-----------------------------------
-- Ventures
-----------------------------------
SET @GOBLIN_GIFTBOX_SMALL  = 5109; -- Frayed Sack (A1)
SET @TINY_TACKLEBOX        = 5110; -- Frayed Sack (A2)
SET @GOBLIN_GIFTBOX_MEDIUM = 5111; -- Frayed Sack (M1)
SET @TITANIC_TACKLEBOX     = 5112; -- Frayed Sack (M2)
SET @GOBLIN_GIFTBOX_LARGE  = 6264; -- Frayed Sack (H1)
SET @GOBLIN_GATHERBOX      = 6345; -- Frayed Sack (H2)

SET @ANGLERS_COMMENDATION = 4033; -- Verdigris Stone
SET @UNION_COMMENDATION   = 4034; -- Verdigris Stone +1
SET @GOBLIN_COMMENDATION  = 4035; -- Verdigris Stone +2
-- We can swap this with a char_inventory query if we decide to use these stones

SET @HAY_BALE            = 6590;
SET @MUSEUM_CASE         = 6591;
SET @SCRAP_LUMBER        = 6592;
SET @BOX_OF_ROCKS        = 6593;

SET @HARVESTERS_SUN_HAT  = 25557;
SET @EXCAVATORS_SHADES   = 25558;
SET @LUMBERJACKS_BERET   = 25559;
SET @MINERS_HELMET       = 25560;

SET @PLAIN_TUNICA        = 26533;
SET @PLAIN_TUNICA_1      = 26534;
SET @PLAIN_GLOVES        = 25984;
SET @PLAIN_GLOVES_1      = 25985;
SET @PLAIN_HOSE          = 25897;
SET @PLAIN_HOSE_1        = 25898;
SET @PLAIN_BOOTS         = 25964;
SET @PLAIN_BOOTS_1       = 25965;

SET @MARINERS_TUNICA     = 26535;
SET @MARINERS_TUNICA_1   = 26536;
SET @MARINERS_GLOVES     = 25986;
SET @MARINERS_GLOVES_1   = 25987;
SET @MARINERS_HOSE       = 25899;
SET @MARINERS_HOSE_1     = 25900;
SET @MARINERS_BOOTS      = 25966;
SET @MARINERS_BOOTS_1    = 25967;


DELETE FROM `item_basic` WHERE itemID IN (
    @GOBLIN_GIFTBOX_SMALL, @GOBLIN_GIFTBOX_MEDIUM, @GOBLIN_GIFTBOX_LARGE,
    @GOBLIN_COMMENDATION, @UNION_COMMENDATION, @ANGLERS_COMMENDATION,
    @TINY_TACKLEBOX, @TITANIC_TACKLEBOX, @GOBLIN_GATHERBOX,

    @HARVESTERS_SUN_HAT, @EXCAVATORS_SHADES, @LUMBERJACKS_BERET, @MINERS_HELMET,
    @PLAIN_TUNICA, @PLAIN_TUNICA_1, @PLAIN_GLOVES, @PLAIN_GLOVES_1,
    @PLAIN_HOSE, @PLAIN_HOSE_1, @PLAIN_BOOTS, @PLAIN_BOOTS_1,

    @MARINERS_TUNICA, @MARINERS_TUNICA_1, @MARINERS_GLOVES, @MARINERS_GLOVES_1,
    @MARINERS_HOSE, @MARINERS_HOSE_1, @MARINERS_BOOTS, @MARINERS_BOOTS_1,

    @HAY_BALE, @MUSEUM_CASE, @SCRAP_LUMBER, @BOX_OF_ROCKS
);

INSERT INTO `item_basic` VALUES (@GOBLIN_GIFTBOX_SMALL,  0, 'goblin_giftbox_(small)',  'gob._giftbox_(sm)',  12, 30300, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@GOBLIN_GIFTBOX_MEDIUM, 0, 'goblin_giftbox_(medium)', 'gob._giftbox_(md)',  12, 30300, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@GOBLIN_GIFTBOX_LARGE,  0, 'goblin_giftbox_(large)',  'gob._giftbox_(lg)',  12, 30300, 0, 1, 0);

INSERT INTO `item_basic` VALUES (@HAY_BALE,              0, 'hay_bale',                'hay_bale',           12, 30300, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@MUSEUM_CASE,           0, 'museum_case',             'museum_case',        12, 30300, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@SCRAP_LUMBER,          0, 'scrap_lumber',            'scrap_lumber',       12, 30300, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@BOX_OF_ROCKS,          0, 'box_of_rocks',            'box_of_rocks',       12, 30300, 0, 1, 0);

INSERT INTO `item_basic` VALUES (@GOBLIN_COMMENDATION,   0, 'goblin_commendation',     'gob._commendation',  99, 30296, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@UNION_COMMENDATION,    0, 'union_commendation',      'uni._commendation',  99, 30296, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@ANGLERS_COMMENDATION,  0, 'anglers_commendation',    'angl._commendation', 99, 30296, 0, 1, 0);

INSERT INTO `item_basic` VALUES (@HARVESTERS_SUN_HAT, 0, 'harvesters_sun_hat', 'harv._sun_hat',      1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@EXCAVATORS_SHADES,  0, 'excavators_shades',  'excavators_shades',  1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@LUMBERJACKS_BERET,  0, 'lumberjacks_beret',  'lumberjacks_beret',  1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@MINERS_HELMET,      0, 'miners_helmet',      'miners_helmet',      1, 63552, 0, 1, 0);

INSERT INTO `item_basic` VALUES (@PLAIN_TUNICA,       0, 'plain_tunica',       'plain_tunica',       1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@PLAIN_TUNICA_1,     0, 'plain_tunica_+1',    'plain_tunica_+1',    1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@PLAIN_GLOVES,       0, 'plain_gloves',       'plain_gloves',       1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@PLAIN_GLOVES_1,     0, 'plain_gloves_+1',    'plain_gloves_+1',    1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@PLAIN_HOSE,         0, 'plain_hose',         'plain_hose',         1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@PLAIN_HOSE_1,       0, 'plain_hose_+1',      'plain_hose_+1',      1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@PLAIN_BOOTS,        0, 'plain_boots',        'plain_boots',        1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@PLAIN_BOOTS_1,      0, 'plain_boots_+1',     'plain_boots_+1',     1, 63552, 0, 1, 0);

INSERT INTO `item_basic` VALUES (@MARINERS_TUNICA,    0, 'mariners_tunica',    'mariners_tunica',    1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@MARINERS_TUNICA_1,  0, 'mariners_tunica_+1', 'mariners_tunica_+1', 1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@MARINERS_GLOVES,    0, 'mariners_gloves',    'mariners_gloves',    1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@MARINERS_GLOVES_1,  0, 'mariners_gloves_+1', 'mariners_gloves_+1', 1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@MARINERS_HOSE,      0, 'mariners_hose',      'mariners_hose',      1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@MARINERS_HOSE_1,    0, 'mariners_hose_+1',   'mariners_hose_+1',   1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@MARINERS_BOOTS,     0, 'mariners_boots',     'mariners_boots',     1, 63552, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@MARINERS_BOOTS_1,   0, 'mariners_boots_+1',  'mariners_boots_+1',  1, 63552, 0, 1, 0);

DELETE FROM `item_equipment` WHERE itemId IN (
    @HARVESTERS_SUN_HAT, @EXCAVATORS_SHADES, @LUMBERJACKS_BERET, @MINERS_HELMET,

    @PLAIN_TUNICA, @PLAIN_TUNICA_1, @PLAIN_GLOVES, @PLAIN_GLOVES_1,
    @PLAIN_HOSE, @PLAIN_HOSE_1, @PLAIN_BOOTS, @PLAIN_BOOTS_1,

    @MARINERS_TUNICA, @MARINERS_TUNICA_1, @MARINERS_GLOVES, @MARINERS_GLOVES_1,
    @MARINERS_HOSE, @MARINERS_HOSE_1, @MARINERS_BOOTS, @MARINERS_BOOTS_1
);

INSERT INTO `item_equipment` VALUES (@HARVESTERS_SUN_HAT, 'harv._sun_hat',       1, 0, 4194303, 366, 0, 0,  16, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@EXCAVATORS_SHADES,  'excavators_shades',   1, 0, 4194303, 121, 0, 0,  16, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@LUMBERJACKS_BERET,  'lumberjacks_beret',   1, 0, 4194303,  24, 0, 0,  16, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@MINERS_HELMET,      'miners_helmet',       1, 0, 4194303, 235, 0, 0,  16, 0, 0, 0);

INSERT INTO `item_equipment` VALUES (@PLAIN_TUNICA,       'plain_tunica',       30, 0, 4194303, 425, 0, 0,  32, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@PLAIN_TUNICA_1,     'plain_tunica_+1',    40, 0, 4194303, 425, 0, 0,  32, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@PLAIN_GLOVES,       'plain_gloves',       30, 0, 4194303, 103, 0, 0,  64, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@PLAIN_GLOVES_1,     'plain_gloves_+1',    40, 0, 4194303, 103, 0, 0,  64, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@PLAIN_HOSE,         'plain_hose',         30, 0, 4194303, 103, 0, 0, 128, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@PLAIN_HOSE_1,       'plain_hose_+1',      40, 0, 4194303, 103, 0, 0, 128, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@PLAIN_BOOTS,        'plain_boots',        30, 0, 4194303, 103, 0, 0, 256, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@PLAIN_BOOTS_1,      'plain_boots_+1',     40, 0, 4194303, 103, 0, 0, 256, 0, 0, 0);

INSERT INTO `item_equipment` VALUES (@MARINERS_TUNICA,    'mariners_tunica',    30, 0, 4194303, 424, 0, 0,  32, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@MARINERS_TUNICA_1,  'mariners_tunica_+1', 40, 0, 4194303, 424, 0, 0,  32, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@MARINERS_GLOVES,    'mariners_gloves',    30, 0, 4194303, 104, 0, 0,  64, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@MARINERS_GLOVES_1,  'mariners_gloves_+1', 40, 0, 4194303, 104, 0, 0,  64, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@MARINERS_HOSE,      'mariners_hose',      30, 0, 4194303, 104, 0, 0, 128, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@MARINERS_HOSE_1,    'mariners_hose_+1',   40, 0, 4194303, 104, 0, 0, 128, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@MARINERS_BOOTS,     'mariners_boots',     30, 0, 4194303, 104, 0, 0, 256, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@MARINERS_BOOTS_1,   'mariners_boots_+1',  40, 0, 4194303, 104, 0, 0, 256, 0, 0, 0);


DELETE FROM `item_usable` WHERE itemId IN (
    @GOBLIN_GIFTBOX_SMALL, @GOBLIN_GIFTBOX_MEDIUM, @GOBLIN_GIFTBOX_LARGE,
    @TINY_TACKLEBOX, @TITANIC_TACKLEBOX, @GOBLIN_GATHERBOX,
    @HAY_BALE, @MUSEUM_CASE, @SCRAP_LUMBER, @BOX_OF_ROCKS
);

INSERT INTO `item_basic` VALUES (@TINY_TACKLEBOX,    0, 'tiny_tacklebox',    'tiny_tacklebox',    12, 30300, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@TITANIC_TACKLEBOX, 0, 'titanic_tacklebox', 'titanic_tacklebox', 12, 30300, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@GOBLIN_GATHERBOX,  0, 'goblin_gatherbox',  'goblin_gatherbox',  12, 30300, 0, 1, 0);

INSERT INTO `item_usable` VALUES (@TINY_TACKLEBOX,        'tiny_tacklebox',          1, 1, 55, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@TITANIC_TACKLEBOX,     'titanic_tacklebox',       1, 1, 55, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@GOBLIN_GATHERBOX,      'goblin_gatherbox',        1, 1, 55, 0, 0, 0, 0, 0);

INSERT INTO `item_usable` VALUES (@GOBLIN_GIFTBOX_SMALL,  'goblin_giftbox_(small)',  1, 1, 55, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@GOBLIN_GIFTBOX_MEDIUM, 'goblin_giftbox_(medium)', 1, 1, 55, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@GOBLIN_GIFTBOX_LARGE,  'goblin_giftbox_(large)',  1, 1, 55, 0, 0, 0, 0, 0);

INSERT INTO `item_usable` VALUES (@HAY_BALE,              'hay_bale',                1, 1, 55, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@MUSEUM_CASE,           'museum_case',             1, 1, 55, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@SCRAP_LUMBER,          'scrap_lumber',            1, 1, 55, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@BOX_OF_ROCKS,          'box_of_rocks',            1, 1, 55, 0, 0, 0, 0, 0);

SET @PET_ALL            = 0;

SET @MOD_DEF            = 1;
SET @MOD_HP             = 2;
SET @MOD_EARTH_RES      = 18;
SET @MOD_THUNDER_RES    = 19;
SET @MOD_WATER_RES      = 20;
SET @MOD_ATT            = 23;
SET @MOD_ACC            = 25;
SET @MOD_EVA            = 31;
SET @MOD_PHYS_DMG_TAKEN = 161;
SET @MOD_HASTE          = 384;
SET @MOD_MARCH_EFFECT   = 443;

SET @MOD_FISHING        = 127;
SET @MOD_HARVESTING     = 513;
SET @MOD_LOGGING        = 514;
SET @MOD_MINING         = 515;
SET @MOD_SURVEYOR       = 2000;
SET @MOD_FATIGUE        = 2004;
SET @MOD_GOLD_ARROW     = 2005;

SET @BATTLE_HORN          = 21402;
SET @BATTLE_HORN_1        = 21403;
SET @WILDERNESS_EARRING   = 28490;
SET @WILDERNESS_EARRING_1 = 28491;
SET @THORINS_SHIELD       = 27633;
SET @THORINS_SHIELD_1     = 27634;

DELETE FROM `item_mods` WHERE itemId IN (
    @BATTLE_HORN, @BATTLE_HORN_1,
    @WILDERNESS_EARRING, @WILDERNESS_EARRING_1,
    @THORINS_SHIELD, @THORINS_SHIELD_1,

    @HARVESTERS_SUN_HAT, @EXCAVATORS_SHADES, @LUMBERJACKS_BERET, @MINERS_HELMET,
    @PLAIN_TUNICA, @PLAIN_TUNICA_1, @PLAIN_GLOVES, @PLAIN_GLOVES_1,
    @PLAIN_HOSE, @PLAIN_HOSE_1, @PLAIN_BOOTS, @PLAIN_BOOTS_1
);

INSERT INTO `item_mods` VALUES
    (@BATTLE_HORN,          @MOD_HP,             5),
    (@BATTLE_HORN,          @MOD_ACC,            1),
    (@BATTLE_HORN,          @MOD_HASTE,        100),
    (@BATTLE_HORN,          @MOD_MARCH_EFFECT,   1),

    (@BATTLE_HORN_1,        @MOD_HP,             8),
    (@BATTLE_HORN_1,        @MOD_ACC,            2),
    (@BATTLE_HORN_1,        @MOD_HASTE,        100),
    (@BATTLE_HORN_1,        @MOD_MARCH_EFFECT,   2),

    (@WILDERNESS_EARRING,   @MOD_EARTH_RES,    1),
    (@WILDERNESS_EARRING,   @MOD_ACC,          1),

    (@WILDERNESS_EARRING_1, @MOD_EARTH_RES,    2),
    (@WILDERNESS_EARRING_1, @MOD_ACC,          2),

    (@THORINS_SHIELD,       @MOD_DEF,            10),
    (@THORINS_SHIELD,       @MOD_THUNDER_RES,    10),
    (@THORINS_SHIELD,       @MOD_HP,             30),
    (@THORINS_SHIELD,       @MOD_ATT,            15),
    (@THORINS_SHIELD,       499,                  5), -- ITEM_SUBEFFECT: 5 (Shock Spikes)
    (@THORINS_SHIELD,       500,                 15), -- ITEM_ADDEFFECT_DMG: 15
    (@THORINS_SHIELD,       501,                 25), -- ITEM_ADDEFFECT_CHANCE: 25

    (@THORINS_SHIELD_1,     @MOD_DEF,            12),
    (@THORINS_SHIELD_1,     @MOD_THUNDER_RES,    15),
    (@THORINS_SHIELD_1,     @MOD_HP,             35),
    (@THORINS_SHIELD_1,     @MOD_ATT,            18),
    (@THORINS_SHIELD_1,     499,                  5), -- ITEM_SUBEFFECT: 5 (Shock Spikes)
    (@THORINS_SHIELD_1,     500,                 18), -- ITEM_ADDEFFECT_DMG: 18
    (@THORINS_SHIELD_1,     501,                 25), -- ITEM_ADDEFFECT_CHANCE: 25

    (@HARVESTERS_SUN_HAT,   @MOD_DEF,          1),
    (@HARVESTERS_SUN_HAT,   @MOD_SURVEYOR,     1),

    (@EXCAVATORS_SHADES,    @MOD_DEF,          1),
    (@EXCAVATORS_SHADES,    @MOD_SURVEYOR,     1),

    (@LUMBERJACKS_BERET,    @MOD_DEF,          1),
    (@LUMBERJACKS_BERET,    @MOD_SURVEYOR,     1),

    (@MINERS_HELMET,        @MOD_DEF,          1),
    (@MINERS_HELMET,        @MOD_SURVEYOR,     1),

    (@PLAIN_TUNICA,         @MOD_DEF,         18),
    (@PLAIN_TUNICA,         @MOD_EARTH_RES,    4),
    (@PLAIN_TUNICA,         @MOD_HARVESTING,  73),
    (@PLAIN_TUNICA,         @MOD_LOGGING,     73),
    (@PLAIN_TUNICA,         @MOD_MINING,      73),
    (@PLAIN_TUNICA,         @MOD_SURVEYOR,     2),

    (@PLAIN_TUNICA_1,       @MOD_DEF,         25),
    (@PLAIN_TUNICA_1,       @MOD_EARTH_RES,    5),
    (@PLAIN_TUNICA_1,       @MOD_HARVESTING,  73),
    (@PLAIN_TUNICA_1,       @MOD_LOGGING,     73),
    (@PLAIN_TUNICA_1,       @MOD_MINING,      73),
    (@PLAIN_TUNICA_1,       @MOD_SURVEYOR,     4),

    (@PLAIN_GLOVES,         @MOD_DEF,          7),
    (@PLAIN_GLOVES,         @MOD_EARTH_RES,    2),
    (@PLAIN_GLOVES,         @MOD_HARVESTING,  73),
    (@PLAIN_GLOVES,         @MOD_LOGGING,     73),
    (@PLAIN_GLOVES,         @MOD_MINING,      73),
    (@PLAIN_GLOVES,         @MOD_SURVEYOR,     2),

    (@PLAIN_GLOVES_1,       @MOD_DEF,          9),
    (@PLAIN_GLOVES_1,       @MOD_EARTH_RES,    3),
    (@PLAIN_GLOVES_1,       @MOD_HARVESTING,  73),
    (@PLAIN_GLOVES_1,       @MOD_LOGGING,     73),
    (@PLAIN_GLOVES_1,       @MOD_MINING,      73),
    (@PLAIN_GLOVES_1,       @MOD_SURVEYOR,     4),

    (@PLAIN_HOSE,           @MOD_DEF,         12),
    (@PLAIN_HOSE,           @MOD_EARTH_RES,    3),
    (@PLAIN_HOSE,           @MOD_HARVESTING,  73),
    (@PLAIN_HOSE,           @MOD_LOGGING,     73),
    (@PLAIN_HOSE,           @MOD_MINING,      73),
    (@PLAIN_HOSE,           @MOD_SURVEYOR,     2),

    (@PLAIN_HOSE_1,         @MOD_DEF,         18),
    (@PLAIN_HOSE_1,         @MOD_EARTH_RES,    4),
    (@PLAIN_HOSE_1,         @MOD_HARVESTING,  73),
    (@PLAIN_HOSE_1,         @MOD_LOGGING,     73),
    (@PLAIN_HOSE_1,         @MOD_MINING,      73),
    (@PLAIN_HOSE_1,         @MOD_SURVEYOR,     4),

    (@PLAIN_BOOTS,          @MOD_DEF,          5),
    (@PLAIN_BOOTS,          @MOD_EARTH_RES,    2),
    (@PLAIN_BOOTS,          @MOD_HARVESTING,  73),
    (@PLAIN_BOOTS,          @MOD_LOGGING,     73),
    (@PLAIN_BOOTS,          @MOD_MINING,      73),
    (@PLAIN_BOOTS,          @MOD_SURVEYOR,     2),

    (@PLAIN_BOOTS_1,        @MOD_DEF,          8),
    (@PLAIN_BOOTS_1,        @MOD_EARTH_RES,    3),
    (@PLAIN_BOOTS_1,        @MOD_HARVESTING,  73),
    (@PLAIN_BOOTS_1,        @MOD_LOGGING,     73),
    (@PLAIN_BOOTS_1,        @MOD_MINING,      73),
    (@PLAIN_BOOTS_1,        @MOD_SURVEYOR,     4),

    (@MARINERS_TUNICA,      @MOD_DEF,         18),
    (@MARINERS_TUNICA,      @MOD_WATER_RES,    4),
    (@MARINERS_TUNICA,      @MOD_FISHING,      1),
    (@MARINERS_TUNICA,      @MOD_FATIGUE,     10),
    (@MARINERS_TUNICA,      @MOD_GOLD_ARROW,   1),

    (@MARINERS_TUNICA_1,    @MOD_DEF,         25),
    (@MARINERS_TUNICA_1,    @MOD_WATER_RES,    5),
    (@MARINERS_TUNICA_1,    @MOD_FISHING,      2),
    (@MARINERS_TUNICA_1,    @MOD_FATIGUE,     20),
    (@MARINERS_TUNICA_1,    @MOD_GOLD_ARROW,   2),

    (@MARINERS_GLOVES,      @MOD_DEF,          7),
    (@MARINERS_GLOVES,      @MOD_WATER_RES,    2),
    (@MARINERS_GLOVES,      @MOD_FISHING,      1),

    (@MARINERS_GLOVES_1,    @MOD_DEF,          9),
    (@MARINERS_GLOVES_1,    @MOD_WATER_RES,    3),
    (@MARINERS_GLOVES_1,    @MOD_FISHING,      2),

    (@MARINERS_HOSE,        @MOD_DEF,         12),
    (@MARINERS_HOSE,        @MOD_WATER_RES,    3),
    (@MARINERS_HOSE,        @MOD_FISHING,      1),

    (@MARINERS_HOSE_1,      @MOD_DEF,         18),
    (@MARINERS_HOSE_1,      @MOD_WATER_RES,    4),
    (@MARINERS_HOSE_1,      @MOD_FISHING,      2),

    (@MARINERS_BOOTS,       @MOD_DEF,          5),
    (@MARINERS_BOOTS,       @MOD_WATER_RES,    2),
    (@MARINERS_BOOTS,       @MOD_FISHING,      1),
    (@MARINERS_BOOTS,       @MOD_FATIGUE,     10),
    (@MARINERS_BOOTS,       @MOD_GOLD_ARROW,   1),

    (@MARINERS_BOOTS_1,     @MOD_DEF,          8),
    (@MARINERS_BOOTS_1,     @MOD_WATER_RES,    3),
    (@MARINERS_BOOTS_1,     @MOD_FISHING,      1),
    (@MARINERS_BOOTS_1,     @MOD_FATIGUE,     20),
    (@MARINERS_BOOTS_1,     @MOD_GOLD_ARROW,   2),

    (17011,                 @MOD_FATIGUE,     10), -- Ebisu Fishing Rod
    (19321,                 @MOD_FATIGUE,     15); -- Ebisu Fishing Rod +1

DELETE FROM `item_mods_pet` WHERE itemId IN (
    @WILDERNESS_EARRING, @WILDERNESS_EARRING_1
);

INSERT INTO `item_mods_pet` VALUES
    (@WILDERNESS_EARRING,   @MOD_ACC, 1, @PET_ALL),
    (@WILDERNESS_EARRING_1, @MOD_ACC, 2, @PET_ALL);

UPDATE `item_equipment` SET level = 25, ilevel = 0, su_level = 0 WHERE itemId IN (
    @BATTLE_HORN, @BATTLE_HORN_1
);

UPDATE `item_equipment` SET level = 45, ilevel = 0, su_level = 0 WHERE itemId IN (
    @WILDERNESS_EARRING, @WILDERNESS_EARRING_1
);

UPDATE `item_equipment` SET level = 65, ilevel = 0, su_level = 0 WHERE itemId IN (
    @THORINS_SHIELD, @THORINS_SHIELD_1
);

UPDATE `item_basic`     SET name = 'battle_horn',    sortname = 'battle_horn'    WHERE itemId = @BATTLE_HORN;
UPDATE `item_basic`     SET name = 'battle_horn_+1', sortname = 'battle_horn_+1' WHERE itemId = @BATTLE_HORN_1;
UPDATE `item_equipment` SET name = 'battle_horn'    WHERE itemId = @BATTLE_HORN;
UPDATE `item_equipment` SET name = 'battle_horn_+1' WHERE itemId = @BATTLE_HORN_1;
UPDATE `item_weapon`    SET name = 'battle_horn'    WHERE itemId = @BATTLE_HORN;
UPDATE `item_weapon`    SET name = 'battle_horn_+1' WHERE itemId = @BATTLE_HORN_1;

UPDATE `item_basic`     SET name = 'wilderness_earring',    sortname = 'wilderness_earring' WHERE itemId = @WILDERNESS_EARRING;
UPDATE `item_basic`     SET name = 'wilderness_earring_+1', sortname = 'wilder._earring_+1' WHERE itemId = @WILDERNESS_EARRING_1;
UPDATE `item_equipment` SET name = 'wilderness_earring'    WHERE itemId = @WILDERNESS_EARRING;
UPDATE `item_equipment` SET name = 'wilderness_earring_+1' WHERE itemId = @WILDERNESS_EARRING_1;

UPDATE `item_basic`     SET name = 'thorins_shield',    sortname = 'thorins_shield'    WHERE itemId = @THORINS_SHIELD;
UPDATE `item_basic`     SET name = 'thorins_shield_+1', sortname = 'thorins_shield_+1' WHERE itemId = @THORINS_SHIELD_1;
UPDATE `item_equipment` SET name = 'thorins_shield' WHERE itemId = @THORINS_SHIELD;
UPDATE `item_equipment` SET name = 'thorins_shield_+1' WHERE itemId = @THORINS_SHIELD_1;