-- -----------------------------------------
-- Pirates SQL
-- -----------------------------------------

--
-- Add zone column to transport.sql
--
ALTER TABLE transport ADD COLUMN IF NOT EXISTS anim_path tinyint(3) unsigned NOT NULL DEFAULT '0';

-- Add updated transport rows
UPDATE `transport` SET anim_path = 5   WHERE `name` = 'Kazham-Jeuno_Airship';
UPDATE `transport` SET anim_path = 6   WHERE `name` = 'Jeuno-Kazham_Airship';
UPDATE `transport` SET anim_path = 6   WHERE `name` = 'Jeuno-Sandoria_Airship';
UPDATE `transport` SET anim_path = 6   WHERE `name` = 'Jeuno-Windurst_Airship';
UPDATE `transport` SET anim_path = 6   WHERE `name` = 'Jeuno-Bastok_Airship';
UPDATE `transport` SET anim_path = 2   WHERE `name` = 'Sandoria-Jeuno_Airship';
UPDATE `transport` SET anim_path = 1   WHERE `name` = 'Windurst-Jeuno_Airship';
UPDATE `transport` SET anim_path = 0   WHERE `name` = 'Bastok-Jeuno_Airship';
UPDATE `transport` SET anim_path = 4   WHERE `name` = 'Selbina-Mhaura_Boat';
UPDATE `transport` SET anim_path = 3   WHERE `name` = 'Mhaura-Selbina_Boat';
UPDATE `transport` SET anim_path = 3   WHERE `name` = 'Mhaura-Whitegate_Boat';
UPDATE `transport` SET anim_path = 20  WHERE `name` = 'Whitegate-Mhaura_Boat';
UPDATE `transport` SET anim_path = 20  WHERE `name` = 'Whitegate-Nashmau_Boat';
UPDATE `transport` SET anim_path = 20  WHERE `name` = 'Nashmau-Whitegate_Boat';
UPDATE `transport` SET anim_path = 17  WHERE `name` = 'Manaclip_Bibiki-Tours';
UPDATE `transport` SET anim_path = 17  WHERE `name` = 'Manaclip_Bibiki-Purgonorgo';
UPDATE `transport` SET anim_path = 17  WHERE `name` = 'Manaclip_Purgonorgo-Bibiki';
UPDATE `transport` SET anim_path = 4   WHERE `name` = 'Selbina-Mhaura_Boat_Pirates';
UPDATE `transport` SET anim_path = 3   WHERE `name` = 'Mhaura-Selbina_Boat_Pirates';

--
-- Mob spawn points
--

REPLACE INTO `mob_spawn_points` VALUES (17678342,'Sea_Crab','Sea Crab',6,4.560, -7.160, 17.430, 227);
REPLACE INTO `mob_spawn_points` VALUES (17678343,'Sea_Crab','Sea Crab',6,1.698, -7.268, 21.497, 139);
REPLACE INTO `mob_spawn_points` VALUES (17678344,'Sea_Pugil','Sea Pugil',7,1.698, -7.268, 21.497, 139);
REPLACE INTO `mob_spawn_points` VALUES (17678345,'Sea_Pugil','Sea Pugil',7,-7.699, -7.663, 7.549,0);
REPLACE INTO `mob_spawn_points` VALUES (17678346,'Sea_Monk','Sea Monk',8,4.560, -7.160, 17.430,0);
REPLACE INTO `mob_spawn_points` VALUES (17678347,'Phantom','Phantom',9,0.0, -7.163, 15.823,0);
REPLACE INTO `mob_spawn_points` VALUES (17678348,'Thunder_Elemental','Thunder Elemental',10,-4.560, -7.663, 3.749,0);
REPLACE INTO `mob_spawn_points` VALUES (17678349,'Water_Elemental','Water Elemental',11,4.629, -7.663, 13.749,0);
REPLACE INTO `mob_spawn_points` VALUES (17678350,'Sea_Horror','Sea Horror',12,3.560, -7.160, 11.430,100);
REPLACE INTO `mob_spawn_points` VALUES (17682438,'Sea_Crab','Sea Crab',6,1.698,-7.268,21.497,139);
REPLACE INTO `mob_spawn_points` VALUES (17682439,'Sea_Crab','Sea Crab',6,1.698,-7.268,21.497,139);
REPLACE INTO `mob_spawn_points` VALUES (17707015,'Sea_Crab','Sea Crab',6,1.698,-7.268,21.497,139);
REPLACE INTO `mob_spawn_points` VALUES (17707017,'Sea_Pugil','Sea Pugil',7,-7.699,-7.663,7.549,0);
REPLACE INTO `mob_spawn_points` VALUES (17707018,'Sea_Monk','Sea Monk',8,4.560,-7.160,17.430,227);
REPLACE INTO `mob_spawn_points` VALUES (17707026,'Enagakure','Enagakure',14,-6.387,-11.662,-13.986,0);
REPLACE INTO `mob_spawn_points` VALUES (17711110,'Sea_Crab','Sea Crab',6,1.698,-7.268,21.497,139);
REPLACE INTO `mob_spawn_points` VALUES (17711111,'Sea_Crab','Sea Crab',6,1.698,-7.268,21.497,139);
REPLACE INTO `mob_spawn_points` VALUES (17711112,'Sea_Pugil','Sea Pugil',7,-7.699,-7.663,7.549,0);
REPLACE INTO `mob_spawn_points` VALUES (17711113,'Sea_Pugil','Sea Pugil',7,-7.699,-7.663,7.549,0);
REPLACE INTO `mob_spawn_points` VALUES (17711114,'Sea_Monk','Sea Monk',8,4.560, -7.160, 17.430, 227);
REPLACE INTO `mob_spawn_points` VALUES (17711121,'Silverhook','Silverhook',13,-6.320,-7.160,12.470,0);

--
-- Mob Groups
--

UPDATE `mob_groups` SET respawntime = 300 WHERE
zoneid in (227,228) AND
`name` in ('Crossbones_blm','Crossbones_war','Ship_Wight');

UPDATE `mob_groups` SET HP = 9000, MP = 4500, minLevel = 67, maxLevel = 70 WHERE
zoneid in (227,228) AND
`name` in ('Blackbeard','Silverhook');

UPDATE `mob_groups` SET respawntime = 0, spawntype = 128 where zoneid in (220,221,227,228); -- all main mob spawning is managed by onZoneTick
UPDATE `mob_groups` SET respawntime = 300, spawntype = 4 where zoneid in (220,221,227,228) and name like "%_elemental";


--
-- NPC List
--
-- TODO Find out if this is needed? Seems to only change speed and speedsub
-- REPLACE INTO `npc_list` VALUES (16785757,'_02u','sdoor_u',0,-301.181,0.000,507.121,1,50,50,9,0,0,0,6147,0x0200000000000000000000000000000000000000,0,'COP',0);
-- REPLACE INTO `npc_list` VALUES (16982046,0x14,'',0,-20.726,3.389,-154.231,98311,50,50,18,0,0,2,2051,0x0400000000000000000000000000000000000000,32,NULL,1);

-- Ship Bound for Selbina (Pirates) (Zone 227)
-- Find npcid base for pirates
SET @PIRATE_BASE = (select npcid from npc_list where (npcid >> 12) & 0xFFF = 227 AND name = 'Map' order by npcid asc limit 1);
INSERT INTO `npc_list` VALUES (@PIRATE_BASE + 1,'pirate1','',58,33.601,-7.163,13.377,719,50,50,0,0,8,2,2075,0x01000a0100100320033003400350126000700000,32,NULL,1);
INSERT INTO `npc_list` VALUES (@PIRATE_BASE + 2,'pirate2','',194,29.728,-7.163,1.303,587,50,50,0,0,8,2,2075,0x0100080100100320033003400350126000700000,32,NULL,1);
INSERT INTO `npc_list` VALUES (@PIRATE_BASE + 3,'pirate3','',56,29.602,-7.163,-2.475,693,50,50,0,0,8,2,2075,0x01000f0100100320033003400350126000700000,32,NULL,1);

-- Ship Bound for Mhaura (Pirates) (Zone 228)
-- Find npcid base for pirates
SET @PIRATE_BASE = (select npcid from npc_list where (npcid >> 12) & 0xFFF = 228 AND name = 'Map' order by npcid asc limit 1);
UPDATE npc_list set name = 'pirate1' where npcid = @PIRATE_BASE + 1;
UPDATE npc_list set name = 'pirate2' where npcid = @PIRATE_BASE + 2;
UPDATE npc_list set name = 'pirate3' where npcid = @PIRATE_BASE + 3;
