-- Bait
SET @SLICED_BLUETAIL  = 16992;
SET @PEELED_CRAYFISH  = 16993;
SET @SLICED_MOAT_CARP = 16994;
SET @ROTTEN_MEAT      = 16995;
SET @SARDINE_BALL     = 16996;
SET @CRAYFISH_BALL    = 16997;
SET @INSECT_BALL      = 16998;
SET @TROUT_BALL       = 16999;
SET @MEATBALL         = 17000;
SET @GIANT_SHELL_BUG  = 17001;
SET @ROBBER_RIG       = 17002;
SET @SLICED_SARDINE   = 17392;
SET @SLICED_COD       = 17393;
SET @PEELED_LOBSTER   = 17394;
SET @LUGWORM          = 17395;
SET @LITTLE_WORM      = 17396;
SET @SHELL_BUG        = 17397;
SET @ROGUE_RIG        = 17398;
SET @SABIKI_RIG       = 17399;
SET @SINKING_MINNOW   = 17400;
SET @LIZARD_LURE      = 17401;
SET @SHRIMP_LURE      = 17402;
SET @FROG_LURE        = 17403;
SET @WORM_LURE        = 17404;
SET @FLY_LURE         = 17405;
SET @DWARF_PUGIL      = 17007;
SET @DRILL_CALAMARY   = 17006;
SET @MINNOW           = 17407;

-- Tiger Shark
SET @TIGER_SHARK = 5817;
INSERT INTO `fishing_bait_affinity` VALUES (@SLICED_MOAT_CARP, @TIGER_SHARK, 3);
INSERT INTO `fishing_bait_affinity` VALUES (@PEELED_LOBSTER,   @TIGER_SHARK, 2);
INSERT INTO `fishing_bait_affinity` VALUES (@MINNOW,           @TIGER_SHARK, 2);
INSERT INTO `fishing_bait_affinity` VALUES (@SINKING_MINNOW,   @TIGER_SHARK, 2);

INSERT INTO `fishing_group` VALUES (136,@TIGER_SHARK,700,50,6); -- Ferry - Mhaura/Selbina

DELETE FROM `fishing_fish` WHERE fishid = @TIGER_SHARK;
INSERT INTO `fishing_fish` VALUES (@TIGER_SHARK,'Tiger Shark',99,43,3,15,105,161,28,1,0,255,255,0,0,3,1,4,0,0,0,1,350,1979,'',0,0,0,0); -- Requires: Anglers' Almanac

-- Morinabaligi
UPDATE fishing_fish SET size_type = 1, min_length = 60, max_length = 180 WHERE `name` = 'Morinabaligi';

-- Quicksilver Blade
SET @QUICKSILVER_BLADE = 6371;
INSERT INTO `fishing_group` VALUES (138, @QUICKSILVER_BLADE, 350, 50, 6); -- Silver_Sea_route_to_Nashmau/Silver_Sea_route_to_Al_Zahbi

DELETE FROM `fishing_fish` WHERE fishid = @QUICKSILVER_BLADE;
INSERT INTO `fishing_fish` VALUES (@QUICKSILVER_BLADE,'Quicksilver Blade',130,36,7,4,115,235,32,1,0,255,255,0,0,3,1,0,1,0,0,1,350,0,'',0,0,1,0);

DELETE FROM `fishing_bait_affinity` WHERE fishid = @QUICKSILVER_BLADE;
INSERT INTO `fishing_bait_affinity` VALUES
    (@SLICED_BLUETAIL,  @QUICKSILVER_BLADE, 2),
    (@SARDINE_BALL,     @QUICKSILVER_BLADE, 3),
    (@PEELED_LOBSTER,   @QUICKSILVER_BLADE, 2),
    (@SINKING_MINNOW,   @QUICKSILVER_BLADE, 2),
    (@SHRIMP_LURE,      @QUICKSILVER_BLADE, 2);

-- ---------------------------------
-- WotG fishing results
-- ---------------------------------
-- SELECT wings_fishing_lure.lureid, wings_fishing_lure.fishid, wings_fishing_lure.luck, basic_lure.name, basic_fish.name, wings_fishing_zone.name FROM wings_fishing_lure
-- INNER JOIN `wings_fishing_zone` ON wings_fishing_lure.fishid = wings_fishing_zone.fishid
-- INNER JOIN item_basic AS basic_fish ON basic_fish.itemid = wings_fishing_lure.fishid
-- INNER JOIN item_basic AS basic_lure ON basic_lure.itemid = wings_fishing_lure.lureid
-- WHERE wings_fishing_zone.name IN (
--   'East Ronfaure [S]',
--   'Beaucedine Glacier [S]',
--   'Jugner Forest [S]',
--   'Vunkerl Inlet [S]',
--   'Batallia Downs [S]',
--   'Bastok Markets [S]',
--   'North Gustaberg [S]',
--   'Grauberg [S]',
--   'Pashhow Marshlands [S]',
--   'Rolanberry Fields [S]',
--   'Windurst Waters [S]',
--   'West Sarutabaruta [S]',
--   'Oztroja Castle [S]'
-- ) ORDER BY wings_fishing_zone.name;

-- (\d+);(\d+);(\d+);([a-z\_]+);([a-z\_]+);([A-Za-z\[\] ]+)
-- INSERT INTO `fishing_bait_affinity` VALUES ($1, $2, $3); -- $4 ($5) $6

SET @TRUMPET_SHELL = 5466;
UPDATE fishing_fish SET disabled = 0, ranking = 32 WHERE fishid = @TRUMPET_SHELL;
DELETE FROM `fishing_bait_affinity` WHERE fishid = @TRUMPET_SHELL;
INSERT INTO `fishing_bait_affinity` VALUES
    (@ROBBER_RIG,       @TRUMPET_SHELL, 3),
    (@CRAYFISH_BALL,    @TRUMPET_SHELL, 2),
    (@ROGUE_RIG,        @TRUMPET_SHELL, 2),
    (@SINKING_MINNOW,   @TRUMPET_SHELL, 1);

SET @GARPIKE = 5472;
UPDATE fishing_fish SET disabled = 0, ranking = 32 WHERE fishid = @GARPIKE;
DELETE FROM `fishing_bait_affinity` WHERE fishid = @GARPIKE;
INSERT INTO `fishing_bait_affinity` VALUES
    (@SINKING_MINNOW,   @GARPIKE, 3),
    (@FROG_LURE,        @GARPIKE, 2),
    (@LIZARD_LURE,      @GARPIKE, 2),
    (@MEATBALL,         @GARPIKE, 2),
    (@MINNOW,           @GARPIKE, 2),
    (@ROBBER_RIG,       @GARPIKE, 2);

SET @MATSYA = 5468;
UPDATE fishing_fish SET disabled = 0, ranking = 38 WHERE fishid = @MATSYA;
DELETE FROM `fishing_bait_affinity` WHERE fishid = @MATSYA;
INSERT INTO `fishing_bait_affinity` VALUES
    (@DWARF_PUGIL,      @MATSYA, 2),
    (@DRILL_CALAMARY,   @MATSYA, 2);

SET @BRASS_LOACH = 5469;
UPDATE fishing_fish SET disabled = 0, ranking = 30 WHERE fishid = @BRASS_LOACH;
DELETE FROM `fishing_bait_affinity` WHERE fishid = @BRASS_LOACH;
INSERT INTO `fishing_bait_affinity` VALUES
    (@LITTLE_WORM,      @BRASS_LOACH, 3),
    (@WORM_LURE,        @BRASS_LOACH, 3);

SET @CA_CUONG = 5474;
UPDATE fishing_fish SET disabled = 0, ranking = 32 WHERE fishid = @CA_CUONG;
DELETE FROM `fishing_bait_affinity` WHERE fishid = @CA_CUONG;
INSERT INTO `fishing_bait_affinity` VALUES
    (@LITTLE_WORM,      @CA_CUONG, 3),
    (@SLICED_MOAT_CARP, @CA_CUONG, 3),
    (@INSECT_BALL,      @CA_CUONG, 2),
    (@MEATBALL,         @CA_CUONG, 2);

SET @PIRARUCU = 5470;
UPDATE fishing_fish SET disabled = 0, ranking = 32 WHERE fishid = @PIRARUCU;
DELETE FROM `fishing_bait_affinity` WHERE fishid = @PIRARUCU;
INSERT INTO `fishing_bait_affinity` VALUES
    (@MEATBALL,         @PIRARUCU, 3),
    (@SLICED_MOAT_CARP, @PIRARUCU, 3),
    (@MINNOW,           @PIRARUCU, 2);

SET @BASTORE_SWEEPER = 5473;
UPDATE fishing_fish SET disabled = 0, ranking = 30 WHERE fishid = @BASTORE_SWEEPER;
DELETE FROM `fishing_bait_affinity` WHERE fishid = @BASTORE_SWEEPER;
INSERT INTO `fishing_bait_affinity` VALUES
    (@SLICED_BLUETAIL,  @BASTORE_SWEEPER, 3),
    (@SLICED_COD,       @BASTORE_SWEEPER, 3),
    (@CRAYFISH_BALL,    @BASTORE_SWEEPER, 2),
    (@LUGWORM,          @BASTORE_SWEEPER, 2),
    (@MEATBALL,         @BASTORE_SWEEPER, 2),
    (@ROBBER_RIG,       @BASTORE_SWEEPER, 2),
    (@SINKING_MINNOW,   @BASTORE_SWEEPER, 2);

SET @GIGANT_OCTOPUS = 5475;
UPDATE fishing_fish SET disabled = 0, ranking = 30 WHERE fishid = @GIGANT_OCTOPUS;
DELETE FROM `fishing_bait_affinity` WHERE fishid = @GIGANT_OCTOPUS;
INSERT INTO `fishing_bait_affinity` VALUES
    (@SHRIMP_LURE,      @GIGANT_OCTOPUS, 3),
    (@CRAYFISH_BALL,    @GIGANT_OCTOPUS, 2),
    (@PEELED_CRAYFISH,  @GIGANT_OCTOPUS, 2),
    (@SINKING_MINNOW,   @GIGANT_OCTOPUS, 2),
    (@ROGUE_RIG,        @GIGANT_OCTOPUS, 2),
    (@ROBBER_RIG,       @GIGANT_OCTOPUS, 2);

SET @ABAIA = 5476;
UPDATE fishing_fish SET disabled = 0, ranking = 34 WHERE fishid = @ABAIA;
DELETE FROM `fishing_bait_affinity` WHERE fishid = @ABAIA;
INSERT INTO `fishing_bait_affinity` VALUES
    (@MINNOW,           @ABAIA, 3),
    (@TROUT_BALL,       @ABAIA, 2);


SET @MEGALODON = 5467;
UPDATE fishing_fish SET disabled = 0, ranking = 34 WHERE fishid = @MEGALODON;
DELETE FROM `fishing_bait_affinity` WHERE fishid = @MEGALODON;
INSERT INTO `fishing_bait_affinity` VALUES
    (@MEATBALL,         @MEGALODON, 3),
    (@SLICED_COD,       @MEGALODON, 2),
    (@MINNOW,           @MEGALODON, 2),
    (@ROGUE_RIG,        @MEGALODON, 2),
    (@ROBBER_RIG,       @MEGALODON, 2);


-- KEY -- (groupid, fishid, rarity, pool_size, restock_rate)
-- NOTE -- Groups are 200+ as LSB goes to ~130, and this should avoid any future conflict.

-- ---------------------------------
-- Bastok Markets [S]
-- ---------------------------------
INSERT INTO `fishing_area` VALUES (87,1,'North Side',2,20,0,0xE32E85C3000000008262F4C11CEB1CC1000000007446D4C1098AF1C000000000D22FEDC2DDA404C300000000D676EFC2219039C3000000001EB6BCC221D058C3000000007328C1C254A363C300000000FFB2E9C2DC5778C3000000001846EFC2DC8F86C3000000008FD3DBC2,0.000,-6.000,0.000);
INSERT INTO `fishing_area` VALUES (87,2,'South Side',0,0,0,'',0.000,-6.000,0.000);

-- Pools
INSERT INTO `fishing_catch` VALUES (87,1,200); -- Group 200 North Side fishing (pools between bridges near the GS guild, etc)
INSERT INTO `fishing_catch` VALUES (87,2,201); -- Group 201 South Side fishing (sea inflow)

-- North Side
INSERT INTO `fishing_group` VALUES (200, 13454,  500, 300,  9); -- copper_ring
INSERT INTO `fishing_group` VALUES (200,    90,  500, 300,  9); -- rusty_bucket
INSERT INTO `fishing_group` VALUES (200, 14117,  500, 300,  9); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (200, 14242,  500, 300,  9); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (200,  4429,  800, 290,  7); -- black_eel
INSERT INTO `fishing_group` VALUES (200,  4472, 1000, 500, 15); -- crayfish
INSERT INTO `fishing_group` VALUES (200,  4401, 1000, 500, 15); -- moat_carp
INSERT INTO `fishing_group` VALUES (200,  4427,  750, 275,  6); -- gold_carp
INSERT INTO `fishing_group` VALUES (200,  4426, 1000, 500, 15); -- tricolored_carp
-- INSERT INTO `fishing_group` VALUES (200,  4515,  500, 500, 15); -- copper_frog -- lack of evidence this comes in the markets, but it does come from Gustaburg (S)

-- South Side (merged with north)
INSERT INTO `fishing_group` VALUES (201, 13454,  500, 300,  9); -- copper_ring
INSERT INTO `fishing_group` VALUES (201,    90,  500, 300,  9); -- rusty_bucket
INSERT INTO `fishing_group` VALUES (201, 14117,  500, 300,  9); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (201, 14242,  500, 300,  9); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (201,  4429,  800, 290,  7); -- black_eel
INSERT INTO `fishing_group` VALUES (201,  4428, 1000, 500, 15); -- dark_bass
INSERT INTO `fishing_group` VALUES (201,  4469,  900, 190,  6); -- giant_catfish
INSERT INTO `fishing_group` VALUES (201,  4401, 1000, 500, 15); -- moat_carp

-- ---------------------------------
-- Batallia Downs [S]
-- ---------------------------------
INSERT INTO `fishing_area` VALUES (84,1,'Whole Zone',0,0,0,NULL,0.000,0.000,0.000);

INSERT INTO `fishing_catch` VALUES (84,1,202); -- All Seasides

INSERT INTO `fishing_group` VALUES (202, 16537,  750, 500, 15); -- mythril_sword
INSERT INTO `fishing_group` VALUES (202, 16655,  750, 500, 15); -- rusty_pick
INSERT INTO `fishing_group` VALUES (202, 16606,  750, 500, 15); -- rusty_greatsword
INSERT INTO `fishing_group` VALUES (202, 13456,  750, 500, 15); -- silver_ring
INSERT INTO `fishing_group` VALUES (202,  4360, 1000, 500, 15); -- bastore_sardine
INSERT INTO `fishing_group` VALUES (202,  5473,  750, 500, 15); -- bastore_sweeper
INSERT INTO `fishing_group` VALUES (202,  4384,  750, 215,  6); -- black_sole
INSERT INTO `fishing_group` VALUES (202,  4399,  650, 275,  6); -- bluetail
INSERT INTO `fishing_group` VALUES (202,  4443, 1000, 500, 15); -- cobalt_jellyfish
INSERT INTO `fishing_group` VALUES (202,  5128,  850, 290,  7); -- cone_calamary
INSERT INTO `fishing_group` VALUES (202,  5472,  750, 250,  6); -- garpike
INSERT INTO `fishing_group` VALUES (202,  5467,  400, 200,  5); -- megalodon
INSERT INTO `fishing_group` VALUES (202,  4482,  950, 500, 15); -- nosteau_herring
INSERT INTO `fishing_group` VALUES (202,  4451,  500, 245,  5); -- silver_shark
INSERT INTO `fishing_group` VALUES (202,  4483, 1000, 500, 15); -- tiger_cod
INSERT INTO `fishing_group` VALUES (202,  4403, 1000, 500, 15); -- yellow_globe

-- ---------------------------------
-- East Ronfaure [S]
-- ---------------------------------
INSERT INTO `fishing_area` VALUES (81,1,'Whole Zone',0,0,0,NULL,0.000,0.000,0.000);

INSERT INTO `fishing_catch` VALUES (81,1,203);  -- All of the Cheval River

INSERT INTO `fishing_group` VALUES (203,   688,  500, 300,  9); -- arrowwood_log
INSERT INTO `fishing_group` VALUES (203, 14242,  500, 300,  9); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (203, 13454,  500, 300,  9); -- copper_ring
INSERT INTO `fishing_group` VALUES (203,  4379, 1000, 500, 15); -- cheval_salmon
INSERT INTO `fishing_group` VALUES (203,  4472, 1000, 500, 15); -- crayfish
INSERT INTO `fishing_group` VALUES (203,  4427,  750, 275,  6); -- gold_carp
INSERT INTO `fishing_group` VALUES (203,  4354, 1000, 500, 15); -- shining_trout
INSERT INTO `fishing_group` VALUES (203,  4426, 1000, 500, 15); -- tricolored_carp

-- ---------------------------------
-- Grauberg [S]
-- JP Wiki shows only witchglen waterfall as a unique pool
-- ---------------------------------
INSERT INTO `fishing_area` VALUES(89, 1, 'Waterfall', 1, 20, 20, '', -100, -14.5, 509); -- F6
INSERT INTO `fishing_area` VALUES(89, 2, 'Witchfire Glen', 1, 50, 100, '', -110, -7.6, 585); -- Rest of glen area
INSERT INTO `fishing_area` VALUES(89, 3, 'All Waterside', 0, 0, 0, NULL, 0.000, 0.000, 0.000); -- whole zone (must be last area)

INSERT INTO `fishing_catch` VALUES (89,1,206); -- Waterfall
INSERT INTO `fishing_catch` VALUES (89,2,204); -- Witchfire Glen
INSERT INTO `fishing_catch` VALUES (89,3,205); -- All waterside

-- Witchfire Glen
INSERT INTO `fishing_group` VALUES (204, 14117,  500, 300,  9); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (204, 14242,  500, 300,  9); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (204,  5469,  750, 275,  6); -- brass_loach
INSERT INTO `fishing_group` VALUES (204,  4515, 1000, 500, 15); -- copper_frog
INSERT INTO `fishing_group` VALUES (204,  5474,  550, 150,  5); -- ca_cuong

-- Rivers
INSERT INTO `fishing_group` VALUES (205, 14117,  500, 300,  9); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (205, 14242,  500, 300,  9); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (205,  4429,  800, 290,  7); -- black_eel

-- Base of waterfall
INSERT INTO `fishing_group` VALUES (206, 14117,  500, 300,  9); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (206, 14242,  500, 300,  9); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (206,  4477,  550, 145,  4); -- gavial_fish

-- Bottom of waterfall?
REPLACE INTO `fishing_group` VALUES (205, 14117,  500, 300,  9); -- rusty_leggings
REPLACE INTO `fishing_group` VALUES (205, 14242,  500, 300,  9); -- rusty_subligar
REPLACE INTO `fishing_group` VALUES (205,  5470,  550, 145,  5); -- pirarucu

-- ---------------------------------
-- Jugner Forest [S]
-- ---------------------------------
-- INSERT INTO `fishing_area` VALUES (82,1,'Crystalwater Spring',1,20,20,'',300.000,1.000,-179.833); -- inaccessible in past
INSERT INTO `fishing_area` VALUES (82,1,'Lake Mechieume - Mouth',1,20,31,'',19.458,3.000,334.528);
INSERT INTO `fishing_area` VALUES (82,2,'Lake Mechieume - Main',2,20,0,0xC1CA2BC30000000010981544DF4F0B430000000064D3114477DE0D4300000000EC41A143235B30C3000000006871A343,0.000,5.000,0.000);
INSERT INTO `fishing_area` VALUES (82,3,'Maidens Spring',1,20,22,'',-496.682,9.000,298.057);
INSERT INTO `fishing_area` VALUES (82,4,'River',0,0,0,NULL,0.000,0.000,0.000);

INSERT INTO `fishing_catch` VALUES (82,1,208); -- Lake Mechieume
INSERT INTO `fishing_catch` VALUES (82,2,208); -- Lake Mechieume

INSERT INTO `fishing_catch` VALUES (82,4,209); -- River
INSERT INTO `fishing_catch` VALUES (82,3,211); -- Maiden's Spring (E-6)
-- INSERT INTO `fishing_catch` VALUES (82,5,210); -- Crystalwater Spring (J-9)

-- Lake Mechieume
INSERT INTO `fishing_group` VALUES (208,   688,  500, 300,  9); -- arrowwood_log
INSERT INTO `fishing_group` VALUES (208,    90,  500, 300,  9); -- rusty_bucket
INSERT INTO `fishing_group` VALUES (208, 12522,  500, 300,  9); -- rusty_cap
INSERT INTO `fishing_group` VALUES (208, 16655,  500, 300,  9); -- rusty_pick
INSERT INTO `fishing_group` VALUES (208, 13456,  500, 300,  9); -- silver_ring
INSERT INTO `fishing_group` VALUES (208, 14117,  500, 300,  9); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (208, 14242,  500, 300,  9); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (208,  4472, 1000, 500, 15); -- crayfish
INSERT INTO `fishing_group` VALUES (208,  4428,  500, 500, 15); -- dark_bass
INSERT INTO `fishing_group` VALUES (208,  4454,  500, 500, 15); -- emperor_fish
INSERT INTO `fishing_group` VALUES (208,  4401, 1000, 500, 15); -- moat_carp
INSERT INTO `fishing_group` VALUES (208,  4426,  500, 500, 15); -- tricolored_carp
INSERT INTO `fishing_group` VALUES (208,  4427,  500, 500, 15); -- gold_carp
INSERT INTO `fishing_group` VALUES (208,  4469,  500, 500, 15); -- giant_catfish
INSERT INTO `fishing_group` VALUES (208,  4402,  750, 260,  5); -- red_terrapin
INSERT INTO `fishing_group` VALUES (208,  5476,  100, 100,  4); -- abaia

-- Rivers
INSERT INTO `fishing_group` VALUES (209,   688,  500, 300,  9); -- arrowwood_log
INSERT INTO `fishing_group` VALUES (209,    90,  500, 300,  9); -- rusty_bucket
INSERT INTO `fishing_group` VALUES (209, 12522,  500, 300,  9); -- rusty_cap
INSERT INTO `fishing_group` VALUES (209, 16655,  500, 300,  9); -- rusty_pick
INSERT INTO `fishing_group` VALUES (209, 13456,  500, 300,  9); -- silver_ring
INSERT INTO `fishing_group` VALUES (209, 14117,  500, 300,  9); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (209, 14242,  500, 300,  9); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (209,  4472, 1000, 500, 15); -- crayfish
INSERT INTO `fishing_group` VALUES (209,  4401, 1000, 500, 15); -- moat_carp
INSERT INTO `fishing_group` VALUES (209,  4426,  500, 500, 15); -- tricolored_carp
INSERT INTO `fishing_group` VALUES (209,  4427,  500, 500, 15); -- gold_carp
INSERT INTO `fishing_group` VALUES (209,  4379,  500, 500, 15); -- cheval_salmon
INSERT INTO `fishing_group` VALUES (209,  4354,  500, 500, 15); -- shining_trout

-- Crystalwater Spring -- inaccessible
-- INSERT INTO `fishing_group` VALUES (210,   688,  500, 300,  9); -- arrowwood_log
-- INSERT INTO `fishing_group` VALUES (210,    90,  500, 300,  9); -- rusty_bucket
-- INSERT INTO `fishing_group` VALUES (210, 12522,  500, 300,  9); -- rusty_cap
-- INSERT INTO `fishing_group` VALUES (210, 16655,  500, 300,  9); -- rusty_pick
-- INSERT INTO `fishing_group` VALUES (210, 13456,  500, 300,  9); -- silver_ring
-- INSERT INTO `fishing_group` VALUES (210, 14117,  500, 300,  9); -- rusty_leggings
-- INSERT INTO `fishing_group` VALUES (210, 14242,  500, 300,  9); -- rusty_subligar
-- INSERT INTO `fishing_group` VALUES (210,  4472, 1000, 500, 15); -- crayfish
-- INSERT INTO `fishing_group` VALUES (210,  4528,  500, 500, 15); -- crystal_bass
-- INSERT INTO `fishing_group` VALUES (210,  4402,  750, 260,  5); -- red_terrapin

-- Maiden's Spring
INSERT INTO `fishing_group` VALUES (211,   688,  500, 300,  9); -- arrowwood_log
INSERT INTO `fishing_group` VALUES (211,    90,  500, 300,  9); -- rusty_bucket
INSERT INTO `fishing_group` VALUES (211, 12522,  500, 300,  9); -- rusty_cap
INSERT INTO `fishing_group` VALUES (211, 16655,  500, 300,  9); -- rusty_pick
INSERT INTO `fishing_group` VALUES (211, 13456,  500, 300,  9); -- silver_ring
INSERT INTO `fishing_group` VALUES (211, 14117,  500, 300,  9); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (211, 14242,  500, 300,  9); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (211,  4472, 1000, 500, 15); -- crayfish
INSERT INTO `fishing_group` VALUES (211,  4402,  750, 260,  5); -- red_terrapin

-- ---------------------------------
-- North Gustaberg [S]
-- ---------------------------------
INSERT INTO `fishing_area` VALUES (88,1,'Whole Zone',0,0,0,NULL,0.000,0.000,0.000);

INSERT INTO `fishing_catch` VALUES (88,1,212);

INSERT INTO `fishing_group` VALUES (212,    90,  750, 500, 15); -- rusty_bucket
INSERT INTO `fishing_group` VALUES (212,  4472,  500, 500, 15); -- crayfish
INSERT INTO `fishing_group` VALUES (212,  4429,  500, 500, 15); -- black_eel
INSERT INTO `fishing_group` VALUES (212,  4477,  500, 500, 15); -- gavial_fish
INSERT INTO `fishing_group` VALUES (212, 14117,  750, 500, 15); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (212, 14242,  750, 500, 15); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (212,  4426,  500, 500, 15); -- tricolored_carp
INSERT INTO `fishing_group` VALUES (212,  4427,  500, 500, 15); -- gold_carp
INSERT INTO `fishing_group` VALUES (212,  4515,  500, 500, 15); -- copper_frog

-- ---------------------------------
-- Oztroja Castle [S]
-- ---------------------------------
INSERT INTO `fishing_area` VALUES (99,1,'Whole Zone',0,0,0,NULL,0.000,0.000,0.000);

INSERT INTO `fishing_catch` VALUES (99,1,213);

INSERT INTO `fishing_group` VALUES (213,  4472,  500, 500, 15); -- crayfish
INSERT INTO `fishing_group` VALUES (213, 14117,  750, 500, 15); -- rusty_leggings

-- ---------------------------------
-- Pashhow Marshlands [S]
-- ---------------------------------
INSERT INTO `fishing_area` VALUES (90,1,'Whole Zone',0,0,0,NULL,0.000,0.000,0.000);

INSERT INTO `fishing_catch` VALUES (90,1,214);

INSERT INTO `fishing_group` VALUES (214, 12522,  750, 500, 15); -- rusty_cap
INSERT INTO `fishing_group` VALUES (214,  4469,  500, 500, 15); -- giant_catfish
INSERT INTO `fishing_group` VALUES (214,  5471,  500, 500, 15); -- gerrothorax
INSERT INTO `fishing_group` VALUES (214,  4402,  500, 500, 15); -- red_terrapin
INSERT INTO `fishing_group` VALUES (214,  4515, 1000, 500, 15); -- copper_frog

-- ---------------------------------
-- Rolanberry Fields [S]
-- ---------------------------------
INSERT INTO `fishing_area` VALUES (91,1,'Whole Zone',0,0,0,NULL,0.000,0.000,0.000);
-- INSERT INTO `fishing_area` VALUES(91, 1, 'Small Fountain 1', 1, 20, 20, '', -538.750, -14.000, -179.103);
-- INSERT INTO `fishing_area` VALUES(91, 2, 'Fountain of Promises', 1, 20, 70, '', -670.355, -21.000, -175.250);
-- INSERT INTO `fishing_area` VALUES(91, 3, 'Fountain of Partings', 1, 20, 60, '', -721.715, -26.000, -423.003);
-- INSERT INTO `fishing_area` VALUES(91, 4, 'Small Fountain 2', 1, 20, 20, '', 257.238, -30.000, -258.576);

INSERT INTO `fishing_catch` VALUES (91,1,215);

INSERT INTO `fishing_group` VALUES (215, 16537,  750, 500, 15); -- mythril_sword
INSERT INTO `fishing_group` VALUES (215,    90,  750, 500, 15); -- rusty_bucket
INSERT INTO `fishing_group` VALUES (215, 16606,  750, 500, 15); -- rusty_greatsword
INSERT INTO `fishing_group` VALUES (215, 13456,  750, 500, 15); -- silver_ring
INSERT INTO `fishing_group` VALUES (215,  4472,  500, 500, 15); -- crayfish
INSERT INTO `fishing_group` VALUES (215,  4428,  500, 500, 15); -- dark_bass
INSERT INTO `fishing_group` VALUES (215, 14242,  750, 500, 15); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (215,  4401, 1000, 500, 15); -- moat_carp
INSERT INTO `fishing_group` VALUES (215, 16655,  750, 500, 15); -- rusty_pick
INSERT INTO `fishing_group` VALUES (215,  4469,  500, 500, 15); -- giant_catfish
INSERT INTO `fishing_group` VALUES (215,  4402,  500, 500, 15); -- red_terrapin
INSERT INTO `fishing_group` VALUES (215, 12316,  750, 500, 15); -- fish_scale_shield

-- ---------------------------------
-- Vunkerl Inlet [S]
-- ---------------------------------
INSERT INTO `fishing_area` VALUES (83,1,'Whole Zone',0,0,0,NULL,0.000,0.000,0.000);
-- INSERT INTO `fishing_area` VALUES(83, 1, 'Bridge', 0, 0, 0, NULL, 0.000, 0.000, 0.000);
-- INSERT INTO `fishing_area` VALUES(83, 2, 'Lake Joroia', 1, 20, 200, NULL, -212.553, -37.738, -307.338);
-- INSERT INTO `fishing_area` VALUES(83, 3, 'Memjar Spring', 1, 20, 130, NULL, -284.279, -38.375, -656.134);
-- INSERT INTO `fishing_area` VALUES(83, 4, 'Ludiwa Spring', 1, 20, 130, NULL, -423.925, -30.592, 574.216);

INSERT INTO `fishing_catch` VALUES (83,1,216);

INSERT INTO `fishing_group` VALUES (216,  5473,  500, 500, 15); -- bastore_sweeper
INSERT INTO `fishing_group` VALUES (216,  4443,  500, 500, 15); -- cobalt_jellyfish
INSERT INTO `fishing_group` VALUES (216,   688,  750, 500, 15); -- arrowwood_log
INSERT INTO `fishing_group` VALUES (216,    90,  750, 500, 15); -- rusty_bucket
INSERT INTO `fishing_group` VALUES (216,  5475, 1000, 500, 15); -- gigant_octopus
INSERT INTO `fishing_group` VALUES (216,  4428,  500, 500, 15); -- dark_bass
INSERT INTO `fishing_group` VALUES (216,  4514,  500, 500, 15); -- quus
INSERT INTO `fishing_group` VALUES (216,  5466, 1000, 500, 15); -- trumpet_shell
INSERT INTO `fishing_group` VALUES (216,  4461,  500, 500, 15); -- bastore_bream
INSERT INTO `fishing_group` VALUES (216, 14117,  750, 500, 15); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (216, 14242,  750, 500, 15); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (216,  4401, 1000, 500, 15); -- moat_carp
INSERT INTO `fishing_group` VALUES (216,  4426,  500, 500, 15); -- tricolored_carp
INSERT INTO `fishing_group` VALUES (216,  4469,  500, 500, 15); -- giant_catfish
INSERT INTO `fishing_group` VALUES (216,  5472,  500, 500, 15); -- garpike
INSERT INTO `fishing_group` VALUES (216,  4360,  500, 500, 15); -- bastore_sardine
INSERT INTO `fishing_group` VALUES (216,  5468,  100, 100,  4); -- matsya
INSERT INTO `fishing_group` VALUES (216,  4481,  500, 500, 15); -- ogre_eel

-- ---------------------------------
-- West Sarutabaruta [S]
-- ---------------------------------
INSERT INTO `fishing_area` VALUES (95,1,'Whole Zone',0,0,0,NULL,0.000,0.000,0.000);
-- INSERT INTO `fishing_area` VALUES(95, 1, 'Pond', 1, 20, 25, '', 110.000, -1.000, -200.000);
-- INSERT INTO `fishing_area` VALUES(95, 2, 'Seaside', 0, 0, 0, NULL, 0.000, 0.000, 0.000);

INSERT INTO `fishing_catch` VALUES (95,1,217);

INSERT INTO `fishing_group` VALUES (217,  4471,  500, 500, 15); -- bladefish
INSERT INTO `fishing_group` VALUES (217,   624,  750, 500, 15); -- clump_of_pamtam_kelp
INSERT INTO `fishing_group` VALUES (217,    90,  750, 500, 15); -- rusty_bucket
INSERT INTO `fishing_group` VALUES (217,  4472,  500, 500, 15); -- crayfish
INSERT INTO `fishing_group` VALUES (217,  4428,  500, 500, 15); -- dark_bass
INSERT INTO `fishing_group` VALUES (217,  4514,  500, 500, 15); -- quus
INSERT INTO `fishing_group` VALUES (217,  4461,  500, 500, 15); -- bastore_bream
INSERT INTO `fishing_group` VALUES (217, 14242,  750, 500, 15); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (217,  4401, 1000, 500, 15); -- moat_carp
INSERT INTO `fishing_group` VALUES (217,  4469,  500, 500, 15); -- giant_catfish
INSERT INTO `fishing_group` VALUES (217,  4360,  500, 500, 15); -- bastore_sardine
INSERT INTO `fishing_group` VALUES (217,  4399,  500, 500, 15); -- bluetail
INSERT INTO `fishing_group` VALUES (217,  4481,  500, 500, 15); -- ogre_eel
INSERT INTO `fishing_group` VALUES (217,  4383,  500, 500, 15); -- gold_lobster

-- ---------------------------------
-- Windurst Waters [S]
-- ---------------------------------
INSERT INTO `fishing_area` VALUES (94,1,'Whole Zone',0,0,0,NULL,0.000,0.000,0.000);

INSERT INTO `fishing_catch` VALUES (94,1,218);

INSERT INTO `fishing_group` VALUES (218,    90,  750, 500, 15); -- rusty_bucket
INSERT INTO `fishing_group` VALUES (218,  4472,  500, 500, 15); -- crayfish
INSERT INTO `fishing_group` VALUES (218,  4464,  500, 500, 15); -- pipira
INSERT INTO `fishing_group` VALUES (218, 14117,  750, 500, 15); -- rusty_leggings
INSERT INTO `fishing_group` VALUES (218, 14242,  750, 500, 15); -- rusty_subligar
INSERT INTO `fishing_group` VALUES (218,  4401, 1000, 500, 15); -- moat_carp
INSERT INTO `fishing_group` VALUES (218,  4427,  500, 500, 15); -- gold_carp

-- ---------------------------------
-- Beaucedine Glacier [S]
-- ---------------------------------
-- INSERT INTO `fishing_area` VALUES (136,1,'Seaside',1,20,150,'',435.000,-1.000,-92.000);
-- INSERT INTO `fishing_area` VALUES (136,2,'Ponds',0,0,0,NULL,0.000,0.000,0.000);
--
-- INSERT INTO `fishing_catch` VALUES (136,1,219);
-- INSERT INTO `fishing_catch` VALUES (136,2,220);
--
-- INSERT INTO `fishing_group` VALUES (213,  4472,  500, 500, 15); -- crayfish
-- INSERT INTO `fishing_group` VALUES (213, 14117,  750, 500, 15); -- rusty_leggings

-- ---------------------------------
-- Vunkerl Inlet [S]
-- ---------------------------------
-- INSERT INTO `fishing_area` VALUES(85, 1, 'Pond', 1, 20, 50, '', 198.750, 2.000, -107.220);
-- INSERT INTO `fishing_area` VALUES(85, 2, 'Other Waterside', 0, 0, 0, NULL, 0.000, 0.000, 0.000);

-- ---------------------------------
-- Add Toraimarai Canal
-- Bridges that cross over canal are only valid fishing spots
-- ---------------------------------

INSERT INTO `fishing_area` VALUES (169,1,'Whole Zone',0,0,0,NULL,0.000,0.000,0.000);
UPDATE fishing_mob set disabled = 0 WHERE zoneid = 169;
