--
-- Author: Carver
-- Date: 8/15/2023
-- Rev: 1.0
-- Description: A module to add custom equipment to the server for Dynamis 2.0.

--
-- Dynamis 2.0 item_mods Modifications
--

SET @MOEPAPA_RING        = 10754;
SET @MOEPAPA_ANNULET     = 10755;
SET @TJUKURRPA_RING      = 10756;
SET @TJUKURRPA_ANNULET   = 10757;
SET @AIFES_RING          = 10758;
SET @AIFES_ANNULET       = 10759;
SET @MOEPAPA_STONE       = 10817;
SET @TJUKURRPA_BELT      = 10818;
SET @ONEIROS_TORQUE      = 10932;
SET @MUJIN_NECKLACE      = 10933;
SET @MOEPAPA_PENDANT     = 10940;
SET @TJUKURRPA_MEDAL     = 10941;
SET @MOEPAPA_MEDAL       = 10943;
SET @ONEIROS_CAPPA       = 10972;
SET @ONEIROS_CAPE        = 10973;
SET @MUJIN_MANTLE        = 10974;
SET @AIFES_MANTLE        = 10983;
SET @TJUKURRPA_MANTLE    = 10984;
SET @ONEIROS_EARRING     = 11030;
SET @ONEIROS_PEARL       = 11031;
SET @MUJIN_STUD          = 11032;
SET @RYUGA_SUNE_ATE      = 11456;
SET @AIFES_PUMPS         = 11461;
SET @ONEIROS_ANNULET     = 11670;
SET @ONEIROS_RING        = 11671;
SET @MUJIN_BAND          = 11672;
SET @ONEIROS_SASH        = 11772;
SET @ONEIROS_BELT        = 11773;
SET @ONEIROS_CEST        = 11774;
SET @ONEIROS_ROPE        = 11775;
SET @MUJIN_OBI           = 11776;
SET @ONEIROS_HELM        = 11816;
SET @ONEIROS_BARBUT      = 11817;
SET @ONEIROS_HEADGEAR    = 11818;
SET @ONEIROS_COIF        = 11819;
SET @TJUKURRPA_GAUNTLETS = 11923;
SET @KHTHONIOS_GLOVES    = 11918;
SET @AVESTA_BANGLES      = 11919;
SET @ONEIROS_AXE         = 18519;
SET @TJUKURRPA_AXE       = 18541;
SET @CHTONIC_STAFF       = 18623;
SET @ONEIROS_GRIP        = 18811;
SET @KHTHONIOS_MASK      = 11820;
SET @KHTHONIOS_HELM      = 11821;
SET @MOEPAPA_MACE        = 17069;
SET @ONEIROS_KNIFE       = 19141;
SET @MUJIN_TANTO         = 19295;
SET @AIFES_BOW           = 19738;
SET @ONEIROS_CLUSTER     = 19763;
SET @ONEIROS_PEBBLE      = 19767;
SET @ONEIROS_LANCE       = 19790;
SET @PORTUS_ANNULET      = 10761;
SET @PORTUS_RING         = 10760;
SET @PORTUS_COLLAR       = 10944;
SET @ALUCINOR_MITTS      = 11924;
SET @ONEIROS_TATHLUM     = 19762;
SET @ONEIROS_HARP        = 17358;
SET @AIFES_MEDAL         = 10942;

-- Forgotten Pouches
SET @FORGOTTEN_POUCH_HEAD  = 6541;
SET @FORGOTTEN_POUCH_BODY  = 6542;
SET @FORGOTTEN_POUCH_HANDS = 6543;
SET @FORGOTTEN_POUCH_LEGS  = 6544;
SET @FORGOTTEN_POUCH_FEET  = 6545;

-- Geomancer Relic +1
SET @BAGUA_GALERO_1   = 26665;
SET @BAGUA_TUNIC_1    = 26841;
SET @BAGUA_MITAINES_1 = 27017;
SET @BAGUA_PANTS_1    = 27193;
SET @BAGUA_SANDALS_1  = 27369;
SET @BAGUA_SASH       = 26323;

-- Runefencer Relic +1
SET @FUTHARK_BANDEAU_1  = 26667;
SET @FUTHARK_COAT_1     = 26843;
SET @FUTHARK_MITONS_1   = 27019;
SET @FUTHARK_TROUSERS_1 = 27195;
SET @FUTHARK_BOOTS_1    = 27371;
SET @FUTHARK_CAPE       = 26240;

-- Delete all item_mods and item_mods_pet rows for Dynamis 2.0 items
DELETE FROM item_mods
WHERE itemId IN (
    @MOEPAPA_RING,
    @MOEPAPA_ANNULET,
    @TJUKURRPA_RING,
    @TJUKURRPA_ANNULET,
    @AIFES_RING,
    @AIFES_ANNULET,
    @MOEPAPA_STONE,
    @TJUKURRPA_BELT,
    @ONEIROS_TORQUE,
    @MUJIN_NECKLACE,
    @MOEPAPA_PENDANT,
    @MOEPAPA_MEDAL,
    @ONEIROS_CAPPA,
    @ONEIROS_CAPE,
    @MUJIN_MANTLE,
    @AIFES_MANTLE,
    @TJUKURRPA_MANTLE,
    @ONEIROS_EARRING,
    @ONEIROS_PEARL,
    @RYUGA_SUNE_ATE,
    @AIFES_PUMPS,
    @ONEIROS_ANNULET,
    @ONEIROS_RING,
    @MUJIN_BAND,
    @ONEIROS_SASH,
    @ONEIROS_BELT,
    @ONEIROS_CEST,
    @ONEIROS_ROPE,
    @MUJIN_OBI,
    @ONEIROS_HELM,
    @ONEIROS_BARBUT,
    @ONEIROS_HEADGEAR,
    @ONEIROS_COIF,
    @TJUKURRPA_GAUNTLETS,
    @KHTHONIOS_GLOVES,
    @AVESTA_BANGLES,
    @ONEIROS_AXE,
    @TJUKURRPA_AXE,
    @CHTONIC_STAFF,
    @ONEIROS_GRIP,
    @KHTHONIOS_MASK,
    @KHTHONIOS_HELM,
    @MOEPAPA_MACE,
    @ONEIROS_KNIFE,
    @MUJIN_TANTO,
    @AIFES_BOW,
    @ONEIROS_CLUSTER,
    @ONEIROS_PEBBLE,
    @ONEIROS_LANCE,
    @PORTUS_ANNULET,
    @PORTUS_RING,
    @PORTUS_COLLAR,
    @ALUCINOR_MITTS,
    @PORTUS_ANNULET,
    @PORTUS_RING,
    @PORTUS_COLLAR,
    @ALUCINOR_MITTS
);

DELETE FROM item_mods_pet WHERE itemId IN(
    @MOEPAPA_STONE,
    @ONEIROS_CAPPA,
    @MUJIN_OBI,
    @MOEPAPA_STONE,
    @AIFES_MANTLE,
    @AIFES_PUMPS,
    @ONEIROS_LANCE,
    @ONEIROS_HEADGEAR,
    @KHTHONIOS_HELM,
    @CHTONIC_STAFF,
    @BAGUA_SANDALS_1,
    @BAGUA_SASH
);

UPDATE item_equipment SET level = 75
WHERE itemId IN (
    @MOEPAPA_RING,
    @MOEPAPA_ANNULET,
    @TJUKURRPA_RING,
    @TJUKURRPA_ANNULET,
    @AIFES_RING,
    @AIFES_ANNULET,
    @MOEPAPA_STONE,
    @TJUKURRPA_BELT,
    @ONEIROS_TORQUE,
    @MUJIN_NECKLACE,
    @MOEPAPA_PENDANT,
    @MOEPAPA_MEDAL,
    @TJUKURRPA_MEDAL,
    @ONEIROS_CAPPA,
    @ONEIROS_CAPE,
    @MUJIN_MANTLE,
    @AIFES_MANTLE,
    @TJUKURRPA_MANTLE,
    @ONEIROS_EARRING,
    @ONEIROS_PEARL,
    @MUJIN_STUD,
    @RYUGA_SUNE_ATE,
    @AIFES_PUMPS,
    @ONEIROS_ANNULET,
    @ONEIROS_RING,
    @MUJIN_BAND,
    @ONEIROS_SASH,
    @ONEIROS_BELT,
    @ONEIROS_CEST,
    @ONEIROS_ROPE,
    @MUJIN_OBI,
    @ONEIROS_HELM,
    @ONEIROS_BARBUT,
    @ONEIROS_HEADGEAR,
    @ONEIROS_COIF,
    @TJUKURRPA_GAUNTLETS,
    @KHTHONIOS_GLOVES,
    @AVESTA_BANGLES,
    @ONEIROS_AXE,
    @TJUKURRPA_AXE,
    @CHTONIC_STAFF,
    @ONEIROS_GRIP,
    @KHTHONIOS_MASK,
    @KHTHONIOS_HELM,
    @MOEPAPA_MACE,
    @ONEIROS_KNIFE,
    @MUJIN_TANTO,
    @AIFES_BOW,
    @ONEIROS_CLUSTER,
    @ONEIROS_PEBBLE,
    @ONEIROS_LANCE,
    @PORTUS_ANNULET,
    @PORTUS_RING,
    @PORTUS_COLLAR,
    @ONEIROS_TATHLUM,
    @ONEIROS_HARP,
    @AIFES_MEDAL,
    @ALUCINOR_MITTS
);

UPDATE item_equipment SET level = 74
WHERE itemId IN (
    @PORTUS_ANNULET,
    @PORTUS_RING,
    @PORTUS_COLLAR,
    @ALUCINOR_MITTS
);

--
-- Insert into item_mods.sql
--
INSERT INTO item_mods (itemId, modId, Value)
VALUES
    (@MOEPAPA_RING,11,5),          -- AGI: 5
    (@MOEPAPA_RING,81,3),          -- DAGGER: 3
    (@MOEPAPA_RING,105,3),         -- MARKSMAN: 3

    (@MOEPAPA_ANNULET,8,5),        -- STR: 5
    (@MOEPAPA_ANNULET,83,3),       -- GSWORD: 3
    (@MOEPAPA_ANNULET,89,3),       -- GKATANA: 3

    (@TJUKURRPA_RING,9,5),         -- DEX: 5
    (@TJUKURRPA_RING,84,3),        -- AXE: 3
    (@TJUKURRPA_RING,88,3),        -- KATANA: 3

    (@TJUKURRPA_ANNULET,13,5),     -- MND: 5
    (@TJUKURRPA_ANNULET,82,3),     -- SWORD: 3
    (@TJUKURRPA_ANNULET,90,3),     -- CLUB: 3

    (@AIFES_RING,8,5),             -- STR: 5
    (@AIFES_RING,87,3),            -- POLEARM: 3
    (@AIFES_RING,104,3),           -- ARCHERY: 3

    (@AIFES_ANNULET,12,5),         -- INT: 5
    (@AIFES_ANNULET,86,3),         -- SCYTHE: 3
    (@AIFES_ANNULET,91,3),         -- STAFF: 3

    (@MOEPAPA_STONE,1,5),          -- DEF: 5
    (@MOEPAPA_STONE,14,5),         -- CHR: 5
    (@MOEPAPA_STONE,384,500),      -- HASTE_GEAR: 500

    (@TJUKURRPA_BELT,1,5),         -- DEF: 5
    (@TJUKURRPA_BELT,8,5),         -- STR: 5
    (@TJUKURRPA_BELT,288,1),       -- DOUBLE_ATTACK: 1

    (@ONEIROS_TORQUE,68,5),        -- EVA: 5
    (@ONEIROS_TORQUE,161,-200),    -- DMGPHYS: -200

    (@MUJIN_NECKLACE,8,5),         -- STR: 5
    (@MUJIN_NECKLACE,306,5),       -- ZANSHIN: 5

    (@MOEPAPA_PENDANT,12,8),       -- INT: 8
    (@MOEPAPA_PENDANT,27,-5),      -- ENMITY: -5
    (@MOEPAPA_PENDANT,563,5),      -- MAGIC_CRIT_DMG_INCREASE: 5

    (@MOEPAPA_MEDAL,9,6),          -- DEX: 6
    (@MOEPAPA_MEDAL,11,6),         -- AGI: 6
    (@MOEPAPA_MEDAL,17,10),        -- WIND_RES: 10
    (@MOEPAPA_MEDAL,19,10),        -- THUNDER_RES: 10

    (@ONEIROS_CAPPA,1,14),         -- DEF: 14
    (@ONEIROS_CAPPA,10,5),         -- VIT: 5

    (@ONEIROS_CAPE,1,8),           -- DEF: 8
    (@ONEIROS_CAPE,30,4),          -- MACC: 4
    (@ONEIROS_CAPE,233,1),         -- DRAGON_KILLER: 1

    (@MUJIN_MANTLE,1,9),           -- DEF: 9
    (@MUJIN_MANTLE,31,5),          -- MEVA: 5
    (@MUJIN_MANTLE,68,5),          -- EVASION: 5
    (@MUJIN_MANTLE,25,5),          -- ACC: 5

    (@AIFES_MANTLE,1,7),           -- DEF: 7
    (@AIFES_MANTLE,11,4),          -- AGI: 4
    (@AIFES_MANTLE,25,4),          -- ACC: 4
    (@AIFES_MANTLE,73,2),          -- STORETP: 2

    (@TJUKURRPA_MANTLE,1,9),       -- DEF: 9
    (@TJUKURRPA_MANTLE,11,3),      -- AGI: 3
    (@TJUKURRPA_MANTLE,28,3),      -- MATT: 3
    (@TJUKURRPA_MANTLE,27,3),      -- ENMITY: 3

    (@ONEIROS_EARRING,2,15),       -- HP: 15
    (@ONEIROS_EARRING,10,3),       -- VIT: 3
    (@ONEIROS_EARRING,375,5),      -- CURE_POTENCY_RCVD: 5

    (@ONEIROS_PEARL,24,3),         -- RATT: 3
    (@ONEIROS_PEARL,27,-2),        -- ENMITY: -2

    (@RYUGA_SUNE_ATE,1,20),        -- DEF: 20
    (@RYUGA_SUNE_ATE,2,30),        -- HP: 30
    (@RYUGA_SUNE_ATE,10,7),        -- VIT: 7
    (@RYUGA_SUNE_ATE,25,4),        -- ACC: 4
    (@RYUGA_SUNE_ATE,68,4),        -- EVA: 4
    (@RYUGA_SUNE_ATE,384,300),     -- HASTE_GEAR: 300
    (@RYUGA_SUNE_ATE,101,5),       -- Automaton - Melee Skill: 5
    (@RYUGA_SUNE_ATE,102,5),       -- Automaton - Ranged Skill: 5
    (@RYUGA_SUNE_ATE,103,5),       -- Automaton - Magic Skill: 5

    (@AIFES_PUMPS,1,20),           -- DEF: 20
    (@AIFES_PUMPS,5,20),           -- MP: 20
    (@AIFES_PUMPS,13,7),           -- MND: 7
    (@AIFES_PUMPS,30,-4),          -- MACC: -4
    (@AIFES_PUMPS,296,4),          -- CONSERVE_MP: 4
    (@AIFES_PUMPS,27,-5),          -- ENMITY: -5

    (@ONEIROS_ANNULET,11,-5),      -- AGI: -5
    (@ONEIROS_ANNULET,25,8),       -- ACC: 8

    (@ONEIROS_RING,25,3),          -- ACC: 3

    (@MUJIN_BAND,9,4),             -- DEX: 4
    (@MUJIN_BAND,175,4),           -- SKILLCHAINDMG: 4

    (@ONEIROS_SASH,1,5),           -- DEF: 5
    (@ONEIROS_SASH,2,20),          -- HP: 20
    (@ONEIROS_SASH,5,20),          -- MP: 20
    (@ONEIROS_SASH,28,4),          -- MATT: 4
    (@ONEIROS_SASH,296,4),         -- CONSERVE_MP: 4

    (@ONEIROS_BELT,1,8),           -- DEF: 8
    (@ONEIROS_BELT,2,45),          -- HP: 45
    (@ONEIROS_BELT,8,3),           -- STR: 3
    (@ONEIROS_BELT,161,-200),      -- DMGPHYS: -200 (-2%)

    (@ONEIROS_CEST,1,5),           -- DEF: 5
    (@ONEIROS_CEST,25,9),          -- ACC: 9
    (@ONEIROS_CEST,73,3),          -- STORETP: 3
    (@ONEIROS_CEST,384,300),       -- HASTE_GEAR: 300

    (@ONEIROS_ROPE,1,4),           -- DEF: 4
    (@ONEIROS_ROPE,73,2),          -- STORETP: 2
    (@ONEIROS_ROPE,902,20),        -- OCCULT_ACUMEN: 20

    (@MUJIN_OBI,1,4),              -- DEF: 4
    (@MUJIN_OBI,5,30),             -- MP: 30

    (@ONEIROS_HELM,1,28),          -- DEF: 28
    (@ONEIROS_HELM,9,9),           -- DEX: 9
    (@ONEIROS_HELM,288,-3),        -- DOUBLE_ATTACK: -3
    (@ONEIROS_HELM,302,-3),        -- TRIPLE_ATTACK: -3
    (@ONEIROS_HELM,421,3),         -- CRIT_DMG_INCREASE: 3

    (@ONEIROS_BARBUT,1,30),        -- DEF: 30
    (@ONEIROS_BARBUT,10,9),        -- VIT: 9
    (@ONEIROS_BARBUT,68,-14),      -- EVA: -14
    (@ONEIROS_BARBUT,161,-500),    -- DMGPHYS: -500 (-5%)
    (@ONEIROS_BARBUT,76,-12),      -- MOVE_SPEED_STACKABLE: -12

    (@ONEIROS_HEADGEAR,1,25),       -- DEF: 25
    (@ONEIROS_HEADGEAR,5,50),       -- MP: 50
    (@ONEIROS_HEADGEAR,12,6),       -- INT: 6
    (@ONEIROS_HEADGEAR,28,6),       -- MATT: 6
    (@ONEIROS_HEADGEAR,30,6),       -- MACC: 6
    (@ONEIROS_HEADGEAR,17,15),      -- WIND_RES: 15
    (@ONEIROS_HEADGEAR,16,-15),     -- ICE_RES: -15
    (@ONEIROS_HEADGEAR,349,1),      -- WIND_AFFINITY_DMG: 1

    (@ONEIROS_COIF,1,23),           -- DEF: 23
    (@ONEIROS_COIF,8,4),            -- STR: 4
    (@ONEIROS_COIF,24,10),          -- RATT: 10
    (@ONEIROS_COIF,27,3),           -- ENMITY: 3
    (@ONEIROS_COIF,365,-3),         -- SNAPSHOT: -3

    (@TJUKURRPA_GAUNTLETS,1,30),      -- DEF: 9
    (@TJUKURRPA_GAUNTLETS,2,30),      -- HP: 30
    (@TJUKURRPA_GAUNTLETS,5,30),      -- MP: 30
    (@TJUKURRPA_GAUNTLETS,25,5),      -- ACC: 5
    (@TJUKURRPA_GAUNTLETS,27,3),      -- ENMITY: 3
    (@TJUKURRPA_GAUNTLETS,161,-300),  -- DMGPHYS: -300 (-3%)

    (@KHTHONIOS_GLOVES,1,23),         -- DEF: 23
    (@KHTHONIOS_GLOVES,11,6),         -- AGI: 6
    (@KHTHONIOS_GLOVES,24,8),         -- RATT: 8
    (@KHTHONIOS_GLOVES,27,-3),        -- ENMITY: -3
    (@KHTHONIOS_GLOVES,305,5),        -- RECYCLE: 5

    (@AVESTA_BANGLES,30,6),           -- MACC: 6
    (@AVESTA_BANGLES,114,9),          -- ENFEEBLING MAGIC SKILL: 9
    (@AVESTA_BANGLES,115,9),          -- ELEMENTAL MAGIC SKILL: 9
    (@AVESTA_BANGLES,116,9),          -- DARK MAGIC SKILL: 9
    (@AVESTA_BANGLES,103,9),          -- Automaton - Magic Skill: 9

    (@ONEIROS_AXE,2,50),              -- HP: 50
    (@ONEIROS_AXE,10,5),              -- VIT: 5
    (@ONEIROS_AXE,160,-500),          -- DMG: -500 (5%)
    (@ONEIROS_AXE,27,5),              -- ENMITY: 5
    (@ONEIROS_AXE,414,5),             -- RETALIATION: 5
    (@ONEIROS_AXE,25,5),              -- ACC: 5

    (@TJUKURRPA_AXE,1052,2),          -- SIC_READY_RECAST -2 (reduction is in seconds)

    (@CHTONIC_STAFF,163,-500),        -- DMGMAGIC: -500 (-5%)

    (@ONEIROS_GRIP,370,1),            -- REGEN: 1
    (@ONEIROS_GRIP,2,5),              -- HP: 5
    (@ONEIROS_GRIP,5,5),              -- MP: 5

    (@KHTHONIOS_MASK,1,23),           -- DEF: 23
    (@KHTHONIOS_MASK,23,14),          -- ATT: 14
    (@KHTHONIOS_MASK,73,4),           -- STORETP: 4
    (@KHTHONIOS_MASK,384,400),        -- HASTE_GEAR: 400
    (@KHTHONIOS_MASK,4,30),           -- CONVMPTOHP: 30
    (@KHTHONIOS_MASK,29,4),           -- Magic Defense: 4

    (@KHTHONIOS_HELM,1,29),           -- DEF: 29
    (@KHTHONIOS_HELM,2,14),           -- HP: 14
    (@KHTHONIOS_HELM,8,7),            -- STR: 7
    (@KHTHONIOS_HELM,12,7),           -- INT: 7
    (@KHTHONIOS_HELM,116,9),          -- DARK MAGIC SKILL: 9

    (@MOEPAPA_MACE,22,30),            -- DARK_MEVA: 30
    (@MOEPAPA_MACE,13,8),             -- MND: 8
    (@MOEPAPA_MACE,25,8),             -- ACC: 8
    (@MOEPAPA_MACE,431,2),            -- ITEM_ADDEFFECT_TYPE: 2
    (@MOEPAPA_MACE,499,12),           -- ITEM_SUBEFFECT: 12
    (@MOEPAPA_MACE,501,10),           -- ITEM_ADDEFFECT_CHANCE: 10
    (@MOEPAPA_MACE,951,156),          -- ITEM_ADDEFFECT_STATUS: 155 -- Additional Effect Flash
    (@MOEPAPA_MACE,953,10),           -- ITEM_ADDEFFECT_DURATION: 10
    (@MOEPAPA_MACE,353,2),            -- LIGHT_AFFINITY_DMG: 2
    (@MOEPAPA_MACE,550,2),            -- LIGHT_AFFINITY_ACC: 2
    (@MOEPAPA_MACE,559,2),            -- LIGHT_AFFINITY_PERP: 2

    (@ONEIROS_KNIFE,11,6),            -- AGI: 6
    (@ONEIROS_KNIFE,421,3),           -- CRIT_DMG_INCREASE: 3

    (@MUJIN_TANTO,160,-300),          -- DMG: -300 (3%)
    (@MUJIN_TANTO,27,3),              -- ENMITY: 3
    (@MUJIN_TANTO,170,2),             -- FASTCAST: 2
    (@MUJIN_TANTO,289,5),             -- SUBTLE_BLOW: 5

    (@AIFES_BOW,5,15),                -- MP: 15
    (@AIFES_BOW,27,-6),               -- ENMITY: -6
    (@AIFES_BOW,26,12),               -- RACC: 12
    (@AIFES_BOW,289,8),               -- SUBTLE_BLOW: 8
    (@AIFES_BOW,381,-3),              -- RANGED_DELAYP: -3% -- Do not use this universally. This ranged delay reduction doesn't impact TP gain.

    (@ONEIROS_CLUSTER,23,-3),         -- ATT: -3
    (@ONEIROS_CLUSTER,384,100),       -- HASTE_GEAR: 100

    (@ONEIROS_PEBBLE,10,3),           -- VIT: 3
    (@ONEIROS_PEBBLE,25,3),           -- ACC: 3

    (@ONEIROS_LANCE,2,50),            -- HP: 50
    (@ONEIROS_LANCE,10,5),            -- VIT: 5
    (@ONEIROS_LANCE,160,-500),        -- DMG: -500 (5%)
    (@ONEIROS_LANCE,27,5),            -- ENMITY: 5
    (@ONEIROS_LANCE,402,5),           -- WYVERN_BREATH: 5

    (@PORTUS_ANNULET,25,6),           -- ACC: 6
    (@PORTUS_ANNULET,107,3),          -- GUARD: 3
    (@PORTUS_ANNULET,108,3),          -- EVASION: 3
    (@PORTUS_ANNULET,109,3),          -- SHIELD: 3
    (@PORTUS_ANNULET,110,3),          -- PARRY: 3

    (@PORTUS_RING,10,4),              -- VIT: 4
    (@PORTUS_RING,80,4),              -- HTH: 4
    (@PORTUS_RING,87,4),              -- POLEARM: 4

    (@PORTUS_COLLAR,25,2),            -- ACC: 2
    (@PORTUS_COLLAR,288,2),           -- DOUBLE_ATTACK: 2

    (@ALUCINOR_MITTS,1,25),           -- DEF: 25
    (@ALUCINOR_MITTS,5,25),           -- MP: 25
    (@ALUCINOR_MITTS,9,5),            -- DEX: 5
    (@ALUCINOR_MITTS,22,25),          -- DARK_RES: 25
    (@ALUCINOR_MITTS,384,300);        -- HASTE_GEAR: 300

--
-- Insert into item_mods_pet.sql
--
INSERT INTO item_mods_pet (itemId, modId, value, petType)
VALUES
    (@MOEPAPA_STONE,384,300,0),     -- All Pets - HASTE_GEAR: 300
    (@ONEIROS_CAPPA,161,-300,0),    -- All Pets - DMGPHYS: -300
    (@AIFES_MANTLE,23,10,0),        -- All Pets - ATT: 10
    (@AIFES_PUMPS,374,4,3),         -- CURE_POTENCY: 4
    (@MUJIN_OBI,23,10,1),           -- Avatar - ATT: 10
    (@ONEIROS_LANCE,370,3,2),       -- Wyvern - REGEN: 3
    (@ONEIROS_LANCE,160,-500,2),    -- Wyvern - Damage Taken: -5%
    (@ONEIROS_HEADGEAR,30,6,3),     -- Automaton - MACC: 6
    (@ONEIROS_HEADGEAR,369,1,3),    -- Automaton - REFRESH: 1
    (@KHTHONIOS_HELM,23,9,0),       -- All Pets - ATT: 9
    (@KHTHONIOS_HELM,24,9,0),       -- All Pets - RATT: 9
    (@KHTHONIOS_HELM,25,9,0),       -- All Pets - ACC: 9
    (@KHTHONIOS_HELM,26,9,0),       -- All Pets - RACC: 9
    (@CHTONIC_STAFF,163,-500,0),    -- All Pets - DMGMAGIC: -500 (-5%)
    (@CHTONIC_STAFF,374,5,0),       -- All Pets - CURE_POTENCY: 5
    (@CHTONIC_STAFF,170,5,0);       -- All Pets - FASTCAST: 5

--
-- Update Base DMG on Weapons
--
UPDATE `item_weapon` SET `dmg` = 45 WHERE `itemId` = @MOEPAPA_MACE;   -- Moepapa Mace
UPDATE `item_weapon` SET `dmg` = 96 WHERE `itemId` = @ONEIROS_AXE;    -- Oneiros axe
UPDATE `item_weapon` SET `dmg` = 46 WHERE `itemId` = @TJUKURRPA_AXE;  -- Tjukurrpa Axe
UPDATE `item_weapon` SET `dmg` = 45 WHERE `itemId` = @CHTONIC_STAFF;  -- Chtonic Staff
UPDATE `item_weapon` SET `dmg` = 96 WHERE `itemId` = @ONEIROS_LANCE;  -- Oneiros lance
UPDATE `item_weapon` SET `dmg` = 27 WHERE `itemId` = @MUJIN_TANTO;    -- Mujin tanto
UPDATE `item_weapon` SET `dmg` = 38 WHERE `itemId` = @ONEIROS_KNIFE;  -- Oneiros knife
UPDATE `item_weapon` SET `dmg` = 79 WHERE `itemId` = @AIFES_BOW;      -- Aife's Bow

--
-- Update Item Latents
--
DELETE FROM `item_latents` WHERE `itemId` = @ONEIROS_RING;      -- Oneiros ring
DELETE FROM `item_latents` WHERE `itemId` = @ONEIROS_GRIP;      -- Oneiros grip
INSERT INTO `item_latents` VALUES (@ONEIROS_RING,288,1,55,100); -- Latent Effect: Double Attack +1% when MP > 100
INSERT INTO `item_latents` VALUES (@ONEIROS_GRIP,369,1,4,50);   -- Refresh MP <= 50%

--
-- Update Jobs on items
--
UPDATE item_equipment SET jobs = 2605043 WHERE itemid = @ONEIROS_CAPPA;       -- Add PUP to Oneiros Cappa
UPDATE item_equipment SET jobs = 2309859 WHERE itemid = @ONEIROS_EARRING;     -- Add MNK/RUN to Oneiros Earring
UPDATE item_equipment SET jobs = 2604019 WHERE itemid = @ONEIROS_TORQUE;      -- Add PUP to Oneiros Torque
UPDATE item_equipment SET jobs = 2140497 WHERE itemid = @ONEIROS_PEBBLE;      -- Add BLU to Oneiros Pebble
UPDATE item_equipment SET jobs = 72752   WHERE itemid = @ONEIROS_PEARL;       -- Add RDM/THF/SAM/NIN/COR to Oneiros Pearl
UPDATE item_equipment SET jobs = 71216   WHERE itemid = @ONEIROS_KNIFE;       -- Add COR to Oneiros Knife
UPDATE item_equipment SET jobs = 2505122 WHERE itemid = @RYUGA_SUNE_ATE;      -- Add NIN/PUP to Ryuga Sune-Ate
UPDATE item_equipment SET jobs = 68801   WHERE itemid = @KHTHONIOS_GLOVES;    -- Add COR to Khthonios Gloves
UPDATE item_equipment SET jobs = 2360608 WHERE itemid = @ONEIROS_CLUSTER;     -- Add BRD to Oneiros Cluster
UPDATE item_equipment SET jobs = 70688   WHERE itemid = @TJUKURRPA_MANTLE;    -- Add NIN/COR to Tjukurrpa Mantle
UPDATE item_equipment SET jobs = 8385    WHERE itemid = @TJUKURRPA_GAUNTLETS; -- Add DRG to Tjukurrpa Gauntlets
UPDATE item_equipment SET jobs = 2535715 WHERE itemid = @TJUKURRPA_BELT;      -- Add DRG/BLU/PUP to Tjukurrpa Belt
UPDATE item_equipment SET jobs = 3178565 WHERE itemid = @MOEPAPA_MACE;        -- Add BLU/RUN to Moepapa Mace
UPDATE item_equipment SET jobs = 1040    WHERE itemid = @AIFES_BOW;           -- Add RDM to Aife's Bow
UPDATE item_equipment SET jobs = 4194303 WHERE itemid = @AIFES_MANTLE;        -- Add All Jobs to Aife's Mantle
UPDATE item_equipment SET jobs = 1720860 WHERE itemid = @AIFES_PUMPS;         -- Add PUP to Aife's Pumps

DELETE FROM `item_basic` WHERE itemID IN (
    @FORGOTTEN_POUCH_HEAD, @FORGOTTEN_POUCH_BODY, @FORGOTTEN_POUCH_HANDS,
    @FORGOTTEN_POUCH_LEGS, @FORGOTTEN_POUCH_FEET
);

DELETE FROM item_usable
WHERE itemID IN(
    @FORGOTTEN_POUCH_HEAD, @FORGOTTEN_POUCH_BODY, @FORGOTTEN_POUCH_HANDS,
    @FORGOTTEN_POUCH_LEGS, @FORGOTTEN_POUCH_FEET
);

INSERT INTO `item_basic` VALUES (@FORGOTTEN_POUCH_HEAD,  0, 'pouch_of_forgotten_thoughts', 'frgtn._pouch_(head)',  99, 30296, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@FORGOTTEN_POUCH_BODY,  0, 'pouch_of_forgotten_hopes',    'frgtn._pouch_(body)',  99, 30296, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@FORGOTTEN_POUCH_HANDS, 0, 'pouch_of_forgotten_touches',  'frgtn._pouch_(hands)', 99, 30296, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@FORGOTTEN_POUCH_LEGS,  0, 'pouch_of_forgotten_journeys', 'frgtn._pouch_(legs)',  99, 30296, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@FORGOTTEN_POUCH_FEET,  0, 'pouch_of_forgotten_steps',    'frgtn._pouch_(feet)',  99, 30296, 0, 1, 0);

INSERT INTO `item_usable` VALUES (@FORGOTTEN_POUCH_HEAD,  'frgtn._pouch_(head)',  1, 1, 0, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@FORGOTTEN_POUCH_BODY,  'frgtn._pouch_(body)',  1, 1, 0, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@FORGOTTEN_POUCH_HANDS, 'frgtn._pouch_(hands)', 1, 1, 0, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@FORGOTTEN_POUCH_LEGS,  'frgtn._pouch_(legs)',  1, 1, 0, 0, 0, 0, 0, 0);
INSERT INTO `item_usable` VALUES (@FORGOTTEN_POUCH_FEET,  'frgtn._pouch_(feet)',  1, 1, 0, 0, 0, 0, 0, 0);

-- Set levels and rewrite item names
UPDATE item_equipment SET level = 75, ilevel = 0
WHERE itemId IN (
    @BAGUA_GALERO_1,
    @BAGUA_TUNIC_1,
    @BAGUA_MITAINES_1,
    @BAGUA_PANTS_1,
    @BAGUA_SANDALS_1,
    @FUTHARK_BANDEAU_1,
    @FUTHARK_COAT_1,
    @FUTHARK_MITONS_1,
    @FUTHARK_TROUSERS_1,
    @FUTHARK_BOOTS_1
);

UPDATE item_equipment SET level = 70, ilevel = 0
WHERE itemId IN (
    @BAGUA_SASH,
    @FUTHARK_CAPE
);

UPDATE item_equipment SET jobs = 1048576, name = "bagua_sash"   WHERE itemId = @BAGUA_SASH;
UPDATE item_equipment SET jobs = 2097152, name = "futhark_cape" WHERE itemId = @FUTHARK_CAPE;

DELETE FROM `item_basic` WHERE itemID IN (
    @BAGUA_SASH,
    @FUTHARK_CAPE
);

INSERT INTO `item_basic` VALUES (@BAGUA_SASH,   0, 'bagua_sash',   'bagua_sash',   1, 63572, 0, 1, 0);
INSERT INTO `item_basic` VALUES (@FUTHARK_CAPE, 0, 'futhark_cape', 'futhark_cape', 1, 63572, 0, 1, 0);

-- Delete all item_mods and item_mods_pet rows for Relic +1 items
DELETE FROM item_mods
WHERE itemId IN (
    @BAGUA_GALERO_1,
    @BAGUA_TUNIC_1,
    @BAGUA_MITAINES_1,
    @BAGUA_PANTS_1,
    @BAGUA_SANDALS_1,
    @BAGUA_SASH,
    @FUTHARK_BANDEAU_1,
    @FUTHARK_COAT_1,
    @FUTHARK_MITONS_1,
    @FUTHARK_TROUSERS_1,
    @FUTHARK_BOOTS_1,
    @FUTHARK_CAPE
);

DELETE FROM item_mods_pet WHERE itemId = @BAGUA_SANDALS_1;

--
-- Geomancer
--
INSERT INTO item_mods (itemId, modId, Value)
VALUES
    (@BAGUA_GALERO_1,1,26),    -- DEF: 26
    (@BAGUA_GALERO_1,5,30),    -- MP+30
    (@BAGUA_GALERO_1,12,5),    -- INT+5
    (@BAGUA_GALERO_1,13,5),    -- MND+5
    (@BAGUA_GALERO_1,315,21),  -- “Drain” and “Aspir” potency +21

    (@BAGUA_TUNIC_1,1,44),     -- DEF: 44
    (@BAGUA_TUNIC_1,2,20),     -- HP+20
    (@BAGUA_TUNIC_1,5,20),     -- MP+20
    (@BAGUA_TUNIC_1,28,6),     -- “Magic Attack Bonus” +6
    (@BAGUA_TUNIC_1,123,11),   -- Geomancy skill +11

    (@BAGUA_MITAINES_1,1,18),  -- DEF: 18
    (@BAGUA_MITAINES_1,5,26),  -- MP+26
    (@BAGUA_MITAINES_1,369,1), -- “Refresh" +1
    (@BAGUA_MITAINES_1,370,1), -- “Regen" +1
    (@BAGUA_MITAINES_1,901,7), -- Elemental Magic casting time -7%

    (@BAGUA_PANTS_1,1,32),     -- DEF: 32
    (@BAGUA_PANTS_1,5,25),     -- MP+25
    (@BAGUA_PANTS_1,12,7),     -- INT+7
    (@BAGUA_PANTS_1,13,4),     -- MND+4
    (@BAGUA_PANTS_1,960,15),   -- “Indicolure” spell duration +15

    (@BAGUA_SANDALS_1,1,17),   -- DEF: 17
    (@BAGUA_SANDALS_1,5,23),   -- MP+23
    (@BAGUA_SANDALS_1,13,4),   -- MND+4
    (@BAGUA_SANDALS_1,114,16), -- Enfeebling magic skill +16

    (@BAGUA_SASH,1,6),         -- DEF: 6
    (@BAGUA_SASH,5,20),        -- MP+20
    (@BAGUA_SASH,12,5),        -- INT+5
    (@BAGUA_SASH,13,5),        -- MND+5
    (@BAGUA_SASH,29,2);        -- MDEF: 2

INSERT INTO item_mods_pet VALUES
    (@BAGUA_SANDALS_1,370,2,8), -- Luopan: “Regen”+2
    (@BAGUA_SASH,160,-200,8);   -- Luopan: Damage taken -2%

--
-- Runefencer
--
INSERT INTO item_mods (itemId, modId, Value)
VALUES
    -- Futhark Bandeau +1
    (@FUTHARK_BANDEAU_1,1,29),      -- DEF: 29
    (@FUTHARK_BANDEAU_1,2,18),      -- HP+18
    (@FUTHARK_BANDEAU_1,5,18),      -- MP+18
    (@FUTHARK_BANDEAU_1,8,7),       -- STR+7
    (@FUTHARK_BANDEAU_1,384,400),   -- Haste +4%
    (@FUTHARK_BANDEAU_1,1004,10),   -- Enhances "Battuta" effect

    -- Futhark Coat +1
    (@FUTHARK_COAT_1,1,53),       -- DEF: 53
    (@FUTHARK_COAT_1,2,22),       -- HP+22
    (@FUTHARK_COAT_1,5,22),       -- MP+22
    (@FUTHARK_COAT_1,8,8),        -- STR+8
    (@FUTHARK_COAT_1,10,8),       -- VIT+8
    (@FUTHARK_COAT_1,31,10),      -- Magic Evasion +10
    (@FUTHARK_COAT_1,516,5),      -- Converts 5% of physical damage taken to MP

    -- Futhark Mitons +1
    (@FUTHARK_MITONS_1,1,21),     -- DEF: 21
    (@FUTHARK_MITONS_1,2,24),     -- HP+24
    (@FUTHARK_MITONS_1,9,8),      -- DEX+8
    (@FUTHARK_MITONS_1,1008,4),   -- "Swordplay" +4
    (@FUTHARK_MITONS_1,1006,10),  -- Enhances "Sleight of Sword" effect

    -- Futhark Trousers +1
    (@FUTHARK_TROUSERS_1,1,42),   -- DEF: 42
    (@FUTHARK_TROUSERS_1,2,27),   -- HP+27
    (@FUTHARK_TROUSERS_1,5,27),   -- MP+27
    (@FUTHARK_TROUSERS_1,10,8),   -- VIT+8
    (@FUTHARK_TROUSERS_1,9,8),    -- DEX+8
    (@FUTHARK_TROUSERS_1,890,12), -- Enhancing magic duration +12
    (@FUTHARK_TROUSERS_1,170,10), -- Enhances "Fast Cast" effect +10%

    -- Futhark Boots +1
    (@FUTHARK_BOOTS_1,1,20),      -- DEF: 20
    (@FUTHARK_BOOTS_1,5,28),      -- MP+28
    (@FUTHARK_BOOTS_1,8,6),       -- STR+6
    (@FUTHARK_BOOTS_1,9,6),       -- DEX+6
    (@FUTHARK_BOOTS_1,384,400),     -- Haste +4%
    (@FUTHARK_BOOTS_1,110,15),    -- Parrying skill +16

    (@FUTHARK_CAPE,1,12), -- DEF: 12
    (@FUTHARK_CAPE,11,5), -- AGI: 5
    (@FUTHARK_CAPE,25,5), -- ACC: 5
    (@FUTHARK_CAPE,23,5), -- ATT: 5
    (@FUTHARK_CAPE,29,2), -- MDEF: 2
    (@FUTHARK_CAPE,27,3); -- ENMITY: 3
