-- Dynamis 2.0 (AKA "Neo Dynamis") SQL drop file. Made with love by Spicyryan.

-- Base Notes
-- Corrects several aspects to be more retail accurate. Mostly from ordinary foes. Such as better pooling base armor or forgotten drops or removing incorrect ones. 
-- Certain base elements aren't retail accurate. For instance each city zone should have a certain monster grouping to a drop pool for the NM spawn items.
-- -This was not done by either LSB or myself. Instead city zones NM spawn items are pooled instead of 1 per particular group.

-- Custom CatsEyeXI notes.
-- Customizes the content after this to be a custom event for our server where players earn Rank Points and spend forgotten items/currency to augment/upgrade Relic Armor.
-- Mantains the previous VNM drops added to Dynamis 1.0 long ago.
-- Bead pouches and NM drop rates are custom, and based around a difficulty curve made up in a spreadsheet designing this event.
-- -Bead pouches have the same rate as a cotton coin purse.

-- Variables
SET @ALWAYS = 1000;  -- Always, 100%
SET @VCOMMON = 240;  -- Very common, 24%
SET @COMMON = 150;   -- Common, 15%
SET @UNCOMMON = 100; -- Uncommon, 10%
SET @RARE = 50;      -- Rare, 5%
SET @VRARE = 10;     -- Very rare, 1%
SET @SRARE = 5;      -- Super Rare, 0.5%
SET @URARE = 1;      -- Ultra rare, 0.1%

-- Forgotten Pouches (Drops 3~15) Average return is 9
SET @FORGOTTEN_POUCH_HEAD  = 6541;
SET @FORGOTTEN_POUCH_BODY  = 6542;
SET @FORGOTTEN_POUCH_HANDS = 6543;
SET @FORGOTTEN_POUCH_LEGS  = 6544;
SET @FORGOTTEN_POUCH_FEET  = 6545;

-- --------------------------------------------------------------------
--                         Dynamis-San d`Oria                       --
-- --------------------------------------------------------------------

-- Ensure we're clearing out the old drop lists
DELETE FROM `mob_droplist` WHERE dropid =  "237"; -- Delete Battlechoir, Soulsender, Wyrmgnasher
DELETE FROM `mob_droplist` WHERE dropid = "2083"; -- Delete Reapertongue Gadgquok
DELETE FROM `mob_droplist` WHERE dropid = "2584"; -- Delete Voidstreaker Butchnotch
DELETE FROM `mob_droplist` WHERE dropid = "2548"; -- Delete Vanguard Amputator
DELETE FROM `mob_droplist` WHERE dropid = "2562"; -- Delete Neckchopper, Backstabber, Dollmaster
DELETE FROM `mob_droplist` WHERE dropid = "2564"; -- Delete Footsoldier, Vexer, Pillager, Predator
DELETE FROM `mob_droplist` WHERE dropid = "3148"; -- Delete Mesmerizer, Hawker, Impaler
DELETE FROM `mob_droplist` WHERE dropid = "3149"; -- Delete Trooper, Grappler, Gutslasher
DELETE FROM `mob_droplist` WHERE dropid = "1967"; -- Delete Overlords Tombstone
DELETE FROM `mob_droplist` WHERE dropid = "3109"; -- Delete Bladeburner Rokgevok
DELETE FROM `mob_droplist` WHERE dropid = "3110"; -- Delete Steelshank Kratzvatz
DELETE FROM `mob_droplist` WHERE dropid = "3111"; -- Delete Bloodfist Voshgrosh
DELETE FROM `mob_droplist` WHERE dropid = "3112"; -- Delete Spellspear Djokvukk
DELETE FROM `mob_droplist` WHERE dropid = "3113"; -- Delete Arch Overlords Tombstone NQ
DELETE FROM `mob_droplist` WHERE dropid = "3951"; -- Delete Arch Overlords Tombstone HQ

-- Assign drop lists to bosses
UPDATE `mob_groups` SET `dropid` = 0    WHERE name = 'Battlechoir_Gitchfotch' AND zoneid = 185;
UPDATE `mob_groups` SET `dropid` = 0    WHERE name = 'Soulsender_Fugbrag' AND zoneid = 185;
UPDATE `mob_groups` SET `dropid` = 1967 WHERE name = 'Overlords_Tombstone' AND zoneid = 185;
UPDATE `mob_groups` SET `dropid` = 3109 WHERE name = 'Bladeburner_Rokgevok' AND zoneid = 185;
UPDATE `mob_groups` SET `dropid` = 3110 WHERE name = 'Steelshank_Kratzvatz' AND zoneid = 185;
UPDATE `mob_groups` SET `dropid` = 3111 WHERE name = 'Bloodfist_Voshgrosh' AND zoneid = 185;
UPDATE `mob_groups` SET `dropid` = 3112 WHERE name = 'Spellspear_Djokvukk' AND zoneid = 185;
UPDATE `mob_groups` SET `dropid` = 3113 WHERE name = 'Arch_Overlord_Tombstone' AND zoneid = 185; -- NQ
UPDATE `mob_groups` SET `dropid` = 3951 WHERE name = 'Arch_Overlord_Tombstone' AND zoneid = 185; -- HQ

-- ZoneID: 185 - Battlechoir Gitchfotch (Spawns with Overlord Tombstone, Drop ID 0, drops nothing)
-- ZoneID: 185 - Soulsender Fugbrag (Spawns with Overlord Tombstone, Drop ID 0, drops nothing)
-- ZoneID: 185 - Wyrmgnasher Bjakdek (Roams Ramparts)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,3353,@VCOMMON);                     -- Barbaric Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,1452,@COMMON);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,1452,@COMMON);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,1452,@COMMON);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,1452,@COMMON);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,1452,@COMMON);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,1453,@RARE);                        -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,1516,80);                           -- Griffon Hide (8.0%)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,1517,80);                           -- Giant Frozen Head (8.0%)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,1519,80);                           -- Fresh Orc Liver (8.0%)
INSERT INTO `mob_droplist` VALUES (237,1,3,20,18290,250);                           -- Relic Bhuj (2.0%)
INSERT INTO `mob_droplist` VALUES (237,1,3,20,18296,250);                           -- Relic Lance (2.0%)
INSERT INTO `mob_droplist` VALUES (237,1,3,20,18308,250);                           -- Ihintanto (2.0%)
INSERT INTO `mob_droplist` VALUES (237,1,3,20,18332,250);                           -- Relic Gun (2.0%)
INSERT INTO `mob_droplist` VALUES (237,0,0,1000,3495,@UNCOMMON);                    -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15074,91);                     -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15081,91);                     -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15108,91);                     -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15118,91);                     -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15125,91);                     -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15127,91);                     -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15129,91);                     -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15132,91);                     -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15136,91);                     -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15146,91);                     -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,1,@UNCOMMON,15145,90);                     -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,2,@UNCOMMON,15040,200);                    -- Argute Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,2,@UNCOMMON,11388,200);                    -- Pantin Babouches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,2,@UNCOMMON,15025,200);                    -- Mirage Bazubands (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,2,@UNCOMMON,16349,200);                    -- Commodore Trews (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,1,2,@UNCOMMON,27016,200);                    -- Bagua Mitaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (237,2,0,1000,1452,0);       	                    -- Ordelle Bronzepiece (Steal)
    
-- ZoneID: 185 - Reapertongue Gadgquok  
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,3353,@VCOMMON);                    -- Barbaric Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,1453,@RARE);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,1516,80);                          -- Griffon Hide (8.0%)
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,1517,80);                          -- Giant Frozen Head (8.0%)
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,1519,80);                          -- Fresh Orc Liver (8.0%)
INSERT INTO `mob_droplist` VALUES (2083,1,3,20,18290,250);                          -- Relic Bhuj (2.0%)
INSERT INTO `mob_droplist` VALUES (2083,1,3,20,18296,250);                          -- Relic Lance (2.0%)
INSERT INTO `mob_droplist` VALUES (2083,1,3,20,18308,250);                          -- Ihintanto (2.0%)
INSERT INTO `mob_droplist` VALUES (2083,1,3,20,18332,250);                          -- Relic Gun (2.0%)
INSERT INTO `mob_droplist` VALUES (2083,0,0,1000,3495,@UNCOMMON);                   -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15074,91);                    -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15081,91);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15108,91);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15118,91);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15125,91);                    -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15127,91);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15129,91);                    -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15132,91);                    -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15136,91);                    -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15146,91);                    -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,1,@UNCOMMON,15145,90);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,2,@UNCOMMON,15040,200);                   -- Argute Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,2,@UNCOMMON,11388,200);                   -- Pantin Babouches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,2,@UNCOMMON,15025,200);                   -- Mirage Bazubands (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,2,@UNCOMMON,16349,200);                   -- Commodore Trews (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,1,2,@UNCOMMON,27016,200);                   -- Bagua Mitaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2083,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
    
-- ZoneID: 185 - Voidstreaker Butchnotch    
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,3353,@COMMON);                     -- Barbaric Bijou (Common, 15%) -- Spawns at pop spot. Reduced rate to balance spam farm.
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,1453,@RARE);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,1516,@UNCOMMON);                   -- Griffon Hide (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,1517,@UNCOMMON);                   -- Giant Frozen Head (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,1519,@UNCOMMON);                   -- Fresh Orc Liver (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,3,20,18290,250);                          -- Relic Bhuj (2.0%)
INSERT INTO `mob_droplist` VALUES (2584,1,3,20,18296,250);                          -- Relic Lance (2.0%)
INSERT INTO `mob_droplist` VALUES (2584,1,3,20,18308,250);                          -- Ihintanto (2.0%)
INSERT INTO `mob_droplist` VALUES (2584,1,3,20,18332,250);                          -- Relic Gun (2.0%)
INSERT INTO `mob_droplist` VALUES (2584,0,0,1000,3495,@UNCOMMON);                   -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15074,91);                    -- Clerics Cap Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15081,91);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15108,91);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15118,91);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15125,91);                    -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15127,91);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15129,91);                    -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15132,91);                    -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15136,91);                    -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15146,91);                    -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,1,@UNCOMMON,15145,90);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,2,@UNCOMMON,15040,200);                   -- Argute Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,2,@UNCOMMON,11388,200);                   -- Pantin Babouches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,2,@UNCOMMON,15025,200);                   -- Mirage Bazubands (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,2,@UNCOMMON,16349,200);                   -- Commodore Trews (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,1,2,@UNCOMMON,27016,200);                   -- Bagua Mitaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2584,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
    
-- ZoneID: 185 - Vanguard Amputator 
-- ZoneID: 185 - Vanguard Amputator 
INSERT INTO `mob_droplist` VALUES (2548,0,0,1000,1516,@UNCOMMON);                   -- Griffon Hide (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,0,0,1000,1517,@UNCOMMON);                   -- Giant Frozen Head (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,0,0,1000,1519,@UNCOMMON);                   -- Fresh Orc Liver (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,5,20,18290,250);     	                    -- Relic Bhuj (2.0%)
INSERT INTO `mob_droplist` VALUES (2548,1,5,20,18296,250);     	                    -- Relic Lance (2.0%)
INSERT INTO `mob_droplist` VALUES (2548,1,5,20,18308,250);     	                    -- Ihintanto (2.0%)
INSERT INTO `mob_droplist` VALUES (2548,1,5,20,18332,250);     	                    -- Relic Gun (2.0%)
INSERT INTO `mob_droplist` VALUES (2548,1,1,@UNCOMMON,3382,500);                    -- Odious Cryptex (4%)
INSERT INTO `mob_droplist` VALUES (2548,1,1,@UNCOMMON,3380,500);                    -- Odious Scale (4%)
INSERT INTO `mob_droplist` VALUES (2548,1,2,@UNCOMMON,3383,500);                    -- Odious Strongbox (4%)
INSERT INTO `mob_droplist` VALUES (2548,1,2,@UNCOMMON,3381,500);                    -- Square Of Odious Leather (4%)
INSERT INTO `mob_droplist` VALUES (2548,0,0,1000,3495,@UNCOMMON);                   -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15074,91);                    -- Clerics Cap Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15081,91);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15108,91);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15118,91);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15125,91);                    -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15127,91);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15129,91);                    -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15132,91);                    -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15136,91);                    -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15146,91);                    -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,3,@UNCOMMON,15145,90);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,4,@UNCOMMON,15040,200);                   -- Argute Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,4,@UNCOMMON,11388,200);                   -- Pantin Babouches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,4,@UNCOMMON,15025,200);                   -- Mirage Bazubands (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,4,@UNCOMMON,16349,200);                   -- Commodore Trews (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,1,4,@UNCOMMON,27016,200);                   -- Bagua Mitaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2548,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
    
-- ZoneID: 185 - Vanguard Neckchopper   
-- ZoneID: 185 - Vanguard Backstabber   
-- ZoneID: 185 - Vanguard Dollmaster    
-- ZoneID: 185 - Vanguard Neckchopper   
-- ZoneID: 185 - Vanguard Backstabber   
-- ZoneID: 185 - Vanguard Dollmaster    
INSERT INTO `mob_droplist` VALUES (2562,0,0,1000,1516,@UNCOMMON);                   -- Griffon Hide (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,0,0,1000,1517,@UNCOMMON);                   -- Giant Frozen Head (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,0,0,1000,1519,@UNCOMMON);                   -- Fresh Orc Liver (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,5,20,18290,250);     	                    -- Relic Bhuj (2.0%)
INSERT INTO `mob_droplist` VALUES (2562,1,5,20,18296,250);     	                    -- Relic Lance (2.0%)
INSERT INTO `mob_droplist` VALUES (2562,1,5,20,18308,250);     	                    -- Ihintanto (2.0%)
INSERT INTO `mob_droplist` VALUES (2562,1,5,20,18332,250);     	                    -- Relic Gun (2.0%)
INSERT INTO `mob_droplist` VALUES (2562,1,1,@UNCOMMON,3382,500);                    -- Odious Cryptex (4%)
INSERT INTO `mob_droplist` VALUES (2562,1,1,@UNCOMMON,3380,500);                    -- Odious Scale (4%)
INSERT INTO `mob_droplist` VALUES (2562,1,2,@UNCOMMON,3383,500);                    -- Odious Strongbox (4%)
INSERT INTO `mob_droplist` VALUES (2562,1,2,@UNCOMMON,3381,500);                    -- Square Of Odious Leather (4%)
INSERT INTO `mob_droplist` VALUES (2562,0,0,1000,3495,@UNCOMMON);                   -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15074,91);                    -- Clerics Cap Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15081,91);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15108,91);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15118,91);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15125,91);                    -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15127,91);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15129,91);                    -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15132,91);                    -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15136,91);                    -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15146,91);                    -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,3,@UNCOMMON,15145,90);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,4,@UNCOMMON,15040,200);                   -- Argute Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,4,@UNCOMMON,11388,200);                   -- Pantin Babouches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,4,@UNCOMMON,15025,200);                   -- Mirage Bazubands (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,4,@UNCOMMON,16349,200);                   -- Commodore Trews (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,1,4,@UNCOMMON,27016,200);                   -- Bagua Mitaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2562,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
    
-- ZoneID: 185 - Vanguard Footsoldier   
-- ZoneID: 185 - Vanguard Vexer 
-- ZoneID: 185 - Vanguard Pillager  
-- ZoneID: 185 - Vanguard Predator  
-- ZoneID: 185 - Vanguard Footsoldier   
-- ZoneID: 185 - Vanguard Vexer 
-- ZoneID: 185 - Vanguard Pillager  
-- ZoneID: 185 - Vanguard Predator  
INSERT INTO `mob_droplist` VALUES (2564,0,0,1000,1516,@UNCOMMON);                   -- Griffon Hide (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,0,0,1000,1517,@UNCOMMON);                   -- Giant Frozen Head (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,0,0,1000,1519,@UNCOMMON);                   -- Fresh Orc Liver (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,5,20,18290,250);     	                    -- Relic Bhuj (2.0%)
INSERT INTO `mob_droplist` VALUES (2564,1,5,20,18296,250);     	                    -- Relic Lance (2.0%)
INSERT INTO `mob_droplist` VALUES (2564,1,5,20,18308,250);     	                    -- Ihintanto (2.0%)
INSERT INTO `mob_droplist` VALUES (2564,1,5,20,18332,250);     	                    -- Relic Gun (2.0%)
INSERT INTO `mob_droplist` VALUES (2564,1,1,@UNCOMMON,3382,500);                    -- Odious Cryptex (4%)
INSERT INTO `mob_droplist` VALUES (2564,1,1,@UNCOMMON,3380,500);                    -- Odious Scale (4%)
INSERT INTO `mob_droplist` VALUES (2564,1,2,@UNCOMMON,3383,500);                    -- Odious Strongbox (4%)
INSERT INTO `mob_droplist` VALUES (2564,1,2,@UNCOMMON,3381,500);                    -- Square Of Odious Leather (4%)
INSERT INTO `mob_droplist` VALUES (2564,0,0,1000,3495,@UNCOMMON);                   -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15074,91);                    -- Clerics Cap Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15081,91);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15108,91);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15118,91);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15125,91);                    -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15127,91);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15129,91);                    -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15132,91);                    -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15136,91);                    -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15146,91);                    -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,3,@UNCOMMON,15145,90);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,4,@UNCOMMON,15040,200);                   -- Argute Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,4,@UNCOMMON,11388,200);                   -- Pantin Babouches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,4,@UNCOMMON,15025,200);                   -- Mirage Bazubands (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,4,@UNCOMMON,16349,200);                   -- Commodore Trews (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,1,4,@UNCOMMON,27016,200);                   -- Bagua Mitaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2564,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
    
-- ZoneID: 185 - Vanguard Mesmerizer    
-- ZoneID: 185 - Vanguard Impaler   
-- ZoneID: 185 - Vanguard Hawker    
-- ZoneID: 185 - Vanguard Mesmerizer    
-- ZoneID: 185 - Vanguard Hawker    
-- ZoneID: 185 - Vanguard Impaler   
INSERT INTO `mob_droplist` VALUES (3148,0,0,1000,1516,@UNCOMMON);                   -- Griffon Hide (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,0,0,1000,1517,@UNCOMMON);                   -- Giant Frozen Head (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,0,0,1000,1519,@UNCOMMON);                   -- Fresh Orc Liver (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,5,20,18290,250);                          -- Relic Bhuj (2.0%)
INSERT INTO `mob_droplist` VALUES (3148,1,5,20,18296,250);                          -- Relic Lance (2.0%)
INSERT INTO `mob_droplist` VALUES (3148,1,5,20,18308,250);                          -- Ihintanto (2.0%)
INSERT INTO `mob_droplist` VALUES (3148,1,5,20,18332,250);                          -- Relic Gun (2.0%)
INSERT INTO `mob_droplist` VALUES (3148,1,1,@UNCOMMON,3382,500);                    -- Odious Cryptex (4%)
INSERT INTO `mob_droplist` VALUES (3148,1,1,@UNCOMMON,3380,500);                    -- Odious Scale (4%)
INSERT INTO `mob_droplist` VALUES (3148,1,2,@UNCOMMON,3383,500);                    -- Odious Strongbox (4%)
INSERT INTO `mob_droplist` VALUES (3148,1,2,@UNCOMMON,3381,500);                    -- Square Of Odious Leather (4%)
INSERT INTO `mob_droplist` VALUES (3148,0,0,1000,3495,@UNCOMMON);                   -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15074,91);                    -- Clerics Cap Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15081,91);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15108,91);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15118,91);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15125,91);                    -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15127,91);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15129,91);                    -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15132,91);                    -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15136,91);                    -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15146,91);                    -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,3,@UNCOMMON,15145,90);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,4,@UNCOMMON,15040,200);                   -- Argute Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,4,@UNCOMMON,11388,200);                   -- Pantin Babouches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,4,@UNCOMMON,15025,200);                   -- Mirage Bazubands (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,4,@UNCOMMON,16349,200);                   -- Commodore Trews (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,1,4,@UNCOMMON,27016,200);                   -- Bagua Mitaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3148,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
    
-- ZoneID: 185 - Vanguard Trooper   
-- ZoneID: 185 - Vanguard Grappler  
-- ZoneID: 185 - Vanguard Bugler    
-- ZoneID: 185 - Vanguard Gutslasher    
-- ZoneID: 185 - Vanguard Grappler  
-- ZoneID: 185 - Vanguard Trooper   
-- ZoneID: 185 - Vanguard Bugler    
-- ZoneID: 185 - Vanguard Gutslasher    
INSERT INTO `mob_droplist` VALUES (3149,0,0,1000,1516,@UNCOMMON);                   -- Griffon Hide (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,0,0,1000,1517,@UNCOMMON);                   -- Giant Frozen Head (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,0,0,1000,1519,@UNCOMMON);                   -- Fresh Orc Liver (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,5,20,18290,250);                          -- Relic Bhuj (2.0%)
INSERT INTO `mob_droplist` VALUES (3149,1,5,20,18296,250);                          -- Relic Lance (2.0%)
INSERT INTO `mob_droplist` VALUES (3149,1,5,20,18308,250);                          -- Ihintanto (2.0%)
INSERT INTO `mob_droplist` VALUES (3149,1,5,20,18332,250);                          -- Relic Gun (2.0%)
INSERT INTO `mob_droplist` VALUES (3149,1,1,@UNCOMMON,3382,500);                    -- Odious Cryptex (4%)
INSERT INTO `mob_droplist` VALUES (3149,1,1,@UNCOMMON,3380,500);                    -- Odious Scale (4%)
INSERT INTO `mob_droplist` VALUES (3149,1,2,@UNCOMMON,3383,500);                    -- Odious Strongbox (4%)
INSERT INTO `mob_droplist` VALUES (3149,1,2,@UNCOMMON,3381,500);                    -- Square Of Odious Leather (4%)
INSERT INTO `mob_droplist` VALUES (3149,0,0,1000,3495,@UNCOMMON);                   -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15074,91);                    -- Clerics Cap Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15081,91);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15108,91);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15118,91);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15125,91);                    -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15127,91);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15129,91);                    -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15132,91);                    -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15136,91);                    -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15146,91);                    -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,3,@UNCOMMON,15145,90);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,4,@UNCOMMON,15040,200);                   -- Argute Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,4,@UNCOMMON,11388,200);                   -- Pantin Babouches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,4,@UNCOMMON,15025,200);                   -- Mirage Bazubands (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,4,@UNCOMMON,16349,200);                   -- Commodore Trews (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,1,4,@UNCOMMON,27016,200);                   -- Bagua Mitaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3149,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
    
-- ZoneID: 185 - Overlords Tombstone    
INSERT INTO `mob_droplist` VALUES (1967,0,0,1000,3404,@ALWAYS);                     -- Fiendish Tome Chapter 1 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1967,0,0,1000,1474,@COMMON);                     -- Infinity Core (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1967,1,1,1000,@FORGOTTEN_POUCH_HANDS,980);       -- Forgotten pouch touch (98%)
INSERT INTO `mob_droplist` VALUES (1967,1,1,1000,1453,@UNCOMMON);                   -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (1967,0,0,1000,11632,50);                         -- Overlord's Tombstone - karka_ring
INSERT INTO `mob_droplist` VALUES (1967,0,0,1000,2465,100);                         -- Overlord's Tombstone - rubber_cap
INSERT INTO `mob_droplist` VALUES (1967,0,0,1000,16054,100);                        -- Overlord's Tombstone - hirudinea_earring
INSERT INTO `mob_droplist` VALUES (1967,0,0,1000,11587,100);                        -- Overlord's Tombstone - nyx_gorget

-- ZoneID: 185 - Bladeburner Rokgevok
INSERT INTO `mob_droplist` VALUES (3109,0,0,1000,3405,@ALWAYS);                     -- Fiendish Tome Chapter 2 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3109,1,1,1000,11772,130);                        -- Oneiros Sash (13%)
INSERT INTO `mob_droplist` VALUES (3109,1,1,1000,@FORGOTTEN_POUCH_HANDS,870);       -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3109,1,2,1000,@FORGOTTEN_POUCH_HANDS,960);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3109,1,2,1000,1453,40);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3109,1,3,1000,@FORGOTTEN_POUCH_HANDS,960);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3109,1,3,1000,1453,40);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3109,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)

-- ZoneID: 185 - Steelshank Kratzvatz
INSERT INTO `mob_droplist` VALUES (3110,0,0,1000,3406,@ALWAYS);                     -- Fiendish Tome Chapter 3 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3110,1,1,1000,10972,130);                        -- Oneiros Cappa (13%)
INSERT INTO `mob_droplist` VALUES (3110,1,1,1000,@FORGOTTEN_POUCH_HANDS,870);       -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3110,1,2,1000,@FORGOTTEN_POUCH_HANDS,960);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3110,1,2,1000,1453,40);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3110,1,3,1000,@FORGOTTEN_POUCH_HANDS,960);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3110,1,3,1000,1453,40);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3110,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)

-- ZoneID: 185 - Bloodfist Voshgrosh
INSERT INTO `mob_droplist` VALUES (3111,0,0,1000,3407,@ALWAYS);                     -- Fiendish Tome Chapter 4 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3111,1,1,1000,11773,130);                        -- Oneiros Belt (13%)
INSERT INTO `mob_droplist` VALUES (3111,1,1,1000,@FORGOTTEN_POUCH_HANDS,870);       -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3111,1,2,1000,@FORGOTTEN_POUCH_HANDS,960);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3111,1,2,1000,1453,40);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3111,1,3,1000,@FORGOTTEN_POUCH_HANDS,960);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3111,1,3,1000,1453,40);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3111,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)

-- ZoneID: 185 - Spellspear Djokvukk
INSERT INTO `mob_droplist` VALUES (3112,0,0,1000,3408,@ALWAYS);                     -- Fiendish Tome Chapter 5 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3112,1,1,1000,10973,130);                        -- Oneiros Cape (13%)
INSERT INTO `mob_droplist` VALUES (3112,1,1,1000,@FORGOTTEN_POUCH_HANDS,870);       -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3112,1,2,1000,@FORGOTTEN_POUCH_HANDS,960);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3112,1,2,1000,1453,40);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3112,1,3,1000,@FORGOTTEN_POUCH_HANDS,960);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3112,1,3,1000,1453,40);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3112,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)

-- ZoneID:  185 - Arch Overlord Tombstone (NQ)
INSERT INTO `mob_droplist` VALUES (3113,0,0,1000,11774,@COMMON);                    -- Oneiros cest (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3113,0,0,1000,19790,@COMMON);                    -- Oneiros cest (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3113,0,0,1000,11816,@COMMON);                    -- Oneiros cest (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3113,0,0,1000,1474,250);                         -- Infinity core (25%)
INSERT INTO `mob_droplist` VALUES (3113,1,1,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3113,1,1,1000,1453,50);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3113,1,2,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3113,1,2,1000,1453,50);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3113,1,3,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3113,1,3,1000,1453,50);                          -- Montiont Silverpiece (5%)

-- ZoneID:  185 - Arch Overlord Tombstone (HQ/White Proc)
INSERT INTO `mob_droplist` VALUES (3951,0,0,1000,11774,200);                        -- Oneiros cest (20%)
INSERT INTO `mob_droplist` VALUES (3951,0,0,1000,19790,200);                        -- Oneiros lance (20%)
INSERT INTO `mob_droplist` VALUES (3951,0,0,1000,11816,200);                        -- Oneiros helm (20%)
INSERT INTO `mob_droplist` VALUES (3951,0,0,1000,1474,500);                         -- Infinity core (50%)
INSERT INTO `mob_droplist` VALUES (3951,0,0,1000,@FORGOTTEN_POUCH_HANDS,@ALWAYS);   -- Forgotten pouch touch (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3951,1,1,1000,@FORGOTTEN_POUCH_HANDS,925);       -- Forgotten pouch touch (92.%)
INSERT INTO `mob_droplist` VALUES (3951,1,1,1000,1453,75);                          -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3951,1,2,1000,@FORGOTTEN_POUCH_HANDS,925);       -- Forgotten pouch touch (92.5%)
INSERT INTO `mob_droplist` VALUES (3951,1,2,1000,1453,75);                          -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3951,1,3,1000,@FORGOTTEN_POUCH_HANDS,925);       -- Forgotten pouch touch (92.5%)
INSERT INTO `mob_droplist` VALUES (3951,1,3,1000,1453,75);                          -- Montiont Silverpiece (7.5%)

-- --------------------------------------------------------------------
--                          Dynamis-Bastok                          --
-- --------------------------------------------------------------------

-- Ensure we're clearing out the old drop lists
DELETE FROM `mob_droplist` WHERE dropid = "2558"; -- Delete Quadavs
DELETE FROM `mob_droplist` WHERE dropid = "2907"; -- Delete Noondozer, Fallsplitter, Manameister, Cannonball
DELETE FROM `mob_droplist` WHERE dropid = "2906"; -- Delete Gudha Effigy
DELETE FROM `mob_droplist` WHERE dropid = "3949"; -- Delete Vazhe Pummelsong
DELETE FROM `mob_droplist` WHERE dropid = "3958"; -- Delete ZoPha Forgesoul
DELETE FROM `mob_droplist` WHERE dropid = "3959"; -- Delete RaGho Darkfount
DELETE FROM `mob_droplist` WHERE dropid = "3960"; -- Delete BuBho Truesteel
DELETE FROM `mob_droplist` WHERE dropid = "3961"; -- Delete Arch GuDha Effigy NQ
DELETE FROM `mob_droplist` WHERE dropid = "3962"; -- Delete Arch GuDha Effigy HQ

UPDATE `mob_groups` SET `dropid` = 2906 WHERE name = 'Gudha_Effigy' AND zoneid = 186;
UPDATE `mob_groups` SET `dropid` = 3949 WHERE name = 'Vazhe_Pummelsong' AND zoneid = 186;
UPDATE `mob_groups` SET `dropid` = 3958 WHERE name = 'ZoPha_Forgesoul' AND zoneid = 186;
UPDATE `mob_groups` SET `dropid` = 3959 WHERE name = 'RaGho_Darkfount' AND zoneid = 186;
UPDATE `mob_groups` SET `dropid` = 3960 WHERE name = 'BuBho_Truesteel' AND zoneid = 186;
UPDATE `mob_groups` SET `dropid` = 3961 WHERE name = 'Arch_GuDha_Effigy' AND zoneid = 186; -- NQ
UPDATE `mob_groups` SET `dropid` = 3962 WHERE name = 'Arch_GuDha_Effigy' AND zoneid = 186; -- HQ

-- ZoneID: 186 - Vanguard Vindicator
-- ZoneID: 186 - Vanguard Militant
-- ZoneID: 186 - Vanguard Beasttender
-- ZoneID: 186 - Vanguard Thaumaturge
-- ZoneID: 186 - Vanguard Protector
-- ZoneID: 186 - Vanguard Purloiner
-- ZoneID: 186 - Vanguard Vigilante
-- ZoneID: 186 - Vanguard Defender
-- ZoneID: 186 - Vanguard Constable
-- ZoneID: 186 - Vanguard Hatamoto
-- ZoneID: 186 - Vanguard Kusa
-- ZoneID: 186 - Vanguard Drakekeeper
-- ZoneID: 186 - Vanguard Minstrel
-- ZoneID: 186 - Vanguard Mason
-- ZoneID: 186 - Vanguard Undertaker
-- ZoneID: 186 - Vanguard Vindicator
-- ZoneID: 186 - Vanguard Militant
-- ZoneID: 186 - Vanguard Constable
-- ZoneID: 186 - Vanguard Thaumaturge
-- ZoneID: 186 - Vanguard Protector
-- ZoneID: 186 - Vanguard Defender
-- ZoneID: 186 - Vanguard Beasttender
-- ZoneID: 186 - Vanguard Drakekeeper
-- ZoneID: 186 - Vanguard Purloiner
-- ZoneID: 186 - Vanguard Vigilante
-- ZoneID: 186 - Vanguard Minstrel
-- ZoneID: 186 - Vanguard Hatamoto
-- ZoneID: 186 - Vanguard Mason
-- ZoneID: 186 - Vanguard Kusa
-- ZoneID: 186 - Vanguard Undertaker
-- ZoneID: 186 - Vanguard Defender
INSERT INTO `mob_droplist` VALUES (2558,0,0,1000,1469,@UNCOMMON);                  -- Chunk Of Wootz Ore (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,0,0,1000,1470,@UNCOMMON);                  -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,0,0,1000,1521,@UNCOMMON);                  -- Vial Of Slime Juice (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,5,20,18278,250);                         -- Relic Blade (2.0%)
INSERT INTO `mob_droplist` VALUES (2558,1,5,20,18284,250);                         -- Relic Axe (2.0%)
INSERT INTO `mob_droplist` VALUES (2558,1,5,20,18302,250);                         -- Relic Scythe (2.0%)
INSERT INTO `mob_droplist` VALUES (2558,1,5,20,18314,250);                         -- Ito (2.0%)
INSERT INTO `mob_droplist` VALUES (2558,1,1,@UNCOMMON,3384,500);                   -- Odious Charm (4%)
INSERT INTO `mob_droplist` VALUES (2558,1,1,@UNCOMMON,3385,500);                   -- Odious Backscale (4%)
INSERT INTO `mob_droplist` VALUES (2558,1,2,@UNCOMMON,3386,500);                   -- Odious Engraving (4%)
INSERT INTO `mob_droplist` VALUES (2558,1,2,@UNCOMMON,3387,500);                   -- Odious Letterbox (4%)
INSERT INTO `mob_droplist` VALUES (2558,0,0,1000,3496,@UNCOMMON);                  -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15078,91);                   -- Valor Coronet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15092,91);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15095,91);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15106,91);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15111,91);                   -- Bards Cuffs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15113,91);                   -- Saotome Kote (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15116,91);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15120,91);                   -- Sorcerers Tonban (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15130,91);                   -- Wyrm Brais (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15133,91);                   -- Melee Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,3,@UNCOMMON,15139,90);                   -- Abyss Sollerets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,4,@UNCOMMON,11478,167);                  -- Etoile Tiara (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,4,@UNCOMMON,11385,167);                  -- Commodore Bottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,4,@UNCOMMON,16346,167);                  -- Mirage Shalwar (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,4,@UNCOMMON,16362,167);                  -- Argute Pants (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,4,@UNCOMMON,26666,166);                  -- Futhark Bandeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,1,4,@UNCOMMON,27192,166);                  -- Bagua Pants (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2558,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 186 - Gunhi Noondozer
-- ZoneID: 186 - Zevho Fallsplitter
-- ZoneID: 186 - Gipha Manameister
-- ZoneID: 186 - Kodho Cannonball
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,3354,@VCOMMON);                   -- Steelwall Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,1469,80);                         -- Chunk Of Wootz Ore (8.0%)
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,1470,80);                         -- Sparkling Stone (8.0%)
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,1521,80);                         -- Vial Of Slime Juice (8.0%)
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,1456,@RARE);                      -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2907,1,3,20,18278,250);                         -- Relic Blade (2.0%)
INSERT INTO `mob_droplist` VALUES (2907,1,3,20,18284,250);                         -- Relic Axe (2.0%)
INSERT INTO `mob_droplist` VALUES (2907,1,3,20,18302,250);                         -- Relic Scythe (2.0%)
INSERT INTO `mob_droplist` VALUES (2907,1,3,20,18314,250);                         -- Ito (2.0%)
INSERT INTO `mob_droplist` VALUES (2907,0,0,1000,3496,@UNCOMMON);                  -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15078,91);                   -- Valor Coronet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15092,91);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15095,91);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15106,91);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15111,91);                   -- Bards Cuffs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15113,91);                   -- Saotome Kote (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15116,91);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15120,91);                   -- Sorcerers Tonban (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15130,91);                   -- Wyrm Brais (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15133,91);                   -- Melee Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,1,@UNCOMMON,15139,90);                   -- Abyss Sollerets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,2,@UNCOMMON,11478,167);                  -- Etoile Tiara (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,2,@UNCOMMON,11385,167);                  -- Commodore Bottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,2,@UNCOMMON,16346,167);                  -- Mirage Shalwar (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,2,@UNCOMMON,16362,167);                  -- Argute Pants (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,2,@UNCOMMON,26666,166);                  -- Futhark Bandeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,1,2,@UNCOMMON,27192,166);                  -- Bagua Pants (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2907,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 186 - Gudha Effigy
INSERT INTO `mob_droplist` VALUES (2906,0,0,1000,3409,@ALWAYS);                     -- Fiendish Tome Chapter 6 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2906,0,0,1000,1474,@COMMON);                     -- Infinity Core (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2906,1,1,1000,@FORGOTTEN_POUCH_LEGS,980);        -- Forgotten pouch journey (98%)
INSERT INTO `mob_droplist` VALUES (2906,1,1,1000,1456,@UNCOMMON);                   -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2906,0,0,1000,16055,100);                        -- Gu'Dha Effigy - choreia_earring
INSERT INTO `mob_droplist` VALUES (2906,0,0,1000,16306,100);                        -- Gu'Dha Effigy - halting_stole
INSERT INTO `mob_droplist` VALUES (2906,0,0,1000,2469,100);                         -- Gu'Dha Effigy - rubber_soles
INSERT INTO `mob_droplist` VALUES (2906,0,0,1000,11630,50);                         -- Gu'Dha Effigy - corneus_ring

-- ZoneID:  186 - Zo'Pha Forgesoul
INSERT INTO `mob_droplist` VALUES (3958,0,0,1000,3410,@ALWAYS);                     -- Fiendish Tome: Chapter 7 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3958,1,1,1000,11775,130);                        -- Oneiros rope (13%)
INSERT INTO `mob_droplist` VALUES (3958,1,1,1000,@FORGOTTEN_POUCH_LEGS,870);        -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3958,1,2,1000,@FORGOTTEN_POUCH_LEGS,960);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3958,1,2,1000,1456,50);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3958,1,3,1000,@FORGOTTEN_POUCH_LEGS,960);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3958,1,3,1000,1456,50);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3958,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  186 - Ra'Gho Darkfount
INSERT INTO `mob_droplist` VALUES (3959,0,0,1000,3411,@ALWAYS);                     -- Fiendish Tome: Chapter 8 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3959,1,1,1000,11776,130);                        -- Mujin obi (13%)
INSERT INTO `mob_droplist` VALUES (3959,1,1,1000,@FORGOTTEN_POUCH_LEGS,870);        -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3959,1,2,1000,@FORGOTTEN_POUCH_LEGS,960);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3959,1,2,1000,1456,50);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3959,1,3,1000,@FORGOTTEN_POUCH_LEGS,960);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3959,1,3,1000,1456,50);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3959,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  186 - Va'Zhe Pummelsong
INSERT INTO `mob_droplist` VALUES (3949,0,0,1000,3412,@ALWAYS);                     -- Fiendish Tome: Chapter 9 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3949,1,1,1000,17358,130);                        -- Oneiros harp (13%)
INSERT INTO `mob_droplist` VALUES (3949,1,1,1000,@FORGOTTEN_POUCH_LEGS,870);        -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3949,1,2,1000,@FORGOTTEN_POUCH_LEGS,960);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3949,1,2,1000,1456,50);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3949,1,3,1000,@FORGOTTEN_POUCH_LEGS,960);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3949,1,3,1000,1456,50);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3949,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  186 - Bu'Bho Truesteel
INSERT INTO `mob_droplist` VALUES (3960,0,0,1000,3413,@ALWAYS);                     -- Fiendish Tome: Chapter 10 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3960,1,1,1000,19767,130);                        -- Oneiros pebble (13%)
INSERT INTO `mob_droplist` VALUES (3960,1,1,1000,@FORGOTTEN_POUCH_LEGS,870);        -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3960,1,2,1000,@FORGOTTEN_POUCH_LEGS,960);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3960,1,2,1000,1456,50);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3960,1,3,1000,@FORGOTTEN_POUCH_LEGS,960);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3960,1,3,1000,1456,50);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3960,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  186 - Arch Gu'Dha Effigy (NQ)
INSERT INTO `mob_droplist` VALUES (3961,0,0,1000,11670,@COMMON);                    -- Oneiros annulet (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3961,0,0,1000,18519,@COMMON);                    -- Oneiros axe (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3961,0,0,1000,11817,@COMMON);                    -- Oneiros barbut (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3961,0,0,1000,1474,250);                         -- Infinity core (25%)
INSERT INTO `mob_droplist` VALUES (3961,1,1,1000,@FORGOTTEN_POUCH_LEGS,950);        -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3961,1,1,1000,1456,50);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3961,1,2,1000,@FORGOTTEN_POUCH_LEGS,950);        -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3961,1,2,1000,1456,50);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3961,1,3,1000,@FORGOTTEN_POUCH_LEGS,950);        -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3961,1,3,1000,1456,50);                          -- One Hundred byne bill (5%)

-- ZoneID:  186 - Arch Gu'Dha Effigy (HQ/White Proc)
INSERT INTO `mob_droplist` VALUES (3962,0,0,1000,11670,200);                        -- Oneiros annulet (20%)
INSERT INTO `mob_droplist` VALUES (3962,0,0,1000,18519,200);                        -- Oneiros axe (20%)
INSERT INTO `mob_droplist` VALUES (3962,0,0,1000,11817,200);                        -- Oneiros barbut (20%)
INSERT INTO `mob_droplist` VALUES (3962,0,0,1000,1474,500);                         -- Infinity core (50%)
INSERT INTO `mob_droplist` VALUES (3962,0,0,1000,@FORGOTTEN_POUCH_LEGS,@ALWAYS);    -- Forgotten pouch journey (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3962,1,1,1000,@FORGOTTEN_POUCH_LEGS,925);        -- Forgotten pouch journey (92.5%)
INSERT INTO `mob_droplist` VALUES (3962,1,1,1000,1456,75);                          -- One Hundred byne bill (7.5%)
INSERT INTO `mob_droplist` VALUES (3962,1,2,1000,@FORGOTTEN_POUCH_LEGS,925);        -- Forgotten pouch journey (92.5%)
INSERT INTO `mob_droplist` VALUES (3962,1,2,1000,1456,75);                          -- One Hundred byne bill (7.5%)
INSERT INTO `mob_droplist` VALUES (3962,1,3,1000,@FORGOTTEN_POUCH_LEGS,925);        -- Forgotten pouch journey (92.5%)
INSERT INTO `mob_droplist` VALUES (3962,1,3,1000,1456,75);                          -- One Hundred byne bill (7.5%)

-- --------------------------------------------------------------------
--                         Dynamis-Windurst                         --
-- --------------------------------------------------------------------

-- Ensure we're clearing out the old drop lists
DELETE FROM `mob_droplist` WHERE dropid = "1264"; -- Delete Haa Pevi The Stentorian
DELETE FROM `mob_droplist` WHERE dropId = "2677" AND `itemId` = 1470;-- Delete Sparkling Stone
DELETE FROM `mob_droplist` WHERE dropid = "1534"; -- Delete Loo Hepe The Eyepiercer
DELETE FROM `mob_droplist` WHERE dropId = "1534" AND `itemId` = 1470;-- Delete Sparkling Stone
DELETE FROM `mob_droplist` WHERE dropid = "1560"; -- Delete Maa Febi The Steadfast, Muu Febi The Steadfast, Xoo Kaza
DELETE FROM `mob_droplist` WHERE dropId = "1560" AND `itemId` = 1470; -- Delete Sparkling Stone
DELETE FROM `mob_droplist` WHERE dropid = "2553"; -- Delete Vanguard Yagudos
DELETE FROM `mob_droplist` WHERE dropId = "2553" AND `itemId` = 1470; -- Delete Sparkling Stone
DELETE FROM `mob_droplist` WHERE dropid = "2677"; -- Delete Wuu Qoho The Razorclaw
DELETE FROM `mob_droplist` WHERE dropId = "2677" AND `itemId` = 1470; -- Delete Sparkling Stone
DELETE FROM `mob_droplist` WHERE dropid = "2510"; -- Delete Tzee Xicu Idol
DELETE FROM `mob_droplist` WHERE dropid = "3963"; -- Delete Xuu Bhoqa the Enigma
DELETE FROM `mob_droplist` WHERE dropid = "3964"; -- Delete Fuu Tzapo the Blessed
DELETE FROM `mob_droplist` WHERE dropid = "3965"; -- Delete Naa Yixothe Stillrage
DELETE FROM `mob_droplist` WHERE dropid = "3966"; -- Delete Tee Zaksa the Ceaseless
DELETE FROM `mob_droplist` WHERE dropid = "3967"; -- Delete Arch Tzee Xicu Idol NQ
DELETE FROM `mob_droplist` WHERE dropid = "3968"; -- Delete Arch Tzee Xicu Idol HQ

-- Assign drop lists to bosses
UPDATE `mob_groups` SET `dropid` = 0    WHERE name = 'Maa Febi The Steadfast' AND zoneid = 187;
UPDATE `mob_groups` SET `dropid` = 0    WHERE name = 'Muu Febi The Steadfast' AND zoneid = 187;
UPDATE `mob_groups` SET `dropid` = 2510 WHERE name = 'Tzee_Xicu_Idol' AND zoneid = 187;
UPDATE `mob_groups` SET `dropid` = 3963 WHERE name = 'Xuu_Bhoqa_the_Enigma' AND zoneid = 187;
UPDATE `mob_groups` SET `dropid` = 3964 WHERE name = 'Fuu_Tzapo_the_Blessed' AND zoneid = 187;
UPDATE `mob_groups` SET `dropid` = 3965 WHERE name = 'Naa_Yixo_the_Stillrage' AND zoneid = 187;
UPDATE `mob_groups` SET `dropid` = 3966 WHERE name = 'Tee_Zaksa_the_Ceaseless' AND zoneid = 187;
UPDATE `mob_groups` SET `dropid` = 3967 WHERE name = 'Arch_Tzee_Xicu_Idol' AND zoneid = 187; -- NQ
UPDATE `mob_groups` SET `dropid` = 3968 WHERE name = 'Arch_Tzee_Xicu_Idol' AND zoneid = 187; -- HQ

-- ZoneID: 187 - Haa Pevi The Stentorian
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,3355,@VCOMMON);                   -- Divine Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,1466,80);                         -- Pile Of Relic Iron (8.0%)
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,1464,80);                         -- Lancewood Log (8.0%)
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,1518,80);                         -- Colossal Skull (8.0%)
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,1450,@RARE);                      -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1264,1,3,20,18260,250);                         -- Relic Knuckles (2.0%)
INSERT INTO `mob_droplist` VALUES (1264,1,3,20,18266,250);                         -- Relic Dagger (2.0%)
INSERT INTO `mob_droplist` VALUES (1264,1,3,20,18272,250);                         -- Relic Sword (2.0%)
INSERT INTO `mob_droplist` VALUES (1264,1,3,20,18320,250);                         -- Relic Maul (2.0%)
INSERT INTO `mob_droplist` VALUES (1264,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15072,91);                   -- Warriors Mask (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15077,91);                   -- Assassins Bonnet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15080,91);                   -- Monster Helm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15084,91);                   -- Koga Hatsuburi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15105,91);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15109,91);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15112,91);                   -- Scouts Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15128,91);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15131,91);                   -- Summoners Spats (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15134,91);                   -- Clerics Duckbills (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,1,@UNCOMMON,15138,90);                   -- Valor Leggings (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,2,@UNCOMMON,11398,167);                  -- Argute Loafers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,2,@UNCOMMON,15031,167);                  -- Pantin Dastanas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,2,@UNCOMMON,15038,167);                  -- Etoile Bangles (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,2,@UNCOMMON,11382,167);                  -- Mirage Charuqs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,2,@UNCOMMON,27018,166);                  -- Futhark Mitons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,1,2,@UNCOMMON,27368,166);                  -- Bagua Sandals (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1264,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID: 187 - Loo Hepe The Eyepiercer
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,3355,@VCOMMON);                   -- Divine Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,1466,80);                         -- Pile Of Relic Iron (8.0%)
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,1464,80);                         -- Lancewood Log (8.0%)
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,1518,80);                         -- Colossal Skull (8.0%)
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,1450,@RARE);                      -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1534,1,3,20,18260,250);                         -- Relic Knuckles (2.0%)
INSERT INTO `mob_droplist` VALUES (1534,1,3,20,18266,250);                         -- Relic Dagger (2.0%)
INSERT INTO `mob_droplist` VALUES (1534,1,3,20,18272,250);                         -- Relic Sword (2.0%)
INSERT INTO `mob_droplist` VALUES (1534,1,3,20,18320,250);                         -- Relic Maul (2.0%)
INSERT INTO `mob_droplist` VALUES (1534,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15072,91);                   -- Warriors Mask (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15077,91);                   -- Assassins Bonnet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15080,91);                   -- Monster Helm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15084,91);                   -- Koga Hatsuburi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15105,91);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15109,91);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15112,91);                   -- Scouts Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15128,91);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15131,91);                   -- Summoners Spats (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15134,91);                   -- Clerics Duckbills (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,1,@UNCOMMON,15138,90);                   -- Valor Leggings (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,2,@UNCOMMON,11398,167);                  -- Argute Loafers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,2,@UNCOMMON,15031,167);                  -- Pantin Dastanas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,2,@UNCOMMON,15038,167);                  -- Etoile Bangles (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,2,@UNCOMMON,11382,167);                  -- Mirage Charuqs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,2,@UNCOMMON,27018,166);                  -- Futhark Mitons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,1,2,@UNCOMMON,27368,166);                  -- Bagua Sandals (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1534,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID: 187 - Maa Febi The Steadfast (Spawned by Tzee Xicu Idol, Drop ID 0, drops nothing)
-- ZoneID: 187 - Muu Febi The Steadfast (Spawned by Tzee Xicu Idol, Drop ID 0, drops nothing)
-- ZoneID: 187 - Xoo Kaza The Solemn (Spawns at Koru Moru's Manor)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,3355,@VCOMMON);                   -- Divine Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,1466,80);                         -- Pile Of Relic Iron (8.0%)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,1464,80);                         -- Lancewood Log (8.0%)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,1518,80);                         -- Colossal Skull (8.0%)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,1450,@RARE);                      -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1560,1,3,20,18260,250);                         -- Relic Knuckles (2.0%)
INSERT INTO `mob_droplist` VALUES (1560,1,3,20,18266,250);                         -- Relic Dagger (2.0%)
INSERT INTO `mob_droplist` VALUES (1560,1,3,20,18272,250);                         -- Relic Sword (2.0%)
INSERT INTO `mob_droplist` VALUES (1560,1,3,20,18320,250);                         -- Relic Maul (2.0%)
INSERT INTO `mob_droplist` VALUES (1560,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15072,91);                   -- Warriors Mask (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15077,91);                   -- Assassins Bonnet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15080,91);                   -- Monster Helm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15084,91);                   -- Koga Hatsuburi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15105,91);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15109,91);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15112,91);                   -- Scouts Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15128,91);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15131,91);                   -- Summoners Spats (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15134,91);                   -- Clerics Duckbills (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,1,@UNCOMMON,15138,90);                   -- Valor Leggings (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,2,@UNCOMMON,11398,167);                  -- Argute Loafers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,2,@UNCOMMON,15031,167);                  -- Pantin Dastanas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,2,@UNCOMMON,15038,167);                  -- Etoile Bangles (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,2,@UNCOMMON,11382,167);                  -- Mirage Charuqs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,2,@UNCOMMON,27018,166);                  -- Futhark Mitons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,1,2,@UNCOMMON,27368,166);                  -- Bagua Sandals (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1560,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID: 187 - Vanguard Skirmisher
-- ZoneID: 187 - Vanguard Priest
-- ZoneID: 187 - Vanguard Prelate
-- ZoneID: 187 - Vanguard Chanter
-- ZoneID: 187 - Vanguard Sentinel
-- ZoneID: 187 - Vanguard Visionary
-- ZoneID: 187 - Vanguard Liberator
-- ZoneID: 187 - Vanguard Inciter
-- ZoneID: 187 - Vanguard Exemplar
-- ZoneID: 187 - Vanguard Salvager
-- ZoneID: 187 - Vanguard Ogresoother
-- ZoneID: 187 - Vanguard Persecutor
-- ZoneID: 187 - Vanguard Assassin
-- ZoneID: 187 - Vanguard Partisan
-- ZoneID: 187 - Vanguard Oracle
-- ZoneID: 187 - Vanguard Salvager
-- ZoneID: 187 - Vanguard Skirmisher
-- ZoneID: 187 - Vanguard Priest
-- ZoneID: 187 - Vanguard Prelate
-- ZoneID: 187 - Vanguard Visionary
-- ZoneID: 187 - Vanguard Sentinel
-- ZoneID: 187 - Vanguard Exemplar
-- ZoneID: 187 - Vanguard Ogresoother
-- ZoneID: 187 - Vanguard Inciter
-- ZoneID: 187 - Vanguard Liberator
-- ZoneID: 187 - Vanguard Assassin
-- ZoneID: 187 - Vanguard Persecutor
-- ZoneID: 187 - Vanguard Chanter
-- ZoneID: 187 - Vanguard Partisan
-- ZoneID: 187 - Vanguard Oracle
INSERT INTO `mob_droplist` VALUES (2553,0,0,1000,1464,@UNCOMMON);                  -- Lancewood Log (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,0,0,1000,1466,@UNCOMMON);                  -- Pile Of Relic Iron (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,0,0,1000,1518,@UNCOMMON);                  -- Colossal Skull (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,5,20,18260,250);                         -- Relic Knuckles (2.0%)
INSERT INTO `mob_droplist` VALUES (2553,1,5,20,18266,250);                         -- Relic Dagger (2.0%)
INSERT INTO `mob_droplist` VALUES (2553,1,5,20,18272,250);                         -- Relic Sword (2.0%)
INSERT INTO `mob_droplist` VALUES (2553,1,5,20,18320,250);                         -- Relic Maul (2.0%)
INSERT INTO `mob_droplist` VALUES (2553,1,1,@UNCOMMON,3388,500);                   -- Odious Necklace (4%)
INSERT INTO `mob_droplist` VALUES (2553,1,1,@UNCOMMON,3389,500);                   -- Odious Feather (4%)
INSERT INTO `mob_droplist` VALUES (2553,1,2,@UNCOMMON,3390,500);                   -- Odious Holy Water (4%)
INSERT INTO `mob_droplist` VALUES (2553,1,2,@UNCOMMON,3391,500);                   -- Odious Quipu (4%)
INSERT INTO `mob_droplist` VALUES (2553,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15072,91);                   -- Warriors Mask (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15077,91);                   -- Assassins Bonnet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15080,91);                   -- Monster Helm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15084,91);                   -- Koga Hatsuburi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15105,91);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15109,91);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15112,91);                   -- Scouts Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15128,91);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15131,91);                   -- Summoners Spats (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15134,91);                   -- Clerics Duckbills (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,3,@UNCOMMON,15138,90);                   -- Valor Leggings (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,4,@UNCOMMON,11398,167);                  -- Argute Loafers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,4,@UNCOMMON,15031,167);                  -- Pantin Dastanas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,4,@UNCOMMON,15038,167);                  -- Etoile Bangles (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,4,@UNCOMMON,11382,167);                  -- Mirage Charuqs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,4,@UNCOMMON,27018,166);                  -- Futhark Mitons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,1,4,@UNCOMMON,27368,166);                  -- Bagua Sandals (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2553,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID: 187 - Wuu Qoho The Razorclaw
INSERT INTO `mob_droplist` VALUES (2677,0,0,1000,3355,@VCOMMON);                   -- Divine Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2677,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2677,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2677,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2677,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2677,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2677,0,0,1000,1464,80);                         -- Lancewood Log (8.0%)
INSERT INTO `mob_droplist` VALUES (2677,0,0,1000,1518,80);                         -- Colossal Skull (8.0%)
INSERT INTO `mob_droplist` VALUES (2677,0,0,1000,1450,@RARE);                      -- Lungo-Nango Jadeshell Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2677,1,3,20,18260,250);                         -- Relic Knuckles (2.0%)
INSERT INTO `mob_droplist` VALUES (2677,1,3,20,18266,250);                         -- Relic Dagger (2.0%)
INSERT INTO `mob_droplist` VALUES (2677,1,3,20,18272,250);                         -- Relic Sword (2.0%)
INSERT INTO `mob_droplist` VALUES (2677,1,3,20,18320,250);                         -- Relic Maul (2.0%)
INSERT INTO `mob_droplist` VALUES (2677,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15072,91);                   -- Warriors Mask (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15077,91);                   -- Assassins Bonnet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15080,91);                   -- Monster Helm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15084,91);                   -- Koga Hatsuburi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15105,91);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15109,91);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15112,91);                   -- Scouts Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15128,91);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15131,91);                   -- Summoners Spats (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15134,91);                   -- Clerics Duckbills (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,1,@UNCOMMON,15138,90);                   -- Valor Leggings (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,2,@UNCOMMON,11398,167);                  -- Argute Loafers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,2,@UNCOMMON,15031,167);                  -- Pantin Dastanas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,2,@UNCOMMON,15038,167);                  -- Etoile Bangles (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,2,@UNCOMMON,11382,167);                  -- Mirage Charuqs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,2,@UNCOMMON,27018,166);                  -- Futhark Mitons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,1,2,@UNCOMMON,27368,166);                  -- Bagua Sandals (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2677,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID: 187 - Tzee Xicu Idol
INSERT INTO `mob_droplist` VALUES (2510,0,0,1000,3414,@ALWAYS);                     -- Fiendish Tome Chapter 11 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2510,0,0,1000,1474,@COMMON);                     -- Infinity Core (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2510,1,1,1000,@FORGOTTEN_POUCH_FEET,980);        -- Forgotten pouch step (98%)
INSERT INTO `mob_droplist` VALUES (2510,1,1,1000,1450,@UNCOMMON);                   -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2510,0,0,1000,11631,50);                         -- Tzee Xicu Idol - blobnag_ring
INSERT INTO `mob_droplist` VALUES (2510,0,0,1000,2467,100);                         -- Tzee Xicu Idol - rubber_gloves
INSERT INTO `mob_droplist` VALUES (2510,0,0,1000,11544,100);                        -- Tzee Xicu Idol - veela_cape
INSERT INTO `mob_droplist` VALUES (2510,0,0,1000,16056,100);                        -- Tzee Xicu Idol - pagondas_earring

-- ZoneID:  187 - Xuu Bhoqa The Enigma
INSERT INTO `mob_droplist` VALUES (3963,0,0,1000,3415,@ALWAYS);                     -- Fiendish Tome: Chapter 12 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3963,1,1,1000,11671,130);                        -- Oneiros ring (13%)
INSERT INTO `mob_droplist` VALUES (3963,1,1,1000,@FORGOTTEN_POUCH_FEET,870);        -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (3963,1,2,1000,@FORGOTTEN_POUCH_FEET,960);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3963,1,2,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3963,1,3,1000,@FORGOTTEN_POUCH_FEET,960);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3963,1,3,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3963,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)

-- ZoneID:  187 - Fuu Tzapo The Blessed
INSERT INTO `mob_droplist` VALUES (3964,0,0,1000,3416,@ALWAYS);                     -- Fiendish Tome: Chapter 13 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3964,1,1,1000,11030,130);                        -- Oneiros Earring (13%)
INSERT INTO `mob_droplist` VALUES (3964,1,1,1000,@FORGOTTEN_POUCH_FEET,870);        -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (3964,1,2,1000,@FORGOTTEN_POUCH_FEET,960);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3964,1,2,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3964,1,3,1000,@FORGOTTEN_POUCH_FEET,960);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3964,1,3,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3964,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)

-- ZoneID:  187 - Naa Yixo The Stillrage
INSERT INTO `mob_droplist` VALUES (3965,0,0,1000,3417,@ALWAYS);                     -- Fiendish Tome: Chapter 14 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3965,1,1,1000,11672,130);                        -- Mujin band (13%)
INSERT INTO `mob_droplist` VALUES (3965,1,1,1000,@FORGOTTEN_POUCH_FEET,870);        -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (3965,1,2,1000,@FORGOTTEN_POUCH_FEET,960);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3965,1,2,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3965,1,3,1000,@FORGOTTEN_POUCH_FEET,960);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3965,1,3,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3965,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)

-- ZoneID:  187 - Tee Zaksa The Ceaseless
INSERT INTO `mob_droplist` VALUES (3966,0,0,1000,3418,@ALWAYS);                     -- Fiendish Tome: Chapter 15 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3966,1,1,1000,10932,130);                        -- Oneiros torque (13%)
INSERT INTO `mob_droplist` VALUES (3966,1,1,1000,@FORGOTTEN_POUCH_FEET,870);        -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (3966,1,2,1000,@FORGOTTEN_POUCH_FEET,960);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3966,1,2,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3966,1,3,1000,@FORGOTTEN_POUCH_FEET,960);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3966,1,3,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3966,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)

-- ZoneID:  187 - Arch Tzee Xicu Idol (NQ)
INSERT INTO `mob_droplist` VALUES (3967,0,0,1000,10933,@COMMON);                    -- Mujin necklace (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3967,0,0,1000,19295,@COMMON);                    -- Mujin tanto (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3967,0,0,1000,11818,@COMMON);                    -- Oneiros Headgear (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3967,0,0,1000,1474,250);                         -- Infinity core (25%)
INSERT INTO `mob_droplist` VALUES (3967,1,1,1000,@FORGOTTEN_POUCH_FEET,950);        -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (3967,1,1,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3967,1,2,1000,@FORGOTTEN_POUCH_FEET,950);        -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (3967,1,2,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3967,1,3,1000,@FORGOTTEN_POUCH_FEET,950);        -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (3967,1,3,1000,1450,50);                          -- Lungo-Nango-Nango Jadeshell (5%)

-- ZoneID:  187 - Arch Tzee Xicu Idol (HQ/White Proc)
INSERT INTO `mob_droplist` VALUES (3968,0,0,1000,10933,200);                        -- Mujin necklace (20%)
INSERT INTO `mob_droplist` VALUES (3968,0,0,1000,19295,200);                        -- Mujin tanto (20%)
INSERT INTO `mob_droplist` VALUES (3968,0,0,1000,11818,200);                        -- Oneiros Headgear (20%)
INSERT INTO `mob_droplist` VALUES (3968,0,0,1000,1474,500);                         -- Infinity core (50%)
INSERT INTO `mob_droplist` VALUES (3968,0,0,1000,@FORGOTTEN_POUCH_FEET,@ALWAYS);    -- Forgotten pouch step (100%)
INSERT INTO `mob_droplist` VALUES (3968,1,1,1000,@FORGOTTEN_POUCH_FEET,925);        -- Forgotten pouch step (92.5%)
INSERT INTO `mob_droplist` VALUES (3968,1,1,1000,1450,75);                          -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3968,1,2,1000,@FORGOTTEN_POUCH_FEET,925);        -- Forgotten pouch step (92.5%)
INSERT INTO `mob_droplist` VALUES (3968,1,2,1000,1450,75);                          -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3968,1,3,1000,@FORGOTTEN_POUCH_FEET,925);        -- Forgotten pouch step (92.5%)
INSERT INTO `mob_droplist` VALUES (3968,1,3,1000,1450,75);                          -- Lungo-Nango-Nango Jadeshell (7.5%)

-- --------------------------------------------------------------------
--                          Dynamis-Jeuno                           --
-- --------------------------------------------------------------------

-- Ensure we're clearing out the old drop lists
DELETE FROM `mob_droplist` WHERE dropid = "143";  -- Delete Rest of Goblin NMs
DELETE FROM `mob_droplist` WHERE dropid = "220";  -- Delete Bandrix Rockjaw
DELETE FROM `mob_droplist` WHERE dropid = "922";  -- Delete Magpietongue, Hamgams
DELETE FROM `mob_droplist` WHERE dropid = "2543"; -- Delete Vanguard Goblins
DELETE FROM `mob_droplist` WHERE dropid = "2560"; -- Delete Vanguard Enchanter
DELETE FROM `mob_droplist` WHERE dropid = "2563"; -- Delete Vanguard Pathfinder
DELETE FROM `mob_droplist` WHERE dropid = "1085"; -- Delete Goblin Golem
DELETE FROM `mob_droplist` WHERE dropid = "3957"; -- Delete Quicktrix Hexhands
DELETE FROM `mob_droplist` WHERE dropid = "3956"; -- Delete Feralox Honeylips
DELETE FROM `mob_droplist` WHERE dropid = "3955"; -- Delete Scourquix Scaleskin
DELETE FROM `mob_droplist` WHERE dropid = "3954"; -- Delete Wilywox Tenderpalm
DELETE FROM `mob_droplist` WHERE dropid = "3953"; -- Delete Arch Goblin Golem NQ
DELETE FROM `mob_droplist` WHERE dropid = "3952"; -- Delete Arch Goblin Golem HQ

-- Assign drop lists to bosses
UPDATE `mob_groups` SET `dropid` = 1085 WHERE name = 'Goblin_Golem' AND zoneid = 188;
UPDATE `mob_groups` SET `dropid` = 3957 WHERE name = 'Quicktrix_Hexhands' AND zoneid = 188;
UPDATE `mob_groups` SET `dropid` = 3956 WHERE name = 'Feralox_Honeylips' AND zoneid = 188;
UPDATE `mob_groups` SET `dropid` = 3955 WHERE name = 'Scourquix_Scaleskin' AND zoneid = 188;
UPDATE `mob_groups` SET `dropid` = 3954 WHERE name = 'Wilywox_Tenderpalm' AND zoneid = 188;
UPDATE `mob_groups` SET `dropid` = 3953 WHERE name = 'Arch_Goblin_Golem' AND zoneid = 188; -- NQ
UPDATE `mob_groups` SET `dropid` = 3952 WHERE name = 'Arch_Goblin_Golem' AND zoneid = 188; -- HQ

-- ZoneID: 188 - Tufflix Loglimbs
-- ZoneID: 188 - Smeltix Thickhide
-- ZoneID: 188 - Jabkix Pigeonpecs
-- ZoneID: 188 - Wasabix Callusdigit
-- ZoneID: 188 - Hermitrix Toothrot
-- ZoneID: 188 - Wyrmwix Snakespecs
-- ZoneID: 188 - Morgmox Moldnoggin
-- ZoneID: 188 - Sparkspox Sweatbrow
-- ZoneID: 188 - Elixmix Hooknose
-- ZoneID: 188 - Buffrix Eargone
-- ZoneID: 188 - Humnox Drumbelly
-- ZoneID: 188 - Ticktox Beadyeyes
-- ZoneID: 188 - Lurklox Dhalmelneck
-- ZoneID: 188 - Kikklix Longlegs
-- ZoneID: 188 - Karashix Swollenskull
-- ZoneID: 188 - Snypestix Eaglebeak
-- ZoneID: 188 - Anvilix Sootwrists
-- ZoneID: 188 - Bootrix Jaggedelbow
-- ZoneID: 188 - Mobpix Mucousmouth
-- ZoneID: 188 - Distilix Stickytoes
-- ZoneID: 188 - Eremix Snottynostril
-- ZoneID: 188 - Jabbrox Grannyguise
-- ZoneID: 188 - Scruffix Shaggychest
-- ZoneID: 188 - Blazox Boneybod
-- ZoneID: 188 - Prowlox Barrelbelly
-- ZoneID: 188 - Cloktix Longnail
-- ZoneID: 188 - Mortilox Wartpaws
-- ZoneID: 188 - Slystix Megapeepers
INSERT INTO `mob_droplist` VALUES (143,0,0,1000,3356,@VCOMMON);                    -- Roving Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (143,1,1,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (143,1,1,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,1,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,2,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (143,1,2,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,2,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,3,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (143,1,3,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,3,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,4,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (143,1,4,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,4,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,5,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (143,1,5,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,5,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (143,0,0,1000,1470,80);                          -- Sparkling Stone (8.0%)
INSERT INTO `mob_droplist` VALUES (143,0,0,1000,1520,80);                          -- Jar Of Goblin Grease (8.0%)
INSERT INTO `mob_droplist` VALUES (143,1,6,@COMMON,3497,334);                      -- Forgotten step (33.4%)
INSERT INTO `mob_droplist` VALUES (143,1,6,@COMMON,3495,333);                      -- Forgotten touch (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,6,@COMMON,3496,333);                      -- Forgotten journey (33.3%)
INSERT INTO `mob_droplist` VALUES (143,1,7,15,1450,334);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (143,1,7,15,1453,333);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (143,1,7,15,1456,333);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15102,91);                    -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15144,91);                    -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15082,91);                    -- Scouts Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15103,91);                    -- Melee Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15119,91);                    -- Clerics Pantaloons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15121,91);                    -- Duelists Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15124,91);                    -- Abyss Flanchard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15135,91);                    -- Sorcerers Sabots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15137,91);                    -- Assassins Poulaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15141,91);                    -- Bards Slippers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,8,@UNCOMMON,15143,90);                    -- Saotome Sune-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,9,@UNCOMMON,15115,200);                   -- Wyrm Finger Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,9,@UNCOMMON,16352,200);                   -- Pantin Churidars (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,9,@UNCOMMON,15028,200);                   -- Commodore Gants (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,9,@UNCOMMON,11396,200);                   -- Etoile Toe Shoes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,9,@UNCOMMON,27370,200);                   -- Futhark Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (143,1,10,20,15066,250);                         -- Relic Shield (2.0%)
INSERT INTO `mob_droplist` VALUES (143,1,10,20,18326,250);                         -- Relic Staff (2.0%)
INSERT INTO `mob_droplist` VALUES (143,1,10,20,18338,250);                         -- Relic Horn (2.0%)
INSERT INTO `mob_droplist` VALUES (143,1,10,20,18344,250);                         -- Relic Bow (2.0%)
INSERT INTO `mob_droplist` VALUES (143,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (143,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (143,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 188 - Bandrix Rockjaw
INSERT INTO `mob_droplist` VALUES (220,0,0,1000,3356,@VCOMMON);                    -- Roving Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (220,1,1,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (220,1,1,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,1,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,2,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (220,1,2,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,2,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,3,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (220,1,3,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,3,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,4,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (220,1,4,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,4,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,5,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (220,1,5,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,5,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (220,0,0,1000,1470,80);                          -- Sparkling Stone (8.0%)
INSERT INTO `mob_droplist` VALUES (220,0,0,1000,1520,80);                          -- Jar Of Goblin Grease (8.0%)
INSERT INTO `mob_droplist` VALUES (220,1,6,@COMMON,3497,334);                      -- Forgotten step (33.4%)
INSERT INTO `mob_droplist` VALUES (220,1,6,@COMMON,3495,333);                      -- Forgotten touch (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,6,@COMMON,3496,333);                      -- Forgotten journey (33.3%)
INSERT INTO `mob_droplist` VALUES (220,1,7,15,1450,334);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (220,1,7,15,1453,333);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (220,1,7,15,1456,333);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15102,91);                    -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15144,91);                    -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15082,91);                    -- Scouts Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15103,91);                    -- Melee Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15119,91);                    -- Clerics Pantaloons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15121,91);                    -- Duelists Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15124,91);                    -- Abyss Flanchard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15135,91);                    -- Sorcerers Sabots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15137,91);                    -- Assassins Poulaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15141,91);                    -- Bards Slippers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,8,@UNCOMMON,15143,90);                    -- Saotome Sune-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,9,@UNCOMMON,15115,200);                   -- Wyrm Finger Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,9,@UNCOMMON,16352,200);                   -- Pantin Churidars (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,9,@UNCOMMON,15028,200);                   -- Commodore Gants (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,9,@UNCOMMON,11396,200);                   -- Etoile Toe Shoes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,9,@UNCOMMON,27370,200);                   -- Futhark Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (220,1,10,20,15066,250);                         -- Relic Shield (2.0%)
INSERT INTO `mob_droplist` VALUES (220,1,10,20,18326,250);                         -- Relic Staff (2.0%)
INSERT INTO `mob_droplist` VALUES (220,1,10,20,18338,250);                         -- Relic Horn (2.0%)
INSERT INTO `mob_droplist` VALUES (220,1,10,20,18344,250);                         -- Relic Bow (2.0%)
INSERT INTO `mob_droplist` VALUES (220,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (220,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (220,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 188 - Gabblox Magpietongue
-- ZoneID: 188 - Rutrix Hamgams
INSERT INTO `mob_droplist` VALUES (922,0,0,1000,3356,@VCOMMON);                    -- Roving Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (922,1,1,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (922,1,1,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,1,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,2,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (922,1,2,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,2,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,3,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (922,1,3,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,3,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,4,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (922,1,4,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,4,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,5,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (922,1,5,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,5,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (922,0,0,1000,1470,80);                          -- Sparkling Stone (8.0%)
INSERT INTO `mob_droplist` VALUES (922,0,0,1000,1520,80);                          -- Jar Of Goblin Grease (8.0%)
INSERT INTO `mob_droplist` VALUES (922,1,6,@COMMON,3497,334);                      -- Forgotten step (33.4%)
INSERT INTO `mob_droplist` VALUES (922,1,6,@COMMON,3495,333);                      -- Forgotten touch (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,6,@COMMON,3496,333);                      -- Forgotten journey (33.3%)
INSERT INTO `mob_droplist` VALUES (922,1,7,15,1450,334);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (922,1,7,15,1453,333);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (922,1,7,15,1456,333);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15102,91);                    -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15144,91);                    -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15082,91);                    -- Scouts Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15103,91);                    -- Melee Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15119,91);                    -- Clerics Pantaloons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15121,91);                    -- Duelists Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15124,91);                    -- Abyss Flanchard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15135,91);                    -- Sorcerers Sabots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15137,91);                    -- Assassins Poulaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15141,91);                    -- Bards Slippers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,8,@UNCOMMON,15143,90);                    -- Saotome Sune-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,9,@UNCOMMON,15115,200);                   -- Wyrm Finger Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,9,@UNCOMMON,16352,200);                   -- Pantin Churidars (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,9,@UNCOMMON,15028,200);                   -- Commodore Gants (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,9,@UNCOMMON,11396,200);                   -- Etoile Toe Shoes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,9,@UNCOMMON,27370,200);                   -- Futhark Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (922,1,10,20,15066,250);                         -- Relic Shield (2.0%)
INSERT INTO `mob_droplist` VALUES (922,1,10,20,18326,250);                         -- Relic Staff (2.0%)
INSERT INTO `mob_droplist` VALUES (922,1,10,20,18338,250);                         -- Relic Horn (2.0%)
INSERT INTO `mob_droplist` VALUES (922,1,10,20,18344,250);                         -- Relic Bow (2.0%)
INSERT INTO `mob_droplist` VALUES (922,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (922,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (922,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 188 - Vanguard Smithy
-- ZoneID: 188 - Vanguard Welldigger
-- ZoneID: 188 - Vanguard Shaman
-- ZoneID: 188 - Vanguard Tinkerer
-- ZoneID: 188 - Vanguard Armorer
-- ZoneID: 188 - Vanguard Hitman
-- ZoneID: 188 - Vanguard Pitfighter
-- ZoneID: 188 - Vanguard Alchemist
-- ZoneID: 188 - Vanguard Maestro
-- ZoneID: 188 - Vanguard Ambusher
-- ZoneID: 188 - Vanguard Necromancer
-- ZoneID: 188 - Vanguard Ronin
-- ZoneID: 188 - Vanguard Smithy
-- ZoneID: 188 - Vanguard Pitfighter
-- ZoneID: 188 - Vanguard Welldigger
-- ZoneID: 188 - Vanguard Alchemist
-- ZoneID: 188 - Vanguard Shaman
-- ZoneID: 188 - Vanguard Tinkerer
-- ZoneID: 188 - Vanguard Maestro
-- ZoneID: 188 - Vanguard Ronin
-- ZoneID: 188 - Vanguard Armorer
-- ZoneID: 188 - Vanguard Necromancer
-- ZoneID: 188 - Vanguard Ambusher
-- ZoneID: 188 - Vanguard Hitman
INSERT INTO `mob_droplist` VALUES (2543,0,0,1000,3356,@SRARE);                     -- Roving Bijou (Super Rare 1%) to allieviate the poor NM capture positions in the zones/grouping reducing PH exposure. TH will add whole %s to this.
INSERT INTO `mob_droplist` VALUES (2543,0,0,1000,1470,@UNCOMMON);                  -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,0,0,1000,1520,@UNCOMMON);                  -- Jar Of Goblin Grease (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,6,20,15066,250);                         -- Relic Shield (2.0%)
INSERT INTO `mob_droplist` VALUES (2543,1,6,20,18326,250);                         -- Relic Staff (2.0%)
INSERT INTO `mob_droplist` VALUES (2543,1,6,20,18338,250);                         -- Relic Horn (2.0%)
INSERT INTO `mob_droplist` VALUES (2543,1,6,20,18344,250);                         -- Relic Bow (2.0%)
INSERT INTO `mob_droplist` VALUES (2543,1,1,@UNCOMMON,3392,500);                   -- Odious Cup (4%)
INSERT INTO `mob_droplist` VALUES (2543,1,1,@UNCOMMON,3393,500);                   -- Odious Die (4%)
INSERT INTO `mob_droplist` VALUES (2543,1,2,@UNCOMMON,3394,500);                   -- Odious Mask (4%)
INSERT INTO `mob_droplist` VALUES (2543,1,2,@UNCOMMON,3395,500);                   -- Odious Grenade (4%)
INSERT INTO `mob_droplist` VALUES (2543,1,3,@COMMON,3497,334);                     -- Forgotten step (33.4%)
INSERT INTO `mob_droplist` VALUES (2543,1,3,@COMMON,3495,333);                     -- Forgotten touch (33.3%)
INSERT INTO `mob_droplist` VALUES (2543,1,3,@COMMON,3496,333);                     -- Forgotten journey (33.3%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15102,91);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15144,91);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15082,91);                   -- Scouts Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15103,91);                   -- Melee Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15119,91);                   -- Clerics Pantaloons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15121,91);                   -- Duelists Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15124,91);                   -- Abyss Flanchard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15135,91);                   -- Sorcerers Sabots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15137,91);                   -- Assassins Poulaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15141,91);                   -- Bards Slippers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,4,@UNCOMMON,15143,90);                   -- Saotome Sune-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,5,@UNCOMMON,15115,200);                  -- Wyrm Finger Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,5,@UNCOMMON,16352,200);                  -- Pantin Churidars (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,5,@UNCOMMON,15028,200);                  -- Commodore Gants (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,5,@UNCOMMON,11396,200);                  -- Etoile Toe Shoes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,1,5,@UNCOMMON,27370,200);                  -- Futhark Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2543,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2543,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2543,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 188 - Vanguard Enchanter
-- ZoneID: 188 - Vanguard Enchanter
INSERT INTO `mob_droplist` VALUES (2560,0,0,1000,3356,@SRARE);                     -- Roving Bijou (Super Rare, 1%) to allieviate the poor NM capture positions in the zones/grouping reducing PH exposure. TH will add whole %s to this.
INSERT INTO `mob_droplist` VALUES (2560,0,0,1000,1470,@UNCOMMON);                  -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,0,0,1000,1520,@UNCOMMON);                  -- Jar Of Goblin Grease (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,6,20,15066,250);                         -- Relic Shield (2.0%)
INSERT INTO `mob_droplist` VALUES (2560,1,6,20,18326,250);                         -- Relic Staff (2.0%)
INSERT INTO `mob_droplist` VALUES (2560,1,6,20,18338,250);                         -- Relic Horn (2.0%)
INSERT INTO `mob_droplist` VALUES (2560,1,6,20,18344,250);                         -- Relic Bow (2.0%)
INSERT INTO `mob_droplist` VALUES (2560,1,1,@UNCOMMON,3392,500);                   -- Odious Cup (4%)
INSERT INTO `mob_droplist` VALUES (2560,1,1,@UNCOMMON,3393,500);                   -- Odious Die (4%)
INSERT INTO `mob_droplist` VALUES (2560,1,2,@UNCOMMON,3394,500);                   -- Odious Mask (4%)
INSERT INTO `mob_droplist` VALUES (2560,1,2,@UNCOMMON,3395,500);                   -- Odious Grenade (4%)
INSERT INTO `mob_droplist` VALUES (2560,1,3,@COMMON,3497,334);                     -- Forgotten step (33.4%)
INSERT INTO `mob_droplist` VALUES (2560,1,3,@COMMON,3495,333);                     -- Forgotten touch (33.3%)
INSERT INTO `mob_droplist` VALUES (2560,1,3,@COMMON,3496,333);                     -- Forgotten journey (33.3%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15102,91);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15144,91);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15082,91);                   -- Scouts Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15103,91);                   -- Melee Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15119,91);                   -- Clerics Pantaloons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15121,91);                   -- Duelists Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15124,91);                   -- Abyss Flanchard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15135,91);                   -- Sorcerers Sabots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15137,91);                   -- Assassins Poulaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15141,91);                   -- Bards Slippers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,4,@UNCOMMON,15143,90);                   -- Saotome Sune-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,5,@UNCOMMON,15115,200);                  -- Wyrm Finger Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,5,@UNCOMMON,16352,200);                  -- Pantin Churidars (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,5,@UNCOMMON,15028,200);                  -- Commodore Gants (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,5,@UNCOMMON,11396,200);                  -- Etoile Toe Shoes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,1,5,@UNCOMMON,27370,200);                  -- Futhark Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2560,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2560,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2560,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 188 - Vanguard Pathfinder
-- ZoneID: 188 - Vanguard Pathfinder
INSERT INTO `mob_droplist` VALUES (2563,0,0,1000,3356,@SRARE);                     -- Roving Bijou (Super Rare, 1%) to allieviate the poor NM capture positions in the zones/grouping reducing PH exposure. TH will add whole %s to this.
INSERT INTO `mob_droplist` VALUES (2563,0,0,1000,1470,@UNCOMMON);                  -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,0,0,1000,1520,@UNCOMMON);                  -- Jar Of Goblin Grease (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,6,20,15066,250);                         -- Relic Shield (2.0%)
INSERT INTO `mob_droplist` VALUES (2563,1,6,20,18326,250);                         -- Relic Staff (2.0%)
INSERT INTO `mob_droplist` VALUES (2563,1,6,20,18338,250);                         -- Relic Horn (2.0%)
INSERT INTO `mob_droplist` VALUES (2563,1,6,20,18344,250);                         -- Relic Bow (2.0%)
INSERT INTO `mob_droplist` VALUES (2563,1,1,@UNCOMMON,3392,500);                   -- Odious Cup (4%)
INSERT INTO `mob_droplist` VALUES (2563,1,1,@UNCOMMON,3393,500);                   -- Odious Die (4%)
INSERT INTO `mob_droplist` VALUES (2563,1,2,@UNCOMMON,3394,500);                   -- Odious Mask (4%)
INSERT INTO `mob_droplist` VALUES (2563,1,2,@UNCOMMON,3395,500);                   -- Odious Grenade (4%)
INSERT INTO `mob_droplist` VALUES (2563,1,3,@COMMON,3497,334);                     -- Forgotten step (33.4%)
INSERT INTO `mob_droplist` VALUES (2563,1,3,@COMMON,3495,333);                     -- Forgotten touch (33.3%)
INSERT INTO `mob_droplist` VALUES (2563,1,3,@COMMON,3496,333);                     -- Forgotten journey (33.3%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15102,91);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15144,91);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15082,91);                   -- Scouts Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15103,91);                   -- Melee Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15119,91);                   -- Clerics Pantaloons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15121,91);                   -- Duelists Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15124,91);                   -- Abyss Flanchard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15135,91);                   -- Sorcerers Sabots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15137,91);                   -- Assassins Poulaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15141,91);                   -- Bards Slippers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,4,@UNCOMMON,15143,90);                   -- Saotome Sune-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,5,@UNCOMMON,15115,200);                  -- Wyrm Finger Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,5,@UNCOMMON,16352,200);                  -- Pantin Churidars (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,5,@UNCOMMON,15028,200);                  -- Commodore Gants (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,5,@UNCOMMON,11396,200);                  -- Etoile Toe Shoes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,1,5,@UNCOMMON,27370,200);                  -- Futhark Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2563,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2563,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2563,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 188 - Goblin Golem
INSERT INTO `mob_droplist` VALUES (1085,0,0,1000,3419,@ALWAYS);                     -- Fiendish Tome Chapter 16 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1085,0,0,1000,1474,@COMMON);                     -- Infinity Core (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1085,1,1,1000,@FORGOTTEN_POUCH_HANDS,326);       -- Forgotten pouch touch (98%)
INSERT INTO `mob_droplist` VALUES (1085,1,1,1000,@FORGOTTEN_POUCH_LEGS,327);        -- Forgotten pouch journey (98%)
INSERT INTO `mob_droplist` VALUES (1085,1,1,1000,@FORGOTTEN_POUCH_FEET,327);        -- Forgotten pouch step (98%)
INSERT INTO `mob_droplist` VALUES (1085,1,1,1000,1450,6);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (1085,1,1,1000,1453,7);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (1085,1,1,1000,1456,7);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (1085,0,0,1000,11633,50);                         -- Goblin Golem - galdr_ring
INSERT INTO `mob_droplist` VALUES (1085,0,0,1000,2468,100);                         -- Goblin Golem - rubber_chausses
INSERT INTO `mob_droplist` VALUES (1085,0,0,1000,15954,100);                        -- Goblin Golem - fierce_belt
INSERT INTO `mob_droplist` VALUES (1085,0,0,1000,16307,100);                        -- Goblin Golem - repelling_collar

-- ZoneID:  188 - Quicktrix Hexhands
INSERT INTO `mob_droplist` VALUES (3957,0,0,1000,3420,@ALWAYS);                     -- Fiendish Tome: Chapter 17 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3957,1,1,1000,10974,130);                        -- Mujin mantle (13%)
INSERT INTO `mob_droplist` VALUES (3957,1,1,1000,@FORGOTTEN_POUCH_HANDS,290);       -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3957,1,1,1000,@FORGOTTEN_POUCH_LEGS,290);        -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3957,1,1,1000,@FORGOTTEN_POUCH_FEET,290);        -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (3957,1,2,1000,@FORGOTTEN_POUCH_HANDS,320);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3957,1,2,1000,@FORGOTTEN_POUCH_LEGS,320);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3957,1,2,1000,@FORGOTTEN_POUCH_FEET,320);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3957,1,2,1000,1450,13);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3957,1,2,1000,1453,13);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3957,1,2,1000,1456,14);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3957,1,3,1000,@FORGOTTEN_POUCH_HANDS,320);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3957,1,3,1000,@FORGOTTEN_POUCH_LEGS,320);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3957,1,3,1000,@FORGOTTEN_POUCH_FEET,320);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3957,1,3,1000,1450,13);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3957,1,3,1000,1453,14);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3957,1,3,1000,1456,13);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3957,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3957,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3957,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  188 - Feralox Honeylips
INSERT INTO `mob_droplist` VALUES (3956,0,0,1000,3421,@ALWAYS);                     -- Fiendish Tome: Chapter 18
INSERT INTO `mob_droplist` VALUES (3956,1,1,1000,19762,130);                        -- Oneiros tathlum (13%)
INSERT INTO `mob_droplist` VALUES (3956,1,1,1000,@FORGOTTEN_POUCH_HANDS,290);       -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3956,1,1,1000,@FORGOTTEN_POUCH_LEGS,290);        -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3956,1,1,1000,@FORGOTTEN_POUCH_FEET,290);        -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (3956,1,2,1000,@FORGOTTEN_POUCH_HANDS,320);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3956,1,2,1000,@FORGOTTEN_POUCH_LEGS,320);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3956,1,2,1000,@FORGOTTEN_POUCH_FEET,320);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3956,1,2,1000,1450,13);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3956,1,2,1000,1453,13);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3956,1,2,1000,1456,14);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3956,1,3,1000,@FORGOTTEN_POUCH_HANDS,320);       -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3956,1,3,1000,@FORGOTTEN_POUCH_LEGS,320);        -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3956,1,3,1000,@FORGOTTEN_POUCH_FEET,320);        -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3956,1,3,1000,1450,13);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3956,1,3,1000,1453,14);                          -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3956,1,3,1000,1456,13);                          -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3956,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3956,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3956,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  188 - Scourquix Scaleskin
INSERT INTO `mob_droplist` VALUES (3955,0,0,1000,3422,@ALWAYS);                       -- Fiendish Tome: Chapter 19 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3955,1,1,1000,11031,130);                          -- Oneiros pearl (13%)
INSERT INTO `mob_droplist` VALUES (3955,1,1,1000,@FORGOTTEN_POUCH_HANDS,290);         -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3955,1,1,1000,@FORGOTTEN_POUCH_LEGS,290);          -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3955,1,1,1000,@FORGOTTEN_POUCH_FEET,290);          -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (3955,1,2,1000,@FORGOTTEN_POUCH_HANDS,320);         -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3955,1,2,1000,@FORGOTTEN_POUCH_LEGS,320);          -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3955,1,2,1000,@FORGOTTEN_POUCH_FEET,320);          -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3955,1,2,1000,1450,13);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3955,1,2,1000,1453,13);                            -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3955,1,2,1000,1456,14);                            -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3955,1,3,1000,@FORGOTTEN_POUCH_HANDS,320);         -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3955,1,3,1000,@FORGOTTEN_POUCH_LEGS,320);          -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3955,1,3,1000,@FORGOTTEN_POUCH_FEET,320);          -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3955,1,3,1000,1450,13);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3955,1,3,1000,1453,14);                            -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3955,1,3,1000,1456,13);                            -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3955,2,0,1000,1449,0);                             -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3955,2,0,1000,1452,0);                             -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3955,2,0,1000,1455,0);                             -- One Byne Bill (Steal)

-- ZoneID:  188 - Wilywox Tenderpalm
INSERT INTO `mob_droplist` VALUES (3954,0,0,1000,3423,@ALWAYS);                       -- Fiendish Tome: Chapter 20 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3954,1,1,1000,11032,130);                          -- Mujin stud (13%)
INSERT INTO `mob_droplist` VALUES (3954,1,1,1000,@FORGOTTEN_POUCH_HANDS,290);         -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3954,1,1,1000,@FORGOTTEN_POUCH_LEGS,290);          -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3954,1,1,1000,@FORGOTTEN_POUCH_FEET,290);          -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (3954,1,2,1000,@FORGOTTEN_POUCH_HANDS,320);         -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3954,1,2,1000,@FORGOTTEN_POUCH_LEGS,320);          -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3954,1,2,1000,@FORGOTTEN_POUCH_FEET,320);          -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3954,1,2,1000,1450,13);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3954,1,2,1000,1453,13);                            -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3954,1,2,1000,1456,14);                            -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3954,1,3,1000,@FORGOTTEN_POUCH_HANDS,320);         -- Forgotten pouch touch (96%)
INSERT INTO `mob_droplist` VALUES (3954,1,3,1000,@FORGOTTEN_POUCH_LEGS,320);          -- Forgotten pouch journey (96%)
INSERT INTO `mob_droplist` VALUES (3954,1,3,1000,@FORGOTTEN_POUCH_FEET,320);          -- Forgotten pouch step (96%)
INSERT INTO `mob_droplist` VALUES (3954,1,3,1000,1450,13);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3954,1,3,1000,1453,14);                            -- Montiont Silverpiece (4%)
INSERT INTO `mob_droplist` VALUES (3954,1,3,1000,1456,13);                            -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3954,2,0,1000,1449,0);                             -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3954,2,0,1000,1452,0);                             -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3954,2,0,1000,1455,0);                             -- One Byne Bill (Steal)

-- ZoneID:  188 - Arch Goblin Golem (NQ)
INSERT INTO `mob_droplist` VALUES (3953,0,0,1000,19141,@UNCOMMON);                    -- Oneiros knife (Uncommon, 15%)
INSERT INTO `mob_droplist` VALUES (3953,0,0,1000,11819,@UNCOMMON);                    -- Oneiros coif (Uncommon, 15%)
INSERT INTO `mob_droplist` VALUES (3953,0,0,1000,18811,@UNCOMMON);                    -- Oneiros grip (Uncommon, 15%)
INSERT INTO `mob_droplist` VALUES (3953,0,0,1000,1474,250);                           -- Infinity core (25%)
INSERT INTO `mob_droplist` VALUES (3953,1,1,1000,@FORGOTTEN_POUCH_HANDS,316);         -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3953,1,1,1000,@FORGOTTEN_POUCH_LEGS,317);          -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3953,1,1,1000,@FORGOTTEN_POUCH_FEET,317);          -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (3953,1,1,1000,1450,16);                            -- Lungo-Nango-Nango jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3953,1,1,1000,1453,17);                            -- Montiont silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3953,1,1,1000,1456,17);                            -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3953,1,2,1000,@FORGOTTEN_POUCH_HANDS,316);         -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3953,1,2,1000,@FORGOTTEN_POUCH_LEGS,317);          -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3953,1,2,1000,@FORGOTTEN_POUCH_FEET,317);          -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (3953,1,2,1000,1450,16);                            -- Lungo-Nango-Nango jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3953,1,2,1000,1453,17);                            -- Montiont silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3953,1,2,1000,1456,17);                            -- One Hundred byne bill (5%)
INSERT INTO `mob_droplist` VALUES (3953,1,3,1000,@FORGOTTEN_POUCH_HANDS,316);         -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3953,1,3,1000,@FORGOTTEN_POUCH_LEGS,317);          -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3953,1,3,1000,@FORGOTTEN_POUCH_FEET,317);          -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (3953,1,3,1000,1450,16);                            -- Lungo-Nango-Nango jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3953,1,3,1000,1453,17);                            -- Montiont silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3953,1,3,1000,1456,17);                            -- One Hundred byne bill (5%)

-- ZoneID:  188 - Arch Goblin Golem (HQ/White Proc)
INSERT INTO `mob_droplist` VALUES (3952,0,0,1000,19141,200);                          -- Oneiros knife (20%)
INSERT INTO `mob_droplist` VALUES (3952,0,0,1000,11819,200);                          -- Oneiros coif (20%)
INSERT INTO `mob_droplist` VALUES (3952,0,0,1000,18811,200);                          -- Oneiros grip (20%)
INSERT INTO `mob_droplist` VALUES (3952,0,0,1000,1474,500);                           -- Infinity core (50%)
INSERT INTO `mob_droplist` VALUES (3952,0,0,1000,@FORGOTTEN_POUCH_HANDS,333);         -- Forgotten pouch touch (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3952,0,0,1000,@FORGOTTEN_POUCH_LEGS,333);          -- Forgotten pouch journey (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3952,0,0,1000,@FORGOTTEN_POUCH_FEET,334);          -- Forgotten pouch step (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3952,1,1,1000,@FORGOTTEN_POUCH_HANDS,308);         -- Forgotten pouch touch (92.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,1,1000,@FORGOTTEN_POUCH_LEGS,308);          -- Forgotten pouch journey (92.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,1,1000,@FORGOTTEN_POUCH_FEET,309);          -- Forgotten pouch step (92.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,1,1000,1450,25);                            -- Lungo-Nango-Nango jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,1,1000,1453,25);                            -- Montiont silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,1,1000,1456,25);                            -- One Hundred byne bill (7.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,2,1000,@FORGOTTEN_POUCH_HANDS,308);         -- Forgotten pouch touch (92.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,2,1000,@FORGOTTEN_POUCH_LEGS,308);          -- Forgotten pouch journey (92.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,2,1000,@FORGOTTEN_POUCH_FEET,309);          -- Forgotten pouch step (92.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,2,1000,1450,25);                            -- Lungo-Nango-Nango jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,2,1000,1453,25);                            -- Montiont silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,2,1000,1456,25);                            -- One Hundred byne bill (7.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,3,1000,@FORGOTTEN_POUCH_HANDS,308);         -- Forgotten pouch touch (92.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,3,1000,@FORGOTTEN_POUCH_LEGS,308);          -- Forgotten pouch journey (92.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,3,1000,@FORGOTTEN_POUCH_FEET,309);          -- Forgotten pouch step (92.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,3,1000,1450,25);                            -- Lungo-Nango-Nango jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,3,1000,1453,25);                            -- Montiont silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3952,1,3,1000,1456,25);                            -- One Hundred byne bill (7.5%)

-- --------------------------------------------------------------------
--                         Dynamis-Beaucedine                       --
-- --------------------------------------------------------------------

-- Ensure we're clearing out the old drop lists
DELETE FROM `mob_droplist` WHERE dropid = "176"; -- Delete Goblin NMs
DELETE FROM `mob_droplist` WHERE dropid = "261"; -- Delete Quadav NMs
DELETE FROM `mob_droplist` WHERE dropid = "265"; -- Delete Yagudo NMs
DELETE FROM `mob_droplist` WHERE dropId = "265" AND `itemId` = 1470; -- Delete Sparkling Stone
DELETE FROM `mob_droplist` WHERE dropid = "493"; -- Delete Orc NMs
DELETE FROM `mob_droplist` WHERE dropId = "493" AND `itemId` = 1470; -- Delete Sparkling Stone
DELETE FROM `mob_droplist` WHERE dropid = "559"; -- Delete Dagourmarche
DELETE FROM `mob_droplist` WHERE dropid = "1211"; -- Delete Goublefaupe
DELETE FROM `mob_droplist` WHERE dropid = "1343"; -- Delete Hydra Warrior
DELETE FROM `mob_droplist` WHERE dropid = "1344"; -- Delete Hydra Bard
DELETE FROM `mob_droplist` WHERE dropid = "1345"; -- Delete Hydra Monk/Ninja
DELETE FROM `mob_droplist` WHERE dropid = "1672"; -- Delete Mildaunegeux
DELETE FROM `mob_droplist` WHERE dropid = "2066"; -- Delete Quiebitiel
DELETE FROM `mob_droplist` WHERE dropid = "2542"; -- Delete Vanguard Goblins
DELETE FROM `mob_droplist` WHERE dropid = "2547"; -- Delete Vanguard Orcs
DELETE FROM `mob_droplist` WHERE dropId = "2547" AND `itemId` = 1470; -- Delete Sparkling Stone
DELETE FROM `mob_droplist` WHERE dropid = "2552"; -- Delete Vanguard Yagudos
DELETE FROM `mob_droplist` WHERE dropId = "2552" AND `itemId` = 1470; -- Delete Sparkling Stone
DELETE FROM `mob_droplist` WHERE dropid = "2557"; -- Delete Vanguard Quadavs
DELETE FROM `mob_droplist` WHERE dropid = "2574"; -- Delete Velosareon
DELETE FROM `mob_droplist` WHERE dropid = "3145"; -- Delete Hydra Ranger
DELETE FROM `mob_droplist` WHERE dropid = "3146"; -- Delete Hydra Summoner
DELETE FROM `mob_droplist` WHERE dropid = "3207"; -- Delete Angra Mainyu
DELETE FROM `mob_droplist` WHERE dropid = "3210"; -- Delete Hitaume
DELETE FROM `mob_droplist` WHERE dropid = "3211"; -- Delete Cavanneche
DELETE FROM `mob_droplist` WHERE dropid = "3212"; -- Delete Arch Angra Mainyu
DELETE FROM `mob_droplist` WHERE dropid = "3213"; -- Delete Hydra Paladin
DELETE FROM `mob_droplist` WHERE dropid = "3214"; -- Delete Hydra Red Mage
DELETE FROM `mob_droplist` WHERE dropid = "3215"; -- Delete Hydra White Mage
DELETE FROM `mob_droplist` WHERE dropid = "3216"; -- Delete Hydra Black Mage
DELETE FROM `mob_droplist` WHERE dropid = "3217"; -- Delete Hydra Thief
DELETE FROM `mob_droplist` WHERE dropid = "3218"; -- Delete Hydra Dark Knight/Hydra Samurai
DELETE FROM `mob_droplist` WHERE dropid = "3219"; -- Delete Hydra Beastmaster
DELETE FROM `mob_droplist` WHERE dropid = "3220"; -- Delete Hydra Dragoon
DELETE FROM `mob_droplist` WHERE dropid = "3221"; -- Delete Taquede
DELETE FROM `mob_droplist` WHERE dropid = "3222"; -- Delete Pignonpausard

-- Assign drop lists to bosses
UPDATE `mob_groups` SET `dropid` = 3207 WHERE name = 'Angra_Mainyu' AND zoneid = 134;
UPDATE `mob_groups` SET `dropid` = 3210 WHERE name = 'Hitaume' AND zoneid = 134;
UPDATE `mob_groups` SET `dropid` = 3211 WHERE name = 'Cavanneche' AND zoneid = 134;
UPDATE `mob_groups` SET `dropid` = 3212 WHERE name = 'Arch_Angra_Mainyu' AND zoneid = 134;
UPDATE `mob_groups` SET `dropid` = 3221 WHERE name = 'Taquede' AND zoneid = 134;
UPDATE `mob_groups` SET `dropid` = 3222 WHERE name = 'Pignonpausard' AND zoneid = 134;

-- ZoneID: 134 - Moltenox Stubthumbs
-- ZoneID: 134 - Droprix Granitepalms
-- ZoneID: 134 - Brewnix Bittypupils
-- ZoneID: 134 - Ascetox Ratgums
-- ZoneID: 134 - Gibberox Pimplebeak
-- ZoneID: 134 - Swypestix Tigershins
-- ZoneID: 134 - Bordox Kittyback
-- ZoneID: 134 - Ruffbix Jumbolobes
-- ZoneID: 134 - Draklix Scalecrust
-- ZoneID: 134 - Tocktix Thinlids
-- ZoneID: 134 - Routsix Rubbertendon
-- ZoneID: 134 - Morblox Chubbychin
-- ZoneID: 134 - Whistrix Toadthroat
-- ZoneID: 134 - Slinkix Trufflesniff
-- ZoneID: 134 - Shisox Widebrow
INSERT INTO `mob_droplist` VALUES (176,0,0,1000,3357,@VCOMMON);                    -- Leering Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (176,1,1,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (176,1,1,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,1,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,2,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (176,1,2,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,2,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,3,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (176,1,3,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,3,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,4,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (176,1,4,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,4,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,5,@COMMON,1449,334);                      -- Tukuku Whiteshell (33.4%)
INSERT INTO `mob_droplist` VALUES (176,1,5,@COMMON,1452,333);                      -- Ordelle Bronzepiece (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,5,@COMMON,1455,333);                      -- One Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (176,0,0,1000,1470,80);                          -- Sparkling Stone (8.0%)
INSERT INTO `mob_droplist` VALUES (176,0,0,1000,1520,80);                          -- Jar Of Goblin Grease (8.0%)
INSERT INTO `mob_droplist` VALUES (176,0,0,1000,3493,@UNCOMMON);                   -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,6,20,1450,334);                           -- Lungo-Nango-Nango Jadeshell (33.4%)
INSERT INTO `mob_droplist` VALUES (176,1,6,20,1453,333);                           -- Montiont Silverpiece (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,6,20,1456,333);                           -- One Hundred Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15088,67);                    -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15089,67);                    -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15090,67);                    -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15091,67);                    -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15094,67);                    -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15096,67);                    -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15098,67);                    -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15099,67);                    -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15100,67);                    -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15101,67);                    -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15117,66);                    -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15122,66);                    -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15123,66);                    -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15140,66);                    -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,7,@UNCOMMON,15142,66);                    -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,8,@UNCOMMON,11292,143);                   -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,8,@UNCOMMON,11295,143);                   -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,8,@UNCOMMON,11298,143);                   -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,8,@UNCOMMON,11307,143);                   -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,8,@UNCOMMON,16360,143);                   -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,8,@UNCOMMON,26840,143);                   -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,1,8,@UNCOMMON,27194,142);                   -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (176,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (176,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (176,2,0,1000,1455,0);                           -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Gunha Wallstormer  
-- ZoneID: 134 - Nahya Floodmaker   
-- ZoneID: 134 - Jifhu Infiltrator  
-- ZoneID: 134 - Gafho Venomtouch   
-- ZoneID: 134 - Tahyu Gallanthunter    
-- ZoneID: 134 - Nubhi Spiraleye    
-- ZoneID: 134 - Debho Pyrohand 
-- ZoneID: 134 - Gotyo Magenapper   
-- ZoneID: 134 - Sozho Metalbender  
-- ZoneID: 134 - Mugha Legionkiller 
-- ZoneID: 134 - Sogho Adderhandler 
-- ZoneID: 134 - Gukhu Dukesniper   
-- ZoneID: 134 - Jikhu Towercleaver 
-- ZoneID: 134 - Mirhe Whisperblade 
-- ZoneID: 134 - Bezhe Keeprazer    
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,3357,@VCOMMON);                    -- Leering Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,1455,@UNCOMMON);                   -- One Byne Bill (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,1455,@UNCOMMON);                   -- One Byne Bill (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,1455,@UNCOMMON);                   -- One Byne Bill (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,1455,@UNCOMMON);                   -- One Byne Bill (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,1455,@UNCOMMON);                   -- One Byne Bill (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,1469,80);                          -- Chunk Of Wootz Ore (8%)
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,1470,80);                          -- Sparkling Stone (8%)
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,1521,80);                          -- Vial Of Slime Juice (8%)
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,3493,@UNCOMMON);                   -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,0,0,1000,1456,@UNCOMMON);                   -- One Hundred Byne Bill (33.3%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15088,67);                    -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15089,67);                    -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15090,67);                    -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15091,67);                    -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15094,67);                    -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15096,67);                    -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15098,67);                    -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15099,67);                    -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15100,67);                    -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15101,67);                    -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15117,66);                    -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15122,66);                    -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15123,66);                    -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15140,66);                    -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,1,@UNCOMMON,15142,66);                    -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,2,@UNCOMMON,11292,143);                   -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,2,@UNCOMMON,11295,143);                   -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,2,@UNCOMMON,11298,143);                   -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,2,@UNCOMMON,11307,143);                   -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,2,@UNCOMMON,16360,143);                   -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,2,@UNCOMMON,26840,143);                   -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,1,2,@UNCOMMON,27194,142);                   -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (261,2,0,1000,1455,0);                           -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Foo Peku The Bloodcloak    
-- ZoneID: 134 - Xaa Chau The Roctalon  
-- ZoneID: 134 - Koo Saxu The Everfast  
-- ZoneID: 134 - Bhuu Wjato The Firepool    
-- ZoneID: 134 - Caa Xaza The Madpiercer    
-- ZoneID: 134 - Maa Zaua The Wyrmkeeper    
-- ZoneID: 134 - Ryy Qihi The Idolrobber    
-- ZoneID: 134 - Guu Waji The Preacher  
-- ZoneID: 134 - Nee Huxa The Judgmental    
-- ZoneID: 134 - Kuu Xuka The Nimble    
-- ZoneID: 134 - Soo Jopo The Fiendking 
-- ZoneID: 134 - Xhoo Fuza The Sublime  
-- ZoneID: 134 - Hee Mida The Meticulous    
-- ZoneID: 134 - Knii Hoqo The Bisector 
-- ZoneID: 134 - Puu Timu The Phantasmal    
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,3357,@VCOMMON);                    -- Leering Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,1449,@UNCOMMON);                   -- Tukuku Whiteshell (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,1449,@UNCOMMON);                   -- Tukuku Whiteshell (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,1449,@UNCOMMON);                   -- Tukuku Whiteshell (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,1449,@UNCOMMON);                   -- Tukuku Whiteshell (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,1449,@UNCOMMON);                   -- Tukuku Whiteshell (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,1466,80);                          -- Pile Of Relic Iron (8%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,1464,80);                          -- Lancewood Log (8%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,1470,80);                          -- Sparkling Stone (8%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,1518,80);                          -- Colossal Skull (8%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,3493,@UNCOMMON);                   -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,0,0,1000,1450,@UNCOMMON);                   -- Lungo-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15088,67);                    -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15089,67);                    -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15090,67);                    -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15091,67);                    -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15094,67);                    -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15096,67);                    -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15098,67);                    -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15099,67);                    -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15100,67);                    -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15101,67);                    -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15117,66);                    -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15122,66);                    -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15123,66);                    -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15140,66);                    -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,1,@UNCOMMON,15142,66);                    -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,2,@UNCOMMON,11292,143);                   -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,2,@UNCOMMON,11295,143);                   -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,2,@UNCOMMON,11298,143);                   -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,2,@UNCOMMON,11307,143);                   -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,2,@UNCOMMON,16360,143);                   -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,2,@UNCOMMON,26840,143);                   -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,1,2,@UNCOMMON,27194,142);                   -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (265,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
    
-- ZoneID: 134 - Humegutter Adzjbadj    
-- ZoneID: 134 - Jeunoraider Gepkzip    
-- ZoneID: 134 - Cobraclaw Buchzvotch   
-- ZoneID: 134 - Wraithdancer Gidbnod   
-- ZoneID: 134 - Galkarider Retzpratz   
-- ZoneID: 134 - Deathcaller Bidfbid    
-- ZoneID: 134 - Spinalsucker Galflmall 
-- ZoneID: 134 - Lockbuster Zapdjipp    
-- ZoneID: 134 - Heavymail Djidzbad 
-- ZoneID: 134 - Elvaanlopper Grokdok   
-- ZoneID: 134 - Skinmask Ugghfogg  
-- ZoneID: 134 - Taruroaster Biggsjig   
-- ZoneID: 134 - Mithraslaver Debhabob  
-- ZoneID: 134 - Ultrasonic Zeknajak    
-- ZoneID: 134 - Drakefeast Wubmfub 
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,3357,@VCOMMON);                    -- Leering Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,1452,@UNCOMMON);                   -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,1452,@UNCOMMON);                   -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,1452,@UNCOMMON);                   -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,1452,@UNCOMMON);                   -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,1452,@UNCOMMON);                   -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,1516,80);                          -- Griffon Hide (8%)
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,1517,80);                          -- Giant Frozen Head (8%)
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,1519,80);                          -- Fresh Orc Liver (8%)
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,3493,@UNCOMMON);                   -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,0,0,1000,1453,@UNCOMMON);                    -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15088,67);                    -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15089,67);                    -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15090,67);                    -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15091,67);                    -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15094,67);                    -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15096,67);                    -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15098,67);                    -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15099,67);                    -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15100,67);                    -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15101,67);                    -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15117,66);                    -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15122,66);                    -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15123,66);                    -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15140,66);                    -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,1,@UNCOMMON,15142,66);                    -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,2,@UNCOMMON,11292,143);                   -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,2,@UNCOMMON,11295,143);                   -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,2,@UNCOMMON,11298,143);                   -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,2,@UNCOMMON,11307,143);                   -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,2,@UNCOMMON,16360,143);                   -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,2,@UNCOMMON,26840,143);                   -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,1,2,@UNCOMMON,27194,142);                   -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (493,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
    
-- ZoneID: 134 - Hydra Warrior  
-- ZoneID: 134 - Hydra Warrior  
INSERT INTO `mob_droplist` VALUES (1343,0,0,1000,3359,@UNCOMMON);                  -- Despots Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,0,0,1000,3398,@UNCOMMON);                  -- Odious Tree Root (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1343,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1343,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1343,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Bard 
-- ZoneID: 134 - Hydra Bard 
INSERT INTO `mob_droplist` VALUES (1344,0,0,1000,3360,@UNCOMMON);                  -- Sadists Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,0,0,1000,3398,@UNCOMMON);                  -- Odious Tree Root (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1344,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1344,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1344,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Monk 
-- ZoneID: 134 - Hydra Ninja    
-- ZoneID: 134 - Hydra Monk 
-- ZoneID: 134 - Hydra Ninja    
INSERT INTO `mob_droplist` VALUES (1345,0,0,1000,3361,@UNCOMMON);                  -- Villains Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,0,0,1000,3398,@UNCOMMON);                  -- Odious Tree Root (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1345,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1345,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1345,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Vanguard Smithy    
-- ZoneID: 134 - Vanguard Pitfighter    
-- ZoneID: 134 - Vanguard Shaman    
-- ZoneID: 134 - Vanguard Enchanter 
-- ZoneID: 134 - Vanguard Pathfinder    
-- ZoneID: 134 - Vanguard Maestro   
-- ZoneID: 134 - Vanguard Welldigger    
-- ZoneID: 134 - Vanguard Armorer   
-- ZoneID: 134 - Vanguard Ambusher  
-- ZoneID: 134 - Vanguard Necromancer   
-- ZoneID: 134 - Vanguard Ronin 
-- ZoneID: 134 - Vanguard Hitman    
-- ZoneID: 134 - Vanguard Dragontamer   
-- ZoneID: 134 - Vanguard Alchemist 
-- ZoneID: 134 - Vanguard Tinkerer  
INSERT INTO `mob_droplist` VALUES (2542,0,0,1000,1470,@UNCOMMON);                  -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,0,0,1000,1520,@UNCOMMON);                  -- Jar Of Goblin Grease (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,3,20,15066,250);                         -- Relic Shield (2.0%)
INSERT INTO `mob_droplist` VALUES (2542,1,3,20,18326,250);                         -- Relic Staff (2.0%)
INSERT INTO `mob_droplist` VALUES (2542,1,3,20,18338,250);                         -- Relic Horn (2.0%)
INSERT INTO `mob_droplist` VALUES (2542,1,3,20,18344,250);                         -- Relic Bow (2.0%)
INSERT INTO `mob_droplist` VALUES (2542,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2542,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2542,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2542,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Vanguard Trooper   
-- ZoneID: 134 - Vanguard Neckchopper   
-- ZoneID: 134 - Vanguard Footsoldier   
-- ZoneID: 134 - Vanguard Vexer 
-- ZoneID: 134 - Vanguard Backstabber   
-- ZoneID: 134 - Vanguard Grappler  
-- ZoneID: 134 - Vanguard Gutslasher    
-- ZoneID: 134 - Vanguard Amputator 
-- ZoneID: 134 - Vanguard Impaler   
-- ZoneID: 134 - Vanguard Predator  
-- ZoneID: 134 - Vanguard Dollmaster    
-- ZoneID: 134 - Vanguard Mesmerizer    
-- ZoneID: 134 - Vanguard Hawker    
-- ZoneID: 134 - Vanguard Pillager  
-- ZoneID: 134 - Vanguard Bugler    
INSERT INTO `mob_droplist` VALUES (2547,0,0,1000,1516,@UNCOMMON);                  -- Griffon Hide (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,0,0,1000,1517,@UNCOMMON);                  -- Giant Frozen Head (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,0,0,1000,1519,@UNCOMMON);                  -- Fresh Orc Liver (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,3,20,18290,250);     	                   -- Relic Bhuj (2.0%)
INSERT INTO `mob_droplist` VALUES (2547,1,3,20,18296,250);     	                   -- Relic Lance (2.0%)
INSERT INTO `mob_droplist` VALUES (2547,1,3,20,18308,250);     	                   -- Ihintanto (2.0%)
INSERT INTO `mob_droplist` VALUES (2547,1,3,20,18332,250);     	                   -- Relic Gun (2.0%)
INSERT INTO `mob_droplist` VALUES (2547,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2547,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
    
-- ZoneID: 134 - Vanguard Sentinel  
-- ZoneID: 134 - Vanguard Assassin  
-- ZoneID: 134 - Vanguard Skirmisher    
-- ZoneID: 134 - Vanguard Visionary 
-- ZoneID: 134 - Vanguard Liberator 
-- ZoneID: 134 - Vanguard Exemplar  
-- ZoneID: 134 - Vanguard Ogresoother   
-- ZoneID: 134 - Vanguard Priest    
-- ZoneID: 134 - Vanguard Inciter   
-- ZoneID: 134 - Vanguard Chanter   
-- ZoneID: 134 - Vanguard Prelate   
-- ZoneID: 134 - Vanguard Partisan  
-- ZoneID: 134 - Vanguard Salvager  
-- ZoneID: 134 - Vanguard Oracle    
-- ZoneID: 134 - Vanguard Persecutor    
INSERT INTO `mob_droplist` VALUES (2552,0,0,1000,1464,@UNCOMMON);                  -- Lancewood Log (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,0,0,1000,1466,@UNCOMMON);                  -- Pile Of Relic Iron (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,0,0,1000,1518,@UNCOMMON);                  -- Colossal Skull (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,3,20,18260,250);                         -- Relic Knuckles (2.0%)
INSERT INTO `mob_droplist` VALUES (2552,1,3,20,18266,250);                         -- Relic Dagger (2.0%)
INSERT INTO `mob_droplist` VALUES (2552,1,3,20,18272,250);                         -- Relic Sword (2.0%)
INSERT INTO `mob_droplist` VALUES (2552,1,3,20,18320,250);                         -- Relic Maul (2.0%)
INSERT INTO `mob_droplist` VALUES (2552,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2552,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
    
-- ZoneID: 134 - Vanguard Vindicator    
-- ZoneID: 134 - Vanguard Protector 
-- ZoneID: 134 - Vanguard Beasttender   
-- ZoneID: 134 - Vanguard Minstrel  
-- ZoneID: 134 - Vanguard Militant  
-- ZoneID: 134 - Vanguard Drakekeeper   
-- ZoneID: 134 - Vanguard Constable 
-- ZoneID: 134 - Vanguard Defender  
-- ZoneID: 134 - Vanguard Hatamoto  
-- ZoneID: 134 - Vanguard Kusa  
-- ZoneID: 134 - Vanguard Purloiner 
-- ZoneID: 134 - Vanguard Mason 
-- ZoneID: 134 - Vanguard Undertaker    
-- ZoneID: 134 - Vanguard Vigilante 
-- ZoneID: 134 - Vanguard Thaumaturge   
INSERT INTO `mob_droplist` VALUES (2557,0,0,1000,1469,@UNCOMMON);                  -- Chunk Of Wootz Ore (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,0,0,1000,1470,@UNCOMMON);                  -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,0,0,1000,1521,@UNCOMMON);                  -- Vial Of Slime Juice (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,3,20,18278,250);                         -- Relic Blade (2.0%)
INSERT INTO `mob_droplist` VALUES (2557,1,3,20,18284,250);                         -- Relic Axe (2.0%)
INSERT INTO `mob_droplist` VALUES (2557,1,3,20,18302,250);                         -- Relic Scythe (2.0%)
INSERT INTO `mob_droplist` VALUES (2557,1,3,20,18314,250);                         -- Ito (2.0%)
INSERT INTO `mob_droplist` VALUES (2557,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2557,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Ranger   
-- ZoneID: 134 - Hydra Ranger   
INSERT INTO `mob_droplist` VALUES (3145,0,0,1000,3362,@UNCOMMON);                  -- Deluders Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,0,0,1000,3396,@UNCOMMON);                  -- Odious Talisman (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3145,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3145,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3145,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Summoner 
-- ZoneID: 134 - Hydra Summoner 
INSERT INTO `mob_droplist` VALUES (3146,0,0,1000,3363,@UNCOMMON);                  -- Traitors Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,0,0,1000,3396,@UNCOMMON);                  -- Odious Talisman (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3146,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3146,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3146,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Paladin  
-- ZoneID: 134 - Hydra Paladin  
INSERT INTO `mob_droplist` VALUES (3213,0,0,1000,3359,@UNCOMMON);                  -- Despots Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,0,0,1000,3396,@UNCOMMON);                  -- Odious Talisman (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3213,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3213,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3213,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Red Mage 
-- ZoneID: 134 - Hydra Red Mage 
INSERT INTO `mob_droplist` VALUES (3214,0,0,1000,3359,@UNCOMMON);                  -- Despots Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,0,0,1000,3397,@UNCOMMON);                  -- Odious Bell (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3214,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3214,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3214,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra White Mage   
-- ZoneID: 134 - Hydra White Mage   
INSERT INTO `mob_droplist` VALUES (3215,0,0,1000,3360,@UNCOMMON);                  -- Sadists Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,0,0,1000,3399,@UNCOMMON);                  -- Odious Mirror (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3215,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3215,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3215,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Black Mage   
-- ZoneID: 134 - Hydra Black Mage   
INSERT INTO `mob_droplist` VALUES (3216,0,0,1000,3360,@UNCOMMON);                  -- Sadists Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,0,0,1000,3396,@UNCOMMON);                  -- Odious Talisman (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3216,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3216,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3216,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Thief    
-- ZoneID: 134 - Hydra Thief    
INSERT INTO `mob_droplist` VALUES (3217,0,0,1000,3361,@UNCOMMON);                  -- Villains Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,0,0,1000,3399,@UNCOMMON);                  -- Odious Mirror (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3217,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3217,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3217,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Dark Knight  
-- ZoneID: 134 - Hydra Samurai  
-- ZoneID: 134 - Hydra Dark Knight  
-- ZoneID: 134 - Hydra Samurai  
INSERT INTO `mob_droplist` VALUES (3218,0,0,1000,3362,@UNCOMMON);                  -- Deluders Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,0,0,1000,3397,@UNCOMMON);                  -- Odious Bell (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3218,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3218,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3218,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Beastmaster  
-- ZoneID: 134 - Hydra Beastmaster  
INSERT INTO `mob_droplist` VALUES (3219,0,0,1000,3363,@UNCOMMON);                  -- Traitors Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,0,0,1000,3397,@UNCOMMON);                  -- Odious Bell (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3219,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3219,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3219,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Hydra Dragoon  
-- ZoneID: 134 - Hydra Dragoon  
INSERT INTO `mob_droplist` VALUES (3220,0,0,1000,3363,@UNCOMMON);                  -- Traitors Fortune Parchment (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,0,0,1000,3399,@UNCOMMON);                  -- Odious Mirror (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,0,0,1000,3493,@UNCOMMON);                  -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15088,67);                   -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15089,67);                   -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15090,67);                   -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15091,67);                   -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15094,67);                   -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15096,67);                   -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15098,67);                   -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15099,67);                   -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15100,67);                   -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15101,67);                   -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15117,66);                   -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15122,66);                   -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15123,66);                   -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15140,66);                   -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,1,@UNCOMMON,15142,66);                   -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,2,@UNCOMMON,11292,143);                  -- Mirage Jubbah (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,2,@UNCOMMON,11295,143);                  -- Commodore Frac (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,2,@UNCOMMON,11298,143);                  -- Pantin Tobe (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,2,@UNCOMMON,11307,143);                  -- Argute Gown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,2,@UNCOMMON,16360,143);                  -- Etoile Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,2,@UNCOMMON,26840,143);                  -- Bagua Tunic (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,1,2,@UNCOMMON,27194,142);                  -- Futhark Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3220,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3220,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3220,2,0,1000,1455,0);                          -- One Byne Bill (Steal)
    
-- ZoneID: 134 - Dagourmarche   
INSERT INTO `mob_droplist` VALUES (559,1,1,1000,1560,334);                         -- Attestation Of Bravery (100%)
INSERT INTO `mob_droplist` VALUES (559,1,1,1000,1563,333);                         -- Attestation Of Fortitude (100%)
INSERT INTO `mob_droplist` VALUES (559,1,1,1000,1567,333);                         -- Attestation Of Virtue (100%)
INSERT INTO `mob_droplist` VALUES (559,1,2,30,1450,334);                             -- Lungo-Nango-Nango Jadeshell (3%)
INSERT INTO `mob_droplist` VALUES (559,1,2,30,1453,333);                             -- Montiont Silverpiece (3%)
INSERT INTO `mob_droplist` VALUES (559,1,2,30,1456,333);                             -- One Hundred Byne Bill (3%)
    
-- ZoneID: 134 - Goublefaupe    
INSERT INTO `mob_droplist` VALUES (1211,1,1,1000,1558,250);                        -- Attestation Of Glory (100%)
INSERT INTO `mob_droplist` VALUES (1211,1,1,1000,1559,250);                        -- Attestation Of Righteousness (100%)
INSERT INTO `mob_droplist` VALUES (1211,1,1,1000,1561,250);                        -- Attestation Of Force (100%)
INSERT INTO `mob_droplist` VALUES (1211,1,1,1000,1821,250);                        -- Attestation Of Invulnerability (100%)
INSERT INTO `mob_droplist` VALUES (1211,1,2,30,1450,334);                            -- Lungo-Nango-Nango Jadeshell (3%)
INSERT INTO `mob_droplist` VALUES (1211,1,2,30,1453,333);                            -- Montiont Silverpiece (3%)
INSERT INTO `mob_droplist` VALUES (1211,1,2,30,1456,333);                            -- One Hundred Byne Bill (3%)
    
-- ZoneID: 134 - Mildaunegeux   
INSERT INTO `mob_droplist` VALUES (1672,1,1,1000,1556,334);                        -- Attestation Of Might (100%)
INSERT INTO `mob_droplist` VALUES (1672,1,1,1000,1564,333);                        -- Attestation Of Legerity (100%)
INSERT INTO `mob_droplist` VALUES (1672,1,1,1000,1570,333);                        -- Attestation Of Accuracy (100%)
INSERT INTO `mob_droplist` VALUES (1672,1,2,30,1450,334);                            -- Lungo-Nango-Nango Jadeshell (3%)
INSERT INTO `mob_droplist` VALUES (1672,1,2,30,1453,333);                            -- Montiont Silverpiece (3%)
INSERT INTO `mob_droplist` VALUES (1672,1,2,30,1456,333);                            -- One Hundred Byne Bill (3%)
    
-- ZoneID: 134 - Quiebitiel 
INSERT INTO `mob_droplist` VALUES (2066,1,1,1000,1557,334);                        -- Attestation Of Celerity (100%)
INSERT INTO `mob_droplist` VALUES (2066,1,1,1000,1566,333);                        -- Attestation Of Sacrifice (100%)
INSERT INTO `mob_droplist` VALUES (2066,1,1,1000,1569,333);                        -- Attestation Of Harmony (100%)
INSERT INTO `mob_droplist` VALUES (2066,1,2,30,1450,334);                            -- Lungo-Nango-Nango Jadeshell (3%)
INSERT INTO `mob_droplist` VALUES (2066,1,2,30,1453,333);                            -- Montiont Silverpiece (3%)
INSERT INTO `mob_droplist` VALUES (2066,1,2,30,1456,333);                            -- One Hundred Byne Bill (3%)

-- ZoneID: 134 - Velosareon
INSERT INTO `mob_droplist` VALUES (2574,1,1,1000,1562,334);                        -- Attestation Of Vigor (100%)
INSERT INTO `mob_droplist` VALUES (2574,1,1,1000,1565,333);                        -- Attestation Of Decisiveness (100%)
INSERT INTO `mob_droplist` VALUES (2574,1,1,1000,1568,333);                        -- Attestation Of Transcendence (100%)
INSERT INTO `mob_droplist` VALUES (2574,1,2,30,1450,334);                            -- Lungo-Nango-Nango Jadeshell (3%)
INSERT INTO `mob_droplist` VALUES (2574,1,2,30,1453,333);                            -- Montiont Silverpiece (3%)
INSERT INTO `mob_droplist` VALUES (2574,1,2,30,1456,333);                            -- One Hundred Byne Bill (3%)

-- ZoneID: 134 - Angra Mainyu
INSERT INTO `mob_droplist` VALUES (3207,0,0,1000,3424,@ALWAYS);                     -- Fiendish Tome Chapter 21 (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (3207,0,0,1000,@FORGOTTEN_POUCH_HEAD,@ALWAYS);    -- Forgotten pouch tought (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3207,1,1,1000,@FORGOTTEN_POUCH_HEAD,970);        -- Forgotten pouch tought (97%)
INSERT INTO `mob_droplist` VALUES (3207,1,1,1000,1450,10);                            -- Lungo-Nango-Nango Jadeshell (3%)
INSERT INTO `mob_droplist` VALUES (3207,1,1,1000,1453,10);                            -- Montiont Silverpiece (3%)
INSERT INTO `mob_droplist` VALUES (3207,1,1,1000,1456,10);                            -- One Hundred Byne Bill (3%)
INSERT INTO `mob_droplist` VALUES (3207,0,0,1000,11628,50);                         -- Angra Mainyu - strigoi_ring
INSERT INTO `mob_droplist` VALUES (3207,0,0,1000,2473,100);                         -- Angra Mainyu - nethercant_chain
INSERT INTO `mob_droplist` VALUES (3207,0,0,1000,11586,100);                        -- Angra Mainyu - backlash_torque
INSERT INTO `mob_droplist` VALUES (3207,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3207,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3207,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 134 - Taquede
INSERT INTO `mob_droplist` VALUES (3221,0,0,1000,3425,@ALWAYS);                     -- Fiendish Tome: Chapter 22 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3221,1,1,1000,11456,130);                        -- Ryuga Sune-Ate (13%)
INSERT INTO `mob_droplist` VALUES (3221,1,1,1000,@FORGOTTEN_POUCH_HEAD,870);        -- Forgotten pouch tought (87%)
-- INSERT INTO `mob_droplist` VALUES (3221,0,0,1000,@FORGOTTEN_POUCH_HEAD,@ALWAYS);    -- Forgotten pouch tought (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3221,1,2,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3221,1,2,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3221,1,2,1000,1453,17);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3221,1,2,1000,1456,17);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3221,1,3,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3221,1,3,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3221,1,3,1000,1453,17);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3221,1,3,1000,1456,17);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3221,1,4,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3221,1,4,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3221,1,4,1000,1453,16);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3221,1,4,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (3221,1,5,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
-- INSERT INTO `mob_droplist` VALUES (3221,1,5,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (3221,1,5,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (3221,1,5,1000,1456,16);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3221,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3221,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3221,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 134 - Pignonpausard
INSERT INTO `mob_droplist` VALUES (3222,0,0,1000,3426,@ALWAYS);                     -- Fiendish Tome: Chapter 23 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3222,1,1,1000,11820,130);                        -- Khthonios Mask (13%)
INSERT INTO `mob_droplist` VALUES (3222,1,1,1000,@FORGOTTEN_POUCH_HEAD,870);        -- Forgotten pouch tought (87%)
-- INSERT INTO `mob_droplist` VALUES (3222,0,0,1000,@FORGOTTEN_POUCH_HEAD,@ALWAYS);    -- Forgotten pouch tought (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3222,1,2,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3222,1,2,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3222,1,2,1000,1453,17);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3222,1,2,1000,1456,17);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3222,1,3,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3222,1,3,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3222,1,3,1000,1453,17);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3222,1,3,1000,1456,17);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3222,1,4,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3222,1,4,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3222,1,4,1000,1453,16);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3222,1,4,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (3222,1,5,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
-- INSERT INTO `mob_droplist` VALUES (3222,1,5,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (3222,1,5,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (3222,1,5,1000,1456,16);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3222,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3222,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3222,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 134 - Hitaume
INSERT INTO `mob_droplist` VALUES (3210,0,0,1000,3427,@ALWAYS);                     -- Fiendish Tome: Chapter 24 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3210,1,1,1000,11918,130);                        -- Khthonios Gloves (13%)
INSERT INTO `mob_droplist` VALUES (3210,1,1,1000,@FORGOTTEN_POUCH_HEAD,870);        -- Forgotten pouch tought (87%)
-- INSERT INTO `mob_droplist` VALUES (3210,0,0,1000,@FORGOTTEN_POUCH_HEAD,@ALWAYS);    -- Forgotten pouch tought (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3210,1,2,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3210,1,2,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3210,1,2,1000,1453,17);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3210,1,2,1000,1456,17);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3210,1,3,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3210,1,3,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3210,1,3,1000,1453,17);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3210,1,3,1000,1456,17);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3210,1,4,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3210,1,4,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3210,1,4,1000,1453,16);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3210,1,4,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (3210,1,5,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
-- INSERT INTO `mob_droplist` VALUES (3210,1,5,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (3210,1,5,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (3210,1,5,1000,1456,16);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3210,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3210,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3210,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 134 - Cavanneche
INSERT INTO `mob_droplist` VALUES (3211,0,0,1000,3428,@ALWAYS);                     -- Fiendish Tome: Chapter 25 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3211,1,1,1000,11821,130);                        -- Khthonios Helm (13%)
INSERT INTO `mob_droplist` VALUES (3211,1,1,1000,@FORGOTTEN_POUCH_HEAD,870);        -- Forgotten pouch tought (87%)
-- INSERT INTO `mob_droplist` VALUES (3211,0,0,1000,@FORGOTTEN_POUCH_HEAD,@ALWAYS);    -- Forgotten pouch tought (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3211,1,2,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3211,1,2,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3211,1,2,1000,1453,17);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3211,1,2,1000,1456,17);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3211,1,3,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3211,1,3,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3211,1,3,1000,1453,17);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3211,1,3,1000,1456,17);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3211,1,4,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
INSERT INTO `mob_droplist` VALUES (3211,1,4,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3211,1,4,1000,1453,16);                            -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3211,1,4,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (3211,1,5,1000,@FORGOTTEN_POUCH_HEAD,950);        -- Forgotten pouch tought (95%)
-- INSERT INTO `mob_droplist` VALUES (3211,1,5,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (3211,1,5,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (3211,1,5,1000,1456,16);                            -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3211,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3211,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3211,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 134 - Arch Angra Mainyu
INSERT INTO `mob_droplist` VALUES (3212,0,0,1000,11919,@COMMON);                    -- Avesta Bangles (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3212,0,0,1000,18623,@COMMON);                    -- Chtonic Staff (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3212,0,0,1000,19763,@COMMON);                    -- Oneiros Cluster (Common, 15%)
INSERT INTO `mob_droplist` VALUES (3212,0,0,1000,@FORGOTTEN_POUCH_HEAD,@ALWAYS);    -- Forgotten Thought (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3212,1,1,1000,@FORGOTTEN_POUCH_HEAD,900);        -- Forgotten Thought (90%)
INSERT INTO `mob_droplist` VALUES (3212,1,1,1000,1450,34);                            -- Lungo-Nango-Nango Jadeshell (10%)
INSERT INTO `mob_droplist` VALUES (3212,1,1,1000,1453,33);                            -- Montiont Silverpiece (10%)
INSERT INTO `mob_droplist` VALUES (3212,1,1,1000,1456,33);                            -- One Hundred Byne Bill (10%)
INSERT INTO `mob_droplist` VALUES (3212,1,2,1000,@FORGOTTEN_POUCH_HEAD,900);        -- Forgotten Thought (90%)
INSERT INTO `mob_droplist` VALUES (3212,1,2,1000,1450,33);                            -- Lungo-Nango-Nango Jadeshell (10%)
INSERT INTO `mob_droplist` VALUES (3212,1,2,1000,1453,34);                            -- Montiont Silverpiece (10%)
INSERT INTO `mob_droplist` VALUES (3212,1,2,1000,1456,33);                            -- One Hundred Byne Bill (10%)
INSERT INTO `mob_droplist` VALUES (3212,1,3,1000,@FORGOTTEN_POUCH_HEAD,900);        -- Forgotten Thought (90%)
INSERT INTO `mob_droplist` VALUES (3212,1,3,1000,1450,33);                            -- Lungo-Nango-Nango Jadeshell (10%)
INSERT INTO `mob_droplist` VALUES (3212,1,3,1000,1453,33);                            -- Montiont Silverpiece (10%)
INSERT INTO `mob_droplist` VALUES (3212,1,3,1000,1456,34);                            -- One Hundred Byne Bill (10%)
-- INSERT INTO `mob_droplist` VALUES (3212,1,4,1000,@FORGOTTEN_POUCH_HEAD,900);        -- Forgotten Thought (90%)
-- INSERT INTO `mob_droplist` VALUES (3212,1,4,1000,1450,34);                            -- Lungo-Nango-Nango Jadeshell (10%)
-- INSERT INTO `mob_droplist` VALUES (3212,1,4,1000,1453,33);                            -- Montiont Silverpiece (10%)
-- INSERT INTO `mob_droplist` VALUES (3212,1,4,1000,1456,33);                            -- One Hundred Byne Bill (Uncommon, 10%)
-- INSERT INTO `mob_droplist` VALUES (3212,1,5,@UNCOMMON,1450,34);                           -- Lungo-Nango-Nango Jadeshell (Uncommon, 10%) -- Added uniquely to compensate for the running and boss length - TENTATIVE, MAY NOT IMPLIMENT
-- INSERT INTO `mob_droplist` VALUES (3212,1,5,@UNCOMMON,1453,33);                           -- Montiont Silverpiece (Uncommon, 10%)
-- INSERT INTO `mob_droplist` VALUES (3212,1,5,@UNCOMMON,1456,33);                           -- One Hundred Byne Bill (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3212,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3212,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3212,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- --------------------------------------------------------------------
--                          Dynamis-Xarcabard                        --
-- --------------------------------------------------------------------

-- Ensure we're clearing out the old drop lists
DELETE FROM `mob_droplist` WHERE dropid = "519";  -- Count Raum
DELETE FROM `mob_droplist` WHERE dropid = "520";  -- Count Vine
DELETE FROM `mob_droplist` WHERE dropid = "521";  -- Count Zaebos
DELETE FROM `mob_droplist` WHERE dropid = "714";  -- Duke Berith
DELETE FROM `mob_droplist` WHERE dropid = "715";  -- Duke Gomory
DELETE FROM `mob_droplist` WHERE dropid = "717";  -- Duke Scox
DELETE FROM `mob_droplist` WHERE dropid = "730";  -- Delete Dynamis Lord
DELETE FROM `mob_droplist` WHERE dropid = "1442"; -- Kindred Demons
DELETE FROM `mob_droplist` WHERE dropid = "1452"; -- King Zagan
DELETE FROM `mob_droplist` WHERE dropid = "1624"; -- Marquis Andras
DELETE FROM `mob_droplist` WHERE dropid = "1625"; -- Marquis Cimeries
DELETE FROM `mob_droplist` WHERE dropid = "1626"; -- Marquis Decarabia
DELETE FROM `mob_droplist` WHERE dropid = "1628"; -- Marquis Gamygyn
DELETE FROM `mob_droplist` WHERE dropid = "1629"; -- Marquis Nebiros
DELETE FROM `mob_droplist` WHERE dropid = "1630"; -- Marquis Orias
DELETE FROM `mob_droplist` WHERE dropid = "1631"; -- Marquis Sabnak
DELETE FROM `mob_droplist` WHERE dropid = "2021"; -- Delete Prince Seere
DELETE FROM `mob_droplist` WHERE dropid = "2559"; -- Delete Vanguard Dragon

-- Assign drop lists to bosses
UPDATE `mob_groups` SET `dropid` = 730 WHERE name = 'Dynamis_Lord' AND zoneid = 135;
UPDATE `mob_groups` SET `dropid` = 4001 WHERE name = 'Baron_Avnas' AND zoneid = 135;
UPDATE `mob_groups` SET `dropid` = 4002 WHERE name = 'Marquis_Caim' AND zoneid = 135;
UPDATE `mob_groups` SET `dropid` = 4003 WHERE name = 'Duke_Haures' AND zoneid = 135;
UPDATE `mob_groups` SET `dropid` = 4004 WHERE name = 'Count_Haagenti' AND zoneid = 135;
UPDATE `mob_groups` SET `dropid` = 4005 WHERE name = 'Arch_Dynamis_Lord' AND zoneid = 135;

-- ZoneID: 135 - Kindred Paladin
-- ZoneID: 135 - Kindred Dark Knight
-- ZoneID: 135 - Kindred Beastmaster
-- ZoneID: 135 - Kindred Ranger
-- ZoneID: 135 - Kindred Bard
-- ZoneID: 135 - Kindred Samurai
-- ZoneID: 135 - Kindred Ninja
-- ZoneID: 135 - Kindred Summoner
-- ZoneID: 135 - Kindred Dragoon
-- ZoneID: 135 - Kindred White Mage
-- ZoneID: 135 - Kindred Black Mage
-- ZoneID: 135 - Kindred Red Mage
-- ZoneID: 135 - Kindred Warrior
-- ZoneID: 135 - Kindred Monk
-- ZoneID: 135 - Kindred Thief
-- ZoneID: 135 - Kindred Warrior
-- ZoneID: 135 - Kindred White Mage
-- ZoneID: 135 - Kindred Red Mage
-- ZoneID: 135 - Kindred Monk
-- ZoneID: 135 - Kindred Black Mage
-- ZoneID: 135 - Kindred Thief
-- ZoneID: 135 - Kindred Paladin
-- ZoneID: 135 - Kindred Dark Knight
-- ZoneID: 135 - Kindred Beastmaster
-- ZoneID: 135 - Kindred Bard
-- ZoneID: 135 - Kindred Ranger
-- ZoneID: 135 - Kindred Samurai
-- ZoneID: 135 - Kindred Ninja
-- ZoneID: 135 - Kindred Dragoon
-- ZoneID: 135 - Kindred Summoner
-- INSERT INTO `mob_droplist` VALUES (1442,1,1,75,3400,250);                   -- Odious Skull (7.5%)
-- INSERT INTO `mob_droplist` VALUES (1442,1,1,75,3401,250);                   -- Odious Horn (7.5%)
-- INSERT INTO `mob_droplist` VALUES (1442,1,1,75,3402,250);                   -- Odious Blood (7.5%)
-- INSERT INTO `mob_droplist` VALUES (1442,1,1,75,3403,250);                   -- Odious Pen (7.5%)
INSERT INTO `mob_droplist` VALUES (1442,0,0,1000,3494,@UNCOMMON);                  -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15073,67);                   -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15075,67);                   -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15076,67);                   -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15079,67);                   -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15083,67);                   -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15085,67);                   -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15086,67);                   -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15087,67);                   -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15093,67);                   -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15097,67);                   -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15104,66);                   -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15107,66);                   -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15110,66);                   -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15114,66);                   -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,2,@UNCOMMON,15126,66);                   -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,3,@UNCOMMON,11480,143);                  -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,3,@UNCOMMON,11468,143);                  -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,3,@UNCOMMON,11305,143);                  -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,3,@UNCOMMON,11465,143);                  -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,3,@UNCOMMON,11471,143);                  -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,3,@UNCOMMON,26664,143);                  -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,1,3,@UNCOMMON,26842,142);                  -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1442,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1442,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1442,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 135 - Count Raum
INSERT INTO `mob_droplist` VALUES (519,0,0,1000,4249,@ALWAYS);                     -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (519,0,0,1000,3358,@VCOMMON);                    -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (519,0,0,1000,3494,@UNCOMMON);                   -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,1,@COMMON,1449,333);                      -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (519,1,1,@COMMON,1452,333);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (519,1,1,@COMMON,1455,334);                      -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15073,67);                    -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15075,67);                    -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15076,67);                    -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15079,67);                    -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15083,67);                    -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15085,67);                    -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15086,67);                    -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15087,67);                    -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15093,67);                    -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15097,67);                    -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15104,66);                    -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15107,66);                    -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15110,66);                    -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15114,66);                    -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,2,@UNCOMMON,15126,66);                    -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,3,@UNCOMMON,11480,143);                   -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,3,@UNCOMMON,11468,143);                   -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,3,@UNCOMMON,11305,143);                   -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,3,@UNCOMMON,11465,143);                   -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,3,@UNCOMMON,11471,143);                   -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,3,@UNCOMMON,26664,143);                   -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,3,@UNCOMMON,26842,142);                   -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (519,1,4,@RARE,1450,333);                         -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (519,1,4,@RARE,1453,333);                         -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (519,1,4,@RARE,1456,334);                         -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (519,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (519,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (519,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 135 - Count Vine
INSERT INTO `mob_droplist` VALUES (520,0,0,1000,4249,@ALWAYS);                     -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (520,0,0,1000,3358,@VCOMMON);                    -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (520,0,0,1000,3494,@UNCOMMON);                   -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,1,@COMMON,1449,333);                      -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (520,1,1,@COMMON,1452,333);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (520,1,1,@COMMON,1455,334);                      -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15073,67);                    -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15075,67);                    -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15076,67);                    -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15079,67);                    -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15083,67);                    -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15085,67);                    -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15086,67);                    -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15087,67);                    -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15093,67);                    -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15097,67);                    -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15104,66);                    -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15107,66);                    -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15110,66);                    -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15114,66);                    -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,2,@UNCOMMON,15126,66);                    -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,3,@UNCOMMON,11480,143);                   -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,3,@UNCOMMON,11468,143);                   -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,3,@UNCOMMON,11305,143);                   -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,3,@UNCOMMON,11465,143);                   -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,3,@UNCOMMON,11471,143);                   -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,3,@UNCOMMON,26664,143);                   -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,3,@UNCOMMON,26842,142);                   -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (520,1,4,@RARE,1450,333);                         -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (520,1,4,@RARE,1453,333);                         -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (520,1,4,@RARE,1456,334);                         -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (520,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (520,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (520,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 135 - Count Zaebos
INSERT INTO `mob_droplist` VALUES (521,0,0,1000,4249,@ALWAYS);                     -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (521,0,0,1000,3358,@VCOMMON);                    -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (521,0,0,1000,3494,@UNCOMMON);                   -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,1,@COMMON,1449,333);                      -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (521,1,1,@COMMON,1452,333);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (521,1,1,@COMMON,1455,334);                      -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15073,67);                    -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15075,67);                    -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15076,67);                    -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15079,67);                    -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15083,67);                    -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15085,67);                    -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15086,67);                    -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15087,67);                    -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15093,67);                    -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15097,67);                    -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15104,66);                    -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15107,66);                    -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15110,66);                    -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15114,66);                    -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,2,@UNCOMMON,15126,66);                    -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,3,@UNCOMMON,11480,143);                   -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,3,@UNCOMMON,11468,143);                   -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,3,@UNCOMMON,11305,143);                   -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,3,@UNCOMMON,11465,143);                   -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,3,@UNCOMMON,11471,143);                   -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,3,@UNCOMMON,26664,143);                   -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,3,@UNCOMMON,26842,142);                   -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (521,1,4,@RARE,1450,333);                         -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (521,1,4,@RARE,1453,333);                         -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (521,1,4,@RARE,1456,334);                         -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (521,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (521,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (521,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 135 - Duke Berith
INSERT INTO `mob_droplist` VALUES (714,0,0,1000,4249,@ALWAYS);                     -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (714,0,0,1000,3358,@VCOMMON);                    -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (714,0,0,1000,3494,@UNCOMMON);                   -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,1,@COMMON,1449,333);                      -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (714,1,1,@COMMON,1452,333);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (714,1,1,@COMMON,1455,334);                      -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15073,67);                    -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15075,67);                    -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15076,67);                    -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15079,67);                    -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15083,67);                    -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15085,67);                    -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15086,67);                    -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15087,67);                    -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15093,67);                    -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15097,67);                    -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15104,66);                    -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15107,66);                    -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15110,66);                    -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15114,66);                    -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,2,@UNCOMMON,15126,66);                    -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,3,@UNCOMMON,11480,143);                   -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,3,@UNCOMMON,11468,143);                   -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,3,@UNCOMMON,11305,143);                   -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,3,@UNCOMMON,11465,143);                   -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,3,@UNCOMMON,11471,143);                   -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,3,@UNCOMMON,26664,143);                   -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,3,@UNCOMMON,26842,142);                   -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (714,1,4,@RARE,1450,333);                         -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (714,1,4,@RARE,1453,333);                         -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (714,1,4,@RARE,1456,334);                         -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (714,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (714,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (714,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 135 - Duke Gomory
INSERT INTO `mob_droplist` VALUES (715,0,0,1000,4249,@ALWAYS);                     -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (715,0,0,1000,3358,@VCOMMON);                    -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (715,0,0,1000,3494,@UNCOMMON);                   -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,1,@COMMON,1449,333);                      -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (715,1,1,@COMMON,1452,333);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (715,1,1,@COMMON,1455,334);                      -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15073,67);                    -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15075,67);                    -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15076,67);                    -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15079,67);                    -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15083,67);                    -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15085,67);                    -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15086,67);                    -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15087,67);                    -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15093,67);                    -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15097,67);                    -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15104,66);                    -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15107,66);                    -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15110,66);                    -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15114,66);                    -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,2,@UNCOMMON,15126,66);                    -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,3,@UNCOMMON,11480,143);                   -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,3,@UNCOMMON,11468,143);                   -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,3,@UNCOMMON,11305,143);                   -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,3,@UNCOMMON,11465,143);                   -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,3,@UNCOMMON,11471,143);                   -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,3,@UNCOMMON,26664,143);                   -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,3,@UNCOMMON,26842,142);                   -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (715,1,4,@RARE,1450,333);                        -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (715,1,4,@RARE,1453,333);                        -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (715,1,4,@RARE,1456,334);                        -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (715,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (715,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (715,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 135 - Duke Scox
INSERT INTO `mob_droplist` VALUES (717,0,0,1000,4249,@ALWAYS);                     -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (717,0,0,1000,3358,@VCOMMON);                    -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (717,0,0,1000,3494,@UNCOMMON);                   -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,1,@COMMON,1449,333);                      -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (717,1,1,@COMMON,1452,333);                      -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (717,1,1,@COMMON,1455,334);                      -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15073,67);                    -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15075,67);                    -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15076,67);                    -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15079,67);                    -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15083,67);                    -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15085,67);                    -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15086,67);                    -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15087,67);                    -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15093,67);                    -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15097,67);                    -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15104,66);                    -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15107,66);                    -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15110,66);                    -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15114,66);                    -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,2,@UNCOMMON,15126,66);                    -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,3,@UNCOMMON,11480,143);                   -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,3,@UNCOMMON,11468,143);                   -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,3,@UNCOMMON,11305,143);                   -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,3,@UNCOMMON,11465,143);                   -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,3,@UNCOMMON,11471,143);                   -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,3,@UNCOMMON,26664,143);                   -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,3,@UNCOMMON,26842,142);                   -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (717,1,4,@RARE,1450,333);                        -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (717,1,4,@RARE,1453,333);                        -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (717,1,4,@RARE,1456,334);                        -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (717,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (717,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (717,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 135 - King Zagan
INSERT INTO `mob_droplist` VALUES (1452,0,0,1000,4249,@ALWAYS);                    -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1452,0,0,1000,3358,@VCOMMON);                   -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1452,0,0,1000,3494,@UNCOMMON);                  -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1452,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1452,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15073,67);                   -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15075,67);                   -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15076,67);                   -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15079,67);                   -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15083,67);                   -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15085,67);                   -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15086,67);                   -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15087,67);                   -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15093,67);                   -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15097,67);                   -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15104,66);                   -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15107,66);                   -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15110,66);                   -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15114,66);                   -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,2,@UNCOMMON,15126,66);                   -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,3,@UNCOMMON,11480,143);                  -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,3,@UNCOMMON,11468,143);                  -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,3,@UNCOMMON,11305,143);                  -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,3,@UNCOMMON,11465,143);                  -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,3,@UNCOMMON,11471,143);                  -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,3,@UNCOMMON,26664,143);                  -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,3,@UNCOMMON,26842,142);                  -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1452,1,4,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1452,1,4,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1452,1,4,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1452,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1452,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1452,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 135 - Marquis Andras
INSERT INTO `mob_droplist` VALUES (1624,0,0,1000,4249,@ALWAYS);                    -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1624,0,0,1000,3358,@VCOMMON);                   -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1624,0,0,1000,3494,@UNCOMMON);                  -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1624,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1624,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15073,67);                   -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15075,67);                   -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15076,67);                   -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15079,67);                   -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15083,67);                   -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15085,67);                   -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15086,67);                   -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15087,67);                   -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15093,67);                   -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15097,67);                   -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15104,66);                   -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15107,66);                   -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15110,66);                   -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15114,66);                   -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,2,@UNCOMMON,15126,66);                   -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,3,@UNCOMMON,11480,143);                  -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,3,@UNCOMMON,11468,143);                  -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,3,@UNCOMMON,11305,143);                  -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,3,@UNCOMMON,11465,143);                  -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,3,@UNCOMMON,11471,143);                  -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,3,@UNCOMMON,26664,143);                  -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,3,@UNCOMMON,26842,142);                  -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1624,1,4,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1624,1,4,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1624,1,4,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1624,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1624,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1624,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 135 - Marquis Cimeries
INSERT INTO `mob_droplist` VALUES (1625,0,0,1000,4249,@ALWAYS);                    -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1625,0,0,1000,3358,@VCOMMON);                   -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1625,0,0,1000,3494,@UNCOMMON);                  -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1625,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1625,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15073,67);                   -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15075,67);                   -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15076,67);                   -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15079,67);                   -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15083,67);                   -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15085,67);                   -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15086,67);                   -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15087,67);                   -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15093,67);                   -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15097,67);                   -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15104,66);                   -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15107,66);                   -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15110,66);                   -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15114,66);                   -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,2,@UNCOMMON,15126,66);                   -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,3,@UNCOMMON,11480,143);                  -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,3,@UNCOMMON,11468,143);                  -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,3,@UNCOMMON,11305,143);                  -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,3,@UNCOMMON,11465,143);                  -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,3,@UNCOMMON,11471,143);                  -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,3,@UNCOMMON,26664,143);                  -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,3,@UNCOMMON,26842,142);                  -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1625,1,4,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1625,1,4,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1625,1,4,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1625,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1625,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1625,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 135 - Marquis Decarabia
INSERT INTO `mob_droplist` VALUES (1626,0,0,1000,4249,@ALWAYS);                    -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1626,0,0,1000,3358,@VCOMMON);                   -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1626,0,0,1000,3494,@UNCOMMON);                  -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1626,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1626,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15073,67);                   -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15075,67);                   -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15076,67);                   -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15079,67);                   -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15083,67);                   -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15085,67);                   -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15086,67);                   -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15087,67);                   -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15093,67);                   -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15097,67);                   -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15104,66);                   -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15107,66);                   -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15110,66);                   -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15114,66);                   -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,2,@UNCOMMON,15126,66);                   -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,3,@UNCOMMON,11480,143);                  -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,3,@UNCOMMON,11468,143);                  -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,3,@UNCOMMON,11305,143);                  -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,3,@UNCOMMON,11465,143);                  -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,3,@UNCOMMON,11471,143);                  -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,3,@UNCOMMON,26664,143);                  -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,3,@UNCOMMON,26842,142);                  -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1626,1,4,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1626,1,4,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1626,1,4,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1626,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1626,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1626,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 135 - Marquis Gamygyn
INSERT INTO `mob_droplist` VALUES (1628,0,0,1000,4249,@ALWAYS);                    -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1628,0,0,1000,3358,@COMMON);                    -- Shrouded Bijou (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1628,0,0,1000,3494,@UNCOMMON);                  -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1628,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1628,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15073,67);                   -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15075,67);                   -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15076,67);                   -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15079,67);                   -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15083,67);                   -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15085,67);                   -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15086,67);                   -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15087,67);                   -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15093,67);                   -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15097,67);                   -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15104,66);                   -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15107,66);                   -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15110,66);                   -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15114,66);                   -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,2,@UNCOMMON,15126,66);                   -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,3,@UNCOMMON,11480,143);                  -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,3,@UNCOMMON,11468,143);                  -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,3,@UNCOMMON,11305,143);                  -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,3,@UNCOMMON,11465,143);                  -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,3,@UNCOMMON,11471,143);                  -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,3,@UNCOMMON,26664,143);                  -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,3,@UNCOMMON,26842,142);                  -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1628,1,4,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1628,1,4,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1628,1,4,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1628,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1628,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1628,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 135 - Marquis Nebiros
INSERT INTO `mob_droplist` VALUES (1629,0,0,1000,4249,@ALWAYS);                    -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1629,0,0,1000,3358,@VCOMMON);                   -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1629,0,0,1000,3494,@UNCOMMON);                  -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1629,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1629,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15073,67);                   -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15075,67);                   -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15076,67);                   -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15079,67);                   -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15083,67);                   -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15085,67);                   -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15086,67);                   -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15087,67);                   -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15093,67);                   -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15097,67);                   -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15104,66);                   -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15107,66);                   -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15110,66);                   -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15114,66);                   -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,2,@UNCOMMON,15126,66);                   -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,3,@UNCOMMON,11480,143);                  -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,3,@UNCOMMON,11468,143);                  -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,3,@UNCOMMON,11305,143);                  -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,3,@UNCOMMON,11465,143);                  -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,3,@UNCOMMON,11471,143);                  -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,3,@UNCOMMON,26664,143);                  -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,3,@UNCOMMON,26842,142);                  -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1629,1,4,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1629,1,4,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1629,1,4,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1629,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1629,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1629,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 135 - Marquis Orias
INSERT INTO `mob_droplist` VALUES (1630,0,0,1000,4249,@ALWAYS);                    -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1630,0,0,1000,3358,@VCOMMON);                   -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1630,0,0,1000,3494,@UNCOMMON);                  -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1630,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1630,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15073,67);                   -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15075,67);                   -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15076,67);                   -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15079,67);                   -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15083,67);                   -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15085,67);                   -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15086,67);                   -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15087,67);                   -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15093,67);                   -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15097,67);                   -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15104,66);                   -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15107,66);                   -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15110,66);                   -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15114,66);                   -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,2,@UNCOMMON,15126,66);                   -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,3,@UNCOMMON,11480,143);                  -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,3,@UNCOMMON,11468,143);                  -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,3,@UNCOMMON,11305,143);                  -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,3,@UNCOMMON,11465,143);                  -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,3,@UNCOMMON,11471,143);                  -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,3,@UNCOMMON,26664,143);                  -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,3,@UNCOMMON,26842,142);                  -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1630,1,4,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1630,1,4,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1630,1,4,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1630,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1630,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1630,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 135 - Marquis Sabnak
INSERT INTO `mob_droplist` VALUES (1631,0,0,1000,4249,@ALWAYS);                    -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1631,0,0,1000,3358,@VCOMMON);                   -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1631,0,0,1000,3494,@UNCOMMON);                  -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1631,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1631,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15073,67);                   -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15075,67);                   -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15076,67);                   -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15079,67);                   -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15083,67);                   -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15085,67);                   -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15086,67);                   -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15087,67);                   -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15093,67);                   -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15097,67);                   -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15104,66);                   -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15107,66);                   -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15110,66);                   -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15114,66);                   -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,2,@UNCOMMON,15126,66);                   -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,3,@UNCOMMON,11480,143);                  -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,3,@UNCOMMON,11468,143);                  -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,3,@UNCOMMON,11305,143);                  -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,3,@UNCOMMON,11465,143);                  -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,3,@UNCOMMON,11471,143);                  -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,3,@UNCOMMON,26664,143);                  -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,3,@UNCOMMON,26842,142);                  -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1631,1,4,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1631,1,4,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1631,1,4,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1631,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1631,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1631,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 135 - Prince Seere
INSERT INTO `mob_droplist` VALUES (2021,0,0,1000,4249,@ALWAYS);                    -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2021,0,0,1000,3358,@VCOMMON);                   -- Shrouded Bijou (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2021,0,0,1000,3494,@UNCOMMON);                  -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2021,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2021,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15073,67);                   -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15075,67);                   -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15076,67);                   -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15079,67);                   -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15083,67);                   -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15085,67);                   -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15086,67);                   -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15087,67);                   -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15093,67);                   -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15097,67);                   -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15104,66);                   -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15107,66);                   -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15110,66);                   -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15114,66);                   -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,2,@UNCOMMON,15126,66);                   -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,3,@UNCOMMON,11480,143);                  -- Argute Mortarboard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,3,@UNCOMMON,11468,143);                  -- Commodore Tricorne (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,3,@UNCOMMON,11305,143);                  -- Etoile Casaque (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,3,@UNCOMMON,11465,143);                  -- Mirage Keffiyeh (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,3,@UNCOMMON,11471,143);                  -- Pantin Taj (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,3,@UNCOMMON,26664,143);                  -- Bagua Galero (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,3,@UNCOMMON,26842,142);                  -- Futhark Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2021,1,4,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2021,1,4,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2021,1,4,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2021,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2021,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2021,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID: 135 - Vanguard Dragon
INSERT INTO `mob_droplist` VALUES (2559,0,0,1000,4249,@ALWAYS);                    -- Copy Of Schultz Stratagems (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2559,0,0,1000,1589,@VCOMMON);                   -- Shard Of Necropsyche (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2559,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2559,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2559,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2559,1,2,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2559,1,2,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2559,1,2,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2559,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2559,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2559,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- There Satellite/Animated weappons were all unchanged.
-- ZoneID: 135 - Satellite Knuckles
INSERT INTO `mob_droplist` VALUES (3151,0,0,1000,3364,@UNCOMMON); -- Mystic Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Daggers
INSERT INTO `mob_droplist` VALUES (3152,0,0,1000,3365,@UNCOMMON); -- Ornate Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Longswords
INSERT INTO `mob_droplist` VALUES (3153,0,0,1000,3366,@UNCOMMON); -- Holy Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Claymores
INSERT INTO `mob_droplist` VALUES (3154,0,0,1000,3367,@UNCOMMON); -- Intricate Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Tabars
INSERT INTO `mob_droplist` VALUES (3155,0,0,1000,3368,@UNCOMMON); -- Runaeic Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Great Axes
INSERT INTO `mob_droplist` VALUES (3156,0,0,1000,3369,@UNCOMMON); -- Seraphic Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Scythes
INSERT INTO `mob_droplist` VALUES (3157,0,0,1000,3370,@UNCOMMON); -- Tenebrous Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Spears
INSERT INTO `mob_droplist` VALUES (3158,0,0,1000,3371,@UNCOMMON); -- Stellar Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Kunai
INSERT INTO `mob_droplist` VALUES (3159,0,0,1000,3372,@UNCOMMON); -- Demoniac Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Tachi
INSERT INTO `mob_droplist` VALUES (3160,0,0,1000,3373,@UNCOMMON); -- Divine Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Hammers
INSERT INTO `mob_droplist` VALUES (3161,0,0,1000,3374,@UNCOMMON); -- Heavenly Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Staves
INSERT INTO `mob_droplist` VALUES (3162,0,0,1000,3375,@UNCOMMON); -- Celestial Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Longbows
INSERT INTO `mob_droplist` VALUES (3163,0,0,1000,3376,@UNCOMMON); -- Snarled Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Guns
INSERT INTO `mob_droplist` VALUES (3164,0,0,1000,3377,@UNCOMMON); -- Ethereal Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Horns
INSERT INTO `mob_droplist` VALUES (3165,0,0,1000,3378,@UNCOMMON); -- Mysterial Goad (Uncommon, 10%)
-- ZoneID: 135 - Satellite Shield
INSERT INTO `mob_droplist` VALUES (3166,0,0,1000,3379,@UNCOMMON); -- Supernal Goad (Uncommon, 10%)

-- ZoneID: 135 - Animated Knuckles
INSERT INTO `mob_droplist` VALUES (3238,0,0,1000,1571,@ALWAYS); -- Mystic Fragment (Always, 100%)
-- ZoneID: 135 - Animated Dagger
INSERT INTO `mob_droplist` VALUES (3239,0,0,1000,1572,@ALWAYS); -- Ornate Fragment (Always, 100%)
-- ZoneID: 135 - Animated Longsword
INSERT INTO `mob_droplist` VALUES (3240,0,0,1000,1573,@ALWAYS); -- Holy Fragment (Always, 100%)
-- ZoneID: 135 - Animated Claymore
INSERT INTO `mob_droplist` VALUES (3241,0,0,1000,1574,@ALWAYS); -- Intricate Fragment (Always, 100%)
-- ZoneID: 135 - Animated Tabar
INSERT INTO `mob_droplist` VALUES (3242,0,0,1000,1575,@ALWAYS); -- Runaeic Fragment (Always, 100%)
-- ZoneID: 135 - Animated Great Axe
INSERT INTO `mob_droplist` VALUES (3243,0,0,1000,1576,@ALWAYS); -- Seraphic Fragment (Always, 100%)
-- ZoneID: 135 - Animated Scythe
INSERT INTO `mob_droplist` VALUES (3244,0,0,1000,1577,@ALWAYS); -- Tenebrous Fragment (Always, 100%)
-- ZoneID: 135 - Animated Spear
INSERT INTO `mob_droplist` VALUES (3245,0,0,1000,1578,@ALWAYS); -- Stellar Fragment (Always, 100%)
-- ZoneID: 135 - Animated Kunai
INSERT INTO `mob_droplist` VALUES (3246,0,0,1000,1579,@ALWAYS); -- Demoniac Fragment (Always, 100%)
-- ZoneID: 135 - Animated Tachi
INSERT INTO `mob_droplist` VALUES (3247,0,0,1000,1580,@ALWAYS); -- Divine Fragment (Always, 100%)
-- ZoneID: 135 - Animated Hammer
INSERT INTO `mob_droplist` VALUES (3248,0,0,1000,1581,@ALWAYS); -- Heavenly Fragment (Always, 100%)
-- ZoneID: 135 - Animated Staff
INSERT INTO `mob_droplist` VALUES (3249,0,0,1000,1582,@ALWAYS); -- Celestial Fragment (Always, 100%)
-- ZoneID: 135 - Animated Longbow
INSERT INTO `mob_droplist` VALUES (3250,0,0,1000,1583,@ALWAYS); -- Snarled Fragment (Always, 100%)
-- ZoneID: 135 - Animated Horn
INSERT INTO `mob_droplist` VALUES (3251,0,0,1000,1584,@ALWAYS); -- Mysterial Fragment (Always, 100%)
-- ZoneID: 135 - Animated Gun
INSERT INTO `mob_droplist` VALUES (3252,0,0,1000,1585,@ALWAYS); -- Ethereal Fragment (Always, 100%)
-- ZoneID: 135 - Animated Shield
INSERT INTO `mob_droplist` VALUES (3253,0,0,1000,1822,@ALWAYS); -- Supernal Fragment (Always, 100%)

-- ZoneID: 135 - Dynamis Lord
-- INSERT INTO `mob_droplist` VALUES (730,0,0,1000,3429,@ALWAYS);                      -- Fiendish Tome Chapter 26 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (730,1,1,1000,13658,@VCOMMON);                    -- Shadow Mantle (Very Common 24%)
INSERT INTO `mob_droplist` VALUES (730,1,1,1000,@FORGOTTEN_POUCH_BODY,760);         -- Forgotten Hope (76%)
INSERT INTO `mob_droplist` VALUES (730,1,2,1000,14646,@COMMON);                     -- Shadow Ring (Common, 15%)
INSERT INTO `mob_droplist` VALUES (730,1,2,1000,@FORGOTTEN_POUCH_BODY,850);         -- Forgotten Hope (85%)
-- INSERT INTO `mob_droplist` VALUES (730,0,0,1000,@FORGOTTEN_POUCH_BODY,@ALWAYS);     -- Forgotten pouch hope (Always, 100%)
INSERT INTO `mob_droplist` VALUES (730,0,0,1000,19163,50);                          -- Dynamis Lord - nightfall
INSERT INTO `mob_droplist` VALUES (730,0,0,1000,11501,50);                          -- Dynamis Lord - nocturnus_helm
INSERT INTO `mob_droplist` VALUES (730,0,0,1000,11354,50);                          -- Dynamis Lord - nocturnus_mail
INSERT INTO `mob_droplist` VALUES (730,0,0,1000,11578,100);                         -- Dynamis Lord - tiercel_necklace
INSERT INTO `mob_droplist` VALUES (730,0,0,1000,11543,100);                         -- Dynamis Lord - hecates_cape
INSERT INTO `mob_droplist` VALUES (730,0,0,1000,19048,100);                         -- Dynamis Lord - reign_grip
INSERT INTO `mob_droplist` VALUES (730,0,0,1000,2466,130);                          -- Dynamis Lord - rubber_harness
INSERT INTO `mob_droplist` VALUES (730,1,3,@VCOMMON,1450,334);                       -- Lungo-Nango Jadeshell (Very Common 24%)
INSERT INTO `mob_droplist` VALUES (730,1,3,@VCOMMON,1453,333);                       -- Montiont Silverpiece (Very Common 24%)
INSERT INTO `mob_droplist` VALUES (730,1,3,@VCOMMON,1456,333);                       -- One Hundred Byne Bill (Very Common 24%)

-- ZoneID: 135 - Baron Avnas (LSB ID: 519)
INSERT INTO `mob_droplist` VALUES (4001,0,0,1000,3430,@ALWAYS);                     -- Fiendish Tome Chapter 27 (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,1,1000,11673,130);                        -- Demonry Ring (13%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,1,1000,@FORGOTTEN_POUCH_BODY,870);        -- Forgotten pouch hope (87%)
-- INSERT INTO `mob_droplist` VALUES (4001,0,0,1000,@FORGOTTEN_POUCH_BODY,@ALWAYS);    -- Forgotten pouch hope (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,2,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,2,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,2,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,2,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,3,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,3,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,3,1000,1453,16);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,3,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,4,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,4,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (10%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,4,1000,1453,17);                            -- Montiont Silverpiece (10%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,4,1000,1456,16);                            -- One Hundred Byne Bill (10%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,5,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,5,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,5,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4001,1,5,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4001,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
-- INSERT INTO `mob_droplist` VALUES (4001,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
-- INSERT INTO `mob_droplist` VALUES (4001,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 135 - Marquis Caim (LSB ID: 520)
INSERT INTO `mob_droplist` VALUES (4002,0,0,1000,3431,@ALWAYS);                     -- Fiendish Tome Chapter 28 (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,1,1000,19764,130);                        -- Demonry Core (13%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,1,1000,@FORGOTTEN_POUCH_BODY,870);        -- Forgotten pouch hope (87%)
-- INSERT INTO `mob_droplist` VALUES (4002,0,0,1000,@FORGOTTEN_POUCH_BODY,@ALWAYS);    -- Forgotten pouch hope (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,2,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,2,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,2,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,2,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,3,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,3,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,3,1000,1453,16);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,3,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,4,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,4,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (10%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,4,1000,1453,17);                            -- Montiont Silverpiece (10%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,4,1000,1456,16);                            -- One Hundred Byne Bill (10%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,5,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,5,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,5,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4002,1,5,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4002,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
-- INSERT INTO `mob_droplist` VALUES (4002,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
-- INSERT INTO `mob_droplist` VALUES (4002,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 135 - Duke Haures (LSB ID: 521)
INSERT INTO `mob_droplist` VALUES (4003,0,0,1000,3432,@ALWAYS);                     -- Fiendish Tome Chapter 29 (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,1,1000,11777,130);                        -- Demonry Sash (13%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,1,1000,@FORGOTTEN_POUCH_BODY,870);        -- Forgotten pouch hope (87%)
-- INSERT INTO `mob_droplist` VALUES (4003,0,0,1000,@FORGOTTEN_POUCH_BODY,@ALWAYS);    -- Forgotten pouch hope (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,2,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,2,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,2,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,2,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,3,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,3,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,3,1000,1453,16);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,3,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,4,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,4,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (10%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,4,1000,1453,17);                            -- Montiont Silverpiece (10%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,4,1000,1456,16);                            -- One Hundred Byne Bill (10%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,5,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,5,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,5,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4003,1,5,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4003,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
-- INSERT INTO `mob_droplist` VALUES (4003,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
-- INSERT INTO `mob_droplist` VALUES (4003,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 135 - Count Haagenti (LSB ID: 1630)
INSERT INTO `mob_droplist` VALUES (4004,0,0,1000,3433,@ALWAYS);                     -- Fiendish Tome Chapter 30 (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,1,1000,19765,130);                        -- Demonry Stone (13%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,1,1000,@FORGOTTEN_POUCH_BODY,870);        -- Forgotten pouch hope (87%)
-- INSERT INTO `mob_droplist` VALUES (4004,0,0,1000,@FORGOTTEN_POUCH_BODY,@ALWAYS);    -- Forgotten pouch hope (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,2,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,2,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,2,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,2,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,3,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,3,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,3,1000,1453,16);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,3,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,4,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,4,1000,1450,17);                            -- Lungo-Nango-Nango Jadeshell (10%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,4,1000,1453,17);                            -- Montiont Silverpiece (10%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,4,1000,1456,16);                            -- One Hundred Byne Bill (10%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,5,1000,@FORGOTTEN_POUCH_BODY,950);        -- Forgotten pouch hope (95%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,5,1000,1450,16);                            -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,5,1000,1453,17);                            -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (4004,1,5,1000,1456,17);                            -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (4004,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
-- INSERT INTO `mob_droplist` VALUES (4004,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
-- INSERT INTO `mob_droplist` VALUES (4004,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID: 135 - Arch Dynamis Lord (LSB ID: 730)
-- INSERT INTO `mob_droplist` VALUES (4005,0,0,1000,3502,@ALWAYS);                     -- Umbral Marrow (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,1,1000,3502,@VCOMMON);                    -- Umbral Marrow (Very Common, 24%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,1,1000,@FORGOTTEN_POUCH_BODY,760);        -- Forgotten pouch hope (76%)
-- INSERT INTO `mob_droplist` VALUES (4005,0,0,1000,@FORGOTTEN_POUCH_BODY,@ALWAYS);    -- Forgotten pouch hope (Always, 100%)
-- INSERT INTO `mob_droplist` VALUES (4005,0,0,1000,10975,200);                        -- Archon Cape (20%)
-- INSERT INTO `mob_droplist` VALUES (4005,0,0,1000,11674,200);                        -- Archon Ring (20%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,2,@VCOMMON,18903,900);                    -- Talekeeper (24% then 90% makes 21.6%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,2,@VCOMMON,17669,100);                    -- Sagasinger (24% then 10% makes 2.4%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,3,1000,@FORGOTTEN_POUCH_BODY,850);        -- Forgotten pouch hope (85%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,3,1000,1450,60);                            -- Lungo-Nango-Nango Jadeshell (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,3,1000,1453,70);                            -- Montiont Silverpiece (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,3,1000,1456,70);                            -- One Hundred Byne Bill (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,4,1000,@FORGOTTEN_POUCH_BODY,850);        -- Forgotten pouch hope (85%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,4,1000,1450,70);                            -- Lungo-Nango-Nango Jadeshell (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,4,1000,1453,60);                            -- Montiont Silverpiece (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,4,1000,1456,70);                            -- One Hundred Byne Bill (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,5,1000,@FORGOTTEN_POUCH_BODY,850);        -- Forgotten pouch hope (85%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,5,1000,1450,70);                            -- Lungo-Nango-Nango Jadeshell (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,5,1000,1453,70);                            -- Montiont Silverpiece (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,5,1000,1456,60);                            -- One Hundred Byne Bill (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,6,1000,@FORGOTTEN_POUCH_BODY,850);        -- Forgotten pouch hope (85%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,6,1000,1450,60);                            -- Lungo-Nango-Nango Jadeshell (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,6,1000,1453,70);                            -- Montiont Silverpiece (15%)
-- INSERT INTO `mob_droplist` VALUES (4005,1,6,1000,1456,70);                            -- One Hundred Byne Bill (15%)
INSERT INTO `mob_droplist` VALUES (4005,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (4005,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (4005,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- --------------------------------------------------------------------
--                          Dynamis-Valkurm                          --
-- --------------------------------------------------------------------

-- Ensure we're clearing out the old drop lists
DELETE FROM `mob_droplist` WHERE dropid = "1792"; -- Delete Nightmare Fly, Funguar, Flytrap Tier 1
DELETE FROM `mob_droplist` WHERE dropid = "1794"; -- Delete Nightmare Hippogryph, Sabotender, Sheep Tier 1
DELETE FROM `mob_droplist` WHERE dropid = "1799"; -- Delete Nightmare Manticore, Treant, Goobbue Tier 1
DELETE FROM `mob_droplist` WHERE dropid = "2539"; -- Delete Vanguard Goblins
DELETE FROM `mob_droplist` WHERE dropid = "2544"; -- Delete Vanguard Orcs
DELETE FROM `mob_droplist` WHERE dropid = "2549"; -- Delete Vanguard Yagudo
DELETE FROM `mob_droplist` WHERE dropid = "2554"; -- Delete Vanguard Quadav
DELETE FROM `mob_droplist` WHERE dropid = "3122"; -- Delete Nightmare Fly, Funguar, Flytrap Tier 2
DELETE FROM `mob_droplist` WHERE dropid = "3123"; -- Delete Nightmare Hippogryph, Sabotender, Sheep Tier 2
DELETE FROM `mob_droplist` WHERE dropid = "3124"; -- Delete Nightmare Manticore, Treant, Goobbue Tier 2
DELETE FROM `mob_droplist` WHERE dropid = "806";  -- Delete Fairy Ring
DELETE FROM `mob_droplist` WHERE dropid = "2909"; -- Delete Stcemqestcint
DELETE FROM `mob_droplist` WHERE dropid = "2910"; -- Delete Nantina
DELETE FROM `mob_droplist` WHERE dropid = "472";  -- Delete Cirrate Christelle
DELETE FROM `mob_droplist` WHERE dropid = "3125"; -- Delete Lost Fairy Ring
DELETE FROM `mob_droplist` WHERE dropid = "3126"; -- Delete Lost Stcemqestcint
DELETE FROM `mob_droplist` WHERE dropid = "3127"; -- Delete Lost Nantina
DELETE FROM `mob_droplist` WHERE dropid = "3128"; -- Delete Arch Christelle

-- Assign drop lists to bosses
UPDATE `mob_groups` SET `dropid` = 472 WHERE name = 'Cirrate_Christelle' AND zoneid = 39;
UPDATE `mob_groups` SET `dropid` = 3125 WHERE name = 'Lost_Fairy_Ring' AND zoneid = 39;
UPDATE `mob_groups` SET `dropid` = 3126 WHERE name = 'Lost_Stcemqestcint' AND zoneid = 39;
UPDATE `mob_groups` SET `dropid` = 3127 WHERE name = 'Lost_Nantina' AND zoneid = 39;
UPDATE `mob_groups` SET `dropid` = 3128 WHERE name = 'Arch_Christelle' AND zoneid = 39;

-- ZoneID:  39 - Vanguard Smithy
-- ZoneID:  39 - Vanguard Dragontamer
-- ZoneID:  39 - Vanguard Necromancer
-- ZoneID:  39 - Vanguard Pitfighter
-- ZoneID:  39 - Vanguard Enchanter
-- ZoneID:  39 - Vanguard Ronin
-- ZoneID:  39 - Vanguard Maestro
-- ZoneID:  39 - Vanguard Hitman
-- ZoneID:  39 - Vanguard Alchemist
-- ZoneID:  39 - Vanguard Welldigger
-- ZoneID:  39 - Vanguard Tinkerer
-- ZoneID:  39 - Vanguard Shaman
-- ZoneID:  39 - Vanguard Armorer
-- ZoneID:  39 - Vanguard Ambusher
-- ZoneID:  39 - Vanguard Pathfinder
-- ZoneID:  39 - Vanguard Smithy
-- ZoneID:  39 - Vanguard Pitfighter
-- ZoneID:  39 - Vanguard Alchemist
-- ZoneID:  39 - Vanguard Ambusher
-- ZoneID:  39 - Vanguard Necromancer
-- ZoneID:  39 - Vanguard Shaman
-- ZoneID:  39 - Vanguard Enchanter
-- ZoneID:  39 - Vanguard Welldigger
-- ZoneID:  39 - Vanguard Ronin
-- ZoneID:  39 - Vanguard Pathfinder
-- ZoneID:  39 - Vanguard Armorer
-- ZoneID:  39 - Vanguard Tinkerer
-- ZoneID:  39 - Vanguard Maestro
-- ZoneID:  39 - Vanguard Hitman
-- ZoneID:  39 - Vanguard Dragontamer
INSERT INTO `mob_droplist` VALUES (2539,0,0,1000,3495,@UNCOMMON);                  -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15077,66);                   -- Assassins Bonnet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15132,66);                   -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15080,66);                   -- Monster Helm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15112,66);                   -- Scouts Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15129,66);                   -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15130,67);                   -- Wyrm Brais (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15131,67);                   -- Summoners Spats (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15133,67);                   -- Melee Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15134,67);                   -- Clerics Duckbills (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15135,67);                   -- Sorcerers Sabots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15136,67);                   -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15138,67);                   -- Valor Leggings (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15139,67);                   -- Abyss Sollerets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15141,67);                   -- Bards Slippers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,1,@UNCOMMON,15143,67);                   -- Saotome Sune-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2539,1,2,@RARE,15040,142);                      -- Argute Bracers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2539,1,2,@RARE,15038,143);                      -- Etoile Bangles (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2539,1,2,@RARE,16349,143);                      -- Commodore Trews (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2539,1,2,@RARE,11382,143);                      -- Mirage Charuqs (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2539,1,2,@RARE,16352,143);                      -- Pantin Churidars (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2539,1,2,@RARE,27018,143);                      -- Futhark Mitons (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2539,1,2,@RARE,27016,143);                      -- Bagua Mitaines (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2539,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2539,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2539,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  39 - Vanguard Pillager
-- ZoneID:  39 - Vanguard Predator
-- ZoneID:  39 - Vanguard Grappler
-- ZoneID:  39 - Vanguard Trooper
-- ZoneID:  39 - Vanguard Gutslasher
-- ZoneID:  39 - Vanguard Amputator
-- ZoneID:  39 - Vanguard Backstabber
-- ZoneID:  39 - Vanguard Hawker
-- ZoneID:  39 - Vanguard Mesmerizer
-- ZoneID:  39 - Vanguard Neckchopper
-- ZoneID:  39 - Vanguard Impaler
-- ZoneID:  39 - Vanguard Vexer
-- ZoneID:  39 - Vanguard Bugler
-- ZoneID:  39 - Vanguard Dollmaster
-- ZoneID:  39 - Vanguard Footsoldier
-- ZoneID:  39 - Vanguard Pillager
-- ZoneID:  39 - Vanguard Neckchopper
-- ZoneID:  39 - Vanguard Bugler
-- ZoneID:  39 - Vanguard Dollmaster
-- ZoneID:  39 - Vanguard Grappler
-- ZoneID:  39 - Vanguard Mesmerizer
-- ZoneID:  39 - Vanguard Predator
-- ZoneID:  39 - Vanguard Backstabber
-- ZoneID:  39 - Vanguard Hawker
-- ZoneID:  39 - Vanguard Amputator
-- ZoneID:  39 - Vanguard Vexer
-- ZoneID:  39 - Vanguard Trooper
-- ZoneID:  39 - Vanguard Gutslasher
-- ZoneID:  39 - Vanguard Impaler
-- ZoneID:  39 - Vanguard Footsoldier
INSERT INTO `mob_droplist` VALUES (2544,0,0,1000,3495,@UNCOMMON);                 -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15077,66);                  -- Assassins Bonnet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15132,66);                  -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15080,66);                  -- Monster Helm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15112,66);                  -- Scouts Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15129,66);                  -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15130,67);                  -- Wyrm Brais (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15131,67);                  -- Summoners Spats (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15133,67);                  -- Melee Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15134,67);                  -- Clerics Duckbills (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15135,67);                  -- Sorcerers Sabots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15136,67);                  -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15138,67);                  -- Valor Leggings (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15139,67);                  -- Abyss Sollerets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15141,67);                  -- Bards Slippers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,1,@UNCOMMON,15143,67);                  -- Saotome Sune-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2544,1,2,@RARE,15040,142);                     -- Argute Bracers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2544,1,2,@RARE,15038,143);                     -- Etoile Bangles (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2544,1,2,@RARE,16349,143);                     -- Commodore Trews (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2544,1,2,@RARE,11382,143);                     -- Mirage Charuqs (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2544,1,2,@RARE,16352,143);                     -- Pantin Churidars (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2544,1,2,@RARE,27018,143);                     -- Futhark Mitons (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2544,1,2,@RARE,27016,143);                     -- Bagua Mitaines (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2544,2,0,1000,1452,0);                         -- Ordelle Bronzepiece (Steal)

-- ZoneID:  39 - Vanguard Inciter
-- ZoneID:  39 - Vanguard Skirmisher
-- ZoneID:  39 - Vanguard Chanter
-- ZoneID:  39 - Vanguard Partisan
-- ZoneID:  39 - Vanguard Sentinel
-- ZoneID:  39 - Vanguard Liberator
-- ZoneID:  39 - Vanguard Oracle
-- ZoneID:  39 - Vanguard Priest
-- ZoneID:  39 - Vanguard Salvager
-- ZoneID:  39 - Vanguard Exemplar
-- ZoneID:  39 - Vanguard Prelate
-- ZoneID:  39 - Vanguard Persecutor
-- ZoneID:  39 - Vanguard Visionary
-- ZoneID:  39 - Vanguard Assassin
-- ZoneID:  39 - Vanguard Ogresoother
-- ZoneID:  39 - Vanguard Skirmisher
-- ZoneID:  39 - Vanguard Visionary
-- ZoneID:  39 - Vanguard Chanter
-- ZoneID:  39 - Vanguard Oracle
-- ZoneID:  39 - Vanguard Sentinel
-- ZoneID:  39 - Vanguard Liberator
-- ZoneID:  39 - Vanguard Salvager
-- ZoneID:  39 - Vanguard Priest
-- ZoneID:  39 - Vanguard Exemplar
-- ZoneID:  39 - Vanguard Persecutor
-- ZoneID:  39 - Vanguard Partisan
-- ZoneID:  39 - Vanguard Prelate
-- ZoneID:  39 - Vanguard Inciter
-- ZoneID:  39 - Vanguard Assassin
-- ZoneID:  39 - Vanguard Ogresoother
INSERT INTO `mob_droplist` VALUES (2549,0,0,1000,3495,@UNCOMMON);                 -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15077,66);                  -- Assassins Bonnet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15132,66);                  -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15080,66);                  -- Monster Helm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15112,66);                  -- Scouts Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15129,66);                  -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15130,67);                  -- Wyrm Brais (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15131,67);                  -- Summoners Spats (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15133,67);                  -- Melee Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15134,67);                  -- Clerics Duckbills (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15135,67);                  -- Sorcerers Sabots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15136,67);                  -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15138,67);                  -- Valor Leggings (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15139,67);                  -- Abyss Sollerets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15141,67);                  -- Bards Slippers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,1,@UNCOMMON,15143,67);                  -- Saotome Sune-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2549,1,2,@RARE,15040,142);                     -- Argute Bracers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2549,1,2,@RARE,15038,143);                     -- Etoile Bangles (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2549,1,2,@RARE,16349,143);                     -- Commodore Trews (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2549,1,2,@RARE,11382,143);                     -- Mirage Charuqs (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2549,1,2,@RARE,16352,143);                     -- Pantin Churidars (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2549,1,2,@RARE,27018,143);                     -- Futhark Mitons (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2549,1,2,@RARE,27016,143);                     -- Bagua Mitaines (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2549,2,0,1000,1449,0);                         -- Tukuku Whiteshell (Steal)

-- ZoneID:  39 - Vanguard Vindicator
-- ZoneID:  39 - Vanguard Thaumaturge
-- ZoneID:  39 - Vanguard Minstrel
-- ZoneID:  39 - Vanguard Kusa
-- ZoneID:  39 - Vanguard Beasttender
-- ZoneID:  39 - Vanguard Militant
-- ZoneID:  39 - Vanguard Vigilante
-- ZoneID:  39 - Vanguard Protector
-- ZoneID:  39 - Vanguard Mason
-- ZoneID:  39 - Vanguard Drakekeeper
-- ZoneID:  39 - Vanguard Constable
-- ZoneID:  39 - Vanguard Purloiner
-- ZoneID:  39 - Vanguard Defender
-- ZoneID:  39 - Vanguard Hatamoto
-- ZoneID:  39 - Vanguard Undertaker
-- ZoneID:  39 - Vanguard Vindicator
-- ZoneID:  39 - Vanguard Vigilante
-- ZoneID:  39 - Vanguard Kusa
-- ZoneID:  39 - Vanguard Militant
-- ZoneID:  39 - Vanguard Mason
-- ZoneID:  39 - Vanguard Beasttender
-- ZoneID:  39 - Vanguard Constable
-- ZoneID:  39 - Vanguard Purloiner
-- ZoneID:  39 - Vanguard Drakekeeper
-- ZoneID:  39 - Vanguard Thaumaturge
-- ZoneID:  39 - Vanguard Minstrel
-- ZoneID:  39 - Vanguard Hatamoto
-- ZoneID:  39 - Vanguard Protector
-- ZoneID:  39 - Vanguard Defender
-- ZoneID:  39 - Vanguard Undertaker
INSERT INTO `mob_droplist` VALUES (2554,0,0,1000,3495,@UNCOMMON);                 -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15077,66);                  -- Assassins Bonnet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15132,66);                  -- Warriors Calligae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15080,66);                  -- Monster Helm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15112,66);                  -- Scouts Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15129,66);                  -- Koga Hakama (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15130,67);                  -- Wyrm Brais (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15131,67);                  -- Summoners Spats (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15133,67);                  -- Melee Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15134,67);                  -- Clerics Duckbills (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15135,67);                  -- Sorcerers Sabots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15136,67);                  -- Duelists Boots (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15138,67);                  -- Valor Leggings (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15139,67);                  -- Abyss Sollerets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15141,67);                  -- Bards Slippers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,1,@UNCOMMON,15143,67);                  -- Saotome Sune-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2554,1,2,@RARE,15040,142);                     -- Argute Bracers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2554,1,2,@RARE,15038,143);                     -- Etoile Bangles (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2554,1,2,@RARE,16349,143);                     -- Commodore Trews (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2554,1,2,@RARE,11382,143);                     -- Mirage Charuqs (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2554,1,2,@RARE,16352,143);                     -- Pantin Churidars (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2554,1,2,@RARE,27018,143);                     -- Futhark Mitons (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2554,1,2,@RARE,27016,143);                     -- Bagua Mitaines (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2554,2,0,1000,1455,0);                         -- One Byne Bill (Steal)

-- ZoneID:  39 - Nightmare Fly Tier 1
-- ZoneID:  39 - Nightmare Funguar Tier 1
-- ZoneID:  39 - Nightmare Flytrap Tier 1
INSERT INTO `mob_droplist` VALUES (1792,0,0,1000,3456,@UNCOMMON);                  -- Creepers Juju (5%)
INSERT INTO `mob_droplist` VALUES (1792,0,0,1000,3495,@UNCOMMON);                  -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,1,@UNCOMMON,15481,250);                  -- Valor Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,1,@UNCOMMON,15920,250);                  -- Commodore Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,1,@UNCOMMON,16244,250);                  -- Mirage Mantle (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,1,@UNCOMMON,16248,250);                  -- Etoile Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2033,66);                    -- Warriors Mask -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2038,66);                    -- Melee Crown -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2043,66);                    -- Clerics Cap -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2048,66);                    -- Sorcerers Petasos -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2053,67);                    -- Duelists Chapeau -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2058,67);                    -- Assassins Bonnet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2063,67);                    -- Valor Coronet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2068,67);                    -- Abyss Burgeonet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2073,67);                    -- Monster Helm -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2078,67);                    -- Bards Roundlet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2083,67);                    -- Scouts Beret -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2088,67);                    -- Saotome Kabuto -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2093,67);                    -- Koga Hatsuburi -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2098,67);                    -- Wyrm Armet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,2,@UNCOMMON,2103,67);                    -- Summoners Horn -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,3,@UNCOMMON,2662,200);                   -- Mirage Keffiyeh -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,3,@UNCOMMON,2667,200);                   -- Commodore Tricorne -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,3,@UNCOMMON,2672,200);                   -- Pantin Taj -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,3,@UNCOMMON,2718,200);                   -- Etoile Tiara -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,1,3,@UNCOMMON,2723,200);                   -- Argute Mortarboard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1792,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  39 - Nightmare Hippogryph Tier 1
-- ZoneID:  39 - Nightmare Sabotender Tier 1
-- ZoneID:  39 - Nightmare Sheep Tier 1
INSERT INTO `mob_droplist` VALUES (1794,0,0,1000,3456,@UNCOMMON);                  -- Creepers Juju (5%)
INSERT INTO `mob_droplist` VALUES (1794,0,0,1000,3495,@UNCOMMON);                  -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,1,@UNCOMMON,15482,250);                  -- Bards Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,1,@UNCOMMON,15484,250);                  -- Summoners Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,1,@UNCOMMON,15871,250);                  -- Warriors Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,1,@UNCOMMON,15877,250);                  -- Koga Sarashi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2033,66);                    -- Warriors Mask -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2038,66);                    -- Melee Crown -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2043,66);                    -- Clerics Cap -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2048,66);                    -- Sorcerers Petasos -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2053,67);                    -- Duelists Chapeau -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2058,67);                    -- Assassins Bonnet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2063,67);                    -- Valor Coronet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2068,67);                    -- Abyss Burgeonet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2073,67);                    -- Monster Helm -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2078,67);                    -- Bards Roundlet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2083,67);                    -- Scouts Beret -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2088,67);                    -- Saotome Kabuto -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2093,67);                    -- Koga Hatsuburi -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2098,67);                    -- Wyrm Armet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,2,@UNCOMMON,2103,67);                    -- Summoners Horn -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,3,@UNCOMMON,2662,200);                   -- Mirage Keffiyeh -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,3,@UNCOMMON,2667,200);                   -- Commodore Tricorne -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,3,@UNCOMMON,2672,200);                   -- Pantin Taj -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,3,@UNCOMMON,2718,200);                   -- Etoile Tiara -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,1,3,@UNCOMMON,2723,200);                   -- Argute Mortarboard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1794,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)

-- ZoneID:  39 - Nightmare Manticore Tier 1
-- ZoneID:  39 - Nightmare Treant Tier 1
-- ZoneID:  39 - Nightmare Goobbue Tier 1
INSERT INTO `mob_droplist` VALUES (1799,0,0,1000,3456,@UNCOMMON);                  -- Creepers Juju (5%)
INSERT INTO `mob_droplist` VALUES (1799,0,0,1000,3495,@UNCOMMON);                  -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,1,@UNCOMMON,15480,200);                  -- Assassins Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,1,@UNCOMMON,15872,200);                  -- Clerics Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,1,@UNCOMMON,15874,200);                  -- Sorcerers Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,1,@UNCOMMON,15875,200);                  -- Monster Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,1,@UNCOMMON,15879,200);                  -- Saotome Koshi-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2033,66);                    -- Warriors Mask -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2038,66);                    -- Melee Crown -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2043,66);                    -- Clerics Cap -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2048,66);                    -- Sorcerers Petasos -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2053,67);                    -- Duelists Chapeau -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2058,67);                    -- Assassins Bonnet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2063,67);                    -- Valor Coronet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2068,67);                    -- Abyss Burgeonet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2073,67);                    -- Monster Helm -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2078,67);                    -- Bards Roundlet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2083,67);                    -- Scouts Beret -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2088,67);                    -- Saotome Kabuto -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2093,67);                    -- Koga Hatsuburi -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2098,67);                    -- Wyrm Armet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,2,@UNCOMMON,2103,67);                    -- Summoners Horn -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,3,@UNCOMMON,2662,200);                   -- Mirage Keffiyeh -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,3,@UNCOMMON,2667,200);                   -- Commodore Tricorne -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,3,@UNCOMMON,2672,200);                   -- Pantin Taj -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,3,@UNCOMMON,2718,200);                   -- Etoile Tiara -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,1,3,@UNCOMMON,2723,200);                   -- Argute Mortarboard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1799,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID:  39 - Nightmare Flytrap Tier 2
-- ZoneID:  39 - Nightmare Funguar Tier 2
-- ZoneID:  39 - Nightmare Fly Tier 2
INSERT INTO `mob_droplist` VALUES (3122,0,0,1000,3461,@UNCOMMON);                  -- Nightmare Bud (5%)
INSERT INTO `mob_droplist` VALUES (3122,0,0,1000,3495,@UNCOMMON);                  -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,1,@UNCOMMON,15480,200);                  -- Assassins Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,1,@UNCOMMON,15872,200);                  -- Clerics Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,1,@UNCOMMON,15874,200);                  -- Sorcerers Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,1,@UNCOMMON,15875,200);                  -- Monster Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,1,@UNCOMMON,15879,200);                  -- Saotome Koshi-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2033,66);                    -- Warriors Mask -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2038,66);                    -- Melee Crown -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2043,66);                    -- Clerics Cap -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2048,66);                    -- Sorcerers Petasos -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2053,67);                    -- Duelists Chapeau -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2058,67);                    -- Assassins Bonnet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2063,67);                    -- Valor Coronet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2068,67);                    -- Abyss Burgeonet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2073,67);                    -- Monster Helm -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2078,67);                    -- Bards Roundlet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2083,67);                    -- Scouts Beret -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2088,67);                    -- Saotome Kabuto -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2093,67);                    -- Koga Hatsuburi -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2098,67);                    -- Wyrm Armet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,2,@UNCOMMON,2103,67);                    -- Summoners Horn -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,3,@UNCOMMON,2662,200);                   -- Mirage Keffiyeh -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,3,@UNCOMMON,2667,200);                   -- Commodore Tricorne -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,3,@UNCOMMON,2672,200);                   -- Pantin Taj -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,3,@UNCOMMON,2718,200);                   -- Etoile Tiara -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,1,3,@UNCOMMON,2723,200);                   -- Argute Mortarboard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3122,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  39 - Nightmare Sabotender Tier 2
-- ZoneID:  39 - Nightmare Hippogryph Tier 2
-- ZoneID:  39 - Nightmare Sheep Tier 2
INSERT INTO `mob_droplist` VALUES (3123,0,0,1000,3460,@UNCOMMON);                  -- Nightmare Log (5%)
INSERT INTO `mob_droplist` VALUES (3123,0,0,1000,3495,@UNCOMMON);                  -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,1,@UNCOMMON,15480,200);                  -- Assassins Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,1,@UNCOMMON,15872,200);                  -- Clerics Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,1,@UNCOMMON,15874,200);                  -- Sorcerers Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,1,@UNCOMMON,15875,200);                  -- Monster Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,1,@UNCOMMON,15879,200);                  -- Saotome Koshi-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2033,66);                    -- Warriors Mask -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2038,66);                    -- Melee Crown -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2043,66);                    -- Clerics Cap -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2048,66);                    -- Sorcerers Petasos -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2053,67);                    -- Duelists Chapeau -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2058,67);                    -- Assassins Bonnet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2063,67);                    -- Valor Coronet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2068,67);                    -- Abyss Burgeonet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2073,67);                    -- Monster Helm -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2078,67);                    -- Bards Roundlet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2083,67);                    -- Scouts Beret -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2088,67);                    -- Saotome Kabuto -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2093,67);                    -- Koga Hatsuburi -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2098,67);                    -- Wyrm Armet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,2,@UNCOMMON,2103,67);                    -- Summoners Horn -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,3,@UNCOMMON,2662,200);                   -- Mirage Keffiyeh -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,3,@UNCOMMON,2667,200);                   -- Commodore Tricorne -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,3,@UNCOMMON,2672,200);                   -- Pantin Taj -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,3,@UNCOMMON,2718,200);                   -- Etoile Tiara -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,1,3,@UNCOMMON,2723,200);                   -- Argute Mortarboard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3123,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)

-- ZoneID:  39 - Nightmare Goobbue Tier 2
-- ZoneID:  39 - Nightmare Manticore Tier 2
-- ZoneID:  39 - Nightmare Treant Tier 2
INSERT INTO `mob_droplist` VALUES (3124,0,0,1000,3462,@UNCOMMON);                  -- Flask Of Nightmare Water (5%)
INSERT INTO `mob_droplist` VALUES (3124,0,0,1000,3495,@UNCOMMON);                  -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,1,@UNCOMMON,15480,200);                  -- Assassins Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,1,@UNCOMMON,15872,200);                  -- Clerics Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,1,@UNCOMMON,15874,200);                  -- Sorcerers Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,1,@UNCOMMON,15875,200);                  -- Monster Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,1,@UNCOMMON,15879,200);                  -- Saotome Koshi-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2033,66);                    -- Warriors Mask -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2038,66);                    -- Melee Crown -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2043,66);                    -- Clerics Cap -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2048,66);                    -- Sorcerers Petasos -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2053,67);                    -- Duelists Chapeau -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2058,67);                    -- Assassins Bonnet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2063,67);                    -- Valor Coronet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2068,67);                    -- Abyss Burgeonet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2073,67);                    -- Monster Helm -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2078,67);                    -- Bards Roundlet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2083,67);                    -- Scouts Beret -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2088,67);                    -- Saotome Kabuto -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2093,67);                    -- Koga Hatsuburi -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2098,67);                    -- Wyrm Armet -1 (Uncomon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,2,@UNCOMMON,2103,67);                    -- Summoners Horn -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,3,@UNCOMMON,2662,200);                   -- Mirage Keffiyeh -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,3,@UNCOMMON,2667,200);                   -- Commodore Tricorne -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,3,@UNCOMMON,2672,200);                   -- Pantin Taj -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,3,@UNCOMMON,2718,200);                   -- Etoile Tiara -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,1,3,@UNCOMMON,2723,200);                   -- Argute Mortarboard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3124,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID:  39 - Fairy Ring
INSERT INTO `mob_droplist` VALUES (806,0,0,1000,5895,@ALWAYS);                     -- Odorless Fungus (Always, 100%)
INSERT INTO `mob_droplist` VALUES (806,0,0,1000,3495,@UNCOMMON);                   -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (806,1,1,@VCOMMON,1449,333);                     -- Tukuku Whiteshell (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (806,1,1,@VCOMMON,1452,333);                     -- Ordelle Bronzepiece (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (806,1,1,@VCOMMON,1455,334);                     -- One Byne Bill (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (806,1,2,@RARE,1450,333);                        -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (806,1,2,@RARE,1453,333);                        -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (806,1,2,@RARE,1456,334);                        -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (806,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (806,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (806,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  39 - Stcemqestcint
INSERT INTO `mob_droplist` VALUES (2909,0,0,1000,5897,@ALWAYS);                    -- Redolent Root (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2909,0,0,1000,3495,@UNCOMMON);                  -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2909,1,1,@VCOMMON,1449,333);                    -- Tukuku Whiteshell (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2909,1,1,@VCOMMON,1452,333);                    -- Ordelle Bronzepiece (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2909,1,1,@VCOMMON,1455,334);                    -- One Byne Bill (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2909,1,2,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2909,1,2,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2909,1,2,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2909,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2909,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2909,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  39 - Nantina
INSERT INTO `mob_droplist` VALUES (2910,0,0,1000,5896,@ALWAYS);                    -- Clump Of Absorbent Moss (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2910,0,0,1000,3495,@UNCOMMON);                  -- Forgotten Touch (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2910,1,1,@VCOMMON,1449,333);                    -- Tukuku Whiteshell (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2910,1,1,@VCOMMON,1452,333);                    -- Ordelle Bronzepiece (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2910,1,1,@VCOMMON,1455,334);                    -- One Byne Bill (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2910,1,2,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2910,1,2,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2910,1,2,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2910,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2910,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2910,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  39 - Cirrate Christelle
INSERT INTO `mob_droplist` VALUES (472,0,0,1000,3470,@ALWAYS);                      -- Fiendish Tome Ii Chapter 1 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (472,0,0,1000,@FORGOTTEN_POUCH_HANDS,@ALWAYS);    -- Forgotten pouch touch (Always, 100%)
INSERT INTO `mob_droplist` VALUES (472,1,1,1000,@FORGOTTEN_POUCH_HANDS,970);        -- Forgotten pouch touch (97%)
INSERT INTO `mob_droplist` VALUES (472,1,1,1000,1450,10);                           -- Lungo-Nango-Nango Jadeshell (3%)
INSERT INTO `mob_droplist` VALUES (472,1,1,1000,1453,10);                           -- Montiont Silverpiece (3%)
INSERT INTO `mob_droplist` VALUES (472,1,1,1000,1456,10);                           -- One Hundred Byne Bill (3%)
INSERT INTO `mob_droplist` VALUES (472,0,0,1000,11634,50);                          -- Cirrate Christelle - veela_ring
INSERT INTO `mob_droplist` VALUES (472,0,0,1000,19245,100);                         -- Cirrate Christelle - jinx_ampulla
INSERT INTO `mob_droplist` VALUES (472,0,0,1000,2470,100);                          -- Cirrate Christelle - nethereye_chain
INSERT INTO `mob_droplist` VALUES (472,2,0,1000,1449,0);                            -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (472,2,0,1000,1452,0);                            -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (472,2,0,1000,1455,0);                            -- One Byne Bill (Steal)

-- ZoneID:  39 - Lost Nantina
INSERT INTO `mob_droplist` VALUES (3127,0,0,1000,3471,@ALWAYS);                     -- Fiendish Tome Ii Chapter 2 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3127,1,1,1000,10943,130);                        -- Moepapa Medal (13%)
INSERT INTO `mob_droplist` VALUES (3127,1,1,1000,@FORGOTTEN_POUCH_HANDS,870);       -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3127,0,0,1000,@FORGOTTEN_POUCH_HANDS,@ALWAYS);   -- Forgotten pouch touch (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3127,1,2,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3127,1,2,1000,1450,16);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3127,1,2,1000,1453,17);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3127,1,2,1000,1456,17);                          -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3127,1,3,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3127,1,3,1000,1450,16);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3127,1,3,1000,1453,17);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3127,1,3,1000,1456,17);                          -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3127,1,4,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3127,1,4,1000,1450,17);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3127,1,4,1000,1453,16);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3127,1,4,1000,1456,17);                          -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (3127,1,5,1000,@FORGOTTEN_POUCH_HANDS,950);    -- Forgotten pouch touch (95%)
-- INSERT INTO `mob_droplist` VALUES (3127,1,5,1000,1450,17);                       -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (3127,1,5,1000,1453,17);                       -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (3127,1,5,1000,1456,16);                       -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3127,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3127,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3127,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  39 - Lost Fairy Ring
INSERT INTO `mob_droplist` VALUES (3125,0,0,1000,3472,@ALWAYS);                     -- Fiendish Tome Ii Chapter 3 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3125,1,1,1000,10817,130);                        -- Moepapa Stone (13%)
INSERT INTO `mob_droplist` VALUES (3125,1,1,1000,@FORGOTTEN_POUCH_HANDS,870);       -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3125,0,0,1000,@FORGOTTEN_POUCH_HANDS,@ALWAYS);   -- Forgotten pouch touch (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3125,1,2,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3125,1,2,1000,1450,16);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3125,1,2,1000,1453,17);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3125,1,2,1000,1456,17);                          -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3125,1,3,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3125,1,3,1000,1450,16);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3125,1,3,1000,1453,17);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3125,1,3,1000,1456,17);                          -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3125,1,4,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3125,1,4,1000,1450,17);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3125,1,4,1000,1453,16);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3125,1,4,1000,1456,17);                          -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (3125,1,5,1000,@FORGOTTEN_POUCH_HANDS,950);    -- Forgotten pouch touch (95%)
-- INSERT INTO `mob_droplist` VALUES (3125,1,5,1000,1450,17);                       -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (3125,1,5,1000,1453,17);                       -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (3125,1,5,1000,1456,16);                       -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3125,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3125,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3125,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  39 - Lost Stcemqestcint
INSERT INTO `mob_droplist` VALUES (3126,0,0,1000,3473,@ALWAYS);                     -- Fiendish Tome Ii Chapter 4 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3126,1,1,1000,17069,130);                        -- Moepapa Mace (13%)
INSERT INTO `mob_droplist` VALUES (3126,1,1,1000,@FORGOTTEN_POUCH_HANDS,870);       -- Forgotten pouch touch (87%)
INSERT INTO `mob_droplist` VALUES (3126,0,0,1000,@FORGOTTEN_POUCH_HANDS,@ALWAYS);   -- Forgotten pouch touch (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3126,1,2,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3126,1,2,1000,1450,16);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3126,1,2,1000,1453,17);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3126,1,2,1000,1456,17);                          -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3126,1,3,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3126,1,3,1000,1450,16);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3126,1,3,1000,1453,17);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3126,1,3,1000,1456,17);                          -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3126,1,4,1000,@FORGOTTEN_POUCH_HANDS,950);       -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (3126,1,4,1000,1450,17);                          -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3126,1,4,1000,1453,16);                          -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3126,1,4,1000,1456,17);                          -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (3126,1,5,1000,@FORGOTTEN_POUCH_HANDS,950);    -- Forgotten pouch touch (95%)
-- INSERT INTO `mob_droplist` VALUES (3126,1,5,1000,1450,17);                       -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (3126,1,5,1000,1453,17);                       -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (3126,1,5,1000,1456,16);                       -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3126,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3126,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3126,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  39 - Arch Christelle
INSERT INTO `mob_droplist` VALUES (3128,0,0,1000,10754,200);                        -- Moepapa Ring (20%)
INSERT INTO `mob_droplist` VALUES (3128,0,0,1000,10755,200);                        -- Moepapa Annulet (20%)
INSERT INTO `mob_droplist` VALUES (3128,0,0,1000,10940,200);                        -- Moepapa Pendant (20%)
INSERT INTO `mob_droplist` VALUES (3128,0,0,1000,@FORGOTTEN_POUCH_HANDS,@ALWAYS);   -- Forgotten pouch touch (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3128,1,1,1000,@FORGOTTEN_POUCH_HANDS,925);       -- Forgotten pouch touch (90%)
INSERT INTO `mob_droplist` VALUES (3128,1,1,1000,1450,25);                          -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3128,1,1,1000,1453,25);                          -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3128,1,1,1000,1456,25);                          -- One Hundred Byne Bill (7.5%)
INSERT INTO `mob_droplist` VALUES (3128,1,2,1000,@FORGOTTEN_POUCH_HANDS,925);       -- Forgotten pouch touch (90%)
INSERT INTO `mob_droplist` VALUES (3128,1,2,1000,1450,25);                          -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3128,1,2,1000,1453,25);                          -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3128,1,2,1000,1456,25);                          -- One Hundred Byne Bill (7.5%)
INSERT INTO `mob_droplist` VALUES (3128,1,3,1000,@FORGOTTEN_POUCH_HANDS,925);       -- Forgotten pouch touch (90%)
INSERT INTO `mob_droplist` VALUES (3128,1,3,1000,1450,25);                          -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3128,1,3,1000,1453,25);                          -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3128,1,3,1000,1456,25);                          -- One Hundred Byne Bill (7.5%)
-- INSERT INTO `mob_droplist` VALUES (3128,1,4,1000,@FORGOTTEN_POUCH_HANDS,950);    -- Forgotten pouch touch (90%)
-- INSERT INTO `mob_droplist` VALUES (3128,1,4,1000,1450,25);                       -- Lungo-Nango-Nango Jadeshell (7.5%)
-- INSERT INTO `mob_droplist` VALUES (3128,1,4,1000,1453,25);                       -- Montiont Silverpiece (7.5%)
-- INSERT INTO `mob_droplist` VALUES (3128,1,4,1000,1456,25);                       -- One Hundred Byne Bill (7.5%)
INSERT INTO `mob_droplist` VALUES (3128,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3128,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3128,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- --------------------------------------------------------------------
--                          Dynamis-Buburimu                         --
-- --------------------------------------------------------------------

-- Ensure we're clearing out the old drop lists
DELETE FROM `mob_droplist` WHERE dropid = "1785"; -- Delete Bunny, Mandragora, Eft T1
DELETE FROM `mob_droplist` WHERE dropid = "1787"; -- Delete Crab, Dhalmel, Scorpion T1
DELETE FROM `mob_droplist` WHERE dropid = "1788"; -- Delete Uragnite, Crawler, Raven T1
DELETE FROM `mob_droplist` WHERE dropid = "1789"; -- Delete Bunny, Mandragora, Eft T2
DELETE FROM `mob_droplist` WHERE dropid = "1791"; -- Delete Crab, Dhalmel, Scorpion T2
DELETE FROM `mob_droplist` WHERE dropid = "1798"; -- Delete Uragnite, Crawler, Raven T2
DELETE FROM `mob_droplist` WHERE dropid = "2540"; -- Delete Vanguard Goblin
DELETE FROM `mob_droplist` WHERE dropid = "2545"; -- Delete Vanguard Orc
DELETE FROM `mob_droplist` WHERE dropid = "2550"; -- Delete Vanguard Yagudo
DELETE FROM `mob_droplist` WHERE dropid = "2555"; -- Delete Vanguard Quadavs
DELETE FROM `mob_droplist` WHERE dropid =  "209"; -- Delete Baa Dava The Bibliophage
DELETE FROM `mob_droplist` WHERE dropid =  "689"; -- Delete Doo Peku The Fleetfoot
DELETE FROM `mob_droplist` WHERE dropid =  "760"; -- Delete Elvaansticker Bxafraff
DELETE FROM `mob_droplist` WHERE dropid =  "840"; -- Delete Flamecaller Zoeqdoq
DELETE FROM `mob_droplist` WHERE dropid = "1209"; -- Delete Gosspix Blabberlips
DELETE FROM `mob_droplist` WHERE dropid = "1271"; -- Delete Hamfist Gukhbuk
DELETE FROM `mob_droplist` WHERE dropid = "1461"; -- Delete Koo Rahi The Levinblade
DELETE FROM `mob_droplist` WHERE dropid = "1556"; -- Delete Lyncean Juwgneg
DELETE FROM `mob_droplist` WHERE dropid = "2085"; -- Delete Ree Nata The Melomanic
DELETE FROM `mob_droplist` WHERE dropid = "2229"; -- Delete Shamblix Rottenheart
DELETE FROM `mob_droplist` WHERE dropid = "2667"; -- Delete Woodnix Shrillwhistle
DELETE FROM `mob_droplist` WHERE dropid = "2901"; -- Delete Gibhe Fleshfeaster
DELETE FROM `mob_droplist` WHERE dropid = "2902"; -- Delete Qupho Bloodspiller
DELETE FROM `mob_droplist` WHERE dropid = "2903"; -- Delete Tezha Ironclad
DELETE FROM `mob_droplist` WHERE dropid = "2904"; -- Delete Varhu Bodysnatcher
DELETE FROM `mob_droplist` WHERE dropid =   "41"; -- Delete Aitvaras
DELETE FROM `mob_droplist` WHERE dropid =   "48"; -- Delete Alklha
DELETE FROM `mob_droplist` WHERE dropid =  "230"; -- Delete Barong
DELETE FROM `mob_droplist` WHERE dropid = "2335"; -- Delete Stihi
DELETE FROM `mob_droplist` WHERE dropid =  "146"; -- Delete Apocalyptic Beast
DELETE FROM `mob_droplist` WHERE dropid = "1802"; -- Delete Lost Aitvaras
DELETE FROM `mob_droplist` WHERE dropid = "1805"; -- Delete Lost Alklha
DELETE FROM `mob_droplist` WHERE dropid = "2795"; -- Delete Lost Barong
DELETE FROM `mob_droplist` WHERE dropid = "2796"; -- Delete Lost Stihi
DELETE FROM `mob_droplist` WHERE dropid = "2797"; -- Delete Arch Apocalyptic Beast

-- Assign drop lists to bosses
UPDATE `mob_groups` SET `dropid` = 146  WHERE name = 'Apocalyptic_Beast' AND zoneid = 40;
UPDATE `mob_groups` SET `dropid` = 2796 WHERE name = 'Lost_Stihi' AND zoneid = 40;
UPDATE `mob_groups` SET `dropid` = 2795 WHERE name = 'Lost_Barong' AND zoneid = 40;
UPDATE `mob_groups` SET `dropid` = 1805 WHERE name = 'Lost_Alklha' AND zoneid = 40;
UPDATE `mob_groups` SET `dropid` = 2797 WHERE name = 'Arch_Apocalyptic_Beast' AND zoneid = 40;

-- ZoneID:  40 - Vanguard Pathfinder
-- ZoneID:  40 - Vanguard Maestro
-- ZoneID:  40 - Vanguard Ronin
-- ZoneID:  40 - Vanguard Smithy
-- ZoneID:  40 - Vanguard Alchemist
-- ZoneID:  40 - Vanguard Shaman
-- ZoneID:  40 - Vanguard Tinkerer
-- ZoneID:  40 - Vanguard Hitman
-- ZoneID:  40 - Vanguard Pitfighter
-- ZoneID:  40 - Vanguard Enchanter
-- ZoneID:  40 - Vanguard Welldigger
-- ZoneID:  40 - Vanguard Armorer
-- ZoneID:  40 - Vanguard Ambusher
-- ZoneID:  40 - Vanguard Necromancer
-- ZoneID:  40 - Vanguard Pitfighter
-- ZoneID:  40 - Vanguard Enchanter
-- ZoneID:  40 - Vanguard Welldigger
-- ZoneID:  40 - Vanguard Armorer
-- ZoneID:  40 - Vanguard Pathfinder
-- ZoneID:  40 - Vanguard Maestro
-- ZoneID:  40 - Vanguard Ronin
-- ZoneID:  40 - Vanguard Necromancer
-- ZoneID:  40 - Vanguard Smithy
-- ZoneID:  40 - Vanguard Alchemist
-- ZoneID:  40 - Vanguard Shaman
-- ZoneID:  40 - Vanguard Tinkerer
-- ZoneID:  40 - Vanguard Ambusher
-- ZoneID:  40 - Vanguard Hitman
-- ZoneID:  40 - Vanguard Dragontamer
-- ZoneID:  40 - Vanguard Dragontamer
INSERT INTO `mob_droplist` VALUES (2540,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15074,66);                       -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15081,66);                       -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15092,66);                       -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15095,66);                       -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15102,66);                       -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15105,67);                       -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15106,67);                       -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15108,67);                       -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15109,67);                       -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15116,67);                       -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15118,67);                       -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15127,67);                       -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15128,67);                       -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15144,67);                       -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,1,@UNCOMMON,15145,67);                       -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2540,1,2,@RARE,11388,143);                     -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2540,1,2,@RARE,15028,143);                     -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2540,1,2,@RARE,16346,143);                     -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2540,1,2,@RARE,11478,143);                     -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2540,1,2,@RARE,11398,143);                     -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2540,1,2,@RARE,26666,143);                     -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2540,1,2,@RARE,27368,142);                     -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2540,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2540,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2540,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Vanguard Mesmerizer
-- ZoneID:  40 - Vanguard Vexer
-- ZoneID:  40 - Vanguard Pillager
-- ZoneID:  40 - Vanguard Neckchopper
-- ZoneID:  40 - Vanguard Hawker
-- ZoneID:  40 - Vanguard Bugler
-- ZoneID:  40 - Vanguard Backstabber
-- ZoneID:  40 - Vanguard Impaler
-- ZoneID:  40 - Vanguard Footsoldier
-- ZoneID:  40 - Vanguard Grappler
-- ZoneID:  40 - Vanguard Amputator
-- ZoneID:  40 - Vanguard Predator
-- ZoneID:  40 - Vanguard Trooper
-- ZoneID:  40 - Vanguard Gutslasher
-- ZoneID:  40 - Vanguard Dollmaster
-- ZoneID:  40 - Vanguard Mesmerizer
-- ZoneID:  40 - Vanguard Vexer
-- ZoneID:  40 - Vanguard Pillager
-- ZoneID:  40 - Vanguard Neckchopper
-- ZoneID:  40 - Vanguard Hawker
-- ZoneID:  40 - Vanguard Bugler
-- ZoneID:  40 - Vanguard Backstabber
-- ZoneID:  40 - Vanguard Impaler
-- ZoneID:  40 - Vanguard Footsoldier
-- ZoneID:  40 - Vanguard Grappler
-- ZoneID:  40 - Vanguard Amputator
-- ZoneID:  40 - Vanguard Predator
-- ZoneID:  40 - Vanguard Trooper
-- ZoneID:  40 - Vanguard Gutslasher
-- ZoneID:  40 - Vanguard Dollmaster
INSERT INTO `mob_droplist` VALUES (2545,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2545,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2545,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2545,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2545,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2545,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2545,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2545,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2545,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)

-- ZoneID:  40 - Vanguard Sentinel
-- ZoneID:  40 - Vanguard Priest
-- ZoneID:  40 - Vanguard Liberator
-- ZoneID:  40 - Vanguard Exemplar
-- ZoneID:  40 - Vanguard Ogresoother
-- ZoneID:  40 - Vanguard Chanter
-- ZoneID:  40 - Vanguard Persecutor
-- ZoneID:  40 - Vanguard Partisan
-- ZoneID:  40 - Vanguard Skirmisher
-- ZoneID:  40 - Vanguard Prelate
-- ZoneID:  40 - Vanguard Visionary
-- ZoneID:  40 - Vanguard Inciter
-- ZoneID:  40 - Vanguard Salvager
-- ZoneID:  40 - Vanguard Assassin
-- ZoneID:  40 - Vanguard Oracle
-- ZoneID:  40 - Vanguard Sentinel
-- ZoneID:  40 - Vanguard Priest
-- ZoneID:  40 - Vanguard Liberator
-- ZoneID:  40 - Vanguard Exemplar
-- ZoneID:  40 - Vanguard Ogresoother
-- ZoneID:  40 - Vanguard Chanter
-- ZoneID:  40 - Vanguard Persecutor
-- ZoneID:  40 - Vanguard Partisan
-- ZoneID:  40 - Vanguard Skirmisher
-- ZoneID:  40 - Vanguard Prelate
-- ZoneID:  40 - Vanguard Visionary
-- ZoneID:  40 - Vanguard Inciter
-- ZoneID:  40 - Vanguard Salvager
-- ZoneID:  40 - Vanguard Assassin
-- ZoneID:  40 - Vanguard Oracle
INSERT INTO `mob_droplist` VALUES (2550,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2550,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2550,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2550,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2550,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2550,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2550,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2550,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2550,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID:  40 - Vanguard Vindicator
-- ZoneID:  40 - Vanguard Militant
-- ZoneID:  40 - Vanguard Constable
-- ZoneID:  40 - Vanguard Beasttender
-- ZoneID:  40 - Vanguard Minstrel
-- ZoneID:  40 - Vanguard Mason
-- ZoneID:  40 - Vanguard Drakekeeper
-- ZoneID:  40 - Vanguard Thaumaturge
-- ZoneID:  40 - Vanguard Protector
-- ZoneID:  40 - Vanguard Purloiner
-- ZoneID:  40 - Vanguard Defender
-- ZoneID:  40 - Vanguard Vigilante
-- ZoneID:  40 - Vanguard Hatamoto
-- ZoneID:  40 - Vanguard Kusa
-- ZoneID:  40 - Vanguard Undertaker
-- ZoneID:  40 - Vanguard Vindicator
-- ZoneID:  40 - Vanguard Militant
-- ZoneID:  40 - Vanguard Constable
-- ZoneID:  40 - Vanguard Beasttender
-- ZoneID:  40 - Vanguard Minstrel
-- ZoneID:  40 - Vanguard Mason
-- ZoneID:  40 - Vanguard Drakekeeper
-- ZoneID:  40 - Vanguard Thaumaturge
-- ZoneID:  40 - Vanguard Protector
-- ZoneID:  40 - Vanguard Purloiner
-- ZoneID:  40 - Vanguard Defender
-- ZoneID:  40 - Vanguard Vigilante
-- ZoneID:  40 - Vanguard Hatamoto
-- ZoneID:  40 - Vanguard Kusa
-- ZoneID:  40 - Vanguard Undertaker
INSERT INTO `mob_droplist` VALUES (2555,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2555,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2555,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2555,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2555,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2555,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2555,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2555,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2555,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Nightmare Bunny Tier 1
-- ZoneID:  40 - Nightmare Mandragora Tier 1
-- ZoneID:  40 - Nightmare Eft Tier 1
INSERT INTO `mob_droplist` VALUES (1785,0,0,1000,3457,@UNCOMMON);                  -- Revelatory Juju (5%)
INSERT INTO `mob_droplist` VALUES (1785,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (5%)
INSERT INTO `mob_droplist` VALUES (1785,1,1,@UNCOMMON,15871,200);                  -- Warriors Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,1,@UNCOMMON,15874,200);                  -- Sorcerers Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,1,@UNCOMMON,15876,200);                  -- Scouts Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,1,@UNCOMMON,16245,200);                  -- Pantin Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,1,@UNCOMMON,26323,200);                  -- Bagua Sash (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2035,66);                    -- Warriors Mufflers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2040,66);                    -- Melee Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2045,66);                    -- Clerics Mitts -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2050,66);                    -- Sorcerers Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2055,66);                    -- Duelists Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2060,67);                    -- Assassins Armlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2065,67);                    -- Valor Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2070,67);                    -- Abyss Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2075,67);                    -- Monster Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2080,67);                    -- Bards Cuffs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2085,67);                    -- Scouts Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2090,67);                    -- Saotome Kote -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2095,67);                    -- Koga Tekko -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2100,67);                    -- Wyrm Finger Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,2,@UNCOMMON,2105,67);                    -- Summoners Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,3,@UNCOMMON,2664,200);                   -- Mirage Bazubands -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,3,@UNCOMMON,2669,200);                   -- Commodore Gants -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,3,@UNCOMMON,2674,200);                   -- Pantin Dastanas -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,3,@UNCOMMON,2720,200);                   -- Etoile Bangles -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,1,3,@UNCOMMON,2725,200);                   -- Argute Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1785,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)

-- ZoneID:  40 - Nightmare Crab Tier 1
-- ZoneID:  40 - Nightmare Dhalmel Tier 1
-- ZoneID:  40 - Nightmare Scorpion Tier 1
INSERT INTO `mob_droplist` VALUES (1787,0,0,1000,3457,@UNCOMMON);                  -- Revelatory Juju (5%)
INSERT INTO `mob_droplist` VALUES (1787,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (5%)
INSERT INTO `mob_droplist` VALUES (1787,1,1,@UNCOMMON,15478,250);                  -- Melee Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,1,@UNCOMMON,15481,250);                  -- Valor Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,1,@UNCOMMON,15482,250);                  -- Bards Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,1,@UNCOMMON,15878,250);                  -- Wyrm Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2035,66);                    -- Warriors Mufflers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2040,66);                    -- Melee Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2045,66);                    -- Clerics Mitts -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2050,66);                    -- Sorcerers Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2055,66);                    -- Duelists Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2060,67);                    -- Assassins Armlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2065,67);                    -- Valor Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2070,67);                    -- Abyss Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2075,67);                    -- Monster Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2080,67);                    -- Bards Cuffs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2085,67);                    -- Scouts Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2090,67);                    -- Saotome Kote -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2095,67);                    -- Koga Tekko -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2100,67);                    -- Wyrm Finger Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,2,@UNCOMMON,2105,67);                    -- Summoners Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,3,@UNCOMMON,2664,200);                   -- Mirage Bazubands -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,3,@UNCOMMON,2669,200);                   -- Commodore Gants -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,3,@UNCOMMON,2674,200);                   -- Pantin Dastanas -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,3,@UNCOMMON,2720,200);                   -- Etoile Bangles -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,1,3,@UNCOMMON,2725,200);                   -- Argute Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1787,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID:  40 - Nightmare Uragnite Tier 1
-- ZoneID:  40 - Nightmare Crawler Tier 1
-- ZoneID:  40 - Nightmare Raven Tier 1
INSERT INTO `mob_droplist` VALUES (1788,0,0,1000,3457,@UNCOMMON);                  -- Revelatory Juju (5%)
INSERT INTO `mob_droplist` VALUES (1788,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,1,@UNCOMMON,15479,250);                  -- Abyss Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,1,@UNCOMMON,15873,250);                  -- Duelists Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,1,@UNCOMMON,15877,250);                  -- Koga Sarashi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,1,@UNCOMMON,16244,250);                  -- Mirage Mantle (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2035,66);                    -- Warriors Mufflers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2040,66);                    -- Melee Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2045,66);                    -- Clerics Mitts -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2050,66);                    -- Sorcerers Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2055,66);                    -- Duelists Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2060,67);                    -- Assassins Armlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2065,67);                    -- Valor Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2070,67);                    -- Abyss Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2075,67);                    -- Monster Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2080,67);                    -- Bards Cuffs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2085,67);                    -- Scouts Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2090,67);                    -- Saotome Kote -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2095,67);                    -- Koga Tekko -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2100,67);                    -- Wyrm Finger Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,2,@UNCOMMON,2105,67);                    -- Summoners Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,3,@UNCOMMON,2664,200);                   -- Mirage Bazubands -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,3,@UNCOMMON,2669,200);                   -- Commodore Gants -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,3,@UNCOMMON,2674,200);                   -- Pantin Dastanas -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,3,@UNCOMMON,2720,200);                   -- Etoile Bangles -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,1,3,@UNCOMMON,2725,200);                   -- Argute Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1788,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Nightmare Bunny Tier 2
-- ZoneID:  40 - Nightmare Mandragora Tier 2
-- ZoneID:  40 - Nightmare Eft Tier 2
INSERT INTO `mob_droplist` VALUES (1789,0,0,1000,3463,@UNCOMMON);                  -- Nightmare Shank (5%)
INSERT INTO `mob_droplist` VALUES (1789,0,0,1000,3466,@UNCOMMON);                  -- Nightmare Chop (5%)
INSERT INTO `mob_droplist` VALUES (1789,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,1,@UNCOMMON,15871,200);                  -- Warriors Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,1,@UNCOMMON,15874,200);                  -- Sorcerers Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,1,@UNCOMMON,15876,200);                  -- Scouts Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,1,@UNCOMMON,16245,200);                  -- Pantin Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,1,@UNCOMMON,26323,200);                  -- Bagua Sash (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2035,66);                    -- Warriors Mufflers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2040,66);                    -- Melee Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2045,66);                    -- Clerics Mitts -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2050,66);                    -- Sorcerers Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2055,66);                    -- Duelists Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2060,67);                    -- Assassins Armlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2065,67);                    -- Valor Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2070,67);                    -- Abyss Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2075,67);                    -- Monster Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2080,67);                    -- Bards Cuffs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2085,67);                    -- Scouts Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2090,67);                    -- Saotome Kote -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2095,67);                    -- Koga Tekko -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2100,67);                    -- Wyrm Finger Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,2,@UNCOMMON,2105,67);                    -- Summoners Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,3,@UNCOMMON,2664,200);                   -- Mirage Bazubands -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,3,@UNCOMMON,2669,200);                   -- Commodore Gants -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,3,@UNCOMMON,2674,200);                   -- Pantin Dastanas -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,3,@UNCOMMON,2720,200);                   -- Etoile Bangles -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,1,3,@UNCOMMON,2725,200);                   -- Argute Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1789,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)

-- ZoneID:  40 - Nightmare Crab Tier 2
-- ZoneID:  40 - Nightmare Dhalmel Tier 2
-- ZoneID:  40 - Nightmare Scorpion Tier 2
INSERT INTO `mob_droplist` VALUES (1791,0,0,1000,3465,@UNCOMMON);                  -- Nightmare Loin (2.0%)
INSERT INTO `mob_droplist` VALUES (1791,0,0,1000,3466,@UNCOMMON);                  -- Nightmare Chop (5%)
INSERT INTO `mob_droplist` VALUES (1791,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,1,@UNCOMMON,15478,250);                  -- Melee Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,1,@UNCOMMON,15481,250);                  -- Valor Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,1,@UNCOMMON,15482,250);                  -- Bards Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,1,@UNCOMMON,15878,250);                  -- Wyrm Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2035,66);                    -- Warriors Mufflers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2040,66);                    -- Melee Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2045,66);                    -- Clerics Mitts -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2050,66);                    -- Sorcerers Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2055,66);                    -- Duelists Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2060,67);                    -- Assassins Armlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2065,67);                    -- Valor Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2070,67);                    -- Abyss Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2075,67);                    -- Monster Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2080,67);                    -- Bards Cuffs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2085,67);                    -- Scouts Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2090,67);                    -- Saotome Kote -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2095,67);                    -- Koga Tekko -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2100,67);                    -- Wyrm Finger Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,2,@UNCOMMON,2105,67);                    -- Summoners Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,3,@UNCOMMON,2664,200);                   -- Mirage Bazubands -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,3,@UNCOMMON,2669,200);                   -- Commodore Gants -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,3,@UNCOMMON,2674,200);                   -- Pantin Dastanas -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,3,@UNCOMMON,2720,200);                   -- Etoile Bangles -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,1,3,@UNCOMMON,2725,200);                   -- Argute Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1791,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID:  40 - Nightmare Uragnite Tier 2
-- ZoneID:  40 - Nightmare Crawler Tier 2
-- ZoneID:  40 - Nightmare Raven Tier 2
INSERT INTO `mob_droplist` VALUES (1798,0,0,1000,3464,@UNCOMMON);                  -- Nightmare Roast (2.0%)
INSERT INTO `mob_droplist` VALUES (1798,0,0,1000,3466,@UNCOMMON);                  -- Nightmare Chop (5%)
INSERT INTO `mob_droplist` VALUES (1798,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,1,@UNCOMMON,15479,250);                  -- Abyss Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,1,@UNCOMMON,15873,250);                  -- Duelists Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,1,@UNCOMMON,15877,250);                  -- Koga Sarashi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,1,@UNCOMMON,16244,250);                  -- Mirage Mantle (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2035,66);                    -- Warriors Mufflers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2040,66);                    -- Melee Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2045,66);                    -- Clerics Mitts -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2050,66);                    -- Sorcerers Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2055,66);                    -- Duelists Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2060,67);                    -- Assassins Armlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2065,67);                    -- Valor Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2070,67);                    -- Abyss Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2075,67);                    -- Monster Gloves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2080,67);                    -- Bards Cuffs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2085,67);                    -- Scouts Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2090,67);                    -- Saotome Kote -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2095,67);                    -- Koga Tekko -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2100,67);                    -- Wyrm Finger Gauntlets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,2,@UNCOMMON,2105,67);                    -- Summoners Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,3,@UNCOMMON,2664,200);                   -- Mirage Bazubands -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,3,@UNCOMMON,2669,200);                   -- Commodore Gants -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,3,@UNCOMMON,2674,200);                   -- Pantin Dastanas -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,3,@UNCOMMON,2720,200);                   -- Etoile Bangles -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,1,3,@UNCOMMON,2725,200);                   -- Argute Bracers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1798,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Baa Dava The Bibliophage
INSERT INTO `mob_droplist` VALUES (209,0,0,1000,5902,@COMMON);                     -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (209,0,0,1000,1449,@COMMON);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (209,0,0,1000,1449,@COMMON);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (209,0,0,1000,1449,@COMMON);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (209,0,0,1000,1449,@COMMON);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (209,0,0,1000,1449,@COMMON);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (209,0,0,1000,3497,@UNCOMMON);                   -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15074,66);                    -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15081,66);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15092,66);                    -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15095,66);                    -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15102,66);                    -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15105,67);                    -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15106,67);                    -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15108,67);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15109,67);                    -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15116,67);                    -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15118,67);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15127,67);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15128,67);                    -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15144,67);                    -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,1,@UNCOMMON,15145,67);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (209,1,2,@RARE,11388,143);                       -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (209,1,2,@RARE,15028,143);                       -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (209,1,2,@RARE,16346,143);                       -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (209,1,2,@RARE,11478,143);                       -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (209,1,2,@RARE,11398,143);                       -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (209,1,2,@RARE,26666,143);                       -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (209,1,2,@RARE,27368,142);                       -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (209,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)

-- ZoneID:  40 - Doo Peku The Fleetfoot
INSERT INTO `mob_droplist` VALUES (689,0,0,1000,5902,@COMMON);                     -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (689,0,0,1000,1449,@COMMON);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (689,0,0,1000,1449,@COMMON);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (689,0,0,1000,1449,@COMMON);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (689,0,0,1000,1449,@COMMON);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (689,0,0,1000,1449,@COMMON);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (689,0,0,1000,3497,@UNCOMMON);                   -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15074,66);                    -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15081,66);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15092,66);                    -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15095,66);                    -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15102,66);                    -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15105,67);                    -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15106,67);                    -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15108,67);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15109,67);                    -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15116,67);                    -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15118,67);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15127,67);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15128,67);                    -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15144,67);                    -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,1,@UNCOMMON,15145,67);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (689,1,2,@RARE,11388,143);                       -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (689,1,2,@RARE,15028,143);                       -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (689,1,2,@RARE,16346,143);                       -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (689,1,2,@RARE,11478,143);                       -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (689,1,2,@RARE,11398,143);                       -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (689,1,2,@RARE,26666,143);                       -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (689,1,2,@RARE,27368,142);                       -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (689,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)

-- ZoneID:  40 - Elvaansticker Bxafraff
INSERT INTO `mob_droplist` VALUES (760,0,0,1000,5902,@COMMON);                     -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (760,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (760,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (760,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (760,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (760,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (760,0,0,1000,3497,@UNCOMMON);                   -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15074,66);                    -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15081,66);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15092,66);                    -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15095,66);                    -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15102,66);                    -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15105,67);                    -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15106,67);                    -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15108,67);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15109,67);                    -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15116,67);                    -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15118,67);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15127,67);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15128,67);                    -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15144,67);                    -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,1,@UNCOMMON,15145,67);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (760,1,2,@RARE,11388,143);                       -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (760,1,2,@RARE,15028,143);                       -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (760,1,2,@RARE,16346,143);                       -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (760,1,2,@RARE,11478,143);                       -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (760,1,2,@RARE,11398,143);                       -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (760,1,2,@RARE,26666,143);                       -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (760,1,2,@RARE,27368,142);                       -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (760,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)

-- ZoneID:  40 - Flamecaller Zoeqdoq
INSERT INTO `mob_droplist` VALUES (840,0,0,1000,5902,@COMMON);                     -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (840,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (840,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (840,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (840,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (840,0,0,1000,1452,@COMMON);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (840,0,0,1000,15105,@COMMON);                    -- Sorcerers Gloves (Common, 15%)
INSERT INTO `mob_droplist` VALUES (840,0,0,1000,3497,@UNCOMMON);                   -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15074,66);                    -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15081,66);                    -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15092,66);                    -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15095,66);                    -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15102,66);                    -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15105,67);                    -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15106,67);                    -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15108,67);                    -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15109,67);                    -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15116,67);                    -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15118,67);                    -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15127,67);                    -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15128,67);                    -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15144,67);                    -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,1,@UNCOMMON,15145,67);                    -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (840,1,2,@RARE,11388,143);                       -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (840,1,2,@RARE,15028,143);                       -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (840,1,2,@RARE,16346,143);                       -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (840,1,2,@RARE,11478,143);                       -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (840,1,2,@RARE,11398,143);                       -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (840,1,2,@RARE,26666,143);                       -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (840,1,2,@RARE,27368,142);                       -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (840,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)

-- ZoneID:  40 - Gosspix Blabberlips
INSERT INTO `mob_droplist` VALUES (1209,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,2,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,2,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,2,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,3,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,3,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,3,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,4,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,4,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,4,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,5,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,5,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,1,5,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1209,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1209,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1209,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1209,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1209,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1209,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1209,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1209,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1209,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1209,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1209,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Hamfist Gukhbuk
INSERT INTO `mob_droplist` VALUES (1271,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1271,0,0,1000,1452,@COMMON);                    -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1271,0,0,1000,1452,@COMMON);                    -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1271,0,0,1000,1452,@COMMON);                    -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1271,0,0,1000,1452,@COMMON);                    -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1271,0,0,1000,1452,@COMMON);                    -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1271,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1271,1,2,@RARE,11388,143);                      -- P Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1271,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1271,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1271,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1271,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1271,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1271,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1271,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)

-- ZoneID:  40 - Koo Rahi The Levinblade
INSERT INTO `mob_droplist` VALUES (1461,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1461,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1461,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1461,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1461,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1461,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1461,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1461,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1461,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1461,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1461,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1461,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1461,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1461,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1461,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID:  40 - Lyncean Juwgneg
INSERT INTO `mob_droplist` VALUES (1556,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1556,0,0,1000,1452,@COMMON);                    -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1556,0,0,1000,1452,@COMMON);                    -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1556,0,0,1000,1452,@COMMON);                    -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1556,0,0,1000,1452,@COMMON);                    -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1556,0,0,1000,1452,@COMMON);                    -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1556,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1556,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1556,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1556,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1556,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1556,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1556,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1556,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1556,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)

-- ZoneID:  40 - Ree Nata The Melomanic
INSERT INTO `mob_droplist` VALUES (2085,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2085,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2085,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2085,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2085,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2085,0,0,1000,1449,@COMMON);                    -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2085,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2085,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2085,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2085,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2085,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2085,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2085,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2085,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2085,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)

-- ZoneID:  40 - Shamblix Rottenheart
INSERT INTO `mob_droplist` VALUES (2229,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,2,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,2,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,2,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,3,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,3,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,3,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,4,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,4,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,4,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,5,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,5,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,1,5,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2229,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2229,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2229,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2229,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2229,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2229,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2229,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2229,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2229,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2229,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2229,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Woodnix Shrillwhistle
INSERT INTO `mob_droplist` VALUES (2667,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,2,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,2,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,2,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,3,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,3,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,3,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,4,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,4,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,4,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,5,@COMMON,1449,333);                     -- Tukuku Whiteshell (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,5,@COMMON,1452,333);                     -- Ordelle Bronzepiece (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,1,5,@COMMON,1455,334);                     -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2667,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2667,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2667,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2667,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2667,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2667,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2667,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2667,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2667,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2667,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2667,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Gibhe Fleshfeaster
INSERT INTO `mob_droplist` VALUES (2901,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2901,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2901,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2901,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2901,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2901,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2901,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2901,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2901,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2901,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2901,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2901,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2901,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2901,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2901,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Qupho Bloodspiller
INSERT INTO `mob_droplist` VALUES (2902,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2902,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2902,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2902,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2902,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2902,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2902,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2902,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2902,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2902,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2902,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2902,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2902,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2902,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2902,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Tezha Ironclad
INSERT INTO `mob_droplist` VALUES (2903,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2903,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2903,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2903,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2903,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2903,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2903,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2903,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2903,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2903,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2903,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2903,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2903,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2903,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2903,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Varhu Bodysnatcher
INSERT INTO `mob_droplist` VALUES (2904,0,0,1000,5902,@COMMON);                    -- Vial Of Cagebeast Blood (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2904,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2904,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2904,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2904,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2904,0,0,1000,1455,@COMMON);                    -- One Byne Bill (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2904,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15074,66);                   -- Clerics Cap (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15081,66);                   -- Bards Roundlet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15092,66);                   -- Assassins Vest (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15095,66);                   -- Monster Jackcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15102,66);                   -- Warriors Mufflers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15105,67);                   -- Sorcerers Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15106,67);                   -- Duelists Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15108,67);                   -- Valor Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15109,67);                   -- Abyss Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15116,67);                   -- Summoners Bracers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15118,67);                   -- Melee Hose (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15127,67);                   -- Scouts Braccae (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15128,67);                   -- Saotome Haidate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15144,67);                   -- Koga Kyahan (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,1,@UNCOMMON,15145,67);                   -- Wyrm Greaves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2904,1,2,@RARE,11388,143);                      -- Pantin Babouches (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2904,1,2,@RARE,15028,143);                      -- Commodore Gants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2904,1,2,@RARE,16346,143);                      -- Mirage Shalwar (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2904,1,2,@RARE,11478,143);                      -- Etoile Tiara (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2904,1,2,@RARE,11398,143);                      -- Argute Loafers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2904,1,2,@RARE,26666,143);                      -- Futhark Bandeau (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2904,1,2,@RARE,27368,142);                      -- Bagua Sandals (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2904,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Aitvaras
INSERT INTO `mob_droplist` VALUES (41,0,0,1000,5901,@ALWAYS);                      -- Shadescale Heart (Always, 100%)
INSERT INTO `mob_droplist` VALUES (41,1,1,@VCOMMON,1449,333);                      -- Tukuku Whiteshell (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (41,1,1,@VCOMMON,1452,333);                      -- Ordelle Bronzepiece (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (41,1,1,@VCOMMON,1455,334);                      -- One Byne Bill (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (41,0,0,1000,3497,@UNCOMMON);                    -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (41,1,2,@RARE,1450,333);                         -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (41,1,2,@RARE,1453,333);                         -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (41,1,2,@RARE,1456,334);                         -- One Hundred Byne Bill (Rare, 5%)

-- ZoneID:  40 - Alklha
INSERT INTO `mob_droplist` VALUES (48,0,0,1000,5900,@ALWAYS);                      -- Shadescale Talon (Always, 100%)
INSERT INTO `mob_droplist` VALUES (48,1,1,@VCOMMON,1449,333);                      -- Tukuku Whiteshell (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (48,1,1,@VCOMMON,1452,333);                      -- Ordelle Bronzepiece (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (48,1,1,@VCOMMON,1455,334);                      -- One Byne Bill (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (48,0,0,1000,3497,@UNCOMMON);                    -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (48,1,2,@RARE,1450,333);                         -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (48,1,2,@RARE,1453,333);                         -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (48,1,2,@RARE,1456,334);                         -- One Hundred Byne Bill (Rare, 5%)

-- ZoneID:  40 - Barong
INSERT INTO `mob_droplist` VALUES (230,0,0,1000,5899,@ALWAYS);                     -- Shadescale Femur (Always, 100%)
INSERT INTO `mob_droplist` VALUES (230,1,1,@VCOMMON,1449,333);                     -- Tukuku Whiteshell (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (230,1,1,@VCOMMON,1452,333);                     -- Ordelle Bronzepiece (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (230,1,1,@VCOMMON,1455,334);                     -- One Byne Bill (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (230,0,0,1000,3497,@UNCOMMON);                   -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (230,1,2,@RARE,1450,333);                        -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (230,1,2,@RARE,1453,333);                        -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (230,1,2,@RARE,1456,334);                        -- One Hundred Byne Bill (Rare, 5%)

-- ZoneID:  40 - Stihi
INSERT INTO `mob_droplist` VALUES (2335,0,0,1000,5898,@ALWAYS);                    -- Shadescale Skull (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2335,1,1,@VCOMMON,1449,333);                    -- Tukuku Whiteshell (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2335,1,1,@VCOMMON,1452,333);                    -- Ordelle Bronzepiece (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2335,1,1,@VCOMMON,1455,334);                    -- One Byne Bill (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2335,0,0,1000,3497,@UNCOMMON);                  -- Forgotten Step (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2335,1,2,@RARE,1450,333);                       -- Lungo-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2335,1,2,@RARE,1453,333);                       -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2335,1,2,@RARE,1456,334);                       -- One Hundred Byne Bill (Rare, 5%)

-- ZoneID:  40 - Apocalyptic Beast
INSERT INTO `mob_droplist` VALUES (146,0,0,1000,3474,@ALWAYS);                     -- Fiendish Tome Ii Chapter 5 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (146,0,0,1000,@FORGOTTEN_POUCH_FEET,@ALWAYS);    -- Forgotten pouch step (Always, 100%)
INSERT INTO `mob_droplist` VALUES (146,1,1,1000,@FORGOTTEN_POUCH_FEET,970);        -- Forgotten pouch step (97%)
INSERT INTO `mob_droplist` VALUES (146,1,1,1000,1450,10);                          -- Lungo-Nango-Nango Jadeshell (3%)
INSERT INTO `mob_droplist` VALUES (146,1,1,1000,1453,10);                          -- Montiont Silverpiece (3%)
INSERT INTO `mob_droplist` VALUES (146,1,1,1000,1456,10);                          -- One Hundred Byne Bill (3%)
INSERT INTO `mob_droplist` VALUES (146,0,0,1000,11629,50);                         -- Apocalyptic Beast - zilant_ring
INSERT INTO `mob_droplist` VALUES (146,0,0,1000,2472,100);                         -- Apocalyptic Beast - netherspirit_chain
INSERT INTO `mob_droplist` VALUES (146,0,0,1000,15955,100);                        -- Apocalyptic Beast - fatality_belt
INSERT INTO `mob_droplist` VALUES (146,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (146,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (146,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  40 - Lost Stihi
INSERT INTO `mob_droplist` VALUES (2796,0,0,1000,3475,@ALWAYS);                    -- Fiendish Tome Ii Chapter 6 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2796,1,1,1000,10941,130);                       -- Tjukurrpa Medal (13%)
INSERT INTO `mob_droplist` VALUES (2796,1,1,1000,@FORGOTTEN_POUCH_FEET,870);       -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (2796,0,0,1000,@FORGOTTEN_POUCH_FEET,@ALWAYS);   -- Forgotten pouch step (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2796,1,2,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (2796,1,2,1000,1450,16);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2796,1,2,1000,1453,17);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (2796,1,2,1000,1456,17);                         -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2796,1,3,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (2796,1,3,1000,1450,17);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2796,1,3,1000,1453,16);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (2796,1,3,1000,1456,17);                         -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2796,1,4,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (2796,1,4,1000,1450,17);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2796,1,4,1000,1453,17);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (2796,1,4,1000,1456,16);                         -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (2796,1,5,1000,@FORGOTTEN_POUCH_FEET,950);    -- Forgotten pouch step (95%)
-- INSERT INTO `mob_droplist` VALUES (2796,1,5,1000,1450,16);                      -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (2796,1,5,1000,1453,17);                      -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (2796,1,5,1000,1456,17);                      -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2796,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2796,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2796,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Lost Barong
INSERT INTO `mob_droplist` VALUES (2795,0,0,1000,3476,@ALWAYS);                    -- Fiendish Tome Ii Chapter 7 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2795,1,1,1000,10984,130);                       -- Tjukurrpa Mantle (13%)
INSERT INTO `mob_droplist` VALUES (2795,1,1,1000,@FORGOTTEN_POUCH_FEET,870);       -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (2795,0,0,1000,@FORGOTTEN_POUCH_FEET,@ALWAYS);   -- Forgotten pouch step (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2795,1,2,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (2795,1,2,1000,1450,16);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2795,1,2,1000,1453,17);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (2795,1,2,1000,1456,17);                         -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2795,1,3,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (2795,1,3,1000,1450,17);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2795,1,3,1000,1453,16);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (2795,1,3,1000,1456,17);                         -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2795,1,4,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (2795,1,4,1000,1450,17);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2795,1,4,1000,1453,17);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (2795,1,4,1000,1456,16);                         -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (2795,1,5,1000,@FORGOTTEN_POUCH_FEET,950);    -- Forgotten pouch step (95%)
-- INSERT INTO `mob_droplist` VALUES (2795,1,5,1000,1450,16);                      -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (2795,1,5,1000,1453,17);                      -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (2795,1,5,1000,1456,17);                      -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2795,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2795,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2795,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Lost Alklha
INSERT INTO `mob_droplist` VALUES (1802,0,0,1000,3478,@ALWAYS);                    -- Fiendish Tome Ii Chapter 9 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1802,1,1,1000,18541,130);                       -- Tjukurrpa Axe (13%)
INSERT INTO `mob_droplist` VALUES (1802,1,1,1000,@FORGOTTEN_POUCH_FEET,870);       -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (1802,0,0,1000,@FORGOTTEN_POUCH_FEET,@ALWAYS);   -- Forgotten pouch step (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1802,1,2,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (1802,1,2,1000,1450,16);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (1802,1,2,1000,1453,17);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (1802,1,2,1000,1456,17);                         -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (1802,1,3,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (1802,1,3,1000,1450,17);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (1802,1,3,1000,1453,16);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (1802,1,3,1000,1456,17);                         -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (1802,1,4,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (1802,1,4,1000,1450,17);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (1802,1,4,1000,1453,17);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (1802,1,4,1000,1456,16);                         -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (1802,1,5,1000,@FORGOTTEN_POUCH_FEET,950);    -- Forgotten pouch step (95%)
-- INSERT INTO `mob_droplist` VALUES (1802,1,5,1000,1450,16);                      -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (1802,1,5,1000,1453,17);                      -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (1802,1,5,1000,1456,17);                      -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (1802,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1802,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1802,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Lost Alklha
INSERT INTO `mob_droplist` VALUES (1805,0,0,1000,3477,@ALWAYS);                    -- Fiendish Tome Ii Chapter 8 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1805,1,1,1000,11923,130);                       -- Tjukurrpa Gauntlets (13%)
INSERT INTO `mob_droplist` VALUES (1805,1,1,1000,@FORGOTTEN_POUCH_FEET,870);       -- Forgotten pouch step (87%)
INSERT INTO `mob_droplist` VALUES (1805,0,0,1000,@FORGOTTEN_POUCH_FEET,@ALWAYS);   -- Forgotten pouch step (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1805,1,2,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (1805,1,2,1000,1450,16);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (1805,1,2,1000,1453,17);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (1805,1,2,1000,1456,17);                         -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (1805,1,3,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (1805,1,3,1000,1450,17);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (1805,1,3,1000,1453,16);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (1805,1,3,1000,1456,17);                         -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (1805,1,4,1000,@FORGOTTEN_POUCH_FEET,950);       -- Forgotten pouch step (95%)
INSERT INTO `mob_droplist` VALUES (1805,1,4,1000,1450,17);                         -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (1805,1,4,1000,1453,17);                         -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (1805,1,4,1000,1456,16);                         -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (1805,1,5,1000,@FORGOTTEN_POUCH_FEET,950);    -- Forgotten pouch step (95%)
-- INSERT INTO `mob_droplist` VALUES (1805,1,5,1000,1450,16);                      -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (1805,1,5,1000,1453,17);                      -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (1805,1,5,1000,1456,17);                      -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (1805,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1805,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1805,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- ZoneID:  40 - Arch Apocalyptic Beast
INSERT INTO `mob_droplist` VALUES (2797,0,0,1000,10818,200);                       -- Tjukurrpa Belt (40.0%)
INSERT INTO `mob_droplist` VALUES (2797,0,0,1000,10756,200);                       -- Tjukurrpa Ring (30.0%)
INSERT INTO `mob_droplist` VALUES (2797,0,0,1000,10757,200);                       -- Tjukurrpa Annulet (20%)
INSERT INTO `mob_droplist` VALUES (2797,0,0,1000,@FORGOTTEN_POUCH_FEET,@ALWAYS);   -- Forgotten pouch step (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2797,1,1,1000,@FORGOTTEN_POUCH_FEET,925);       -- Forgotten pouch step (92.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,1,1000,1450,25);                         -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,1,1000,1453,25);                         -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,1,1000,1456,25);                         -- One Hundred Byne Bill (7.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,2,1000,@FORGOTTEN_POUCH_FEET,925);       -- Forgotten pouch step (92.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,2,1000,1450,25);                         -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,2,1000,1453,25);                         -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,2,1000,1456,25);                         -- One Hundred Byne Bill (7.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,3,1000,@FORGOTTEN_POUCH_FEET,925);       -- Forgotten pouch step (92.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,3,1000,1450,25);                         -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,3,1000,1453,25);                         -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (2797,1,3,1000,1456,25);                         -- One Hundred Byne Bill (7.5%)
-- INSERT INTO `mob_droplist` VALUES (2797,1,4,1000,@FORGOTTEN_POUCH_FEET,925);    -- Forgotten pouch step (92.5%)
-- INSERT INTO `mob_droplist` VALUES (2797,1,4,1000,1450,25);                      -- Lungo-Nango-Nango Jadeshell (7.5%)
-- INSERT INTO `mob_droplist` VALUES (2797,1,4,1000,1453,25);                      -- Montiont Silverpiece (7.5%)
-- INSERT INTO `mob_droplist` VALUES (2797,1,4,1000,1456,25);                      -- One Hundred Byne Bill (7.5%)
INSERT INTO `mob_droplist` VALUES (2797,2,0,1000,1449,0);                          -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2797,2,0,1000,1452,0);                          -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2797,2,0,1000,1455,0);                          -- One Byne Bill (Steal)

-- --------------------------------------------------------------------
--                          Dynamis-Qufim                            --
-- --------------------------------------------------------------------

-- Ensure we're clearing out the old drop lists
DELETE FROM `mob_droplist` WHERE dropid = "1790"; -- Delete Tiger, Diremite, Raptor T1
DELETE FROM `mob_droplist` WHERE dropid = "1793"; -- Delete Kraken, Gaylas, Roc T1
DELETE FROM `mob_droplist` WHERE dropid = "1803"; -- Delete Weapon, Stirge, Snoll T1
DELETE FROM `mob_droplist` WHERE dropid = "1800"; -- Delete Tiger, Diremite, Raptor T2
DELETE FROM `mob_droplist` WHERE dropid = "2798"; -- Delete Kraken, Gaylas, Roc T2
DELETE FROM `mob_droplist` WHERE dropid = "1804"; -- Delete Weapon, Stirge, Snoll T2
DELETE FROM `mob_droplist` WHERE dropid = "2541"; -- Delete Vanguard Goblin
DELETE FROM `mob_droplist` WHERE dropid = "2546"; -- Delete Vanguard Orc
DELETE FROM `mob_droplist` WHERE dropid = "2551"; -- Delete Vanguard Yagudo
DELETE FROM `mob_droplist` WHERE dropid = "2556"; -- Delete Vanguard Quadavs
DELETE FROM `mob_droplist` WHERE dropid = "3131"; -- Delete Scolopendra
DELETE FROM `mob_droplist` WHERE dropid = "3132"; -- Delete Stringes
DELETE FROM `mob_droplist` WHERE dropid = "3133"; -- Delete Suttung
DELETE FROM `mob_droplist` WHERE dropid =  "112"; -- Delete Antaeus
DELETE FROM `mob_droplist` WHERE dropid = "3135"; -- Delete Lost Stringes
DELETE FROM `mob_droplist` WHERE dropid = "3134"; -- Delete Lost Scolopendra
DELETE FROM `mob_droplist` WHERE dropid = "3136"; -- Delete Lost Suttung
DELETE FROM `mob_droplist` WHERE dropid = "3130"; -- Delete Arch Antaeus

-- Assign drop lists to bosses
UPDATE `mob_groups` SET `dropid` = 112  WHERE name = 'Antaeus' AND zoneid = 41;
UPDATE `mob_groups` SET `dropid` = 3135 WHERE name = 'Lost_Stringes' AND zoneid = 41;
UPDATE `mob_groups` SET `dropid` = 3134 WHERE name = 'Lost_Scolopendra' AND zoneid = 41;
UPDATE `mob_groups` SET `dropid` = 3136 WHERE name = 'Lost_Suttung' AND zoneid = 41;
UPDATE `mob_groups` SET `dropid` = 3130 WHERE name = 'Arch_Antaeus' AND zoneid = 41;

-- ZoneID:  41 - Vanguard Smithy
-- ZoneID:  41 - Vanguard Enchanter
-- ZoneID:  41 - Vanguard Ambusher
-- ZoneID:  41 - Vanguard Hitman
-- ZoneID:  41 - Vanguard Dragontamer
-- ZoneID:  41 - Vanguard Pitfighter
-- ZoneID:  41 - Vanguard Shaman
-- ZoneID:  41 - Vanguard Tinkerer
-- ZoneID:  41 - Vanguard Maestro
-- ZoneID:  41 - Vanguard Necromancer
-- ZoneID:  41 - Vanguard Alchemist
-- ZoneID:  41 - Vanguard Welldigger
-- ZoneID:  41 - Vanguard Armorer
-- ZoneID:  41 - Vanguard Pathfinder
-- ZoneID:  41 - Vanguard Ronin
-- ZoneID:  41 - Vanguard Alchemist
-- ZoneID:  41 - Vanguard Armorer
-- ZoneID:  41 - Vanguard Pathfinder
-- ZoneID:  41 - Vanguard Ronin
-- ZoneID:  41 - Vanguard Smithy
-- ZoneID:  41 - Vanguard Welldigger
-- ZoneID:  41 - Vanguard Tinkerer
-- ZoneID:  41 - Vanguard Enchanter
-- ZoneID:  41 - Vanguard Ambusher
-- ZoneID:  41 - Vanguard Hitman
-- ZoneID:  41 - Vanguard Dragontamer
-- ZoneID:  41 - Vanguard Pitfighter
-- ZoneID:  41 - Vanguard Shaman
-- ZoneID:  41 - Vanguard Maestro
-- ZoneID:  41 - Vanguard Necromancer
INSERT INTO `mob_droplist` VALUES (2541,0,0,1000,3496,@UNCOMMON);              -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15072,66);               -- Warriors Mask (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15078,66);               -- Valor Coronet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15082,66);               -- Scouts Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15084,66);               -- Koga Hatsuburi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15103,66);               -- Melee Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15111,67);               -- Bards Cuffs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15113,67);               -- Saotome Kote (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15115,67);               -- Wyrm Finger Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15119,67);               -- Clerics Pantaloons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15120,67);               -- Sorcerers Tonban (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15121,67);               -- Duelists Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15124,67);               -- Abyss Flanchard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15125,67);               -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15137,67);               -- Assassins Poulaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,1,@UNCOMMON,15146,67);               -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2541,1,2,@RARE,15025,167);                  -- Mirage Bazubands (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2541,1,2,@RARE,11385,167);                  -- Commodore Bottes (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2541,1,2,@RARE,15031,167);                  -- Pantin Dastanas (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2541,1,2,@RARE,11396,167);                  -- Etoile Toe Shoes (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2541,1,2,@RARE,27370,167);                  -- Futhark Boots (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2541,1,2,@RARE,16362,166);                  -- Argute Pants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2541,1,2,@RARE,27192,166);                  -- Bagua Pants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2541,2,0,1000,1449,0);                      -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2541,2,0,1000,1452,0);                      -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2541,2,0,1000,1455,0);                      -- One Byne Bill (Steal)

-- ZoneID:  41 - Vanguard Footsoldier
-- ZoneID:  41 - Vanguard Amputator
-- ZoneID:  41 - Vanguard Vexer
-- ZoneID:  41 - Vanguard Predator
-- ZoneID:  41 - Vanguard Impaler
-- ZoneID:  41 - Vanguard Grappler
-- ZoneID:  41 - Vanguard Pillager
-- ZoneID:  41 - Vanguard Trooper
-- ZoneID:  41 - Vanguard Bugler
-- ZoneID:  41 - Vanguard Dollmaster
-- ZoneID:  41 - Vanguard Mesmerizer
-- ZoneID:  41 - Vanguard Neckchopper
-- ZoneID:  41 - Vanguard Hawker
-- ZoneID:  41 - Vanguard Gutslasher
-- ZoneID:  41 - Vanguard Backstabber
-- ZoneID:  41 - Vanguard Amputator
-- ZoneID:  41 - Vanguard Vexer
-- ZoneID:  41 - Vanguard Neckchopper
-- ZoneID:  41 - Vanguard Predator
-- ZoneID:  41 - Vanguard Impaler
-- ZoneID:  41 - Vanguard Footsoldier
-- ZoneID:  41 - Vanguard Pillager
-- ZoneID:  41 - Vanguard Trooper
-- ZoneID:  41 - Vanguard Bugler
-- ZoneID:  41 - Vanguard Gutslasher
-- ZoneID:  41 - Vanguard Dollmaster
-- ZoneID:  41 - Vanguard Grappler
-- ZoneID:  41 - Vanguard Mesmerizer
-- ZoneID:  41 - Vanguard Hawker
-- ZoneID:  41 - Vanguard Backstabber
INSERT INTO `mob_droplist` VALUES (2546,0,0,1000,3496,@UNCOMMON);              -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15072,66);               -- Warriors Mask (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15078,66);               -- Valor Coronet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15082,66);               -- Scouts Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15084,66);               -- Koga Hatsuburi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15103,66);               -- Melee Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15111,67);               -- Bards Cuffs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15113,67);               -- Saotome Kote (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15115,67);               -- Wyrm Finger Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15119,67);               -- Clerics Pantaloons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15120,67);               -- Sorcerers Tonban (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15121,67);               -- Duelists Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15124,67);               -- Abyss Flanchard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15125,67);               -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15137,67);               -- Assassins Poulaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,1,@UNCOMMON,15146,67);               -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2546,1,2,@RARE,15025,167);                  -- Mirage Bazubands (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2546,1,2,@RARE,11385,167);                  -- Commodore Bottes (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2546,1,2,@RARE,15031,167);                  -- Pantin Dastanas (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2546,1,2,@RARE,11396,167);                  -- Etoile Toe Shoes (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2546,1,2,@RARE,27370,167);                  -- Futhark Boots (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2546,1,2,@RARE,16362,166);                  -- Argute Pants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2546,1,2,@RARE,27192,166);                  -- Bagua Pants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2546,2,0,1000,1452,0);                      -- Ordelle Bronzepiece (Steal)

-- ZoneID:  41 - Vanguard Skirmisher
-- ZoneID:  41 - Vanguard Sentinel
-- ZoneID:  41 - Vanguard Exemplar
-- ZoneID:  41 - Vanguard Inciter
-- ZoneID:  41 - Vanguard Ogresoother
-- ZoneID:  41 - Vanguard Priest
-- ZoneID:  41 - Vanguard Prelate
-- ZoneID:  41 - Vanguard Chanter
-- ZoneID:  41 - Vanguard Partisan
-- ZoneID:  41 - Vanguard Assassin
-- ZoneID:  41 - Vanguard Visionary
-- ZoneID:  41 - Vanguard Liberator
-- ZoneID:  41 - Vanguard Salvager
-- ZoneID:  41 - Vanguard Persecutor
-- ZoneID:  41 - Vanguard Oracle
-- ZoneID:  41 - Vanguard Skirmisher
-- ZoneID:  41 - Vanguard Sentinel
-- ZoneID:  41 - Vanguard Exemplar
-- ZoneID:  41 - Vanguard Inciter
-- ZoneID:  41 - Vanguard Ogresoother
-- ZoneID:  41 - Vanguard Priest
-- ZoneID:  41 - Vanguard Prelate
-- ZoneID:  41 - Vanguard Chanter
-- ZoneID:  41 - Vanguard Partisan
-- ZoneID:  41 - Vanguard Assassin
-- ZoneID:  41 - Vanguard Visionary
-- ZoneID:  41 - Vanguard Liberator
-- ZoneID:  41 - Vanguard Salvager
-- ZoneID:  41 - Vanguard Persecutor
-- ZoneID:  41 - Vanguard Oracle
INSERT INTO `mob_droplist` VALUES (2551,0,0,1000,3496,@UNCOMMON);              -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15072,66);               -- Warriors Mask (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15078,66);               -- Valor Coronet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15082,66);               -- Scouts Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15084,66);               -- Koga Hatsuburi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15103,66);               -- Melee Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15111,67);               -- Bards Cuffs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15113,67);               -- Saotome Kote (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15115,67);               -- Wyrm Finger Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15119,67);               -- Clerics Pantaloons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15120,67);               -- Sorcerers Tonban (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15121,67);               -- Duelists Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15124,67);               -- Abyss Flanchard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15125,67);               -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15137,67);               -- Assassins Poulaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,1,@UNCOMMON,15146,67);               -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2551,1,2,@RARE,15025,167);                  -- Mirage Bazubands (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2551,1,2,@RARE,11385,167);                  -- Commodore Bottes (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2551,1,2,@RARE,15031,167);                  -- Pantin Dastanas (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2551,1,2,@RARE,11396,167);                  -- Etoile Toe Shoes (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2551,1,2,@RARE,27370,167);                  -- Futhark Boots (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2551,1,2,@RARE,16362,166);                  -- Argute Pants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2551,1,2,@RARE,27192,166);                  -- Bagua Pants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2551,2,0,1000,1449,0);                      -- Tukuku Whiteshell (Steal)

-- ZoneID:  41 - Vanguard Militant
-- ZoneID:  41 - Vanguard Thaumaturge
-- ZoneID:  41 - Vanguard Beasttender
-- ZoneID:  41 - Vanguard Mason
-- ZoneID:  41 - Vanguard Hatamoto
-- ZoneID:  41 - Vanguard Vindicator
-- ZoneID:  41 - Vanguard Protector
-- ZoneID:  41 - Vanguard Defender
-- ZoneID:  41 - Vanguard Kusa
-- ZoneID:  41 - Vanguard Undertaker
-- ZoneID:  41 - Vanguard Constable
-- ZoneID:  41 - Vanguard Purloiner
-- ZoneID:  41 - Vanguard Vigilante
-- ZoneID:  41 - Vanguard Minstrel
-- ZoneID:  41 - Vanguard Drakekeeper
-- ZoneID:  41 - Vanguard Thaumaturge
-- ZoneID:  41 - Vanguard Militant
-- ZoneID:  41 - Vanguard Thaumaturge
-- ZoneID:  41 - Vanguard Beasttender
-- ZoneID:  41 - Vanguard Mason
-- ZoneID:  41 - Vanguard Hatamoto
-- ZoneID:  41 - Vanguard Vindicator
-- ZoneID:  41 - Vanguard Protector
-- ZoneID:  41 - Vanguard Defender
-- ZoneID:  41 - Vanguard Kusa
-- ZoneID:  41 - Vanguard Undertaker
-- ZoneID:  41 - Vanguard Constable
-- ZoneID:  41 - Vanguard Purloiner
-- ZoneID:  41 - Vanguard Vigilante
-- ZoneID:  41 - Vanguard Minstrel
-- ZoneID:  41 - Vanguard Drakekeeper
INSERT INTO `mob_droplist` VALUES (2556,0,0,1000,3496,@UNCOMMON);              -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15072,66);               -- Warriors Mask (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15078,66);               -- Valor Coronet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15082,66);               -- Scouts Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15084,66);               -- Koga Hatsuburi (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15103,66);               -- Melee Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15111,67);               -- Bards Cuffs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15113,67);               -- Saotome Kote (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15115,67);               -- Wyrm Finger Gauntlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15119,67);               -- Clerics Pantaloons (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15120,67);               -- Sorcerers Tonban (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15121,67);               -- Duelists Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15124,67);               -- Abyss Flanchard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15125,67);               -- Monster Trousers (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15137,67);               -- Assassins Poulaines (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,1,@UNCOMMON,15146,67);               -- Summoners Pigaches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2556,1,2,@RARE,15025,167);                  -- Mirage Bazubands (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2556,1,2,@RARE,11385,167);                  -- Commodore Bottes (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2556,1,2,@RARE,15031,167);                  -- Pantin Dastanas (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2556,1,2,@RARE,11396,167);                  -- Etoile Toe Shoes (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2556,1,2,@RARE,27370,167);                  -- Futhark Boots (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2556,1,2,@RARE,16362,166);                  -- Argute Pants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2556,1,2,@RARE,27192,166);                  -- Bagua Pants (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2556,2,0,1000,1455,0);                      -- One Byne Bill (Steal)

-- ZoneID:  41 - Nightmare Tiger Tier 1
-- ZoneID:  41 - Nightmare Diremite Tier 1
-- ZoneID:  41 - Nightmare Raptor Tier 1
INSERT INTO `mob_droplist` VALUES (1790,0,0,1000,3458,@UNCOMMON);                   -- Undying Juju (5%)
INSERT INTO `mob_droplist` VALUES (1790,0,0,1000,3496,@UNCOMMON);                   -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,@UNCOMMON,1000,15484,200);                -- Summoners Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,@UNCOMMON,1000,15879,200);                -- Saotome Koshi-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,@UNCOMMON,1000,15920,200);                -- Commodore Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,@UNCOMMON,1000,15925,200);                -- Argute Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,@UNCOMMON,1000,16245,200);                -- Pantin Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2037,66);                     -- Warriors Calligae -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2042,66);                     -- Melee Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2047,66);                     -- Clerics Duckbills -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2052,66);                     -- Sorcerers Sabots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2057,66);                     -- Duelists Boots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2062,67);                     -- Assassins Poulaines -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2067,67);                     -- Valor Leggings -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2072,67);                     -- Abyss Sollerets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2077,67);                     -- Monster Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2082,67);                     -- Bards Slippers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2087,67);                     -- Scouts Socks -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2092,67);                     -- Saotome Sune-Ate -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2097,67);                     -- Koga Kyahan -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2102,67);                     -- Wyrm Greaves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,2,@UNCOMMON,2107,67);                     -- Summoners Pigaches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,3,@UNCOMMON,2666,200);                    -- Mirage Charuqs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,3,@UNCOMMON,2671,200);                    -- Commodore Bottes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,3,@UNCOMMON,2676,200);                    -- Pantin Babouches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,3,@UNCOMMON,2722,200);                    -- Etoile Toe Shoes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,1,3,@UNCOMMON,2727,200);                    -- Argute Loafers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1790,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)

-- ZoneID:  41 - Nightmare Kraken Tier 1
-- ZoneID:  41 - Nightmare Gaylas Tier 1
-- ZoneID:  41 - Nightmare Roc Tier 1
INSERT INTO `mob_droplist` VALUES (1793,0,0,1000,3458,@UNCOMMON);                   -- Undying Juju (5%)
INSERT INTO `mob_droplist` VALUES (1793,0,0,1000,3496,@UNCOMMON);                   -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,1,@UNCOMMON,15479,200);                   -- Abyss Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,1,@UNCOMMON,15480,200);                   -- Assassins Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,1,@UNCOMMON,15873,200);                   -- Duelists Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,1,@UNCOMMON,15876,200);                   -- Scouts Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,1,@UNCOMMON,26240,200);                   -- Futhark Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2037,66);                     -- Warriors Calligae -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2042,66);                     -- Melee Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2047,66);                     -- Clerics Duckbills -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2052,66);                     -- Sorcerers Sabots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2057,66);                     -- Duelists Boots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2062,67);                     -- Assassins Poulaines -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2067,67);                     -- Valor Leggings -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2072,67);                     -- Abyss Sollerets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2077,67);                     -- Monster Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2082,67);                     -- Bards Slippers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2087,67);                     -- Scouts Socks -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2092,67);                     -- Saotome Sune-Ate -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2097,67);                     -- Koga Kyahan -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2102,67);                     -- Wyrm Greaves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,2,@UNCOMMON,2107,67);                     -- Summoners Pigaches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,3,@UNCOMMON,2666,200);                    -- Mirage Charuqs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,3,@UNCOMMON,2671,200);                    -- Commodore Bottes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,3,@UNCOMMON,2676,200);                    -- Pantin Babouches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,3,@UNCOMMON,2722,200);                    -- Etoile Toe Shoes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,1,3,@UNCOMMON,2727,200);                    -- Argute Loafers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1793,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  41 - Nightmare Weapon Tier 1
-- ZoneID:  41 - Nightmare Stirge Tier 1
-- ZoneID:  41 - Nightmare Snoll Tier 1
INSERT INTO `mob_droplist` VALUES (1803,0,0,1000,3458,@UNCOMMON);                   -- Undying Juju (5%)
INSERT INTO `mob_droplist` VALUES (1803,0,0,1000,3496,@UNCOMMON);                   -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,1,@UNCOMMON,15478,250);                   -- Melee Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,1,@UNCOMMON,15872,250);                   -- Clerics Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,1,@UNCOMMON,15875,250);                   -- Monster Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,1,@UNCOMMON,15878,250);                   -- Wyrm Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2037,66);                     -- Warriors Calligae -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2042,66);                     -- Melee Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2047,66);                     -- Clerics Duckbills -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2052,66);                     -- Sorcerers Sabots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2057,66);                     -- Duelists Boots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2062,67);                     -- Assassins Poulaines -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2067,67);                     -- Valor Leggings -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2072,67);                     -- Abyss Sollerets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2077,67);                     -- Monster Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2082,67);                     -- Bards Slippers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2087,67);                     -- Scouts Socks -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2092,67);                     -- Saotome Sune-Ate -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2097,67);                     -- Koga Kyahan -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2102,67);                     -- Wyrm Greaves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,2,@UNCOMMON,2107,67);                     -- Summoners Pigaches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,3,@UNCOMMON,2666,200);                    -- Mirage Charuqs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,3,@UNCOMMON,2671,200);                    -- Commodore Bottes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,3,@UNCOMMON,2676,200);                    -- Pantin Babouches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,3,@UNCOMMON,2722,200);                    -- Etoile Toe Shoes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,1,3,@UNCOMMON,2727,200);                    -- Argute Loafers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1803,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)

-- ZoneID:  41 - Nightmare Diremite Tier 2
-- ZoneID:  41 - Nightmare Tiger Tier 2
-- ZoneID:  41 - Nightmare Raptor Tier 2
INSERT INTO `mob_droplist` VALUES (1800,0,0,1000,3469,@UNCOMMON);                   -- Nightmare Shard (2.0%)
INSERT INTO `mob_droplist` VALUES (1800,0,0,1000,3496,@UNCOMMON);                   -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,1,@UNCOMMON,15484,200);                   -- Summoners Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,1,@UNCOMMON,15879,200);                   -- Saotome Koshi-Ate (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,1,@UNCOMMON,15920,200);                   -- Commodore Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,1,@UNCOMMON,15925,200);                   -- Argute Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,1,@UNCOMMON,16245,200);                   -- Pantin Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2037,66);                     -- Warriors Calligae -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2042,66);                     -- Melee Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2047,66);                     -- Clerics Duckbills -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2052,66);                     -- Sorcerers Sabots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2057,66);                     -- Duelists Boots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2062,67);                     -- Assassins Poulaines -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2067,67);                     -- Valor Leggings -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2072,67);                     -- Abyss Sollerets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2077,67);                     -- Monster Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2082,67);                     -- Bards Slippers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2087,67);                     -- Scouts Socks -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2092,67);                     -- Saotome Sune-Ate -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2097,67);                     -- Koga Kyahan -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2102,67);                     -- Wyrm Greaves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,2,@UNCOMMON,2107,67);                     -- Summoners Pigaches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,3,@UNCOMMON,2666,200);                    -- Mirage Charuqs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,3,@UNCOMMON,2671,200);                    -- Commodore Bottes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,3,@UNCOMMON,2676,200);                    -- Pantin Babouches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,3,@UNCOMMON,2722,200);                    -- Etoile Toe Shoes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,1,3,@UNCOMMON,2727,200);                    -- Argute Loafers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1800,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)

-- ZoneID:  41 - Nightmare Stirge Tier 2
-- ZoneID:  41 - Nightmare Snoll Tier 2
-- ZoneID:  41 - Nightmare Weapon Tier 2
INSERT INTO `mob_droplist` VALUES (1804,0,0,1000,3467,@UNCOMMON);                   -- Nightmare Shell (5%)
INSERT INTO `mob_droplist` VALUES (1804,0,0,1000,3496,@UNCOMMON);                   -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,1,@UNCOMMON,15478,250);                   -- Melee Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,1,@UNCOMMON,15872,250);                   -- Clerics Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,1,@UNCOMMON,15875,250);                   -- Monster Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,1,@UNCOMMON,15878,250);                   -- Wyrm Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2037,66);                     -- Warriors Calligae -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2042,66);                     -- Melee Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2047,66);                     -- Clerics Duckbills -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2052,66);                     -- Sorcerers Sabots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2057,66);                     -- Duelists Boots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2062,67);                     -- Assassins Poulaines -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2067,67);                     -- Valor Leggings -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2072,67);                     -- Abyss Sollerets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2077,67);                     -- Monster Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2082,67);                     -- Bards Slippers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2087,67);                     -- Scouts Socks -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2092,67);                     -- Saotome Sune-Ate -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2097,67);                     -- Koga Kyahan -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2102,67);                     -- Wyrm Greaves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,2,@UNCOMMON,2107,67);                     -- Summoners Pigaches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,3,@UNCOMMON,2666,200);                    -- Mirage Charuqs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,3,@UNCOMMON,2671,200);                    -- Commodore Bottes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,3,@UNCOMMON,2676,200);                    -- Pantin Babouches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,3,@UNCOMMON,2722,200);                    -- Etoile Toe Shoes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,1,3,@UNCOMMON,2727,200);                    -- Argute Loafers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1804,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)

-- ZoneID:  41 - Nightmare Roc Tier 2
-- ZoneID:  41 - Nightmare Gaylas Tier 2
-- ZoneID:  41 - Nightmare Kraken Tier 2
INSERT INTO `mob_droplist` VALUES (2798,0,0,1000,3468,@UNCOMMON);                   -- Vial Of Nightmare Blood (5%)
INSERT INTO `mob_droplist` VALUES (2798,0,0,1000,3496,@UNCOMMON);                   -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,1,@UNCOMMON,15479,200);                   -- Abyss Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,1,@UNCOMMON,15480,200);                   -- Assassins Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,1,@UNCOMMON,15873,200);                   -- Duelists Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,1,@UNCOMMON,15876,200);                   -- Scouts Belt (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,1,@UNCOMMON,26240,200);                   -- Futhark Cape (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2037,66);                     -- Warriors Calligae -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2042,66);                     -- Melee Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2047,66);                     -- Clerics Duckbills -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2052,66);                     -- Sorcerers Sabots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2057,66);                     -- Duelists Boots -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2062,67);                     -- Assassins Poulaines -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2067,67);                     -- Valor Leggings -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2072,67);                     -- Abyss Sollerets -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2077,67);                     -- Monster Gaiters -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2082,67);                     -- Bards Slippers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2087,67);                     -- Scouts Socks -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2092,67);                     -- Saotome Sune-Ate -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2097,67);                     -- Koga Kyahan -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2102,67);                     -- Wyrm Greaves -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,2,@UNCOMMON,2107,67);                     -- Summoners Pigaches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,3,@UNCOMMON,2666,200);                    -- Mirage Charuqs -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,3,@UNCOMMON,2671,200);                    -- Commodore Bottes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,3,@UNCOMMON,2676,200);                    -- Pantin Babouches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,3,@UNCOMMON,2722,200);                    -- Etoile Toe Shoes -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,1,3,@UNCOMMON,2727,200);                    -- Argute Loafers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2798,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  41 - Scolopendra
INSERT INTO `mob_droplist` VALUES (3131,0,0,1000,5903,@ALWAYS);                     -- Vial Of Sea Monk Venom (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3131,0,0,1000,3496,@UNCOMMON);                   -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3131,1,1,@VCOMMON,1449,333);                     -- Tukuku Whiteshell (25.0%)
INSERT INTO `mob_droplist` VALUES (3131,1,1,@VCOMMON,1452,333);                     -- Ordelle Bronzepiece (25.0%)
INSERT INTO `mob_droplist` VALUES (3131,1,1,@VCOMMON,1455,334);                     -- One Byne Bill (25.0%)
INSERT INTO `mob_droplist` VALUES (3131,1,2,@RARE,1450,333);                        -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3131,1,2,@RARE,1453,333);                        -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3131,1,2,@RARE,1456,334);                        -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3131,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3131,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3131,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  41 - Stringes
INSERT INTO `mob_droplist` VALUES (3132,0,0,1000,5904,@ALWAYS);                     -- Perforated Wing (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3132,0,0,1000,3496,@UNCOMMON);                   -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3132,1,1,@VCOMMON,1449,333);                     -- Tukuku Whiteshell (25.0%)
INSERT INTO `mob_droplist` VALUES (3132,1,1,@VCOMMON,1452,333);                     -- Ordelle Bronzepiece (25.0%)
INSERT INTO `mob_droplist` VALUES (3132,1,1,@VCOMMON,1455,334);                     -- One Byne Bill (25.0%)
INSERT INTO `mob_droplist` VALUES (3132,1,2,@RARE,1450,333);                        -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3132,1,2,@RARE,1453,333);                        -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3132,1,2,@RARE,1456,334);                        -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3132,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3132,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3132,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  41 - Suttung
INSERT INTO `mob_droplist` VALUES (3133,0,0,1000,5905,@ALWAYS);                     -- Undying Moiety (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3133,0,0,1000,3496,@UNCOMMON);                   -- Forgotten Journey (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3133,1,1,@VCOMMON,1449,333);                     -- Tukuku Whiteshell (25.0%)
INSERT INTO `mob_droplist` VALUES (3133,1,1,@VCOMMON,1452,333);                     -- Ordelle Bronzepiece (25.0%)
INSERT INTO `mob_droplist` VALUES (3133,1,1,@VCOMMON,1455,334);                     -- One Byne Bill (25.0%)
INSERT INTO `mob_droplist` VALUES (3133,1,2,@RARE,1450,333);                        -- Lungo-Nango-Nango Jadeshell (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3133,1,2,@RARE,1453,333);                        -- Montiont Silverpiece (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3133,1,2,@RARE,1456,334);                        -- One Hundred Byne Bill (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3133,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3133,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3133,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  41 - Antaeus
INSERT INTO `mob_droplist` VALUES (112,0,0,1000,3479,@ALWAYS);                      -- Fiendish Tome Ii Chapter 10 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (112,0,0,1000,@FORGOTTEN_POUCH_LEGS,@ALWAYS);     -- Forgotten pouch journey (Always, 100%)
INSERT INTO `mob_droplist` VALUES (112,1,2,1000,@FORGOTTEN_POUCH_LEGS,950);         -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (112,1,1,1000,1450,10);                           -- Lungo-Nango-Nango Jadeshell (3%)
INSERT INTO `mob_droplist` VALUES (112,1,1,1000,1453,10);                           -- Montiont Silverpiece (3%)
INSERT INTO `mob_droplist` VALUES (112,1,1,1000,1456,10);                           -- One Hundred Byne Bill (3%)
INSERT INTO `mob_droplist` VALUES (112,0,0,1000,15859,50);                          -- Antaeus - succor_ring
INSERT INTO `mob_droplist` VALUES (112,0,0,1000,2474,100);                          -- Antaeus - netherpact_chain
INSERT INTO `mob_droplist` VALUES (112,0,0,1000,11635,100);                         -- Antaeus - alert_ring
INSERT INTO `mob_droplist` VALUES (112,2,0,1000,1449,0);                            -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (112,2,0,1000,1452,0);                            -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (112,2,0,1000,1455,0);                            -- One Byne Bill (Steal)

-- ZoneID:  41 - Lost Stringes
INSERT INTO `mob_droplist` VALUES (3135,0,0,1000,3480,@ALWAYS);                      -- Fiendish Tome Ii Chapter 11 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3135,1,1,1000,10942,130);                         -- Aifes Medal (30.0%)
INSERT INTO `mob_droplist` VALUES (3135,1,1,1000,@FORGOTTEN_POUCH_LEGS,870);         -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3135,0,0,1000,@FORGOTTEN_POUCH_LEGS,@ALWAYS);     -- Forgotten pouch journey (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3135,1,2,1000,@FORGOTTEN_POUCH_LEGS,950);         -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3135,1,2,1000,1450,16);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3135,1,2,1000,1453,17);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3135,1,2,1000,1456,17);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3135,1,3,1000,@FORGOTTEN_POUCH_LEGS,950);         -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3135,1,3,1000,1450,17);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3135,1,3,1000,1453,16);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3135,1,3,1000,1456,17);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3135,1,4,1000,@FORGOTTEN_POUCH_LEGS,950);         -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3135,1,4,1000,1450,17);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3135,1,4,1000,1453,17);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3135,1,4,1000,1456,16);                           -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (3135,1,5,1000,@FORGOTTEN_POUCH_LEGS,950);      -- Forgotten pouch journey (95%)
-- INSERT INTO `mob_droplist` VALUES (3135,1,5,1000,1450,16);                        -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (3135,1,5,1000,1453,17);                        -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (3135,1,5,1000,1456,17);                        -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3135,2,0,1000,1449,0);                            -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3135,2,0,1000,1452,0);                            -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3135,2,0,1000,1455,0);                            -- One Byne Bill (Steal)

-- ZoneID:  41 - Lost Scolopendra
INSERT INTO `mob_droplist` VALUES (3134,0,0,1000,3481,@ALWAYS);                      -- Fiendish Tome Ii Chapter 12 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3134,1,1,1000,10983,130);                         -- Aifes Mantle (30.0%)
INSERT INTO `mob_droplist` VALUES (3134,1,1,1000,@FORGOTTEN_POUCH_LEGS,870);         -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3134,0,0,1000,@FORGOTTEN_POUCH_LEGS,@ALWAYS);     -- Forgotten pouch journey (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3134,1,2,1000,@FORGOTTEN_POUCH_LEGS,950);         -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3134,1,2,1000,1450,16);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3134,1,2,1000,1453,17);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3134,1,2,1000,1456,17);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3134,1,3,1000,@FORGOTTEN_POUCH_LEGS,950);         -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3134,1,3,1000,1450,17);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3134,1,3,1000,1453,16);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3134,1,3,1000,1456,17);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3134,1,4,1000,@FORGOTTEN_POUCH_LEGS,950);         -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3134,1,4,1000,1450,17);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3134,1,4,1000,1453,17);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3134,1,4,1000,1456,16);                           -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (3134,1,5,1000,@FORGOTTEN_POUCH_LEGS,950);      -- Forgotten pouch journey (95%)
-- INSERT INTO `mob_droplist` VALUES (3134,1,5,1000,1450,16);                        -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (3134,1,5,1000,1453,17);                        -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (3134,1,5,1000,1456,17);                        -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3134,2,0,1000,1449,0);                            -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3134,2,0,1000,1452,0);                            -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3134,2,0,1000,1455,0);                            -- One Byne Bill (Steal)

-- ZoneID:  41 - Lost Suttung
INSERT INTO `mob_droplist` VALUES (3136,0,0,1000,3482,@ALWAYS);                      -- Fiendish Tome Ii Chapter 13 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3136,1,1,1000,19738,130);                         -- Aifes Bow (30.0%)
INSERT INTO `mob_droplist` VALUES (3136,1,1,1000,@FORGOTTEN_POUCH_LEGS,870);         -- Forgotten pouch journey (87%)
INSERT INTO `mob_droplist` VALUES (3136,0,0,1000,@FORGOTTEN_POUCH_LEGS,@ALWAYS);     -- Forgotten pouch journey (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3136,1,2,1000,@FORGOTTEN_POUCH_LEGS,950);         -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3136,1,2,1000,1450,16);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3136,1,2,1000,1453,17);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3136,1,2,1000,1456,17);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3136,1,3,1000,@FORGOTTEN_POUCH_LEGS,950);         -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3136,1,3,1000,1450,17);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3136,1,3,1000,1453,16);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3136,1,3,1000,1456,17);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3136,1,4,1000,@FORGOTTEN_POUCH_LEGS,950);         -- Forgotten pouch journey (95%)
INSERT INTO `mob_droplist` VALUES (3136,1,4,1000,1450,17);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (3136,1,4,1000,1453,17);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (3136,1,4,1000,1456,16);                           -- One Hundred Byne Bill (5%)
-- INSERT INTO `mob_droplist` VALUES (3136,1,5,1000,@FORGOTTEN_POUCH_LEGS,950);      -- Forgotten pouch journey (95%)
-- INSERT INTO `mob_droplist` VALUES (3136,1,5,1000,1450,16);                        -- Lungo-Nango-Nango Jadeshell (5%)
-- INSERT INTO `mob_droplist` VALUES (3136,1,5,1000,1453,17);                        -- Montiont Silverpiece (5%)
-- INSERT INTO `mob_droplist` VALUES (3136,1,5,1000,1456,17);                        -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (3136,2,0,1000,1449,0);                            -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3136,2,0,1000,1452,0);                            -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3136,2,0,1000,1455,0);                            -- One Byne Bill (Steal)

-- ZoneID:  41 - Arch Antaeus
INSERT INTO `mob_droplist` VALUES (3130,0,0,1000,11461,200);                         -- Aifes Pumps (20%)
INSERT INTO `mob_droplist` VALUES (3130,0,0,1000,10758,200);                         -- Aifes Ring (20%)
INSERT INTO `mob_droplist` VALUES (3130,0,0,1000,10759,200);                         -- Aifes Annulet (20%)
INSERT INTO `mob_droplist` VALUES (3130,0,0,1000,@FORGOTTEN_POUCH_LEGS,@ALWAYS);     -- Forgotten pouch journey (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3130,1,1,1000,@FORGOTTEN_POUCH_LEGS,925);         -- Forgotten pouch journey (92.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,1,1000,1450,25);                           -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,1,1000,1453,25);                           -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,1,1000,1456,25);                           -- One Hundred Byne Bill (7.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,2,1000,@FORGOTTEN_POUCH_LEGS,925);         -- Forgotten pouch journey (92.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,2,1000,1450,25);                           -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,2,1000,1453,25);                           -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,2,1000,1456,25);                           -- One Hundred Byne Bill (7.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,3,1000,@FORGOTTEN_POUCH_LEGS,925);         -- Forgotten pouch journey (92.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,3,1000,1450,25);                           -- Lungo-Nango-Nango Jadeshell (7.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,3,1000,1453,25);                           -- Montiont Silverpiece (7.5%)
INSERT INTO `mob_droplist` VALUES (3130,1,3,1000,1456,25);                           -- One Hundred Byne Bill (7.5%)
-- INSERT INTO `mob_droplist` VALUES (3130,1,4,1000,@FORGOTTEN_POUCH_LEGS,925);      -- Forgotten pouch journey (92.5%)
-- INSERT INTO `mob_droplist` VALUES (3130,1,4,1000,1450,25);                        -- Lungo-Nango-Nango Jadeshell (7.5%)
-- INSERT INTO `mob_droplist` VALUES (3130,1,4,1000,1453,25);                        -- Montiont Silverpiece (7.5%)
-- INSERT INTO `mob_droplist` VALUES (3130,1,4,1000,1456,25);                        -- One Hundred Byne Bill (7.5%)
INSERT INTO `mob_droplist` VALUES (3130,2,0,1000,1449,0);                            -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3130,2,0,1000,1452,0);                            -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3130,2,0,1000,1455,0);                            -- One Byne Bill (Steal)

-- --------------------------------------------------------------------
--                          Dynamis-Tavnazia                         --
-- --------------------------------------------------------------------

-- Ensure we're clearing out the old drop lists
DELETE FROM `mob_droplist` WHERE dropid = "1342"; -- Delete Fomor Floor 1
DELETE FROM `mob_droplist` WHERE dropid = "1441"; -- Delete Fomor Floor 2
DELETE FROM `mob_droplist` WHERE dropid = "1786"; -- Delete Nightmare Cluster
DELETE FROM `mob_droplist` WHERE dropid = "1795"; -- Delete Nightmare Bugard and Hornet
DELETE FROM `mob_droplist` WHERE dropid = "1796"; -- Delete Nightmare Leech
DELETE FROM `mob_droplist` WHERE dropid = "1797"; -- Delete Nightmare Makara
DELETE FROM `mob_droplist` WHERE dropid = "1807"; -- Delete Nightmare Worm
DELETE FROM `mob_droplist` WHERE dropid = "2854"; -- Delete Nightmare Taurus
DELETE FROM `mob_droplist` WHERE dropid = "2908"; -- Delete Diabolos Spade, Heart, Diamond, and Club
DELETE FROM `mob_droplist` WHERE dropid = "3137"; -- Delete Diabolos Nox, Letum, Umbra, and Somnus

-- ZoneID:  42 - Hydra Warrior
-- ZoneID:  42 - Hydra Red Mage
-- ZoneID:  42 - Hydra Paladin
-- ZoneID:  42 - Hydra Ninja
-- ZoneID:  42 - Hydra Monk
-- ZoneID:  42 - Hydra White Mage
-- ZoneID:  42 - Hydra Beastmaster
-- ZoneID:  42 - Hydra Black Mage
-- ZoneID:  42 - Hydra Dark Knight
-- ZoneID:  42 - Hydra Bard
-- ZoneID:  42 - Hydra Dragoon
-- ZoneID:  42 - Hydra Thief
-- ZoneID:  42 - Hydra Ranger
-- ZoneID:  42 - Hydra Samurai
-- ZoneID:  42 - Hydra Summoner
INSERT INTO `mob_droplist` VALUES (1342,0,0,1000,3459,25);                     -- Heralds Juju (2.5%)
INSERT INTO `mob_droplist` VALUES (1342,1,1,@UNCOMMON,3493,500);               -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,1,@UNCOMMON,3494,500);               -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15088,66);               -- Melee Cyclas (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15089,66);               -- Clerics Briault (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15090,66);               -- Sorcerers Coat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15091,66);               -- Duelists Tabard (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15094,66);               -- Abyss Cuirass (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15096,67);               -- Bards Justaucorps (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15098,67);               -- Saotome Domaru (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15099,67);               -- Koga Chainmail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15100,67);               -- Wyrm Mail (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15101,67);               -- Summoners Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15117,67);               -- Warriors Cuisses (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15122,67);               -- Assassins Culottes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15123,67);               -- Valor Breeches (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15140,67);               -- Monster Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@UNCOMMON,15142,67);               -- Scouts Socks (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@RARE,11292,143);                  -- Mirage Jubbah (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@RARE,11295,143);                  -- Commodore Frac (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@RARE,11298,143);                  -- Pantin Tobe (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@RARE,11307,143);                  -- Argute Gown (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@RARE,16360,143);                  -- Etoile Tights (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@RARE,26840,143);                  -- Bagua Tunic (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1342,1,2,@RARE,27194,142);                  -- Futhark Trousers (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1342,2,0,1000,1449,0);                      -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1342,2,0,1000,1452,0);                      -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1342,2,0,1000,1455,0);                      -- One Byne Bill (Steal)

-- ZoneID:  42 - Kindred Monk
-- ZoneID:  42 - Kindred Black Mage
-- ZoneID:  42 - Kindred Beastmaster
-- ZoneID:  42 - Kindred White Mage
-- ZoneID:  42 - Kindred Dark Knight
-- ZoneID:  42 - Kindred Ranger
-- ZoneID:  42 - Kindred Red Mage
-- ZoneID:  42 - Kindred Paladin
-- ZoneID:  42 - Kindred Samurai
-- ZoneID:  42 - Kindred Warrior
-- ZoneID:  42 - Kindred Thief
-- ZoneID:  42 - Kindred Summoner
-- ZoneID:  42 - Kindred Bard
-- ZoneID:  42 - Kindred Ninja
-- ZoneID:  42 - Kindred Dragoon
INSERT INTO `mob_droplist` VALUES (1441,0,0,1000,3484,@UNCOMMON);                   -- Fiendish Tome Ii Chapter 15 (4.0%)
INSERT INTO `mob_droplist` VALUES (1441,1,1,@UNCOMMON,3493,500);                    -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,1,@UNCOMMON,3494,500);                    -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15073,66);                    -- Melee Crown (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15075,66);                    -- Sorcerers Petasos (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15076,66);                    -- Duelists Chapeau (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15079,66);                    -- Abyss Burgeonet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15083,66);                    -- Saotome Kabuto (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15085,67);                    -- Wyrm Armet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15086,67);                    -- Summoners Horn (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15087,67);                    -- Warriors Lorica (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15093,67);                    -- Valor Surcoat (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15097,67);                    -- Scouts Jerkin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15104,67);                    -- Clerics Mitts (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15107,67);                    -- Assassins Armlets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15110,67);                    -- Monster Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15114,67);                    -- Koga Tekko (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,2,@UNCOMMON,15126,67);                    -- Bards Cannions (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1441,1,3,@RARE,11465,143);                       -- Mirage Keffiyeh (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1441,1,3,@RARE,11468,143);                       -- Commodore Tricorne (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1441,1,3,@RARE,11471,143);                       -- Pantin Taj (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1441,1,3,@RARE,11480,143);                       -- Argute Mortarboard (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1441,1,3,@RARE,11305,143);                       -- Etoile Casaque (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1441,1,3,@RARE,26664,143);                       -- Bagua Galero (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1441,1,3,@RARE,26842,142);                       -- Futhark Coat (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1441,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (1441,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (1441,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  42 - Nightmare Cluster
INSERT INTO `mob_droplist` VALUES (1786,1,1,@UNCOMMON,3493,500);                    -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,1,@UNCOMMON,3494,500);                    -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,2,@UNCOMMON,3485,500);                    -- Fiendish Tome Ii Chapter 16 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,2,@UNCOMMON,3486,500);                    -- Fiendish Tome Ii Chapter 17 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2034,66);                     -- Warriors Lorica -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2039,66);                     -- Melee Cyclas -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2044,66);                     -- Clerics Briault -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2049,66);                     -- Sorcerers Coat -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2054,66);                     -- Duelists Tabard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2059,67);                     -- Assassins Vest -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2064,67);                     -- Valor Surcoat -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2069,67);                     -- Abyss Cuirass -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2074,67);                     -- Monster Jackcoat -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2079,67);                     -- Bards Justaucorps -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2084,67);                     -- Scouts Jerkin -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2089,67);                     -- Saotome Domaru -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2094,67);                     -- Koga Chainmail -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2099,67);                     -- Wyrm Mail -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,3,@UNCOMMON,2104,67);                     -- Summoners Doublet -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,4,@UNCOMMON,2663,200);                    -- Mirage Jubbah -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,4,@UNCOMMON,2668,200);                    -- Commodore Frac -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,4,@UNCOMMON,2673,200);                    -- Pantin Tobe -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,4,@UNCOMMON,2719,200);                    -- Etoile Casaque -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,1,4,@UNCOMMON,2724,200);                    -- Argute Gown -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1786,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)

-- ZoneID:  42 - Nightmare Bugard
-- ZoneID:  42 - Nightmare Hornet
INSERT INTO `mob_droplist` VALUES (1795,0,0,1000,3459,25);                          -- Heralds Juju (2.5%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,3493,500);                    -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,3494,500);                    -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2036,66);                     -- Warriors Cuisses -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2041,66);                     -- Melee Hose -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2046,66);                     -- Clerics Pantaloons -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2051,66);                     -- Sorcerers Tonban -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2056,66);                     -- Duelists Tights -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2061,67);                     -- Assassins Culotte -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2066,67);                     -- Valor Breeches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2071,67);                     -- Abyss Flanchard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2076,67);                     -- Monster Trousers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2081,67);                     -- Bards Cannions -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2086,67);                     -- Scouts Braccae -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2091,67);                     -- Saotome Haidate -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2096,67);                     -- Koga Hakama -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2101,67);                     -- Wyrm Brais -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,1,@UNCOMMON,2106,67);                     -- Summoners Spats -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,2,@UNCOMMON,2665,200);                    -- Mirage Shalwar -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,2,@UNCOMMON,2670,200);                    -- Commodore Trews -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,2,@UNCOMMON,2675,200);                    -- Pantin Churidars -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,2,@UNCOMMON,2721,200);                    -- Etoile Tights -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,1,2,@UNCOMMON,2726,200);                    -- Argute Pants -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1795,2,0,1000,1455,0);                           -- One Byne Bill (Steal)

-- ZoneID:  42 - Nightmare Leech
INSERT INTO `mob_droplist` VALUES (1796,1,1,@UNCOMMON,3493,500);                    -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,1,@UNCOMMON,3494,500);                    -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,2,@UNCOMMON,3485,500);                    -- Fiendish Tome Ii Chapter 16 (2.0%)
INSERT INTO `mob_droplist` VALUES (1796,1,2,@UNCOMMON,3486,500);                    -- Fiendish Tome Ii Chapter 17 (2.0%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2034,66);                     -- Warriors Lorica -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2039,66);                     -- Melee Cyclas -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2044,66);                     -- Clerics Briault -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2049,66);                     -- Sorcerers Coat -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2054,66);                     -- Duelists Tabard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2059,67);                     -- Assassins Vest -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2064,67);                     -- Valor Surcoat -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2069,67);                     -- Abyss Cuirass -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2074,67);                     -- Monster Jackcoat -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2079,67);                     -- Bards Justaucorps -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2084,67);                     -- Scouts Jerkin -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2089,67);                     -- Saotome Domaru -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2094,67);                     -- Koga Chainmail -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2099,67);                     -- Wyrm Mail -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,3,@UNCOMMON,2104,67);                     -- Summoners Doublet -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,4,@UNCOMMON,2663,200);                    -- Mirage Jubbah -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,4,@UNCOMMON,2668,200);                    -- Commodore Frac -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,4,@UNCOMMON,2673,200);                    -- Pantin Tobe -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,4,@UNCOMMON,2719,200);                    -- Etoile Casaque -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,1,4,@UNCOMMON,2724,200);                    -- Argute Gown -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1796,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)

-- ZoneID:  42 - Nightmare Makara
INSERT INTO `mob_droplist` VALUES (1797,0,0,1000,3459,25);                          -- Heralds Juju (2.5%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,3493,500);                    -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,3494,500);                    -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2036,66);                     -- Warriors Cuisses -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2041,66);                     -- Melee Hose -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2046,66);                     -- Clerics Pantaloons -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2051,66);                     -- Sorcerers Tonban -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2056,66);                     -- Duelists Tights -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2061,67);                     -- Assassins Culotte -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2066,67);                     -- Valor Breeches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2071,67);                     -- Abyss Flanchard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2076,67);                     -- Monster Trousers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2081,67);                     -- Bards Cannions -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2086,67);                     -- Scouts Braccae -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2091,67);                     -- Saotome Haidate -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2096,67);                     -- Koga Hakama -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2101,67);                     -- Wyrm Brais -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,1,@UNCOMMON,2106,67);                     -- Summoners Spats -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,2,@UNCOMMON,2665,200);                    -- Mirage Shalwar -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,2,@UNCOMMON,2670,200);                    -- Commodore Trews -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,2,@UNCOMMON,2675,200);                    -- Pantin Churidars -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,2,@UNCOMMON,2721,200);                    -- Etoile Tights -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,1,2,@UNCOMMON,2726,200);                    -- Argute Pants -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1797,2,0,1000,1452,0);                           -- Ordelle Bronzepiece (Steal)

-- ZoneID:  42 - Nightmare Worm
INSERT INTO `mob_droplist` VALUES (1807,0,0,1000,3459,25);                          -- Heralds Juju (2.5%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,3493,500);                    -- Forgotten Thought (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,3494,500);                    -- Forgotten Hope (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2036,66);                     -- Warriors Cuisses -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2041,66);                     -- Melee Hose -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2046,66);                     -- Clerics Pantaloons -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2051,66);                     -- Sorcerers Tonban -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2056,66);                     -- Duelists Tights -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2061,67);                     -- Assassins Culotte -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2066,67);                     -- Valor Breeches -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2071,67);                     -- Abyss Flanchard -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2076,67);                     -- Monster Trousers -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2081,67);                     -- Bards Cannions -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2086,67);                     -- Scouts Braccae -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2091,67);                     -- Saotome Haidate -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2096,67);                     -- Koga Hakama -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2101,67);                     -- Wyrm Brais -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,1,@UNCOMMON,2106,67);                     -- Summoners Spats -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,2,@UNCOMMON,2665,200);                    -- Mirage Shalwar -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,2,@UNCOMMON,2670,200);                    -- Commodore Trews -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,2,@UNCOMMON,2675,200);                    -- Pantin Churidars -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,2,@UNCOMMON,2721,200);                    -- Etoile Tights -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,1,2,@UNCOMMON,2726,200);                    -- Argute Pants -1 (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1807,2,0,1000,1449,0);                           -- Tukuku Whiteshell (Steal)

-- ZoneID:  42 - Nightmare Taurus

INSERT INTO `mob_droplist` VALUES (2854,1,1,@UNCOMMON,1449,333);                     -- Tukuku Whiteshell (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,1,@UNCOMMON,1452,333);                     -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,1,@UNCOMMON,1455,334);                     -- One Byne Bill (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,2,@UNCOMMON,15260,200);                    -- Hydra Beret (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,2,@UNCOMMON,14515,200);                    -- Hydra Doublet (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,2,@UNCOMMON,14924,200);                    -- Hydra Gloves (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,2,@UNCOMMON,15595,200);                    -- Hydra Brais (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,2,@UNCOMMON,15680,200);                    -- Hydra Gaiters (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,3,@UNCOMMON,15262,200);                    -- Hydra Salade (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,3,@UNCOMMON,14517,200);                    -- Hydra Haubert (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,3,@UNCOMMON,14926,200);                    -- Hydra Moufles (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,3,@UNCOMMON,15597,200);                    -- Hydra Brayettes (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,3,@UNCOMMON,15682,200);                    -- Hydra Sollerets (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,4,@UNCOMMON,15261,200);                    -- Hydra Tiara (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,4,@UNCOMMON,14516,200);                    -- Hydra Harness (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,4,@UNCOMMON,14925,200);                    -- Hydra Mittens (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,4,@UNCOMMON,15596,200);                    -- Hydra Tights (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2854,1,4,@UNCOMMON,15681,200);                    -- Hydra Spats (Uncommon, 10%)
-- The Hydra trust gear is absolutely worthless. If we ever dat edit it we can add it back in.
-- INSERT INTO `mob_droplist` VALUES (2854,0,0,1000,15263,@UNCOMMON);                -- Hydra Cap (2.0%)
-- INSERT INTO `mob_droplist` VALUES (2854,0,0,1000,14518,@UNCOMMON);                -- Hydra Jupon (2.0%)
-- INSERT INTO `mob_droplist` VALUES (2854,0,0,1000,14927,@UNCOMMON);                -- Hydra Bracers (2.0%)
-- INSERT INTO `mob_droplist` VALUES (2854,0,0,1000,15598,@UNCOMMON);                -- Hydra Hose (2.0%)
-- INSERT INTO `mob_droplist` VALUES (2854,0,0,1000,15683,@UNCOMMON);                -- Hydra Boots (2.0%)
INSERT INTO `mob_droplist` VALUES (2854,2,0,1000,1449,0);                            -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2854,2,0,1000,1452,0);                            -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2854,2,0,1000,1455,0);                            -- One Byne Bill (Steal)

-- ZoneID:  42 - Diabolos Spade
-- ZoneID:  42 - Diabolos Heart
-- ZoneID:  42 - Diabolos Diamond
-- ZoneID:  42 - Diabolos Club
INSERT INTO `mob_droplist` VALUES (2908,0,0,1000,3483,@ALWAYS);                      -- Fiendish Tome Ii Chapter 14 (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2908,1,1,@ALWAYS,@FORGOTTEN_POUCH_HEAD,500);      -- Forgotten pouch thought (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2908,1,1,@ALWAYS,@FORGOTTEN_POUCH_BODY,500);      -- Forgotten pouch hope (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2908,1,2,1000,@FORGOTTEN_POUCH_HEAD,475);         -- Forgotten pouch touch (95%)  --THESE RATES WILL CHANGE WHEN TAV 2.0 COMES OUT. DEPENDS ON HOW DIFFICULT THIS OLD ZONE BOSS IS.
INSERT INTO `mob_droplist` VALUES (2908,1,2,1000,@FORGOTTEN_POUCH_BODY,475);         -- Forgotten pouch hope (95%)
INSERT INTO `mob_droplist` VALUES (2908,1,2,1000,1450,16);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,2,1000,1453,17);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,2,1000,1456,17);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,3,1000,@FORGOTTEN_POUCH_HEAD,475);         -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (2908,1,3,1000,@FORGOTTEN_POUCH_BODY,475);         -- Forgotten pouch hope (95%)
INSERT INTO `mob_droplist` VALUES (2908,1,3,1000,1450,16);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,3,1000,1453,17);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,3,1000,1456,17);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,4,1000,@FORGOTTEN_POUCH_HEAD,475);         -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (2908,1,4,1000,@FORGOTTEN_POUCH_BODY,475);         -- Forgotten pouch hope (95%)
INSERT INTO `mob_droplist` VALUES (2908,1,4,1000,1450,17);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,4,1000,1453,16);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,4,1000,1456,17);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,5,1000,@FORGOTTEN_POUCH_HEAD,475);         -- Forgotten pouch touch (95%)
INSERT INTO `mob_droplist` VALUES (2908,1,5,1000,@FORGOTTEN_POUCH_BODY,475);         -- Forgotten pouch hope (95%)
INSERT INTO `mob_droplist` VALUES (2908,1,5,1000,1450,17);                           -- Lungo-Nango-Nango Jadeshell (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,5,1000,1453,17);                           -- Montiont Silverpiece (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,5,1000,1456,16);                           -- One Hundred Byne Bill (5%)
INSERT INTO `mob_droplist` VALUES (2908,1,6,200,11585,334);                          -- Diabolos - beguiling_collar (20%)
INSERT INTO `mob_droplist` VALUES (2908,1,6,200,15948,333);                          -- Diabolos - bobcat_belt (20%)
INSERT INTO `mob_droplist` VALUES (2908,1,6,200,15953,333);                          -- Diabolos - marching_belt (20%)
INSERT INTO `mob_droplist` VALUES (2908,1,7,@COMMON,16151,500);                      -- Diabolos - leonine_mask (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2908,1,7,@COMMON,14162,500);                      -- Diabolos - agronas_leggings (Common, 15%)
INSERT INTO `mob_droplist` VALUES (2908,1,8,@UNCOMMON,11502,500);                    -- Diabolos - acubens_helm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2908,1,8,@UNCOMMON,19244,500);                    -- Diabolos - verthandis_gem (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2908,0,0,1000,2471,100);                          -- Diabolos - netherfield_chain (20%)
INSERT INTO `mob_droplist` VALUES (2908,2,0,1000,1449,0);                            -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (2908,2,0,1000,1452,0);                            -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (2908,2,0,1000,1455,0);                            -- One Byne Bill (Steal)

-- ZoneID:  42 - Diabolos Nox
-- ZoneID:  42 - Diabolos Letum
-- ZoneID:  42 - Diabolos Umbra
-- ZoneID:  42 - Diabolos Somnus
INSERT INTO `mob_droplist` VALUES (3137,0,0,1000,10761,200);                         -- Portus Annulet (20%)
INSERT INTO `mob_droplist` VALUES (3137,0,0,1000,10760,200);                         -- Portus Ring (20%)
INSERT INTO `mob_droplist` VALUES (3137,1,1,250,10944,500);                          -- Portus Collar (25% then 50% is 12.5%)
INSERT INTO `mob_droplist` VALUES (3137,1,1,250,11924,500);                          -- Alucinor Mitts (25% then 50% is 12.5%)
INSERT INTO `mob_droplist` VALUES (3137,1,2,@ALWAYS,@FORGOTTEN_POUCH_HEAD,500);      -- Forgotten pouch thought (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3137,1,2,@ALWAYS,@FORGOTTEN_POUCH_BODY,500);      -- Forgotten pouch hope (Always, 100%)
INSERT INTO `mob_droplist` VALUES (3137,1,3,1000,@FORGOTTEN_POUCH_HEAD,440);         -- Forgotten pouch touch (88%)
INSERT INTO `mob_droplist` VALUES (3137,1,3,1000,@FORGOTTEN_POUCH_BODY,440);         -- Forgotten pouch hope (88%)
INSERT INTO `mob_droplist` VALUES (3137,1,3,1000,1450,50);                           -- Lungo-Nango-Nango Jadeshell (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,3,1000,1453,40);                           -- Montiont Silverpiece (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,3,1000,1456,50);                           -- One Hundred Byne Bill (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,4,1000,@FORGOTTEN_POUCH_HEAD,440);         -- Forgotten pouch touch (88%)
INSERT INTO `mob_droplist` VALUES (3137,1,4,1000,@FORGOTTEN_POUCH_BODY,440);         -- Forgotten pouch hope (88%)
INSERT INTO `mob_droplist` VALUES (3137,1,4,1000,1450,50);                           -- Lungo-Nango-Nango Jadeshell (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,4,1000,1453,40);                           -- Montiont Silverpiece (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,4,1000,1456,50);                           -- One Hundred Byne Bill (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,5,1000,@FORGOTTEN_POUCH_HEAD,440);         -- Forgotten pouch touch (88%)
INSERT INTO `mob_droplist` VALUES (3137,1,5,1000,@FORGOTTEN_POUCH_BODY,440);         -- Forgotten pouch hope (88%)
INSERT INTO `mob_droplist` VALUES (3137,1,5,1000,1450,50);                           -- Lungo-Nango-Nango Jadeshell (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,5,1000,1453,40);                           -- Montiont Silverpiece (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,5,1000,1456,50);                           -- One Hundred Byne Bill (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,6,1000,@FORGOTTEN_POUCH_HEAD,440);         -- Forgotten pouch touch (88%)
INSERT INTO `mob_droplist` VALUES (3137,1,6,1000,@FORGOTTEN_POUCH_BODY,440);         -- Forgotten pouch hope (88%)
INSERT INTO `mob_droplist` VALUES (3137,1,6,1000,1450,50);                           -- Lungo-Nango-Nango Jadeshell (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,6,1000,1453,40);                           -- Montiont Silverpiece (12%)
INSERT INTO `mob_droplist` VALUES (3137,1,6,1000,1456,50);                           -- One Hundred Byne Bill (12%)
INSERT INTO `mob_droplist` VALUES (3137,2,0,1000,1449,0);                            -- Tukuku Whiteshell (Steal)
INSERT INTO `mob_droplist` VALUES (3137,2,0,1000,1452,0);                            -- Ordelle Bronzepiece (Steal)
INSERT INTO `mob_droplist` VALUES (3137,2,0,1000,1455,0);                            -- One Byne Bill (Steal)

-- --------------------------------------------------------------------
--                          Statues                                  --
-- --------------------------------------------------------------------
DELETE FROM `mob_droplist` WHERE dropid =  "745"; -- Adamantking Effigy Dreamlands
DELETE FROM `mob_droplist` WHERE dropid = "3114"; -- Adamantking Effigy Beaucedine
DELETE FROM `mob_droplist` WHERE dropid = "3115"; -- Adamantking Effigy Xarcabard
DELETE FROM `mob_droplist` WHERE dropid =   "20"; -- Adamantking Effigy Bastok
DELETE FROM `mob_droplist` WHERE dropid = "2623"; -- Serjeant Tombstone Dreamlands
DELETE FROM `mob_droplist` WHERE dropid = "3118"; -- Serjeant Tombstone Beaucedine
DELETE FROM `mob_droplist` WHERE dropid = "3119"; -- Serjeant Tombstone Xarcabard
DELETE FROM `mob_droplist` WHERE dropid = "2201"; -- Serjeant Tombstone San d`Oria
DELETE FROM `mob_droplist` WHERE dropid = "1612"; -- Manifest Icon Dreamlands
DELETE FROM `mob_droplist` WHERE dropid = "3120"; -- Avatar Icon Beaucedine
DELETE FROM `mob_droplist` WHERE dropid = "3121"; -- Avatar Icon Xarcabard
DELETE FROM `mob_droplist` WHERE dropid =  "195"; -- Avatar Icon Windurst
DELETE FROM `mob_droplist` WHERE dropid = "1143"; -- Goblin Replica Dreamlands
DELETE FROM `mob_droplist` WHERE dropid = "3116"; -- Goblin Replica Beaucedine
DELETE FROM `mob_droplist` WHERE dropid = "3117"; -- Goblin Replica Xarcabard
DELETE FROM `mob_droplist` WHERE dropid = "1144"; -- Goblin Replica Jeuno
DELETE FROM `mob_droplist` WHERE dropid = "2561"; -- Vanguard Eye Tavnazia, Beaucedine, Xarcabard

-- Nothing here is changed except for currency going from a 1% to a 5% because why not.
-- Zone 39  is Valkurm
-- Zone 40  is Buburimu
-- Zone 41  is Qufim
-- Zone 42  is Tavnazia
-- Zone 134 is Beaucedine
-- Zone 135 is Xarcabard
-- Zone 185 is San d`Oria 
-- Zone 186 is Bastok
-- Zone 187 is Windurst
-- Zone 188 is Jeuno

-- ZoneID:  39 - Adamantking Effigy
-- ZoneID:  39 - Adamantking Effigy
-- ZoneID:  40 - Adamantking Effigy
-- ZoneID:  40 - Adamantking Effigy
-- ZoneID:  41 - Adamantking Effigy 
-- ZoneID:  41 - Adamantking Effigy
-- ZoneID:  42 - Adamantking Effigy
INSERT INTO `mob_droplist` VALUES (745,0,0,1000,749,@UNCOMMON);         -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (745,0,0,1000,4248,@UNCOMMON);        -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (745,0,0,1000,748,@UNCOMMON);         -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (745,0,0,1000,1455,@UNCOMMON);        -- One Byne Bill (Uncommon, 10%)

-- ZoneID: 134 - Adamantking Effigy
INSERT INTO `mob_droplist` VALUES (3114,0,0,1000,1474,@UNCOMMON);       -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3114,0,0,1000,749,@UNCOMMON);        -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3114,0,0,1000,1470,@UNCOMMON);       -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3114,0,0,1000,4248,@UNCOMMON);       -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3114,0,0,1000,748,@UNCOMMON);        -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (3114,0,0,1000,1455,@UNCOMMON);       -- One Byne Bill (Uncommon, 10%)

-- ZoneID: 135 - Adamantking Effigy
INSERT INTO `mob_droplist` VALUES (3115,0,0,1000,1474,@UNCOMMON);       -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3115,0,0,1000,749,@UNCOMMON);        -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3115,0,0,1000,4248,@UNCOMMON);       -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3115,0,0,1000,748,@UNCOMMON);        -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (3115,0,0,1000,1455,@UNCOMMON);       -- One Byne Bill (Uncommon, 10%)

-- ZoneID: 186 - Adamantking Effigy
-- ZoneID: 186 - Adamantking Effigy
INSERT INTO `mob_droplist` VALUES (20,0,0,1000,1474,@UNCOMMON);         -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (20,0,0,1000,749,@UNCOMMON);          -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (20,0,0,1000,1470,@UNCOMMON);         -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (20,0,0,1000,748,@UNCOMMON);          -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (20,0,0,1000,1455,@UNCOMMON);         -- One Byne Bill (Uncommon, 10%)

-- ZoneID:  39 - Serjeant Tombstone
-- ZoneID:  39 - Serjeant Tombstone
-- ZoneID:  40 - Serjeant Tombstone
-- ZoneID:  40 - Serjeant Tombstone
-- ZoneID:  41 - Serjeant Tombstone
-- ZoneID:  41 - Serjeant Tombstone
-- ZoneID:  42 - Serjeant Tombstone
INSERT INTO `mob_droplist` VALUES (2623,0,0,1000,749,@UNCOMMON);        -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2623,0,0,1000,4248,@UNCOMMON);       -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2623,0,0,1000,748,@UNCOMMON);        -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (2623,0,0,1000,1452,@UNCOMMON);       -- Ordelle Bronzepiece (Uncommon, 10%)

-- ZoneID: 134 - Serjeant Tombstone
INSERT INTO `mob_droplist` VALUES (3118,0,0,1000,1474,@UNCOMMON);       -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3118,0,0,1000,749,@UNCOMMON);        -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3118,0,0,1000,1470,@UNCOMMON);       -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3118,0,0,1000,4248,@UNCOMMON);       -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3118,0,0,1000,748,@UNCOMMON);        -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (3118,0,0,1000,1452,@UNCOMMON);       -- Ordelle Bronzepiece (Uncommon, 10%)

-- ZoneID: 135 - Serjeant Tombstone
INSERT INTO `mob_droplist` VALUES (3119,0,0,1000,1474,@UNCOMMON);      -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3119,0,0,1000,749,@UNCOMMON);       -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3119,0,0,1000,4248,@UNCOMMON);      -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3119,0,0,1000,748,@UNCOMMON);       -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (3119,0,0,1000,1452,@UNCOMMON);      -- Ordelle Bronzepiece (Uncommon, 10%)

-- ZoneID: 185 - Serjeant Tombstone
-- ZoneID: 185 - Serjeant Tombstone
INSERT INTO `mob_droplist` VALUES (2201,0,0,1000,1474,@UNCOMMON);      -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2201,0,0,1000,749,@UNCOMMON);       -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2201,0,0,1000,1470,@UNCOMMON);      -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2201,0,0,1000,748,@UNCOMMON);       -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (2201,0,0,1000,1452,@UNCOMMON);      -- Ordelle Bronzepiece (Uncommon, 10%)

-- ZoneID:  39 - Manifest Icon
-- ZoneID:  39 - Manifest Icon
-- ZoneID:  40 - Manifest Icon
-- ZoneID:  40 - Manifest Icon
-- ZoneID:  41 - Manifest Icon
-- ZoneID:  41 - Manifest Icon
-- ZoneID:  42 - Manifest Icon
INSERT INTO `mob_droplist` VALUES (1612,0,0,1000,749,@UNCOMMON);       -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1612,0,0,1000,4248,@UNCOMMON);      -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1612,0,0,1000,748,@UNCOMMON);       -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (1612,0,0,1000,1449,@UNCOMMON);      -- Tukuku Whiteshell (Uncommon, 10%)

-- ZoneID: 134 - Avatar Icon
INSERT INTO `mob_droplist` VALUES (3120,0,0,1000,1474,@UNCOMMON);      -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3120,0,0,1000,749,@UNCOMMON);       -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3120,0,0,1000,1470,@UNCOMMON);      -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3120,0,0,1000,4248,@UNCOMMON);      -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3120,0,0,1000,748,@UNCOMMON);       -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (3120,0,0,1000,1449,@UNCOMMON);      -- Tukuku Whiteshell (Uncommon, 10%)

-- ZoneID: 135 - Avatar Icon
INSERT INTO `mob_droplist` VALUES (3121,0,0,1000,1474,@UNCOMMON);      -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3121,0,0,1000,749,@UNCOMMON);       -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3121,0,0,1000,4248,@UNCOMMON);      -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3121,0,0,1000,748,@UNCOMMON);       -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (3121,0,0,1000,1449,@UNCOMMON);      -- Tukuku Whiteshell (Uncommon, 10%)

-- ZoneID: 187 - Avatar Icon
-- ZoneID: 187 - Avatar Icon
INSERT INTO `mob_droplist` VALUES (195,0,0,1000,1474,@UNCOMMON);       -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (195,0,0,1000,749,@UNCOMMON);        -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (195,0,0,1000,1470,@UNCOMMON);       -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (195,0,0,1000,748,@UNCOMMON);        -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (195,0,0,1000,1449,@UNCOMMON);       -- Tukuku Whiteshell (Uncommon, 10%)

-- ZoneID:  39 - Goblin Replica
-- ZoneID:  39 - Goblin Replica
-- ZoneID:  40 - Goblin Replica
-- ZoneID:  40 - Goblin Replica
-- ZoneID:  41 - Goblin Replica
-- ZoneID:  41 - Goblin Replica
-- ZoneID:  42 - Goblin Replica
INSERT INTO `mob_droplist` VALUES (1143,0,0,1000,749,@UNCOMMON);       -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1143,0,0,1000,4248,@UNCOMMON);      -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1143,0,0,1000,748,@UNCOMMON);       -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (1143,1,1,@UNCOMMON,1449,333);       -- Tukuku Whiteshell (Rare, %)
INSERT INTO `mob_droplist` VALUES (1143,1,1,@UNCOMMON,1452,333);       -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1143,1,1,@UNCOMMON,1455,334);       -- One Byne Bill (Uncommon, 10%)

-- ZoneID: 134 - Goblin Replica
INSERT INTO `mob_droplist` VALUES (3116,0,0,1000,1474,@UNCOMMON);      -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3116,0,0,1000,749,@UNCOMMON);       -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3116,0,0,1000,1470,@UNCOMMON);      -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3116,0,0,1000,4248,@UNCOMMON);      -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3116,0,0,1000,748,@UNCOMMON);       -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (3116,1,1,@UNCOMMON,1449,333);       -- Tukuku Whiteshell (Rare, %)
INSERT INTO `mob_droplist` VALUES (3116,1,1,@UNCOMMON,1452,333);       -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3116,1,1,@UNCOMMON,1455,334);       -- One Byne Bill (Uncommon, 10%)

-- ZoneID: 135 - Goblin Replica
INSERT INTO `mob_droplist` VALUES (3117,0,0,1000,1474,@UNCOMMON);      -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3117,0,0,1000,749,@UNCOMMON);       -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3117,0,0,1000,4248,@UNCOMMON);      -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3117,0,0,1000,748,@UNCOMMON);       -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (3117,1,1,@UNCOMMON,1449,333);       -- Tukuku Whiteshell (Rare, %)
INSERT INTO `mob_droplist` VALUES (3117,1,1,@UNCOMMON,1452,333);       -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (3117,1,1,@UNCOMMON,1455,334);       -- One Byne Bill (Uncommon, 10%)

-- ZoneID: 188 - Goblin Replica
-- ZoneID: 188 - Goblin Replica
INSERT INTO `mob_droplist` VALUES (1144,0,0,1000,1474,@UNCOMMON);     -- Infinity Core (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1144,0,0,1000,749,@UNCOMMON);      -- Mythril Beastcoin (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1144,0,0,1000,1470,@UNCOMMON);     -- Sparkling Stone (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1144,1,1,@UNCOMMON,1449,333);      -- Tukuku Whiteshell (Rare, %)
INSERT INTO `mob_droplist` VALUES (1144,1,1,@UNCOMMON,1452,333);      -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1144,1,1,@UNCOMMON,1455,334);      -- One Byne Bill (Uncommon, 10%)

-- ZoneID:  42 - Vanguard Eye
-- ZoneID: 134 - Vanguard Eye
-- ZoneID: 134 - Vanguard Eye
-- ZoneID: 135 - Vanguard Eye
-- ZoneID: 135 - Vanguard Eye
INSERT INTO `mob_droplist` VALUES (2561,0,0,1000,4248,@UNCOMMON);     -- Copy Of Ginuvas Battle Theory (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2561,0,0,1000,749,40);             -- Mythril Beastcoin (4.0%)
INSERT INTO `mob_droplist` VALUES (2561,0,0,1000,748,@UNCOMMON);      -- Gold Beastcoin (2.0%)
INSERT INTO `mob_droplist` VALUES (2561,1,1,@UNCOMMON,1449,333);      -- Tukuku Whiteshell (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2561,1,1,@UNCOMMON,1452,333);      -- Ordelle Bronzepiece (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2561,1,1,@UNCOMMON,1455,334);      -- One Byne Bill (Uncommon, 10%)

