-- Dynamis 2.0 Mob Setup
--
-- Update mob groups
--

-- Dynamis Bastok
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=186 AND `groupid`=30; -- ZoPha_Forgesoul
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=186 AND `groupid`=26; -- RaGho_Darkfount
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=186 AND `groupid`=29; -- Bu'Bho Truesteel
UPDATE `mob_groups` SET `HP`='35000',               `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=186 AND `groupid`=28; -- Vazhe_Pummelsong
UPDATE `mob_groups` SET `HP`='50000', `MP`='10000', `minLevel`='85', `maxLevel`='85' WHERE `zoneid`=186 AND `groupid`=31; -- Arch_GuDha_Effigy

-- Dynamis Sandoria
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=185 AND `groupid`=27; -- Bladeburner Rokgevok
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=185 AND `groupid`=28; -- Steelshank Kratzvatz
UPDATE `mob_groups` SET `HP`='5000',  `MP`='5000',  `minLevel`='80', `maxLevel`='80' WHERE `zoneid`=185 AND `groupid`=29; -- Kratzvatzs_Hecteyes
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=185 AND `groupid`=30; -- Bloodfist_Voshgrosh
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=185 AND `groupid`=31; -- Spellspear_Djokvukk
UPDATE `mob_groups` SET `HP`='5000',  `MP`='2500',  `minLevel`='80', `maxLevel`='80' WHERE `zoneid`=185 AND `groupid`=32; -- Djokvukks_Wyvern
UPDATE `mob_groups` SET `HP`='50000', `MP`='10000', `minLevel`='85', `maxLevel`='85' WHERE `zoneid`=185 AND `groupid`=33; -- Arch_Overlord_Tombstone

-- Dynamis Windurst
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=187 AND `groupid`=28; -- Xuu_Bhoqa_the_Enigma
UPDATE `mob_groups` SET `HP`='5000',  `MP`='2500',  `minLevel`='60', `maxLevel`='60' WHERE `zoneid`=187 AND `groupid`=29; -- Xuu_Bhoqas_Avatar
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=187 AND `groupid`=30; -- Fuu_Tzapo_the_Blessed
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=187 AND `groupid`=31; -- Naa_Yixo_the_Stillrage
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=187 AND `groupid`=32; -- Tee_Zaksa_the_Ceaseless
UPDATE `mob_groups` SET `HP`='50000', `MP`='10000', `minLevel`='85', `maxLevel`='85' WHERE `zoneid`=187 AND `groupid`=33; -- Arch_Tzee_Xicu_Idol

-- Dynamis Jeuno
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=188 AND `groupid`=55; -- Quicktrix_Hexhands
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=188 AND `groupid`=56; -- Feralox_Honeylips
UPDATE `mob_groups` SET `HP`='5000',  `MP`='2500',  `minLevel`='80', `maxLevel`='80' WHERE `zoneid`=188 AND `groupid`=57; -- Feraloxs_Slime
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=188 AND `groupid`=58; -- Scourquix_Scaleskin
UPDATE `mob_groups` SET `HP`='5000',  `MP`='2500',  `minLevel`='80', `maxLevel`='80' WHERE `zoneid`=188 AND `groupid`=59; -- Scourquixs_Wyvern
UPDATE `mob_groups` SET `HP`='35000', `MP`='10000', `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=188 AND `groupid`=60; -- Wilywox_Tenderpalm
UPDATE `mob_groups` SET `HP`='50000', `MP`='10000', `minLevel`='85', `maxLevel`='85' WHERE `zoneid`=188 AND `groupid`=61; -- Arch_Goblin_Golem

-- Dynamis - Beaucedine
UPDATE `mob_groups` SET `HP`='5000',  `MP`='2500',  `minLevel`='82', `maxLevel`='82' WHERE `zoneid`=134 AND `groupid`=14; -- Taquedes_Wyvern
UPDATE `mob_groups` SET `HP`='37500', `MP`='10000', `minLevel`='91', `maxLevel`='92' WHERE `zoneid`=134 AND `groupid`=15; -- Pignonpausard
UPDATE `mob_groups` SET `HP`='37500', `MP`='10000', `minLevel`='91', `maxLevel`='92' WHERE `zoneid`=134 AND `groupid`=16; -- Hitaume
UPDATE `mob_groups` SET `HP`='37500', `MP`='10000', `minLevel`='91', `maxLevel`='92' WHERE `zoneid`=134 AND `groupid`=17; -- Cavanneche
UPDATE `mob_groups` SET `HP`='37500',               `minLevel`='91', `maxLevel`='92' WHERE `zoneid`=134 AND `groupid`=13; -- Taquede
UPDATE `mob_groups` SET `HP`='50000', `MP`='10000', `minLevel`='91', `maxLevel`='92' WHERE `zoneid`=134 AND `groupid`=18; -- Arch_Angra_Mainyu
UPDATE `mob_groups` SET `HP`='20000'                                                 WHERE `zoneid`=134 AND `groupid`=1;  -- Angra_Mainyu

-- Dynamis - Xarcabard
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE `zoneid`=135 AND `groupid`=4;  -- Duke Haures
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE `zoneid`=135 AND `groupid`=5;  -- Marquis Caim
UPDATE `mob_groups` SET `HP`='5000',  `MP`='2500',  `minLevel`='83', `maxLevel`='83' WHERE `zoneid`=135 AND `groupid`=6;  -- Caims Vouivre
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE `zoneid`=135 AND `groupid`=7;  -- Baron_Avnas
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE `zoneid`=135 AND `groupid`=8;  -- Count_Haagenti
UPDATE `mob_groups` SET `HP`='5000',  `MP`='2500',  `minLevel`='60', `maxLevel`='60' WHERE `zoneid`=135 AND `groupid`=9;  -- Haagentis_Avatar
UPDATE `mob_groups` SET `HP`='50000', `MP`='10000', `minLevel`='95', `maxLevel`='95' WHERE `zoneid`=135 AND `groupid`=10; -- Arch_Dynamis_Lord

-- Dynamis - Valkurm
UPDATE `mob_groups` SET `HP`='20000', `MP`='10000', `minLevel`='80', `maxLevel`='80' WHERE `zoneid`=39 AND `groupid`=8;    -- Nantina
UPDATE `mob_groups` SET `HP`='20000', `MP`='10000', `minLevel`='80', `maxLevel`='80' WHERE `zoneid`=39 AND `groupid`=10;   -- Fairy_Ring
UPDATE `mob_groups` SET `HP`='20000', `MP`='10000', `minLevel`='80', `maxLevel`='80' WHERE `zoneid`=39 AND `groupid`=6;    -- Stcemqestcint
UPDATE `mob_groups` SET `HP`='30000', `MP`='10000', `minLevel`='85', `maxLevel`='85' WHERE `zoneid`=39 AND `groupid`=1;    -- Cirrate_Christelle
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=39 AND `groupid`=172; -- Lost_Fairy_Ring
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=39 AND `groupid`=174; -- Lost_Nantina
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=39 AND `groupid`=173; -- Lost_Stcemqestcint
UPDATE `mob_groups` SET `HP`='52000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=39 AND `groupid`=175; -- Arch_Christelle

-- Dynamis - Buburimu
UPDATE `mob_groups` SET `HP`='20000', `MP`='10000', `minLevel`='80', `maxLevel`='80' WHERE  `zoneid`=40 AND `groupid`=103; -- Barong
UPDATE `mob_groups` SET `HP`='20000', `MP`='10000', `minLevel`='80', `maxLevel`='80' WHERE  `zoneid`=40 AND `groupid`=104; -- Alklha
UPDATE `mob_groups` SET `HP`='20000', `MP`='10000', `minLevel`='80', `maxLevel`='80' WHERE  `zoneid`=40 AND `groupid`=105; -- Aitvaras
UPDATE `mob_groups` SET `HP`='20000', `MP`='10000', `minLevel`='80', `maxLevel`='80' WHERE  `zoneid`=40 AND `groupid`=102; -- Stihi
UPDATE `mob_groups` SET `HP`='30000', `MP`='10000', `minLevel`='85', `maxLevel`='85' WHERE  `zoneid`=40 AND `groupid`=1;   -- Apocalyptic_Beast
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=40 AND `groupid`=108; -- Lost_Barong
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=40 AND `groupid`=110; -- Lost_Alklha
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=40 AND `groupid`=106; -- Lost_Aitvaras
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=40 AND `groupid`=109; -- Lost_Stihi
UPDATE `mob_groups` SET `HP`='52000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=40 AND `groupid`=107; -- Arch_Apocalyptic_Beast

-- Dynamis - Qufim
UPDATE `mob_groups` SET `HP`='20000', `MP`=    '0', `minLevel`='80', `maxLevel`='80' WHERE  `zoneid`=41 AND `groupid`=79; -- Stringes
UPDATE `mob_groups` SET `HP`='20000', `MP`='10000', `minLevel`='80', `maxLevel`='80' WHERE  `zoneid`=41 AND `groupid`=76; -- Scolopendra
UPDATE `mob_groups` SET `HP`='20000', `MP`='10000', `minLevel`='80', `maxLevel`='80' WHERE  `zoneid`=41 AND `groupid`=85; -- Suttung
UPDATE `mob_groups` SET `HP`='30000', `MP`=    '0', `minLevel`='85', `maxLevel`='85' WHERE  `zoneid`=41 AND `groupid`=1;  -- Antaeus
UPDATE `mob_groups` SET `HP`='40000', `MP`=    '0', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=41 AND `groupid`=91; -- Lost_Stringes
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=41 AND `groupid`=87; -- Lost_Scolopendra
UPDATE `mob_groups` SET `HP`='40000', `MP`='10000', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=41 AND `groupid`=92; -- Lost_Suttung
UPDATE `mob_groups` SET `HP`='52000', `MP`=    '0', `minLevel`='93', `maxLevel`='93' WHERE  `zoneid`=41 AND `groupid`=93; -- Arch_Antaeus

-- Dynamis - Tavnazia
UPDATE `mob_groups` SET `HP`='50000', `MP`='10000', `minLevel`='87', `maxLevel`='87' WHERE  `zoneid`=42 AND `groupid`=1; -- Diabolos_Spade
UPDATE `mob_groups` SET `HP`='50000', `MP`='10000', `minLevel`='87', `maxLevel`='87' WHERE  `zoneid`=42 AND `groupid`=2; -- Diabolos_Heart
UPDATE `mob_groups` SET `HP`='50000', `MP`='10000', `minLevel`='87', `maxLevel`='87' WHERE  `zoneid`=42 AND `groupid`=3; -- Diabolos_Diamond
UPDATE `mob_groups` SET `HP`='50000', `MP`='10000', `minLevel`='87', `maxLevel`='87' WHERE  `zoneid`=42 AND `groupid`=4; -- Diabolos_Club
UPDATE `mob_groups` SET `HP`='100000', `MP`='10000', `minLevel`='95', `maxLevel`='95' WHERE  `zoneid`=42 AND `groupid`=62; -- Diabolos_Somnus
UPDATE `mob_groups` SET `HP`='100000', `MP`='10000', `minLevel`='95', `maxLevel`='95' WHERE  `zoneid`=42 AND `groupid`=37; -- Diabolos_Nox
UPDATE `mob_groups` SET `HP`='100000', `MP`='10000', `minLevel`='95', `maxLevel`='95' WHERE  `zoneid`=42 AND `groupid`=38; -- Diabolos_Letum
UPDATE `mob_groups` SET `HP`='100000', `MP`='10000', `minLevel`='95', `maxLevel`='95' WHERE  `zoneid`=42 AND `groupid`=39; -- Diabolos_Umbra

--
-- Update mob pools
--

-- Dynamis Bastok
UPDATE `mob_pools` SET `spellList`='163' WHERE `poolid`=6088;                                      -- ZoPha_Forgesoul
UPDATE `mob_pools` SET `spellList`='293' WHERE `poolid`=6060;                                      -- RaGho_Darkfount
UPDATE `mob_pools` SET `spellList`='979' WHERE `poolid`=6062;                                      -- VaZhe_Pummelsong
UPDATE `mob_pools` SET `spellList`='977' WHERE `poolid`=6063;                                      -- Bu'Bho Truesteel
UPDATE `mob_pools` SET `mJob`='8', `spellList`='975', `skill_list_id`='5022' WHERE `poolid`=2284;  -- Arch_GuDha_Effigy

-- Dynamis Sandoria
UPDATE `mob_pools` SET `spellList`='296' WHERE `poolid`=6081;                                      -- Arch_GuDha_Effigy
UPDATE `mob_pools` SET `spellList`='977' WHERE `poolid`=6082;                                      -- Steelshank Kratzvatz
UPDATE `mob_pools` SET `spellList`='296' WHERE `poolid`=6083;                                      -- Kratzvatzs_Hecteyes
UPDATE `mob_pools` SET `spellList`='293' WHERE `poolid`=6084;                                      -- Bloodfist_Voshgrosh
UPDATE `mob_pools` SET `spellList`='974' WHERE `poolid`=6085;                                      -- Spellspear_Djokvukk
UPDATE `mob_pools` SET `mJob`='2', `spellList`='975', `skill_list_id`='5022' WHERE `poolid`=6087;  -- Arch_Overlord_Tombstone

-- Dynamis Windurst
UPDATE `mob_pools` SET `spellList`='0'   WHERE `poolid`=4896;                                      -- Xuu_Bhoqa_the_Enigma
UPDATE `mob_pools` SET `spellList`='970' WHERE `poolid`=6089;                                      -- Fuu_Tzapo_the_Blessed
UPDATE `mob_pools` SET `sJob`='12', `spellList`='971' WHERE `poolid`=6090;                         -- Naa_Yixo_the_Stillrage
UPDATE `mob_pools` SET `mJob`='13', `spellList`='977' WHERE `poolid`=6091;                         -- Tee_Zaksa_the_Ceaseless
UPDATE `mob_pools` SET `spellList`='967', `skill_list_id`='5022' WHERE `poolid`=6092;              -- Arch_Tzee_Xicu_Idol

-- Dynamis Jeuno
UPDATE `mob_pools` SET `spellList`='971' WHERE `poolid`=4241;                                      -- Quicktrix_Hexhands
UPDATE `mob_pools` SET `spellList`='979' WHERE `poolid`=4653;                                      -- Feralox_Honeylips
UPDATE `mob_pools` SET `spellList`='972' WHERE `poolid`=2841;                                      -- Feraloxs_Slime
UPDATE `mob_pools` SET `sJob`='6', `spellList`='970', `skill_list_id`='5025' WHERE `poolid`=3843;  -- Wilywox_Tenderpalm
UPDATE `mob_pools` SET `mJob`='1', `spellList`='967', `skill_list_id`='5026' WHERE `poolid`=4844;  -- Arch_Goblin_Golem

--  Dynamis - Beaucedine
UPDATE `mob_pools` SET `sJob`='12', `spellList`='970', `skill_list_id`='359' WHERE `poolid`=6065;  -- Pignonpausard
UPDATE `mob_pools` SET `sJob`='4',  `spellList`='975', `skill_list_id`='359' WHERE `poolid`=6067;  -- Cavanneche
UPDATE `mob_pools` SET `mJob`='1', `sJob`='1', `skill_list_id`='359' WHERE `poolid`=6066;          -- Hitaume
UPDATE `mob_pools` SET `spellList`='973' WHERE `poolid`=141;                                       -- Angra_Mainyu
UPDATE `mob_pools` SET `spellList`='967' WHERE `poolid`=6093;                                      -- Arch_Angra_Mainyu

-- Dynamis - Xarcabard
UPDATE `mob_pools` SET `spellList`='971', `skill_list_id`='169' WHERE `poolid`=6053;               -- Duke Haures
UPDATE `mob_pools` SET `spellList`='968', `skill_list_id`='169' WHERE `poolid`=6054;               -- Marquis Caim
UPDATE `mob_pools` SET `skill_list_id`='990' WHERE  `poolid`=6055;                                 -- Caims Vouivre
UPDATE `mob_pools` SET `spellList`='293', `skill_list_id`='169' WHERE `poolid`=6056;               -- Baron_Avnas
UPDATE `mob_pools` SET `sJob`='7', `spellList`='977', `skill_list_id`='169' WHERE `poolid`=6057;   -- Count_Haagenti
UPDATE `mob_pools` SET `sJob`='5', `skill_list_id`='361' WHERE `poolid`=6059;                      -- Arch_Dynamis_Lord

-- Dynamis - Valkurm
UPDATE `mob_pools` SET `skill_list_id`= '136' WHERE  `poolid`=2807;                                -- Nantina
UPDATE `mob_pools` SET `skill_list_id`='5064' WHERE  `poolid`=730;                                 -- Cirrate_Christelle
UPDATE `mob_pools` SET `skill_list_id`='5063' WHERE  `poolid`=400;                                 -- Lost_Nantina
UPDATE `mob_pools` SET `skill_list_id`='5064' WHERE  `poolid`=354;                                 -- Arch_Christelle

-- Dynamis - Buburimu
UPDATE `mob_pools` SET `mJob`='10' WHERE `poolid`=73;                                             -- Aitvaras
UPDATE `mob_pools` SET `mJob`='10', `sJob`='4' WHERE `poolid`=198;                                -- Apocalyptic_Beast
UPDATE `mob_pools` SET `mJob`='10' WHERE  `poolid`=5116;                                          -- Lost_Aitvaras
UPDATE `mob_pools` SET `mJob`='10', `sJob`='4' WHERE  `poolid`=5112;                              -- Arch_Apocalyptic_Beast

-- Dynamis - Qufim
UPDATE `mob_pools` SET `skill_list_id`='5065' WHERE  `poolid`=162;                                -- Antaeus
UPDATE `mob_pools` SET `skill_list_id`='5065' WHERE  `poolid`=5117;                               -- Arch_Antaeus

-- Dynamis - Tavnazia
UPDATE `mob_pools` SET `spellList`= '962', `skill_list_id`='5068' WHERE `poolid` = 1028;          -- Diabolos_Club
UPDATE `mob_pools` SET `spellList`= '961', `skill_list_id`='5067' WHERE `poolid` = 1029;          -- Diabolos_Diamond
UPDATE `mob_pools` SET `spellList`= '960', `skill_list_id`='5070' WHERE `poolid` = 1030;          -- Diabolos_Heart
UPDATE `mob_pools` SET `spellList`=   '0', `skill_list_id`='5069' WHERE `poolid` = 1031;          -- Diabolos_Spade
UPDATE `mob_pools` SET `spellList`= '959', `skill_list_id`='5071' WHERE `poolid` = 4091;          -- Diabolos_Umbra
UPDATE `mob_pools` SET `spellList`= '958', `skill_list_id`='5067' WHERE `poolid` = 6050;          -- Diabolos_Letum
UPDATE `mob_pools` SET `spellList`= '957', `skill_list_id`='5070' WHERE `poolid` = 6051;          -- Diabolos_Nox
UPDATE `mob_pools` SET `spellList`=   '0', `skill_list_id`='5072' WHERE `poolid` = 6052;          -- Diabolos_Somnus

--
-- Update mob pool mods
--
-- Delete existing entries in mob_pool_mods for multiple poolids
DELETE FROM `mob_pool_mods` WHERE `poolid` IN (1344, 3122, 3167, 4351, 5117, 5732, 6058);

-- Dynamis - Beaucedine
-- Fire_Pukis
INSERT INTO `mob_pool_mods` VALUES (1344,29,20,0);   -- MDEF: 20
INSERT INTO `mob_pool_mods` VALUES (1344,240,150,0); -- SLEEPRES: 90
INSERT INTO `mob_pool_mods` VALUES (1344,247,150,0); -- BINDRES: 150
INSERT INTO `mob_pool_mods` VALUES (1344,249,150,0); -- GRAVITYRES: 150
INSERT INTO `mob_pool_mods` VALUES (1344,254,150,0); -- LULLABYRES: 150
INSERT INTO `mob_pool_mods` VALUES (1344,368,50,0);  -- REGAIN: 50

-- Petro_Pukis
INSERT INTO `mob_pool_mods` VALUES (3122,29,20,0);   -- MDEF: 20
INSERT INTO `mob_pool_mods` VALUES (3122,240,150,0); -- SLEEPRES: 90
INSERT INTO `mob_pool_mods` VALUES (3122,247,150,0); -- BINDRES: 150
INSERT INTO `mob_pool_mods` VALUES (3122,249,150,0); -- GRAVITYRES: 150
INSERT INTO `mob_pool_mods` VALUES (3122,254,150,0); -- LULLABYRES: 150
INSERT INTO `mob_pool_mods` VALUES (3122,368,50,0);  -- REGAIN: 50

-- Poison_Pukis
INSERT INTO `mob_pool_mods` VALUES (3167,29,20,0);   -- MDEF: 20
INSERT INTO `mob_pool_mods` VALUES (3167,240,150,0); -- SLEEPRES: 90
INSERT INTO `mob_pool_mods` VALUES (3167,247,150,0); -- BINDRES: 150
INSERT INTO `mob_pool_mods` VALUES (3167,249,150,0); -- GRAVITYRES: 150
INSERT INTO `mob_pool_mods` VALUES (3167,254,150,0); -- LULLABYRES: 150
INSERT INTO `mob_pool_mods` VALUES (3167,368,50,0);  -- REGAIN: 50

-- Wind_Pukis
INSERT INTO `mob_pool_mods` VALUES (4351,29,20,0);   -- MDEF: 20
INSERT INTO `mob_pool_mods` VALUES (4351,240,150,0); -- SLEEPRES: 90
INSERT INTO `mob_pool_mods` VALUES (4351,247,150,0); -- BINDRES: 150
INSERT INTO `mob_pool_mods` VALUES (4351,249,150,0); -- GRAVITYRES: 150
INSERT INTO `mob_pool_mods` VALUES (4351,254,150,0); -- LULLABYRES: 150
INSERT INTO `mob_pool_mods` VALUES (4351,368,50,0);  -- REGAIN: 50

-- Xuu_Bhoqas_Avatar
INSERT INTO `mob_pool_mods` VALUES (5732,12,-38,0);  -- INT: -38

-- Haagentis_Avatar
INSERT INTO `mob_pool_mods` VALUES (6058,12,-10,0);  -- INT: -10

-- Arch_Antaeus
INSERT INTO `mob_pool_mods` VALUES (5117, 30, 1636, 1); -- SPECIAL_SKILL: 732 trebuchet

--
-- Update mob spawn mods
--

-- Delete existing entries from mob_spawn_mods
DELETE FROM mob_spawn_mods
WHERE mobid IN (
    17539307, 17539308, 17539310, 17539311, 17539302,                              -- Dynamis - Bastok
    17535207, 17535208, 17535210, 17535211, 17535212,                              -- Dynamis - Sandoria
    17543464, 17543466, 17543467, 17543468, 17543469,                              -- Dynamis - Windurst
    17547493, 17547494, 17547496, 17547498, 17547499,                              -- Dynamis - Jeuno
    17326093, 17326095, 17326096, 17326097,                                        -- Dynamis - Beaucedine
    17330185, 17330186, 17330188, 17330189, 17330191,                              -- Dynamis - Xarcabard
    16936961, 16937432, 16937311, 16937415, 16937290,                              -- Dynamis - Valkurm
    16941057, 16941520, 16941576, 16941552, 16941368,                              -- Dynamis - Buburimu
    16945153, 16945421, 16945457, 16945470, 16945403,                              -- Dynamis - Qufim
    16949249, 16949250, 16949251, 16949252, 16949326, 16949327, 16949328, 16949329 -- Dynamis - Tavnazia
);
-- All of these are DRAW_IN: 25
-- Insert into mob_spawn_mods
INSERT INTO `mob_spawn_mods` (`mobid`, `modid`, `value`, `is_mob_mod`)
VALUES
    -- Dynamis Bastok
    (17539307, 12, 25, 1), -- Zo'Pha Forgesoul
    (17539308, 12, 25, 1), -- Ra'Gho Darkfount
    (17539310, 12, 25, 1), -- Va'Zhe Pummelsong
    (17539311, 12, 25, 1), -- Bu'Bho Truesteel
    (17539302, 12, 25, 1), -- Arch Gu'Dha Effigy
    -- Dynamis Sandoria
    (17535207, 12, 25, 1), -- Bladeburner_Rokgevok
    (17535208, 12, 25, 1), -- Steelshank_Kratzvatz
    (17535210, 12, 25, 1), -- Bloodfist_Voshgrosh
    (17535211, 12, 25, 1), -- Spellspear_Djokvukk
    (17535212, 12, 25, 1), -- Arch_Overlord_Tombstone
    -- Dynamis Windurst
    (17543464, 12, 25, 1), -- Xuu_Bhoqa_the_Enigma
    (17543466, 12, 25, 1), -- Fuu_Tzapo_the_Blessed
    (17543467, 12, 25, 1), -- Naa_Yixo_the_Stillrage
    (17543468, 12, 25, 1), -- Tee_Zaksa_the_Ceaseless
    (17543469, 12, 25, 1), -- Arch_Tzee_Xicu_Idol
    -- Dynamis Jeuno
    (17547493, 12, 25, 1), -- Quicktrix_Hexhands
    (17547494, 12, 25, 1), -- Feralox_Honeylips
    (17547496, 12, 25, 1), -- Scourquix_Scaleskin
    (17547498, 12, 25, 1), -- Wilywox_Tenderpalm
    (17547499, 12, 25, 1), -- Arch_Goblin_Golem
    -- Dynamis - Beaucedine
    (17326093, 12, 25, 1), -- Taquede
    (17326095, 12, 25, 1), -- Pignonpausard
    (17326096, 12, 25, 1), -- Hitaume
    (17326097, 12, 25, 1), -- Cavanneche
    -- Dynamis - Xarcabard
    (17330185, 12, 25, 1), -- Duke_Haures
    (17330186, 12, 25, 1), -- Marquis_Caim
    (17330188, 12, 25, 1), -- Baron_Avnas
    (17330189, 12, 25, 1), -- Count_Haagenti
    (17330191, 12, 25, 1), -- Arch_Dynamis_Lord
    -- Dynamis - Valkurm
    (16936961, 12, 25, 1), -- Cirrate_Christelle
    (16937432, 12, 25, 1), -- Lost_Fairy_Ring
    (16937311, 12, 25, 1), -- Lost_Nantina
    (16937415, 12, 25, 1), -- Lost_Stcemqestcint
    (16937290, 12, 25, 1), -- Arch_Christelle
    -- Dynamis - Buburimu
    (16941057, 12, 25, 1), -- Apocalyptic_Beast
    (16941520, 12, 25, 1), -- Lost_Barong
    (16941576, 12, 25, 1), -- Lost_Alklha
    (16941552, 12, 25, 1), -- Lost_Stihi
    (16941368, 12, 25, 1), -- Arch_Apocalyptic_Beast
    -- Dynamis - Qufim
    (16945153, 12, 25, 1), -- Antaeus
    (16945421, 12, 25, 1), -- Lost_Stringes
    (16945457, 12, 25, 1), -- Lost_Scolopendra
    (16945470, 12, 25, 1), -- Lost_Suttung
    (16945403, 12, 25, 1), -- Arch_Antaeus
    -- Dynamis Tavnazia
    (16949249, 12, 25, 1), -- Diabolos_Spade
    (16949250, 12, 25, 1), -- Diabolos_Heart
    (16949251, 12, 25, 1), -- Diabolos_Diamond
    (16949252, 12, 25, 1), -- Diabolos_Club
    (16949326, 12, 25, 1), -- Diabolos_Somnus
    (16949327, 12, 25, 1), -- Diabolos_Nox
    (16949328, 12, 25, 1), -- Diabolos_Letum
    (16949329, 12, 25, 1); -- Diabolos_Umbra
--
-- Update mob spawn points
--

-- Dynamis - Beaucedine
UPDATE `mob_spawn_points` SET `pos_x`='289.590', `pos_y`='20.104', `pos_z`='450.303', `pos_rot`='192' WHERE `mobid`=17326082;  -- Fire_Pukis
UPDATE `mob_spawn_points` SET `pos_x`='277.838', `pos_y`='20.943', `pos_z`='461.115', `pos_rot`='251' WHERE `mobid`=17326083;  -- Poison_Pukis
UPDATE `mob_spawn_points` SET `pos_x`='287.023', `pos_y`='20.349', `pos_z`='473.964', `pos_rot`='54' WHERE `mobid`=17326084;   -- Wind_Pukis
UPDATE `mob_spawn_points` SET `pos_x`='301.679', `pos_y`='20.180', `pos_z`='463.846', `pos_rot`='122' WHERE `mobid`=17326085;  -- Petro_Pukis

-- Dynamis - Xarcabard
UPDATE `mob_spawn_points`
SET `mobname` = 'Arch_Dynamis_Lord_2'
WHERE `mobid` IN (17330192, 17330193, 17330194, 17330195); -- Arch_Dynamis_Lord (Clone)


--
-- Build custom spellList
--

-- Delete entries for specified spell lists by spell_list_id
DELETE FROM `mob_spell_lists`
WHERE `spell_list_id` IN (957, 958, 959, 960, 961, 962, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979);
-- Insert new spell list entries
INSERT INTO `mob_spell_lists` VALUES
    -- VaZhe_Pummelsong spellList
    ('Pummelsong',979,383,78,255), -- armys_paeon_vi (78~255)
    ('Pummelsong',979,420,60,255), -- victory_march (60~255)
    ('Pummelsong',979,422,59,255), -- carnage_elegy (59~255)
    ('Pummelsong',979,374,76,255), -- foe_requiem_vii (76~255)
    ('Pummelsong',979,392,61,255), -- knights_minne_iv (61~255)
    ('Pummelsong',979,419,29,255), -- advancing_march (29~255)
    ('Pummelsong',979,398,87,255), -- valor_minuet_v (87~255)
    -- VaZhe_Pummelsong spellList for soul voice
    ('Pummelsong_SP',978,462,33,255), -- magic_finale (33~255)
    ('Pummelsong_SP',978,376,27, 91), -- horde_lullaby (27~91)
    ('Pummelsong_SP',978,463,16,255), -- foe_lullaby (16~255)
    ('Pummelsong_SP',978,423, 1,255), -- massacre_elegy (1~255)
    -- Bu'Bho Truesteel
    ('Truesteel',977, 47,90,255), -- protect_v (90~255)
    ('Truesteel',977, 51,80,255), -- shell_iv (80~255)
    ('Truesteel',977,112,37,255), -- flash (37~255)
    ('Truesteel',977,  4,55,255), -- cure_iv (55~255)
    -- Bu'Bho Truesteel spellList for invincible
    ('Truesteel_SP',976,  4,55,255), -- cure_iv (55~255)
    -- Arch_Boss >50HPP
    ('Arch_Boss',975,252,37,255), -- stun (37~255)
    ('Arch_Boss',975,246,62,255), -- drain_ii (62~255)
    ('Arch_Boss',975,248,78,255), -- aspir_ii (78~255)
    ('Arch_Boss',975,266,43,255), -- absorb-str (43~255)
    ('Arch_Boss',975,267,41,255), -- absorb-dex (41~255)
    ('Arch_Boss',975,270,39,255), -- absorb-int (39~255)
    ('Arch_Boss',975,275,45,255), -- absorb-tp (45~255)
    ('Arch_Boss',975,242,61,255), -- absorb-acc (61~255)
    ('Arch_Boss',975,366, 1,255), -- graviga (1~255)
    ('Arch_Boss',975,356, 1,255), -- paralyga (1~255)
    ('Arch_Boss',975,274, 1,255), -- sleepga_ii (1~255)
    -- Arch_Boss <50HPP. adds death spell
    ('Arch_Boss_death',974,252,37,255), -- stun (37~255)
    ('Arch_Boss_death',974,246,62,255), -- drain_ii (62~255)
    ('Arch_Boss_death',974,248,78,255), -- aspir_ii (78~255)
    ('Arch_Boss_death',974,266,43,255), -- absorb-str (43~255)
    ('Arch_Boss_death',974,267,41,255), -- absorb-dex (41~255)
    ('Arch_Boss_death',974,270,39,255), -- absorb-int (39~255)
    ('Arch_Boss_death',974,275,45,255), -- absorb-tp (45~255)
    ('Arch_Boss_death',974,242,61,255), -- absorb-acc (61~255)
    ('Arch_Boss_death',974,366, 1,255), -- graviga (1~255)
    ('Arch_Boss_death',974,356, 1,255), -- paralyga (1~255)
    ('Arch_Boss_death',974,274, 1,255), -- sleepga_ii (1~255)
    ('Arch_Boss_death',974,367, 1,255), -- death (1~255)
    -- Spellspear_Djokvukk deafault spellList
    ('Spellspear_DJ',973,232, 1,255), -- bio_iii (1~255)
    ('Spellspear_DJ',973, 79,75,255), -- slow_ii (75~255)
    ('Spellspear_DJ',973, 80,75,255), -- paralyze_ii (75~255)
    ('Spellspear_DJ',973,106,33,255), -- phalanx (33~255)
    ('Spellspear_DJ',973, 47, 1,255), -- protect_v (1~255)
    ('Spellspear_DJ',973, 52, 1,255), -- shell_v (1~255)
    ('Spellspear_DJ',973, 54, 1,255), -- stoneskin (1~255)
    ('Spellspear_DJ',973, 57, 1,255), -- haste (1~255)
    ('Spellspear_DJ',973,842,85,255), -- distract_ii (85~255)
    ('Spellspear_DJ',973,844,90,255), -- frazzle_ii (92~255)
    ('Spellspear_DJ',973,216, 1,255), -- gravity (1~255)
    ('Spellspear_DJ',973,493,90,255), -- temper (95~255)
    ('Spellspear_DJ',973, 59, 4,255), -- silence (4~255)
    -- Spellspear_Djokvukk spellList for chainspell nukes
    ('Spellspear_DJ_nukes',972,146, 1,255), -- fire_iii (1~255)
    ('Spellspear_DJ_nukes',972,151, 1,255), -- blizzard_iii (1~255)
    ('Spellspear_DJ_nukes',972,156, 1,255), -- aero_iii (1~255)
    ('Spellspear_DJ_nukes',972,161, 1,255), -- stone_iii (1~255)
    ('Spellspear_DJ_nukes',972,166, 1,255), -- thunder_iii (1~255)
    ('Spellspear_DJ_nukes',972,171, 1,255), -- water_iii (1~255)
    -- Spellspear_Djokvukk spellList for chainspell buffs
    ('Spellspear_DJ_buff',971,106,33,255), -- phalanx (33~255)
    ('Spellspear_DJ_buff',971, 47, 1,255), -- protect_v (1~255)
    ('Spellspear_DJ_buff',971, 52, 1,255), -- shell_v (1~255)
    ('Spellspear_DJ_buff',971, 54, 1,255), -- stoneskin (1~255)
    ('Spellspear_DJ_buff',971, 57, 1,255), -- haste (1~255)
    ('Spellspear_DJ_buff',971,486, 1,255), -- gain-str (1~255)
    ('Spellspear_DJ_buff',971,487, 1,255), -- gain-dex (1~255)
    ('Spellspear_DJ_buff',971,488, 1,255), -- gain-vit (1~255)
    ('Spellspear_DJ_buff',971,489, 1,255), -- gain-agi (1~255)
    ('Spellspear_DJ_buff',971,491, 1,255), -- gain-mnd (1~255)
    ('Spellspear_DJ_buff',971,110,44,255), -- regen_ii (44~255)
    ('Spellspear_DJ_buff',971,  3,21,255), -- cure_iii (21~255)
    ('Spellspear_DJ_buff',971,  4,41,255), -- cure_iv (41~255)
    ('Spellspear_DJ_buff',971,493,90,255), -- temper (95~255)
    ('Spellspear_DJ_buff',971,250, 1,255), -- ice_spikes (1~255)
    ('Spellspear_DJ_buff',971, 53, 1,255), -- blink (1~255)
    ('Spellspear_DJ_buff',971, 65, 5,255), -- barwater (5~255)
    ('Spellspear_DJ_buff',971, 55, 1,255), -- aquaveil (1~255)
    -- Fuu_Tzapo_the_Blessed
    ('Fuu_Tzapo',970, 47,90,255), -- protect_v (90~255)
    ('Fuu_Tzapo',970, 51,80,255), -- shell_iv (80~255)
    ('Fuu_Tzapo',970,112,37,255), -- flash (37~255)
    ('Fuu_Tzapo',970,  6,80,255), -- cure_vi (80~255)
    ('Fuu_Tzapo',970, 56,13,255), -- slow (13~255)
    ('Fuu_Tzapo',970, 57,40,255), -- haste (40~255)
    ('Fuu_Tzapo',970, 58, 4,255), -- paralyze (4~255)
    ('Fuu_Tzapo',970,477,86,255), -- regen_iv (86~255)
    ('Fuu_Tzapo',970, 40,69,255), -- banishga_iii (69~255)
    ('Fuu_Tzapo',970, 35,74,255), -- diaga_iii (74~255)
    ('Fuu_Tzapo',970, 53,19,255), -- blink (19~255)
    ('Fuu_Tzapo',970, 54,28,255), -- stoneskin (28~255)
    ('Fuu_Tzapo',970, 59,15,255), -- silence (15~255)
    ('Fuu_Tzapo',970,143,32,255), -- erase (32~255)
    -- Fuu_Tzapo_the_Blessed_SP - post benediction
    ('Fuu_Tzapo_SP',969, 6,80,255), -- cure_vi (80~255)
    -- Tee_Zaksa_the_Ceaseless - ninja mode
    ('Tee_Zaksa_NIN',968,328,73,255), -- huton_san (73~255)
    ('Tee_Zaksa_NIN',968,339,37, 72), -- utsusemi_ni (37~72)
    ('Tee_Zaksa_NIN',968,340,73,255), -- utsusemi_san (73~255)
    ('Tee_Zaksa_NIN',968,342,65,255), -- jubaku_ni (65~255)
    ('Tee_Zaksa_NIN',968,346,76,255), -- hojo_san (76~255)
    ('Tee_Zaksa_NIN',968,349,73,255), -- kurayami_san (73~255)
    -- Arch_Tzee_Xicu_Idol - default
    ('Arch_Tzee_Xicu_Idol',967,147,1,255), -- fire_iv (1~255)
    ('Arch_Tzee_Xicu_Idol',967,152,1,255), -- blizzard_iv (1~255)
    ('Arch_Tzee_Xicu_Idol',967,157,1,255), -- aero_iv (1~255)
    ('Arch_Tzee_Xicu_Idol',967,162,1,255), -- stone_iv (1~255)
    ('Arch_Tzee_Xicu_Idol',967,167,1,255), -- thunder_iv (1~255)
    ('Arch_Tzee_Xicu_Idol',967,172,1,255), -- water_iv (1~255)
    ('Arch_Tzee_Xicu_Idol',967,176,1,255), -- firaga_iii (1~255)
    ('Arch_Tzee_Xicu_Idol',967,181,1,255), -- blizzaga_iii (1~255)
    ('Arch_Tzee_Xicu_Idol',967,186,1,255), -- aeroga_iii (1~255)
    ('Arch_Tzee_Xicu_Idol',967,191,1,255), -- stonega_iii (1~255)
    ('Arch_Tzee_Xicu_Idol',967,196,1,255), -- thundaga_iii (1~255)
    ('Arch_Tzee_Xicu_Idol',967,201,1,255), -- waterga_iii (1~255)
    ('Arch_Tzee_Xicu_Idol',967,252,1,255), -- stun (1~255)
    ('Arch_Tzee_Xicu_Idol',967,274,1,255), -- sleepga_ii (1~255)
    -- Arch_Tzee_Xicu_Idol - HPP <50
    ('Arch_Tzee_Xicu_Idol_Death',966,147,1,255), -- fire_iv (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,152,1,255), -- blizzard_iv (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,157,1,255), -- aero_iv (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,162,1,255), -- stone_iv (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,167,1,255), -- thunder_iv (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,172,1,255), -- water_iv (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,176,1,255), -- firaga_iii (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,181,1,255), -- blizzaga_iii (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,186,1,255), -- aeroga_iii (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,191,1,255), -- stonega_iii (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,196,1,255), -- thundaga_iii (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,201,1,255), -- waterga_iii (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,252,1,255), -- stun (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,274,1,255), -- sleepga_ii (1~255)
    ('Arch_Tzee_Xicu_Idol_Death',966,367,1,255), -- death (1~255)
    -- Angra_Mainyu
    ('Angra_Mainyu_SP',965,367,1,255), -- death (1~255)
    -- Diabolos_Club
    ('Diabolos_Club',962,232,1,255), -- bio_iii (1~255)
    ('Diabolos_Club',962,245,1,255), -- drain (1~255)
    ('Diabolos_Club',962,247,1,255), -- aspir (1~255)
    ('Diabolos_Club',962,274,1,255), -- sleepga_ii (1~255)
    ('Diabolos_Club',962,360,1,255), -- dispelga (1~255)
    ('Diabolos_Club',962,361,1,255), -- blindga (1~255)
    -- Diabolos_Diamond
    ('Diabolos_Diamond',961,232,1,255), -- bio_iii (1~255)
    ('Diabolos_Diamond',961,245,1,255), -- drain (1~255)
    ('Diabolos_Diamond',961,247,1,255), -- aspir (1~255)
    ('Diabolos_Diamond',961,274,1,255), -- sleepga_ii (1~255)
    ('Diabolos_Diamond',961,361,1,255), -- blindga (1~255)
    -- Diabolos_Heart
    ('Diabolos_Heart',960,232,1,255), -- bio_iii (1~255)
    ('Diabolos_Heart',960,245,1,255), -- drain (1~255)
    ('Diabolos_Heart',960,247,1,255), -- aspir (1~255)
    ('Diabolos_Heart',960,260,1,255), -- dispel (32~255)
    ('Diabolos_Heart',960,274,1,255), -- sleepga_ii (1~255)
    ('Diabolos_Heart',960,360,1,255), -- dispelga (1~255)
    ('Diabolos_Heart',960,361,1,255), -- blindga (1~255)
    -- ('Diabolos_Heart',960,502,1,255), -- kaustra (1~255)
    -- ('Diabolos_Heart',960,367,1,255), -- death (1~255)
    -- Diabolos_Umbra
    ('Diabolos_Umbra',959,361,1,255), -- blindga (1~255)
    ('Diabolos_Umbra',959,360,1,255), -- dispelga (1~255)
    -- ('Diabolos_Umbra',959,502,1,255), -- kaustra (1~255)
    -- Diabolos_Letum
    ('Diabolos_Letum',958,245,1,255), -- drain (1~255)
    ('Diabolos_Letum',958,361,1,255), -- blindga (1~255)
    -- Diabolos_Nox
    ('Diabolos_Nox',957,245,1,255), -- drain (1~255)
    ('Diabolos_Nox',957,274,1,255), -- sleepga_ii (1~255)
    ('Diabolos_Nox',957,361,1,255), -- blindga (1~255)
    ('Diabolos_Nox',957,247,1,255), -- aspir (1~255)
    ('Diabolos_Nox',957,232,1,255); -- bio_iii (1~255)
    -- ('Diabolos_Nox',957,367,1,255); -- death (1~255)

-- Delete entries for specified skill lists by mob_skill_id
DELETE FROM `mob_skills`
WHERE `mob_skill_id` IN (1554, 1605, 1607, 1609, 1619, 1903, 1904, 1906, 1907, 1908, 1909, 1910, 1912, 1917, 1918, 1919);
INSERT INTO `mob_skills` VALUES
    (1554,915,'camisado',0,0.0,10.0,2000,1500,4,0,0,2,0,0,0),
    (1605,63,'miasmic_breath',4,0.0,15.0,2000,1500,4,0,0,0,0,0,0),
    (1607,63,'fragrant_breath',4,0.0,15.0,2000,1500,4,0,0,0,0,0,0),
    (1609,63,'putrid_breath',4,0.0,15.0,2000,1500,4,0,0,0,0,0,0),
    (1619,331,'attractant',1,0.0,15.0,2000,1500,4,0,0,0,0,0,0),
    (1903,915,'camisado',0,0.0,10.0,640,3000,4,64,0,5,0,0,0),
    (1904,1126,'somnolence',0,0.0,10.0,641,3000,4,128,0,0,0,0,0),
    (1906,917,'ultimate_terror',1,0.0,15.0,643,3000,4,128,0,0,0,0,0),
    (1907,1127,'dream_shroud',1,0.0,10.0,645,1500,1,128,0,0,0,0,0),
    (1908,918,'nightmare',1,0.0,10.0,642,3000,4,128,0,0,0,0,0),
    (1909,1128,'cacodemonia',1,0.0,15.0,2000,500,4,0,0,0,0,0,0),
    (1910,1129,'nether_blast',0,0.0,10.0,646,3000,4,64,0,0,0,0,0),
    (1912,1125,'hypnogenesis',1,0.0,20.0,2000,1500,4,0,0,0,0,0,0),
    (1917,1280,'sweeping_somnolence',4,0.0,20.0,2000,1500,4,0,0,0,0,0,0),
    (1918,1282,'nether_tempest',1,0.0,20,2000,2000,4,0,0,0,0,0,0),
    (1919,1281,'daydream',0,0.0,7.0,2000,1500,4,0,0,0,0,0,0);

--
-- Build custom mob skill lists
--

-- Delete entries for specified skill lists by skill_list_id
DELETE FROM `mob_skill_lists`
WHERE `skill_list_id` IN (380, 5022, 5023, 5024, 5025, 5026, 5027, 5063, 5064, 5065, 5066, 5067, 5068, 5069, 5070, 5071, 5072);

-- Insert new spell list entries
INSERT INTO `mob_skill_lists` VALUES
    -- Diabolos Pet
    ('Pet-Diabolos',380,1554),
    ('Pet-Diabolos',380,1904),
    ('Pet-Diabolos',380,1905),
    ('Pet-Diabolos',380,1906),
    ('Pet-Diabolos',380,1907),
    ('Pet-Diabolos',380,1908),
    ('Pet-Diabolos',380,1910),
    ('Pet-Diabolos',380,1911),
    -- Arch_GuDha_Effigy
    ('Arch_GuDha',5022,1117), -- lead_breath
    ('Arch_GuDha',5022,1115), -- torpid_glare
    ('Arch_GuDha',5022,1111), -- numbing_glare
    -- Arch_GuDha_Effigy HPP <50
    ('Arch_GuDha_two',5023,1112), -- seismostomp
    ('Arch_GuDha_two',5023,1113), -- tormentful_glare
    -- Arch_Overlord_Tombstone HPP <50
    ('Arch_Overlord_two',5024,1110), -- seismostomp
    ('Arch_Overlord_two',5024,1113), -- tormentful_glare
    -- Wilywox_Tenderpalm
    ('Wilywox_Tenderpalm',5025,591), -- bomb toss
    -- Arch_Goblin_Golem HPP >50
    ('Arch_Goblin_Golem',5026,1115), -- torpid_glare
    ('Arch_Goblin_Golem',5026,1111), -- numbing_glare
    -- Arch_Goblin_Golem_SP
    ('Arch_Goblin_Golem_SP',5027,1110), -- seismostomp
    -- Nantina
    ('Lost_Nantina',5063, 581), -- Blow
    ('Lost_Nantina',5063, 584), -- Uppercut
    ('Lost_Nantina',5063,1619), -- Attractant
    -- Cirrate Christelle
    ('Cirrate_Christelle',5064, 317), -- vampiric_lash
    ('Cirrate_Christelle',5064,1332), -- extremely_bad_breath
    ('Cirrate_Christelle',5064,1605), -- miasmic_breath
    ('Cirrate_Christelle',5064,1607), -- fragrant_breath
    ('Cirrate_Christelle',5064,1609), -- putrid_breath
    -- Antaeus
    ('Antaeus',5065, 662), -- lightning roar
    ('Antaeus',5065, 664), -- impact roar
    ('Antaeus',5065, 665), -- grand slam
    ('Antaeus',5065, 667), -- power attack weapon
    ('Antaeus',5065,1636), -- trebuchet
    -- Diabolos Shard
    ('Diabolos_Shard',5066,1903), -- camisado
    -- Diabolos Diamond
    ('Diabolos_Diamond',5067,1909), -- Cacodemonia
    ('Diabolos_Diamond',5067,1912), -- Hypnogenesis
    -- Diabolos Club
    ('Diabolos_Club',5068,1554), -- Camisado: Using old non-AoE Camisado
    ('Diabolos_Club',5068,1905), -- Noctoshield
    ('Diabolos_Club',5068,1909), -- Cacodemonia
    -- Diabolos Spade
    ('Diabolos_Spade',5069,1554), -- Camisado: Using old non-AoE Camisado
    ('Diabolos_Spade',5069,1905), -- Noctoshield
    ('Diabolos_Spade',5069,1906), -- Ultimate Terror
    ('Diabolos_Spade',5069,1907), -- Dream Shroud
    ('Diabolos_Spade',5069,1918), -- Nether Tempest
    -- Diabolos_Heart
    ('Diabolos_Heart',5070,1905), -- Noctoshield
    ('Diabolos_Heart',5070,1906), -- Ultimate Terror
    ('Diabolos_Heart',5070,1907), -- Dream Shroud
    -- Diabolos Umbra
    ('Diabolos_Umbra',5071,1903), -- camisado
    ('Diabolos_Umbra',5071,1906), -- ultimate terror
    ('Diabolos_Umbra',5071,1910), -- nether blast
    ('Diabolos_Umbra',5071,1917), -- sweeping somnolence
    -- Diabolo Somnus
    ('Diabolos_Somnus',5072,1905), -- Noctoshield
    ('Diabolos_Somnus',5072,1917), -- sweeping somnolence
    ('Diabolos_Somnus',5072,1918); -- Nether Tempest

--
-- Modify mob skills.
--

UPDATE `mob_skills` SET `mob_skill_aoe` = '0' WHERE `mob_skill_id` = 1066; -- fanatic_dance
UPDATE `mob_skills` SET `mob_skill_aoe`='4', `mob_skill_distance`='25.0' WHERE  `mob_skill_id`=1636; -- trebuchet
