# Allow trusts & set global treasure pool
# Global loot pools in domain invasion zones
UPDATE zone_settings SET misc = '2520' WHERE name IN (
    'Ceizak_Battlegrounds',  -- Colkhab
    'Foret_de_Hennetiel',    -- Tchakka
    'Morimar_Basalt_Fields', -- Achuka
    'Yorcia_Weald',          -- Yumcax
    'Marjami_Ravine',        -- Hurkan
    'Kamihr_Drifts',         -- Kumhau
    'RaKaznar_Turris'        -- Helga
    -- 'Reisenjima_Henge'    -- Tortuga
    -- 'Provenance'          -- Battosai / Bahamut
    -- 'Kamihr_Drifts',      -- Amphisbaena
);

-- Amphisbaena -- Skill_List_ID 817
-- REPLACE INTO `mob_groups` (`groupid`, `poolid`, `zoneid`, `name`, `respawntime`, `spawntype`, `dropid`, `HP`, `MP`, `minLevel`, `maxLevel`, `allegiance`) VALUES (43, 1872, 132, 'Hadhayosh', 0, 128, 1268, 40000, 9999, 150, 150, 0);

-- Tortuga Use Skill_List_ID 277 Spell_list_ID 24
-- REPLACE INTO `mob_groups` (`groupid`, `poolid`, `zoneid`, `name`, `respawntime`, `spawntype`, `dropid`, `HP`, `MP`, `minLevel`, `maxLevel`, `allegiance`) VALUES (79, 5695, 289, 'Genbu-Escha', 0, 128, 0, 40000, 25000, 150, 150, 0);

-- Battosai Use Skill_List_ID 313
-- REPLACE INTO `mob_groups` (`groupid`, `poolid`, `zoneid`, `name`, `respawntime`, `spawntype`, `dropid`, `HP`, `MP`, `minLevel`, `maxLevel`, `allegiance`) VALUES (54, 2018, 73, 'Hydra', 0, 128, 0, 40000, 20000, 150, 150, 0);

UPDATE `mob_groups` SET respawntime = 0, spawntype = 128, HP = 50000, MP = 50000, minLevel = 80, maxLevel = 80, allegiance = 0 WHERE name IN (
    'Colkhab',
    'Tchakka',
    'Achuka',
    'Yumcax',
    'Hurkan',
    'Kumhau'
    -- 'Hydra'       -- Battosai
    -- 'Genbu-Escha' -- Tortuga
    -- 'Hadhayosh'   -- Amphisbaena
);

UPDATE `mob_pools` SET aggro = 1, true_detection = 1 WHERE name IN (
    'Colkhab',
    'Tchakka',
    'Achuka',
    'Yumcax',
    'Hurkan',
    'Kumhau'
);

--
-- Set Mob Levels (Adds)
--
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 28 and zoneid = 261;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 33 and zoneid = 261;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 26 and zoneid = 262;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 29 and zoneid = 262;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 30 and zoneid = 262;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 26 and zoneid = 265;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 30 and zoneid = 265;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 31 and zoneid = 265;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid =  3 and zoneid = 263;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 24 and zoneid = 263;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 24 and zoneid = 266;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 25 and zoneid = 266;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 32 and zoneid = 266;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 19 and zoneid = 267;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 20 and zoneid = 267;
UPDATE mob_groups SET minLevel = 78, maxLevel = 78, HP = 2500 WHERE groupid = 21 and zoneid = 267;

--
-- Update animations
--

-- Colkhab
UPDATE `mob_skills` SET `mob_anim_id` = 2136, `knockback` = 5, `mob_skill_aoe` = 4 WHERE `mob_skill_id` = 3002; -- mandibular_lashing
UPDATE `mob_skills` SET `mob_anim_id` = 2137, `knockback` = 3, `mob_skill_aoe` = 4 WHERE `mob_skill_id` = 3003; -- vespine_hurricane
UPDATE `mob_skills` SET `mob_anim_id` = 2138, `mob_skill_aoe` = 4 WHERE `mob_skill_id` = 3004; -- stinger_volley
UPDATE `mob_skills` SET `mob_anim_id` = 2139, `knockback` = 3, `mob_skill_aoe` = 2 WHERE `mob_skill_id` = 3005; -- droning_whirlwind
UPDATE `mob_skills` SET `mob_anim_id` = 2140 WHERE `mob_skill_id` = 3006; -- incisive_denouement
UPDATE `mob_skills` SET `mob_anim_id` = 2141, `knockback` = 3, `mob_skill_aoe` = 4 WHERE `mob_skill_id` = 3007; -- incisive_apotheosis

-- Craklaw
UPDATE `mob_skills` SET `mob_skill_aoe` = 4 WHERE `mob_skill_id` = 2961; -- riptide_eupnea
UPDATE `mob_skills` SET `mob_anim_id`= 2183 WHERE `mob_skill_id` = 2960; -- viscid_spindrift
UPDATE `mob_skills` SET `mob_anim_id`= 2182, `mob_skill_aoe`= 4 WHERE  `mob_skill_id` = 2959; -- sundering_snip
UPDATE `mob_skills` SET `mob_anim_id`= 2181, `mob_skill_aoe`= 4 WHERE  `mob_skill_id` = 2958; -- rending_deluge
UPDATE `mob_skills` SET `mob_anim_id`= 2180 WHERE  `mob_skill_id`= 2957; -- impenetrable_carapace

-- Kumhau's Tusk(Raaz)
INSERT INTO `mob_skills` VALUES (3130,2274,'barreling_smash',0,0.0,7.0,2000,1500,4,0,0,0,0,0,0);
INSERT INTO `mob_skills` VALUES (3131,2275,'sweeping_gouge',4,0.0,7.0,2000,1500,4,0,0,0,0,0,0);
INSERT INTO `mob_skills` VALUES (3132,2276,'zealous_snort',0,0.0,7.0,2000,1500,1,0,0,0,0,0,0);

-- Hurkan
DELETE FROM `mob_skills` WHERE `mob_skill_id` = 3072;
INSERT INTO `mob_skills` VALUES (3072,2222,'crashing_thunder',1,0.0,18.0,2000,2000,4,0,0,4,0,0,0);
UPDATE `mob_skills` SET `mob_anim_id` = 2218 WHERE `mob_skill_id` = 3073; -- reverberating_cry
UPDATE `mob_skills` SET `mob_anim_id` = 2219, `mob_skill_aoe` = 4 WHERE `mob_skill_id` = 3074; -- brownout
UPDATE `mob_skills` SET `mob_anim_id` = 2220 WHERE `mob_skill_id` = 3075; -- reverse_current
UPDATE `mob_skills` SET `mob_anim_id` = 2221, `mob_skill_aoe` = 4 WHERE `mob_skill_id` = 3076; -- sparkstorm
UPDATE `mob_skills` SET `mob_anim_id` = 2222, `mob_skill_distance` = 15.0 WHERE `mob_skill_id` = 3077; -- static_prison

-- Yumcax
UPDATE `mob_skills` SET `mob_anim_id` = 2205, `mob_skill_aoe` = 0 WHERE `mob_skill_id` = 3057; -- root_of_the_problem
UPDATE `mob_skills` SET `mob_anim_id` = 2206, `mob_skill_distance` = 15.0 WHERE `mob_skill_id` = 3058; -- potted_plant
UPDATE `mob_skills` SET `mob_anim_id` = 2207 WHERE `mob_skill_id` = 3059; -- uproot
UPDATE `mob_skills` SET `mob_anim_id` = 2209, `mob_skill_distance` = 15.0 WHERE `mob_skill_id` = 3061; -- firefly_fandango
UPDATE `mob_skills` SET `mob_skill_distance` = 15.0 WHERE `mob_skill_id` = 3060; -- canopierce
UPDATE `mob_skills` SET `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3062; -- tiiimbeeer

-- Matamata
UPDATE `mob_skills` SET `mob_anim_id`= 2124 WHERE `mob_skill_id`= 2965; -- cranial_thrust
UPDATE `mob_skills` SET `mob_skill_aoe`= 2, `knockback`= 1 WHERE `mob_skill_id`= 2966; -- tail_thwack
UPDATE `mob_skills` SET `mob_skill_aoe`= 2 WHERE `mob_skill_id`= 2967; -- embalming_earth
UPDATE `mob_skills` SET `knockback`= 1 WHERE `mob_skill_id`= 2968; -- scalding_breath

DELETE FROM `mob_skill_lists` WHERE `skill_list_name` IN ('Colkhab', 'Tchakka', 'Achuka', 'Yumcax', 'Hurkan', 'Kumhau');

-- Colkhab: 5028
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Colkhab';
INSERT INTO `mob_skill_lists` VALUES('Colkhab',5028,3002); -- mandibular_lashing
INSERT INTO `mob_skill_lists` VALUES('Colkhab',5028,3003); -- vespine_hurricane
INSERT INTO `mob_skill_lists` VALUES('Colkhab',5028,3004); -- stinger_volley
INSERT INTO `mob_skill_lists` VALUES('Colkhab',5028,3005); -- droning_whirlwind
INSERT INTO `mob_skill_lists` VALUES('Colkhab',5028,3006); -- incisive_denouement
INSERT INTO `mob_skill_lists` VALUES('Colkhab',5028,3007); -- incisive_apotheosis

-- Tchakka: 5029
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Tchakka';
INSERT INTO `mob_skill_lists` VALUES('Tchakka',5029,3011); -- protolithic_puncture
INSERT INTO `mob_skill_lists` VALUES('Tchakka',5029,3012); -- aquatic_lance
INSERT INTO `mob_skill_lists` VALUES('Tchakka',5029,3013); -- pelagic_cleaver
INSERT INTO `mob_skill_lists` VALUES('Tchakka',5029,3014); -- carcharian_verve
INSERT INTO `mob_skill_lists` VALUES('Tchakka',5029,3015); -- tidal_guillotine
INSERT INTO `mob_skill_lists` VALUES('Tchakka',5029,3016); -- marine_mayhem
UPDATE `mob_skills` SET `mob_skill_distance` = 10.0 , `mob_valid_targets` = 4 WHERE `mob_skill_id` = 3013; -- pelagic_cleaver
UPDATE `mob_skills` SET `mob_skill_aoe` = 0, `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3011; -- protolithic_puncture
UPDATE `mob_skills` SET `mob_skill_aoe` = 4, `mob_skill_distance`= 10.0 WHERE `mob_skill_id` = 3012; -- aquatic_lance
UPDATE `mob_skills` SET `mob_skill_aoe` = 0, `mob_valid_targets` = 1 WHERE `mob_skill_id` = 3014; -- carcharian_verve
UPDATE `mob_skills` SET `mob_skill_aoe` = 4,`mob_skill_distance` = 15.0 WHERE `mob_skill_id` = 3015; -- tidal_guillotine

-- Achuka: 5030
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Achuka';
INSERT INTO `mob_skill_lists` VALUES('Achuka',5030,3020); -- blistering_roar
INSERT INTO `mob_skill_lists` VALUES('Achuka',5030,3021); -- searing_serration
INSERT INTO `mob_skill_lists` VALUES('Achuka',5030,3022); -- volcanic_stasis
INSERT INTO `mob_skill_lists` VALUES('Achuka',5030,3023); -- tyrannical_blow
INSERT INTO `mob_skill_lists` VALUES('Achuka',5030,3024); -- batholithic_shell
INSERT INTO `mob_skill_lists` VALUES('Achuka',5030,3025); -- pyroclastic_surge
INSERT INTO `mob_skill_lists` VALUES('Achuka',5030,3026); -- incinerating_lahar
UPDATE `mob_skills` SET `knockback` = 3 WHERE `mob_skill_id` = 3023; -- tyrannical_blow
UPDATE `mob_skills` SET `mob_skill_aoe` = 4 , `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3022; -- volcanic_stasis
UPDATE `mob_skills` SET `mob_skill_distance` = 10.0, `knockback` = 3 WHERE `mob_skill_id` = 3026; -- incinerating_lahar
UPDATE `mob_skills` SET `mob_skill_distance` = 15.0 WHERE `mob_skill_id` = 3020; -- blistering_roar

-- Yumcax: 5031
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Yumcax';
INSERT INTO `mob_skill_lists` VALUES('Yumcax',5031,3057); -- root_of_the_problem
INSERT INTO `mob_skill_lists` VALUES('Yumcax',5031,3058); -- potted_plant
INSERT INTO `mob_skill_lists` VALUES('Yumcax',5031,3059); -- uproot
INSERT INTO `mob_skill_lists` VALUES('Yumcax',5031,3060); -- canopierce
INSERT INTO `mob_skill_lists` VALUES('Yumcax',5031,3061); -- firefly_fandango
INSERT INTO `mob_skill_lists` VALUES('Yumcax',5031,3062); -- tiiimbeeer

-- Hurkan: 5032
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Hurkan';
INSERT INTO `mob_skill_lists` VALUES('Hurkan',5032,3072); -- crashing_thunder
INSERT INTO `mob_skill_lists` VALUES('Hurkan',5032,3073); -- reverberating_cry
INSERT INTO `mob_skill_lists` VALUES('Hurkan',5032,3074); -- brownout
INSERT INTO `mob_skill_lists` VALUES('Hurkan',5032,3075); -- reverse_current
INSERT INTO `mob_skill_lists` VALUES('Hurkan',5032,3076); -- sparkstorm
INSERT INTO `mob_skill_lists` VALUES('Hurkan',5032,3077); -- static_prison

-- Kumhau: 5033
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Kumhau';
INSERT INTO `mob_skill_lists` VALUES('Kumhau',5033,3141); -- glacial_tomb
INSERT INTO `mob_skill_lists` VALUES('Kumhau',5033,3142); -- glassy_nova
INSERT INTO `mob_skill_lists` VALUES('Kumhau',5033,3140); -- permafrost_requiem
INSERT INTO `mob_skill_lists` VALUES('Kumhau',5033,3137); -- polar_roar
INSERT INTO `mob_skill_lists` VALUES('Kumhau',5033,3138); -- brain_freeze
INSERT INTO `mob_skill_lists` VALUES('Kumhau',5033,3139); -- biting_abrogation
UPDATE `mob_skills` SET `knockback` = 3 WHERE `mob_skill_id` = 3139; -- sets biting_abrogation to knockback
UPDATE `mob_skills` SET `mob_skill_aoe` = 4, `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3138; -- brain_freeze
UPDATE `mob_skills` SET `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3142; -- glassy_nova
UPDATE `mob_skills` SET `mob_skill_distance` = 15.0 WHERE `mob_skill_id` = 3139; -- biting_abrogation
UPDATE `mob_skills` SET `mob_skill_distance` = 10.0, `knockback` = 3 WHERE `mob_skill_id` = 3137; -- polar_roar
UPDATE `mob_skills` SET `mob_skill_distance` = 15.0 WHERE `mob_skill_id` = 3140; -- permafrost_requiem

-- Outlands Peiste: 5034
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Outlands_Peiste';
INSERT INTO `mob_skill_lists` VALUES('Outlands_Peiste',5034,2152); -- aqua_fortis
INSERT INTO `mob_skill_lists` VALUES('Outlands_Peiste',5034,2153); -- regurgitation
INSERT INTO `mob_skill_lists` VALUES('Outlands_Peiste',5034,2154); -- delta_thrust
INSERT INTO `mob_skill_lists` VALUES('Outlands_Peiste',5034,2155); -- torpefying_charge
UPDATE `mob_skills` SET `mob_skill_aoe` = 2 WHERE `mob_skill_id` = 2152; -- aqua_fortis
UPDATE `mob_skills` SET `mob_skill_aoe` = 4 WHERE `mob_skill_id`= 2155; -- torpefying_charge
UPDATE `mob_pools` SET `skill_list_id` = '5034' WHERE `poolid` = 4866;

-- Clawed Tulfaire: 5035
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Clawed_Tulfaire';
INSERT INTO `mob_skill_lists` VALUES('Clawed_Tulfaire',5035,3063); -- molting_plumage
INSERT INTO `mob_skill_lists` VALUES('Clawed_Tulfaire',5035,3064); -- pentapeck
INSERT INTO `mob_skill_lists` VALUES('Clawed_Tulfaire',5035,3065); -- swooping_frenzy
UPDATE `mob_pools` SET `skill_list_id` = 5035 WHERE `poolid` = 4913;
UPDATE `mob_skills` SET `mob_skill_aoe` = 4, `mob_skill_distance` = 10.0, `knockback` = 3 WHERE `mob_skill_id` = 3063; -- molting_plumage
UPDATE `mob_skills` SET `mob_skill_aoe` = 0, `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3064; -- pentapeck
UPDATE `mob_skills` SET `mob_skill_aoe` = 4, `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3065; -- swooping_frenzy

-- Raaz: 458 (Kumhau's Tusk)
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Raaz';
INSERT INTO `mob_skill_lists` VALUES('Raaz',458,3130); -- barreling_smash
INSERT INTO `mob_skill_lists` VALUES('Raaz',458,3131); -- sweeping_gouge
INSERT INTO `mob_skill_lists` VALUES('Raaz',458,3132); -- zealous_snort

-- Matamata: 275
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Matamata';
INSERT INTO `mob_skill_lists` VALUES('Matamata',275,2965); -- cranial_thrust
INSERT INTO `mob_skill_lists` VALUES('Matamata',275,2966); -- tail_thwack
INSERT INTO `mob_skill_lists` VALUES('Matamata',275,2967); -- embalming_earth
INSERT INTO `mob_skill_lists` VALUES('Matamata',275,2968); -- scalding_breath

-- Yumcax's Panopt: 5036
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Yumcaxs_Panopt';
INSERT INTO `mob_skill_lists` VALUES('Yumcaxs_Panopt',5036,3030); -- retinal_glare
INSERT INTO `mob_skill_lists` VALUES('Yumcaxs_Panopt',5036,3031); -- sylvan_slumber
INSERT INTO `mob_skill_lists` VALUES('Yumcaxs_Panopt',5036,3032); -- crushing_gaze
UPDATE `mob_pools` SET `skill_list_id` = 5036 WHERE `poolid` = 4872;
UPDATE `mob_skills` SET `mob_anim_id` = 2099 WHERE `mob_skill_id` = 3030; -- retinal_glare
UPDATE `mob_skills` SET `mob_anim_id` = 2100, `mob_skill_distance` = 10.0 WHERE  `mob_skill_id` = 3031; -- sylvan_slumber
UPDATE `mob_skills` SET `mob_anim_id` = 2101, `mob_skill_aoe` = 4, `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3032; -- crushing_gaze

-- Yumcax's Maw: 5037
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Yumcaxs_Maw';
INSERT INTO `mob_skill_lists` VALUES('Yumcaxs_Maw',5037,3097); -- tickling_tendrils
INSERT INTO `mob_skill_lists` VALUES('Yumcaxs_Maw',5037,3098); -- stink_bomb
INSERT INTO `mob_skill_lists` VALUES('Yumcaxs_Maw',5037,3099); -- nectarous_deluge
INSERT INTO `mob_skill_lists` VALUES('Yumcaxs_Maw',5037,3100); -- nepenthic_plunge
UPDATE `mob_pools` SET `skill_list_id` = 5037 WHERE `poolid` = 4946;
UPDATE `mob_skills` SET `mob_anim_id` = 2172, `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3097; -- tickling_tendrils
UPDATE `mob_skills` SET `mob_anim_id` = 2173, `mob_skill_aoe` = 2, `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3098; -- stink_bomb
UPDATE `mob_skills` SET `mob_anim_id` = 2174, `mob_skill_aoe` = 4, `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3099; -- nectarous_deluge
UPDATE `mob_skills` SET `mob_anim_id` = 2175, `mob_skill_aoe` = 4, `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 3100; -- nepenthic_plunge

-- Leaping Chapuli: 5038
DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Leaping_Chapuli';
INSERT INTO `mob_skill_lists` VALUES('Leaping_Chapuli',5038,2946); -- sensilla_blades
INSERT INTO `mob_skill_lists` VALUES('Leaping_Chapuli',5038,2947); -- tegmina_buffet
UPDATE `mob_pools` SET `skill_list_id` = 5038 WHERE `poolid` = 4751;
UPDATE `mob_skills` SET `mob_skill_aoe` = 4,`mob_skill_distance` = 10.0,`knockback` = 3 WHERE `mob_skill_id` = 2946; -- sensilla_blades
UPDATE `mob_skills` SET `mob_skill_aoe` = 2, `mob_skill_distance` = 10.0 WHERE `mob_skill_id` = 2947; -- tegmina_buffet

-- Bahamut
REPLACE INTO mob_groups (groupid, poolid, zoneid, name, respawntime, spawntype, dropid, HP, MP, minLevel, maxLevel, allegiance) VALUES (17, 325, 29, 'Bahamut', 0, 128, 0, 30000, 10000, 100, 100, 0);

-- Add CIPHER_OF_LHUS_ALTER_EGO (Matsui-P) and Pearlscale to Bahamut
INSERT INTO mob_droplist (dropId, dropType, groupId, groupRate, itemId, itemRate) VALUES (3901, 0, 0, 1000, 10132, 240);
INSERT INTO mob_droplist (dropId, dropType, groupId, groupRate, itemId, itemRate) VALUES (3901, 0, 0, 1000, 5714, 100);

-- Helga:
DELETE FROM `mob_spell_lists` WHERE `spell_list_name` = 'Helga_DI';
INSERT INTO `mob_spell_lists` VALUES('Helga_DI',986,219,1,255); -- Comet
INSERT INTO `mob_spell_lists` VALUES('Helga_DI',986,218,1,255); -- Meteor
INSERT INTO `mob_spell_lists` VALUES('Helga_DI',986,503,1,255); -- Impact
INSERT INTO `mob_spell_lists` VALUES('Helga_DI',986,357,1,255); -- Slowga
INSERT INTO `mob_spell_lists` VALUES('Helga_DI',986,360,1,255); -- Dispelga

DELETE FROM `mob_skill_lists` WHERE `skill_list_name` = 'Helga_DI';
INSERT INTO `mob_skill_lists` VALUES('Helga_DI',5039,2880); -- night_stalker
INSERT INTO `mob_skill_lists` VALUES('Helga_DI',5039,2881); -- atropine_spore
INSERT INTO `mob_skill_lists` VALUES('Helga_DI',5039,2883); -- full_bloom
INSERT INTO `mob_skill_lists` VALUES('Helga_DI',5039,2884); -- deracinator
--INSERT INTO `mob_skill_lists` VALUES('Helga_DI',5039,2882); -- frond_fatale
--INSERT INTO `mob_skill_lists` VALUES('Helga_DI',5039,2885); -- beautiful_death

UPDATE `mob_skills` SET mob_skill_aoe = 4                WHERE mob_skill_name = 'atropine_spore';
UPDATE `mob_skills` SET mob_skill_aoe = 4, knockback = 3 WHERE mob_skill_name = 'night_stalker';

UPDATE mob_pools SET skill_list_id = 5039 WHERE name = 'Virava';

UPDATE mob_groups SET hp = 90000, mp = 30000, minLevel = 80, maxLevel = 80 WHERE name = 'Virava' AND zoneid = 289;
UPDATE mob_groups SET hp = 5000, mp = 5000 WHERE name = 'Rafflesia' AND zoneid = 95;
