--
-- Jobs
--
SET @WAR      =  1;
SET @MNK      =  2;
SET @WHM      =  4;
SET @BLM      =  8;
SET @RDM      = 16;
SET @THF      = 32;
SET @PLD      = 64;
SET @DRK      = 128;
SET @BST      = 256;
SET @BRD      = 512;
SET @RNG      = 1024;
SET @SAM      = 2048;
SET @NIN      = 4096;
SET @DRG      = 8192;
SET @SMN      = 16384;
SET @BLU      = 32768;
SET @COR      = 65536;
SET @PUP      = 131072;
SET @DNC      = 262144;
SET @SCH      = 524288;
SET @GEO      = 1048576;
SET @RUN      = 2097152;
SET @ALL_JOBS = 4194303;

--
-- Mods
--
SET @PET_ALL       = 0;
SET @PET_AUTOMATON = 3;
SET @PET_LUOPAN    = 8;

SET @MOD_DEF = 1;
SET @MOD_HP  = 2;
SET @MOD_MP  = 5;

SET @MOD_STR =  8;
SET @MOD_DEX =  9;
SET @MOD_VIT = 10;
SET @MOD_AGI = 11;
SET @MOD_INT = 12;
SET @MOD_MND = 13;
SET @MOD_CHR = 14;

SET @MOD_FIRE_RES    = 15;
SET @MOD_ICE_RES     = 16;
SET @MOD_WIND_RES    = 17;
SET @MOD_EARTH_RES   = 18;
SET @MOD_THUNDER_RES = 19;
SET @MOD_WATER_RES   = 20;
SET @MOD_LIGHT_RES   = 21;
SET @MOD_DARK_RES    = 22;

SET @MOD_ATT    = 23;
SET @MOD_RATT   = 24;
SET @MOD_ACC    = 25;
SET @MOD_RACC   = 26;
SET @MOD_ENMITY = 27;
SET @MOD_MATT   = 28;
SET @MOD_MDEF   = 29;
SET @MOD_MACC   = 30;
SET @MOD_MEVA   = 31;
SET @MOD_EVA    = 68;

SET @MOD_STORE_TP = 73;

SET @MOD_HTH_SKILL     = 80;
SET @MOD_DAGGER_SKILL  = 81;
SET @MOD_SWORD_SKILL   = 82;
SET @MOD_GSWORD_SKILL  = 83;
SET @MOD_AXE_SKILL     = 84;
SET @MOD_GAXE_SKILL    = 85;
SET @MOD_SCYTHE_SKILL  = 86;
SET @MOD_POLEARM_SKILL = 87;
SET @MOD_KATANA_SKILL  = 88;
SET @MOD_GKATANA_SKILL = 89;
SET @MOD_CLUB_SKILL    = 90;
SET @MOD_STAFF_SKILL   = 91;

SET @MOD_AUTO_MAGIC_SKILL  = 103;
SET @MOD_ARCHERY_SKILL     = 104;
SET @MOD_MARKSMAN_SKILL    = 105;
SET @MOD_THROWING_SKILL    = 106;

SET @MOD_GUARD_SKILL   = 107;
SET @MOD_EVASION_SKILL = 108;
SET @MOD_SHIELD_SKILL  = 109;
SET @MOD_PARRY_SKILL   = 110;

SET @MOD_DIVINE_SKILL    = 111;
SET @MOD_HEALING_SKILL   = 112;
SET @MOD_ENHANCE_SKILL   = 113;
SET @MOD_ENFEEBLE_SKILL  = 114;
SET @MOD_ELEMENTAL_SKILL = 115;
SET @MOD_DARK_SKILL      = 116;
SET @MOD_SUMMONING_SKILL = 117;
SET @MOD_NINJUTSU_SKILL  = 118;
SET @MOD_SINGING_SKILL   = 119;
SET @MOD_STRING_SKILL    = 120;
SET @MOD_WIND_SKILL      = 121;
SET @MOD_BLUE_SKILL      = 122;
SET @MOD_GEOMANCY_SKILL  = 123;
SET @MOD_HANDBELL_SKILL  = 124;

SET @MOD_DAMAGE_TAKEN        = 160;
SET @MOD_PHYS_DMG_TAKEN      = 161;
SET @MOD_BREATH_DMG_TAKEN    = 162;
SET @MOD_MAGIC_DMG_TAKEN     = 163;
SET @MOD_MAGIC_DMG_TAKEN_II  = 831;

SET @MOD_FASTCAST    = 170;
SET @MOD_CONSERVE_MP = 296;

SET @MOD_CRITICAL_RATE  = 165;
SET @MOD_SKILLCHAIN_DMG = 175;
SET @MOD_DOUBLE_ATK     = 288;
SET @MOD_SUBTLE_BLOW    = 289;
SET @MOD_COUNTER        = 291;
SET @MOD_TRIPLE_ATK     = 302;
SET @MOD_ZANSHIN        = 306;
SET @MOD_NINJA_TOOL     = 308;

SET @MOD_JUMP_TP_BONUS      = 361;
SET @MOD_JUMP_DOUBLE_ATTACK = 888;

SET @MOD_VERMIN_KILLER   = 224;
SET @MOD_BIRD_KILLER     = 225;
SET @MOD_AMORPH_KILLER   = 226;
SET @MOD_LIZARD_KILLER   = 227;
SET @MOD_AQUAN_KILLER    = 228;
SET @MOD_PLANTOID_KILLER = 229;
SET @MOD_BEAST_KILLER    = 230;
SET @MOD_UNDEAD_KILLER   = 231;
SET @MOD_ARCANA_KILLER   = 232;
SET @MOD_DRAGON_KILLER   = 233;
SET @MOD_DEMON_KILLER    = 234;
SET @MOD_EMPTY_KILLER    = 235;
SET @MOD_HUMANOID_KILLER = 236;
SET @MOD_LUMINIAN_KILLER = 237;
SET @MOD_LUMINION_KILLER = 238;

SET @MOD_FIRE_AFFINITY_DMG    = 347;
SET @MOD_ICE_AFFINITY_DMG     = 348;
SET @MOD_WIND_AFFINITY_DMG    = 349;
SET @MOD_EARTH_AFFINITY_DMG   = 350;
SET @MOD_THUNDER_AFFINITY_DMG = 351;
SET @MOD_WATER_AFFINITY_DMG   = 352;
SET @MOD_LIGHT_AFFINITY_DMG   = 353;
SET @MOD_DARK_AFFINITY_DMG    = 354;

SET @MOD_FIRE_AFFINITY_ACC    = 544;
SET @MOD_ICE_AFFINITY_ACC     = 545;
SET @MOD_WIND_AFFINITY_ACC    = 546;
SET @MOD_EARTH_AFFINITY_ACC   = 547;
SET @MOD_THUNDER_AFFINITY_ACC = 548;
SET @MOD_WATER_AFFINITY_ACC   = 549;
SET @MOD_LIGHT_AFFINITY_ACC   = 550;
SET @MOD_DARK_AFFINITY_ACC    = 551;

SET @MOD_REGEN_DURATION = 339;
SET @MOD_DAY_REDUCTION  = 373;

SET @MOD_LULLABY_EFFECT = 440;
SET @MOD_BALLAD_EFFECT  = 442;

SET @MOD_GRIMOIRE_SPELLCASTING = 489;
SET @MOD_SAMBA_DURATION        = 490;

SET @CURE_CAST_TIME         = 519;

SET @MOD_PHALANX            = 301;
SET @MOD_AVATAR_PERP        = 346;
SET @MOD_RAPID_SHOT         = 359;
SET @MOD_REFRESH            = 369;
SET @MOD_REGEN              = 370;
SET @MOD_CURE_POTENCY       = 374;
SET @MOD_HASTE              = 384;
SET @MOD_RETALIATION        = 414;
SET @MOD_CRITICAL_DMG       = 421;
SET @MOD_ENSPELL_DMG_BONUS  = 432;
SET @MOD_IRIDESCENCE        = 566;
SET @MOD_CURE2MP_PERCENT    = 860;
SET @MOD_ELEMENTAL_CELERITY = 901;
SET @MOD_OCCULT_ACUMEN      = 902;
SET @MOD_PET_MAB_MDB        = 992;
SET @MOD_TRIPLE_SHOT_RATE   = 999;

SET @MOD_REPAIR_POTENCY = 854;

SET @MOD_SWIPE                  = 1016;
SET @MOD_REPRISAL_BLOCK_BONUS   = 1067;
SET @MOD_REPRISAL_SPIKES_BONUS  = 1068;

SET @LATENT_STATUS_EFFECT =  13;
SET @EFFECT_ELVORSEAL     = 603;

--
-- DI rewards
--

-- Beads
SET @FIELD_ROPE      = 11769;
SET @FIELD_TORQUE    = 10926;
SET @NAMAR_BOOMERANG = 21348;

-- Colkhab
SET @HATXIIK         = 20820;
SET @KUAKUAKAIT      = 20958;

-- Tchakka
SET @TAIKOGANE       = 20992;
SET @ATOYAC          = 20630;
SET @AZUKINAGAMITSU  = 21047;
SET @ATETEPEYORG     = 21253;

-- Achuka
SET @MAOCHINOLI      = 20543;
SET @XIUTLEATO       = 20731;

-- Yumcax
SET @TAMAXCHI        = 21125;
SET @IXTAB           = 20872;

-- Hurkan
SET @XBALANQUE       = 20917;
SET @HUNAHPU         = 20826;
SET @KAQULJAAN       = 20768;
SET @ANIMIKII_BULLET = 21334;

-- Kumhau
SET @AJJUB_BOW       = 21233;
SET @BAQIL_STAFF     = 21186;
SET @NEPOTE_BELL     = 21463;

-- Remove "MYSTERY_BOX", "MAIL2ACCOUNT"
UPDATE `item_basic` SET flags = 63552 WHERE `name` IN (
    'narmar_boomerang',
    'cloud_hairpin',
    'fishers_torque',
    'field_torque',
    'field_rope'
);

UPDATE `item_equipment` SET level = 75 WHERE `name` IN (
    'narmar_boomerang',
    'cloud_hairpin'
);

UPDATE `item_equipment` SET level = 65 WHERE `name` IN (
    'fishers_torque',
    'field_torque',
    'field_rope'
);

--
-- Shards
--

-- Field Rope
DELETE FROM `item_mods` WHERE itemId = @FIELD_ROPE;
INSERT INTO `item_mods` VALUES (@FIELD_ROPE,513,73); -- HARVESTING_RESULT: 1
INSERT INTO `item_mods` VALUES (@FIELD_ROPE,514,73); -- LOGGING_RESULT: 1
INSERT INTO `item_mods` VALUES (@FIELD_ROPE,515,73); -- MINING_RESULT: 1

-- Field Torque
DELETE FROM `item_mods` WHERE itemId = @FIELD_TORQUE;
INSERT INTO `item_mods` VALUES (@FIELD_TORQUE,513,73); -- HARVESTING_RESULT: 1
INSERT INTO `item_mods` VALUES (@FIELD_TORQUE,514,73); -- LOGGING_RESULT: 1
INSERT INTO `item_mods` VALUES (@FIELD_TORQUE,515,73); -- MINING_RESULT: 1

UPDATE `item_equipment` SET level = 30 WHERE name IN ('chocobo_torque');
UPDATE `item_equipment` SET level = 65 WHERE name IN ('field_torque', 'field_rope', 'fishers_torque');
UPDATE `item_equipment` SET level = 75 WHERE name IN ('narmar_boomerang', 'cloud_hairpin');

UPDATE `item_weapon` SET dmg = 30 WHERE name = 'narmar_boomerang';

DELETE FROM `item_mods` WHERE itemId = @NAMAR_BOOMERANG;
INSERT INTO `item_mods` VALUES (@NAMAR_BOOMERANG, @MOD_ATT,  10);
INSERT INTO `item_mods` VALUES (@NAMAR_BOOMERANG, @MOD_RATT, 10);

--
-- Usable Items
--

-- Aged Box (Bayld)
DELETE FROM `item_usable` WHERE itemId = 6267;
INSERT INTO `item_usable` VALUES (6267,'aged_box_bayld',1,1,55,0,0,0,0,0);

--
-- Naakual Weapons
--
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId IN (
    @HATXIIK, @KUAKUAKAIT, @TAIKOGANE, @ATOYAC, @AZUKINAGAMITSU, @ATETEPEYORG,
    @MAOCHINOLI, @XIUTLEATO, @TAMAXCHI, @IXTAB, @XBALANQUE, @HUNAHPU,
    @KAQULJAAN, @ANIMIKII_BULLET, @AJJUB_BOW, @BAQIL_STAFF, @NEPOTE_BELL
);

UPDATE `item_weapon` SET ilvl_skill = 0, ilvl_parry = 0, ilvl_macc = 0 WHERE itemId IN (
    @HATXIIK, @KUAKUAKAIT, @TAIKOGANE, @ATOYAC, @AZUKINAGAMITSU, @ATETEPEYORG,
    @MAOCHINOLI, @XIUTLEATO, @TAMAXCHI, @IXTAB, @XBALANQUE, @HUNAHPU,
    @KAQULJAAN, @ANIMIKII_BULLET, @AJJUB_BOW, @BAQIL_STAFF, @NEPOTE_BELL
);

DELETE FROM `item_latents` WHERE itemId IN (
    @HATXIIK, @KUAKUAKAIT, @TAIKOGANE, @ATOYAC, @AZUKINAGAMITSU, @ATETEPEYORG,
    @MAOCHINOLI, @XIUTLEATO, @TAMAXCHI, @IXTAB, @XBALANQUE, @HUNAHPU,
    @KAQULJAAN, @AJJUB_BOW, @BAQIL_STAFF
);

INSERT INTO `item_latents` VALUES
    (@HATXIIK, @MOD_STORE_TP,               5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@HATXIIK, @MOD_DAMAGE_TAKEN,        -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@HATXIIK, @MOD_REGEN,                  5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@HATXIIK, @MOD_REFRESH,                3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@HATXIIK, @MOD_PET_MAB_MDB,            5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@KUAKUAKAIT, @MOD_STORE_TP,            5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@KUAKUAKAIT, @MOD_DAMAGE_TAKEN,     -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@KUAKUAKAIT, @MOD_REGEN,               5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@KUAKUAKAIT, @MOD_REFRESH,             3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@KUAKUAKAIT, @MOD_PET_MAB_MDB,         5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@TAIKOGANE, @MOD_STORE_TP,             5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@TAIKOGANE, @MOD_DAMAGE_TAKEN,      -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@TAIKOGANE, @MOD_REGEN,                5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@TAIKOGANE, @MOD_REFRESH,              3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@TAIKOGANE, @MOD_PET_MAB_MDB,          5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@ATOYAC, @MOD_STORE_TP,                5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@ATOYAC, @MOD_DAMAGE_TAKEN,         -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@ATOYAC, @MOD_REGEN,                   5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@ATOYAC, @MOD_REFRESH,                 3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@ATOYAC, @MOD_PET_MAB_MDB,             5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@AZUKINAGAMITSU, @MOD_STORE_TP,        5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@AZUKINAGAMITSU, @MOD_DAMAGE_TAKEN, -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@AZUKINAGAMITSU, @MOD_REGEN,           5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@AZUKINAGAMITSU, @MOD_REFRESH,         3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@AZUKINAGAMITSU, @MOD_PET_MAB_MDB,     5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@ATETEPEYORG, @MOD_STORE_TP,           5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@ATETEPEYORG, @MOD_DAMAGE_TAKEN,    -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@ATETEPEYORG, @MOD_REGEN,              5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@ATETEPEYORG, @MOD_REFRESH,            3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@ATETEPEYORG, @MOD_PET_MAB_MDB,        5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@MAOCHINOLI, @MOD_STORE_TP,            5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@MAOCHINOLI, @MOD_DAMAGE_TAKEN,     -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@MAOCHINOLI, @MOD_REGEN,               5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@MAOCHINOLI, @MOD_REFRESH,             3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@MAOCHINOLI, @MOD_PET_MAB_MDB,         5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@MAOCHINOLI, @MOD_AUTO_MAGIC_SKILL,    5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL), -- Exact amount of +skill needed for a 5/5 skill merited PUP to get Thunder IV to break auras.

    (@XIUTLEATO, @MOD_STORE_TP,             5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@XIUTLEATO, @MOD_DAMAGE_TAKEN,      -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@XIUTLEATO, @MOD_REGEN,                5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@XIUTLEATO, @MOD_REFRESH,              3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@XIUTLEATO, @MOD_PET_MAB_MDB,          5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@TAMAXCHI, @MOD_STORE_TP,              5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@TAMAXCHI, @MOD_DAMAGE_TAKEN,       -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@TAMAXCHI, @MOD_REGEN,                 5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@TAMAXCHI, @MOD_REFRESH,               3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@TAMAXCHI, @MOD_PET_MAB_MDB,           5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@IXTAB, @MOD_STORE_TP,                 5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@IXTAB, @MOD_DAMAGE_TAKEN,          -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@IXTAB, @MOD_REGEN,                    5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@IXTAB, @MOD_REFRESH,                  3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@IXTAB, @MOD_PET_MAB_MDB,              5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@XBALANQUE, @MOD_STORE_TP,             5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@XBALANQUE, @MOD_DAMAGE_TAKEN,      -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@XBALANQUE, @MOD_REGEN,                5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@XBALANQUE, @MOD_REFRESH,              3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@XBALANQUE, @PET_MAB_MDB,              5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@HUNAHPU, @MOD_STORE_TP,               5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@HUNAHPU, @MOD_DAMAGE_TAKEN,        -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@HUNAHPU, @MOD_REGEN,                  5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@HUNAHPU, @MOD_REFRESH,                3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@HUNAHPU, @MOD_PET_MAB_MDB,            5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@KAQULJAAN, @MOD_STORE_TP,             5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@KAQULJAAN, @MOD_DAMAGE_TAKEN,      -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@KAQULJAAN, @MOD_REGEN,                5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@KAQULJAAN, @MOD_REFRESH,              3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@KAQULJAAN, @MOD_PET_MAB_MDB,          5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@AJJUB_BOW, @MOD_STORE_TP,             5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@AJJUB_BOW, @MOD_DAMAGE_TAKEN,      -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@AJJUB_BOW, @MOD_REGEN,                5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@AJJUB_BOW, @MOD_REFRESH,              3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@AJJUB_BOW, @MOD_PET_MAB_MDB,          5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),

    (@BAQIL_STAFF, @MOD_STORE_TP,           5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@BAQIL_STAFF, @MOD_DAMAGE_TAKEN,    -500, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@BAQIL_STAFF, @MOD_REGEN,              5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@BAQIL_STAFF, @MOD_REFRESH,            3, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL),
    (@BAQIL_STAFF, @MOD_PET_MAB_MDB,        5, @LATENT_STATUS_EFFECT, @EFFECT_ELVORSEAL);

UPDATE `item_weapon` SET dmg = 46 WHERE itemId = @HATXIIK;
UPDATE `item_equipment` SET jobs = 2098561 WHERE itemId = @HATXIIK;
DELETE FROM `item_mods` WHERE itemId = @HATXIIK;
INSERT INTO `item_mods` VALUES
    (@HATXIIK, @MOD_STR,        3),
    (@HATXIIK, @MOD_VIT,        3),
    (@HATXIIK, @MOD_WIND_RES,  20),
    (@HATXIIK, @MOD_AXE_SKILL,  3),
    (@HATXIIK, @MOD_DOUBLE_ATK, 2);

UPDATE `item_weapon` SET dmg = 92 WHERE itemId = @KUAKUAKAIT;
UPDATE `item_equipment` SET jobs = 8256 WHERE itemId = @KUAKUAKAIT;
DELETE FROM `item_mods` WHERE itemId = @KUAKUAKAIT;
INSERT INTO `item_mods` VALUES
    (@KUAKUAKAIT, @MOD_STR,            3),
    (@KUAKUAKAIT, @MOD_VIT,            3),
    (@KUAKUAKAIT, @MOD_WIND_RES,      20),
    (@KUAKUAKAIT, @MOD_POLEARM_SKILL,  3),
    (@KUAKUAKAIT, @MOD_HASTE,        100);

DELETE FROM `item_mods_pet` WHERE itemId = @KUAKUAKAIT;
INSERT INTO `item_mods_pet` VALUES
    (@KUAKUAKAIT, @MOD_HP,    25, @PET_ALL),
    (@KUAKUAKAIT, @MOD_REGEN,  1, @PET_ALL);

UPDATE `item_weapon` SET dmg = 36 WHERE itemId = @TAIKOGANE;
UPDATE `item_equipment` SET jobs = 4096 WHERE itemId = @TAIKOGANE;
DELETE FROM `item_mods` WHERE itemId = @TAIKOGANE;
INSERT INTO `item_mods` VALUES
    (@TAIKOGANE, @MOD_DEX,            3),
    (@TAIKOGANE, @MOD_AGI,            3),
    (@TAIKOGANE, @MOD_WIND_RES,      20),
    (@TAIKOGANE, @MOD_EVA,            3),
    (@TAIKOGANE, @MOD_KATANA_SKILL,   3),
    (@TAIKOGANE, @MOD_PARRY_SKILL,    5),
    (@TAIKOGANE, @MOD_CRITICAL_RATE,  2);

UPDATE `item_weapon` SET dmg = 33 WHERE itemId = @ATOYAC;
UPDATE `item_equipment` SET jobs = 464881 WHERE itemId = @ATOYAC;
DELETE FROM `item_mods` WHERE itemId = @ATOYAC;
INSERT INTO `item_mods` VALUES
    (@ATOYAC, @MOD_DEX,          3),
    (@ATOYAC, @MOD_AGI,          3),
    (@ATOYAC, @MOD_WATER_RES,   20),
    (@ATOYAC, @MOD_EVA,          3),
    (@ATOYAC, @MOD_DAGGER_SKILL, 3),
    (@ATOYAC, @MOD_SUBTLE_BLOW,  5);

UPDATE `item_weapon` SET dmg = 81 WHERE itemId = @AZUKINAGAMITSU;
UPDATE `item_equipment` SET jobs = 6144 WHERE itemId = @AZUKINAGAMITSU;
DELETE FROM `item_mods` WHERE itemId = @AZUKINAGAMITSU;
INSERT INTO `item_mods` VALUES
    (@AZUKINAGAMITSU, @MOD_STR,             3),
    (@AZUKINAGAMITSU, @MOD_DEX,             3),
    (@AZUKINAGAMITSU, @MOD_WATER_RES,      20),
    (@AZUKINAGAMITSU, @MOD_GKATANA_SKILL,   3),
    (@AZUKINAGAMITSU, @MOD_SKILLCHAIN_DMG,  3);

UPDATE `item_weapon` SET dmg = 48 WHERE itemId = @ATETEPEYORG;
UPDATE `item_equipment` SET jobs = 1056 WHERE itemId = @ATETEPEYORG;
DELETE FROM `item_mods` WHERE itemId = @ATETEPEYORG;
INSERT INTO `item_mods` VALUES
    (@ATETEPEYORG, @MOD_AGI,             3),
    (@ATETEPEYORG, @MOD_MND,             3),
    (@ATETEPEYORG, @MOD_WATER_RES,      20),
    (@ATETEPEYORG, @MOD_MARKSMAN_SKILL,  3),
    (@ATETEPEYORG, @MOD_RACC,            5),
    (@ATETEPEYORG, @MOD_MACC,            5),
    (@ATETEPEYORG, @MOD_MATT,            5),
    (@ATETEPEYORG, @MOD_ENMITY,         -5);

UPDATE `item_weapon` SET dmg = 18 WHERE itemId = @MAOCHINOLI;
UPDATE `item_equipment` SET jobs = @MNK+@PUP WHERE itemId = @MAOCHINOLI;
DELETE FROM `item_mods` WHERE itemId = @MAOCHINOLI;
INSERT INTO `item_mods` VALUES
    (@MAOCHINOLI, @MOD_STR,         3),
    (@MAOCHINOLI, @MOD_DEX,         3),
    (@MAOCHINOLI, @MOD_FIRE_RES,   20),
    (@MAOCHINOLI, @MOD_ATT,         5),
    (@MAOCHINOLI, @MOD_EVA,         5),
    (@MAOCHINOLI, @MOD_HTH_SKILL,   3),
    (@MAOCHINOLI, @MOD_GUARD_SKILL, 5),
    (@MAOCHINOLI, @MOD_STORE_TP,    3);

DELETE FROM `item_mods_pet` WHERE itemId = @MAOCHINOLI;
INSERT INTO `item_mods_pet` VALUES
    (@MAOCHINOLI, @MOD_REGEN,      1, @PET_ALL),
    (@MAOCHINOLI, @MOD_DOUBLE_ATK, 2, @PET_ALL);

UPDATE `item_weapon` SET dmg = 41 WHERE itemId = @XIUTLEATO;
UPDATE `item_equipment` SET jobs = 2195537 WHERE itemId = @XIUTLEATO;
DELETE FROM `item_mods` WHERE itemId = @XIUTLEATO;
INSERT INTO `item_mods` VALUES
    (@XIUTLEATO, @MOD_STR,               3),
    (@XIUTLEATO, @MOD_VIT,               3),
    (@XIUTLEATO, @MOD_FIRE_RES,         20),
    (@XIUTLEATO, @MOD_SWORD_SKILL,       3),
    (@XIUTLEATO, @MOD_SHIELD_SKILL,      3),
    (@XIUTLEATO, @MOD_MACC,              2),
    (@XIUTLEATO, @MOD_PHYS_DMG_TAKEN, -200);

UPDATE `item_weapon` SET dmg = 31 WHERE itemId = @TAMAXCHI;
UPDATE `item_equipment` SET jobs = 3850780 WHERE itemId = @TAMAXCHI;
DELETE FROM `item_mods` WHERE itemId = @TAMAXCHI;
INSERT INTO `item_mods` VALUES
    (@TAMAXCHI, @MOD_INT,           3),
    (@TAMAXCHI, @MOD_MND,           3),
    (@TAMAXCHI, @MOD_EARTH_RES,    20),
    (@TAMAXCHI, @MOD_MATT,          5),
    (@TAMAXCHI, @MOD_CLUB_SKILL,    3),
    (@TAMAXCHI, @MOD_MACC,          2),
    (@TAMAXCHI, @MOD_CURE_POTENCY, 10);

UPDATE `item_weapon` SET dmg = 93 WHERE itemId = @IXTAB;
UPDATE `item_equipment` SET jobs = 2097281 WHERE itemId = @IXTAB;
DELETE FROM `item_mods` WHERE itemId = @IXTAB;
INSERT INTO `item_mods` VALUES
    (@IXTAB, @MOD_STR,         3),
    (@IXTAB, @MOD_VIT,         3),
    (@IXTAB, @MOD_EARTH_RES,  20),
    (@IXTAB, @MOD_GAXE_SKILL,  3),
    (@IXTAB, @MOD_STORE_TP,    5);

UPDATE `item_weapon` SET dmg = 93 WHERE itemId = @XBALANQUE;
UPDATE `item_equipment` SET jobs = 393 WHERE itemId = @XBALANQUE;
DELETE FROM `item_mods` WHERE itemId = @XBALANQUE;
INSERT INTO `item_mods` VALUES
    (@XBALANQUE, @MOD_STR,           3),
    (@XBALANQUE, @MOD_DEX,           3),
    (@XBALANQUE, @MOD_THUNDER_RES,  20),
    (@XBALANQUE, @MOD_ATT,           5),
    (@XBALANQUE, @MOD_SCYTHE_SKILL,  3),
    (@XBALANQUE, @MOD_MACC,          4),
    (@XBALANQUE, @MOD_DOUBLE_ATK,    2);

UPDATE `item_weapon` SET dmg = 46 WHERE itemId = @HUNAHPU;
UPDATE `item_equipment` SET jobs = 256 WHERE itemId = @HUNAHPU;
DELETE FROM `item_mods` WHERE itemId = @HUNAHPU;
INSERT INTO `item_mods` VALUES
    (@HUNAHPU, @MOD_STR,           3),
    (@HUNAHPU, @MOD_DEX,           3),
    (@HUNAHPU, @MOD_THUNDER_RES,  20),
    (@HUNAHPU, @MOD_AXE_SKILL,     3);

DELETE FROM `item_mods_pet` WHERE itemId = @HUNAHPU;
INSERT INTO `item_mods_pet` VALUES
    (@HUNAHPU, @MOD_ACC,   5, @PET_ALL),
    (@HUNAHPU, @MOD_HASTE, 1, @PET_ALL);

UPDATE `item_weapon` SET dmg = 83 WHERE itemId = @KAQULJAAN;
UPDATE `item_equipment` SET jobs = 2097345 WHERE itemId = @KAQULJAAN;
DELETE FROM `item_mods` WHERE itemId = @KAQULJAAN;
INSERT INTO `item_mods` VALUES
    (@KAQULJAAN, @MOD_STR,          3),
    (@KAQULJAAN, @MOD_DEX,          3),
    (@KAQULJAAN, @MOD_THUNDER_RES, 20),
    (@KAQULJAAN, @MOD_ATT,          5),
    (@KAQULJAAN, @MOD_MATT,         5),
    (@KAQULJAAN, @MOD_GSWORD_SKILL, 3),
    (@KAQULJAAN, @MOD_PARRY_SKILL,  5),
    (@KAQULJAAN, @MOD_MACC,         4),
    (@KAQULJAAN, @MOD_DOUBLE_ATK,   2);

UPDATE `item_weapon` SET dmg = 80 WHERE itemId = @ANIMIKII_BULLET;
UPDATE `item_equipment` SET jobs = 66560 WHERE itemId = @ANIMIKII_BULLET;
DELETE FROM `item_mods` WHERE itemId = @ANIMIKII_BULLET;
INSERT INTO `item_mods` VALUES
    (@ANIMIKII_BULLET, @MOD_RACC, 25),
    (@ANIMIKII_BULLET, @MOD_MACC, 10),
    (@ANIMIKII_BULLET, @MOD_MATT,  5);

UPDATE `item_weapon` SET dmg = 76 WHERE itemId = @AJJUB_BOW;
UPDATE `item_equipment` SET jobs = 3072 WHERE itemId = @AJJUB_BOW;
DELETE FROM `item_mods` WHERE itemId = @AJJUB_BOW;
INSERT INTO `item_mods` VALUES
    (@AJJUB_BOW, @MOD_AGI,            6),
    (@AJJUB_BOW, @MOD_ICE_RES,       20),
    (@AJJUB_BOW, @MOD_ARCHERY_SKILL,  3),
    (@AJJUB_BOW, @MOD_RACC,           5),
    (@AJJUB_BOW, @MOD_RATT,           5),
    (@AJJUB_BOW, @MOD_RAPID_SHOT,     5);

UPDATE `item_weapon` SET dmg = 57 WHERE itemId = @BAQIL_STAFF;
UPDATE `item_equipment` SET jobs = 1589788 WHERE itemId = @BAQIL_STAFF;
DELETE FROM `item_mods` WHERE itemId = @BAQIL_STAFF;
INSERT INTO `item_mods` VALUES
    (@BAQIL_STAFF, @MOD_MP,                  10),
    (@BAQIL_STAFF, @MOD_INT,                  3),
    (@BAQIL_STAFF, @MOD_MND,                  3),
    (@BAQIL_STAFF, @MOD_ICE_RES,             20),
    (@BAQIL_STAFF, @MOD_OCCULT_ACUMEN,       20),
    (@BAQIL_STAFF, @MOD_STAFF_SKILL,          3),
    (@BAQIL_STAFF, @MOD_ACC,                  6),
    (@BAQIL_STAFF, @MOD_MACC,                 4),
    (@BAQIL_STAFF, @MOD_AVATAR_PERP,          2),
    (@BAQIL_STAFF, @MOD_FIRE_AFFINITY_DMG,    2),
    (@BAQIL_STAFF, @MOD_ICE_AFFINITY_DMG,     2),
    (@BAQIL_STAFF, @MOD_WIND_AFFINITY_DMG,    2),
    (@BAQIL_STAFF, @MOD_EARTH_AFFINITY_DMG,   2),
    (@BAQIL_STAFF, @MOD_THUNDER_AFFINITY_DMG, 2),
    (@BAQIL_STAFF, @MOD_WATER_AFFINITY_DMG,   2),
    (@BAQIL_STAFF, @MOD_LIGHT_AFFINITY_DMG,   2),
    (@BAQIL_STAFF, @MOD_DARK_AFFINITY_DMG,    2),
    (@BAQIL_STAFF, @MOD_FIRE_AFFINITY_ACC,    2),
    (@BAQIL_STAFF, @MOD_ICE_AFFINITY_ACC,     2),
    (@BAQIL_STAFF, @MOD_WIND_AFFINITY_ACC,    2),
    (@BAQIL_STAFF, @MOD_EARTH_AFFINITY_ACC,   2),
    (@BAQIL_STAFF, @MOD_THUNDER_AFFINITY_ACC, 2),
    (@BAQIL_STAFF, @MOD_WATER_AFFINITY_ACC,   2),
    (@BAQIL_STAFF, @MOD_LIGHT_AFFINITY_ACC,   2),
    (@BAQIL_STAFF, @MOD_DARK_AFFINITY_ACC,    2);

DELETE FROM `item_mods_pet` WHERE itemId = @BAQIL_STAFF;
INSERT INTO `item_mods_pet` VALUES
    (@BAQIL_STAFF, @MOD_REGEN,      1, @PET_ALL),
    (@BAQIL_STAFF, @MOD_DOUBLE_ATK, 2, @PET_ALL);

UPDATE `item_equipment` SET jobs = 1048576 WHERE itemId = @NEPOTE_BELL;
DELETE FROM `item_mods` WHERE itemId = @NEPOTE_BELL;
INSERT INTO `item_mods` VALUES
    (@NEPOTE_BELL, @MOD_MP,             20),
    (@NEPOTE_BELL, @MOD_INT,             2),
    (@NEPOTE_BELL, @MOD_HANDBELL_SKILL,  6);

DELETE FROM `item_mods_pet` WHERE itemId = @NEPOTE_BELL;
INSERT INTO `item_mods_pet` VALUES
    (@NEPOTE_BELL, @MOD_DAMAGE_TAKEN, -100, @PET_LUOPAN);

UPDATE `item_basic` SET aH = 14 WHERE itemId = @NEPOTE_BELL; -- Weapons->Instruments

--
-- Oboro Weapons
--

SET @MINOS           = 20860;
SET @NYEPEL          = 20534;
SET @SINDRI          = 21110;
SET @KALADANDA       = 21173;
SET @EGEKING         = 20720;
SET @SANDUNG         = 20618;
SET @PRIWEN          = 28648;
SET @CRONUS          = 20904;
SET @ARKTOI          = 20811;
SET @TERPANDER       = 21407;
SET @LIONSQUALL      = 21277;
SET @KURIKARANOTACHI = 21039;
SET @SHIGI           = 20994;
SET @AREADBHAR       = 20948;
SET @GRIDARVOR       = 21174;
SET @MIMESIS         = 20721;
SET @DEATHLOCKE      = 21278;
SET @OHTAS           = 20535;
SET @POLYHYMNIA      = 20619;
SET @COEUS           = 21175;
SET @DUNNA           = 21372;
SET @AETTIR          = 20761;

UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId IN (
    @MINOS, @NYEPEL, @SINDRI, @KALADANDA, @EGEKING, @SANDUNG,
    @PRIWEN, @CRONUS, @ARKTOI, @TERPANDER, @LIONSQUALL, @KURIKARANOTACHI,
    @SHIGI, @AREADBHAR, @GRIDARVOR, @MIMESIS, @DEATHLOCKE, @OHTAS,
    @POLYHYMNIA, @COEUS, @DUNNA, @AETTIR
);

UPDATE `item_weapon` SET ilvl_skill = 0, ilvl_parry = 0, ilvl_macc = 0 WHERE itemId IN (
    @MINOS, @NYEPEL, @SINDRI, @KALADANDA, @EGEKING, @SANDUNG,
    @PRIWEN, @CRONUS, @ARKTOI, @TERPANDER, @LIONSQUALL, @KURIKARANOTACHI,
    @SHIGI, @AREADBHAR, @GRIDARVOR, @MIMESIS, @DEATHLOCKE, @OHTAS,
    @POLYHYMNIA, @COEUS, @DUNNA, @AETTIR
);

-- Clear ITEM_FLAG_MYSTERY_BOX from item
UPDATE item_basic SET
    item_basic.flags = item_basic.flags & ~0x0004
WHERE (item_basic.flags & 0x0004) AND item_basic.itemId IN(
    @MINOS, @NYEPEL, @SINDRI, @KALADANDA, @EGEKING, @SANDUNG,
    @PRIWEN, @CRONUS, @ARKTOI, @TERPANDER, @LIONSQUALL, @KURIKARANOTACHI,
    @SHIGI, @AREADBHAR, @GRIDARVOR, @MIMESIS, @DEATHLOCKE, @OHTAS,
    @POLYHYMNIA, @COEUS, @DUNNA, @AETTIR
);

UPDATE `item_weapon`    SET dmg = 95 WHERE itemId = @MINOS;
DELETE FROM `item_mods` WHERE itemId = @MINOS;
INSERT INTO `item_mods` VALUES
    (@MINOS, @MOD_HP,         20),
    (@MINOS, @MOD_VIT,         6),
    (@MINOS, @MOD_ATT,         8),
    (@MINOS, @MOD_ENMITY,      4),
    (@MINOS, @MOD_DOUBLE_ATK,  3),
    (@MINOS, @MOD_RETALIATION, 3);

UPDATE `item_weapon`    SET dmg  = 20 WHERE itemId = @NYEPEL;
DELETE FROM `item_mods` WHERE itemId = @NYEPEL;
INSERT INTO `item_mods` VALUES
    (@NYEPEL, @MOD_HP,          35),
    (@NYEPEL, @MOD_STR,          4),
    (@NYEPEL, @MOD_VIT,          4),
    (@NYEPEL, @MOD_ATT,          8),
    (@NYEPEL, @MOD_ENMITY,       4),
    (@NYEPEL, @MOD_STORE_TP,     5),
    (@NYEPEL, @MOD_COUNTER,      6),
    (@NYEPEL, @MOD_GUARD_SKILL, 15);

UPDATE `item_weapon`    SET dmg = 49 WHERE itemId = @SINDRI;
DELETE FROM `item_mods` WHERE itemId = @SINDRI;
INSERT INTO `item_mods` VALUES
    (@SINDRI, @MOD_MP,             15),
    (@SINDRI, @MOD_MND,             6),
    (@SINDRI, @MOD_ACC,             8),
    (@SINDRI, @MOD_MACC,            4),
    (@SINDRI, @MOD_ENMITY,         -4),
    (@SINDRI, @MOD_DOUBLE_ATK,      3),
    (@SINDRI, @MOD_CURE2MP_PERCENT, 1);

UPDATE `item_weapon`    SET dmg = 58 WHERE itemId = @KALADANDA;
DELETE FROM `item_mods` WHERE itemId = @KALADANDA;
INSERT INTO `item_mods` VALUES
    (@KALADANDA, @MOD_MP,                  20),
    (@KALADANDA, @MOD_STR,                  6),
    (@KALADANDA, @MOD_DEX,                  6),
    (@KALADANDA, @MOD_VIT,                  6),
    (@KALADANDA, @MOD_AGI,                  6),
    (@KALADANDA, @MOD_INT,                  6),
    (@KALADANDA, @MOD_MND,                  6),
    (@KALADANDA, @MOD_CHR,                  6),
    (@KALADANDA, @MOD_ATT,                  8),
    (@KALADANDA, @MOD_FIRE_RES,            20),
    (@KALADANDA, @MOD_ICE_RES,             20),
    (@KALADANDA, @MOD_WIND_RES,            20),
    (@KALADANDA, @MOD_EARTH_RES,           20),
    (@KALADANDA, @MOD_THUNDER_RES,         20),
    (@KALADANDA, @MOD_WATER_RES,           20),
    (@KALADANDA, @MOD_LIGHT_RES,           20),
    (@KALADANDA, @MOD_DARK_RES,            20),
    (@KALADANDA, @MOD_OCCULT_ACUMEN,       50),
    (@KALADANDA, @MOD_ELEMENTAL_CELERITY,   8),
    (@KALADANDA, @MOD_IRIDESCENCE,          2),
    (@KALADANDA, @MOD_FIRE_AFFINITY_DMG,    3),
    (@KALADANDA, @MOD_ICE_AFFINITY_DMG,     3),
    (@KALADANDA, @MOD_WIND_AFFINITY_DMG,    3),
    (@KALADANDA, @MOD_EARTH_AFFINITY_DMG,   3),
    (@KALADANDA, @MOD_THUNDER_AFFINITY_DMG, 3),
    (@KALADANDA, @MOD_WATER_AFFINITY_DMG,   3),
    (@KALADANDA, @MOD_LIGHT_AFFINITY_DMG,   3),
    (@KALADANDA, @MOD_DARK_AFFINITY_DMG,    3),
    (@KALADANDA, @MOD_FIRE_AFFINITY_ACC,    3),
    (@KALADANDA, @MOD_ICE_AFFINITY_ACC,     3),
    (@KALADANDA, @MOD_WIND_AFFINITY_ACC,    3),
    (@KALADANDA, @MOD_EARTH_AFFINITY_ACC,   3),
    (@KALADANDA, @MOD_THUNDER_AFFINITY_ACC, 3),
    (@KALADANDA, @MOD_WATER_AFFINITY_ACC,   3),
    (@KALADANDA, @MOD_LIGHT_AFFINITY_ACC,   3),
    (@KALADANDA, @MOD_DARK_AFFINITY_ACC,    3);

UPDATE `item_weapon`    SET dmg = 43 WHERE itemId = @EGEKING;
DELETE FROM `item_mods` WHERE itemId = @EGEKING;
INSERT INTO `item_mods` VALUES
    (@EGEKING, @MOD_HP,               15),
    (@EGEKING, @MOD_MP,               15),
    (@EGEKING, @MOD_STR,               4),
    (@EGEKING, @MOD_MND,               4),
    (@EGEKING, @MOD_ACC,               8),
    (@EGEKING, @MOD_MACC,              4),
    (@EGEKING, @MOD_MATT,              4),
    (@EGEKING, @MOD_ENMITY,           -4),
    (@EGEKING, @MOD_PHALANX,           3),
    (@EGEKING, @MOD_ENSPELL_DMG_BONUS, 6);

UPDATE `item_weapon`    SET dmg = 35 WHERE itemId = @SANDUNG;
DELETE FROM `item_mods` WHERE itemId = @SANDUNG;
INSERT INTO `item_mods` VALUES
    (@SANDUNG, @MOD_HP,         15),
    (@SANDUNG, @MOD_DEX,         4),
    (@SANDUNG, @MOD_AGI,         4),
    (@SANDUNG, @MOD_ACC,         8),
    (@SANDUNG, @MOD_EVA,         5),
    (@SANDUNG, @MOD_ENMITY,      4),
    (@SANDUNG, @MOD_TRIPLE_ATK,  1),
    (@SANDUNG, 431,              2), -- ITEM_ADDEFFECT_TYPE: 2
    (@SANDUNG, 499,             13), -- ITEM_SUBEFFECT: 13
    (@SANDUNG, 501,             10), -- ITEM_ADDEFFECT_CHANCE: 10
    (@SANDUNG, 951,              6), -- ITEM_ADDEFFECT_STATUS: 6
    (@SANDUNG, 952,             10), -- ITEM_ADDEFFECT_POWER: 10
    (@SANDUNG, 953,             15); -- ITEM_ADDEFFECT_DURATION: 15

DELETE FROM `item_mods` WHERE itemId = @PRIWEN;
INSERT INTO `item_mods` VALUES
    (@PRIWEN, @MOD_DEF,                   30),
    (@PRIWEN, @MOD_HP,                    20),
    (@PRIWEN, @MOD_PHALANX,                1),
    (@PRIWEN, @MOD_PHYS_DMG_TAKEN,      -300),
    (@PRIWEN, @MOD_REPRISAL_BLOCK_BONUS,   2),
    (@PRIWEN, @MOD_REPRISAL_SPIKES_BONUS, 50),
    (@PRIWEN, @MOD_REGEN,                  1);

UPDATE `item_weapon`    SET dmg = 99 WHERE itemId = @CRONUS;
DELETE FROM `item_mods` WHERE itemId = @CRONUS;
INSERT INTO `item_mods` VALUES
    (@CRONUS, @MOD_HP,        15),
    (@CRONUS, @MOD_MP,        15),
    (@CRONUS, @MOD_STR,        4),
    (@CRONUS, @MOD_INT,        4),
    (@CRONUS, @MOD_ATK,       12),
    (@CRONUS, @MOD_MACC,       6),
    (@CRONUS, @MOD_ENMITY,    -4),
    (@CRONUS, 431,             5), -- ITEM_ADDEFFECT_TYPE: 5
    (@CRONUS, 499,            21), -- ITEM_SUBEFFECT: 21
    (@CRONUS, 500,            10), -- ITEM_ADDEFFECT_DMG: 20
    (@CRONUS, 501,            10), -- ITEM_ADDEFFECT_CHANCE: 10
    (@CRONUS, 950,             8), -- ITEM_ADDEFFECT_ELEMENT: 8
    (@CRONUS, @MOD_REFRESH,    1);

UPDATE `item_weapon`    SET dmg = 48 WHERE itemId = @ARKTOI;
DELETE FROM `item_mods` WHERE itemId = @ARKTOI;
INSERT INTO `item_mods` VALUES
    (@ARKTOI, @MOD_HP,             20),
    (@ARKTOI, @MOD_STR,             5),
    (@ARKTOI, @MOD_CHR,             5),
    (@ARKTOI, @MOD_ATK,            10),
    (@ARKTOI, @MOD_ENMITY,         -5),
    (@ARKTOI, @MOD_VERMIN_KILLER,   5),
    (@ARKTOI, @MOD_BIRD_KILLER,     5),
    (@ARKTOI, @MOD_AMORPH_KILLER,   5),
    (@ARKTOI, @MOD_LIZARD_KILLER,   5),
    (@ARKTOI, @MOD_AQUAN_KILLER,    5),
    (@ARKTOI, @MOD_PLANTOID_KILLER, 5),
    (@ARKTOI, @MOD_BEAST_KILLER,    5),
    (@ARKTOI, @MOD_UNDEAD_KILLER,   5),
    (@ARKTOI, @MOD_ARCANA_KILLER,   5),
    (@ARKTOI, @MOD_DRAGON_KILLER,   5),
    (@ARKTOI, @MOD_DEMON_KILLER,    5),
    (@ARKTOI, @MOD_EMPTY_KILLER,    5),
    (@ARKTOI, @MOD_HUMANOID_KILLER, 5),
    (@ARKTOI, @MOD_LUMINIAN_KILLER, 5),
    (@ARKTOI, @MOD_LUMINION_KILLER, 5);

DELETE FROM `item_mods_pet` WHERE itemId = @ARKTOI;
INSERT INTO `item_mods_pet` VALUES
    (@ARKTOI, @MOD_ATT,        8, @PET_ALL),
    (@ARKTOI, @MOD_DOUBLE_ATK, 3, @PET_ALL);

DELETE FROM `item_mods` WHERE itemId = @TERPANDER;
INSERT INTO `item_mods` VALUES
    (@TERPANDER, @MOD_HP,            15),
    (@TERPANDER, @MOD_MP,            15),
    (@TERPANDER, @MOD_ENMITY,        -4),
    (@TERPANDER, @MOD_STRING_SKILL,   8),
    (@TERPANDER, @MOD_LULLABY_EFFECT, 3),
    (@TERPANDER, @MOD_BALLAD_EFFECT,  2);

UPDATE `item_weapon`    SET dmg = 42 WHERE itemId = @LIONSQUALL;
DELETE FROM `item_mods` WHERE itemId = @LIONSQUALL;
INSERT INTO `item_mods` VALUES
    (@LIONSQUALL, @MOD_HP,         20),
    (@LIONSQUALL, @MOD_RATT,       15),
    (@LIONSQUALL, @MOD_MATT,        8),
    (@LIONSQUALL, @MOD_ENMITY,     -4),
    (@LIONSQUALL, @MOD_RAPID_SHOT,  5),
    (@LIONSQUALL, @MOD_STORE_TP,    5);

UPDATE `item_weapon`    SET dmg = 82 WHERE itemId = @KURIKARANOTACHI;
DELETE FROM `item_mods` WHERE itemId = @KURIKARANOTACHI;
INSERT INTO `item_mods` VALUES
    (@KURIKARANOTACHI, @MOD_HP,            20),
    (@KURIKARANOTACHI, @MOD_STR,            4),
    (@KURIKARANOTACHI, @MOD_AGI,            4),
    (@KURIKARANOTACHI, @MOD_ATT,            8),
    (@KURIKARANOTACHI, @MOD_RATT,           8),
    (@KURIKARANOTACHI, @MOD_ENMITY,        -4),
    (@KURIKARANOTACHI, @MOD_ZANSHIN,        4),
    (@KURIKARANOTACHI, @MOD_SKILLCHAIN_DMG, 4);

UPDATE `item_weapon`    SET dmg = 32 WHERE itemId = @SHIGI;
DELETE FROM `item_mods` WHERE itemId = @SHIGI;
INSERT INTO `item_mods` VALUES
    (@SHIGI, @MOD_HP,        20),
    (@SHIGI, @MOD_DEX,        6),
    (@SHIGI, @MOD_ATT,        8),
    (@SHIGI, @MOD_RATT,       8),
    (@SHIGI, @MOD_MATT,       8),
    (@SHIGI, @MOD_ENMITY,     4),
    (@SHIGI, @MOD_STORE_TP,   5),
    (@SHIGI, @MOD_NINJA_TOOL, 5);

UPDATE `item_weapon`    SET dmg = 94 WHERE itemId = @AREADBHAR;
DELETE FROM `item_mods` WHERE itemId = @AREADBHAR;
INSERT INTO `item_mods` VALUES
    (@AREADBHAR, @MOD_HP,                20),
    (@AREADBHAR, @MOD_STR,                4),
    (@AREADBHAR, @MOD_VIT,                4),
    (@AREADBHAR, @MOD_ATT,                8),
    (@AREADBHAR, @MOD_ENMITY,            -4),
    (@AREADBHAR, @MOD_JUMP_TP_BONUS,     30),
    (@AREADBHAR, @MOD_JUMP_DOUBLE_ATTACK, 3);
    
DELETE FROM `item_mods_pet` WHERE itemId = @AREADBHAR;
INSERT INTO `item_mods_pet` VALUES
    (@AREADBHAR, @MOD_ACC,             8, @PET_ALL),
    (@AREADBHAR, @MOD_DAMAGE_TAKEN, -300, @PET_ALL);

UPDATE `item_weapon`    SET dmg = 60 WHERE itemId = @GRIDARVOR;
DELETE FROM `item_mods` WHERE itemId = @GRIDARVOR;
INSERT INTO `item_mods` VALUES
    (@GRIDARVOR, @MOD_MP,           35),
    (@GRIDARVOR, @MOD_INT,           6),
    (@GRIDARVOR, @MOD_MND,           6),
    (@GRIDARVOR, @MOD_ACC,           8),
    (@GRIDARVOR, @MOD_ENMITY,       -4),
    (@GRIDARVOR, @MOD_IRIDESCENCE,   3),
    (@GRIDARVOR, @MOD_DOUBLE_ATK,    3),
    (@GRIDARVOR, @MOD_DAY_REDUCTION, 5);
    
DELETE FROM `item_mods_pet` WHERE itemId = @GRIDARVOR;
INSERT INTO `item_mods_pet` VALUES
    (@GRIDARVOR, @MOD_ACC,   8, @PET_ALL),
    (@GRIDARVOR, @MOD_HASTE, 4, @PET_ALL);

UPDATE `item_weapon`    SET dmg = 43 WHERE itemId = @MIMESIS;
DELETE FROM `item_mods` WHERE itemId = @MIMESIS;
INSERT INTO `item_mods` VALUES
    (@MIMESIS, @MOD_HP,        15),
    (@MIMESIS, @MOD_MP,        15),
    (@MIMESIS, @MOD_STR,        6),
    (@MIMESIS, @MOD_INT,        6),
    (@MIMESIS, @MOD_MND,        6),
    (@MIMESIS, @MOD_ACC,        8),
    (@MIMESIS, @MOD_MATT,       4),
    (@MIMESIS, @MOD_MACC,       4),
    (@MIMESIS, @MOD_ENMITY,     4),
    (@MIMESIS, @MOD_FASTCAST,   5);

UPDATE `item_weapon`    SET dmg = 35 WHERE itemId = @DEATHLOCKE;
DELETE FROM `item_mods` WHERE itemId = @DEATHLOCKE;
INSERT INTO `item_mods` VALUES
    (@DEATHLOCKE, @MOD_HP,              15),
    (@DEATHLOCKE, @MOD_MP,              15),
    (@DEATHLOCKE, @MOD_AGI,              6),
    (@DEATHLOCKE, @MOD_RACC,             8),
    (@DEATHLOCKE, @MOD_MACC,             5),
    (@DEATHLOCKE, @MOD_MATT,             5),
    (@DEATHLOCKE, @MOD_ENMITY,          -4),
    (@DEATHLOCKE, @MOD_RAPID_SHOT,       5),
    (@DEATHLOCKE, @MOD_STORE_TP,         5);

UPDATE `item_weapon`    SET dmg = 20 WHERE itemId = @OHTAS;
DELETE FROM `item_mods` WHERE itemId = @OHTAS;
INSERT INTO `item_mods` VALUES
    (@OHTAS, @MOD_HP,             20),
    (@OHTAS, @MOD_DEX,             4),
    (@OHTAS, @MOD_AGI,             4),
    (@OHTAS, @MOD_ACC,             8),
    (@OHTAS, @MOD_ENMITY,         -4),
    (@OHTAS, @MOD_REPAIR_POTENCY, 10);
    
DELETE FROM `item_mods_pet` WHERE itemId = @OHTAS;
INSERT INTO `item_mods_pet` VALUES
    (@OHTAS, @MOD_ACC,        8, @PET_ALL),
    (@OHTAS, @MOD_RACC,       8, @PET_ALL),
    (@OHTAS, @MOD_DOUBLE_ATK, 3, @PET_ALL);

UPDATE `item_weapon`    SET dmg = 35 WHERE itemId = @POLYHYMNIA;
DELETE FROM `item_mods` WHERE itemId = @POLYHYMNIA;
INSERT INTO `item_mods` VALUES
    (@POLYHYMNIA, @MOD_HP,             20),
    (@POLYHYMNIA, @MOD_DEX,             4),
    (@POLYHYMNIA, @MOD_AGI,             4),
    (@POLYHYMNIA, @MOD_ACC,             8),
    (@POLYHYMNIA, @MOD_EVA,             5),
    (@POLYHYMNIA, @MOD_ENMITY,          4),
    (@POLYHYMNIA, @MOD_DAMAGE_TAKEN, -300),
    (@POLYHYMNIA, @MOD_SAMBA_DURATION, 20);

UPDATE `item_weapon`    SET dmg = 58 WHERE itemId = @COEUS;
DELETE FROM `item_mods` WHERE itemId = @COEUS;
INSERT INTO `item_mods` VALUES
    (@COEUS, @MOD_MP,                   40),
    (@COEUS, @MOD_INT,                   8),
    (@COEUS, @MOD_ENMITY,               -4),
    (@COEUS, @MOD_REGEN_DURATION,       20),
    (@COEUS, @MOD_GRIMOIRE_SPELLCASTING, 8),
    (@COEUS, @MOD_CONSERVE_MP,           8),
    (@COEUS, @MOD_IRIDESCENCE,           2),
    (@COEUS, @MOD_FIRE_AFFINITY_DMG,     3),
    (@COEUS, @MOD_ICE_AFFINITY_DMG,      3),
    (@COEUS, @MOD_WIND_AFFINITY_DMG,     3),
    (@COEUS, @MOD_EARTH_AFFINITY_DMG,    3),
    (@COEUS, @MOD_THUNDER_AFFINITY_DMG,  3),
    (@COEUS, @MOD_WATER_AFFINITY_DMG,    3),
    (@COEUS, @MOD_LIGHT_AFFINITY_DMG,    3),
    (@COEUS, @MOD_DARK_AFFINITY_DMG,     3),
    (@COEUS, @MOD_FIRE_AFFINITY_ACC,     3),
    (@COEUS, @MOD_ICE_AFFINITY_ACC,      3),
    (@COEUS, @MOD_WIND_AFFINITY_ACC,     3),
    (@COEUS, @MOD_EARTH_AFFINITY_ACC,    3),
    (@COEUS, @MOD_THUNDER_AFFINITY_ACC,  3),
    (@COEUS, @MOD_WATER_AFFINITY_ACC,    3),
    (@COEUS, @MOD_LIGHT_AFFINITY_ACC,    3),
    (@COEUS, @MOD_DARK_AFFINITY_ACC,     3);

UPDATE `item_equipment` SET jobs = 1048576 WHERE itemId = @DUNNA;
DELETE FROM `item_mods` WHERE itemId = @DUNNA;
INSERT INTO `item_mods` VALUES
    (@DUNNA, @MOD_MP,              25),
    (@DUNNA, @MOD_INT,              4),
    (@DUNNA, @MOD_ENMITY,          -4),
    (@DUNNA, @MOD_HANDBELL_SKILL,  15);

DELETE FROM `item_mods_pet` WHERE itemId = @DUNNA;
INSERT INTO `item_mods_pet` VALUES
    (@DUNNA, @MOD_DAMAGE_TAKEN, -300, @PET_LUOPAN);

UPDATE `item_weapon`    SET dmg = 85 WHERE itemId = @AETTIR;
DELETE FROM `item_mods` WHERE itemId = @AETTIR;
INSERT INTO `item_mods` VALUES
    (@AETTIR, @MOD_HP,                  20),
    (@AETTIR, @MOD_MP,                  15),
    (@AETTIR, @MOD_DEX,                  4),
    (@AETTIR, @MOD_AGI,                  4),
    (@AETTIR, @MOD_ACC,                  8),
    (@AETTIR, @MOD_ENMITY,               5),
    (@AETTIR, @MOD_SWIPE,                5),
    (@AETTIR, @MOD_MAGIC_DMG_TAKEN_II, 500);
