-- Base drop rates
SET @ALWAYS   = 1000; -- Always,      100%
SET @VCOMMON  = 240;  -- Very common,  24%
SET @COMMON   = 150;  -- Common,       15%
SET @UNCOMMON = 100;  -- Uncommon,     10%
SET @RARE     = 50;   -- Rare,          5%
SET @VRARE    = 10;   -- Very rare,     1%
SET @SRARE    = 5;    -- Super rare,  0.5%
SET @URARE    = 1;    -- Ultra rare,  0.1%

-- Remainder (For grouped drops)
SET @VCOMMON_R  = 760;  -- Very common (R),   76%
SET @COMMON_R   = 850;  -- Common (R),        85%
SET @UNCOMMON_R = 900;  -- Uncommon (R),      90%
SET @RARE_R     = 950;  -- Rare (R),          95%
SET @VRARE_R    = 990;  -- Very rare (R),     99%
SET @SRARE_R    = 995;  -- Super rare (R),  99.5%
SET @URARE_R    = 999;  -- Ultra rare (R),  99.9%

SET @COLKHAB = 3902;
SET @TCHAKKA = 3903;
SET @ACHUKA  = 3904;
SET @YUMCAX  = 3905;
SET @HURKAN  = 3906;
SET @KUMHAU  = 3907;
SET @HELGA   = 3974;

SET @PEARLSCALE = 5714;
SET @MAYAKOV    = 10151;
SET @MATSUI     = 10132;
SET @BEHEMEAT   = 6416;
SET @WOLFRAM    = 2858;
SET @COBALT     = 2859;
SET @HP_BAYLD   = 8798;
SET @AGED_BOX   = 6267;

UPDATE `mob_groups` SET dropId = @COLKHAB WHERE `name` = 'Colkhab';
UPDATE `mob_groups` SET dropId = @TCHAKKA WHERE `name` = 'Tchakka';
UPDATE `mob_groups` SET dropId = @ACHUKA  WHERE `name` = 'Achuka';
UPDATE `mob_groups` SET dropId = @YUMCAX  WHERE `name` = 'Yumcax';
UPDATE `mob_groups` SET dropId = @HURKAN  WHERE `name` = 'Hurkan';
UPDATE `mob_groups` SET dropId = @KUMHAU  WHERE `name` = 'Kumhau';
UPDATE `mob_groups` SET dropId = @HELGA   WHERE `name` = 'Virava';

DELETE FROM mob_droplist WHERE dropId IN (@COLKHAB, @TCHAKKA, @ACHUKA, @YUMCAX, @YUMCAX, @KUMHAU, @HELGA);
INSERT INTO mob_droplist (dropId, dropType, groupId, groupRate, itemId, itemRate) VALUES
    (@COLKHAB, 1, 1, @ALWAYS, @PEARLSCALE,  @UNCOMMON),  -- Pearlscale                (10%)
    (@COLKHAB, 1, 1, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                 (90%)
    (@COLKHAB, 1, 2, @ALWAYS, @BEHEMEAT,      @COMMON),  -- Behemoth Meat             (15%)
    (@COLKHAB, 1, 2, @ALWAYS, @HP_BAYLD,          840),  -- H-P Bayld                 (84%)
    (@COLKHAB, 1, 2, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)          ( 1%)
    (@COLKHAB, 1, 3, @ALWAYS, @WOLFRAM,      @VCOMMON),  -- Wolfram Steel             (24%)
    (@COLKHAB, 1, 3, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                 (75%)
    (@COLKHAB, 1, 3, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)          ( 1%)
    (@COLKHAB, 1, 4, @ALWAYS, @COBALT,       @VCOMMON),  -- Cobalt Ore                (24%)
    (@COLKHAB, 1, 4, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                 (75%)
    (@COLKHAB, 1, 4, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)          ( 1%)
    (@COLKHAB, 1, 5, @ALWAYS, @HP_BAYLD,    @COMMON_R),  -- H-P Bayld                 (85%)
    (@COLKHAB, 1, 5, @ALWAYS, @AGED_BOX,      @COMMON),  -- Aged Box (Bayld)          (15%)
    (@COLKHAB, 1, 6, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                 (90%)
    (@COLKHAB, 1, 6, @ALWAYS, 3980,             @RARE),  -- Bztavian Stinger          ( 5%)
    (@COLKHAB, 1, 6, @ALWAYS, @AGED_BOX,        @RARE),  -- Aged Box (Bayld)          ( 5%)
    (@COLKHAB, 1, 7, @COMMON, 20820,              333),  -- Hatxiik (Axe)             (15%)
    (@COLKHAB, 1, 7, @COMMON, 20958,              333),  -- Kuakuakait (Polearm)      (15%)
    (@COLKHAB, 1, 7, @COMMON, 20992,              334),  -- Taikogane (Katana)        (15%)

    (@TCHAKKA, 1, 1, @ALWAYS, @PEARLSCALE,  @UNCOMMON),  -- Pearlscale                (10%)
    (@TCHAKKA, 1, 1, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                 (90%)
    (@TCHAKKA, 1, 2, @ALWAYS, @BEHEMEAT,      @COMMON),  -- Behemoth Meat             (15%)
    (@TCHAKKA, 1, 2, @ALWAYS, @HP_BAYLD,          840),  -- H-P Bayld                 (84%)
    (@TCHAKKA, 1, 2, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)          ( 1%)
    (@TCHAKKA, 1, 3, @ALWAYS, @WOLFRAM,      @VCOMMON),  -- Wolfram Steel             (24%)
    (@TCHAKKA, 1, 3, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                 (75%)
    (@TCHAKKA, 1, 3, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)          ( 1%)
    (@TCHAKKA, 1, 4, @ALWAYS, @COBALT,       @VCOMMON),  -- Cobalt Ore                (24%)
    (@TCHAKKA, 1, 4, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                 (75%)
    (@TCHAKKA, 1, 4, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)          ( 1%)
    (@TCHAKKA, 1, 5, @ALWAYS, @HP_BAYLD,    @COMMON_R),  -- H-P Bayld                 (85%)
    (@TCHAKKA, 1, 5, @ALWAYS, @AGED_BOX,      @COMMON),  -- Aged Box (Bayld)          (15%)
    (@TCHAKKA, 1, 6, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                 (90%)
    (@TCHAKKA, 1, 6, @ALWAYS, 3979,             @RARE),  -- Rockfin Tooth             ( 5%)
    (@TCHAKKA, 1, 6, @ALWAYS, @AGED_BOX,        @RARE),  -- Aged Box (Bayld)          ( 5%)
    (@TCHAKKA, 1, 7, @COMMON, 20630,              333),  -- Atoyac (Dagger)           (15%)
    (@TCHAKKA, 1, 7, @COMMON, 21047,              333),  -- Azukinagamitsu (G.Katana) (15%)
    (@TCHAKKA, 1, 7, @COMMON, 21253,              334),  -- Atetepeyorg (Crossbow)    (15%)

    (@ACHUKA, 1, 1, @ALWAYS, @PEARLSCALE,  @UNCOMMON),  -- Pearlscale                 (10%)
    (@ACHUKA, 1, 1, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                  (90%)
    (@ACHUKA, 1, 2, @ALWAYS, @BEHEMEAT,      @COMMON),  -- Behemoth Meat              (15%)
    (@ACHUKA, 1, 2, @ALWAYS, @HP_BAYLD,          840),  -- H-P Bayld                  (84%)
    (@ACHUKA, 1, 2, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@ACHUKA, 1, 3, @ALWAYS, @WOLFRAM,      @VCOMMON),  -- Wolfram Steel              (24%)
    (@ACHUKA, 1, 3, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                  (75%)
    (@ACHUKA, 1, 3, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@ACHUKA, 1, 4, @ALWAYS, @COBALT,       @VCOMMON),  -- Cobalt Ore                 (24%)
    (@ACHUKA, 1, 4, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                  (75%)
    (@ACHUKA, 1, 4, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@ACHUKA, 1, 5, @ALWAYS, @HP_BAYLD,    @COMMON_R),  -- H-P Bayld                  (85%)
    (@ACHUKA, 1, 5, @ALWAYS, @AGED_BOX,      @COMMON),  -- Aged Box (Bayld)           (15%)
    (@ACHUKA, 1, 6, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                  (90%)
    (@ACHUKA, 1, 6, @ALWAYS, 3977,             @RARE),  -- Gabbrath Horn              ( 5%)
    (@ACHUKA, 1, 6, @ALWAYS, @AGED_BOX,        @RARE),  -- Aged Box (Bayld)           ( 5%)
    (@ACHUKA, 1, 7, @COMMON, 20543,              500),  -- Maochinoli (Hand-to-Hand)  (15%)
    (@ACHUKA, 1, 7, @COMMON, 20731,              500),  -- Xiutleato (Sword)          (15%)

    (@YUMCAX, 1, 1, @ALWAYS, @PEARLSCALE,  @UNCOMMON),  -- Pearlscale                 (10%)
    (@YUMCAX, 1, 1, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                  (90%)
    (@YUMCAX, 1, 2, @ALWAYS, @BEHEMEAT,      @COMMON),  -- Behemoth Meat              (15%)
    (@YUMCAX, 1, 2, @ALWAYS, @HP_BAYLD,          840),  -- H-P Bayld                  (84%)
    (@YUMCAX, 1, 2, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@YUMCAX, 1, 3, @ALWAYS, @WOLFRAM,      @VCOMMON),  -- Wolfram Steel              (24%)
    (@YUMCAX, 1, 3, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                  (75%)
    (@YUMCAX, 1, 3, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@YUMCAX, 1, 4, @ALWAYS, @COBALT,       @VCOMMON),  -- Cobalt Ore                 (24%)
    (@YUMCAX, 1, 4, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                  (75%)
    (@YUMCAX, 1, 4, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@YUMCAX, 1, 5, @ALWAYS, @HP_BAYLD,    @COMMON_R),  -- H-P Bayld                  (85%)
    (@YUMCAX, 1, 5, @ALWAYS, @AGED_BOX,      @COMMON),  -- Aged Box (Bayld)           (15%)
    (@YUMCAX, 1, 6, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                  (90%)
    (@YUMCAX, 1, 6, @ALWAYS, 4014,             @RARE),  -- Yggdreant Bole             ( 5%)
    (@YUMCAX, 1, 6, @ALWAYS, @AGED_BOX,        @RARE),  -- Aged Box (Bayld)           ( 5%)
    (@YUMCAX, 1, 7, @COMMON, 21125,              500),  -- Tamaxchi (Club)            (15%)
    (@YUMCAX, 1, 7, @COMMON, 20872,              500),  -- Ixtab (Great Axe)          (15%)

    (@HURKAN, 1, 1, @ALWAYS, @PEARLSCALE,  @UNCOMMON),  -- Pearlscale                 (10%)
    (@HURKAN, 1, 1, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                  (90%)
    (@HURKAN, 1, 2, @ALWAYS, @BEHEMEAT,      @COMMON),  -- Behemoth Meat              (15%)
    (@HURKAN, 1, 2, @ALWAYS, @HP_BAYLD,          840),  -- H-P Bayld                  (84%)
    (@HURKAN, 1, 2, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@HURKAN, 1, 3, @ALWAYS, @WOLFRAM,      @VCOMMON),  -- Wolfram Steel              (24%)
    (@HURKAN, 1, 3, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                  (75%)
    (@HURKAN, 1, 3, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@HURKAN, 1, 4, @ALWAYS, @COBALT,       @VCOMMON),  -- Cobalt Ore                 (24%)
    (@HURKAN, 1, 4, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                  (75%)
    (@HURKAN, 1, 4, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@HURKAN, 1, 5, @ALWAYS, @HP_BAYLD,          700),  -- H-P Bayld                  (70%)
    (@HURKAN, 1, 5, @ALWAYS, @AGED_BOX,      @COMMON),  -- Aged Box (Bayld)           (15%)
    (@HURKAN, 1, 5, @ALWAYS, 21334,          @COMMON),  -- Animikii Bullet (Ammo)     (15%)
    (@HURKAN, 1, 6, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                  (90%)
    (@HURKAN, 1, 6, @ALWAYS, 4012,             @RARE),  -- Waktza Rostrum             ( 5%)
    (@HURKAN, 1, 6, @ALWAYS, @AGED_BOX,        @RARE),  -- Aged Box (Bayld)           ( 5%)
    (@HURKAN, 1, 7, @COMMON, 20917,              333),  -- Xbalanque (Scythe)         (15%)
    (@HURKAN, 1, 7, @COMMON, 20826,              333),  -- Hunahpu (Axe)              (15%)
    (@HURKAN, 1, 7, @COMMON, 20768,              334),  -- Kaquljaan (G.Sword)        (15%)

    (@KUMHAU, 1, 1, @ALWAYS, @PEARLSCALE,  @UNCOMMON),  -- Pearlscale                 (10%)
    (@KUMHAU, 1, 1, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                  (90%)
    (@KUMHAU, 1, 2, @ALWAYS, @BEHEMEAT,      @COMMON),  -- Behemoth Meat              (15%)
    (@KUMHAU, 1, 2, @ALWAYS, @HP_BAYLD,          840),  -- H-P Bayld                  (84%)
    (@KUMHAU, 1, 2, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@KUMHAU, 1, 3, @ALWAYS, @WOLFRAM,      @VCOMMON),  -- Wolfram Steel              (24%)
    (@KUMHAU, 1, 3, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                  (75%)
    (@KUMHAU, 1, 3, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@KUMHAU, 1, 4, @ALWAYS, @COBALT,       @VCOMMON),  -- Cobalt Ore                 (24%)
    (@KUMHAU, 1, 4, @ALWAYS, @HP_BAYLD,          750),  -- H-P Bayld                  (75%)
    (@KUMHAU, 1, 4, @ALWAYS, @AGED_BOX,       @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@HURKAN, 1, 5, @ALWAYS, @HP_BAYLD,          700),  -- H-P Bayld                  (70%)
    (@HURKAN, 1, 5, @ALWAYS, @AGED_BOX,      @COMMON),  -- Aged Box (Bayld)           (15%)
    (@KUMHAU, 1, 5, @COMMON, 21463,          @COMMON),  -- Nepote Bell (Handbell)     (15%)
    (@KUMHAU, 1, 6, @ALWAYS, @HP_BAYLD,  @UNCOMMON_R),  -- H-P Bayld                  (90%)
    (@KUMHAU, 1, 6, @ALWAYS, 8752,             @RARE),  -- Cehuetzi Claw              ( 5%)
    (@KUMHAU, 1, 6, @ALWAYS, @AGED_BOX,        @RARE),  -- Aged Box (Bayld)           ( 5%)
    (@KUMHAU, 1, 7, @COMMON, 21233,              500),  -- Ajjub Bow (Bow)            (15%)
    (@KUMHAU, 1, 7, @COMMON, 21186,              500),  -- Baqil Staff (Staff)        (15%)

    (@HELGA, 1, 1, @ALWAYS, @MAYAKOV,      @COMMON_R),  -- Cipher: Mayakov            (85%)
    (@HELGA, 1, 1, @ALWAYS, @MATSUI,           @RARE),  -- Cipher: Matsui             ( 5%)
    (@HELGA, 1, 1, @ALWAYS, @HP_BAYLD,     @UNCOMMON),  -- H-P Bayld                  (10%)
    (@HELGA, 1, 2, @ALWAYS, @WOLFRAM,       @VCOMMON),  -- Wolfram Steel              (24%)
    (@HELGA, 1, 2, @ALWAYS, @HP_BAYLD,           750),  -- H-P Bayld                  (75%)
    (@HELGA, 1, 2, @ALWAYS, @AGED_BOX,        @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@HELGA, 1, 3, @ALWAYS, @WOLFRAM,       @VCOMMON),  -- Wolfram Steel              (24%)
    (@HELGA, 1, 3, @ALWAYS, @HP_BAYLD,           750),  -- H-P Bayld                  (75%)
    (@HELGA, 1, 3, @ALWAYS, @AGED_BOX,        @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@HELGA, 1, 4, @ALWAYS, @COBALT,        @VCOMMON),  -- Cobalt Ore                 (24%)
    (@HELGA, 1, 4, @ALWAYS, @HP_BAYLD,           750),  -- H-P Bayld                  (75%)
    (@HELGA, 1, 4, @ALWAYS, @AGED_BOX,        @VRARE),  -- Aged Box (Bayld)           ( 1%)
    (@HELGA, 1, 5, @ALWAYS, @HP_BAYLD,    @VCOMMON_R),  -- H-P Bayld                  (76%)
    (@HELGA, 1, 5, @ALWAYS, @AGED_BOX,      @VCOMMON),  -- Aged Box (Bayld)           (24%)
    (@HELGA, 1, 6, @ALWAYS, @HP_BAYLD,           800),  -- H-P Bayld                  (80%)
    (@HELGA, 1, 6, @ALWAYS, @COBALT,         @COMMON),  -- Cobalt Ore                 (15%)
    (@HELGA, 1, 6, @ALWAYS, @AGED_BOX,        @VRARE),  -- Aged Box (Bayld)           ( 5%)
    (@HELGA, 1, 7, @ALWAYS, 3980,             @VRARE),  -- Bztavian Stinger           ( 1%)
    (@HELGA, 1, 7, @ALWAYS, 3979,             @VRARE),  -- Rockfin Tooth              ( 1%)
    (@HELGA, 1, 7, @ALWAYS, 3977,             @VRARE),  -- Gabbrath Horn              ( 1%)
    (@HELGA, 1, 7, @ALWAYS, 4014,             @VRARE),  -- Yggdreant Bole             ( 1%)
    (@HELGA, 1, 7, @ALWAYS, 4012,             @VRARE),  -- Waktza Rostrum             ( 1%)
    (@HELGA, 1, 7, @ALWAYS, 8752,             @VRARE),  -- Cehuetzi Claw              ( 1%)
    (@HELGA, 1, 7, @ALWAYS, @HP_BAYLD,            40),  -- H-P Bayld                  ( 4%)
    (@HELGA, 1, 7, @ALWAYS, @HP_BAYLD,     @COMMON_R),  -- H-P Bayld                  (85%)
    (@HELGA, 1, 7, @ALWAYS, @AGED_BOX,         @RARE);  -- Aged Box (Bayld)           ( 5%)
