-- Drop Rates
SET @ALWAYS = 1000;  -- Always, 100%
SET @VCOMMON = 240;  -- Very common, 24%
SET @COMMON = 150;   -- Common, 15%
SET @UNCOMMON = 100; -- Uncommon, 10%
SET @RARE = 50;      -- Rare, 5%
SET @VRARE = 10;     -- Very rare, 1%
SET @SRARE = 5;      -- Super Rare, 0.5%
SET @URARE = 1;      -- Ultra rare, 0.1%

SET @WAR  =  1;
SET @MNK  =  2;
SET @WHM  =  4;
SET @BLM  =  8;
SET @RDM  = 16;
SET @THF  = 32;
SET @PLD  = 64;
SET @DRK  = 128;
SET @BST  = 256;
SET @BRD  = 512;
SET @RNG  = 1024;
SET @SAM  = 2048;
SET @NIN  = 4096;
SET @DRG  = 8192;
SET @SMN  = 16384;
SET @BLU  = 32768;
SET @COR  = 65536;
SET @PUP  = 131072;
SET @DNC  = 262144;
SET @SCH  = 524288;
SET @GEO  = 1048576;
SET @RUN  = 2097152;

SET @SHIELD_SIZE_1 = 1;
SET @SHIELD_SIZE_2 = 2;
SET @SHIELD_SIZE_3 = 3;
SET @SHIELD_SIZE_4 = 4;
SET @SHIELD_SIZE_5 = 5;

SET @SLOT_MAIN_HAND = 1;
SET @SLOT_OFF_HAND  = 2;
SET @SLOT_AMMO      = 8;

--
-- Mods
--
SET @PET_ALL       = 0;
SET @PET_AVATAR    = 1;
SET @PET_WYVERN    = 2;
SET @PET_AUTOMATON = 3;
SET @PET_LUOPAN    = 8;

SET @MOD_DEF = 1;
SET @MOD_HP  = 2;
SET @MOD_MP  = 5;

SET @MOD_STR =  8;
SET @MOD_DEX =  9;
SET @MOD_VIT = 10;
SET @MOD_AGI = 11;
SET @MOD_INT = 12;
SET @MOD_MND = 13;
SET @MOD_CHR = 14;

SET @MOD_FIRE_RES    = 15;
SET @MOD_ICE_RES     = 16;
SET @MOD_WIND_RES    = 17;
SET @MOD_EARTH_RES   = 18;
SET @MOD_THUNDER_RES = 19;
SET @MOD_WATER_RES   = 20;
SET @MOD_LIGHT_RES   = 21;
SET @MOD_DARK_RES    = 22;

SET @MOD_ATT    = 23;
SET @MOD_RATT   = 24;
SET @MOD_ACC    = 25;
SET @MOD_RACC   = 26;
SET @MOD_ENMITY = 27;
SET @MOD_MATT   = 28;
SET @MOD_MDEF   = 29;
SET @MOD_MACC   = 30;
SET @MOD_EVA    = 31;

SET @MOD_HMP      = 71;
SET @MOD_HHP      = 72;
SET @MOD_STORE_TP = 73;

SET @MOD_HTH_SKILL     = 80;
SET @MOD_DAGGER_SKILL  = 81;
SET @MOD_SWORD_SKILL   = 82;
SET @MOD_GSWORD_SKILL  = 83;
SET @MOD_AXE_SKILL     = 84;
SET @MOD_GAXE_SKILL    = 85;
SET @MOD_SCYTHE_SKILL  = 86;
SET @MOD_POLEARM_SKILL = 87;
SET @MOD_KATANA_SKILL  = 88;
SET @MOD_GKATANA_SKILL = 89;
SET @MOD_CLUB_SKILL    = 90;
SET @MOD_STAFF_SKILL   = 91;

SET @MOD_AUTO_MAGIC_SKILL  = 103;
SET @MOD_ARCHERY_SKILL     = 104;
SET @MOD_MARKSMAN_SKILL    = 105;
SET @MOD_THROWING_SKILL    = 106;

SET @MOD_GUARD_SKILL   = 107;
SET @MOD_EVASION_SKILL = 108;
SET @MOD_SHIELD_SKILL  = 109;
SET @MOD_PARRY_SKILL   = 110;

SET @MOD_DIVINE_SKILL    = 111;
SET @MOD_HEALING_SKILL   = 112;
SET @MOD_ENHANCE_SKILL   = 113;
SET @MOD_ENFEEBLE_SKILL  = 114;
SET @MOD_ELEMENTAL_SKILL = 115;
SET @MOD_DARK_SKILL      = 116;
SET @MOD_SUMMONING_SKILL = 117;
SET @MOD_NINJUTSU_SKILL  = 118;
SET @MOD_SINGING_SKILL   = 119;
SET @MOD_STRING_SKILL    = 120;
SET @MOD_WIND_SKILL      = 121;
SET @MOD_BLUE_SKILL      = 122;
SET @MOD_GEOMANCY_SKILL  = 123;
SET @MOD_HANDBELL_SKILL  = 124;

SET @MOD_DAMAGE_TAKEN        = 160;
SET @MOD_PHYS_DMG_TAKEN      = 161;
SET @MOD_BREATH_DMG_TAKEN    = 162;
SET @MOD_MAGIC_DMG_TAKEN     = 163;
SET @MOD_CRIT_HIT_RATE       = 165;
SET @MOD_MAGIC_DMG_TAKEN_II  = 831;

SET @MOD_FASTCAST    = 170;
SET @MOD_CONSERVE_MP = 296;

SET @MOD_CRITICAL_RATE  = 165;
SET @MOD_SPELL_INTERRUPT = 168;
SET @MOD_SKILLCHAIN_DMG = 175;
SET @MOD_DOUBLE_ATK     = 288;
SET @MOD_SUBTLE_BLOW    = 289;
SET @MOD_COUNTER        = 291;
SET @MOD_TRIPLE_ATK     = 302;
SET @MOD_ZANSHIN        = 306;
SET @MOD_NINJA_TOOL     = 308;

SET @MOD_JUMP_TP_BONUS      = 361;
SET @MOD_JUMP_DOUBLE_ATTACK = 888;

SET @MOD_VERMIN_KILLER   = 224;
SET @MOD_BIRD_KILLER     = 225;
SET @MOD_AMORPH_KILLER   = 226;
SET @MOD_LIZARD_KILLER   = 227;
SET @MOD_AQUAN_KILLER    = 228;
SET @MOD_PLANTOID_KILLER = 229;
SET @MOD_BEAST_KILLER    = 230;
SET @MOD_UNDEAD_KILLER   = 231;
SET @MOD_ARCANA_KILLER   = 232;
SET @MOD_DRAGON_KILLER   = 233;
SET @MOD_DEMON_KILLER    = 234;
SET @MOD_EMPTY_KILLER    = 235;
SET @MOD_HUMANOID_KILLER = 236;
SET @MOD_LUMINIAN_KILLER = 237;
SET @MOD_LUMINION_KILLER = 238;

SET @MOD_FIRE_AFFINITY_DMG    = 347;
SET @MOD_ICE_AFFINITY_DMG     = 348;
SET @MOD_WIND_AFFINITY_DMG    = 349;
SET @MOD_EARTH_AFFINITY_DMG   = 350;
SET @MOD_THUNDER_AFFINITY_DMG = 351;
SET @MOD_WATER_AFFINITY_DMG   = 352;
SET @MOD_LIGHT_AFFINITY_DMG   = 353;
SET @MOD_DARK_AFFINITY_DMG    = 354;

SET @MOD_ITEM_ADDEFFECT_TYPE  = 431;

SET @MOD_FIRE_AFFINITY_ACC    = 544;
SET @MOD_ICE_AFFINITY_ACC     = 545;
SET @MOD_WIND_AFFINITY_ACC    = 546;
SET @MOD_EARTH_AFFINITY_ACC   = 547;
SET @MOD_THUNDER_AFFINITY_ACC = 548;
SET @MOD_WATER_AFFINITY_ACC   = 549;
SET @MOD_LIGHT_AFFINITY_ACC   = 550;
SET @MOD_DARK_AFFINITY_ACC    = 551;

SET @MOD_REGEN_DURATION = 339;
SET @MOD_DAY_REDUCTION  = 373;

SET @MOD_REDUCE_ENMITY_LOSS = 427;

SET @MOD_LULLABY_EFFECT = 440;
SET @MOD_BALLAD_EFFECT  = 442;

SET @MOD_GRIMOIRE_SPELLCASTING = 489;
SET @MOD_SAMBA_DURATION        = 490;

SET @CURE_CAST_TIME         = 519;

SET @MOD_PHALANX            = 301;
SET @MOD_AVATAR_PERP        = 346;
SET @MOD_RAPID_SHOT         = 359;
SET @MOD_REFRESH            = 369;
SET @MOD_REGEN              = 370;
SET @MOD_CURE_POTENCY       = 374;
SET @MOD_HASTE              = 384;
SET @MOD_RETALIATION        = 414;
SET @MOD_CRITICAL_DMG       = 421;
SET @MOD_ENSPELL_DMG_BONUS  = 432;
SET @MOD_IRIDESCENCE        = 566;
SET @MOD_CURE2MP_PERCENT    = 860;
SET @MOD_ENH_MAGIC_DURATION = 890;
SET @MOD_ELEMENTAL_CELERITY = 901;
SET @MOD_OCCULT_ACUMEN      = 902;
SET @MOD_ENHANCES_PRO_SHELL = 977;
SET @MOD_PET_MAB_MDB        = 992;
SET @MOD_TRIPLE_SHOT_RATE   = 999;

SET @MOD_REPAIR_POTENCY = 854;

SET @MOD_SWIPE                  = 1016;
SET @MOD_REPRISAL_BLOCK_BONUS   = 1067;
SET @MOD_REPRISAL_SPIKES_BONUS  = 1068;

SET @MOD_ADDEFFECT_TYPE    = 431;
SET @MOD_SUBEFFECT         = 499;
SET @MOD_ADDEFFECT_DMG     = 500;
SET @MOD_ADDEFFECT_CHANCE  = 501;
SET @MOD_ADDEFFECT_ELEMENT = 950;

SET @LATENT_STATUS_EFFECT =  13;
SET @LATENT_PARTY_SIZE    =  15;
SET @LATENT_WEAPON_DRAWN  =  56;
SET @EFFECT_ELVORSEAL     = 603;
SET @EFFECT_ICE_SPIKES    =  35;

SET @OHRMAZD      = 20530; -- Hand-to-Hand
SET @IPETAM       = 20616; -- Dagger
SET @MACBAIN      = 20759; -- Great Sword
SET @INANNA       = 20901; -- Scythe
SET @KUMBHAKARNA  = 20809; -- Axe
SET @SVARGA       = 20857; -- Great Axe
SET @CLAIDHEAMH   = 20718; -- Sword
SET @KERAUNOS     = 21169; -- Staff
SET @NEHUSHTAN    = 21105; -- Club
SET @OLYNDICUS    = 20946; -- Polearm
SET @PHAOSPHAELIA = 21224; -- Bow
SET @DOOMSDAY     = 21476; -- Gun
SET @NENEKIRIMARU = 21037; -- Great Katana
SET @IZUNA        = 20989; -- Katana
SET @LINOS        = 21404; -- Wind
SET @ADAMAS       = 10806; -- Shield (PLD)
SET @SVALINN      = 27627; -- Shield (WAR)
SET @CLARITAS     = 18909; -- Sword (RDM)

SET @XINGZHE      = 18627; -- Staff (MNK)
SET @VERUTUM      = 22281; -- Ammo (DRG)

DELETE FROM item_mods
WHERE itemId IN (
    @OHRMAZD, @IPETAM, @MACBAIN, @INANNA, @KUMBHAKARNA,
    @SVARGA, @CLAIDHEAMH, @KERAUNOS, @NEHUSHTAN, @OLYNDICUS,
    @PHAOSPHAELIA, @DOOMSDAY, @NENEKIRIMARU, @IZUNA, @SVALINN,
    @LINOS, @ADAMAS, @CLARITAS, @XINGZHE, @VERUTUM
);

DELETE FROM item_mods_pet
WHERE itemId IN (
    @OHRMAZD, @IPETAM, @MACBAIN, @INANNA, @KUMBHAKARNA,
    @SVARGA, @CLAIDHEAMH, @KERAUNOS, @NEHUSHTAN, @OLYNDICUS,
    @PHAOSPHAELIA, @DOOMSDAY, @NENEKIRIMARU, @IZUNA, @SVALINN,
    @LINOS, @ADAMAS, @CLARITAS, @XINGZHE, @VERUTUM
);

INSERT INTO item_mods (itemId, modId, Value)
VALUES
    (@ADAMAS, @MOD_DEF,           28),
    (@ADAMAS, @MOD_MP,            50),
    (@ADAMAS, @MOD_ENMITY,       -15),
    (@ADAMAS, @MOD_CURE_POTENCY,  15),

    (@SVALINN, @MOD_DEF,                36),
    (@SVALINN, @MOD_ENMITY,             10),
    (@SVALINN, @MOD_RETALIATION,        15),
    (@SVALINN, @MOD_REDUCE_ENMITY_LOSS, 15),

    (@CLARITAS, @MOD_HASTE,          400),
    (@CLARITAS, @MOD_CURE_POTENCY,    15),
    (@CLARITAS, @MOD_ENFEEBLE_SKILL,  10),

    (@XINGZHE, @MOD_DOUBLE_ATK,       4),
    (@XINGZHE, @MOD_SPELL_INTERRUPT, 25),
    (@XINGZHE, @MOD_STAFF_SKILL,     10);

INSERT INTO item_mods_pet (itemId, modId, value, petType)
VALUES
    -- Verutum (Knobkierrie)
    (@VERUTUM, @MOD_REGEN, 5, @PET_WYVERN); -- Wyvern - REGEN: 5

DELETE FROM `item_equipment`
WHERE itemId IN (
    @OHRMAZD, @IPETAM, @MACBAIN, @INANNA, @KUMBHAKARNA,
    @SVARGA, @CLAIDHEAMH, @KERAUNOS, @NEHUSHTAN, @OLYNDICUS,
    @PHAOSPHAELIA, @DOOMSDAY, @NENEKIRIMARU, @IZUNA, @SVALINN,
    @LINOS, @ADAMAS, @CLARITAS, @XINGZHE, @VERUTUM
);

SET @ADAMAS_NAME       = 'adamas';
SET @SVALINN_NAME      = 'svalinn';
SET @CLARITAS_NAME     = 'claritas';
SET @XINGZHE_NAME      = 'xingzhe';
SET @VERUTUM_NAME      = 'verutum';
SET @OHRMAZD_NAME      = 'ohrmazd';
SET @IPETAM_NAME       = 'ipetam';
SET @MACBAIN_NAME      = 'macbain';
SET @INANNA_NAME       = 'inanna';
SET @KUMBHAKARNA_NAME  = 'kumbhakarna';
SET @SVARGA_NAME       = 'svarga';
SET @CLAIDHEAMH_NAME   = 'claidheamh_soluis';
SET @KERAUNOS_NAME     = 'keraunos';
SET @NEHUSHTAN_NAME    = 'nehushtan';
SET @OLYNDICUS_NAME    = 'olyndicus';
SET @PHAOSPHAELIA_NAME = 'phaosphaelia';
SET @DOOMSDAY_NAME     = 'doomsday';
SET @NENEKIRIMARU_NAME = 'nenekirimaru';
SET @IZUNA_NAME        = 'izuna';
SET @LINOS_NAME        = 'linos';

-- CW Ultimate Weapon System
INSERT INTO `item_equipment` VALUES (@CLARITAS,     @CLARITAS_NAME,     75, 0, @RDM,        582, 0, 0, 3, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@OHRMAZD,      @OHRMAZD_NAME,      75, 0, @MNK + @PUP, 506, 0, 0, 1, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@IPETAM,       @IPETAM_NAME,       75, 0, @THF + @DNC, 710, 0, 0, 3, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@MACBAIN,      @MACBAIN_NAME,      75, 0, @DRK + @RUN, 712, 0, 0, 1, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@INANNA,       @INANNA_NAME,       75, 0, @DRK,        715, 0, 0, 1, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@KUMBHAKARNA,  @KUMBHAKARNA_NAME,  75, 0, @WAR + @BST, 713, 0, 0, 3, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@SVARGA,       @SVARGA_NAME,       75, 0, @WAR,        714, 0, 0, 1, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@CLAIDHEAMH,   @CLAIDHEAMH_NAME,   75, 0, @PLD + @BLU, 711, 0, 0, 3, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@KERAUNOS,     @KERAUNOS_NAME,     75, 0, @BLM + @SCH, 720, 0, 0, 1, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@NEHUSHTAN,    @NEHUSHTAN_NAME,    75, 0, @WHM + @GEO, 719, 0, 0, 3, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@OLYNDICUS,    @OLYNDICUS_NAME,    75, 0, @DRG,        716, 0, 0, 1, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@PHAOSPHAELIA, @PHAOSPHAELIA_NAME, 75, 0, @RNG,        122, 0, 0, 4, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@DOOMSDAY,     @DOOMSDAY_NAME,     75, 0, @RNG + @COR, 123, 0, 0, 4, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@NENEKIRIMARU, @NENEKIRIMARU_NAME, 75, 0, @SAM,        718, 0, 0, 1, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@IZUNA,        @IZUNA_NAME,        75, 0, @NIN,        717, 0, 0, 3, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@LINOS,        @LINOS_NAME,        75, 0, @BRD,        124, 0, 0, 4, 0, 0, 0);

INSERT INTO `item_equipment` VALUES (@VERUTUM,      @VERUTUM_NAME,      75, 0, @DRG,         88, 0, 0, @SLOT_AMMO, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@XINGZHE,      @XINGZHE_NAME,      75, 0, @MNK,        341, 0, 0, @SLOT_MAIN_HAND, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@ADAMAS,       @ADAMAS_NAME,       75, 0, @PLD,         61, @SHIELD_SIZE_3, 0, @SLOT_OFF_HAND, 0, 0, 0);
INSERT INTO `item_equipment` VALUES (@SVALINN,      @SVALINN_NAME,      75, 0, @WAR,        653, @SHIELD_SIZE_4, 0, @SLOT_OFF_HAND, 0, 0, 0);

DELETE FROM `item_weapon`
WHERE itemId IN (
    @OHRMAZD, @IPETAM, @MACBAIN, @INANNA, @KUMBHAKARNA,
    @SVARGA, @CLAIDHEAMH, @KERAUNOS, @NEHUSHTAN, @OLYNDICUS,
    @PHAOSPHAELIA, @DOOMSDAY, @NENEKIRIMARU, @IZUNA, @SVALINN,
    @LINOS, @ADAMAS, @CLARITAS, @XINGZHE, @VERUTUM
);

INSERT INTO `item_weapon` VALUES (@CLARITAS,     @CLARITAS_NAME,      3, 0, 0, 0, 0, 2, 1, 228,  40, 0);
INSERT INTO `item_weapon` VALUES (@OHRMAZD,      @OHRMAZD_NAME,       1, 0, 0, 0, 0, 4, 1, 640,  26, 0);
INSERT INTO `item_weapon` VALUES (@IPETAM,       @IPETAM_NAME,        2, 0, 0, 0, 0, 1, 1, 220,  41, 0);
INSERT INTO `item_weapon` VALUES (@MACBAIN,      @MACBAIN_NAME,       4, 0, 0, 0, 0, 2, 1, 510,  88, 0);
INSERT INTO `item_weapon` VALUES (@INANNA,       @INANNA_NAME,        7, 0, 0, 0, 0, 2, 1, 550, 108, 0);
INSERT INTO `item_weapon` VALUES (@KUMBHAKARNA,  @KUMBHAKARNA_NAME,   5, 0, 0, 0, 0, 2, 1, 322,  58, 0);
INSERT INTO `item_weapon` VALUES (@SVARGA,       @SVARGA_NAME,        6, 0, 0, 0, 0, 2, 1, 545, 104, 0);
INSERT INTO `item_weapon` VALUES (@CLAIDHEAMH,   @CLAIDHEAMH_NAME,    3, 0, 0, 0, 0, 2, 1, 270,  52, 0);
INSERT INTO `item_weapon` VALUES (@KERAUNOS,     @KERAUNOS_NAME,     12, 0, 0, 0, 0, 3, 1, 435,  75, 0);
INSERT INTO `item_weapon` VALUES (@NEHUSHTAN,    @NEHUSHTAN_NAME,    11, 0, 0, 0, 0, 3, 1, 352,  64, 0);
INSERT INTO `item_weapon` VALUES (@OLYNDICUS,    @OLYNDICUS_NAME,     8, 0, 0, 0, 0, 1, 1, 528, 103, 0);
INSERT INTO `item_weapon` VALUES (@PHAOSPHAELIA, @PHAOSPHAELIA_NAME, 25, 0, 0, 0, 0, 1, 1, 524,  85, 0);
INSERT INTO `item_weapon` VALUES (@DOOMSDAY,     @DOOMSDAY_NAME,     26, 1, 0, 0, 0, 1, 1, 600,  51, 0);
INSERT INTO `item_weapon` VALUES (@NENEKIRIMARU, @NENEKIRIMARU_NAME, 10, 0, 0, 0, 0, 2, 1, 484,  86, 0);
INSERT INTO `item_weapon` VALUES (@IZUNA,        @IZUNA_NAME,         9, 0, 0, 0, 0, 2, 1, 237,  44, 0);
INSERT INTO `item_weapon` VALUES (@LINOS,        @LINOS_NAME,        42, 0, 0, 0, 0, 0, 1, 240,   3, 0);

INSERT INTO `item_weapon` VALUES (@XINGZHE,      @XINGZHE_NAME,      12, 0, 0, 0, 0, 3, 1, 412,  80, 0);

UPDATE item_basic SET flags = 63552, aH = 0, NoSale = 1, BaseSell = 0 WHERE itemid IN (
    @OHRMAZD, @IPETAM, @MACBAIN, @INANNA, @KUMBHAKARNA,
    @SVARGA, @CLAIDHEAMH, @KERAUNOS, @NEHUSHTAN, @OLYNDICUS,
    @PHAOSPHAELIA, @DOOMSDAY, @NENEKIRIMARU, @IZUNA, @SVALINN,
    @LINOS, @ADAMAS, @CLARITAS, @XINGZHE, @VERUTUM
);

UPDATE item_basic SET name = @CLARITAS_NAME,     sortname = @CLARITAS_NAME     WHERE itemid = @CLARITAS;
UPDATE item_basic SET name = @OHRMAZD_NAME,      sortname = @OHRMAZD_NAME      WHERE itemid = @OHRMAZD;
UPDATE item_basic SET name = @IPETAM_NAME,       sortname = @IPETAM_NAME       WHERE itemid = @IPETAM;
UPDATE item_basic SET name = @MACBAIN_NAME,      sortname = @MACBAIN_NAME      WHERE itemid = @MACBAIN;
UPDATE item_basic SET name = @INANNA_NAME,       sortname = @INANNA_NAME       WHERE itemid = @INANNA;
UPDATE item_basic SET name = @KUMBHAKARNA_NAME,  sortname = @KUMBHAKARNA_NAME  WHERE itemid = @KUMBHAKARNA;
UPDATE item_basic SET name = @SVARGA_NAME,       sortname = @SVARGA_NAME       WHERE itemid = @SVARGA;
UPDATE item_basic SET name = @CLAIDHEAMH_NAME,   sortname = @CLAIDHEAMH_NAME   WHERE itemid = @CLAIDHEAMH;
UPDATE item_basic SET name = @KERAUNOS_NAME,     sortname = @KERAUNOS_NAME     WHERE itemid = @KERAUNOS;
UPDATE item_basic SET name = @NEHUSHTAN_NAME,    sortname = @NEHUSHTAN_NAME    WHERE itemid = @NEHUSHTAN;
UPDATE item_basic SET name = @OLYNDICUS_NAME,    sortname = @OLYNDICUS_NAME    WHERE itemid = @OLYNDICUS;
UPDATE item_basic SET name = @PHAOSPHAELIA_NAME, sortname = @PHAOSPHAELIA_NAME WHERE itemid = @PHAOSPHAELIA;
UPDATE item_basic SET name = @DOOMSDAY_NAME,     sortname = @DOOMSDAY_NAME     WHERE itemid = @DOOMSDAY;
UPDATE item_basic SET name = @NENEKIRIMARU_NAME, sortname = @NENEKIRIMARU_NAME WHERE itemid = @NENEKIRIMARU;
UPDATE item_basic SET name = @IZUNA_NAME,        sortname = @IZUNA_NAME        WHERE itemid = @IZUNA;
UPDATE item_basic SET name = @LINOS_NAME,        sortname = @LINOS_NAME        WHERE itemid = @LINOS;

UPDATE item_basic SET name = @ADAMAS_NAME,       sortname = @ADAMAS_NAME       WHERE itemid = @ADAMAS;
UPDATE item_basic SET name = @CLARITAS_NAME,     sortname = @CLARITAS_NAME     WHERE itemid = @CLARITAS;
UPDATE item_basic SET name = @XINGZHE_NAME,      sortname = @XINGZHE_NAME      WHERE itemid = @XINGZHE;
UPDATE item_basic SET name = @VERUTUM_NAME,      sortname = @VERUTUM_NAME      WHERE itemid = @VERUTUM;

-- CW Ammo
SET @FLAME_ARROW = 22289;
UPDATE item_basic     SET name = 'flame_arrow', sortname = 'flame_arrow' WHERE itemId = @FLAME_ARROW;
UPDATE item_equipment SET name = 'flame_arrow', level = 70, ilevel = 0, su_level = 0, jobs = @RNG + @PLD + @SAM WHERE itemId = @FLAME_ARROW;
UPDATE item_weapon    SET ilvl_skill = 0, ilvl_parry = 0, ilvl_macc = 0, dmg = 36, delay = 90 WHERE itemId = @FLAME_ARROW;

SET @FROST_ARROW = 21300;
UPDATE item_basic     SET name = 'frost_arrow', sortname = 'frost_arrow' WHERE itemId = @FROST_ARROW;
UPDATE item_equipment SET name = 'frost_arrow', level = 70, ilevel = 0, su_level = 0, jobs = @RNG + @PLD + @SAM WHERE itemId = @FROST_ARROW;
UPDATE item_weapon    SET ilvl_skill = 0, ilvl_parry = 0, ilvl_macc = 0, dmg = 32, delay = 90 WHERE itemId = @FROST_ARROW;

SET @THUNDER_BOLT = 22290;
UPDATE item_basic     SET name = 'thunder_bolt', sortname = 'thunder_bolt' WHERE itemId = @THUNDER_BOLT;
UPDATE item_equipment SET name = 'thunder_bolt', level = 70, ilevel = 0, su_level = 0, jobs = @THF + @DRK + @RNG WHERE itemId = @THUNDER_BOLT;
UPDATE item_weapon    SET ilvl_skill = 0, ilvl_parry = 0, ilvl_macc = 0, dmg = 38, delay = 192 WHERE itemId = @THUNDER_BOLT;

DELETE FROM item_mods_pet WHERE itemId IN (@FLAME_ARROW, @FROST_ARROW, @THUNDER_BOLT);
INSERT INTO item_mods (itemId, modId, Value) VALUES
    (@FLAME_ARROW, @MOD_INT,                12),
    (@FLAME_ARROW, @MOD_ICE_RES,            10),
    (@FLAME_ARROW, @MOD_ADDEFFECT_TYPE,      1),
    (@FLAME_ARROW, @MOD_SUBEFFECT,           1),
    (@FLAME_ARROW, @MOD_ADDEFFECT_DMG,      80),
    (@FLAME_ARROW, @MOD_ADDEFFECT_CHANCE,  100),
    (@FLAME_ARROW, @MOD_ADDEFFECT_ELEMENT,   1),

    (@FROST_ARROW, @MOD_INT,                15),
    (@FROST_ARROW, @MOD_WIND_RES,           10),
    (@FROST_ARROW, @MOD_ADDEFFECT_TYPE,      1),
    (@FROST_ARROW, @MOD_SUBEFFECT,           2),
    (@FROST_ARROW, @MOD_ADDEFFECT_DMG,      80),
    (@FROST_ARROW, @MOD_ADDEFFECT_CHANCE,  100),
    (@FROST_ARROW, @MOD_ADDEFFECT_ELEMENT,   2),

    (@THUNDER_BOLT, @MOD_INT,                12),
    (@THUNDER_BOLT, @MOD_EARTH_RES,          10),
    (@THUNDER_BOLT, @MOD_ADDEFFECT_TYPE,      1),
    (@THUNDER_BOLT, @MOD_SUBEFFECT,           5),
    (@THUNDER_BOLT, @MOD_ADDEFFECT_DMG,      80),
    (@THUNDER_BOLT, @MOD_ADDEFFECT_CHANCE,  100),
    (@THUNDER_BOLT, @MOD_ADDEFFECT_ELEMENT,   5);

SET @FLAME_QUIVER        = 6420;
SET @FROST_QUIVER        = 6417;
SET @THUNDER_BOLT_QUIVER = 6429;

UPDATE item_basic SET name = 'flame_quiver',        sortname = 'flame_quiver'     WHERE itemId = @FLAME_QUIVER;
UPDATE item_basic SET name = 'frost_quiver',        sortname = 'frost_quiver'     WHERE itemId = @FROST_QUIVER;
UPDATE item_basic SET name = 'thunder_bolt_quiver', sortname = 'tdr._bolt_quiver' WHERE itemId = @THUNDER_BOLT_QUIVER;

DELETE FROM item_usable WHERE itemid IN (@FLAME_QUIVER, @FROST_QUIVER, @THUNDER_BOLT_QUIVER);
INSERT INTO item_usable VALUES (@FLAME_QUIVER,        'flame_quiver',        1, 1, 55, 0, 0, 0, 0, 0);
INSERT INTO item_usable VALUES (@FROST_QUIVER,        'frost_quiver',        1, 1, 55, 0, 0, 0, 0, 0);
INSERT INTO item_usable VALUES (@THUNDER_BOLT_QUIVER, 'thunder_bolt_quiver', 1, 1, 55, 0, 0, 0, 0, 0);

-- Clear ITEM_FLAG_MYSTERY_BOX from item
UPDATE item_basic SET
    item_basic.flags = item_basic.flags & ~0x0004
WHERE (item_basic.flags & 0x0004) AND item_basic.itemId IN (
    @FLAME_ARROW,
    @FROST_ARROW,
    @THUNDER_BOLT,
    @FLAME_QUIVER,
    @FROST_QUIVER,
    @THUNDER_BOLT_QUIVER,

    @OHRMAZD, @IPETAM, @MACBAIN, @INANNA, @KUMBHAKARNA,
    @SVARGA, @CLAIDHEAMH, @KERAUNOS, @NEHUSHTAN, @OLYNDICUS,
    @PHAOSPHAELIA, @DOOMSDAY, @NENEKIRIMARU, @IZUNA, @SVALINN,
    @LINOS, @ADAMAS, @CLARITAS, @XINGZHE, @VERUTUM
);
