-- Drop Rates
SET @ALWAYS = 1000;  -- Always, 100%
SET @VCOMMON = 240;  -- Very common, 24%
SET @COMMON = 150;   -- Common, 15%
SET @UNCOMMON = 100; -- Uncommon, 10%
SET @RARE = 50;      -- Rare, 5%
SET @VRARE = 10;     -- Very rare, 1%
SET @SRARE = 5;      -- Super Rare, 0.5%
SET @URARE = 1;      -- Ultra rare, 0.1%

SET @WAR  =  1;
SET @MNK  =  2;
SET @WHM  =  4;
SET @BLM  =  8;
SET @RDM  = 16;
SET @THF  = 32;
SET @PLD  = 64;
SET @DRK  = 128;
SET @BST  = 256;
SET @BRD  = 512;
SET @RNG  = 1024;
SET @SAM  = 2048;
SET @NIN  = 4096;
SET @DRG  = 8192;
SET @SMN  = 16384;
SET @BLU  = 32768;
SET @COR  = 65536;
SET @PUP  = 131072;
SET @DNC  = 262144;
SET @SCH  = 524288;
SET @GEO  = 1048576;
SET @RUN  = 2097152;

SET @SHIELD_SIZE_1 = 1;
SET @SHIELD_SIZE_2 = 2;
SET @SHIELD_SIZE_3 = 3;
SET @SHIELD_SIZE_4 = 4;
SET @SHIELD_SIZE_5 = 5;

SET @SLOT_TWO_HAND  = 1;
SET @SLOT_MAIN_HAND = 2;
SET @SLOT_OFF_HAND  = 3;
SET @SLOT_AMMO      = 8;

--
-- Mods
--
SET @PET_ALL       = 0;
SET @PET_AVATAR    = 1;
SET @PET_WYVERN    = 2;
SET @PET_AUTOMATON = 3;
SET @PET_LUOPAN    = 8;

SET @MOD_DEF = 1;
SET @MOD_HP  = 2;
SET @MOD_MP  = 5;

SET @MOD_STR =  8;
SET @MOD_DEX =  9;
SET @MOD_VIT = 10;
SET @MOD_AGI = 11;
SET @MOD_INT = 12;
SET @MOD_MND = 13;
SET @MOD_CHR = 14;

SET @MOD_FIRE_RES    = 15;
SET @MOD_ICE_RES     = 16;
SET @MOD_WIND_RES    = 17;
SET @MOD_EARTH_RES   = 18;
SET @MOD_THUNDER_RES = 19;
SET @MOD_WATER_RES   = 20;
SET @MOD_LIGHT_RES   = 21;
SET @MOD_DARK_RES    = 22;

SET @MOD_ATT    = 23;
SET @MOD_RATT   = 24;
SET @MOD_ACC    = 25;
SET @MOD_RACC   = 26;
SET @MOD_ENMITY = 27;
SET @MOD_MATT   = 28;
SET @MOD_MDEF   = 29;
SET @MOD_MACC   = 30;
SET @MOD_EVA    = 31;

SET @MOD_HMP      = 71;
SET @MOD_HHP      = 72;
SET @MOD_STORE_TP = 73;

SET @MOD_HTH_SKILL     = 80;
SET @MOD_DAGGER_SKILL  = 81;
SET @MOD_SWORD_SKILL   = 82;
SET @MOD_GSWORD_SKILL  = 83;
SET @MOD_AXE_SKILL     = 84;
SET @MOD_GAXE_SKILL    = 85;
SET @MOD_SCYTHE_SKILL  = 86;
SET @MOD_POLEARM_SKILL = 87;
SET @MOD_KATANA_SKILL  = 88;
SET @MOD_GKATANA_SKILL = 89;
SET @MOD_CLUB_SKILL    = 90;
SET @MOD_STAFF_SKILL   = 91;

SET @MOD_AUTO_MAGIC_SKILL  = 103;
SET @MOD_ARCHERY_SKILL     = 104;
SET @MOD_MARKSMAN_SKILL    = 105;
SET @MOD_THROWING_SKILL    = 106;

SET @MOD_GUARD_SKILL   = 107;
SET @MOD_EVASION_SKILL = 108;
SET @MOD_SHIELD_SKILL  = 109;
SET @MOD_PARRY_SKILL   = 110;

SET @MOD_DIVINE_SKILL    = 111;
SET @MOD_HEALING_SKILL   = 112;
SET @MOD_ENHANCE_SKILL   = 113;
SET @MOD_ENFEEBLE_SKILL  = 114;
SET @MOD_ELEMENTAL_SKILL = 115;
SET @MOD_DARK_SKILL      = 116;
SET @MOD_SUMMONING_SKILL = 117;
SET @MOD_NINJUTSU_SKILL  = 118;
SET @MOD_SINGING_SKILL   = 119;
SET @MOD_STRING_SKILL    = 120;
SET @MOD_WIND_SKILL      = 121;
SET @MOD_BLUE_SKILL      = 122;
SET @MOD_GEOMANCY_SKILL  = 123;
SET @MOD_HANDBELL_SKILL  = 124;

SET @MOD_DAMAGE_TAKEN        = 160;
SET @MOD_PHYS_DMG_TAKEN      = 161;
SET @MOD_BREATH_DMG_TAKEN    = 162;
SET @MOD_MAGIC_DMG_TAKEN     = 163;
SET @MOD_CRIT_HIT_RATE       = 165;
SET @MOD_MAGIC_DMG_TAKEN_II  = 831;

SET @MOD_FASTCAST    = 170;
SET @MOD_CONSERVE_MP = 296;

SET @MOD_CRITICAL_RATE  = 165;
SET @MOD_SPELL_INTERRUPT = 168;
SET @MOD_SKILLCHAIN_DMG = 175;
SET @MOD_DOUBLE_ATK     = 288;
SET @MOD_SUBTLE_BLOW    = 289;
SET @MOD_COUNTER        = 291;
SET @MOD_TRIPLE_ATK     = 302;
SET @MOD_ZANSHIN        = 306;
SET @MOD_NINJA_TOOL     = 308;

SET @MOD_JUMP_TP_BONUS      = 361;
SET @MOD_JUMP_DOUBLE_ATTACK = 888;

SET @MOD_VERMIN_KILLER   = 224;
SET @MOD_BIRD_KILLER     = 225;
SET @MOD_AMORPH_KILLER   = 226;
SET @MOD_LIZARD_KILLER   = 227;
SET @MOD_AQUAN_KILLER    = 228;
SET @MOD_PLANTOID_KILLER = 229;
SET @MOD_BEAST_KILLER    = 230;
SET @MOD_UNDEAD_KILLER   = 231;
SET @MOD_ARCANA_KILLER   = 232;
SET @MOD_DRAGON_KILLER   = 233;
SET @MOD_DEMON_KILLER    = 234;
SET @MOD_EMPTY_KILLER    = 235;
SET @MOD_HUMANOID_KILLER = 236;
SET @MOD_LUMINIAN_KILLER = 237;
SET @MOD_LUMINION_KILLER = 238;

SET @MOD_FIRE_AFFINITY_DMG    = 347;
SET @MOD_ICE_AFFINITY_DMG     = 348;
SET @MOD_WIND_AFFINITY_DMG    = 349;
SET @MOD_EARTH_AFFINITY_DMG   = 350;
SET @MOD_THUNDER_AFFINITY_DMG = 351;
SET @MOD_WATER_AFFINITY_DMG   = 352;
SET @MOD_LIGHT_AFFINITY_DMG   = 353;
SET @MOD_DARK_AFFINITY_DMG    = 354;

SET @MOD_ITEM_ADDEFFECT_TYPE  = 431;

SET @MOD_FIRE_AFFINITY_ACC    = 544;
SET @MOD_ICE_AFFINITY_ACC     = 545;
SET @MOD_WIND_AFFINITY_ACC    = 546;
SET @MOD_EARTH_AFFINITY_ACC   = 547;
SET @MOD_THUNDER_AFFINITY_ACC = 548;
SET @MOD_WATER_AFFINITY_ACC   = 549;
SET @MOD_LIGHT_AFFINITY_ACC   = 550;
SET @MOD_DARK_AFFINITY_ACC    = 551;

SET @MOD_REGEN_DURATION = 339;
SET @MOD_DAY_REDUCTION  = 373;

SET @MOD_REDUCE_ENMITY_LOSS = 427;

SET @MOD_LULLABY_EFFECT = 440;
SET @MOD_BALLAD_EFFECT  = 442;

SET @MOD_GRIMOIRE_SPELLCASTING = 489;
SET @MOD_SAMBA_DURATION        = 490;

SET @CURE_CAST_TIME         = 519;

SET @MOD_PHALANX            = 301;
SET @MOD_AVATAR_PERP        = 346;
SET @MOD_RAPID_SHOT         = 359;
SET @MOD_REFRESH            = 369;
SET @MOD_REGEN              = 370;
SET @MOD_CURE_POTENCY       = 374;
SET @MOD_HASTE              = 384;
SET @MOD_RETALIATION        = 414;
SET @MOD_CRITICAL_DMG       = 421;
SET @MOD_ENSPELL_DMG_BONUS  = 432;
SET @MOD_IRIDESCENCE        = 566;
SET @MOD_CURE2MP_PERCENT    = 860;
SET @MOD_ENH_MAGIC_DURATION = 890;
SET @MOD_ELEMENTAL_CELERITY = 901;
SET @MOD_OCCULT_ACUMEN      = 902;
SET @MOD_ENHANCES_PRO_SHELL = 977;
SET @MOD_PET_MAB_MDB        = 992;
SET @MOD_TRIPLE_SHOT_RATE   = 999;

SET @MOD_REPAIR_POTENCY = 854;

SET @MOD_SWIPE                  = 1016;
SET @MOD_REPRISAL_BLOCK_BONUS   = 1067;
SET @MOD_REPRISAL_SPIKES_BONUS  = 1068;

SET @LATENT_STATUS_EFFECT =  13;
SET @LATENT_PARTY_SIZE    =  15;
SET @LATENT_WEAPON_DRAWN  =  56;
SET @EFFECT_ELVORSEAL     = 603;
SET @EFFECT_ICE_SPIKES    =  35;

---------------------
-- Provenance Watcher
---------------------
SET @DRACHENHORN   = 10912;
SET @HYALINE_HAT   = 10913;
SET @TESSERA_SAIO  = 10485;
SET @VILE_ELIXIR   = 4174;
SET @VILE_ELIXIR_1 = 4175;

DELETE FROM `item_mods` WHERE itemId IN (
    @DRACHENHORN, @HYALINE_HAT, @TESSERA_SAIO
);

-- TODO: Needs proper review
INSERT INTO `item_mods` VALUES
    (@DRACHENHORN,      @MOD_DEF,               29),
    (@DRACHENHORN,      @MOD_STR,                9),
    (@DRACHENHORN,      @MOD_DEX,                9),
    (@DRACHENHORN,      @MOD_VIT,                9),

    (@HYALINE_HAT,      @MOD_DEF,               25),
    (@HYALINE_HAT,      @MOD_INT,               10),
    (@HYALINE_HAT,      @MOD_MND,               10),
    (@HYALINE_HAT,      @MOD_CHR,               10),
    (@HYALINE_HAT,      @MOD_FASTCAST,           5),
    (@HYALINE_HAT,      @MOD_ENMITY,            -4),

    (@TESSERA_SAIO,     @MOD_DEF,               40),
    (@TESSERA_SAIO,     @MOD_STR,                8),
    (@TESSERA_SAIO,     @MOD_DEX,                8),
    (@TESSERA_SAIO,     @MOD_AGI,                8),
    (@TESSERA_SAIO,     @MOD_ATT,               12),
    (@TESSERA_SAIO,     @MOD_RATT,              12),
    (@TESSERA_SAIO,     @MOD_MATT,               5),
    (@TESSERA_SAIO,     @MOD_HASTE,              2);

SET @PROVENANCE_WATCHER = 3910;
SET @SARBAZ             = 3911;
SET @PIL                = 3912;
SET @ASB                = 3913;
SET @RUKH               = 3914;
SET @SHAH               = 3915;
SET @WAZIR              = 3916;
-- Free up to 3949 (2023/11/5)

UPDATE `mob_groups` SET dropId = @PROVENANCE_WATCHER WHERE `name` = 'Provenance_Watcher';

DELETE FROM `mob_droplist` WHERE `dropId` IN (
    @PROVENANCE_WATCHER, @SARBAZ, @PIL, @ASB, @RUKH, @SHAH, @WAZIR
);

INSERT INTO `mob_droplist` VALUES (@PROVENANCE_WATCHER, 0, 0, 1000, @VILE_ELIXIR,   @VCOMMON);  -- (24.0%)
INSERT INTO `mob_droplist` VALUES (@PROVENANCE_WATCHER, 0, 0, 1000, @VILE_ELIXIR_1, @COMMON);   -- (15.0%)
INSERT INTO `mob_droplist` VALUES (@PROVENANCE_WATCHER, 0, 0, 1000, @TESSERA_SAIO,  @UNCOMMON); -- (10.0%)
INSERT INTO `mob_droplist` VALUES (@PROVENANCE_WATCHER, 0, 0, 1000, @DRACHENHORN,   @RARE);     -- ( 5.0%)
INSERT INTO `mob_droplist` VALUES (@PROVENANCE_WATCHER, 0, 0, 1000, @HYALINE_HAT,   @RARE);     -- ( 5.0%)
-- Should also drop some materials (TBD)

-- Clear ITEM_FLAG_MYSTERY_BOX from item
UPDATE item_basic SET
    item_basic.flags = item_basic.flags & ~0x0004
WHERE (item_basic.flags & 0x0004) AND item_basic.itemId IN (
    @DRACHENHORN,
    @HYALINE_HAT,
    @TESSERA_SAIO
);
