-- Drop Rates
SET @ALWAYS   = 1000;  -- Always, 100%
SET @VCOMMON  = 240;  -- Very common, 24%
SET @COMMON   = 150;   -- Common, 15%
SET @UNCOMMON = 100; -- Uncommon, 10%
SET @RARE     = 50;      -- Rare, 5%
SET @VRARE    = 10;     -- Very rare, 1%
SET @SRARE    = 5;      -- Super Rare, 0.5%
SET @URARE    = 1;      -- Ultra rare, 0.1%

SET @WAR  =  1;
SET @MNK  =  2;
SET @WHM  =  4;
SET @BLM  =  8;
SET @RDM  = 16;
SET @THF  = 32;
SET @PLD  = 64;
SET @DRK  = 128;
SET @BST  = 256;
SET @BRD  = 512;
SET @RNG  = 1024;
SET @SAM  = 2048;
SET @NIN  = 4096;
SET @DRG  = 8192;
SET @SMN  = 16384;
SET @BLU  = 32768;
SET @COR  = 65536;
SET @PUP  = 131072;
SET @DNC  = 262144;
SET @SCH  = 524288;
SET @GEO  = 1048576;
SET @RUN  = 2097152;

SET @SHIELD_SIZE_1 = 1;
SET @SHIELD_SIZE_2 = 2;
SET @SHIELD_SIZE_3 = 3;
SET @SHIELD_SIZE_4 = 4;
SET @SHIELD_SIZE_5 = 5;

SET @SLOT_TWO_HAND  = 1;
SET @SLOT_MAIN_HAND = 2;
SET @SLOT_OFF_HAND  = 3;
SET @SLOT_AMMO      = 8;

--
-- Mods
--
SET @PET_ALL       = 0;
SET @PET_AVATAR    = 1;
SET @PET_WYVERN    = 2;
SET @PET_AUTOMATON = 3;
SET @PET_LUOPAN    = 8;

SET @MOD_DEF = 1;
SET @MOD_HP  = 2;
SET @MOD_MP  = 5;

SET @MOD_STR =  8;
SET @MOD_DEX =  9;
SET @MOD_VIT = 10;
SET @MOD_AGI = 11;
SET @MOD_INT = 12;
SET @MOD_MND = 13;
SET @MOD_CHR = 14;

SET @MOD_FIRE_RES    = 15;
SET @MOD_ICE_RES     = 16;
SET @MOD_WIND_RES    = 17;
SET @MOD_EARTH_RES   = 18;
SET @MOD_THUNDER_RES = 19;
SET @MOD_WATER_RES   = 20;
SET @MOD_LIGHT_RES   = 21;
SET @MOD_DARK_RES    = 22;

SET @MOD_ATT    = 23;
SET @MOD_RATT   = 24;
SET @MOD_ACC    = 25;
SET @MOD_RACC   = 26;
SET @MOD_ENMITY = 27;
SET @MOD_MATT   = 28;
SET @MOD_MDEF   = 29;
SET @MOD_MACC   = 30;
SET @MOD_EVA    = 31;

SET @MOD_HMP      = 71;
SET @MOD_HHP      = 72;
SET @MOD_STORE_TP = 73;

SET @MOD_HTH_SKILL     = 80;
SET @MOD_DAGGER_SKILL  = 81;
SET @MOD_SWORD_SKILL   = 82;
SET @MOD_GSWORD_SKILL  = 83;
SET @MOD_AXE_SKILL     = 84;
SET @MOD_GAXE_SKILL    = 85;
SET @MOD_SCYTHE_SKILL  = 86;
SET @MOD_POLEARM_SKILL = 87;
SET @MOD_KATANA_SKILL  = 88;
SET @MOD_GKATANA_SKILL = 89;
SET @MOD_CLUB_SKILL    = 90;
SET @MOD_STAFF_SKILL   = 91;

SET @MOD_AUTO_MAGIC_SKILL  = 103;
SET @MOD_ARCHERY_SKILL     = 104;
SET @MOD_MARKSMAN_SKILL    = 105;
SET @MOD_THROWING_SKILL    = 106;

SET @MOD_GUARD_SKILL   = 107;
SET @MOD_EVASION_SKILL = 108;
SET @MOD_SHIELD_SKILL  = 109;
SET @MOD_PARRY_SKILL   = 110;

SET @MOD_DIVINE_SKILL    = 111;
SET @MOD_HEALING_SKILL   = 112;
SET @MOD_ENHANCE_SKILL   = 113;
SET @MOD_ENFEEBLE_SKILL  = 114;
SET @MOD_ELEMENTAL_SKILL = 115;
SET @MOD_DARK_SKILL      = 116;
SET @MOD_SUMMONING_SKILL = 117;
SET @MOD_NINJUTSU_SKILL  = 118;
SET @MOD_SINGING_SKILL   = 119;
SET @MOD_STRING_SKILL    = 120;
SET @MOD_WIND_SKILL      = 121;
SET @MOD_BLUE_SKILL      = 122;
SET @MOD_GEOMANCY_SKILL  = 123;
SET @MOD_HANDBELL_SKILL  = 124;

SET @MOD_DAMAGE_TAKEN        = 160;
SET @MOD_PHYS_DMG_TAKEN      = 161;
SET @MOD_BREATH_DMG_TAKEN    = 162;
SET @MOD_MAGIC_DMG_TAKEN     = 163;
SET @MOD_CRIT_HIT_RATE       = 165;
SET @MOD_MAGIC_DMG_TAKEN_II  = 831;

SET @MOD_FASTCAST    = 170;
SET @MOD_CONSERVE_MP = 296;

SET @MOD_CRITICAL_RATE  = 165;
SET @MOD_SPELL_INTERRUPT = 168;
SET @MOD_SKILLCHAIN_DMG = 175;
SET @MOD_DOUBLE_ATK     = 288;
SET @MOD_SUBTLE_BLOW    = 289;
SET @MOD_COUNTER        = 291;
SET @MOD_TRIPLE_ATK     = 302;
SET @MOD_ZANSHIN        = 306;
SET @MOD_NINJA_TOOL     = 308;

SET @MOD_JUMP_TP_BONUS      = 361;
SET @MOD_JUMP_DOUBLE_ATTACK = 888;

SET @MOD_VERMIN_KILLER   = 224;
SET @MOD_BIRD_KILLER     = 225;
SET @MOD_AMORPH_KILLER   = 226;
SET @MOD_LIZARD_KILLER   = 227;
SET @MOD_AQUAN_KILLER    = 228;
SET @MOD_PLANTOID_KILLER = 229;
SET @MOD_BEAST_KILLER    = 230;
SET @MOD_UNDEAD_KILLER   = 231;
SET @MOD_ARCANA_KILLER   = 232;
SET @MOD_DRAGON_KILLER   = 233;
SET @MOD_DEMON_KILLER    = 234;
SET @MOD_EMPTY_KILLER    = 235;
SET @MOD_HUMANOID_KILLER = 236;
SET @MOD_LUMINIAN_KILLER = 237;
SET @MOD_LUMINION_KILLER = 238;

SET @MOD_FIRE_AFFINITY_DMG    = 347;
SET @MOD_ICE_AFFINITY_DMG     = 348;
SET @MOD_WIND_AFFINITY_DMG    = 349;
SET @MOD_EARTH_AFFINITY_DMG   = 350;
SET @MOD_THUNDER_AFFINITY_DMG = 351;
SET @MOD_WATER_AFFINITY_DMG   = 352;
SET @MOD_LIGHT_AFFINITY_DMG   = 353;
SET @MOD_DARK_AFFINITY_DMG    = 354;

SET @MOD_ITEM_ADDEFFECT_TYPE  = 431;

SET @MOD_FIRE_AFFINITY_ACC    = 544;
SET @MOD_ICE_AFFINITY_ACC     = 545;
SET @MOD_WIND_AFFINITY_ACC    = 546;
SET @MOD_EARTH_AFFINITY_ACC   = 547;
SET @MOD_THUNDER_AFFINITY_ACC = 548;
SET @MOD_WATER_AFFINITY_ACC   = 549;
SET @MOD_LIGHT_AFFINITY_ACC   = 550;
SET @MOD_DARK_AFFINITY_ACC    = 551;

SET @MOD_REGEN_DURATION = 339;
SET @MOD_DAY_REDUCTION  = 373;

SET @MOD_REDUCE_ENMITY_LOSS = 427;

SET @MOD_LULLABY_EFFECT = 440;
SET @MOD_BALLAD_EFFECT  = 442;

SET @MOD_GRIMOIRE_SPELLCASTING = 489;
SET @MOD_SAMBA_DURATION        = 490;

SET @CURE_CAST_TIME         = 519;

SET @MOD_PHALANX            = 301;
SET @MOD_AVATAR_PERP        = 346;
SET @MOD_RAPID_SHOT         = 359;
SET @MOD_REFRESH            = 369;
SET @MOD_REGEN              = 370;
SET @MOD_CURE_POTENCY       = 374;
SET @MOD_HASTE              = 384;
SET @MOD_RETALIATION        = 414;
SET @MOD_CRITICAL_DMG       = 421;
SET @MOD_ENSPELL_DMG_BONUS  = 432;
SET @MOD_IRIDESCENCE        = 566;
SET @MOD_CURE2MP_PERCENT    = 860;
SET @MOD_ENH_MAGIC_DURATION = 890;
SET @MOD_ELEMENTAL_CELERITY = 901;
SET @MOD_OCCULT_ACUMEN      = 902;
SET @MOD_ENHANCES_PRO_SHELL = 977;
SET @MOD_PET_MAB_MDB        = 992;
SET @MOD_TRIPLE_SHOT_RATE   = 999;

SET @MOD_REPAIR_POTENCY = 854;

SET @MOD_SWIPE                  = 1016;
SET @MOD_REPRISAL_BLOCK_BONUS   = 1067;
SET @MOD_REPRISAL_SPIKES_BONUS  = 1068;

SET @LATENT_STATUS_EFFECT =  13;
SET @LATENT_PARTY_SIZE    =  15;
SET @LATENT_WEAPON_DRAWN  =  56;
SET @EFFECT_ELVORSEAL     = 603;
SET @EFFECT_ICE_SPIKES    =  35;

SET @SLOT_HEAD  = 16;
SET @SLOT_BODY  = 32;
SET @SLOT_HANDS = 64;
SET @SLOT_LEGS  = 128;
SET @SLOT_FEET  = 256;

SET @LOW_LEVEL_SET = 40;
SET @MID_LEVEL_SET = 60;
SET @END_LEVEL_SET = 75;

SET @HEAVY_JOBS = @WAR + @PLD + @DRK + @SAM + @DRK + @RUN;
SET @LIGHT_JOBS = @MNK + @THF + @BST + @RNG + @NIN + @COR + @PUP + @DNC;
SET @MAGE_JOBS  = @WHM + @BLM + @RDM + @BRD + @SMN + @BLU + @SCH + @GEO;

-----------------------------------
-- Azurite Cuitass Set (Lv40)
-- WAR, PLD, DRK, SAM, DRG, RUN
-----------------------------------
SET @AZURITE_ARMET       = 26733;
SET @AZURITE_CUIRASS     = 26891;
SET @AZURITE_GAUNTLETS   = 27045;
SET @AZURITE_CUISSES     = 27232;
SET @AZURITE_SABATONS    = 27402;

SET @DARKSTEEL_CUIRASS_MODEL = 22;
SET @AZURITE_ARMET_NAME      = 'azurite_armet';
SET @AZURITE_CUIRASS_NAME    = 'azurite_cuirass';
SET @AZURITE_GAUNTLETS_NAME  = 'azurite_gauntlets';
SET @AZURITE_CUISSES_NAME    = 'azurite_cuisses';
SET @AZURITE_SABATONS_NAME   = 'azurite_sabatons';

DELETE FROM `item_equipment` WHERE itemId IN (
    @AZURITE_ARMET, @AZURITE_CUIRASS, @AZURITE_GAUNTLETS, @AZURITE_CUISSES, @AZURITE_SABATONS
);

INSERT INTO `item_equipment` VALUES
    (@AZURITE_ARMET,     @AZURITE_ARMET_NAME,     @LOW_LEVEL_SET, 0, @HEAVY_JOBS, @DARKSTEEL_CUIRASS_MODEL, 0, 0, @SLOT_HEAD,  0, 0, 0),
    (@AZURITE_CUIRASS,   @AZURITE_CUIRASS_NAME,   @LOW_LEVEL_SET, 0, @HEAVY_JOBS, @DARKSTEEL_CUIRASS_MODEL, 0, 0, @SLOT_BODY,  0, 0, 0),
    (@AZURITE_GAUNTLETS, @AZURITE_GAUNTLETS_NAME, @LOW_LEVEL_SET, 0, @HEAVY_JOBS, @DARKSTEEL_CUIRASS_MODEL, 0, 0, @SLOT_HANDS, 0, 0, 0),
    (@AZURITE_CUISSES,   @AZURITE_CUISSES_NAME,   @LOW_LEVEL_SET, 0, @HEAVY_JOBS, @DARKSTEEL_CUIRASS_MODEL, 0, 0, @SLOT_LEGS,  0, 0, 0),
    (@AZURITE_SABATONS,  @AZURITE_SABATONS_NAME,  @LOW_LEVEL_SET, 0, @HEAVY_JOBS, @DARKSTEEL_CUIRASS_MODEL, 0, 0, @SLOT_FEET,  0, 0, 0);

UPDATE `item_basic` SET name = @AZURITE_ARMET_NAME,     sortname = @AZURITE_ARMET_NAME     WHERE itemid = @AZURITE_ARMET;
UPDATE `item_basic` SET name = @AZURITE_CUIRASS_NAME,   sortname = @AZURITE_CUIRASS_NAME   WHERE itemid = @AZURITE_CUIRASS;
UPDATE `item_basic` SET name = @AZURITE_GAUNTLETS_NAME, sortname = @AZURITE_GAUNTLETS_NAME WHERE itemid = @AZURITE_GAUNTLETS;
UPDATE `item_basic` SET name = @AZURITE_CUISSES_NAME,   sortname = @AZURITE_CUISSES_NAME   WHERE itemid = @AZURITE_CUISSES;
UPDATE `item_basic` SET name = @AZURITE_SABATONS_NAME,  sortname = @AZURITE_SABATONS_NAME  WHERE itemid = @AZURITE_SABATONS;

DELETE FROM `item_mods` WHERE itemId IN (
    @AZURITE_ARMET, @AZURITE_CUIRASS, @AZURITE_GAUNTLETS, @AZURITE_CUISSES, @AZURITE_SABATONS
);

INSERT INTO `item_mods` VALUES
    (@AZURITE_ARMET,     @MOD_DEF,                16),
    (@AZURITE_ARMET,     @MOD_VIT,                 2),
    (@AZURITE_ARMET,     @MOD_ATT,                 5),
    (@AZURITE_ARMET,     @MOD_ENMITY,              1),

    (@AZURITE_CUIRASS,   @MOD_DEF,                32),
    (@AZURITE_CUIRASS,   @MOD_VIT,                 4),
    (@AZURITE_CUIRASS,   @MOD_ATT,                 3),
    (@AZURITE_CUIRASS,   @MOD_ACC,                 3),
    (@AZURITE_CUIRASS,   @MOD_ENMITY,              2),

    (@AZURITE_GAUNTLETS, @MOD_DEF,                11),
    (@AZURITE_GAUNTLETS, @MOD_VIT,                 2),
    (@AZURITE_GAUNTLETS, @MOD_ATT,                 5),

    (@AZURITE_CUISSES,   @MOD_DEF,                23),
    (@AZURITE_CUISSES,   @MOD_VIT,                 3),
    (@AZURITE_CUISSES,   @MOD_ATT,                 6),
    (@AZURITE_CUISSES,   @MOD_ENMITY,              2),

    (@AZURITE_SABATONS,  @MOD_DEF,                 9),
    (@AZURITE_SABATONS,  @MOD_VIT,                 2),
    (@AZURITE_SABATONS,  @MOD_ACC,                 5);

-----------------------------------
-- Argentite Haubert Set (Lv60)
--  WAR, PLD, DRK, SAM, DRG, RUN
-----------------------------------
SET @ARGENTITE_GALEA     = 25557;
SET @ARGENTITE_HAUBERT   = 26533;
SET @ARGENTITE_MOUFLES   = 25984;
SET @ARGENTITE_BRAYETTES = 25897;
SET @ARGENTITE_SOLLERETS = 25964;

SET @EBUR_HAUBERT_MODEL       = 278;
SET @ARGENTITE_GALEA_NAME     = 'argentite_galea';
SET @ARGENTITE_HAUBERT_NAME   = 'argentite_haubert';
SET @ARGENTITE_MOUFLES_NAME   = 'argentite_moufles';
SET @ARGENTITE_BRAYETTES_NAME = 'argentite_brayettes';
SET @ARGENTITE_SOLLERETS_NAME = 'argentite_sollerets';

DELETE FROM `item_equipment` WHERE itemId IN (
    @ARGENTITE_GALEA, @ARGENTITE_HAUBERT, @ARGENTITE_MOUFLES, @ARGENTITE_BRAYETTES, @ARGENTITE_SOLLERETS
);

INSERT INTO `item_equipment` VALUES
    (@ARGENTITE_GALEA,     @ARGENTITE_GALEA_NAME,     @MID_LEVEL_SET, 0, @HEAVY_JOBS, @EBUR_HAUBERT_MODEL, 0, 0, @SLOT_HEAD,  0, 0, 0),
    (@ARGENTITE_HAUBERT,   @ARGENTITE_HAUBERT_NAME,   @MID_LEVEL_SET, 0, @HEAVY_JOBS, @EBUR_HAUBERT_MODEL, 0, 0, @SLOT_BODY,  0, 0, 0),
    (@ARGENTITE_MOUFLES,   @ARGENTITE_MOUFLES_NAME,   @MID_LEVEL_SET, 0, @HEAVY_JOBS, @EBUR_HAUBERT_MODEL, 0, 0, @SLOT_HANDS, 0, 0, 0),
    (@ARGENTITE_BRAYETTES, @ARGENTITE_BRAYETTES_NAME, @MID_LEVEL_SET, 0, @HEAVY_JOBS, @EBUR_HAUBERT_MODEL, 0, 0, @SLOT_LEGS,  0, 0, 0),
    (@ARGENTITE_SOLLERETS, @ARGENTITE_SOLLERETS_NAME, @MID_LEVEL_SET, 0, @HEAVY_JOBS, @EBUR_HAUBERT_MODEL, 0, 0, @SLOT_FEET,  0, 0, 0);

UPDATE `item_basic` SET name = @ARGENTITE_GALEA_NAME,     sortname = @ARGENTITE_GALEA_NAME     WHERE itemid = @ARGENTITE_GALEA;
UPDATE `item_basic` SET name = @ARGENTITE_HAUBERT_NAME,   sortname = @ARGENTITE_HAUBERT_NAME   WHERE itemid = @ARGENTITE_HAUBERT;
UPDATE `item_basic` SET name = @ARGENTITE_MOUFLES_NAME,   sortname = @ARGENTITE_MOUFLES_NAME   WHERE itemid = @ARGENTITE_MOUFLES;
UPDATE `item_basic` SET name = @ARGENTITE_BRAYETTES_NAME, sortname = @ARGENTITE_BRAYETTES_NAME WHERE itemid = @ARGENTITE_BRAYETTES;
UPDATE `item_basic` SET name = @ARGENTITE_SOLLERETS_NAME, sortname = @ARGENTITE_SOLLERETS_NAME WHERE itemid = @ARGENTITE_SOLLERETS;

DELETE FROM `item_mods` WHERE itemId IN (
    @ARGENTITE_GALEA, @ARGENTITE_HAUBERT, @ARGENTITE_MOUFLES, @ARGENTITE_BRAYETTES, @ARGENTITE_SOLLERETS
);

INSERT INTO `item_mods` VALUES
    (@ARGENTITE_GALEA,     @MOD_DEF,                22),
    -- TODO:

    (@ARGENTITE_HAUBERT,   @MOD_DEF,                44),
    -- TODO:
    -- VIT, Enmity+, Attack+, Light+

    (@ARGENTITE_MOUFLES,   @MOD_DEF,                15),
    -- TODO:

    (@ARGENTITE_BRAYETTES, @MOD_DEF,                31),
    -- TODO:

    (@ARGENTITE_SOLLERETS, @MOD_DEF,                12);
    -- TODO:

-----------------------------------
-- Wurtzite Doublet Set (Lv40)
-- MNK, THF, BST, RNG, NIN, COR, PUP, DNC
-----------------------------------
SET @WURTZITE_BERET      = 25614;
SET @WURTZITE_DOUBLET    = 25687;
SET @WURTZITE_GLOVES     = 27118;
SET @WURTZITE_BRAIS      = 25897;
SET @WURTZITE_GAITERS    = 25964;

SET @HYDRA_DOUBLET_MODEL   = 132;
SET @WURTZITE_BERET_NAME   = 'wurtzite_beret';
SET @WURTZITE_DOUBLET_NAME = 'wurtzite_doublet';
SET @WURTZITE_GLOVES_NAME  = 'wurtzite_gloves';
SET @WURTZITE_BRAIS_NAME   = 'wurtzite_brais';
SET @WURTZITE_GAITERS_NAME = 'wurtzite_gaiters';

DELETE FROM `item_equipment` WHERE itemId IN (
    @WURTZITE_BERET, @WURTZITE_DOUBLET, @WURTZITE_GLOVES, @WURTZITE_BRAIS, @WURTZITE_GAITERS
);

INSERT INTO `item_equipment` VALUES
    (@WURTZITE_BERET,   @WURTZITE_BERET_NAME,   @LOW_LEVEL_SET, 0, @LIGHT_JOBS, @HYDRA_DOUBLET_MODEL, 0, 0, @SLOT_HEAD,  0, 0, 0),
    (@WURTZITE_DOUBLET, @WURTZITE_DOUBLET_NAME, @LOW_LEVEL_SET, 0, @LIGHT_JOBS, @HYDRA_DOUBLET_MODEL, 0, 0, @SLOT_BODY,  0, 0, 0),
    (@WURTZITE_GLOVES,  @WURTZITE_GLOVES_NAME,  @LOW_LEVEL_SET, 0, @LIGHT_JOBS, @HYDRA_DOUBLET_MODEL, 0, 0, @SLOT_HANDS, 0, 0, 0),
    (@WURTZITE_BRAIS,   @WURTZITE_BRAIS_NAME,   @LOW_LEVEL_SET, 0, @LIGHT_JOBS, @HYDRA_DOUBLET_MODEL, 0, 0, @SLOT_LEGS,  0, 0, 0),
    (@WURTZITE_GAITERS, @WURTZITE_GAITERS_NAME, @LOW_LEVEL_SET, 0, @LIGHT_JOBS, @HYDRA_DOUBLET_MODEL, 0, 0, @SLOT_FEET,  0, 0, 0);

UPDATE `item_basic` SET name = @WURTZITE_BERET_NAME,   sortname = @WURTZITE_BERET_NAME   WHERE itemid = @WURTZITE_BERET;
UPDATE `item_basic` SET name = @WURTZITE_DOUBLET_NAME, sortname = @WURTZITE_DOUBLET_NAME WHERE itemid = @WURTZITE_DOUBLET;
UPDATE `item_basic` SET name = @WURTZITE_GLOVES_NAME,  sortname = @WURTZITE_GLOVES_NAME  WHERE itemid = @WURTZITE_GLOVES;
UPDATE `item_basic` SET name = @WURTZITE_BRAIS_NAME,   sortname = @WURTZITE_BRAIS_NAME   WHERE itemid = @WURTZITE_BRAIS;
UPDATE `item_basic` SET name = @WURTZITE_GAITERS_NAME, sortname = @WURTZITE_GAITERS_NAME WHERE itemid = @WURTZITE_GAITERS;

DELETE FROM `item_mods` WHERE itemId IN (
    @WURTZITE_BERET, @WURTZITE_DOUBLET, @WURTZITE_GLOVES, @WURTZITE_BRAIS, @WURTZITE_GAITERS
);

INSERT INTO `item_mods` VALUES
    (@WURTZITE_BERET,   @MOD_DEF,                15),
    -- TODO:

    (@WURTZITE_DOUBLET, @MOD_DEF,                29),
    -- TODO:
    -- AGI, Accuracy, Fire+

    (@WURTZITE_GLOVES,  @MOD_DEF,                10),
    -- TODO:

    (@WURTZITE_BRAIS,   @MOD_DEF,                21),
    -- TODO:

    (@WURTZITE_GAITERS, @MOD_DEF,                 9);
    -- TODO:

-----------------------------------
-- Sylvanite Harness Set (Lv60)
-- MNK, THF, BST, RNG, NIN, COR, PUP, DNC
-----------------------------------
SET @SYLVANITE_MASK      = 25612;
SET @SYLVANITE_HARNESS   = 25685;
SET @SYLVANITE_GLOVES    = 27116;
SET @SYLVANITE_BRAIS     = 27301;
SET @SYLVANITE_BOOTS     = 27472;

SET @EBUR_HARNESS_MODEL     = 248;
SET @SYLVANITE_MASK_NAME    = 'sylvanite_mask';
SET @SYLVANITE_HARNESS_NAME = 'sylvanite_harness';
SET @SYLVANITE_GLOVES_NAME  = 'sylvanite_gloves';
SET @SYLVANITE_BRAIS_NAME   = 'sylvanite_brais';
SET @SYLVANITE_GAITERS_NAME = 'sylvanite_gaiters';

DELETE FROM `item_equipment` WHERE itemId IN (
    @SYLVANITE_MASK, @SYLVANITE_HARNESS, @SYLVANITE_GLOVES, @SYLVANITE_BRAIS, @SYLVANITE_GAITERS
);

INSERT INTO `item_equipment` VALUES
    (@SYLVANITE_MASK,   @SYLVANITE_MASK_NAME,     @MID_LEVEL_SET, 0, @LIGHT_JOBS, @EBUR_HARNESS_MODEL, 0, 0, @SLOT_HEAD,  0, 0, 0),
    (@SYLVANITE_HARNESS, @SYLVANITE_HARNESS_NAME, @MID_LEVEL_SET, 0, @LIGHT_JOBS, @EBUR_HARNESS_MODEL, 0, 0, @SLOT_BODY,  0, 0, 0),
    (@SYLVANITE_GLOVES,  @SYLVANITE_GLOVES_NAME,  @MID_LEVEL_SET, 0, @LIGHT_JOBS, @EBUR_HARNESS_MODEL, 0, 0, @SLOT_HANDS, 0, 0, 0),
    (@SYLVANITE_BRAIS,   @SYLVANITE_BRAIS_NAME,   @MID_LEVEL_SET, 0, @LIGHT_JOBS, @EBUR_HARNESS_MODEL, 0, 0, @SLOT_LEGS,  0, 0, 0),
    (@SYLVANITE_GAITERS, @SYLVANITE_GAITERS_NAME, @MID_LEVEL_SET, 0, @LIGHT_JOBS, @EBUR_HARNESS_MODEL, 0, 0, @SLOT_FEET,  0, 0, 0);

UPDATE `item_basic` SET name = @SYLVANITE_MASK_NAME,    sortname = @SYLVANITE_MASK_NAME    WHERE itemid = @SYLVANITE_MASK;
UPDATE `item_basic` SET name = @SYLVANITE_HARNESS_NAME, sortname = @SYLVANITE_HARNESS_NAME WHERE itemid = @SYLVANITE_HARNESS;
UPDATE `item_basic` SET name = @SYLVANITE_GLOVES_NAME,  sortname = @SYLVANITE_GLOVES_NAME  WHERE itemid = @SYLVANITE_GLOVES;
UPDATE `item_basic` SET name = @SYLVANITE_BRAIS_NAME,   sortname = @SYLVANITE_BRAIS_NAME   WHERE itemid = @SYLVANITE_BRAIS;
UPDATE `item_basic` SET name = @SYLVANITE_GAITERS_NAME, sortname = @SYLVANITE_GAITERS_NAME WHERE itemid = @SYLVANITE_GAITERS;

DELETE FROM `item_mods` WHERE itemId IN (
    @SYLVANITE_MASK, @SYLVANITE_HARNESS, @SYLVANITE_GLOVES, @SYLVANITE_BRAIS, @SYLVANITE_BOOTS
);

INSERT INTO `item_mods` VALUES
    (@SYLVANITE_MASK,    @MOD_DEF,                18),
    -- TODO:

    (@SYLVANITE_HARNESS, @MOD_DEF,                39),
    -- TODO:
    -- AGI, Accuracy, Wind+

    (@SYLVANITE_GLOVES,  @MOD_DEF,                13),
    -- TODO:

    (@SYLVANITE_BRAIS,   @MOD_DEF,                28),
    -- TODO:

    (@SYLVANITE_BOOTS,   @MOD_DEF,                11);
    -- TODO:

-----------------------------------
-- Magnetite Saio Set (Lv40)
-- WHM, BLM, RDM, BRD, SMN, BLU, SCH, GEO
-----------------------------------
SET @MAGNETITE_CHAPEAU   = 26736;
SET @MAGNETITE_SAIO      = 26894;
SET @MAGNETITE_CUFFS     = 27048;
SET @MAGNETITE_SLOPS     = 27235;
SET @MAGNETITE_PIGACHES  = 27405;

SET @BLACK_TRADERS_MODEL     = 161;
SET @MAGNETITE_CHAPEAU_NAME  = 'magnetite_chapeau';
SET @MAGNETITE_SAIO_NAME     = 'magnetite_saio';
SET @MAGNETITE_CUFFS_NAME    = 'magnetite_cuffs';
SET @MAGNETITE_SLOPS_NAME    = 'magnetite_slops';
SET @MAGNETITE_PIGACHES_NAME = 'magnetite_pigaches';

DELETE FROM `item_equipment` WHERE itemId IN (
    @MAGNETITE_CHAPEAU, @MAGNETITE_SAIO, @MAGNETITE_CUFFS, @MAGNETITE_SLOPS, @MAGNETITE_PIGACHES
);

INSERT INTO `item_equipment` VALUES
    (@MAGNETITE_CHAPEAU,  @MAGNETITE_CHAPEAU_NAME,  @LOW_LEVEL_SET, 0, @MAGE_JOBS, @BLACK_TRADERS_MODEL, 0, 0, @SLOT_HEAD,  0, 0, 0),
    (@MAGNETITE_SAIO,     @MAGNETITE_SAIO_NAME,     @LOW_LEVEL_SET, 0, @MAGE_JOBS, @BLACK_TRADERS_MODEL, 0, 0, @SLOT_BODY,  0, 0, 0),
    (@MAGNETITE_CUFFS,    @MAGNETITE_CUFFS_NAME,    @LOW_LEVEL_SET, 0, @MAGE_JOBS, @BLACK_TRADERS_MODEL, 0, 0, @SLOT_HANDS, 0, 0, 0),
    (@MAGNETITE_SLOPS,    @MAGNETITE_SLOPS_NAME,    @LOW_LEVEL_SET, 0, @MAGE_JOBS, @BLACK_TRADERS_MODEL, 0, 0, @SLOT_LEGS,  0, 0, 0),
    (@MAGNETITE_PIGACHES, @MAGNETITE_PIGACHES_NAME, @LOW_LEVEL_SET, 0, @MAGE_JOBS, @BLACK_TRADERS_MODEL, 0, 0, @SLOT_FEET,  0, 0, 0);

UPDATE `item_basic` SET name = @MAGNETITE_CHAPEAU_NAME,  sortname = @MAGNETITE_CHAPEAU_NAME  WHERE itemid = @MAGNETITE_CHAPEAU;
UPDATE `item_basic` SET name = @MAGNETITE_SAIO_NAME,     sortname = @MAGNETITE_SAIO_NAME     WHERE itemid = @MAGNETITE_SAIO;
UPDATE `item_basic` SET name = @MAGNETITE_CUFFS_NAME,    sortname = @MAGNETITE_CUFFS_NAME    WHERE itemid = @MAGNETITE_CUFFS;
UPDATE `item_basic` SET name = @MAGNETITE_SLOPS_NAME,    sortname = @MAGNETITE_SLOPS_NAME    WHERE itemid = @MAGNETITE_SLOPS;
UPDATE `item_basic` SET name = @MAGNETITE_PIGACHES_NAME, sortname = @MAGNETITE_PIGACHES_NAME WHERE itemid = @MAGNETITE_PIGACHES;

DELETE FROM `item_mods` WHERE itemId IN (
    @MAGNETITE_CHAPEAU, @MAGNETITE_SAIO, @MAGNETITE_CUFFS, @MAGNETITE_SLOPS, @MAGNETITE_PIGACHES
);

INSERT INTO `item_mods` VALUES
    (@MAGNETITE_CHAPEAU,  @MOD_DEF,                12),
    -- TODO:

    (@MAGNETITE_SAIO,     @MOD_DEF,                24),
    -- TODO:
    -- INT, M.Accuracy, Dark+

    (@MAGNETITE_CUFFS,    @MOD_DEF,                 8),
    -- TODO:

    (@MAGNETITE_SLOPS,    @MOD_DEF,                17),
    -- TODO:

    (@MAGNETITE_PIGACHES, @MOD_DEF,                 7);
    -- TODO:

-----------------------------------
-- Goethite Coat Set (Lv60)
-- WHM, BLM, RDM, BRD, SMN, BLU, SCH, GEO
-----------------------------------
SET @GOETHITE_HAT        = 25616;
SET @GOETHITE_COAT       = 25689;
SET @GOETHITE_CUFFS      = 27120;
SET @GOETHITE_PANTS      = 27305;
SET @GOETHITE_SABOTS     = 27476;

SET @FURIA_COAT_MODEL     = 262;
SET @GOETHITE_HAT_NAME    = 'goethite_hat';
SET @GOETHITE_COAT_NAME   = 'goethite_coat';
SET @GOETHITE_CUFFS_NAME  = 'goethite_cuffs';
SET @GOETHITE_PANTS_NAME  = 'goethite_pants';
SET @GOETHITE_SABOTS_NAME = 'goethite_sabots';

DELETE FROM `item_equipment` WHERE itemId IN (
    @GOETHITE_HAT, @GOETHITE_COAT, @GOETHITE_CUFFS, @GOETHITE_PANTS, @GOETHITE_SABOTS
);

INSERT INTO `item_equipment` VALUES
    (@GOETHITE_HAT,    @GOETHITE_HAT_NAME,    @MID_LEVEL_SET, 0, @MAGE_JOBS, @FURIA_COAT_MODEL, 0, 0, @SLOT_HEAD,  0, 0, 0),
    (@GOETHITE_COAT,   @GOETHITE_COAT_NAME,   @MID_LEVEL_SET, 0, @MAGE_JOBS, @FURIA_COAT_MODEL, 0, 0, @SLOT_BODY,  0, 0, 0),
    (@GOETHITE_CUFFS,  @GOETHITE_CUFFS_NAME,  @MID_LEVEL_SET, 0, @MAGE_JOBS, @FURIA_COAT_MODEL, 0, 0, @SLOT_HANDS, 0, 0, 0),
    (@GOETHITE_PANTS,  @GOETHITE_PANTS_NAME,  @MID_LEVEL_SET, 0, @MAGE_JOBS, @FURIA_COAT_MODEL, 0, 0, @SLOT_LEGS,  0, 0, 0),
    (@GOETHITE_SABOTS, @GOETHITE_SABOTS_NAME, @MID_LEVEL_SET, 0, @MAGE_JOBS, @FURIA_COAT_MODEL, 0, 0, @SLOT_FEET,  0, 0, 0);

UPDATE `item_basic` SET name = @GOETHITE_HAT_NAME,    sortname = @GOETHITE_HAT_NAME    WHERE itemid = @GOETHITE_HAT;
UPDATE `item_basic` SET name = @GOETHITE_COAT_NAME,   sortname = @GOETHITE_COAT_NAME   WHERE itemid = @GOETHITE_COAT;
UPDATE `item_basic` SET name = @GOETHITE_CUFFS_NAME,  sortname = @GOETHITE_CUFFS_NAME  WHERE itemid = @GOETHITE_CUFFS;
UPDATE `item_basic` SET name = @GOETHITE_PANTS_NAME,  sortname = @GOETHITE_PANTS_NAME  WHERE itemid = @GOETHITE_PANTS;
UPDATE `item_basic` SET name = @GOETHITE_SABOTS_NAME, sortname = @GOETHITE_SABOTS_NAME WHERE itemid = @GOETHITE_SABOTS;

DELETE FROM `item_mods` WHERE itemId IN (
    @GOETHITE_HAT, @GOETHITE_COAT, @GOETHITE_CUFFS, @GOETHITE_PANTS, @GOETHITE_SABOTS
);

INSERT INTO `item_mods` VALUES
    (@GOETHITE_HAT,      @MOD_DEF,                18),
    -- TODO:

    (@GOETHITE_COAT,     @MOD_DEF,                34),
    -- TODO:
    -- INT, MAB, Pet, Lightning

    (@GOETHITE_CUFFS,    @MOD_DEF,                12),
    -- TODO:

    (@GOETHITE_PANTS,    @MOD_DEF,                24),
    -- TODO:

    (@GOETHITE_SABOTS,   @MOD_DEF,                10);


SET @SAPPHIRE_MASK      = 23812;
SET @SAPPHIRE_PLATEMAIL = 23813;
SET @SAPPHIRE_GAUNTLETS = 23814;
SET @SAPPHIRE_TROUSERS  = 23815;
SET @SAPPHIRE_LEGGINGS  = 23816;

SET @JADEITE_VISOR      = 23817;
SET @JADEITE_CUIRIE     = 23818;
SET @JADEITE_GLOVES     = 23819;
SET @JADEITE_CHAUSSES   = 23820;
SET @JADEITE_JAMBEAUX   = 23821;

SET @RUBY_CORONAL       = 23832;
SET @RUBY_ROBE          = 23833;
SET @RUBY_CUFFS         = 23834;
SET @RUBY_SLOPS         = 23835;
SET @RUBY_PIGACHES      = 23836;

-- WAR, PLD, DRK, SAM, DRG, RUN
UPDATE `item_equipment` set jobs = 2107585 WHERE itemId IN (
    @SAPPHIRE_MASK, @SAPPHIRE_PLATEMAIL, @SAPPHIRE_GAUNTLETS, @SAPPHIRE_TROUSERS, @SAPPHIRE_LEGGINGS
);

DELETE FROM `item_mods` WHERE itemId IN (
    @SAPPHIRE_MASK, @SAPPHIRE_PLATEMAIL, @SAPPHIRE_GAUNTLETS, @SAPPHIRE_TROUSERS, @SAPPHIRE_LEGGINGS
);

INSERT INTO `item_mods` VALUES
    (@SAPPHIRE_MASK,      @MOD_DEF,                28),
    (@SAPPHIRE_MASK,      @MOD_ATT,                15),
    (@SAPPHIRE_MASK,      @MOD_ACC,                 5),
    (@SAPPHIRE_MASK,      @MOD_ENMITY,              4),
    (@SAPPHIRE_MASK,      @MOD_VIT,                 4),

    (@SAPPHIRE_PLATEMAIL, @MOD_DEF,                54),
    (@SAPPHIRE_PLATEMAIL, @MOD_ATT,                18),
    (@SAPPHIRE_PLATEMAIL, @MOD_MAGIC_DMG_TAKEN_II,  5),
    (@SAPPHIRE_PLATEMAIL, @MOD_ENMITY,              7),
    (@SAPPHIRE_PLATEMAIL, @MOD_VIT,                 7),

    (@SAPPHIRE_GAUNTLETS, @MOD_DEF,                20),
    (@SAPPHIRE_GAUNTLETS, @MOD_ATT,                15),
    (@SAPPHIRE_GAUNTLETS, @MOD_ENMITY,              6),
    (@SAPPHIRE_GAUNTLETS, @MOD_VIT,                 6),

    (@SAPPHIRE_TROUSERS,  @MOD_DEF,                35),
    (@SAPPHIRE_TROUSERS,  @MOD_ATT,                12),
    (@SAPPHIRE_TROUSERS,  @MOD_ENMITY,              5),
    (@SAPPHIRE_TROUSERS,  @MOD_VIT,                 5),

    (@SAPPHIRE_LEGGINGS,  @MOD_DEF,                20),
    (@SAPPHIRE_LEGGINGS,  @MOD_ATT,                 8),
    (@SAPPHIRE_LEGGINGS,  @MOD_ENMITY,              6),
    (@SAPPHIRE_LEGGINGS,  @MOD_VIT,                 6);

-- MNK, THF, BST, RNG, NIN, COR, PUP, DNC
UPDATE `item_equipment` set jobs = 464162 WHERE itemId IN (
    @JADEITE_VISOR, @JADEITE_CUIRIE, @JADEITE_GLOVES, @JADEITE_CHAUSSES, @JADEITE_JAMBEAUX
);

DELETE FROM `item_mods` WHERE itemId IN (
    @JADEITE_VISOR, @JADEITE_CUIRIE, @JADEITE_GLOVES, @JADEITE_CHAUSSES, @JADEITE_JAMBEAUX
);

INSERT INTO `item_mods` VALUES
    (@JADEITE_VISOR,       @MOD_DEF,                 1),
    (@JADEITE_CUIRIE,      @MOD_DEF,                 1),
    (@JADEITE_GLOVES,      @MOD_DEF,                 1),
    (@JADEITE_CHAUSSES,    @MOD_DEF,                 1),
    (@JADEITE_JAMBEAUX,    @MOD_DEF,                 1);
-- Martial Arts
-- Pet: Attack
-- AGI
-- DEX
-- Waltz?
-- Crit

-- WHM, BLM, RDM, BRD, SMN, BLU, SCH, GEO
UPDATE `item_equipment` set jobs = 1622556 WHERE itemId IN (
    @RUBY_CORONAL, @RUBY_ROBE, @RUBY_CUFFS, @RUBY_SLOPS, @RUBY_PIGACHES
);

DELETE FROM `item_mods` WHERE itemId IN (
    @RUBY_CORONAL, @RUBY_ROBE, @RUBY_CUFFS, @RUBY_SLOPS, @RUBY_PIGACHES
);

INSERT INTO `item_mods` VALUES
    (@RUBY_CORONAL,       @MOD_DEF,                 1),
    (@RUBY_ROBE,          @MOD_DEF,                 1),
    (@RUBY_CUFFS,         @MOD_DEF,                 1),
    (@RUBY_SLOPS,         @MOD_DEF,                 1),
    (@RUBY_PIGACHES,      @MOD_DEF,                 1);

-- MAB
-- Pet: MAB
-- Pet: DT
-- Refresh
-- MP
-- MND
-- Attack +10
-- Enmity-

UPDATE `item_equipment` SET level = 72, ilevel = 0, su_level = 0 WHERE itemId IN (
    @SAPPHIRE_MASK, @JADEITE_VISOR, @RUBY_CORONAL
);

UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId IN (
    @SAPPHIRE_GAUNTLETS, @SAPPHIRE_LEGGINGS,
    @JADEITE_GLOVES, @JADEITE_JAMBEAUX,
    @RUBY_CUFFS, @RUBY_PIGACHES
);

UPDATE `item_equipment` SET level = 74, ilevel = 0, su_level = 0 WHERE itemId IN (
    @SAPPHIRE_TROUSERS, @JADEITE_CHAUSSES, @RUBY_SLOPS
);

UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId IN (
    @SAPPHIRE_PLATEMAIL, @JADEITE_CUIRIE, @RUBY_ROBE
);

-- Clear ITEM_FLAG_MYSTERY_BOX from item
UPDATE item_basic SET
    item_basic.flags = item_basic.flags & ~0x0004
WHERE (item_basic.flags & 0x0004) AND item_basic.itemId IN (
    -- WAR, PLD, DRK, SAM, DRG, RUN
    @AZURITE_ARMET,
    @AZURITE_CUIRASS,
    @AZURITE_GAUNTLETS,
    @AZURITE_CUISSES,
    @AZURITE_SABATONS,

    @ARGENTITE_GALEA,
    @ARGENTITE_HAUBERT,
    @ARGENTITE_MOUFLES,
    @ARGENTITE_BRAYETTES,
    @ARGENTITE_SOLLERETS,

    @SAPPHIRE_MASK,
    @SAPPHIRE_PLATEMAIL,
    @SAPPHIRE_GAUNTLETS,
    @SAPPHIRE_TROUSERS,
    @SAPPHIRE_LEGGINGS,

    -- MNK, THF, BST, RNG, NIN, COR, PUP, DNC
    @WURTZITE_BERET,
    @WURTZITE_DOUBLET,
    @WURTZITE_GLOVES,
    @WURTZITE_BRAIS,
    @WURTZITE_GAITERS,

    @SYLVANITE_MASK,
    @SYLVANITE_HARNESS,
    @SYLVANITE_GLOVES,
    @SYLVANITE_BRAIS,
    @SYLVANITE_BOOTS,

    @JADEITE_VISOR,
    @JADEITE_CUIRIE,
    @JADEITE_GLOVES,
    @JADEITE_CHAUSSES,
    @JADEITE_JAMBEAUX,

    -- WHM, BLM, RDM, BRD, SMN, BLU, SCH, GEO
    @MAGNETITE_CHAPEAU,
    @MAGNETITE_SAIO,
    @MAGNETITE_CUFFS,
    @MAGNETITE_SLOPS,
    @MAGNETITE_PIGACHES,

    @GOETHITE_HAT,
    @GOETHITE_COAT,
    @GOETHITE_CUFFS,
    @GOETHITE_PANTS,
    @GOETHITE_SABOTS,

    @RUBY_CORONAL,
    @RUBY_ROBE,
    @RUBY_CUFFS,
    @RUBY_SLOPS,
    @RUBY_PIGACHES
);
