-- ----------------------
-- Mob Relocation Updates
-- ----------------------

-- Valkurm Dunes, Goblin Leecher, Outpost Patrol
UPDATE mob_spawn_points SET pos_x = 210.481, pos_y = -6.946, pos_z = 101.274 WHERE mobid = 17199305;

-- Move very dangerous mobs from Crystal Warriorstarting areas

-- King Ranperre's Tomb
DELETE FROM `mob_spawn_points` WHERE mobid = 17555726;
INSERT INTO `mob_spawn_points` VALUES (17555726,'Plague_Bats','Plague_Bats',20,157.225,0.000,237.981,1);

-- Dangruf Wadi
DELETE FROM `nm_spawn_points` WHERE mobid = 17559558 AND pos = 2;
INSERT INTO `nm_spawn_points` VALUES (17559558,2,-412.532,4.000,42.275); -- Geyser Lizard

-- Toraimarai Canal
DELETE FROM `mob_spawn_points` WHERE mobid = 17469663;
DELETE FROM `mob_spawn_points` WHERE mobid = 17469665;
INSERT INTO `mob_spawn_points` VALUES (17469663,'Impish_Bats','Impish Bats',33,68.530,24.000,-21.890,143);
INSERT INTO `mob_spawn_points` VALUES (17469665,'Impish_Bats','Impish Bats',33,56.739,23.250,-37.431,227);

-- Castle Oztroja
DELETE FROM `mob_spawn_points` WHERE mobid = 17395990; -- Yagudo Zealot
DELETE FROM `mob_spawn_points` WHERE mobid = 17395991; -- Yagudo Lutenist
INSERT INTO `mob_spawn_points` VALUES (17395990,'Yagudo_Zealot','Yagudo Zealot',19,-167.000,-16.256,184.500,32);
INSERT INTO `mob_spawn_points` VALUES (17395991,'Yagudo_Lutenist','Yagudo Lutenist',23,-166.490,-16.176,191.291,96);

-- Relocates dangerous monsters away from outposts
-- Valkurm Dunes
UPDATE mob_spawn_points SET pos_x = 210.481, pos_y = -6.946, pos_z = 101.274 WHERE mobname = 'Goblin_Leecher' AND pos_x = 184.673 AND pos_y = -7.710 AND pos_z = 106.691;

-- Buburimu Peninsula
UPDATE mob_spawn_points SET pos_x = -396.957, pos_y = -32.261, pos_z = 44.893 WHERE mobname = 'Goblin_Shepherd' AND pos_x = -166.429 AND pos_y = 7.910 AND pos_z = -105.478;
UPDATE mob_spawn_points SET pos_x = -411.430, pos_y = -31.429, pos_z =  3.221 WHERE mobname = 'Goblin_Bandit'   AND pos_x = -134.000 AND pos_y = 7.000 AND pos_z = -96;

-- Cape Teriggan
UPDATE mob_spawn_points SET pos_x = -75.189, pos_y = -1.413, pos_z = -130.057 WHERE mobname = 'Goblin_Mercenary' AND pos_x = -139.706 AND pos_y = 7.167 AND pos_z = -61.223;
UPDATE mob_spawn_points SET pos_x =  -7.247, pos_y =  0.161, pos_z =    0.709 WHERE mobname = 'Goblin_Mercenary' AND pos_x = -144.000 AND pos_y = 8.000 AND pos_z = -21.000;
UPDATE mob_spawn_points SET pos_x = -61.728, pos_y = -1.335, pos_z =  -99.354 WHERE mobname = 'Goblin_Bandit'    AND pos_x = -154.915 AND pos_y = 7.554 AND pos_z = -38.958;
UPDATE mob_spawn_points SET pos_x = -37.084, pos_y =  0.000, pos_z =  -37.121 WHERE mobname = 'Goblin_Robber'    AND pos_x = -239.932 AND pos_y = 8.205 AND pos_z = -222.775;
UPDATE mob_spawn_points SET pos_x = -24.580, pos_y =  0.737, pos_z =  -82.615 WHERE mobname = 'Goblin_Robber'    AND pos_x = -232.230 AND pos_y = 7.024 AND pos_z = -273.263;

-- Eastern Altepa Desert
UPDATE mob_spawn_points SET pos_x = -325.870, pos_y = 7.453, pos_z = -196.602 WHERE mobname = 'Goblin_Ambusher' AND pos_x = -521.287 AND pos_y = -32.811 AND pos_z = 85.324;
UPDATE mob_spawn_points SET pos_x = -146.846, pos_y = 8.510, pos_z = -239.809 WHERE mobname = 'Goblin_Butcher'  AND pos_x = -482.059 AND pos_y = -31.970 AND pos_z = 67.880;

-- Yuhtunga Jungle
UPDATE mob_spawn_points SET pos_x = -190.317, pos_y = -0.048, pos_z = -340.674 WHERE mobname = 'Goblin_Furrier' AND pos_x = -224.306 AND pos_y = -1.550 AND pos_z = -358.469;
UPDATE mob_spawn_points SET pos_x = -291.329, pos_y = -0.013, pos_z = -351.107 WHERE mobname = 'Goblin_Furrier' AND pos_x = -238.298 AND pos_y = -0.420 AND pos_z = -366.293;

-- Yhoator Jungle
UPDATE mob_spawn_points SET pos_x = 244.705, pos_y = 0.000, pos_z = -162.007 WHERE mobname = 'Tonberry_Hexer'    AND pos_x = 236.941 AND pos_y = -0.50  AND pos_z = -82.527;
UPDATE mob_spawn_points SET pos_x = 230.252, pos_y = 0.600, pos_z = -190.586 WHERE mobname = 'Tonberry_Creeper'  AND pos_x = 236.445 AND pos_y = 0.017  AND pos_z = -99.661;
UPDATE mob_spawn_points SET pos_x = 207.793, pos_y = 0.594, pos_z = -174.136 WHERE mobname = 'Tonberry_Harasser' AND pos_x = 231.520 AND pos_y = -0.125 AND pos_z = -101.445;

-- North Gustaberg (S)
UPDATE mob_spawn_points SET pos_x =-525.911, pos_y = 39.690, pos_z = 7.759 WHERE mobname = 'Goblin_Skirmisher' AND pos_x = -396.666 AND pos_y = 46.627 AND pos_z = -95.098;

--  Mob relocations for Ventures to create camps
-- Aydeewa Subterrane
UPDATE mob_spawn_points SET pos_x = 282.110, pos_y = 33.780, pos_z = -90.898   WHERE mobid = 17056072;    -- Slime Mold out of Leech camp at PW
UPDATE mob_spawn_points SET pos_x = 194.773, pos_y = 34.021, pos_z = -112.216  WHERE mobid = 17056085;    -- Slug switches camps with the Slime
UPDATE mob_spawn_points SET pos_x = 273.297, pos_y = 33.879, pos_z = -77.816   WHERE mobid = 17056078;    -- Slime Mold out of Leech camp at PW
UPDATE mob_spawn_points SET pos_x = 208.211, pos_y = 33.968, pos_z = -119.715  WHERE mobid = 17056088;    -- Slug switches camps with the Slime
-- Map 2
UPDATE mob_spawn_points SET pos_x = 278.806, pos_y = 39.824, pos_z = 23.302    WHERE mobid = 17055770;    -- Qiqirn Enterpriser (I-9) to (K-8)
UPDATE mob_spawn_points SET pos_x = 255.872, pos_y = 39.180, pos_z = 21.163    WHERE mobid = 17055772;    -- Qiqirn Lieuter (I-8) to (K-8)
UPDATE mob_spawn_points SET pos_x = 268.677, pos_y = 39.392, pos_z = 26.936    WHERE mobid = 17055774;    -- Qiqirn Enterpriser (I-8) to (K-8)
UPDATE mob_spawn_points SET pos_x = 293.303, pos_y = 39.332, pos_z = 28.332    WHERE mobid = 17055788;    -- Qiqirn Enterpriser (H-9) to (K-8)
UPDATE mob_spawn_points SET pos_x = 296.818, pos_y = 39.828, pos_z = 42.222    WHERE mobid = 17055789;    -- Qiqirn Enterpriser (I-9) to (K-8)
UPDATE mob_spawn_points SET pos_x = 291.913, pos_y = 39.316, pos_z = 53.062    WHERE mobid = 17055790;    -- Qiqirn Enterpriser (H-10) to (K-8)
UPDATE mob_spawn_points SET pos_x = 260.016, pos_y = 39.137, pos_z = 59.963    WHERE mobid = 17055791;    -- Qiqirn Lieuter (F-9) to (K-8)
UPDATE mob_spawn_points SET pos_x = 277.499, pos_y = 39.838, pos_z = 56.156    WHERE mobid = 17055793;    -- Qiqirn Enterpriser (F-9) to (K-8)
UPDATE mob_spawn_points SET pos_x = 266.963, pos_y = 39.450, pos_z = 47.274    WHERE mobid = 17055799;    -- Qiqirn Enterpriser (E-8) to (K-8)
UPDATE mob_spawn_points SET pos_x = 254.972, pos_y = 39.837, pos_z = 90.780    WHERE mobid = 17055819;    -- Defoliator (K-8) to (K-7)
UPDATE mob_spawn_points SET pos_x = 249.744, pos_y = 39.785, pos_z = 127.226   WHERE mobid = 17055820;    -- Defoliator (K-8) to (K-7)
UPDATE mob_spawn_points SET pos_x = 192.704, pos_y = 39.827, pos_z = 129.062   WHERE mobid = 17055821;    -- Defoliator (K-8) to (J-7)
UPDATE mob_spawn_points SET pos_x = 118.960, pos_y = 36.806, pos_z = 5.887     WHERE mobid = 17055822;    -- Defoliator (K-8) to (J-8)
UPDATE mob_spawn_points SET pos_x = 111.581, pos_y = 37.012, pos_z = -44.485   WHERE mobid = 17055832;    -- Aydeewa Diremite (I-9) slightly away from hill
UPDATE mob_spawn_points SET pos_x = 170.797, pos_y = 36.774, pos_z = -39.944   WHERE mobid = 17055834;    -- Aydeewa Diremite (J-9) slightly away from hill
UPDATE mob_spawn_points SET pos_x = 97.047, pos_y = 36.264, pos_z = -73.117    WHERE mobid = 17055835;    -- Fossorial Flea (J-9) off hill to (I-9)
UPDATE mob_spawn_points SET pos_x = 90.808, pos_y = 36.370, pos_z = -99.860    WHERE mobid = 17055836;    -- Fossorial Flea (J-9) off hill to (I-10)
UPDATE mob_spawn_points SET pos_x = -331.845, pos_y = 8.332, pos_z = 67.049    WHERE mobid = 17055868;    -- Deforester room (D-7/8) link reduction
UPDATE mob_spawn_points SET pos_x = -301.261, pos_y = 9.994, pos_z = 55.705    WHERE mobid = 17055869;    -- Deforester room (D-7/8) link reduction
UPDATE mob_spawn_points SET pos_x = -329.075, pos_y = 8.418, pos_z = 95.233    WHERE mobid = 17055871;    -- Deforester room (D-7/8) link reduction
UPDATE mob_spawn_points SET pos_x = -316.679, pos_y = 8.727, pos_z = 97.094    WHERE mobid = 17055872;    -- Deforester room (D-7/8) link reduction
UPDATE mob_spawn_points SET pos_x = -302.616, pos_y = 8.216, pos_z = 99.977    WHERE mobid = 17055873;    -- Deforester room (D-7/8) link reduction
UPDATE mob_spawn_points SET pos_x = -310.350, pos_y = 8.385, pos_z = 63.288    WHERE mobid = 17055874;    -- Deforester room (D-7/8) link reduction
UPDATE mob_spawn_points SET pos_x = -267.456, pos_y = 8.865, pos_z = 79.422    WHERE mobid = 17055875;    -- Deforester room (D-7/8) link reduction
UPDATE mob_spawn_points SET pos_x = -288.356, pos_y = 8.496, pos_z = 63.475    WHERE mobid = 17055876;    -- Deforester room (D-7/8) link reduction
UPDATE mob_spawn_points SET pos_x = -288.430, pos_y = 8.887, pos_z = 96.812    WHERE mobid = 17055877;    -- Deforester room (D-7/8) link reduction
UPDATE mob_spawn_points SET pos_x = -274.334, pos_y = 8.659, pos_z = 97.564    WHERE mobid = 17055878;    -- Deforester room (D-7/8) link reduction
UPDATE mob_spawn_points SET pos_x = 109.973, pos_y = 36.489, pos_z = 11.332    WHERE mobid = 17055984;    -- Aydeewa Diremite (H-6) Map 3 to (I-8) Map 2
UPDATE mob_spawn_points SET pos_x = 132.867, pos_y = 36.398, pos_z = 12.819    WHERE mobid = 17055985;    -- Aydeewa Diremite (H-6) Map 3 to (J-8) Map 2
UPDATE mob_spawn_points SET pos_x = 144.151, pos_y = 36.639, pos_z = -54.704   WHERE mobid = 17055986;    -- Aydeewa Diremite (H-6) Map 3 to (J-9) Map 2
-- Map 3
UPDATE mob_spawn_points SET pos_x = -331.585, pos_y = 36.357, pos_z = -105.991 WHERE mobid = 17055882;    -- Qiqirn Archaeologist (F-7) to (H-6)
UPDATE mob_spawn_points SET pos_x = -319.534, pos_y = 36.912, pos_z = -103.121 WHERE mobid = 17055883;    -- Qiqirn Archaeologist (F-7) to (H-6)
UPDATE mob_spawn_points SET pos_x = -306.618, pos_y = 37.977, pos_z = -106.754 WHERE mobid = 17055893;    -- Qiqirn Archaeologist (G-7) to (H-6)
UPDATE mob_spawn_points SET pos_x = -303.182, pos_y = 36.831, pos_z = -122.072 WHERE mobid = 17055894;    -- Qiqirn Archaeologist (G-7) to (H-6)
UPDATE mob_spawn_points SET pos_x = -346.746, pos_y = 36.223, pos_z = -100.156 WHERE mobid = 17055901;    -- Qiqirn Mosstrooper (G-6) to (H-6)
UPDATE mob_spawn_points SET pos_x = -381.878, pos_y = 39.285, pos_z = -90.090  WHERE mobid = 17055903;    -- Fossorial Flea (H-6) to (G-6)
UPDATE mob_spawn_points SET pos_x = -305.142, pos_y = 36.252, pos_z = -135.303 WHERE mobid = 17055907;    -- Qiqirn Archaeologist (F-7) to (H-6)
UPDATE mob_spawn_points SET pos_x = -474.197, pos_y = 11.539, pos_z = -260.117 WHERE mobid = 17055908;    -- Mold Eater (F-8) to (F-8) spread out links
UPDATE mob_spawn_points SET pos_x = -319.996, pos_y = 36.935, pos_z = -135.392 WHERE mobid = 17055914;    -- Qiqirn Archaeologist (G-8) to (H-6)
UPDATE mob_spawn_points SET pos_x = -330.337, pos_y = 36.759, pos_z = -127.216 WHERE mobid = 17055939;    -- Qiqirn Archaeologist (H-8) to (H-6)
UPDATE mob_spawn_points SET pos_x = -336.275, pos_y = 36.880, pos_z = -119.573 WHERE mobid = 17055940;    -- Qiqirn Archaeologist (H-8) to (H-6)
UPDATE mob_spawn_points SET pos_x = -299.666, pos_y = 36.310, pos_z = -150.854 WHERE mobid = 17055931;    -- Qiqirn Mosstrooper (H-10) to (H-6)
-- Map 5
UPDATE mob_spawn_points SET pos_x = -98.722, pos_y = 36.651, pos_z = -97.203   WHERE mobid = 17056024;    -- Mycoskulker (I-9) link reduction
UPDATE mob_spawn_points SET pos_x = -97.816, pos_y = 35.605, pos_z = -17.776   WHERE mobid = 17056027;    -- Mycoskulker (I-9) link reduction
UPDATE mob_spawn_points SET pos_x = -59.355, pos_y = 35.846, pos_z = -53.463   WHERE mobid = 17056029;    -- Mycoskulker (I-9) link reduction
UPDATE mob_spawn_points SET pos_x = -65.121, pos_y = 36.809, pos_z = -35.193   WHERE mobid = 17056030;    -- Mycoskulker (I-9) link reduction
UPDATE mob_spawn_points SET pos_x = -136.807, pos_y = 36.717, pos_z = -85.804  WHERE mobid = 17056031;    -- Mycoskulker (I-9) link reduction
UPDATE mob_spawn_points SET pos_x = -61.430, pos_y = 36.531, pos_z = -68.545   WHERE mobid = 17056033;    -- Mycoskulker (I-9) link reduction
UPDATE mob_spawn_points SET pos_x = -78.639, pos_y = 36.897, pos_z = -96.084   WHERE mobid = 17056036;    -- Mycoskulker (I-9) link reduction

-- Batallia Downs
UPDATE mob_spawn_points SET pos_x = 183.616, pos_y = 4.836, pos_z = 63.076 WHERE mobid = 17207592;      -- Orcish Beastrider away from coast (Poor capture position)
UPDATE mob_spawn_points SET pos_x = 199.408, pos_y = 8.618, pos_z = 23.763 WHERE mobid = 17207594;      -- Orcish Cursemaker away from coast to make camp viable
UPDATE mob_spawn_points SET pos_x = 197.586, pos_y = 8.916, pos_z = 221.651 WHERE mobid = 17207582;     -- Moves Ba closer to coast camp
UPDATE mob_spawn_points SET pos_x = 176.234, pos_y = 8.101, pos_z = 198.491 WHERE mobid = 17207562;     -- Moves Ba closer to coast camp
UPDATE mob_spawn_points SET pos_x = 226.993, pos_y = 8.497, pos_z = 197.359 WHERE mobid = 17207563;     -- Moves Ba closer to coast camp
UPDATE mob_spawn_points SET pos_x = 172.700, pos_y = 8.545, pos_z = 233.076 WHERE mobid = 17207573;     -- Moves Ba closer to coast camp
UPDATE mob_spawn_points SET pos_x = 75.886, pos_y = 8.328, pos_z = -349.093 WHERE mobid = 17207651;     -- Moves Goblin Furrier out of Eldieme hill camp
UPDATE mob_spawn_points SET pos_x = 113.099, pos_y = 0.773, pos_z = -363.314 WHERE mobid = 17207649;    -- Moves Goblin Pathfinder out of Eldieme hill camp
UPDATE mob_spawn_points SET pos_x = 151.038, pos_y = 2.171, pos_z = -413.339 WHERE mobid = 17207643;    -- Moves Ba closer of Eldieme hill camp
UPDATE mob_spawn_points SET pos_x = 173.135, pos_y = 1.785, pos_z = -386.384 WHERE mobid = 17207618;    -- Moves Ba closer of Eldieme hill camp
UPDATE mob_spawn_points SET pos_x = 159.289, pos_y = 8.00, pos_z = -440.634 WHERE mobid = 17207644;     -- Moves Clipper closer of Eldieme hill camp
UPDATE mob_spawn_points SET pos_x = 185.758, pos_y = 8.572, pos_z = -431.936 WHERE mobid = 17207646;    -- Moves Clipper closer of Eldieme hill camp
UPDATE mob_spawn_points SET pos_x = 105.671, pos_y = 6.481, pos_z = -413.354 WHERE mobid = 17207652;    -- Moves Goblin Shaman to the Eldieme hill camp with the others (Poor capture position)
UPDATE mob_spawn_points SET pos_x = 94.207, pos_y = 6.518, pos_z = -391.832 WHERE mobid = 17207653;     -- Moves Goblin Shaman to the Eldieme hill camp with the others (Poor capture position)

-- Batallia Downs (S)
UPDATE mob_spawn_points SET pos_x = 50.186, pos_y = -8.488, pos_z = -184.214  WHERE mobid = 17121538;      -- Sadfly (G-8) to (I-9) hill
UPDATE mob_spawn_points SET pos_x = 101.430, pos_y = -5.671, pos_z = -169.186 WHERE mobid = 17121543;      -- Sadfly (F-6) to (I-9) hill
UPDATE mob_spawn_points SET pos_x = 173.016, pos_y = 0.497, pos_z = -243.431  WHERE mobid = 17121610;      -- Chaneque (NM) (I-9) hill to (J-9), it isn't supposed to aggro parties, but does
UPDATE mob_spawn_points SET pos_x = 80.827, pos_y = 8.072, pos_z = -365.478   WHERE mobid = 17121645;      -- Ba (I-9) to (I-10)

-- Bhaflau Thickets
UPDATE mob_spawn_points SET pos_x = 57.873, pos_y = -35.913, pos_z = 638.438  WHERE mobid = 16990362;    -- Colorful Treant out of Colibri camp and next to other nearby tree in open spot
UPDATE mob_spawn_points SET pos_x = -15.400, pos_y = -35.672, pos_z = 472.167 WHERE mobid = 16990361;    -- Olden Treant out of Colibri camp and next to other nearby tree close to Dea ZNM spawn
UPDATE mob_spawn_points SET pos_x = 36.744, pos_y = -35.910, pos_z = 537.884  WHERE mobid = 16990357;    -- Colibri into the former Treant's area
UPDATE mob_spawn_points SET pos_x = 60.7042, pos_y = -34.383, pos_z = 585.270 WHERE mobid = 16990358;    -- Colibri into the former Treant's area
UPDATE mob_spawn_points SET pos_x = 46.812, pos_y = -32.357, pos_z = 556.112  WHERE mobid = 16990359;    -- Colibri into the former Treant's area
UPDATE mob_spawn_points SET pos_x = 43.350, pos_y = -16.767, pos_z = 271.397  WHERE mobid = 16990315 ;   -- Colibri into closer to the Eruca camp from nearby

-- Bibiki Bay
UPDATE mob_spawn_points SET pos_x = 544.336, pos_y = -20.242, pos_z = 809.229 WHERE mobid = 16793717;     -- other Rarab from zone entrance further into other mobs.
UPDATE mob_spawn_points SET pos_x = 596.787, pos_y = -19.756, pos_z = 808.883 WHERE mobid = 16793718;     -- Rarab from zone entrance further into other mobs.
UPDATE mob_spawn_points SET pos_x = 548.753, pos_y = -19.838, pos_z = 787.568 WHERE mobid = 16793720;     -- Marine Dhalmel from zone entrance further into other mobs.
UPDATE mob_spawn_points SET pos_x = 477.581, pos_y = -20.000, pos_z = 791.872 WHERE mobid = 16793748;     -- Marine Dhalmel away from hugging the Goblin Pathfinder's rock
UPDATE mob_spawn_points SET pos_x = 462.729, pos_y = -19.137, pos_z = 798.613 WHERE mobid = 16793749;     -- Island Rarab from bad capture position on top of Goblin's Rarab
UPDATE mob_spawn_points SET pos_x = 315.720, pos_y = -28.019, pos_z = 881.218 WHERE mobid = 16793750;     -- Hobogoblin Martialist to cactus near first Animaler
UPDATE mob_spawn_points SET pos_x = 318.869, pos_y = -28.000, pos_z = 842.316 WHERE mobid = 16793754;     -- Tropical Rarab from cactus into eft/rarab camp near tragopan cliff
UPDATE mob_spawn_points SET pos_x = 294.864, pos_y = -27.317, pos_z = 802.602 WHERE mobid = 16793755;     -- Tropical Rarab from cactus into eft/rarab camp near tragopan cliff
UPDATE mob_spawn_points SET pos_x = 150.610, pos_y = -35.731, pos_z = 716.322 WHERE mobid = 16793757;     -- Hobgoblin Venerer to "goblin alley"
UPDATE mob_spawn_points SET pos_x = 118.726, pos_y = -35.349, pos_z = 694.550 WHERE mobid = 16793759;     -- Hobgoblin Fascinator to "goblin alley"
UPDATE mob_spawn_points SET pos_x = 257.588, pos_y = -35.207, pos_z = 845.339 WHERE mobid = 16793766;     -- Tragopan from bad capture from being right on top of another
UPDATE mob_spawn_points SET pos_x = 90.066, pos_y = -45.450, pos_z = 903.121  WHERE mobid = 16793767;     -- Teine Sith (Bomb during fog) to CoP tunnel entrance and out of XP camp
UPDATE mob_spawn_points SET pos_x = 202.883, pos_y = -44.124, pos_z = 835.485 WHERE mobid = 16793769;     -- Catoblepas from "goblin alley" into general hill area
UPDATE mob_spawn_points SET pos_x = 296.671, pos_y = -35.763, pos_z = 838.054 WHERE mobid = 16793770;     -- Tragopan from edge brought into bird camp
UPDATE mob_spawn_points SET pos_x = 319.279, pos_y = -27.062, pos_z = 821.237 WHERE mobid = 16793773;     -- Tropical Rarab from "goblin alley" to below ledge
UPDATE mob_spawn_points SET pos_x = 282.733, pos_y = -28.000, pos_z = 798.280 WHERE mobid = 16793774;     -- Tartarus Eft from "goblin alley" to below ledge
UPDATE mob_spawn_points SET pos_x = 119.528, pos_y = -44.261, pos_z = 885.088 WHERE mobid = 16793775;     -- Tartarus Eft to CoP tunnel entrance (Splacknuck PH)
UPDATE mob_spawn_points SET pos_x = 163.241, pos_y = -36.000, pos_z = 641.327 WHERE mobid = 16793777;     -- Hobgoblin Animalier to "goblin alley" before locus, makes BLM or SMN solo camp, one pet on each side.
UPDATE mob_spawn_points SET pos_x = 322.634, pos_y = -27.281, pos_z = 855.233 WHERE mobid = 16793779;     -- Tartarus Eft from CoP tunnel area before ledge
UPDATE mob_spawn_points SET pos_x = 117.132, pos_y = -44.000, pos_z = 761.474 WHERE mobid = 16793780;     -- Hobgoblin Fascinator to "goblin alley"
UPDATE mob_spawn_points SET pos_x = 302.764, pos_y = -28.024, pos_z = 813.739 WHERE mobid = 16793781;     -- Tartarus Eft from CoP tunnel into general hill area
UPDATE mob_spawn_points SET pos_x = 241.339, pos_y = -31.644, pos_z = 816.469 WHERE mobid = 16793782;     -- Catoblepas from "goblin alley" into general hill area
UPDATE mob_spawn_points SET pos_x = 299.050, pos_y = -36.219, pos_z = 857.039 WHERE mobid = 16793783;     -- Tragopan from "goblin alley" and into XP camp
UPDATE mob_spawn_points SET pos_x = 113.778, pos_y = -36.591, pos_z = 726.297 WHERE mobid = 16793784;     -- Hobgoblin Martialist to "goblin alley"
UPDATE mob_spawn_points SET pos_x = 136.308, pos_y = -37.024, pos_z = 699.955 WHERE mobid = 16793785;     -- Hobgoblin Martialist to "goblin alley"
UPDATE mob_spawn_points SET pos_x = 250.576, pos_y = -34.240, pos_z = 829.382 WHERE mobid = 16793786;     -- Tragopan from CoP tunnel entrance and into XP camp
UPDATE mob_spawn_points SET pos_x = 284.247, pos_y = -28.636, pos_z = 811.037 WHERE mobid = 16793787;     -- Tropical Rarab from CoP tunnel to area before ledge
UPDATE mob_spawn_points SET pos_x = 120.135, pos_y = -44.365, pos_z = 874.546 WHERE mobid = 16793788;     -- Tartarus Eft from CoP tunnel to tunnel entrance
UPDATE mob_spawn_points SET pos_x = 188.059, pos_y = -39.056, pos_z = 819.059 WHERE mobid = 16793790;     -- Catoblepas from "goblin alley" into general hill area
UPDATE mob_spawn_points SET pos_x = 308.615, pos_y = -28.167, pos_z = 827.655 WHERE mobid = 16793791;     -- Tropical Rarab from "goblin alley" area below ledge
UPDATE mob_spawn_points SET pos_x = 287.858, pos_y = -35.452, pos_z = 826.551 WHERE mobid = 16793793;     -- Tragopan from "goblin alley" and into XP camp
UPDATE mob_spawn_points SET pos_x = 249.525, pos_y = -27.724, pos_z = 800.078 WHERE mobid = 16793794;     -- Catoblepas from "goblin alley" into general hill area
UPDATE mob_spawn_points SET pos_x = 208.880, pos_y = -35.280, pos_z = 796.449 WHERE mobid = 16793795;     -- Catoblepas from "goblin alley" into general hill area
UPDATE mob_spawn_points SET pos_x = 126.406, pos_y = -44.362, pos_z = 769.221 WHERE mobid = 16793799;     -- Hobgoblin Venerer in "goblin alley" on Animalier to alley entrance

-- The Boyahda Tree
UPDATE mob_spawn_points SET pos_x = -118.786, pos_y = 8.920, pos_z = -48.536   WHERE mobid = 17404199;     -- Gobbue from tunnel entrance otw to Aery to make a camp
UPDATE mob_spawn_points SET pos_x = -161.537, pos_y = 8.953, pos_z = -174.994  WHERE mobid = 17404220;    -- Korrigan from ledge camp before ancient goobbue room
UPDATE mob_spawn_points SET pos_x = -174.366, pos_y = 8.713, pos_z = -171.884  WHERE mobid = 17404221;    -- Korrigan from ledge camp before ancient goobbue room
UPDATE mob_spawn_points SET pos_x = -171.832, pos_y = 8.800, pos_z = -78.483   WHERE mobid = 17404218;     -- Korrigan from ledge camp before ancient goobbue room towards west ledge before aery tunnel
UPDATE mob_spawn_points SET pos_x = -138.076, pos_y = 6.374, pos_z = -51.717   WHERE mobid = 17404219;     -- Korrigan from ledge camp before ancient goobbue room to island after waterfall before aery
UPDATE mob_spawn_points SET pos_x = -168.079, pos_y = 8.942, pos_z = -162.967  WHERE mobid = 17404233;    -- The second stacked Crawler (poor LSB capture) from tunnel into room
UPDATE mob_spawn_points SET pos_x = -147.155, pos_y = 8.631, pos_z = -162.564  WHERE mobid = 17404281;    -- Crawler from Ancient Goobbue room up the ledge to waterfall room
UPDATE mob_spawn_points SET pos_x = -160.313, pos_y = 8.993, pos_z = -146.028  WHERE mobid = 17404282;    -- Crawler from Ancient Goobbue room up the ledge to waterfall room
UPDATE mob_spawn_points SET pos_x = -160.459, pos_y = 8.740, pos_z = -130.203  WHERE mobid = 17404285;    -- Crawler from Ancient Goobbue room up the ledge to waterfall room
UPDATE mob_spawn_points SET pos_x = -155.000, pos_y = 8.535, pos_z = -114.131  WHERE mobid = 17404286;    -- Crawler from Ancient Goobbue room up the ledge to waterfall room
UPDATE mob_spawn_points SET pos_x = -175.742, pos_y = 7.804, pos_z = -108.009  WHERE mobid = 17404180;    -- Crawler from tunnel curve after Ancient Goobbue and before the waterfall/book to waterfall room 
-- Boyahda Peapuk Room
UPDATE mob_spawn_points SET pos_x = -185.930, pos_y = 8.301, pos_z = -247.114  WHERE mobid = 17404238;     -- Mourning Crawler north spread out.
UPDATE mob_spawn_points SET pos_x = -210.561, pos_y = 7.357, pos_z = -227.871  WHERE mobid = 17404239;     -- Peapuk north spread out.
UPDATE mob_spawn_points SET pos_x = -208.478, pos_y = 8.857, pos_z = -245.387  WHERE mobid = 17404240;     -- Peapuk north spread out.
UPDATE mob_spawn_points SET pos_x = -182.889, pos_y = 7.921, pos_z = -233.656  WHERE mobid = 17404241;     -- Mourning Crawler from island to north.
UPDATE mob_spawn_points SET pos_x = -198.837, pos_y = 8.813, pos_z = -228.021  WHERE mobid = 17404242;     -- Mourning Crawler from island to north.
UPDATE mob_spawn_points SET pos_x = -212.632, pos_y = 8.336, pos_z = -310.453  WHERE mobid = 17404243;     -- Mourning Crawler from island to south.
UPDATE mob_spawn_points SET pos_x = -197.998, pos_y = 8.745, pos_z = -310.154  WHERE mobid = 17404244;     -- Peapuk from island to south.
UPDATE mob_spawn_points SET pos_x = -211.384, pos_y = 7.726, pos_z = -328.592  WHERE mobid = 17404245;     -- Mourning Crawler south spread out.
UPDATE mob_spawn_points SET pos_x = -186.507, pos_y = 8.426, pos_z = -311.913  WHERE mobid = 17404246;     -- Mourning Crawler south spread out.
UPDATE mob_spawn_points SET pos_x = -189.853, pos_y = 8.705, pos_z = -321.697  WHERE mobid = 17404248;     -- Peapuk south spread out.
UPDATE mob_spawn_points SET pos_x = -193.228, pos_y = 8.884, pos_z = -239.921  WHERE mobid = 17404252;     -- Peapuk double near island east moved north.
UPDATE mob_spawn_points SET pos_x = -183.217, pos_y = 9.991, pos_z = -294.343  WHERE mobid = 17404253;     -- Peapuk double near island east spread out.
UPDATE mob_spawn_points SET pos_x = -190.942, pos_y = 10.038, pos_z = -300.605 WHERE mobid = 17404258;    -- Viseclaw moved into water with the rest of them and off the island.
UPDATE mob_spawn_points SET pos_x = -212.154, pos_y = 8.824, pos_z = -320.734  WHERE mobid = 17404260;     -- Peapuk from island to south.
UPDATE mob_spawn_points SET pos_x = -235.142, pos_y = 9.825, pos_z = -273.931  WHERE mobid = 17404263;     -- Viseclaw from west waterfall more in line with other mobs.
UPDATE mob_spawn_points SET pos_x = -234.169, pos_y = 9.844, pos_z = -292.175  WHERE mobid = 17404264;     -- Peapuk away from waterfall so it can be used for Ergon weapon.

-- Caedarva Mire
UPDATE mob_spawn_points SET pos_x = 180.146, pos_y = -11.625, pos_z = -481.056  WHERE mobid = 17100820;     -- Chigoe (H-10) to (I-9) on ledge
UPDATE mob_spawn_points SET pos_x = 238.243, pos_y = 0.250, pos_z = -711.448    WHERE mobid = 17100817;     -- Marsh Murre (H-10) to (I-10)
UPDATE mob_spawn_points SET pos_x = 249.410, pos_y = -0.500, pos_z = -704.258   WHERE mobid = 17100818;     -- Marsh Murre (H-10) to (I-10)
UPDATE mob_spawn_points SET pos_x = 171.486, pos_y = -9.640, pos_z = -486.550   WHERE mobid = 17100821;     -- Chigoe (H-10) to (I-9) on ledge
UPDATE mob_spawn_points SET pos_x = 167.989, pos_y = -9.868, pos_z = -474.096   WHERE mobid = 17100823;     -- Chigoe (H-10) to (I-9) on ledge
UPDATE mob_spawn_points SET pos_x = 147.255, pos_y = -10.000, pos_z = -465.869  WHERE mobid = 17100824;     -- Chigoe (H-10) to (I-9) on ledge
UPDATE mob_spawn_points SET pos_x = 264.932, pos_y = -2.373, pos_z = -705.008   WHERE mobid = 17100826;     -- Marsh Murre (H-10) to (I-10)
UPDATE mob_spawn_points SET pos_x = 251.512, pos_y = 0.250, pos_z = -679.342    WHERE mobid = 17100834;     -- Marsh Murre (H-9) to (I-10)
UPDATE mob_spawn_points SET pos_x = 120.652, pos_y = 0.000, pos_z = -719.304    WHERE mobid = 17100835;     -- Treant Sapling (H-9) to (I-11)
UPDATE mob_spawn_points SET pos_x = 145.505, pos_y = 0.404, pos_z = -720.778    WHERE mobid = 17100837;     -- Leech (I-10) to (I-10)
UPDATE mob_spawn_points SET pos_x = 144.101, pos_y = -0.008, pos_z = -703.940   WHERE mobid = 17100838;     -- Treant Sapling (H-9) to (I-11)
UPDATE mob_spawn_points SET pos_x = 206.241, pos_y = -0.286, pos_z = -642.701   WHERE mobid = 17100848;     -- Puktrap (I-9) to (I-10)
UPDATE mob_spawn_points SET pos_x = 159.482, pos_y = 0.000, pos_z = -681.671    WHERE mobid = 17100849;     -- Leech (I-9) to (I-10)
UPDATE mob_spawn_points SET pos_x = 234.971, pos_y = -0.135, pos_z = -722.681   WHERE mobid = 17100850;     -- Marsh Murre (I-9) to (I-10)
UPDATE mob_spawn_points SET pos_x = 132.753, pos_y = -1.870, pos_z = -738.095   WHERE mobid = 17100851;     -- Treant Sapling (I-9) to (I-11)
UPDATE mob_spawn_points SET pos_x = 228.094, pos_y = -0.903, pos_z = -662.636   WHERE mobid = 17100857;     -- Marsh Murre (I-9) to (I-10)
UPDATE mob_spawn_points SET pos_x = 265.680, pos_y = -1.250, pos_z = -689.680   WHERE mobid = 17100862;     -- Marsh Murre (I-10) to (I-10)
UPDATE mob_spawn_points SET pos_x = 224.352, pos_y = 0.452, pos_z = -684.728    WHERE mobid = 17100864;     -- Marsh Murre (I-9) to (I-10)
UPDATE mob_spawn_points SET pos_x = 199.685, pos_y = 0.000, pos_z = -603.418    WHERE mobid = 17100865;     -- Puktrap (I-9) to (I-10)
UPDATE mob_spawn_points SET pos_x = 314.400, pos_y = -11.956, pos_z = -463.131  WHERE mobid = 17100872;     -- Karakul (J-9) to (J-9) less linky
UPDATE mob_spawn_points SET pos_x = 279.846, pos_y = -15.500, pos_z = -381.927  WHERE mobid = 17100874;     -- Karakul (J-8) fix position so it stops drowning itself in the water
UPDATE mob_spawn_points SET pos_x = 291.185, pos_y = -15.750, pos_z = -401.409  WHERE mobid = 17100878;     -- Karakul (I-8) to (J-8)
UPDATE mob_spawn_points SET pos_x = 331.002, pos_y = -15.750, pos_z = -397.133  WHERE mobid = 17100879;     -- Karakul (I-8) to (J-8)
UPDATE mob_spawn_points SET pos_x = 311.316, pos_y = -14.500, pos_z = -389.603  WHERE mobid = 17100881;     -- Jnun (J-8) to (J-8) less linky
UPDATE mob_spawn_points SET pos_x = 323.682, pos_y = -10.000, pos_z = -427.380  WHERE mobid = 17100889;     -- Karakul (I-9) to (J-9)
UPDATE mob_spawn_points SET pos_x = 253.029, pos_y = -2.000, pos_z = -717.614   WHERE mobid = 17100885;     -- Marsh Murre (I-8) to (I-10)
UPDATE mob_spawn_points SET pos_x = 342.238, pos_y = -11.500, pos_z = -429.479  WHERE mobid = 17100892;     -- Karakul (I-9) to (J-9)
-- UPDATE mob_spawn_points SET pos_x = 162.009, pos_y = -7.584, pos_z = -334.670   WHERE mobid = 17100886;     -- Treant (I-9) to (I-8)
-- UPDATE mob_spawn_points SET pos_x = 158.840, pos_y = -8.015, pos_z = -323.772   WHERE mobid = 17100896;     -- Treant spread out (I-8) to (I-8)
-- UPDATE mob_spawn_points SET pos_x = 167.781, pos_y = -8.952, pos_z = -306.038   WHERE mobid = 17100903;     -- Treant stuck in bushes (I-8) to (I-8)
-- UPDATE mob_spawn_points SET pos_x = 141.695, pos_y = -10.962, pos_z = -320.214  WHERE mobid = 17100916;     -- Treant (I-9) to (I-8)
-- UPDATE mob_spawn_points SET pos_x = 157.464, pos_y = -7.880, pos_z = -354.053   WHERE mobid = 17100922;     -- Treant (I-7) to (I-8)
UPDATE mob_spawn_points SET pos_x = 235.854, pos_y = 0.281, pos_z = -692.748    WHERE mobid = 17100926;     -- Marsh Murre (J-8) to (I-10)
UPDATE mob_spawn_points SET pos_x = 306.807, pos_y = -15.489, pos_z = -328.516  WHERE mobid = 17100933;     -- Jnun (K-8) to (J-9)
UPDATE mob_spawn_points SET pos_x = 436.150, pos_y = -7.699, pos_z = -307.168   WHERE mobid = 17100946;     -- Heraldic Imp stuck in bushes (J-8) to (J-8)
UPDATE mob_spawn_points SET pos_x = 131.852, pos_y = 0.239, pos_z = -685.017    WHERE mobid = 17100953;     -- Leech stuck in bushes (J-8) to (I-10)
UPDATE mob_spawn_points SET pos_x = -311.146, pos_y = -1.493, pos_z = -728.889  WHERE mobid = 17100977;     -- Treant Sapling outside Nashmau (F-11) off of being on top the other
UPDATE mob_spawn_points SET pos_x = -382.944, pos_y = 0.191, pos_z = -727.687   WHERE mobid = 17100979;     -- Marsh Murre outside Nashmau (F-10) to (E-11)
UPDATE mob_spawn_points SET pos_x = -333.322, pos_y = 0.305, pos_z = -715.724   WHERE mobid = 17100986;     -- Treant Sapling outside Nyzul (E-11) to (E-11) outside Nashmau
UPDATE mob_spawn_points SET pos_x = -351.916, pos_y = 0.250, pos_z = -716.866   WHERE mobid = 17100987;     -- Treant Sapling outside Nyzul (E-11) to (E-11) outside Nashmau
UPDATE mob_spawn_points SET pos_x = -412.538, pos_y = 4.166, pos_z = -645.445   WHERE mobid = 17101010;     -- Marsh Murre back of grave yard (F-9) to (E-10)
UPDATE mob_spawn_points SET pos_x = -423.691, pos_y = -2.329, pos_z = -709.907  WHERE mobid = 17101015;     -- Marsh Murre (E-10) near Einherjar to (E-10) nearer to Nashmau
UPDATE mob_spawn_points SET pos_x = -394.716, pos_y = 0.250, pos_z = -711.014   WHERE mobid = 17101019;     -- Random isolated Marsh Murre (F-10) to (E-10)
UPDATE mob_spawn_points SET pos_x = -417.431, pos_y = 1.680, pos_z = -695.130   WHERE mobid = 17101020;     -- Random isolated Marsh Murre (F-9) to (E-10)
UPDATE mob_spawn_points SET pos_x = -252.502, pos_y = 6.000, pos_z = -522.532   WHERE mobid = 17101021;     -- Spread out Slough Skua (F-9)
UPDATE mob_spawn_points SET pos_x = -235.273, pos_y = 7.815, pos_z = -524.647   WHERE mobid = 17101022;     -- Spread out Slough Skua (F-9)
UPDATE mob_spawn_points SET pos_x = -238.086, pos_y = 8.500, pos_z = -501.510   WHERE mobid = 17101023;     -- Spread out Slough Skua (F-9)
UPDATE mob_spawn_points SET pos_x = -218.872, pos_y = 4.137, pos_z = -473.863   WHERE mobid = 17101024;     -- Spread out Slough Skua (F-9)
UPDATE mob_spawn_points SET pos_x = -262.184, pos_y = 8.240, pos_z = -473.973   WHERE mobid = 17101031;     -- Spread out Slough Skua (F-9)
UPDATE mob_spawn_points SET pos_x = -227.397, pos_y = 4.500, pos_z = -461.853   WHERE mobid = 17101034;     -- Spread out Slough Skua (F-9)
UPDATE mob_spawn_points SET pos_x = 238.281, pos_y = -12.250, pos_z = -335.587  WHERE mobid = 17101036;     -- Shade Dvucca (F-9) Near Reef to Azouph (I-8)
UPDATE mob_spawn_points SET pos_x = 240.058, pos_y = -9.688, pos_z = -348.958   WHERE mobid = 17101037;     -- Shade Dvucca (F-9) Near Reef to Azouph (I-8)
UPDATE mob_spawn_points SET pos_x = 223.850, pos_y = -7.500, pos_z = -357.278   WHERE mobid = 17101051;     -- Shade Dvucca (G-10) Near Nyzul to Azouph (I-8)
UPDATE mob_spawn_points SET pos_x = 220.245, pos_y = -7.500, pos_z = -363.161   WHERE mobid = 17101052;     -- Shade Dvucca (G-10) Near Nyzul to Azouph (I-8)
UPDATE mob_spawn_points SET pos_x = 240.968, pos_y = -8.000, pos_z = -362.406   WHERE mobid = 17101053;     -- Shade Dvucca (G-10) Near Nyzul to Azouph (I-8)
UPDATE mob_spawn_points SET pos_x = 231.223, pos_y = -7.750, pos_z = -362.640   WHERE mobid = 17101054;     -- Shade Dvucca (G-10) Near Nyzul to Azouph (I-8)
UPDATE mob_spawn_points SET pos_x = 236.295, pos_y = -7.752, pos_z = -371.985   WHERE mobid = 17101119;     -- Shade Dvucca (G-7) Near Reef to Azouph (I-8)

-- Cape Teriggan
UPDATE mob_spawn_points SET pos_x = 62.735, pos_y = 0.512, pos_z = -112.381 WHERE mobid = 17240208;     -- Velociraptor out of a corner on the beach that players can camp in
UPDATE mob_spawn_points SET pos_x = 36.755, pos_y = 4.000, pos_z = -167.142 WHERE mobid = 17240226;     -- Fantasma out of a the same raptor corner on the beach. Spawns at night. Moved to the coast.

-- Misareauyx Coast
UPDATE mob_spawn_points SET pos_x = 414.716, pos_y = -7.248, pos_z = 78.920 WHERE mobid = 16879823;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 407.716, pos_y = -7.361, pos_z = 65.440 WHERE mobid = 16879824;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 458.330, pos_y = -7.203, pos_z = 74.439 WHERE mobid = 16879825;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 417.717, pos_y = -7.164, pos_z = 42.624 WHERE mobid = 16879826;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 470.760, pos_y = -8.675, pos_z = 94.215 WHERE mobid = 16879827;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 454.009, pos_y = -7.502, pos_z = 65.826 WHERE mobid = 16879828;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 446.143, pos_y = -7.135, pos_z = 61.666 WHERE mobid = 16879829;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 445.877, pos_y = -8.086, pos_z = 48.680 WHERE mobid = 16879830;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 429.388, pos_y = -7.580, pos_z = 73.684 WHERE mobid = 16879831;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 434.991, pos_y = -8.130, pos_z = 89.773 WHERE mobid = 16879832;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 432.832, pos_y = -7.994, pos_z = 45.247 WHERE mobid = 16879691;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 457.543, pos_y = -11.063, pos_z = 99.012 WHERE mobid = 16879698;      -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 475.658, pos_y = -7.984, pos_z = 81.905 WHERE mobid = 16879699;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 401.410, pos_y = -8.000, pos_z = 77.953 WHERE mobid = 16879717;       -- Stack Seaboard Vulture South
UPDATE mob_spawn_points SET pos_x = 445.894, pos_y = -24.000, pos_z = 286.579 WHERE mobid = 16879709;     -- Stack Seaboard Vulture North
UPDATE mob_spawn_points SET pos_x = 466.202, pos_y = -23.394, pos_z = 271.192 WHERE mobid = 16879715;     -- Stack Seaboard Vulture North
UPDATE mob_spawn_points SET pos_x = 451.925, pos_y = -23.443, pos_z = 274.056 WHERE mobid = 16879716;     -- Stack Seaboard Vulture North
UPDATE mob_spawn_points SET pos_x = 475.345, pos_y = -23.528, pos_z = 235.517 WHERE mobid = 16879718;     -- Stack Seaboard Vulture North
UPDATE mob_spawn_points SET pos_x = 480.962, pos_y = -23.913, pos_z = 273.920 WHERE mobid = 16879719;     -- Stack Seaboard Vulture North

-- Rolanberry Fields
UPDATE mob_spawn_points SET pos_x = -350.927, pos_y = 8.367, pos_z = 157.082    WHERE mobid = 17228060;  -- Stray Berry Grub into the grape field with the rest to bolster camp
UPDATE mob_spawn_points SET pos_x = -369.697, pos_y = 0.208, pos_z = -78.816    WHERE mobid = 17228087;  -- Stray Berry Grub near the grape field with the rest to bolster camp
UPDATE mob_spawn_points SET pos_x = -397.639, pos_y = 0.000, pos_z = -78.201    WHERE mobid = 17228078;  -- Slightly moves a Berry Grub near a grape field to improve a camp
UPDATE mob_spawn_points SET pos_x = -90.599, pos_y = -0.674, pos_z = -487.983   WHERE mobid = 17227892;  -- Stray Berry Grub near the grape field with the rest to bolster camp
UPDATE mob_spawn_points SET pos_x = -77.693, pos_y = 0.052, pos_z = -480.867    WHERE mobid = 17227893;  -- Stray Berry Grub near the grape field (H-11) with the rest to bolster camp
UPDATE mob_spawn_points SET pos_x = -41.070, pos_y = 0.000, pos_z = -480.333    WHERE mobid = 17227875;  -- Stray Berry Grub near the grape field (H-11) with the rest to bolster camp
UPDATE mob_spawn_points SET pos_x = 255.003, pos_y = -31.727, pos_z = -289.864  WHERE mobid = 17228007;  -- Poison Leech near the east lake with the rest to bolster camp
UPDATE mob_spawn_points SET pos_x = 227.647, pos_y = -30.333, pos_z = -247.227  WHERE mobid = 17228005;  -- Poison Leech near the east lake with the rest to bolster camp
UPDATE mob_spawn_points SET pos_x = 195.558, pos_y = -28.003, pos_z = -222.595  WHERE mobid = 17228010;  -- Goblin Mugger off mountain wall (Poor capture position)
UPDATE mob_spawn_points SET pos_x = 289.029, pos_y = -31.749, pos_z = -239.468  WHERE mobid = 17227964;  -- Berry Grub near east lake
UPDATE mob_spawn_points SET pos_x = -592.094, pos_y = -19.132, pos_z = -223.801 WHERE mobid = 17228108;  -- Berry Grub from one side of west lake to the other
UPDATE mob_spawn_points SET pos_x = -582.130, pos_y = -21.058, pos_z = -196.497 WHERE mobid = 17228111;  -- Berry Grub from one side of west lake to the other
UPDATE mob_spawn_points SET pos_x = -598.968, pos_y = -23.310, pos_z = -182.021 WHERE mobid = 17228112;  -- Berry Grub from one side of west lake to the other
UPDATE mob_spawn_points SET pos_x = -602.819, pos_y = -23.945, pos_z = -205.905 WHERE mobid = 17228120;  -- Berry Grub from one side of west lake to the other
UPDATE mob_spawn_points SET pos_x = -616.668, pos_y = -23.204, pos_z = -144.102 WHERE mobid = 17228124;  -- Poison Leech from one side of west lake to the other
UPDATE mob_spawn_points SET pos_x = -620.932, pos_y = -21.230, pos_z = -145.743 WHERE mobid = 17228123;  -- Poison Leech closer to west lake
UPDATE mob_spawn_points SET pos_x = -578.061, pos_y = -19.734, pos_z = -163.925 WHERE mobid = 17228127;  -- Poison Leech closer to west lake
UPDATE mob_spawn_points SET pos_x = -535.263, pos_y = -15.285, pos_z = -199.688 WHERE mobid = 17228131;  -- Clipper from Goblins to small west lake
UPDATE mob_spawn_points SET pos_x = -645.681, pos_y = -22.358, pos_z = -193.767 WHERE mobid = 17228133;  -- Clipper from Goblins to small west lake
UPDATE mob_spawn_points SET pos_x = -710.966, pos_y = -23.705, pos_z = -238.256 WHERE mobid = 17228142;  -- Goblin Smithy to other side of the west lake
UPDATE mob_spawn_points SET pos_x = -708.901, pos_y = -22.431, pos_z = -147.565 WHERE mobid = 17228143;  -- Goblin Shaman to other side of the west lake

-- Rolanberry Fields (S)
UPDATE mob_spawn_points SET pos_x = -372.239, pos_y = 6.496, pos_z = 272.755    WHERE mobid = 17150003;  -- Goobbue Farmer (L-8) to (G-6)
UPDATE mob_spawn_points SET pos_x = -94.015, pos_y = -7.719, pos_z = -162.796   WHERE mobid = 17150019;  -- Coppercap (K-6) to (H-9)
UPDATE mob_spawn_points SET pos_x = -102.049, pos_y = -7.169, pos_z = -135.066  WHERE mobid = 17150020;  -- Coppercap (K-6) to (H-9)
UPDATE mob_spawn_points SET pos_x = -124.816, pos_y = -7.500, pos_z = -137.258  WHERE mobid = 17150021;  -- Coppercap (K-6) to (H-9)
UPDATE mob_spawn_points SET pos_x = -84.379, pos_y = -7.360, pos_z = -130.093   WHERE mobid = 17150054;  -- Coppercap (K-11) to (H-9)
UPDATE mob_spawn_points SET pos_x = -75.457, pos_y = -7.793, pos_z = -153.869   WHERE mobid = 17150055;  -- Coppercap (K-10) to (H-9)
UPDATE mob_spawn_points SET pos_x = -90.925, pos_y = -7.556, pos_z = -181.079   WHERE mobid = 17150056;  -- Coppercap (K-11) to (H-9)
UPDATE mob_spawn_points SET pos_x = -80.874, pos_y = -8.000, pos_z = -165.218   WHERE mobid = 17150057;  -- Coppercap (K-10) to (H-9)
UPDATE mob_spawn_points SET pos_x = -372.473, pos_y = 7.233, pos_z = 296.217    WHERE mobid = 17150080;  -- Goobbue Farmer (G-8) to (G-7)
UPDATE mob_spawn_points SET pos_x = -90.927, pos_y = -7.521, pos_z = -363.744   WHERE mobid = 17150097;  -- Goobbue Farmer (H-10) out of road to (H-11)
UPDATE mob_spawn_points SET pos_x = -333.774, pos_y = 6.780, pos_z = 332.001    WHERE mobid = 17150113;  -- Goobbue Farmer (I-12) out of road to (G-6)
UPDATE mob_spawn_points SET pos_x = -391.120, pos_y = 7.654, pos_z = 325.393    WHERE mobid = 17150117;  -- Chigoe (F-6) out of flies and slighly closer to zone line.
UPDATE mob_spawn_points SET pos_x = -392.781, pos_y = 8.140, pos_z = 320.128    WHERE mobid = 17150118;  -- Chigoe (F-6) out of flies and slighly closer to zone line.
UPDATE mob_spawn_points SET pos_x = -399.813, pos_y = 6.349, pos_z = 309.090    WHERE mobid = 17150119;  -- Chigoe (F-6) out of flies and slighly closer to zone line.
UPDATE mob_spawn_points SET pos_x = -404.330, pos_y = 4.817, pos_z = 304.890    WHERE mobid = 17150120;  -- Chigoe (F-6) out of flies and slighly closer to zone line.
UPDATE mob_spawn_points SET pos_x = -392.562, pos_y = 0.421, pos_z = 283.611    WHERE mobid = 17150127;  -- Goobbue Farmer (G-7) to (E-6)
UPDATE mob_spawn_points SET pos_x = -381.340, pos_y = 2.642, pos_z = 166.430    WHERE mobid = 17150134;  -- Champion Crawler (F-7) field to field (F-7)
UPDATE mob_spawn_points SET pos_x = -444.003, pos_y = -7.292, pos_z = 61.065    WHERE mobid = 17150135;  -- Champion Crawler (G-8) to battlement camp (F-8)
UPDATE mob_spawn_points SET pos_x = -330.330, pos_y = 8.097, pos_z = 168.588    WHERE mobid = 17150136;  -- Champion Crawler (F-7) field to field (G-7)
UPDATE mob_spawn_points SET pos_x = -328.982, pos_y = 8.307, pos_z = 119.176    WHERE mobid = 17150137;  -- Champion Crawler (F-7) field to field (G-8)
UPDATE mob_spawn_points SET pos_x = -439.545, pos_y = -7.828, pos_z = 33.186    WHERE mobid = 17150138;  -- Champion Crawler (G-8) to battlement camp (F-8)
UPDATE mob_spawn_points SET pos_x = -361.835, pos_y = 8.000, pos_z = 121.630    WHERE mobid = 17150139;  -- Champion Crawler (G-8) road to field (G-8)
UPDATE mob_spawn_points SET pos_x = -439.517, pos_y = -7.391, pos_z = -15.710   WHERE mobid = 17150140;  -- Champion Crawler (G-8) below ledge to battlement camp (F-8)
UPDATE mob_spawn_points SET pos_x = -450.881, pos_y = -9.053, pos_z = 12.792    WHERE mobid = 17150142;  -- Champion Crawler (G-8) below ledge to battlement camp (F-8)
UPDATE mob_spawn_points SET pos_x = -360.466, pos_y = 8.145, pos_z = 153.719    WHERE mobid = 17150141;  -- Champion Crawler (G-8) road to field (F-8)
UPDATE mob_spawn_points SET pos_x = -376.068, pos_y = 5.290, pos_z = 153.907    WHERE mobid = 17150143;  -- Champion Crawler (G-8) road to field (F-7)
UPDATE mob_spawn_points SET pos_x = -442.807, pos_y = -7.945, pos_z = -34.882   WHERE mobid = 17150151;  -- Champion Crawler (F-8) to battlement camp (F-8)
UPDATE mob_spawn_points SET pos_x = -415.476, pos_y = -8.028, pos_z = -7.843    WHERE mobid = 17150152;  -- Champion Crawler (F-8) to battlement camp (F-8)
UPDATE mob_spawn_points SET pos_x = -396.544, pos_y = -7.577, pos_z = 27.104    WHERE mobid = 17150153;  -- Champion Crawler (F-8) to battlement camp (F-8)
UPDATE mob_spawn_points SET pos_x = -546.927, pos_y = -17.187, pos_z = -57.067  WHERE mobid = 17150154;  -- Berry Grub (F-9) towards other ones (E-9)
UPDATE mob_spawn_points SET pos_x = -505.448, pos_y = -15.912, pos_z = -51.247  WHERE mobid = 17150155;  -- Berry Grub (F-9) towards other ones (F-9)
UPDATE mob_spawn_points SET pos_x = -537.383, pos_y = -15.131, pos_z = -39.981  WHERE mobid = 17150156;  -- Berry Grub (F-9) towards other ones (E-8)
UPDATE mob_spawn_points SET pos_x = -508.692, pos_y = -16.500, pos_z = -66.479  WHERE mobid = 17150161;  -- Berry Grub (F-8) dead end to (F-9)
UPDATE mob_spawn_points SET pos_x = -579.827, pos_y = -20.500, pos_z = -163.726 WHERE mobid = 17150164;  -- Scabrous Slug (F-9) to (E-9)
UPDATE mob_spawn_points SET pos_x = -555.961, pos_y = -15.642, pos_z = -171.868 WHERE mobid = 17150165;  -- Scabrous Slug (F-9) to (E-9)
UPDATE mob_spawn_points SET pos_x = -575.205, pos_y = -18.396, pos_z = -190.747 WHERE mobid = 17150166;  -- Scabrous Slug (E-10) from la-la-land to viscinity of other mobs (E-9)
UPDATE mob_spawn_points SET pos_x = -565.476, pos_y = -17.479, pos_z = -149.345 WHERE mobid = 17150167;  -- Scabrous Slug (F-10) from la-la-land to viscinity of other mobs (E-9)
UPDATE mob_spawn_points SET pos_x = -687.768, pos_y = -23.812, pos_z = -242.158 WHERE mobid = 17150171;  -- Water Elemental (E-9) to other side of lake (out of camp) (E-10)
UPDATE mob_spawn_points SET pos_x = -500.745, pos_y = -15.085, pos_z = -79.276  WHERE mobid = 17150172;  -- Berry Grub (E-9) to (F-9)
UPDATE mob_spawn_points SET pos_x = -482.653, pos_y = -16.000, pos_z = -74.012  WHERE mobid = 17150173;  -- Berry Grub (E-9) to (F-9)
UPDATE mob_spawn_points SET pos_x = -520.848, pos_y = -16.000, pos_z = -40.0419 WHERE mobid = 17150174;  -- Berry Grub (E-9) to (F-9)
UPDATE mob_spawn_points SET pos_x = -530.380, pos_y = -15.891, pos_z = -73.396  WHERE mobid = 17150175;  -- Berry Grub (E-9) to (E-9)
UPDATE mob_spawn_points SET pos_x = -616.291, pos_y = -23.824, pos_z = -207.240 WHERE mobid = 17150176;  -- Poison Leech (D-10) to other side of lake (E-9)
UPDATE mob_spawn_points SET pos_x = -597.852, pos_y = -23.645, pos_z = -189.958 WHERE mobid = 17150177;  -- Poison Leech (D-10) to other side of lake (E-9)
UPDATE mob_spawn_points SET pos_x = -601.753, pos_y = -22.820, pos_z = -210.277 WHERE mobid = 17150178;  -- Scabrous Slug (E-10) to other side of lake (E-10)
UPDATE mob_spawn_points SET pos_x = -646.767, pos_y = -21.160, pos_z = -188.896 WHERE mobid = 17150183;  -- Clipper (D-11) from Simurgh lake to (E-9)
UPDATE mob_spawn_points SET pos_x = -630.548, pos_y = -21.131, pos_z = -186.178 WHERE mobid = 17150184;  -- Clipper (D-11) from Simurgh lake to (E-9)
UPDATE mob_spawn_points SET pos_x = -617.551, pos_y = -21.354, pos_z = -179.462 WHERE mobid = 17150185;  -- Clipper (D-11) from Simurgh lake to (E-9)
UPDATE mob_spawn_points SET pos_x = -613.474, pos_y = -20.667, pos_z = -169.209 WHERE mobid = 17150188;  -- Clipper (D-11) from Simurgh lake to (E-9)
UPDATE mob_spawn_points SET pos_x = -616.609, pos_y = -20.061, pos_z = -154.811 WHERE mobid = 17150189;  -- Clipper (D-11) from Simurgh lake to (E-9)
UPDATE mob_spawn_points SET pos_x = -622.971, pos_y = -23.173, pos_z = -137.960 WHERE mobid = 17150190;  -- Clipper (D-11) from Simurgh lake to (E-9)
UPDATE mob_spawn_points SET pos_x = -85.211, pos_y = -4.865, pos_z = -378.787   WHERE mobid = 17150208;  -- Goobbue Farmer (I-13) out of Hawkers to (H-11)
UPDATE mob_spawn_points SET pos_x = 2.153, pos_y = -4.368, pos_z = -780.484     WHERE mobid = 17150210;  -- Hawker (I-13) out of linking cluster (I-13)
UPDATE mob_spawn_points SET pos_x = -142.510, pos_y = -7.886, pos_z = -450.182  WHERE mobid = 17150216;  -- Goobbue Farmer (H-10) to (H-11)
UPDATE mob_spawn_points SET pos_x = -127.304, pos_y = -7.496, pos_z = -429.119  WHERE mobid = 17150217;  -- Goobbue Farmer (H-10) to (H-11)
UPDATE mob_spawn_points SET pos_x = -160.689, pos_y = -7.831, pos_z = -408.093  WHERE mobid = 17150218;  -- Goobbue Farmer (H-10) to (H-11)
UPDATE mob_spawn_points SET pos_x = -112.661, pos_y = -7.979, pos_z = -387.901  WHERE mobid = 17150219;  -- Goobbue Farmer (H-11) to (H-11)
UPDATE mob_spawn_points SET pos_x = -11.903, pos_y = -3.632, pos_z = -777.566   WHERE mobid = 17150214;  -- Hawker (I-13) into group (I-13)
UPDATE mob_spawn_points SET pos_x = 6.354, pos_y = -0.300, pos_z = -799.004     WHERE mobid = 17150215;  -- Hawker (I-13) into group (I-13)
UPDATE mob_spawn_points SET pos_x = -103.186, pos_y = -8.723, pos_z = -170.341  WHERE mobid = 17150221;  -- Coppercap (H-11) to (H-9)
UPDATE mob_spawn_points SET pos_x = -91.039, pos_y = -7.582, pos_z = -155.544   WHERE mobid = 17150222;  -- Coppercap (H-11) to (H-9)
UPDATE mob_spawn_points SET pos_x = -68.745, pos_y = -8.088, pos_z = -171.351   WHERE mobid = 17150223;  -- Coppercap (H-11) to (H-9)
UPDATE mob_spawn_points SET pos_x = -54.642, pos_y = -7.005, pos_z = -172.702   WHERE mobid = 17150224;  -- Coppercap (H-11) to (H-9)
UPDATE mob_spawn_points SET pos_x = -140.7130, pos_y = -7.506, pos_z = -405.692 WHERE mobid = 17150227;  -- Goobbue Farmer (H-11) to (H-11)
UPDATE mob_spawn_points SET pos_x = -121.118, pos_y = -7.790, pos_z = -406.853  WHERE mobid = 17150228;  -- Goobbue Farmer (H-11) to (H-11)
UPDATE mob_spawn_points SET pos_x = -119.050, pos_y = -8.070, pos_z = -441.103  WHERE mobid = 17150236;  -- Goobbue Farmer (I-9) to (H-11)
UPDATE mob_spawn_points SET pos_x = -115.212, pos_y = -7.899, pos_z = -420.767  WHERE mobid = 17150237;  -- Goobbue Farmer (I-10) to (H-11)
UPDATE mob_spawn_points SET pos_x = -136.372, pos_y = -8.483, pos_z = -382.853  WHERE mobid = 17150238;  -- Goobbue Farmer (I-10) to (H-11)
UPDATE mob_spawn_points SET pos_x = -34.798, pos_y = -8.052, pos_z = -206.452   WHERE mobid = 17150241;  -- Coppercap (I-9) to (I-10)
UPDATE mob_spawn_points SET pos_x = -55.207, pos_y = -7.176, pos_z = -179.090   WHERE mobid = 17150248;  -- Coppercap (H-9) to (H-9)
UPDATE mob_spawn_points SET pos_x = -100.737, pos_y = -4.721, pos_z = -404.721  WHERE mobid = 17150254;  -- Goobbue Farmer (I-10) to (H-11)
UPDATE mob_spawn_points SET pos_x = -67.402, pos_y = -8.005, pos_z = -216.559   WHERE mobid = 17150255;  -- Coppercap (I-10) to (H-10)
UPDATE mob_spawn_points SET pos_x = -57.233, pos_y = -7.742, pos_z = -190.573   WHERE mobid = 17150257;  -- Coppercap (H-9) to (H-9)
UPDATE mob_spawn_points SET pos_x = -123.017, pos_y = -8.000, pos_z = -115.743  WHERE mobid = 17150258;  -- Coppercap (H-9) to (H-9)
UPDATE mob_spawn_points SET pos_x = -520.235, pos_y = -15.130, pos_z = -17.261  WHERE mobid = 17150309;  -- Goblin Skirmisher (G-8) to (F-8)
UPDATE mob_spawn_points SET pos_x = -501.574, pos_y = -15.445, pos_z = -116.585 WHERE mobid = 17150315;  -- Goblin Skirmisher (I-12) to (F-9)

-- Sauromugue_Champaign
UPDATE mob_spawn_points SET pos_x = -345.175, pos_y = 7.895, pos_z = 432.321  WHERE mobid = 17268777;    -- Tabar Beak (K-7) to (F-5)
UPDATE mob_spawn_points SET pos_x = -358.407, pos_y = 1.946, pos_z = 466.727  WHERE mobid = 17268778;    -- Tabar Beak (K-8) to (F-5)
UPDATE mob_spawn_points SET pos_x = -362.311, pos_y = 7.966, pos_z = 435.788  WHERE mobid = 17268812;    -- Tabar Beak (K-8) to(F-5)
UPDATE mob_spawn_points SET pos_x = -351.918, pos_y = 4.517, pos_z = 410.166  WHERE mobid = 17268820;    -- Tabar Beak (K-7) to (F-5)
UPDATE mob_spawn_points SET pos_x = -339.715, pos_y = 5.021, pos_z = 452.372  WHERE mobid = 17268827;    -- Tabar Beak (J-7) to (F-5)
UPDATE mob_spawn_points SET pos_x = -161.178, pos_y = 16.000, pos_z = -1.440  WHERE mobid = 17268869;    -- Diving Beetle (J-9) to (G-8)
UPDATE mob_spawn_points SET pos_x = -164.710, pos_y = 15.728, pos_z = 42.575  WHERE mobid = 17268870;    -- Diving Beetle (K-9) to (G-8)
UPDATE mob_spawn_points SET pos_x = -118.437, pos_y = 16.842, pos_z = 23.137  WHERE mobid = 17268871;    -- Diving Beetle (J-9) to (H-8)
UPDATE mob_spawn_points SET pos_x = -258.351, pos_y = 7.000, pos_z = 98.320   WHERE mobid = 17268879;    -- Diving Beetle (K-8) to (G-7)
UPDATE mob_spawn_points SET pos_x = -237.386, pos_y = 8.000, pos_z = 78.552   WHERE mobid = 17268878;    -- Diving Beetle (J-7) to (G-8) 
UPDATE mob_spawn_points SET pos_x = -99.740, pos_y = 11.332, pos_z = -36.139  WHERE mobid = 17268883;    -- Hill Lizard (H-8) to (H-8)
UPDATE mob_spawn_points SET pos_x = -124.951, pos_y = 15.754, pos_z = -35.741 WHERE mobid = 17268884;    -- Hill Lizard (H-8) to (H-8)
UPDATE mob_spawn_points SET pos_x = -124.816, pos_y = 16.039, pos_z = -2.825  WHERE mobid = 17268885;    -- Diving Beetle (H-9) to (H-8)
UPDATE mob_spawn_points SET pos_x = -142.924, pos_y = 16.852, pos_z = -0.897  WHERE mobid = 17268886;    -- Diving Beetle (H-9) to (G-8)
UPDATE mob_spawn_points SET pos_x = -108.236, pos_y = 14.940, pos_z = -15.112 WHERE mobid = 17268890;    -- Hill Lizard (H-8) to (G-8)
UPDATE mob_spawn_points SET pos_x = -106.709, pos_y = 13.513, pos_z = -32.423 WHERE mobid = 17268892;    -- Diving Beetle (H-8) to (H-8)
UPDATE mob_spawn_points SET pos_x = -122.738, pos_y = 16.782, pos_z = -15.112 WHERE mobid = 17268893;    -- Diving Beetle (H-8) to (H-8)
UPDATE mob_spawn_points SET pos_x = 41.199, pos_y = 3.915, pos_z = -138.797   WHERE mobid = 17268903;    -- Goblin Gambler (G-8) to (I-9)
UPDATE mob_spawn_points SET pos_x = -189.420, pos_y = 7.719, pos_z = 222.859  WHERE mobid = 17268914;    -- Evil Weapon (I-9) to (G-7)
UPDATE mob_spawn_points SET pos_x = -200.191, pos_y = 8.897, pos_z = 217.967  WHERE mobid = 17268915;    -- Evil Weapon (I-9) to (G-7)
UPDATE mob_spawn_points SET pos_x = -206.994, pos_y = 7.308, pos_z = 197.859  WHERE mobid = 17268916;    -- Evil Weapon (I-9) to (G-7)
UPDATE mob_spawn_points SET pos_x = -249.403, pos_y = 7.731, pos_z = 95.787   WHERE mobid = 17268942;    -- Diving Beetle (I-7) to (G-8)
UPDATE mob_spawn_points SET pos_x = -328.599, pos_y = 0.208, pos_z = 478.373  WHERE mobid = 17268950;    -- Tabar Beak (G-6) to (F-5)
UPDATE mob_spawn_points SET pos_x = -325.729, pos_y = 6.524, pos_z = 452.901  WHERE mobid = 17268951;    -- Tabar Beak (H-6) to (F-5)
UPDATE mob_spawn_points SET pos_x = -337.046, pos_y = 6.404, pos_z = 416.889  WHERE mobid = 17268958;    -- Tabar Beak (H-6) to (F-5)
UPDATE mob_spawn_points SET pos_x = -324.299, pos_y = 7.956, pos_z = 400.823  WHERE mobid = 17268959;    -- Tabar Beak (G-6) to (F-6)
UPDATE mob_spawn_points SET pos_x = -313.346, pos_y = 8.656, pos_z = 375.945  WHERE mobid = 17268982;    -- Tabar Beak (K-7) to (F-6)
UPDATE mob_spawn_points SET pos_x = -335.946, pos_y = 5.027, pos_z = 381.727  WHERE mobid = 17268983;    -- Tabar Beak (G-6) to (F-6)
UPDATE mob_spawn_points SET pos_x = -248.959, pos_y = 8.000, pos_z = 47.929   WHERE mobid = 17268989;    -- Diving Beetle (G-7) to (G-8)
UPDATE mob_spawn_points SET pos_x = -143.152, pos_y = 16.344, pos_z = 23.772  WHERE mobid = 17268943;    -- Diving Beetle (I-7) to (G-8)
UPDATE mob_spawn_points SET pos_x = -278.032, pos_y = 8.912, pos_z = 61.719   WHERE mobid = 17268990;    -- Diving Beetle (G-7) to (G-8)
UPDATE mob_spawn_points SET pos_x = -251.085, pos_y = 6.624, pos_z = 237.317  WHERE mobid = 17269010;    -- Evil Weapon (J-10) ledge to (G-7)
UPDATE mob_spawn_points SET pos_x = -123.030, pos_y = 16.635, pos_z = 25.598  WHERE mobid = 17269063;    -- Hill Lizard (J-10) ledge to (H-8)
UPDATE mob_spawn_points SET pos_x = -110.750, pos_y = 15.578, pos_z = 8.660   WHERE mobid = 17269069;    -- Hill Lizard (J-9) ledge to (H-8)
UPDATE mob_spawn_points SET pos_x = -124.816, pos_y = 16.039, pos_z = -2.825  WHERE mobid = 17269070;    -- Hill Lizard (J-9) ledge to (G-8)
UPDATE mob_spawn_points SET pos_x = -152.032, pos_y = 16.565, pos_z = 15.281  WHERE mobid = 17269071;    -- Hill Lizard (J-9) ledge to (G-8)

-- West Sarutabaruta [S]
UPDATE mob_spawn_points SET pos_x = 187.425, pos_y = -5.099, pos_z = 109.099  WHERE mobid = 17166346;     -- Bee from north side of hill to tower (I-8)
UPDATE mob_spawn_points SET pos_x = 277.979, pos_y = -20.000, pos_z = 599.426 WHERE mobid = 17166353;     -- Dhalmel away from wall and into herd (J-5)
UPDATE mob_spawn_points SET pos_x = 249.193, pos_y = -20.326, pos_z = 596.602 WHERE mobid = 17166358;     -- Dhalmel away from wall and into herd (J-5)
UPDATE mob_spawn_points SET pos_x = 201.474, pos_y = -21.072, pos_z = 577.137 WHERE mobid = 17166362;     -- Dhalmel stacked directly on another spread to (I-5)
UPDATE mob_spawn_points SET pos_x = 243.325, pos_y = -20.066, pos_z = 565.044 WHERE mobid = 17166366;     -- Dhalmel closer into herd (J-5)
UPDATE mob_spawn_points SET pos_x = 239.288, pos_y = -20.986, pos_z = 535.760 WHERE mobid = 17166367;     -- Dhalmel closer into herd (J-5)
UPDATE mob_spawn_points SET pos_x = 209.547, pos_y = -4.987, pos_z = 55.569   WHERE mobid = 17166378;     -- Bee from West hill to (I-8) tower
UPDATE mob_spawn_points SET pos_x = 58.987, pos_y = -14.822, pos_z = 217.642  WHERE mobid = 17166381;     -- Bee from hill moved to (H-7) near OP
UPDATE mob_spawn_points SET pos_x = 192.455, pos_y = -4.449, pos_z = 78.999   WHERE mobid = 17166385;     -- Bee from hill moved to (I-8) tower
UPDATE mob_spawn_points SET pos_x = 99.384, pos_y = -8.367, pos_z = 123.895   WHERE mobid = 17166387;     -- Crawler from West hill closer to group (I-7)
UPDATE mob_spawn_points SET pos_x = 91.949, pos_y = -10.748, pos_z = 171.822  WHERE mobid = 17166388;     -- Crawler from West hill closer to group (I-7)
UPDATE mob_spawn_points SET pos_x = 89.851, pos_y = -8.367, pos_z = 123.895   WHERE mobid = 17166396;     -- Crawler from hill into the group (I-7)
UPDATE mob_spawn_points SET pos_x = 120.588, pos_y = -16.771, pos_z = 184.566 WHERE mobid = 17166397;     -- Crawler from ledge into the group (I-7)
UPDATE mob_spawn_points SET pos_x = 93.392, pos_y = -14.409, pos_z = 194.913 WHERE mobid = 17166398;      -- Crawler from East of hill to West (I-7)
UPDATE mob_spawn_points SET pos_x = 121.402, pos_y = -9.898, pos_z = 135.138 WHERE mobid = 17166399;      -- Crawler from East of hill to West (I-7)
UPDATE mob_spawn_points SET pos_x = 120.264, pos_y = -7.958, pos_z = 115.603 WHERE mobid = 17166400;      -- Crawler from East of hill to (I-8)
UPDATE mob_spawn_points SET pos_x = 59.368, pos_y = -19.879, pos_z = 275.701 WHERE mobid = 17166403;      -- Bee from hill moved to groups
UPDATE mob_spawn_points SET pos_x = 66.776, pos_y = -19.606, pos_z = 251.934 WHERE mobid = 17166404;      -- Bee from hill moved to groups
UPDATE mob_spawn_points SET pos_x = 68.950, pos_y = -18.981, pos_z = 234.797 WHERE mobid = 17166408;      -- Bee from hill moved to groups
UPDATE mob_spawn_points SET pos_x = 203.340, pos_y = -4.368, pos_z = 89.869 WHERE mobid = 17166411;       -- Bee from hill moved to (I-8) tower
UPDATE mob_spawn_points SET pos_x = 203.886, pos_y = -4.000, pos_z = 121.811 WHERE mobid = 17166412;      -- Bee from hill moved to (I-8) tower
UPDATE mob_spawn_points SET pos_x = 40.746, pos_y = -16.278, pos_z = 248.429 WHERE mobid = 17166418;      -- Bee from hill moved to groups
UPDATE mob_spawn_points SET pos_x = -23.421, pos_y = -12.515, pos_z = 232.079 WHERE mobid = 17166420;     -- Rarab from near Arbiter to Road near OP (H-7)
UPDATE mob_spawn_points SET pos_x = -4.573, pos_y = -11.552, pos_z = 231.782 WHERE mobid = 17166421;      -- Rarab from Crows closer to group of rarabs near fort
UPDATE mob_spawn_points SET pos_x = 16.029, pos_y = -13.915, pos_z = 235.207 WHERE mobid = 17166422;      -- Rarab from Crows closer to group of rarabs near fort
UPDATE mob_spawn_points SET pos_x = -35.893, pos_y = -8.682, pos_z = 173.406 WHERE mobid = 17166424;      -- Crow from (H-7) Near OP from on top of the other crow
UPDATE mob_spawn_points SET pos_x = -30.050, pos_y = -12.373, pos_z = 241.714 WHERE mobid = 17166428;     -- Rarab from near Arbiter to Road near OP (H-7)
UPDATE mob_spawn_points SET pos_x = -12.064, pos_y = -11.134, pos_z = 221.376 WHERE mobid = 17166429;     -- Rarab from near Arbiter to Road near group (H-7)
UPDATE mob_spawn_points SET pos_x = -109.686, pos_y = -17.146, pos_z = 344.212 WHERE mobid = 17166430;    -- Rarab from near Arbiter to Road near group (G-6)
UPDATE mob_spawn_points SET pos_x = 289.018, pos_y = -4.315, pos_z = 41.908 WHERE mobid = 17166462;       -- Spread out Lycopodium (J-8)
UPDATE mob_spawn_points SET pos_x = 321.998, pos_y = -4.578, pos_z = 52.573 WHERE mobid = 17166463;       -- Spread out Lycopodium (J-8)
UPDATE mob_spawn_points SET pos_x = 230.758, pos_y = -4.500, pos_z = 87.492 WHERE mobid = 17166464;       -- Spread out Lycopodium (I-8)
UPDATE mob_spawn_points SET pos_x = 257.506, pos_y = -5.098, pos_z = 78.756 WHERE mobid = 17166465;       -- Spread out Lycopodium (J-8)
UPDATE mob_spawn_points SET pos_x = 293.216, pos_y = -4.644, pos_z = 113.723 WHERE mobid = 17166466;      -- Spread out Lycopodium (J-8)
UPDATE mob_spawn_points SET pos_x = -11.803, pos_y = -9.114, pos_z = 187.146 WHERE mobid = 17166468;      -- Crow from near East Saruta to (H-7) Near OP
UPDATE mob_spawn_points SET pos_x = -28.311, pos_y = -9.069, pos_z = 148.694 WHERE mobid = 17166469;      -- Crow from near East Saruta to (H-7)
UPDATE mob_spawn_points SET pos_x = 69.601, pos_y = -1.128, pos_z = 17.212 WHERE mobid = 17166470;        -- Crow from near East Saruta to (H-8)
UPDATE mob_spawn_points SET pos_x = 91.283, pos_y = -0.457, pos_z = 41.287 WHERE mobid = 17166471;        -- Crow from near East Saruta to (I-8)
UPDATE mob_spawn_points SET pos_x = 309.984, pos_y = -4.717, pos_z = 21.982 WHERE mobid = 17166461;       -- Lycopodium on top of the other spread out (J-8)
UPDATE mob_spawn_points SET pos_x = 281.938, pos_y = -4.409, pos_z = 90.526 WHERE mobid = 17166467;       -- Lycopodium from East spread out West (J-8)
UPDATE mob_spawn_points SET pos_x = 254.738, pos_y = -5.029, pos_z = 94.621 WHERE mobid = 17166473;       -- Stray Lycopodium from East spread out West (J-8)
UPDATE mob_spawn_points SET pos_x = 221.751, pos_y = -5.142, pos_z = 76.698 WHERE mobid = 17166481;       -- Rarab from gate to Waters moved from lycopodium field to (I-8)
UPDATE mob_spawn_points SET pos_x = 218.934, pos_y = -5.374, pos_z = 98.646 WHERE mobid = 17166482;       -- Rarab from gate to Waters moved from lycopodium field to (I-8)
UPDATE mob_spawn_points SET pos_x = 310.703, pos_y = -16.332, pos_z = 238.370 WHERE mobid = 17166483;     -- Gob Franctireur from on top of Gob Patrolman to fill the area better (J-7)
UPDATE mob_spawn_points SET pos_x = 265.941, pos_y = -3.374, pos_z = 93.649 WHERE mobid = 17166490;       -- Stray Rarab pulled into (J-8)
UPDATE mob_spawn_points SET pos_x = 240.487, pos_y = -4.911, pos_z = 97.446 WHERE mobid = 17166491;       -- Stray Rarab pulled into (J-8)
UPDATE mob_spawn_points SET pos_x = 240.440, pos_y = -4.000, pos_z = 76.032 WHERE mobid = 17166492;       -- Stray Rarab pulled into (J-8) near tower
UPDATE mob_spawn_points SET pos_x = 61.940, pos_y = -9.250, pos_z = 154.210 WHERE mobid = 17166494;       -- Crawler from Lycopodium/Rarab tower to group (H-7)
UPDATE mob_spawn_points SET pos_x = 274.965, pos_y = -4.628, pos_z = 67.022 WHERE mobid = 17166497;       -- Stray Lycopodium moved to (J-8)
UPDATE mob_spawn_points SET pos_x = 85.785, pos_y = 3.639, pos_z = -449.740 WHERE mobid = 17166547;       -- Spread Crab (I-11)
UPDATE mob_spawn_points SET pos_x = 81.931, pos_y = 4.000, pos_z = -477.071 WHERE mobid = 17166548;       -- Spread Crab (I-11)
UPDATE mob_spawn_points SET pos_x = 76.036, pos_y = 3.120, pos_z = -465.023 WHERE mobid = 17166549;       -- Spread Crab (I-11)
UPDATE mob_spawn_points SET pos_x = 113.551, pos_y = 8.082, pos_z = -459.045 WHERE mobid = 17166552;      -- Spread Crab (I-11)
UPDATE mob_spawn_points SET pos_x = -56.245, pos_y = -5.017, pos_z = -359.849 WHERE mobid = 17166564;     -- Spread Hispid Rarab (H-11)
UPDATE mob_spawn_points SET pos_x = -103.879, pos_y = -5.183, pos_z = -393.097 WHERE mobid = 17166569;    -- Spread Hispid Rarab (G-11)
UPDATE mob_spawn_points SET pos_x = -117.634, pos_y = -5.177, pos_z = -138.807 WHERE mobid = 17166578;    -- Goblin Franctireur to (G-9)
UPDATE mob_spawn_points SET pos_x = -334.848, pos_y = 8.844, pos_z = -459.946 WHERE mobid = 17166597;     -- Spread Crab (F-11)
UPDATE mob_spawn_points SET pos_x = -356.556, pos_y = 2.874, pos_z = -417.981 WHERE mobid = 17166601;     -- Spread Crab (F-11)
UPDATE mob_spawn_points SET pos_x = -359.191, pos_y = 3.472, pos_z = -427.843 WHERE mobid = 17166602;     -- Spread Crab (F-11)
UPDATE mob_spawn_points SET pos_x = -369.059, pos_y = 5.218, pos_z = -444.804 WHERE mobid = 17166603;     -- Spread Crab (F-11)
UPDATE mob_spawn_points SET pos_x = -342.990, pos_y = 2.763, pos_z = -434.770 WHERE mobid = 17166604;     -- Spread Crab (F-11)
UPDATE mob_spawn_points SET pos_x = -331.128, pos_y = 3.552, pos_z = -438.767 WHERE mobid = 17166606;     -- Spread Crab (F-11)
UPDATE mob_spawn_points SET pos_x = -326.860, pos_y = 4.735, pos_z = -449.025 WHERE mobid = 17166607;     -- Spread Crab (F-11)
UPDATE mob_spawn_points SET pos_x = -352.860, pos_y = 3.791, pos_z = -435.853 WHERE mobid = 17166608;     -- Spread Crab (F-11)
UPDATE mob_spawn_points SET pos_x = -44.748, pos_y = -4.048, pos_z = -237.584 WHERE mobid = 17166614;     -- Lonely Crawler all the way west by coast to (H-10)
UPDATE mob_spawn_points SET pos_x = -66.673, pos_y = -4.672, pos_z = -236.639 WHERE mobid = 17166623;     -- Crawler to (H-10)
UPDATE mob_spawn_points SET pos_x = 1.708, pos_y = -0.699, pos_z = -213.533 WHERE mobid = 17166625;       -- Bumblebee to (H-10)
UPDATE mob_spawn_points SET pos_x = -3.460, pos_y = 0.000, pos_z = -237.638 WHERE mobid = 17166626;       -- Bumblebee to (H-10)
UPDATE mob_spawn_points SET pos_x = -127.447, pos_y = -16.742, pos_z = 368.849 WHERE mobid = 17166648;    -- Rabbit from bee cluster out to (G-6) nearer OP
UPDATE mob_spawn_points SET pos_x = -97.496, pos_y = -16.902, pos_z = 356.502 WHERE mobid = 17166649;     -- Rabbit from bee cluster out to (G-6) nearer OP
UPDATE mob_spawn_points SET pos_x = -117.131, pos_y = -16.120, pos_z = 354.094 WHERE mobid = 17166650;    -- Rabbit from bee cluster out to (G-6) nearer OP
UPDATE mob_spawn_points SET pos_x = -118.723, pos_y = -16.472, pos_z = 371.532 WHERE mobid = 17166654;    -- Pull outter bee into (G-6)
UPDATE mob_spawn_points SET pos_x = -143.746, pos_y = -17.184, pos_z = 394.716 WHERE mobid = 17166657;    -- Bee from NW tower to (G-6)
UPDATE mob_spawn_points SET pos_x = -172.804, pos_y = -16.500, pos_z = 352.326 WHERE mobid = 17166668;    -- Bee from NW tower to (G-6)
UPDATE mob_spawn_points SET pos_x = -143.952, pos_y = -17.012, pos_z = 363.265 WHERE mobid = 17166660;    -- Bee from NW ledge to (G-6)
UPDATE mob_spawn_points SET pos_x = -164.580, pos_y = -16.305, pos_z = 391.750 WHERE mobid = 17166664;    -- Bee from NW ledge to (G-6)
UPDATE mob_spawn_points SET pos_x = -102.331, pos_y = -17.397, pos_z = 338.515 WHERE mobid = 17166665;    -- Bee from NW ledge to (G-6) near OP
UPDATE mob_spawn_points SET pos_x = -198.903, pos_y = -0.457, pos_z = 41.287 WHERE mobid = 17166672;      -- Bee from NW tower to (G-6)
UPDATE mob_spawn_points SET pos_x = 394.273, pos_y = -4.109, pos_z = 83.000 WHERE mobid = 17166677;       -- Yagudo Persecutor from East Saruta dead end to fill for moved crow
UPDATE mob_spawn_points SET pos_x = 376.695, pos_y = -5.045, pos_z = 119.739 WHERE mobid = 17166679;      -- Yagudo Persecutor from East Saruta dead end to fill for moved crow
UPDATE mob_spawn_points SET pos_x = -199.875, pos_y = -2.000, pos_z = -220.089 WHERE mobid = 17166685;    -- Predatory Goblin Skirmisher to (G-10)
UPDATE mob_spawn_points SET pos_x = -165.524, pos_y = -4.197, pos_z = -160.835 WHERE mobid = 17166687;    -- Goblin Skirmisher to (G-9)
UPDATE mob_spawn_points SET pos_x = 93.538, pos_y = -0.698, pos_z = -205.332 WHERE mobid = 17166701;      -- Dumb frog spread out from incorrect cluster of 3 on top of each other (I-10)
UPDATE mob_spawn_points SET pos_x = -313.149, pos_y = -0.362, pos_z = -322.096 WHERE mobid = 17166704;    -- Pond Poroggo Gent to South tower (F-10)
UPDATE mob_spawn_points SET pos_x = -392.139, pos_y = 3.493, pos_z = -353.959 WHERE mobid = 17166706;     -- South tower Poroggo Gent to coast (F-10)
UPDATE mob_spawn_points SET pos_x = -388.276, pos_y = 7.077, pos_z = -378.935 WHERE mobid = 17166707;     -- South tower Poroggo Gent to coast (F-11)
UPDATE mob_spawn_points SET pos_x = -319.375, pos_y = 3.706, pos_z = -368.664 WHERE mobid = 17166708;     -- South tower Toad from behind tower to north (F-11)
UPDATE mob_spawn_points SET pos_x = -371.072, pos_y = 4.901, pos_z = -372.256 WHERE mobid = 17166710;     -- South tower Toad from behind tower to west (F-11)
UPDATE mob_spawn_points SET pos_x = -418.003, pos_y = 9.535, pos_z = -382.526 WHERE mobid = 17166713;     -- North tower Poroggo Gent to coast (E-11)
UPDATE mob_spawn_points SET pos_x = -421.829, pos_y = 2.862, pos_z = -359.504 WHERE mobid = 17166714;     -- North tower Poroggo Gent to coast (E-10)
UPDATE mob_spawn_points SET pos_x = -320.598, pos_y = 3.823, pos_z = -354.640 WHERE mobid = 17166715;     -- North tower Toad to South tower (F-10)
UPDATE mob_spawn_points SET pos_x = -311.730, pos_y = 2.545, pos_z = -343.867 WHERE mobid = 17166716;     -- North tower Toad to South tower (F-10)
UPDATE mob_spawn_points SET pos_x = -321.407, pos_y = 0.812, pos_z = -330.554 WHERE mobid = 17166717;     -- North tower Toad to South tower (F-10)
UPDATE mob_spawn_points SET pos_x = -361.336, pos_y = 3.601, pos_z = -352.860 WHERE mobid = 17166718;     -- North tower Toad to South tower (F-10)
UPDATE mob_spawn_points SET pos_x = 318.866, pos_y = -12.000, pos_z = 197.765 WHERE mobid = 17166721;     -- Goblin Picaroon from ledge of hill to fill goblin gap (J-7)
