-- ------------------------------------------------------------
-- Notes
-- ------------------------------------------------------------

-- This is a general reduction of respawn timers for foes in dungeons. Half of them were already 5 minutes. This equalizes it and makes it easier for players to understand or experience.
-- Includes most dungeons except for Castle Zvahl Baileys (S), Castle Zvahl Keep (S), Dragon's Aery.
-- Dungeons that already had their timers changed to 300 like the Crawlers Nest or Dangruf Wadi are not in here.
-- Special psuedo NMs (with job testimonies) such as the Orcish Warlord or Yagudo High Priest are set to 15 minutes instead of 20. Some already were inconsistently 15 while others were longer.
-- Grand Palace of HuXzoi only had zdei respawn reduced for camping Temperance as a QoL measure. Nothing else seemed necessary or desirable.
-- The Garden of Ru'Hmet only had Aern timers reduced for camping Ix'aern (DRG).
-- The Shrine of Ru'Avitau only had Pots, Statues, and elemental recast reduced to aid in farming Water or Diorite and crystals.
-- Labyrinth of Onzozo Torama, Manticore, Goblins were not changed due to our excavation points near them. Faster respawns would hinder the activity.
-- A few random NMs such as Ancient Gobbue or Oni Carcass with no real value that get requested as goblin daily NMs were changed from 24 hours to 6.

-- ------------------------------------------------------------
-- Alzadaal_Undersea_Ruins (Zone 72)
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qiqirn_Poulterer' AND zoneid = 72;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qiqirn_Goldsmith' AND zoneid = 72;

-- ------------------------------------------------------------
-- Arrapago_Reef (Zone 54)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Reserve_Draugar_thf' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Reserve_Draugar_blm' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Merrow_Chantress' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Arrapago_Apkallu' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Graverobber' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Phasma' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Reserve_Draugar_drk' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Dartist' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Dancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Reserve_Draugar_drg' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Jnun' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nipper' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Fatedealer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qutrub_drk' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ashakku' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Purgatory_Bat' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qiqirn_Treasure_Hunter' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qiqirn_Trailer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Heraldic_Imp' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamie_No7' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Merrow_Shadowdancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Merrow_Icedancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Merrow_Kabukidancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bhoot' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fallen_Volunteer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fallen_Imperial_Wizard' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fallen_Imperial_Trooper' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Bellydancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Draugar_Servant_drk' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Soulflayer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Draugar_Servant_blm' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Draugar_Servant_drg' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Deathdancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Draugar_Servant_thf' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Merrow_Songstress' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Merrow_Bladedancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ice_Elemental' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Merrow_Wavedancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Idolater_drk' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Necromancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Toxophilite' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Seneschal_Imp' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Merrow_Typhoondancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Emperor_Apkallu' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nix_Songstress' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Elemental' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nix_Wavedancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nix_Bladedancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nix_Typhoondancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamie_Necromancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamie_Bellydancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamie_Deathdancer' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamie_Toxophilite' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ephramadian_Shade_mnk' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ephramadian_Shade_rdm' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ephramadian_Shade_rng' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ephramadian_Shade_cor' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Palace_Guard_rng' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Palace_Guard_cor' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qutrub_blm' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lamia_Idolater_blm' AND zoneid = 54;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lahama' AND zoneid = 54;

-- ------------------------------------------------------------
-- Aydeewa_Subterrane (Zone 68)
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Treant_Sapling' AND zoneid = 68;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Puktrap' AND zoneid = 68;                 -- Ventures
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Slime_Mold' AND zoneid = 68;
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Qiqirn_Enterpriser' AND zoneid = 68;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Qiqirn_Lieuter' AND zoneid = 68;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fossorial_Flea' AND zoneid = 68;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Phlebotomic_Slug' AND zoneid = 68;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Defoliator' AND zoneid = 68;              -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Deforester' AND zoneid = 68;
UPDATE `mob_groups` SET `respawntime` = 480 WHERE name = 'Air_Elemental' AND zoneid = 68;
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Aydeewa_Diremite' AND zoneid = 68;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Mycohopper' AND zoneid = 68;              -- Ventures
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Great_Ameretat' AND zoneid = 68;
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Qiqirn_Archaeologist' AND zoneid = 68;    -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Qiqirn_Mosstrooper' AND zoneid = 68;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Mold_Eater' AND zoneid = 68;              -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Cave_Tiger' AND zoneid = 68;              -- Ventures

-- ------------------------------------------------------------
-- Batallia_Downs (Zone 105)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Ba' AND zoneid = 105;                  -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'May_Fly' AND zoneid = 105;             -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Clipper' AND zoneid = 105;             -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Stalking_Sapling' AND zoneid = 105;    -- Ventures

-- ------------------------------------------------------------
-- Batallia_Downs (S) (Zone 84)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Ba' AND zoneid = 84;                  -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Clipper' AND zoneid = 84;             -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Forester_Beetle' AND zoneid = 84;     -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Lycopodium' AND zoneid = 84;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Sadfly' AND zoneid = 84;              -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Smilodon' AND zoneid = 84;            -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Stalking_Sapling' AND zoneid = 84;    -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Tsetse_Fly' AND zoneid = 84;          -- Ventures

-- ------------------------------------------------------------
-- Beadeaux (Zone 147)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Land_Pugil' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Silver_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Garnet_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Zircon_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bronze_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Caterpillar' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Elder_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Iron_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spinel_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Emerald_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Broo' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gloop' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Steel_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mythril_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gold_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Topaz_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Big_Jaw' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ancient_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Darksteel_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Platinum_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sapphire_Quadav' AND zoneid = 147;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Larva' AND zoneid = 147;

-- ------------------------------------------------------------
-- Beadeaux_[S] (Zone 92)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ancient_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Vajra_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Star_Ruby_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Edible_Slug' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Pitchy_Pudding' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Magnes_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gold_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Seneschal_Imp' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Iron_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Adaman_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Electrumcap' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Doyen_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Chatoyant_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Meteor_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Platinum_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Steel_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ferroalloy_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Baetyl_Quadav' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Virulent_Peiste' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 7200 WHERE name = 'GaLhu_Nevermolt' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 7200 WHERE name = 'Bres' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 7200 WHERE name = 'DiZho_Spongeshell' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 7200 WHERE name = 'Observant_Zekka' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 7200 WHERE name = 'MuNhi_Thimbletail' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 7200 WHERE name = 'Blifnix_Oilycheeks' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 7200 WHERE name = 'VaGho_Bloodbasked' AND zoneid = 92;
UPDATE `mob_groups` SET `respawntime` = 7200 WHERE name = 'RaDha_Scarscute' AND zoneid = 92;

-- ------------------------------------------------------------
-- Bhaflau_Thickets (Zone 52)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Lesser_Colibri' AND zoneid = 52;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Colibri' AND zoneid = 52;              -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Date_Eruca' AND zoneid = 52;           -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Treant_Sapling' AND zoneid = 52;       -- Ventures

-- ------------------------------------------------------------
-- Bibiki_Bay (Zone 4)
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Tragopan' AND zoneid = 4;              -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Tropical_Rarab' AND zoneid = 4;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Tartarus_Eft' AND zoneid = 4;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Hobgoblin_Animalier' AND zoneid = 4;   -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Hobgoblin_Fascinator' AND zoneid = 4;  -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Hobgoblin_Martialist' AND zoneid = 4;  -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Hobgoblin_Venerer' AND zoneid = 4;     -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Catoblepas' AND zoneid = 4;            -- Ventures

-- ------------------------------------------------------------
-- Cape_Teriggan (Zone 113)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Beach_Bunny' AND zoneid = 113;         -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Robber_Crab' AND zoneid = 113;         -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Terror_Pugil' AND zoneid = 113;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Terror_Pugil' AND zoneid = 113;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Velociraptor' AND zoneid = 113;        -- Ventures

-- ------------------------------------------------------------
-- Caedarva_Mire (Zone 79)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Treant_Sapling' AND zoneid = 79;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Caedarva_Leech' AND zoneid = 79;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Puktrap' AND zoneid = 79;               -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Oil_Slick' AND zoneid = 79;             -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Oderly_Imp' AND zoneid = 79;            -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Qiqirn_Rock_Hound' AND zoneid = 79;     -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Qiqirn_Mireguide' AND zoneid = 79;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Wild_Karakul' AND zoneid = 79;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Mature_Treant' AND zoneid = 79;         -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Ephramadian_Shade' AND zoneid = 79;     -- Ventures
UPDATE `mob_groups` SET `respawntime` = 260 WHERE name = 'Reserve_Draugar' AND zoneid = 79;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 260 WHERE name = 'Lamia_Fatedealer' AND zoneid = 79;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Jnun' AND zoneid = 79;                  -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Heraldic_Imp' AND zoneid = 79;
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Spongilla_Fly' AND zoneid = 79;
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Slough_Skua' AND zoneid = 79;

-- ------------------------------------------------------------
-- Castle_Oztroja (Zone 151)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Votary' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bastion_Bats' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Theologist' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Priest' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Herald' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Oracle' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Interrogator' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Meat_Maggot' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fire_Elemental' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Earth_Elemental' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Drummer' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Cutter' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bulwark_Bat' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Zealot' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Prior' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Conquistador' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Lutenist' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Sentinel' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Abbot' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Chanter' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Inquisitor' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ooze' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Parasite' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Flagellant' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Prelate' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Conductor' AND zoneid = 151;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Assassin' AND zoneid = 151;

-- ------------------------------------------------------------
-- Castle_Oztroja_[S] (Zone 99)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Sentinel' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Knight_Templar' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bastion_Bats' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Eradicator' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_High_Priest' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Prelate' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Chanter' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Prioress' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Blooming_Rafflesia' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Antlion_Fly' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Earth_Elemental' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fire_Elemental' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'War_Lynx' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Immolatory_Pugil' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Seneschal_Imp' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Yojimbo' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Nokizaru' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Flagellant' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bulwark_Bat' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Abbot' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Hierogrammat' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Conductor' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gnat' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Superior' AND zoneid = 99;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Parasite' AND zoneid = 99;

-- ------------------------------------------------------------
-- Castle_Zvahl_Baileys (Zone 161)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Evil_Eye' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Pawn' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Elemental' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ice_Elemental' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Knight' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Wizard' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Poacher' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Trader' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Robber' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Reaper' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Bowshooter' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Footsoldier' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Gladiator' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Trooper' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Warlock' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Elder_Quadav' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Iron_Quadav' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spinel_Quadav' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Emerald_Quadav' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Zealot' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Conquistador' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Lutenist' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Prior' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Morbid_Eye' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Commander' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_General' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Chancellor' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Magistrate' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Blood_Demon' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Doom_Demon' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Arch_Demon' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Abyssal_Demon' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ahriman' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dread_Demon' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Judicator_Demon' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Stygian_Demon' AND zoneid = 161;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gore_Demon' AND zoneid = 161;

-- ------------------------------------------------------------
-- Castle_Zvahl_Keep (Zone 162)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Pawn' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Evil_Eye' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Wizard' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Knight' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demon_Warlock' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Poacher' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Trader' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Robber' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Reaper' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Hunter' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Bouncer' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Enchanter' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Bowshooter' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Footsoldier' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Gladiator' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Trooper' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Veteran' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Predator' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Zerker' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Warchief' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Elder_Quadav' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Iron_Quadav' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spinel_Quadav' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Emerald_Quadav' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Steel_Quadav' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mythril_Quadav' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gold_Quadav' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Topaz_Quadav' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Zealot' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Conquistador' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Lutenist' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Prior' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Sentinel' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Chanter' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Inquisitor' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Abbot' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Morbid_Eye' AND zoneid = 162;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Deadly_Iris' AND zoneid = 162;

-- ------------------------------------------------------------
-- Crawlers_Nest_[S] (Zone 171)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Witch_Hazel' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Puroboros' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fire_Elemental' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Electrumcap' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Wespe' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Labyrinth_Lizard' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Old_Quadav' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Heliodor_Quadav' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Silver_Quadav' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Emerald_Quadav' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bronze_Quadav' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Brass_Quadav' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sapphirine_Quadav' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Doom_Scorpion' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Processionaire' AND zoneid = 171;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 171;

-- ------------------------------------------------------------
-- Davoi (Zone 149)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Fighter' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Cursemaker' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Davoi_Hornet' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Serjeant' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Wood_Bats' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Impaler' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Beastrider' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Nightraider' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Brawler' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'War_Lizard' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Firebelcher' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Wolf_Bat' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Bowshooter' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Footsoldier' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Gladiator' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Trooper' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Davoi_Wasp' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Geezard' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Veteran' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Predator' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Zerker' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Warchief' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Dreadnought' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Farkiller' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Champion' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Davoi_Pugil' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Morbol' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Davoi_Mush' AND zoneid = 149;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Dragoon' AND zoneid = 149;

-- ------------------------------------------------------------
-- Den_of_Rancor (Zone 160)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Trailer' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dire_Bat' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fire_Elemental' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Imprecator' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Slasher' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Beleaguerer' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bifrons' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Cave_Worm' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tormentor' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Puck' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bullbeggar' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Den_Scorpion' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demonic_Pugil' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Doom_Toad' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Succubus_Bats' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Cutlass_Scorpion' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Million_Eyes' AND zoneid = 160;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mousse' AND zoneid = 160;

-- ------------------------------------------------------------
-- East_Ronfaure_[S] (Zone 81)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Djinn' AND zoneid = 81;           -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Giant_Spider' AND zoneid = 81;    -- Ventures

-- ------------------------------------------------------------
-- FeiYin (Zone 204)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Undead_Bats' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Revenant' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Drone' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Vampire_Bat' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Clockwork_Pod' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ore_Golem' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Shadow_war' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Shadow_rng' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Shadow_blm' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Shadow_thf' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Underworld_Bats' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Talos' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Droma' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Camazotz' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Utukku' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Colossus' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ice_Elemental' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Elemental' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Killing_Weapon' AND zoneid = 204;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Hellish_Weapon' AND zoneid = 204;

-- ------------------------------------------------------------
-- Giddeus (Zone 145)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Votary' AND zoneid = 145;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Theologist' AND zoneid = 145;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Yagudo_Priest' AND zoneid = 145;

-- ------------------------------------------------------------
-- Grand_Palace_of_HuXzoi (Zone 34)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Eozdei' AND zoneid = 34;

-- ------------------------------------------------------------
-- Gustav_Tunnel (Zone 212)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Erlik' AND zoneid = 212;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Antares' AND zoneid = 212;
UPDATE `mob_groups` SET `respawntime` = 420 WHERE name = 'Demonic_Pugil' AND zoneid = 212;  -- Adds a 2 minute pad to respawn to help with Bastok 9-1
UPDATE `mob_groups` SET `respawntime` = 420 WHERE name = 'Doom_Warlock' AND zoneid = 212;   -- Adds a 2 minute pad to respawn to help with Bastok 9-1/Evisceration
UPDATE `mob_groups` SET `respawntime` = 420 WHERE name = 'Doom_Guard' AND zoneid = 212;     -- Adds a 2 minute pad to respawn to help with Bastok 9-1/Evisceration

-- ------------------------------------------------------------
-- Halvung (Zone 62)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qiqirn_Mercenary' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qiqirn_Diamantaire' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Volcanic_Bats' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Purgatory_Bat' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Troll_Gemologist' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Troll_Stoneworker' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Troll_Lapidarist' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Troll_Smelter' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Troll_Engraver' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Troll_Cameist' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Troll_Ironworker' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Earth_Elemental' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Black_Pudding' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Wamouracampa' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Magmatic_Eruca' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Billionaire' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fire_Elemental' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Friars_Lantern' AND zoneid = 62;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Wamoura' AND zoneid = 62;

-- ------------------------------------------------------------
-- King_Ranperres_Tomb (Zone 190)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Ding_Bats' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Carrion_Worm' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Goblin_Thug' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Mouse_Bat' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Goblin_Weaver' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Stone_Eater' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Enchanted_Bones_blm' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spook' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Wind_Bats' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Goblin_Ambusher' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Goblin_Tinkerer' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Goblin_Butcher' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Grave_Bat' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Rock_Eater' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Nachzehrer_war' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Tomb_Bat' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Plague_Bats' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Goblin_Mugger' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Goblin_Leecher' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Goblin_Gambler' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Locus_Tomb_Worm' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Locus_Dire_Bat' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Locus_Cutlass_Scorpion' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Locus_Thousand_Eyes' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Hati' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Spartoi_Warrior' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Spartoi_Sorcerer' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Locus_Lemures' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Locus_Armet_Beetle' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Enchanted_Bones_war' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Nachzehrer_blm' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Locus_Hati' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Locus_Spartoi_Sorcerer' AND zoneid = 190;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Locus_Spartoi_Warrior' AND zoneid = 190;

-- ------------------------------------------------------------
-- Korroloka_Tunnel (Zone 173)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Land_Worm' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Seeker_Bats' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thread_Leech' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Huge_Spider' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Combat' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Jelly' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sea_Monk' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Clipper' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Jammer_Leech' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bogy' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gigas_Stonemason' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gigas_Stonecarrier' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gigas_Stonegrinder' AND zoneid = 173;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gigas_Foreman' AND zoneid = 173;

-- ------------------------------------------------------------
-- Kuftal_Tunnel (Zone 174)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Diplopod' AND zoneid = 174;
UPDATE `mob_groups` SET `respawntime` = 960 WHERE name = 'Devil_Manta_fished' AND zoneid = 174;
-- Due to the unique name of the Devil Manta fished, and how it doesnt return a result when searching on our website, this entry below is a backup
-- Otherwise the Devil Manta can be fished over and over with no delay. This would flood Angel Skin across the server.
UPDATE `mob_groups` SET `respawntime` = 960 WHERE groupid = 3 AND dropid = 644 AND zoneid = 174; -- Devil Manta 16 Minutes

-- ------------------------------------------------------------
-- La_Vaule_[S] (Zone 85)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Morbol' AND zoneid = 85;
UPDATE `mob_groups` SET `respawntime` = 7200 WHERE name = 'Rugaroo' AND zoneid = 85;

-- ------------------------------------------------------------
-- Labyrinth_of_Onzozo (Zone 213)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Poacher' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Robber' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Reaper' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Labyrinth_Leech' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Air_Elemental' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Cockatrice' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Trader' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mushussu' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Miner' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Bouncer' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Hunter' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Enchanter' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Flying_Manta' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tainted_Flesh' AND zoneid = 213;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Wyvern' AND zoneid = 213;

-- ------------------------------------------------------------
-- Mamook (Zone 65)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Hunting_Raptor' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Colibri' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Carriage_Lizard' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ziz' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Puk_M' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mamool_Ja_Diver' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Poroggo' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Air_Elemental' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Battle_Bugard' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Brei' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qiqirn_Poulterer' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qiqirn_Goldsmith' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spinner' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mamool_Ja_Mimer' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Watch_Wyvern' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sea_Puk' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nipper' AND zoneid = 65;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Suhur_Mas' AND zoneid = 65;

-- ------------------------------------------------------------
-- Misareaux Coast (Zone 25)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Seaboard_Vulture' AND zoneid = 25;

-- ------------------------------------------------------------
-- Monastic_Cavern (Zone 150)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Bowshooter' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Footsoldier' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Gladiator' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Trooper' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Veteran' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Predator' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Zerker' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Warchief' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Farkiller' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Dreadnought' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Champion' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Dragoon' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 900 WHERE name = 'Orcish_Warlord' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Protector' AND zoneid = 150;
UPDATE `mob_groups` SET `respawntime` = 900 WHERE name = 'Orcish_Hexspinner' AND zoneid = 150;

-- ------------------------------------------------------------
-- Newton_Movalpolos (Zone 12)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Foreman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Packman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bugbear_Trashman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Fireman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Lengthman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bugbear_Watchman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Workman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Tankman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Draftsman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dire_Bat' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Yardman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Succubus_Bats' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Earth_Elemental' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Headman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nightmare_Bats' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Junkman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Aidman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Purgatory_Bat' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Topsman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bugbear_Deathsman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Marksman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Engineman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Roadman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Hangman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Swordsman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Groundman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Scalpelman' AND zoneid = 12;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Earth_Elemental' AND zoneid = 12;

-- ------------------------------------------------------------
-- Oldton_Movalpolos (Zone 11)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Bats' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Craftsman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Gutterman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Pickman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Leadman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Witchman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Hammerman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Ragman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Chapman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bugbear_Servingman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Earth_Elemental' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Stirge' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ancient_Bomb' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Rodman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bugbear_Bondman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Tollman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Gasman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Coalman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Repairman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Doorman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Oilman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Pikeman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Shovelman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Freelance' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Ashman' AND zoneid = 11;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Moblin_Gurneyman' AND zoneid = 11;

-- ------------------------------------------------------------
-- Ordelles_Caves (Zone 193)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Stink_Bats' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Snipper' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Blood_Bunny' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Tinkerer' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Butcher' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Ambusher' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Hognosed_Bat' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Stalking_Sapling' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fly_Agaric' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Mugger' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Leecher' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Gambler' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dung_Beetle' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Jelly' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Shrieker' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Will-o-the-Wisp' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Clipper' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goliath_Beetle' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Seeker_Bats' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ancient_Bat' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Pathfinder' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Furrier' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Smithy' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Shaman' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Air_Elemental' AND zoneid = 193;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 193;

-- ------------------------------------------------------------
-- Outer_Horutoto_Ruins (Zone 194)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Ambusher' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Tinkerer' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Butcher' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Stink_Bats' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Rotten_Jam' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Black_Slime' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ghoul_war' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Combat' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Two_of_Cups' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Two_of_Batons' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Two_of_Swords' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Two_of_Coins' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Three_of_Cups' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Three_of_Batons' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Three_of_Swords' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Three_of_Coins' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Four_of_Cups' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Four_of_Batons' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Four_of_Swords' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Four_of_Coins' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Five_of_Cups' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Five_of_Batons' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Five_of_Swords' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Five_of_Coins' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Six_of_Cups' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Six_of_Batons' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Six_of_Swords' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Six_of_Coins' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Eight_of_Cups' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Eight_of_Batons' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Eight_of_Swords' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Eight_of_Coins' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dancing_Weapon' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Seven_of_Cups' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Seven_of_Batons' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Seven_of_Swords' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Seven_of_Coins' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nine_of_Batons' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nine_of_Cups' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nine_of_Swords' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nine_of_Coins' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ten_of_Cups' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ten_of_Batons' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ten_of_Swords' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ten_of_Coins' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Balloon' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Battue_Bats' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Thug' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Weaver' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Blade_Bat' AND zoneid = 194;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ghoul_blm' AND zoneid = 194;

-- ------------------------------------------------------------
-- Palborough_Mines (Zone 143)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 18000 WHERE name = 'NoMho_Crimsonarmor' AND zoneid = 143;

-- ------------------------------------------------------------
-- Phomiuna_Aqueducts (Zone 27)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Big_Jaw_noaggro' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gloop' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Addled_Tumor' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Taurus' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Vampire_Bat' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Diremite' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Canal_Bats' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Hell_Bat' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Stegotaur' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Beastmaster' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Makara' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Dragoon' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Ninja' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Oil_Spill' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Warrior' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Thief' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Summoner' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Foul_Meat' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Paladin' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Bard' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Minotaur' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Air_Elemental' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Elemental' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Monk' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Samurai' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Ranger' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Dark_Knight' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Black_Mage' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Red_Mage' AND zoneid = 27;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fomor_Red_Mage' AND zoneid = 27;

-- ------------------------------------------------------------
-- PsoXja (Zone 9)
-- ------------------------------------------------------------
-- The commented out mobs are ones that interfere with players doing CoP Three Paths where they have to open the 16 doors, and faster respawns are counter productive to completing the mission. Returns them to LSB default.
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Vampire_Bat' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Maze_Lizard' AND zoneid = 9;
-- UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Blubber_Eyes' AND zoneid = 9;
-- UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Cryptonberry_Plaguer' AND zoneid = 9;
-- UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Cryptonberry_Cutter' AND zoneid = 9;
-- UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Magic_Millstone' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Camazotz' AND zoneid = 9;
-- UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Snoll' AND zoneid = 9;
-- UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Cryptonberry_Harrier' AND zoneid = 9;
-- UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Cryptonberry_Stalker' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Diremite_Stalker' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ice_Elemental' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Hunter' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Enchanter' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Jeweler' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Bouncer' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Mercenary' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Alchemist' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Bandit' AND zoneid = 9;
-- UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Maledict_Millstone' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dire_Bat' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Diremite_Assaulter' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thousand_Eyes' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Veterinarian' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Morozko' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Labyrinth_Lizard' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Snow_Lizard' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Elemental' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gargoyle' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gazer' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Diremite' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Snowball' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Avalanche' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Purgatory_Bat' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Million_Eyes' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demonic_Millstone' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Frost_Lizard' AND zoneid = 9;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Diremite_Dominator' AND zoneid = 9;

-- ------------------------------------------------------------
-- Quicksand_Caves (Zone 208)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sand_Spider' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Helm_Beetle' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Antican_Hastatus' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Antican_Princeps' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Antican_Signifer' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sand_Eater' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sand_Lizard' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Antican_Triarius' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Antican_Antesignanus' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Antican_Quaestor' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Antican_Aedilis' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Girtab' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sand_Digger' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spelunking_Sabotender' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sand_Tarantula' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 900 WHERE name = 'Antican_Praetor' AND zoneid = 208;
UPDATE `mob_groups` SET `respawntime` = 900 WHERE name = 'Antican_Legatus' AND zoneid = 208;

-- ------------------------------------------------------------
-- Qulun_Dome (Zone 148)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ancient_Quadav' AND zoneid = 148;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Darksteel_Quadav' AND zoneid = 148;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Platinum_Quadav' AND zoneid = 148;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sapphire_Quadav' AND zoneid = 148;
UPDATE `mob_groups` SET `respawntime` = 900 WHERE name = 'Ruby_Quadav' AND zoneid = 148;
UPDATE `mob_groups` SET `respawntime` = 900 WHERE name = 'Adaman_Quadav' AND zoneid = 148;

-- ------------------------------------------------------------
-- Ranguemont_Pass (Zone 166)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Wind_Bats' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Blade_Bat' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Oil_Slick' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Thug' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Weaver' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Mugger' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Leecher' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Gambler' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Seeker_Bats' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ooze' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Cave_Scorpion' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Stirge' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Taisai' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Giant_Scorpion' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bat_Eye' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Hecteyes' AND zoneid = 166;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Evil_Weapon' AND zoneid = 166;

-- ------------------------------------------------------------
-- Rolanberry_Fields (Zone 110) Ventures
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 180 WHERE zoneid = 110 AND name IN (
    'Death_Wasp', 'Clipper', 'Poison_Leech', 'Berry_Grub', 'Thread_Leech'
);

-- ------------------------------------------------------------
-- Rolanberry_Fields_[S] (Zone 91)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Berry_Grub' AND zoneid = 91;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Champion_Crawler' AND zoneid = 91;    -- Ventures
UPDATE `mob_groups` SET `respawntime` = 200 WHERE name = 'Clipper' AND zoneid = 91;             -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Coppercap' AND zoneid = 91;           -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Death_Jacket' AND zoneid = 91;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Dragonfly' AND zoneid = 91;           -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Goobbue_Farmer' AND zoneid = 91;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Hawker' AND zoneid = 91;              -- Ventures
UPDATE `mob_groups` SET `respawntime` = 220 WHERE name = 'Poison_Leech' AND zoneid = 91;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Scabrous_Slug' AND zoneid = 91;       -- Ventures

-- ------------------------------------------------------------
-- Sacrarium (Zone 28)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Gazer' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Greater_Gaylas' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Stegotaur' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Mummy' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Lich' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Blubber_Eyes' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Utukku' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Ranger' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Ninja' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Bard' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Dragoon' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Black_Mage' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Beastmaster' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Monk' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Red_Mage' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Samurai' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Dark_Knight' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Summoner' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Warrior' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Thief' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Fomor_Paladin' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Teratotaur' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Keremet' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Air_Elemental' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Thunder_Elemental' AND zoneid = 28;
UPDATE `mob_groups` SET `respawntime` = 600 WHERE name = 'Dark_Elemental' AND zoneid = 28;

-- ------------------------------------------------------------
-- Sea_Serpent_Grotto (Zone 176)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Royal_Leech' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Undead_Bats' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spring_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Pond_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lake_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Ironshell' AND zoneid = 176;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ghast_blm' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ooze' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Brook_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Rivulet_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Vampire_Bat' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Riparian_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Grotto_Pugil' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sea_Bonze' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Marsh_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Sahagin_Parasite' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Swamp_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bog_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Blubber_Eyes' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Razorjaw_Pugil' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mousse' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Shore_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Coastal_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Delta_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lagoon_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Robber_Crab' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dire_Bat' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mindgazer' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Greatclaw' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nightmare_Bats' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 900 WHERE name = 'Abyss_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 900 WHERE name = 'Coral_Sahagin' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ghast_war' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bigclaw' AND zoneid = 176;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Rock_Crab' AND zoneid = 176;

-- ------------------------------------------------------------
-- Sauromugue_Champaign (Zone 120)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 180 WHERE name = 'Hill_Lizard' AND zoneid = 120;         -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Moon_Bat' AND zoneid = 120;            -- Ventures
UPDATE `mob_groups` SET `respawntime` = 180 WHERE name = 'Diving_Beetle' AND zoneid = 120;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Goblin_Gambler' AND zoneid = 120;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Goblin_Leecher' AND zoneid = 120;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Goblin_Mugger' AND zoneid = 120;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Yagudo_Priest' AND zoneid = 120;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Yagudo_Theologist' AND zoneid = 120;   -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Yagudo_Votary' AND zoneid = 120;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Sauromugue_Skink' AND zoneid = 120;    -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Champaign_Coeurl' AND zoneid = 120;    -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Goblin_Furrier' AND zoneid = 120;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Goblin_Pathfinder' AND zoneid = 120;   -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Goblin_Shaman' AND zoneid = 120;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Goblin_Smithy' AND zoneid = 120;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Yagudo_Drummer' AND zoneid = 120;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Yagudo_Herald' AND zoneid = 120;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Yagudo_Interrogator' AND zoneid = 120; -- Ventures
UPDATE `mob_groups` SET `respawntime` = 200 WHERE name = 'Tabar_Beak' AND zoneid = 120;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 200 WHERE name = 'Evil_Weapon' AND zoneid = 120;         -- Ventures

-- ------------------------------------------------------------
-- Sauromugue_Champaign_[S] (Zone 98)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Gouger_Beetle' AND zoneid = 98;     -- Ventures
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Sauromugue_Skink' AND zoneid = 98;  -- Ventures
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Tabar_Beak' AND zoneid = 98;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Diving_Beetle' AND zoneid = 98;     -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Hill_Lizard' AND zoneid = 98;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Lynx' AND zoneid = 98;              -- Ventures

-- ------------------------------------------------------------
-- Temple_of_Uggalepih (Zone 159)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Wespe' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Temple_Opo' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Stalker' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Cutter' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Harrier' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Rumble_Crawler' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Branding_Iron' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Torama' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 900 WHERE name = 'Manipulator' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Maledictor' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Pursuer' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Stabber' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tonberry_Dismayer' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Hover_Tank' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fire_Elemental' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Iron_Maiden' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Temple_Bee' AND zoneid = 159;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 159;

-- ------------------------------------------------------------
-- The_Boyahda_Tree (Zone 153)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 21600 WHERE name = 'Ancient_Goobbue' AND zoneid = 153;
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Bark_Spider' AND zoneid = 153;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Death_Cap' AND zoneid = 153;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Mourioche' AND zoneid = 153;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Moss_Eater' AND zoneid = 153;         -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Knight_Crawler' AND zoneid = 153;     -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Old_Goobbue' AND zoneid = 153;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Robber_Crab' AND zoneid = 153;        -- Ventures
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 153;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 153;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Morbol_Menace' AND zoneid = 153;
UPDATE `mob_groups` SET `respawntime` = 300 WHERE name = 'Elder_Goobbue' AND zoneid = 153;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Korrigan' AND zoneid = 153;           -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Skimmer' AND zoneid = 153;            -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Steelshell' AND zoneid = 153;         -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Processionaire' AND zoneid = 153;     -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Darter' AND zoneid = 153;             -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Blood_Ball' AND zoneid = 153;         -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Boyahda_Sapling' AND zoneid = 153;    -- Ventures
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Bark_Tarantula' AND zoneid = 153;     -- Ventures
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Demonic_Rose' AND zoneid = 153;
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Mourning_Crawler' AND zoneid = 153;
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Snaggletooth_Peapuk' AND zoneid = 153;
UPDATE `mob_groups` SET `respawntime` = 270 WHERE name = 'Viseclaw' AND zoneid = 153;

-- ------------------------------------------------------------
-- The_Eldieme_Necropolis (Zone 195)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Marchosias' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lost_Soul_blm' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Shade_war' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Shade_rng' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Shade_thf' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Shade_drk' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Revenant' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Hell_Hound' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Anemone' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gazer' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Puroboros' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mummy' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lich' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Blood_Soul' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ka_war' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ka_blm' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ka_rng' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ka_thf' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tomb_Wolf' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Utukku' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Nekros_Hound' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Stalker_war' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Stalker_blm' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Stalker_thf' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Stalker_rng' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Azer' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fallen_Knight' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ice_Elemental' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Earth_Elemental' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Haunt' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tomb_Warrior' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Tomb_Mage' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spriggan_war' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spriggan_blm' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spriggan_thf' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Spriggan_rng' AND zoneid = 195;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lost_Soul_war' AND zoneid = 195;

-- ------------------------------------------------------------
-- The_Eldieme_Necropolis_[S] (Zone 175)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Hell_Hound' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ignis_Djinn' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lich' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lost_Soul_war' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Brawler' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Chasseur' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Cursemaker' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Orcish_Trooper' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Northern_Spriggan' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Eastern_Spriggan' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Western_Spriggan' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Southern_Spriggan' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Gazer' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Freesword' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Blastmaster' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Corpsman' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Goblin_Pioneer' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'War_Smilodon' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Revenant' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Earth_Elemental' AND zoneid = 175;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ice_Elemental' AND zoneid = 175;

-- ------------------------------------------------------------
-- The_Garden_of_RuHmet (Zone 35)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_blm' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_thf' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_rdm' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_sam' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_rng' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_nin' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_drg' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_mnk' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_whm' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_brd' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_bst' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_war' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_smn' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_drk' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Awaern_pld' AND zoneid = 35;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Qnzdei' AND zoneid = 35;

-- ------------------------------------------------------------
-- The_Shrine_of_RuAvitau (Zone 178)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Aura_Pot' AND zoneid = 178;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ice_Elemental' AND zoneid = 178;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fire_Elemental' AND zoneid = 178;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Aura_Statue' AND zoneid = 178;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 178;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 178;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Air_Elemental' AND zoneid = 178;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Earth_Elemental' AND zoneid = 178;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Elemental' AND zoneid = 178;

-- ------------------------------------------------------------
-- Toraimarai_Canal (Zone 169)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Canal_Bats' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Hell_Bat' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bigclaw' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fallen_Knight' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Lich' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dark_Aspic' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bloodsucker' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Girtab' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Scavenger_Crab' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fleshcraver' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mindcraver' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Rotten_Sod' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Makara' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Bouncing_Ball' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Stygian_Pugil' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 21600 WHERE name = 'Oni_Carcass' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Mousse' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Impish_Bats' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Hinge_Oil' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Dire_Bat' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Doom_Mage' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Doom_Soldier' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 21600 WHERE name = 'Brazen_Bones' AND zoneid = 169;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Starmite' AND zoneid = 169;

-- ------------------------------------------------------------
-- VeLugannon_Palace (Zone 177)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Air_Elemental' AND zoneid = 177;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Earth_Elemental' AND zoneid = 177;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Thunder_Elemental' AND zoneid = 177;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Water_Elemental' AND zoneid = 177;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Ice_Elemental' AND zoneid = 177;
UPDATE `mob_groups` SET `respawntime` = 330 WHERE name = 'Fire_Elemental' AND zoneid = 177;

-- ------------------------------------------------------------
-- Eastern_Altepa_Desert (Zone 114)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Sand_Beetle' AND zoneid = 114;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Desert_Dhalmel' AND zoneid = 114;    -- Ventures

-- ------------------------------------------------------------
-- Western_Altepa_Desert (Zone 125)
-- ------------------------------------------------------------

UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Desert_Beetle' AND zoneid = 125;     -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Goblin_Bouncer' AND zoneid = 125;    -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Goblin_Enchanter' AND zoneid = 125;  -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Goblin_Hunter' AND zoneid = 125;     -- Ventures

-- ------------------------------------------------------------
-- Western_Sarutabaruta_[S] (Zone 95)
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Tiny_Lycopodium' AND zoneid = 95;    -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Savanna_Rarab' AND zoneid = 95;      -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Bumblebee' AND zoneid = 95;          -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Crawler' AND zoneid = 95;            -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Carrion_Crow' AND zoneid = 95;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 200 WHERE name = 'River_Crab' AND zoneid = 95;         -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Savanna_Dhalmel' AND zoneid = 95;    -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Hispid_Rarab' AND zoneid = 95;       -- Ventures
UPDATE `mob_groups` SET `respawntime` = 200 WHERE name = 'Toad' AND zoneid = 95;               -- Ventures
UPDATE `mob_groups` SET `respawntime` = 240 WHERE name = 'Poroggo_Gent' AND zoneid = 95;       -- Ventures

-- ------------------------------------------------------------
-- Valkurm_Dunes (Zone 103) Ventures
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 180 WHERE zoneid = 95 AND name IN (
    'Sand_Hare', 'Hill_Lizard', 'Snipper', 'Damselfly', 'Brutal_Sheep', 'Beach_Pugil'
);

-- ------------------------------------------------------------
-- Buburimu_Peninsula (Zone 118) Ventures
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 180 WHERE zoneid = 118 AND name IN (
    'Mighty_Rarab', 'Sylvestre', 'Snipper', 'Carnivorous_Crawler', 'Zu', 'Bull_Dhalmel'
);

-- ------------------------------------------------------------
-- Meriphataud_Mountains (Zone 119) Ventures
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 180 WHERE zoneid = 119 AND name IN (
    'Wandering_Sapling', 'Jubjub', 'Crane_Fly', 'Hill_Lizard', 'Stag_Beetle', 'Raptor', 'Coeurl'
);

-- ------------------------------------------------------------
-- Pashhow_Marshlands (Zone 109) Ventures
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 180 WHERE zoneid = 109 AND name IN (
    'Bog_Bunny', 'Water_Wasp', 'Land_Pugil', 'Snipper', 'Gadfly', 'Thread_Leech', 'Carnivorous_Crawler'
);

-- ------------------------------------------------------------
-- Qufim_Island (Zone 126) Ventures
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 180 WHERE zoneid = 126 AND name IN (
    'Land_Worm', 'Clipper', 'Greater_Pugil', 'Acrophies'
);

-- ------------------------------------------------------------
-- Yuhtunga_Jungle (Zone 123) Ventures
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 180 WHERE zoneid = 123 AND name IN (
    'Yuhtunga_Mandragora', 'Ivory_Lizard', 'Death_Jacket', 'Soldier_Crawler'
);

-- ------------------------------------------------------------
-- Yhoator_Jungle (Zone 124) Ventures
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 180 WHERE zoneid = 124 AND name IN (
    'Yhoator_Mandragora', 'White_Lizard', 'Yhoator_Wasp', 'Big_Jaw', 'Master_Coeurl'
);

-- ------------------------------------------------------------
-- The_Sanctuary_of_ZiTah (Zone 121) Ventures
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 180 WHERE zoneid = 121 AND name IN (
    'Lesser_Gaylas', 'Ogrefly', 'Myxomycete'
);

-- ------------------------------------------------------------
-- Eastern_Altepa_Desert (Zone 114) Ventures
-- ------------------------------------------------------------
UPDATE `mob_groups` SET `respawntime` = 180 WHERE zoneid = 114 AND name IN (
    'Giant_Spider', 'Sand_Beetle', 'Desert_Dhalmel'
);
