-- Variables
SET @ALWAYS = 1000;  -- Always, 100%
SET @VCOMMON = 240;  -- Very common, 24%
SET @COMMON = 150;   -- Common, 15%
SET @UNCOMMON = 100; -- Uncommon, 10%
SET @RARE = 50;      -- Rare, 5%
SET @VRARE = 10;     -- Very rare, 1%
SET @SRARE = 5;      -- Super Rare, 0.5%
SET @URARE = 1;      -- Ultra rare, 0.1%

-- Bump all drop rates between 1% and 5% to 5% due to them getting floored to 1
UPDATE mob_droplist SET itemRate = @RARE WHERE itemRate < @RARE AND itemRate > @VRARE;

-- Daily Quest drops
-- Tavnazian Liver
INSERT INTO `mob_droplist` VALUES (2382,0,0,1000,5154,@UNCOMMON);       -- Tavnazian Sheep (Lufaise Meadows)
INSERT INTO `mob_droplist` VALUES (2383,0,0,1000,5154,@UNCOMMON);       -- Tavnazian Sheep (Misareaux Coast)
INSERT INTO `mob_droplist` VALUES (4100,0,0,1000,5154,@UNCOMMON);       -- Orcs (Lufaise Meadows/Misareaux Cost)
INSERT INTO `mob_droplist` VALUES (4100,2,0,1000,750,0);            -- Orcs (Lufaise Meadows/Misareaux Cost) Silver Beastcoin (Steal)
INSERT INTO `mob_droplist` VALUES (4101,0,0,1000,5154,@UNCOMMON);       -- Orcish Bowshooter (Misareaux Cost)
INSERT INTO `mob_droplist` VALUES (4101,0,0,1000,1661,@UNCOMMON);   -- Orcish Bowshooter (Misareaux Cost) Misareaux Garlic
INSERT INTO `mob_droplist` VALUES (4101,2,0,1000,750,0);            -- Orcish Bowshooter (Misareaux Cost) Silver Beastcoin (Steal)
UPDATE mob_groups SET dropId = "4100" WHERE zoneId = "24" AND groupId = "17"; -- Orcish Beastrider (Lufaise Meadows)
UPDATE mob_groups SET dropId = "4100" WHERE zoneId = "24" AND groupId = "16"; -- Orcish Brawler (Lufaise Meadows)
UPDATE mob_groups SET dropId = "4100" WHERE zoneId = "24" AND groupId = "58"; -- Orcish Footsoldier (Lufaise Meadows)
UPDATE mob_groups SET dropId = "4100" WHERE zoneId = "24" AND groupId = "18"; -- Orcish Nightraider (Lufaise Meadows)
UPDATE mob_groups SET dropId = "4100" WHERE zoneId = "24" AND groupId = "57"; -- Orcish Bowshooter (Lufaise Meadows)
UPDATE mob_groups SET dropId = "4101" WHERE zoneId = "25" AND groupId = "31"; -- Orcish Bowshooter (Misareaux Coast)
UPDATE mob_groups SET dropId = "4100" WHERE zoneId = "24" AND groupId = "59"; -- Orcish Gladiator (Lufaise Meadows)
UPDATE mob_groups SET dropId = "4100" WHERE zoneId = "24" AND groupId = "60"; -- Orcish Trooper (Lufaise Meadows)

-- Air Tank
UPDATE mob_groups SET dropid = "1325" WHERE zoneid = "4"  AND groupid = "32"; -- Hobgoblin Venerer (Bibiki Bay)

-- Mage's Ballad II (Yagudo Chanters in Castle_Oztroja_[S], and Meriphataud_Mountains_[S]
INSERT INTO mob_droplist VALUES (2697,0,0,1000,4995,50);

-- Garrison Drops
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE itemId = 1604; -- (Garrison) Mannequin Legs
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE itemId = 1605; -- (Garrison) Mannequin Feet
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE itemId IN (
    1528, -- Red Cryptex
    1529, -- Dst. Engraving
    1530, -- 7-Knot Quipu
    1531, -- Galka Fang Sack

    1532, -- Jade Cryptex
    1533, -- Silver Engraving
    1534, -- Mithra Fang Sack
    1535, -- 13-Knot Quipu

    1538, -- R. Leather Missive

    1536, -- T. Leather Missive
    1539, -- Hound Fang Sack
    1542, -- S. Leather Missive
    1537, -- B. Leather Missive

    1540, -- D. Leather Missive
    1543, -- C. Leather Missive
    1541  -- Bunny Fang Sack
);

-- Rabbit Charm
UPDATE mob_droplist SET itemRate = @COMMON WHERE itemId = 13112; -- Jaggedy-Eared Jack - Rabbit Charm (Common, 15%)

-- Wyrdstrand from lower level Champion Crawler camp in Rolanberry (S)
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 2035 AND itemId = 3550; -- Champion Crawler Wyrdstrand (Rare, 5%)

-- Coarse Boomerang
INSERT INTO `mob_droplist` VALUES (217,0,0,1000,17290,@UNCOMMON); -- Coarse Boomerang (5.0%)

-- Spicy's Retail Drop Corrections/Estimates.  When in doubt, go lower.
--------------------------------- Key ------------------------------------------
-- -- Mob Name (Zone)   Item (New Rate)     [LSB default rate at time of change]

--------------------------------- Normal Foes ------------------------------------------

-- Add Counterfeit Gil (Goblin Pathfinder)
INSERT INTO `mob_droplist` VALUES (283,0,0,1000,1708,@UNCOMMON);                                        -- Attohwa Chasm (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1126,0,0,1000,1708,@UNCOMMON);                                       -- Batallia Downs (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1127,0,0,1000,1708,@UNCOMMON);                                       -- Rolanberry Fields (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1128,0,0,1000,1708,@UNCOMMON);                                       -- Beaucedine Glacier/Yhoator Jungle (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1129,0,0,1000,1708,@UNCOMMON);                                       -- Sauromugue Champaign (Uncommon, 10%)

-- Ore Drop Rate Fixes. Some Ores have wrong drop rates in base LSB such as Iron Ore from Kuftal Digger at 80%.
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 849 AND itemId = 643;                   -- Flesh Eater (E Altepa)           Iron Ore (Very Common, 24%)             [80%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 636 AND itemId = 643;                   -- Desert Worm (W Altepa)           Iron Ore (Very Common, 24%)             [80%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 134 AND itemId = 643;                   -- Antican Retiarius                Iron Ore (Very Common, 24%)             [80%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 438 AND itemId = 643;                   -- Cave Worm (Rancor)               Iron Ore (Very Common, 24%)             [80%]
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 438 AND itemId = 737;                      -- Cave Worm (Rancor)               Gold Ore (Rare, 5%)                [ 2%] - Kuftal Delver 1%
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 439 AND itemId = 737;                      -- Cave Worm (Kuftal)               Gold Ore (Rare, 5%)                [ 3%] - Kuftal Delver 1%
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 1116 AND itemId = 737;                     -- Goblin Miner (Onzozo)            Gold Ore (Rare, 5%)                [ 3%] - Kuftal Delver 1%
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 1467 AND itemId = 641;                 -- Kuftal Digger                    Tin Ore  (Uncommon, 10%)                [61%] - Cave Worm in Kuftal 10%, Boulder Eater 15%
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 1467 AND itemId = 643;                  -- Kuftal Digger                    Iron Ore (Very Common, 24%)             [80%]
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 1467 AND itemId = 737;                     -- Kuftal Digger                    Gold Ore (Rare, 5%)                [ 2%] - Kuftal Delver 1%
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 1467 AND itemId = 738;                     -- Kuftal Digger                    Platinum Ore (Rare, 5%)            [ 2%] - Boulder Eater 1%
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 130 AND itemId = 643;                   -- Antican Praetor (Quick)          Iron Ore (Very Common, 24%)             [80%]
UPDATE mob_droplist SET itemRate = @COMMON WHERE dropId = 2496 AND itemId = 640;                   -- Tunnel Worm (Gusta [S])          Copper Ore (Common, 15%)                [17%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 2496 AND itemId = 768;                  -- Tunnel Worm (Gusta [S])          Flint Stone (Very Common, 24%)          [29%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 2114 AND itemId = 768;                  -- Rock Eater (La Theine)           Flint Stone (Very Common, 24%)          [32%]
UPDATE mob_droplist SET itemRate = @COMMON WHERE dropId = 2339 AND itemId = 640;                   -- Stone Eater (S Gusta)            Copper Ore (Common, 15%)                [19%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 2339 AND itemId = 642;                 -- Stone Eater (S Gusta)            Zinc Ore (Uncommon, 10%)                    [ 4%]
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 2339 AND itemId = 736;                     -- Stone Eater (S Gusta)            Silver Ore (Rare, 5%)              [ 3%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 2339 AND itemId = 768;                  -- Stone Eater (S Gusta)            Flint Stone (Very Common, 24%)          [26%]
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 2116 AND itemId = 736;                     -- Rock Eater (KRT)                 Silver Ore (Rare, 5%)              [ 3%]
UPDATE mob_droplist SET itemRate = @COMMON WHERE dropId = 74 AND itemId = 640;                     -- Amphisbaena (Gusgen)             Copper Ore (Common, 15%)                [19%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 74 AND itemId = 768;                    -- Amphisbaena (Gusgen)             Flint Stone (Very Common, 24%)          [26%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 2497 AND itemId = 768;                  -- Tunnel Worm (West Ron)           Flint Stone (Very Common, 24%)          [30%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 2115 AND itemId = 768;                  -- Rock Eater (Konschtat)           Flint Stone (Very Common, 24%)          [30%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 2115 AND itemId = 642;                 -- Stone Eater (S Gusta)            Zinc Ore (Uncommon, 10%)                    [ 6%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 2115 AND itemId = 768;                  -- Dirt Eater (Giddeus)             Flint Stone (Very Common, 24%)          [32%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 773 AND itemId = 644;                   -- Enkidu (VeLu Palace)             Mythril Ore (Very Common, 24%)          [43%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 773 AND itemId = 955;                  -- Enkidu (VeLu Palace)             Golem Shard (Uncommon, 10%)                 [ 7%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 2824 AND itemId = 644;                  -- Aura Statue (RuAvitau)           Mythril Ore (Very Common, 24%)          [25%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 2824 AND itemId = 955;                 -- Aura Statue (RuAvitau)           Golem Shard (Uncommon, 10%)                 [ 7%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 1956 AND itemId = 644;                  -- Ore Golem (FeiYin)               Mythril Ore (Very Common, 24%)          [31%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 505 AND itemId = 644;                   -- Colossus (FeiYin)                Mythril Ore (Very Common, 24%)          [32%]

-- Sky Pop Item Drop Rate Fixes. 2% is not a real rate. It is 1%.
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 2824 AND itemId = 2388;                    -- Aura Statue (RuAvitau)           Diorite (Rare, 5%)                 [ 2%]
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 193 AND itemId = 1195;                     -- Aura Pot (RuAvitau)              Romaeve Water (Rare, 5%)           [ 2%]

-- Correct Balloon Cloth, Skaudo Ingot, and Subligars drop rates.
-- These are a bit all over with some data clearly set from badFFXIClopedia. Using reason/best guesses/setting to our server. Two Cloth or Ingots can drop at once, skewing the rates online.
DELETE FROM mob_droplist WHERE groupId = 19 AND itemId = 1739;                                      -- Fomor SAM (Sacrarium) Doesn't Drop Balloon Cloth
UPDATE mob_groups SET dropId = "858" WHERE zoneId = "24" AND groupId = "46";                        -- Fomor RNG (Meadows) erroneously has the same drop ID as the PLD in Sacrarium. Sets to dropId of Fomor Beastmaster in same zone.

UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 886 AND itemId = 1739;                  -- Fomor THF (Aqueducts)            Balloon Cloth (Uncommon, 10%)           [30%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 887 AND itemId = 1739;                  -- Fomor THF (Sacrarium)            Balloon Cloth (Uncommon, 10%)           [46%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 886 AND itemId = 15377;                 -- Fomor THF (Aqueducts)            Gemini Subligar (Uncommon, 10%)         [34%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 887 AND itemId = 15377;                 -- Fomor THF (Aqueducts)            Gemini Subligar (Uncommon, 10%)             [13%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 873 AND itemId = 1739;                  -- Fomor RNG (Aqueducts)            Balloon Cloth (Uncommon, 10%)           [ 6%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 874 AND itemId = 1739;                  -- Fomor RNG (Sacrarium)            Balloon Cloth (Uncommon, 10%)           [66%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 873 AND itemId = 15380;                 -- Fomor RNG (Aqueducts)            Virgo Subligar (Uncommon, 10%)          [15%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 874 AND itemId = 15380;                 -- Fomor RNG (Sacrarium)            Virgo Subligar (Uncommon, 10%)              [ 4%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 878 AND itemId = 1738;                  -- Fomor SAM (Aqueducts)            Shakudo Ingot (Uncommon, 10%)           [75%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 879 AND itemId = 1738;                  -- Fomor SAM (Sacrarium)            Shakudo Ingot (Uncommon, 10%)           [75%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 878 AND itemId = 15378;                 -- Fomor SAM (Aqueducts)            Cancer Subligar (Uncommon, 10%)         [10%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 879 AND itemId = 15378;                 -- Fomor SAM (Sacrarium)            Cancer Subligar (Uncommon, 10%)             [ 8%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 870 AND itemId = 1738;                  -- Fomor NIN (Aqueducts)            Shakudo Ingot (Uncommon, 10%)           [35%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 871 AND itemId = 1738;                  -- Fomor NIN (Sacrarium)            Shakudo Ingot (Uncommon, 10%)           [59%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 870 AND itemId = 15376;                 -- Fomor NIN (Aqueducts)            Taurus Subligar (Uncommon, 10%)         [35%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 871 AND itemId = 15376;                 -- Fomor NIN (Sacrarium)            Taurus Subligar (Uncommon, 10%)             [10%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 868 AND itemId = 15385;                 -- Fomor MNK (Aqueducts)            Aquarius Subligar (Uncommon, 10%)       [10%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 869 AND itemId = 15385;                 -- Fomor MNK (Sacrarium)            Aquarius Subligar (Uncommon, 10%)           [10%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 856 AND itemId = 15381;                 -- Fomor BRD (Aqueducts)            Libra Subligar (Uncommon, 10%)          [29%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 857 AND itemId = 15381;                 -- Fomor BRD (Sacrarium)            Libra Subligar (Uncommon, 10%)              [ 4%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 861 AND itemId = 15375;                 -- Fomor BLM (Aqueducts)            Aries Subligar (Uncommon, 10%)          [23%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 862 AND itemId = 15375;                 -- Fomor BLM (Sacrarium)            Aries Subligar (Uncommon, 10%)              [ 6%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 859 AND itemId = 15388;                 -- Fomor BST (Aqueducts)            Ophiuchus Subligar (Uncommon, 10%)      [24%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 860 AND itemId = 15388;                 -- Fomor BST (Sacrarium)            Ophiuchus Subligar (Uncommon, 10%)          [ 8%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 875 AND itemId = 15382;                 -- Fomor RDM (Aqueducts)            Scorpius Subligar (Uncommon, 10%)       [19%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 876 AND itemId = 15382;                 -- Fomor RDM (Sacrarium)            Scorpius Subligar (Uncommon, 10%)           [ 9%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 863 AND itemId = 15383;                 -- Fomor DRK (Aqueducts)            Sagittarius Subligar (Uncommon, 10%)    [25%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 864 AND itemId = 15383;                 -- Fomor DRK (Sacrarium)            Sagittarius Subligar (Uncommon, 10%)        [ 8%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 881 AND itemId = 15384;                 -- Fomor SMN (Aqueducts)            Capricornus Subligar (Uncommon, 10%)    [25%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 882 AND itemId = 15384;                 -- Fomor SMN (Sacrarium)            Capricornus Subligar (Uncommon, 10%)        [ 8%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 2877 AND itemId = 15386;                -- Fomor PLD (Aqueducts)            Pisces  Subligar (Uncommon, 10%)        [19%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 872 AND itemId = 15386;                 -- Fomor PLD (Sacrarium)            Pisces  Subligar (Uncommon, 10%)            [ 8%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 865 AND itemId = 15379;                 -- Fomor DRG (Aqueducts)            Capricornus Subligar (Uncommon, 10%)    [32%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 866 AND itemId = 15379;                 -- Fomor DRG (Sacrarium)            Capricornus Subligar (Uncommon, 10%)        [ 9%]

UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE itemId = 1018;                                   -- Orcish Cursemaker (Global)       Shaman Garlic (Uncommon, 10%)          ~[16%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE itemId = 530;                                    -- Orcish Serjeant (Global)         Castle Floor Plans (Uncommon, 10%)          [ 8%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE itemId = 1686;                                   -- Orcish Footsoldier (Global)      Soiled Letter (Uncommon, 10%)               [10%]
UPDATE mob_droplist SET itemRate = @COMMON WHERE dropID = 1944 AND itemId = 554;                    -- Orcish Trooper (Davoi)           Gold Orcmask (Common, 15%)            [18%]
UPDATE mob_droplist SET itemRate = @COMMON WHERE dropID = 1945 AND itemId = 554;                    -- Orcish Trooper (Monastic Cavern) Gold Orcmask (Common, 15%)            [18%]
UPDATE mob_droplist SET itemRate = @COMMON WHERE dropID = 1946 AND itemId = 554;                    -- Orcish Trooper (Zvahl Baileys)   Gold Orcmask (Common, 15%)            [18%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 1954 AND itemId = 4860;                 -- Orcish Zerker (Davoi/Zvahl Keep) Stun (Uncommon, 10%)                        [23%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 1955 AND itemId = 4860;                 -- Orcish Zerker (Monastic)         Stun (Uncommon, 10%)                        [23%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 574 AND itemId = 912;                   -- Davoi Hornet (Davoi)             Beehive Chip (Uncommon, 10%)            [29%]
UPDATE mob_droplist SET itemRate = @COMMON WHERE dropId = 576 AND itemId = 912;                     -- Davoi Wasp (Davoi)               Beehive Chip (Common, 15%)              [47%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 576 AND itemId = 4370;                  -- Davoi Wasp (Davoi)               Honey (Uncommon, 10%)                   [21%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 1735 AND itemId = 16937;                -- Morbol (Davoi)                   Icicle Sword (Uncommon, 10%)                [10%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 1901 AND itemId = 17292;                -- Orcish Firebelcher (Davoi)       Long Boomerang (Uncommon, 10%)          [18%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 1901 AND itemId = 17256;                -- Orcish Firebelcher (Davoi)       Serpentine Gun (Uncommon, 10%)              [12%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 644 AND itemId = 1312;                  -- Devil_Manta_fished (Kuftal)      Angel Skin (Uncommon, 10%)                  [ 8%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 1705 AND itemId = 1651;                  -- Moblin Chapman (Oldton)          Moblin Thread (Very Common, 24%)        [35%]
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 1705 AND itemId = 1638;                     -- Moblin Chapman (Oldton)          Moblin Mask (Rare, 5%)             [19%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 1722 AND itemId = 1651;                  -- Moblin Witchman (Oldton)         Moblin Thread (Very Common, 24%)        [34%]
UPDATE mob_droplist SET itemRate = @RARE WHERE dropId = 1722 AND itemId = 1638;                     -- Moblin Witchman (Oldton)         Moblin Mask (Rare, 5%)             [19%]
-- dropId 42 is also the same ID for Typhoon Wyverns in Gustav 
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 42 AND itemId = 1122;                   -- Ajattara (Grauberg (S))          Wyvern Skin (Uncommon, 10%)             [27%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 42 AND itemId = 1124;                   -- Ajattara (Grauberg (S))          Wyvern Wing (Uncommon, 10%)                 [33%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 2628 AND itemId = 1122;                 -- Watch Wyvern (Mamook)            Wyvern Skin (Uncommon, 10%)             [27%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 2628 AND itemId = 1124;                 -- Watch Wyvern (Mamook)            Wyvern Wing (Uncommon, 10%)                 [33%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 1477 AND itemId = 1122;                 -- Ladon (Kuftal Tunnel)            Wyvern Skin (Uncommon, 10%)             [27%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 1477 AND itemId = 1124;                 -- Ladon (Kuftal Tunnel)            Wyvern Wing (Uncommon, 10%)                 [33%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 1477 AND itemId = 866;                  -- Ladon (Kuftal Tunnel)            Wyvern Scale (Uncommon, 10%)                [ 7%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 2679 AND itemId = 1122;                 -- Wyvern (Labyrinth of Onzozo)     Wyvern Skin (Uncommon, 10%)             [27%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 2679 AND itemId = 1124;                 -- Wyvern (Labyrinth of Onzozo)     Wyvern Wing (Uncommon, 10%)                 [33%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 2679 AND itemId = 866;                  -- Wyvern (Labyrinth of Onzozo)     Wyvern Scale (Uncommon, 10%)                [ 7%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 841 AND itemId = 1122;                  -- Flamedrake (Riverne-Site A01)    Wyvern Skin (Uncommon, 10%)             [27%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 841 AND itemId = 1124;                  -- Flamedrake (Riverne-Site A01)    Wyvern Wing (Uncommon, 10%)                 [33%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 841 AND itemId = 1691;                   -- Flamedrake (Riverne-Site A01)    Giant Scale (Very Common, 24%)          [35%]
--Blazedrake in B01 is missing the wyvern tailskin drop, but is sharing the same dropId at LSB as the Ignidrake which doesnt drop it. They will need to address that, otherwise it can't just be inserted into the pool.
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 841 AND itemId = 1122;                  -- Blazedrake (Riverne-Site B01)    Wyvern Skin (Uncommon, 10%)             [ 5%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 841 AND itemId = 1124;                  -- Blazedrake (Riverne-Site B01)    Wyvern Wing (Uncommon, 10%)                 [ 3%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 841 AND itemId = 1691;                   -- Blazedrake (Riverne-Site B01)    Giant Scale (Very Common, 24%)          [35%]


-- Global Armor Drop Rate Fixes - Any foe dropping these basic items has the rate corrected to retail accurate instead of 1~3% armor dropping constantly on foes from bad base data

-- Very lowest level armor (~level 1-10) is 0.5%~1%, going with .5% to be safe. You can see this with Giddeus XIDB drop data. 
-- Low level armor (~level 12-20) is 0.5%. You can see this with Palborough XIDB drop data on Onyx Quadav, etc.
-- Other higher armor items (~20+) from mobs are likely URARE~SRARE (.1%~.5%) going with .1% to be safe. You can see this with Davoi/Monastic/Castle Zvhal etc XIDB drop data.

UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12448;                                     -- Bronze Cap (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12704;                                     -- Bronze Mittens (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12832;                                     -- Bronze Subligar (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12960;                                     -- Bronze Leggings (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12472;                                     -- Circlet (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12728;                                     -- Cuffs (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12856;                                     -- Slops (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12984;                                     -- Ash Clogs (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12440;                                     -- Leather Bandana (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12696;                                     -- Leather Gloves (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12824;                                     -- Leather Trousers (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12952;                                     -- Leather Highboots (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12456;                                     -- Hachimaki (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12712;                                     -- Tekko (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12840;                                     -- Sitabaki (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12968;                                     -- Kyahan (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12736;                                     -- Mitts (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12864;                                     -- Slacks (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12992;                                     -- Solea (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12432;                                     -- Faceguard (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12688;                                     -- Scale Finger Gauntlets (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12816;                                     -- Scale Cuisses (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12944;                                     -- Scale Greaves (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12449;                                     -- Brass Cap (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12705;                                     -- Brass Mittens (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12833;                                     -- Brass Subligar (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12961;                                     -- Brass Leggings (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12473;                                     -- Poet's Circlet (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12729;                                     -- Linen Cuffs (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12857;                                     -- Linen Slops (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12985;                                     -- Holly Clogs (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12441;                                     -- Lizard Helm (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12697;                                     -- Lizard Gloves (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12825;                                     -- Lizard Trousers (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12953;                                     -- Lizard Ledelsens (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12424;                                     -- Lizard Ledelsens (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12457;                                     -- Cotton Hachimaki (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12713;                                     -- Cotton Tekko (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12841;                                     -- Cotton Sitabaki (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12969;                                     -- Cotton Kyahan (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12737;                                     -- White Mitts (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12865;                                     -- Black Slacks (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @VRARE WHERE itemId = 12993;                                     -- Sandals (Very Rare, 1%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12424;                                     -- Iron Mask (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12680;                                     -- Chain Mittens (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12808;                                     -- Chain Hose (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12936;                                     -- Greaves (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12433;                                     -- Brass Mask (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12689;                                     -- Brass Finger Gauntlets (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12817;                                     -- Brass Cuisses (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12945;                                     -- Brass Greaves (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12474;                                     -- Wool Hat (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12730;                                     -- Wool Cuffs (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12858;                                     -- Wool Slops (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12986;                                     -- Chestnut Sabots (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12442;                                     -- Studded Bandana (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12698;                                     -- Studded Gloves (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12826;                                     -- Studded Trousers (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12954;                                     -- Studded Boots (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12458;                                     -- Soil Hachimaki (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12714;                                     -- Soil Tekko (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12842;                                     -- Soil Sitabaki (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12970;                                     -- Soil Kyahan (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12443;                                     -- Cuir Bandana (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12699;                                     -- Cuir Gloves (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12827;                                     -- Cuir Trousers (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12955;                                     -- Cuir Highboots (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12425;                                     -- Silver Mask (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12681;                                     -- Silver Mittens (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12809;                                     -- Silver Hose (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12937;                                     -- Silver Greaves (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12450;                                     -- Padded Cap (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12706;                                     -- Iron Mittens (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12836;                                     -- Iron Subligar (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12962;                                     -- Leggings (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12416;                                     -- Sallet (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12672;                                     -- Gauntlets (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12800;                                     -- Cuisses (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12928;                                     -- Plate Leggings (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12417;                                     -- Mythril Sallet (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12673;                                     -- Mythril Gauntlets (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12801;                                     -- Mythril Cuisses (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12929;                                     -- Mythril Leggings (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12611;                                     -- White Cloak (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12739;                                     -- Black Mitts (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12867;                                     -- White Slacks (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12995;                                     -- Moccasins (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12475;                                     -- Velvet Hat (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12731;                                     -- Velvet Cuffs (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12859;                                     -- Velvet Slops (Super Rare, .5%)
UPDATE mob_droplist SET itemRate = @SRARE WHERE itemId = 12987;                                     -- Ebony Sabots (Super Rare, .5%)

-- Deleted items from droplists, these should not drop at all, but do.
-- Orcish Trooper in Davoi don't drop these.
DELETE FROM mob_droplist WHERE dropID = 1944 AND itemId = 12553;                                    -- Silver Mail
DELETE FROM mob_droplist WHERE dropID = 1944 AND itemId = 12424;                                    -- Iron Mask
DELETE FROM mob_droplist WHERE dropID = 1944 AND itemId = 12680;                                    -- Chain Mittens
-- Moblin Coalman/Gasman in Olton Movalpolos don't drop Moblin Thread.
DELETE FROM mob_droplist WHERE dropID = 1706 AND itemId = 1651;                                     -- Moblin Thread from Coalman
DELETE FROM mob_droplist WHERE dropID = 1709 AND itemId = 1651;                                     -- Moblin Thread from Gasman


-- Full corrected pools. For when there are many items to update at once.
-- Deleted pool from mob_droplist.sql and inserts the new one.

-- Sea corrections. FFXIDB has a large sample data list on these foes. So these are all at or close to retail accurate
-- Sole exception: Sea Xzomit Babies are a bit estimated. However, very little change from base LSB on that one.
-- Sea mobs have some major drop issues. Most pronounced is the crystal cluster spam drops. Otherwise, organs are all higher than they should be in most cases.

-- ZoneID:  35 - Awaern Mnk  (Don't know why this solely is it's own droplist, it isn't different)
DELETE FROM `mob_droplist` WHERE dropid =  "198";
INSERT INTO `mob_droplist` VALUES (198,0,0,1000,1786,@UNCOMMON); -- Aern Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (198,0,0,1000,1783,@UNCOMMON); -- Sample Of Luminian Tissue (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (198,1,1,@VRARE,4104,125);     -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (198,1,1,@VRARE,4105,125);     -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (198,1,1,@VRARE,4106,125);     -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (198,1,1,@VRARE,4107,125);     -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (198,1,1,@VRARE,4108,125);     -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (198,1,1,@VRARE,4109,125);     -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (198,1,1,@VRARE,4110,125);     -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (198,1,1,@VRARE,4111,125);     -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (198,4,0,1000,1783,0);         -- Sample Of Luminian Tissue (Despoil)
INSERT INTO `mob_droplist` VALUES (198,4,0,1000,1786,0);         -- Aern Organ (Despoil)

-- ZoneID:  33 - Aweuvhi
-- ZoneID:  35 - Aweuvhi
DELETE FROM `mob_droplist` WHERE dropid =  "199";
INSERT INTO `mob_droplist` VALUES (199,0,0,1000,1818,@UNCOMMON);  -- Euvhi Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (199,0,0,1000,1899,@UNCOMMON);  -- High-Quality Euvhi Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (199,0,0,1000,1783,@UNCOMMON);  -- Sample Of Luminian Tissue (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (199,1,1,@VRARE,4104,125);      -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (199,1,1,@VRARE,4105,125);      -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (199,1,1,@VRARE,4106,125);      -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (199,1,1,@VRARE,4107,125);      -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (199,1,1,@VRARE,4108,125);      -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (199,1,1,@VRARE,4109,125);      -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (199,1,1,@VRARE,4110,125);      -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (199,1,1,@VRARE,4111,125);      -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (199,4,0,1000,1783,0);          -- Sample Of Luminian Tissue (Despoil)

-- ZoneID:  35 - Awghrah
DELETE FROM `mob_droplist` WHERE dropid =  "200";
INSERT INTO `mob_droplist` VALUES (200,0,0,1000,1819,@VCOMMON);     -- Luminion Chip (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (200,0,0,1000,1872,@UNCOMMON);    -- Ghrah M Chip (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (200,1,1,@VRARE,4104,125);        -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (200,1,1,@VRARE,4105,125);        -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (200,1,1,@VRARE,4106,125);        -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (200,1,1,@VRARE,4107,125);        -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (200,1,1,@VRARE,4108,125);        -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (200,1,1,@VRARE,4109,125);        -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (200,1,1,@VRARE,4110,125);        -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (200,1,1,@VRARE,4111,125);        -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (200,4,0,1000,1819,0);            -- Luminion Chip (Despoil)

-- ZoneID:  34 - Eoaern War-- ZoneID:  34 - Eoaern Mnk-- ZoneID:  34 - Eoaern Blm-- ZoneID:  34 - Eoaern Smn-- ZoneID:  34 - Eoaern Thf-- ZoneID:  34 - Eoaern Pld-- ZoneID:  34 - Eoaern Rng-- ZoneID:  34 - Eoaern Nin-- ZoneID:  34 - Eoaern Drg-- ZoneID:  34 - Eoaern Whm-- ZoneID:  34 - Eoaern Bst-- ZoneID:  34 - Eoaern Brd-- ZoneID:  34 - Eoaern Sam-- ZoneID:  34 - Eoaern Drk-- ZoneID:  34 - Eoaern Rdm
-- ZoneID:  35 - Awaern Blm-- ZoneID:  35 - Awaern Thf-- ZoneID:  35 - Awaern Rdm-- ZoneID:  35 - Awaern Sam-- ZoneID:  35 - Awaern Rng-- ZoneID:  35 - Awaern Nin-- ZoneID:  35 - Awaern Drg-- ZoneID:  35 - Awaern Whm-- ZoneID:  35 - Awaern Brd-- ZoneID:  35 - Awaern Bst-- ZoneID:  35 - Awaern War-- ZoneID:  35 - Awaern Smn-- ZoneID:  35 - Awaern Drk-- ZoneID:  35 - Awaern Pld
DELETE FROM `mob_droplist` WHERE dropid =  "775";
INSERT INTO `mob_droplist` VALUES (775,0,0,1000,1786,@UNCOMMON);    -- Aern Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (775,0,0,1000,1900,@UNCOMMON);    -- High-Quality Aern Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (775,0,0,1000,1783,@UNCOMMON);    -- Sample Of Luminian Tissue (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (775,1,1,@VRARE,4104,125);        -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (775,1,1,@VRARE,4105,125);        -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (775,1,1,@VRARE,4106,125);        -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (775,1,1,@VRARE,4107,125);        -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (775,1,1,@VRARE,4108,125);        -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (775,1,1,@VRARE,4109,125);        -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (775,1,1,@VRARE,4110,125);        -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (775,1,1,@VRARE,4111,125);        -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (775,4,0,1000,1783,0);            -- Sample Of Luminian Tissue (Despoil)
INSERT INTO `mob_droplist` VALUES (775,4,0,1000,1786,0);            -- Aern Organ (Despoil)

-- ZoneID:  34 - Eoeuvhi
DELETE FROM `mob_droplist` WHERE dropid =  "776";
INSERT INTO `mob_droplist` VALUES (776,0,0,1000,1818,@RARE);      -- Euvhi Organ (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (776,0,0,1000,1783,@UNCOMMON);  -- Sample Of Luminian Tissue (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (776,1,1,@VRARE,4104,125);      -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (776,1,1,@VRARE,4105,125);      -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (776,1,1,@VRARE,4106,125);      -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (776,1,1,@VRARE,4107,125);      -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (776,1,1,@VRARE,4108,125);      -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (776,1,1,@VRARE,4109,125);      -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (776,1,1,@VRARE,4110,125);      -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (776,1,1,@VRARE,4111,125);      -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (776,4,0,1000,1783,0);          -- Sample Of Luminian Tissue (Despoil)

-- ZoneID:  34 - Eoghrah
DELETE FROM `mob_droplist` WHERE dropid =  "777";
INSERT INTO `mob_droplist` VALUES (777,0,0,1000,1819,@VCOMMON);     -- Luminion Chip (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (777,0,0,1000,1872,@UNCOMMON);    -- Ghrah M Chip (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (777,1,1,@VRARE,4104,125);        -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (777,1,1,@VRARE,4105,125);        -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (777,1,1,@VRARE,4106,125);        -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (777,1,1,@VRARE,4107,125);        -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (777,1,1,@VRARE,4108,125);        -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (777,1,1,@VRARE,4109,125);        -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (777,1,1,@VRARE,4110,125);        -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (777,1,1,@VRARE,4111,125);        -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (777,4,0,1000,1783,0);            -- Sample Of Luminian Tissue (Despoil)
INSERT INTO `mob_droplist` VALUES (777,4,0,1000,1819,0);            -- Luminion Chip (Despoil)

-- ZoneID:  34 - Eozdei
UPDATE mob_groups SET dropId = "778" WHERE zoneId = "35" AND name = "Awzdei"; -- Aw'zdei (The Garden of Ru'hmet) Has no drop list in LSB for some reason
DELETE FROM `mob_droplist` WHERE dropid =  "778";
INSERT INTO `mob_droplist` VALUES (778,0,0,1000,1819,@UNCOMMON); -- Luminion Chip (Uncommon, 10%)

-- ZoneID:  33 - Omaern Whm-- ZoneID:  33 - Omaern Bst-- ZoneID:  33 - Omaern Drg-- ZoneID:  33 - Omaern Smn-- ZoneID:  33 - Omaern Nin-- ZoneID:  33 - Omaern Pld-- ZoneID:  33 - Omaern Drk-- ZoneID:  33 - Omaern Brd-- ZoneID:  33 - Omaern Sam-- ZoneID:  33 - Omaern Mnk-- ZoneID:  33 - Omaern Blm-- ZoneID:  33 - Omaern War-- ZoneID:  33 - Omaern Rng-- ZoneID:  33 - Omaern Rdm-- ZoneID:  33 - Omaern Thf
DELETE FROM `mob_droplist` WHERE dropid =  "1853";
INSERT INTO `mob_droplist` VALUES (1853,0,0,1000,1786,@UNCOMMON); -- Aern Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1853,0,0,1000,1783,@UNCOMMON); -- Sample Of Luminian Tissue (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1853,1,1,@VRARE,4104,125);     -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1853,1,1,@VRARE,4105,125);     -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1853,1,1,@VRARE,4106,125);     -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1853,1,1,@VRARE,4107,125);     -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1853,1,1,@VRARE,4108,125);     -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1853,1,1,@VRARE,4109,125);     -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1853,1,1,@VRARE,4110,125);     -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1853,1,1,@VRARE,4111,125);     -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1853,4,0,1000,1783,0);         -- Sample Of Luminian Tissue (Despoil)

-- ZoneID:  33 - Omhpemde
-- ZoneID:  33 - Omhpemde Nodive
DELETE FROM `mob_droplist` WHERE dropid =  "1854";
INSERT INTO `mob_droplist` VALUES (1854,0,0,1000,1871,@UNCOMMON);  -- High-Quality Hpemde Organ (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1854,0,0,1000,1787,@UNCOMMON);  -- Hpemde Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1854,0,0,1000,1783,@RARE);      -- Sample Of Luminian Tissue (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1854,1,1,@RARE,4104,125);       -- Fire Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1854,1,1,@RARE,4105,125);       -- Ice Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1854,1,1,@RARE,4106,125);       -- Wind Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1854,1,1,@RARE,4107,125);       -- Earth Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1854,1,1,@RARE,4108,125);       -- Lightning Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1854,1,1,@RARE,4109,125);       -- Water Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1854,1,1,@RARE,4110,125);       -- Light Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1854,1,1,@RARE,4111,125);       -- Dark Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1854,4,0,1000,1783,0);          -- Sample Of Luminian Tissue (Despoil)

-- ZoneID:  33 - Omphuabo
DELETE FROM `mob_droplist` WHERE dropid =  "1855";
INSERT INTO `mob_droplist` VALUES (1855,0,0,1000,1784,@COMMON);    -- Phuabo Organ (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1855,0,0,1000,1784,@COMMON);    -- Phuabo Organ (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1855,0,0,1000,1783,@UNCOMMON);  -- Sample Of Luminian Tissue (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1855,0,0,1000,1852,@RARE);      -- High-Quality Phuabo Organ (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1855,4,0,1000,1783,0);          -- Sample Of Luminian Tissue (Despoil)
INSERT INTO `mob_droplist` VALUES (1855,4,0,1000,1784,0);          -- Phuabo Organ (Despoil)

-- ZoneID:  33 - Omxzomit
DELETE FROM `mob_droplist` WHERE dropid =  "1856";
INSERT INTO `mob_droplist` VALUES (1856,0,0,1000,1785,@VCOMMON);   -- Xzomit Organ (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1856,0,0,1000,1855,@UNCOMMON);  -- High-Quality Xzomit Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1856,0,0,1000,1783,@UNCOMMON);  -- Sample Of Luminian Tissue (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1856,1,1,@VRARE,4104,125);      -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1856,1,1,@VRARE,4105,125);      -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1856,1,1,@VRARE,4106,125);      -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1856,1,1,@VRARE,4107,125);      -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1856,1,1,@VRARE,4108,125);      -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1856,1,1,@VRARE,4109,125);      -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1856,1,1,@VRARE,4110,125);      -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1856,1,1,@VRARE,4111,125);      -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (1856,4,0,1000,1783,0);          -- Sample Of Luminian Tissue (Despoil)

-- ZoneID:  33 - Omyovra
DELETE FROM `mob_droplist` WHERE dropid =  "1857";
INSERT INTO `mob_droplist` VALUES (1857,0,0,1000,1788,@ALWAYS);    -- Yovra Organ (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1857,0,0,1000,1788,@UNCOMMON);  -- Yovra Organ (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1857,0,0,1000,1783,@UNCOMMON);  -- Sample Of Luminian Tissue (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (1857,1,1,@RARE,4104,125);       -- Fire Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1857,1,1,@RARE,4105,125);       -- Ice Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1857,1,1,@RARE,4106,125);       -- Wind Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1857,1,1,@RARE,4107,125);       -- Earth Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1857,1,1,@RARE,4108,125);       -- Lightning Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1857,1,1,@RARE,4109,125);       -- Water Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1857,1,1,@RARE,4110,125);       -- Light Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (1857,1,1,@RARE,4111,125);       -- Dark Cluster (Rare, 5%)

-- ZoneID:  33 - Ulaern War-- ZoneID:  33 - Ulaern Sam-- ZoneID:  33 - Ulaern Blm-- ZoneID:  33 - Ulaern Rdm-- ZoneID:  33 - Ulaern Nin-- ZoneID:  33 - Ulaern Rng-- ZoneID:  33 - Ulaern Mnk-- ZoneID:  33 - Ulaern Bst-- ZoneID:  33 - Ulaern Drg-- ZoneID:  33 - Ulaern Thf-- ZoneID:  33 - Ulaern Drk-- ZoneID:  33 - Ulaern Smn-- ZoneID:  33 - Ulaern Whm-- ZoneID:  33 - Ulaern Brd-- ZoneID:  33 - Ulaern Pld
DELETE FROM `mob_droplist` WHERE dropid =  "2514";
INSERT INTO `mob_droplist` VALUES (2514,0,0,1000,1786,@UNCOMMON); -- Aern Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2514,0,0,1000,1783,@UNCOMMON); -- Sample Of Luminian Tissue (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2514,1,1,@VRARE,4104,125);     -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2514,1,1,@VRARE,4105,125);     -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2514,1,1,@VRARE,4106,125);     -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2514,1,1,@VRARE,4107,125);     -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2514,1,1,@VRARE,4108,125);     -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2514,1,1,@VRARE,4109,125);     -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2514,1,1,@VRARE,4110,125);     -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2514,1,1,@VRARE,4111,125);     -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2514,4,0,1000,1783,0);         -- Sample Of Luminian Tissue (Despoil)

-- ZoneID:  33 - Ulhpemde
DELETE FROM `mob_droplist` WHERE dropid =  "2515";
INSERT INTO `mob_droplist` VALUES (2515,0,0,1000,1871,@UNCOMMON);  -- High-Quality Hpemde Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2515,0,0,1000,1787,@UNCOMMON);  -- Hpemde Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2515,0,0,1000,1783,@RARE);      -- Sample Of Luminian Tissue (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2515,1,1,@RARE,4104,125);       -- Fire Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2515,1,1,@RARE,4105,125);       -- Ice Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2515,1,1,@RARE,4106,125);       -- Wind Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2515,1,1,@RARE,4107,125);       -- Earth Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2515,1,1,@RARE,4108,125);       -- Lightning Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2515,1,1,@RARE,4109,125);       -- Water Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2515,1,1,@RARE,4110,125);       -- Light Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2515,1,1,@RARE,4111,125);       -- Dark Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2515,4,0,1000,1783,0);          -- Sample Of Luminian Tissue (Despoil)

-- ZoneID:  33 - Ulphuabo
DELETE FROM `mob_droplist` WHERE dropid =  "2516";
INSERT INTO `mob_droplist` VALUES (2516,0,0,1000,1784,@UNCOMMON); -- Phuabo Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2516,0,0,1000,1784,@UNCOMMON); -- Phuabo Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2516,0,0,1000,1852,@UNCOMMON); -- High-Quality Phuabo Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2516,0,0,1000,1783,@RARE);     -- Sample Of Luminian Tissue (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2516,4,0,1000,1783,0);         -- Sample Of Luminian Tissue (Despoil)

-- ZoneID:  33 - Ulxzomit (mother)
DELETE FROM `mob_droplist` WHERE dropid =  "2517";
INSERT INTO `mob_droplist` VALUES (2517,0,0,1000,1785,@ALWAYS);   -- Xzomit Organ (Always, 100%)
INSERT INTO `mob_droplist` VALUES (2517,0,0,1000,1855,@UNCOMMON); -- High-Quality Xzomit Organ (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2517,0,0,1000,1783,@UNCOMMON); -- Luminian Tissue (Uncommon, 10%)
INSERT INTO `mob_droplist` VALUES (2517,1,1,@VRARE,4104,125);     -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2517,1,1,@VRARE,4105,125);     -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2517,1,1,@VRARE,4106,125);     -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2517,1,1,@VRARE,4107,125);     -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2517,1,1,@VRARE,4108,125);     -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2517,1,1,@VRARE,4109,125);     -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2517,1,1,@VRARE,4110,125);     -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2517,1,1,@VRARE,4111,125);     -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (2517,4,0,1000,1783,0);         -- Sample Of Luminian Tissue (Despoil)

-- ZoneID:  33 - Ulyovra
DELETE FROM `mob_droplist` WHERE dropid =  "2518";
INSERT INTO `mob_droplist` VALUES (2518,0,0,1000,1788,@VCOMMON);     -- Yovra Organ (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (2518,0,0,1000,1783,@UNCOMMON);    -- Sample Of Luminian Tissue (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2518,1,1,@RARE,4104,125);         -- Fire Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2518,1,1,@RARE,4105,125);         -- Ice Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2518,1,1,@RARE,4106,125);         -- Wind Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2518,1,1,@RARE,4107,125);         -- Earth Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2518,1,1,@RARE,4108,125);         -- Lightning Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2518,1,1,@RARE,4109,125);         -- Water Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2518,1,1,@RARE,4110,125);         -- Light Cluster (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (2518,1,1,@RARE,4111,125);         -- Dark Cluster (Rare, 5%)

-- ZoneID:  33 - Ulxzomit (baby)
DELETE FROM `mob_droplist` WHERE dropid =  "3231";
INSERT INTO `mob_droplist` VALUES (3231,0,0,1000,1785,@RARE);  -- Xzomit Organ (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3231,0,0,1000,1855,@RARE);  -- High-Quality Xzomit Organ (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3231,0,0,1000,1783,@RARE);  -- Luminian Tissue (Rare, 5%)
INSERT INTO `mob_droplist` VALUES (3231,1,1,@VRARE,4104,125);  -- Fire Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (3231,1,1,@VRARE,4105,125);  -- Ice Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (3231,1,1,@VRARE,4106,125);  -- Wind Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (3231,1,1,@VRARE,4107,125);  -- Earth Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (3231,1,1,@VRARE,4108,125);  -- Lightning Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (3231,1,1,@VRARE,4109,125);  -- Water Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (3231,1,1,@VRARE,4110,125);  -- Light Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (3231,1,1,@VRARE,4111,125);  -- Dark Cluster (Very rare, 1%)
INSERT INTO `mob_droplist` VALUES (3231,4,0,1000,1783,0);      -- Sample Of Luminian Tissue (Despoil)

--------------------------------- Notorious Monsters ------------------------------------------
-- Phomiuna Aqueducts - NMs were reduced to 2-3 hour respawns locally. This lowers them to the highest natural retail drop rate.Insufficient data, but they are all very likely 24% drops.
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE itemId = 14466;                                   -- Eba                              Fomor Tunic (Very Common, 24%)          [35%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE itemId = 15219;                                   -- Mahisha                          Sinister Mask (Very Common, 24%)        [47%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE itemId = 17510;                                   -- Tres Duendes                     Vampiric Claws (Very Common, 24%)       [42%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE itemId = 17794;                                   -- Tres Duendes                     Niokiyotsuna (Very Common, 24%)         [32%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE itemId = 18007;                                   -- Tres Duendes                     Chiroptera Dagger (Very Common, 24%)    [38%]

UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 2810 AND itemId = 15979;                 -- Zoraal_Jas_Pkuucha (Wajaom)      Fowling Earring (Very Common, 24%)      [35%]
UPDATE mob_droplist SET itemRate = @COMMON WHERE dropId = 2810 AND itemId = 17953;                  -- Zoraal_Jas_Pkuucha (Wajaom)      Zoraal Ja's Axe (Common, 15%)           [30%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 3084 AND itemId = 16035;                -- Goaftrap (Misareaux)             Altdorf's Earring (Uncommon, 10%)          [4.1%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 3021 AND itemId = 16036;                -- Goblintrap (Ronfaure [S])        Wilhelm's Earring (Uncommon, 10%)          [4.9%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 2841 AND itemId = 16754;                 -- Da'Dha Hundredmask (Beadeaux)    Parrying Knife (Very Common, 24%)       [84%]
UPDATE mob_droplist SET itemRate = @UNCOMMON WHERE dropId = 2841 AND itemId = 16819;                -- Da'Dha Hundredmask (Beadeaux)    Mithran Scimitar (Uncommon, 10%)        [16%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 2237 AND itemId = 14468;                 -- Shikigami Weapon (Ro'Maeve)      Yinyang Robe (Very Common, 24%)       [20.8%]
UPDATE mob_droplist SET itemRate = @VCOMMON WHERE dropId = 444 AND itemId = 14806;                  -- Centurio Xii-I (Eastern Altepa)  Intruder Earring (Very Common, 24%)     [39%]

-- ZoneID:  120 - Deadly Dodo
DELETE FROM `mob_droplist` WHERE dropid =  "578";
INSERT INTO `mob_droplist` VALUES (578,0,0,1000,4435,@VCOMMON); -- Slice Of Cockatrice Meat (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (578,0,0,1000,854,@VCOMMON);  -- Cockatrice Skin (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (578,0,0,1000,842,@VCOMMON);  -- Giant Bird Feather (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (578,0,0,1000,1014,@VCOMMON); -- Dodo Skin (Very Common, 24%)                                                                                 [21%]
INSERT INTO `mob_droplist` VALUES (578,2,0,1000,842,0);         -- Giant Bird Feather (Steal)

-- ZoneID: 111 - Nue
DELETE FROM `mob_droplist` WHERE dropid =  "1827";
INSERT INTO `mob_droplist` VALUES (1827,0,0,1000,884,@ALWAYS);   -- Black Tiger Fang (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1827,0,0,1000,861,@VCOMMON);  -- Black Tiger Hide (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1827,0,0,1000,861,@COMMON);   -- Black Tiger Hide (Common, 15%)
INSERT INTO `mob_droplist` VALUES (1827,0,0,1000,1012,@VCOMMON); -- Nue Fang (Very Common, 24%)                                                                                 [19%]
INSERT INTO `mob_droplist` VALUES (1827,2,0,1000,4400,0);        -- Slice Of Land Crab Meat (Steal)

-- ZoneID: 111 - Kirata
DELETE FROM `mob_droplist` WHERE dropid =  "1453";
INSERT INTO `mob_droplist` VALUES (1453,0,0,1000,884,@VCOMMON);   -- Black Tiger Fang (Very Common, 24%)
INSERT INTO `mob_droplist` VALUES (1453,0,0,1000,18359,@VCOMMON); -- Boreas Cesti (Very Common, 24%)                                                                            [28%]
INSERT INTO `mob_droplist` VALUES (1453,0,0,1000,861,@VCOMMON);   -- Black Tiger Hide (Common, 15%)

-- ZoneID: "Unknown - Unknown" (Voluptuous Vivian)
DELETE FROM `mob_droplist` WHERE dropid =  "2829";
INSERT INTO `mob_droplist` VALUES (2829,0,0,1000,920,@ALWAYS);     -- Malboro Vine (Always, 100%) [69%]
INSERT INTO `mob_droplist` VALUES (2829,0,0,1000,13301,@UNCOMMON); -- Vivian Ring (Uncommon, 10%)[7.0%]
INSERT INTO `mob_droplist` VALUES (2829,0,0,1000,13574,@UNCOMMON); -- Black Ribbon (Uncommon, 10%) [5%]
INSERT INTO `mob_droplist` VALUES (2829,0,0,1000,837,@UNCOMMON);   -- Spool Of Malboro Fiber (Uncommon, 10%)[3%]

-- ZoneID: 127 - King Behemoth
-- If LSB did digging or modern scraping, a lot of these abjurations would probably be reduced dramatically from the force spawn update. Any modern KB video has very few tatters, any old one drops tons.
-- Below is more accurate to the 75 era, but the black belt item of the force pop chance is accurate.
DELETE FROM `mob_droplist` WHERE dropid =  "1450";
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,860,@ALWAYS);      -- Behemoth Hide (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,860,@VCOMMON);     -- Behemoth Hide (Very Common, 24%) [40.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,883,@ALWAYS);      -- Behemoth Horn (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,883,@COMMON);      -- Behemoth Horn (Common, 15%) [25.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,1527,@COMMON);     -- Behemoth Tongue (Common, 15%) [67.0%] - (Old 100% drop data throwing this off)
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,831,@VCOMMON);     -- Square Of Shining Cloth (Very Common, 24%) [53.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,1328,@VCOMMON);    -- Aquarian Abjuration Feet (Very Common, 24%) [27.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,1328,@COMMON);     -- Aquarian Abjuration Feet (Common, 15%) [13.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,1322,@VCOMMON);    -- Earthen Abjuration Legs (Very Common, 24%) [32.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,1322,@COMMON);     -- Earthen Abjuration Legs (Common, 15%) [16.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,1332,@VCOMMON);    -- Martial Abjuration Legs (Very Common, 24%) [29.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,1332,@COMMON);     -- Martial Abjuration Legs (Common, 15%) [14.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,1334,@VCOMMON);    -- Wyrmal Abjuration Head (Very Common, 24%) [38.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,1334,@COMMON);     -- Wyrmal Abjuration Head (Common, 15%) [19.0%]
INSERT INTO `mob_droplist` VALUES (1450,0,0,1000,6416,@UNCOMMON);   -- King Behemoth - Behemoth Meat
INSERT INTO `mob_droplist` VALUES (1450,1,1,1000,13415,950);        -- Pixie Earring (Group 1 - 95.0%)
INSERT INTO `mob_droplist` VALUES (1450,1,1,1000,13566,@RARE);      -- Defending Ring (Group 1 - Rare, 5%)

-- ZoneID: 154 - Nidhogg
-- See King Behemoth Note
DELETE FROM `mob_droplist` WHERE dropid =  "1781";
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1133,@ALWAYS);  -- Vial Of Dragon Blood (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1133,@VCOMMON); -- Vial Of Dragon Blood (Very Common 24%) [50.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,4486,@ALWAYS);  -- Dragon Heart (Always, 100%)
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,4272,@COMMON);  -- Slice Of Dragon Meat (Common, 15%) [13.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1526,@COMMON);  -- Wyrm Beard (Common, 15%) [35.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,865,@VCOMMON);  -- Handful Of Nidhoggs Scales (Very Common, 24%) [70.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,865,@VCOMMON);  -- Handful Of Nidhoggs Scales (Very Common, 24%) [35.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,865,@COMMON);   -- Handful Of Nidhoggs Scales (Common, 15%) [17.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1325,@VCOMMON); -- Aquarian Abjuration Body (Very Common, 24%) [27.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1325,@COMMON);  -- Aquarian Abjuration Body (Common, 15%) [13.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1320,@VCOMMON); -- Earthen Abjuration Body (Very Common, 24%) [27.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1320,@COMMON);  -- Earthen Abjuration Body (Common, 15%) [13.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1330,@VCOMMON); -- Martial Abjuration Body (Very Common, 24%) [37.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1330,@COMMON);  -- Martial Abjuration Body (Common, 15%) [18.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1342,@VCOMMON); -- Neptunal Abjuration Legs (Very Common, 24%) [26.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,1342,@COMMON);  -- Neptunal Abjuration Legs (Common, 15%) [13.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,867,@UNCOMMON); -- Handful Of Dragon Scales (Uncommon, 10%)[6.0%]
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,903,@RARE);     -- Dragon Talon (Rare, 5%) [2.0%]
-- Custom Until We Have Salvage. Avoids load order conflict with custom_lootz.sql
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,14962,150); -- Nidhogg - enyos_gauntlets
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,14966,150); -- Nidhogg - njords_gloves
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,14970,150); -- Nidhogg - hoshikazu_tekko
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,14974,150); -- Nidhogg - anus_gages
INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,14978,150); -- Nidhogg - nemains_cuffs

-- ZoneID: 128 - Aspidochelone
-- See King Behemoth Note
DELETE FROM `mob_droplist` WHERE dropid =  "183";
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,646,@ALWAYS);     -- Chunk Of Adaman Ore (Always, 100%) [89.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,646,@VCOMMON);    -- Chunk Of Adaman Ore (Very Common, 24%) [45.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,646,@VCOMMON);    -- Chunk Of Adaman Ore (Very Common, 24%) [30.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,646,@VCOMMON);    -- Chunk Of Adaman Ore (Very Common, 24%) [22.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,908,@VCOMMON);    -- Adamantoise Shell (Very Common, 24%) [37.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,1525,@COMMON);    -- Adamantoise Egg (Common, 15%) [25.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,1325,@VCOMMON);   -- Aquarian Abjuration Body (Very Common, 24%) [35.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,1325,@COMMON);    -- Aquarian Abjuration Body (Common, 15%) [18.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,1318,@VCOMMON);   -- Dryadic Abjuration Feet (Very Common, 24%) [34.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,1318,@COMMON);    -- Dryadic Abjuration Feet (Common, 15%) [17.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,1333,@VCOMMON);   -- Martial Abjuration Feet (Very Common, 24%) [27.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,1333,@COMMON);    -- Martial Abjuration Feet (Common, 15%) [14.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,1335,@VCOMMON);   -- Wyrmal Abjuration Body (Very Common, 24%) [26.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,1335,@COMMON);    -- Wyrmal Abjuration Body (Common, 15%) [13.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,12361,@COMMON);   -- Sipar (Common, 15%) [16.0%]
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,13794,@UNCOMMON); -- Heavy Cuirass (Uncommon, 10%) [7.0%]
-- Custom Until We Have Salvage. Avoids load order conflict with custom_lootz.sql
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,14963,150);  -- Aspidochelone - phoboss_gauntlets
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,14967,150);  -- Aspidochelone - freyrs_gloves
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,14971,150);  -- Aspidochelone - tsukikazu_gote
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,14975,150);  -- Aspidochelone - eas_dastanas
INSERT INTO `mob_droplist` VALUES (183,0,0,1000,14979,150);  -- Aspidochelone - bodbs_cuffs

-- Adamantoise
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE dropId = 21 AND itemId = 908; -- Adamantoise Shell (Uncommon, 10%) [9.0%]

-- Fafnir
UPDATE `mob_droplist` SET itemRate = @RARE WHERE dropId = 805 AND itemId = 16555; -- Ridll (5%)

-- Seiryu
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE dropId = 2196 AND itemId = 1312;  -- Angel Skin (Uncommon, 10%)

-- Stroper Chyme (Also restores pre-RMT drop 'Shikaree ring')
UPDATE `mob_droplist` SET itemId = 13514, itemRate = @UNCOMMON WHERE dropid = 2349 AND itemId = 15551; -- Archers Ring (Uncommon, 10%)

-- Lockheart drop rate increase for Oboro weapon
UPDATE `mob_droplist` SET itemRate = @VCOMMON WHERE itemId = 16944; -- Frostmane - Lockheart (Very Common, 24%)

-- Ochiudo's/Ochimusha Kote 5% -> 10%
UPDATE `mob_droplist` SET itemRate = 900       WHERE dropId = 1652 AND itemId = 16703;
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE dropId = 1652 AND (itemId = 14986 OR itemId = 13952);

-- Shinobi/Sarutobi Kyahan 5% -> 10%
UPDATE `mob_droplist` SET itemRate = 900       WHERE dropId = 2069 AND itemId = 16820;
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE dropId = 2069 AND (itemId = 15737 OR itemId = 13054);

--
-- Common Materials
--
UPDATE `mob_droplist` SET itemRate = @COMMON WHERE itemId = 677;                                                   -- Chunk of White Steel (Rare, 5%)
UPDATE `mob_droplist` SET itemRate = @COMMON WHERE itemId = 881;                                                   -- Crab shell (Common, 15%)
UPDATE `mob_droplist` SET itemRate = @COMMON WHERE itemId = 816 AND itemRate < @VCOMMON;                           -- Silk thread (Common, 15%)
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE itemId = 17187;                                               -- Eurytos Bow (Uncommon, 10%)
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE itemId = 19216;                                               -- Failnaught (Uncommon, 10%)
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE itemId = 1739 AND itemRate < @UNCOMMON AND itemRate > @VRARE; -- Balloon Cloth (1-9% to 10%)
UPDATE `mob_droplist` SET itemRate = @COMMON WHERE itemId = 927 AND itemRate < @COMMON AND itemRate > @RARE;       -- Coeurl Whisker (6-14% to 15%)
UPDATE `mob_droplist` SET itemRate = @COMMON WHERE itemId = 863 AND itemRate < @COMMON AND itemRate > @RARE;       -- Coeurl Hide    (6-14% to 15%)
UPDATE `mob_droplist` SET itemRate = @COMMON WHERE itemId = 935 AND itemRate < @COMMON AND itemRate > @RARE;       -- Ahriman Wing (6-9% to 15%)
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE itemId = 5568 AND itemRate < @COMMON AND itemRate > @RARE;    -- Apkallu Egg (8% to 10%)
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE itemId = 2166 AND itemRate < @COMMON AND itemRate > @RARE;    -- Marid Hair (8% to 10%)
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE itemId =  843 AND itemRate < @COMMON AND itemRate > @RARE;    -- Giant Bird Plume (9% to 10%)

--
-- Spells
--
UPDATE `mob_droplist` SET itemRate = @RARE WHERE itemId = 4902 AND itemRate < @RARE; -- Light spirit pact (Rare, 5%)
UPDATE `mob_droplist` SET itemRate = @RARE WHERE itemId = 4903 AND itemRate < @RARE; -- Dark spirit pact (Rare, 5%)
UPDATE `mob_droplist` SET itemRate = @RARE WHERE itemId = 4789;                      -- Blizzaga III (Rare, 5%)
UPDATE `mob_droplist` SET itemRate = @RARE WHERE itemId = 5030;                      -- Scroll of Carnage Elegy (Rare, 5%)
--
-- Subjob items
--
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE itemId = 537; -- Damselfly worm (Uncommon, 10%)
UPDATE `mob_droplist` SET itemRate = @COMMON WHERE itemId = 538;   -- Magicked skull (Common, 15%)
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE itemId = 539; -- Crab apron (Uncommon, 10%)
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE itemId = 542; -- Wild rabbit tail (Uncommon, 10%)

-- Coffer keys
UPDATE `mob_droplist` SET itemRate = @RARE WHERE itemId IN (
    1042,      -- 'davoi_coffer_key'
    1043,      -- 'beadeaux_coffer_key'
    1044,      -- 'oztroja_coffer_key'
    1045,      -- 'nest_coffer_key'
    1046,      -- 'eldieme_coffer_key'
    1047,      -- 'garlaige_coffer_key'
    1048,      -- 'zvahl_coffer_key'
    1049,      -- 'uggalepih_coffer_key'
    1050,      -- 'rancor_den_coffer_key'
    1051,      -- 'kuftal_coffer_key'
    1052,      -- 'boyahda_coffer_key'
    1053,      -- 'cauldron_coffer_key'
    1054,      -- 'quicksand_coffer_key'
    1057,      -- 'toraimarai_coffer_key'
    1058,      -- 'ruaun_coffer_key'
    1059,      -- 'grotto_coffer_key'
    1060,      -- 'velugannon_coffer_key'
    1063       -- 'newton_coffer_key'
)
AND itemRate < @RARE;

-- Chest keys
UPDATE `mob_droplist` SET itemRate = @RARE WHERE itemId IN (
    1024,  -- 'ghelsba_chest_key'
    1025,  -- 'palborough_chest_key'
    1026,  -- 'giddeus_chest_key'
    1027,  -- 'ranperre_chest_key'
    1028,  -- 'dangruf_chest_key'
    1029,  -- 'horutoto_chest_key'
    1030,  -- 'ordelle_chest_key'
    1031,  -- 'gusgen_chest_key'
    1032,  -- 'shakhrami_chest_key'
    1033,  -- 'davoi_chest_key'
    1034,  -- 'beadeaux_chest_key'
    1035,  -- 'oztroja_chest_key'
    1036,  -- 'delkfutt_chest_key'
    1037,  -- 'feiyin_chest_key'
    1038,  -- 'zvahl_chest_key'
    1039,  -- 'eldieme_chest_key'
    1040,  -- 'nest_chest_key'
    1041,  -- 'garlaige_chest_key'
    1055,  -- 'grotto_chest_key'
    1056,  -- 'onzozo_chest_key'
    1061,  -- 'sacrarium_chest_key'
    1062,  -- 'oldton_chest_key'
    1064   -- 'psoxja_chest_key'
)
AND itemRate < @RARE;

-- Nyzul Vigil Weapons
UPDATE `mob_droplist` SET itemRate = @UNCOMMON WHERE itemId IN (
    17742, -- Vorpal Sword
    17744, -- Brave Blade
    17956, -- Double Axe
    18003, -- Swordbreaker
    18034, -- Dancing Dagger
    18120, -- Radiant Lance
    18426, -- Sasuke Katana
    18443, -- Windslicer
    18589, -- Mages Staff
    18719, -- Killer Bow
    18720, -- Quicksilver
    18753, -- Burning Fists
    18851, -- Werebuster
    18944, -- Death Sickle
    18590, -- Scepter Staff
    18592, -- Elder Staff
    18754, -- Inferno Claws
    19102 -- Main Gauche
);
