-----------------------------------
-- Custom Loot Distribution
-----------------------------------
-- Updates to existing drops should go in drop_rate_corrections.sql
-- This file is intended for custom drops added to mobs that wouldn't otherwise have them.

-----------------------------------
-- Drop rates
-----------------------------------
SET @ALWAYS   = 1000; -- Always      (100%)
SET @VCOMMON  = 240;  -- Very Common ( 24%)
SET @COMMON   = 150;  -- Common      ( 15%)
SET @UNCOMMON = 100;  -- Uncommon    ( 10%)
SET @RARE     = 50;   -- Rare        (  5%)
SET @VRARE    = 10;   -- Very Rare   (  1%)
SET @SRARE    = 5;    -- Super Rare  (0.5%)
SET @URARE    = 1;    -- Ultra Rare  (0.1%)

-----------------------------------
-- Limbus
-----------------------------------
-- NW Apollyon - Kaiser Behemoth
INSERT INTO `mob_droplist` VALUES (3987,0,0,1000,1875,800);     -- ancient_beastcoin (stock rate)
INSERT INTO `mob_droplist` VALUES (3987,0,0,1000,6416,@COMMON); -- behemoth_meat
UPDATE mob_groups SET dropid = "3987" WHERE name = "Kaiser_Behemoth" and zoneid = "38"; -- change default drop ID

-- Western Temenos
-- Ancient Beastcoin (100.0%)
UPDATE mob_groups SET dropid  = 2861 WHERE name IN (
    'Enhanced_Beetle',
    'Enhanced_Lizard',
    'Enhanced_Slime',
    'Enhanced_Pugil',
    'Enhanced_Vulture'
);

-- Ancient Beastcoin (50.0%)
UPDATE mob_groups SET dropid = 2858 WHERE name IN (
    'Enhanced_Tiger',
    'Enhanced_Mandragora'
);

-----------------------------------
-- World NMs
-----------------------------------
-- Hagun
SET @HAGUN = 17829;
INSERT INTO `mob_droplist` VALUES (1961,0,0,1000, @HAGUN, @COMMON);   -- Oupire
INSERT INTO `mob_droplist` VALUES (3901,0,0,1000, @HAGUN, @UNCOMMON); -- Bahamut v1

-- Dragon Staff
INSERT INTO `mob_droplist` VALUES (179,0,0,1000,17597,300);  -- Ash Dragon (Ifrit's Cauldron)

-- Behemoth Meat
INSERT INTO `mob_droplist` VALUES (251,0,0,1000,6416,@VCOMMON); -- Behemoth

-- Dragon Scales
SET @DRAGON_SCALES = 867;
INSERT INTO `mob_droplist` VALUES (2521,0,0,1000, @DRAGON_SCALES, @VCOMMON);  -- Ungur  (Gustav Tunnel)
INSERT INTO `mob_droplist` VALUES ( 389,0,0,1000, @DRAGON_SCALES, @UNCOMMON); -- Bune   (Gustav Tunnel)
INSERT INTO `mob_droplist` VALUES (1252,0,0,1000, @DRAGON_SCALES, @VCOMMON);  -- Guivre (Kuftal Tunnel)

-- Mamook
SET @DAMASCENE_CLOTH = 836;
INSERT INTO `mob_droplist` VALUES (1337,0,0,1000, @DAMASCENE_CLOTH, @ALWAYS);   -- Hundredfaced Hapool Ja (Mamook) 72h respawn
INSERT INTO `mob_droplist` VALUES (2112,0,0,1000, @DAMASCENE_CLOTH, @UNCOMMON); -- Roc (Sauromugue Champaign)

-- Angel Skin
SET @ANGEL_SKIN = 1312;
INSERT INTO `mob_droplist` VALUES( 456,0,1,1000,@ANGEL_SKIN,@UNCOMMON); -- Charybdis      (Sea Serpent Grotto)
INSERT INTO `mob_droplist` VALUES(3999,0,1,1000,@ANGEL_SKIN,@RARE);     -- Nostokulshedra (Arrapago Reef)
UPDATE `mob_droplist` SET `itemRate` = @RARE WHERE `dropId` = 2196 AND `itemId` = 1312; -- Seiryu
UPDATE `mob_groups` SET `dropId` = 3999 WHERE `zoneId` = 54 AND `groupId` = 52 AND `name` = 'Nostokulshedra'; -- Nostokulshedra

-- Siren's Hair
SET @SIRENS_HAIR = 1313;
INSERT INTO `mob_droplist` VALUES (1825,0,0,1000,@SIRENS_HAIR,@COMMON);      -- Novv_the_Whitehearted (Sea Serpent Grotto)
INSERT INTO `mob_droplist` VALUES (1973,0,0,1000,@SIRENS_HAIR,@COMMON);      -- Pahh the Gullcaller   (Sea Serpent Grotto)
INSERT INTO `mob_droplist` VALUES (2813,0,0,1000,@SIRENS_HAIR,@RARE);        -- Zuug_the_Shoreleaper  (Sea Serpent Grotto)
INSERT INTO `mob_droplist` VALUES (1836,0,0,1000,@SIRENS_HAIR,@VCOMMON); -- Ocean_Sahagin         (Sea Serpent Grotto)

-- Water Spider Web (only accessible in retail from zones that have WEW/CW level synced)
SET @W_SPIDER_WEB = 2198;
INSERT INTO `mob_droplist` VALUES (228,0,0,1000,@W_SPIDER_WEB,@UNCOMMON); -- Add to 65+ spiders drop id (Boyahda, quicksand, Mamook)

-- HQ Zilart Kings have their drops updated in drop_rate_corrections.sql and overrides this, these are in that sql for now.
-- INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,14962,@VCOMMON); -- Nidhogg - enyos_gauntlets
-- INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,14966,@VCOMMON); -- Nidhogg - njords_gloves
-- INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,14970,@VCOMMON); -- Nidhogg - hoshikazu_tekko
-- INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,14974,@VCOMMON); -- Nidhogg - anus_gages
-- INSERT INTO `mob_droplist` VALUES (1781,0,0,1000,14978,@VCOMMON); -- Nidhogg - nemains_cuffs
-- INSERT INTO `mob_droplist` VALUES (183,0,0,1000,14963,@VCOMMON);  -- Aspidochelone - phoboss_gauntlets
-- INSERT INTO `mob_droplist` VALUES (183,0,0,1000,14967,@VCOMMON);  -- Aspidochelone - freyrs_gloves
-- INSERT INTO `mob_droplist` VALUES (183,0,0,1000,14971,@VCOMMON);  -- Aspidochelone - tsukikazu_gote
-- INSERT INTO `mob_droplist` VALUES (183,0,0,1000,14975,@VCOMMON);  -- Aspidochelone - eas_dastanas
-- INSERT INTO `mob_droplist` VALUES (183,0,0,1000,14979,@VCOMMON);  -- Aspidochelone - bodbs_cuffs

-----------------------------------
-- Wyrms
-----------------------------------
-- Tiamat
INSERT INTO `mob_droplist` VALUES (2416,0,0,1000,14547,@VCOMMON);  -- enyos_breastplate
INSERT INTO `mob_droplist` VALUES (2416,0,0,1000,14551,@VCOMMON);  -- njords_jerkin
INSERT INTO `mob_droplist` VALUES (2416,0,0,1000,14555,@VCOMMON);  -- hoshikazu_gi
INSERT INTO `mob_droplist` VALUES (2416,0,0,1000,14559,@VCOMMON);  -- anus_doublet
INSERT INTO `mob_droplist` VALUES (2416,0,0,1000,14563,@VCOMMON);  -- nemains_robe
INSERT INTO `mob_droplist` VALUES (2416,0,0,1000,11286,@UNCOMMON); -- avalon_breastplate

-- Jormungand
INSERT INTO `mob_droplist` VALUES (1410,0,0,1000,14548,@VCOMMON);  -- phoboss_cuirass
INSERT INTO `mob_droplist` VALUES (1410,0,0,1000,14552,@VCOMMON);  -- freyrs_jerkin
INSERT INTO `mob_droplist` VALUES (1410,0,0,1000,14556,@VCOMMON);  -- tsukikazu_togi
INSERT INTO `mob_droplist` VALUES (1410,0,0,1000,14560,@VCOMMON);  -- eas_doublet
INSERT INTO `mob_droplist` VALUES (1410,0,0,1000,14564,@VCOMMON);  -- bodbs_robe
INSERT INTO `mob_droplist` VALUES (1410,0,0,1000,16178,@UNCOMMON); -- avalon_shield
INSERT INTO `mob_droplist` VALUES (1410,0,0,1000,16344,@UNCOMMON); -- oily_trousers

-- Vrtra
INSERT INTO `mob_droplist` VALUES (2592,0,0,1000,14549,@VCOMMON);  -- deimoss_cuirass
INSERT INTO `mob_droplist` VALUES (2592,0,0,1000,14553,@VCOMMON);  -- freyas_jerkin
INSERT INTO `mob_droplist` VALUES (2592,0,0,1000,14557,@VCOMMON);  -- hikazu_hara-ate
INSERT INTO `mob_droplist` VALUES (2592,0,0,1000,14561,@VCOMMON);  -- enlils_gambison
INSERT INTO `mob_droplist` VALUES (2592,0,0,1000,14565,@VCOMMON);  -- machas_coat
INSERT INTO `mob_droplist` VALUES (2592,0,0,1000,11285,@UNCOMMON); -- morganas_cotehardie

-----------------------------------
-- ToAU HNM
-----------------------------------
-- Cerberus
INSERT INTO `mob_droplist` VALUES (446,0,0,1000,16085,@VCOMMON);  -- enyos_mask
INSERT INTO `mob_droplist` VALUES (446,0,0,1000,16089,@VCOMMON);  -- njords_mask
INSERT INTO `mob_droplist` VALUES (446,0,0,1000,16093,@VCOMMON);  -- hoshikazu_hachimaki
INSERT INTO `mob_droplist` VALUES (446,0,0,1000,16097,@VCOMMON);  -- anus_tiara
INSERT INTO `mob_droplist` VALUES (446,0,0,1000,16101,@VCOMMON);  -- nemains_crown
INSERT INTO `mob_droplist` VALUES (446,0,0,1000, 2359,@RARE);     -- star_sapphire
INSERT INTO `mob_droplist` VALUES (446,0,0,1000,17857,@RARE);     -- animator_+1
INSERT INTO `mob_droplist` VALUES (446,0,0,1000,17745,@UNCOMMON); -- hofud
INSERT INTO `mob_droplist` VALUES (446,0,0,1000,18121,@UNCOMMON); -- valkyries_fork
INSERT INTO `mob_droplist` VALUES (446,0,0,1000,11287,@UNCOMMON); -- antares_harness

-- Hydra
INSERT INTO `mob_droplist` VALUES (3147,0,0,1000,16086,@VCOMMON);  -- phoboss_mask
INSERT INTO `mob_droplist` VALUES (3147,0,0,1000,16090,@VCOMMON);  -- freyrs_mask
INSERT INTO `mob_droplist` VALUES (3147,0,0,1000,16094,@VCOMMON);  -- tsukikazu_jinpachi
INSERT INTO `mob_droplist` VALUES (3147,0,0,1000,16098,@VCOMMON);  -- eas_tiara
INSERT INTO `mob_droplist` VALUES (3147,0,0,1000,16102,@VCOMMON);  -- bodbs_crown
INSERT INTO `mob_droplist` VALUES (3147,0,0,1000, 2359,@RARE);     -- star_sapphire
INSERT INTO `mob_droplist` VALUES (3147,0,0,1000,17857,@RARE);     -- animator_+1
INSERT INTO `mob_droplist` VALUES (3147,0,0,1000,14577,@UNCOMMON); -- valhalla_breastplate
INSERT INTO `mob_droplist` VALUES (3147,0,0,1000,19213,@UNCOMMON); -- white_tathlum

-- Khimaira
INSERT INTO `mob_droplist` VALUES (1437,0,0,1000,16087,@VCOMMON);  -- deimoss_mask
INSERT INTO `mob_droplist` VALUES (1437,0,0,1000,16091,@VCOMMON);  -- freyas_mask
INSERT INTO `mob_droplist` VALUES (1437,0,0,1000,16095,@VCOMMON);  -- hikazu_kabuto
INSERT INTO `mob_droplist` VALUES (1437,0,0,1000,16099,@VCOMMON);  -- enlils_tiara
INSERT INTO `mob_droplist` VALUES (1437,0,0,1000,16103,@VCOMMON);  -- machas_crown
INSERT INTO `mob_droplist` VALUES (1437,0,0,1000,2359,@RARE);      -- star_sapphire
INSERT INTO `mob_droplist` VALUES (1437,0,0,1000,17857,@RARE);     -- animator_+1
INSERT INTO `mob_droplist` VALUES (1437,0,0,1000,16117,@UNCOMMON); -- valhalla_helm
INSERT INTO `mob_droplist` VALUES (1437,0,0,1000,19212,@UNCOMMON); -- black_tathlum

-- Medusa
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000,15626,@VCOMMON);  -- enyos_cuisses
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000,15630,@VCOMMON);  -- njords_trousers
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000,15634,@VCOMMON);  -- hoshikazu_hakama
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000,15638,@VCOMMON);  -- anus_brais
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000,15642,@VCOMMON);  -- nemains_slops
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000, 2330,@RARE);     -- yoichis_sash
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000,15911,@RARE);     -- buccaneers_belt
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000,15799,@RARE);     -- iota_ring
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000,15800,@RARE);     -- omega_ring
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000,14943,@UNCOMMON); -- barbarossas_moufles
INSERT INTO `mob_droplist` VALUES (1651,0,0,1000,17751,@UNCOMMON); -- fragarach

-- Gulool Ja Ja
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000,15627,@VCOMMON);  -- phoboss_cuisses
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000,15631,@VCOMMON);  -- freyrs_trousers
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000,15635,@VCOMMON);  -- tsukikazu_haidate
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000,15639,@VCOMMON);  -- eas_brais
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000,15643,@VCOMMON);  -- bodbs_slops
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000, 2330,@RARE);     -- yoichis_sash
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000,15990,@RARE);     -- delta_earring
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000,16268,@RARE);     -- kubira_bead_necklace
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000,16269,@RARE);     -- morganas_choker
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000,18028,@UNCOMMON); -- matrons_knife
INSERT INTO `mob_droplist` VALUES (1257,0,0,1000,16275,@UNCOMMON); -- ancient_torque

-- Gurfurlur the Menacing
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,15628,@VCOMMON);  -- deimoss_cuisses
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,15632,@VCOMMON);  -- freyas_trousers
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,15636,@VCOMMON);  -- hikazu_hakama
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,15640,@VCOMMON);  -- enlils_brayettes
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,15644,@VCOMMON);  -- machas_slops
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,2330,@RARE);      -- yoichis_sash
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,16228,@RARE);     -- aslan_cape
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,16229,@RARE);     -- gleemans_cape
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,16267,@RARE);     -- ritter_gorget
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,15617,@UNCOMMON); -- barbarossas_zerehs
INSERT INTO `mob_droplist` VALUES (1259,0,0,1000,11288,@UNCOMMON); -- zahaks_mail

-----------------------------------
-- Ru'Aun
-----------------------------------
-- Genbu
INSERT INTO `mob_droplist` VALUES (946,0,0,1000,2434,@RARE); -- hadean_abjuration_head
INSERT INTO `mob_droplist` VALUES (946,0,0,1000,2429,@RARE); -- phantasmal_abjuration_head

-- Seiryu
INSERT INTO `mob_droplist` VALUES (2196,0,0,1000,2436,@RARE); -- hadean_abjuration_hands
INSERT INTO `mob_droplist` VALUES (2196,0,0,1000,2431,@RARE); -- phantasmal_abjuration_hands

-- Suzaku
INSERT INTO `mob_droplist` VALUES (2362,0,0,1000,2437,@RARE); -- hadean_abjuration_legs
INSERT INTO `mob_droplist` VALUES (2362,0,0,1000,2432,@RARE); -- phantasmal_abjuration_legs

-- Byakko
INSERT INTO `mob_droplist` VALUES (394,0,0,1000,2438,@RARE);  -- hadean_abjuration_feet
INSERT INTO `mob_droplist` VALUES (394,0,0,1000,2433,@RARE);  -- phantasmal_abjuration_feet

-- Kirin
INSERT INTO `mob_droplist` VALUES (2819,0,0,1000,2435,@RARE); -- hadean_abjuration_body
INSERT INTO `mob_droplist` VALUES (2819,0,0,1000,2430,@RARE); -- phantasmal_abjuration_body

-- Add ores to Sky NMs
SET @BLOODWOOD_LOG = 729;
SET @THOKCHA_ORE   = 734;
SET @PHRYGIAN_ORE  = 740;
SET @P_BRASS_ORE   = 741;

INSERT INTO `mob_droplist` VALUES (2326,0,0,1000, @THOKCHA_ORE,   @RARE); -- Steam Cleaner
INSERT INTO `mob_droplist` VALUES (2326,0,0,1000, @P_BRASS_ORE,   @RARE); -- Steam Cleaner
INSERT INTO `mob_droplist` VALUES (2326,0,0,1000, @BLOODWOOD_LOG, @RARE); -- Steam Cleaner

INSERT INTO `mob_droplist` VALUES (2820,0,0,1000, @THOKCHA_ORE,   @RARE); -- Mother Globe
INSERT INTO `mob_droplist` VALUES (2820,0,0,1000, @PHRYGIAN_ORE,  @RARE); -- Mother Globe
INSERT INTO `mob_droplist` VALUES (2820,0,0,1000, @P_BRASS_ORE,   @RARE); -- Mother Globe
INSERT INTO `mob_droplist` VALUES (2820,0,0,1000, @BLOODWOOD_LOG, @RARE); -- Mother Globe

INSERT INTO `mob_droplist` VALUES ( 357,0,0,1000, @THOKCHA_ORE,   @RARE); -- Brigandish Blade
INSERT INTO `mob_droplist` VALUES ( 357,0,0,1000, @PHRYGIAN_ORE,  @RARE); -- Brigandish Blade
INSERT INTO `mob_droplist` VALUES ( 357,0,0,1000, @P_BRASS_ORE,   @RARE); -- Brigandish Blade
INSERT INTO `mob_droplist` VALUES ( 357,0,0,1000, @BLOODWOOD_LOG, @RARE); -- Brigandish Blade

INSERT INTO `mob_droplist` VALUES (2821,0,0,1000, @THOKCHA_ORE,   @RARE); -- Faust
INSERT INTO `mob_droplist` VALUES (2821,0,0,1000, @PHRYGIAN_ORE,  @RARE); -- Faust
INSERT INTO `mob_droplist` VALUES (2821,0,0,1000, @P_BRASS_ORE,   @RARE); -- Faust
INSERT INTO `mob_droplist` VALUES (2821,0,0,1000, @BLOODWOOD_LOG, @RARE); -- Faust

INSERT INTO `mob_droplist` VALUES ( 638,0,0,1000, @THOKCHA_ORE,   @RARE); -- Despot
INSERT INTO `mob_droplist` VALUES ( 638,0,0,1000, @PHRYGIAN_ORE,  @RARE); -- Despot
INSERT INTO `mob_droplist` VALUES ( 638,0,0,1000, @P_BRASS_ORE,   @RARE); -- Despot
INSERT INTO `mob_droplist` VALUES ( 638,0,0,1000, @BLOODWOOD_LOG, @RARE); -- Despot

INSERT INTO `mob_droplist` VALUES (2822,0,0,1000, @THOKCHA_ORE,   @RARE); -- Ullikummi
INSERT INTO `mob_droplist` VALUES (2822,0,0,1000, @P_BRASS_ORE,   @RARE); -- Ullikummi
INSERT INTO `mob_droplist` VALUES (2822,0,0,1000, @BLOODWOOD_LOG, @RARE); -- Ullikummi

INSERT INTO `mob_droplist` VALUES (2800,0,0,1000, @THOKCHA_ORE,   @RARE); -- Zipacna
INSERT INTO `mob_droplist` VALUES (2800,0,0,1000, @PHRYGIAN_ORE,  @RARE); -- Zipacna
INSERT INTO `mob_droplist` VALUES (2800,0,0,1000, @P_BRASS_ORE,   @RARE); -- Zipacna
INSERT INTO `mob_droplist` VALUES (2800,0,0,1000, @BLOODWOOD_LOG, @RARE); -- Zipacna

INSERT INTO `mob_droplist` VALUES (2823,0,0,1000, @THOKCHA_ORE,   @RARE); -- Olla Grande
INSERT INTO `mob_droplist` VALUES (2823,0,0,1000, @PHRYGIAN_ORE,  @RARE); -- Olla Grande
INSERT INTO `mob_droplist` VALUES (2823,0,0,1000, @P_BRASS_ORE,   @RARE); -- Olla Grande
INSERT INTO `mob_droplist` VALUES (2823,0,0,1000, @BLOODWOOD_LOG, @RARE); -- Olla Grande

-----------------------------------
-- Sky 2.0 (Thanks Demetrie)
-----------------------------------
-- Escha Byakko
INSERT INTO `mob_droplist` VALUES (3990,0,0,1000,  837,@VCOMMON);  -- Malboro Fiber
INSERT INTO `mob_droplist` VALUES (3990,0,0,1000,  722,@COMMON);   -- Divine Log
INSERT INTO `mob_droplist` VALUES (3990,0,0,1000,  860,@COMMON);   -- Behemoth Hide

INSERT INTO `mob_droplist` VALUES (3990,0,1,1000, 1311,@VCOMMON);  -- Piece Of Oxblood
INSERT INTO `mob_droplist` VALUES (3990,0,1,1000,  658,@COMMON);   -- Damascus Ingot
INSERT INTO `mob_droplist` VALUES (3990,0,1,1000, 1110,@COMMON);   -- Beetle Blood
INSERT INTO `mob_droplist` VALUES (3990,0,1,1000, 2169,@COMMON);   -- Cerberus Hide

INSERT INTO `mob_droplist` VALUES (3990,0,2,1000,15714,@RARE);     -- deimoss_leggings
INSERT INTO `mob_droplist` VALUES (3990,0,2,1000,15718,@RARE);     -- freyas_ledelsens
INSERT INTO `mob_droplist` VALUES (3990,0,2,1000,15722,@RARE);     -- hikazu_sune-ate
INSERT INTO `mob_droplist` VALUES (3990,0,2,1000,15726,@RARE);     -- enlils_crackows
INSERT INTO `mob_droplist` VALUES (3990,0,2,1000,15730,@RARE);     -- machas_pigaches

INSERT INTO `mob_droplist` VALUES (3990,0,3,1000,18498,@UNCOMMON); -- balestarius
INSERT INTO `mob_droplist` VALUES (3990,0,3,1000,13403,@UNCOMMON); -- assault_earring
INSERT INTO `mob_droplist` VALUES (3990,0,3,1000,16241,@RARE);     -- cuchulains_mantle
INSERT INTO `mob_droplist` VALUES (3990,0,3,1000,16356,@RARE);     -- nimues_tights

INSERT INTO `mob_droplist` VALUES (3990,0,4,1000, 3010,@RARE);     -- Ripped Haidate (Jokushu Haidate)
INSERT INTO `mob_droplist` VALUES (3990,0,5,1000,27525,@RARE);     -- Jokushu Chain

-- Escha Genbu
INSERT INTO `mob_droplist` VALUES (3991,0,0,1000, 908,@VCOMMON);   -- Adamantoise Shell
INSERT INTO `mob_droplist` VALUES (3991,0,0,1000, 901,@COMMON);    -- Venomous Claw
INSERT INTO `mob_droplist` VALUES (3991,0,0,1000,1311,@COMMON);    -- Piece Of Oxblood

INSERT INTO `mob_droplist` VALUES (3991,0,1,1000, 722,@VCOMMON);   -- Divine Log
INSERT INTO `mob_droplist` VALUES (3991,0,1,1000, 655,@COMMON);    -- Adaman Ingot
INSERT INTO `mob_droplist` VALUES (3991,0,1,1000,1110,@COMMON);    -- Beetle Blood
INSERT INTO `mob_droplist` VALUES (3991,0,1,1000, 860,@COMMON);    -- Behemoth Hide

INSERT INTO `mob_droplist` VALUES (3991,0,2,1000,14964,@RARE);     -- deimoss_gauntlets
INSERT INTO `mob_droplist` VALUES (3991,0,2,1000,14968,@RARE);     -- freyas_gloves
INSERT INTO `mob_droplist` VALUES (3991,0,2,1000,14972,@RARE);     -- hikazu_gote
INSERT INTO `mob_droplist` VALUES (3991,0,2,1000,14976,@RARE);     -- enlils_kolluks
INSERT INTO `mob_droplist` VALUES (3991,0,2,1000,14980,@RARE);     -- machas_cuffs

INSERT INTO `mob_droplist` VALUES (3991,0,3,1000,15831,@UNCOMMON); -- fenian_ring
INSERT INTO `mob_droplist` VALUES (3991,0,3,1000,17758,@UNCOMMON); -- ruler
INSERT INTO `mob_droplist` VALUES (3991,0,3,1000,16158,@RARE);     -- gnadbhods_helm
INSERT INTO `mob_droplist` VALUES (3991,0,3,1000,15918,@RARE);     -- witch_sash

INSERT INTO `mob_droplist` VALUES (3991,0,4,1000, 3008,@RARE);     -- Cracked Kabuto (Genmei Kabuto)
INSERT INTO `mob_droplist` VALUES (3991,0,5,1000,27539,@RARE);     -- Genmei Earring

-- Escha Suzaku
INSERT INTO `mob_droplist` VALUES (3992,0,0,1000, 1313,@VCOMMON);  -- Siren's Hair
INSERT INTO `mob_droplist` VALUES (3992,0,0,1000,  836,@COMMON);   -- Damascene Cloth
INSERT INTO `mob_droplist` VALUES (3992,0,0,1000, 1110,@COMMON);   -- Beetle Blood

INSERT INTO `mob_droplist` VALUES (3992,0,1,1000,  747,@VCOMMON);  -- Orichalcum Ingot
INSERT INTO `mob_droplist` VALUES (3992,0,1,1000,  831,@COMMON);   -- Shining Cloth
INSERT INTO `mob_droplist` VALUES (3992,0,1,1000,  901,@COMMON);   -- Venomous Claw
INSERT INTO `mob_droplist` VALUES (3992,0,1,1000,  867,@COMMON);   -- dragon_scales

INSERT INTO `mob_droplist` VALUES (3992,0,2,1000,15712,@RARE);     -- enyos_leggings
INSERT INTO `mob_droplist` VALUES (3992,0,2,1000,15716,@RARE);     -- njords_ledelsens
INSERT INTO `mob_droplist` VALUES (3992,0,2,1000,15720,@RARE);     -- hoshikazu_kyahan
INSERT INTO `mob_droplist` VALUES (3992,0,2,1000,15724,@RARE);     -- anus_gaiters
INSERT INTO `mob_droplist` VALUES (3992,0,2,1000,15728,@RARE);     -- nemains_sabots

INSERT INTO `mob_droplist` VALUES (3992,0,3,1000,16002,@UNCOMMON); -- roundel_earring
INSERT INTO `mob_droplist` VALUES (3992,0,3,1000,13624,@UNCOMMON); -- enhancing_mantle
INSERT INTO `mob_droplist` VALUES (3992,0,3,1000,15917,@RARE);     -- cuchulains_belt
INSERT INTO `mob_droplist` VALUES (3992,0,3,1000,11365,@RARE);     -- karasutengu_kogake

INSERT INTO `mob_droplist` VALUES (3992,0,4,1000, 3009,@RARE);     -- Scuffed Sune-Ate (Shukuyu Sune-Ate)
INSERT INTO `mob_droplist` VALUES (3992,0,5,1000,26161,@RARE);     -- Shukuyu Ring

-- Escha Seiryu
INSERT INTO `mob_droplist` VALUES (3993,0,0,1000,  903,@VCOMMON);  -- Dragon Talon
INSERT INTO `mob_droplist` VALUES (3993,0,0,1000, 1133,@COMMON);   -- Dragon Blood
INSERT INTO `mob_droplist` VALUES (3993,0,0,1000, 4272,@COMMON);   -- Dragon Meat

INSERT INTO `mob_droplist` VALUES (3993,0,1,1000,  836,@VCOMMON);  -- Damascene Cloth
INSERT INTO `mob_droplist` VALUES (3993,0,1,1000,  837,@COMMON);   -- Malboro Fiber
INSERT INTO `mob_droplist` VALUES (3993,0,1,1000, 4486,@COMMON);   -- Dragon Heart
INSERT INTO `mob_droplist` VALUES (3993,0,1,1000, 1712,@COMMON);   -- Cashmere Wool

INSERT INTO `mob_droplist` VALUES (3993,0,2,1000,15713,@RARE);     -- phoboss_sabatons
INSERT INTO `mob_droplist` VALUES (3993,0,2,1000,15717,@RARE);     -- freyrs_ledelsens
INSERT INTO `mob_droplist` VALUES (3993,0,2,1000,15721,@RARE);     -- tsukikazu_sune-ate
INSERT INTO `mob_droplist` VALUES (3993,0,2,1000,15725,@RARE);     -- eas_crackows
INSERT INTO `mob_droplist` VALUES (3993,0,2,1000,15729,@RARE);     -- bodbs_pigaches

INSERT INTO `mob_droplist` VALUES (3993,0,3,1000,11392,@UNCOMMON); -- koschei_crackows
INSERT INTO `mob_droplist` VALUES (3993,0,3,1000,18598,@UNCOMMON); -- prester
INSERT INTO `mob_droplist` VALUES (3993,0,3,1000,16159,@RARE);     -- zhagos_barbut
INSERT INTO `mob_droplist` VALUES (3993,0,3,1000,16001,@RARE);     -- crapaud_earring

INSERT INTO `mob_droplist` VALUES (3993,0,4,1000, 3011,@RARE);     -- Ruined Kote (Kobo Kote)
INSERT INTO `mob_droplist` VALUES (3993,0,5,1000,26320,@RARE);     -- Kobo Obi

-- Escha Kirin - High Prize Items
INSERT INTO `mob_droplist` VALUES (3989,0,0,1000,831,@VCOMMON);     -- Shining Cloth
INSERT INTO `mob_droplist` VALUES (3989,0,0,1000,658,@COMMON);      -- Damascus Ingot
INSERT INTO `mob_droplist` VALUES (3989,0,0,1000,747,@COMMON);      -- Orichalcum Ingot

INSERT INTO `mob_droplist` VALUES (3989,0,1,1000,3503,@ALWAYS);     -- Mulcibar's Scoria
INSERT INTO `mob_droplist` VALUES (3989,0,2,1000,3503,@VCOMMON);    -- Mulcibar's Scoria
INSERT INTO `mob_droplist` VALUES (3989,0,3,1000,2168,@COMMON);     -- Cerberus Claw
INSERT INTO `mob_droplist` VALUES (3989,0,3,1000,2169,@UNCOMMON);   -- Cerberus Hide

INSERT INTO `mob_droplist` VALUES (3989,0,4,1000,16160,@UNCOMMON);  -- Ree Habalo's Headgear
INSERT INTO `mob_droplist` VALUES (3989,0,4,1000,19030,@UNCOMMON);  -- Wise Strap
INSERT INTO `mob_droplist` VALUES (3989,0,4,1000,15833,@UNCOMMON);  -- Diverter's Ring

INSERT INTO `mob_droplist` VALUES (3989,0,5,1000,11281,@RARE);      -- Hachiryu Haramaki
INSERT INTO `mob_droplist` VALUES (3989,0,5,1000,18447,@RARE);      -- Nanatsusayanotachi
INSERT INTO `mob_droplist` VALUES (3989,0,5,1000,18759,@RARE);      -- Shenlongs Baghnakhs
INSERT INTO `mob_droplist` VALUES (3989,0,5,1000,18594,@RARE);      -- Dorje

INSERT INTO `mob_droplist` VALUES (3989,0,6,1000, 3007,@RARE);      -- Tattered Osode (Reiki Osode)
INSERT INTO `mob_droplist` VALUES (3989,0,7,1000,20842,@VRARE);     -- Reikiono

-- Eschan Porxie
UPDATE mob_groups SET dropId = "3975" WHERE zoneId = "289" and name = "Eschan_Porxie";
INSERT INTO `mob_droplist` VALUES (3975,0,0,1000,6392,220); -- Eschan Porxie (Bead Pouch)
INSERT INTO `mob_droplist` VALUES (3975,0,0,1000,6393,40);  -- Eschan Porxie (Porxie Pork)
