-- -----------------------------------------------
-- Remove gear from AH to reduce clutter
-- -----------------------------------------------

-- Clear AH sellable flag from item
UPDATE item_basic left join item_equipment using (itemid)
SET item_basic.flags = item_basic.flags & ~0x0040
WHERE (item_basic.flags & 0x0040) > 0 AND
(
    item_equipment.`level` > 75 OR -- lv 76-99 gear
    item_equipment.ilevel > 0      -- itemLevel gear
);

-- Set to invalid category
UPDATE item_basic left join item_equipment using (itemid)
SET item_basic.aH = 255
WHERE  item_basic.aH > 0 AND
(
    item_equipment.`level` > 75 OR -- lv 76-99 gear
    item_equipment.ilevel > 0      -- itemLevel gear
);



-- -----------------------------------------------
-- Remove gear from Goblin Mystery box
-- -----------------------------------------------

-- Clear ITEM_FLAG_MYSTERY_BOX from item
UPDATE item_basic left join item_equipment using (itemid)
SET item_basic.flags = item_basic.flags & ~0x0004
WHERE (item_basic.flags & 0x0004) > 0 AND
(
    item_equipment.`level` > 75 OR -- lv 76-99
    item_equipment.ilevel > 0   OR -- itemLevel gear
    itemid in (                     -- Special Items
        -- Crooked Jones (Fishing)
        18888, -- Brigand's Eyepatch
        20717, -- Mercurial Kunai (Arendsi Fleuret)
        28443, -- Brig. Eyepatch
        20945, -- Halieutica (Nativus Halberd)
        9417,  -- Worn Fishing Gear
        9418,  -- Fine Fishing Line
        9419,  -- Aged Fishing Pole
        9420,  -- Rusty Fishing Hook
        9426,  -- Buccaneer's Chart
        9427,  -- Emperor Clam
        9428,  -- Placeholder (Fishing/Clamming Content)
        9429,  -- Placeholder (Fishing/Clamming Content)
        -- Crystal Warrior (YA/GG/MM)
        28442, -- Champion Belt
        28496, -- Moblinium Might
        21479, -- Arcane Arbalest
        28539, -- Outlaw's Earring
        26702, -- Yagudo Crown
        9491,  -- Arena Token
        9493,  -- Moblin Master Key
        -- Dynamis 2.0
        9498,  -- Timeless Sand
        -- Custom Beast Jugs
        17917, -- Fun Dip
        -- Ventures
        10870, -- Venture Ring
        9435,  -- Goblin Brew
        9496,  -- Goblin Brew +1
        9497,  -- Goblin Brew +2
        9498   -- Goblin Brew +3
    )                           OR
    itemid in (                     -- Dragon Slaying
        -- Materials
        9444,  -- Golden Bangle
        9445,  -- Golden Rings
        9446,  -- Golden Rings +1
        9447,  -- Wyrm Scale
        9453,  -- Wyrm Tooth
        9454,  -- Embersteel Ingot
        9455,  -- Fable Thread
        9456,  -- Fable Cloth
        3545,  -- Serica Cloth
        -- Weapons/Armor
        21384, -- Rimestone
        28640, -- Hierarch's Mantle
        21385, -- Cinderstone
        28514, -- Adept's Earring
        28577, -- Titanium Band (Kunaji Ring)
        27767, -- Erudite Cap (Buremte Hat)
        28201, -- Acrobat's Breeches (Xux Trousers)
        20554, -- Steady Fists (Tlalpoloani)
        27738, -- Assailant's Visor (Ejekamal Mask)
        28459, -- Subtle Sash (Chuq'aba Belt)
        28062, -- Ornate Gloves (Quauhpilli Gloves)
        20740, -- Unbreakable (Camatlatia)
        27779, -- Conqueror's Helm (Quauhpilli Helm)
        21915, -- Stormblade (Koga Shinobi-gatana)
        28384, -- Loxo Scarf (Huani Collar)
        28458, -- Covenant Belt (Jaq'ij Sash)
        28305, -- Ruthless Greaves (Ejekamal Boots)
        28050, -- Swift Gages (Buremte Gloves)
        27781, -- Windfall Hat (Xux Hat)
        20643  -- Serpent Tongue (Macoquetza)
    )                           OR
    itemid in (                    -- Pulse Weapons
        19174, -- Bifrost (Borealis)
        17669, -- Undulant Black (Sagasinger)
        22086, -- Elegy's Respite (Xoanon)
        19298, -- Carver (Ikarigiri)
        18904, -- Somnia Melodiam (Ephemeron)
        18525, -- Hax (Himthige)
        22107, -- Tonzoffun (Ullr)
        21519, -- Face Breakers (Karambit)
        21830, -- Broken Promise (Drepanum)
        21722  -- Raqia (Dolichenus)
    )                           OR
    itemid in (                    -- Limbus Armor
        15240, -- Homam Zucchetto
        14488, -- Homam Corazza
        14905, -- Homam Manopolas
        15576, -- Homam Cosciales
        15661, -- Homam Gambieras
        15241, -- Nashira Turban
        14489, -- Nashira Manteel
        14906, -- Nashira Gages
        15577, -- Nashira Seraweels
        15662  -- Nashira Crackows
    )                           OR
    itemid in (                     -- Salvage armor
        16085, -- Enyo's Mask
        14547, -- Enyo's Brstplate
        14962, -- Enyo's Gauntlets
        15626, -- Enyo's Cuisses
        15712, -- Enyo's Leggings
        16086, -- Phobos's Mask
        14548, -- Phobos's Cuirass
        14963, -- Phobos's Gauntlets
        15627, -- Phobos's Cuisses
        15713, -- Phobos's Sabatons
        16087, -- Deimos's Mask
        14549, -- Deimos's Cuirass
        14964, -- Deimos's Gauntlets
        15628, -- Deimos's Cuisses
        15714, -- Deimos's Leggings
        27658, -- Ate's Mask
        27798, -- Ate's Cuirass
        27938, -- Ate's Gauntlets
        28081, -- Ate's Flanchard
        28218, -- Ate's Sollerets
        16084, -- Ares' Mask
        14546, -- Ares' Cuirass
        14961, -- Ares' Gauntlets
        15625, -- Ares' Flanchard
        15711, -- Ares' Sollerets
        16089, -- Njord's Mask
        14551, -- Njord's Jerkin
        14966, -- Njord's Gloves
        15630, -- Njord's Trousers
        15716, -- Njord's Ledelsens
        16090, -- Freyr's Mask
        14552, -- Freyr's Jerkin
        14967, -- Freyr's Gloves
        15631, -- Freyr's Trousers
        15717, -- Freyr's Ledelsens
        16091, -- Freyas's Mask
        14553, -- Freyas's Jerkin
        14968, -- Freyas's Gloves
        15632, -- Freyas's Trousers
        15718, -- Freyas's Ledelsens
        27659, -- Idi's Mask
        27799, -- Idi's Jerkin
        27939, -- Idi's Gloves
        28082, -- Idi's Trousers
        28219, -- Idi's Ledelsens
        16088, -- Skadi's Visor
        14550, -- Skadi's Cuirie
        14965, -- Skadi's Bazubands
        15629, -- Skadi's Chausses
        15715, -- Skadi's Jambeaux
        16093, -- Hoshikazu Hachimaki
        14555, -- Hoshikazu Gi
        14970, -- Hoshikazu Tekko
        15634, -- Hoshikazu Hakama
        15720, -- Hoshikazu Kyahan
        16094, -- Tsukikazu Jinpachi
        14556, -- Tsukikazu Togi
        14971, -- Tsukikazu Gote
        15635, -- Tsukikazu Haidate
        15721, -- Tsukikazu Sune-Ate
        16095, -- Hikazu Kabuto
        14557, -- Hikazu Hara-Ate
        14972, -- Hikazu Gote
        15636, -- Hikazu Hakama
        15722, -- Hikazu Sune-Ate
        27660, -- Genta Kabuto
        27800, -- Genta Hara-Ate
        27940, -- Genta Gote
        28083, -- Genta-no-Hakama
        28220, -- Genta Sune-Ate
        16092, -- Usukane Somen
        14554, -- Usukane Haramaki
        14969, -- Usukane Gote
        15633, -- Usukane Hizayoroi
        15719, -- Usukane Sune-Ate
        16097, -- Anu's Tiara
        14559, -- Anu's Doublet
        14974, -- Anu's Gages
        15638, -- Anu's Brais
        15724, -- Anu's Gaiters
        16098, -- Ea's Tiara
        14560, -- Ea's Doublet
        14975, -- Ea's Dastanas
        15639, -- Ea's Brais
        15725, -- Ea's Crackows
        16099, -- Enlil's Tiara
        14561, -- Enlil's Gambison
        14976, -- Enlil's Kolluks
        15640, -- Enlil's Brayettes
        15726, -- Enlil's Crackows
        27661, -- Namru's Tiara
        27801, -- Namru's Jubbah
        27941, -- Namru's Dastanas
        28084, -- Namru's Shalwar
        28221, -- Namru's Crackows
        16096, -- Marduk's Tiara
        14558, -- Marduk's Jubbah
        14973, -- Marduk's Dastanas
        15637, -- Marduk's Shalwar
        15723, -- Marduk's Crackows
        16101, -- Nemain's Crown
        14563, -- Nemain's Robe
        14978, -- Nemain's Cuffs
        15642, -- Nemain's Slops
        15728, -- Nemain's Sabots
        16102, -- Bodb's Crown
        14564, -- Bodb's Robe
        14979, -- Bodb's Cuffs
        15643, -- Bodb's Slops
        15729, -- Bodb's Pigaches
        16103, -- Macha's Crown
        14565, -- Macha's Coat
        14980, -- Macha's Cuffs
        15644, -- Macha's Slops
        15730, -- Macha's Pigaches
        27662, -- Neit's Crown
        27802, -- Neit's Coat
        27942, -- Neit's Cuffs
        28085, -- Neit's Slops
        28222, -- Neit's Pigaches
        16100, -- Morrigan's Coronal
        14562, -- Morrigan's Robe
        14977, -- Morrigan's Cuffs
        15641, -- Morrigan's Slops
        15727  -- Morrigan's Pigaches
    )                           OR
    itemid in (                     -- Mastery System
        9281, -- Paragon Card
        9282, -- Paragon Card
        9283, -- Paragon Card
        9284, -- Paragon Card
        9285, -- Paragon Card
        9286, -- Paragon Card
        9287, -- Paragon Card
        9288, -- Paragon Card
        9289, -- Paragon Card
        9290, -- Paragon Card
        9291, -- Paragon Card
        9292, -- Paragon Card
        9293, -- Paragon Card
        9294, -- Paragon Card
        9295, -- Paragon Card
        9296, -- Paragon Card
        9297, -- Paragon Card
        9298, -- Paragon Card
        9299, -- Paragon Card
        9300, -- Paragon Card
        9301, -- Paragon Card
        9302, -- Paragon Card
        9303, -- Kin's Scale
        9304, -- Gin's Scale
        9305, -- Kei's Scale
        9306, -- Kyou's Scale
        9307  -- Fu's Scale
    )                           OR
    itemid IN (                     -- Improper Automaton Attachments IDs
        8449, -- strobe
        8450, -- tension_spring
        8451, -- inhibitor
        8452, -- tension_spring_ii
        8453, -- attuner
        8454, -- reactive_shield
        8455, -- flame_holder
        8456, -- heat_capacitor
        8457, -- strobe_ii
        8458, -- tension_spring_iii
        8459, -- inhibitor_ii
        8460, -- tension_spring_iv
        8461, -- heat_capacitor_ii
        8462, -- speedloader
        8463, -- speedloader_ii
        8464, -- tension_spring_v
        8465, -- magniplug
        8466, -- magniplug_ii
        8481, -- mana_booster
        8482, -- loudspeaker
        8483, -- scanner
        8484, -- loudspeaker_ii
        8485, -- tactical_processor
        8486, -- tranquilizer
        8487, -- ice_maker
        8488, -- power_cooler
        8489, -- loudspeaker_iii
        8490, -- tranquilizer_ii
        8491, -- amplifier
        8492, -- loudspeaker_iv
        8493, -- tranquilizer_iii
        8494, -- amplifier_ii
        8495, -- loudspeaker_v
        8496, -- tranquilizer_iv
        8497, -- arcanoclutch
        8498, -- arcanoclutch_ii
        8513, -- accelerator
        8514, -- scope
        8515, -- pattern_reader
        8516, -- accelerator_ii
        8517, -- drum_magazine
        8518, -- turbo_charger
        8519, -- replicator
        8520, -- barrage_turbine
        8521, -- turbo_charger_ii
        8522, -- accelerator_iii
        8523, -- scope_ii
        8524, -- repeater
        8525, -- accelerator_iv
        8526, -- scope_iii
        8527, -- scope_iv
        8528, -- truesights
        8545, -- shock_absorber
        8546, -- armor_plate
        8547, -- analyzer
        8548, -- armor_plate_ii
        8549, -- equalizer
        8550, -- schurzen
        8551, -- hammermill
        8552, -- barrier_module_ii
        8553, -- shock_absorber_ii
        8554, -- armor_plate_iii
        8555, -- barrier_module
        8556, -- armor_plate_iv
        8557, -- shock_absorber_iii
        8577, -- stabilizer
        8578, -- volt_gun
        8579, -- heat_seeker
        8580, -- stabilizer_ii
        8581, -- target_marker
        8582, -- dynamo
        8583, -- coiler
        8584, -- galvanizer
        8585, -- stabilizer_iii
        8586, -- coiler_ii
        8587, -- dynamo_ii
        8588, -- stabilizer_iv
        8589, -- dynamo_iii
        8590, -- stabilizer_v
        8609, -- mana_jammer
        8610, -- heatsink
        8611, -- stealth_screen
        8612, -- mana_jammer_ii
        8613, -- mana_channeler
        8614, -- condenser
        8615, -- steam_jacket
        8616, -- percolator
        8617, -- mana_jammer_iii
        8618, -- stealth_screen_ii
        8619, -- resister
        8620, -- resister_ii
        8621, -- mana_jammer_iv
        8622, -- mana_channeler_ii
        8641, -- auto-repair_kit
        8642, -- flashbulb
        8643, -- damage_gauge
        8644, -- auto-repair_kit_ii
        8645, -- eraser
        8646, -- optic_fiber
        8648, -- vivi-valve
        8649, -- vivi-valve_ii
        8650, -- auto-repair_kit_iii
        8651, -- arcanic_cell
        8652, -- arcanic_cell_ii
        8653, -- auto-repair_kit_iv
        8654, -- optic_fiber_ii
        8655, -- damage_gauge_ii
        8673, -- mana_tank
        8674, -- mana_converter
        8675, -- mana_conserver
        8676, -- mana_tank_ii
        8677, -- smoke_screen
        8678, -- economizer
        8680, -- disruptor
        8681  -- mana_tank_iii
    )
);

-- Also remove bad attachments from AH
UPDATE item_basic SET aH = 0 WHERE itemid IN (
    8449, -- strobe
    8450, -- tension_spring
    8451, -- inhibitor
    8452, -- tension_spring_ii
    8453, -- attuner
    8454, -- reactive_shield
    8455, -- flame_holder
    8456, -- heat_capacitor
    8457, -- strobe_ii
    8458, -- tension_spring_iii
    8459, -- inhibitor_ii
    8460, -- tension_spring_iv
    8461, -- heat_capacitor_ii
    8462, -- speedloader
    8463, -- speedloader_ii
    8464, -- tension_spring_v
    8465, -- magniplug
    8466, -- magniplug_ii
    8481, -- mana_booster
    8482, -- loudspeaker
    8483, -- scanner
    8484, -- loudspeaker_ii
    8485, -- tactical_processor
    8486, -- tranquilizer
    8487, -- ice_maker
    8488, -- power_cooler
    8489, -- loudspeaker_iii
    8490, -- tranquilizer_ii
    8491, -- amplifier
    8492, -- loudspeaker_iv
    8493, -- tranquilizer_iii
    8494, -- amplifier_ii
    8495, -- loudspeaker_v
    8496, -- tranquilizer_iv
    8497, -- arcanoclutch
    8498, -- arcanoclutch_ii
    8513, -- accelerator
    8514, -- scope
    8515, -- pattern_reader
    8516, -- accelerator_ii
    8517, -- drum_magazine
    8518, -- turbo_charger
    8519, -- replicator
    8520, -- barrage_turbine
    8521, -- turbo_charger_ii
    8522, -- accelerator_iii
    8523, -- scope_ii
    8524, -- repeater
    8525, -- accelerator_iv
    8526, -- scope_iii
    8527, -- scope_iv
    8528, -- truesights
    8545, -- shock_absorber
    8546, -- armor_plate
    8547, -- analyzer
    8548, -- armor_plate_ii
    8549, -- equalizer
    8550, -- schurzen
    8551, -- hammermill
    8552, -- barrier_module_ii
    8553, -- shock_absorber_ii
    8554, -- armor_plate_iii
    8555, -- barrier_module
    8556, -- armor_plate_iv
    8557, -- shock_absorber_iii
    8577, -- stabilizer
    8578, -- volt_gun
    8579, -- heat_seeker
    8580, -- stabilizer_ii
    8581, -- target_marker
    8582, -- dynamo
    8583, -- coiler
    8584, -- galvanizer
    8585, -- stabilizer_iii
    8586, -- coiler_ii
    8587, -- dynamo_ii
    8588, -- stabilizer_iv
    8589, -- dynamo_iii
    8590, -- stabilizer_v
    8609, -- mana_jammer
    8610, -- heatsink
    8611, -- stealth_screen
    8612, -- mana_jammer_ii
    8613, -- mana_channeler
    8614, -- condenser
    8615, -- steam_jacket
    8616, -- percolator
    8617, -- mana_jammer_iii
    8618, -- stealth_screen_ii
    8619, -- resister
    8620, -- resister_ii
    8621, -- mana_jammer_iv
    8622, -- mana_channeler_ii
    8641, -- auto-repair_kit
    8642, -- flashbulb
    8643, -- damage_gauge
    8644, -- auto-repair_kit_ii
    8645, -- eraser
    8646, -- optic_fiber
    8648, -- vivi-valve
    8649, -- vivi-valve_ii
    8650, -- auto-repair_kit_iii
    8651, -- arcanic_cell
    8652, -- arcanic_cell_ii
    8653, -- auto-repair_kit_iv
    8654, -- optic_fiber_ii
    8655, -- damage_gauge_ii
    8673, -- mana_tank
    8674, -- mana_converter
    8675, -- mana_conserver
    8676, -- mana_tank_ii
    8677, -- smoke_screen
    8678, -- economizer
    8680, -- disruptor
    8681  -- mana_tank_iii
);
