-----------------------------------
-- Mastery System
-----------------------------------
SET @PET_ALL       = 0;
SET @PET_AVATAR    = 1;
SET @PET_WYVERN    = 2;
SET @PET_AUTOMATON = 3;
SET @PET_LUOPAN    = 8;

SET @MOD_DEF = 1;
SET @MOD_HP  = 2;
SET @MOD_MP  = 5;

SET @MOD_HP2MP = 7;
SET @MOD_STR =  8;
SET @MOD_DEX =  9;
SET @MOD_VIT = 10;
SET @MOD_AGI = 11;
SET @MOD_INT = 12;
SET @MOD_MND = 13;
SET @MOD_CHR = 14;

SET @MOD_FIRE_RES    = 15;
SET @MOD_ICE_RES     = 16;
SET @MOD_WIND_RES    = 17;
SET @MOD_EARTH_RES   = 18;
SET @MOD_THUNDER_RES = 19;
SET @MOD_WATER_RES   = 20;
SET @MOD_LIGHT_RES   = 21;
SET @MOD_DARK_RES    = 22;

SET @MOD_ATT    = 23;
SET @MOD_RATT   = 24;
SET @MOD_ACC    = 25;
SET @MOD_RACC   = 26;
SET @MOD_ENMITY = 27;
SET @MOD_MATT   = 28;
SET @MOD_MDEF   = 29;
SET @MOD_MACC   = 30;
SET @MOD_MEVA   = 31;
SET @MOD_WSACC  = 48;

SET @MOD_TP_OVER     =  7;
SET @MOD_UNDER_LEVEL = 50;
SET @MOD_ABOVE_LEVEL = 51;
SET @MOD_EVA         = 68;
SET @MOD_HMP         = 71;
SET @MOD_HHP         = 72;
SET @MOD_STORE_TP    = 73;
SET @MOD_MOVESPEED   = 76;

SET @MOD_HTH_SKILL       = 80;
SET @MOD_DAGGER_SKILL    = 81;
SET @MOD_SWORD_SKILL     = 82;
SET @MOD_GSWORD_SKILL    = 83;
SET @MOD_AXE_SKILL       = 84;
SET @MOD_GAXE_SKILL      = 85;
SET @MOD_SCYTHE_SKILL    = 86;
SET @MOD_POLEARM_SKILL   = 87;
SET @MOD_KATANA_SKILL    = 88;
SET @MOD_GKATANA_SKILL   = 89;
SET @MOD_CLUB_SKILL      = 90;
SET @MOD_STAFF_SKILL     = 91;
SET @MOD_FLEE_DURATION   = 93;
SET @MOD_MEDITATE        = 94;
SET @MOD_WARDING_CIR_DUR = 95;
SET @MOD_SOULEATER       = 96;
SET @MOD_BOOST_EFFECT    = 97;
SET @MOD_CAMOFLAGE_DUR   = 98;

SET @MOD_AUTO_MAGIC_SKILL = 103;
SET @MOD_ARCHERY_SKILL    = 104;
SET @MOD_MARKSMAN_SKILL   = 105;
SET @MOD_THROWING_SKILL   = 106;

SET @MOD_GUARD_SKILL   = 107;
SET @MOD_EVASION_SKILL = 108;
SET @MOD_SHIELD_SKILL  = 109;
SET @MOD_PARRY_SKILL   = 110;

SET @MOD_DIVINE_SKILL    = 111;
SET @MOD_HEALING_SKILL   = 112;
SET @MOD_ENHANCE_SKILL   = 113;
SET @MOD_ENFEEBLE_SKILL  = 114;
SET @MOD_ELEMENTAL_SKILL = 115;
SET @MOD_DARK_SKILL      = 116;
SET @MOD_SUMMONING_SKILL = 117;
SET @MOD_NINJUTSU_SKILL  = 118;
SET @MOD_SINGING_SKILL   = 119;
SET @MOD_STRING_SKILL    = 120;
SET @MOD_WIND_SKILL      = 121;
SET @MOD_BLUE_SKILL      = 122;
SET @MOD_GEOMANCY_SKILL  = 123;
SET @MOD_HANDBELL_SKILL  = 124;

SET @MOD_FISHING_SKILL   = 127;

SET @MOD_DAMAGE_TAKEN       = 160;
SET @MOD_PHYS_DMG_TAKEN     = 161;
SET @MOD_BREATH_DMG_TAKEN   = 162;
SET @MOD_MAGIC_DMG_TAKEN    = 163;
SET @MOD_CRIT_HIT_RATE      = 165;
SET @MOD_ENEMYCRITRATE      = 166;
SET @MOD_SPELL_INTERRUPT    = 168;
SET @MOD_MARTIAL_ARTS       = 173;
SET @MOD_SKILLCHAIN_DMG     = 175;
SET @MOD_MAGIC_DMG_TAKEN_II = 831;

SET @MOD_FASTCAST    = 170;
SET @MOD_CONSERVE_MP = 296;

SET @MOD_VERMIN_KILLER   = 224;
SET @MOD_BIRD_KILLER     = 225;
SET @MOD_AMORPH_KILLER   = 226;
SET @MOD_LIZARD_KILLER   = 227;
SET @MOD_AQUAN_KILLER    = 228;
SET @MOD_PLANTOID_KILLER = 229;
SET @MOD_BEAST_KILLER    = 230;
SET @MOD_UNDEAD_KILLER   = 231;
SET @MOD_ARCANA_KILLER   = 232;
SET @MOD_DRAGON_KILLER   = 233;
SET @MOD_DEMON_KILLER    = 234;
SET @MOD_EMPTY_KILLER    = 235;
SET @MOD_HUMANOID_KILLER = 236;
SET @MOD_LUMINIAN_KILLER = 237;
SET @MOD_LUMINION_KILLER = 238;

SET @MOD_DUAL_WIELD      = 259;
SET @MOD_RSE             = 276;
SET @MOD_SPIRIT_LINK     = 281;
SET @MOD_WEAPON_DMG      = 287;
SET @MOD_DOUBLE_ATK      = 288;
SET @MOD_SUBTLE_BLOW     = 289;
SET @MOD_COUNTER         = 291;
SET @MOD_KICK_RATE       = 292;
SET @MOD_STEAL           = 298;
SET @MOD_TRIPLE_ATK      = 302;
SET @MOD_TREASURE_HUNTER = 303;
SET @MOD_ZANSHIN         = 306;
SET @MOD_NINJA_TOOL      = 308;
SET @MOD_SCAVENGE        = 312;
SET @MOD_SHARPSHOT       = 314;
SET @MOD_DRAIN_ASPIR_POT = 315;
SET @MOD_TP_BONUS        = 345;
SET @MOD_BARRAGE_ACC     = 420;
SET @MOD_SHIELD_MASTERY  = 485;
SET @MOD_SHIELD_RATE     = 518;
SET @MOD_TRICK_ATK_AGI   = 520;

SET @MOD_JUMP_TP_BONUS      = 361;
SET @MOD_JUMP_DOUBLE_ATTACK = 888;

SET @MOD_LIGHT_ARTS_SKILL     = 336;
SET @MOD_DARK_ARTS_SKILL      = 337;
SET @MOD_FIRE_AFFINITY_DMG    = 347;
SET @MOD_ICE_AFFINITY_DMG     = 348;
SET @MOD_WIND_AFFINITY_DMG    = 349;
SET @MOD_EARTH_AFFINITY_DMG   = 350;
SET @MOD_THUNDER_AFFINITY_DMG = 351;
SET @MOD_WATER_AFFINITY_DMG   = 352;
SET @MOD_LIGHT_AFFINITY_DMG   = 353;
SET @MOD_DARK_AFFINITY_DMG    = 354;
SET @MOD_CHARM_TIME           = 360;
SET @MOD_JUMP_ATT_BONUS       = 362;
SET @MOD_REWARD_BONUS         = 364;

SET @MOD_ITEM_ADDEFFECT_TYPE     = 431;
SET @MOD_ITEM_SUBEFFECT          = 499;
SET @MOD_ITEM_ADDEFFECT_DMG      = 500;
SET @MOD_ITEM_ADDEFFECT_CHANCE   = 501;
SET @MOD_LIGHT_AFFINITY_PERP     = 559;
SET @MOD_ITEM_ADDEFFECT_ELEMENT  = 950;
SET @MOD_ITEM_ADDEFFECT_STATUS   = 951;
SET @MOD_ITEM_ADDEFFECT_DURATION = 953;

SET @MOD_REGEN_DURATION = 339;
SET @MOD_DAY_REDUCTION  = 373;
SET @MOD_STEP_ACCURACY  = 403;

SET @MOD_LULLABY_EFFECT         = 440;
SET @MOD_BALLAD_EFFECT          = 442;
SET @MOD_SONG_DURATION_BONUS    = 454;

SET @MOD_GRIMOIRE_SPELLCASTING = 489;
SET @MOD_SAMBA_DURATION        = 490;
SET @MOD_WALTZ_POTENCY         = 491;

SET @MOD_PHALANX            = 301;
SET @MOD_AVATAR_PERP        = 346;
SET @MOD_BP_DELAY           = 357;
SET @MOD_SNAP_SHOT          = 365;
SET @MOD_RAPID_SHOT         = 359;
SET @MOD_REFRESH            = 369;
SET @MOD_REGEN              = 370;
SET @MOD_CURE_POTENCY       = 374;
SET @MOD_HASTE              = 384;
SET @MOD_WEAPON_BASH        = 392;
SET @MOD_SUBLIMATION_BONUS  = 401;
SET @MOD_QUICK_DRAW_DMG     = 411;
SET @MOD_RETALIATION        = 414;
SET @MOD_CRITICAL_DMG       = 421;
SET @MOD_SHADOWBIND_EXT     = 425;
SET @MOD_ENSPELL_DMG_BONUS  = 432;
SET @MOD_ALL_SONGS          = 452;
SET @MOD_MAG_BURST_BONUS    = 487;
SET @MOD_JIG_DURATION       = 492;
SET @MOD_MANEUVER_BONUS     = 504;
SET @MOD_OVERLOAD_THRESH    = 505;
SET @MOD_ABSORB_DMG_TO_MP   = 516;
SET @MOD_CURE_CAST_TIME     = 519;
SET @MOD_ROLL_RANGE         = 528;

SET @MOD_ELEMENTAL_SIPHON     = 540;
SET @MOD_FIRE_AFFINITY_ACC    = 544;
SET @MOD_ICE_AFFINITY_ACC     = 545;
SET @MOD_WIND_AFFINITY_ACC    = 546;
SET @MOD_EARTH_AFFINITY_ACC   = 547;
SET @MOD_THUNDER_AFFINITY_ACC = 548;
SET @MOD_WATER_AFFINITY_ACC   = 549;
SET @MOD_LIGHT_AFFINITY_ACC   = 550;
SET @MOD_DARK_AFFINITY_ACC    = 551;
SET @MOD_DODGE_EFFECT         = 552;
SET @MOD_FOCUS_EFFECT         = 561;
SET @MOD_IRIDESCENCE          = 566;

SET @MOD_WYVERN_BREATH        = 829;
SET @MOD_REPAIR_EFFECT        = 853;
SET @MOD_REPAIR_POTENCY       = 854;
SET @MOD_HOLY_CIRCLE_DUR      = 857;
SET @MOD_ARCANE_CIR_DUR       = 858;
SET @MOD_ANCIENT_CIR_DUR      = 859;
SET @MOD_CURE2MP_PERCENT      = 860;
SET @MOD_HIDE_DURATION        = 885;
SET @MOD_ENH_MAGIC_DURATION   = 890;
SET @MOD_GILFINDER            = 897;
SET @MOD_ELEMENTAL_CELERITY   = 901;
SET @MOD_OCCULT_ACUMEN        = 902;
SET @MOD_FENCER_TP_BONUS      = 903;
SET @MOD_FENCER_CRITHITRATE   = 904;
SET @MOD_BLOOD_BOON           = 913;
SET @MOD_BLUE_LEARN_CHANCE    = 945;
SET @MOD_BERSERK_DURATION     = 954;
SET @MOD_AGGRESSOR_DURATION   = 955;
SET @MOD_CARDINAL_CHANT       = 959;
SET @MOD_COVER_MAGIC          = 966;
SET @MOD_ENHANCES_PRO_SHELL   = 977;
SET @MOD_OCCASIONALLY_ATTACKS = 978;
SET @MOD_LUOPAN_DMG_TAKEN     = 990;
SET @MOD_PET_MAB_MDB          = 992;
SET @MOD_TRIPLE_SHOT_RATE     = 999;
SET @MOD_VALLIANCE_VALLATION  = 1010;
SET @MOD_ENHANCE_PFLUG        = 1011;
SET @MOD_ENHANCE_GAMBIT       = 1018;
SET @MOD_CHAKRA_MULT          = 1026;
SET @MOD_CHAKRA_REMOVAL       = 1027;
SET @MOD_LIFE_CYCLE           = 1029;
SET @MOD_ARCANE_CIR_POT       = 1069;

SET @PETMOD_HPP           = 3;
SET @PETMOD_MPP           = 5;
SET @PETMOD_ATT           = 23;
SET @PETMOD_RATT          = 24;
SET @PETMOD_ACC           = 25;
SET @PETMOD_RACC          = 26;
SET @PETMOD_AVATAR_ENMITY = 27;
SET @PETMOD_AVATAR_EVA    = 68;
SET @PETMOD_AUTO_HHP      = 71;
SET @PETMOD_AUTO_HMP      = 72;
SET @PETMOD_DAMAGE_TAKEN  = 160;
SET @PETMOD_CRIT_HIT_RATE = 165;
SET @PETMOD_DOUBLE_ATTACK = 288;
SET @PETMOD_REGEN         = 370;
SET @PETMOD_AUTO_CURE_POT = 374;
SET @PETMOD_HASTE         = 384;

-----------------------------------
-- Warrior
-----------------------------------
SET @FIGHTERS_MASK_P2     = 23040;
SET @FIGHTERS_LORICA_P2   = 23107;
SET @FIGHTERS_MUFFLERS_P2 = 23174;
SET @FIGHTERS_CUISSES_P2  = 23241;
SET @FIGHTERS_CALLIGAE_P2 = 23308;

UPDATE `item_basic` SET name = 'fighters_mask_+2',     sortname = 'fighters_mask_+2'     WHERE itemId = @FIGHTERS_MASK_P2;
UPDATE `item_basic` SET name = 'fighters_lorica_+2',   sortname = 'fighters_lorica_+2'   WHERE itemId = @FIGHTERS_LORICA_P2;
UPDATE `item_basic` SET name = 'fighters_mufflers_+2', sortname = 'fighters_mufflers_+2' WHERE itemId = @FIGHTERS_MUFFLERS_P2;
UPDATE `item_basic` SET name = 'fighters_cuissses_+2', sortname = 'fighters_cuisses_+2'  WHERE itemId = @FIGHTERS_CUISSES_P2;
UPDATE `item_basic` SET name = 'fighters_calligae_+2', sortname = 'fighters_calligae_+2' WHERE itemId = @FIGHTERS_CALLIGAE_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@FIGHTERS_MASK_P2, @FIGHTERS_LORICA_P2, @FIGHTERS_MUFFLERS_P2, @FIGHTERS_CUISSES_P2, @FIGHTERS_CALLIGAE_P2);
DELETE FROM `item_mods` WHERE itemId IN (@FIGHTERS_MASK_P2, @FIGHTERS_LORICA_P2, @FIGHTERS_MUFFLERS_P2, @FIGHTERS_CUISSES_P2, @FIGHTERS_CALLIGAE_P2);

INSERT INTO `item_mods` VALUES
    (@FIGHTERS_MASK_P2,     @MOD_DEF,              30), -- 28
    (@FIGHTERS_MASK_P2,     @MOD_HP,               20), -- 15
    (@FIGHTERS_MASK_P2,     @MOD_DEX,               6), -- 5
    (@FIGHTERS_MASK_P2,     @MOD_VIT,               6), -- 5
    (@FIGHTERS_MASK_P2,     @MOD_ENMITY,            3), -- 1
    (@FIGHTERS_MASK_P2,     @MOD_HMP,               3), -- 1
    --
    (@FIGHTERS_MASK_P2,     @MOD_CRIT_HIT_RATE,     3), -- 3
    (@FIGHTERS_MASK_P2,     @MOD_HASTE,           500), -- 500

    (@FIGHTERS_LORICA_P2,   @MOD_DEF,              52), -- 50
    (@FIGHTERS_LORICA_P2,   @MOD_HP,               25), -- 20
    (@FIGHTERS_LORICA_P2,   @MOD_VIT,              10), -- 7
    (@FIGHTERS_LORICA_P2,   @MOD_ATT,              15), -- 10
    --
    (@FIGHTERS_LORICA_P2,   @MOD_ENMITY,           15), -- 14
    (@FIGHTERS_LORICA_P2,   @MOD_PHYS_DMG_TAKEN, -400), -- -400

    (@FIGHTERS_MUFFLERS_P2, @MOD_DEF,              24), -- 22
    (@FIGHTERS_MUFFLERS_P2, @MOD_HP,               18), -- 13
    (@FIGHTERS_MUFFLERS_P2, @MOD_STR,               8), -- 6
    (@FIGHTERS_MUFFLERS_P2, @MOD_HASTE,           200), -- N/A
    (@FIGHTERS_MUFFLERS_P2, @MOD_SHIELD_SKILL,     20), -- 15
    --
    (@FIGHTERS_MUFFLERS_P2, @MOD_ENMITY,           10), -- 9
    (@FIGHTERS_MUFFLERS_P2, @MOD_PHYS_DMG_TAKEN, -400), -- -300

    (@FIGHTERS_CUISSES_P2,  @MOD_DEF,              41), -- 39
    (@FIGHTERS_CUISSES_P2,  @MOD_HP,               20), -- 15
    (@FIGHTERS_CUISSES_P2,  @MOD_ACC,               8), -- 5
    (@FIGHTERS_CUISSES_P2,  @MOD_EVA,               8), -- 5
    (@FIGHTERS_CUISSES_P2,  @MOD_ENMITY,           10), -- 9
    --
    (@FIGHTERS_CUISSES_P2,  @MOD_HMP,               4), -- 2
    (@FIGHTERS_CUISSES_P2,  @MOD_PHYS_DMG_TAKEN, -400), -- -300

    (@FIGHTERS_CALLIGAE_P2, @MOD_DEF,              21), -- 19
    (@FIGHTERS_CALLIGAE_P2, @MOD_HP,               15), -- 12
    (@FIGHTERS_CALLIGAE_P2, @MOD_VIT,               5), -- 3
    (@FIGHTERS_CALLIGAE_P2, @MOD_AGI,               5), -- 3
    (@FIGHTERS_CALLIGAE_P2, @MOD_HASTE,           200), -- N/A
    (@FIGHTERS_CALLIGAE_P2, @MOD_DOUBLE_ATK,        4), -- 4
    --
    (@FIGHTERS_CALLIGAE_P2, @MOD_ENMITY,            3), -- 1
    (@FIGHTERS_CALLIGAE_P2, @MOD_STORE_TP,          6); -- 6

-----------------------------------
-- Monk
-----------------------------------
SET @TEMPLE_CROWN_P2   = 23041;
SET @TEMPLE_CYCLAS_P2  = 23108;
SET @TEMPLE_GLOVES_P2  = 23175;
SET @TEMPLE_HOSE_P2    = 23242;
SET @TEMPLE_GAITERS_P2 = 23309;

UPDATE `item_basic` SET name = 'temple_crown_+2',   sortname = 'temple_crown_+2'   WHERE itemId = @TEMPLE_CROWN_P2;
UPDATE `item_basic` SET name = 'temple_cyclas_+2',  sortname = 'temple_cyclas_+2'  WHERE itemId = @TEMPLE_CYCLAS_P2;
UPDATE `item_basic` SET name = 'temple_gloves_+2',  sortname = 'temple_gloves_+2'  WHERE itemId = @TEMPLE_GLOVES_P2;
UPDATE `item_basic` SET name = 'temple_hose_+2',    sortname = 'temple_hose_+2'    WHERE itemId = @TEMPLE_HOSE_P2;
UPDATE `item_basic` SET name = 'temple_gaiters_+2', sortname = 'temple_gaiters_+2' WHERE itemId = @TEMPLE_GAITERS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@TEMPLE_CROWN_P2, @TEMPLE_CYCLAS_P2, @TEMPLE_GLOVES_P2, @TEMPLE_HOSE_P2, @TEMPLE_GAITERS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@TEMPLE_CROWN_P2, @TEMPLE_CYCLAS_P2, @TEMPLE_GLOVES_P2, @TEMPLE_HOSE_P2, @TEMPLE_GAITERS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@TEMPLE_CROWN_P2,       @MOD_DEF,              25), -- 23
    (@TEMPLE_CROWN_P2,       @MOD_HP,               22), -- 16
    (@TEMPLE_CROWN_P2,       @MOD_MND,              10), -- 8
    (@TEMPLE_CROWN_P2,       @MOD_FOCUS_EFFECT,     15), -- 10
    (@TEMPLE_CROWN_P2,       @MOD_HHP,               3), -- 1
    --
    (@TEMPLE_CROWN_P2,       @MOD_CRIT_HIT_RATE,     5), -- 3
    (@TEMPLE_CROWN_P2,       @MOD_HASTE,           500), -- 5

    -- Body
    (@TEMPLE_CYCLAS_P2,      @MOD_DEF,              48), -- 44
    (@TEMPLE_CYCLAS_P2,      @MOD_HP,               25), -- 20
    (@TEMPLE_CYCLAS_P2,      @MOD_STR,              10), -- 6
    (@TEMPLE_CYCLAS_P2,      @MOD_VIT,              10), -- 6
    (@TEMPLE_CYCLAS_P2,      @MOD_ACC,               7), -- 5
    (@TEMPLE_CYCLAS_P2,      @MOD_CHAKRA_MULT,      12), -- 10
    (@TEMPLE_CYCLAS_P2,      @MOD_CHAKRA_REMOVAL,    2), -- 1
    --
    (@TEMPLE_CYCLAS_P2,      @MOD_MARTIAL_ARTS,      5), -- 2
    (@TEMPLE_CYCLAS_P2,      @MOD_STORE_TP,          7), -- 5

    -- Hands
    (@TEMPLE_GLOVES_P2,      @MOD_DEF,              17), -- 15
    (@TEMPLE_GLOVES_P2,      @MOD_HP,               18), -- 14
    (@TEMPLE_GLOVES_P2,      @MOD_STR,              10), -- 6
    (@TEMPLE_GLOVES_P2,      @MOD_BOOST_EFFECT,     65), -- 55
    (@TEMPLE_GLOVES_P2,      @MOD_SUBTLE_BLOW,       6), -- 4
    --
    (@TEMPLE_GLOVES_P2,      @MOD_DOUBLE_ATK,        3), -- 3
    (@TEMPLE_GLOVES_P2,      @MOD_HASTE,           400), -- 3

    -- Legs
    (@TEMPLE_HOSE_P2,        @MOD_DEF,              35), -- 31
    (@TEMPLE_HOSE_P2,        @MOD_HP,               22), -- 18
    (@TEMPLE_HOSE_P2,        @MOD_MND,               7), -- 4
    (@TEMPLE_HOSE_P2,        @MOD_GUARD_SKILL,      18), -- 15
    (@TEMPLE_HOSE_P2,        @MOD_COUNTER,           5), -- 3
    --
    (@TEMPLE_HOSE_P2,        @MOD_VIT,              13), -- 11
    (@TEMPLE_HOSE_P2,        @MOD_STR,              13), -- 11

    -- Feet
    (@TEMPLE_GAITERS_P2,     @MOD_DEF,              18), -- 15
    (@TEMPLE_GAITERS_P2,     @MOD_HP,               15), -- 12
    (@TEMPLE_GAITERS_P2,     @MOD_DEX,               7), -- 5
    (@TEMPLE_GAITERS_P2,     @MOD_MND,               7), -- 5
    (@TEMPLE_GAITERS_P2,     @MOD_EVA,              12), -- 10
    (@TEMPLE_GAITERS_P2,     @MOD_DODGE_EFFECT,     15), -- 10
    --
    (@TEMPLE_GAITERS_P2,     @MOD_MOD_KICK_RATE,     8), -- 5
    (@TEMPLE_GAITERS_P2,     @MOD_HASTE,           400); -- 3

-----------------------------------
-- White Mage
-----------------------------------
SET @HEALERS_CAP_P2        = 23042;
SET @HEALERS_BRIAULT_P2    = 23109;
SET @HEALERS_MITTS_P2      = 23176;
SET @HEALERS_PANTALOONS_P2 = 23243;
SET @HEALERS_DUCKBILLS_P2  = 23310;

UPDATE `item_basic` SET name = 'healers_cap_+2',        sortname = 'healers_cap_+2'        WHERE itemId = @HEALERS_CAP_P2;
UPDATE `item_basic` SET name = 'healers_briault_+2',    sortname = 'healers_briault_+2'    WHERE itemId = @HEALERS_BRIAULT_P2;
UPDATE `item_basic` SET name = 'healers_mitts_+2',      sortname = 'healers_mitts_+2'      WHERE itemId = @HEALERS_MITTS_P2;
UPDATE `item_basic` SET name = 'healers_pantaloons_+2', sortname = 'healers_pantaloons_+2' WHERE itemId = @HEALERS_PANTALOONS_P2;
UPDATE `item_basic` SET name = 'healers_duckbills_+2',  sortname = 'healers_duckbills_+2'  WHERE itemId = @HEALERS_DUCKBILLS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@HEALERS_CAP_P2, @HEALERS_BRIAULT_P2, @HEALERS_MITTS_P2, @HEALERS_PANTALOONS_P2, @HEALERS_DUCKBILLS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@HEALERS_CAP_P2, @HEALERS_BRIAULT_P2, @HEALERS_MITTS_P2, @HEALERS_PANTALOONS_P2, @HEALERS_DUCKBILLS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@HEALERS_CAP_P2,            @MOD_DEF,              28), -- 23
    (@HEALERS_CAP_P2,            @MOD_MP,               35), -- 28
    (@HEALERS_CAP_P2,            @MOD_MND,              10), -- 7
    (@HEALERS_CAP_P2,            @MOD_ENMITY,           -2), -- -1
    (@HEALERS_CAP_P2,            @MOD_HMP,               5), -- 4
    --
    (@HEALERS_CAP_P2,            @MOD_REFRESH,           1), -- 1
    (@HEALERS_CAP_P2,            @MOD_CURE_POTENCY,      4), -- N/A

    -- Body
    (@HEALERS_BRIAULT_P2,        @MOD_DEF,              44), -- 40
    (@HEALERS_BRIAULT_P2,        @MOD_MP,               65), -- 53 (Combined base and augment stats)
    (@HEALERS_BRIAULT_P2,        @MOD_ENMITY,           -5), -- -4
    (@HEALERS_BRIAULT_P2,        @MOD_HMP,               7), -- 5
    (@HEALERS_BRIAULT_P2,        @MOD_ENFEEBLE_SKILL,   15), -- 12
    --
    (@HEALERS_BRIAULT_P2,        @MOD_DAMAGE_TAKEN,     -7), -- 5

    -- Hands
    (@HEALERS_MITTS_P2,          @MOD_DEF,              17), -- 14
    (@HEALERS_MITTS_P2,          @MOD_MP,               20), -- 15
    (@HEALERS_MITTS_P2,          @MOD_STR,              10), -- 7
    (@HEALERS_MITTS_P2,          @MOD_MND,              10), -- 7
    (@HEALERS_MITTS_P2,          @MOD_ENMITY,           -5), -- -4
    (@HEALERS_MITTS_P2,          @MOD_HEALING_SKILL,    17), -- 15
    --
    (@HEALERS_MITTS_P2,          @MOD_CURE_POTENCY,      5), -- 3
    (@HEALERS_MITTS_P2,          @MOD_CONSERVE_MP,       7), -- 5

    -- Legs
    (@HEALERS_PANTALOONS_P2,     @MOD_DEF,              32), -- 28
    (@HEALERS_PANTALOONS_P2,     @MOD_MP,               35), -- 30
    (@HEALERS_PANTALOONS_P2,     @MOD_VIT,               8), -- 5
    (@HEALERS_PANTALOONS_P2,     @MOD_ENMITY,           -2), -- -2
    (@HEALERS_PANTALOONS_P2,     @MOD_DIVINE_SKILL,     17), -- 15
    --
    (@HEALERS_PANTALOONS_P2,     @MOD_MACC,             7), -- 5
    (@HEALERS_PANTALOONS_P2,     @MOD_CURE_CAST_TIME,    5), -- 3

    -- Feet
    (@HEALERS_DUCKBILLS_P2,      @MOD_DEF,              15), -- 12
    (@HEALERS_DUCKBILLS_P2,      @MOD_HP,               20), -- 15
    (@HEALERS_DUCKBILLS_P2,      @MOD_AGI,               8), -- 5
    (@HEALERS_DUCKBILLS_P2,      @MOD_INT,               8), -- 5
    (@HEALERS_DUCKBILLS_P2,      @MOD_SPELL_INTERRUPT,  30), -- 25
    --
    (@HEALERS_DUCKBILLS_P2,      @MOD_MP,               55), -- 54
    (@HEALERS_DUCKBILLS_P2,      @MOD_HMP,               5); -- 4

-----------------------------------
-- Black Mage
-----------------------------------
SET @WIZARDS_PETASOS_P2 = 23043;
SET @WIZARDS_COAT_P2    = 23110;
SET @WIZARDS_GLOVES_P2  = 23177;
SET @WIZARDS_TONBAN_P2  = 23244;
SET @WIZARDS_SABOTS_P2  = 23311;

UPDATE `item_basic` SET name = 'wizards_petasos_+2', sortname = 'wizards_petasos_+2' WHERE itemId = @WIZARDS_PETASOS_P2;
UPDATE `item_basic` SET name = 'wizards_coat_+2',    sortname = 'wizards_coat_+2'    WHERE itemId = @WIZARDS_COAT_P2;
UPDATE `item_basic` SET name = 'wizards_gloves_+2',  sortname = 'wizards_gloves_+2'  WHERE itemId = @WIZARDS_GLOVES_P2;
UPDATE `item_basic` SET name = 'wizards_tonban_+2',  sortname = 'wizards_tonban_+2'  WHERE itemId = @WIZARDS_TONBAN_P2;
UPDATE `item_basic` SET name = 'wizards_sabots_+2',  sortname = 'wizards_sabots_+2'  WHERE itemId = @WIZARDS_SABOTS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@WIZARDS_PETASOS_P2, @WIZARDS_COAT_P2, @WIZARDS_GLOVES_P2, @WIZARDS_TONBAN_P2, @WIZARDS_SABOTS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@WIZARDS_PETASOS_P2, @WIZARDS_COAT_P2, @WIZARDS_GLOVES_P2, @WIZARDS_TONBAN_P2, @WIZARDS_SABOTS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@WIZARDS_PETASOS_P2,     @MOD_DEF,              24), -- 20
    (@WIZARDS_PETASOS_P2,     @MOD_MP,               35), -- 30
    (@WIZARDS_PETASOS_P2,     @MOD_INT,               8), -- 5
    (@WIZARDS_PETASOS_P2,     @MOD_ENMITY,           -5), -- -4
    (@WIZARDS_PETASOS_P2,     @MOD_HMP,               5), -- 4 (Combined Base/Augment Stats)
    --
    (@WIZARDS_PETASOS_P2,     @MOD_REFRESH,           1), -- 1

    -- Body
    (@WIZARDS_COAT_P2,        @MOD_DEF,              42), -- 38
    (@WIZARDS_COAT_P2,        @MOD_MP,               55), -- 54
    (@WIZARDS_COAT_P2,        @MOD_ENMITY,           -6), -- -5
    (@WIZARDS_COAT_P2,        @MOD_HMP,               6), -- 5
    (@WIZARDS_COAT_P2,        @MOD_ENFEEBLE_SKILL,   14), -- 12
    --
    (@WIZARDS_COAT_P2,        @MOD_ELEMENTAL_SKILL,   3), -- N/A
    (@WIZARDS_COAT_P2,        @MOD_MACC,              7), -- 5

    -- Hands
    (@WIZARDS_GLOVES_P2,      @MOD_DEF,              16), -- 13
    (@WIZARDS_GLOVES_P2,      @MOD_MP,               20), -- 17
    (@WIZARDS_GLOVES_P2,      @MOD_INT,               5), -- 3
    (@WIZARDS_GLOVES_P2,      @MOD_CHR,               5), -- 3
    (@WIZARDS_GLOVES_P2,      @MOD_ENMITY,           -2), -- -2
    (@WIZARDS_GLOVES_P2,      @MOD_ELEMENTAL_SKILL,  17), -- 15
    --
    (@WIZARDS_GLOVES_P2,      @MOD_MATT,              6), -- 5
    (@WIZARDS_GLOVES_P2,      @MOD_CONSERVE_MP,       7), -- 5

    -- Legs
    (@WIZARDS_TONBAN_P2,      @MOD_DEF,              30), -- 27
    (@WIZARDS_TONBAN_P2,      @MOD_MP,               24), -- 19
    (@WIZARDS_TONBAN_P2,      @MOD_ENMITY,           -2), -- -2
    (@WIZARDS_TONBAN_P2,      @MOD_HMP,               2), -- 1
    (@WIZARDS_TONBAN_P2,      @MOD_DARK_SKILL,       17), -- 15
    --
    (@WIZARDS_TONBAN_P2,      @MOD_MACC,              7), -- 5
    (@WIZARDS_TONBAN_P2,      @MOD_DRAIN_ASPIR_POT,   7), -- 5

    -- Feet
    (@WIZARDS_SABOTS_P2,      @MOD_DEF,              13), -- 11
    (@WIZARDS_SABOTS_P2,      @MOD_MP,               60), -- 54 (Combined base and augment stats)
    (@WIZARDS_SABOTS_P2,      @MOD_AGI,               7), -- 5
    (@WIZARDS_SABOTS_P2,      @MOD_MND,               7), -- 5
    (@WIZARDS_SABOTS_P2,      @MOD_SPELL_INTERRUPT,  22), -- 20
    --
    (@WIZARDS_SABOTS_P2,      @MOD_HMP,               5); -- 3

-----------------------------------
-- Red Mage
-----------------------------------
SET @WARLOCKS_CHAPEAU_P2 = 23044;
SET @WARLOCKS_TABARD_P2  = 23111;
SET @WARLOCKS_GLOVES_P2  = 23178;
SET @WARLOCKS_TIGHTS_P2  = 23245;
SET @WARLOCKS_BOOTS_P2   = 23312;

UPDATE `item_basic` SET name = 'warlocks_chapeau_+2', sortname = 'warlocks_chapeau_+2' WHERE itemId = @WARLOCKS_CHAPEAU_P2;
UPDATE `item_basic` SET name = 'warlocks_tabard_+2',  sortname = 'warlocks_tabard_+2'  WHERE itemId = @WARLOCKS_TABARD_P2;
UPDATE `item_basic` SET name = 'warlocks_gloves_+2',  sortname = 'warlocks_gloves_+2'  WHERE itemId = @WARLOCKS_GLOVES_P2;
UPDATE `item_basic` SET name = 'warlocks_tights_+2',  sortname = 'warlocks_tights_+2'  WHERE itemId = @WARLOCKS_TIGHTS_P2;
UPDATE `item_basic` SET name = 'warlocks_boots_+2',   sortname = 'warlocks_boots_+2'   WHERE itemId = @WARLOCKS_BOOTS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@WARLOCKS_CHAPEAU_P2, @WARLOCKS_TABARD_P2, @WARLOCKS_GLOVES_P2, @WARLOCKS_TIGHTS_P2, @WARLOCKS_BOOTS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@WARLOCKS_CHAPEAU_P2, @WARLOCKS_TABARD_P2, @WARLOCKS_GLOVES_P2, @WARLOCKS_TIGHTS_P2, @WARLOCKS_BOOTS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@WARLOCKS_CHAPEAU_P2,     @MOD_DEF,              28), -- 24
    (@WARLOCKS_CHAPEAU_P2,     @MOD_MP,               30), -- 25
    (@WARLOCKS_CHAPEAU_P2,     @MOD_INT,               8), -- 5
    (@WARLOCKS_CHAPEAU_P2,     @MOD_ELEMENTAL_SKILL,  12), -- 10
    (@WARLOCKS_CHAPEAU_P2,     @MOD_FASTCAST,         12), -- 10
    --
    (@WARLOCKS_CHAPEAU_P2,     @MOD_MATT,              8), -- 6
    (@WARLOCKS_CHAPEAU_P2,     @MOD_CONSERVE_MP,       7), -- 5

    -- Body
    (@WARLOCKS_TABARD_P2,      @MOD_DEF,              48), -- 44
    (@WARLOCKS_TABARD_P2,      @MOD_MP,               60), -- 55 (Combined base and augment stats)
    (@WARLOCKS_TABARD_P2,      @MOD_HMP,               7), -- 5
    (@WARLOCKS_TABARD_P2,      @MOD_ENFEEBLE_SKILL,   17), -- 15
    (@WARLOCKS_TABARD_P2,      @MOD_SPELL_INTERRUPT,  15), -- 12
    --
    (@WARLOCKS_TABARD_P2,      @MOD_MACC,              7), -- 5

    -- Hands
    (@WARLOCKS_GLOVES_P2,      @MOD_DEF,              21), -- 17
    (@WARLOCKS_GLOVES_P2,      @MOD_MP,               21), -- 17
    (@WARLOCKS_GLOVES_P2,      @MOD_DEX,               8), -- 6
    (@WARLOCKS_GLOVES_P2,      @MOD_INT,               4), -- 2
    (@WARLOCKS_GLOVES_P2,      @MOD_MND,               4), -- 2
    (@WARLOCKS_GLOVES_P2,      @MOD_PARRY_SKILL,      18), -- 15
    --
    (@WARLOCKS_GLOVES_P2,      @MOD_DOUBLE_ATK,        3), -- 3
    (@WARLOCKS_GLOVES_P2,      @MOD_HASTE,           400), -- 3

    -- Legs
    (@WARLOCKS_TIGHTS_P2,      @MOD_DEF,              37), -- 33
    (@WARLOCKS_TIGHTS_P2,      @MOD_MP,               55), -- 54
    (@WARLOCKS_TIGHTS_P2,      @MOD_MND,               8), -- 5
    (@WARLOCKS_TIGHTS_P2,      @MOD_HEALING_SKILL,    12), -- 10
    (@WARLOCKS_TIGHTS_P2,      @MOD_ENHANCE_SKILL,    17), -- 15
    --
    (@WARLOCKS_TIGHTS_P2,      @MOD_SHIELD_SKILL,     10), -- N/A
    (@WARLOCKS_TIGHTS_P2,      @MOD_CURE_POTENCY,     10), -- 6

    -- Feet
    (@WARLOCKS_BOOTS_P2,       @MOD_DEF,              30), -- 15
    (@WARLOCKS_BOOTS_P2,       @MOD_MP,               60), -- 55
    (@WARLOCKS_BOOTS_P2,       @MOD_AGI,               5), -- 3
    (@WARLOCKS_BOOTS_P2,       @MOD_INT,               5), -- 3
    (@WARLOCKS_BOOTS_P2,       @MOD_MND,               5), -- 3
    (@WARLOCKS_BOOTS_P2,       @MOD_HASTE,           200), -- N/A
    (@WARLOCKS_BOOTS_P2,       @MOD_SHIELD_SKILL,     12), -- 10
    --
    (@WARLOCKS_BOOTS_P2,       @MOD_SWORD_SKILL,      12), -- 10
    (@WARLOCKS_BOOTS_P2,       @MOD_HMP,               7); -- 5

-----------------------------------
-- Thief
-----------------------------------
SET @ROGUES_BONNET_P2    = 23045;
SET @ROGUES_VEST_P2      = 23112;
SET @ROGUES_ARMLETS_P2   = 23179;
SET @ROGUES_CULOTTES_P2  = 23246;
SET @ROGUES_POULAINES_P2 = 23313;

UPDATE `item_basic` SET name = 'rogues_bonnet_+2',    sortname = 'rogues_bonnet_+2'    WHERE itemId = @ROGUES_BONNET_P2;
UPDATE `item_basic` SET name = 'rogues_vest_+2',      sortname = 'rogues_vest_+2'      WHERE itemId = @ROGUES_VEST_P2;
UPDATE `item_basic` SET name = 'rogues_armlets_+2',   sortname = 'rogues_armlets_+2'   WHERE itemId = @ROGUES_ARMLETS_P2;
UPDATE `item_basic` SET name = 'rogues_culottes_+2',  sortname = 'rogues_culottes_+2'  WHERE itemId = @ROGUES_CULOTTES_P2;
UPDATE `item_basic` SET name = 'rogues_poulaines_+2', sortname = 'rogues_poulaines_+2' WHERE itemId = @ROGUES_POULAINES_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@ROGUES_BONNET_P2, @ROGUES_VEST_P2, @ROGUES_ARMLETS_P2, @ROGUES_CULOTTES_P2, @ROGUES_POULAINES_P2);
DELETE FROM `item_mods` WHERE itemId IN (@ROGUES_BONNET_P2, @ROGUES_VEST_P2, @ROGUES_ARMLETS_P2, @ROGUES_CULOTTES_P2, @ROGUES_POULAINES_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@ROGUES_BONNET_P2,        @MOD_DEF,              28), -- 24
    (@ROGUES_BONNET_P2,        @MOD_HP,               18), -- 13
    (@ROGUES_BONNET_P2,        @MOD_DEX,               5), -- 3
    (@ROGUES_BONNET_P2,        @MOD_RACC,             10), -- 8
    (@ROGUES_BONNET_P2,        @MOD_EVA,              12), -- 10
    --
    (@ROGUES_BONNET_P2,        @MOD_CRIT_HIT_RATE,     4), -- 3
    (@ROGUES_BONNET_P2,        @MOD_HASTE,           500), -- 5

    -- Body
    (@ROGUES_VEST_P2,          @MOD_DEF,              50), -- 45
    (@ROGUES_VEST_P2,          @MOD_HP,               25), -- 20
    (@ROGUES_VEST_P2,          @MOD_STR,               8), -- 6
    (@ROGUES_VEST_P2,          @MOD_ACC,              12), -- 10
    (@ROGUES_VEST_P2,          @MOD_HIDE_DURATION,   120), -- 100
    --
    (@ROGUES_VEST_P2,          @MOD_DUAL_WIELD,        5), -- 3
    (@ROGUES_VEST_P2,          @MOD_TREASURE_HUNTER,   1), -- N/A

    -- Hands
    (@ROGUES_ARMLETS_P2,       @MOD_DEF,              20), -- 16
    (@ROGUES_ARMLETS_P2,       @MOD_HP,               15), -- 10
    (@ROGUES_ARMLETS_P2,       @MOD_DEX,               5), -- 3
    (@ROGUES_ARMLETS_P2,       @MOD_STEAL,             2), -- 1
    (@ROGUES_ARMLETS_P2,       @MOD_TRICK_ATK_AGI,    18), -- 15
    --
    (@ROGUES_ARMLETS_P2,       @MOD_HASTE,           400), -- 3
    (@ROGUES_ARMLETS_P2,       @MOD_TREASURE_HUNTER,   1), -- N/A

    -- Legs
    (@ROGUES_CULOTTES_P2,      @MOD_DEF,              38), -- 34
    (@ROGUES_CULOTTES_P2,      @MOD_HP,               20), -- 15
    (@ROGUES_CULOTTES_P2,      @MOD_DEX,               4), -- 2
    (@ROGUES_CULOTTES_P2,      @MOD_AGI,               6), -- 4
    (@ROGUES_CULOTTES_P2,      @MOD_STEAL,             2), -- 1
    --
    (@ROGUES_CULOTTES_P2,      @MOD_RACC,             10), -- 8
    (@ROGUES_CULOTTES_P2,      @MOD_RATT,             10), -- 8


    -- Feet
    (@ROGUES_POULAINES_P2,     @MOD_DEF,              18), -- 15
    (@ROGUES_POULAINES_P2,     @MOD_DEX,               5), -- 3
    (@ROGUES_POULAINES_P2,     @MOD_RACC,              8), -- 5
    (@ROGUES_POULAINES_P2,     @MOD_FLEE_DURATION,    20), -- 15
    (@ROGUES_POULAINES_P2,     @MOD_STEAL,             2), -- 2
    --
    (@ROGUES_POULAINES_P2,     @MOD_DOUBLE_ATK,        4), -- 3
    (@ROGUES_POULAINES_P2,     @MOD_HASTE,           300); -- 3

-----------------------------------
-- Paladin
-----------------------------------
SET @GALLANT_CORONET_P2   = 23046;
SET @GALLANT_SURCOAT_P2   = 23113;
SET @GALLANT_GAUNTLETS_P2 = 23180;
SET @GALLANT_BREECHES_P2  = 23247;
SET @GALLANT_LEGGINGS_P2  = 23314;

UPDATE `item_basic` SET name = 'gallant_coronet_+2',   sortname = 'gallant_coronet_+2'   WHERE itemId = @GALLANT_CORONET_P2;
UPDATE `item_basic` SET name = 'gallant_surcoat_+2',   sortname = 'gallant_surcoat_+2'   WHERE itemId = @GALLANT_SURCOAT_P2;
UPDATE `item_basic` SET name = 'gallant_gauntlets_+2', sortname = 'gallant_gauntlets_+2' WHERE itemId = @GALLANT_GAUNTLETS_P2;
UPDATE `item_basic` SET name = 'gallant_breeches_+2',  sortname = 'gallant_breeches_+2'  WHERE itemId = @GALLANT_BREECHES_P2;
UPDATE `item_basic` SET name = 'gallant_leggings_+2',  sortname = 'gallant_leggings_+2'  WHERE itemId = @GALLANT_LEGGINGS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@GALLANT_CORONET_P2, @GALLANT_SURCOAT_P2, @GALLANT_GAUNTLETS_P2, @GALLANT_BREECHES_P2, @GALLANT_LEGGINGS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@GALLANT_CORONET_P2, @GALLANT_SURCOAT_P2, @GALLANT_GAUNTLETS_P2, @GALLANT_BREECHES_P2, @GALLANT_LEGGINGS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@GALLANT_CORONET_P2,       @MOD_DEF,                33), -- 28
    (@GALLANT_CORONET_P2,       @MOD_HP,                 20), -- 12
    (@GALLANT_CORONET_P2,       @MOD_MND,                 8), -- 6
    (@GALLANT_CORONET_P2,       @MOD_HASTE,             400), -- N/A
    (@GALLANT_CORONET_P2,       @MOD_ENMITY,              4), -- 3
    (@GALLANT_CORONET_P2,       @MOD_COVER_MAGIC,         2), -- 1
    --
    (@GALLANT_CORONET_P2,       @MOD_DAMAGE_TAKEN,     -400), -- 3
    (@GALLANT_CORONET_P2,       @MOD_CURE_POTENCY,        7), -- N/A

    -- Body
    (@GALLANT_SURCOAT_P2,       @MOD_DEF,                58), -- 55
    (@GALLANT_SURCOAT_P2,       @MOD_HP,                 25), -- 20
    (@GALLANT_SURCOAT_P2,       @MOD_VIT,                 8), -- 6
    (@GALLANT_SURCOAT_P2,       @MOD_ENMITY,              3), -- 2
    (@GALLANT_SURCOAT_P2,       @MOD_DIVINE_SKILL,       10), -- 8
    --
    (@GALLANT_SURCOAT_P2,       @MOD_REFRESH,             1), -- 1 / Paladin's don't need any more refresh :)
    (@GALLANT_SURCOAT_P2,       @MOD_SHIELD_RATE,         5), -- 3

    -- Hands
    (@GALLANT_GAUNTLETS_P2,     @MOD_DEF,                25), -- 22
    (@GALLANT_GAUNTLETS_P2,     @MOD_HP,                 15), -- 11
    (@GALLANT_GAUNTLETS_P2,     @MOD_DEX,                 8), -- 6
    (@GALLANT_GAUNTLETS_P2,     @MOD_HASTE,             200), -- N/A
    (@GALLANT_GAUNTLETS_P2,     @MOD_VIT,                 5), -- 3
    (@GALLANT_GAUNTLETS_P2,     @MOD_ENMITY,              3), -- 2
    --
    (@GALLANT_GAUNTLETS_P2,     @MOD_MAGIC_DMG_TAKEN,  -500), -- -5
    (@GALLANT_GAUNTLETS_P2,     @MOD_ENEMYCRITRATE,      -4), -- -3

    -- Legs
    (@GALLANT_BREECHES_P2,      @MOD_DEF,                45), -- 43
    (@GALLANT_BREECHES_P2,      @MOD_HP,                 24), -- 20
    (@GALLANT_BREECHES_P2,      @MOD_AGI,                 8), -- 4
    (@GALLANT_BREECHES_P2,      @MOD_ENMITY,              3), -- 2
    (@GALLANT_BREECHES_P2,      @MOD_ENHANCE_SKILL,      12), -- 10
    --
    (@GALLANT_BREECHES_P2,      @MOD_SHIELD_MASTERY,      3), -- 2
    (@GALLANT_BREECHES_P2,      @MOD_SHIELD_SKILL,        7), -- 5

    -- Feet
    (@GALLANT_LEGGINGS_P2,      @MOD_DEF,                22), -- 19
    (@GALLANT_LEGGINGS_P2,      @MOD_HP,                 25), -- 20
    (@GALLANT_LEGGINGS_P2,      @MOD_CHR,                 7), -- 5
    (@GALLANT_LEGGINGS_P2,      @MOD_ACC,                 4), -- N/A
    (@GALLANT_LEGGINGS_P2,      @MOD_SHIELD_SKILL,       15), -- 12
    (@GALLANT_LEGGINGS_P2,      @MOD_HOLY_CIRCLE_DUR,   100), -- 90
    --
    (@GALLANT_LEGGINGS_P2,      @MOD_BREATH_DMG_TAKEN, -600), -- 5
    (@GALLANT_LEGGINGS_P2,      @MOD_MDEF,                3); -- 3

-----------------------------------
-- Dark Knight
-----------------------------------
SET @CHAOS_BURGEONET_P2 = 23047;
SET @CHAOS_CUIRASS_P2   = 23114;
SET @CHAOS_GAUNTLETS_P2 = 23181;
SET @CHAOS_FLANCHARD_P2 = 23248;
SET @CHAOS_SOLLERETS_P2 = 23315;

UPDATE `item_basic` SET name = 'chaos_burgeonet_+2', sortname = 'chaos_burgeonet_+2' WHERE itemId = @CHAOS_BURGEONET_P2;
UPDATE `item_basic` SET name = 'chaos_cuirass_+2',   sortname = 'chaos_cuirass_+2'   WHERE itemId = @CHAOS_CUIRASS_P2;
UPDATE `item_basic` SET name = 'chaos_gauntlets_+2', sortname = 'chaos_gauntlets_+2' WHERE itemId = @CHAOS_GAUNTLETS_P2;
UPDATE `item_basic` SET name = 'chaos_flanchard_+2', sortname = 'chaos_flanchard_+2' WHERE itemId = @CHAOS_FLANCHARD_P2;
UPDATE `item_basic` SET name = 'chaos_sollerets_+2', sortname = 'chaos_sollerets_+2' WHERE itemId = @CHAOS_SOLLERETS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@CHAOS_BURGEONET_P2, @CHAOS_CUIRASS_P2, @CHAOS_GAUNTLETS_P2, @CHAOS_FLANCHARD_P2, @CHAOS_SOLLERETS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@CHAOS_BURGEONET_P2, @CHAOS_CUIRASS_P2, @CHAOS_GAUNTLETS_P2, @CHAOS_FLANCHARD_P2, @CHAOS_SOLLERETS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@CHAOS_BURGEONET_P2,     @MOD_DEF,              30), -- 27
    (@CHAOS_BURGEONET_P2,     @MOD_HP,               16), -- 12
    (@CHAOS_BURGEONET_P2,     @MOD_MP,               15), -- 12
    (@CHAOS_BURGEONET_P2,     @MOD_STR,              10), -- 7
    (@CHAOS_BURGEONET_P2,     @MOD_SOULEATER,         3), -- 2
    (@CHAOS_BURGEONET_P2,     @MOD_DARK_SKILL,        8), -- 5
    --
    (@CHAOS_BURGEONET_P2,     @MOD_CRIT_HIT_RATE,     4), -- 3
    (@CHAOS_BURGEONET_P2,     @MOD_HASTE,           500), -- 5

    -- Body
    (@CHAOS_CUIRASS_P2,       @MOD_DEF,              53), -- 49
    (@CHAOS_CUIRASS_P2,       @MOD_HP,               25), -- 20
    (@CHAOS_CUIRASS_P2,       @MOD_MP,               25), -- 20
    (@CHAOS_CUIRASS_P2,       @MOD_STR,              10), -- 7
    (@CHAOS_CUIRASS_P2,       @MOD_VIT,              10), -- 7
    (@CHAOS_CUIRASS_P2,       @MOD_ATT,              18), -- 10
    (@CHAOS_CUIRASS_P2,       @MOD_ENFEEBLE_SKILL,    8), -- 5
    --
    (@CHAOS_CUIRASS_P2,       @MOD_REFRESH,           2), -- 1
    (@CHAOS_CUIRASS_P2,       @MOD_REGEN,             5), -- 3

    -- Hands
    (@CHAOS_GAUNTLETS_P2,     @MOD_DEF,              24), -- 20
    (@CHAOS_GAUNTLETS_P2,     @MOD_HP,               15), -- 11
    (@CHAOS_GAUNTLETS_P2,     @MOD_MP,               15), -- 11
    (@CHAOS_GAUNTLETS_P2,     @MOD_STR,               8), -- 6
    (@CHAOS_GAUNTLETS_P2,     @MOD_DEX,               8), -- 6
    (@CHAOS_GAUNTLETS_P2,     @MOD_ACC,               8), -- 3
    (@CHAOS_GAUNTLETS_P2,     @MOD_WEAPON_BASH,      12), -- 10
    --
    (@CHAOS_GAUNTLETS_P2,     @MOD_STORE_TP,          5), -- 5
    (@CHAOS_GAUNTLETS_P2,     @MOD_HASTE,           500), -- 5

    -- Legs
    (@CHAOS_FLANCHARD_P2,     @MOD_DEF,              41), -- 38
    (@CHAOS_FLANCHARD_P2,     @MOD_HP,               20), -- 15
    (@CHAOS_FLANCHARD_P2,     @MOD_MP,               20), -- 15
    (@CHAOS_FLANCHARD_P2,     @MOD_DEX,               8), -- 5
    (@CHAOS_FLANCHARD_P2,     @MOD_INT,              12), -- 10 (Combined base and augment stats)
    (@CHAOS_FLANCHARD_P2,     @MOD_EVA,               5), -- 5 / I don't think they need any more evasion...
    (@CHAOS_FLANCHARD_P2,     @MOD_PARRY_SKILL,      18), -- 15
    --
    (@CHAOS_FLANCHARD_P2,     @MOD_DRAIN_ASPIR_POT,   7), -- 5

    -- Feet
    (@CHAOS_SOLLERETS_P2,     @MOD_DEF,              22), -- 17
    (@CHAOS_SOLLERETS_P2,     @MOD_HP,               20), -- 15
    (@CHAOS_SOLLERETS_P2,     @MOD_MP,               20), -- 15
    (@CHAOS_SOLLERETS_P2,     @MOD_MND,               6), -- 5
    (@CHAOS_SOLLERETS_P2,     @MOD_ARCANE_CIR_DUR,   60), -- 50
    (@CHAOS_SOLLERETS_P2,     @MOD_ARCANE_CIR_POT,    4), -- 2
    --
    (@CHAOS_SOLLERETS_P2,     @MOD_DOUBLE_ATK,        4), -- 3
    (@CHAOS_SOLLERETS_P2,     @MOD_HASTE,           300); -- 3

-----------------------------------
-- Beastmaster
-----------------------------------
SET @BEAST_HELM_P2     = 23048;
SET @BEAST_JACKCOAT_P2 = 23115;
SET @BEAST_GLOVES_P2   = 23182;
SET @BEAST_TROUSERS_P2 = 23249;
SET @BEAST_GAITERS_P2  = 23316;

UPDATE `item_basic` SET name = 'beast_helm_+2',     sortname = 'beast_helm_+2'     WHERE itemId = @BEAST_HELM_P2;
UPDATE `item_basic` SET name = 'beast_jackcoat_+2', sortname = 'beast_jackcoat_+2' WHERE itemId = @BEAST_JACKCOAT_P2;
UPDATE `item_basic` SET name = 'beast_gloves_+2',   sortname = 'beast_gloves_+2'   WHERE itemId = @BEAST_GLOVES_P2;
UPDATE `item_basic` SET name = 'beast_trousers_+2', sortname = 'beast_trousers_+2' WHERE itemId = @BEAST_TROUSERS_P2;
UPDATE `item_basic` SET name = 'beast_gaiters_+2',  sortname = 'beast_gaiters_+2'  WHERE itemId = @BEAST_GAITERS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@BEAST_HELM_P2, @BEAST_JACKCOAT_P2, @BEAST_GLOVES_P2, @BEAST_TROUSERS_P2, @BEAST_GAITERS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@BEAST_HELM_P2, @BEAST_JACKCOAT_P2, @BEAST_GLOVES_P2, @BEAST_TROUSERS_P2, @BEAST_GAITERS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@BEAST_HELM_P2,         @MOD_DEF,              30), -- 26
    (@BEAST_HELM_P2,         @MOD_HP,               20), -- 15
    (@BEAST_HELM_P2,         @MOD_INT,              12), -- 8
    (@BEAST_HELM_P2,         @MOD_MND,              12), -- 8
    (@BEAST_HELM_P2,         @MOD_CHARM_TIME,        6), -- 4
    -- TODO: Item also has a mod to improve "tame" success, but we don't use in the +1 version.
    --
    (@BEAST_HELM_P2,         @MOD_HASTE,           600), -- 5

    -- Body
    (@BEAST_JACKCOAT_P2,     @MOD_DEF,              53), -- 49
    (@BEAST_JACKCOAT_P2,     @MOD_HP,               25), -- 20
    (@BEAST_JACKCOAT_P2,     @MOD_VIT,              10), -- 6
    (@BEAST_JACKCOAT_P2,     @MOD_CHARM_TIME,        8), -- 6
    --
    (@BEAST_JACKCOAT_P2,     @MOD_HASTE,           400), -- 3

    -- Hands
    (@BEAST_GLOVES_P2,       @MOD_DEF,              20), -- 15
    (@BEAST_GLOVES_P2,       @MOD_HP,               15), -- 11
    (@BEAST_GLOVES_P2,       @MOD_DEX,               8), -- 5
    (@BEAST_GLOVES_P2,       @MOD_CHR,               8), -- 5
    (@BEAST_GLOVES_P2,       @MOD_PARRY_SKILL,      15), -- 10
    (@BEAST_GLOVES_P2,       @MOD_CHARM_TIME,        5), -- 3
    --
    (@BEAST_GLOVES_P2,       @MOD_HASTE,           500), -- 5
    (@BEAST_GLOVES_P2,       @MOD_DOUBLE_ATK,        4), -- 3

    -- Legs
    (@BEAST_TROUSERS_P2,     @MOD_DEF,              37), -- 34
    (@BEAST_TROUSERS_P2,     @MOD_HP,               20), -- 15
    (@BEAST_TROUSERS_P2,     @MOD_STR,               8), -- 6
    (@BEAST_TROUSERS_P2,     @MOD_CHR,               8), -- 6
    (@BEAST_TROUSERS_P2,     @MOD_ATT,              15), -- N/A
    (@BEAST_TROUSERS_P2,     @MOD_VERMIN_KILLER,     1), -- 1
    (@BEAST_TROUSERS_P2,     @MOD_BIRD_KILLER,       1), -- 1
    (@BEAST_TROUSERS_P2,     @MOD_AMORPH_KILLER,     1), -- 1
    (@BEAST_TROUSERS_P2,     @MOD_LIZARD_KILLER,     1), -- 1
    (@BEAST_TROUSERS_P2,     @MOD_AQUAN_KILLER,      1), -- 1
    (@BEAST_TROUSERS_P2,     @MOD_PLANTOID_KILLER,   1), -- 1
    (@BEAST_TROUSERS_P2,     @MOD_BEAST_KILLER,      1), -- 1
    (@BEAST_TROUSERS_P2,     @MOD_CHARM_TIME,        8), -- 6
    --
    (@BEAST_TROUSERS_P2,     @MOD_HASTE,           500), -- 5

    -- Feet
    (@BEAST_GAITERS_P2,      @MOD_DEF,              17), -- 14
    (@BEAST_GAITERS_P2,      @MOD_HP,               15), -- 11
    (@BEAST_GAITERS_P2,      @MOD_AGI,               8), -- 5
    (@BEAST_GAITERS_P2,      @MOD_CHR,               8), -- 5
    (@BEAST_GAITERS_P2,      @MOD_ACC,               4), -- N/A
    (@BEAST_GAITERS_P2,      @MOD_CHARM_TIME,        4), -- 2
    (@BEAST_GAITERS_P2,      @MOD_REWARD_BONUS,     15), -- 11
    --
    (@BEAST_GAITERS_P2,      @MOD_HASTE,           500); -- 5

INSERT INTO `item_mods_pet` VALUES
    -- Pet Mods
    (@BEAST_HELM_P2,         @PETMOD_HASTE,            7, @PET_ALL), -- 5
    (@BEAST_JACKCOAT_P2,     @PETMOD_DAMAGE_TAKEN,  -700, @PET_ALL), -- 5
    (@BEAST_TROUSERS_P2,     @PETMOD_DOUBLE_ATTACK,    5, @PET_ALL), -- 4
    (@BEAST_TROUSERS_P2,     @PETMOD_CRIT_HIT_RATE,    5, @PET_ALL), -- 4
    (@BEAST_GAITERS_P2,      @PETMOD_REGEN,            5, @PET_ALL); -- 3

-----------------------------------
-- Bard
-----------------------------------
SET @CHORAL_ROUNDLET_P2    = 23049;
SET @CHORAL_JUSTAUCORPS_P2 = 23116;
SET @CHORAL_CUFFS_P2       = 23183;
SET @CHORAL_CANNIONS_P2    = 23250;
SET @CHORAL_SLIPPERS_P2    = 23317;

UPDATE `item_basic` SET name = 'choral_roundlet_+2',    sortname = 'choral_roundlet_+2'    WHERE itemId = @CHORAL_ROUNDLET_P2;
UPDATE `item_basic` SET name = 'choral_justaucorps_+2', sortname = 'choral_justaucorps_+2' WHERE itemId = @CHORAL_JUSTAUCORPS_P2;
UPDATE `item_basic` SET name = 'choral_cuffs_+2',       sortname = 'choral_cuffs_+2'       WHERE itemId = @CHORAL_CUFFS_P2;
UPDATE `item_basic` SET name = 'choral_cannions_+2',    sortname = 'choral_cannions_+2'    WHERE itemId = @CHORAL_CANNIONS_P2;
UPDATE `item_basic` SET name = 'choral_slippers_+2',    sortname = 'choral_slippers_+2'    WHERE itemId = @CHORAL_SLIPPERS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@CHORAL_ROUNDLET_P2, @CHORAL_JUSTAUCORPS_P2, @CHORAL_CUFFS_P2, @CHORAL_CANNIONS_P2, @CHORAL_SLIPPERS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@CHORAL_ROUNDLET_P2, @CHORAL_JUSTAUCORPS_P2, @CHORAL_CUFFS_P2, @CHORAL_CANNIONS_P2, @CHORAL_SLIPPERS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@CHORAL_ROUNDLET_P2,        @MOD_DEF,               23), -- 19
    (@CHORAL_ROUNDLET_P2,        @MOD_HP,                15), -- 11
    (@CHORAL_ROUNDLET_P2,        @MOD_MND,                8), -- 6
    (@CHORAL_ROUNDLET_P2,        @MOD_CHR,                8), -- 6
    (@CHORAL_ROUNDLET_P2,        @MOD_ENMITY,            -3), -- -2
    (@CHORAL_ROUNDLET_P2,        @MOD_PARRY,              7), -- 5
    --
    (@CHORAL_ROUNDLET_P2,        @MOD_REFRESH,            1), -- 1
    (@CHORAL_ROUNDLET_P2,        @MOD_REGEN,              4), -- 3

    -- Body
    (@CHORAL_JUSTAUCORPS_P2,     @MOD_DEF,               48), -- 45
    (@CHORAL_JUSTAUCORPS_P2,     @MOD_HP,                25), -- 20
    (@CHORAL_JUSTAUCORPS_P2,     @MOD_VIT,               12), -- 10
    (@CHORAL_JUSTAUCORPS_P2,     @MOD_CHR,               12), -- 10
    (@CHORAL_JUSTAUCORPS_P2,     @MOD_ENMITY,            -5), -- -3
    (@CHORAL_JUSTAUCORPS_P2,     @MOD_STRING_SKILL,      10), -- 6
    --
    (@CHORAL_JUSTAUCORPS_P2,     @MOD_SINGING_SKILL,      7), -- 5
    (@CHORAL_JUSTAUCORPS_P2,     @MOD_WIND_SKILL,         7), -- 6

    -- Hands
    (@CHORAL_CUFFS_P2,           @MOD_DEF,               22), -- 18
    (@CHORAL_CUFFS_P2,           @MOD_HP,                20), -- 14
    (@CHORAL_CUFFS_P2,           @MOD_VIT,               10), -- 7
    (@CHORAL_CUFFS_P2,           @MOD_CHR,               12), -- 10 (Combined base and augment stats)
    (@CHORAL_CUFFS_P2,           @MOD_ENMITY,            -2), -- -1
    (@CHORAL_CUFFS_P2,           @MOD_SINGING_SKILL,     12), -- 10
    --
    (@CHORAL_CUFFS_P2,           @MOD_MACC,               5), -- 3

    -- Legs
    (@CHORAL_CANNIONS_P2,        @MOD_DEF,               34), -- 31
    (@CHORAL_CANNIONS_P2,        @MOD_HP,                20), -- 12
    (@CHORAL_CANNIONS_P2,        @MOD_STR,               12), -- 8
    (@CHORAL_CANNIONS_P2,        @MOD_DEX,               12), -- 8
    (@CHORAL_CANNIONS_P2,        @MOD_ENMITY,            -3), -- -2
    (@CHORAL_CANNIONS_P2,        @MOD_WIND_SKILL,        10), -- 8
    --
    (@CHORAL_CANNIONS_P2,        @MOD_SONG_RECAST,       -4), -- 3
    (@CHORAL_CANNIONS_P2,        @MOD_MACC,               5), -- N/A

    -- Feet
    (@CHORAL_SLIPPERS_P2,        @MOD_DEF,               18), -- 14
    (@CHORAL_SLIPPERS_P2,        @MOD_HP,                15), -- 10
    (@CHORAL_SLIPPERS_P2,        @MOD_DEX,                8), -- 5
    (@CHORAL_SLIPPERS_P2,        @MOD_AGI,                8), -- 5
    (@CHORAL_SLIPPERS_P2,        @MOD_EVA,                8), -- 5
    (@CHORAL_SLIPPERS_P2,        @MOD_HMP,                3), -- 2
    (@CHORAL_SLIPPERS_P2,        @MOD_HHP,                4), -- 2
    --
    (@CHORAL_SLIPPERS_P2,        @MOD_DAMAGE_TAKEN,    -300); -- N/A

-----------------------------------
-- Ranger
-----------------------------------
SET @HUNTERS_BERET_P2   = 23050;
SET @HUNTERS_JERKIN_P2  = 23117;
SET @HUNTERS_BRACERS_P2 = 23184;
SET @HUNTERS_BRACCAE_P2 = 23251;
SET @HUNTERS_SOCKS_P2   = 23318;

UPDATE `item_basic` SET name = 'hunters_beret_+2',   sortname = 'hunters_beret_+2'   WHERE itemId = @HUNTERS_BERET_P2;
UPDATE `item_basic` SET name = 'hunters_jerkin_+2',  sortname = 'hunters_jerkin_+2'  WHERE itemId = @HUNTERS_JERKIN_P2;
UPDATE `item_basic` SET name = 'hunters_bracers_+2', sortname = 'hunters_bracers_+2' WHERE itemId = @HUNTERS_BRACERS_P2;
UPDATE `item_basic` SET name = 'hunters_braccae_+2', sortname = 'hunters_braccae_+2' WHERE itemId = @HUNTERS_BRACCAE_P2;
UPDATE `item_basic` SET name = 'hunters_socks_+2',   sortname = 'hunters_socks_+2'   WHERE itemId = @HUNTERS_SOCKS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@HUNTERS_BERET_P2, @HUNTERS_JERKIN_P2, @HUNTERS_BRACERS_P2, @HUNTERS_BRACCAE_P2, @HUNTERS_SOCKS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@HUNTERS_BERET_P2, @HUNTERS_JERKIN_P2, @HUNTERS_BRACERS_P2, @HUNTERS_BRACCAE_P2, @HUNTERS_SOCKS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@HUNTERS_BERET_P2,       @MOD_DEF,              28), -- 24
    (@HUNTERS_BERET_P2,       @MOD_HP,               20), -- 13
    (@HUNTERS_BERET_P2,       @MOD_AGI,               6), -- 4
    (@HUNTERS_BERET_P2,       @MOD_INT,               6), -- 4
    (@HUNTERS_BERET_P2,       @MOD_RATT,              8), -- 5
    (@HUNTERS_BERET_P2,       @MOD_RAPID_SHOT,        8), -- 5
    --
    (@HUNTERS_BERET_P2,       @MOD_MOVESPEED,        19), -- N/A
    (@HUNTERS_BERET_P2,       @MOD_RACC,              7), -- 5

    -- Body
    (@HUNTERS_JERKIN_P2,      @MOD_DEF,              50), -- 45
    (@HUNTERS_JERKIN_P2,      @MOD_HP,               25), -- 20
    (@HUNTERS_JERKIN_P2,      @MOD_VIT,               6), -- 4
    (@HUNTERS_JERKIN_P2,      @MOD_AGI,               6), -- 4
    (@HUNTERS_JERKIN_P2,      @MOD_RACC,             12), -- 10
    (@HUNTERS_JERKIN_P2,      @MOD_CAMOFLAGE_DUR,    60), -- 50
    --
    (@HUNTERS_JERKIN_P2,      @MOD_ACC,              12), -- 10
    (@HUNTERS_JERKIN_P2,      @MOD_STORE_TP,         10), -- 8

    -- Hands
    (@HUNTERS_BRACERS_P2,     @MOD_DEF,              18), -- 14
    (@HUNTERS_BRACERS_P2,     @MOD_HP,               15), -- 10
    (@HUNTERS_BRACERS_P2,     @MOD_DEX,               8), -- 6
    (@HUNTERS_BRACERS_P2,     @MOD_AGI,               8), -- 6
    (@HUNTERS_BRACERS_P2,     @MOD_SHADOWBIND_EXT,   12), -- 10
    --
    (@HUNTERS_BRACERS_P2,     @MOD_RACC,              8), -- 6
    (@HUNTERS_BRACERS_P2,     @MOD_BARRAGE_ACC,       5), -- 2

    -- Legs
    (@HUNTERS_BRACCAE_P2,     @MOD_DEF,              36), -- 32
    (@HUNTERS_BRACCAE_P2,     @MOD_HP,               20), -- 15
    (@HUNTERS_BRACCAE_P2,     @MOD_AGI,              18), -- 16 (Combined base and augment stats)
    (@HUNTERS_BRACCAE_P2,     @MOD_MND,               8), -- 5
    (@HUNTERS_BRACCAE_P2,     @MOD_HASTE,           300), -- N/A
    (@HUNTERS_BRACCAE_P2,     @MOD_ENMITY,           -5), -- -3
    (@HUNTERS_BRACCAE_P2,     @MOD_SHARPSHOT,        12), -- 10
    --
    (@HUNTERS_BRACCAE_P2,     @MOD_DEX,              13), -- 10

    -- Feet
    (@HUNTERS_SOCKS_P2,       @MOD_DEF,              20), -- 16
    (@HUNTERS_SOCKS_P2,       @MOD_HP,               15), -- 10
    (@HUNTERS_SOCKS_P2,       @MOD_DEX,               8), -- 6
    (@HUNTERS_SOCKS_P2,       @MOD_AGI,               8), -- 6
    (@HUNTERS_SOCKS_P2,       @MOD_EVA,               8), -- 5
    (@HUNTERS_SOCKS_P2,       @MOD_SCAVENGE,          8), -- 5
    --
    (@HUNTERS_SOCKS_P2,       @MOD_DOUBLE_ATK,        4), -- 3
    (@HUNTERS_SOCKS_P2,       @MOD_HASTE,           500); -- 5

-----------------------------------
-- Summoner
-----------------------------------
SET @EVOKERS_HORN_P2     = 23054;
SET @EVOKERS_DOUBLET_P2  = 23121;
SET @EVOKERS_BRACERS_P2  = 23188;
SET @EVOKERS_SPATS_P2    = 23255;
SET @EVOKERS_PIGACHES_P2 = 23322;

UPDATE `item_basic` SET name = 'evokers_horn_+2',     sortname = 'evokers_horn_+2'     WHERE itemId = @EVOKERS_HORN_P2;
UPDATE `item_basic` SET name = 'evokers_doublet_+2',  sortname = 'evokers_doublet_+2'  WHERE itemId = @EVOKERS_DOUBLET_P2;
UPDATE `item_basic` SET name = 'evokers_bracers_+2',  sortname = 'evokers_bracers_+2'  WHERE itemId = @EVOKERS_BRACERS_P2;
UPDATE `item_basic` SET name = 'evokers_spats_+2',    sortname = 'evokers_spats_+2'    WHERE itemId = @EVOKERS_SPATS_P2;
UPDATE `item_basic` SET name = 'evokers_pigaches_+2', sortname = 'evokers_pigaches_+2' WHERE itemId = @EVOKERS_PIGACHES_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@EVOKERS_HORN_P2, @EVOKERS_DOUBLET_P2, @EVOKERS_BRACERS_P2, @EVOKERS_SPATS_P2, @EVOKERS_PIGACHES_P2);
DELETE FROM `item_mods` WHERE itemId IN (@EVOKERS_HORN_P2, @EVOKERS_DOUBLET_P2, @EVOKERS_BRACERS_P2, @EVOKERS_SPATS_P2, @EVOKERS_PIGACHES_P2);
DELETE FROM `item_mods_pet` WHERE itemId IN (@EVOKERS_HORN_P2, @EVOKERS_DOUBLET_P2, @EVOKERS_BRACERS_P2, @EVOKERS_SPATS_P2, @EVOKERS_PIGACHES_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@EVOKERS_HORN_P2,         @MOD_DEF,              18), -- 15
    (@EVOKERS_HORN_P2,         @MOD_MP,               30), -- 25
    (@EVOKERS_HORN_P2,         @MOD_INT,               8), -- 6
    (@EVOKERS_HORN_P2,         @MOD_MND,               8), -- 6
    (@EVOKERS_HORN_P2,         @MOD_SUMMONING_SKILL,   8), -- 5
    --
    (@EVOKERS_HORN_P2,         @MOD_REFRESH,           1), -- 1
    (@EVOKERS_HORN_P2,         @MOD_HMP,               5), -- 4

    -- Body
    (@EVOKERS_DOUBLET_P2,      @MOD_DEF,              38), -- 35
    (@EVOKERS_DOUBLET_P2,      @MOD_MP,               50), -- 45
    (@EVOKERS_DOUBLET_P2,      @MOD_HMP,               8), -- 8 (Combined base and augment stats)
    (@EVOKERS_DOUBLET_P2,      @MOD_BP_DELAY,          5), -- 4

    -- Hands
    (@EVOKERS_BRACERS_P2,      @MOD_DEF,              14), -- 11
    (@EVOKERS_BRACERS_P2,      @MOD_MP,               23), -- 19
    (@EVOKERS_BRACERS_P2,      @MOD_BP_DELAY,          2), -- 1

    -- Legs
    (@EVOKERS_SPATS_P2,        @MOD_DEF,              29), -- 25
    (@EVOKERS_SPATS_P2,        @MOD_MP,               28), -- 22
    (@EVOKERS_SPATS_P2,        @MOD_HASTE,           300), -- N/A
    (@EVOKERS_SPATS_P2,        @MOD_ENMITY,           -4), -- -3

    -- Feet
    (@EVOKERS_PIGACHES_P2,     @MOD_DEF,              14), -- 10
    (@EVOKERS_PIGACHES_P2,     @MOD_MP,               30), -- 25
    (@EVOKERS_PIGACHES_P2,     @MOD_AVATAR_PERP,       2), -- 1
    (@EVOKERS_PIGACHES_P2,     @MOD_ELEMENTAL_SIPHON,  7); -- 5

INSERT INTO `item_mods_pet` VALUES
    (@EVOKERS_HORN_P2,         @PETMOD_AVATAR_ENMITY,   -4, @PET_AVATAR), -- -3
    (@EVOKERS_DOUBLET_P2,      @PETMOD_ACC,             10, @PET_AVATAR), -- 8
    (@EVOKERS_DOUBLET_P2,      @PETMOD_RACC,            10, @PET_AVATAR), -- 8
    (@EVOKERS_BRACERS_P2,      @PETMOD_DAMAGE_TAKEN,  -700, @PET_AVATAR), -- 5
    (@EVOKERS_BRACERS_P2,      @PETMOD_HASTE,            7, @PET_AVATAR), -- 5
    (@EVOKERS_SPATS_P2,        @PETMOD_ATT,              5, @PET_AVATAR), -- 3
    (@EVOKERS_SPATS_P2,        @PETMOD_RATT,             5, @PET_AVATAR), -- 3
    (@EVOKERS_SPATS_P2,        @PETMOD_DOUBLE_ATTACK,    5, @PET_AVATAR), -- 3
    (@EVOKERS_PIGACHES_P2,     @PETMOD_REGEN,            5, @PET_AVATAR);

-----------------------------------
-- Samurai
-----------------------------------
SET @MYOCHIN_KABUTO_P2   = 23051;
SET @MYOCHIN_DOMARU_P2   = 23118;
SET @MYOCHIN_KOTE_P2     = 23185;
SET @MYOCHIN_HAIDATE_P2  = 23252;
SET @MYOCHIN_SUNE_ATE_P2 = 23319;

UPDATE `item_basic` SET name = 'myochin_kabuto_+2',   sortname = 'myochin_kabuto_+2'   WHERE itemId = @MYOCHIN_KABUTO_P2;
UPDATE `item_basic` SET name = 'myochin_domaru_+2',   sortname = 'myochin_domaru_+2'   WHERE itemId = @MYOCHIN_DOMARU_P2;
UPDATE `item_basic` SET name = 'myochin_kote_+2',     sortname = 'myochin_kote_+2'     WHERE itemId = @MYOCHIN_KOTE_P2;
UPDATE `item_basic` SET name = 'myochin_haidate_+2',  sortname = 'myochin_haidate_+2'  WHERE itemId = @MYOCHIN_HAIDATE_P2;
UPDATE `item_basic` SET name = 'myochin_sune-ate_+2', sortname = 'myochin_sune-ate_+2' WHERE itemId = @MYOCHIN_SUNE_ATE_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@MYOCHIN_KABUTO_P2, @MYOCHIN_DOMARU_P2, @MYOCHIN_KOTE_P2, @MYOCHIN_HAIDATE_P2, @MYOCHIN_SUNE_ATE_P2);
DELETE FROM `item_mods` WHERE itemId IN (@MYOCHIN_KABUTO_P2, @MYOCHIN_DOMARU_P2, @MYOCHIN_KOTE_P2, @MYOCHIN_HAIDATE_P2, @MYOCHIN_SUNE_ATE_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@MYOCHIN_KABUTO_P2,       @MOD_DEF,              28), -- 25
    (@MYOCHIN_KABUTO_P2,       @MOD_HP,               20), -- 13
    (@MYOCHIN_KABUTO_P2,       @MOD_STR,               8), -- 5
    (@MYOCHIN_KABUTO_P2,       @MOD_MND,               8), -- 5
    (@MYOCHIN_KABUTO_P2,       @MOD_MEDITATE,          5), -- 4
    (@MYOCHIN_KABUTO_P2,       @MOD_WARDING_CIR_DUR, 100), -- 90
    --
    (@MYOCHIN_KABUTO_P2,       @MOD_CRIT_HIT_RATE,     4), -- 3
    (@MYOCHIN_KABUTO_P2,       @MOD_HASTE,           500), -- 5

    -- Body
    (@MYOCHIN_DOMARU_P2,       @MOD_DEF,              54), -- 50
    (@MYOCHIN_DOMARU_P2,       @MOD_HP,               15), -- 10
    (@MYOCHIN_DOMARU_P2,       @MOD_STR,               8), -- 6
    (@MYOCHIN_DOMARU_P2,       @MOD_VIT,               8), -- 6
    (@MYOCHIN_DOMARU_P2,       @MOD_ACC,              15), -- 12
    --
    (@MYOCHIN_DOMARU_P2,       @MOD_MEDITATE,          2), -- 1
    (@MYOCHIN_DOMARU_P2,       @MOD_REGEN,             5), -- 3

    -- Hands
    (@MYOCHIN_KOTE_P2,         @MOD_DEF,              24), -- 21
    (@MYOCHIN_KOTE_P2,         @MOD_HP,               20), -- 15
    (@MYOCHIN_KOTE_P2,         @MOD_STR,               8), -- 7
    (@MYOCHIN_KOTE_P2,         @MOD_DEX,               8), -- 7
    (@MYOCHIN_KOTE_P2,         @MOD_ENMITY,            3), -- 2
    --
    (@MYOCHIN_KOTE_P2,         @MOD_ZANSHIN,           5), -- 3
    (@MYOCHIN_KOTE_P2,         @MOD_HASTE,           400), -- 3

    -- Legs
    (@MYOCHIN_HAIDATE_P2,      @MOD_DEF,              43), -- 40
    (@MYOCHIN_HAIDATE_P2,      @MOD_HP,               20), -- 15
    (@MYOCHIN_HAIDATE_P2,      @MOD_STR,               8), -- 5
    (@MYOCHIN_HAIDATE_P2,      @MOD_VIT,               8), -- 5
    (@MYOCHIN_HAIDATE_P2,      @MOD_STORE_TP,          9), -- 4
    (@MYOCHIN_HAIDATE_P2,      @MOD_PARRY,            12), -- 10
    --
    (@MYOCHIN_HAIDATE_P2,      @MOD_DOUBLE_ATK,        2), -- N/A
    (@MYOCHIN_HAIDATE_P2,      @MOD_HASTE,           500), -- 5

    -- Feet
    (@MYOCHIN_SUNE_ATE_P2,     @MOD_DEF,              21), -- 18
    (@MYOCHIN_SUNE_ATE_P2,     @MOD_HP,               25), -- 20
    (@MYOCHIN_SUNE_ATE_P2,     @MOD_ATT,              10), -- 8
    (@MYOCHIN_SUNE_ATE_P2,     @MOD_ENMITY,            6), -- 5
    (@MYOCHIN_SUNE_ATE_P2,     @MOD_ZANSHIN,           2), -- 1
    --
    (@MYOCHIN_SUNE_ATE_P2,     @MOD_DOUBLE_ATK,        4), -- 3
    (@MYOCHIN_SUNE_ATE_P2,     @MOD_HASTE,           300); -- 3

-----------------------------------
-- Ninja
-----------------------------------
SET @NINJA_HATSUBURI_P2 = 23052;
SET @NINJA_CHAINMAIL_P2 = 23119;
SET @NINJA_TEKKO_P2     = 23186;
SET @NINJA_HAKAMA_P2    = 23253;
SET @NINJA_KYAHAN_P2    = 23320;

UPDATE `item_basic` SET name = 'ninja_hatsuburi_+2', sortname = 'ninja_hatsuburi_+2' WHERE itemId = @NINJA_HATSUBURI_P2;
UPDATE `item_basic` SET name = 'ninja_chainmail_+2', sortname = 'ninja_chainmail_+2' WHERE itemId = @NINJA_CHAINMAIL_P2;
UPDATE `item_basic` SET name = 'ninja_tekko_+2',     sortname = 'ninja_tekko_+2'     WHERE itemId = @NINJA_TEKKO_P2;
UPDATE `item_basic` SET name = 'ninja_hakama_+2',    sortname = 'ninja_hakama_+2'    WHERE itemId = @NINJA_HAKAMA_P2;
UPDATE `item_basic` SET name = 'ninja_kyahan_+2',    sortname = 'ninja_kyahan_+2'    WHERE itemId = @NINJA_KYAHAN_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@NINJA_HATSUBURI_P2, @NINJA_CHAINMAIL_P2, @NINJA_TEKKO_P2, @NINJA_HAKAMA_P2, @NINJA_KYAHAN_P2);
DELETE FROM `item_mods` WHERE itemId IN (@NINJA_HATSUBURI_P2, @NINJA_CHAINMAIL_P2, @NINJA_TEKKO_P2, @NINJA_HAKAMA_P2, @NINJA_KYAHAN_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@NINJA_HATSUBURI_P2,     @MOD_DEF,              26), -- 22
    (@NINJA_HATSUBURI_P2,     @MOD_HP,               15), -- 10
    (@NINJA_HATSUBURI_P2,     @MOD_AGI,              10), -- 8
    (@NINJA_HATSUBURI_P2,     @MOD_CHR,              10), -- 8
    (@NINJA_HATSUBURI_P2,     @MOD_EVA,              10), -- 8
    (@NINJA_HATSUBURI_P2,     @MOD_NINJUTSU_SKILL,   10), -- 5
    --
    (@NINJA_HATSUBURI_P2,     @MOD_CRIT_HIT_RATE,     4), -- 3
    (@NINJA_HATSUBURI_P2,     @MOD_HASTE,           600), -- 5

    -- Body
    (@NINJA_CHAINMAIL_P2,     @MOD_DEF,                   51), -- 46
    (@NINJA_CHAINMAIL_P2,     @MOD_HP,                    20), -- 15
    (@NINJA_CHAINMAIL_P2,     @MOD_DEX,                    8), -- 5
    (@NINJA_CHAINMAIL_P2,     @MOD_VIT,                    8), -- 5
    (@NINJA_CHAINMAIL_P2,     @MOD_DUAL_WIELD,             8), -- 5
    (@NINJA_CHAINMAIL_P2,     @MOD_ITEM_SUBEFFECT,         8), -- 5
    (@NINJA_CHAINMAIL_P2,     @MOD_ITEM_ADDEFFECT_DMG,    30), -- 25
    (@NINJA_CHAINMAIL_P2,     @MOD_ITEM_ADDEFFECT_CHANCE, 30), -- 25
    --
    (@NINJA_CHAINMAIL_P2,     @MOD_PARRY_SKILL,           10), -- N/A
    (@NINJA_CHAINMAIL_P2,     @MOD_ACC,                   10), -- 8

    -- Hands
    (@NINJA_TEKKO_P2,         @MOD_DEF,              22), -- 18
    (@NINJA_TEKKO_P2,         @MOD_HP,               18), -- 13
    (@NINJA_TEKKO_P2,         @MOD_STR,               8), -- 6
    (@NINJA_TEKKO_P2,         @MOD_DEX,               8), -- 6
    (@NINJA_TEKKO_P2,         @MOD_RATT,             25), -- 20
    (@NINJA_TEKKO_P2,         @MOD_RACC,             25), -- 20
    (@NINJA_TEKKO_P2,         @MOD_THROWING_SKILL,   10), -- 5
    --
    (@NINJA_TEKKO_P2,         @MOD_DOUBLE_ATK,        3), -- 3
    (@NINJA_TEKKO_P2,         @MOD_HASTE,           400), -- 3

    -- Legs
    (@NINJA_HAKAMA_P2,        @MOD_DEF,              34), -- 31
    (@NINJA_HAKAMA_P2,        @MOD_ACC,              10), -- 5
    (@NINJA_HAKAMA_P2,        @MOD_RACC,             12), -- 10
    --
    (@NINJA_HAKAMA_P2,        @MOD_EVA,              10), -- 5
    (@NINJA_HAKAMA_P2,        @MOD_NINJA_TOOL,        5), -- 3

    -- Feet
    (@NINJA_KYAHAN_P2,        @MOD_DEF,              18), -- 15
    (@NINJA_KYAHAN_P2,        @MOD_HP,               18), -- 12
    (@NINJA_KYAHAN_P2,        @MOD_AGI,               8), -- 6
    (@NINJA_KYAHAN_P2,        @MOD_INT,               8), -- 6
    --
    (@NINJA_KYAHAN_P2,        @MOD_MATT,             12), -- 10
    (@NINJA_KYAHAN_P2,        @MOD_NINJUTSU_SKILL,   10), -- 5
    (@NINJA_KYAHAN_P2,        @MOD_MOVESPEED,        18); -- Latent: +24%

-----------------------------------
-- Dragoon
-----------------------------------
SET @DRACHEN_ARMET_P2   = 23053;
SET @DRACHEN_MAIL_P2    = 23120;
SET @DRACHEN_FNG_GNT_P2 = 23187;
SET @DRACHEN_BRAIS_P2   = 23254;
SET @DRACHEN_GREAVES_P2 = 23321;

UPDATE `item_basic` SET name = 'drachen_armet_+2',            sortname = 'drachen_armet_+2'    WHERE itemId = @DRACHEN_ARMET_P2;
UPDATE `item_basic` SET name = 'drachen_mail_+2',             sortname = 'drachen_mail_+2'     WHERE itemId = @DRACHEN_MAIL_P2;
UPDATE `item_basic` SET name = 'drachen_finger_gauntlets_+2', sortname = 'drachen_fng.gnt._+2' WHERE itemId = @DRACHEN_FNG_GNT_P2;
UPDATE `item_basic` SET name = 'drachen_brais_+2',            sortname = 'drachen_brais_+2'    WHERE itemId = @DRACHEN_BRAIS_P2;
UPDATE `item_basic` SET name = 'drachen_greaves_+2',          sortname = 'drachen_greaves_+2'  WHERE itemId = @DRACHEN_GREAVES_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@DRACHEN_ARMET_P2, @DRACHEN_MAIL_P2, @DRACHEN_FNG_GNT_P2, @DRACHEN_BRAIS_P2, @DRACHEN_GREAVES_P2);
DELETE FROM `item_mods` WHERE itemId IN (@DRACHEN_ARMET_P2, @DRACHEN_MAIL_P2, @DRACHEN_FNG_GNT_P2, @DRACHEN_BRAIS_P2, @DRACHEN_GREAVES_P2);
DELETE FROM `item_mods_pet` WHERE itemId IN (@DRACHEN_ARMET_P2, @DRACHEN_MAIL_P2, @DRACHEN_FNG_GNT_P2, @DRACHEN_BRAIS_P2, @DRACHEN_GREAVES_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@DRACHEN_ARMET_P2,                @MOD_DEF,              30), -- 25
    (@DRACHEN_ARMET_P2,                @MOD_HP,               15), -- 10
    (@DRACHEN_ARMET_P2,                @MOD_VIT,              10), -- 8
    (@DRACHEN_ARMET_P2,                @MOD_MND,              10), -- 8
    (@DRACHEN_ARMET_P2,                @MOD_SPIRIT_LINK,       1), -- N/A (not on base piece for some reason)
    (@DRACHEN_ARMET_P2,                @MOD_WYVERN_BREATH,     8), -- 5
    -- Pet Mods handled below
    (@DRACHEN_ARMET_P2,                @MOD_CRIT_HIT_RATE,     4), -- 3
    (@DRACHEN_ARMET_P2,                @MOD_HASTE,           500), -- 5

    -- Body
    (@DRACHEN_MAIL_P2,                 @MOD_DEF,              54), -- 49
    (@DRACHEN_MAIL_P2,                 @MOD_HP,               20), -- 15
    (@DRACHEN_MAIL_P2,                 @MOD_STR,               8), -- 6
    (@DRACHEN_MAIL_P2,                 @MOD_VIT,               8), -- 6
    (@DRACHEN_MAIL_P2,                 @MOD_ATT,              10), -- 7
    -- Pet Mods handled below
    (@DRACHEN_MAIL_P2,                 @MOD_ACC,              12), -- 10
    (@DRACHEN_MAIL_P2,                 @MOD_STORE_TP,         10), -- 8

    -- Hands
    (@DRACHEN_FNG_GNT_P2,              @MOD_DEF,              23), -- 19
    (@DRACHEN_FNG_GNT_P2,              @MOD_HP,               15), -- 11
    (@DRACHEN_FNG_GNT_P2,              @MOD_STR,               8), -- 5
    (@DRACHEN_FNG_GNT_P2,              @MOD_DEX,               8), -- 5
    (@DRACHEN_FNG_GNT_P2,              @MOD_PARRY,            15), -- 12
    -- Pet Mods handled below
    (@DRACHEN_FNG_GNT_P2,              @MOD_DOUBLE_ATK,        3), -- 3
    (@DRACHEN_FNG_GNT_P2,              @MOD_HASTE,           500), -- 3 (Matches CW)

    -- Legs
    (@DRACHEN_BRAIS_P2,                @MOD_DEF,              35), -- 32
    (@DRACHEN_BRAIS_P2,                @MOD_HP,               20), -- 15
    (@DRACHEN_BRAIS_P2,                @MOD_ACC,              12), -- 9
    (@DRACHEN_BRAIS_P2,                @MOD_ANCIENT_CIR_DUR, 100), -- 90
    -- Pet Mods handled below
    (@DRACHEN_BRAIS_P2,                @MOD_HASTE,           500), -- 3

    -- Feet
    (@DRACHEN_GREAVES_P2,              @MOD_DEF,              20), -- 16
    (@DRACHEN_GREAVES_P2,              @MOD_HP,               20), -- 12
    (@DRACHEN_GREAVES_P2,              @MOD_DEX,               8), -- 5
    (@DRACHEN_GREAVES_P2,              @MOD_AGI,               8), -- 5
    (@DRACHEN_GREAVES_P2,              @MOD_ATT,               5), -- N/A
    (@DRACHEN_GREAVES_P2,              @MOD_EVA,              12), -- 10
    (@DRACHEN_GREAVES_P2,              @MOD_JUMP_ATT_BONUS,   18), -- 15
    -- Pet mods handled below
    (@DRACHEN_GREAVES_P2,              @MOD_HASTE,           300); -- 3

INSERT INTO `item_mods_pet` VALUES
    (@DRACHEN_ARMET_P2,                @PETMOD_REGEN,          2, @PET_WYVERN), -- 1
    (@DRACHEN_FNG_GNT_P2,              @PETMOD_ACC,            7, @PET_WYVERN), -- 5
    (@DRACHEN_BRAIS_P2,                @PETMOD_HPP,           20, @PET_WYVERN), -- 15
    (@DRACHEN_BRAIS_P2,                @PETMOD_ACC,           17, @PET_WYVERN), -- 15
    (@DRACHEN_BRAIS_P2,                @PETMOD_WYVERN_RACC,   17, @PET_WYVERN), -- 15
    (@DRACHEN_GREAVES_P2,              @PETMOD_REGEN,          3, @PET_WYVERN); -- 3

-----------------------------------
-- Blue Mage
-----------------------------------
SET @MAGUS_KEFFIYEH_P2  = 23055;
SET @MAGUS_JUBBAH_P2    = 23122;
SET @MAGUS_BAZUBANDS_P2 = 23189;
SET @MAGUS_SHALWAR_P2   = 23256;
SET @MAGUS_CHARUQS_P2   = 23323;

UPDATE `item_basic` SET name = 'magus_keffiyeh_+2',  sortname = 'magus_keffiyeh_+2'  WHERE itemId = @MAGUS_KEFFIYEH_P2;
UPDATE `item_basic` SET name = 'magus_jubbah_+2',    sortname = 'magus_jubbah_+2'    WHERE itemId = @MAGUS_JUBBAH_P2;
UPDATE `item_basic` SET name = 'magus_bazubands_+2', sortname = 'magus_bazubands_+2' WHERE itemId = @MAGUS_BAZUBANDS_P2;
UPDATE `item_basic` SET name = 'magus_shalwar_+2',   sortname = 'magus_shalwar_+2'   WHERE itemId = @MAGUS_SHALWAR_P2;
UPDATE `item_basic` SET name = 'magus_charuqs_+2',   sortname = 'magus_charuqs_+2'   WHERE itemId = @MAGUS_CHARUQS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@MAGUS_KEFFIYEH_P2, @MAGUS_JUBBAH_P2, @MAGUS_BAZUBANDS_P2, @MAGUS_SHALWAR_P2, @MAGUS_CHARUQS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@MAGUS_KEFFIYEH_P2, @MAGUS_JUBBAH_P2, @MAGUS_BAZUBANDS_P2, @MAGUS_SHALWAR_P2, @MAGUS_CHARUQS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@MAGUS_KEFFIYEH_P2,      @MOD_DEF,              28), -- 24
    (@MAGUS_KEFFIYEH_P2,      @MOD_MP,               30), -- 25
    (@MAGUS_KEFFIYEH_P2,      @MOD_INT,               8), -- 5
    (@MAGUS_KEFFIYEH_P2,      @MOD_MND,               8), -- 5
    --
    (@MAGUS_KEFFIYEH_P2,      @MOD_CRIT_HIT_RATE,     4), -- 3
    (@MAGUS_KEFFIYEH_P2,      @MOD_HASTE,           500), -- 5

    -- Body
    (@MAGUS_JUBBAH_P2,        @MOD_DEF,              48), -- 45
    (@MAGUS_JUBBAH_P2,        @MOD_HP,               22), -- 17
    (@MAGUS_JUBBAH_P2,        @MOD_MP,               22), -- 17
    (@MAGUS_JUBBAH_P2,        @MOD_STR,               8), -- 5
    (@MAGUS_JUBBAH_P2,        @MOD_DEX,               8), -- 5
    (@MAGUS_JUBBAH_P2,        @MOD_HHP,               2), -- 1
    (@MAGUS_JUBBAH_P2,        @MOD_HMP,               2), -- 1
    (@MAGUS_JUBBAH_P2,        @MOD_BLUE_SKILL,       18), -- 15
    --
    (@MAGUS_JUBBAH_P2,        @MOD_ACC,              15), -- 10
    (@MAGUS_JUBBAH_P2,        @MOD_DUAL_WIELD,        5), -- 3

    -- Hands
    (@MAGUS_BAZUBANDS_P2,     @MOD_DEF,               20), -- 17
    (@MAGUS_BAZUBANDS_P2,     @MOD_MP,                25), -- 20
    (@MAGUS_BAZUBANDS_P2,     @MOD_STR,                5), -- 3
    (@MAGUS_BAZUBANDS_P2,     @MOD_INT,                5), -- 3
    (@MAGUS_BAZUBANDS_P2,     @MOD_PARRY,             12), -- 10
    (@MAGUS_BAZUBANDS_P2,     @MOD_BLUE_LEARN_CHANCE, 13), -- 11
    --
    (@MAGUS_BAZUBANDS_P2,     @MOD_DOUBLE_ATK,         3), -- 3
    (@MAGUS_BAZUBANDS_P2,     @MOD_HASTE,            500), -- 3 (Matches CW)

    -- Legs
    (@MAGUS_SHALWAR_P2,       @MOD_DEF,              38), -- 34
    (@MAGUS_SHALWAR_P2,       @MOD_HP,               30), -- 25
    (@MAGUS_SHALWAR_P2,       @MOD_DEX,               8), -- 5
    (@MAGUS_SHALWAR_P2,       @MOD_VIT,               8), -- 5
    (@MAGUS_SHALWAR_P2,       @MOD_AGI,               8), -- 5
    (@MAGUS_SHALWAR_P2,       @MOD_HASTE,           300), -- N/A
    (@MAGUS_SHALWAR_P2,       @MOD_SPELL_INTERRUPT,  15), -- 12
    --
    (@MAGUS_SHALWAR_P2,       @MOD_REFRESH,           2), -- 1
    (@MAGUS_SHALWAR_P2,       @MOD_REGEN,             5), -- 3


    -- Feet
    (@MAGUS_CHARUQS_P2,       @MOD_DEF,              20), -- 17
    (@MAGUS_CHARUQS_P2,       @MOD_HP,               25), -- 18
    (@MAGUS_CHARUQS_P2,       @MOD_MP,               25), -- 18
    (@MAGUS_CHARUQS_P2,       @MOD_ACC,               8), -- 3
    (@MAGUS_CHARUQS_P2,       @MOD_EVASION_SKILL,    12), -- 10
    (@MAGUS_CHARUQS_P2,       @MOD_ENMITY,           -6), -- -5
    --
    (@MAGUS_CHARUQS_P2,       @MOD_MATT,             12), -- 10
    (@MAGUS_CHARUQS_P2,       @MOD_BLUE_SKILL,        7); -- 5

-----------------------------------
-- Corsair
-----------------------------------
SET @CORSAIRS_TRICORNE_P2 = 23056;
SET @CORSAIRS_FRAC_P2     = 23123;
SET @CORSAIRS_GANTS_P2    = 23190;
SET @CORSAIRS_CULOTTES_P2 = 23257;
SET @CORSAIRS_BOTTES_P2   = 23324;

UPDATE `item_basic` SET name = 'corsairs_tricorne_+2', sortname = 'corsairs_tricorne_+2' WHERE itemId = @CORSAIRS_TRICORNE_P2;
UPDATE `item_basic` SET name = 'corsairs_frac_+2',     sortname = 'corsairs_frac_+2'     WHERE itemId = @CORSAIRS_FRAC_P2;
UPDATE `item_basic` SET name = 'corsairs_gants_+2',    sortname = 'corsairs_gants_+2'    WHERE itemId = @CORSAIRS_GANTS_P2;
UPDATE `item_basic` SET name = 'corsairs_culottes_+2', sortname = 'corsairs_culottes_+2' WHERE itemId = @CORSAIRS_CULOTTES_P2;
UPDATE `item_basic` SET name = 'corsairs_bottes_+2',   sortname = 'corsairs_bottes_+2'   WHERE itemId = @CORSAIRS_BOTTES_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@CORSAIRS_TRICORNE_P2, @CORSAIRS_FRAC_P2, @CORSAIRS_GANTS_P2, @CORSAIRS_CULOTTES_P2, @CORSAIRS_BOTTES_P2);
DELETE FROM `item_mods` WHERE itemId IN (@CORSAIRS_TRICORNE_P2, @CORSAIRS_FRAC_P2, @CORSAIRS_GANTS_P2, @CORSAIRS_CULOTTES_P2, @CORSAIRS_BOTTES_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@CORSAIRS_TRICORNE_P2,     @MOD_DEF,              27), -- 23
    (@CORSAIRS_TRICORNE_P2,     @MOD_HP,               18), -- 13
    (@CORSAIRS_TRICORNE_P2,     @MOD_STR,               6), -- 4
    (@CORSAIRS_TRICORNE_P2,     @MOD_AGI,               6), -- 4
    (@CORSAIRS_TRICORNE_P2,     @MOD_HASTE,           400), -- N/A
    (@CORSAIRS_TRICORNE_P2,     @MOD_RACC,             12), -- 9
    (@CORSAIRS_TRICORNE_P2,     @MOD_QUICK_DRAW_DMG,    7), -- 5
    --
    (@CORSAIRS_TRICORNE_P2,     @MOD_RATT,             10), -- 6
    (@CORSAIRS_TRICORNE_P2,     @MOD_REGEN,             3), -- 2

    -- Body
    (@CORSAIRS_FRAC_P2,         @MOD_DEF,              47), -- 43
    (@CORSAIRS_FRAC_P2,         @MOD_HP,               25), -- 20
    (@CORSAIRS_FRAC_P2,         @MOD_DEX,               8), -- 5
    (@CORSAIRS_FRAC_P2,         @MOD_AGI,              18), -- 16 (Combined base and augment stats)
    (@CORSAIRS_FRAC_P2,         @MOD_HASTE,           200), -- N/A
    (@CORSAIRS_FRAC_P2,         @MOD_RATT,              8), -- 5
    (@CORSAIRS_FRAC_P2,         @MOD_RACC,             12), -- 10
    --
    (@CORSAIRS_FRAC_P2,         @MOD_MARKSMAN_SKILL,    5), -- 3

    -- Hands
    (@CORSAIRS_GANTS_P2,        @MOD_DEF,              15), -- 12
    (@CORSAIRS_GANTS_P2,        @MOD_HP,               20), -- 15
    (@CORSAIRS_GANTS_P2,        @MOD_DEX,               8), -- 5
    (@CORSAIRS_GANTS_P2,        @MOD_MND,               8), -- 5
    (@CORSAIRS_GANTS_P2,        @MOD_EVA,               5), -- 3
    (@CORSAIRS_GANTS_P2,        @MOD_PARRY,             8), -- 5
    --
    (@CORSAIRS_GANTS_P2,        @MOD_DOUBLE_ATK,        4), -- 3
    (@CORSAIRS_GANTS_P2,        @MOD_HASTE,           400), -- 3

    -- Legs
    (@CORSAIRS_CULOTTES_P2,        @MOD_DEF,           34), -- 29
    (@CORSAIRS_CULOTTES_P2,        @MOD_HP,            30), -- 25
    (@CORSAIRS_CULOTTES_P2,        @MOD_INT,            8), -- 5
    (@CORSAIRS_CULOTTES_P2,        @MOD_AGI,            8), -- 5
    (@CORSAIRS_CULOTTES_P2,        @MOD_ENMITY,        -5), -- -4
    --
    (@CORSAIRS_CULOTTES_P2,        @MOD_ACC,           10), -- 6
    (@CORSAIRS_CULOTTES_P2,        @MOD_DUAL_WIELD,     5), -- 3

    -- Feet
    (@CORSAIRS_BOTTES_P2,       @MOD_DEF,              15), -- 12
    (@CORSAIRS_BOTTES_P2,       @MOD_HP,               20), -- 15
    (@CORSAIRS_BOTTES_P2,       @MOD_STR,               8), -- 5
    (@CORSAIRS_BOTTES_P2,       @MOD_AGI,               8), -- 5
    (@CORSAIRS_BOTTES_P2,       @MOD_HASTE,           200), -- N/A
    (@CORSAIRS_BOTTES_P2,       @MOD_ACC,               6), -- 4
    (@CORSAIRS_BOTTES_P2,       @MOD_RACC,              6), -- 4
    --
    (@CORSAIRS_BOTTES_P2,       @MOD_RAPID_SHOT,        7), -- 5
    (@CORSAIRS_BOTTES_P2,       @MOD_SNAP_SHOT,         5); -- 3

-----------------------------------
-- Puppetmaster
-----------------------------------
SET @PUPPETRY_TAJ_P2       = 23057;
SET @PUPPETRY_TOBE_P2      = 23124;
SET @PUPPETRY_DASTANAS_P2  = 23191;
SET @PUPPETRY_CHURIDARS_P2 = 23258;
SET @PUPPETRY_BABOUCHES_P2 = 23325;

UPDATE `item_basic` SET name = 'puppetry_taj_+2',       sortname = 'puppetry_taj_+2'       WHERE itemId = @PUPPETRY_TAJ_P2;
UPDATE `item_basic` SET name = 'puppetry_tobe_+2',      sortname = 'puppetry_tobe_+2'      WHERE itemId = @PUPPETRY_TOBE_P2;
UPDATE `item_basic` SET name = 'puppetry_dastanas_+2',  sortname = 'puppetry_dastanas_+2'  WHERE itemId = @PUPPETRY_DASTANAS_P2;
UPDATE `item_basic` SET name = 'puppetry_churidars_+2', sortname = 'puppetry_churidars_+2' WHERE itemId = @PUPPETRY_CHURIDARS_P2;
UPDATE `item_basic` SET name = 'puppetry_babouches_+2', sortname = 'puppetry_babouches_+2' WHERE itemId = @PUPPETRY_BABOUCHES_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@PUPPETRY_TAJ_P2, @PUPPETRY_TOBE_P2, @PUPPETRY_DASTANAS_P2, @PUPPETRY_CHURIDARS_P2, @PUPPETRY_BABOUCHES_P2);
DELETE FROM `item_mods` WHERE itemId IN (@PUPPETRY_TAJ_P2, @PUPPETRY_TOBE_P2, @PUPPETRY_DASTANAS_P2, @PUPPETRY_CHURIDARS_P2, @PUPPETRY_BABOUCHES_P2);
DELETE FROM `item_mods_pet` WHERE itemId IN (@PUPPETRY_TAJ_P2, @PUPPETRY_TOBE_P2, @PUPPETRY_DASTANAS_P2, @PUPPETRY_CHURIDARS_P2, @PUPPETRY_BABOUCHES_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@PUPPETRY_TAJ_P2,           @MOD_DEF,              18), -- 16
    (@PUPPETRY_TAJ_P2,           @MOD_HP,               20), -- 15
    (@PUPPETRY_TAJ_P2,           @MOD_DEX,               8), -- 5
    (@PUPPETRY_TAJ_P2,           @MOD_VIT,               8), -- 5
    (@PUPPETRY_TAJ_P2,           @MOD_MND,               8), -- 5
    -- Pet mods added below
    (@PUPPETRY_TAJ_P2,           @MOD_HASTE,           600), -- 5

    -- Body
    (@PUPPETRY_TOBE_P2,          @MOD_DEF,              40), -- 37
    (@PUPPETRY_TOBE_P2,          @MOD_HP,               20), -- 17
    (@PUPPETRY_TOBE_P2,          @MOD_ATT,              12), -- 5
    (@PUPPETRY_TOBE_P2,          @MOD_ACC,              12), -- 5
    --
    (@PUPPETRY_TOBE_P2,          @MOD_MARTIAL_ARTS,      4), -- 2
    (@PUPPETRY_TOBE_P2,          @MOD_STORE_TP,          7), -- 5

    -- Hands
    (@PUPPETRY_DASTANAS_P2,      @MOD_DEF,              17), -- 13
    (@PUPPETRY_DASTANAS_P2,      @MOD_HP,               22), -- 18
    (@PUPPETRY_DASTANAS_P2,      @MOD_STR,               8), -- 5
    (@PUPPETRY_DASTANAS_P2,      @MOD_AGI,               8), -- 5
    (@PUPPETRY_DASTANAS_P2,      @MOD_MANEUVER_BONUS,    2), -- 1
    (@PUPPETRY_DASTANAS_P2,      @MOD_OVERLOAD_THRESH,   7), -- 5
    --
    (@PUPPETRY_DASTANAS_P2,      @MOD_DOUBLE_ATK,        4), -- 3
    (@PUPPETRY_DASTANAS_P2,      @MOD_HASTE,           400), -- 3

    -- Legs
    (@PUPPETRY_CHURIDARS_P2,     @MOD_DEF,              34), -- 26
    (@PUPPETRY_CHURIDARS_P2,     @MOD_HP,               20), -- 16
    (@PUPPETRY_CHURIDARS_P2,     @MOD_DEX,               8), -- 5
    (@PUPPETRY_CHURIDARS_P2,     @MOD_CHR,               8), -- 5
    -- Pet mods added below
    (@PUPPETRY_CHURIDARS_P2,     @MOD_HASTE,           500), -- 3

    -- Feet
    (@PUPPETRY_BABOUCHES_P2,     @MOD_DEF,              14), -- 12
    (@PUPPETRY_BABOUCHES_P2,     @MOD_HP,               22), -- 19
    (@PUPPETRY_BABOUCHES_P2,     @MOD_STR,               8), -- 5
    (@PUPPETRY_BABOUCHES_P2,     @MOD_ACC,               8), -- 5
    (@PUPPETRY_BABOUCHES_P2,     @MOD_EVA,               8), -- 5
    (@PUPPETRY_BABOUCHES_P2,     @MOD_REPAIR_EFFECT,     2), -- 1
    -- Pet mods added below
    (@PUPPETRY_BABOUCHES_P2,     @MOD_REPAIR_POTENCY,    5); -- 3

INSERT INTO `item_mods_pet` VALUES
    (@PUPPETRY_TAJ_P2,           @PETMOD_AUTO_HHP,       5, @PET_AUTOMATON), -- 3
    (@PUPPETRY_TAJ_P2,           @PETMOD_AUTO_HMP,       5, @PET_AUTOMATON), -- 3
    (@PUPPETRY_TAJ_P2,           @PETMOD_HASTE,        700, @PET_AUTOMATON), -- 5
    (@PUPPETRY_TOBE_P2,          @PETMOD_HPP,           20, @PET_AUTOMATON), -- ?? TODO: Needs Verified
    (@PUPPETRY_TOBE_P2,          @PETMOD_HMP,           20, @PET_AUTOMATON), -- ?? TODO: Needs Verified
    (@PUPPETRY_CHURIDARS_P2,     @PETMOD_AUTO_CURE_POT,  7, @PET_AUTOMATON), -- 5
    (@PUPPETRY_CHURIDARS_P2,     @PETMOD_DOUBLE_ATTACK,  5, @PET_AUTOMATON), -- 4
    (@PUPPETRY_CHURIDARS_P2,     @PETMOD_CRIT_HIT_RATE,  5, @PET_AUTOMATON), -- 4
    (@PUPPETRY_BABOUCHES_P2,     @PETMOD_REGEN,          5, @PET_AUTOMATON); -- 3

-----------------------------------
-- Dancer
-----------------------------------
-- Male
SET @DANCERS_TIARA_P2_M     = 23058;
SET @DANCERS_CASAQUE_P2_M   = 23125;
SET @DANCERS_BANGLES_P2_M   = 23192;
SET @DANCERS_TIGHTS_P2_M    = 23259;
SET @DANCERS_TOE_SHOES_P2_M = 23326;

-- Female
SET @DANCERS_TIARA_P2_F     = 23059;
SET @DANCERS_CASAQUE_P2_F   = 23126;
SET @DANCERS_BANGLES_P2_F   = 23193;
SET @DANCERS_TIGHTS_P2_F    = 23260;
SET @DANCERS_TOE_SHOES_P2_F = 23327;

UPDATE `item_basic` SET name = 'dancers_tiara_+2',     sortname = 'dancers_tiara_+2'     WHERE itemId = @DANCERS_TIARA_P2_M     OR itemId = @DANCERS_TIARA_P2_F;
UPDATE `item_basic` SET name = 'dancers_casaque_+2',   sortname = 'dancers_casaque_+2'   WHERE itemId = @DANCERS_CASAQUE_P2_M   OR itemId = @DANCERS_CASAQUE_P2_F;
UPDATE `item_basic` SET name = 'dancers_bangles_+2',   sortname = 'dancers_bangles_+2'   WHERE itemId = @DANCERS_BANGLES_P2_M   OR itemId = @DANCERS_BANGLES_P2_F;
UPDATE `item_basic` SET name = 'dancers_tights_+2',    sortname = 'dancers_tights_+2'    WHERE itemId = @DANCERS_TIGHTS_P2_M    OR itemId = @DANCERS_TIGHTS_P2_F;
UPDATE `item_basic` SET name = 'dancers_toe_shoes_+2', sortname = 'dancers_toe_shoes_+2' WHERE itemId = @DANCERS_TOE_SHOES_P2_M OR itemId = @DANCERS_TOE_SHOES_P2_F;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (
    @DANCERS_TIARA_P2_M, @DANCERS_CASAQUE_P2_M, @DANCERS_BANGLES_P2_M, @DANCERS_TIGHTS_P2_M, @DANCERS_TOE_SHOES_P2_M,
    @DANCERS_TIARA_P2_F, @DANCERS_CASAQUE_P2_F, @DANCERS_BANGLES_P2_F, @DANCERS_TIGHTS_P2_F, @DANCERS_TOE_SHOES_P2_F
);

DELETE FROM `item_mods` WHERE itemId IN (
    @DANCERS_TIARA_P2_M, @DANCERS_CASAQUE_P2_M, @DANCERS_BANGLES_P2_M, @DANCERS_TIGHTS_P2_M, @DANCERS_TOE_SHOES_P2_M,
    @DANCERS_TIARA_P2_F, @DANCERS_CASAQUE_P2_F, @DANCERS_BANGLES_P2_F, @DANCERS_TIGHTS_P2_F, @DANCERS_TOE_SHOES_P2_F
);

-- DNC AF has Male/Female versions and mods need to be duplicated for both sets

INSERT INTO `item_mods` VALUES
    -- Head
    (@DANCERS_TIARA_P2_M,        @MOD_DEF,               23), -- 19
    (@DANCERS_TIARA_P2_M,        @MOD_HP,                20), -- 15
    (@DANCERS_TIARA_P2_M,        @MOD_DEX,                6), -- 4
    (@DANCERS_TIARA_P2_M,        @MOD_CHR,                6), -- 4
    (@DANCERS_TIARA_P2_M,        @MOD_ENMITY,            -4), -- -2
    (@DANCERS_TIARA_P2_M,        @MOD_RSE,              149), -- N/A
    (@DANCERS_TIARA_P2_M,        @MOD_SAMBA_DURATION,    35), -- 30
    --
    (@DANCERS_TIARA_P2_M,        @MOD_CRIT_HIT_RATE,      4), -- 3
    (@DANCERS_TIARA_P2_M,        @MOD_HASTE,            500), -- 5

    (@DANCERS_TIARA_P2_F,        @MOD_DEF,               23), -- 19
    (@DANCERS_TIARA_P2_F,        @MOD_HP,                20), -- 15
    (@DANCERS_TIARA_P2_F,        @MOD_DEX,                6), -- 4
    (@DANCERS_TIARA_P2_F,        @MOD_CHR,                6), -- 4
    (@DANCERS_TIARA_P2_F,        @MOD_ENMITY,            -4), -- -2
    (@DANCERS_TIARA_P2_F,        @MOD_RSE,              106), -- N/A
    (@DANCERS_TIARA_P2_F,        @MOD_SAMBA_DURATION,    35), -- 30
    --
    (@DANCERS_TIARA_P2_F,        @MOD_CRIT_HIT_RATE,      4), -- 3
    (@DANCERS_TIARA_P2_F,        @MOD_HASTE,            500), -- 5

    -- Body
    (@DANCERS_CASAQUE_P2_M,      @MOD_DEF,               45), -- 39
    (@DANCERS_CASAQUE_P2_M,      @MOD_HP,                30), -- 25
    (@DANCERS_CASAQUE_P2_M,      @MOD_STR,                7), -- 5
    (@DANCERS_CASAQUE_P2_M,      @MOD_DEX,                7), -- 5
    (@DANCERS_CASAQUE_P2_M,      @MOD_ENMITY,            -4), -- -2
    (@DANCERS_CASAQUE_P2_M,      @MOD_RSE,              149), -- N/A
    (@DANCERS_CASAQUE_P2_M,      @MOD_WALTZ_POTENCY,     20), -- 15 (Combined Base/Augment Stats)
    --
    -- TODO: Where is Waltz Delay?!

    (@DANCERS_CASAQUE_P2_F,      @MOD_DEF,               45), -- 39
    (@DANCERS_CASAQUE_P2_F,      @MOD_HP,                30), -- 25
    (@DANCERS_CASAQUE_P2_F,      @MOD_STR,                7), -- 5
    (@DANCERS_CASAQUE_P2_F,      @MOD_DEX,                7), -- 5
    (@DANCERS_CASAQUE_P2_F,      @MOD_ENMITY,            -4), -- -2
    (@DANCERS_CASAQUE_P2_F,      @MOD_RSE,              106), -- N/A
    (@DANCERS_CASAQUE_P2_F,      @MOD_WALTZ_POTENCY,     20), -- 15 (Combined Base/Augment Stats)
    -- TODO: Where is Waltz Delay?!

    -- Hands
    (@DANCERS_BANGLES_P2_M,       @MOD_DEF,              20), -- 16
    (@DANCERS_BANGLES_P2_M,       @MOD_HP,               22), -- 17
    (@DANCERS_BANGLES_P2_M,       @MOD_DEX,               6), -- 4
    (@DANCERS_BANGLES_P2_M,       @MOD_AGI,               6), -- 4
    (@DANCERS_BANGLES_P2_M,       @MOD_ATT,               8), -- 5
    (@DANCERS_BANGLES_P2_M,       @MOD_RSE,             149), -- N/A
    (@DANCERS_BANGLES_P2_M,       @MOD_STEP_ACCURACY,     2), -- 1
    --
    (@DANCERS_BANGLES_P2_M,       @MOD_DUAL_WIELD,        5), -- 3
    (@DANCERS_BANGLES_P2_M,       @MOD_HASTE,           400), -- 3

    (@DANCERS_BANGLES_P2_F,       @MOD_DEF,              20), -- 16
    (@DANCERS_BANGLES_P2_F,       @MOD_HP,               22), -- 17
    (@DANCERS_BANGLES_P2_F,       @MOD_DEX,               6), -- 4
    (@DANCERS_BANGLES_P2_F,       @MOD_AGI,               6), -- 4
    (@DANCERS_BANGLES_P2_F,       @MOD_ATT,               8), -- 5
    (@DANCERS_BANGLES_P2_F,       @MOD_RSE,             106), -- N/A
    (@DANCERS_BANGLES_P2_F,       @MOD_STEP_ACCURACY,     2), -- 1
    --
    (@DANCERS_BANGLES_P2_F,       @MOD_DUAL_WIELD,        5), -- 3
    (@DANCERS_BANGLES_P2_F,       @MOD_HASTE,           400), -- 3

    -- Legs
    (@DANCERS_TIGHTS_P2_M,        @MOD_DEF,              32), -- 29
    (@DANCERS_TIGHTS_P2_M,        @MOD_HP,               20), -- 15
    (@DANCERS_TIGHTS_P2_M,        @MOD_VIT,               7), -- 5
    (@DANCERS_TIGHTS_P2_M,        @MOD_CHR,               7), -- 5
    (@DANCERS_TIGHTS_P2_M,        @MOD_ATT,              10), -- 5
    (@DANCERS_TIGHTS_P2_M,        @MOD_ACC,              10), -- 5
    (@DANCERS_TIGHTS_P2_M,        @MOD_RSE,             149), -- N/A
    (@DANCERS_TIGHTS_P2_M,        @MOD_ENMITY,           -2), -- -1
    --
    (@DANCERS_TIGHTS_P2_M,        @MOD_STR,              13), -- 11
    (@DANCERS_TIGHTS_P2_M,        @MOD_DEX,              13), -- 11

    (@DANCERS_TIGHTS_P2_F,        @MOD_DEF,              32), -- 29
    (@DANCERS_TIGHTS_P2_F,        @MOD_HP,               20), -- 15
    (@DANCERS_TIGHTS_P2_F,        @MOD_VIT,               7), -- 5
    (@DANCERS_TIGHTS_P2_F,        @MOD_CHR,               7), -- 5
    (@DANCERS_TIGHTS_P2_F,        @MOD_ATT,              10), -- 5
    (@DANCERS_TIGHTS_P2_F,        @MOD_ACC,              10), -- 5
    (@DANCERS_TIGHTS_P2_F,        @MOD_RSE,             106), -- N/A
    (@DANCERS_TIGHTS_P2_F,        @MOD_ENMITY,           -2), -- -1
    --
    (@DANCERS_TIGHTS_P2_F,        @MOD_STR,              13), -- 11
    (@DANCERS_TIGHTS_P2_F,        @MOD_DEX,              13), -- 11

    -- Feet
    (@DANCERS_TOE_SHOES_P2_M,     @MOD_DEF,              20), -- 15
    (@DANCERS_TOE_SHOES_P2_M,     @MOD_HP,               20), -- 12
    (@DANCERS_TOE_SHOES_P2_M,     @MOD_STR,               5), -- 3
    (@DANCERS_TOE_SHOES_P2_M,     @MOD_AGI,               5), -- 3
    (@DANCERS_TOE_SHOES_P2_M,     @MOD_ATT,               8), -- 5
    (@DANCERS_TOE_SHOES_P2_M,     @MOD_EVA,               8), -- 5
    (@DANCERS_TOE_SHOES_P2_M,     @MOD_RSE,             149), -- N/A
    (@DANCERS_TOE_SHOES_P2_M,     @MOD_JIG_DURATION,     30), -- 25
    --
    (@DANCERS_TOE_SHOES_P2_M,     @MOD_DOUBLE_ATK,        4), -- 3
    (@DANCERS_TOE_SHOES_P2_M,     @MOD_HASTE,           400), -- 3

    (@DANCERS_TOE_SHOES_P2_F,     @MOD_DEF,              20), -- 15
    (@DANCERS_TOE_SHOES_P2_F,     @MOD_HP,               20), -- 12
    (@DANCERS_TOE_SHOES_P2_F,     @MOD_STR,               5), -- 3
    (@DANCERS_TOE_SHOES_P2_F,     @MOD_AGI,               5), -- 3
    (@DANCERS_TOE_SHOES_P2_F,     @MOD_ATT,               8), -- 5
    (@DANCERS_TOE_SHOES_P2_F,     @MOD_EVA,               8), -- 5
    (@DANCERS_TOE_SHOES_P2_F,     @MOD_RSE,             106), -- N/A
    (@DANCERS_TOE_SHOES_P2_F,     @MOD_JIG_DURATION,     30), -- 25
    --
    (@DANCERS_TOE_SHOES_P2_F,     @MOD_DOUBLE_ATK,        4), -- 3
    (@DANCERS_TOE_SHOES_P2_F,     @MOD_HASTE,           400); -- 3

-----------------------------------
-- Scholar
-----------------------------------
SET @SCHOLARS_MORTARBOARD_P2 = 23060;
SET @SCHOLARS_GOWN_P2        = 23127;
SET @SCHOLARS_BRACERS_P2     = 23194;
SET @SCHOLARS_PANTS_P2       = 23261;
SET @SCHOLARS_LOAFERS_P2     = 23328;

UPDATE `item_basic` SET name = 'scholars_mortarboard_+2', sortname = 'scholars_mortarboard_+2' WHERE itemId = @SCHOLARS_MORTARBOARD_P2;
UPDATE `item_basic` SET name = 'scholars_gown_+2',        sortname = 'scholars_gown_+2'        WHERE itemId = @SCHOLARS_GOWN_P2;
UPDATE `item_basic` SET name = 'scholars_bracers_+2',     sortname = 'scholars_bracers_+2'     WHERE itemId = @SCHOLARS_BRACERS_P2;
UPDATE `item_basic` SET name = 'scholars_pants_+2',       sortname = 'scholars_pants_+2'       WHERE itemId = @SCHOLARS_PANTS_P2;
UPDATE `item_basic` SET name = 'scholars_loafers_+2',     sortname = 'scholars_loafers_+2'     WHERE itemId = @SCHOLARS_LOAFERS_P2;

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@SCHOLARS_MORTARBOARD_P2, @SCHOLARS_GOWN_P2, @SCHOLARS_BRACERS_P2, @SCHOLARS_PANTS_P2, @SCHOLARS_LOAFERS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@SCHOLARS_MORTARBOARD_P2, @SCHOLARS_GOWN_P2, @SCHOLARS_BRACERS_P2, @SCHOLARS_PANTS_P2, @SCHOLARS_LOAFERS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@SCHOLARS_MORTARBOARD_P2,     @MOD_DEF,               20), -- 16
    (@SCHOLARS_MORTARBOARD_P2,     @MOD_MP,                25), -- 20
    (@SCHOLARS_MORTARBOARD_P2,     @MOD_INT,                8), -- 5
    (@SCHOLARS_MORTARBOARD_P2,     @MOD_ENMITY,            -2), -- -1
    (@SCHOLARS_MORTARBOARD_P2,     @MOD_SUBLIMATION_BONUS,  2), -- 1
    --
    (@SCHOLARS_MORTARBOARD_P2,     @MOD_MAG_BURST_BONUS,    5), -- 3
    (@SCHOLARS_MORTARBOARD_P2,     @MOD_MATT,               7), -- 5

    -- Body
    (@SCHOLARS_GOWN_P2,            @MOD_DEF,               44), -- 39
    (@SCHOLARS_GOWN_P2,            @MOD_MP,                22), -- 18
    (@SCHOLARS_GOWN_P2,            @MOD_INT,                5), -- 3
    (@SCHOLARS_GOWN_P2,            @MOD_MND,                5), -- 3
    (@SCHOLARS_GOWN_P2,            @MOD_HMP,                7), -- 5
    (@SCHOLARS_GOWN_P2,            @MOD_DARK_ARTS_SKILL,   20), -- 15
    --
    (@SCHOLARS_GOWN_P2,            @MOD_MACC,               7), -- 5
    (@SCHOLARS_GOWN_P2,            @MOD_MATT,               7), -- 5

    -- Hands
    (@SCHOLARS_BRACERS_P2,         @MOD_DEF,               18), -- 14
    (@SCHOLARS_BRACERS_P2,         @MOD_MP,                25), -- 20
    (@SCHOLARS_BRACERS_P2,         @MOD_MND,                8), -- 5
    (@SCHOLARS_BRACERS_P2,         @MOD_ENMITY,            -5), -- -3
    (@SCHOLARS_BRACERS_P2,         @MOD_SPELL_INTERRUPT,   25), -- 20
    --
    (@SCHOLARS_BRACERS_P2,         @MOD_REFRESH,            2), -- 1
    (@SCHOLARS_BRACERS_P2,         @MOD_HMP,                5), -- 3

    -- Legs
    (@SCHOLARS_PANTS_P2,           @MOD_DEF,               32), -- 28
    (@SCHOLARS_PANTS_P2,           @MOD_MP,                30), -- 25
    (@SCHOLARS_PANTS_P2,           @MOD_VIT,                5), -- 3
    (@SCHOLARS_PANTS_P2,           @MOD_MND,                5), -- 3
    (@SCHOLARS_PANTS_P2,           @MOD_ENMITY,            -3), -- -2
    (@SCHOLARS_PANTS_P2,           @MOD_LIGHT_ARTS_SKILL,  20), -- 15
    --
    (@SCHOLARS_PANTS_P2,           @MOD_CONSERVE_MP,        7), -- 5
    (@SCHOLARS_PANTS_P2,           @MOD_CURE_POTENCY,       8), -- 7

    -- Feet
    (@SCHOLARS_LOAFERS_P2,         @MOD_DEF,                   15), -- 11
    (@SCHOLARS_LOAFERS_P2,         @MOD_MP,                    25), -- 20
    (@SCHOLARS_LOAFERS_P2,         @MOD_AGI,                    5), -- 3
    (@SCHOLARS_LOAFERS_P2,         @MOD_INT,                    5), -- 3
    (@SCHOLARS_LOAFERS_P2,         @MOD_ENMITY,                -4), -- -2
    (@SCHOLARS_LOAFERS_P2,         @MOD_GRIMOIRE_SPELLCASTING, -7), -- -5
    --
    (@SCHOLARS_LOAFERS_P2,         @MOD_MACC,                   7), -- 5
    (@SCHOLARS_LOAFERS_P2,         @MOD_DRAIN_ASPIR_POT,        7); -- 5

-----------------------------------
-- Geomancer
-----------------------------------
SET @GEOMANCY_GALERO_P2   = 23061;
SET @GEOMANCY_TUNIC_P2    = 23128;
SET @GEOMANCY_MITAINES_P2 = 23195;
SET @GEOMANCY_PANTS_P2    = 23262;
SET @GEOMANCY_SANDALS_P2  = 23329;

-- GEO AF starts from iLvl and doesn't need to be renamed

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@GEOMANCY_GALERO_P2, @GEOMANCY_TUNIC_P2, @GEOMANCY_MITAINES_P2, @GEOMANCY_PANTS_P2, @GEOMANCY_SANDALS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@GEOMANCY_GALERO_P2, @GEOMANCY_TUNIC_P2, @GEOMANCY_MITAINES_P2, @GEOMANCY_PANTS_P2, @GEOMANCY_SANDALS_P2);
DELETE FROM `item_mods_pet` WHERE itemId IN (@GEOMANCY_GALERO_P2, @GEOMANCY_TUNIC_P2, @GEOMANCY_MITAINES_P2, @GEOMANCY_PANTS_P2, @GEOMANCY_SANDALS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@GEOMANCY_GALERO_P2,       @MOD_DEF,              30), -- 25
    (@GEOMANCY_GALERO_P2,       @MOD_MP,               30), -- 25
    (@GEOMANCY_GALERO_P2,       @MOD_INT,               8), -- 5
    (@GEOMANCY_GALERO_P2,       @MOD_ELEMENTAL_SKILL,  17), -- 15
    (@GEOMANCY_GALERO_P2,       @MOD_CARDINAL_CHANT,   60), -- 50 TODO: VERIFY
    --
    (@GEOMANCY_GALERO_P2,       @MOD_REFRESH,           2), -- 1
    (@GEOMANCY_GALERO_P2,       @MOD_CONSERVE_MP,       7), -- 5

    -- Body
    (@GEOMANCY_TUNIC_P2,        @MOD_DEF,              44), -- 40
    (@GEOMANCY_TUNIC_P2,        @MOD_MP,               40), -- 35
    (@GEOMANCY_TUNIC_P2,        @MOD_DARK_SKILL,       15), -- 12
    (@GEOMANCY_TUNIC_P2,        @MOD_LIFE_CYCLE,       15), -- 10
    --
    (@GEOMANCY_TUNIC_P2,        @MOD_DAMAGE_TAKEN,   -700), -- -500
    (@GEOMANCY_TUNIC_P2,        @MOD_MACC,              7), -- 5

    -- Hands
    (@GEOMANCY_MITAINES_P2,     @MOD_DEF,               18), -- 15
    (@GEOMANCY_MITAINES_P2,     @MOD_MP,                20), -- 16
    (@GEOMANCY_MITAINES_P2,     @MOD_INT,                7), -- 3
    (@GEOMANCY_MITAINES_P2,     @MOD_MND,                7), -- 4
    (@GEOMANCY_MITAINES_P2,     @MOD_GEOMANCY_SKILL,    20), -- 15
    -- Pet mods handled below
    (@GEOMANCY_MITAINES_P2,     @MOD_CONSERVE_MP,       5), -- 3

    -- Legs
    (@GEOMANCY_PANTS_P2,        @MOD_DEF,              35), -- 30
    (@GEOMANCY_PANTS_P2,        @MOD_MP,               25), -- 20
    (@GEOMANCY_PANTS_P2,        @MOD_FASTCAST,         12), -- 10
    (@GEOMANCY_PANTS_P2,        @MOD_SPELL_INTERRUPT,  18), -- 15
    --
    (@GEOMANCY_PANTS_P2,        @MOD_INT,              13), -- 11
    (@GEOMANCY_PANTS_P2,        @MOD_MND,              13), -- 11

    -- Feet
    (@GEOMANCY_SANDALS_P2,      @MOD_DEF,              15), -- 12
    (@GEOMANCY_SANDALS_P2,      @MOD_MP,               60), -- 54 (Combined base and augment stats)
    (@GEOMANCY_SANDALS_P2,      @MOD_AGI,               8), -- 5
    (@GEOMANCY_SANDALS_P2,      @MOD_CHR,               8), -- 5
    (@GEOMANCY_SANDALS_P2,      @MOD_MOVESPEED,        18), -- 12
    --
    (@GEOMANCY_SANDALS_P2,      @MOD_HMP,               7); -- 5

INSERT INTO `item_mods_pet` VALUES
    (@GEOMANCY_MITAINES_P2,     @PETMOD_DAMAGE_TAKEN, -1200, @PET_LUOPAN); -- 1100 (Combined base and augment stats)

-----------------------------------
-- Rune Fencer
-----------------------------------
SET @RUNEIST_BANDEAU_P2  = 23062;
SET @RUNEIST_COAT_P2     = 23129;
SET @RUNEIST_MITONS_P2   = 23196;
SET @RUNEIST_TROUSERS_P2 = 23263;
SET @RUNEIST_BOOTS_P2    = 23330;

-- RUN AF starts from iLvl and doesn't need to be renamed

UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId IN (@RUNEIST_BANDEAU_P2, @RUNEIST_COAT_P2, @RUNEIST_MITONS_P2, @RUNEIST_TROUSERS_P2, @RUNEIST_BOOTS_P2);
DELETE FROM `item_mods` WHERE itemId IN (@RUNEIST_BANDEAU_P2, @RUNEIST_COAT_P2, @RUNEIST_MITONS_P2, @RUNEIST_TROUSERS_P2, @RUNEIST_BOOTS_P2);

INSERT INTO `item_mods` VALUES
    -- Head
    (@RUNEIST_BANDEAU_P2,      @MOD_DEF,                   34), -- 27
    (@RUNEIST_BANDEAU_P2,      @MOD_HP,                    34), -- 27
    (@RUNEIST_BANDEAU_P2,      @MOD_DEX,                    8), -- 5
    (@RUNEIST_BANDEAU_P2,      @MOD_HASTE,                500), -- N/A
    (@RUNEIST_BANDEAU_P2,      @MOD_DAMAGE_TAKEN,        -300), -- -3 (Phys.)
    (@RUNEIST_BANDEAU_P2,      @MOD_REGEN_DURATION,         5), -- 3
    --
    (@RUNEIST_BANDEAU_P2,      @MOD_ENMITY,                 7), -- 5
    (@RUNEIST_BANDEAU_P2,      @MOD_REGEN,                  4), -- 2

    -- Body
    (@RUNEIST_COAT_P2,         @MOD_DEF,                   54), -- 50
    (@RUNEIST_COAT_P2,         @MOD_HP,                    25), -- 20
    (@RUNEIST_COAT_P2,         @MOD_MP,                    25), -- 20
    (@RUNEIST_COAT_P2,         @MOD_STR,                    8), -- 5
    (@RUNEIST_COAT_P2,         @MOD_VIT,                    8), -- 5
    (@RUNEIST_COAT_P2,         @MOD_ICE_RES,               15), -- 10
    (@RUNEIST_COAT_P2,         @MOD_FIRE_RES,              15), -- 10
    (@RUNEIST_COAT_P2,         @MOD_EARTH_RES,             15), -- 10
    (@RUNEIST_COAT_P2,         @MOD_WIND_RES,              15), -- 10
    (@RUNEIST_COAT_P2,         @MOD_WATER_RES,             15), -- 10
    (@RUNEIST_COAT_P2,         @MOD_LIGHT_RES,             15), -- 10
    (@RUNEIST_COAT_P2,         @MOD_DARK_RES,              15), -- 10
    (@RUNEIST_COAT_P2,         @MOD_THUNDER_RES,           15), -- 10
    (@RUNEIST_COAT_P2,         @MOD_VALLIANCE_VALLATION,   15), -- 10
    --
    (@RUNEIST_COAT_P2,         @MOD_MAGIC_DMG_TAKEN,     -500), -- -3
    (@RUNEIST_COAT_P2,         @MOD_PARRY,                  7), -- 5

    -- Hands
    (@RUNEIST_MITONS_P2,       @MOD_DEF,                   25), -- 21
    (@RUNEIST_MITONS_P2,       @MOD_MP,                    25), -- 22
    (@RUNEIST_MITONS_P2,       @MOD_DEX,                    5), -- 3
    (@RUNEIST_MITONS_P2,       @MOD_VIT,                    5), -- 3
    (@RUNEIST_MITONS_P2,       @MOD_HASTE,                300), -- N/A
    (@RUNEIST_MITONS_P2,       @MOD_REFRESH,                2), -- 1
    (@RUNEIST_MITONS_P2,       @MOD_ENHANCE_GAMBIT,        15), -- 10
    --
    (@RUNEIST_MITONS_P2,       @MOD_GSWORD_SKILL,           7), -- 5
    (@RUNEIST_MITONS_P2,       @MOD_ENMITY,                 5), -- 3

    -- Legs
    (@RUNEIST_TROUSERS_P2,     @MOD_DEF,                   44), -- 40
    (@RUNEIST_TROUSERS_P2,     @MOD_HP,                    20), -- 15
    (@RUNEIST_TROUSERS_P2,     @MOD_MP,                    20), -- 15
    (@RUNEIST_TROUSERS_P2,     @MOD_STR,                   10), -- 7
    (@RUNEIST_TROUSERS_P2,     @MOD_HASTE,                400), -- N/A
    (@RUNEIST_TROUSERS_P2,     @MOD_ENMITY,                 7), -- 5
    (@RUNEIST_TROUSERS_P2,     @MOD_DAMAGE_TAKEN,        -300), -- -3 (Phys.)
    --
    (@RUNEIST_TROUSERS_P2,     @MOD_VIT,                   13), -- 11
    (@RUNEIST_TROUSERS_P2,     @MOD_MND,                   13), -- 11

    -- Feet
    (@RUNEIST_BOOTS_P2,        @MOD_DEF,                   22), -- 18
    (@RUNEIST_BOOTS_P2,        @MOD_MP,                    24), -- 18
    (@RUNEIST_BOOTS_P2,        @MOD_VIT,                    8), -- 6
    (@RUNEIST_BOOTS_P2,        @MOD_HASTE,                300), -- N/A
    (@RUNEIST_BOOTS_P2,        @MOD_MDEF,                   4), -- 2
    (@RUNEIST_BOOTS_P2,        @MOD_ENHANCE_PFLUG,         15), -- 10
    --
    (@RUNEIST_BOOTS_P2,        @MOD_BREATH_DMG_TAKEN,    -500), -- -3
    (@RUNEIST_BOOTS_P2,        @MOD_ENMITY,                 5); -- 3
