-----------------------------------
-- CatsEyeXI Job Adjustments
-----------------------------------
-- WAR =  1 -- MNK =  2
-- WHM =  3 -- BLM =  4
-- RDM =  5 -- THF =  6
-- PLD =  7 -- DRK =  8
-- BST =  9 -- BRD = 10
-- RNG = 11 -- SAM = 12
-- NIN = 13 -- DRG = 14
-- SMN = 15 -- BLU = 16
-- COR = 17 -- PUP = 18
-- DNC = 19 -- SCH = 20
-- GEO = 21 -- RUN = 22

-----------------------------------
-- Warrior
-----------------------------------
UPDATE traits SET level = 40 WHERE traitid = 25  AND job = 1  AND rank = 1;     -- Shield Mastery I
UPDATE abilities SET level = 75, recastTime = 600 WHERE abilityId = 267;        -- Blood Rage

-----------------------------------
-- Monk
-----------------------------------
UPDATE abilities SET level = 75 WHERE abilityId = 253;                          -- Perfect Counter
INSERT INTO `traits` VALUES (3,'attack bonus',2,30,1,23,10,NULL,0);             -- Attack Bonus I
INSERT INTO `traits` VALUES (3,'attack bonus',2,30,1,24,10,NULL,0);             -- Attack Bonus I
INSERT INTO `traits` VALUES (3,'attack bonus',2,55,2,23,22,'ROV',0);            -- Attack Bonus II
INSERT INTO `traits` VALUES (3,'attack bonus',2,55,2,24,22,'ROV',0);            -- Attack Bonus II
INSERT INTO `traits` VALUES (3,'attack bonus',2,70,3,23,35,'ABYSSEA',0);        -- Attack Bonus III
INSERT INTO `traits` VALUES (3,'attack bonus',2,70,3,24,35,'ABYSSEA',0);        -- Attack Bonus III
UPDATE traits SET level = 75 WHERE traitid = 127 AND job = 2  AND rank = 2;     -- Smite II

-----------------------------------
-- White Mage
-----------------------------------
# Allow WHM to use Enlight at 75
UPDATE `spell_list` SET jobs = 0x00003D00000000000000000000000000000000000000 WHERE spellid = "310";

-----------------------------------
-- Black Mage
-----------------------------------
-- UPDATE abilities SET level = 70 WHERE abilityId = 254;                       -- Mana Wall (Not coded)
UPDATE abilities SET level = 75 WHERE abilityId = 272;                          -- Enmity Douse
UPDATE traits SET level = 60 WHERE traitid = 109 AND job = 4  AND rank = 1;     -- Occult Acumen I
UPDATE traits SET level = 75 WHERE traitid = 109 AND job = 4  AND rank = 2;     -- Occult Acumen II
UPDATE `skill_ranks` SET `blm` = 6 WHERE name = 'scythe';                       -- Upgrade Scythe Skill from E to C+
UPDATE `weapon_skills` SET `jobs` = 0x01000001000000010100000000000000000000000000 WHERE name = 'entropy'; -- Add BLM to Entropy

-----------------------------------
-- Red Mage
-----------------------------------
UPDATE traits SET level = 70 WHERE traitid =   5 AND job = 5  AND rank = 1;     -- Mag. Burst Bonus I
UPDATE traits SET level = 75 WHERE traitid = 110 AND job = 5  AND rank = 1;     -- Magic Atk. Bonus III

-----------------------------------
-- Thief
-----------------------------------
UPDATE abilities SET level = 40 WHERE abilityId =  84;                          -- Accomplice
UPDATE abilities SET level = 40 WHERE abilityId = 236;                          -- Collaborator
UPDATE abilities SET level = 75 WHERE abilityId = 276;                          -- Conspirator
UPDATE abilities SET level = 75 WHERE abilityId = 228;                          -- Despoil

UPDATE traits SET level = 50 WHERE traitid = 68  AND job = 6  AND rank = 1;     -- Assassin
UPDATE `traits` SET `level` = 20, `content_tag` = NULL WHERE `name` = 'dual wield' AND `rank` = 1 AND job = 6; -- THF Dual Wield I Lv20
UPDATE `traits` SET `level` = 20, `content_tag` = NULL WHERE `name` = 'dual wield' AND `rank` = 2 AND job = 6; -- THF Dual Wield II Lv40

-----------------------------------
-- Dark Knight
-----------------------------------
UPDATE abilities SET level = 75 WHERE abilityId = 256;                          -- Nether Void
UPDATE abilities SET level = 75 WHERE abilityId = 280;                          -- Scarlet Delirium

-----------------------------------
-- Beastmaster
-----------------------------------
UPDATE traits SET level = 75 WHERE traitid = 103 AND job = 9  AND rank = 1;     -- Stout Servant I
UPDATE traits SET level = 60 WHERE traitid = 107 AND job = 9  AND rank = 1;     -- Fencer I
UPDATE traits SET level = 75 WHERE traitid = 107 AND job = 9  AND rank = 2;     -- Fencer II

-----------------------------------
-- Bard
-----------------------------------
UPDATE traits SET level = 75 WHERE traitid = 107 AND job = 10 AND rank = 1;     -- Fencer I

-----------------------------------
-- Ninja
-----------------------------------
UPDATE abilities SET level = 75 WHERE abilityId = 259;                          -- Futae
UPDATE traits SET level = 75 WHERE traitid = 13  AND job = 13 AND rank = 1;     -- Magic Burst Bonus I
UPDATE traits SET level = 75 WHERE traitid = 100 AND job = 13 AND rank = 1;     -- Tactical Parry I

-----------------------------------
-- Dragoon
-----------------------------------
UPDATE abilities SET level = 75 WHERE abilityId = 336;                          -- Fly High

-----------------------------------
-- Summoner
-----------------------------------
UPDATE abilities SET level = 75 WHERE abilityId = 296;                          -- Mana Cede

-----------------------------------
-- Corsair
-----------------------------------
UPDATE abilities SET level = 75 WHERE abilityId = 119;                          -- Caster's Roll
UPDATE abilities SET level = 75 WHERE abilityId = 304;                          -- Companion's Roll

-----------------------------------
-- Dancer
-----------------------------------
-- DNC
-- # UPDATE abilities SET level = 75, recastTime = 1800 WHERE abilityId = 341;     -- Grand Pas ???

-----------------------------------
-- Scholar
-----------------------------------
UPDATE abilities SET level = 75 WHERE abilityId = 316;                          -- Perpetuance
UPDATE abilities SET level = 75 WHERE abilityId = 317;                          -- Immanence
UPDATE traits SET level = 60 WHERE traitid = 109 AND job = 20 AND rank = 1;     -- Occult Acumen I
UPDATE traits SET level = 75 WHERE traitid = 109 AND job = 20 AND rank = 2;     -- Occult Acumen II

-- SCH Stratagems (PLEASE NOTE: THIS FUNCTIONS, BUT CURRENTLY DISPLAYS INCORRECTLY IN THE MENUS IN GAME)
-- - E.g. Players menu displays 4 charges, but upon reaching 0 from 4 stratagems in a row, it immediately displays another [1] stratagem in the menu.
-- -- Recast timer is also incorrect after ticking up (1:00), but initially displays at the right timer [0:48], this is probably a visual bug.
-- --- Setting the job to 99 resolves this visual error, so it isn't some simple fix on our end.

-- Level   |Charges |Recharge Time per Charge
-- -----   -------- ---------------
-- 10      |1       |4:00 minutes
-- 30      |2       |2:00 minutes
-- 50      |3       |1:20 minutes
-- 65 (70) |4       |1:00 minute
-- 75 (90) |5       |48 seconds
-----------------------------------

UPDATE abilities_charges SET level = 65 WHERE recastId = 231 AND maxCharges = 4; -- 4 charges max every 60 seconds at level 65
UPDATE abilities_charges SET level = 75 WHERE recastId = 231 AND maxCharges = 5; -- 5 charges max every 48 seconds at level 75

-----------------------------------
-- Runefencer
-----------------------------------
UPDATE `spell_list` SET jobs = 0x00002D00000025000000000000000000000000000026 WHERE spellid = "112"; -- RUN Flash 38
UPDATE `spell_list` SET jobs = 0x0000000000000000000000000000000000000000003A WHERE spellid = "476"; -- RUN Crusade 56
UPDATE abilities SET level = 75 WHERE abilityId = 374;                                               -- One for All

-----------------------------------
-- Geomancer
-----------------------------------
# Allow GEO to use Indi/Geo Haste, and Indi/Geo Frailty at 74
UPDATE `spell_list` SET jobs = 0x00000000000000000000000000000000000000004A00 where spellid in (771,788,801,818);
