--
-- Flags (src/map/items/item.h)
--
SET @ITEM_EQUIP = 64576; -- Rare/Ex and Equippable
SET @ITEM_EX    = 29760; -- Ex but not Rare
SET @ITEM_RARE  = 62528; -- Rare and Ex
SET @ITEM_EQUSE = 65088; -- Rare/Ex and Equippable and Usable
SET @ITEM_EXUSE = 30272; -- Ex Non-equipment and Usable
SET @ITEM_EQDEF =  2080; -- Equippable with default attributes, tradable, delivery box, inscribable etc.

--
-- Jobs
--
SET @WAR      =  1;
SET @MNK      =  2;
SET @WHM      =  4;
SET @BLM      =  8;
SET @RDM      = 16;
SET @THF      = 32;
SET @PLD      = 64;
SET @DRK      = 128;
SET @BST      = 256;
SET @BRD      = 512;
SET @RNG      = 1024;
SET @SAM      = 2048;
SET @NIN      = 4096;
SET @DRG      = 8192;
SET @SMN      = 16384;
SET @BLU      = 32768;
SET @COR      = 65536;
SET @PUP      = 131072;
SET @DNC      = 262144;
SET @SCH      = 524288;
SET @GEO      = 1048576;
SET @RUN      = 2097152;
SET @ALL_JOBS = 4194303;

--
-- Slots
--
SET @SLOT_TWOHAND  = 1;
SET @SLOT_OFFHAND  = 2;
SET @SLOT_MAINHAND = 3;
SET @SLOT_RANGED   = 4;
SET @SLOT_AMMO     = 8;

SET @SLOT_HEAD  = 16;
SET @SLOT_BODY  = 32;
SET @SLOT_HANDS = 64;
SET @SLOT_LEGS  = 128;
SET @SLOT_FEET  = 256;

SET @SLOT_NECK  = 512;
SET @SLOT_WAIST = 1024;
SET @SLOT_EAR   = 6144;
SET @SLOT_RING  = 24576;
SET @SLOT_BACK  = 32768;

--
-- Damage Type
--
SET @DMG_PIERCING = 1;
SET @DMG_SLASHING = 2;
SET @DMG_BLUNT    = 3;
SET @DMG_IMPACT   = 4;

--
-- Skills
--
SET @SKILL_HAND_TO_HAND = 1;
SET @SKILL_DAGGER       = 2;
SET @SKILL_SWORD        = 3;
SET @SKILL_GREAT_SWORD  = 4;
SET @SKILL_AXE          = 5;
SET @SKILL_GREAT_AXE    = 6;
SET @SKILL_SCYTHE       = 7;
SET @SKILL_POLEARM      = 8;
SET @SKILL_KATANA       = 9;
SET @SKILL_GREAT_KATANA = 10;
SET @SKILL_CLUB         = 11;
SET @SKILL_STAFF        = 12;

SET @SKILL_ARCHERY      = 25;
SET @SKILL_MARKSMANSHIP = 26;
SET @SUBSKILL_CROSSBOW  = 0;
SET @SUBSKILL_GUN       = 1;
SET @SUBSKILL_CANNON    = 2;

SET @SKILL_WIND         = 42;

--
-- AH Categories
--

SET @AH_H2H         =   1; -- Weapons->H2h
SET @AH_DAGGER      =   2; -- Weapons->Dagger
SET @AH_SWORD       =   3; -- Weapons->Sword
SET @AH_GREATSWORD  =   4; -- Weapons->Greatsword
SET @AH_AXE         =   5; -- Weapons->Axe
SET @AH_GREATAXE    =   6; -- Weapons->Greataxe
SET @AH_SCYTHE      =   7; -- Weapons->Scythe
SET @AH_POLEARM     =   8; -- Weapons->Polearm
SET @AH_KATANA      =   9; -- Weapons->Katana
SET @AH_GREATKATANA =  10; -- Weapons->Greatkatana
SET @AH_CLUB        =  11; -- Weapons->Club
SET @AH_STAFF       =  12; -- Weapons->Staff
SET @AH_BOW         =  13; -- Weapons->Bow
SET @AH_INSTRUMENTS =  14; -- Weapons->Instruments
SET @AH_AMMUNITION  =  15; -- Weapons->Ammo&Misc->Ammunition
SET @AH_SHIELD      =  16; -- Armor->Shield
SET @AH_HEAD        =  17; -- Armor->Head
SET @AH_BODY        =  18; -- Armor->Body
SET @AH_HANDS       =  19; -- Armor->Hands
SET @AH_LEGS        =  20; -- Armor->Legs
SET @AH_FEET        =  21; -- Armor->Feet
SET @AH_NECK        =  22; -- Armor->Neck
SET @AH_WAIST       =  23; -- Armor->Waist
SET @AH_EARRINGS    =  24; -- Armor->Earrings
SET @AH_RINGS       =  25; -- Armor->Rings
SET @AH_BACK        =  26; -- Armor->Back

SET @SMITHING       =  38; -- Materials->Smithing
SET @GOLDSMITHING   =  39; -- Materials->Goldsmithing
SET @CLOTHCRAFT     =  40; -- Materials->Clothcraft
SET @LEATHERCRAFT   =  41; -- Materials->Leathercraft
SET @BONECRAFT      =  42; -- Materials->Bonecraft
SET @WOODWORKING    =  43; -- Materials->Woodworking
SET @ALCHEMY        =  44; -- Materials->Alchemy

SET @AH_MISC        =  46; -- Misc

SET @AH_SWEETS      =  57; -- Food->Meals->Sweets

SET @AH_GRIPS       =  62; -- Weapons->Ammo&Misc->Grips

--
-- Crystals
--
SET @FIRE_CRYSTAL      = 4096;
SET @ICE_CRYSTAL       = 4097;
SET @WIND_CRYSTAL      = 4098;
SET @EARTH_CRYSTAL     = 4099;
SET @LIGHTNING_CRYSTAL = 4100;
SET @WATER_CRYSTAL     = 4101;
SET @LIGHT_CRYSTAL     = 4102;
SET @DARK_CRYSTAL      = 4103;

SET @INFERNO_CRYSTAL   = 4238;
SET @GLACIER_CRYSTAL   = 4239;
SET @CYCLONE_CRYSTAL   = 4240;
SET @TERRA_CRYSTAL     = 4241;
SET @PLASMA_CRYSTAL    = 4242;
SET @TORRENT_CRYSTAL   = 4243;
SET @AURORA_CRYSTAL    = 4244;
SET @TWILIGHT_CRYSTAL  = 4245;

--
-- Elements
--
SET @ELEMENT_FIRE    = 1;
SET @ELEMENT_ICE     = 2;
SET @ELEMENT_WIND    = 3;
SET @ELEMENT_EARTH   = 4;
SET @ELEMENT_THUNDER = 5;
SET @ELEMENT_WATER   = 6;
SET @ELEMENT_LIGHT   = 7;
SET @ELEMENT_DARK    = 8;

--
-- Mods
--
SET @PET_ALL       = 0;
SET @PET_AVATAR    = 1;
SET @PET_AUTOMATON = 3;
SET @PET_LUOPAN    = 8;

SET @MOD_DEF = 1;
SET @MOD_HP  = 2;
SET @MOD_MP  = 5;

SET @MOD_HP2MP = 7;
SET @MOD_STR =  8;
SET @MOD_DEX =  9;
SET @MOD_VIT = 10;
SET @MOD_AGI = 11;
SET @MOD_INT = 12;
SET @MOD_MND = 13;
SET @MOD_CHR = 14;

SET @MOD_FIRE_RES    = 15;
SET @MOD_ICE_RES     = 16;
SET @MOD_WIND_RES    = 17;
SET @MOD_EARTH_RES   = 18;
SET @MOD_THUNDER_RES = 19;
SET @MOD_WATER_RES   = 20;
SET @MOD_LIGHT_RES   = 21;
SET @MOD_DARK_RES    = 22;

SET @MOD_ATT    = 23;
SET @MOD_RATT   = 24;
SET @MOD_ACC    = 25;
SET @MOD_RACC   = 26;
SET @MOD_ENMITY = 27;
SET @MOD_MATT   = 28;
SET @MOD_MDEF   = 29;
SET @MOD_MACC   = 30;
SET @MOD_MEVA   = 31;
SET @MOD_WSACC  = 48;

SET @MOD_TP_OVER     =  7;
SET @MOD_UNDER_LEVEL = 50;
SET @MOD_ABOVE_LEVEL = 51;
SET @MOD_EVA         = 68;
SET @MOD_HMP         = 71;
SET @MOD_HHP         = 72;
SET @MOD_STORE_TP    = 73;
SET @MOD_MOVESPEED   = 76;

SET @MOD_HTH_SKILL     = 80;
SET @MOD_DAGGER_SKILL  = 81;
SET @MOD_SWORD_SKILL   = 82;
SET @MOD_GSWORD_SKILL  = 83;
SET @MOD_AXE_SKILL     = 84;
SET @MOD_GAXE_SKILL    = 85;
SET @MOD_SCYTHE_SKILL  = 86;
SET @MOD_POLEARM_SKILL = 87;
SET @MOD_KATANA_SKILL  = 88;
SET @MOD_GKATANA_SKILL = 89;
SET @MOD_CLUB_SKILL    = 90;
SET @MOD_STAFF_SKILL   = 91;

SET @MOD_AUTO_MAGIC_SKILL  = 103;
SET @MOD_ARCHERY_SKILL     = 104;
SET @MOD_MARKSMAN_SKILL    = 105;
SET @MOD_THROWING_SKILL    = 106;

SET @MOD_GUARD_SKILL   = 107;
SET @MOD_EVASION_SKILL = 108;
SET @MOD_SHIELD_SKILL  = 109;
SET @MOD_PARRY_SKILL   = 110;

SET @MOD_DIVINE_SKILL    = 111;
SET @MOD_HEALING_SKILL   = 112;
SET @MOD_ENHANCE_SKILL   = 113;
SET @MOD_ENFEEBLE_SKILL  = 114;
SET @MOD_ELEMENTAL_SKILL = 115;
SET @MOD_DARK_SKILL      = 116;
SET @MOD_SUMMONING_SKILL = 117;
SET @MOD_NINJUTSU_SKILL  = 118;
SET @MOD_SINGING_SKILL   = 119;
SET @MOD_STRING_SKILL    = 120;
SET @MOD_WIND_SKILL      = 121;
SET @MOD_BLUE_SKILL      = 122;
SET @MOD_GEOMANCY_SKILL  = 123;
SET @MOD_HANDBELL_SKILL  = 124;

SET @MOD_BP_DAMAGE       = 126;
SET @MOD_FISHING_SKILL   = 127;

SET @MOD_DAMAGE_TAKEN        = 160;
SET @MOD_PHYS_DMG_TAKEN      = 161;
SET @MOD_BREATH_DMG_TAKEN    = 162;
SET @MOD_MAGIC_DMG_TAKEN     = 163;
SET @MOD_CRIT_HIT_RATE       = 165;
SET @MOD_SPELL_INTERRUPT     = 168;
SET @MOD_MARTIAL_ARTS        = 173;
SET @MOD_SKILLCHAIN_DMG      = 175;
SET @MOD_DMGPHYS_II          = 190;
SET @MOD_MAGIC_DMG_TAKEN_II  = 831;

SET @MOD_FASTCAST    = 170;
SET @MOD_CONSERVE_MP = 296;

SET @MOD_VERMIN_KILLER   = 224;
SET @MOD_BIRD_KILLER     = 225;
SET @MOD_AMORPH_KILLER   = 226;
SET @MOD_LIZARD_KILLER   = 227;
SET @MOD_AQUAN_KILLER    = 228;
SET @MOD_PLANTOID_KILLER = 229;
SET @MOD_BEAST_KILLER    = 230;
SET @MOD_UNDEAD_KILLER   = 231;
SET @MOD_ARCANA_KILLER   = 232;
SET @MOD_DRAGON_KILLER   = 233;
SET @MOD_DEMON_KILLER    = 234;
SET @MOD_EMPTY_KILLER    = 235;
SET @MOD_HUMANOID_KILLER = 236;
SET @MOD_LUMINIAN_KILLER = 237;
SET @MOD_LUMINION_KILLER = 238;

SET @MOD_AFTERMATH       = 256;
SET @MOD_DUAL_WIELD      = 259;
SET @MOD_WEAPON_DMG      = 287;
SET @MOD_DOUBLE_ATK      = 288;
SET @MOD_SUBTLE_BLOW     = 289;
SET @MOD_COUNTER         = 291;
SET @MOD_TRIPLE_ATK      = 302;
SET @MOD_TREASURE_HUNTER = 303;
SET @MOD_ZANSHIN         = 306;
SET @MOD_NINJA_TOOL      = 308;
SET @MOD_ENH_DRAIN_ASPIR = 315;
SET @MOD_TP_BONUS        = 345;

SET @MOD_JUMP_TP_BONUS      = 361;
SET @MOD_SNAPSHOT           = 365;
SET @MOD_CURE_POTENCY_RCVD  = 375;
SET @MOD_JUMP_DOUBLE_ATTACK = 888;

SET @MOD_FIRE_AFFINITY_DMG    = 347;
SET @MOD_ICE_AFFINITY_DMG     = 348;
SET @MOD_WIND_AFFINITY_DMG    = 349;
SET @MOD_EARTH_AFFINITY_DMG   = 350;
SET @MOD_THUNDER_AFFINITY_DMG = 351;
SET @MOD_WATER_AFFINITY_DMG   = 352;
SET @MOD_LIGHT_AFFINITY_DMG   = 353;
SET @MOD_DARK_AFFINITY_DMG    = 354;

SET @MOD_ENMITY_LOSS_REDUCTION   = 427;
SET @MOD_ITEM_ADDEFFECT_TYPE     = 431;
SET @MOD_ITEM_SUBEFFECT          = 499;
SET @MOD_ITEM_ADDEFFECT_DMG      = 500;
SET @MOD_ITEM_ADDEFFECT_CHANCE   = 501;
SET @MOD_LIGHT_AFFINITY_PERP     = 559;
SET @MOD_ITEM_ADDEFFECT_ELEMENT  = 950;
SET @MOD_ITEM_ADDEFFECT_STATUS   = 951;
SET @MOD_ITEM_ADDEFFECT_DURATION = 953;

SET @MOD_REGEN_DURATION = 339;
SET @MOD_DAY_REDUCTION  = 373;
SET @MOD_STEP_ACCURACY  = 403;

SET @MOD_LULLABY_EFFECT         = 440;
SET @MOD_BALLAD_EFFECT          = 442;
SET @MOD_SONG_DURATION_BONUS    = 454;

SET @MOD_TACTICAL_PARRY        = 486;
SET @MOD_GRIMOIRE_SPELLCASTING = 489;
SET @MOD_SAMBA_DURATION        = 490;
SET @MOD_WALTZ_POTENCY         = 491;

SET @MOD_PHALANX            = 301;
SET @MOD_AVATAR_PERP        = 346;
SET @MOD_ADDS_WEAPONSKILL   = 355;
SET @MOD_BP_DELAY           = 357;
SET @MOD_RAPID_SHOT         = 359;
SET @MOD_REFRESH            = 369;
SET @MOD_REGEN              = 370;
SET @MOD_CURE_POTENCY       = 374;
SET @MOD_HASTE              = 384;
SET @MOD_RETALIATION        = 414;
SET @MOD_CRITICAL_DMG       = 421;
SET @MOD_ENSPELL_DMG_BONUS  = 432;
SET @MOD_ALL_SONGS          = 452;
SET @MOD_MAG_BURST_BONUS    = 487;
SET @MOD_OVERLOAD_THRESH    = 505;
SET @MOD_ABSORB_DMG_TO_MP   = 516;
SET @MOD_CURE_CAST_TIME     = 519;
SET @MOD_ABSORB_POTENCY     = 521;
SET @MOD_ROLL_RANGE         = 528;
SET @MOD_BP_DELAY_II        = 541;

SET @MOD_FIRE_AFFINITY_ACC    = 544;
SET @MOD_ICE_AFFINITY_ACC     = 545;
SET @MOD_WIND_AFFINITY_ACC    = 546;
SET @MOD_EARTH_AFFINITY_ACC   = 547;
SET @MOD_THUNDER_AFFINITY_ACC = 548;
SET @MOD_WATER_AFFINITY_ACC   = 549;
SET @MOD_LIGHT_AFFINITY_ACC   = 550;
SET @MOD_DARK_AFFINITY_ACC    = 551;
SET @MOD_IRIDESCENCE          = 566;
SET @MOD_WYVERN_BREATH_PROC   = 829;

SET @MOD_CURE2MP_PERCENT      = 860;
SET @MOD_ENH_MAGIC_DURATION   = 890;
SET @MOD_GILFINDER            = 897;
SET @MOD_ELEMENTAL_CELERITY   = 901;
SET @MOD_OCCULT_ACUMEN        = 902;
SET @MOD_FENCER_TP_BONUS      = 903;
SET @MOD_FENCER_CRITHITRATE   = 904;
SET @MOD_DAKEN_RATE           = 911;
SET @MOD_BLOOD_BOON           = 913;
SET @MOD_BERSERK_DURATION     = 954;
SET @MOD_AGGRESSOR_DURATION   = 955;
SET @MOD_GEOMANCY_BONUS       = 961;
SET @MOD_PARRYING_RATE        = 963;
SET @MOD_ENHANCES_PRO_SHELL   = 977;
SET @MOD_OCCASIONALLY_ATTACKS = 978;
SET @MOD_PET_MAB_MDB          = 992;
SET @MOD_TRIPLE_SHOT_RATE     = 999;
SET @MOD_STEP_TP_CONSUMED     = 1077;

SET @MOD_REPAIR_POTENCY = 854;

SET @MOD_SWIPE                  = 1016;
SET @MOD_REPRISAL_BLOCK_BONUS   = 1067;
SET @MOD_REPRISAL_SPIKES_BONUS  = 1068;

SET @MOD_FISHING_FATIGUE        = 2004;
SET @MOD_FISHING_GOLD_ARROW     = 2005;

SET @LATENT_TP_OVER       =   7;
SET @LATENT_STATUS_EFFECT =  13;
SET @LATENT_PARTY_SIZE    =  15;
SET @LATENT_ZONE          =  23;
SET @LATENT_WEAPON_DRAWN  =  56;
SET @EFFECT_ELVORSEAL     = 603;
SET @EFFECT_ICE_SPIKES    =  35;

SET @SYNTH_SKILL_GAIN    =  852;

-- Midras's Helm +1
DELETE FROM `item_mods` WHERE `itemId` = 25637;
INSERT INTO `item_mods` VALUES (25637,852,5); -- SYNTH_SKILL_GAIN: 5

-- Shadow Ring 25% deathres
UPDATE item_mods set value = 25 where itemid = 14646 and modid = 255;

-- Beitetsu Parcel (gives escha beads)
UPDATE item_usable SET animation = "117" WHERE itemId = "6392";

-- Add Escha Pouch to db (gives escha beads)
DELETE FROM `item_usable` WHERE itemId = 6392;
INSERT INTO item_usable VALUES (6392,'bead_pouch',1,1,117,0,0,0,0,0);
DELETE FROM `item_equipment` WHERE name = 'ark_shield';
INSERT INTO `item_equipment` VALUES (26490,'ark_shield',1,0,4194303,674,5,0,2,0,0,0);

-- Add Shobuhouou Kabuto to db (Lvl 1 Head - Enchantment: Raise)
DELETE FROM `item_usable` WHERE itemId = 26789;
INSERT INTO item_usable VALUES (26789,'shobuhouou_kabuto',32,8,33,0,1,30,72000,0);

-- Remove modifiers for Judge's Cape
DELETE FROM `item_mods` WHERE itemId = 13606;

-- Prevent Mandau damage spike (move to latent)
-- 506 EXTRA_DMG_CHANCE: 50
-- 507 OCC_DO_EXTRA_DMG: 300
DELETE FROM `item_latents` WHERE  `itemId`=18270 AND `modId`=506 AND `value`=50 AND `latentId`=40 AND `latentParam`=0;
DELETE FROM `item_latents` WHERE  `itemId`=18270 AND `modId`=507 AND `value`=300 AND `latentId`=40 AND `latentParam`=0;
INSERT INTO `item_latents` VALUES (18270,506,50,40,0);     -- Mandau EXTRA_DMG_CHANCE 5% in Main hand (50 -> 5%)
INSERT INTO `item_latents` VALUES (18270,507,300,40,0);    -- Mandau OCC_DO_EXTRA_DMG * 3 in Main hand (300 -> * 3)

-- Prevent Vajra damage spike (move to latent)
-- 526 AUGMENTS_SA: 10
-- 527 AUGMENTS_TA: 10
DELETE FROM `item_latents` WHERE  `itemId`=18996 AND `modId`=526 AND `value`=10 AND `latentId`=40 AND `latentParam`=0;
DELETE FROM `item_latents` WHERE  `itemId`=18996 AND `modId`=527 AND `value`=10 AND `latentId`=40 AND `latentParam`=0;
INSERT INTO `item_latents` VALUES (18996,526,10,40,0);     -- Vajra AUGMENTS_SA in Main hand
INSERT INTO `item_latents` VALUES (18996,527,10,40,0);     -- Vajra AUGMENTS_TA in Main hand

-- Fix model ids for lockstyle gear
UPDATE item_equipment SET MId = "367" WHERE itemId = "27880"; -- Overalls (female)
UPDATE item_equipment SET MId = "367" WHERE itemId = "27734"; -- Straw Hat (female)

-- Octave club setup
DELETE FROM item_latents WHERE itemId = "18852"; -- remove job divisor latent from octave club
DELETE FROM item_weapon WHERE itemID = "18852"; -- remove stats from octave club
INSERT INTO item_weapon VALUES (18852,'octave_club',11,0,0,0,0,3,8,264,11,0); -- add kraken club stats to octave club

-- Unable to throw Nokizaru Shuriken from KSNM99
-- (Needs review, as this will affect Daken)
-- DELETE FROM item_weapon WHERE itemID = 18173;
-- INSERT INTO item_weapon VALUES (18173,'nokizaru_shuriken',0,0,0,0,0,0,1,999,0,0);

-- Missing food entries
DELETE FROM item_usable WHERE itemid IN (6258, 6259, 6381);
INSERT INTO item_usable VALUES (6258, 'piece_of_shiromochi',1,1,28,0,0,0,0,0);
INSERT INTO item_usable VALUES (6259, 'piece_of_shiromochi_+1',1,1,28,0,0,0,0,0);
INSERT INTO item_usable VALUES (6381, 'fishermans_feast',1,1,28,0,0,0,0,0);

-- Missing Byakko Masque model ID
DELETE FROM `item_equipment` WHERE name = 'byakko_masque';
INSERT INTO `item_equipment` VALUES (23737,'byakko_masque',1,0,4194303,459,0,0,16,0,0,0);

-- EXP scrolls stackable and not rare
UPDATE `item_basic` SET stackSize = 12, flags = 30276 WHERE `name` IN (
    'page_from_miratetes_memoirs',
    'copy_of_ginuvas_battle_theory',
    'copy_of_schultz_stratagems',
    'page_from_the_dragon_chronicles'
);

UPDATE `item_basic` SET stackSize = 12 WHERE `name` IN (
    'creel_of_moat_carp',
    'creel_of_forest_carp'
);

UPDATE `item_usable` SET activation = 1, animation = 55 WHERE `name` IN (
    'creel_of_moat_carp',
    'creel_of_forest_carp'
);

-- Dynamis - Valkurm weakening items for zone boss
DELETE FROM item_usable WHERE itemid IN (5895, 5896, 5897);
INSERT INTO item_usable VALUES (5895, 'odorless_fungus',4,2,0,0,0,0,0,0);
INSERT INTO item_usable VALUES (5896, 'clump_of_absorbent_moss',4,2,0,0,0,0,0,0);
INSERT INTO item_usable VALUES (5897, 'redolent_root',4,2,0,0,0,0,0,0);

-- Dynamis - Buburimu weakening items for zone boss
DELETE FROM item_usable WHERE itemid IN (5898, 5899, 5900, 5901, 5902);
INSERT INTO item_usable VALUES (5898, 'shadescale_skull',4,2,0,0,0,0,0,0);
INSERT INTO item_usable VALUES (5899, 'shadescale_femur',4,2,0,0,0,0,0,0);
INSERT INTO item_usable VALUES (5900, 'shadescale_talon',4,2,0,0,0,0,0,0);
INSERT INTO item_usable VALUES (5901, 'shadescale_heart',4,2,0,0,0,0,0,0);
INSERT INTO item_usable VALUES (5902, 'vial_of_cagebeast_blood',4,2,0,0,0,0,0,0);

-- Dynamis - Qufim weakening items for zone boss
DELETE FROM item_usable WHERE itemid IN (5903, 5904, 5905);
INSERT INTO item_usable VALUES (5903, 'vial_of_sea_monk_venom',4,2,0,0,0,0,0,0);
INSERT INTO item_usable VALUES (5904, 'perforated_wing',4,2,0,0,0,0,0,0);
INSERT INTO item_usable VALUES (5905, 'undying_moiety',4,2,0,0,0,0,0,0);

-- Scaled down items
--
UPDATE `item_equipment` SET level = 65, ilevel = 0, su_level = 0 WHERE itemId IN (
    @PROUESSE_RING, @FURTIVE_GRIP
);

SET @KILLERS_KILIJ = 18914;
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId = @KILLERS_KILIJ;
UPDATE `item_weapon`    SET dmg = 42 WHERE itemId = @KILLERS_KILIJ;
DELETE FROM `item_mods` WHERE itemId = @KILLERS_KILIJ;
INSERT INTO `item_mods` VALUES
    (@KILLERS_KILIJ, @MOD_MP,             30),
    (@KILLERS_KILIJ, @MOD_DEX,             2),
    (@KILLERS_KILIJ, @MOD_VIT,             2),
    (@KILLERS_KILIJ, @MOD_VERMIN_KILLER,   5),
    (@KILLERS_KILIJ, @MOD_BIRD_KILLER,     5),
    (@KILLERS_KILIJ, @MOD_AMORPH_KILLER,   5),
    (@KILLERS_KILIJ, @MOD_LIZARD_KILLER,   5),
    (@KILLERS_KILIJ, @MOD_AQUAN_KILLER,    5),
    (@KILLERS_KILIJ, @MOD_PLANTOID_KILLER, 5),
    (@KILLERS_KILIJ, @MOD_BEAST_KILLER,    5),
    (@KILLERS_KILIJ, @MOD_UNDEAD_KILLER,   5),
    (@KILLERS_KILIJ, @MOD_ARCANA_KILLER,   5),
    (@KILLERS_KILIJ, @MOD_DRAGON_KILLER,   5),
    (@KILLERS_KILIJ, @MOD_DEMON_KILLER,    5),
    (@KILLERS_KILIJ, @MOD_EMPTY_KILLER,    5),
    (@KILLERS_KILIJ, @MOD_HUMANOID_KILLER, 5),
    (@KILLERS_KILIJ, @MOD_LUMINIAN_KILLER, 5),
    (@KILLERS_KILIJ, @MOD_LUMINION_KILLER, 5);

SET @ERADICATORS_KILIJ = 18915;
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId = @ERADICATORS_KILIJ;
UPDATE `item_weapon`    SET dmg = 43 WHERE itemId = @ERADICATORS_KILIJ;
DELETE FROM `item_mods` WHERE itemId = @ERADICATORS_KILIJ;
INSERT INTO `item_mods` VALUES
    (@ERADICATORS_KILIJ, @MOD_MP,             35),
    (@ERADICATORS_KILIJ, @MOD_DEX,             3),
    (@ERADICATORS_KILIJ, @MOD_VIT,             3),
    (@ERADICATORS_KILIJ, @MOD_VERMIN_KILLER,   6),
    (@ERADICATORS_KILIJ, @MOD_BIRD_KILLER,     6),
    (@ERADICATORS_KILIJ, @MOD_AMORPH_KILLER,   6),
    (@ERADICATORS_KILIJ, @MOD_LIZARD_KILLER,   6),
    (@ERADICATORS_KILIJ, @MOD_AQUAN_KILLER,    6),
    (@ERADICATORS_KILIJ, @MOD_PLANTOID_KILLER, 6),
    (@ERADICATORS_KILIJ, @MOD_BEAST_KILLER,    6),
    (@ERADICATORS_KILIJ, @MOD_UNDEAD_KILLER,   6),
    (@ERADICATORS_KILIJ, @MOD_ARCANA_KILLER,   6),
    (@ERADICATORS_KILIJ, @MOD_DRAGON_KILLER,   6),
    (@ERADICATORS_KILIJ, @MOD_DEMON_KILLER,    6),
    (@ERADICATORS_KILIJ, @MOD_EMPTY_KILLER,    6),
    (@ERADICATORS_KILIJ, @MOD_HUMANOID_KILLER, 6),
    (@ERADICATORS_KILIJ, @MOD_LUMINIAN_KILLER, 6),
    (@ERADICATORS_KILIJ, @MOD_LUMINION_KILLER, 6);

SET @DAGDAS_SHIELD = 16202;
UPDATE `item_equipment` SET level = 70, ilevel = 0, su_level = 0 WHERE itemId = @DAGDAS_SHIELD;
DELETE FROM `item_mods` WHERE itemId = @DAGDAS_SHIELD;
INSERT INTO `item_mods` VALUES
    (@DAGDAS_SHIELD, @MOD_DEF,          20),
    (@DAGDAS_SHIELD, @MOD_ENMITY,        2),
    (@DAGDAS_SHIELD, @MOD_CURE_POTENCY,  5);

SET @POTESTAS_BOMBLET = 19779;
UPDATE `item_equipment` SET level = 70, ilevel = 0, su_level = 0 WHERE itemId = @POTESTAS_BOMBLET;
DELETE FROM `item_mods` WHERE itemId = @POTESTAS_BOMBLET;
INSERT INTO `item_mods` VALUES
    (@POTESTAS_BOMBLET, @MOD_FIRE_RES, 10),
    (@POTESTAS_BOMBLET, @MOD_ATT,       5);

SET @GRAPEVINE_CAPE = 11575;
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId = @GRAPEVINE_CAPE;
DELETE FROM `item_mods` WHERE itemId = @GRAPEVINE_CAPE;
INSERT INTO `item_mods` VALUES
    (@GRAPEVINE_CAPE, @MOD_DEF,                7),
    (@GRAPEVINE_CAPE, @MOD_INT,                3),
    (@GRAPEVINE_CAPE, @MOD_MND,                3),
    (@GRAPEVINE_CAPE, @MOD_ENH_MAGIC_DURATION, 3);

SET @MELACO_MITTENS = 11920;
UPDATE `item_equipment` SET level = 72, ilevel = 0, su_level = 0 WHERE itemId = @MELACO_MITTENS;
DELETE FROM `item_mods` WHERE itemId = @MELACO_MITTENS;
INSERT INTO `item_mods` VALUES
    (@MELACO_MITTENS, @MOD_DEF,              16),
    (@MELACO_MITTENS, @MOD_MND,               3),
    (@MELACO_MITTENS, @MOD_PHYS_DMG_TAKEN, -300),
    (@MELACO_MITTENS, @MOD_BIRD_KILLER,       2);

SET @BOND_CAPE = 11576;
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId = @BOND_CAPE;
DELETE FROM `item_latents` WHERE itemId = @BOND_CAPE;
INSERT INTO `item_latents` VALUES (@BOND_CAPE, @MOD_MACC, 1, @LATENT_PARTY_SIZE, 3);
INSERT INTO `item_latents` VALUES (@BOND_CAPE, @MOD_MACC, 2, @LATENT_PARTY_SIZE, 4);
INSERT INTO `item_latents` VALUES (@BOND_CAPE, @MOD_MACC, 3, @LATENT_PARTY_SIZE, 5);
INSERT INTO `item_latents` VALUES (@BOND_CAPE, @MOD_MACC, 4, @LATENT_PARTY_SIZE, 6);
DELETE FROM `item_mods` WHERE itemId = @BOND_CAPE;
INSERT INTO `item_mods` VALUES
    (@BOND_CAPE, @MOD_DEF,  7),
    (@BOND_CAPE, @MOD_MP,  15),
    (@BOND_CAPE, @MOD_MND,  3);

SET @PROUESSE_RING = 11677;
UPDATE `item_equipment` SET level = 65, ilevel = 0, su_level = 0 WHERE itemId = @PROUESSE_RING;

SET @NUMEN_STAFF = 18624;
DELETE FROM `item_latents` WHERE itemId = @NUMEN_STAFF;
INSERT INTO `item_latents` VALUES (@NUMEN_STAFF, @MOD_REFRESH, 1, @LATENT_WEAPON_DRAWN, 2);
DELETE FROM `item_mods` WHERE itemId = @NUMEN_STAFF;
INSERT INTO `item_mods` VALUES
    (@NUMEN_STAFF, @MOD_MP,  25),
    (@NUMEN_STAFF, @MOD_HMP, 11);
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId = @NUMEN_STAFF;

SET @OSSA_GRIP = 18812;
DELETE FROM `item_latents` WHERE itemId = @OSSA_GRIP;
INSERT INTO `item_latents` VALUES (@OSSA_GRIP, @MOD_ENH_MAGIC_DURATION, 5, @LATENT_STATUS_EFFECT, @EFFECT_ICE_SPIKES);
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId = @OSSA_GRIP;

SET @COCOON_BAND = 11823;
UPDATE `item_equipment` SET level = 71, ilevel = 0, su_level = 0 WHERE itemId = @COCOON_BAND;
DELETE FROM `item_latents` WHERE itemId = @COCOON_BAND;
DELETE FROM `item_mods` WHERE itemId = @COCOON_BAND;
INSERT INTO `item_mods` VALUES
    (@COCOON_BAND, @MOD_DEF,        65),
    (@COCOON_BAND, @MOD_WIND_RES,  -10),
    (@COCOON_BAND, @MOD_HASTE,    -500);

SET @METASOMA_KATARS = 18784;
UPDATE `item_equipment` SET level = 69, ilevel = 0, su_level = 0 WHERE itemId = @METASOMA_KATARS;
UPDATE `item_weapon`    SET dmg = 17 WHERE itemId = @METASOMA_KATARS;
DELETE FROM `item_mods` WHERE itemId = @METASOMA_KATARS;
INSERT INTO `item_mods` VALUES
    (@METASOMA_KATARS, @MOD_ATT,                 5),
    (@METASOMA_KATARS, @MOD_ITEM_ADDEFFECT_TYPE, 1);

SET @DRAGONKIN_EARRING = 11038;
UPDATE `item_equipment` SET level = 72, ilevel = 0, su_level = 0 WHERE itemId = @DRAGONKIN_EARRING;
DELETE FROM `item_mods` WHERE itemId = @DRAGONKIN_EARRING;
INSERT INTO `item_mods` VALUES (@DRAGONKIN_EARRING, @MOD_ATT, 5);

SET @BRACHYURA_EARRING = 11039;
UPDATE `item_equipment` SET level = 70, ilevel = 0, su_level = 0 WHERE itemId = @BRACHYURA_EARRING;
DELETE FROM `item_mods` WHERE itemId = @BRACHYURA_EARRING;
INSERT INTO `item_mods` VALUES
    (@BRACHYURA_EARRING, @MOD_MP,                 15),
    (@BRACHYURA_EARRING, @MOD_ENHANCES_PRO_SHELL,  1);

SET @WIZZAN_GRIP = 18816;
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId = @WIZZAN_GRIP;
DELETE FROM `item_mods` WHERE itemId = @WIZZAN_GRIP;
INSERT INTO `item_mods` VALUES
    (@WIZZAN_GRIP, @MOD_INT,         2),
    (@WIZZAN_GRIP, @MOD_CONSERVE_MP, 1);

SET @TERMINUS_EARRING = 11040;
UPDATE `item_equipment` SET level = 70, ilevel = 0, su_level = 0 WHERE itemId = @TERMINUS_EARRING;

SET @LIMINUS_EARRING = 11041;
UPDATE `item_equipment` SET level = 70, ilevel = 0, su_level = 0 WHERE itemId = @LIMINUS_EARRING;

SET @FURTIVE_GRIP = 18817;
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId = @FURTIVE_GRIP;

SET @RANCOROUS_MANTLE  = 10991;
UPDATE `item_equipment` SET level = 72, ilevel = 0, su_level = 0 WHERE itemId = @RANCOROUS_MANTLE;
DELETE FROM `item_mods` WHERE itemId = @RANCOROUS_MANTLE;
INSERT INTO `item_mods` VALUES
    (@RANCOROUS_MANTLE, @MOD_DEF, 7),
    (@RANCOROUS_MANTLE, @MOD_ATT, 8),
    (@RANCOROUS_MANTLE, @MOD_CRIT_HIT_RATE, 2),
    (@RANCOROUS_MANTLE, @MOD_DAMAGE_TAKEN, 10);

SET @MANA_AMPULLA = 19780;
UPDATE `item_equipment` SET level = 70, ilevel = 0, su_level = 0 WHERE itemId = @MANA_AMPULLA;
DELETE FROM `item_mods` WHERE itemId = @MANA_AMPULLA;
INSERT INTO `item_mods` VALUES
    (@MANA_AMPULLA, @MOD_MP,  15),
    (@MANA_AMPULLA, @MOD_MND,  1),
    (@MANA_AMPULLA, @MOD_HMP,  1);

SET @BUZBAZ_SAINTI = 18791;
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId = @BUZBAZ_SAINTI;
UPDATE `item_weapon`    SET dmg = 18 WHERE itemId = @BUZBAZ_SAINTI;
DELETE FROM `item_mods` WHERE itemId = @BUZBAZ_SAINTI;
INSERT INTO `item_mods` VALUES
    (@BUZBAZ_SAINTI, @MOD_OVERLOAD_THRESH,      5);

DELETE FROM `item_mods_pet` WHERE itemId = @BUZBAZ_SAINTI;
INSERT INTO `item_mods_pet` VALUES
    (@BUZBAZ_SAINTI, @MOD_HP,  10, @PET_AUTOMATON),
    (@BUZBAZ_SAINTI, @MOD_ATT,  5, @PET_AUTOMATON),
    (@BUZBAZ_SAINTI, @MOD_RATT, 5, @PET_AUTOMATON);

SET @BUZBAZ_SAINTI_P1 = 18792;
UPDATE `item_equipment` SET level = 75, ilevel = 0, su_level = 0 WHERE itemId = @BUZBAZ_SAINTI_P1;
UPDATE `item_weapon`    SET dmg = 19 WHERE itemId = @BUZBAZ_SAINTI_P1;
DELETE FROM `item_mods` WHERE itemId = @BUZBAZ_SAINTI_P1;
INSERT INTO `item_mods` VALUES
    (@BUZBAZ_SAINTI_P1, @MOD_OVERLOAD_THRESH,     10);

DELETE FROM `item_mods_pet` WHERE itemId = @BUZBAZ_SAINTI_P1;
INSERT INTO `item_mods_pet` VALUES
    (@BUZBAZ_SAINTI_P1, @MOD_HP,  15, @PET_AUTOMATON),
    (@BUZBAZ_SAINTI_P1, @MOD_ATT,  6, @PET_AUTOMATON),
    (@BUZBAZ_SAINTI_P1, @MOD_RATT, 6, @PET_AUTOMATON);

-----------------------------------
-- Level 97 crafted weapons. Turned into level 73 weapons. Long live synthesis.
-----------------------------------
SET @AISA = 19299;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @AISA;
UPDATE `item_weapon`    SET dmg = 38 WHERE itemId = @AISA;
DELETE FROM `item_mods` WHERE itemId = @AISA;
INSERT INTO `item_mods` VALUES
    (@AISA, @MOD_DEX,               2),
    (@AISA, @MOD_INT,               2),
    (@AISA, @MOD_SKILLCHAIN_DMG,    2),
    (@AISA, @MOD_MAG_BURST_BONUS,   2);

SET @AISA_P1 = 19300;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @AISA_P1;
UPDATE `item_weapon`    SET dmg = 39 WHERE itemId = @AISA_P1;
DELETE FROM `item_mods` WHERE itemId = @AISA_P1;
INSERT INTO `item_mods` VALUES
    (@AISA_P1, @MOD_DEX,               3),
    (@AISA_P1, @MOD_INT,               3),
    (@AISA_P1, @MOD_SKILLCHAIN_DMG,    3),
    (@AISA_P1, @MOD_MAG_BURST_BONUS,   3);

SET @APAISANTE = 18910;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @APAISANTE;
UPDATE `item_weapon`    SET dmg = 40 WHERE itemId = @APAISANTE;
DELETE FROM `item_mods` WHERE itemId = @APAISANTE;
INSERT INTO `item_mods` VALUES
    (@APAISANTE, @MOD_MP,                  15),
    (@APAISANTE, @MOD_MND,                  3),
    (@APAISANTE, @MOD_CURE_CAST_TIME,       6),
    (@APAISANTE, @MOD_SONG_DURATION_BONUS,  2);

SET @APAISANTE_P1 = 18911;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @APAISANTE_P1;
UPDATE `item_weapon`    SET dmg = 41 WHERE itemId = @APAISANTE_P1;
DELETE FROM `item_mods` WHERE itemId = @APAISANTE_P1;
INSERT INTO `item_mods` VALUES
    (@APAISANTE_P1, @MOD_MP,                  20),
    (@APAISANTE_P1, @MOD_MND,                  4),
    (@APAISANTE_P1, @MOD_CURE_CAST_TIME,       8),
    (@APAISANTE_P1, @MOD_SONG_DURATION_BONUS,  3);

SET @BREIDOX = 18543;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @BREIDOX;
UPDATE `item_weapon`    SET dmg = 47 WHERE itemId = @BREIDOX;
DELETE FROM `item_mods` WHERE itemId = @BREIDOX;
INSERT INTO `item_mods` VALUES
    (@BREIDOX, @MOD_HP,                   5),
    (@BREIDOX, @MOD_STR,                  3),
    (@BREIDOX, @MOD_ENMITY,               3),
    (@BREIDOX, @MOD_FENCER_TP_BONUS,     50),
    (@BREIDOX, @MOD_FENCER_CRITHITRATE,   1);

DELETE FROM `item_mods_pet` WHERE itemId = @BREIDOX;
INSERT INTO `item_mods_pet` VALUES
    (@BREIDOX, @MOD_STR, 3, @PET_ALL);

SET @BREIDOX_P1 = 18544;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @BREIDOX_P1;
UPDATE `item_weapon`    SET dmg = 48 WHERE itemId = @BREIDOX_P1;
DELETE FROM `item_mods` WHERE itemId = @BREIDOX_P1;
INSERT INTO `item_mods` VALUES
    (@BREIDOX_P1, @MOD_HP,                  10),
    (@BREIDOX_P1, @MOD_STR,                  4),
    (@BREIDOX_P1, @MOD_ENMITY,               4),
    (@BREIDOX_P1, @MOD_FENCER_TP_BONUS,    100),
    (@BREIDOX_P1, @MOD_FENCER_CRITHITRATE,   2);

DELETE FROM `item_mods_pet` WHERE itemId = @BREIDOX_P1;
INSERT INTO `item_mods_pet` VALUES
    (@BREIDOX_P1, @MOD_STR, 4, @PET_ALL);

SET @ETOURDISSANTE = 19177;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @ETOURDISSANTE;
UPDATE `item_weapon`    SET dmg = 83 WHERE itemId = @ETOURDISSANTE;
DELETE FROM `item_mods` WHERE itemId = @ETOURDISSANTE;
INSERT INTO `item_mods` VALUES
    (@ETOURDISSANTE, @MOD_DEX,                      3),
    (@ETOURDISSANTE, @MOD_INT,                      3),
    (@ETOURDISSANTE, @MOD_DOUBLE_ATK,               1),
    (@ETOURDISSANTE, @MOD_ENMITY,                   1),
    (@ETOURDISSANTE, @MOD_ITEM_ADDEFFECT_TYPE,      2),
    (@ETOURDISSANTE, @MOD_ITEM_SUBEFFECT,          16),
    (@ETOURDISSANTE, @MOD_ITEM_ADDEFFECT_CHANCE,    2),
    (@ETOURDISSANTE, @MOD_ITEM_ADDEFFECT_STATUS,   10),
    (@ETOURDISSANTE, @MOD_ITEM_ADDEFFECT_DURATION,  2);

SET @ETOURDISSANTE_P1 = 19178;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @ETOURDISSANTE_P1;
UPDATE `item_weapon`    SET dmg = 84 WHERE itemId = @ETOURDISSANTE_P1;
DELETE FROM `item_mods` WHERE itemId = @ETOURDISSANTE_P1;
INSERT INTO `item_mods` VALUES
    (@ETOURDISSANTE_P1, @MOD_DEX,                      4),
    (@ETOURDISSANTE_P1, @MOD_INT,                      4),
    (@ETOURDISSANTE_P1, @MOD_DOUBLE_ATK,               2),
    (@ETOURDISSANTE_P1, @MOD_ENMITY,                   2),
    (@ETOURDISSANTE_P1, @MOD_ITEM_ADDEFFECT_TYPE,      2),
    (@ETOURDISSANTE_P1, @MOD_ITEM_SUBEFFECT,          16),
    (@ETOURDISSANTE_P1, @MOD_ITEM_ADDEFFECT_CHANCE,    3),
    (@ETOURDISSANTE_P1, @MOD_ITEM_ADDEFFECT_STATUS,   10),
    (@ETOURDISSANTE_P1, @MOD_ITEM_ADDEFFECT_DURATION,  3);

SET @FIRNAXE = 18522;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @FIRNAXE;
UPDATE `item_weapon`    SET dmg = 93 WHERE itemId = @FIRNAXE;
DELETE FROM `item_mods` WHERE itemId = @FIRNAXE;
INSERT INTO `item_mods` VALUES
    (@FIRNAXE, @MOD_HP,                  10),
    (@FIRNAXE, @MOD_VIT,                  4),
    (@FIRNAXE, @MOD_ACC,                  4),
    (@FIRNAXE, @MOD_ICE_RES,              5),
    (@FIRNAXE, @MOD_BERSERK_DURATION,    10),
    (@FIRNAXE, @MOD_AGGRESSOR_DURATION,  10);

SET @FIRNAXE_P1 = 18523;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @FIRNAXE_P1;
UPDATE `item_weapon`    SET dmg = 94 WHERE itemId = @FIRNAXE_P1;
DELETE FROM `item_mods` WHERE itemId = @FIRNAXE_P1;
INSERT INTO `item_mods` VALUES
    (@FIRNAXE_P1, @MOD_HP,                  15),
    (@FIRNAXE_P1, @MOD_VIT,                  5),
    (@FIRNAXE_P1, @MOD_ACC,                  5),
    (@FIRNAXE_P1, @MOD_ICE_RES,             10),
    (@FIRNAXE_P1, @MOD_BERSERK_DURATION,    15),
    (@FIRNAXE_P1, @MOD_AGGRESSOR_DURATION,  15);

SET @FLETE_POLE = 18628;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @FLETE_POLE;
UPDATE `item_weapon` SET dmg = 66 WHERE itemId = @FLETE_POLE;
DELETE FROM `item_mods` WHERE itemId = @FLETE_POLE;
INSERT INTO `item_mods` VALUES
    (@FLETE_POLE, @MOD_ATT,                  7),
    (@FLETE_POLE, @MOD_HASTE,              100),
    (@FLETE_POLE, @MOD_SUMMONING_SKILL,      2),
    (@FLETE_POLE, @MOD_AVATAR_PERP,          2);

DELETE FROM `item_mods_pet` WHERE itemId = @FLETE_POLE;
INSERT INTO `item_mods_pet` VALUES
    (@FLETE_POLE, @MOD_HASTE, 100, @PET_AVATAR);

SET @FLETE_POLE_P1 = 18629;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @FLETE_POLE_P1;
UPDATE `item_weapon` SET dmg = 67 WHERE itemId = @FLETE_POLE_P1;
DELETE FROM `item_mods` WHERE itemId = @FLETE_POLE_P1;
INSERT INTO `item_mods` VALUES
    (@FLETE_POLE_P1, @MOD_ATT,                  8),
    (@FLETE_POLE_P1, @MOD_HASTE,              200),
    (@FLETE_POLE_P1, @MOD_SUMMONING_SKILL,      3),
    (@FLETE_POLE_P1, @MOD_AVATAR_PERP,          2);

DELETE FROM `item_mods_pet` WHERE itemId = @FLETE_POLE_P1;
INSERT INTO `item_mods_pet` VALUES
    (@FLETE_POLE_P1, @MOD_HASTE, 200, @PET_AVATAR);

SET @GORKHALI_KUKRI = 19788;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @GORKHALI_KUKRI;
UPDATE `item_weapon`    SET dmg = 32 WHERE itemId = @GORKHALI_KUKRI;
DELETE FROM `item_mods` WHERE itemId = @GORKHALI_KUKRI;
INSERT INTO `item_mods` VALUES
    (@GORKHALI_KUKRI, @MOD_HP,                        10),
    (@GORKHALI_KUKRI, @MOD_DEF,                       10),
    (@GORKHALI_KUKRI, @MOD_MDEF,                       2),
    (@GORKHALI_KUKRI, @MOD_WALTZ_POTENCY,              2);

SET @MAHAKALIS_KUKRI = 19789;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @MAHAKALIS_KUKRI;
UPDATE `item_weapon`    SET dmg = 33 WHERE itemId = @MAHAKALIS_KUKRI;
DELETE FROM `item_mods` WHERE itemId = @MAHAKALIS_KUKRI;
INSERT INTO `item_mods` VALUES
    (@MAHAKALIS_KUKRI, @MOD_HP,                        15),
    (@MAHAKALIS_KUKRI, @MOD_DEF,                       15),
    (@MAHAKALIS_KUKRI, @MOD_MDEF,                       3),
    (@MAHAKALIS_KUKRI, @MOD_WALTZ_POTENCY,              3);

SET @SWITH_CAPE = 11000;
UPDATE `item_equipment` SET level = 69, ilevel = 0, su_level = 0 WHERE itemId = @SWITH_CAPE;
DELETE FROM `item_mods` WHERE itemId = @SWITH_CAPE;
INSERT INTO `item_mods` VALUES
    (@SWITH_CAPE, @MOD_DEF,                           6),
    (@SWITH_CAPE, @MOD_HP,                          -20),
    (@SWITH_CAPE, @MOD_MND,                           3),
    (@SWITH_CAPE, @MOD_CHR,                           3);

SET @SWITH_CAPE_P1 = 11001;
UPDATE `item_equipment` SET level = 69, ilevel = 0, su_level = 0 WHERE itemId = @SWITH_CAPE_P1;
DELETE FROM `item_mods` WHERE itemId = @SWITH_CAPE_P1;
INSERT INTO `item_mods` VALUES
    (@SWITH_CAPE_P1, @MOD_DEF,                        7),
    (@SWITH_CAPE_P1, @MOD_HP,                       -25),
    (@SWITH_CAPE_P1, @MOD_MND,                        4),
    (@SWITH_CAPE_P1, @MOD_CHR,                        4),
    (@SWITH_CAPE_P1, @MOD_FASTCAST,                   2);

SET @URJA_TROUSERS = 10577;
UPDATE `item_equipment` SET level = 71, ilevel = 0, su_level = 0 WHERE itemId = @URJA_TROUSERS;
DELETE FROM `item_mods` WHERE itemId = @URJA_TROUSERS;
INSERT INTO `item_mods` VALUES
    (@URJA_TROUSERS, @MOD_DEF,                       31),
    (@URJA_TROUSERS, @MOD_AGI,                        5),
    (@URJA_TROUSERS, @MOD_ATT,                        5),
    (@URJA_TROUSERS, 244,                             1); -- SILENCERES: 1

SET @STHIRA_TROUSERS = 10578;
UPDATE `item_equipment` SET level = 71, ilevel = 0, su_level = 0 WHERE itemId = @STHIRA_TROUSERS;
DELETE FROM `item_mods` WHERE itemId = @STHIRA_TROUSERS;
INSERT INTO `item_mods` VALUES
    (@STHIRA_TROUSERS, @MOD_DEF,                     32),
    (@STHIRA_TROUSERS, @MOD_AGI,                      6),
    (@STHIRA_TROUSERS, @MOD_ATT,                      6),
    (@STHIRA_TROUSERS, 244,                           1); -- SILENCERES: 1

SET @EVADER_EARRING = 11060;
UPDATE `item_equipment` SET level = 72, ilevel = 0, su_level = 0 WHERE itemId = @EVADER_EARRING;
DELETE FROM `item_mods` WHERE itemId = @EVADER_EARRING;
INSERT INTO `item_mods` VALUES
    (@EVADER_EARRING, @MOD_ATT,                      -6),
    (@EVADER_EARRING, @MOD_EVA,                       6);

SET @EVADER_EARRING_P1 = 11061;
UPDATE `item_equipment` SET level = 72, ilevel = 0, su_level = 0 WHERE itemId = @EVADER_EARRING_P1;
DELETE FROM `item_mods` WHERE itemId = @EVADER_EARRING_P1;
INSERT INTO `item_mods` VALUES
    (@EVADER_EARRING_P1, @MOD_ATT,                   -7),
    (@EVADER_EARRING_P1, @MOD_EVA,                    7);

SET @SAIDA_RING = 10792;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @SAIDA_RING;
DELETE FROM `item_mods` WHERE itemId = @SAIDA_RING;
INSERT INTO `item_mods` VALUES
    (@SAIDA_RING, @MOD_DEF,                           4),
    (@SAIDA_RING,       67,                          15); -- ENHANCES_CURSNA_RCVD: 15

SET @ESHMUNS_RING = 10793;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @ESHMUNS_RING;
DELETE FROM `item_mods` WHERE itemId = @ESHMUNS_RING;
INSERT INTO `item_mods` VALUES
    (@ESHMUNS_RING, @MOD_DEF,                         5),
    (@ESHMUNS_RING,       67,                        20); -- ENHANCES_CURSNA_RCVD: 20

SET @MARATH_BAGHNAKHS = 18789;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @MARATH_BAGHNAKHS;
UPDATE `item_weapon`    SET dmg = 17 WHERE itemId = @MARATH_BAGHNAKHS;
DELETE FROM `item_mods` WHERE itemId = @MARATH_BAGHNAKHS;
INSERT INTO `item_mods` VALUES
    (@MARATH_BAGHNAKHS, @MOD_STR,                        2),
    (@MARATH_BAGHNAKHS, @MOD_DEX,                        2),
    (@MARATH_BAGHNAKHS, @MOD_ACC,                        3),
    (@MARATH_BAGHNAKHS, @MOD_ATT,                        8);

DELETE FROM `item_mods_pet` WHERE itemId = @MARATH_BAGHNAKHS;
INSERT INTO `item_mods_pet` VALUES
    (@MARATH_BAGHNAKHS, @MOD_DOUBLE_ATK, 1, @PET_ALL);

SET @SHIVAJI_BAGHNAKHS = 18790;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @SHIVAJI_BAGHNAKHS;
UPDATE `item_weapon`    SET dmg = 18 WHERE itemId = @SHIVAJI_BAGHNAKHS;
DELETE FROM `item_mods` WHERE itemId = @SHIVAJI_BAGHNAKHS;
INSERT INTO `item_mods` VALUES
    (@SHIVAJI_BAGHNAKHS, @MOD_STR,                        3),
    (@SHIVAJI_BAGHNAKHS, @MOD_DEX,                        3),
    (@SHIVAJI_BAGHNAKHS, @MOD_ACC,                        4),
    (@SHIVAJI_BAGHNAKHS, @MOD_ATT,                        9);

DELETE FROM `item_mods_pet` WHERE itemId = @SHIVAJI_BAGHNAKHS;
INSERT INTO `item_mods_pet` VALUES
    (@SHIVAJI_BAGHNAKHS, @MOD_DOUBLE_ATK, 2, @PET_ALL);

SET @NURIGOMEYUMI = 19786;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @NURIGOMEYUMI;
UPDATE `item_weapon`    SET dmg = 76 WHERE itemId = @NURIGOMEYUMI;
DELETE FROM `item_mods` WHERE itemId = @NURIGOMEYUMI;
INSERT INTO `item_mods` VALUES
    (@NURIGOMEYUMI, @MOD_STR,                        1),
    (@NURIGOMEYUMI, @MOD_RACC,                      11),
    (@NURIGOMEYUMI, @MOD_RATT,                       5),
    (@NURIGOMEYUMI, @MOD_DEMON_KILLER,               2);

SET @NURIGOMEYUMI_P1 = 19787;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @NURIGOMEYUMI_P1;
UPDATE `item_weapon`    SET dmg = 77 WHERE itemId = @NURIGOMEYUMI_P1;
DELETE FROM `item_mods` WHERE itemId = @NURIGOMEYUMI_P1;
INSERT INTO `item_mods` VALUES
    (@NURIGOMEYUMI_P1, @MOD_STR,                        2),
    (@NURIGOMEYUMI_P1, @MOD_RACC,                      12),
    (@NURIGOMEYUMI_P1, @MOD_RATT,                       6),
    (@NURIGOMEYUMI_P1, @MOD_DEMON_KILLER,               3);

SET @OPPRIMO = 19743;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @OPPRIMO;
UPDATE `item_weapon`    SET dmg = 38 WHERE itemId = @OPPRIMO;
DELETE FROM `item_mods` WHERE itemId = @OPPRIMO;
INSERT INTO `item_mods` VALUES
    (@OPPRIMO, @MOD_MP,                        15),
    (@OPPRIMO, @MOD_AGI,                        2),
    (@OPPRIMO, @MOD_RACC,                       4),
    (@OPPRIMO, @MOD_ENMITY,                    -2),
    (@OPPRIMO, @MOD_ROLL_RANGE,                 2);

SET @OPPRIMO_P1 = 19744;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @OPPRIMO_P1;
UPDATE `item_weapon`    SET dmg = 39 WHERE itemId = @OPPRIMO_P1;
DELETE FROM `item_mods` WHERE itemId = @OPPRIMO_P1;
INSERT INTO `item_mods` VALUES
    (@OPPRIMO_P1, @MOD_MP,                        20),
    (@OPPRIMO_P1, @MOD_AGI,                        3),
    (@OPPRIMO_P1, @MOD_RACC,                       5),
    (@OPPRIMO_P1, @MOD_ENMITY,                    -3),
    (@OPPRIMO_P1, @MOD_ROLL_RANGE,                 3);

SET @ROSSCHINDER = 19796;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @ROSSCHINDER;
UPDATE `item_weapon`    SET dmg = 70 WHERE itemId = @ROSSCHINDER;
DELETE FROM `item_mods` WHERE itemId = @ROSSCHINDER;
INSERT INTO `item_mods` VALUES
    (@ROSSCHINDER, @MOD_HP,                        30),
    (@ROSSCHINDER, @MOD_STR,                        3),
    (@ROSSCHINDER, @MOD_DEX,                        3),
    (@ROSSCHINDER, @MOD_COUNTER,                    6),
    (@ROSSCHINDER, @MOD_ITEM_ADDEFFECT_TYPE,        2),
    (@ROSSCHINDER, @MOD_ITEM_SUBEFFECT,            11),
    (@ROSSCHINDER, @MOD_ITEM_ADDEFFECT_CHANCE,     10), -- Shiva's Claws/Kikokou, 10% chance
    (@ROSSCHINDER, @MOD_ITEM_ADDEFFECT_STATUS,      4),
    (@ROSSCHINDER, @MOD_ITEM_ADDEFFECT_POWER,      10), -- Shiva's Claws 30% power, Kikokou 17% power
    (@ROSSCHINDER, @MOD_ITEM_ADDEFFECT_DURATION,   15); -- Shiva's Claws/Kikokou, 30 seconds.

SET @ROSSCHINDER_P1 = 19797;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @ROSSCHINDER_P1;
UPDATE `item_weapon`    SET dmg = 71 WHERE itemId = @ROSSCHINDER_P1;
DELETE FROM `item_mods` WHERE itemId = @ROSSCHINDER_P1;
INSERT INTO `item_mods` VALUES
    (@ROSSCHINDER_P1, @MOD_HP,                        40),
    (@ROSSCHINDER_P1, @MOD_STR,                        4),
    (@ROSSCHINDER_P1, @MOD_DEX,                        4),
    (@ROSSCHINDER_P1, @MOD_COUNTER,                    8),
    (@ROSSCHINDER_P1, @MOD_ITEM_ADDEFFECT_TYPE,        2),
    (@ROSSCHINDER_P1, @MOD_ITEM_SUBEFFECT,            11),
    (@ROSSCHINDER_P1, @MOD_ITEM_ADDEFFECT_CHANCE,     10),
    (@ROSSCHINDER_P1, @MOD_ITEM_ADDEFFECT_STATUS,      4),
    (@ROSSCHINDER_P1, @MOD_ITEM_ADDEFFECT_POWER,      15),
    (@ROSSCHINDER_P1, @MOD_ITEM_ADDEFFECT_DURATION,   20);

SET @SASANUKI = 18462;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @SASANUKI;
UPDATE `item_weapon`    SET dmg = 73 WHERE itemId = @SASANUKI;
DELETE FROM `item_mods` WHERE itemId = @SASANUKI;
INSERT INTO `item_mods` VALUES
    (@SASANUKI, @MOD_STR,                        4),
    (@SASANUKI, @MOD_ACC,                        3),
    (@SASANUKI, @MOD_ZANSHIN,                    2),
    (@SASANUKI, @MOD_PHYS_DMG_TAKEN,          -200);

SET @SASANUKI_P1 = 18463;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @SASANUKI_P1;
UPDATE `item_weapon`    SET dmg = 74 WHERE itemId = @SASANUKI_P1;
DELETE FROM `item_mods` WHERE itemId = @SASANUKI_P1;
INSERT INTO `item_mods` VALUES
    (@SASANUKI_P1, @MOD_STR,                        5),
    (@SASANUKI_P1, @MOD_ACC,                        4),
    (@SASANUKI_P1, @MOD_ZANSHIN,                    3),
    (@SASANUKI_P1, @MOD_PHYS_DMG_TAKEN,          -300);

SET @VEJOVIS_WAND = 18884;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @VEJOVIS_WAND;
UPDATE `item_weapon`    SET dmg = 32 WHERE itemId = @VEJOVIS_WAND;
DELETE FROM `item_mods` WHERE itemId = @VEJOVIS_WAND;
INSERT INTO `item_mods` VALUES
    (@VEJOVIS_WAND, @MOD_MP,                        10),
    (@VEJOVIS_WAND, @MOD_VIT,                        3),
    (@VEJOVIS_WAND, @MOD_ACC,                        3),
    (@VEJOVIS_WAND, @MOD_CURE_CAST_TIME,             3),
    (@VEJOVIS_WAND, @MOD_BLUE_SKILL,                 3);

SET @VEJOVIS_WAND_P1 = 18885;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @VEJOVIS_WAND_P1;
UPDATE `item_weapon`    SET dmg = 33 WHERE itemId = @VEJOVIS_WAND_P1;
DELETE FROM `item_mods` WHERE itemId = @VEJOVIS_WAND_P1;
INSERT INTO `item_mods` VALUES
    (@VEJOVIS_WAND_P1, @MOD_MP,                        15),
    (@VEJOVIS_WAND_P1, @MOD_VIT,                        4),
    (@VEJOVIS_WAND_P1, @MOD_ACC,                        4),
    (@VEJOVIS_WAND_P1, @MOD_CURE_CAST_TIME,             4),
    (@VEJOVIS_WAND_P1, @MOD_BLUE_SKILL,                 4);

SET @YHATDHARA = 18561;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @YHATDHARA;
UPDATE `item_weapon`    SET dmg = 87 WHERE itemId = @YHATDHARA;
DELETE FROM `item_mods` WHERE itemId = @YHATDHARA;
INSERT INTO `item_mods` VALUES
    (@YHATDHARA, @MOD_INT,                  3),
    (@YHATDHARA, @MOD_CHR,                  3),
    (@YHATDHARA, @MOD_ATT,                  5),
    (@YHATDHARA, @MOD_WSACC,                7),
    (@YHATDHARA, @MOD_STORE_TP,             2);

DELETE FROM `item_mods_pet` WHERE itemId = @YHATDHARA;
INSERT INTO `item_mods_pet` VALUES
    (@YHATDHARA, @MOD_DOUBLE_ATK, 2, @PET_ALL);

SET @YHATDHARA_P1 = 18562;
UPDATE `item_equipment` SET level = 73, ilevel = 0, su_level = 0 WHERE itemId = @YHATDHARA_P1;
UPDATE `item_weapon`    SET dmg = 88 WHERE itemId = @YHATDHARA_P1;
DELETE FROM `item_mods` WHERE itemId = @YHATDHARA_P1;
INSERT INTO `item_mods` VALUES
    (@YHATDHARA_P1, @MOD_INT,                  4),
    (@YHATDHARA_P1, @MOD_CHR,                  4),
    (@YHATDHARA_P1, @MOD_ATT,                  6),
    (@YHATDHARA_P1, @MOD_WSACC,                8),
    (@YHATDHARA_P1, @MOD_STORE_TP,             3);

DELETE FROM `item_mods_pet` WHERE itemId = @YHATDHARA_P1;
INSERT INTO `item_mods_pet` VALUES
    (@YHATDHARA_P1, @MOD_DOUBLE_ATK, 3, @PET_ALL);

-- Tartarus Platemail (WEW)
-- Enchantment: Recollection (Teleport Library)
SET @TARTARUS_PLATEMAIL = 26944;
DELETE FROM item_usable WHERE itemid = @TARTARUS_PLATEMAIL;
INSERT INTO item_usable VALUES (@TARTARUS_PLATEMAIL,'tartarus_platemail',1,1,27,8,1,30,3600,0);
UPDATE `item_equipment` SET level = 75, jobs = 4194303, ilevel = 0, su_level = 0 WHERE itemId = @TARTARUS_PLATEMAIL;
DELETE FROM `item_mods` WHERE itemId = @TARTARUS_PLATEMAIL;
INSERT INTO `item_mods` VALUES
    (@TARTARUS_PLATEMAIL, @MOD_DEF, 48),
    (@TARTARUS_PLATEMAIL, @MOD_HP,  10),
    (@TARTARUS_PLATEMAIL, @MOD_MP,  10),
    (@TARTARUS_PLATEMAIL, @MOD_TREASURE_HUNTER,  1);

-- Talaria (WEW)
-- Base stats and onItemUse the same, but added TH
SET @TALARIA = 11403;
DELETE FROM `item_mods` WHERE itemid = @TALARIA;
INSERT INTO `item_mods` VALUES
    (@TALARIA, @MOD_DEF, 1),
    (@TALARIA, @MOD_TREASURE_HUNTER, 1);

-- Strip ilvl (If applicable)
-- UPDATE `item_weapon` SET ilvl_skill = 0, ilvl_parry = 0, ilvl_macc = 0 WHERE itemId IN (
-- );


-- Plumb Boots
SET @PLUMB_BOOTS = 10372;
DELETE FROM item_usable WHERE itemid = @PLUMB_BOOTS;
UPDATE `item_equipment` SET level = 75 WHERE itemId = @PLUMB_BOOTS;
DELETE FROM `item_mods` WHERE itemId = @PLUMB_BOOTS AND `modId` = @MOD_DEF;
INSERT INTO `item_mods` VALUES
    (@PLUMB_BOOTS, @MOD_DEF, 20);


-- Poroggo Cassock (Garbagio)
SET @POROGGO_CASSOCK   = 23803;
SET @POROGGO_CASSOCK_P1 = 23804;

DELETE FROM `item_equipment` WHERE name IN ('poroggo_cassock', 'poroggo_cass._+1');
INSERT INTO `item_equipment` VALUES
    (@POROGGO_CASSOCK,   'poroggo_cassock',  1, 0, 4194303, 477, 0, 0, 32, 16, 0, 0),
    (@POROGGO_CASSOCK_P1, 'poroggo_cass._+1', 1, 0, 4194303, 477, 0, 0, 32, 16, 0, 0);

DELETE FROM `item_mods` WHERE itemId IN (@POROGGO_CASSOCK, @POROGGO_CASSOCK_P1);
INSERT INTO `item_mods` VALUES
    (@POROGGO_CASSOCK, @MOD_DEF, 1),
    (@POROGGO_CASSOCK_P1, @MOD_DEF, 1);

-----------------------------------
-- Synergy
-----------------------------------
-- Artisan's Torque
SET @ARTISANS_TORQUE = 10394;
DELETE FROM `item_basic` WHERE itemid = @ARTISANS_TORQUE;
INSERT INTO `item_basic` VALUES (@ARTISANS_TORQUE,0,'artisans_torque','artisans_torque',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ARTISANS_TORQUE;
INSERT INTO `item_equipment` VALUES (@ARTISANS_TORQUE,'artisans_torque',1,0,@ALL_JOBS,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ARTISANS_TORQUE;
INSERT INTO `item_mods` VALUES
    (@ARTISANS_TORQUE, 128, 2), -- WOOD: 2
    (@ARTISANS_TORQUE, 129, 2), -- SMITH: 2
    (@ARTISANS_TORQUE, 130, 2), -- GOLDSMITH: 2
    (@ARTISANS_TORQUE, 131, 2), -- CLOTH: 2
    (@ARTISANS_TORQUE, 132, 2), -- LEATHER: 2
    (@ARTISANS_TORQUE, 133, 2), -- BONE: 2
    (@ARTISANS_TORQUE, 134, 2), -- ALCHEMY: 2
    (@ARTISANS_TORQUE, 135, 2); -- COOK: 2

-- Artisan's Ring
SET @ARTISANS_RING = 28565;
DELETE FROM `item_basic` WHERE itemid = @ARTISANS_RING;
INSERT INTO `item_basic` VALUES (@ARTISANS_RING,0,'artisans_ring','artisans_ring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ARTISANS_RING;
INSERT INTO `item_equipment` VALUES (@ARTISANS_RING,'artisans_ring',1,0,@ALL_JOBS,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ARTISANS_RING;
INSERT INTO `item_mods` VALUES
    (@ARTISANS_RING, 851, 2), -- SYNTH_SUCCESS: 2
    (@ARTISANS_RING, 144, 1), -- ANTIHQ_WOOD: 1
    (@ARTISANS_RING, 145, 1), -- ANTIHQ_SMITH: 1
    (@ARTISANS_RING, 146, 1), -- ANTIHQ_GOLDSMITH: 1
    (@ARTISANS_RING, 147, 1), -- ANTIHQ_CLOTH: 1
    (@ARTISANS_RING, 148, 1), -- ANTIHQ_LEATHER: 1
    (@ARTISANS_RING, 149, 1), -- ANTIHQ_BONE: 1
    (@ARTISANS_RING, 150, 1), -- ANTIHQ_ALCHEMY: 1
    (@ARTISANS_RING, 151, 1); -- ANTIHQ_COOK: 1

-----------------------------------
-- New Player Campaigns
-----------------------------------
-- Mythos Token (New Player Reward for Mythic Weapon)
UPDATE `item_basic` SET `name` = 'mythos_token', `sortname` = 'mythos_token' WHERE itemid = 28918;

-- Empyrean Magian Trial Base Dmg Reduction (Players had obtained these and we reduced rather than eliminate)
-- Chest for base trial weapons is also hidden in hide_npcs.sql

-- Mantis (Total DMG: 20)
UPDATE `item_weapon` SET `dmg` = 12 WHERE `itemId` = 19329;
-- Kartika (Total DMG: 36)
UPDATE `item_weapon` SET `dmg` = 30 WHERE `itemId` = 19334;
-- Nobilis (Total DMG: 46)
UPDATE `item_weapon` SET `dmg` = 38 WHERE `itemId` = 19339;
-- Albion (Total DMG: 86)
UPDATE `item_weapon` SET `dmg` = 74 WHERE `itemId` = 19344;
-- Bonebiter (Total DMG: 51)
UPDATE `item_weapon` SET `dmg` = 43 WHERE `itemId` = 19349;
-- Bonesplitter (Total DMG: 97)
UPDATE `item_weapon` SET `dmg` = 84 WHERE `itemId` = 19354;
-- Ultimatum (Total DMG: 99)
UPDATE `item_weapon` SET `dmg` = 87 WHERE `itemId` = 19359;
-- Copperhead (Total DMG: 97)
UPDATE `item_weapon` SET `dmg` = 83 WHERE `itemId` = 19363;
-- Mozu (Total DMG: 41)
UPDATE `item_weapon` SET `dmg` = 33 WHERE `itemId` = 19369;
-- Radennotachi (Total DMG: 83)
UPDATE `item_weapon` SET `dmg` = 71 WHERE `itemId` = 19374;
-- Culacula (Total DMG: 49)
UPDATE `item_weapon` SET `dmg` = 33 WHERE `itemId` = 19379;
-- Slaine (Total DMG: 69)
UPDATE `item_weapon` SET `dmg` = 54 WHERE `itemId` = 19384;
-- Astrild (Total DMG: 78)
UPDATE `item_weapon` SET `dmg` = 67 WHERE `itemId` = 19389;
-- Magnatus (Total DMG: 43)
UPDATE `item_weapon` SET `dmg` = 35 WHERE `itemId` = 19394;

-- Randy's Rod (Ruinous Randy)
SET @RANDYS_ROD = 22155;
DELETE FROM `item_basic` WHERE itemid = @RANDYS_ROD;
INSERT INTO `item_basic` VALUES
    (@RANDYS_ROD,0,'randys_rod','randys_rod',1,64576,0,1,0);
DELETE FROM `item_usable` WHERE itemid = @RANDYS_ROD;
INSERT INTO `item_usable` VALUES
    (@RANDYS_ROD,'randys_rod',1,1,27,5,1,30,72000,0);
DELETE FROM `item_equipment` WHERE itemId = @RANDYS_ROD;
INSERT INTO `item_equipment` VALUES
    (@RANDYS_ROD,'randys_rod',30,0,4194303,801,0,0,3,0,0,0);
DELETE FROM `item_weapon` WHERE itemId = @RANDYS_ROD;
INSERT INTO `item_weapon` VALUES (@RANDYS_ROD,'randys_rod',11,0,0,0,0,3,1,257,5,0);

-- Lower stun chance on stun knife, stun kukiri, mamushito, and platinum grip.
UPDATE `item_mods`
SET `value` = 1
WHERE `itemId` IN (16503, 16506, 16910, 19019) AND `modId` = 501;
-- Lower stun chance on stun knife +1, stun kukiri +1, mamushito +1, and platinum grip +1.
UPDATE `item_mods`
SET `value` = 2
WHERE `itemId` IN (17600, 17614, 17770, 19020) AND `modId` = 501;

-- Make Garrison Hose Lv20 like the rest of the set
UPDATE `item_equipment` SET level = 20 WHERE `name` = 'garrison_hose';

-- Vajra (75) adds TH+1
SET @VAJRA_75 = 18996;
DELETE FROM `item_mods` WHERE itemId = @VAJRA_75;
INSERT INTO `item_mods` VALUES (@VAJRA_75,256,29); -- AFTERMATH: 29
INSERT INTO `item_mods` VALUES (@VAJRA_75,355,27); -- ADDS_WEAPONSKILL: 27
INSERT INTO `item_mods` VALUES (@VAJRA_75,526,10); -- AUGMENTS_SA: 10
INSERT INTO `item_mods` VALUES (@VAJRA_75,527,10); -- AUGMENTS_TA: 10
INSERT INTO `item_mods` VALUES (@VAJRA_75,303,1);  -- TREASURE_HUNTER: 1

-- Bonze Cape
SET @BONZE_CAPE = 13614;
UPDATE item_equipment SET jobs = 4194303 WHERE itemid = @BONZE_CAPE;
DELETE FROM `item_mods` WHERE itemId = @BONZE_CAPE;
INSERT INTO `item_mods` VALUES
    (@BONZE_CAPE, @MOD_DEF,           2),
    (@BONZE_CAPE, @MOD_MP,            3),
    (@BONZE_CAPE, @MOD_INT,           1),
    (@BONZE_CAPE, @SYNTH_SKILL_GAIN, 15);

-- Pirate's Key
SET @PIRATES_KEY = 9538;
DELETE FROM `item_basic` WHERE itemId = @PIRATES_KEY;
INSERT INTO `item_basic` VALUES (@PIRATES_KEY,0,'pirates_key','pirates_key',1,@ITEM_RARE,0,1,0);

-- Brigand's Shovel
SET @BRIGANDS_SHOVEL = 18888;
DELETE FROM `item_basic` WHERE itemId = @BRIGANDS_SHOVEL;
INSERT INTO `item_basic` VALUES (@BRIGANDS_SHOVEL,0,'brigands_shovel','brigands_shovel',1,@ITEM_EQUSE,0,1,0);

DELETE FROM `item_weapon` WHERE itemId = @BRIGANDS_SHOVEL;
INSERT INTO `item_weapon` VALUES (@BRIGANDS_SHOVEL,'brigands_shovel',12,0,0,0,0,3,1,402,35,0);

UPDATE `item_equipment` SET level = 40, jobs = 4194303, MId = 455, ilevel = 0, su_level = 0 WHERE itemId = @BRIGANDS_SHOVEL;
DELETE FROM `item_mods` WHERE itemId = @BRIGANDS_SHOVEL;
INSERT INTO `item_mods` VALUES
    (@BRIGANDS_SHOVEL, @MOD_HP,         10),
    (@BRIGANDS_SHOVEL, @MOD_WATER_RES,   8),
    (@BRIGANDS_SHOVEL, @MOD_EXCAVATION, 73);

DELETE FROM `item_usable` WHERE itemid = @BRIGANDS_SHOVEL;
INSERT INTO `item_usable` VALUES (@BRIGANDS_SHOVEL,'brigands_shovel',1,1,55,5,1,10,15,0);

-- Brigand's Eyepatch
SET @BRIGANDS_EYEPATCH = 28443;
DELETE FROM `item_basic` WHERE itemid = @BRIGANDS_EYEPATCH;
INSERT INTO `item_basic` VALUES (@BRIGANDS_EYEPATCH,0,'brigands_eyepatch','brigands_eyepatch',1,@ITEM_EQUSE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BRIGANDS_EYEPATCH;
INSERT INTO `item_equipment` VALUES (@BRIGANDS_EYEPATCH,'brigands_eyepatch',50,0,4194303,233,0,0,16,0,0,0);

DELETE FROM `item_usable` WHERE itemid = @BRIGANDS_EYEPATCH;
INSERT INTO `item_usable` VALUES (@BRIGANDS_EYEPATCH,'brigands_eyepatch',1,8,0,0,1,15,1200,0);

DELETE FROM `item_mods` WHERE itemId = @BRIGANDS_EYEPATCH;
INSERT INTO `item_mods` VALUES
    (@BRIGANDS_EYEPATCH, @MOD_MP,                 15),
    (@BRIGANDS_EYEPATCH, @MOD_WATER_RES,          10),
    (@BRIGANDS_EYEPATCH, @MOD_CHR,                 3),
    (@BRIGANDS_EYEPATCH, @MOD_FISHING_FATIGUE,    20),
    (@BRIGANDS_EYEPATCH, @MOD_FISHING_GOLD_ARROW,  2);

-- Halieutica
SET @HALIEUTICA = 20945;
DELETE FROM `item_basic` WHERE itemid = @HALIEUTICA;
INSERT INTO `item_basic` VALUES (@HALIEUTICA,0,'halieutica','halieutica',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HALIEUTICA;
INSERT INTO `item_equipment` VALUES (@HALIEUTICA,'halieutica',50,0,4194303,859,0,0,3,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @HALIEUTICA;
INSERT INTO `item_weapon` VALUES (@HALIEUTICA,'halieutica',8,0,0,0,0,@DMG_PIERCING,1,396,60,0);

DELETE FROM `item_mods` WHERE itemId = @HALIEUTICA;
INSERT INTO `item_mods` VALUES
    (@HALIEUTICA, @MOD_HP,                 15),
    (@HALIEUTICA, @MOD_WATER_RES,          20),
    (@HALIEUTICA, @MOD_FISHING_SKILL,       2),
    (@HALIEUTICA, @MOD_FISHING_FATIGUE,    50),
    (@HALIEUTICA, @MOD_FISHING_GOLD_ARROW,  5);

-- Ultimate Fishing Spear Items
SET @WORN_FISHING_GEAR = 9417;
DELETE FROM `item_basic` WHERE itemId = @WORN_FISHING_GEAR;
INSERT INTO `item_basic` VALUES (@WORN_FISHING_GEAR,0,'worn_fishing_gear','worn_fishing_gear',1,@ITEM_RARE,0,1,0);

SET @FINE_FISHING_LINE = 9418;
DELETE FROM `item_basic` WHERE itemId = @FINE_FISHING_LINE;
INSERT INTO `item_basic` VALUES (@FINE_FISHING_LINE,0,'fine_fishing_line','fine_fishing_line',1,@ITEM_RARE,0,1,0);

SET @AGED_FISHING_POLE = 9419;
DELETE FROM `item_basic` WHERE itemId = @AGED_FISHING_POLE;
INSERT INTO `item_basic` VALUES (@AGED_FISHING_POLE,0,'aged_fishing_pole','aged_fishing_pole',1,@ITEM_RARE,0,1,0);

SET @RUSTY_FISHING_HOOK = 9420;
DELETE FROM `item_basic` WHERE itemId = @RUSTY_FISHING_HOOK;
INSERT INTO `item_basic` VALUES (@RUSTY_FISHING_HOOK,0,'rusty_fishing_hook','rusty_fishing_hook',1,@ITEM_RARE,0,1,0);

SET @BUCCANEERS_CHART = 9426;
DELETE FROM `item_basic` WHERE itemId = @BUCCANEERS_CHART;
INSERT INTO `item_basic` VALUES (@BUCCANEERS_CHART,0,'buccaneers_chart','buccaneers_chart',1,@ITEM_RARE,0,1,0);

SET @EMPEROR_CLAM = 9427;
DELETE FROM `item_basic` WHERE itemId = @EMPEROR_CLAM;
INSERT INTO `item_basic` VALUES (@EMPEROR_CLAM,0,'emperor_clam','emperor_clam',1,@ITEM_RARE,0,1,0);

SET @WYRM_GOLD = 9425;
DELETE FROM `item_basic` WHERE itemId = @WYRM_GOLD;
INSERT INTO `item_basic` VALUES (@WYRM_GOLD,0,'wyrm_gold','wyrm_gold',1,@ITEM_EX,0,1,0);

-- Mercurial Kunai
SET @MERCURIAL_KUNAI = 20717;
DELETE FROM `item_basic` WHERE itemid = @MERCURIAL_KUNAI;
INSERT INTO `item_basic` VALUES (@MERCURIAL_KUNAI,0,'mercurial_kunai','mercurial_kunai',1,34820,9,0,1440);

DELETE FROM `item_equipment` WHERE itemId = @MERCURIAL_KUNAI;
INSERT INTO `item_equipment` VALUES (@MERCURIAL_KUNAI,'mercurial_kunai',70,0,4096,314,0,0,3,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @MERCURIAL_KUNAI;
INSERT INTO `item_weapon` VALUES (@MERCURIAL_KUNAI,'mercurial_kunai',9,0,0,0,0,2,3,190,17,0);

DELETE FROM `item_mods` WHERE itemId = @MERCURIAL_KUNAI;

-- Venture Ring
SET @VENTURE_RING = 10870;
DELETE FROM `item_basic` WHERE itemid = @VENTURE_RING;
INSERT INTO `item_basic` VALUES (@VENTURE_RING,0,'venture_ring','venture_ring',1,@ITEM_EQUIP,0,1,0);
DELETE FROM `item_usable` WHERE itemid = @VENTURE_RING;
INSERT INTO `item_usable` VALUES (@VENTURE_RING,'venture_ring',1,3,76,0,1,5,600,0);
DELETE FROM `item_equipment` WHERE itemId = @VENTURE_RING;
INSERT INTO `item_equipment` VALUES (@VENTURE_RING,'venture_ring',1,0,4194303,0,0,0,24576,0,0,0);
DELETE FROM `item_mods` WHERE itemid = @VENTURE_RING;


-----------------------------------
-- Moblin Mayhem (CW)
-----------------------------------
-- Champion Belt
SET @CHAMPION_BELT = 28442;
DELETE FROM `item_basic` WHERE itemid = @CHAMPION_BELT;
INSERT INTO `item_basic` VALUES (@CHAMPION_BELT,0,'champion_belt','champion_belt',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @CHAMPION_BELT;
INSERT INTO `item_equipment` VALUES (@CHAMPION_BELT,'champion_belt',70,0,4194303,0,0,0,1024,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @CHAMPION_BELT;
INSERT INTO `item_mods` VALUES
    (@CHAMPION_BELT, @MOD_DEF,         5),
    (@CHAMPION_BELT, @MOD_VIT,         4),
    (@CHAMPION_BELT, @MOD_FIRE_RES,   20),
    (@CHAMPION_BELT, @MOD_ATT,        16);

-- Moblinium Might
SET @MOBLINIUM_MIGHT = 28496;
DELETE FROM `item_basic` WHERE itemid = @MOBLINIUM_MIGHT;
INSERT INTO `item_basic` VALUES (@MOBLINIUM_MIGHT,0,'moblinium_might','moblinium_might',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @MOBLINIUM_MIGHT;
INSERT INTO `item_equipment` VALUES (@MOBLINIUM_MIGHT,'moblinium_might',70,0,4194303,0,0,0,24576,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @MOBLINIUM_MIGHT;
INSERT INTO `item_mods` VALUES
    (@MOBLINIUM_MIGHT, @MOD_AGI,         4),
    (@MOBLINIUM_MIGHT, @MOD_ATT,         8),
    (@MOBLINIUM_MIGHT, @MOD_RATT,        8);

-- Warloq's Locket
SET @WARLOQS_LOCKET = 28614;
DELETE FROM `item_basic` WHERE itemid = @WARLOQS_LOCKET;
INSERT INTO `item_basic` VALUES (@WARLOQS_LOCKET,0,'warloqs_locket','warloqs_locket',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @WARLOQS_LOCKET;
INSERT INTO `item_equipment` VALUES (@WARLOQS_LOCKET,'warloqs_locket',70,0,@WHM+@BLM+@RDM+@SMN+@SCH+@GEO,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @WARLOQS_LOCKET;
INSERT INTO `item_mods` VALUES
    (@WARLOQS_LOCKET, @MOD_INT,         4),
    (@WARLOQS_LOCKET, @MOD_MND,         4),
    (@WARLOQS_LOCKET, @MOD_HP2MP,      40);

DELETE FROM `item_mods_pet` WHERE itemid = @WARLOQS_LOCKET;
INSERT INTO `item_mods_pet` VALUES
    (@WARLOQS_LOCKET, @MOD_REGEN, 1, @PET_ALL);

SET @MOBLIN_MALLET = 21102; -- (Icon: Club Hammer)
DELETE FROM `item_basic` WHERE itemid = @MOBLIN_MALLET;
INSERT INTO `item_basic` VALUES (@MOBLIN_MALLET,0,'moblin_mallet','moblin_mallet',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @MOBLIN_MALLET;
INSERT INTO `item_equipment` VALUES (@MOBLIN_MALLET,'moblin_mallet',70,0,@MNK+@WHM+@BLM+@SMN+@SCH+@GEO,454,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @MOBLIN_MALLET;
INSERT INTO `item_weapon` VALUES (@MOBLIN_MALLET,'moblin_mallet',@SKILL_CLUB,0,0,0,0,@DMG_BLUNT,4,340,9,0);

DELETE FROM `item_mods` WHERE itemId = @MOBLIN_MALLET;
INSERT INTO `item_mods` VALUES
    (@MOBLIN_MALLET, @MOD_HP,            50),
    (@MOBLIN_MALLET, @MOD_VERMIN_KILLER,  5);

-- Arena Token
SET @ARENA_TOKEN = 9491;
DELETE FROM `item_basic` WHERE itemId = @ARENA_TOKEN;
INSERT INTO `item_basic` VALUES (@ARENA_TOKEN,0,'arena_token','arena_token',99,@ITEM_EX,0,1,0);

-- Moblin Medallion
SET @MOBLIN_MEDALLION = 9492;
DELETE FROM `item_basic` WHERE itemId = @MOBLIN_MEDALLION;
INSERT INTO `item_basic` VALUES (@MOBLIN_MEDALLION,0,'moblin_medallion','moblin_medallion',99,@ITEM_EX,0,1,0);

-- Moblin Master Key
SET @MOBLIN_MASTER_KEY = 9493;
DELETE FROM `item_basic` WHERE itemId = @MOBLIN_MASTER_KEY;
INSERT INTO `item_basic` VALUES (@MOBLIN_MASTER_KEY,0,'moblin_master_key','moblin_master_key',1,@ITEM_RARE,0,1,0);

-- Timeless Sand
SET @TIMELESS_SAND = 9498;
DELETE FROM `item_basic` WHERE itemId = @TIMELESS_SAND;
INSERT INTO `item_basic` VALUES (@TIMELESS_SAND,0,'vial_of_timeless_sand','timeless_sand',99,@ITEM_EX,0,1,0);

-----------------------------------
-- Yagudo Arena (CW)
-----------------------------------
-- Arcane Arbalest
SET @ARCANE_ARBALEST = 21479;
DELETE FROM `item_basic` WHERE itemid = @ARCANE_ARBALEST;
INSERT INTO `item_basic` VALUES (@ARCANE_ARBALEST,0,'arcane_arbalest','arcane_arbalest',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ARCANE_ARBALEST;
INSERT INTO `item_equipment` VALUES (@ARCANE_ARBALEST,'arcane_arbalest',50,0,1185,52,0,0,4,0,0,0);

DELETE FROM `item_weapon` WHERE itemid = @ARCANE_ARBALEST;
INSERT INTO `item_weapon` VALUES (@ARCANE_ARBALEST,'arcane_arbalest',@SKILL_MARKSMANSHIP,@SUBSKILL_GUN,0,0,0,@DMG_PIERCING,1,288,32,0);

DELETE FROM `item_mods` WHERE itemId = @ARCANE_ARBALEST;
INSERT INTO `item_mods` VALUES
    (@ARCANE_ARBALEST, @MOD_INT,         4),
    (@ARCANE_ARBALEST, @MOD_MND,         4),
    (@ARCANE_ARBALEST, @MOD_ATT,         3),
    (@ARCANE_ARBALEST, @MOD_RACC,        5);

-- Outlaw's Earring
SET @OUTLAWS_EARRING = 28539;
DELETE FROM `item_basic` WHERE itemid = @OUTLAWS_EARRING;
INSERT INTO `item_basic` VALUES (@OUTLAWS_EARRING,0,'outlaws_earring','outlaws_earring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @OUTLAWS_EARRING;
INSERT INTO `item_equipment` VALUES (@OUTLAWS_EARRING,'outlaws_earring',50,0,4194303,0,0,0,6144,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @OUTLAWS_EARRING;
INSERT INTO `item_mods` VALUES
    (@OUTLAWS_EARRING, @MOD_MP,         15),
    (@OUTLAWS_EARRING, @MOD_DEX,         2),
    (@OUTLAWS_EARRING, @MOD_MND,         2);

-- Talon Tathlum
SET @TALON_TATHLUM = 19270; -- (Icon: Quartz Tathlum)
DELETE FROM `item_basic` WHERE itemid = @TALON_TATHLUM;
INSERT INTO `item_basic` VALUES (@TALON_TATHLUM,0,'talon_tathlum','talon_tathlum',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TALON_TATHLUM;
INSERT INTO `item_equipment` VALUES (@TALON_TATHLUM,'talon_tathlum',50,0,@WHM+@BLM+@SMN+@BLU+@SCH+@GEO,0,0,0,@SLOT_AMMO,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @TALON_TATHLUM;
INSERT INTO `item_weapon` VALUES (@TALON_TATHLUM,'talon_tathlum',0,0,0,0,0,0,1,999,0,0);

DELETE FROM `item_mods` WHERE itemId = @TALON_TATHLUM;
INSERT INTO `item_mods` VALUES
    (@TALON_TATHLUM, @MOD_MP,         15),
    (@TALON_TATHLUM, @MOD_STR,         2),
    (@TALON_TATHLUM, @MOD_DEX,         2);

-- Exile's Cloak
SET @EXILES_CLOAK = 11008; -- (Icon: Drachenblut Cape)
DELETE FROM `item_basic` WHERE itemid = @EXILES_CLOAK;
INSERT INTO `item_basic` VALUES (@EXILES_CLOAK,0,'exiles_cloak','exiles_cloak',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @EXILES_CLOAK;
INSERT INTO `item_equipment` VALUES (@EXILES_CLOAK,'exiles_cloak',50,0,@ALL_JOBS,0,0,0,@SLOT_BACK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @EXILES_CLOAK;
INSERT INTO `item_mods` VALUES
    (@EXILES_CLOAK, @MOD_DEF,        4),
    (@EXILES_CLOAK, @MOD_HP,        15),
    (@EXILES_CLOAK, @MOD_CHR,       -3),
    (@EXILES_CLOAK, @MOD_LIGHT_RES, 10),
    (@EXILES_CLOAK, @MOD_ATT,        3);

-- Yagudo Crown
SET @YAGUDO_CROWN = 26702;
DELETE FROM `item_basic` WHERE itemid = @YAGUDO_CROWN;
INSERT INTO `item_basic` VALUES (@YAGUDO_CROWN,0,'yagudo_crown','yagudo_crown',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @YAGUDO_CROWN;
INSERT INTO `item_equipment` VALUES (@YAGUDO_CROWN,'yagudo_crown',75,0,4194303,145,0,0,16,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @YAGUDO_CROWN;
INSERT INTO `item_mods` VALUES
    (@YAGUDO_CROWN, @MOD_DEF,        24),
    (@YAGUDO_CROWN, @MOD_HP,         15),
    (@YAGUDO_CROWN, @MOD_MP,         15),
    (@YAGUDO_CROWN, @MOD_DEX,         3),
    (@YAGUDO_CROWN, @MOD_EVA,         3),
    (@YAGUDO_CROWN, @MOD_HASTE,     500);

-----------------------------------
-- Tonberry Trouble (CW)
-----------------------------------
-- Bandit's Earring
SET @BANDITS_EARRING = 28513;
DELETE FROM `item_basic` WHERE itemid = @BANDITS_EARRING;
INSERT INTO `item_basic` VALUES (@BANDITS_EARRING,0,'bandits_earring','bandits_earring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BANDITS_EARRING;
INSERT INTO `item_equipment` VALUES (@BANDITS_EARRING,'bandits_earring',60,0,@THF+@BRD+@NIN+@DNC+@RUN,0,0,0,6144,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @BANDITS_EARRING;
INSERT INTO `item_mods` VALUES
    (@BANDITS_EARRING, @MOD_PARRY_SKILL, 5),
    (@BANDITS_EARRING, @MOD_ENMITY,      2),
    (@BANDITS_EARRING, 835,              1); -- Enhances "Mug" effect

-- Radiant Lantern
SET @RADIANT_LANTERN = 28386;
DELETE FROM `item_basic` WHERE itemid = @RADIANT_LANTERN;
INSERT INTO `item_basic` VALUES (@RADIANT_LANTERN,0,'radiant_lantern','radiant_lantern',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @RADIANT_LANTERN;
INSERT INTO `item_equipment` VALUES (@RADIANT_LANTERN,'radiant_lantern',60,0,@WHM+@BLM+@RDM+@SMN+@SCH+@GEO,0,0,0,512,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @RADIANT_LANTERN;
INSERT INTO `item_mods` VALUES
    (@RADIANT_LANTERN, @MOD_MP,             40),
    (@RADIANT_LANTERN, @MOD_ENMITY,         -2),
    (@RADIANT_LANTERN, @MOD_GEOMANCY_SKILL,  5),
    (@RADIANT_LANTERN, 540,                 30); -- Elemental Siphon

-- Madoushi Shuriken
SET @MADOUSHI_SHURIKEN = 21214;
DELETE FROM `item_basic` WHERE itemid = @MADOUSHI_SHURIKEN;
INSERT INTO `item_basic` VALUES (@MADOUSHI_SHURIKEN,0,'madoushi_shuriken','madoushi_shuriken',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @MADOUSHI_SHURIKEN;
INSERT INTO `item_equipment` VALUES (@MADOUSHI_SHURIKEN,'madoushi_shuriken',60,0,@NIN,0,0,0,8,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @MADOUSHI_SHURIKEN;
INSERT INTO `item_weapon` VALUES (@MADOUSHI_SHURIKEN,'madoushi_shuriken',27,3,0,0,0,@DMG_PIERCING,1,192,80,0);

DELETE FROM `item_mods` WHERE itemId = @MADOUSHI_SHURIKEN;
INSERT INTO `item_mods` VALUES
    (@MADOUSHI_SHURIKEN, @MOD_RATT,          13),
    (@MADOUSHI_SHURIKEN, @MOD_MATT,           6);

-- Savage Shiv
SET @SAVAGE_SHIV = 20891;
DELETE FROM `item_basic` WHERE itemid = @SAVAGE_SHIV;
INSERT INTO `item_basic` VALUES (@SAVAGE_SHIV,0,'savage_shiv','savage_shiv',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SAVAGE_SHIV;
INSERT INTO `item_equipment` VALUES (@SAVAGE_SHIV,'savage_shiv',60,0,@WAR+@DRK+@SAM+@RUN,0,0,0,8,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @SAVAGE_SHIV;
INSERT INTO `item_weapon` VALUES (@SAVAGE_SHIV,'savage_shiv',0,0,0,0,0,0,1,999,0,0);

DELETE FROM `item_mods` WHERE itemId = @SAVAGE_SHIV;
INSERT INTO `item_mods` VALUES
    (@SAVAGE_SHIV, @MOD_STR,            2),
    (@SAVAGE_SHIV, @MOD_ACC,           -3),
    (@SAVAGE_SHIV, @MOD_HASTE,        100);

-----------------------------------
-- Goblin Brew (Venture Battles)
-----------------------------------
-- Special Brew
SET @SPECIAL_BREW = 9434;
DELETE FROM `item_basic` WHERE itemId = @SPECIAL_BREW;
INSERT INTO `item_basic` VALUES (@SPECIAL_BREW,0,'vial_of_special_goblin_brew','special_goblin_brew',12,@ITEM_EX,0,1,0);

-- Goblin Brew
SET @GOBLIN_BREW = 9435;
DELETE FROM `item_basic` WHERE itemId = @GOBLIN_BREW;
INSERT INTO `item_basic` VALUES (@GOBLIN_BREW,0,'vial_of_goblin_brew','goblin_brew',12,@ITEM_EX,0,1,0);

-- Goblin Brew +1
SET @GOBLIN_BREW_P1 = 9436;
DELETE FROM `item_basic` WHERE itemId = @GOBLIN_BREW_P1;
INSERT INTO `item_basic` VALUES (@GOBLIN_BREW_P1,0,'vial_of_goblin_brew_+1','goblin_brew_+1',12,@ITEM_EX,0,1,0);

-- Goblin Brew +2
SET @GOBLIN_BREW_P2 = 9437;
DELETE FROM `item_basic` WHERE itemId = @GOBLIN_BREW_P2;
INSERT INTO `item_basic` VALUES (@GOBLIN_BREW_P2,0,'vial_of_goblin_brew_+2','goblin_brew_+2',12,@ITEM_EX,0,1,0);

-- Goblin Brew +3
SET @GOBLIN_BREW_P3 = 9438;
DELETE FROM `item_basic` WHERE itemId = @GOBLIN_BREW_P3;
INSERT INTO `item_basic` VALUES (@GOBLIN_BREW_P3,0,'vial_of_goblin_brew_+3','goblin_brew_+3',12,@ITEM_EX,0,1,0);

-----------------------------------
-- Dragonslaying
-----------------------------------
-- Golden Bangle
SET @GOLDEN_BANGLE = 9444;
DELETE FROM `item_basic` WHERE itemId = @GOLDEN_BANGLE;
INSERT INTO `item_basic` VALUES (@GOLDEN_BANGLE,0,'golden_bangle','golden_bangle',1,@ITEM_RARE,0,1,0);

-- Golden Rings
SET @GOLDEN_RINGS = 9445;
DELETE FROM `item_basic` WHERE itemId = @GOLDEN_RINGS;
INSERT INTO `item_basic` VALUES (@GOLDEN_RINGS,0,'golden_rings','golden_rings',1,@ITEM_RARE,0,1,0);

-- Golden Rings +1
SET @GOLDEN_RINGS_P1 = 9446;
DELETE FROM `item_basic` WHERE itemId = @GOLDEN_RINGS_P1;
INSERT INTO `item_basic` VALUES (@GOLDEN_RINGS_P1,0,'golden_rings_+1','golden_rings_+1',1,@ITEM_RARE,0,1,0);

-- Wyrm Scale
SET @WYRM_SCALE = 9447;
DELETE FROM `item_basic` WHERE itemId = @WYRM_SCALE;
INSERT INTO `item_basic` VALUES (@WYRM_SCALE,0,'wyrm_scale','wyrm_scale',12,4,@LEATHERCRAFT,0,5125);

-- Wyrm Tooth
SET @WYRM_TOOTH = 9453;
DELETE FROM `item_basic` WHERE itemId = @WYRM_TOOTH;
INSERT INTO `item_basic` VALUES (@WYRM_TOOTH,0,'wyrm_tooth','wyrm_tooth',12,4,@BONECRAFT,0,3740);

-- Embersteel Ingot
SET @EMBERSTEEL_INGOT = 9454;
DELETE FROM `item_basic` WHERE itemId = @EMBERSTEEL_INGOT;
INSERT INTO `item_basic` VALUES (@EMBERSTEEL_INGOT,0,'embersteel_ingot','embersteel_ingot',12,4,@SMITHING,0,3740);

-- Fable Thread
SET @FABLE_THREAD = 9455;
DELETE FROM `item_basic` WHERE itemId = @FABLE_THREAD;
INSERT INTO `item_basic` VALUES (@FABLE_THREAD,0,'fable_thread','fable_thread',12,4,@CLOTHCRAFT,0,2710);

-- Fable Cloth
SET @FABLE_CLOTH = 9456;
DELETE FROM `item_basic` WHERE itemId = @FABLE_CLOTH;
INSERT INTO `item_basic` VALUES (@FABLE_CLOTH,0,'fable_cloth','fable_cloth',12,4,@CLOTHCRAFT,0,7805);

SET @FABLE_CLOTH_SYNTH = 80000;
DELETE FROM `synth_recipes` WHERE ID = @FABLE_CLOTH_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @FABLE_CLOTH_SYNTH,0,0,
    0,0,0,98, -- Wood/Smith/Gold/Cloth
    0,0,0,0,  -- Leather/Bone/Alchemy/Cooking
    4099,4241,@FABLE_THREAD,@FABLE_THREAD,@FABLE_THREAD,0,0,0,0,0,@FABLE_CLOTH,@FABLE_CLOTH,@FABLE_CLOTH,@FABLE_CLOTH,1,1,1,1,'Fable Cloth');

-----------------------------------
-- Glacial Wyvern (Ice)
-----------------------------------

-- Rimestone
SET @RIMESTONE = 21384;
DELETE FROM `item_basic` WHERE itemid = @RIMESTONE;
INSERT INTO `item_basic` VALUES (@RIMESTONE,0,'rimestone','rimestone',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @RIMESTONE;
INSERT INTO `item_equipment` VALUES (@RIMESTONE,'rimestone',60,0,1589788,0,0,0,8,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @RIMESTONE;
INSERT INTO `item_mods` VALUES
    (@RIMESTONE, @MOD_MP,   20),
    (@RIMESTONE, @MOD_MND,   1),
    (@RIMESTONE, @MOD_MACC,  1);

-- Hierarch's Mantle
SET @HIERARCHS_MANTLE = 28640;
DELETE FROM `item_basic` WHERE itemid = @HIERARCHS_MANTLE;
INSERT INTO `item_basic` VALUES (@HIERARCHS_MANTLE,0,'hierarchs_mantle','hierarchs_mantle',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HIERARCHS_MANTLE;
INSERT INTO `item_equipment` VALUES (@HIERARCHS_MANTLE,'hierarchs_mantle',60,0,1753628,0,0,0,32768,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HIERARCHS_MANTLE;
INSERT INTO `item_mods` VALUES
    (@HIERARCHS_MANTLE, @MOD_DEF,             7),
    (@HIERARCHS_MANTLE, @MOD_MP,             15),
    (@HIERARCHS_MANTLE, @MOD_MND,             3),
    (@HIERARCHS_MANTLE, @MOD_CURE_CAST_TIME,  7);

-----------------------------------
-- Searing Eldrake (Fire)
-----------------------------------

-- Cinderstone
SET @CINDERSTONE = 21385;
DELETE FROM `item_basic` WHERE itemid = @CINDERSTONE;
INSERT INTO `item_basic` VALUES (@CINDERSTONE,0,'cinderstone','cinderstone',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @CINDERSTONE;
INSERT INTO `item_equipment` VALUES (@CINDERSTONE,'cinderstone',60,0,@WAR+@THF+@DRK+@NIN+@DRG+@RUN,0,0,0,8,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @CINDERSTONE;
INSERT INTO `item_mods` VALUES
    (@CINDERSTONE, @MOD_FIRE_RES, 10),
    (@CINDERSTONE, @MOD_HP,       20),
    (@CINDERSTONE, @MOD_STR,       4),
    (@CINDERSTONE, @MOD_ENMITY,    2);

-- Adept's Earring
SET @ADEPTS_EARRING = 28514;
DELETE FROM `item_basic` WHERE itemid = @ADEPTS_EARRING;
INSERT INTO `item_basic` VALUES (@ADEPTS_EARRING,0,'adepts_earring','adepts_earring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ADEPTS_EARRING;
INSERT INTO `item_equipment` VALUES (@ADEPTS_EARRING,'adepts_earring',60,0,4194303,0,0,0,6144,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ADEPTS_EARRING;
INSERT INTO `item_mods` VALUES
    (@ADEPTS_EARRING, @MOD_ENMITY, -3),
    (@ADEPTS_EARRING, @MOD_MATT,   5);

-----------------------------------
-- Midgardsormr (Earth)
-----------------------------------

-- Titanium Band (Kunaji Ring)
SET @TITANIUM_BAND = 28577;
DELETE FROM `item_basic` WHERE itemid = @TITANIUM_BAND;
INSERT INTO `item_basic` VALUES (@TITANIUM_BAND,0,'titanium_band','titanium_band',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TITANIUM_BAND;
INSERT INTO `item_equipment` VALUES (@TITANIUM_BAND,'titanium_band',70,0,4194303,0,0,0,24576,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TITANIUM_BAND;
INSERT INTO `item_mods` VALUES
    (@TITANIUM_BAND, @MOD_DEF,               5),
    (@TITANIUM_BAND, @MOD_HP,               65),
    (@TITANIUM_BAND, @MOD_EARTH_RES,        15),
    (@TITANIUM_BAND, @MOD_ENMITY,            2),
    (@TITANIUM_BAND, @MOD_PHYS_DMG_TAKEN, -200);

-- Erudite Cap (Buremte Hat)
SET @ERUDITE_CAP = 27767;
DELETE FROM `item_basic` WHERE itemid = @ERUDITE_CAP;
INSERT INTO `item_basic` VALUES (@ERUDITE_CAP,0,'erudite_cap','erudite_cap',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ERUDITE_CAP;
INSERT INTO `item_equipment` VALUES (@ERUDITE_CAP,'erudite_cap',70,0,1589788,352,0,0,16,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ERUDITE_CAP;
INSERT INTO `item_mods` VALUES
    (@ERUDITE_CAP, @MOD_DEF,            25),
    (@ERUDITE_CAP, @MOD_MP,             30),
    (@ERUDITE_CAP, @MOD_VIT,             3),
    (@ERUDITE_CAP, @MOD_INT,             5),
    (@ERUDITE_CAP, @MOD_MACC,            5),
    (@ERUDITE_CAP, @MOD_CURE_CAST_TIME,  5);

-- Acrobat's Breeches (Xux Trousers)
SET @ACROBATS_BREECHES = 28201;
DELETE FROM `item_basic` WHERE itemid = @ACROBATS_BREECHES;
INSERT INTO `item_basic` VALUES (@ACROBATS_BREECHES,0,'acrobats_breeches','acrobats_breeches',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ACROBATS_BREECHES;
INSERT INTO `item_equipment` VALUES (@ACROBATS_BREECHES,'acrobats_breeches',70,0,2593826,346,0,0,128,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ACROBATS_BREECHES;
INSERT INTO `item_mods` VALUES
    (@ACROBATS_BREECHES, @MOD_DEF,           35),
    (@ACROBATS_BREECHES, @MOD_DEX,            2),
    (@ACROBATS_BREECHES, @MOD_AGI,            9),
    (@ACROBATS_BREECHES, @MOD_EVA,           11),
    (@ACROBATS_BREECHES, @MOD_HASTE,        200),
    (@ACROBATS_BREECHES, @MOD_TRIPLE_ATK,     2);

-- Steady Fists (Tlalpoloani)
SET @STEADY_FISTS = 20554;
DELETE FROM `item_basic` WHERE itemid = @STEADY_FISTS;
INSERT INTO `item_basic` VALUES (@STEADY_FISTS,0,'steady_fists','steady_fists',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @STEADY_FISTS;
INSERT INTO `item_equipment` VALUES (@STEADY_FISTS,'steady_fists',70,0,131074,135,0,0,1,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @STEADY_FISTS;
INSERT INTO `item_weapon` VALUES (@STEADY_FISTS,'steady_fists',1,0,0,0,0,@DMG_IMPACT,1,576,24,0);

DELETE FROM `item_mods` WHERE itemId = @STEADY_FISTS;
INSERT INTO `item_mods` VALUES
    (@STEADY_FISTS, @MOD_DEF,                      5),
    (@STEADY_FISTS, @MOD_DEX,                      8),
    (@STEADY_FISTS, @MOD_VIT,                      8),
    (@STEADY_FISTS, @MOD_GUARD_SKILL,              8),
    (@STEADY_FISTS, @MOD_PHYS_DMG_TAKEN,        -800),
    (@STEADY_FISTS, @MOD_ITEM_ADDEFFECT_TYPE,      1),
    (@STEADY_FISTS, @MOD_ITEM_SUBEFFECT,           4),
    (@STEADY_FISTS, @MOD_ITEM_ADDEFFECT_DMG,      20),
    (@STEADY_FISTS, @MOD_ITEM_ADDEFFECT_CHANCE,   15),
    (@STEADY_FISTS, @MOD_ITEM_ADDEFFECT_ELEMENT,   4);

-----------------------------------
-- Arfarvegr (Water)
-----------------------------------

-- Assailant's Visor (Ejekamal Mask)
SET @ASSAILANTS_VISOR = 27738;
DELETE FROM `item_basic` WHERE itemid = @ASSAILANTS_VISOR;
INSERT INTO `item_basic` VALUES (@ASSAILANTS_VISOR,0,'assailants_visor','assailants_visor',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ASSAILANTS_VISOR;
INSERT INTO `item_equipment` VALUES (@ASSAILANTS_VISOR,'assailants_visor',70,0,2593826,347,0,0,16,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ASSAILANTS_VISOR;
INSERT INTO `item_mods` VALUES
    (@ASSAILANTS_VISOR, @MOD_DEF,           28),
    (@ASSAILANTS_VISOR, @MOD_HP,            30),
    (@ASSAILANTS_VISOR, @MOD_MP,            22),
    (@ASSAILANTS_VISOR, @MOD_STR,            5),
    (@ASSAILANTS_VISOR, @MOD_DEX,           11),
    (@ASSAILANTS_VISOR, @MOD_DRAGON_KILLER,  5);

-- Subtle Sash (Chuq'aba Belt)
SET @SUBTLE_SASH = 28459;
DELETE FROM `item_basic` WHERE itemid = @SUBTLE_SASH;
INSERT INTO `item_basic` VALUES (@SUBTLE_SASH,0,'subtle_sash','subtle_sash',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SUBTLE_SASH;
INSERT INTO `item_equipment` VALUES (@SUBTLE_SASH,'subtle_sash',70,0,2473969,0,0,0,1024,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SUBTLE_SASH;
INSERT INTO `item_mods` VALUES
    (@SUBTLE_SASH, @MOD_AGI,           5),
    (@SUBTLE_SASH, @MOD_ATT,           5),
    (@SUBTLE_SASH, @MOD_RATT,          5),
    (@SUBTLE_SASH, @MOD_HASTE,       300),
    (@SUBTLE_SASH, @MOD_SUBTLE_BLOW,   8);

-- Ornate Gloves (Quauhpilli Gloves)
SET @ORNATE_GLOVES = 28062;
DELETE FROM `item_basic` WHERE itemid = @ORNATE_GLOVES;
INSERT INTO `item_basic` VALUES (@ORNATE_GLOVES,0,'ornate_gloves','ornate_gloves',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ORNATE_GLOVES;
INSERT INTO `item_equipment` VALUES (@ORNATE_GLOVES,'ornate_gloves',70,0,1589788,264,0,0,64,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ORNATE_GLOVES;
INSERT INTO `item_mods` VALUES
    (@ORNATE_GLOVES, @MOD_DEF,     17),
    (@ORNATE_GLOVES, @MOD_MP,      20),
    (@ORNATE_GLOVES, @MOD_DEX,      8),
    (@ORNATE_GLOVES, @MOD_MND,      6),
    (@ORNATE_GLOVES, @MOD_MACC,     4),
    (@ORNATE_GLOVES, @MOD_MATT,     4),
    (@ORNATE_GLOVES, @MOD_MDEF,     2),
    (@ORNATE_GLOVES, @MOD_HASTE,  200);

-- Unbreakable (Camatlatia)
SET @UNBREAKABLE = 20740;
DELETE FROM `item_basic` WHERE itemid = @UNBREAKABLE;
INSERT INTO `item_basic` VALUES (@UNBREAKABLE,0,'unbreakable','unbreakable',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @UNBREAKABLE;
INSERT INTO `item_equipment` VALUES (@UNBREAKABLE,'unbreakable',70,0,@RDM+@PLD+@BLU+@RUN,757,0,0,3,0,0,0); -- Fettering Blade

DELETE FROM `item_weapon` WHERE itemId = @UNBREAKABLE;
INSERT INTO `item_weapon` VALUES (@UNBREAKABLE,'unbreakable',3,0,0,0,0,@DMG_SLASHING,1,240,46,0);

DELETE FROM `item_mods` WHERE itemId = @UNBREAKABLE;
INSERT INTO `item_mods` VALUES
    (@UNBREAKABLE, @MOD_DEF,                     15),
    (@UNBREAKABLE, @MOD_WATER_RES,               15),
    (@UNBREAKABLE, @MOD_MND,                      3),
    (@UNBREAKABLE, @MOD_DAMAGE_TAKEN,          -500),
    (@UNBREAKABLE, @MOD_ENMITY,                   5),
    (@UNBREAKABLE, @MOD_DRAGON_KILLER,            5),
    (@UNBREAKABLE, @MOD_ITEM_ADDEFFECT_TYPE,      1),
    (@UNBREAKABLE, @MOD_ITEM_SUBEFFECT,           6),
    (@UNBREAKABLE, @MOD_ITEM_ADDEFFECT_DMG,      20),
    (@UNBREAKABLE, @MOD_ITEM_ADDEFFECT_CHANCE,   15),
    (@UNBREAKABLE, @MOD_ITEM_ADDEFFECT_ELEMENT,   6);

-----------------------------------
-- Skrudningr (Thunder)
-----------------------------------

-- Conqueror's Helm (Quauhpilli Helm)
SET @CONQUERORS_HELM = 27779;
DELETE FROM `item_basic` WHERE itemid = @CONQUERORS_HELM;
INSERT INTO `item_basic` VALUES (@CONQUERORS_HELM,0,'conquerors_helm','conquerors_helm',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @CONQUERORS_HELM;
INSERT INTO `item_equipment` VALUES (@CONQUERORS_HELM,'conquerors_helm',70,0,10689,348,0,0,16,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @CONQUERORS_HELM;
INSERT INTO `item_mods` VALUES
    (@CONQUERORS_HELM, @MOD_DEF,           36),
    (@CONQUERORS_HELM, @MOD_HP,            25),
    (@CONQUERORS_HELM, @MOD_STR,            8),
    (@CONQUERORS_HELM, @MOD_HASTE,        400),
    (@CONQUERORS_HELM, @MOD_DOUBLE_ATK,     2);

-- Stormblade (Koga Shinobi-gatana)
SET @STORMBLADE = 21915;
DELETE FROM `item_basic` WHERE itemid = @STORMBLADE;
INSERT INTO `item_basic` VALUES (@STORMBLADE,0,'stormblade','stormblade',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @STORMBLADE;
INSERT INTO `item_equipment` VALUES (@STORMBLADE,'stormblade',70,0,@WAR+@THF+@DRK+@BST+@BLU+@COR,263,0,0,3,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @STORMBLADE;
INSERT INTO `item_weapon` VALUES (@STORMBLADE,'stormblade',3,0,0,0,0,@DMG_SLASHING,2,236,39,0);

DELETE FROM `item_mods` WHERE itemId = @STORMBLADE;
INSERT INTO `item_mods` VALUES
    (@STORMBLADE, @MOD_THUNDER_RES,             14),
    (@STORMBLADE, @MOD_INT,                      3),
    (@STORMBLADE, @MOD_DRAGON_KILLER,            5),
    (@STORMBLADE, @MOD_ITEM_ADDEFFECT_TYPE,      1),
    (@STORMBLADE, @MOD_ITEM_SUBEFFECT,           5),
    (@STORMBLADE, @MOD_ITEM_ADDEFFECT_DMG,      40),
    (@STORMBLADE, @MOD_ITEM_ADDEFFECT_CHANCE,   15),
    (@STORMBLADE, @MOD_ITEM_ADDEFFECT_ELEMENT,   5);

DELETE FROM `item_latents` WHERE itemId = @STORMBLADE;
INSERT INTO `item_latents` VALUES (@STORMBLADE,9,5,35,0); -- Lightningsday: DEX +5

-- Loxo Scarf (Huani Collar)
SET @LOXO_SCARF = 28384;
DELETE FROM `item_basic` WHERE itemid = @LOXO_SCARF;
INSERT INTO `item_basic` VALUES (@LOXO_SCARF,0,'loxo_scarf','loxo_scarf',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @LOXO_SCARF;
INSERT INTO `item_equipment` VALUES (@LOXO_SCARF,'loxo_scarf',70,0,2569522,0,0,0,512,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @LOXO_SCARF;
INSERT INTO `item_mods` VALUES
    (@LOXO_SCARF, @MOD_AGI,           4),
    (@LOXO_SCARF, @MOD_RACC,          8),
    (@LOXO_SCARF, @MOD_THUNDER_RES,  15),
    (@LOXO_SCARF, @MOD_ENMITY,       -2);

-- Covenant Belt (Jaq'ij Sash)
SET @COVENANT_BELT = 28458;
DELETE FROM `item_basic` WHERE itemid = @COVENANT_BELT;
INSERT INTO `item_basic` VALUES (@COVENANT_BELT,0,'covenant_belt','covenant_belt',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @COVENANT_BELT;
INSERT INTO `item_equipment` VALUES (@COVENANT_BELT,'covenant_belt',70,0,1622556,0,0,0,1024,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @COVENANT_BELT;
INSERT INTO `item_mods` VALUES
    (@COVENANT_BELT, @MOD_MP,         30),
    (@COVENANT_BELT, @MOD_BLOOD_BOON,  3);

DELETE FROM `item_mods_pet` WHERE itemid = @COVENANT_BELT;
INSERT INTO `item_mods_pet` VALUES
    (@COVENANT_BELT, @MOD_ACC, 10, @PET_AVATAR);

-----------------------------------
-- Brjota (Wind)
-----------------------------------

-- Ruthless Greaves (Ejekamal Boots)
SET @RUTHLESS_GREAVES = 28305;
DELETE FROM `item_basic` WHERE itemid = @RUTHLESS_GREAVES;
INSERT INTO `item_basic` VALUES (@RUTHLESS_GREAVES,0,'ruthless_greaves','ruthless_greaves',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @RUTHLESS_GREAVES;
INSERT INTO `item_equipment` VALUES (@RUTHLESS_GREAVES,'ruthless_greaves',75,0,@WAR+@PLD+@DRK+@BST+@SAM+@DRG,328,0,0,256,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @RUTHLESS_GREAVES;
INSERT INTO `item_mods` VALUES
    (@RUTHLESS_GREAVES, @MOD_DEF,                    20),
    (@RUTHLESS_GREAVES, @MOD_HP,                     35),
    (@RUTHLESS_GREAVES, @MOD_WIND_RES,               15),
    (@RUTHLESS_GREAVES, @MOD_STR,                     5),
    (@RUTHLESS_GREAVES, @MOD_HASTE,                 400),
    (@RUTHLESS_GREAVES, @MOD_TRIPLE_ATK,              1),
    (@RUTHLESS_GREAVES, @MOD_ITEM_SUBEFFECT,          3),
    (@RUTHLESS_GREAVES, @MOD_ITEM_ADDEFFECT_DMG,     15),
    (@RUTHLESS_GREAVES, @MOD_ITEM_ADDEFFECT_CHANCE,  15);

-- Swift Gages (Buremte Gloves)
SET @SWIFT_GAGES = 28050;
DELETE FROM `item_basic` WHERE itemid = @SWIFT_GAGES;
INSERT INTO `item_basic` VALUES (@SWIFT_GAGES,0,'swift_gages','swift_gages',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SWIFT_GAGES;
INSERT INTO `item_equipment` VALUES (@SWIFT_GAGES,'swift_gages',75,0,@WAR+@RDM+@THF+@PLD+@DRK+@BST+@BRD+@RNG+@SAM+@NIN+@DRG+@BLU+@COR+@DNC+@RUN,249,0,0,64,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SWIFT_GAGES;
INSERT INTO `item_mods` VALUES
    (@SWIFT_GAGES, @MOD_DEF,         20),
    (@SWIFT_GAGES, @MOD_HP,          15),
    (@SWIFT_GAGES, @MOD_WIND_RES,    15),
    (@SWIFT_GAGES, @MOD_AGI,          8),
    (@SWIFT_GAGES, @MOD_HASTE,      400),
    (@SWIFT_GAGES, @MOD_STORE_TP,     2);

-- Windfall Hat (Xux Hat)
SET @WINDFALL_HAT = 27781;
DELETE FROM `item_basic` WHERE itemid = @WINDFALL_HAT;
INSERT INTO `item_basic` VALUES (@WINDFALL_HAT,0,'windfall_hat','windfall_hat',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @WINDFALL_HAT;
INSERT INTO `item_equipment` VALUES (@WINDFALL_HAT,'windfall_hat',75,0,1589788,346,0,0,16,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @WINDFALL_HAT;
INSERT INTO `item_mods` VALUES
    (@WINDFALL_HAT, @MOD_DEF,        20),
    (@WINDFALL_HAT, @MOD_MP,         25),
    (@WINDFALL_HAT, @MOD_WIND_RES,   15),
    (@WINDFALL_HAT, @MOD_HASTE,     600),
    (@WINDFALL_HAT, @MOD_FASTCAST,    3),
    (@WINDFALL_HAT, 897,              2); -- Gilfinder +2

-- Hurricane
SET @HURRICANE = 20936;
DELETE FROM `item_basic` WHERE itemid = @HURRICANE;
INSERT INTO `item_basic` VALUES (@HURRICANE,0,'hurricane','hurricane',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HURRICANE;
INSERT INTO `item_equipment` VALUES (@HURRICANE,'hurricane',75,0,@SAM+@DRG,444,0,0,1,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @HURRICANE;
INSERT INTO `item_weapon` VALUES (@HURRICANE,'hurricane',8,0,0,0,0,@DMG_PIERCING,2,480,72,0);

DELETE FROM `item_mods` WHERE itemId = @HURRICANE;
INSERT INTO `item_mods` VALUES
    (@HURRICANE, @MOD_AGI,       9),
    (@HURRICANE, @MOD_VIT,       9),
    (@HURRICANE, @MOD_WIND_RES, 18),
    (@HURRICANE, @MOD_ACC,      10),
    (@HURRICANE, @MOD_STORE_TP,  5);

-----------------------------------
-- (Light)
-----------------------------------

-- Timeless Ocarina
SET @TIMELESS_OCARINA = 28388;
DELETE FROM `item_basic` WHERE itemid = @TIMELESS_OCARINA;
INSERT INTO `item_basic` VALUES (@TIMELESS_OCARINA,0,'timeless_ocarina','timeless_ocarina',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TIMELESS_OCARINA;
INSERT INTO `item_equipment` VALUES (@TIMELESS_OCARINA,'timeless_ocarina',75,0,@BRD,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TIMELESS_OCARINA;
INSERT INTO `item_mods` VALUES
    (@TIMELESS_OCARINA, @MOD_MP,                  25),
    (@TIMELESS_OCARINA, @MOD_CHR,                  5),
    (@TIMELESS_OCARINA, @MOD_LIGHT_RES,           10),
    (@TIMELESS_OCARINA, @MOD_SWORD_SKILL,         12),
    (@TIMELESS_OCARINA, @MOD_SONG_DURATION_BONUS, 10);

-- Sol Stone
SET @SOL_STONE = 28457;
DELETE FROM `item_basic` WHERE itemid = @SOL_STONE;
INSERT INTO `item_basic` VALUES (@SOL_STONE,0,'sol_stone','sol_stone',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SOL_STONE;
INSERT INTO `item_equipment` VALUES (@SOL_STONE,'sol_stone',75,0,@BST+@DRG+@SMN+@PUP,0,0,0,@SLOT_WAIST,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SOL_STONE;
INSERT INTO `item_mods` VALUES
    (@SOL_STONE, @MOD_DEF,     5),
    (@SOL_STONE, @MOD_ACC,     5),
    (@SOL_STONE, @MOD_EVA,     5),
    (@SOL_STONE, @MOD_HASTE, 500);

DELETE FROM `item_mods_pet` WHERE itemId = @SOL_STONE;
INSERT INTO `item_mods_pet` VALUES
    (@SOL_STONE, @MOD_HASTE,  300, @PET_ALL);

-- TBD tank item

-- Refraction
SET @REFRACTION = 20595;
DELETE FROM `item_basic` WHERE itemid = @REFRACTION;
INSERT INTO `item_basic` VALUES (@REFRACTION,0,'refraction','refraction',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @REFRACTION;
INSERT INTO `item_equipment` VALUES (@REFRACTION,'refraction',75,0,@THF+@RNG+@COR,541,0,0,3,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @REFRACTION;
INSERT INTO `item_weapon` VALUES (@REFRACTION,'refraction',2,0,0,0,0,@DMG_PIERCING,1,201,35,0);

DELETE FROM `item_mods` WHERE itemId = @REFRACTION;
INSERT INTO `item_mods` VALUES
    (@REFRACTION, @MOD_AGI,        4),
    (@REFRACTION, @MOD_MND,        8),
    (@REFRACTION, @MOD_RACC,      12),
    (@REFRACTION, @MOD_ENMITY,    -4),
    (@REFRACTION, @MOD_MOVESPEED, 12);

-----------------------------------
-- Gobbie Brew
-----------------------------------

-- Zhulong Bell (Lv30)
SET @ZHULONG_BELL = 21425;
DELETE FROM `item_basic` WHERE itemid = @ZHULONG_BELL;
INSERT INTO `item_basic` VALUES (@ZHULONG_BELL,0,'zhulong_bell','zhulong_bell',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ZHULONG_BELL;
INSERT INTO `item_equipment` VALUES (@ZHULONG_BELL,'zhulong_bell',30,0,@GEO,121,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @ZHULONG_BELL;
INSERT INTO `item_weapon` VALUES (@ZHULONG_BELL,'zhulong_bell',45,0,0,0,0,0,1,999,0,0);

DELETE FROM `item_mods` WHERE itemId = @ZHULONG_BELL;
INSERT INTO `item_mods` VALUES
    (@ZHULONG_BELL, @MOD_FIRE_RES,       5),
    (@ZHULONG_BELL, @MOD_MP,            15),
    (@ZHULONG_BELL, @MOD_HANDBELL_SKILL, 3);

-- Enlightenment (Lv30)
SET @ENLIGHTENMENT = 21426;
DELETE FROM `item_basic` WHERE itemid = @ENLIGHTENMENT;
INSERT INTO `item_basic` VALUES (@ENLIGHTENMENT,0,'enlightenment','enlightenment',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ENLIGHTENMENT;
INSERT INTO `item_equipment` VALUES (@ENLIGHTENMENT,'enlightenment',30,0,@SCH,0,0,0,@SLOT_AMMO,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @ENLIGHTENMENT;
INSERT INTO `item_weapon` VALUES (@ENLIGHTENMENT,'enlightenment',0,0,0,0,0,0,1,999,0,0);

DELETE FROM `item_mods` WHERE itemId = @ENLIGHTENMENT;
INSERT INTO `item_mods` VALUES
    (@ENLIGHTENMENT, @MOD_MP,            15),
    (@ENLIGHTENMENT, @MOD_INT,            1),
    (@ENLIGHTENMENT, @MOD_MND,            1),
    (@ENLIGHTENMENT, @MOD_HEALING_SKILL,  3);

-- Sinister Sickle (Lv30)
SET @SINISTER_SICKLE = 20829;
DELETE FROM `item_basic` WHERE itemid = @SINISTER_SICKLE;
INSERT INTO `item_basic` VALUES (@SINISTER_SICKLE,0,'sinister_sickle','sinister_sickle',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SINISTER_SICKLE;
INSERT INTO `item_equipment` VALUES (@SINISTER_SICKLE,'sinister_sickle',30,0,@BLM,366,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @SINISTER_SICKLE;
INSERT INTO `item_weapon` VALUES (@SINISTER_SICKLE,'sinister_sickle',7,0,0,0,0,@DMG_SLASHING,1,501,52,0);

DELETE FROM `item_mods` WHERE itemId = @SINISTER_SICKLE;
INSERT INTO `item_mods` VALUES
    (@SINISTER_SICKLE, @MOD_DARK_RES,         10),
    (@SINISTER_SICKLE, @MOD_STR,               2),
    (@SINISTER_SICKLE, @MOD_ACC,               6),
    (@SINISTER_SICKLE, @MOD_DOUBLE_ATK,        2);

DELETE FROM `item_latents` WHERE itemid = @SINISTER_SICKLE;
INSERT INTO `item_latents` VALUES (@SINISTER_SICKLE,369,1,5,30); -- "Refresh" effect while MP under 30 (actual number,not %)

-- Tigris Grip (Lv40)
SET @TIGRIS_GRIP = 21428;
DELETE FROM `item_basic` WHERE itemid = @TIGRIS_GRIP;
INSERT INTO `item_basic` VALUES (@TIGRIS_GRIP,0,'tigris_grip','tigris_grip',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TIGRIS_GRIP;
INSERT INTO `item_equipment` VALUES (@TIGRIS_GRIP,'tigris_grip',40,0,4194303,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TIGRIS_GRIP;
INSERT INTO `item_mods` VALUES
    (@TIGRIS_GRIP, @MOD_ATT,       2),
    (@TIGRIS_GRIP, @MOD_STORE_TP,  2);

-- Slippery Cape (Lv40)
SET @SLIPPERY_CAPE = 28611;
DELETE FROM `item_basic` WHERE itemid = @SLIPPERY_CAPE;
INSERT INTO `item_basic` VALUES (@SLIPPERY_CAPE,0,'slippery_cape','slippery_cape',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SLIPPERY_CAPE;
INSERT INTO `item_equipment` VALUES (@SLIPPERY_CAPE,'slippery_cape',40,0,269345,0,0,0,@SLOT_BACK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SLIPPERY_CAPE;
INSERT INTO `item_mods` VALUES
    (@SLIPPERY_CAPE, @MOD_DEF, 5),
    (@SLIPPERY_CAPE, @MOD_ATT, 4),
    (@SLIPPERY_CAPE, @MOD_EVA, 4);

-- Chivalric Emblem (Lv40)
SET @CHIVALRIC_EMBLEM = 20965;
DELETE FROM `item_basic` WHERE itemid = @CHIVALRIC_EMBLEM;
INSERT INTO `item_basic` VALUES (@CHIVALRIC_EMBLEM,0,'chivalric_emblem','chivalric_emblem',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @CHIVALRIC_EMBLEM;
INSERT INTO `item_equipment` VALUES (@CHIVALRIC_EMBLEM,'chivalric_emblem',40,0,@WAR+@PLD+@RUN,0,0,0,@SLOT_AMMO,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @CHIVALRIC_EMBLEM;
INSERT INTO `item_weapon` VALUES (@CHIVALRIC_EMBLEM,'chivalric_emblem',0,0,0,0,0,0,1,999,0,0);

DELETE FROM `item_mods` WHERE itemId = @CHIVALRIC_EMBLEM;
INSERT INTO `item_mods` VALUES
    (@CHIVALRIC_EMBLEM, @MOD_LIGHT_RES,     10),
    (@CHIVALRIC_EMBLEM, @MOD_HP,            15),
    (@CHIVALRIC_EMBLEM, @MOD_PARRY_SKILL,    3);

-- Liberty (Lv50)
SET @LIBERTY = 21257;
DELETE FROM `item_basic` WHERE itemid = @LIBERTY;
INSERT INTO `item_basic` VALUES (@LIBERTY,0,'liberty','liberty',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @LIBERTY;
INSERT INTO `item_equipment` VALUES (@LIBERTY,'liberty',50,0,70688,60,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @LIBERTY;
INSERT INTO `item_weapon` VALUES (@LIBERTY,'liberty',26,1,0,0,0,@DMG_PIERCING,1,548,35,0);

DELETE FROM `item_mods` WHERE itemId = @LIBERTY;
INSERT INTO `item_mods` VALUES
    (@LIBERTY, @MOD_AGI,  2),
    (@LIBERTY, @MOD_INT,  2),
    (@LIBERTY, @MOD_RACC, 8);

-- Wyrt Gorget (Lv50)
SET @WYRT_GORGET = 28400;
DELETE FROM `item_basic` WHERE itemid = @WYRT_GORGET;
INSERT INTO `item_basic` VALUES (@WYRT_GORGET,0,'wyrt_gorget','wyrt_gorget',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @WYRT_GORGET;
INSERT INTO `item_equipment` VALUES (@WYRT_GORGET,'wyrt_gorget',50,0,3662710,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @WYRT_GORGET;
INSERT INTO `item_mods` VALUES
    (@WYRT_GORGET, @MOD_DEF,      4),
    (@WYRT_GORGET, @MOD_STR,      4),
    (@WYRT_GORGET, @MOD_VIT,      4);

-- Myrmeleo Ring (Lv50)
SET @MYRMELEO_RING = 28576;
DELETE FROM `item_basic` WHERE itemid = @MYRMELEO_RING;
INSERT INTO `item_basic` VALUES (@MYRMELEO_RING,0,'myrmeleo_ring','myrmeleo_ring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @MYRMELEO_RING;
INSERT INTO `item_equipment` VALUES (@MYRMELEO_RING,'myrmeleo_ring',50,0,4194303,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @MYRMELEO_RING;
INSERT INTO `item_mods` VALUES
    (@MYRMELEO_RING, @MOD_HP,               20),
    (@MYRMELEO_RING, @MOD_VIT,               4),
    (@MYRMELEO_RING, @MOD_EARTH_RES,        10),
    (@MYRMELEO_RING, @MOD_PHYS_DMG_TAKEN, -200);

-- Avarice (Humility) (Lv73)
SET @AVARICE = 21697;
DELETE FROM `item_basic` WHERE itemid = @AVARICE;
INSERT INTO `item_basic` VALUES (@AVARICE,0,'avarice','avarice',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @AVARICE;
INSERT INTO `item_equipment` VALUES (@AVARICE,'avarice',73,0,2097281,630,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @AVARICE;
INSERT INTO `item_weapon` VALUES (@AVARICE,'avarice',4,0,0,0,0,@DMG_SLASHING,1,480,84,0);

DELETE FROM `item_mods` WHERE itemId = @AVARICE;
INSERT INTO `item_mods` VALUES
    (@AVARICE, @MOD_HP,              -20),
    (@AVARICE, @MOD_CHR,             -10),
    (@AVARICE, @MOD_TREASURE_HUNTER,   2),
    (@AVARICE, @MOD_GILFINDER,         2);

-- Kyugutachi (Lv73)
SET @KYUGUTACHI = 21054;
DELETE FROM `item_basic` WHERE itemid = @KYUGUTACHI;
INSERT INTO `item_basic` VALUES (@KYUGUTACHI,0,'kyugutachi','kyugutachi',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @KYUGUTACHI;
INSERT INTO `item_equipment` VALUES (@KYUGUTACHI,'kyugutachi',73,0,2048,323,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @KYUGUTACHI;
INSERT INTO `item_weapon` VALUES (@KYUGUTACHI,'kyugutachi',10,0,0,0,0,@DMG_SLASHING,1,450,82,0);

DELETE FROM `item_mods` WHERE itemId = @KYUGUTACHI;
INSERT INTO `item_mods` VALUES
    (@KYUGUTACHI, @MOD_HP,            20),
    (@KYUGUTACHI, @MOD_AGI,           12),
    (@KYUGUTACHI, @MOD_ARCHERY_SKILL, 15);

-- Sprightly Feather (Lv73)
SET @SPRIGHTLY_FEATHER = 21386;
DELETE FROM `item_basic` WHERE itemid = @SPRIGHTLY_FEATHER;
INSERT INTO `item_basic` VALUES (@SPRIGHTLY_FEATHER,0,'sprightly_feather','sprightly_feather',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SPRIGHTLY_FEATHER;
INSERT INTO `item_equipment` VALUES (@SPRIGHTLY_FEATHER,'sprightly_feather',73,0,4194303,0,0,0,@SLOT_AMMO,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @SPRIGHTLY_FEATHER;
INSERT INTO `item_weapon` VALUES (@SPRIGHTLY_FEATHER,'sprightly_feather',0,0,0,0,0,0,1,999,0,0);

DELETE FROM `item_mods` WHERE itemId = @SPRIGHTLY_FEATHER;
INSERT INTO `item_mods` VALUES
    (@SPRIGHTLY_FEATHER, @MOD_MP,            10),
    (@SPRIGHTLY_FEATHER, @MOD_STAFF_SKILL,    4),
    (@SPRIGHTLY_FEATHER, @MOD_SCYTHE_SKILL,   4);

-----------------------------------
-- Goblin Brew +2
-----------------------------------
-- Hibernal Ring (Lv75)
SET @HIBERNAL_RING = 28575;
DELETE FROM `item_basic` WHERE itemid = @HIBERNAL_RING;
INSERT INTO `item_basic` VALUES (@HIBERNAL_RING,0,'hibernal_ring','hibernal_ring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HIBERNAL_RING;
INSERT INTO `item_equipment` VALUES (@HIBERNAL_RING,'hibernal_ring',75,0,@BLM+@BRD+@SCH+@GEO,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HIBERNAL_RING;
INSERT INTO `item_mods` VALUES
    (@HIBERNAL_RING, @MOD_MP,               25),
    (@HIBERNAL_RING, @MOD_INT,               5),
    (@HIBERNAL_RING, @MOD_ICE_RES,          15),
    (@HIBERNAL_RING, @MOD_FASTCAST,          2);

-- Hailstone Hose (Lv75)
SET @HAILSTONE_HOSE = 28166;
DELETE FROM `item_basic` WHERE itemid = @HAILSTONE_HOSE;
INSERT INTO `item_basic` VALUES (@HAILSTONE_HOSE,0,'hailstone_hose','hailstone_hose',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HAILSTONE_HOSE;
INSERT INTO `item_equipment` VALUES (@HAILSTONE_HOSE,'hailstone_hose',75,0,@THF+@RNG+@NIN+@COR,320,0,0,@SLOT_LEGS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HAILSTONE_HOSE;
INSERT INTO `item_mods` VALUES
    (@HAILSTONE_HOSE, @MOD_HP,               25),
    (@HAILSTONE_HOSE, @MOD_RATT,             10),
    (@HAILSTONE_HOSE, @MOD_ICE_RES,          20),
    (@HAILSTONE_HOSE, @MOD_HASTE,           200),
    (@HAILSTONE_HOSE, @MOD_MARKSMAN_SKILL,    5),
    (@HAILSTONE_HOSE, @MOD_MATT,              5);

-- Rikugame Nodowa (Lv75)
SET @RIKUGAME_NODOWA = 28385;
DELETE FROM `item_basic` WHERE itemid = @RIKUGAME_NODOWA;
INSERT INTO `item_basic` VALUES (@RIKUGAME_NODOWA,0,'rikugame_nodowa','rikugame_nodowa',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @RIKUGAME_NODOWA;
INSERT INTO `item_equipment` VALUES (@RIKUGAME_NODOWA,'rikugame_nodowa',75,0,@WAR+@DRK+@DRG+@SAM+@RUN,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @RIKUGAME_NODOWA;
INSERT INTO `item_mods` VALUES
    (@RIKUGAME_NODOWA, @MOD_DEF,              10),
    (@RIKUGAME_NODOWA, @MOD_VIT,               4),
    (@RIKUGAME_NODOWA, @MOD_STORE_TP,          3);

-- Tellus Pendulum (Lv75)
SET @TELLUS_PENDULUM = 28387;
DELETE FROM `item_basic` WHERE itemid = @TELLUS_PENDULUM;
INSERT INTO `item_basic` VALUES (@TELLUS_PENDULUM,0,'tellus_pendulum','tellus_pendulum',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TELLUS_PENDULUM;
INSERT INTO `item_equipment` VALUES (@TELLUS_PENDULUM,'tellus_pendulum',75,0,@WHM+@BLM+@SMN+@SCH+@GEO,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TELLUS_PENDULUM;
INSERT INTO `item_mods` VALUES
    (@TELLUS_PENDULUM, @MOD_STR,               5),
    (@TELLUS_PENDULUM, @MOD_VIT,               3),
    (@TELLUS_PENDULUM, @MOD_EARTH_RES,        15),
    (@TELLUS_PENDULUM, 35,                     8); -- Earth MAB

-- Bagua Ring (Lv75)
SET @BAGUA_RING = 28548;
DELETE FROM `item_basic` WHERE itemid = @BAGUA_RING;
INSERT INTO `item_basic` VALUES (@BAGUA_RING,0,'bagua_ring','bagua_ring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BAGUA_RING;
INSERT INTO `item_equipment` VALUES (@BAGUA_RING,'bagua_ring',75,0,@GEO,0,0,0,24576,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @BAGUA_RING;
INSERT INTO `item_mods` VALUES
    (@BAGUA_RING, @MOD_MP,               40),
    (@BAGUA_RING, @MOD_MND,               5),
    (@BAGUA_RING, @MOD_DEX,               2),
    (@BAGUA_RING, @MOD_GEOMANCY_SKILL,    5);

-- Luminous Earring (Lv75)
SET @LUMINOUS_EARRING = 28613;
DELETE FROM `item_basic` WHERE itemid = @LUMINOUS_EARRING ;
INSERT INTO `item_basic` VALUES (@LUMINOUS_EARRING ,0,'luminous_earring','luminous_earring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @LUMINOUS_EARRING ;
INSERT INTO `item_equipment` VALUES (@LUMINOUS_EARRING ,'luminous_earring',75,0,@MNK+@RDM+@THF+@BST+@BRD+@NIN+@BLU+@COR+@PUP+@DNC+@RUN,0,0,0,@SLOT_EAR,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @LUMINOUS_EARRING;
INSERT INTO `item_mods` VALUES
    (@LUMINOUS_EARRING, @MOD_ATT,               4),
    (@LUMINOUS_EARRING, @MOD_ACC,               3),
    (@LUMINOUS_EARRING, @MOD_LIGHT_RES,        10),
    (@LUMINOUS_EARRING, @MOD_SUBTLE_BLOW,       2);

-- Emberpearl Earring (Lv75)
SET @EMBERPEARL_EARRING = 28612;
DELETE FROM `item_basic` WHERE itemid = @EMBERPEARL_EARRING ;
INSERT INTO `item_basic` VALUES (@EMBERPEARL_EARRING ,0,'emberpearl_earring','emberpearl_earring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @EMBERPEARL_EARRING ;
INSERT INTO `item_equipment` VALUES (@EMBERPEARL_EARRING ,'emberpearl_earring',75,0,@WAR+@WHM+@RDM+@PLD+@DRK+@RNG+@SAM+@BLU+@COR+@GEO+@RUN,0,0,0,@SLOT_EAR,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @EMBERPEARL_EARRING;
INSERT INTO `item_mods` VALUES
    (@EMBERPEARL_EARRING, @MOD_STR,               2),
    (@EMBERPEARL_EARRING, @MOD_MND,               2),
    (@EMBERPEARL_EARRING, @MOD_FIRE_RES,         10);

-- Flamedancer Glaive (Lv75)
SET @FLAMEDANCER_GLAIVE = 21026;
DELETE FROM `item_basic` WHERE itemid = @FLAMEDANCER_GLAIVE;
INSERT INTO `item_basic` VALUES (@FLAMEDANCER_GLAIVE,0,'flamedancer_glaive','flamedancer_glaive',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @FLAMEDANCER_GLAIVE;
INSERT INTO `item_equipment` VALUES (@FLAMEDANCER_GLAIVE,'flamedancer_glaive',30,0,@DNC,89,0,0,4,@SLOT_RANGED,0,0);

DELETE FROM `item_weapon` WHERE itemId = @FLAMEDANCER_GLAIVE;
INSERT INTO `item_weapon` VALUES (@FLAMEDANCER_GLAIVE,'flamedancer_glaive',27,0,0,0,0,@DMG_PIERCING,1,286,16,0);

DELETE FROM `item_mods` WHERE itemId = @FLAMEDANCER_GLAIVE;
INSERT INTO `item_mods` VALUES
    (@FLAMEDANCER_GLAIVE, @MOD_CHR,                      5),
    (@FLAMEDANCER_GLAIVE, @MOD_FIRE_RES,                15),
    (@FLAMEDANCER_GLAIVE, @MOD_STEP_ACCURACY,           10),
    (@FLAMEDANCER_GLAIVE, @MOD_SAMBA_DURATION,          15),
    (@FLAMEDANCER_GLAIVE, @MOD_ITEM_ADDEFFECT_TYPE,      1),
    (@FLAMEDANCER_GLAIVE, @MOD_ITEM_SUBEFFECT,           1),
    (@FLAMEDANCER_GLAIVE, @MOD_ITEM_ADDEFFECT_DMG,      15),
    (@FLAMEDANCER_GLAIVE, @MOD_ITEM_ADDEFFECT_CHANCE,  100),
    (@FLAMEDANCER_GLAIVE, @MOD_ITEM_ADDEFFECT_ELEMENT,   1);

-----------------------------------
-- Goblin Brew +3
-----------------------------------

-- Kennan's Longbow
SET @KENNANS_LONGBOW = 21089;
DELETE FROM `item_basic` WHERE itemid = @KENNANS_LONGBOW;
INSERT INTO `item_basic` VALUES (@KENNANS_LONGBOW,0,'kennans_longbow','kennans_longbow',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @KENNANS_LONGBOW;
INSERT INTO `item_equipment` VALUES (@KENNANS_LONGBOW,'kennans_longbow',75,0,@RNG+@SAM,86,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @KENNANS_LONGBOW;
INSERT INTO `item_weapon` VALUES (@KENNANS_LONGBOW,'kennans_longbow',25,0,0,0,0,@DMG_PIERCING,1,524,78,0);

DELETE FROM `item_mods` WHERE itemId = @KENNANS_LONGBOW;
INSERT INTO `item_mods` VALUES
    (@KENNANS_LONGBOW, @MOD_STR,              5),
    (@KENNANS_LONGBOW, @MOD_AGI,              5),
    (@KENNANS_LONGBOW, @MOD_ARCHERY_SKILL,   10),
    (@KENNANS_LONGBOW, @MOD_STORE_TP,         5),
    (@KENNANS_LONGBOW, @MOD_TP_BONUS,      1000);

-- Oathbreaker
SET @OATHBREAKER = 20643;
DELETE FROM `item_basic` WHERE itemid = @OATHBREAKER;
INSERT INTO `item_basic` VALUES (@OATHBREAKER,0,'oathbreaker','oathbreaker',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @OATHBREAKER;
INSERT INTO `item_equipment` VALUES (@OATHBREAKER,'oathbreaker',75,0,@WAR+@PLD+@NIN+@RUN,0,0,0,@SLOT_AMMO,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @OATHBREAKER;
INSERT INTO `item_weapon` VALUES (@OATHBREAKER,'oathbreaker',0,0,0,0,0,0,1,999,0,0);

DELETE FROM `item_mods` WHERE itemId = @OATHBREAKER;
INSERT INTO `item_mods` VALUES
    (@OATHBREAKER, @MOD_AGI,               4),
    (@OATHBREAKER, @MOD_PARRY_SKILL,       9),
    (@OATHBREAKER, @MOD_ABSORB_DMG_TO_MP,  2);

-- Manaflow Sash
SET @MANAFLOW_SASH = 28615;
DELETE FROM `item_basic` WHERE itemid = @MANAFLOW_SASH;
INSERT INTO `item_basic` VALUES (@MANAFLOW_SASH,0,'manaflow_sash','manaflow_sash',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @MANAFLOW_SASH;
INSERT INTO `item_equipment` VALUES (@MANAFLOW_SASH,'manaflow_sash',75,0,@WHM+@BLM+@SMN+@SCH+@GEO,0,0,0,@SLOT_WAIST,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @MANAFLOW_SASH;
INSERT INTO `item_mods` VALUES
    (@MANAFLOW_SASH, @MOD_DEF,       5),
    (@MANAFLOW_SASH, @MOD_MP,       25),
    (@MANAFLOW_SASH, @MOD_MND,       5),
    (@MANAFLOW_SASH, @MOD_FASTCAST,  2);

-- Beastly Girdle
SET @BEASTLY_GIRDLE = 28460;
DELETE FROM `item_basic` WHERE itemid = @BEASTLY_GIRDLE;
INSERT INTO `item_basic` VALUES (@BEASTLY_GIRDLE,0,'beastly_girdle','beastly_girdle',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BEASTLY_GIRDLE;
INSERT INTO `item_equipment` VALUES (@BEASTLY_GIRDLE,'beastly_girdle',75,0,@BST+@DRG+@SMN+@PUP,0,0,0,@SLOT_WAIST,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @BEASTLY_GIRDLE;
INSERT INTO `item_mods` VALUES
    (@BEASTLY_GIRDLE, @MOD_DEF,        5),
    (@BEASTLY_GIRDLE, @MOD_HP,        35),
    (@BEASTLY_GIRDLE, @MOD_VIT,        6),
    (@BEASTLY_GIRDLE, @MOD_EARTH_RES, 10);

DELETE FROM `item_mods_pet` WHERE itemId = @BEASTLY_GIRDLE;
INSERT INTO `item_mods_pet` VALUES
    (@BEASTLY_GIRDLE, @MOD_PHYS_DMG_TAKEN, -400, @PET_ALL);

-----------------------------------
-- Movement Speed
-----------------------------------
SET @STRIDER_BOOTS     = 14080;
SET @TROTTER_BOOTS     = 15736;

SET @CRIMSON_CUISSES   = 14280;
SET @BLOOD_CUISSES     = 14281;

SET @HERALDS_GAITERS   = 15322;
SET @CRIERS_GAITERS    = 27456;

SET @SKADIS_JAMBEAUX   = 15715;

SET @HERMES_SANDALS    = 11379;
SET @HERMES_SANDALS_P1 = 11380;

UPDATE `item_mods` SET value = 18 WHERE modId = @MOD_MOVESPEED AND itemId = @STRIDER_BOOTS;
UPDATE `item_mods` SET value = 18 WHERE modId = @MOD_MOVESPEED AND itemId = @TROTTER_BOOTS;

UPDATE `item_mods` SET value = 12 WHERE modId = @MOD_MOVESPEED AND itemId = @CRIMSON_CUISSES;
UPDATE `item_mods` SET value = 18 WHERE modId = @MOD_MOVESPEED AND itemId = @BLOOD_CUISSES;

UPDATE `item_mods` SET value = 18 WHERE modId = @MOD_MOVESPEED AND itemId = @HERALDS_GAITERS;
UPDATE `item_mods` SET value = 18 WHERE modId = @MOD_MOVESPEED AND itemId = @CRIERS_GAITERS;

UPDATE `item_mods` SET value = 19 WHERE modId = @MOD_MOVESPEED AND itemId = @SKADIS_JAMBEAUX;

UPDATE `item_mods` SET value = 18 WHERE modId = @MOD_MOVESPEED AND itemId = @HERMES_SANDALS;
UPDATE `item_mods` SET value = 19 WHERE modId = @MOD_MOVESPEED AND itemId = @HERMES_SANDALS_P1;

-- Areion Boots
SET @AREION_BOOTS = 10647;
DELETE FROM `item_basic` WHERE itemid = @AREION_BOOTS;
INSERT INTO `item_basic` VALUES (@AREION_BOOTS,0,'areion_boots','areion_boots',1,@ITEM_EQDEF,@AH_FEET,1,0);

DELETE FROM `item_equipment` WHERE itemId = @AREION_BOOTS;
INSERT INTO `item_equipment` VALUES (@AREION_BOOTS,'areion_boots',20,0,@THF+@RNG,11,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @AREION_BOOTS;
INSERT INTO `item_mods` VALUES
    (@AREION_BOOTS, @MOD_DEF,        4),
    (@AREION_BOOTS, @MOD_AGI,        3),
    (@AREION_BOOTS, @MOD_ACC,        2),
    (@AREION_BOOTS, @MOD_MOVESPEED, 19);

-- Areion Boots +1
SET @AREION_BOOTS_P1 = 10648;
DELETE FROM `item_basic` WHERE itemid = @AREION_BOOTS_P1;
INSERT INTO `item_basic` VALUES (@AREION_BOOTS_P1,0,'areion_boots_+1','areion_boots_+1',1,@ITEM_EQDEF,@AH_FEET,1,0);

DELETE FROM `item_equipment` WHERE itemId = @AREION_BOOTS_P1;
INSERT INTO `item_equipment` VALUES (@AREION_BOOTS_P1,'areion_boots_+1',20,0,@THF+@RNG,11,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @AREION_BOOTS_P1;
INSERT INTO `item_mods` VALUES
    (@AREION_BOOTS_P1, @MOD_DEF,        5),
    (@AREION_BOOTS_P1, @MOD_AGI,        4),
    (@AREION_BOOTS_P1, @MOD_ACC,        3),
    (@AREION_BOOTS_P1, @MOD_MOVESPEED, 20);

-- Harbinger's Gaiters
SET @HARBINGERS_GAITERS = 27400;
DELETE FROM `item_basic` WHERE itemid = @HARBINGERS_GAITERS;
INSERT INTO `item_basic` VALUES (@HARBINGERS_GAITERS,0,'harbingers_gaiters','harbingers_gaiters',1,@ITEM_EQDEF,@AH_FEET,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HARBINGERS_GAITERS;
INSERT INTO `item_equipment` VALUES (@HARBINGERS_GAITERS,'harbingers_gaiters',70,0,@MNK+@WHM+@BLM+@SMN+@SCH+@GEO,21,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HARBINGERS_GAITERS;
INSERT INTO `item_mods` VALUES
    (@HARBINGERS_GAITERS, @MOD_DEF,        17),
    (@HARBINGERS_GAITERS, @MOD_MP,         15),
    (@HARBINGERS_GAITERS, @MOD_EVA,         9),
    (@HARBINGERS_GAITERS, @MOD_HASTE,     200),
    (@HARBINGERS_GAITERS, @MOD_MOVESPEED,  19);

-- Harbinger's Gaiters +1
SET @HARBINGERS_GAITERS_P1 = 27401;
DELETE FROM `item_basic` WHERE itemid = @HARBINGERS_GAITERS_P1;
INSERT INTO `item_basic` VALUES (@HARBINGERS_GAITERS_P1,0,'harbingers_gaiters_+1','harbingers_gaiters_+1',1,@ITEM_EQDEF,@AH_FEET,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HARBINGERS_GAITERS_P1;
INSERT INTO `item_equipment` VALUES (@HARBINGERS_GAITERS_P1,'harbingers_gaiters_+1',70,0,@MNK+@WHM+@BLM+@SMN+@SCH+@GEO,21,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HARBINGERS_GAITERS_P1;
INSERT INTO `item_mods` VALUES
    (@HARBINGERS_GAITERS_P1, @MOD_DEF,        18),
    (@HARBINGERS_GAITERS_P1, @MOD_MP,         18),
    (@HARBINGERS_GAITERS_P1, @MOD_EVA,        10),
    (@HARBINGERS_GAITERS_P1, @MOD_HASTE,     300),
    (@HARBINGERS_GAITERS_P1, @MOD_MOVESPEED,  20);

-----------------------------------
-- Synthesis for Movespeed upgrades
-----------------------------------
-- Elementium Ingot
SET @ELEMENTIUM_INGOT = 9495;
DELETE FROM `item_basic` WHERE itemId = @ELEMENTIUM_INGOT;
INSERT INTO `item_basic` VALUES (@ELEMENTIUM_INGOT,0,'elementium_ingot','elementium_ingot',12,4,@GOLDSMITHING,0,4512);

-- Refined Elementium
SET @REFINED_ELEMENTIUM = 9496;
DELETE FROM `item_basic` WHERE itemId = @REFINED_ELEMENTIUM;
INSERT INTO `item_basic` VALUES (@REFINED_ELEMENTIUM,0,'refined_elementium','refined_elementium',12,4,@GOLDSMITHING,0,4738);

SET @ELEMENTIUM_INGOT_SYNTH = 80001;
SET @FIRE_ORE               = 1255;
SET @ICE_ORE                = 1256;
SET @WIND_ORE               = 1257;
SET @EARTH_ORE              = 1258;
SET @LIGHTNING_ORE          = 1259;
SET @WATER_ORE              = 1260;
SET @LIGHT_ORE              = 1261;
SET @DARK_ORE               = 1262;
DELETE FROM `synth_recipes` WHERE ID = @ELEMENTIUM_INGOT_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @ELEMENTIUM_INGOT_SYNTH,0,0,
    0,0,94,0, -- Wood/Smith/Gold/Cloth
    0,0,0,0,  -- Leather/Bone/Alchemy/Cooking
    @FIRE_CRYSTAL,@INFERNO_CRYSTAL,@FIRE_ORE,@ICE_ORE,@WIND_ORE,@EARTH_ORE,@LIGHTNING_ORE,@WATER_ORE,@LIGHT_ORE,@DARK_ORE, -- Materials
    @ELEMENTIUM_INGOT,@REFINED_ELEMENTIUM,@REFINED_ELEMENTIUM,@REFINED_ELEMENTIUM,1,1,2,2,'Elementium Ingot'               -- Results
);

SET @REFINED_ELEMENTIUM_SYNTH = 80002;
DELETE FROM `synth_recipes` WHERE ID = @REFINED_ELEMENTIUM_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @REFINED_ELEMENTIUM_SYNTH,0,0,
    0,0,95,0, -- Wood/Smith/Gold/Cloth
    0,0,0,0,  -- Leather/Bone/Alchemy/Cooking
    @FIRE_CRYSTAL,@INFERNO_CRYSTAL,@ELEMENTIUM_INGOT,@ELEMENTIUM_INGOT,@ELEMENTIUM_INGOT,@ELEMENTIUM_INGOT,0,0,0,0, -- Materials
    @REFINED_ELEMENTIUM,@REFINED_ELEMENTIUM,@REFINED_ELEMENTIUM,@REFINED_ELEMENTIUM,1,2,3,4,'Refined Elementium'    -- Results
);

-- Fine Ochre
SET @FINE_OCHRE = 9515;
DELETE FROM `item_basic` WHERE itemId = @FINE_OCHRE;
INSERT INTO `item_basic` VALUES (@FINE_OCHRE,0,'fine_ochre','fine_ochre',12,4,@ALCHEMY,0,6480);

-- Dragon Powder
SET @DRAGON_POWDER = 9509;
DELETE FROM `item_basic` WHERE itemId = @DRAGON_POWDER;
INSERT INTO `item_basic` VALUES (@DRAGON_POWDER,0,'dragon_powder','dragon_powder',12,4,@BONECRAFT,0,2315);

SET @DRAGON_POWDER_SYNTH = 80003;
SET @DRAGON_BONE         = 1771;
DELETE FROM `synth_recipes` WHERE ID = @DRAGON_POWDER_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @DRAGON_POWDER_SYNTH,0,0,
    0,0,0,0,  -- Wood/Smith/Gold/Cloth
    0,94,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,@DRAGON_BONE,@DRAGON_BONE,@DRAGON_BONE,@DRAGON_BONE,0,0,0,0, -- Materials
    @DRAGON_POWDER,@DRAGON_POWDER,@DRAGON_POWDER,@DRAGON_POWDER,1,2,3,4,'Dragon Powder'         -- Results
);

-- Ochre Dye
SET @OCHRE_DYE = 9516;
DELETE FROM `item_basic` WHERE itemId = @OCHRE_DYE;
INSERT INTO `item_basic` VALUES (@OCHRE_DYE,0,'ochre_dye','ochre_dye',12,4,@ALCHEMY,0,8130);

SET @OCHRE_DYE_SYNTH = 80004;
DELETE FROM `synth_recipes` WHERE ID = @OCHRE_DYE_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @OCHRE_DYE_SYNTH,0,0,
    0,0,0,0,   -- Wood/Smith/Gold/Cloth
    0,0,102,0, -- Leather/Bone/Alchemy/Cooking
    @WATER_CRYSTAL,@TORRENT_CRYSTAL,@DRAGON_POWDER,@DRAGON_POWDER,@FINE_OCHRE,0,0,0,0,0, -- Materials
    @OCHRE_DYE,@OCHRE_DYE,@OCHRE_DYE,@OCHRE_DYE,1,1,2,2,'Ochre Dye'                      -- Results
);

-- Elementium Thread
SET @ELEMENTIUM_THREAD = 9499;
DELETE FROM `item_basic` WHERE itemId = @ELEMENTIUM_THREAD;
INSERT INTO `item_basic` VALUES (@ELEMENTIUM_THREAD,0,'elementium_thread','elementium_thread',12,4,@CLOTHCRAFT,0,8027);

SET @ELEMENTIUM_THREAD_SYNTH = 80005;
DELETE FROM `synth_recipes` WHERE ID = @ELEMENTIUM_THREAD_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @ELEMENTIUM_THREAD_SYNTH,0,0,
    0,0,0,94, -- Wood/Smith/Gold/Cloth
    0,0,0,0,  -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,@FABLE_THREAD,@REFINED_ELEMENTIUM,0,0,0,0,0,0,          -- Materials
    @ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,1,2,3,4,'Elementium Thread' -- Results
);

-- Embersteel Rivet
SET @EMBERSTEEL_RIVET = 9489;
DELETE FROM `item_basic` WHERE itemId = @EMBERSTEEL_RIVET;
INSERT INTO `item_basic` VALUES (@EMBERSTEEL_RIVET,0,'embersteel_rivet','embersteel_rivet',12,4,@SMITHING,0,2165);

SET @EMBERSTEEL_RIVET_SYNTH = 80006;
DELETE FROM `synth_recipes` WHERE ID = @EMBERSTEEL_RIVET_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @EMBERSTEEL_RIVET_SYNTH,0,0,
    0,94,0,0, -- Wood/Smith/Gold/Cloth
    0,0,0,0,  -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,@EMBERSTEEL_INGOT,0,0,0,0,0,0,0,                                    -- Materials
    @EMBERSTEEL_RIVET,@EMBERSTEEL_RIVET,@EMBERSTEEL_RIVET,@EMBERSTEEL_RIVET,1,2,3,4,'Embersteel Rivet' -- Results
);

-- Aeiron Boots
SET @AEIRON_BOOTS_SYNTH = 35011;
SET @SERICA_CLOTH       = 3545;
DELETE FROM `synth_recipes` WHERE ID = @AEIRON_BOOTS_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @AEIRON_BOOTS_SYNTH,0,0,
    0,0,0,106, -- Wood/Smith/Gold/Cloth
    0,0,0,0,   -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,@SERICA_CLOTH,@ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,@STRIDER_BOOTS,0,0,0, -- Materials
    @AREION_BOOTS,@AREION_BOOTS_P1,@AREION_BOOTS_P1,@AREION_BOOTS_P1,1,1,1,1,'Aeiron Boots'                                    -- Results
);

SET @AEIRON_BOOTS_SYNTH_2 = 80007;
DELETE FROM `synth_recipes` WHERE ID = @AEIRON_BOOTS_SYNTH_2;
INSERT INTO `synth_recipes` VALUES (
    @AEIRON_BOOTS_SYNTH_2,0,0,
    0,0,0,106, -- Wood/Smith/Gold/Cloth
    0,0,0,0,   -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,@SERICA_CLOTH,@ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,@TROTTER_BOOTS,0,0,0, -- Materials
    @AREION_BOOTS,@AREION_BOOTS_P1,@AREION_BOOTS_P1,@AREION_BOOTS_P1,1,1,1,1,'Aeiron Boots'                                    -- Results
);

-- Harbinger's Gaiters
SET @HARBINGERS_GAITERS_SYNTH = 80008;
DELETE FROM `synth_recipes` WHERE ID = @HARBINGERS_GAITERS_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @HARBINGERS_GAITERS_SYNTH,0,0,
    0,0,0,108, -- Wood/Smith/Gold/Cloth
    0,0,0,0,   -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,@EMBERSTEEL_RIVET,@EMBERSTEEL_RIVET,@ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,@OCHRE_DYE,@HERALDS_GAITERS,0,0, -- Materials
    @HARBINGERS_GAITERS,@HARBINGERS_GAITERS_P1,@HARBINGERS_GAITERS_P1,@HARBINGERS_GAITERS_P1,1,1,1,1,'Harbingers Gaiters'                    -- Results
);

SET @HARBINGERS_GAITERS_SYNTH_2 = 80009;
DELETE FROM `synth_recipes` WHERE ID = @HARBINGERS_GAITERS_SYNTH_2;
INSERT INTO `synth_recipes` VALUES (
    @HARBINGERS_GAITERS_SYNTH_2,0,0,
    0,0,0,108, -- Wood/Smith/Gold/Cloth
    0,0,0,0,   -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,@EMBERSTEEL_RIVET,@EMBERSTEEL_RIVET,@ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,@OCHRE_DYE,@CRIERS_GAITERS,0,0, -- Materials
    @HARBINGERS_GAITERS,@HARBINGERS_GAITERS_P1,@HARBINGERS_GAITERS_P1,@HARBINGERS_GAITERS_P1,1,1,1,1,'Harbingers Gaiters'                   -- Results
);

-- Dragon Essence
SET @DRAGON_ESSENCE = 9517;
DELETE FROM `item_basic` WHERE itemId = @DRAGON_ESSENCE;
INSERT INTO `item_basic` VALUES (@DRAGON_ESSENCE,0,'dragon_essence','dragon_essence',12,4,@ALCHEMY,0,5605);

SET @DRAGON_ESSENCE_SYNTH = 80010;
SET @DRAGON_ESSENCE       = 9517;
DELETE FROM `synth_recipes` WHERE ID = @DRAGON_ESSENCE_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @DRAGON_ESSENCE_SYNTH,0,0,
    0,0,0,0,  -- Wood/Smith/Gold/Cloth
    0,0,92,0, -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@REFINED_ELEMENTIUM,@DRAGON_POWDER,@DRAGON_POWDER,0,0,0,0,0, -- Materials
    @DRAGON_ESSENCE,@DRAGON_ESSENCE,@DRAGON_ESSENCE,@DRAGON_ESSENCE,1,2,2,2,'Dragon Essence'    -- Results
);

-- Animated Lumber
SET @ANIMATED_LUMBER = 9485;
DELETE FROM `item_basic` WHERE itemId = @ANIMATED_LUMBER;
INSERT INTO `item_basic` VALUES (@ANIMATED_LUMBER,0,'animated_lumber','animated_lumber',12,4,@WOODWORKING,0,3865);

SET @ANIMATED_LUMBER_SYNTH = 80011;
SET @BLOODWOOD_LUMBER      = 729;
DELETE FROM `synth_recipes` WHERE ID = @ANIMATED_LUMBER_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @ANIMATED_LUMBER_SYNTH,0,0,
    94,0,0,0, -- Wood/Smith/Gold/Cloth
    0,0,0,0,  -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,@BLOODWOOD_LUMBER,@REFINED_ELEMENTIUM,0,0,0,0,0,0,             -- Materials
    @ANIMATED_LUMBER,@ANIMATED_LUMBER,@ANIMATED_LUMBER,@ANIMATED_LUMBER,1,2,3,4,'Animated Lumber' -- Results
);

-----------------------------------
-- New crafted items
-----------------------------------
-- Visionary Obi
SET @VISIONARY_OBI = 11765;
DELETE FROM `item_basic` WHERE itemid = @VISIONARY_OBI;
INSERT INTO `item_basic` VALUES (@VISIONARY_OBI,0,'visionary_obi','visionary_obi',1,@ITEM_EQDEF,@AH_WAIST,1,0);

DELETE FROM `item_equipment` WHERE itemId = @VISIONARY_OBI;
INSERT INTO `item_equipment` VALUES (@VISIONARY_OBI,'visionary_obi',73,0,@WHM+@BLM+@BLU+@SCH+@GEO,0,0,0,@SLOT_WAIST,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @VISIONARY_OBI;
INSERT INTO `item_mods` VALUES
    (@VISIONARY_OBI, @MOD_DEF, 4),
    (@VISIONARY_OBI, @MOD_STR, 6),
    (@VISIONARY_OBI, @MOD_MND, 6),
    (@VISIONARY_OBI, @MOD_ACC, 5);

-- Visionary Obi +1
SET @VISIONARY_OBI_P1 = 11766;
DELETE FROM `item_basic` WHERE itemid = @VISIONARY_OBI_P1;
INSERT INTO `item_basic` VALUES (@VISIONARY_OBI_P1,0,'visionary_obi','visionary_obi',1,@ITEM_EQDEF,@AH_WAIST,1,0);

DELETE FROM `item_equipment` WHERE itemId = @VISIONARY_OBI_P1;
INSERT INTO `item_equipment` VALUES (@VISIONARY_OBI_P1,'visionary_obi',73,0,@WHM+@BLM+@BLU+@SCH+@GEO,0,0,0,@SLOT_WAIST,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @VISIONARY_OBI_P1;
INSERT INTO `item_mods` VALUES
    (@VISIONARY_OBI_P1, @MOD_DEF,        5),
    (@VISIONARY_OBI_P1, @MOD_STR,        7),
    (@VISIONARY_OBI_P1, @MOD_MND,        7),
    (@VISIONARY_OBI_P1, @MOD_ACC,        7),
    (@VISIONARY_OBI_P1, @MOD_DOUBLE_ATK, 1);

SET @VISIONARY_OBI_SYNTH = 80012;
SET @ARACHNE_OBI         = 13275;
SET @SPARKSTRAND         =  2199;
DELETE FROM `synth_recipes` WHERE ID = @VISIONARY_OBI_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @VISIONARY_OBI_SYNTH,0,0,
    0,0,0,105, -- Wood/Smith/Gold/Cloth
    0,0,0,0,   -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,
        @SPARKSTRAND,@SPARKSTRAND,@SPARKSTRAND,@SPARKSTRAND,
        @ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,@ELEMENTIUM_THREAD,@ARACHNE_OBI,                   -- Materials
    @VISIONARY_OBI,@VISIONARY_OBI_P1,@VISIONARY_OBI_P1,@VISIONARY_OBI_P1,1,1,1,1,'Visionary Obi' -- Results
);

-- Companion Belt
SET @COMPANION_BELT = 11763;
DELETE FROM `item_basic` WHERE itemid = @COMPANION_BELT;
INSERT INTO `item_basic` VALUES (@COMPANION_BELT,0,'companion_belt','companion_belt',1,@ITEM_EQDEF,@AH_WAIST,1,0);

DELETE FROM `item_equipment` WHERE itemId = @COMPANION_BELT;
INSERT INTO `item_equipment` VALUES (@COMPANION_BELT,'companion_belt',73,0,@BST+@DRG+@PUP,0,0,0,@SLOT_WAIST,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @COMPANION_BELT;
INSERT INTO `item_mods` VALUES
    (@COMPANION_BELT, @MOD_DEF,        5),
    (@COMPANION_BELT, @MOD_ACC,        6),
    (@COMPANION_BELT, @MOD_HASTE,    400);

DELETE FROM `item_mods_pet` WHERE itemId = @COMPANION_BELT;
INSERT INTO `item_mods_pet` VALUES
    (@COMPANION_BELT, @MOD_ACC,  5, @PET_ALL),
    (@COMPANION_BELT, @MOD_RACC, 5, @PET_ALL);

-- Companion Belt +1
SET @COMPANION_BELT_P1 = 11764;
DELETE FROM `item_basic` WHERE itemid = @COMPANION_BELT_P1;
INSERT INTO `item_basic` VALUES (@COMPANION_BELT_P1,0,'companion_belt_+1','companion_belt_+1',1,@ITEM_EQDEF,@AH_WAIST,1,0);

DELETE FROM `item_equipment` WHERE itemId = @COMPANION_BELT_P1;
INSERT INTO `item_equipment` VALUES (@COMPANION_BELT_P1,'companion_belt_+1',73,0,@BST+@DRG+@PUP,0,0,0,@SLOT_WAIST,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @COMPANION_BELT_P1;
INSERT INTO `item_mods` VALUES
    (@COMPANION_BELT_P1, @MOD_DEF,        6),
    (@COMPANION_BELT_P1, @MOD_ACC,        8),
    (@COMPANION_BELT_P1, @MOD_HASTE,    600);

DELETE FROM `item_mods_pet` WHERE itemId = @COMPANION_BELT_P1;
INSERT INTO `item_mods_pet` VALUES
    (@COMPANION_BELT_P1, @MOD_ACC,        8, @PET_ALL),
    (@COMPANION_BELT_P1, @MOD_RACC,       8, @PET_ALL),
    (@COMPANION_BELT_P1, @MOD_DOUBLE_ATK, 1, @PET_ALL);

SET @COMPANION_BELT_SYNTH = 80013;
SET @LIFE_BELT            = 13231;
SET @PHYRGIAN_GOLD_INGOT  =   743;
DELETE FROM `synth_recipes` WHERE ID = @COMPANION_BELT_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @COMPANION_BELT_SYNTH,0,0,
    0,0,105,0, -- Wood/Smith/Gold/Cloth
    0,0,0,0,   -- Leather/Bone/Alchemy/Cooking
    @FIRE_CRYSTAL,@INFERNO_CRYSTAL,
        @PHYRGIAN_GOLD_INGOT,@PHYRGIAN_GOLD_INGOT,@PHYRGIAN_GOLD_INGOT,@PHYRGIAN_GOLD_INGOT,
        @EMBERSTEEL_RIVET,@EMBERSTEEL_RIVET,@EMBERSTEEL_RIVET,@LIFE_BELT,                             -- Materials
    @COMPANION_BELT,@COMPANION_BELT_P1,@COMPANION_BELT_P1,@COMPANION_BELT_P1,1,1,1,1,'Companion Belt' -- Results
);

-- Elementium Torque
SET @ELEMENTIUM_TORQUE = 10916;
DELETE FROM `item_basic` WHERE itemid = @ELEMENTIUM_TORQUE;
INSERT INTO `item_basic` VALUES (@ELEMENTIUM_TORQUE,0,'elementium_torque','elementium_torque',1,@ITEM_EQDEF,@AH_NECK,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ELEMENTIUM_TORQUE;
INSERT INTO `item_equipment` VALUES (@ELEMENTIUM_TORQUE,'elementium_torque',40,0,@ALL_JOBS,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ELEMENTIUM_TORQUE;
INSERT INTO `item_mods` VALUES
    (@ELEMENTIUM_TORQUE, @MOD_MP,             15),
    (@ELEMENTIUM_TORQUE, @MOD_DIVINE_SKILL,    3),
    (@ELEMENTIUM_TORQUE, @MOD_HEALING_SKILL,   3),
    (@ELEMENTIUM_TORQUE, @MOD_ENHANCE_SKILL,   3),
    (@ELEMENTIUM_TORQUE, @MOD_ENFEEBLE_SKILL,  3),
    (@ELEMENTIUM_TORQUE, @MOD_ELEMENTAL_SKILL, 3),
    (@ELEMENTIUM_TORQUE, @MOD_DARK_SKILL,      3),
    (@ELEMENTIUM_TORQUE, @MOD_SINGING_SKILL,   3),
    (@ELEMENTIUM_TORQUE, @MOD_WIND_SKILL,      3),
    (@ELEMENTIUM_TORQUE, @MOD_STRING_SKILL,    3),
    (@ELEMENTIUM_TORQUE, @MOD_SUMMONING_SKILL, 3),
    (@ELEMENTIUM_TORQUE, @MOD_NINJUTSU_SKILL,  3),
    (@ELEMENTIUM_TORQUE, @MOD_BLUE_SKILL,      3),
    (@ELEMENTIUM_TORQUE, @MOD_HANDBELL_SKILL,  3),
    (@ELEMENTIUM_TORQUE, @MOD_GEOMANCY_SKILL,  3);

-- Elementium Torque +1
SET @ELEMENTIUM_TORQUE_P1 = 10917;
DELETE FROM `item_basic` WHERE itemid = @ELEMENTIUM_TORQUE_P1;
INSERT INTO `item_basic` VALUES (@ELEMENTIUM_TORQUE_P1,0,'elementium_torque_+1','elementium_torque_+1',1,@ITEM_EQDEF,@AH_NECK,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ELEMENTIUM_TORQUE_P1;
INSERT INTO `item_equipment` VALUES (@ELEMENTIUM_TORQUE_P1,'elementium_torque_+1',40,0,@ALL_JOBS,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ELEMENTIUM_TORQUE_P1;
INSERT INTO `item_mods` VALUES
    (@ELEMENTIUM_TORQUE_P1, @MOD_MP,             20),
    (@ELEMENTIUM_TORQUE_P1, @MOD_DIVINE_SKILL,    4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_HEALING_SKILL,   4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_ENHANCE_SKILL,   4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_ENFEEBLE_SKILL,  4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_ELEMENTAL_SKILL, 4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_DARK_SKILL,      4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_SINGING_SKILL,   4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_WIND_SKILL,      4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_STRING_SKILL,    4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_SUMMONING_SKILL, 4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_NINJUTSU_SKILL,  4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_BLUE_SKILL,      4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_HANDBELL_SKILL,  4),
    (@ELEMENTIUM_TORQUE_P1, @MOD_GEOMANCY_SKILL,  4);

SET @ELEMENTIUM_TORQUE_SYNTH = 80014;
SET @TORQUE_P1               = 13126;
DELETE FROM `synth_recipes` WHERE ID = @ELEMENTIUM_TORQUE_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @ELEMENTIUM_TORQUE_SYNTH,0,0,
    0,0,0,0,  -- Wood/Smith/Gold/Cloth
    0,0,85,0, -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@REFINED_ELEMENTIUM,@TORQUE_P1,0,0,0,0,0,0,                                       -- Materials
    @ELEMENTIUM_TORQUE,@ELEMENTIUM_TORQUE_P1,@ELEMENTIUM_TORQUE_P1,@ELEMENTIUM_TORQUE_P1,1,1,1,1,'Elementium Torque' -- Results
);

-- Incanter's Torque
SET @INCANTERS_TORQUE = 26016;
DELETE FROM `item_basic` WHERE itemid = @INCANTERS_TORQUE;
INSERT INTO `item_basic` VALUES (@INCANTERS_TORQUE,0,'incanters_torque','incanters_torque',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @INCANTERS_TORQUE;
INSERT INTO `item_equipment` VALUES (@INCANTERS_TORQUE,'incanters_torque',75,0,@ALL_JOBS,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @INCANTERS_TORQUE;
INSERT INTO `item_mods` VALUES
    (@INCANTERS_TORQUE, @MOD_DIVINE_SKILL,    8),
    (@INCANTERS_TORQUE, @MOD_HEALING_SKILL,   8),
    (@INCANTERS_TORQUE, @MOD_ENHANCE_SKILL,   8),
    (@INCANTERS_TORQUE, @MOD_ENFEEBLE_SKILL,  8),
    (@INCANTERS_TORQUE, @MOD_ELEMENTAL_SKILL, 8),
    (@INCANTERS_TORQUE, @MOD_DARK_SKILL,      8),
    (@INCANTERS_TORQUE, @MOD_SINGING_SKILL,   8),
    (@INCANTERS_TORQUE, @MOD_WIND_SKILL,      8),
    (@INCANTERS_TORQUE, @MOD_STRING_SKILL,    8),
    (@INCANTERS_TORQUE, @MOD_SUMMONING_SKILL, 8),
    (@INCANTERS_TORQUE, @MOD_NINJUTSU_SKILL,  8),
    (@INCANTERS_TORQUE, @MOD_BLUE_SKILL,      8),
    (@INCANTERS_TORQUE, @MOD_HANDBELL_SKILL,  8),
    (@INCANTERS_TORQUE, @MOD_GEOMANCY_SKILL,  8),
    (@INCANTERS_TORQUE, 530,                  1); -- NO_SPELL_MP_DEPLETION: 1

SET @COMMENDATION_BAG = 6547;
DELETE FROM `item_basic` WHERE itemid = @COMMENDATION_BAG;
INSERT INTO `item_basic` VALUES (@COMMENDATION_BAG,0,'commendation_bag','commendation_bag',99,@ITEM_EXUSE,0,1,0);
DELETE FROM `item_usable` WHERE itemid = @COMMENDATION_BAG;
INSERT INTO `item_usable` VALUES (@COMMENDATION_BAG,'commendation_bag',1,1,55,0,0,0,0,0);

SET @DOMAIN_COFFER = 6552;
DELETE FROM `item_basic` WHERE itemid = @DOMAIN_COFFER;
INSERT INTO `item_basic` VALUES (@DOMAIN_COFFER,0,'domain_coffer','domain_coffer',99,@ITEM_EXUSE,0,1,0);
DELETE FROM `item_usable` WHERE itemid = @DOMAIN_COFFER;
INSERT INTO `item_usable` VALUES (@DOMAIN_COFFER,'domain_coffer',1,1,55,0,0,0,0,0);

SET @DOMAIN_COFFER_P1 = 6553;
DELETE FROM `item_basic` WHERE itemid = @DOMAIN_COFFER_P1;
INSERT INTO `item_basic` VALUES (@DOMAIN_COFFER_P1,0,'domain_coffer_+1','domain_coffer_+1',99,@ITEM_EXUSE,0,1,0);
DELETE FROM `item_usable` WHERE itemid = @DOMAIN_COFFER_P1;
INSERT INTO `item_usable` VALUES (@DOMAIN_COFFER_P1,'domain_coffer_+1',1,1,55,0,0,0,0,0);

-- Goblin Stone
SET @GOBLIN_STONE = 9497;
DELETE FROM `item_basic` WHERE itemId = @GOBLIN_STONE;
INSERT INTO `item_basic` VALUES (@GOBLIN_STONE,0,'goblin_stone','goblin_stone',12,4,@ALCHEMY,0,3215);

-- Goblin Powder
SET @GOBLIN_POWDER = 9518;
DELETE FROM `item_basic` WHERE itemId = @GOBLIN_POWDER;
INSERT INTO `item_basic` VALUES (@GOBLIN_POWDER,0,'goblin_powder','goblin_powder',12,4,@ALCHEMY,0,1770);

SET @GOBLIN_POWDER_SYNTH = 80015;
DELETE FROM `synth_recipes` WHERE ID = @GOBLIN_POWDER_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @GOBLIN_POWDER_SYNTH,0,0,
    0,0,0,0,  -- Wood/Smith/Gold/Cloth
    0,0,94,0, -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@GOBLIN_STONE,0,0,0,0,0,0,0,                         -- Materials
    @GOBLIN_POWDER,@GOBLIN_POWDER,@GOBLIN_POWDER,@GOBLIN_POWDER,1,2,2,2,'Goblin Powder' -- Results
);

-- Amphisbaena Hide
SET @AMPHISBAENA_HIDE = 9506;
DELETE FROM `item_basic` WHERE itemId = @AMPHISBAENA_HIDE;
INSERT INTO `item_basic` VALUES (@AMPHISBAENA_HIDE,0,'amphisbaena_hide','amphisbaena_hide',12,4,@LEATHERCRAFT,0,11350);

-- Battosai Fang
SET @BATTOSAI_FANG = 9510;
DELETE FROM `item_basic` WHERE itemId = @BATTOSAI_FANG;
INSERT INTO `item_basic` VALUES (@BATTOSAI_FANG,0,'battosai_fang','battosai_fang',12,4,@BONECRAFT,0,9830);

-- Tortuga Shell
SET @TORTUGA_SHELL = 9511;
DELETE FROM `item_basic` WHERE itemId = @TORTUGA_SHELL;
INSERT INTO `item_basic` VALUES (@TORTUGA_SHELL,0,'tortuga_shell','tortuga_shell',12,4,@BONECRAFT,0,10215);

SET @CARNELIAN        = 767; -- Fire
SET @FULMENITE        = 777; -- Lightning
SET @HELIODOR         = 778; -- Earth
SET @AVENTURINE       = 779; -- Wind
SET @CLARITE          = 780; -- Ice
SET @LARIMAR          = 781; -- Water
SET @SELENITE         = 782; -- Light
SET @TENEBRITE        = 783; -- Dark

SET @TRIUMPH_EARRING  = 13408;
SET @ADROIT_EARRING   = 13410;
SET @ROBUST_EARRING   = 13412;
SET @NIMBLE_EARRING   = 13407;
SET @OMN_EARRING      = 13409;
SET @CMN_EARRING      = 13411;
SET @HEAVENS_EARRING  = 13414;
SET @HADES_EARRING    = 13413;

SET @FLAME_EARRING    = 11678;
SET @THUNDER_EARRING  = 11679;
SET @SOIL_EARRING     = 11680;
SET @BREEZE_EARRING   = 11681;
SET @SNOW_EARRING     = 11682;
SET @AQUA_EARRING     = 11683;
SET @LIGHT_EARRING    = 11684;
SET @DARKNESS_EARRING = 11685;

SET @VULCANS_EARRING  = 11686;
SET @JUPITERS_EARRING = 11687;
SET @TERRAS_EARRING   = 11688;
SET @AUSTERS_EARRING  = 11689;
SET @AQUILOS_EARRING  = 11690;
SET @NEPTUNES_EARRING = 11691;
SET @APOLLOS_EARRING  = 11692;
SET @PLUTOS_EARRING   = 11693;

UPDATE item_equipment SET level = 75 WHERE itemId IN (
    @FLAME_EARRING,   @THUNDER_EARRING , @SOIL_EARRING,    @BREEZE_EARRING,
    @SNOW_EARRING,    @AQUA_EARRING,     @LIGHT_EARRING,   @DARKNESS_EARRING,
    @VULCANS_EARRING, @JUPITERS_EARRING, @TERRAS_EARRING,  @AUSTERS_EARRING,
    @AQUILOS_EARRING, @NEPTUNES_EARRING, @APOLLOS_EARRING, @PLUTOS_EARRING
);

DELETE FROM `item_mods` WHERE itemId = @FLAME_EARRING;
INSERT INTO `item_mods` VALUES
    (@FLAME_EARRING, @MOD_STR,       2),
    (@FLAME_EARRING, @MOD_FIRE_RES, 15),
    (@FLAME_EARRING, @MOD_ICE_RES,  15),
    (@FLAME_EARRING, @MOD_ATT,       2);

DELETE FROM `item_mods` WHERE itemId = @VULCANS_EARRING;
INSERT INTO `item_mods` VALUES
    (@VULCANS_EARRING, @MOD_STR,       3),
    (@VULCANS_EARRING, @MOD_FIRE_RES, 16),
    (@VULCANS_EARRING, @MOD_ICE_RES,  16),
    (@VULCANS_EARRING, @MOD_ATT,       3);

DELETE FROM `item_mods` WHERE itemId = @THUNDER_EARRING;
INSERT INTO `item_mods` VALUES
    (@THUNDER_EARRING, @MOD_DEX,          2),
    (@THUNDER_EARRING, @MOD_THUNDER_RES, 15),
    (@THUNDER_EARRING, @MOD_WATER_RES,   15),
    (@THUNDER_EARRING, @MOD_ACC,          2);

DELETE FROM `item_mods` WHERE itemId = @JUPITERS_EARRING;
INSERT INTO `item_mods` VALUES
    (@JUPITERS_EARRING, @MOD_DEX,          3),
    (@JUPITERS_EARRING, @MOD_THUNDER_RES, 16),
    (@JUPITERS_EARRING, @MOD_WATER_RES,   16),
    (@JUPITERS_EARRING, @MOD_ACC,          3);

DELETE FROM `item_mods` WHERE itemId = @SOIL_EARRING;
INSERT INTO `item_mods` VALUES
    (@SOIL_EARRING, @MOD_VIT,               2),
    (@SOIL_EARRING, @MOD_EARTH_RES,        15),
    (@SOIL_EARRING, @MOD_THUNDER_RES,      15),
    (@SOIL_EARRING, @MOD_PHYS_DMG_TAKEN, -200);

DELETE FROM `item_mods` WHERE itemId = @TERRAS_EARRING;
INSERT INTO `item_mods` VALUES
    (@TERRAS_EARRING, @MOD_VIT,               3),
    (@TERRAS_EARRING, @MOD_EARTH_RES,        16),
    (@TERRAS_EARRING, @MOD_THUNDER_RES,      16),
    (@TERRAS_EARRING, @MOD_PHYS_DMG_TAKEN, -300);

DELETE FROM `item_mods` WHERE itemId = @BREEZE_EARRING;
INSERT INTO `item_mods` VALUES
    (@BREEZE_EARRING, @MOD_AGI,        2),
    (@BREEZE_EARRING, @MOD_WIND_RES,  15),
    (@BREEZE_EARRING, @MOD_EARTH_RES, 15),
    (@BREEZE_EARRING, @MOD_RACC,       2);

DELETE FROM `item_mods` WHERE itemId = @AUSTERS_EARRING;
INSERT INTO `item_mods` VALUES
    (@AUSTERS_EARRING, @MOD_AGI,        3),
    (@AUSTERS_EARRING, @MOD_WIND_RES,  16),
    (@AUSTERS_EARRING, @MOD_EARTH_RES, 16),
    (@AUSTERS_EARRING, @MOD_RACC,       3);

DELETE FROM `item_mods` WHERE itemId = @SNOW_EARRING;
INSERT INTO `item_mods` VALUES
    (@SNOW_EARRING, @MOD_INT,              2),
    (@SNOW_EARRING, @MOD_ICE_RES,         15),
    (@SNOW_EARRING, @MOD_WIND_RES,        15),
    (@SNOW_EARRING, @MOD_MAG_BURST_BONUS,  2);

DELETE FROM `item_mods` WHERE itemId = @AQUILOS_EARRING;
INSERT INTO `item_mods` VALUES
    (@AQUILOS_EARRING, @MOD_INT,              3),
    (@AQUILOS_EARRING, @MOD_ICE_RES,         16),
    (@AQUILOS_EARRING, @MOD_WIND_RES,        16),
    (@AQUILOS_EARRING, @MOD_MAG_BURST_BONUS,  3);

DELETE FROM `item_mods` WHERE itemId = @AQUA_EARRING;
INSERT INTO `item_mods` VALUES
    (@AQUA_EARRING, @MOD_MND,        2),
    (@AQUA_EARRING, @MOD_FIRE_RES,  15),
    (@AQUA_EARRING, @MOD_WATER_RES, 15),
    (@AQUA_EARRING, @MOD_MACC,       2);

DELETE FROM `item_mods` WHERE itemId = @NEPTUNES_EARRING;
INSERT INTO `item_mods` VALUES
    (@NEPTUNES_EARRING, @MOD_MND,        3),
    (@NEPTUNES_EARRING, @MOD_FIRE_RES,  16),
    (@NEPTUNES_EARRING, @MOD_WATER_RES, 16),
    (@NEPTUNES_EARRING, @MOD_MACC,       3);

DELETE FROM `item_mods` WHERE itemId = @LIGHT_EARRING;
INSERT INTO `item_mods` VALUES
    (@LIGHT_EARRING, @MOD_HP,           15),
    (@LIGHT_EARRING, @MOD_LIGHT_RES,    15),
    (@LIGHT_EARRING, @MOD_ENMITY,       -2),
    (@LIGHT_EARRING, @MOD_CURE_POTENCY,  2);

DELETE FROM `item_mods` WHERE itemId = @APOLLOS_EARRING;
INSERT INTO `item_mods` VALUES
    (@APOLLOS_EARRING, @MOD_HP,           20),
    (@APOLLOS_EARRING, @MOD_LIGHT_RES,    16),
    (@APOLLOS_EARRING, @MOD_ENMITY,       -3),
    (@APOLLOS_EARRING, @MOD_CURE_POTENCY,  3);

DELETE FROM `item_mods` WHERE itemId = @DARKNESS_EARRING;
INSERT INTO `item_mods` VALUES
    (@DARKNESS_EARRING, @MOD_MP,       25),
    (@DARKNESS_EARRING, @MOD_DARK_RES, 15),
    (@DARKNESS_EARRING, @MOD_ENMITY,    2),
    (@DARKNESS_EARRING, @MOD_HMP,       2);

DELETE FROM `item_mods` WHERE itemId = @PLUTOS_EARRING;
INSERT INTO `item_mods` VALUES
    (@PLUTOS_EARRING, @MOD_MP,       20),
    (@PLUTOS_EARRING, @MOD_DARK_RES, 16),
    (@PLUTOS_EARRING, @MOD_ENMITY,    3),
    (@PLUTOS_EARRING, @MOD_HMP,       3);

SET @FLAME_EARRING_SYNTH = 80016;
DELETE FROM `synth_recipes` WHERE ID = @FLAME_EARRING_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @FLAME_EARRING_SYNTH,0,0,
    0,0,108,0, -- Wood/Smith/Gold/Cloth
    0,0,60,0,  -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@CARNELIAN,@GOBLIN_POWDER,@GOBLIN_POWDER,@TRIUMPH_EARRING,0,0,0,0, -- Materials
    @FLAME_EARRING,@VULCANS_EARRING,@VULCANS_EARRING,@VULCANS_EARRING,1,1,1,1,'Flame Earring'         -- Results
);

SET @THUNDER_EARRING_SYNTH = 80017;
DELETE FROM `synth_recipes` WHERE ID = @THUNDER_EARRING_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @THUNDER_EARRING_SYNTH,0,0,
    0,0,108,0, -- Wood/Smith/Gold/Cloth
    0,0,60,0,  -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@FULMENITE,@GOBLIN_POWDER,@GOBLIN_POWDER,@ADROIT_EARRING,0,0,0,0, -- Materials
    @THUNDER_EARRING,@JUPITERS_EARRING,@JUPITERS_EARRING,@JUPITERS_EARRING,1,1,1,1,'Thunder Earring' -- Results
);

SET @SOIL_EARRING_SYNTH = 80018;
DELETE FROM `synth_recipes` WHERE ID = @SOIL_EARRING_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @SOIL_EARRING_SYNTH,0,0,
    0,0,108,0, -- Wood/Smith/Gold/Cloth
    0,0,60,0,  -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@HELIODOR,@GOBLIN_POWDER,@GOBLIN_POWDER,@ROBUST_EARRING,0,0,0,0, -- Materials
    @SOIL_EARRING,@TERRAS_EARRING,@TERRAS_EARRING,@TERRAS_EARRING,1,1,1,1,'Soil Earring'            -- Results
);

SET @BREEZE_EARRING_SYNTH = 80019;
DELETE FROM `synth_recipes` WHERE ID = @BREEZE_EARRING_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @BREEZE_EARRING_SYNTH,0,0,
    0,0,108,0, -- Wood/Smith/Gold/Cloth
    0,0,60,0,  -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@AVENTURINE,@GOBLIN_POWDER,@GOBLIN_POWDER,@NIMBLE_EARRING,0,0,0,0, -- Materials
    @BREEZE_EARRING,@AUSTERS_EARRING,@AUSTERS_EARRING,@AUSTERS_EARRING,1,1,1,1,'Breeze Earring'       -- Results
);

SET @SNOW_EARRING_SYNTH = 80020;
DELETE FROM `synth_recipes` WHERE ID = @SNOW_EARRING_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @SNOW_EARRING_SYNTH,0,0,
    0,0,108,0, -- Wood/Smith/Gold/Cloth
    0,0,60,0,  -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@CLARITE,@GOBLIN_POWDER,@GOBLIN_POWDER,@OMN_EARRING,0,0,0,0, -- Materials
    @SNOW_EARRING,@AQUILOS_EARRING,@AQUILOS_EARRING,@AQUILOS_EARRING,1,1,1,1,'Snow Earring'     -- Results
);

SET @AQUA_EARRING_SYNTH = 80021;
DELETE FROM `synth_recipes` WHERE ID = @AQUA_EARRING_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @AQUA_EARRING_SYNTH,0,0,
    0,0,108,0, -- Wood/Smith/Gold/Cloth
    0,0,60,0,  -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@LARIMAR,@GOBLIN_POWDER,@GOBLIN_POWDER,@CMN_EARRING,0,0,0,0, -- Materials
    @AQUA_EARRING,@NEPTUNES_EARRING,@NEPTUNES_EARRING,@NEPTUNES_EARRING,1,1,1,1,'Aqua Earring'  -- Results
);

SET @LIGHT_EARRING_SYNTH = 80022;
DELETE FROM `synth_recipes` WHERE ID = @LIGHT_EARRING_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @LIGHT_EARRING_SYNTH,0,0,
    0,0,108,0, -- Wood/Smith/Gold/Cloth
    0,0,60,0,  -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@SELENITE,@GOBLIN_POWDER,@GOBLIN_POWDER,@HEAVENS_EARRING,0,0,0,0, -- Materials
    @LIGHT_EARRING,@APOLLOS_EARRING,@APOLLOS_EARRING,@APOLLOS_EARRING,1,1,1,1,'Light Earring'        -- Results
);

SET @DARKNESS_EARRING_SYNTH = 80023;
DELETE FROM `synth_recipes` WHERE ID = @DARKNESS_EARRING_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @DARKNESS_EARRING_SYNTH,0,0,
    0,0,108,0, -- Wood/Smith/Gold/Cloth
    0,0,60,0,  -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,@TENEBRITE,@GOBLIN_POWDER,@GOBLIN_POWDER,@HADES_EARRING,0,0,0,0, -- Materials
    @DARKNESS_EARRING,@PLUTOS_EARRING,@PLUTOS_EARRING,@PLUTOS_EARRING,1,1,1,1,'Darkness Earring'    -- Results
);

-- Voluspa Mantle
SET @VOLUSPA_MANTLE = 28606;
DELETE FROM `item_basic` WHERE itemid = @VOLUSPA_MANTLE;
INSERT INTO `item_basic` VALUES (@VOLUSPA_MANTLE,0,'voluspa_mantle','voluspa_mantle',1,@ITEM_EQDEF,@AH_BACK,1,0);

DELETE FROM `item_equipment` WHERE itemId = @VOLUSPA_MANTLE;
INSERT INTO `item_equipment` VALUES (@VOLUSPA_MANTLE,'voluspa_mantle',74,0,@BLM+@BLU+@SCH+@GEO,0,0,0,@SLOT_BACK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @VOLUSPA_MANTLE;
INSERT INTO `item_mods` VALUES
    (@VOLUSPA_MANTLE, @MOD_DEF,      8),
    (@VOLUSPA_MANTLE, @MOD_MP,      15),
    (@VOLUSPA_MANTLE, @MOD_ICE_RES, 10),
    (@VOLUSPA_MANTLE, @MOD_MACC,     2),
    (@VOLUSPA_MANTLE, @MOD_MATT,     3);

-- Voluspa Mantle +1
SET @VOLUSPA_MANTLE_P1 = 28607;
DELETE FROM `item_basic` WHERE itemid = @VOLUSPA_MANTLE_P1;
INSERT INTO `item_basic` VALUES (@VOLUSPA_MANTLE_P1,0,'voluspa_mantle_+1','voluspa_mantle_+1',1,@ITEM_EQDEF,@AH_BACK,1,0);

DELETE FROM `item_equipment` WHERE itemId = @VOLUSPA_MANTLE_P1;
INSERT INTO `item_equipment` VALUES (@VOLUSPA_MANTLE_P1,'voluspa_mantle_+1',74,0,@BLM+@BLU+@SCH+@GEO,0,0,0,@SLOT_BACK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @VOLUSPA_MANTLE_P1;
INSERT INTO `item_mods` VALUES
    (@VOLUSPA_MANTLE_P1, @MOD_DEF,                    9),
    (@VOLUSPA_MANTLE_P1, @MOD_MP,                    25),
    (@VOLUSPA_MANTLE_P1, @MOD_ICE_RES,               12),
    (@VOLUSPA_MANTLE_P1, @MOD_MACC,                   3),
    (@VOLUSPA_MANTLE_P1, @MOD_MATT,                   5),
    (@VOLUSPA_MANTLE_P1, @MOD_ITEM_SUBEFFECT,         2), -- Ice Spikes
    (@VOLUSPA_MANTLE_P1, @MOD_ITEM_ADDEFFECT_DMG,    20),
    (@VOLUSPA_MANTLE_P1, @MOD_ITEM_ADDEFFECT_CHANCE, 20);

SET @VOLUSPA_MANTLE_SYNTH = 80024;
SET @AKASO_THREAD         = 4027;
SET @CEHUETZI_PELT        = 8754;
SET @PRISM_CAPE           = 13627;
DELETE FROM `synth_recipes` WHERE Result = @VOLUSPA_MANTLE;
INSERT INTO `synth_recipes` VALUES (
    @VOLUSPA_MANTLE_SYNTH,0,0,
    0,0,0,60,  -- Wood/Smith/Gold/Cloth
    114,0,0,0, -- Leather/Bone/Alchemy/Cooking
    @ICE_CRYSTAL,@GLACIER_CRYSTAL,
        @AKASO_THREAD,@CEHUETZI_PELT,@PRISM_CAPE,0,0,0,0,0,                                           -- Materials
    @VOLUSPA_MANTLE,@VOLUSPA_MANTLE_P1,@VOLUSPA_MANTLE_P1,@VOLUSPA_MANTLE_P1,1,1,1,1,'Voluspa Mantle' -- Results
);

-- Norn's Grip (Icon: Mythril Grip)
SET @NORNS_GRIP = 22210;
DELETE FROM `item_basic` WHERE itemid = @NORNS_GRIP;
INSERT INTO `item_basic` VALUES (@NORNS_GRIP,0,'norns_grip','norns_grip',1,@ITEM_EQDEF,@AH_GRIPS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @NORNS_GRIP;
INSERT INTO `item_equipment` VALUES (@NORNS_GRIP,'norns_grip',75,0,@BLM+@SMN+@SCH+@GEO,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @NORNS_GRIP;
INSERT INTO `item_mods` VALUES
    (@NORNS_GRIP, @MOD_MATT, 2);

DELETE FROM `item_mods_pet` WHERE itemId = @NORNS_GRIP;
INSERT INTO `item_mods_pet` VALUES
    (@NORNS_GRIP, @MOD_BP_DAMAGE, 2, @PET_AVATAR);

-- Norn's Grip +1 (Icon: Mythril Grip +1)
SET @NORNS_GRIP_P1 = 22211;
DELETE FROM `item_basic` WHERE itemid = @NORNS_GRIP_P1;
INSERT INTO `item_basic` VALUES (@NORNS_GRIP_P1,0,'norns_grip_+1','norns_grip_+1',1,@ITEM_EQDEF,@AH_GRIPS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @NORNS_GRIP_P1;
INSERT INTO `item_equipment` VALUES (@NORNS_GRIP_P1,'norns_grip_+1',75,0,@BLM+@SMN+@SCH+@GEO,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @NORNS_GRIP_P1;
INSERT INTO `item_mods` VALUES
    (@NORNS_GRIP_P1, @MOD_INT,  2),
    (@NORNS_GRIP_P1, @MOD_MATT, 4);

DELETE FROM `item_mods_pet` WHERE itemId = @NORNS_GRIP_P1;
INSERT INTO `item_mods_pet` VALUES
    (@NORNS_GRIP_P1, @MOD_BP_DAMAGE, 4, @PET_AVATAR);

SET @NORNS_GRIP_SYNTH = 80025;
SET @CERBERUS_HIDE    = 2169;
SET @CEHUETZI_PELT    = 8754;
SET @BUGARD_STRAP_P1  = 19018;
DELETE FROM `synth_recipes` WHERE Result = @NORNS_GRIP;
INSERT INTO `synth_recipes` VALUES (
    @NORNS_GRIP_SYNTH,0,0,
    0,0,0,0,    -- Wood/Smith/Gold/Cloth
    105,0,60,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @CERBERUS_HIDE,@CEHUETZI_PELT,@BUGARD_STRAP_P1,0,0,0,0,0,                   -- Materials
    @NORNS_GRIP,@NORNS_GRIP_P1,@NORNS_GRIP_P1,@NORNS_GRIP_P1,1,1,1,1,'Norn\'s Grip' -- Results
);

-- Hajduk Ring
SET @HAJDUK_RING = 11058;
DELETE FROM `item_basic` WHERE itemid = @HAJDUK_RING;
INSERT INTO `item_basic` VALUES (@HAJDUK_RING,0,'hajduk_ring','hajduk_ring',1,@ITEM_EQDEF,@AH_RINGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HAJDUK_RING;
INSERT INTO `item_equipment` VALUES (@HAJDUK_RING,'hajduk_ring',72,0,@ALL_JOBS,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HAJDUK_RING;
INSERT INTO `item_mods` VALUES
    (@HAJDUK_RING, @MOD_DEF,    3),
    (@HAJDUK_RING, @MOD_HP,    12),
    (@HAJDUK_RING, @MOD_ACC,  -12),
    (@HAJDUK_RING, @MOD_RACC,  12);

-- Hajduk Ring +1
SET @HAJDUK_RING_P1 = 11059;
DELETE FROM `item_basic` WHERE itemid = @HAJDUK_RING_P1;
INSERT INTO `item_basic` VALUES (@HAJDUK_RING_P1,0,'hajduk_ring_+1','hajduk_ring_+1',1,@ITEM_EQDEF,@AH_RINGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HAJDUK_RING_P1;
INSERT INTO `item_equipment` VALUES (@HAJDUK_RING_P1,'hajduk_ring_+1',72,0,@ALL_JOBS,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HAJDUK_RING_P1;
INSERT INTO `item_mods` VALUES
    (@HAJDUK_RING_P1, @MOD_DEF,    4),
    (@HAJDUK_RING_P1, @MOD_HP,    13),
    (@HAJDUK_RING_P1, @MOD_ACC,  -13),
    (@HAJDUK_RING_P1, @MOD_RACC,  13);

SET @HAJDUK_RING_SYNTH = 80026;
SET @KHIMAIRA_HORN     =  2371;
DELETE FROM `synth_recipes` WHERE Result = @HAJDUK_RING;
INSERT INTO `synth_recipes` VALUES (
    @HAJDUK_RING_SYNTH,0,0,
    0,0,0,0,   -- Wood/Smith/Gold/Cloth
    0,100,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @KHIMAIRA_HORN,@KHIMAIRA_HORN,0,0,0,0,0,0,                     -- Materials
    @HAJDUK_RING,@HAJDUK_RING_P1,@HAJDUK_RING_P1,@HAJDUK_RING_P1,1,1,1,1,'Hajduk Ring' -- Results
);

-- Ydalir Ring (Icon: Carapace Ring)
SET @YDALIR_RING = 11644;
DELETE FROM `item_basic` WHERE itemid = @YDALIR_RING;
INSERT INTO `item_basic` VALUES (@YDALIR_RING,0,'ydalir_ring','ydalir_ring',1,@ITEM_EQDEF,@AH_RINGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @YDALIR_RING;
INSERT INTO `item_equipment` VALUES (@YDALIR_RING,'ydalir_ring',73,0,@ALL_JOBS,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @YDALIR_RING;
INSERT INTO `item_mods` VALUES
    (@YDALIR_RING, @MOD_DEF,   4),
    (@YDALIR_RING, @MOD_HP,   15),
    (@YDALIR_RING, @MOD_ACC,   2),
    (@YDALIR_RING, @MOD_RACC, 13);

-- Ydalir Ring +1 (Icon: Carapace Ring +1)
SET @YDALIR_RING_P1 = 11645;
DELETE FROM `item_basic` WHERE itemid = @YDALIR_RING_P1;
INSERT INTO `item_basic` VALUES (@YDALIR_RING_P1,0,'ydalir_ring_+1','ydalir_ring_+1',1,@ITEM_EQDEF,@AH_RINGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @YDALIR_RING_P1;
INSERT INTO `item_equipment` VALUES (@YDALIR_RING_P1,'ydalir_ring_+1',73,0,@ALL_JOBS,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @YDALIR_RING_P1;
INSERT INTO `item_mods` VALUES
    (@YDALIR_RING_P1, @MOD_DEF,   5),
    (@YDALIR_RING_P1, @MOD_HP,   18),
    (@YDALIR_RING_P1, @MOD_ACC,   5),
    (@YDALIR_RING_P1, @MOD_RACC, 14);

SET @YDALIR_RING_SYNTH = 80027;
SET @CEHUETZI_CLAW     =  8752;
SET @BEHEMOTH_RING_P1  = 13556;
DELETE FROM `synth_recipes` WHERE Result = @YDALIR_RING;
INSERT INTO `synth_recipes` VALUES (
    @YDALIR_RING_SYNTH,0,0,
    0,0,0,0,   -- Wood/Smith/Gold/Cloth
    0,110,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @KHIMAIRA_HORN,@CEHUETZI_CLAW,@BEHEMOTH_RING_P1,0,0,0,0,0,                     -- Materials
    @YDALIR_RING,@YDALIR_RING_P1,@YDALIR_RING_P1,@YDALIR_RING_P1,1,1,1,1,'Ydalir Ring' -- Results
);


-- Yetshila
SET @YETSHILA = 21378;
DELETE FROM `item_basic` WHERE itemid = @YETSHILA;
INSERT INTO `item_basic` VALUES (@YETSHILA,0,'yetshila','yetshila',1,@ITEM_EQDEF,@AH_AMMUNITION,1,0);

DELETE FROM `item_equipment` WHERE itemId = @YETSHILA;
INSERT INTO `item_equipment` VALUES (@YETSHILA,'yetshila',75,0,@RDM+@THF+@NIN+@RUN,0,0,0,@SLOT_AMMO,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @YETSHILA;
INSERT INTO `item_weapon` VALUES (@YETSHILA,'yetshila',0,0,0,0,0,0,1,999,0,0);

DELETE FROM `item_mods` WHERE itemId = @YETSHILA;
INSERT INTO `item_mods` VALUES
    (@YETSHILA, @MOD_DEX,           1),
    (@YETSHILA, @MOD_CRIT_HIT_RATE, 1),
    (@YETSHILA, @MOD_CRITICAL_DMG,  2);

-- Yetshila +1
SET @YETSHILA_P1 = 21379;
DELETE FROM `item_basic` WHERE itemid = @YETSHILA_P1;
INSERT INTO `item_basic` VALUES (@YETSHILA_P1,0,'yetshila_+1','yetshila_+1',1,@ITEM_EQDEF,@AH_AMMUNITION,1,0);

DELETE FROM `item_equipment` WHERE itemId = @YETSHILA_P1;
INSERT INTO `item_equipment` VALUES (@YETSHILA_P1,'yetshila_+1',75,0,@RDM+@THF+@NIN+@RUN,0,0,0,@SLOT_AMMO,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @YETSHILA_P1;
INSERT INTO `item_weapon` VALUES (@YETSHILA_P1,'yetshila_+1',0,0,0,0,0,0,1,999,0,0);

DELETE FROM `item_mods` WHERE itemId = @YETSHILA_P1;
INSERT INTO `item_mods` VALUES
    (@YETSHILA_P1, @MOD_DEX,           2),
    (@YETSHILA_P1, @MOD_CRIT_HIT_RATE, 2),
    (@YETSHILA_P1, @MOD_CRITICAL_DMG,  3);

SET @YETSHILA_SYNTH = 80028;
SET @WAKTZA_ROSTRUM = 4012;
SET @WAKTZA_CREST   = 4013;
SET @ANIMAL_GLUE    = 937;
DELETE FROM `synth_recipes` WHERE Result = @YETSHILA;
INSERT INTO `synth_recipes` VALUES (
    @YETSHILA_SYNTH,0,0,
    0,0,0,114, -- Wood/Smith/Gold/Cloth
    0,60,0,0,  -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @ANIMAL_GLUE,@WAKTZA_ROSTRUM,@WAKTZA_CREST,0,0,0,0,0,           -- Materials
    @YETSHILA,@YETSHILA_P1,@YETSHILA_P1,@YETSHILA_P1,1,1,1,1,'Yetshila' -- Results
);

-- Titan's Grip (Icon: Brass Grip)
SET @TITANS_GRIP = 22208;
DELETE FROM `item_basic` WHERE itemid = @TITANS_GRIP;
INSERT INTO `item_basic` VALUES (@TITANS_GRIP,0,'titans_grip','titans_grip',1,@ITEM_EQDEF,@AH_GRIPS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TITANS_GRIP;
INSERT INTO `item_equipment` VALUES (@TITANS_GRIP,'titans_grip',75,0,@WAR+@MNK+@DRK+@SAM+@DRG+@RUN,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TITANS_GRIP;
INSERT INTO `item_mods` VALUES
    (@TITANS_GRIP, @MOD_PHYS_DMG_TAKEN, -200),
    (@TITANS_GRIP, @MOD_REGEN,             1);

-- Titan's Grip +1 (Icon: Brass Grip +1)
SET @TITANS_GRIP_P1 = 22209;
DELETE FROM `item_basic` WHERE itemid = @TITANS_GRIP_P1;
INSERT INTO `item_basic` VALUES (@TITANS_GRIP_P1,0,'titans_grip_+1','titans_grip_+1',1,@ITEM_EQDEF,@AH_GRIPS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TITANS_GRIP_P1;
INSERT INTO `item_equipment` VALUES (@TITANS_GRIP_P1,'titans_grip_+1',75,0,@WAR+@MNK+@DRK+@SAM+@DRG+@RUN,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TITANS_GRIP_P1;
INSERT INTO `item_mods` VALUES
    (@TITANS_GRIP_P1, @MOD_VIT,               2),
    (@TITANS_GRIP_P1, @MOD_PHYS_DMG_TAKEN, -400),
    (@TITANS_GRIP_P1, @MOD_REGEN,             2);

SET @TITANS_GRIP_SYNTH = 80029;
SET @KHIMAIRA_TAIL     = 2373;
SET @YGGDREANT_ROOT    = 4015;
SET @PLATINUM_GRIP_P1  = 19020;
DELETE FROM `synth_recipes` WHERE Result = @TITANS_GRIP;
INSERT INTO `synth_recipes` VALUES (
    @TITANS_GRIP_SYNTH,0,0,
    0,0,60,0,  -- Wood/Smith/Gold/Cloth
    105,0,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @KHIMAIRA_TAIL,@YGGDREANT_ROOT,@PLATINUM_GRIP_P1,0,0,0,0,0,                      -- Materials
    @TITANS_GRIP,@TITANS_GRIP_P1,@TITANS_GRIP_P1,@TITANS_GRIP_P1,1,1,1,1,'Titan\'s Grip' -- Results
);

-- Valar Bow (Icon: Cerberus Bow)
SET @VALAR_BOW = 21249;
DELETE FROM `item_basic` WHERE itemid = @VALAR_BOW;
INSERT INTO `item_basic` VALUES (@VALAR_BOW,0,'valar_bow','valar_bow',1,@ITEM_EQDEF,@AH_BOW,1,0);

DELETE FROM `item_equipment` WHERE itemId = @VALAR_BOW;
INSERT INTO `item_equipment` VALUES (@VALAR_BOW,'valar_bow',74,0,@RNG,32,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @VALAR_BOW;
INSERT INTO `item_weapon` VALUES (@VALAR_BOW,'valar_bow',@SKILL_ARCHERY,0,0,0,0,@DMG_PIERCING,1,490,74,0);

DELETE FROM `item_mods` WHERE itemId = @VALAR_BOW;
INSERT INTO `item_mods` VALUES
    (@VALAR_BOW, @MOD_STR,        4),
    (@VALAR_BOW, @MOD_AGI,        4),
    (@VALAR_BOW, @MOD_LIGHT_RES,  8),
    (@VALAR_BOW, @MOD_RACC,       4),
    (@VALAR_BOW, @MOD_RATT,      24);

-- Valar Bow +1 (Icon: Cerberus Bow +1)
SET @VALAR_BOW_P1 = 21250;
DELETE FROM `item_basic` WHERE itemid = @VALAR_BOW_P1;
INSERT INTO `item_basic` VALUES (@VALAR_BOW_P1,0,'valar_bow_+1','valar_bow_+1',1,@ITEM_EQDEF,@AH_BOW,1,0);

DELETE FROM `item_equipment` WHERE itemId = @VALAR_BOW_P1;
INSERT INTO `item_equipment` VALUES (@VALAR_BOW_P1,'valar_bow_+1',74,0,@RNG,37,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @VALAR_BOW_P1;
INSERT INTO `item_weapon` VALUES (@VALAR_BOW_P1,'valar_bow_+1',@SKILL_ARCHERY,0,0,0,0,@DMG_PIERCING,1,480,77,0);

DELETE FROM `item_mods` WHERE itemId = @VALAR_BOW_P1;
INSERT INTO `item_mods` VALUES
    (@VALAR_BOW_P1, @MOD_STR,        5),
    (@VALAR_BOW_P1, @MOD_AGI,        5),
    (@VALAR_BOW_P1, @MOD_LIGHT_RES, 12),
    (@VALAR_BOW_P1, @MOD_RACC,       8),
    (@VALAR_BOW_P1, @MOD_RATT,      25);

SET @VALAR_BOW_SYNTH = 80030;
SET @KHIMAIRA_MANE   =  2372;
SET @YGGDREANT_BOLE  =  4014;
SET @EURYTOS_BOW     = 17187;
SET @VALIS_BOW       = 18714;
DELETE FROM `synth_recipes` WHERE Result = @VALAR_BOW;
INSERT INTO `synth_recipes` VALUES (
    @VALAR_BOW_SYNTH,0,0,
    105,0,0,0, -- Wood/Smith/Gold/Cloth
    0,0,60,0,  -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,
        @KHIMAIRA_MANE,@YGGDREANT_BOLE,@GOBLIN_POWDER,@EURYTOS_BOW,0,0,0,0,  -- Materials
    @VALAR_BOW,@VALAR_BOW_P1,@VALAR_BOW_P1,@VALAR_BOW_P1,1,1,1,1,'Valar Bow' -- Results
);

-- Hjaldr Ring (Icon: Cerberus Ring)
SET @HJALDR_RING = 28583;
DELETE FROM `item_basic` WHERE itemid = @HJALDR_RING;
INSERT INTO `item_basic` VALUES (@HJALDR_RING,0,'hjaldr_ring','hjaldr_ring',1,@ITEM_EQDEF,@AH_RINGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HJALDR_RING;
INSERT INTO `item_equipment` VALUES (@HJALDR_RING,'hjaldr_ring',75,0,@WAR+@DRK+@RUN,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HJALDR_RING;
INSERT INTO `item_mods` VALUES
    (@HJALDR_RING, @MOD_FIRE_RES, 6),
    (@HJALDR_RING, @MOD_ATT,      6),
    (@HJALDR_RING, @MOD_ENMITY,   3),
    (@HJALDR_RING, @MOD_MDEF,     1),
    (@HJALDR_RING, @MOD_STORE_TP, 1);

-- Hjaldr Ring +1 (Icon: Cerberus Ring)
SET @HJALDR_RING_P1 = 28584;
DELETE FROM `item_basic` WHERE itemid = @HJALDR_RING_P1;
INSERT INTO `item_basic` VALUES (@HJALDR_RING_P1,0,'hjaldr_ring_+1','hjaldr_ring_+1',1,@ITEM_EQDEF,@AH_RINGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HJALDR_RING_P1;
INSERT INTO `item_equipment` VALUES (@HJALDR_RING_P1,'hjaldr_ring_+1',75,0,@WAR+@DRK+@RUN,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HJALDR_RING_P1;
INSERT INTO `item_mods` VALUES
    (@HJALDR_RING_P1, @MOD_FIRE_RES,  9),
    (@HJALDR_RING_P1, @MOD_ATT,       9),
    (@HJALDR_RING_P1, @MOD_ENMITY,    4),
    (@HJALDR_RING_P1, @MOD_MDEF,      2),
    (@HJALDR_RING_P1, @MOD_STORE_TP,  2);

SET @HJALDR_RING_SYNTH = 80031;
SET @MATAMATA_SHELL    =  3934;
SET @GABBRATH_HORN     =  3977;
SET @MERMANS_RING      = 13504;
DELETE FROM `synth_recipes` WHERE Result = @HJALDR_RING;
INSERT INTO `synth_recipes` VALUES (
    @HJALDR_RING_SYNTH,0,0,
    0,0,0,0,   -- Wood/Smith/Gold/Cloth
    0,109,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @MATAMATA_SHELL,@GABBRATH_HORN,@MERMANS_RING,0,0,0,0,0,                        -- Materials
    @HJALDR_RING,@HJALDR_RING_P1,@HJALDR_RING_P1,@HJALDR_RING_P1,1,1,1,1,'Hjaldr Ring' -- Results
);

-- Longbeard's Grip
SET @LONGBEARDS_GRIP = 22202;
DELETE FROM `item_basic` WHERE itemid = @LONGBEARDS_GRIP;
INSERT INTO `item_basic` VALUES (@LONGBEARDS_GRIP,0,'longbeards_grip','longbeards_grip',1,@ITEM_EQDEF,@AH_GRIPS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @LONGBEARDS_GRIP;
INSERT INTO `item_equipment` VALUES (@LONGBEARDS_GRIP,'longbeards_grip',75,0,@WAR+@MNK+@DRK+@BRD+@DRG+@RUN,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @LONGBEARDS_GRIP;
INSERT INTO `item_mods` VALUES
    (@LONGBEARDS_GRIP, @MOD_MEVA,               4),
    (@LONGBEARDS_GRIP, @MOD_MAGIC_DMG_TAKEN, -200);

-- Longbeard's Grip +1
SET @LONGBEARDS_GRIP_P1 = 22203;
DELETE FROM `item_basic` WHERE itemid = @LONGBEARDS_GRIP_P1;
INSERT INTO `item_basic` VALUES (@LONGBEARDS_GRIP_P1,0,'longbeards_grip_+1','longbeards_grip_+1',1,@ITEM_EQDEF,@AH_GRIPS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @LONGBEARDS_GRIP_P1;
INSERT INTO `item_equipment` VALUES (@LONGBEARDS_GRIP_P1,'longbeards_grip_+1',75,0,@WAR+@MNK+@DRK+@BRD+@DRG+@RUN,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @LONGBEARDS_GRIP_P1;
INSERT INTO `item_mods` VALUES
    (@LONGBEARDS_GRIP_P1, @MOD_MEVA,               8),
    (@LONGBEARDS_GRIP_P1, @MOD_MAGIC_DMG_TAKEN, -400),
    (@LONGBEARDS_GRIP_P1, @MOD_REFRESH,            1);

SET @LONGBEARDS_GRIP_SYNTH = 80032;
SET @ROCKFIN_FIN           =  3978;
SET @RAAZ_LEATHER          =  8708;
SET @RAPTOR_STRAP_P1       = 19016;
DELETE FROM `synth_recipes` WHERE Result = @LONGBEARDS_GRIP;
INSERT INTO `synth_recipes` VALUES (
    @LONGBEARDS_GRIP_SYNTH,0,0,
    0,0,0,0,   -- Wood/Smith/Gold/Cloth
    111,0,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @ROCKFIN_FIN,@RAAZ_LEATHER,@RAPTOR_STRAP_P1,0,0,0,0,0,                                               -- Materials
    @LONGBEARDS_GRIP,@LONGBEARDS_GRIP_P1,@LONGBEARDS_GRIP_P1,@LONGBEARDS_GRIP_P1,1,1,1,1,'Longbeard\'s Grip' -- Results
);

-- Conjurer's Crook
SET @CONJURERS_CROOK = 21202;
DELETE FROM `item_basic` WHERE itemid = @CONJURERS_CROOK;
INSERT INTO `item_basic` VALUES (@CONJURERS_CROOK,0,'conjurers_crook','conjurers_crook',1,@ITEM_EQDEF,@AH_STAFF,1,0);

DELETE FROM `item_equipment` WHERE itemId = @CONJURERS_CROOK;
INSERT INTO `item_equipment` VALUES (@CONJURERS_CROOK,'conjurers_crook',73,0,@SMN,293,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @CONJURERS_CROOK;
INSERT INTO `item_weapon` VALUES (@CONJURERS_CROOK,'conjurers_crook',@SKILL_STAFF,0,0,0,0,3,1,366,57,0);

DELETE FROM `item_mods` WHERE itemId = @CONJURERS_CROOK;
INSERT INTO `item_mods` VALUES
    (@CONJURERS_CROOK, @MOD_MP,  25),
    (@CONJURERS_CROOK, @MOD_INT,  8),
    (@CONJURERS_CROOK, 553,       2),  -- FIRE_AFFINITY_PERP: 2
    (@CONJURERS_CROOK, 554,       2),  -- ICE_AFFINITY_PERP: 2
    (@CONJURERS_CROOK, 555,       2),  -- WIND_AFFINITY_PERP: 2
    (@CONJURERS_CROOK, 556,       2),  -- EARTH_AFFINITY_PERP: 2
    (@CONJURERS_CROOK, 557,       2),  -- THUNDER_AFFINITY_PERP: 2
    (@CONJURERS_CROOK, 558,       2),  -- WATER_AFFINITY_PERP: 2
    (@CONJURERS_CROOK, 559,       2),  -- LIGHT_AFFINITY_PERP: 2
    (@CONJURERS_CROOK, 560,       2);  -- DARK_AFFINITY_PERP: 2

DELETE FROM `item_mods_pet` WHERE itemId = @CONJURERS_CROOK;
INSERT INTO `item_mods_pet` VALUES
    (@CONJURERS_CROOK, @MOD_MATT, 15, @PET_AVATAR);

-- Conjurer's Crook +1
SET @CONJURERS_CROOK_P1 = 21203;
DELETE FROM `item_basic` WHERE itemid = @CONJURERS_CROOK_P1;
INSERT INTO `item_basic` VALUES (@CONJURERS_CROOK_P1,0,'conjurers_crook_+1','conjurers_crook_+1',1,@ITEM_EQDEF,@AH_STAFF,1,0);

DELETE FROM `item_equipment` WHERE itemId = @CONJURERS_CROOK_P1;
INSERT INTO `item_equipment` VALUES (@CONJURERS_CROOK_P1,'conjurers_crook_+1',73,0,@SMN,293,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @CONJURERS_CROOK_P1;
INSERT INTO `item_weapon` VALUES (@CONJURERS_CROOK_P1,'conjurers_crook_+1',@SKILL_STAFF,0,0,0,0,3,1,356,62,0);

DELETE FROM `item_mods` WHERE itemId = @CONJURERS_CROOK_P1;
INSERT INTO `item_mods` VALUES
    (@CONJURERS_CROOK_P1, @MOD_MP,  40),
    (@CONJURERS_CROOK_P1, @MOD_INT, 10),
    (@CONJURERS_CROOK_P1, 553,       3),  -- FIRE_AFFINITY_PERP: 3
    (@CONJURERS_CROOK_P1, 554,       3),  -- ICE_AFFINITY_PERP: 3
    (@CONJURERS_CROOK_P1, 555,       3),  -- WIND_AFFINITY_PERP: 3
    (@CONJURERS_CROOK_P1, 556,       3),  -- EARTH_AFFINITY_PERP: 3
    (@CONJURERS_CROOK_P1, 557,       3),  -- THUNDER_AFFINITY_PERP: 3
    (@CONJURERS_CROOK_P1, 558,       3),  -- WATER_AFFINITY_PERP: 3
    (@CONJURERS_CROOK_P1, 559,       3),  -- LIGHT_AFFINITY_PERP: 3
    (@CONJURERS_CROOK_P1, 560,       3);  -- DARK_AFFINITY_PERP: 3

DELETE FROM `item_mods_pet` WHERE itemId = @CONJURERS_CROOK;
INSERT INTO `item_mods_pet` VALUES
    (@CONJURERS_CROOK, @MOD_MATT, 20, @PET_AVATAR),
    (@CONJURERS_CROOK, @MOD_MACC, 10, @PET_AVATAR);

SET @CONJURERS_CROOK_SYNTH = 80033;
SET @TANZANITE_JEWEL       =  3925;
SET @URUNDAY_LUMBER        =  3927;
SET @ROCKFIN_TOOTH         =  3979;
SET @IRIDAL_STAFF          = 18632;
DELETE FROM `synth_recipes` WHERE Result = @CONJURERS_CROOK;
INSERT INTO `synth_recipes` VALUES (
    @CONJURERS_CROOK_SYNTH,0,0,
    110,0,60,0, -- Wood/Smith/Gold/Cloth
    0,0,0,0,    -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,
        @TANZANITE_JEWEL,@URUNDAY_LUMBER,@URUNDAY_LUMBER,@ROCKFIN_TOOTH,@IRIDAL_STAFF,0,0,0,                 -- Materials
    @CONJURERS_CROOK,@CONJURERS_CROOK_P1,@CONJURERS_CROOK_P1,@CONJURERS_CROOK_P1,1,1,1,1,'Conjurer\'s Crook' -- Results
);

-- Reflexive Grip
SET @REFLEXIVE_GRIP = 22200;
DELETE FROM `item_basic` WHERE itemid = @REFLEXIVE_GRIP;
INSERT INTO `item_basic` VALUES (@REFLEXIVE_GRIP,0,'reflexive_grip','reflexive_grip',1,@ITEM_EQDEF,@AH_GRIPS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @REFLEXIVE_GRIP;
INSERT INTO `item_equipment` VALUES (@REFLEXIVE_GRIP,'reflexive_grip',75,0,@WHM+@BLM+@RDM+@BRD+@SCH+@GEO,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @REFLEXIVE_GRIP;
INSERT INTO `item_mods` VALUES
    (@REFLEXIVE_GRIP, @MOD_MACC,     3),
    (@REFLEXIVE_GRIP, @MOD_FASTCAST, 1);

-- Reflexive Grip +1
SET @REFLEXIVE_GRIP_P1 = 22201;
DELETE FROM `item_basic` WHERE itemid = @REFLEXIVE_GRIP_P1;
INSERT INTO `item_basic` VALUES (@REFLEXIVE_GRIP_P1,0,'reflexive_grip_+1','reflexive_grip_+1',1,@ITEM_EQDEF,@AH_GRIPS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @REFLEXIVE_GRIP_P1;
INSERT INTO `item_equipment` VALUES (@REFLEXIVE_GRIP_P1,'reflexive_grip_+1',75,0,@WHM+@BLM+@RDM+@BRD+@SCH+@GEO,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @REFLEXIVE_GRIP_P1;
INSERT INTO `item_mods` VALUES
    (@REFLEXIVE_GRIP_P1, @MOD_MACC,     4),
    (@REFLEXIVE_GRIP_P1, @MOD_FASTCAST, 3);

-- Omni Grip
SET @OMNI_GRIP = 22199;
DELETE FROM `item_basic` WHERE itemid = @OMNI_GRIP;
INSERT INTO `item_basic` VALUES (@OMNI_GRIP,0,'omni_grip','omni_grip',1,@ITEM_EQDEF,@AH_GRIPS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @OMNI_GRIP;
INSERT INTO `item_equipment` VALUES (@OMNI_GRIP,'omni_grip',70,0,@ALL_JOBS,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @OMNI_GRIP;
INSERT INTO `item_mods` VALUES
    (@OMNI_GRIP, @MOD_MP,   25),
    (@OMNI_GRIP, @MOD_MACC,  3);

SET @REFLEXIVE_GRIP_SYNTH = 80034;
SET @BZTAVIAN_WING        =  3981;
DELETE FROM `synth_recipes` WHERE Result = @REFLEXIVE_GRIP;
INSERT INTO `synth_recipes` VALUES (
    @REFLEXIVE_GRIP_SYNTH,0,0,
    0,0,0,32, -- Wood/Smith/Gold/Cloth
    93,0,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @BZTAVIAN_WING,@RAAZ_LEATHER,@OMNI_GRIP,0,0,0,0,0,                                            -- Materials
    @REFLEXIVE_GRIP,@REFLEXIVE_GRIP_P1,@REFLEXIVE_GRIP_P1,@REFLEXIVE_GRIP_P1,1,1,1,1,'Reflexive Grip' -- Results
);

-- Stormlord Shawl
SET @STORMLORD_SHAWL = 10968;
DELETE FROM `item_basic` WHERE itemid = @STORMLORD_SHAWL;
INSERT INTO `item_basic` VALUES (@STORMLORD_SHAWL,0,'stormlord_shawl','stormlord_shawl',1,@ITEM_EQDEF,@AH_BACK,1,0);

DELETE FROM `item_equipment` WHERE itemId = @STORMLORD_SHAWL;
INSERT INTO `item_equipment` VALUES (@STORMLORD_SHAWL,'stormlord_shawl',73,0,@WHM+@BLM+@RDM+@BRD+@SMN+@BLU+@PUP+@SCH+@GEO,0,0,0,@SLOT_BACK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @STORMLORD_SHAWL;
INSERT INTO `item_mods` VALUES
    (@STORMLORD_SHAWL, @MOD_DEF,         11),
    (@STORMLORD_SHAWL, @MOD_ATT,         10),
    (@STORMLORD_SHAWL, @MOD_STR,          3),
    (@STORMLORD_SHAWL, @MOD_MND,          3),
    (@STORMLORD_SHAWL, @MOD_THUNDER_RES, 10);

-- Stormlord Shawl +1
SET @STORMLORD_SHAWL_P1 = 10969;
DELETE FROM `item_basic` WHERE itemid = @STORMLORD_SHAWL_P1;
INSERT INTO `item_basic` VALUES (@STORMLORD_SHAWL_P1,0,'stormlord_shawl_+1','stormlord_shawl_+1',1,@ITEM_EQDEF,@AH_BACK,1,0);

DELETE FROM `item_equipment` WHERE itemId = @STORMLORD_SHAWL_P1;
INSERT INTO `item_equipment` VALUES (@STORMLORD_SHAWL_P1,'stormlord_shawl_+1',73,0,@WHM+@BLM+@RDM+@BRD+@SMN+@BLU+@PUP+@SCH+@GEO,0,0,0,@SLOT_BACK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @STORMLORD_SHAWL_P1;
INSERT INTO `item_mods` VALUES
    (@STORMLORD_SHAWL_P1, @MOD_DEF,         12),
    (@STORMLORD_SHAWL_P1, @MOD_ATT,         15),
    (@STORMLORD_SHAWL_P1, @MOD_STR,          4),
    (@STORMLORD_SHAWL_P1, @MOD_MND,          4),
    (@STORMLORD_SHAWL_P1, @MOD_THUNDER_RES, 12),
    (@STORMLORD_SHAWL_P1, @MOD_DOUBLE_ATK,   1);

SET @STORMLORD_SHAWL_SYNTH = 80035;
SET @AMEMET_MANTLE_P1      = 13646;
DELETE FROM `synth_recipes` WHERE Result = @STORMLORD_SHAWL;
INSERT INTO `synth_recipes` VALUES (
    @STORMLORD_SHAWL_SYNTH,0,0,
    0,0,0,44,  -- Wood/Smith/Gold/Cloth
    93,0,44,0, -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,
        @ELEMENTIUM_THREAD,@AMPHISBAENA_HIDE,@GOBLIN_POWDER,@AMEMET_MANTLE_P1,0,0,0,0,                     -- Materials
    @STORMLORD_SHAWL,@STORMLORD_SHAWL_P1,@STORMLORD_SHAWL_P1,@STORMLORD_SHAWL_P1,1,1,1,1,'Stormlord Shawl' -- Results
);

-- Chunin Ring
SET @CHUNIN_RING = 10794;
DELETE FROM `item_basic` WHERE itemid = @CHUNIN_RING;
INSERT INTO `item_basic` VALUES (@CHUNIN_RING,0,'chunin_ring','chunin_ring',1,@ITEM_EQDEF,@AH_RINGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @CHUNIN_RING;
INSERT INTO `item_equipment` VALUES (@CHUNIN_RING,'chunin_ring',73,0,@MNK+@THF+@BRD+@SAM+@NIN+@RUN,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @CHUNIN_RING;
INSERT INTO `item_mods` VALUES
    (@CHUNIN_RING, @MOD_DEF, 3),
    (@CHUNIN_RING, @MOD_AGI, 3),
    (@CHUNIN_RING, @MOD_INT, 3),
    (@CHUNIN_RING, @MOD_ACC, 5),
    (@CHUNIN_RING, @MOD_EVA, 5);

-- Chunin Ring +1
SET @CHUNIN_RING_P1 = 10795;
DELETE FROM `item_basic` WHERE itemid = @CHUNIN_RING_P1;
INSERT INTO `item_basic` VALUES (@CHUNIN_RING_P1,0,'chunin_ring_+1','chunin_ring_+1',1,@ITEM_EQDEF,@AH_RINGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @CHUNIN_RING_P1;
INSERT INTO `item_equipment` VALUES (@CHUNIN_RING_P1,'chunin_ring_+1',73,0,@MNK+@THF+@BRD+@SAM+@NIN+@RUN,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @CHUNIN_RING_P1;
INSERT INTO `item_mods` VALUES
    (@CHUNIN_RING_P1, @MOD_DEF,    4),
    (@CHUNIN_RING_P1, @MOD_AGI,    4),
    (@CHUNIN_RING_P1, @MOD_INT,    4),
    (@CHUNIN_RING_P1, @MOD_ACC,    6),
    (@CHUNIN_RING_P1, @MOD_EVA,    6),
    (@CHUNIN_RING_P1, @MOD_ENMITY, 2);

SET @CHUNIN_RING_SYNTH = 80036;
SET @WIVRE_RING_P1     = 15812;
DELETE FROM `synth_recipes` WHERE Result = @CHUNIN_RING;
INSERT INTO `synth_recipes` VALUES (
    @CHUNIN_RING_SYNTH,0,0,
    0,0,0,0,   -- Wood/Smith/Gold/Cloth
    0,93,44,0, -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,
        @BATTOSAI_FANG,@GOBLIN_POWDER,@WIVRE_RING_P1,0,0,0,0,0,                        -- Materials
    @CHUNIN_RING,@CHUNIN_RING_P1,@CHUNIN_RING_P1,@CHUNIN_RING_P1,1,1,1,1,'Chunin Ring' -- Results
);

-- Askalaphos
SET @ASKALAPHOS = 10964;
DELETE FROM `item_basic` WHERE itemid = @ASKALAPHOS;
INSERT INTO `item_basic` VALUES (@ASKALAPHOS,0,'askalaphos','askalaphos',1,@ITEM_EQDEF,@AH_SHIELD,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ASKALAPHOS;
INSERT INTO `item_equipment` VALUES (@ASKALAPHOS,'askalaphos',73,0,@WAR+@RDM+@DRK+@BLU,50,3,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ASKALAPHOS;
INSERT INTO `item_mods` VALUES
    (@ASKALAPHOS, @MOD_DEF,          34),
    (@ASKALAPHOS, @MOD_STR,           4),
    (@ASKALAPHOS, @MOD_ENMITY,        4),
    (@ASKALAPHOS, @MOD_SHIELD_SKILL, 14);

-- Askalaphos +1
SET @ASKALAPHOS_P1 = 10965;
DELETE FROM `item_basic` WHERE itemid = @ASKALAPHOS_P1;
INSERT INTO `item_basic` VALUES (@ASKALAPHOS_P1,0,'askalaphos_+1','askalaphos_+1',1,@ITEM_EQDEF,@AH_SHIELD,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ASKALAPHOS_P1;
INSERT INTO `item_equipment` VALUES (@ASKALAPHOS_P1,'askalaphos_+1',73,0,@WAR+@RDM+@DRK+@BLU,50,3,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ASKALAPHOS_P1;
INSERT INTO `item_mods` VALUES
    (@ASKALAPHOS_P1, @MOD_DEF,               35),
    (@ASKALAPHOS_P1, @MOD_STR,                5),
    (@ASKALAPHOS_P1, @MOD_ENMITY,             5),
    (@ASKALAPHOS_P1, @MOD_SHIELD_SKILL,      15),
    (@ASKALAPHOS_P1, @MOD_MAGIC_DMG_TAKEN, -500);

SET @ASKALAPHOS_SYNTH  = 80037;
SET @TITANIUM_INGOT    = 4021;
SET @ACHERON_SHIELD_P1 = 12386;
DELETE FROM `synth_recipes` WHERE Result = @ASKALAPHOS;
INSERT INTO `synth_recipes` VALUES (
    @ASKALAPHOS_SYNTH,0,0,
    0,44,0,0,  -- Wood/Smith/Gold/Cloth
    0,93,44,0, -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,
        @TITANIUM_INGOT,@TORTUGA_SHELL,@GOBLIN_POWDER,@ACHERON_SHIELD_P1,0,0,0,0, -- Materials
    @ASKALAPHOS,@ASKALAPHOS_P1,@ASKALAPHOS_P1,@ASKALAPHOS_P1,1,1,1,1,'Askalaphos' -- Results
);

-- Uk'uxkaj Cap
SET @UKUXKAJ_CAP = 27766;
DELETE FROM `item_basic` WHERE itemid = @UKUXKAJ_CAP;
INSERT INTO `item_basic` VALUES (@UKUXKAJ_CAP,0,'ukuxkaj_cap','ukuxkaj_cap',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @UKUXKAJ_CAP;
INSERT INTO `item_equipment` VALUES (@UKUXKAJ_CAP,'ukuxkaj_cap',75,0,@MNK+@THF+@RNG+@NIN+@BLU+@COR+@PUP+@DNC+@RUN,330,0,0,@SLOT_HEAD,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @UKUXKAJ_CAP;
INSERT INTO `item_mods` VALUES
    (@UKUXKAJ_CAP, @MOD_DEF,        23),
    (@UKUXKAJ_CAP, @MOD_HP,         25),
    (@UKUXKAJ_CAP, @MOD_ATT,         9),
    (@UKUXKAJ_CAP, @MOD_HTH_SKILL,   9),
    (@UKUXKAJ_CAP, @MOD_HASTE,     500);

-- Uk'uxkaj Boots
SET @UKUXKAJ_BOOTS = 28331;
DELETE FROM `item_basic` WHERE itemid = @UKUXKAJ_BOOTS;
INSERT INTO `item_basic` VALUES (@UKUXKAJ_BOOTS,0,'ukuxkaj_boots','ukuxkaj_boots',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @UKUXKAJ_BOOTS;
INSERT INTO `item_equipment` VALUES (@UKUXKAJ_BOOTS,'ukuxkaj_boots',75,0,@WHM+@BLM+@RDM+@BRD+@SMN+@BLU+@SCH+@GEO,330,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @UKUXKAJ_BOOTS;
INSERT INTO `item_mods` VALUES
    (@UKUXKAJ_BOOTS, @MOD_DEF,  18),
    (@UKUXKAJ_BOOTS, @MOD_HP,   10),
    (@UKUXKAJ_BOOTS, @MOD_MP,   13),
    (@UKUXKAJ_BOOTS, @MOD_INT,   5),
    (@UKUXKAJ_BOOTS, @MOD_MATT,  4);

-- Floral Gauntlets
SET @FLORAL_GAUNTLETS = 27137;
DELETE FROM `item_basic` WHERE itemid = @FLORAL_GAUNTLETS;
INSERT INTO `item_basic` VALUES (@FLORAL_GAUNTLETS,0,'floral_gauntlets','floral_gauntlets',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @FLORAL_GAUNTLETS;
INSERT INTO `item_equipment` VALUES (@FLORAL_GAUNTLETS,'floral_gauntlets',75,0,@THF+@RNG+@NIN+@COR,106,0,0,@SLOT_HANDS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @FLORAL_GAUNTLETS;
INSERT INTO `item_mods` VALUES
    (@FLORAL_GAUNTLETS, @MOD_DEF,        18),
    (@FLORAL_GAUNTLETS, @MOD_HP,         25),
    (@FLORAL_GAUNTLETS, @MOD_STR,         4),
    (@FLORAL_GAUNTLETS, @MOD_DEX,         4),
    (@FLORAL_GAUNTLETS, @MOD_HASTE,     200),
    (@FLORAL_GAUNTLETS, @MOD_DUAL_WIELD,  5);

-- Vampirism
SET @VAMPIRISM = 20706;
DELETE FROM `item_basic` WHERE itemid = @VAMPIRISM;
INSERT INTO `item_basic` VALUES (@VAMPIRISM,0,'vampirism','vampirism',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @VAMPIRISM;
INSERT INTO `item_equipment` VALUES (@VAMPIRISM,'vampirism',75,0,@WAR+@RDM+@THF+@PLD+@DRK+@BRD+@RNG+@NIN+@DRG+@BLU+@COR+@RUN,752,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @VAMPIRISM;
INSERT INTO `item_weapon` VALUES (@VAMPIRISM,'vampirism',@SKILL_SWORD,0,0,0,0,@DMG_PIERCING,1,240,41,0);

DELETE FROM `item_mods` WHERE itemId = @VAMPIRISM;
INSERT INTO `item_mods` VALUES
    (@VAMPIRISM, @MOD_HP,                                45),
    (@VAMPIRISM, @MOD_ATT,                                8),
    (@VAMPIRISM, @MOD_MATT,                               8),
    (@VAMPIRISM, @MOD_ITEM_ADDEFFECT_TYPE,                5),
    (@VAMPIRISM, @MOD_ITEM_SUBEFFECT,                    21), -- HP Drain
    (@VAMPIRISM, @MOD_ITEM_ADDEFFECT_DMG,                15),
    (@VAMPIRISM, @MOD_ITEM_ADDEFFECT_CHANCE,            100),
    (@VAMPIRISM, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_DARK);

-- Taming Sari
SET @TAMING_SARI = 20596;
DELETE FROM `item_basic` WHERE itemid = @TAMING_SARI;
INSERT INTO `item_basic` VALUES (@TAMING_SARI,0,'taming_sari','taming_sari',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TAMING_SARI;
INSERT INTO `item_equipment` VALUES (@TAMING_SARI,'taming_sari',75,0,@THF+@BRD+@DNC,628,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @TAMING_SARI;
INSERT INTO `item_weapon` VALUES (@TAMING_SARI,'taming_sari',@SKILL_DAGGER,0,0,0,0,@DMG_PIERCING,2,211,29,0);

DELETE FROM `item_mods` WHERE itemId = @TAMING_SARI;
INSERT INTO `item_mods` VALUES
    (@TAMING_SARI, @MOD_STR,         3),
    (@TAMING_SARI, @MOD_DEX,         7),
    (@TAMING_SARI, @MOD_SUBTLE_BLOW, 8);

-- Samnuha Tights
SET @SAMNUHA_TIGHTS = 27295;
DELETE FROM `item_basic` WHERE itemid = @SAMNUHA_TIGHTS;
INSERT INTO `item_basic` VALUES (@SAMNUHA_TIGHTS,0,'samnuha_tights','samnuha_tights',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SAMNUHA_TIGHTS;
INSERT INTO `item_equipment` VALUES (@SAMNUHA_TIGHTS,'samnuha_tights',75,0,@MNK+@THF+@RNG+@NIN+@BLU+@COR+@PUP+@DNC+@RUN,401,0,0,@SLOT_LEGS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SAMNUHA_TIGHTS;
INSERT INTO `item_mods` VALUES
    (@SAMNUHA_TIGHTS, @MOD_DEF,       42),
    (@SAMNUHA_TIGHTS, @MOD_HP,        35),
    (@SAMNUHA_TIGHTS, @MOD_STR,        3),
    (@SAMNUHA_TIGHTS, @MOD_ACC,       -5),
    (@SAMNUHA_TIGHTS, @MOD_EVA,       -5),
    (@SAMNUHA_TIGHTS, @MOD_HASTE,    600),
    (@SAMNUHA_TIGHTS, @MOD_STORE_TP,   2);

-- Samnuha Coat
SET @SAMNUHA_COAT = 26973;
DELETE FROM `item_basic` WHERE itemid = @SAMNUHA_COAT;
INSERT INTO `item_basic` VALUES (@SAMNUHA_COAT,0,'samnuha_coat','samnuha_coat',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SAMNUHA_COAT;
INSERT INTO `item_equipment` VALUES (@SAMNUHA_COAT,'samnuha_coat',75,0,@MNK+@THF+@RNG+@NIN+@BLU+@COR+@PUP+@DNC+@RUN,401,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SAMNUHA_COAT;
INSERT INTO `item_mods` VALUES
    (@SAMNUHA_COAT, @MOD_DEF,    45),
    (@SAMNUHA_COAT, @MOD_HP,     40),
    (@SAMNUHA_COAT, @MOD_DEX,     5),
    (@SAMNUHA_COAT, @MOD_AGI,     5),
    (@SAMNUHA_COAT, @MOD_ACC,    10),
    (@SAMNUHA_COAT, @MOD_EVA,     5),
    (@SAMNUHA_COAT, @MOD_MATT,   10),
    (@SAMNUHA_COAT, @MOD_HASTE, 200);

-- Medium's Sabots
SET @MEDIUMS_SABOT = 27493;
DELETE FROM `item_basic` WHERE itemid = @MEDIUMS_SABOT;
INSERT INTO `item_basic` VALUES (@MEDIUMS_SABOT,0,'mediums_sabots','mediums_sabots',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @MEDIUMS_SABOT;
INSERT INTO `item_equipment` VALUES (@MEDIUMS_SABOT,'mediums_sabots',75,0,@WHM+@BLM+@RDM+@BRD+@SMN+@BLU+@SCH+@GEO,252,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @MEDIUMS_SABOT;
INSERT INTO `item_mods` VALUES
    (@MEDIUMS_SABOT, @MOD_DEF,            14),
    (@MEDIUMS_SABOT, @MOD_MP,             20),
    (@MEDIUMS_SABOT, @MOD_STR,             3),
    (@MEDIUMS_SABOT, @MOD_MND,             8),
    (@MEDIUMS_SABOT, @MOD_HANDBELL_SKILL,  5),
    (@MEDIUMS_SABOT, @MOD_CURE_POTENCY,    4);

-- Purgation
SET @PURGATION = 20796;
DELETE FROM `item_basic` WHERE itemid = @PURGATION;
INSERT INTO `item_basic` VALUES (@PURGATION,0,'purgation','purgation',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @PURGATION;
INSERT INTO `item_equipment` VALUES (@PURGATION,'purgation',75,0,@WAR+@DRK+@BST,387,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @PURGATION;
INSERT INTO `item_weapon` VALUES (@PURGATION,'purgation',@SKILL_AXE,0,0,0,0,@DMG_BLUNT,1,288,50,0);

DELETE FROM `item_mods` WHERE itemId = @PURGATION;
INSERT INTO `item_mods` VALUES
    (@PURGATION, @MOD_ACC,               12),
    (@PURGATION, @MOD_MAGIC_DMG_TAKEN, -400),
    (@PURGATION, @MOD_DOUBLE_ATK,         3),
    (@PURGATION, @MOD_UNDEAD_KILLER,      5);

-- Ochu
SET @OCHU = 20978;
DELETE FROM `item_basic` WHERE itemid = @OCHU;
INSERT INTO `item_basic` VALUES (@OCHU,0,'ochu','ochu',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @OCHU;
INSERT INTO `item_equipment` VALUES (@OCHU,'ochu',75,0,@NIN,613,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @OCHU;
INSERT INTO `item_weapon` VALUES (@OCHU,'ochu',@SKILL_KATANA,0,0,0,0,@DMG_SLASHING,1,227,40,0);

DELETE FROM `item_mods` WHERE itemId = @OCHU;
INSERT INTO `item_mods` VALUES
    (@OCHU, @MOD_STR,         4),
    (@OCHU, @MOD_DEX,         4),
    (@OCHU, @MOD_ACC,         8),
    (@OCHU, @MOD_RACC,        8),
    (@OCHU, @MOD_SUBTLE_BLOW, 8);

-- Jumalik Helm
SET @JUMALIK_HELM = 25603;
DELETE FROM `item_basic` WHERE itemid = @JUMALIK_HELM;
INSERT INTO `item_basic` VALUES (@JUMALIK_HELM,0,'jumalik_helm','jumalik_helm',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @JUMALIK_HELM;
INSERT INTO `item_equipment` VALUES (@JUMALIK_HELM,'jumalik_helm',75,0,@WAR+@PLD+@DRK+@BST+@DRG+@RUN,400,0,0,@SLOT_HEAD,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @JUMALIK_HELM;
INSERT INTO `item_mods` VALUES
    (@JUMALIK_HELM, @MOD_DEF,              35),
    (@JUMALIK_HELM, @MOD_HP,               25),
    (@JUMALIK_HELM, @MOD_MP,               15),
    (@JUMALIK_HELM, @MOD_VIT,               8),
    (@JUMALIK_HELM, @MOD_MATT,              9),
    (@JUMALIK_HELM, @MOD_PHYS_DMG_TAKEN, -500),
    (@JUMALIK_HELM, @MOD_HASTE,           500);

-- Jumalik Mail
SET @JUMALIK_MAIL = 26972;
DELETE FROM `item_basic` WHERE itemid = @JUMALIK_MAIL;
INSERT INTO `item_basic` VALUES (@JUMALIK_MAIL,0,'jumalik_mail','jumalik_mail',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @JUMALIK_MAIL;
INSERT INTO `item_equipment` VALUES (@JUMALIK_MAIL,'jumalik_mail',75,0,@WAR+@PLD+@DRK+@BST+@DRG+@RUN,400,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @JUMALIK_MAIL;
INSERT INTO `item_mods` VALUES
    (@JUMALIK_MAIL, @MOD_DEF,           58),
    (@JUMALIK_MAIL, @MOD_HP,            35),
    (@JUMALIK_MAIL, @MOD_MP,            25),
    (@JUMALIK_MAIL, @MOD_DEX,            8),
    (@JUMALIK_MAIL, @MOD_ATT,           20),
    (@JUMALIK_MAIL, @MOD_HASTE,        100),
    (@JUMALIK_MAIL, @MOD_CURE_POTENCY,   9);

-- Dampening Tam
SET @DAMPENING_TAM = 25630;
DELETE FROM `item_basic` WHERE itemid = @DAMPENING_TAM;
INSERT INTO `item_basic` VALUES (@DAMPENING_TAM,0,'dampening_tam','dampening_tam',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DAMPENING_TAM;
INSERT INTO `item_equipment` VALUES (@DAMPENING_TAM,'dampening_tam',75,0,@MNK+@THF+@RNG+@NIN+@BLU+@COR+@DNC+@RUN,258,0,0,@SLOT_HEAD,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DAMPENING_TAM;
INSERT INTO `item_mods` VALUES
    (@DAMPENING_TAM, @MOD_DEF,               22),
    (@DAMPENING_TAM, @MOD_HP,                15),
    (@DAMPENING_TAM, @MOD_STR,                2),
    (@DAMPENING_TAM, @MOD_DEX,                4),
    (@DAMPENING_TAM, @MOD_ACC,                5),
    (@DAMPENING_TAM, @MOD_HASTE,            500),
    (@DAMPENING_TAM, @MOD_MAGIC_DMG_TAKEN, -200);

-- Divinity
SET @DIVINITY = 21088;
DELETE FROM `item_basic` WHERE itemid = @DIVINITY;
INSERT INTO `item_basic` VALUES (@DIVINITY,0,'divinity','divinity',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DIVINITY;
INSERT INTO `item_equipment` VALUES (@DIVINITY,'divinity',75,0,@WHM+@GEO,751,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @DIVINITY;
INSERT INTO `item_weapon` VALUES (@DIVINITY,'divinity',@SKILL_CLUB,0,0,0,0,@DMG_BLUNT,1,340,52,0);

DELETE FROM `item_mods` WHERE itemId = @DIVINITY;
INSERT INTO `item_mods` VALUES
    (@DIVINITY, @MOD_STR,           5),
    (@DIVINITY, @MOD_MND,           8),
    (@DIVINITY, @MOD_MATT,         12),
    (@DIVINITY, @MOD_DIVINE_SKILL, 12);

-- Malevolence
SET @MALEVOLENCE = 20595;
DELETE FROM `item_basic` WHERE itemid = @MALEVOLENCE;
INSERT INTO `item_basic` VALUES (@MALEVOLENCE,0,'malevolence','malevolence',1,@ITEM_RARE,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @MALEVOLENCE;
INSERT INTO `item_equipment` VALUES (@MALEVOLENCE,'malevolence',75,0,@BLM+@SMN+@SCH+@GEO,541,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @MALEVOLENCE;
INSERT INTO `item_weapon` VALUES (@MALEVOLENCE,'malevolence',@SKILL_DAGGER,0,0,0,0,@DMG_PIERCING,1,201,33,0);

DELETE FROM `item_mods` WHERE itemId = @MALEVOLENCE;
INSERT INTO `item_mods` VALUES
    (@MALEVOLENCE, @MOD_INT,  9),
    (@MALEVOLENCE, @MOD_MATT, 9);

DELETE FROM `item_latents` WHERE itemid = @MALEVOLENCE;
INSERT INTO `item_latents` VALUES (@MALEVOLENCE, @MOD_REFRESH, 2, @MOD_TP_OVER, 1000);

-- Starfall
SET @STARFALL = 21129;
DELETE FROM `item_basic` WHERE itemid = @STARFALL;
INSERT INTO `item_basic` VALUES (@STARFALL,0,'starfall','starfall',1,@ITEM_EQDEF,@AH_CLUB,1,0);

DELETE FROM `item_equipment` WHERE itemId = @STARFALL;
INSERT INTO `item_equipment` VALUES (@STARFALL,'starfall',73,0,@WHM+@PLD+@GEO,360,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @STARFALL;
INSERT INTO `item_weapon` VALUES (@STARFALL,'starfall',@SKILL_CLUB,0,0,0,0,@DMG_PIERCING,1,340,49,0);

DELETE FROM `item_mods` WHERE itemId = @STARFALL;
INSERT INTO `item_mods` VALUES
    (@STARFALL, @MOD_MP,  25),
    (@STARFALL, @MOD_STR,  5),
    (@STARFALL, @MOD_MND,  5),
    (@STARFALL, @MOD_ATT, 10);

SET @STARFALL_P1 = 21130;
DELETE FROM `item_basic` WHERE itemid = @STARFALL_P1;
INSERT INTO `item_basic` VALUES (@STARFALL_P1,0,'starfall_+1','starfall_+1',1,@ITEM_EQDEF,@AH_CLUB,1,0);

DELETE FROM `item_equipment` WHERE itemId = @STARFALL_P1;
INSERT INTO `item_equipment` VALUES (@STARFALL_P1,'starfall_+1',73,0,@WHM+@PLD+@GEO,360,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @STARFALL_P1;
INSERT INTO `item_weapon` VALUES (@STARFALL_P1,'starfall_+1',@SKILL_CLUB,0,0,0,0,@DMG_PIERCING,1,334,50,0);

DELETE FROM `item_mods` WHERE itemId = @STARFALL_P1;
INSERT INTO `item_mods` VALUES
    (@STARFALL_P1, @MOD_MP,  30),
    (@STARFALL_P1, @MOD_STR,  6),
    (@STARFALL_P1, @MOD_MND,  6),
    (@STARFALL_P1, @MOD_ATT, 15);

SET @STARFALL_SYNTH    = 80038;
SET @BZTAVIAN_STINGER  = 3980;
SET @DARKSTEEL_MAUL_P1 = 17432;
DELETE FROM `synth_recipes` WHERE Result = @STARFALL;
INSERT INTO `synth_recipes` VALUES (
    @STARFALL_SYNTH,0,0,
    0,0,113,0,  -- Wood/Smith/Gold/Cloth
    0,0,60,0,   -- Leather/Bone/Alchemy/Cooking
    @LIGHT_CRYSTAL,@AURORA_CRYSTAL,
        @URUNDAY_LUMBER,@BZTAVIAN_STINGER,@GOBLIN_POWDER,@DARKSTEEL_MAUL_P1,0,0,0,0, -- Materials
    @STARFALL,@STARFALL_P1,@STARFALL_P1,@STARFALL_P1,1,1,1,1,'Starfall'              -- Results
);

-----------------------------------
-- Allied Incursion (Crystal Warrior)
-----------------------------------
-- Beastman Banner
SET @BEASTMAN_BANNER = 3950;
DELETE FROM `item_basic` WHERE itemId = @BEASTMAN_BANNER;
INSERT INTO `item_basic` VALUES (@BEASTMAN_BANNER,0,'beastman_banner','beastman_banner',12,@ITEM_EX,0,1,0);

-- Orcish Chain
SET @ORCISH_CHAIN = 3012; -- (Icon: Darksteel Chain)
DELETE FROM `item_basic` WHERE itemId = @ORCISH_CHAIN;
INSERT INTO `item_basic` VALUES (@ORCISH_CHAIN,0,'orcish_chain','orcish_chain',99,@ITEM_EX,0,1,0);

-- Quadav Chain
SET @QUADAV_CHAIN = 3013; -- (Icon: Brass Chain)
DELETE FROM `item_basic` WHERE itemId = @QUADAV_CHAIN;
INSERT INTO `item_basic` VALUES (@QUADAV_CHAIN,0,'quadav_chain','quadav_chain',99,@ITEM_EX,0,1,0);

-- Yagudo Chain
SET @YAGUDO_CHAIN = 3014; -- (Icon: Silver Chain)
DELETE FROM `item_basic` WHERE itemId = @YAGUDO_CHAIN;
INSERT INTO `item_basic` VALUES (@YAGUDO_CHAIN,0,'yagudo_chain','yagudo_chain',99,@ITEM_EX,0,1,0);

-- Orcish Steel
SET @ORCISH_STEEL = 3951; -- (Icon: Darksteel Sheet)
DELETE FROM `item_basic` WHERE itemId = @ORCISH_STEEL;
INSERT INTO `item_basic` VALUES (@ORCISH_STEEL,0,'orcish_steel','orcish_steel',99,@ITEM_EX,0,1,0);

-- Quadav Brass
SET @QUADAV_BRASS = 3952; -- (Icon: Brass Sheet)
DELETE FROM `item_basic` WHERE itemId = @QUADAV_BRASS;
INSERT INTO `item_basic` VALUES (@QUADAV_BRASS,0,'quadav_brass','quadav_brass',99,@ITEM_EX,0,1,0);

-- Yagudo Silver
SET @YAGUDO_SILVER = 3953; -- (Icon: Silver Sheet)
DELETE FROM `item_basic` WHERE itemId = @YAGUDO_SILVER;
INSERT INTO `item_basic` VALUES (@YAGUDO_SILVER,0,'yagudo_silver','yagudo_silver',99,@ITEM_EX,0,1,0);

-- Orcish Leather
SET @ORCISH_LEATHER = 3954; -- (Icon: Ram Leather)
DELETE FROM `item_basic` WHERE itemId = @ORCISH_LEATHER;
INSERT INTO `item_basic` VALUES (@ORCISH_LEATHER,0,'orcish_leather','orcish_leather',12,@ITEM_EX,0,1,0);

-- Quadav Thread
SET @QUADAV_THREAD = 3955; -- (Icon: Gold Thread)
DELETE FROM `item_basic` WHERE itemId = @QUADAV_THREAD;
INSERT INTO `item_basic` VALUES (@QUADAV_THREAD,0,'quadav_thread','quadav_thread',12,@ITEM_EX,0,1,0);

-- Yagudo Cloth
SET @YAGUDO_CLOTH = 3956; -- (Icon: Silk Cloth)
DELETE FROM `item_basic` WHERE itemId = @YAGUDO_CLOTH;
INSERT INTO `item_basic` VALUES (@YAGUDO_CLOTH,0,'yagudo_cloth','yagudo_cloth',12,@ITEM_EX,0,1,0);

-- Garrison Sallet +1
SET @GARRISON_SALLET_P1 = 25567;
DELETE FROM `item_basic` WHERE itemid = @GARRISON_SALLET_P1;
INSERT INTO `item_basic` VALUES (@GARRISON_SALLET_P1,0,'garrison_sallet_+1','garrison_sallet_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @GARRISON_SALLET_P1;
INSERT INTO `item_equipment` VALUES (@GARRISON_SALLET_P1,'garrison_sallet_+1',20,0,@ALL_JOBS,2,0,0,@SLOT_HEAD,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @GARRISON_SALLET_P1;
INSERT INTO `item_mods` VALUES
    (@GARRISON_SALLET_P1, @MOD_DEF, 8),
    (@GARRISON_SALLET_P1, @MOD_HP,  6),
    (@GARRISON_SALLET_P1, @MOD_MND, 2),
    (@GARRISON_SALLET_P1, @MOD_CHR, 2);

DELETE FROM `item_latents` WHERE itemid = @GARRISON_SALLET_P1;
INSERT INTO `item_latents` VALUES (@GARRISON_SALLET_P1,@MOD_REGEN,1,@MOD_UNDER_LEVEL,51);

-- Garrison Tunica +1
SET @GARRISON_TUNICA_P1 = 26543;
DELETE FROM `item_basic` WHERE itemid = @GARRISON_TUNICA_P1;
INSERT INTO `item_basic` VALUES (@GARRISON_TUNICA_P1,0,'garrison_tunica_+1','garrison_tunica_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @GARRISON_TUNICA_P1;
INSERT INTO `item_equipment` VALUES (@GARRISON_TUNICA_P1,'garrison_tunica_+1',20,0,@ALL_JOBS,104,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @GARRISON_TUNICA_P1;
INSERT INTO `item_mods` VALUES
    (@GARRISON_TUNICA_P1, @MOD_DEF, 18),
    (@GARRISON_TUNICA_P1, @MOD_MP,  10),
    (@GARRISON_TUNICA_P1, @MOD_DEX,  2),
    (@GARRISON_TUNICA_P1, @MOD_CHR,  2);

DELETE FROM `item_latents` WHERE itemid = @GARRISON_TUNICA_P1;
INSERT INTO `item_latents` VALUES (@GARRISON_TUNICA_P1,@MOD_REFRESH,1,@MOD_UNDER_LEVEL,51);

-- Garrison Gloves +1
SET @GARRISON_GLOVES_P1 = 25994;
DELETE FROM `item_basic` WHERE itemid = @GARRISON_GLOVES_P1;
INSERT INTO `item_basic` VALUES (@GARRISON_GLOVES_P1,0,'garrison_gloves_+1','garrison_gloves_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @GARRISON_GLOVES_P1;
INSERT INTO `item_equipment` VALUES (@GARRISON_GLOVES_P1,'garrison_gloves_+1',20,0,@ALL_JOBS,104,0,0,@SLOT_HANDS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @GARRISON_GLOVES_P1;
INSERT INTO `item_mods` VALUES
    (@GARRISON_GLOVES_P1, @MOD_DEF, 6),
    (@GARRISON_GLOVES_P1, @MOD_MP,  5),
    (@GARRISON_GLOVES_P1, @MOD_VIT, 2),
    (@GARRISON_GLOVES_P1, @MOD_INT, 2),
    (@GARRISON_GLOVES_P1, @MOD_HHP, 2);

-- Garrison Hose +1
SET @GARRISON_HOSE_P1 = 25907;
DELETE FROM `item_basic` WHERE itemid = @GARRISON_HOSE_P1;
INSERT INTO `item_basic` VALUES (@GARRISON_HOSE_P1,0,'garrison_hose_+1','garrison_hose_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @GARRISON_HOSE_P1;
INSERT INTO `item_equipment` VALUES (@GARRISON_HOSE_P1,'garrison_hose_+1',20,0,@ALL_JOBS,105,0,0,@SLOT_LEGS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @GARRISON_HOSE_P1;
INSERT INTO `item_mods` VALUES
    (@GARRISON_HOSE_P1, @MOD_DEF, 12),
    (@GARRISON_HOSE_P1, @MOD_HP,   8),
    (@GARRISON_HOSE_P1, @MOD_STR,  2),
    (@GARRISON_HOSE_P1, @MOD_DEX,  2);

DELETE FROM `item_latents` WHERE itemid = @GARRISON_HOSE_P1;
INSERT INTO `item_latents` VALUES (@GARRISON_HOSE_P1,@MOD_HASTE,2,@MOD_UNDER_LEVEL,51);

-- Garrison Boots +1
SET @GARRISON_BOOTS_P1 = 25974;
DELETE FROM `item_basic` WHERE itemid = @GARRISON_BOOTS_P1;
INSERT INTO `item_basic` VALUES (@GARRISON_BOOTS_P1,0,'garrison_boots_+1','garrison_boots_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @GARRISON_BOOTS_P1;
INSERT INTO `item_equipment` VALUES (@GARRISON_BOOTS_P1,'garrison_boots_+1',20,0,@ALL_JOBS,105,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @GARRISON_BOOTS_P1;
INSERT INTO `item_mods` VALUES
    (@GARRISON_BOOTS_P1, @MOD_DEF, 6),
    (@GARRISON_BOOTS_P1, @MOD_HP,  5),
    (@GARRISON_BOOTS_P1, @MOD_INT, 2),
    (@GARRISON_BOOTS_P1, @MOD_MND, 2),
    (@GARRISON_BOOTS_P1, @MOD_HMP, 2);

-----------------------------------
-- Fort Ghelsba (Allied Incursion)
-----------------------------------
SET @DRUIDS_ROBE = 28167; -- (Icon: Wool Robe +1)
DELETE FROM `item_basic` WHERE itemid = @DRUIDS_ROBE;
INSERT INTO `item_basic` VALUES (@DRUIDS_ROBE,0,'druids_robe','druids_robe',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DRUIDS_ROBE;
INSERT INTO `item_equipment` VALUES (@DRUIDS_ROBE,'druids_robe',8,0,@WHM+@BLM+@RDM+@SMN+@SCH+@GEO,18,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DRUIDS_ROBE;
INSERT INTO `item_mods` VALUES
    (@DRUIDS_ROBE, @MOD_DEF,          10),
    (@DRUIDS_ROBE, @MOD_MP,            5);

SET @TRIBAL_EARRING = 28343; -- (Icon: Pennon Earring +1)
DELETE FROM `item_basic` WHERE itemid = @TRIBAL_EARRING;
INSERT INTO `item_basic` VALUES (@TRIBAL_EARRING,0,'tribal_earring','tribal_earring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TRIBAL_EARRING;
INSERT INTO `item_equipment` VALUES (@TRIBAL_EARRING,'tribal_earring',20,0,@ALL_JOBS,0,0,0,@SLOT_EAR,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TRIBAL_EARRING;
INSERT INTO `item_mods` VALUES
    (@TRIBAL_EARRING, @MOD_DEF,           1),
    (@TRIBAL_EARRING, @MOD_VIT,           1),
    (@TRIBAL_EARRING, @MOD_AXE_SKILL,     2),
    (@TRIBAL_EARRING, @MOD_POLEARM_SKILL, 2);

-- Orcish Axegrip
SET @ORCISH_AXEGRIP = 20844;
DELETE FROM `item_basic` WHERE itemid = @ORCISH_AXEGRIP;
INSERT INTO `item_basic` VALUES (@ORCISH_AXEGRIP,0,'orcish_axegrip','orcish_axegrip',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ORCISH_AXEGRIP;
INSERT INTO `item_equipment` VALUES (@ORCISH_AXEGRIP,'orcish_axegrip',20,0,@WAR+@DRK+@BST+@RNG+@RUN,0,0,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @ORCISH_AXEGRIP;

DELETE FROM `item_mods` WHERE itemId = @ORCISH_AXEGRIP;
INSERT INTO `item_mods` VALUES
    (@ORCISH_AXEGRIP, @MOD_HP,               12),
    (@ORCISH_AXEGRIP, @MOD_PHYS_DMG_TAKEN, -200);

-----------------------------------
-- Palborough Mines (Allied Incursion)
-----------------------------------
SET @COARSE_BREASTPLATE = 27739; -- (Icon: Breastplate +1)
DELETE FROM `item_basic` WHERE itemid = @COARSE_BREASTPLATE;
INSERT INTO `item_basic` VALUES (@COARSE_BREASTPLATE,0,'coarse_breastplate','coarse_breastplate',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @COARSE_BREASTPLATE;
INSERT INTO `item_equipment` VALUES (@COARSE_BREASTPLATE,'coarse_breastplate',8,0,@WAR+@DRK+@PLD+@RUN,2,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @COARSE_BREASTPLATE;
INSERT INTO `item_mods` VALUES
    (@COARSE_BREASTPLATE, @MOD_DEF, 14),
    (@COARSE_BREASTPLATE, @MOD_EVA, -3);

SET @TERRAPIN_TRAITOR = 20597; -- (Icon: Yataghan +1)
DELETE FROM `item_basic` WHERE itemid = @TERRAPIN_TRAITOR;
INSERT INTO `item_basic` VALUES (@TERRAPIN_TRAITOR,0,'terrapin_traitor','terrapin_traitor',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TERRAPIN_TRAITOR;
INSERT INTO `item_equipment` VALUES (@TERRAPIN_TRAITOR,'terrapin_traitor',20,0,@THF+@BRD+@RNG+@COR+@DNC,450,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @TERRAPIN_TRAITOR;
INSERT INTO `item_weapon` VALUES (@TERRAPIN_TRAITOR,'terrapin_traitor',@SKILL_DAGGER,0,0,0,0,1,1,201,5,0);

DELETE FROM `item_mods` WHERE itemId = @TERRAPIN_TRAITOR;
DELETE FROM `item_latents` WHERE itemId = @TERRAPIN_TRAITOR;
INSERT INTO `item_latents` VALUES (@TERRAPIN_TRAITOR,@MOD_OCCASIONALLY_ATTACKS,2,@MOD_UNDER_LEVEL,50);

-- Pixie Shield
SET @PIXIE_SHIELD = 27737;
DELETE FROM `item_basic` WHERE itemid = @PIXIE_SHIELD;
INSERT INTO `item_basic` VALUES (@PIXIE_SHIELD,0,'pixie_shield','pixie_shield',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @PIXIE_SHIELD;
INSERT INTO `item_equipment` VALUES (@PIXIE_SHIELD,'pixie_shield',20,0,@WHM+@BLM+@RDM+@SMN+@SCH+@GEO,35,2,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @PIXIE_SHIELD;
INSERT INTO `item_mods` VALUES
    (@PIXIE_SHIELD, @MOD_DEF,  5),
    (@PIXIE_SHIELD, @MOD_MP,  15),
    (@PIXIE_SHIELD, @MOD_INT,  1),
    (@PIXIE_SHIELD, @MOD_MND,  2);

-----------------------------------
-- Giddeus (Allied Incursion)
-----------------------------------
-- Sniper's Shroud
SET @SNIPERS_SHROUD = 28028; -- (Icon: Marid Mantle +1)
DELETE FROM `item_basic` WHERE itemid = @SNIPERS_SHROUD;
INSERT INTO `item_basic` VALUES (@SNIPERS_SHROUD,0,'snipers_shroud','snipers_shroud',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SNIPERS_SHROUD;
INSERT INTO `item_equipment` VALUES (@SNIPERS_SHROUD,'snipers_shroud',8,0,@THF+@RNG+@COR,0,0,0,@SLOT_BACK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SNIPERS_SHROUD;
INSERT INTO `item_mods` VALUES
    (@SNIPERS_SHROUD, @MOD_DEF,        2),
    (@SNIPERS_SHROUD, @MOD_STR,        1),
    (@SNIPERS_SHROUD, @MOD_RATT,       1);

-- Gambler's Chapeau
SET @GAMBLERS_CHAPEAU = 27780; -- (Icon: Baron's Chapeau)
DELETE FROM `item_basic` WHERE itemid = @GAMBLERS_CHAPEAU;
INSERT INTO `item_basic` VALUES (@GAMBLERS_CHAPEAU,0,'gamblers_chapeau','gamblers_chapeau',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @GAMBLERS_CHAPEAU;
INSERT INTO `item_equipment` VALUES (@GAMBLERS_CHAPEAU,'gamblers_chapeau',20,0,@WHM+@BLM+@RDM+@DRK+@BRD+@SMN+@BLU+@COR+@SCH+@GEO+@RUN,161,0,0,@SLOT_HEAD,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @GAMBLERS_CHAPEAU;
INSERT INTO `item_mods` VALUES
    (@GAMBLERS_CHAPEAU, @MOD_DEF,        9),
    (@GAMBLERS_CHAPEAU, @MOD_MP,        20),
    (@GAMBLERS_CHAPEAU, @MOD_INT,        3);

-- Pegasus Collar
SET @PEGASUS_COLLAR = 28610;
DELETE FROM `item_basic` WHERE itemid = @PEGASUS_COLLAR;
INSERT INTO `item_basic` VALUES (@PEGASUS_COLLAR,0,'pegasus_collar','pegasus_collar',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @PEGASUS_COLLAR;
INSERT INTO `item_equipment` VALUES (@PEGASUS_COLLAR,'pegasus_collar',20,0,@BRD+@COR,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @PEGASUS_COLLAR;
INSERT INTO `item_mods` VALUES
    (@PEGASUS_COLLAR, @MOD_DEF,        3),
    (@PEGASUS_COLLAR, @MOD_CHR,        3),
    (@PEGASUS_COLLAR, @MOD_AGI,        3),
    (@PEGASUS_COLLAR, @MOD_MOVESPEED, 12);

-----------------------------------
-- Davoi (Allied Incursion)
-----------------------------------
-- Hunter's Shawl
SET @HUNTERS_SHAWL = 10992; -- (Icon: Behem. Mantle +1)
DELETE FROM `item_basic` WHERE itemid = @HUNTERS_SHAWL;
INSERT INTO `item_basic` VALUES (@HUNTERS_SHAWL,0,'hunters_shawl','hunters_shawl',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HUNTERS_SHAWL;
INSERT INTO `item_equipment` VALUES (@HUNTERS_SHAWL,'hunters_shawl',30,0,@THF+@RNG+@COR,0,0,0,@SLOT_BACK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HUNTERS_SHAWL;
INSERT INTO `item_mods` VALUES
    (@HUNTERS_SHAWL, @MOD_DEF,        3),
    (@HUNTERS_SHAWL, @MOD_STR,        2),
    (@HUNTERS_SHAWL, @MOD_AGI,        2),
    (@HUNTERS_SHAWL, @MOD_RATT,       3),
    (@HUNTERS_SHAWL, @MOD_RACC,       3);

-- Illusionist's Garb
SET @ILLUSIONISTS_GARB = 10467; -- (Icon: Mage's Robe)
DELETE FROM `item_basic` WHERE itemid = @ILLUSIONISTS_GARB;
INSERT INTO `item_basic` VALUES (@ILLUSIONISTS_GARB,0,'illusionists_garb','illusionists_garb',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ILLUSIONISTS_GARB;
INSERT INTO `item_equipment` VALUES (@ILLUSIONISTS_GARB,'illusionists_garb',30,0,@WHM+@BLM+@RDM+@SCH+@GEO,18,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @ILLUSIONISTS_GARB;
INSERT INTO `item_mods` VALUES
    (@ILLUSIONISTS_GARB, @MOD_DEF, 19),
    (@ILLUSIONISTS_GARB, @MOD_MP,  15),
    (@ILLUSIONISTS_GARB, @MOD_INT,  2),
    (@ILLUSIONISTS_GARB, @MOD_MND,  2),
    (@ILLUSIONISTS_GARB, @MOD_MATT, 4);

-- Axemaster's Gauntlets
SET @AXEMASTERS_GAUNTLETS = 10515; -- (Icon: Conte Manopolas)
DELETE FROM `item_basic` WHERE itemid = @AXEMASTERS_GAUNTLETS;
INSERT INTO `item_basic` VALUES (@AXEMASTERS_GAUNTLETS,0,'axemasters_gauntlets','axemasters_gauntlets',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @AXEMASTERS_GAUNTLETS;
INSERT INTO `item_equipment` VALUES (@AXEMASTERS_GAUNTLETS,'axemasters_gauntlets',30,0,@WAR+@DRK+@BST+@RUN,136,0,0,@SLOT_HANDS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @AXEMASTERS_GAUNTLETS;
INSERT INTO `item_mods` VALUES
    (@AXEMASTERS_GAUNTLETS, @MOD_DEF,       12),
    (@AXEMASTERS_GAUNTLETS, @MOD_HASTE,      2),
    (@AXEMASTERS_GAUNTLETS, @MOD_AXE_SKILL,  7);

-----------------------------------
-- Beadeaux (Allied Incursion)
-----------------------------------
-- Curate's Earring
SET @CURATES_EARRING = 11051; -- (Icon: Wisdom Earring)
DELETE FROM `item_basic` WHERE itemid = @CURATES_EARRING;
INSERT INTO `item_basic` VALUES (@CURATES_EARRING,0,'curates_earring','curates_earring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @CURATES_EARRING;
INSERT INTO `item_equipment` VALUES (@CURATES_EARRING,'curates_earring',30,0,@WHM+@RDM+@SMN+@SCH+@GEO,0,0,0,@SLOT_EAR,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @CURATES_EARRING;
INSERT INTO `item_mods` VALUES
    (@CURATES_EARRING, @MOD_MP,           10),
    (@CURATES_EARRING, @MOD_MND,           1),
    (@CURATES_EARRING, @MOD_CURE_POTENCY,  2),
    (@CURATES_EARRING, @MOD_STAFF_SKILL,   2);

-- Bruiser's Cloak
SET @BRUISERS_CLOAK = 10993; -- (Icon: Felicitas Cape +1)
DELETE FROM `item_basic` WHERE itemid = @BRUISERS_CLOAK;
INSERT INTO `item_basic` VALUES (@BRUISERS_CLOAK,0,'bruisers_cloak','bruisers_cloak',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BRUISERS_CLOAK;
INSERT INTO `item_equipment` VALUES (@BRUISERS_CLOAK,'bruisers_cloak',30,0,@MNK+@PUP,0,0,0,@SLOT_BACK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @BRUISERS_CLOAK;
INSERT INTO `item_mods` VALUES
    (@BRUISERS_CLOAK, @MOD_DEF,        3),
    (@BRUISERS_CLOAK, @MOD_STR,        2),
    (@BRUISERS_CLOAK, @MOD_HASTE,      2),
    (@BRUISERS_CLOAK, @MOD_HTH_SKILL,  5);

-- Revenge
SET @REVENGE = 22119; -- (Icon: Staurobow +1)
DELETE FROM `item_basic` WHERE itemid = @REVENGE;
INSERT INTO `item_basic` VALUES (@REVENGE,0,'revenge','revenge',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @REVENGE;
INSERT INTO `item_equipment` VALUES (@REVENGE,'revenge',30,0,@WAR+@THF+@DRK+@RNG,62,0,0,4,0,0,0);

DELETE FROM `item_weapon` WHERE itemid = @REVENGE;
INSERT INTO `item_weapon` VALUES (@REVENGE,'revenge',@SKILL_MARKSMANSHIP,@SUBSKILL_CROSSBOW,0,0,0,@DMG_PIERCING,1,280,25,0);

DELETE FROM `item_mods` WHERE itemId = @REVENGE;
INSERT INTO `item_mods` VALUES
    (@REVENGE, @MOD_HP,         12),
    (@REVENGE, @MOD_STR,         3),
    (@REVENGE, @MOD_RATT,       12),
    (@REVENGE, @MOD_RAPID_SHOT,  3),
    (@REVENGE, @MOD_DUAL_WIELD,  5);

-----------------------------------
-- Castle Oztroja (Allied Incursion)
-----------------------------------
-- Yoiyami
SET @YOIYAMI = 21905; -- (Icon: Kunai +1)
DELETE FROM `item_basic` WHERE itemid = @YOIYAMI;
INSERT INTO `item_basic` VALUES (@YOIYAMI,0,'yoiyami','yoiyami',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @YOIYAMI;
INSERT INTO `item_equipment` VALUES (@YOIYAMI,'yoiyami',30,0,@NIN,315,0,0,3,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @YOIYAMI;
INSERT INTO `item_weapon` VALUES (@YOIYAMI,'yoiyami',@SKILL_KATANA,0,0,0,0,@DMG_SLASHING,1,120,12,0);

DELETE FROM `item_mods` WHERE itemId = @YOIYAMI;
INSERT INTO `item_mods` VALUES
    (@YOIYAMI, @MOD_DEX,         3),
    (@YOIYAMI, @MOD_ATT,         5),
    (@YOIYAMI, @MOD_DUAL_WIELD,  3);

-- Chaplain's Ring
SET @CHAPLAINS_RING = 10787; -- (Icon: Heavens Ring)
DELETE FROM `item_basic` WHERE itemid = @CHAPLAINS_RING;
INSERT INTO `item_basic` VALUES (@CHAPLAINS_RING,0,'chaplains_ring','chaplains_ring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @CHAPLAINS_RING;
INSERT INTO `item_equipment` VALUES (@CHAPLAINS_RING,'chaplains_ring',30,0,@WHM+@BLU+@SCH+@GEO,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @CHAPLAINS_RING;
INSERT INTO `item_mods` VALUES
    (@CHAPLAINS_RING, @MOD_MP,           15),
    (@CHAPLAINS_RING, @MOD_MND,           3),
    (@CHAPLAINS_RING, @MOD_ACC,           4),
    (@CHAPLAINS_RING, @MOD_CLUB_SKILL,    3);

-- Heroic Hairpin
SET @HEROIC_HAIRPIN = 10893; -- (Icon: Wivre Hairpin +1)
DELETE FROM `item_basic` WHERE itemid = @HEROIC_HAIRPIN;
INSERT INTO `item_basic` VALUES (@HEROIC_HAIRPIN,0,'heroic_hairpin','heroic_hairpin',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HEROIC_HAIRPIN;
INSERT INTO `item_equipment` VALUES (@HEROIC_HAIRPIN,'heroic_hairpin',30,0,@ALL_JOBS,0,0,0,@SLOT_HEAD,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @HEROIC_HAIRPIN;
INSERT INTO `item_mods` VALUES
    (@HEROIC_HAIRPIN, @MOD_HP,               15),
    (@HEROIC_HAIRPIN, @MOD_HASTE,           200),
    (@HEROIC_HAIRPIN, @MOD_PHYS_DMG_TAKEN, -200),
    (@HEROIC_HAIRPIN, @MOD_DUAL_WIELD,        3);

-----------------------------------
-- CW Ultimate Weapon - Hand-to-Hand (MNK/PUP)
-----------------------------------
SET @WORN_KNUCKLES = 2984;
DELETE FROM `item_basic` WHERE itemid = @WORN_KNUCKLES;
INSERT INTO `item_basic` VALUES (@WORN_KNUCKLES,0,'worn_knuckles','worn_knuckles',1,@ITEM_RARE,0,1,0);

-- Hand-to-Hand Tier I
SET @PERSUASION = 21510; -- (Icon: Bastokan Knuckles)
DELETE FROM `item_basic` WHERE itemid = @PERSUASION;
INSERT INTO `item_basic` VALUES (@PERSUASION,0,'persuasion','persuasion',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @PERSUASION;
INSERT INTO `item_equipment` VALUES (@PERSUASION,'persuasion',20,0,@MNK+@PUP,131,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @PERSUASION;
INSERT INTO `item_weapon` VALUES (@PERSUASION,'persuasion',@SKILL_HAND_TO_HAND,0,0,0,0,@DMG_IMPACT,1,576,12,0);

DELETE FROM `item_mods` WHERE itemId = @PERSUASION;
INSERT INTO `item_mods` VALUES
    (@PERSUASION, @MOD_STR,                                3),
    (@PERSUASION, @MOD_ACC,                                5),
    (@PERSUASION, @MOD_GUARD_SKILL,                        5),
    (@PERSUASION, @MOD_ITEM_ADDEFFECT_TYPE,                1),
    (@PERSUASION, @MOD_ITEM_SUBEFFECT,         @ELEMENT_FIRE),
    (@PERSUASION, @MOD_ITEM_ADDEFFECT_DMG,                10),
    (@PERSUASION, @MOD_ITEM_ADDEFFECT_CHANCE,             10),
    (@PERSUASION, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_FIRE);

DELETE FROM `item_mods_pet` WHERE itemId = @PERSUASION;
INSERT INTO `item_mods_pet` VALUES
    (@PERSUASION, @MOD_ACC,    5, @PET_ALL),
    (@PERSUASION, @MOD_ENMITY, 3, @PET_ALL);

DELETE FROM `item_latents` WHERE itemId = @PERSUASION;
INSERT INTO `item_latents` VALUES (@PERSUASION,@MOD_WEAPON_DMG,2,@MOD_ABOVE_LEVEL,29);

-- Hand-to-Hand Tier II
SET @PERSUASION_P1 = 20531; -- (Icon: Republic Knuckles)
DELETE FROM `item_basic` WHERE itemid = @PERSUASION_P1;
INSERT INTO `item_basic` VALUES (@PERSUASION_P1,0,'persuasion_+1','persuasion_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @PERSUASION_P1;
INSERT INTO `item_equipment` VALUES (@PERSUASION_P1,'persuasion_+1',50,0,@MNK+@PUP,131,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @PERSUASION_P1;
INSERT INTO `item_weapon` VALUES (@PERSUASION_P1,'persuasion_+1',@SKILL_HAND_TO_HAND,0,0,0,0,@DMG_IMPACT,1,576,20,0);

DELETE FROM `item_mods` WHERE itemId = @PERSUASION_P1;
INSERT INTO `item_mods` VALUES
    (@PERSUASION_P1, @MOD_STR,                                5),
    (@PERSUASION_P1, @MOD_ACC,                                8),
    (@PERSUASION_P1, @MOD_GUARD_SKILL,                        8),
    (@PERSUASION_P1, @MOD_COUNTER,                            5),
    (@PERSUASION_P1, @MOD_ITEM_ADDEFFECT_TYPE,                1),
    (@PERSUASION_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_FIRE),
    (@PERSUASION_P1, @MOD_ITEM_ADDEFFECT_DMG,                15),
    (@PERSUASION_P1, @MOD_ITEM_ADDEFFECT_CHANCE,             15),
    (@PERSUASION_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_FIRE);

DELETE FROM `item_mods_pet` WHERE itemId = @PERSUASION;
INSERT INTO `item_mods_pet` VALUES
    (@PERSUASION, @MOD_ACC,    8, @PET_ALL),
    (@PERSUASION, @MOD_ENMITY, 5, @PET_ALL);

DELETE FROM `item_latents` WHERE itemId = @PERSUASION;
INSERT INTO `item_latents` VALUES (@PERSUASION,@MOD_WEAPON_DMG,2,@MOD_ABOVE_LEVEL,59);


-----------------------------------
-- CW Ultimate Weapon - Sword (PLD/BLU)
-----------------------------------
SET @WORN_SWORD = 2985;
DELETE FROM `item_basic` WHERE itemid = @WORN_SWORD;
INSERT INTO `item_basic` VALUES (@WORN_SWORD,0,'worn_sword','worn_sword',1,@ITEM_RARE,0,1,0);

-- Longsword Tier I
SET @FEALTY = 22219; -- (Icon: Shamshir +1)
DELETE FROM `item_basic` WHERE itemid = @FEALTY;
INSERT INTO `item_basic` VALUES (@FEALTY,0,'fealty','fealty',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @FEALTY;
INSERT INTO `item_equipment` VALUES (@FEALTY,'fealty',20,0,@PLD+@BLU,253,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @FEALTY;
INSERT INTO `item_weapon` VALUES (@FEALTY,'fealty',@SKILL_SWORD,0,0,0,0,@DMG_SLASHING,1,240,20,0);

DELETE FROM `item_mods` WHERE itemId = @FEALTY;
INSERT INTO `item_mods` VALUES
    (@FEALTY, @MOD_DEF,                                10),
    (@FEALTY, @MOD_STR,                                 3),
    (@FEALTY, @MOD_VIT,                                 3),
    (@FEALTY, @MOD_ACC,                                 5),
    (@FEALTY, @MOD_SPELL_INTERRUPT,                     5),
    (@FEALTY, @MOD_ITEM_ADDEFFECT_TYPE,                 1),
    (@FEALTY, @MOD_ITEM_SUBEFFECT,         @ELEMENT_EARTH),
    (@FEALTY, @MOD_ITEM_ADDEFFECT_DMG,                 10),
    (@FEALTY, @MOD_ITEM_ADDEFFECT_CHANCE,              10),
    (@FEALTY, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_EARTH);

DELETE FROM `item_latents` WHERE itemId = @FEALTY;
INSERT INTO `item_latents` VALUES (@FEALTY,@MOD_WEAPON_DMG,8,@MOD_ABOVE_LEVEL,29);

-- Longsword Tier II
SET @FEALTY_P1 = 20719; -- (Icon: Shamshir +2)
DELETE FROM `item_basic` WHERE itemid = @FEALTY_P1;
INSERT INTO `item_basic` VALUES (@FEALTY_P1,0,'fealty_+1','fealty_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @FEALTY_P1;
INSERT INTO `item_equipment` VALUES (@FEALTY_P1,'fealty_+1',50,0,@PLD+@BLU,253,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @FEALTY_P1;
INSERT INTO `item_weapon` VALUES (@FEALTY_P1,'fealty_+1',@SKILL_SWORD,0,0,0,0,@DMG_SLASHING,1,240,40,0);

DELETE FROM `item_mods` WHERE itemId = @FEALTY_P1;
INSERT INTO `item_mods` VALUES
    (@FEALTY_P1, @MOD_DEF,                                12),
    (@FEALTY_P1, @MOD_STR,                                 5),
    (@FEALTY_P1, @MOD_VIT,                                 5),
    (@FEALTY_P1, @MOD_ACC,                                 8),
    (@FEALTY_P1, @MOD_PARRYING_RATE,                       3),
    (@FEALTY_P1, @MOD_SPELL_INTERRUPT,                    10),
    (@FEALTY_P1, @MOD_DUAL_WIELD,                          3),
    (@FEALTY_P1, @MOD_ITEM_ADDEFFECT_TYPE,                 1),
    (@FEALTY_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_EARTH),
    (@FEALTY_P1, @MOD_ITEM_ADDEFFECT_DMG,                 15),
    (@FEALTY_P1, @MOD_ITEM_ADDEFFECT_CHANCE,              15),
    (@FEALTY_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_EARTH);

DELETE FROM `item_latents` WHERE itemId = @FEALTY_P1;
INSERT INTO `item_latents` VALUES (@FEALTY_P1,@MOD_WEAPON_DMG,8,@MOD_ABOVE_LEVEL,59);


-----------------------------------
-- CW Ultimate Weapon - Axe (WAR/BST)
-----------------------------------
SET @WORN_AXE = 2986;
DELETE FROM `item_basic` WHERE itemid = @WORN_AXE;
INSERT INTO `item_basic` VALUES (@WORN_AXE,0,'worn_axe','worn_axe',1,@ITEM_RARE,0,1,0);

-- Axe Tier I
SET @WOODLANDER = 21712; -- (Icon: Bastokan Axe)
DELETE FROM `item_basic` WHERE itemid = @WOODLANDER;
INSERT INTO `item_basic` VALUES (@WOODLANDER,0,'woodlander','woodlander',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @WOODLANDER;
INSERT INTO `item_equipment` VALUES (@WOODLANDER,'woodlander',20,0,@WAR+@BST,78,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @WOODLANDER;
INSERT INTO `item_weapon` VALUES (@WOODLANDER,'woodlander',@SKILL_AXE,0,0,0,0,@DMG_SLASHING,1,276,24,0);

DELETE FROM `item_mods` WHERE itemId = @WOODLANDER;
INSERT INTO `item_mods` VALUES
    (@WOODLANDER, @MOD_ATT,                                 5),
    (@WOODLANDER, @MOD_PHYS_DMG_TAKEN,                   -500),
    (@WOODLANDER, @MOD_ITEM_ADDEFFECT_TYPE,                 1),
    (@WOODLANDER, @MOD_ITEM_SUBEFFECT,         @ELEMENT_EARTH),
    (@WOODLANDER, @MOD_ITEM_ADDEFFECT_DMG,                 10),
    (@WOODLANDER, @MOD_ITEM_ADDEFFECT_CHANCE,              10),
    (@WOODLANDER, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_EARTH);

DELETE FROM `item_mods_pet` WHERE itemId = @WOODLANDER;
INSERT INTO `item_mods_pet` VALUES
    (@WOODLANDER, @MOD_ATT, 5, @PET_ALL);

DELETE FROM `item_latents` WHERE itemId = @WOODLANDER;
INSERT INTO `item_latents` VALUES (@WOODLANDER,@MOD_WEAPON_DMG,8,@MOD_ABOVE_LEVEL,29);

-- Axe Tier II
SET @WOODLANDER_P1 = 20810; -- (Icon: Republic Axe)
DELETE FROM `item_basic` WHERE itemid = @WOODLANDER_P1;
INSERT INTO `item_basic` VALUES (@WOODLANDER_P1,0,'woodlander_+1','woodlander_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @WOODLANDER_P1;
INSERT INTO `item_equipment` VALUES (@WOODLANDER_P1,'woodlander_+1',50,0,@WAR+@BST,78,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @WOODLANDER_P1;
INSERT INTO `item_weapon` VALUES (@WOODLANDER_P1,'woodlander_+1',@SKILL_AXE,0,0,0,0,@DMG_SLASHING,1,276,42,0);

DELETE FROM `item_mods` WHERE itemId = @WOODLANDER;
INSERT INTO `item_mods` VALUES
    (@WOODLANDER_P1, @MOD_ATT,                                15),
    (@WOODLANDER_P1, @MOD_PHYS_DMG_TAKEN,                  -1000),
    (@WOODLANDER_P1, @MOD_ITEM_ADDEFFECT_TYPE,                 1),
    (@WOODLANDER_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_EARTH),
    (@WOODLANDER_P1, @MOD_ITEM_ADDEFFECT_DMG,                 10),
    (@WOODLANDER_P1, @MOD_ITEM_ADDEFFECT_CHANCE,              10),
    (@WOODLANDER_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_EARTH);

DELETE FROM `item_mods_pet` WHERE itemId = @WOODLANDER_P1;
INSERT INTO `item_mods_pet` VALUES
    (@WOODLANDER_P1, @MOD_ATT, 15, @PET_ALL),
    (@WOODLANDER_P1, @MOD_ACC, 10, @PET_ALL);

DELETE FROM `item_latents` WHERE itemId = @WOODLANDER_P1;
INSERT INTO `item_latents` VALUES (@WOODLANDER_P1,@MOD_WEAPON_DMG,6,@MOD_ABOVE_LEVEL,59);


-----------------------------------
-- CW Ultimate Weapon - Great Axe (WAR)
-----------------------------------
SET @WORN_CHOPPER = 2987;
DELETE FROM `item_basic` WHERE itemid = @WORN_CHOPPER;
INSERT INTO `item_basic` VALUES (@WORN_CHOPPER,0,'worn_chopper','worn_chopper',1,@ITEM_RARE,0,1,0);

-- Great Axe Tier I
SET @SAVAGERY = 21769; -- (Icon: Atlas +1)
DELETE FROM `item_basic` WHERE itemid = @SAVAGERY;
INSERT INTO `item_basic` VALUES (@SAVAGERY,0,'savagery','savagery',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SAVAGERY;
INSERT INTO `item_equipment` VALUES (@SAVAGERY,'savagery',20,0,@WAR,348,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @SAVAGERY;
INSERT INTO `item_weapon` VALUES (@SAVAGERY,'savagery',@SKILL_GREAT_AXE,0,0,0,0,@DMG_SLASHING,1,504,45,0);

DELETE FROM `item_mods` WHERE itemId = @SAVAGERY;
INSERT INTO `item_mods` VALUES
    (@SAVAGERY, @MOD_VIT,                                4),
    (@SAVAGERY, @MOD_ACC,                                5),
    (@SAVAGERY, @MOD_ENMITY,                             3),
    (@SAVAGERY, @MOD_DAMAGE_TAKEN,                    -300),
    (@SAVAGERY, @MOD_PARRYING_RATE,                      2),
    (@SAVAGERY, @MOD_ITEM_ADDEFFECT_TYPE,                1),
    (@SAVAGERY, @MOD_ITEM_SUBEFFECT,         @ELEMENT_WIND),
    (@SAVAGERY, @MOD_ITEM_ADDEFFECT_DMG,                10),
    (@SAVAGERY, @MOD_ITEM_ADDEFFECT_CHANCE,             10),
    (@SAVAGERY, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_WIND);

DELETE FROM `item_latents` WHERE itemId = @SAVAGERY;
INSERT INTO `item_latents` VALUES (@SAVAGERY,@MOD_WEAPON_DMG,16,@MOD_ABOVE_LEVEL,29);

-- Great Axe Tier II
SET @SAVAGERY_P1 = 20859; -- (Icon: Atlas +2)
DELETE FROM `item_basic` WHERE itemid = @SAVAGERY_P1;
INSERT INTO `item_basic` VALUES (@SAVAGERY_P1,0,'savagery_+1','savagery_+',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SAVAGERY_P1;
INSERT INTO `item_equipment` VALUES (@SAVAGERY_P1,'savagery_+1',50,0,@WAR,348,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @SAVAGERY_P1;
INSERT INTO `item_weapon` VALUES (@SAVAGERY_P1,'savagery_+1',@SKILL_GREAT_AXE,0,0,0,0,@DMG_SLASHING,3,504,56,0);

DELETE FROM `item_mods` WHERE itemId = @SAVAGERY_P1;
INSERT INTO `item_mods` VALUES
    (@SAVAGERY_P1, @MOD_VIT,                                8),
    (@SAVAGERY_P1, @MOD_ACC,                                8),
    (@SAVAGERY_P1, @MOD_ENMITY,                             5),
    (@SAVAGERY_P1, @MOD_DAMAGE_TAKEN,                    -500),
    (@SAVAGERY_P1, @MOD_PARRYING_RATE,                      5),
    (@SAVAGERY_P1, @MOD_TACTICAL_PARRY,                     5),
    (@SAVAGERY_P1, @MOD_ITEM_ADDEFFECT_TYPE,                1),
    (@SAVAGERY_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_WIND),
    (@SAVAGERY_P1, @MOD_ITEM_ADDEFFECT_DMG,                15),
    (@SAVAGERY_P1, @MOD_ITEM_ADDEFFECT_CHANCE,             15),
    (@SAVAGERY_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_WIND);

DELETE FROM `item_latents` WHERE itemId = @SAVAGERY;
-- Multi-hit weapons do not have enhanced damage at Lv60+


-----------------------------------
-- CW Ultimate Weapon - Polearm (DRG)
-----------------------------------
SET @WORN_LANCE = 2988;
DELETE FROM `item_basic` WHERE itemid = @WORN_LANCE;
INSERT INTO `item_basic` VALUES (@WORN_LANCE,0,'worn_lance','worn_lance',1,@ITEM_RARE,0,1,0);

-- Polearm Tier I
SET @HEARTPIERCER = 21864; -- (Icon: R.K. Lance +1)
DELETE FROM `item_basic` WHERE itemid = @HEARTPIERCER;
INSERT INTO `item_basic` VALUES (@HEARTPIERCER,0,'heartpiercer','heartpiercer',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HEARTPIERCER;
INSERT INTO `item_equipment` VALUES (@HEARTPIERCER,'heartpiercer',20,0,@DRG,210,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @HEARTPIERCER;
INSERT INTO `item_weapon` VALUES (@HEARTPIERCER,'heartpiercer',@SKILL_POLEARM,0,0,0,0,@DMG_PIERCING,1,492,40,0);

DELETE FROM `item_mods` WHERE itemId = @HEARTPIERCER;
INSERT INTO `item_mods` VALUES
    (@HEARTPIERCER, @MOD_STR,                                   3),
    (@HEARTPIERCER, @MOD_DEX,                                   3),
    (@HEARTPIERCER, @MOD_ATT,                                   6),
    (@HEARTPIERCER, @MOD_STORE_TP,                              3),
    (@HEARTPIERCER, @MOD_ITEM_ADDEFFECT_TYPE,                   1),
    (@HEARTPIERCER, @MOD_ITEM_SUBEFFECT,         @ELEMENT_THUNDER),
    (@HEARTPIERCER, @MOD_ITEM_ADDEFFECT_DMG,                   10),
    (@HEARTPIERCER, @MOD_ITEM_ADDEFFECT_CHANCE,                10),
    (@HEARTPIERCER, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_THUNDER);

DELETE FROM `item_mods_pet` WHERE itemId = @HEARTPIERCER;
INSERT INTO `item_mods_pet` VALUES
    (@HEARTPIERCER, @MOD_ATT,             6, @PET_ALL),
    (@HEARTPIERCER, @MOD_DAMAGE_TAKEN, -500, @PET_ALL);

DELETE FROM `item_latents` WHERE itemId = @HEARTPIERCER;
INSERT INTO `item_latents` VALUES (@HEARTPIERCER,@MOD_WEAPON_DMG,16,@MOD_ABOVE_LEVEL,29);

-- Polearm Tier II
SET @HEARTPIERCER_P1 = 20947; -- (Icon: R.K. Lance +2)
DELETE FROM `item_basic` WHERE itemid = @HEARTPIERCER_P1;
INSERT INTO `item_basic` VALUES (@HEARTPIERCER_P1,0,'heartpiercer_+1','heartpiercer_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HEARTPIERCER_P1;
INSERT INTO `item_equipment` VALUES (@HEARTPIERCER_P1,'heartpiercer_+1',50,0,@DRG,210,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @HEARTPIERCER_P1;
INSERT INTO `item_weapon` VALUES (@HEARTPIERCER_P1,'heartpiercer_+1',@SKILL_POLEARM,0,0,0,0,@DMG_PIERCING,1,492,80,0);

DELETE FROM `item_mods` WHERE itemId = @HEARTPIERCER_P1;
INSERT INTO `item_mods` VALUES
    (@HEARTPIERCER_P1, @MOD_STR,                                   5),
    (@HEARTPIERCER_P1, @MOD_DEX,                                   5),
    (@HEARTPIERCER_P1, @MOD_ATT,                                   8),
    (@HEARTPIERCER_P1, @MOD_STORE_TP,                              5),
    (@HEARTPIERCER_P1, @MOD_WYVERN_BREATH_PROC,                    1), -- Wyvern uses breaths more effectively
    (@HEARTPIERCER_P1, @MOD_ITEM_ADDEFFECT_TYPE,                   1),
    (@HEARTPIERCER_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_THUNDER),
    (@HEARTPIERCER_P1, @MOD_ITEM_ADDEFFECT_DMG,                   15),
    (@HEARTPIERCER_P1, @MOD_ITEM_ADDEFFECT_CHANCE,                15),
    (@HEARTPIERCER_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_THUNDER);

DELETE FROM `item_mods_pet` WHERE itemId = @HEARTPIERCER_P1;
INSERT INTO `item_mods_pet` VALUES
    (@HEARTPIERCER_P1, @MOD_ATT,             10, @PET_ALL),
    (@HEARTPIERCER_P1, @MOD_DAMAGE_TAKEN, -1000, @PET_ALL);

DELETE FROM `item_latents` WHERE itemId = @HEARTPIERCER_P1;
INSERT INTO `item_latents` VALUES (@HEARTPIERCER_P1, @MOD_WEAPON_DMG, 8, @MOD_ABOVE_LEVEL, 59);


-----------------------------------
-- CW Ultimate Weapon - Shield (WAR)
-----------------------------------
SET @WORN_SHIELD = 2989;
DELETE FROM `item_basic` WHERE itemid = @WORN_SHIELD;
INSERT INTO `item_basic` VALUES (@WORN_SHIELD,0,'worn_shield','worn_shield',1,@ITEM_RARE,0,1,0);

-- Shield Tier I
SET @SOLUS = 26413; -- (Icon: T.K. Shield +1)
DELETE FROM `item_basic` WHERE itemid = @SOLUS;
INSERT INTO `item_basic` VALUES (@SOLUS,0,'solus','solus',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SOLUS;
INSERT INTO `item_equipment` VALUES (@SOLUS,'solus',20,0,@WAR,28,3,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SOLUS;
INSERT INTO `item_mods` VALUES
    (@SOLUS, @MOD_DEF,                   10),
    (@SOLUS, @MOD_VIT,                    3),
    (@SOLUS, @MOD_ENMITY,                 5),
    (@SOLUS, @MOD_SHIELD_SKILL,           6),
    (@SOLUS, @MOD_ENMITY_LOSS_REDUCTION,  5);

DELETE FROM `item_latents` WHERE itemId = @SOLUS;
INSERT INTO `item_latents` VALUES (@SOLUS,@MOD_DEF,2,@MOD_ABOVE_LEVEL,29);

-- Shield Tier II
SET @SOLUS_P1 = 27624; -- (Icon: T.K. Shield +2)
DELETE FROM `item_basic` WHERE itemid = @SOLUS_P1;
INSERT INTO `item_basic` VALUES (@SOLUS_P1,0,'solus_+1','solus_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SOLUS_P1;
INSERT INTO `item_equipment` VALUES (@SOLUS_P1,'solus_+1',50,0,@WAR,28,3,0,@SLOT_OFFHAND,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SOLUS_P1;
INSERT INTO `item_mods` VALUES
    (@SOLUS_P1, @MOD_DEF,                   18),
    (@SOLUS_P1, @MOD_VIT,                    5),
    (@SOLUS_P1, @MOD_ENMITY,                 8),
    (@SOLUS_P1, @MOD_SHIELD_SKILL,          12),
    (@SOLUS_P1, @MOD_ENMITY_LOSS_REDUCTION, 10);

DELETE FROM `item_latents` WHERE itemId = @SOLUS_P1;
INSERT INTO `item_latents` VALUES (@SOLUS_P1, @MOD_DEF, 2, @MOD_ABOVE_LEVEL, 59);


-----------------------------------
-- CW Ultimate Weapon - Sword (RDM)
-----------------------------------
SET @WORN_RAPIER = 2978;
DELETE FROM `item_basic` WHERE itemid = @WORN_RAPIER;
INSERT INTO `item_basic` VALUES (@WORN_RAPIER,0,'worn_rapier','worn_rapier',1,@ITEM_RARE,0,1,0);

-- Sword Tier I
SET @SPELLSWORD = 21622; -- (Icon: Msk. Sword +1)
DELETE FROM `item_basic` WHERE itemid = @SPELLSWORD;
INSERT INTO `item_basic` VALUES (@SPELLSWORD,0,'spellsword','spellsword',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SPELLSWORD;
INSERT INTO `item_equipment` VALUES (@SPELLSWORD,'spellsword',20,0,@RDM,188,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @SPELLSWORD;
INSERT INTO `item_weapon` VALUES (@SPELLSWORD,'spellsword',@SKILL_SWORD,0,0,0,0,@DMG_PIERCING,1,224,18,0);

DELETE FROM `item_mods` WHERE itemId = @SPELLSWORD;
INSERT INTO `item_mods` VALUES
    (@SPELLSWORD, @MOD_INT,                               4),
    (@SPELLSWORD, @MOD_MND,                               4),
    (@SPELLSWORD, @MOD_CURE_POTENCY,                      5),
    (@SPELLSWORD, @MOD_ITEM_ADDEFFECT_TYPE,               1),
    (@SPELLSWORD, @MOD_ITEM_SUBEFFECT,         @ELEMENT_ICE),
    (@SPELLSWORD, @MOD_ITEM_ADDEFFECT_DMG,               10),
    (@SPELLSWORD, @MOD_ITEM_ADDEFFECT_CHANCE,            10),
    (@SPELLSWORD, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_ICE);

DELETE FROM `item_latents` WHERE itemId = @SPELLSWORD;
INSERT INTO `item_latents` VALUES (@SPELLSWORD,@MOD_WEAPON_DMG,5,@MOD_ABOVE_LEVEL,29);

-- Sword Tier II
SET @SPELLSWORD_P1 = 18905; -- (Icon: Msk. Sword +2)
DELETE FROM `item_basic` WHERE itemid = @SPELLSWORD_P1;
INSERT INTO `item_basic` VALUES (@SPELLSWORD_P1,0,'spellsword_+1','spellsword_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SPELLSWORD_P1;
INSERT INTO `item_equipment` VALUES (@SPELLSWORD_P1,'spellsword_+1',50,0,@RDM,188,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @SPELLSWORD_P1;
INSERT INTO `item_weapon` VALUES (@SPELLSWORD_P1,'spellsword_+1',@SKILL_SWORD,0,0,0,0,@DMG_PIERCING,1,224,36,0);

DELETE FROM `item_mods` WHERE itemId = @SPELLSWORD_P1;
INSERT INTO `item_mods` VALUES
    (@SPELLSWORD_P1, @MOD_INT,                               5),
    (@SPELLSWORD_P1, @MOD_MND,                               5),
    (@SPELLSWORD_P1, @MOD_HASTE,                           200),
    (@SPELLSWORD_P1, @MOD_CURE_POTENCY,                     10),
    (@SPELLSWORD_P1, @MOD_ENFEEBLE_SKILL,                    5),
    (@SPELLSWORD_P1, @MOD_ITEM_ADDEFFECT_TYPE,               1),
    (@SPELLSWORD_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_ICE),
    (@SPELLSWORD_P1, @MOD_ITEM_ADDEFFECT_DMG,               15),
    (@SPELLSWORD_P1, @MOD_ITEM_ADDEFFECT_CHANCE,            15),
    (@SPELLSWORD_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_ICE);

DELETE FROM `item_latents` WHERE itemId = @SPELLSWORD_P1;
INSERT INTO `item_latents` VALUES (@SPELLSWORD_P1, @MOD_WEAPON_DMG, 2, @MOD_ABOVE_LEVEL, 59);


-----------------------------------
-- CW Ultimate Weapon - Great Sword (DRK/RUN)
-----------------------------------
SET @WORN_BLADE = 2979;
DELETE FROM `item_basic` WHERE itemid = @WORN_BLADE;
INSERT INTO `item_basic` VALUES (@WORN_BLADE,0,'worn_blade','worn_blade',1,@ITEM_RARE,0,1,0);

-- Great Sword Tier I
SET @BITTERNESS = 21665; -- (Icon: Ryl.Swd. Blade +1)
DELETE FROM `item_basic` WHERE itemid = @BITTERNESS;
INSERT INTO `item_basic` VALUES (@BITTERNESS,0,'bitterness','bitterness',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BITTERNESS;
INSERT INTO `item_equipment` VALUES (@BITTERNESS,'bitterness',20,0,@DRK+@RUN,72,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @BITTERNESS;
INSERT INTO `item_weapon` VALUES (@BITTERNESS,'bitterness',@SKILL_GREAT_SWORD,0,0,0,0,@DMG_SLASHING,1,480,38,0);

DELETE FROM `item_mods` WHERE itemId = @BITTERNESS;
INSERT INTO `item_mods` VALUES
    (@BITTERNESS, @MOD_MP,                                 9),
    (@BITTERNESS, @MOD_STR,                                3),
    (@BITTERNESS, @MOD_INT,                                3),
    (@BITTERNESS, @MOD_ATT,                               13),
    (@BITTERNESS, @MOD_ENMITY,                             3),
    (@BITTERNESS, @MOD_ITEM_ADDEFFECT_TYPE,                1),
    (@BITTERNESS, @MOD_ITEM_SUBEFFECT,         @ELEMENT_DARK),
    (@BITTERNESS, @MOD_ITEM_ADDEFFECT_DMG,                10),
    (@BITTERNESS, @MOD_ITEM_ADDEFFECT_CHANCE,             10),
    (@BITTERNESS, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_DARK);

DELETE FROM `item_latents` WHERE itemId = @BITTERNESS;
INSERT INTO `item_latents` VALUES (@BITTERNESS,@MOD_WEAPON_DMG,8,@MOD_ABOVE_LEVEL,29);

-- Great Sword Tier II
SET @BITTERNESS_P1 = 20760; -- (Icon: Ryl.Swd. Blade +2)
DELETE FROM `item_basic` WHERE itemid = @BITTERNESS_P1;
INSERT INTO `item_basic` VALUES (@BITTERNESS_P1,0,'bitterness_+1','bitterness_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BITTERNESS_P1;
INSERT INTO `item_equipment` VALUES (@BITTERNESS_P1,'bitterness_+1',50,0,@DRK+@RUN,72,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @BITTERNESS_P1;
INSERT INTO `item_weapon` VALUES (@BITTERNESS_P1,'bitterness_+1',@SKILL_GREAT_SWORD,0,0,0,0,@DMG_SLASHING,1,480,76,0);

DELETE FROM `item_mods` WHERE itemId = @BITTERNESS_P1;
INSERT INTO `item_mods` VALUES
    (@BITTERNESS_P1, @MOD_MP,                                13),
    (@BITTERNESS_P1, @MOD_STR,                                5),
    (@BITTERNESS_P1, @MOD_INT,                                5),
    (@BITTERNESS_P1, @MOD_ATT,                               19),
    (@BITTERNESS_P1, @MOD_ENMITY,                             5),
    (@BITTERNESS_P1, @MOD_FASTCAST,                           5),
    (@BITTERNESS_P1, @MOD_REFRESH,                            1),
    (@BITTERNESS_P1, @MOD_ITEM_ADDEFFECT_TYPE,               10), -- Dispel
    (@BITTERNESS_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_DARK),
    (@BITTERNESS_P1, @MOD_ITEM_ADDEFFECT_CHANCE,             15),
    (@BITTERNESS_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_DARK);

DELETE FROM `item_latents` WHERE itemId = @BITTERNESS_P1;
INSERT INTO `item_latents` VALUES (@BITTERNESS_P1, @MOD_WEAPON_DMG, 8, @MOD_ABOVE_LEVEL, 59);

-----------------------------------
-- CW Ultimate Weapon - Scythe (DRK)
-----------------------------------
SET @WORN_SCYTHE = 2980;
DELETE FROM `item_basic` WHERE itemid = @WORN_SCYTHE;
INSERT INTO `item_basic` VALUES (@WORN_SCYTHE,0,'worn_scythe','worn_scythe',1,@ITEM_RARE,0,1,0);

-- Scythe Tier I
SET @FORESHADOW = 21822; -- (Icon: Windurstian Scythe)
DELETE FROM `item_basic` WHERE itemid = @FORESHADOW;
INSERT INTO `item_basic` VALUES (@FORESHADOW,0,'foreshadow','foreshadow',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @FORESHADOW;
INSERT INTO `item_equipment` VALUES (@FORESHADOW,'foreshadow',20,0,@BLM+@DRK,194,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @FORESHADOW;
INSERT INTO `item_weapon` VALUES (@FORESHADOW,'foreshadow',@SKILL_SCYTHE,0,0,0,0,@DMG_SLASHING,1,528,43,0);

DELETE FROM `item_mods` WHERE itemId = @FORESHADOW;
INSERT INTO `item_mods` VALUES
    (@FORESHADOW, @MOD_STR,                                3),
    (@FORESHADOW, @MOD_INT,                                5),
    (@FORESHADOW, @MOD_TP_BONUS,                        1000),
    (@FORESHADOW, @MOD_HMP,                                5),
    (@FORESHADOW, @MOD_ENH_DRAIN_ASPIR,                    5),
    (@FORESHADOW, @MOD_ITEM_ADDEFFECT_TYPE,                1),
    (@FORESHADOW, @MOD_ITEM_SUBEFFECT,         @ELEMENT_DARK),
    (@FORESHADOW, @MOD_ITEM_ADDEFFECT_DMG,                10),
    (@FORESHADOW, @MOD_ITEM_ADDEFFECT_CHANCE,             10),
    (@FORESHADOW, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_DARK);

DELETE FROM `item_latents` WHERE itemId = @FORESHADOW;
INSERT INTO `item_latents` VALUES (@FORESHADOW,@MOD_WEAPON_DMG,12,@MOD_ABOVE_LEVEL,29);

-- Scythe Tier II
SET @FORESHADOW_P1 = 20903; -- (Icon: Federation Scythe)
DELETE FROM `item_basic` WHERE itemid = @FORESHADOW_P1;
INSERT INTO `item_basic` VALUES (@FORESHADOW_P1,0,'foreshadow_+1','foreshadow_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @FORESHADOW_P1;
INSERT INTO `item_equipment` VALUES (@FORESHADOW_P1,'foreshadow_+1',50,0,@BLM+@DRK,194,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @FORESHADOW_P1;
INSERT INTO `item_weapon` VALUES (@FORESHADOW_P1,'foreshadow_+1',@SKILL_SCYTHE,0,0,0,0,@DMG_SLASHING,1,528,82,0);

DELETE FROM `item_mods` WHERE itemId = @FORESHADOW_P1;
INSERT INTO `item_mods` VALUES
    (@FORESHADOW_P1, @MOD_STR,                                5),
    (@FORESHADOW_P1, @MOD_INT,                                8),
    (@FORESHADOW_P1, @MOD_TP_BONUS,                        1000),
    (@FORESHADOW_P1, @MOD_ENH_DRAIN_ASPIR,                   10),
    (@FORESHADOW_P1, @MOD_HMP,                               10),
    (@FORESHADOW_P1, @MOD_IRIDESCENCE,                        2),
    (@FORESHADOW_P1, @MOD_FIRE_AFFINITY_DMG,                  3),
    (@FORESHADOW_P1, @MOD_ICE_AFFINITY_DMG,                   3),
    (@FORESHADOW_P1, @MOD_WIND_AFFINITY_DMG,                  3),
    (@FORESHADOW_P1, @MOD_EARTH_AFFINITY_DMG,                 3),
    (@FORESHADOW_P1, @MOD_THUNDER_AFFINITY_DMG,               3),
    (@FORESHADOW_P1, @MOD_WATER_AFFINITY_DMG,                 3),
    (@FORESHADOW_P1, @MOD_LIGHT_AFFINITY_DMG,                 3),
    (@FORESHADOW_P1, @MOD_DARK_AFFINITY_DMG,                  3),
    (@FORESHADOW_P1, @MOD_FIRE_AFFINITY_ACC,                  3),
    (@FORESHADOW_P1, @MOD_ICE_AFFINITY_ACC,                   3),
    (@FORESHADOW_P1, @MOD_WIND_AFFINITY_ACC,                  3),
    (@FORESHADOW_P1, @MOD_EARTH_AFFINITY_ACC,                 3),
    (@FORESHADOW_P1, @MOD_THUNDER_AFFINITY_ACC,               3),
    (@FORESHADOW_P1, @MOD_WATER_AFFINITY_ACC,                 3),
    (@FORESHADOW_P1, @MOD_LIGHT_AFFINITY_ACC,                 3),
    (@FORESHADOW_P1, @MOD_DARK_AFFINITY_ACC,                  3),
    (@FORESHADOW_P1, @MOD_ITEM_ADDEFFECT_TYPE,                1),
    (@FORESHADOW_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_DARK),
    (@FORESHADOW_P1, @MOD_ITEM_ADDEFFECT_DMG,                15),
    (@FORESHADOW_P1, @MOD_ITEM_ADDEFFECT_CHANCE,             15),
    (@FORESHADOW_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_DARK);

DELETE FROM `item_latents` WHERE itemId = @FORESHADOW_P1;
INSERT INTO `item_latents` VALUES (@FORESHADOW_P1, @MOD_WEAPON_DMG, 8, @MOD_ABOVE_LEVEL, 59);


-----------------------------------
-- CW Ultimate Weapon - Club (WHM/GEO)
-----------------------------------
SET @WORN_HAMMER = 2981;
DELETE FROM `item_basic` WHERE itemid = @WORN_HAMMER;
INSERT INTO `item_basic` VALUES (@WORN_HAMMER,0,'worn_hammer','worn_hammer',1,@ITEM_RARE,0,1,0);

-- Club Tier I
SET @STOUTHEART = 22006; -- (Icon: Bastokan Hammer)
DELETE FROM `item_basic` WHERE itemid = @STOUTHEART;
INSERT INTO `item_basic` VALUES (@STOUTHEART,0,'stoutheart','stoutheart',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @STOUTHEART;
INSERT INTO `item_equipment` VALUES (@STOUTHEART,'stoutheart',20,0,@WHM+@GEO,115,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @STOUTHEART;
INSERT INTO `item_weapon` VALUES (@STOUTHEART,'stoutheart',@SKILL_CLUB,0,0,0,0,@DMG_BLUNT,1,340,22,0);

DELETE FROM `item_mods` WHERE itemId = @STOUTHEART;
INSERT INTO `item_mods` VALUES
    (@STOUTHEART, @MOD_STR,                                 3),
    (@STOUTHEART, @MOD_MND,                                 3),
    (@STOUTHEART, @MOD_ATT,                                 7),
    (@STOUTHEART, @MOD_HMP,                                 5),
    (@STOUTHEART, @MOD_CURE_POTENCY,                        5),
    (@STOUTHEART, @MOD_ITEM_ADDEFFECT_TYPE,                 1),
    (@STOUTHEART, @MOD_ITEM_SUBEFFECT,         @ELEMENT_LIGHT),
    (@STOUTHEART, @MOD_ITEM_ADDEFFECT_DMG,                 10),
    (@STOUTHEART, @MOD_ITEM_ADDEFFECT_CHANCE,              10),
    (@STOUTHEART, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_LIGHT);

DELETE FROM `item_latents` WHERE itemId = @STOUTHEART;
INSERT INTO `item_latents` VALUES (@STOUTHEART,@MOD_WEAPON_DMG,8,@MOD_ABOVE_LEVEL,29);

-- Club Tier II
SET @STOUTHEART_P1 = 21109; -- (Icon: Republic Hammer)
DELETE FROM `item_basic` WHERE itemid = @STOUTHEART_P1;
INSERT INTO `item_basic` VALUES (@STOUTHEART_P1,0,'stoutheart_+1','stoutheart_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @STOUTHEART_P1;
INSERT INTO `item_equipment` VALUES (@STOUTHEART_P1,'stoutheart_+1',50,0,@WHM+@GEO,115,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @STOUTHEART_P1;
INSERT INTO `item_weapon` VALUES (@STOUTHEART_P1,'stoutheart_+1',@SKILL_CLUB,0,0,0,0,@DMG_BLUNT,1,340,36,0);

DELETE FROM `item_mods` WHERE itemId = @STOUTHEART_P1;
INSERT INTO `item_mods` VALUES
    (@STOUTHEART_P1, @MOD_STR,                                 5),
    (@STOUTHEART_P1, @MOD_MND,                                 5),
    (@STOUTHEART_P1, @MOD_ATT,                                 8),
    (@STOUTHEART_P1, @MOD_HMP,                                10),
    (@STOUTHEART_P1, @MOD_CURE_POTENCY,                       10),
    (@STOUTHEART_P1, @MOD_GEOMANCY_SKILL,                      8),
    (@STOUTHEART_P1, @MOD_REFRESH,                             1),
    (@STOUTHEART_P1, @MOD_ITEM_ADDEFFECT_TYPE,                 1),
    (@STOUTHEART_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_LIGHT),
    (@STOUTHEART_P1, @MOD_ITEM_ADDEFFECT_DMG,                 15),
    (@STOUTHEART_P1, @MOD_ITEM_ADDEFFECT_CHANCE,              15),
    (@STOUTHEART_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_LIGHT);

DELETE FROM `item_latents` WHERE itemId = @STOUTHEART_P1;
INSERT INTO `item_latents` VALUES (@STOUTHEART_P1, @MOD_WEAPON_DMG, 6, @MOD_ABOVE_LEVEL, 59);


-----------------------------------
-- CW Ultimate Weapon - Staff (SMN)
-----------------------------------
SET @WORN_STAFF = 2982;
DELETE FROM `item_basic` WHERE itemid = @WORN_STAFF;
INSERT INTO `item_basic` VALUES (@WORN_STAFF,0,'worn_staff','worn_staff',1,@ITEM_RARE,0,1,0);

-- Staff Tier I
SET @RADIANCE = 22291; -- (Icon: Windurstian Staff)
DELETE FROM `item_basic` WHERE itemid = @RADIANCE;
INSERT INTO `item_basic` VALUES (@RADIANCE,0,'radiance','radiance',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @RADIANCE;
INSERT INTO `item_equipment` VALUES (@RADIANCE,'radiance',20,0,@SMN,290,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @RADIANCE;
INSERT INTO `item_weapon` VALUES (@RADIANCE,'radiance',@SKILL_STAFF,0,0,0,0,@DMG_BLUNT,1,366,24,0);

DELETE FROM `item_mods` WHERE itemId = @RADIANCE;
INSERT INTO `item_mods` VALUES
    (@RADIANCE, @MOD_MP,                                 25),
    (@RADIANCE, @MOD_MND,                                 4),
    (@RADIANCE, @MOD_CURE_POTENCY,                        5),
    (@RADIANCE, @MOD_HMP,                                 5),
    (@RADIANCE, @MOD_REFRESH,                             1),
    (@RADIANCE, @MOD_ITEM_ADDEFFECT_TYPE,                 1),
    (@RADIANCE, @MOD_ITEM_SUBEFFECT,         @ELEMENT_LIGHT),
    (@RADIANCE, @MOD_ITEM_ADDEFFECT_DMG,                 10),
    (@RADIANCE, @MOD_ITEM_ADDEFFECT_CHANCE,              10),
    (@RADIANCE, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_LIGHT);

DELETE FROM `item_mods_pet` WHERE itemId = @RADIANCE;
INSERT INTO `item_mods_pet` VALUES
    (@RADIANCE, @MOD_ATT, 10, @PET_ALL);

DELETE FROM `item_latents` WHERE itemId = @RADIANCE;
INSERT INTO `item_latents` VALUES (@RADIANCE, @MOD_WEAPON_DMG, 8, @MOD_ABOVE_LEVEL, 29);

-- Staff Tier II
SET @RADIANCE_P1 = 21172; -- (Icon: Federation Staff)
DELETE FROM `item_basic` WHERE itemid = @RADIANCE_P1;
INSERT INTO `item_basic` VALUES (@RADIANCE_P1,0,'radiance_+1','radiance_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @RADIANCE_P1;
INSERT INTO `item_equipment` VALUES (@RADIANCE_P1,'radiance_+1',50,0,@SMN,290,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @RADIANCE_P1;
INSERT INTO `item_weapon` VALUES (@RADIANCE_P1,'radiance_+1',@SKILL_STAFF,0,0,0,0,@DMG_BLUNT,1,366,40,0);

DELETE FROM `item_mods` WHERE itemId = @RADIANCE_P1;
INSERT INTO `item_mods` VALUES
    (@RADIANCE_P1, @MOD_MP,                                 50),
    (@RADIANCE_P1, @MOD_MND,                                 8),
    (@RADIANCE_P1, @MOD_CURE_POTENCY,                       10),
    (@RADIANCE_P1, @MOD_HMP,                                10),
    (@RADIANCE_P1, @MOD_REFRESH,                             2),
    (@RADIANCE_P1, @MOD_ITEM_ADDEFFECT_TYPE,                 1),
    (@RADIANCE_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_LIGHT),
    (@RADIANCE_P1, @MOD_ITEM_ADDEFFECT_DMG,                 15),
    (@RADIANCE_P1, @MOD_ITEM_ADDEFFECT_CHANCE,              15),
    (@RADIANCE_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_LIGHT);

DELETE FROM `item_mods_pet` WHERE itemId = @RADIANCE_P1;
INSERT INTO `item_mods_pet` VALUES
    (@RADIANCE_P1, @MOD_ATT, 15, @PET_ALL),
    (@RADIANCE_P1, @MOD_ACC, 10, @PET_ALL);

DELETE FROM `item_latents` WHERE itemId = @RADIANCE_P1;
INSERT INTO `item_latents` VALUES
    (@RADIANCE_P1, @MOD_WEAPON_DMG,  8, @MOD_ABOVE_LEVEL,  59);


-----------------------------------
-- CW Ultimate Weapon - Gun (RNG/COR)
-----------------------------------
SET @WORN_MUSKET = 2983;
DELETE FROM `item_basic` WHERE itemid = @WORN_MUSKET;
INSERT INTO `item_basic` VALUES (@WORN_MUSKET,0,'worn_musket','worn_staff',1,@ITEM_RARE,0,1,0);

-- Gun Tier I
SET @INSURANCE = 22144; -- (Icon: Musketeer Gun +1)
DELETE FROM `item_basic` WHERE itemid = @INSURANCE;
INSERT INTO `item_basic` VALUES (@INSURANCE,0,'insurance','insurance',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @INSURANCE;
INSERT INTO `item_equipment` VALUES (@INSURANCE,'insurance',20,0,@RNG+@COR,57,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @INSURANCE;
INSERT INTO `item_weapon` VALUES (@INSURANCE,'insurance',@SKILL_MARKSMANSHIP,@SUBSKILL_GUN,0,0,0,@DMG_PIERCING,1,600,20,0);

DELETE FROM `item_mods` WHERE itemId = @INSURANCE;
INSERT INTO `item_mods` VALUES
    (@INSURANCE, @MOD_AGI,       3),
    (@INSURANCE, @MOD_RATT,     10),
    (@INSURANCE, @MOD_MATT,      5),
    (@INSURANCE, @MOD_STORE_TP,  3);

DELETE FROM `item_latents` WHERE itemId = @INSURANCE;
INSERT INTO `item_latents` VALUES (@INSURANCE,@MOD_WEAPON_DMG,8,@MOD_ABOVE_LEVEL,29);

-- Gun Tier II
SET @INSURANCE_P1 = 21275; -- (Icon: Musketeer Gun +2)
DELETE FROM `item_basic` WHERE itemid = @INSURANCE_P1;
INSERT INTO `item_basic` VALUES (@INSURANCE_P1,0,'insurance_+1','insurance_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @INSURANCE_P1;
INSERT INTO `item_equipment` VALUES (@INSURANCE_P1,'insurance_+1',50,0,@RNG+@COR,57,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @INSURANCE_P1;
INSERT INTO `item_weapon` VALUES (@INSURANCE_P1,'insurance_+1',@SKILL_MARKSMANSHIP,@SUBSKILL_GUN,0,0,0,@DMG_PIERCING,1,600,38,0);

DELETE FROM `item_mods` WHERE itemId = @INSURANCE_P1;
INSERT INTO `item_mods` VALUES
    (@INSURANCE_P1, @MOD_AGI,       5),
    (@INSURANCE_P1, @MOD_RATT,     15),
    (@INSURANCE_P1, @MOD_HASTE,   200),
    (@INSURANCE_P1, @MOD_MATT,     10),
    (@INSURANCE_P1, @MOD_STORE_TP,  5);

DELETE FROM `item_latents` WHERE itemId = @INSURANCE_P1;
INSERT INTO `item_latents` VALUES (@INSURANCE_P1, @MOD_WEAPON_DMG, 4, @MOD_ABOVE_LEVEL, 59);


-----------------------------------
-- CW Ultimate Weapon - Dagger (THF/DNC)
-----------------------------------
SET @WORN_KNIFE = 2990;
DELETE FROM `item_basic` WHERE itemid = @WORN_KNIFE;
INSERT INTO `item_basic` VALUES (@WORN_KNIFE,0,'worn_knife','worn_knife',1,@ITEM_RARE,0,1,0);

-- Dagger Tier I
SET @BUSHWHACKER = 21566; -- (Icon: Windurstian Knife)
DELETE FROM `item_basic` WHERE itemid = @BUSHWHACKER;
INSERT INTO `item_basic` VALUES (@BUSHWHACKER,0,'bushwhacker','bushwhacker',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BUSHWHACKER;
INSERT INTO `item_equipment` VALUES (@BUSHWHACKER,'bushwhacker',20,0,@THF+@DNC,160,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @BUSHWHACKER;
INSERT INTO `item_weapon` VALUES (@BUSHWHACKER,'bushwhacker',@SKILL_DAGGER,0,0,0,0,@DMG_PIERCING,1,200,14,0);

DELETE FROM `item_mods` WHERE itemId = @BUSHWHACKER;
INSERT INTO `item_mods` VALUES
    (@BUSHWHACKER, @MOD_DEX,                                4),
    (@BUSHWHACKER, @MOD_CHR,                                4),
    (@BUSHWHACKER, @MOD_CRIT_HIT_RATE,                      3),
    (@BUSHWHACKER, @MOD_ITEM_ADDEFFECT_TYPE,                1),
    (@BUSHWHACKER, @MOD_ITEM_SUBEFFECT,         @ELEMENT_WIND),
    (@BUSHWHACKER, @MOD_ITEM_ADDEFFECT_DMG,                10),
    (@BUSHWHACKER, @MOD_ITEM_ADDEFFECT_CHANCE,             10),
    (@BUSHWHACKER, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_WIND);

DELETE FROM `item_latents` WHERE itemId = @BUSHWHACKER;
INSERT INTO `item_latents` VALUES (@BUSHWHACKER,@MOD_WEAPON_DMG,2,@MOD_ABOVE_LEVEL,29);

-- Dagger Tier II
SET @BUSHWHACKER_P1 = 20617; -- (Icon: Federation Knife)
DELETE FROM `item_basic` WHERE itemid = @BUSHWHACKER_P1;
INSERT INTO `item_basic` VALUES (@BUSHWHACKER_P1,0,'bushwhacker_+1','bushwhacker_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BUSHWHACKER_P1;
INSERT INTO `item_equipment` VALUES (@BUSHWHACKER_P1,'bushwhacker_+1',50,0,@THF+@DNC,160,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @BUSHWHACKER_P1;
INSERT INTO `item_weapon` VALUES (@BUSHWHACKER_P1,'bushwhacker_+1',@SKILL_DAGGER,0,0,0,0,@DMG_PIERCING,1,200,24,0);

DELETE FROM `item_mods` WHERE itemId = @BUSHWHACKER_P1;
INSERT INTO `item_mods` VALUES
    (@BUSHWHACKER_P1, @MOD_DEX,                                6),
    (@BUSHWHACKER_P1, @MOD_CHR,                                8),
    (@BUSHWHACKER_P1, @MOD_CRIT_HIT_RATE,                      5),
    (@BUSHWHACKER_P1, @MOD_TRIPLE_ATK,                         3),
    (@BUSHWHACKER_P1, @MOD_STEP_TP_CONSUMED,                 -30),
    (@BUSHWHACKER_P1, @MOD_ITEM_ADDEFFECT_TYPE,                1),
    (@BUSHWHACKER_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_WIND),
    (@BUSHWHACKER_P1, @MOD_ITEM_ADDEFFECT_DMG,                15),
    (@BUSHWHACKER_P1, @MOD_ITEM_ADDEFFECT_CHANCE,             15),
    (@BUSHWHACKER_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_WIND);

DELETE FROM `item_latents` WHERE itemId = @BUSHWHACKER_P1;
INSERT INTO `item_latents` VALUES (@BUSHWHACKER_P1, @MOD_WEAPON_DMG, 6, @MOD_ABOVE_LEVEL, 59);


-----------------------------------
-- CW Ultimate Weapon - Katana (NIN)
-----------------------------------
SET @WORN_KATANA = 2991;
DELETE FROM `item_basic` WHERE itemid = @WORN_KATANA;
INSERT INTO `item_basic` VALUES (@WORN_KATANA,0,'worn_katana','worn_katana',1,@ITEM_RARE,0,1,0);

-- Katana Tier I
SET @HIKAGE = 21912; -- (Icon: Tobi +1)
DELETE FROM `item_basic` WHERE itemid = @HIKAGE;
INSERT INTO `item_basic` VALUES (@HIKAGE,0,'hikage','hikage',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HIKAGE;
INSERT INTO `item_equipment` VALUES (@HIKAGE,'hikage',20,0,@NIN,313,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @HIKAGE;
INSERT INTO `item_weapon` VALUES (@HIKAGE,'hikage',@SKILL_KATANA,0,0,0,0,@DMG_SLASHING,1,227,15,0);

DELETE FROM `item_mods` WHERE itemId = @HIKAGE;
INSERT INTO `item_mods` VALUES
    (@HIKAGE, @MOD_DEX,                                 4),
    (@HIKAGE, @MOD_INT,                                 4),
    (@HIKAGE, @MOD_ATT,                                 5),
    (@HIKAGE, @MOD_RATT,                                5),
    (@HIKAGE, @MOD_MATT,                                3),
    (@HIKAGE, @MOD_ITEM_ADDEFFECT_TYPE,                 1),
    (@HIKAGE, @MOD_ITEM_SUBEFFECT,         @ELEMENT_WATER),
    (@HIKAGE, @MOD_ITEM_ADDEFFECT_DMG,                 10),
    (@HIKAGE, @MOD_ITEM_ADDEFFECT_CHANCE,              10),
    (@HIKAGE, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_WATER);

DELETE FROM `item_latents` WHERE itemId = @HIKAGE;
INSERT INTO `item_latents` VALUES (@HIKAGE,@MOD_WEAPON_DMG,7,@MOD_ABOVE_LEVEL,29);

-- Katana Tier II
SET @HIKAGE_P1 = 20993; -- (Icon: Tobi +2)
DELETE FROM `item_basic` WHERE itemid = @HIKAGE_P1;
INSERT INTO `item_basic` VALUES (@HIKAGE_P1,0,'hikage_+1','hikage_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @HIKAGE_P1;
INSERT INTO `item_equipment` VALUES (@HIKAGE_P1,'hikage_+1',50,0,@NIN,313,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @HIKAGE_P1;
INSERT INTO `item_weapon` VALUES (@HIKAGE_P1,'hikage_+1',@SKILL_KATANA,0,0,0,0,@DMG_SLASHING,1,227,30,0);

DELETE FROM `item_mods` WHERE itemId = @HIKAGE_P1;
INSERT INTO `item_mods` VALUES
    (@HIKAGE_P1, @MOD_DEX,                                 6),
    (@HIKAGE_P1, @MOD_INT,                                 8),
    (@HIKAGE_P1, @MOD_ATT,                                10),
    (@HIKAGE_P1, @MOD_RATT,                               10),
    (@HIKAGE_P1, @MOD_MATT,                                5),
    (@HIKAGE_P1, @MOD_MAGIC_DMG_TAKEN,                  -800),
    (@HIKAGE_P1, @MOD_DAKEN_RATE,                          3),
    (@HIKAGE_P1, @MOD_ITEM_ADDEFFECT_TYPE,                 1),
    (@HIKAGE_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_WATER),
    (@HIKAGE_P1, @MOD_ITEM_ADDEFFECT_DMG,                 15),
    (@HIKAGE_P1, @MOD_ITEM_ADDEFFECT_CHANCE,              15),
    (@HIKAGE_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_WATER);

DELETE FROM `item_latents` WHERE itemId = @HIKAGE;
INSERT INTO `item_latents` VALUES (@HIKAGE,@MOD_WEAPON_DMG, 6, @MOD_ABOVE_LEVEL, 59);


-----------------------------------
-- CW Ultimate Weapon - Great Katana (SAM)
-----------------------------------
SET @WORN_TACHI = 2992;
DELETE FROM `item_basic` WHERE itemid = @WORN_TACHI;
INSERT INTO `item_basic` VALUES (@WORN_TACHI,0,'worn_tachi','worn_tachi',1,@ITEM_RARE,0,1,0);

-- Great Katana Tier I
SET @GIRITACHI = 21976; -- (Icon: Hyogugusari +1)
DELETE FROM `item_basic` WHERE itemid = @GIRITACHI;
INSERT INTO `item_basic` VALUES (@GIRITACHI,0,'giritachi','giritachi',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @GIRITACHI;
INSERT INTO `item_equipment` VALUES (@GIRITACHI,'giritachi',20,0,@SAM,147,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @GIRITACHI;
INSERT INTO `item_weapon` VALUES (@GIRITACHI,'giritachi',@SKILL_GREAT_KATANA,0,0,0,0,@DMG_SLASHING,1,450,40,0);

DELETE FROM `item_mods` WHERE itemId = @GIRITACHI;
INSERT INTO `item_mods` VALUES
    (@GIRITACHI, @MOD_ATT,                                   8),
    (@GIRITACHI, @MOD_STORE_TP,                              5),
    (@GIRITACHI, @MOD_ZANSHIN,                               3),
    (@GIRITACHI, @MOD_ITEM_ADDEFFECT_TYPE,                   1),
    (@GIRITACHI, @MOD_ITEM_SUBEFFECT,         @ELEMENT_THUNDER),
    (@GIRITACHI, @MOD_ITEM_ADDEFFECT_DMG,                   10),
    (@GIRITACHI, @MOD_ITEM_ADDEFFECT_CHANCE,                10),
    (@GIRITACHI, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_THUNDER);

DELETE FROM `item_latents` WHERE itemId = @GIRITACHI;
INSERT INTO `item_latents` VALUES (@GIRITACHI,@MOD_WEAPON_DMG,10,@MOD_ABOVE_LEVEL,29);

-- Great Katana Tier II
SET @GIRITACHI_P1 = 21038; -- (Icon: Hyogugusari +2)
DELETE FROM `item_basic` WHERE itemid = @GIRITACHI_P1;
INSERT INTO `item_basic` VALUES (@GIRITACHI_P1,0,'giritachi_+1','giritachi_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @GIRITACHI_P1;
INSERT INTO `item_equipment` VALUES (@GIRITACHI_P1,'giritachi_+1',20,0,@SAM,147,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @GIRITACHI_P1;
INSERT INTO `item_weapon` VALUES (@GIRITACHI_P1,'giritachi_+1',@SKILL_GREAT_KATANA,0,0,0,0,@DMG_SLASHING,3,450,52,0);

DELETE FROM `item_mods` WHERE itemId = @GIRITACHI_P1;
INSERT INTO `item_mods` VALUES
    (@GIRITACHI_P1, @MOD_ATT,                                  12),
    (@GIRITACHI_P1, @MOD_STORE_TP,                              8),
    (@GIRITACHI_P1, @MOD_ZANSHIN,                               5),
    (@GIRITACHI_P1, @MOD_ITEM_ADDEFFECT_TYPE,                   1),
    (@GIRITACHI_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_THUNDER),
    (@GIRITACHI_P1, @MOD_ITEM_ADDEFFECT_DMG,                   15),
    (@GIRITACHI_P1, @MOD_ITEM_ADDEFFECT_CHANCE,                15),
    (@GIRITACHI_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_THUNDER);

DELETE FROM `item_latents` WHERE itemId = @GIRITACHI_P1;
-- Multi-hit weapons do not have enhanced damage at Lv60+


-----------------------------------
-- CW Ultimate Weapon - Staff (BLM/SCH)
-----------------------------------
SET @WORN_POLE = 2993;
DELETE FROM `item_basic` WHERE itemid = @WORN_POLE;
INSERT INTO `item_basic` VALUES (@WORN_POLE,0,'worn_pole','worn_pole',1,@ITEM_RARE,0,1,0);

-- Staff Tier I
SET @ARCANIUM = 22088; -- (Icon: Windurstian Pole)
DELETE FROM `item_basic` WHERE itemid = @ARCANIUM;
INSERT INTO `item_basic` VALUES (@ARCANIUM,0,'arcanium','arcanium',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ARCANIUM;
INSERT INTO `item_equipment` VALUES (@ARCANIUM,'arcanium',20,0,@BLM+@SCH,302,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @ARCANIUM;
INSERT INTO `item_weapon` VALUES (@ARCANIUM,'arcanium',@SKILL_STAFF,0,0,0,0,@DMG_BLUNT,1,402,28,0);

DELETE FROM `item_mods` WHERE itemId = @ARCANIUM;
INSERT INTO `item_mods` VALUES
    (@ARCANIUM, @MOD_MP,                               15),
    (@ARCANIUM, @MOD_INT,                               5),
    (@ARCANIUM, @MOD_HMP,                               5),
    (@ARCANIUM, @MOD_CURE_POTENCY,                      5),
    (@ARCANIUM, @MOD_ITEM_ADDEFFECT_TYPE,               1),
    (@ARCANIUM, @MOD_ITEM_SUBEFFECT,         @ELEMENT_ICE),
    (@ARCANIUM, @MOD_ITEM_ADDEFFECT_DMG,               10),
    (@ARCANIUM, @MOD_ITEM_ADDEFFECT_CHANCE,            10),
    (@ARCANIUM, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_ICE);

DELETE FROM `item_latents` WHERE itemId = @ARCANIUM;
INSERT INTO `item_latents` VALUES (@ARCANIUM,@MOD_WEAPON_DMG,8,@MOD_ABOVE_LEVEL,29);

-- Staff Tier II
SET @ARCANIUM_P1 = 21171; -- (Icon: Federation Pole)
DELETE FROM `item_basic` WHERE itemid = @ARCANIUM_P1;
INSERT INTO `item_basic` VALUES (@ARCANIUM_P1,0,'arcanium_+1','arcanium_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ARCANIUM_P1;
INSERT INTO `item_equipment` VALUES (@ARCANIUM_P1,'arcanium_+1',50,0,@BLM+@SCH,302,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @ARCANIUM_P1;
INSERT INTO `item_weapon` VALUES (@ARCANIUM_P1,'arcanium_+1',@SKILL_STAFF,0,0,0,0,@DMG_BLUNT,5,402,24,0);

DELETE FROM `item_mods` WHERE itemId = @ARCANIUM_P1;
INSERT INTO `item_mods` VALUES
    (@ARCANIUM_P1, @MOD_MP,                               25),
    (@ARCANIUM_P1, @MOD_INT,                               6),
    (@ARCANIUM_P1, @MOD_HMP,                              10),
    (@ARCANIUM_P1, @MOD_CURE_POTENCY,                     10),
    (@ARCANIUM_P1, @MOD_IRIDESCENCE,                       2),
    (@ARCANIUM_P1, @MOD_FIRE_AFFINITY_DMG,                 2),
    (@ARCANIUM_P1, @MOD_ICE_AFFINITY_DMG,                  2),
    (@ARCANIUM_P1, @MOD_WIND_AFFINITY_DMG,                 2),
    (@ARCANIUM_P1, @MOD_EARTH_AFFINITY_DMG,                2),
    (@ARCANIUM_P1, @MOD_THUNDER_AFFINITY_DMG,              2),
    (@ARCANIUM_P1, @MOD_WATER_AFFINITY_DMG,                2),
    (@ARCANIUM_P1, @MOD_LIGHT_AFFINITY_DMG,                2),
    (@ARCANIUM_P1, @MOD_DARK_AFFINITY_DMG,                 2),
    (@ARCANIUM_P1, @MOD_FIRE_AFFINITY_ACC,                 2),
    (@ARCANIUM_P1, @MOD_ICE_AFFINITY_ACC,                  2),
    (@ARCANIUM_P1, @MOD_WIND_AFFINITY_ACC,                 2),
    (@ARCANIUM_P1, @MOD_EARTH_AFFINITY_ACC,                2),
    (@ARCANIUM_P1, @MOD_THUNDER_AFFINITY_ACC,              2),
    (@ARCANIUM_P1, @MOD_WATER_AFFINITY_ACC,                2),
    (@ARCANIUM_P1, @MOD_LIGHT_AFFINITY_ACC,                2),
    (@ARCANIUM_P1, @MOD_DARK_AFFINITY_ACC,                 2),
    (@ARCANIUM_P1, @MOD_ITEM_ADDEFFECT_TYPE,               1),
    (@ARCANIUM_P1, @MOD_ITEM_SUBEFFECT,         @ELEMENT_ICE),
    (@ARCANIUM_P1, @MOD_ITEM_ADDEFFECT_DMG,               15),
    (@ARCANIUM_P1, @MOD_ITEM_ADDEFFECT_CHANCE,            15),
    (@ARCANIUM_P1, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_ICE);

DELETE FROM `item_latents` WHERE itemId = @ARCANIUM;
-- Multi-hit weapons do not have enhanced damage at Lv60+


-----------------------------------
-- CW Ultimate Weapon - Bow (RNG)
-----------------------------------
SET @WORN_LONGBOW = 2994;
DELETE FROM `item_basic` WHERE itemid = @WORN_LONGBOW;
INSERT INTO `item_basic` VALUES (@WORN_LONGBOW,0,'worn_longbow','worn_longbow',1,@ITEM_RARE,0,1,0);

-- Bow Tier I
SET @ELVENLORE = 22133; -- (Icon: San d'Orian Bow)
DELETE FROM `item_basic` WHERE itemid = @ELVENLORE;
INSERT INTO `item_basic` VALUES (@ELVENLORE,0,'elvenlore','elvenlore',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ELVENLORE;
INSERT INTO `item_equipment` VALUES (@ELVENLORE,'elvenlore',20,0,@RNG,37,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @ELVENLORE;
INSERT INTO `item_weapon` VALUES (@ELVENLORE,'elvenlore',@SKILL_ARCHERY,0,0,0,0,@DMG_PIERCING,1,540,38,0);

DELETE FROM `item_mods` WHERE itemId = @ELVENLORE;
INSERT INTO `item_mods` VALUES
    (@ELVENLORE, @MOD_AGI,     3),
    (@ELVENLORE, @MOD_ENMITY, -3),
    (@ELVENLORE, @MOD_RATT,   10);

DELETE FROM `item_latents` WHERE itemId = @ELVENLORE;
INSERT INTO `item_latents` VALUES (@ELVENLORE,@MOD_WEAPON_DMG,12,@MOD_ABOVE_LEVEL,29);

-- Bow Tier II
SET @ELVENLORE_P1 = 21226; -- (Icon: Kingdom Bow)
DELETE FROM `item_basic` WHERE itemid = @ELVENLORE_P1;
INSERT INTO `item_basic` VALUES (@ELVENLORE_P1,0,'elvenlore_+1','elvenlore_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ELVENLORE_P1;
INSERT INTO `item_equipment` VALUES (@ELVENLORE_P1,'elvenlore_+1',20,0,@RNG,37,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @ELVENLORE_P1;
INSERT INTO `item_weapon` VALUES (@ELVENLORE_P1,'elvenlore_+1',@SKILL_ARCHERY,0,0,0,0,@DMG_PIERCING,1,540,74,0);

DELETE FROM `item_mods` WHERE itemId = @ELVENLORE_P1;
INSERT INTO `item_mods` VALUES
    (@ELVENLORE_P1, @MOD_AGI,     5),
    (@ELVENLORE_P1, @MOD_ENMITY, -6),
    (@ELVENLORE_P1, @MOD_RATT,   25),
    (@ELVENLORE_P1, @MOD_RACC,    5);

DELETE FROM `item_latents` WHERE itemId = @ELVENLORE_P1;
INSERT INTO `item_latents` VALUES (@ELVENLORE_P1, @MOD_WEAPON_DMG, 4, @MOD_ABOVE_LEVEL, 59);


-----------------------------------
-- CW Ultimate Weapon - Wind (BRD)
-----------------------------------
SET @WORN_FIFE = 2995;
DELETE FROM `item_basic` WHERE itemid = @WORN_FIFE;
INSERT INTO `item_basic` VALUES (@WORN_FIFE,0,'worn_fife','worn_fife',1,@ITEM_RARE,0,1,0);

-- Fife Tier I
SET @ROUSER = 22296; -- (Icon: Flute +1)
DELETE FROM `item_basic` WHERE itemid = @ROUSER;
INSERT INTO `item_basic` VALUES (@ROUSER,0,'rouser','rouser',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ROUSER;
INSERT INTO `item_equipment` VALUES (@ROUSER,'rouser',20,0,@BRD,65,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @ROUSER;
INSERT INTO `item_weapon` VALUES (@ROUSER,'rouser',@SKILL_WIND,0,0,0,0,0,1,240,0,0);

DELETE FROM `item_mods` WHERE itemId = @ROUSER;
INSERT INTO `item_mods` VALUES
    (@ROUSER, @MOD_CHR,                   4),
    (@ROUSER, @MOD_HASTE,               100),
    (@ROUSER, @MOD_SONG_DURATION_BONUS,   5),
    (@ROUSER, @MOD_ALL_SONGS,             1);

DELETE FROM `item_latents` WHERE itemId = @ROUSER;
INSERT INTO `item_latents` VALUES (@ROUSER,@MOD_WIND_SKILL,3,@MOD_ABOVE_LEVEL,29);

-- Fife Tier II
SET @ROUSER_P1 = 21406; -- (Icon: Flute +2)
DELETE FROM `item_basic` WHERE itemid = @ROUSER_P1;
INSERT INTO `item_basic` VALUES (@ROUSER_P1,0,'rouser_+1','rouser_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @ROUSER_P1;
INSERT INTO `item_equipment` VALUES (@ROUSER_P1,'rouser_+1',50,0,@BRD,65,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @ROUSER_P1;
INSERT INTO `item_weapon` VALUES (@ROUSER_P1,'rouser_+1',@SKILL_WIND,0,0,0,0,0,1,240,0,0);

DELETE FROM `item_mods` WHERE itemId = @ROUSER_P1;
INSERT INTO `item_mods` VALUES
    (@ROUSER_P1, @MOD_CHR,                   6),
    (@ROUSER_P1, @MOD_HASTE,               300),
    (@ROUSER_P1, @MOD_WIND_SKILL,            3),
    (@ROUSER_P1, @MOD_SONG_DURATION_BONUS,  15),
    (@ROUSER_P1, @MOD_ALL_SONGS,             1);

DELETE FROM `item_latents` WHERE itemId = @ROUSER_P1;
INSERT INTO `item_latents` VALUES (@ROUSER_P1, @MOD_WIND_SKILL, 2, @MOD_ABOVE_LEVEL, 59);


-----------------------------------
-- Ammo Adjustments
-----------------------------------
UPDATE `item_weapon` SET dmg = 32 WHERE name = 'tin_bullet';
UPDATE `item_weapon` SET dmg = 38 WHERE name = 'copper_bullet';

-----------------------------------
-- CW Utility Items
-----------------------------------
SET @GARRISON_PASS = 3002;
DELETE FROM `item_basic` WHERE itemid = @GARRISON_PASS;
INSERT INTO `item_basic` VALUES (@GARRISON_PASS,0,'garrison_pass','garrison_pass',1,@ITEM_RARE,0,1,0);

SET @GOBLIN_KEYRING = 3003;
DELETE FROM `item_basic` WHERE itemid = @GOBLIN_KEYRING;
INSERT INTO `item_basic` VALUES (@GOBLIN_KEYRING,0,'goblin_keyring','goblin_keyring',1,@ITEM_RARE,0,1,0);

-----------------------------------
-- Letter from Adoulin: Idris/Epeolatry System
-----------------------------------
SET @ADOULIN_LETTER = 3020;
DELETE FROM `item_basic` WHERE itemid = @ADOULIN_LETTER;
INSERT INTO `item_basic` VALUES (@ADOULIN_LETTER,0,'adoulin_letter','adoulin_letter',1,@ITEM_RARE,0,1,0);

SET @BROKEN_SWORD = 3021;
DELETE FROM `item_basic` WHERE itemid = @BROKEN_SWORD;
INSERT INTO `item_basic` VALUES (@BROKEN_SWORD,0,'broken_sword','broken_sword',1,@ITEM_RARE,0,1,0);

SET @BROKEN_WAND = 3022;
DELETE FROM `item_basic` WHERE itemid = @BROKEN_WAND;
INSERT INTO `item_basic` VALUES (@BROKEN_WAND,0,'broken_wand','broken_wand',1,@ITEM_RARE,0,1,0);

-- Runic Scales
SET @RUNIC_SCALES = 3445;
DELETE FROM `item_basic` WHERE itemId = @RUNIC_SCALES;
INSERT INTO `item_basic` VALUES (@RUNIC_SCALES,0,'runic_scales','runic_scales',12,4,@BONECRAFT,0,5166);

-- Geoweave
SET @GEOWEAVE = 9500;
DELETE FROM `item_basic` WHERE itemId = @GEOWEAVE;
INSERT INTO `item_basic` VALUES (@GEOWEAVE,0,'geoweave','geoweave',12,4,@CLOTHCRAFT,0,4580);

-- Setup exclusive weapon skills
DELETE FROM `weapon_skills` WHERE `weaponskillid` IN (61, 175);
INSERT INTO `weapon_skills` VALUES (61,'dimidiation',0x00000000000000000000000000000000000000000001,4,230,0,119,2000,5,1,13,12,0,1,49);
INSERT INTO `weapon_skills` VALUES (175,'exudation',0x00000000000000000000000000000000000000200000,11,230,0,75,2000,5,1,14,12,0,1,0);

--  Idris (Level 75)
SET @IDRIS = 21070;
DELETE FROM `item_mods` WHERE itemId = @IDRIS;
INSERT INTO `item_mods` VALUES
    (@IDRIS, @MOD_MATT, 10),
    (@IDRIS, @MOD_MACC, 10),
    (@IDRIS, @MOD_AFTERMATH, 31),
    (@IDRIS, @MOD_ADDS_WEAPONSKILL, 175),
    (@IDRIS, @MOD_GEOMANCY_BONUS, 2);

DELETE FROM `item_equipment` WHERE itemId = @IDRIS;
INSERT INTO `item_equipment` VALUES (@IDRIS,'idris',75,0,1048576,707,0,0,3,0,0,0);

DELETE FROM `item_weapon` WHERE `itemId` = @IDRIS;
INSERT INTO `item_weapon` VALUES (@IDRIS,'idris',11,0,0,0,0,3,1,280,52,0);

DELETE FROM `item_mods_pet` WHERE `itemId` = @IDRIS;
INSERT INTO `item_mods_pet` VALUES (@IDRIS, @MOD_DAMAGE_TAKEN,-1000, @PET_LUOPAN);

-- Epeolatry (Level 75)
SET @EPEOLATRY = 20753;
DELETE FROM `item_mods` WHERE itemId = @EPEOLATRY;
INSERT INTO `item_mods` VALUES
    (@EPEOLATRY, @MOD_ENMITY, 10),
    (@EPEOLATRY, @MOD_PARRY_SKILL, 10),
    (@EPEOLATRY, @MOD_DMGPHYS_II, -1000),
    (@EPEOLATRY, @MOD_AFTERMATH, 29),
    (@EPEOLATRY, @MOD_ADDS_WEAPONSKILL, 61),
    (@EPEOLATRY, @MOD_ENMITY_LOSS_REDUCTION, 10);

DELETE FROM `item_equipment` WHERE itemId = @EPEOLATRY;
INSERT INTO `item_equipment` VALUES (@EPEOLATRY,'epeolatry',75,0,2097152,706,0,0,1,0,0,0);

DELETE FROM `item_weapon` WHERE `itemId` = @EPEOLATRY;
INSERT INTO `item_weapon` VALUES (@EPEOLATRY,'epeolatry',4,0,0,0,0,2,1,489,98,0);

-----------------------------------
-- Fomor Kings
-----------------------------------
SET @MUIRIDIAN_SACK = 6564;
DELETE FROM `item_basic` WHERE itemid = @MUIRIDIAN_SACK;
INSERT INTO `item_basic` VALUES (@MUIRIDIAN_SACK,0,'muiridian_sack','muiridian_sack',1,@ITEM_EXUSE,0,1,0);

DELETE FROM `item_usable` WHERE itemId = @MUIRIDIAN_SACK;
INSERT INTO `item_usable` VALUES (@MUIRIDIAN_SACK, 'muiridian_sack',  1, 1, 41, 0, 0, 0, 0, 0);

SET @MUIRIDIAN_GOLD = 3001;
DELETE FROM `item_basic` WHERE itemid = @MUIRIDIAN_GOLD;
INSERT INTO `item_basic` VALUES (@MUIRIDIAN_GOLD,0,'muiridian_gold','muiridian_gold',99,4,@AH_MISC,1,0);

DELETE FROM `item_usable` WHERE itemId = @MUIRIDIAN_GOLD;

-- Spectral Ore
SET @SPECTRAL_ORE = 9075;
DELETE FROM `item_basic` WHERE itemId = @SPECTRAL_ORE; -- Icon: Vulcanite Ore
INSERT INTO `item_basic` VALUES (@SPECTRAL_ORE,0,'spectral_ore','spectral_ore',12,4,@SMITHING,0,7642);

-- Removes ilvl Blurred recipes
DELETE FROM `synth_recipes` WHERE
    Ingredient1 = @SPECTRAL_ORE OR
    Ingredient2 = @SPECTRAL_ORE OR
    Ingredient3 = @SPECTRAL_ORE OR
    Ingredient4 = @SPECTRAL_ORE OR
    Ingredient5 = @SPECTRAL_ORE OR
    Ingredient6 = @SPECTRAL_ORE OR
    Ingredient7 = @SPECTRAL_ORE OR
    Ingredient8 = @SPECTRAL_ORE;

-- Slumber Ring
SET @SLUMBER_RING = 27135; -- Icon: Sulevia's Ring
DELETE FROM `item_basic` WHERE itemid = @SLUMBER_RING;
INSERT INTO `item_basic` VALUES (@SLUMBER_RING,0,'slumber_ring','slumber_ring',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SLUMBER_RING;
INSERT INTO `item_equipment` VALUES (@SLUMBER_RING,'slumber_ring',74,0,@ALL_JOBS,0,0,0,@SLOT_RING,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SLUMBER_RING;
INSERT INTO `item_mods` VALUES
    (@SLUMBER_RING, @MOD_DEF,           2),
    (@SLUMBER_RING, @MOD_ACC,           6),
    (@SLUMBER_RING, @MOD_DARK_RES,      4),
    (@SLUMBER_RING, @MOD_UNDEAD_KILLER, 6);

-- Ghost Pendant
SET @GHOST_PENDANT = 27321; -- Icon: Sand Charm
DELETE FROM `item_basic` WHERE itemid = @GHOST_PENDANT;
INSERT INTO `item_basic` VALUES (@GHOST_PENDANT,0,'ghost_pendant','ghost_pendant',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @GHOST_PENDANT;
INSERT INTO `item_equipment` VALUES (@GHOST_PENDANT,'ghost_pendant',74,0,@ALL_JOBS,0,0,0,@SLOT_NECK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @GHOST_PENDANT;
INSERT INTO `item_mods` VALUES
    (@GHOST_PENDANT, @MOD_DEF,           2),
    (@GHOST_PENDANT, @MOD_ACC,           6),
    (@GHOST_PENDANT, @MOD_STORE_TP,      2),
    (@GHOST_PENDANT, @MOD_UNDEAD_KILLER, 4);

-- Somber Shroud
SET @SOMBER_SHROUD = 27136; -- Icon: Tiger Mantle
DELETE FROM `item_basic` WHERE itemid = @SOMBER_SHROUD;
INSERT INTO `item_basic` VALUES (@SOMBER_SHROUD,0,'somber_shroud','somber_shroud',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @SOMBER_SHROUD;
INSERT INTO `item_equipment` VALUES (@SOMBER_SHROUD,'somber_shroud',74,0,@ALL_JOBS,0,0,0,@SLOT_BACK,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @SOMBER_SHROUD;
INSERT INTO `item_mods` VALUES
    (@SOMBER_SHROUD, @MOD_DEF,           3),
    (@SOMBER_SHROUD, @MOD_ACC,           8),
    (@SOMBER_SHROUD, @MOD_DARK_RES,     13),
    (@SOMBER_SHROUD, @MOD_UNDEAD_KILLER, 3);

-- Terror Talons
SET @TERROR_TALONS = 20517; -- Icon: Vampiric Claws
DELETE FROM `item_basic` WHERE itemid = @TERROR_TALONS;
INSERT INTO `item_basic` VALUES (@TERROR_TALONS,0,'terror_talons','terror_talons',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TERROR_TALONS;
INSERT INTO `item_equipment` VALUES (@TERROR_TALONS,'terror_talons',74,0,@MNK+@PUP,122,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @TERROR_TALONS;
INSERT INTO `item_weapon` VALUES (@TERROR_TALONS,'terror_talons',@SKILL_HAND_TO_HAND,0,0,0,0,@DMG_SLASHING,1,540,18,0);

DELETE FROM `item_mods` WHERE itemId = @TERROR_TALONS;
INSERT INTO `item_mods` VALUES
    (@TERROR_TALONS, @MOD_HP,                                25),
    (@TERROR_TALONS, @MOD_MP,                                25),
    (@TERROR_TALONS, @MOD_DEX,                                9),
    (@TERROR_TALONS, @MOD_ITEM_ADDEFFECT_TYPE,                5),
    (@TERROR_TALONS, @MOD_ITEM_SUBEFFECT,                    21), -- HP Drain
    (@TERROR_TALONS, @MOD_ITEM_ADDEFFECT_DMG,                15),
    (@TERROR_TALONS, @MOD_ITEM_ADDEFFECT_CHANCE,             20),
    (@TERROR_TALONS, @MOD_ITEM_ADDEFFECT_ELEMENT, @ELEMENT_DARK);

-----------------------------------
-- Blurred Crossbow
-----------------------------------
SET @BLURRED_CROSSBOW   = 21480;
SET @REPEATING_CROSSBOW = 17221;
SET @WOLFRAM_STEEL      = 2858;
SET @KAPOR_LUMBER       = 733;
SET @ADAMAN_INGOT       = 655;
DELETE FROM `item_basic` WHERE itemid = @BLURRED_CROSSBOW;
INSERT INTO `item_basic` VALUES (@BLURRED_CROSSBOW,0,'blurred_crossbow','blurred_crossbow',1,@ITEM_EQDEF,@AH_BOW,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BLURRED_CROSSBOW;
INSERT INTO `item_equipment` VALUES (@BLURRED_CROSSBOW,'blurred_crossbow',75,0,@RNG+@THF,130,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @BLURRED_CROSSBOW;
INSERT INTO `item_weapon` VALUES (@BLURRED_CROSSBOW,'blurred_crossbow',@SKILL_MARKSMANSHIP,0,0,0,0,@DMG_PIERCING,1,288,43,0);

DELETE FROM `item_mods` WHERE itemId = @BLURRED_CROSSBOW;
INSERT INTO `item_mods` VALUES
    (@BLURRED_CROSSBOW, @MOD_AGI,    7),
    (@BLURRED_CROSSBOW, @MOD_MND,    7),
    (@BLURRED_CROSSBOW, @MOD_RACC,  15),
    (@BLURRED_CROSSBOW, @MOD_RATT,   5);

SET @BLURRED_CROSSBOW_P1 = 21481;
DELETE FROM `item_basic` WHERE itemid = @BLURRED_CROSSBOW_P1;
INSERT INTO `item_basic` VALUES (@BLURRED_CROSSBOW_P1,0,'blurred_crossbow_+1','blurred_crossbow_+1',1,@ITEM_EQDEF,@AH_BOW,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BLURRED_CROSSBOW_P1;
INSERT INTO `item_equipment` VALUES (@BLURRED_CROSSBOW_P1,'blurred_crossbow_+1',75,0,@RNG+@THF,130,0,0,@SLOT_RANGED,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @BLURRED_CROSSBOW_P1;
INSERT INTO `item_weapon` VALUES (@BLURRED_CROSSBOW_P1,'blurred_crossbow_+1',@SKILL_MARKSMANSHIP,0,0,0,0,@DMG_PIERCING,1,280,44,0);

DELETE FROM `item_mods` WHERE itemId = @BLURRED_CROSSBOW_P1;
INSERT INTO `item_mods` VALUES
    (@BLURRED_CROSSBOW_P1, @MOD_AGI,       8),
    (@BLURRED_CROSSBOW_P1, @MOD_MND,       8),
    (@BLURRED_CROSSBOW_P1, @MOD_RACC,     18),
    (@BLURRED_CROSSBOW_P1, @MOD_RATT,     10),
    (@BLURRED_CROSSBOW_P1, @MOD_SNAPSHOT, 10);

SET @BLURRED_CROSSBOW_SYNTH = 80050;
DELETE FROM `synth_recipes` WHERE Result = @BLURRED_CROSSBOW;
INSERT INTO `synth_recipes` VALUES (
    @BLURRED_CROSSBOW_SYNTH,0,0,
    50,105,0,0, -- Wood/Smith/Gold/Cloth
    0,0,0,0,    -- Leather/Bone/Alchemy/Cooking
    @FIRE_CRYSTAL,@INFERNO_CRYSTAL,
        @ADAMAN_INGOT,@KAPOR_LUMBER,@KAPOR_LUMBER,@WOLFRAM_STEEL,@SPECTRAL_ORE,@SPECTRAL_ORE,@REPEATING_CROSSBOW,0, -- Materials
    @BLURRED_CROSSBOW,@BLURRED_CROSSBOW_P1,@BLURRED_CROSSBOW_P1,@BLURRED_CROSSBOW_P1,1,1,1,1,'Blurred Crossbow'       -- Results
);

-----------------------------------
-- Blurred Claws
-----------------------------------
SET @BLURRED_CLAWS = 20525;
SET @DRAGON_CLAWS  = 16416;
SET @MAMMOTH_TUSK  = 1458;
DELETE FROM `item_basic` WHERE itemid = @BLURRED_CLAWS;
INSERT INTO `item_basic` VALUES (@BLURRED_CLAWS,0,'blurred_claws','blurred_claws',1,@ITEM_EQDEF,@AH_H2H,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BLURRED_CLAWS;
INSERT INTO `item_equipment` VALUES (@BLURRED_CLAWS,'blurred_claws',75,0,@MNK+@PUP,486,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @BLURRED_CLAWS;
INSERT INTO `item_weapon` VALUES (@BLURRED_CLAWS,'blurred_claws',@SKILL_HAND_TO_HAND,0,0,0,0,@DMG_IMPACT,1,576,18,0);

DELETE FROM `item_mods` WHERE itemId = @BLURRED_CLAWS;
INSERT INTO `item_mods` VALUES
    (@BLURRED_CLAWS, @MOD_STR,    7),
    (@BLURRED_CLAWS, @MOD_VIT,    7),
    (@BLURRED_CLAWS, @MOD_ACC,   10);

SET @BLURRED_CLAWS_P1 = 20526;
DELETE FROM `item_basic` WHERE itemid = @BLURRED_CLAWS_P1;
INSERT INTO `item_basic` VALUES (@BLURRED_CLAWS_P1,0,'blurred_claws_+1','blurred_claws_+1',1,@ITEM_EQDEF,@AH_H2H,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BLURRED_CLAWS_P1;
INSERT INTO `item_equipment` VALUES (@BLURRED_CLAWS_P1,'blurred_claws_+1',75,0,@MNK+@PUP,486,0,0,@SLOT_TWOHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @BLURRED_CLAWS_P1;
INSERT INTO `item_weapon` VALUES (@BLURRED_CLAWS_P1,'blurred_claws_+1',@SKILL_HAND_TO_HAND,0,0,0,0,@DMG_IMPACT,1,571,19,0);

DELETE FROM `item_mods` WHERE itemId = @BLURRED_CLAWS_P1;
INSERT INTO `item_mods` VALUES
    (@BLURRED_CLAWS_P1, @MOD_STR,           8),
    (@BLURRED_CLAWS_P1, @MOD_VIT,           8),
    (@BLURRED_CLAWS_P1, @MOD_ACC,          12),
    (@BLURRED_CLAWS_P1, @MOD_MARTIAL_ARTS, 10);

SET @BLURRED_CLAWS_SYNTH = 80051;
DELETE FROM `synth_recipes` WHERE Result = @BLURRED_CLAWS;
INSERT INTO `synth_recipes` VALUES (
    @BLURRED_CLAWS_SYNTH,0,0,
    0,105,0,0, -- Wood/Smith/Gold/Cloth
    0,50,0,0,  -- Leather/Bone/Alchemy/Cooking
    @FIRE_CRYSTAL,@INFERNO_CRYSTAL,
        @ADAMAN_INGOT,@MAMMOTH_TUSK,@MAMMOTH_TUSK,@WOLFRAM_STEEL,@SPECTRAL_ORE,@SPECTRAL_ORE,@DRAGON_CLAWS,0, -- Materials
    @BLURRED_CLAWS,@BLURRED_CLAWS_P1,@BLURRED_CLAWS_P1,@BLURRED_CLAWS_P1,1,1,1,1,'Blurred Claws'              -- Results
);

-----------------------------------
-- Blurred Rod
-----------------------------------
SET @BLURRED_ROD   = 21093;
SET @SCEPTER       = 17064;
SET @THOKCHA_INGOT = 735;
DELETE FROM `item_basic` WHERE itemid = @BLURRED_ROD;
INSERT INTO `item_basic` VALUES (@BLURRED_ROD,0,'blurred_rod','blurred_rod',1,@ITEM_EQDEF,@AH_CLUB,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BLURRED_ROD;
INSERT INTO `item_equipment` VALUES (@BLURRED_ROD,'blurred_rod',75,0,@WAR+@MNK+@WHM+@BLM+@PLD+@SMN+@BLU+@SCH+@GEO,748,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @BLURRED_ROD;
INSERT INTO `item_weapon` VALUES (@BLURRED_ROD,'blurred_rod',@SKILL_CLUB,0,0,0,0,@DMG_IMPACT,1,288,39,0);

DELETE FROM `item_mods` WHERE itemId = @BLURRED_ROD;
INSERT INTO `item_mods` VALUES
    (@BLURRED_ROD, @MOD_INT,    7),
    (@BLURRED_ROD, @MOD_MND,    7),
    (@BLURRED_ROD, @MOD_MACC,  10),
    (@BLURRED_ROD, @MOD_ACC,   10);

SET @BLURRED_ROD_P1 = 21094;
DELETE FROM `item_basic` WHERE itemid = @BLURRED_ROD_P1;
INSERT INTO `item_basic` VALUES (@BLURRED_ROD_P1,0,'blurred_rod_+1','blurred_rod_+1',1,@ITEM_EQDEF,@AH_CLUB,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BLURRED_ROD_P1;
INSERT INTO `item_equipment` VALUES (@BLURRED_ROD_P1,'blurred_rod_+1',75,0,@WAR+@MNK+@WHM+@BLM+@PLD+@SMN+@BLU+@SCH+@GEO,748,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @BLURRED_ROD_P1;
INSERT INTO `item_weapon` VALUES (@BLURRED_ROD_P1,'blurred_rod_+1',@SKILL_CLUB,0,0,0,0,@DMG_IMPACT,2,280,40,0); -- Occ. attack twice

DELETE FROM `item_mods` WHERE itemId = @BLURRED_ROD_P1;
INSERT INTO `item_mods` VALUES
    (@BLURRED_ROD_P1, @MOD_INT,    8),
    (@BLURRED_ROD_P1, @MOD_MND,    8),
    (@BLURRED_ROD_P1, @MOD_MACC,  12),
    (@BLURRED_ROD_P1, @MOD_ACC,   12);

SET @BLURRED_ROD_SYNTH = 80052;
DELETE FROM `synth_recipes` WHERE Result = @BLURRED_ROD;
INSERT INTO `synth_recipes` VALUES (
    @BLURRED_ROD_SYNTH,0,0,
    0,105,50,0, -- Wood/Smith/Gold/Cloth
    0,0,0,0,    -- Leather/Bone/Alchemy/Cooking
    @FIRE_CRYSTAL,@INFERNO_CRYSTAL,
        @ADAMAN_INGOT,@THOKCHA_INGOT,@THOKCHA_INGOT,@WOLFRAM_STEEL,@SPECTRAL_ORE,@SPECTRAL_ORE,@SCEPTER,0, -- Materials
    @BLURRED_ROD,@BLURRED_ROD_P1,@BLURRED_ROD_P1,@BLURRED_ROD_P1,1,1,1,1,'Blurred Rod'                     -- Results
);

-----------------------------------
-- Tempest Bonnet
-----------------------------------
-- Geoweave          x1
-- Fable Cloth       x1
-- Akaso Thread      x1
-- Elementium Thread x1
SET @TEMPEST_BONNET = 25581;
SET @AKASO_THREAD   = 4027;
DELETE FROM `item_basic` WHERE itemid = @TEMPEST_BONNET;
INSERT INTO `item_basic` VALUES (@TEMPEST_BONNET,0,'tempest_bonnet','tempest_bonnet',1,@ITEM_EQDEF,@AH_HEAD,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TEMPEST_BONNET;
INSERT INTO `item_equipment` VALUES (@TEMPEST_BONNET,'tempest_bonnet',70,0,@GEO,196,0,0,@SLOT_HEAD,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TEMPEST_BONNET;
INSERT INTO `item_mods` VALUES
    (@TEMPEST_BONNET, @MOD_DEF,   26),
    (@TEMPEST_BONNET, @MOD_MP,    25),
    (@TEMPEST_BONNET, @MOD_HASTE,  3),
    (@TEMPEST_BONNET, @MOD_ACC,    7);

SET @TEMPEST_BONNET_P1 = 25582;
DELETE FROM `item_basic` WHERE itemid = @TEMPEST_BONNET_P1;
INSERT INTO `item_basic` VALUES (@TEMPEST_BONNET_P1,0,'tempest_bonnet_+1','tempest_bonnet_+1',1,@ITEM_EQDEF,@AH_HEAD,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TEMPEST_BONNET_P1;
INSERT INTO `item_equipment` VALUES (@TEMPEST_BONNET_P1,'tempest_bonnet_+1',70,0,@GEO,196,0,0,@SLOT_HEAD,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TEMPEST_BONNET_P1;
INSERT INTO `item_mods` VALUES
    (@TEMPEST_BONNET_P1, @MOD_DEF,   27),
    (@TEMPEST_BONNET_P1, @MOD_MP,    30),
    (@TEMPEST_BONNET_P1, @MOD_HASTE,  4),
    (@TEMPEST_BONNET_P1, @MOD_ACC,    8);

SET @TEMPEST_BONNET_SYNTH    = 80039;
DELETE FROM `synth_recipes` WHERE Result = @TEMPEST_BONNET;
INSERT INTO `synth_recipes` VALUES (
    @TEMPEST_BONNET_SYNTH,0,0,
    0,0,0,95,  -- Wood/Smith/Gold/Cloth
    0,0,0,0,   -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,
        @AKASO_THREAD,@FABLE_CLOTH,@ELEMENTIUM_THREAD,@GEOWEAVE,0,0,0,0,                              -- Materials
    @TEMPEST_BONNET,@TEMPEST_BONNET_P1,@TEMPEST_BONNET_P1,@TEMPEST_BONNET_P1,1,1,1,1,'Tempest Bonnet' -- Results
);

-----------------------------------
-- Tempest Jacket
-----------------------------------
-- Geoweave          x2
-- Fable Cloth       x2
-- Akaso Thread      x2
-- Elementium Thread x1
-- Gold Thread       x1
SET @TEMPEST_JACKET = 25781;
SET @GOLD_THREAD    =  823;
DELETE FROM `item_basic` WHERE itemid = @TEMPEST_JACKET;
INSERT INTO `item_basic` VALUES (@TEMPEST_JACKET,0,'tempest_jacket','tempest_jacket',1,@ITEM_EQDEF,@AH_BODY,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TEMPEST_JACKET;
INSERT INTO `item_equipment` VALUES (@TEMPEST_JACKET,'tempest_jacket',70,0,@GEO,196,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TEMPEST_JACKET;
INSERT INTO `item_mods` VALUES
    (@TEMPEST_JACKET, @MOD_DEF,   43),
    (@TEMPEST_JACKET, @MOD_MP,    35),
    (@TEMPEST_JACKET, @MOD_MATT,   7),
    (@TEMPEST_JACKET, @MOD_HASTE,  1),
    (@TEMPEST_JACKET, @MOD_ACC,    8);

SET @TEMPEST_JACKET_P1 = 25782;
DELETE FROM `item_basic` WHERE itemid = @TEMPEST_JACKET_P1;
INSERT INTO `item_basic` VALUES (@TEMPEST_JACKET_P1,0,'tempest_jacket_+1','tempest_jacket_+1',1,@ITEM_EQDEF,@AH_BODY,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TEMPEST_JACKET_P1;
INSERT INTO `item_equipment` VALUES (@TEMPEST_JACKET_P1,'tempest_jacket_+1',70,0,@GEO,196,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TEMPEST_JACKET_P1;
INSERT INTO `item_mods` VALUES
    (@TEMPEST_JACKET_P1, @MOD_DEF,   44),
    (@TEMPEST_JACKET_P1, @MOD_MP,    40),
    (@TEMPEST_JACKET_P1, @MOD_MATT,   8),
    (@TEMPEST_JACKET_P1, @MOD_HASTE,  2),
    (@TEMPEST_JACKET_P1, @MOD_ACC,   10);

SET @TEMPEST_JACKET_SYNTH = 80040;
DELETE FROM `synth_recipes` WHERE Result = @TEMPEST_JACKET;
INSERT INTO `synth_recipes` VALUES (
    @TEMPEST_JACKET_SYNTH,0,0,
    0,0,0,100, -- Wood/Smith/Gold/Cloth
    0,0,0,0,   -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,
        @GOLD_THREAD,@AKASO_THREAD,@AKASO_THREAD,@FABLE_CLOTH,@FABLE_CLOTH,@ELEMENTIUM_THREAD,@GEOWEAVE,@GEOWEAVE, -- Materials
    @TEMPEST_JACKET,@TEMPEST_JACKET_P1,@TEMPEST_JACKET_P1,@TEMPEST_JACKET_P1,1,1,1,1,'Tempest Jacket'              -- Results
);

-----------------------------------
-- Tempest Wrists
-----------------------------------
-- Geoweave          x1
-- Fable Cloth       x2
-- Elementium Thread x1
-- Akaso Thread      x2
SET @TEMPEST_WRISTS = 25820;
DELETE FROM `item_basic` WHERE itemid = @TEMPEST_WRISTS;
INSERT INTO `item_basic` VALUES (@TEMPEST_WRISTS,0,'tempest_wrists','tempest_wrists',1,@ITEM_EQDEF,@AH_HANDS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TEMPEST_WRISTS;
INSERT INTO `item_equipment` VALUES (@TEMPEST_WRISTS,'tempest_wrists',70,0,@GEO,196,0,0,@SLOT_HANDS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TEMPEST_WRISTS;
INSERT INTO `item_mods` VALUES
    (@TEMPEST_WRISTS, @MOD_DEF,    21),
    (@TEMPEST_WRISTS, @MOD_MP,     15),
    (@TEMPEST_WRISTS, @MOD_ATT,     4),
    (@TEMPEST_WRISTS, @MOD_HASTE, 400);

SET @TEMPEST_WRISTS_P1 = 25821;
DELETE FROM `item_basic` WHERE itemid = @TEMPEST_WRISTS_P1;
INSERT INTO `item_basic` VALUES (@TEMPEST_WRISTS_P1,0,'tempest_wrists_+1','tempest_wrists_+1',1,@ITEM_EQDEF,@AH_HANDS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TEMPEST_WRISTS_P1;
INSERT INTO `item_equipment` VALUES (@TEMPEST_WRISTS_P1,'tempest_wrists_+1',70,0,@GEO,196,0,0,@SLOT_HANDS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TEMPEST_WRISTS_P1;
INSERT INTO `item_mods` VALUES
    (@TEMPEST_WRISTS_P1, @MOD_DEF,    22),
    (@TEMPEST_WRISTS_P1, @MOD_MP,     20),
    (@TEMPEST_WRISTS_P1, @MOD_ATT,     5),
    (@TEMPEST_WRISTS_P1, @MOD_HASTE, 500);

SET @TEMPEST_WRISTS_SYNTH = 80041;
DELETE FROM `synth_recipes` WHERE Result = @TEMPEST_WRISTS;
INSERT INTO `synth_recipes` VALUES (
    @TEMPEST_WRISTS_SYNTH,0,0,
    0,0,0,96, -- Wood/Smith/Gold/Cloth
    0,0,0,0,  -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,
        @AKASO_THREAD,@AKASO_THREAD,@FABLE_CLOTH,@FABLE_CLOTH,@ELEMENTIUM_THREAD,@GEOWEAVE,0,0,       -- Materials
    @TEMPEST_WRISTS,@TEMPEST_WRISTS_P1,@TEMPEST_WRISTS_P1,@TEMPEST_WRISTS_P1,1,1,1,1,'Tempest Wrists' -- Results
);

-----------------------------------
-- Tempest Kecks
-----------------------------------
-- Geoweave          x2
-- Fable Cloth       x2
-- Elementium Thread x1
-- Akaso Thread      x1
SET @TEMPEST_KECKS = 25875;
DELETE FROM `item_basic` WHERE itemid = @TEMPEST_KECKS;
INSERT INTO `item_basic` VALUES (@TEMPEST_KECKS,0,'tempest_kecks','tempest_kecks',1,@ITEM_EQDEF,@AH_LEGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TEMPEST_KECKS;
INSERT INTO `item_equipment` VALUES (@TEMPEST_KECKS,'tempest_kecks',70,0,@GEO,196,0,0,@SLOT_LEGS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TEMPEST_KECKS;
INSERT INTO `item_mods` VALUES
    (@TEMPEST_KECKS, @MOD_DEF,    29),
    (@TEMPEST_KECKS, @MOD_MP,     25),
    (@TEMPEST_KECKS, @MOD_MATT,    4),
    (@TEMPEST_KECKS, @MOD_ATT,     8),
    (@TEMPEST_KECKS, @MOD_HASTE, 300);

SET @TEMPEST_KECKS_P1 = 25876;
DELETE FROM `item_basic` WHERE itemid = @TEMPEST_KECKS_P1;
INSERT INTO `item_basic` VALUES (@TEMPEST_KECKS_P1,0,'tempest_kecks_+1','tempest_kecks_+1',1,@ITEM_EQDEF,@AH_LEGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TEMPEST_KECKS_P1;
INSERT INTO `item_equipment` VALUES (@TEMPEST_KECKS_P1,'tempest_kecks_+1',70,0,@GEO,196,0,0,@SLOT_LEGS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TEMPEST_KECKS_P1;
INSERT INTO `item_mods` VALUES
    (@TEMPEST_KECKS_P1, @MOD_DEF,    30),
    (@TEMPEST_KECKS_P1, @MOD_MP,     30),
    (@TEMPEST_KECKS_P1, @MOD_MATT,    5),
    (@TEMPEST_KECKS_P1, @MOD_ATT,    10),
    (@TEMPEST_KECKS_P1, @MOD_HASTE, 400);

SET @TEMPEST_KECKS_SYNTH = 80042;
DELETE FROM `synth_recipes` WHERE Result = @TEMPEST_KECKS;
INSERT INTO `synth_recipes` VALUES (
    @TEMPEST_KECKS_SYNTH,0,0,
    0,0,0,97, -- Wood/Smith/Gold/Cloth
    0,0,0,0,  -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,
        @AKASO_THREAD,@FABLE_CLOTH,@FABLE_CLOTH,@ELEMENTIUM_THREAD,@GEOWEAVE,@GEOWEAVE,0,0,      -- Materials
    @TEMPEST_KECKS,@TEMPEST_KECKS_P1,@TEMPEST_KECKS_P1,@TEMPEST_KECKS_P1,1,1,1,1,'Tempest Kecks' -- Results
);

-----------------------------------
-- Tempest Gamashes
-----------------------------------
-- Geoweave          x1
-- Fable Cloth       x2
-- Elementium Thread x1
-- Akaso Thread      x1
SET @TEMPEST_GAMASHES = 25942;
DELETE FROM `item_basic` WHERE itemid = @TEMPEST_GAMASHES;
INSERT INTO `item_basic` VALUES (@TEMPEST_GAMASHES,0,'tempest_gamashes','tempest_gamashes',1,@ITEM_EQDEF,@AH_FEET,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TEMPEST_GAMASHES;
INSERT INTO `item_equipment` VALUES (@TEMPEST_GAMASHES,'tempest_gamashes',70,0,@GEO,196,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TEMPEST_GAMASHES;
INSERT INTO `item_mods` VALUES
    (@TEMPEST_GAMASHES, @MOD_DEF,    14),
    (@TEMPEST_GAMASHES, @MOD_MP,     15),
    (@TEMPEST_GAMASHES, @MOD_MATT,    4),
    (@TEMPEST_GAMASHES, @MOD_ATT,    12);

SET @TEMPEST_GAMASHES_P1 = 25943;
DELETE FROM `item_basic` WHERE itemid = @TEMPEST_GAMASHES_P1;
INSERT INTO `item_basic` VALUES (@TEMPEST_GAMASHES_P1,0,'tempest_gamashes_+1','tempest_gamashes_+1',1,@ITEM_EQDEF,@AH_FEET,1,0);

DELETE FROM `item_equipment` WHERE itemId = @TEMPEST_GAMASHES_P1;
INSERT INTO `item_equipment` VALUES (@TEMPEST_GAMASHES_P1,'tempest_gamashes_+1',70,0,@GEO,196,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @TEMPEST_GAMASHES_P1;
INSERT INTO `item_mods` VALUES
    (@TEMPEST_GAMASHES_P1, @MOD_DEF,    15),
    (@TEMPEST_GAMASHES_P1, @MOD_MP,     20),
    (@TEMPEST_GAMASHES_P1, @MOD_MATT,    5),
    (@TEMPEST_GAMASHES_P1, @MOD_ATT,    15);

SET @TEMPEST_GAMASHES_SYNTH = 80043;
DELETE FROM `synth_recipes` WHERE Result = @TEMPEST_GAMASHES;
INSERT INTO `synth_recipes` VALUES (
    @TEMPEST_GAMASHES_SYNTH,0,0,
    0,0,0,94, -- Wood/Smith/Gold/Cloth
    0,0,0,0,  -- Leather/Bone/Alchemy/Cooking
    @EARTH_CRYSTAL,@TERRA_CRYSTAL,
        @AKASO_THREAD,@FABLE_CLOTH,@FABLE_CLOTH,@ELEMENTIUM_THREAD,@GEOWEAVE,0,0,0,                             -- Materials
    @TEMPEST_GAMASHES,@TEMPEST_GAMASHES_P1,@TEMPEST_GAMASHES_P1,@TEMPEST_GAMASHES_P1,1,1,1,1,'Tempest Gamashes' -- Results
);

-- Elementium Stud
SET @ELEMENTIUM_STUD = 9490;
DELETE FROM `item_basic` WHERE itemId = @ELEMENTIUM_STUD;
INSERT INTO `item_basic` VALUES (@ELEMENTIUM_STUD,0,'elementium_stud','elementium_stud',12,4,@SMITHING,0,3380);

SET @ELEMENTIUM_STUD_SYNTH = 80044;
DELETE FROM `synth_recipes` WHERE Result = @ELEMENTIUM_STUD;
INSERT INTO `synth_recipes` VALUES (
    @ELEMENTIUM_STUD_SYNTH,0,0,
    0,94,0,0, -- Wood/Smith/Gold/Cloth
    0,0,0,0,  -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,@REFINED_ELEMENTIUM,0,0,0,0,0,0,0,                             -- Materials
    @ELEMENTIUM_STUD,@ELEMENTIUM_STUD,@ELEMENTIUM_STUD,@ELEMENTIUM_STUD,1,2,3,4,'Elementium Stud' -- Results
);

-----------------------------------
-- Dux Visor
-----------------------------------
-- Runic Scales    x1
-- Titanium Ingot  x1
-- Matamata Shell  x1
-- Elementium Stud x1
SET @DUX_MODEL = 336;
SET @DUX_VISOR = 10434;
DELETE FROM `item_basic` WHERE itemid = @DUX_VISOR;
INSERT INTO `item_basic` VALUES (@DUX_VISOR,0,'dux_visor','dux_visor',1,@ITEM_EQDEF,@AH_HEAD,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DUX_VISOR;
INSERT INTO `item_equipment` VALUES (@DUX_VISOR,'dux_visor',70,0,@RUN,@DUX_MODEL,0,0,@SLOT_HEAD,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DUX_VISOR;
INSERT INTO `item_mods` VALUES
    (@DUX_VISOR, @MOD_DEF,              27),
    (@DUX_VISOR, @MOD_STR,               5),
    (@DUX_VISOR, @MOD_ATT,              13),
    (@DUX_VISOR, @MOD_PHYS_DMG_TAKEN, -300),
    (@DUX_VISOR, @MOD_ENMITY,            3);

SET @DUX_VISOR_P1 = 10435;
DELETE FROM `item_basic` WHERE itemid = @DUX_VISOR_P1;
INSERT INTO `item_basic` VALUES (@DUX_VISOR_P1,0,'dux_visor_+1','dux_visor_+1',1,@ITEM_EQDEF,@AH_HEAD,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DUX_VISOR_P1;
INSERT INTO `item_equipment` VALUES (@DUX_VISOR_P1,'dux_visor_+1',70,0,@RUN,@DUX_MODEL,0,0,@SLOT_HEAD,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DUX_VISOR_P1;
INSERT INTO `item_mods` VALUES
    (@DUX_VISOR_P1, @MOD_DEF,              28),
    (@DUX_VISOR_P1, @MOD_STR,               6),
    (@DUX_VISOR_P1, @MOD_ATT,              14),
    (@DUX_VISOR_P1, @MOD_PHYS_DMG_TAKEN, -400),
    (@DUX_VISOR_P1, @MOD_ENMITY,            4);

SET @DUX_VISOR_SYNTH = 80045;
DELETE FROM `synth_recipes` WHERE Result = @DUX_VISOR;
INSERT INTO `synth_recipes` VALUES (
    @DUX_VISOR_SYNTH,0,0,
    0,0,0,0,    -- Wood/Smith/Gold/Cloth
    0,95,0,0,   -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @RUNIC_SCALES,@MATAMATA_SHELL,@TITANIUM_INGOT,@ELEMENTIUM_STUD,0,0,0,0, -- Materials
    @DUX_VISOR,@DUX_VISOR_P1,@DUX_VISOR_P1,@DUX_VISOR_P1,1,1,1,1,'Dux Visor'    -- Results
);

-----------------------------------
-- Dux Scale Mail
-----------------------------------
-- Runic Scales    x2
-- Titanium Ingot  x2
-- Matamata Shell  x2
-- Elementium Stud x1
-- Squamous Hide   x1
SET @DUX_SCALE_MAIL = 10272;
DELETE FROM `item_basic` WHERE itemid = @DUX_SCALE_MAIL;
INSERT INTO `item_basic` VALUES (@DUX_SCALE_MAIL,0,'dux_scale_mail','dux_scale_mail',1,@ITEM_EQDEF,@AH_BODY,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DUX_SCALE_MAIL;
INSERT INTO `item_equipment` VALUES (@DUX_SCALE_MAIL,'dux_scale_mail',70,0,@RUN,@DUX_MODEL,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DUX_SCALE_MAIL;
INSERT INTO `item_mods` VALUES
    (@DUX_SCALE_MAIL, @MOD_DEF,              51),
    (@DUX_SCALE_MAIL, @MOD_STR,               9),
    (@DUX_SCALE_MAIL, @MOD_VIT,               9),
    (@DUX_SCALE_MAIL, @MOD_ATT,              15),
    (@DUX_SCALE_MAIL, @MOD_PHYS_DMG_TAKEN, -400),
    (@DUX_SCALE_MAIL, @MOD_ENMITY,            6);

SET @DUX_SCALE_MAIL_P1 = 10273;
DELETE FROM `item_basic` WHERE itemid = @DUX_SCALE_MAIL_P1;
INSERT INTO `item_basic` VALUES (@DUX_SCALE_MAIL_P1,0,'dux_scale_mail_+1','dux_scale_mail_+1',1,@ITEM_EQDEF,@AH_BODY,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DUX_SCALE_MAIL_P1;
INSERT INTO `item_equipment` VALUES (@DUX_SCALE_MAIL_P1,'dux_scale_mail_+1',70,0,@RUN,@DUX_MODEL,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DUX_SCALE_MAIL_P1;
INSERT INTO `item_mods` VALUES
    (@DUX_SCALE_MAIL_P1, @MOD_DEF,              52),
    (@DUX_SCALE_MAIL_P1, @MOD_STR,              10),
    (@DUX_SCALE_MAIL_P1, @MOD_VIT,              10),
    (@DUX_SCALE_MAIL_P1, @MOD_ATT,              16),
    (@DUX_SCALE_MAIL_P1, @MOD_PHYS_DMG_TAKEN, -500),
    (@DUX_SCALE_MAIL_P1, @MOD_ENMITY,            7);

SET @DUX_SCALE_MAIL_SYNTH = 80046;
SET @SQUAMOUS_HIDE        =  3552;
DELETE FROM `synth_recipes` WHERE Result = @DUX_SCALE_MAIL;
INSERT INTO `synth_recipes` VALUES (
    @DUX_SCALE_MAIL_SYNTH,0,0,
    0,0,0,0,   -- Wood/Smith/Gold/Cloth
    0,100,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @RUNIC_SCALES,@RUNIC_SCALES,@SQUAMOUS_HIDE,@MATAMATA_SHELL,@MATAMATA_SHELL,@TITANIUM_INGOT,@TITANIUM_INGOT,@ELEMENTIUM_STUD, -- Materials
    @DUX_SCALE_MAIL,@DUX_SCALE_MAIL_P1,@DUX_SCALE_MAIL_P1,@DUX_SCALE_MAIL_P1,1,1,1,1,'Dux Scale Mail'                                -- Results
);

-----------------------------------
-- Dux Finger Gauntlets
-----------------------------------
-- Runic Scales     x1
-- Titanium Ingot   x2
-- Matamata Shell   x2
-- Elementium Study x1
SET @DUX_FINGER_GAUNTLETS = 10316;
DELETE FROM `item_basic` WHERE itemid = @DUX_FINGER_GAUNTLETS;
INSERT INTO `item_basic` VALUES (@DUX_FINGER_GAUNTLETS,0,'dux_finger_gauntlets','dux_finger_gauntlets',1,@ITEM_EQDEF,@AH_HANDS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DUX_FINGER_GAUNTLETS;
INSERT INTO `item_equipment` VALUES (@DUX_FINGER_GAUNTLETS,'dux_finger_gauntlets',70,0,@RUN,@DUX_MODEL,0,0,@SLOT_HANDS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DUX_FINGER_GAUNTLETS;
INSERT INTO `item_mods` VALUES
    (@DUX_FINGER_GAUNTLETS, @MOD_DEF,              20),
    (@DUX_FINGER_GAUNTLETS, @MOD_VIT,               4),
    (@DUX_FINGER_GAUNTLETS, @MOD_ACC,              10),
    (@DUX_FINGER_GAUNTLETS, @MOD_PHYS_DMG_TAKEN, -200),
    (@DUX_FINGER_GAUNTLETS, @MOD_ENMITY,            4);

SET @DUX_FINGER_GAUNTLETS_P1 = 10317;
DELETE FROM `item_basic` WHERE itemid = @DUX_FINGER_GAUNTLETS_P1;
INSERT INTO `item_basic` VALUES (@DUX_FINGER_GAUNTLETS_P1,0,'dux_finger_gauntlets_+1','dux_finger_gauntlets_+1',1,@ITEM_EQDEF,@AH_HANDS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DUX_FINGER_GAUNTLETS_P1;
INSERT INTO `item_equipment` VALUES (@DUX_FINGER_GAUNTLETS_P1,'dux_finger_gauntlets_+1',70,0,@RUN,@DUX_MODEL,0,0,@SLOT_HANDS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DUX_FINGER_GAUNTLETS_P1;
INSERT INTO `item_mods` VALUES
    (@DUX_FINGER_GAUNTLETS_P1, @MOD_DEF,              21),
    (@DUX_FINGER_GAUNTLETS_P1, @MOD_VIT,               5),
    (@DUX_FINGER_GAUNTLETS_P1, @MOD_ATT,              11),
    (@DUX_FINGER_GAUNTLETS_P1, @MOD_PHYS_DMG_TAKEN, -300),
    (@DUX_FINGER_GAUNTLETS_P1, @MOD_ENMITY,            5);

SET @DUX_FINGER_GAUNTLETS_SYNTH = 80047;
DELETE FROM `synth_recipes` WHERE Result = @DUX_FINGER_GAUNTLETS;
INSERT INTO `synth_recipes` VALUES (
    @DUX_FINGER_GAUNTLETS_SYNTH,0,0,
    0,0,0,0,   -- Wood/Smith/Gold/Cloth
    0,96,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @RUNIC_SCALES,@MATAMATA_SHELL,@MATAMATA_SHELL,@TITANIUM_INGOT,@TITANIUM_INGOT,@ELEMENTIUM_STUD,0,0,                           -- Materials
    @DUX_FINGER_GAUNTLETS,@DUX_FINGER_GAUNTLETS_P1,@DUX_FINGER_GAUNTLETS_P1,@DUX_FINGER_GAUNTLETS_P1,1,1,1,1,'Dux Finger Gauntlets'   -- Results
);

-----------------------------------
-- Dux Cuisses
-----------------------------------
-- Runic Scales     x2
-- Titanium Ingot   x2
-- Matamata Shell   x1
-- Elementium Study x1
SET @DUX_CUISSES = 10346;
DELETE FROM `item_basic` WHERE itemid = @DUX_CUISSES;
INSERT INTO `item_basic` VALUES (@DUX_CUISSES,0,'dux_cuisses','dux_cuisses',1,@ITEM_EQDEF,@AH_LEGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DUX_CUISSES;
INSERT INTO `item_equipment` VALUES (@DUX_CUISSES,'dux_cuisses',70,0,@RUN,@DUX_MODEL,0,0,@SLOT_LEGS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DUX_CUISSES;
INSERT INTO `item_mods` VALUES
    (@DUX_CUISSES, @MOD_DEF,              40),
    (@DUX_CUISSES, @MOD_STR,               7),
    (@DUX_CUISSES, @MOD_ATT,              11),
    (@DUX_CUISSES, @MOD_PHYS_DMG_TAKEN, -400),
    (@DUX_CUISSES, @MOD_ENMITY,            5);

SET @DUX_CUISSES_P1 = 10347;
DELETE FROM `item_basic` WHERE itemid = @DUX_CUISSES_P1;
INSERT INTO `item_basic` VALUES (@DUX_CUISSES_P1,0,'dux_cuisses_+1','dux_cuisses_+1',1,@ITEM_EQDEF,@AH_LEGS,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DUX_CUISSES_P1;
INSERT INTO `item_equipment` VALUES (@DUX_CUISSES_P1,'dux_cuisses_+1',70,0,@RUN,@DUX_MODEL,0,0,@SLOT_LEGS,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DUX_CUISSES_P1;
INSERT INTO `item_mods` VALUES
    (@DUX_CUISSES_P1, @MOD_DEF,              41),
    (@DUX_CUISSES_P1, @MOD_VIT,               8),
    (@DUX_CUISSES_P1, @MOD_ATT,              12),
    (@DUX_CUISSES_P1, @MOD_PHYS_DMG_TAKEN, -500),
    (@DUX_CUISSES_P1, @MOD_ENMITY,            6);

SET @DUX_CUISSES_SYNTH = 80048;
DELETE FROM `synth_recipes` WHERE Result = @DUX_CUISSES;
INSERT INTO `synth_recipes` VALUES (
    @DUX_CUISSES_SYNTH,0,0,
    0,0,0,0,  -- Wood/Smith/Gold/Cloth
    0,97,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @RUNIC_SCALES,@RUNIC_SCALES,@MATAMATA_SHELL,@TITANIUM_INGOT,@TITANIUM_INGOT,@ELEMENTIUM_STUD,0,0, -- Materials
    @DUX_CUISSES,@DUX_CUISSES_P1,@DUX_CUISSES_P1,@DUX_CUISSES_P1,1,1,1,1,'Dux Cuisses'                    -- Results
);

-----------------------------------
-- Dux Greaves
-----------------------------------
-- Runic Scales     x1
-- Titanium Ingot   x2
-- Matamata Shell   x1
-- Elementium Study x1
SET @DUX_GREAVES = 10363;
DELETE FROM `item_basic` WHERE itemid = @DUX_GREAVES;
INSERT INTO `item_basic` VALUES (@DUX_GREAVES,0,'dux_greaves','dux_greaves',1,@ITEM_EQDEF,@AH_FEET,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DUX_GREAVES;
INSERT INTO `item_equipment` VALUES (@DUX_GREAVES,'dux_greaves',70,0,@RUN,@DUX_MODEL,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DUX_GREAVES;
INSERT INTO `item_mods` VALUES
    (@DUX_GREAVES, @MOD_DEF,              20),
    (@DUX_GREAVES, @MOD_VIT,               5),
    (@DUX_GREAVES, @MOD_ACC,               9),
    (@DUX_GREAVES, @MOD_PHYS_DMG_TAKEN, -300),
    (@DUX_GREAVES, @MOD_ENMITY,            4);

SET @DUX_GREAVES_P1 = 10364;
DELETE FROM `item_basic` WHERE itemid = @DUX_GREAVES_P1;
INSERT INTO `item_basic` VALUES (@DUX_GREAVES_P1,0,'dux_greaves_+1','dux_greaves_+1',1,@ITEM_EQDEF,@AH_FEET,1,0);

DELETE FROM `item_equipment` WHERE itemId = @DUX_GREAVES_P1;
INSERT INTO `item_equipment` VALUES (@DUX_GREAVES_P1,'dux_greaves_+1',70,0,@RUN,@DUX_MODEL,0,0,@SLOT_FEET,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @DUX_GREAVES_P1;
INSERT INTO `item_mods` VALUES
    (@DUX_GREAVES_P1, @MOD_DEF,              21),
    (@DUX_GREAVES_P1, @MOD_VIT,               6),
    (@DUX_GREAVES_P1, @MOD_ACC,              10),
    (@DUX_GREAVES_P1, @MOD_PHYS_DMG_TAKEN, -400),
    (@DUX_GREAVES_P1, @MOD_ENMITY,            5);

SET @DUX_GREAVES_SYNTH = 80049;
DELETE FROM `synth_recipes` WHERE Result = @DUX_GREAVES;
INSERT INTO `synth_recipes` VALUES (
    @DUX_GREAVES_SYNTH,0,0,
    0,0,0,0,  -- Wood/Smith/Gold/Cloth
    0,94,0,0, -- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,
        @RUNIC_SCALES,@MATAMATA_SHELL,@TITANIUM_INGOT,@TITANIUM_INGOT,@ELEMENTIUM_STUD,0,0,0, -- Materials
    @DUX_GREAVES,@DUX_GREAVES_P1,@DUX_GREAVES_P1,@DUX_GREAVES_P1,1,1,1,1,'Dux Greaves'        -- Results
);

-----------------------------------
-- Aether Caskets
-----------------------------------
-- Blank Key (Icon: Rusty Key)
SET @BLANK_KEY = 9494;
DELETE FROM `item_basic` WHERE itemId = @BLANK_KEY;
INSERT INTO `item_basic` VALUES (@BLANK_KEY,0,'blank_key','blank_key',12,4,@GOLDSMITHING,0,1250);

-- Aether Dust (Icon: Prism Powder)
SET @AETHER_DUST = 9470;
DELETE FROM `item_basic` WHERE itemId = @AETHER_DUST;
INSERT INTO `item_basic` VALUES (@AETHER_DUST,0,'aether_dust','aether_dust',12,4,@ALCHEMY,0,2345);
DELETE FROM `synth_recipes` WHERE Result = @AETHER_DUST;

-- Prismatic Cluster (Icon: Light Cluster)
SET @PRISMATIC_CLUSTER = 9471;
DELETE FROM `item_basic` WHERE itemId = @PRISMATIC_CLUSTER;
INSERT INTO `item_basic` VALUES (@PRISMATIC_CLUSTER,0,'prismatic_cluster','prismatic_cluster',12,4,@ALCHEMY,0,320);
DELETE FROM `synth_recipes` WHERE Result = @PRISMATIC_CLUSTER;

-- Aether Key (Icon: Prelate Key)
SET @AETHER_KEY = 9472;
DELETE FROM `item_basic` WHERE itemId = @AETHER_KEY;
INSERT INTO `item_basic` VALUES (@AETHER_KEY,0,'aether_key','aether_key',12,4,@ALCHEMY,0,1900);
DELETE FROM `synth_recipes` WHERE Result = @AETHER_KEY;

-- Prismatic Key (Icon: Oldton Chest Key)
SET @PRISMATIC_KEY = 9473;
DELETE FROM `item_basic` WHERE itemId = @PRISMATIC_KEY;
INSERT INTO `item_basic` VALUES (@PRISMATIC_KEY,0,'prismatic_key','prismatic_key',12,4,@ALCHEMY,0,680);
DELETE FROM `synth_recipes` WHERE Result = @PRISMATIC_KEY;

-- Aether Fragment (Icon: Shivatear)
SET @AETHER_FRAGMENT = 2999;
DELETE FROM `item_basic` WHERE itemId = @AETHER_FRAGMENT;
INSERT INTO `item_basic` VALUES (@AETHER_FRAGMENT,0,'aether_fragment','aether_fragment',99,@ITEM_EX,0,1,0);
DELETE FROM `synth_recipes` WHERE Result = @AETHER_FRAGMENT;

SET @AETHER_KEY_SYNTH = 80053;
DELETE FROM `synth_recipes` WHERE ID = @AETHER_KEY_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @AETHER_KEY_SYNTH,0,0,
    0,0,0,0, -- Wood/Smith/Gold/Cloth
    0,0,60,0,-- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,@AETHER_DUST,@BLANK_KEY,0,0,0,0,0,0,   -- Materials
    @AETHER_KEY,@AETHER_KEY,@AETHER_KEY,@AETHER_KEY,3,6,9,12,'Aether Key' -- Results
);

SET @PRISMATIC_KEY_SYNTH = 80054;
DELETE FROM `synth_recipes` WHERE ID = @PRISMATIC_KEY_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @PRISMATIC_KEY_SYNTH,0,0,
    0,0,0,0, -- Wood/Smith/Gold/Cloth
    0,0,90,0,-- Leather/Bone/Alchemy/Cooking
    @WIND_CRYSTAL,@CYCLONE_CRYSTAL,@PRISMATIC_CLUSTER,@BLANK_KEY,0,0,0,0,0,0,           -- Materials
    @PRISMATIC_KEY,@PRISMATIC_KEY,@PRISMATIC_KEY,@PRISMATIC_KEY,3,6,9,12,'Prismatic Key' -- Results
);

-----------------------------------
-- Genmei Shield
-----------------------------------
SET @GENMEI_SHIELD = 27645;
UPDATE `item_equipment` SET level = 74, ilevel = 0 WHERE itemId = @GENMEI_SHIELD;

DELETE FROM `item_mods` WHERE itemId = @GENMEI_SHIELD;
INSERT INTO `item_mods` VALUES
    (@GENMEI_SHIELD, @MOD_DEF,               30),
    (@GENMEI_SHIELD, @MOD_FIRE_RES,         -15),
    (@GENMEI_SHIELD, @MOD_EARTH_RES,         15),
    (@GENMEI_SHIELD, @MOD_EVA,               12),
    (@GENMEI_SHIELD, @MOD_PHYS_DMG_TAKEN, -1200),
    (@GENMEI_SHIELD, @MOD_CURE_POTENCY,       8),
    (@GENMEI_SHIELD, @MOD_CURE_CAST_TIME,     8);

DELETE FROM `item_latents` WHERE itemid = @GENMEI_SHIELD;
INSERT INTO `item_latents` VALUES
    (@GENMEI_SHIELD, @MOD_FASTCAST, 10, @LATENT_ZONE, 130), -- Ru'Aun Gardens
    (@GENMEI_SHIELD, @MOD_FASTCAST, 10, @LATENT_ZONE, 177), -- Ve'Lugannon Palace
    (@GENMEI_SHIELD, @MOD_FASTCAST, 10, @LATENT_ZONE, 178), -- The Shrine of Ru'Avitau
    (@GENMEI_SHIELD, @MOD_FASTCAST, 10, @LATENT_ZONE, 179), -- Stellar Fulcrum
    (@GENMEI_SHIELD, @MOD_FASTCAST, 10, @LATENT_ZONE, 180), -- La'Loff Amphitheater
    (@GENMEI_SHIELD, @MOD_FASTCAST, 10, @LATENT_ZONE, 181); -- The Celestial Nexus

-----------------------------------
-- Shukuyu's Scythe
-----------------------------------
SET @SHUKUYUS_SCYTHE = 20893;
UPDATE `item_equipment` SET level = 74, ilevel = 0 WHERE itemId = @SHUKUYUS_SCYTHE;
UPDATE `item_weapon` SET dmg = 92, ilvl_skill = 0, ilvl_parry = 0, ilvl_macc = 0 WHERE itemId = @SHUKUYUS_SCYTHE;

DELETE FROM `item_mods` WHERE itemId = @SHUKUYUS_SCYTHE;
INSERT INTO `item_mods` VALUES
    (@SHUKUYUS_SCYTHE, @MOD_STR,             5),
    (@SHUKUYUS_SCYTHE, @MOD_FIRE_RES,       15),
    (@SHUKUYUS_SCYTHE, @MOD_ATT,            15),
    (@SHUKUYUS_SCYTHE, @MOD_ACC,             8),
    (@SHUKUYUS_SCYTHE, @MOD_BIRD_KILLER,    10);

DELETE FROM `item_latents` WHERE itemid = @SHUKUYUS_SCYTHE;
INSERT INTO `item_latents` VALUES
    (@SHUKUYUS_SCYTHE, @MOD_HASTE, 500, @LATENT_ZONE, 130), -- Ru'Aun Gardens
    (@SHUKUYUS_SCYTHE, @MOD_HASTE, 500, @LATENT_ZONE, 177), -- Ve'Lugannon Palace
    (@SHUKUYUS_SCYTHE, @MOD_HASTE, 500, @LATENT_ZONE, 178), -- The Shrine of Ru'Avitau
    (@SHUKUYUS_SCYTHE, @MOD_HASTE, 500, @LATENT_ZONE, 179), -- Stellar Fulcrum
    (@SHUKUYUS_SCYTHE, @MOD_HASTE, 500, @LATENT_ZONE, 180), -- La'Loff Amphitheater
    (@SHUKUYUS_SCYTHE, @MOD_HASTE, 500, @LATENT_ZONE, 181); -- The Celestial Nexus

-----------------------------------
-- Koboto
-----------------------------------
SET @KOBOTO = 20699;
UPDATE `item_equipment` SET level = 74, ilevel = 0 WHERE itemId = @KOBOTO;
UPDATE `item_weapon` SET dmg = 47, ilvl_skill = 0, ilvl_parry = 0, ilvl_macc = 0 WHERE itemId = @KOBOTO;

DELETE FROM `item_mods` WHERE itemId = @KOBOTO;
INSERT INTO `item_mods` VALUES
    (@KOBOTO, @MOD_WATER_RES,       15),
    (@KOBOTO, @MOD_ATT,             15),
    (@KOBOTO, @MOD_EVA,             10),
    (@KOBOTO, @MOD_PLANTOID_KILLER, 10),
    (@KOBOTO, @MOD_DUAL_WIELD,       5);

DELETE FROM `item_latents` WHERE itemid = @KOBOTO;
INSERT INTO `item_latents` VALUES
    (@KOBOTO, @MOD_CRIT_HIT_RATE, 5, @LATENT_ZONE, 130), -- Ru'Aun Gardens
    (@KOBOTO, @MOD_CRIT_HIT_RATE, 5, @LATENT_ZONE, 177), -- Ve'Lugannon Palace
    (@KOBOTO, @MOD_CRIT_HIT_RATE, 5, @LATENT_ZONE, 178), -- The Shrine of Ru'Avitau
    (@KOBOTO, @MOD_CRIT_HIT_RATE, 5, @LATENT_ZONE, 179), -- Stellar Fulcrum
    (@KOBOTO, @MOD_CRIT_HIT_RATE, 5, @LATENT_ZONE, 180), -- La'Loff Amphitheater
    (@KOBOTO, @MOD_CRIT_HIT_RATE, 5, @LATENT_ZONE, 181); -- The Celestial Nexus

-----------------------------------
-- Jokushuono
-----------------------------------
SET @JOKUSHUONO = 20846;
UPDATE `item_equipment` SET level = 74, ilevel = 0 WHERE itemId = @JOKUSHUONO;
UPDATE `item_weapon` SET dmg = 98, ilvl_skill = 0, ilvl_parry = 0, ilvl_macc = 0 WHERE itemId = @JOKUSHUONO;

DELETE FROM `item_mods` WHERE itemId = @JOKUSHUONO;
INSERT INTO `item_mods` VALUES
    (@JOKUSHUONO, @MOD_WIND_RES,          15),
    (@JOKUSHUONO, @MOD_ATT,               15),
    (@JOKUSHUONO, @MOD_CRIT_HIT_RATE,      5),
    (@JOKUSHUONO, @MOD_MAGIC_DMG_TAKEN, -400),
    (@JOKUSHUONO, @MOD_BEAST_KILLER,      10);

DELETE FROM `item_latents` WHERE itemid = @KOBOTO;
INSERT INTO `item_latents` VALUES
    (@JOKUSHUONO, @MOD_DOUBLE_ATK, 5, @LATENT_ZONE, 130), -- Ru'Aun Gardens
    (@JOKUSHUONO, @MOD_DOUBLE_ATK, 5, @LATENT_ZONE, 177), -- Ve'Lugannon Palace
    (@JOKUSHUONO, @MOD_DOUBLE_ATK, 5, @LATENT_ZONE, 178), -- The Shrine of Ru'Avitau
    (@JOKUSHUONO, @MOD_DOUBLE_ATK, 5, @LATENT_ZONE, 179), -- Stellar Fulcrum
    (@JOKUSHUONO, @MOD_DOUBLE_ATK, 5, @LATENT_ZONE, 180), -- La'Loff Amphitheater
    (@JOKUSHUONO, @MOD_DOUBLE_ATK, 5, @LATENT_ZONE, 181); -- The Celestial Nexus

-----------------------------------
-- Mastery System
-----------------------------------
SET @MASTERY_RING = 10777; -- (Icon: Apeile Ring)
DELETE FROM `item_equipment` WHERE itemId = @MASTERY_RING;
UPDATE `item_equipment` SET level = 1, ilevel = 0 WHERE itemId = @MASTERY_RING;

DELETE FROM `item_mods` WHERE itemId = @MASTERY_RING;
INSERT INTO `item_mods` VALUES
    (@MASTERY_RING, @MOD_DEF,       1),
    (@MASTERY_RING, @MOD_DEX,       1),
    (@MASTERY_RING, @MOD_LIGHT_RES, 1);

DELETE FROM `item_usable` WHERE itemid = @MASTERY_RING;
INSERT INTO `item_usable` VALUES (@MASTERY_RING,'mastery_ring',1,3,76,0,10,5,300,0);

-----------------------------------
-- Partner Program
-----------------------------------
-- Cosmetic Coupon (Icon: Whistle coupon)
SET @COSMETIC_COUPON = 3000;
DELETE FROM `item_basic` WHERE itemId = @COSMETIC_COUPON ;
INSERT INTO `item_basic` VALUES (@COSMETIC_COUPON ,0,'cosmetic_coupon','cosmetic_coupon',12,4,0,0,0);

-----------------------------------
-- Custom Food
-----------------------------------
-- Dragon Fruit Pie (Icon: Pumpkin Pie)
SET @DRAGON_FRUIT_PIE = 6517;
DELETE FROM `item_basic` WHERE itemId = @DRAGON_FRUIT_PIE;
INSERT INTO `item_basic` VALUES (@DRAGON_FRUIT_PIE,0,'dragon_fruit_pie','dragon_fruit_pie',12,1548,@AH_SWEETS,0,765);

DELETE FROM `item_usable` WHERE itemId = @DRAGON_FRUIT_PIE;
INSERT INTO `item_usable` VALUES (@DRAGON_FRUIT_PIE,'dragon_fruit_pie',1,1,26,0,0,0,0,0);

DELETE FROM `synth_recipes` WHERE Result = @DRAGON_FRUIT_PIE;

SET @DRAGON_FRUIT_PIE_SYNTH = 80055;
SET @DRAGON_FRUIT           =  5662;
SET @BIRD_EGG               =  4570;
SET @HONEY                  =  4370;
SET @PIE_DOUGH              =   616;
DELETE FROM `synth_recipes` WHERE ID = @DRAGON_FRUIT_PIE_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @DRAGON_FRUIT_PIE_SYNTH,0,0,
    0,0,0,0, -- Wood/Smith/Gold/Cloth
    0,0,0,85,-- Leather/Bone/Alchemy/Cooking
    @FIRE_CRYSTAL,@INFERNO_CRYSTAL,@PIE_DOUGH,@PIE_DOUGH,@HONEY,@BIRD_EGG,@DRAGON_FRUIT,@DRAGON_FRUIT,@DRAGON_FRUIT,@DRAGON_FRUIT, -- Materials
    @DRAGON_FRUIT_PIE,@DRAGON_FRUIT_PIE,@DRAGON_FRUIT_PIE,@DRAGON_FRUIT_PIE,1,1,1,1,'Dragon Fruit Pie' -- Results
);

-- Rolanberry Cheesecake (Icon: Gat. aux Fraises)
SET @ROLANBERRY_CHEESECAKE = 6518;
SET @YOGURT                = 5575;
SET @WIZARD_COOKIE         = 4576;
SET @ROLANBERRY            = 4365;
SET @KITRON                = 4273;
DELETE FROM `item_basic` WHERE itemId = @ROLANBERRY_CHEESECAKE;
INSERT INTO `item_basic` VALUES (@ROLANBERRY_CHEESECAKE,0,'rolanberry_cheesecake','rolanberry_cheesecake',12,1548,@AH_SWEETS,1,545);

DELETE FROM `item_usable` WHERE itemId = @ROLANBERRY_CHEESECAKE;
INSERT INTO `item_usable` VALUES (@ROLANBERRY_CHEESECAKE,'rolanberry_cheesecake',1,1,26,0,0,0,0,0);

DELETE FROM `synth_recipes` WHERE Result = @ROLANBERRY_CHEESECAKE;

SET @ROLANBERRY_CHEESECAKE_SYNTH = 80056;
DELETE FROM `synth_recipes` WHERE ID = @ROLANBERRY_CHEESECAKE_SYNTH;
INSERT INTO `synth_recipes` VALUES (
    @ROLANBERRY_CHEESECAKE_SYNTH,0,0,
    0,0,0,0, -- Wood/Smith/Gold/Cloth
    0,0,0,85,-- Leather/Bone/Alchemy/Cooking
    @ICE_CRYSTAL,@GLACIER_CRYSTAL,@KITRON,@KITRON,@ROLANBERRY,@WIZARD_COOKIE,@YOGURT,@YOGURT,@YOGURT,@YOGURT, -- Materials
    @ROLANBERRY_CHEESECAKE,@ROLANBERRY_CHEESECAKE,@ROLANBERRY_CHEESECAKE,@ROLANBERRY_CHEESECAKE,1,1,1,1,'Rolanberry Cheesecake' -- Results
);

-----------------------------------
-- Kraken Club +1
-----------------------------------
SET @KRAKEN_CLUB_P1 = 21104;
DELETE FROM `item_basic` WHERE itemid = @KRAKEN_CLUB_P1;
INSERT INTO `item_basic` VALUES (@KRAKEN_CLUB_P1,0,'kraken_club_+1','kraken_club_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @KRAKEN_CLUB_P1;
INSERT INTO `item_equipment` VALUES (@KRAKEN_CLUB_P1,'kraken_club_+1',75,0,@ALL_JOBS,110,0,0,@SLOT_MAINHAND,0,0,0);

DELETE FROM `item_weapon` WHERE itemId = @KRAKEN_CLUB_P1;
INSERT INTO `item_weapon` VALUES (@KRAKEN_CLUB_P1,'kraken_club_+1',@SKILL_CLUB,0,0,0,0,@DMG_BLUNT,8,264,12,0);

DELETE FROM `item_mods` WHERE itemId = @KRAKEN_CLUB_P1;

-- Slimy Tentacle
SET @SLIMY_TENTACLE = 3019;
DELETE FROM `item_basic` WHERE itemId = @SLIMY_TENTACLE;
INSERT INTO `item_basic` VALUES (@SLIMY_TENTACLE,0,'slimy_tentacle','slimy_tentacle',1,@ITEM_RARE,0,1,0);

-- Epic Lure
SET @EPIC_LURE = 3004;
DELETE FROM `item_basic` WHERE itemId = @EPIC_LURE;
INSERT INTO `item_basic` VALUES (@EPIC_LURE,0,'epic_lure','epic_lure',1,@ITEM_RARE,0,1,0);

-----------------------------------
-- Guild NMs
-----------------------------------
-- Twilight Gold
SET @TWILIGHT_GOLD = 3023;
DELETE FROM `item_basic` WHERE itemId = @TWILIGHT_GOLD;
INSERT INTO `item_basic` VALUES (@TWILIGHT_GOLD,0,'twlight_gold','twilight_gold',12,@ITEM_EX,0,1,0);

-- Brutal Earring +1 (Icon: Bone Earring +1)
SET @BRUTAL_EARRING_P1 = 27537;
DELETE FROM `item_basic` WHERE itemid = @BRUTAL_EARRING_P1;
INSERT INTO `item_basic` VALUES (@BRUTAL_EARRING_P1,0,'brutal_earring_+1','brutal_earring_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @BRUTAL_EARRING_P1;
INSERT INTO `item_equipment` VALUES (@BRUTAL_EARRING_P1,'brutal_earring_+1',75,0,@ALL_JOBS,0,0,0,@SLOT_EAR,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @BRUTAL_EARRING_P1;
INSERT INTO `item_mods` VALUES
    (@BRUTAL_EARRING_P1, @MOD_DOUBLE_ATK, 6),
    (@BRUTAL_EARRING_P1, @MOD_STORE_TP,   2);

-- Warwolf Belt +1 (Icon: Warrior's Belt +1)
SET @WARWOLF_BELT_P1 = 26324;
DELETE FROM `item_basic` WHERE itemid = @WARWOLF_BELT_P1;
INSERT INTO `item_basic` VALUES (@WARWOLF_BELT_P1,0,'warwolf_belt_+1','warwolf_belt_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @WARWOLF_BELT_P1;
INSERT INTO `item_equipment` VALUES (@WARWOLF_BELT_P1,'warwolf_belt_+1',71,0,@WAR+@MNK+@RDM+@THF+@PLD+@DRK+@BST+@BRD+@SAM+@NIN+@DRG+@BLU+@COR+@DNC+@RUN,0,0,0,@SLOT_WAIST,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @WARWOLF_BELT_P1;
INSERT INTO `item_mods` VALUES
    (@WARWOLF_BELT_P1, @MOD_DEF,    7),
    (@WARWOLF_BELT_P1, @MOD_STR,    6),
    (@WARWOLF_BELT_P1, @MOD_DEX,    6),
    (@WARWOLF_BELT_P1, @MOD_VIT,    5),
    (@WARWOLF_BELT_P1, @MOD_ENMITY, 4);

-- Reverend Mail +1 (Icon: Haubergeon +1)
SET @REVEREND_MAIL_P1 = 27886;
DELETE FROM `item_basic` WHERE itemid = @REVEREND_MAIL_P1;
INSERT INTO `item_basic` VALUES (@REVEREND_MAIL_P1,0,'reverent_mail_+1','reverent_mail_+1',1,@ITEM_EQUIP,0,1,0);

DELETE FROM `item_equipment` WHERE itemId = @REVEREND_MAIL_P1;
INSERT INTO `item_equipment` VALUES (@REVEREND_MAIL_P1,'reverent_mail_+1',75,0,@WHM,40,0,0,@SLOT_BODY,0,0,0);

DELETE FROM `item_mods` WHERE itemId = @REVEREND_MAIL_P1;
INSERT INTO `item_mods` VALUES
    (@REVEREND_MAIL_P1, @MOD_DEF,       52),
    (@REVEREND_MAIL_P1, @MOD_HP,        30),
    (@REVEREND_MAIL_P1, @MOD_MP,        30),
    (@REVEREND_MAIL_P1, @MOD_MND,        5),
    (@REVEREND_MAIL_P1, @MOD_ACC,       12),
    (@REVEREND_MAIL_P1, @MOD_EVA,       12),
    (@REVEREND_MAIL_P1, @MOD_HASTE,    400),
    (@REVEREND_MAIL_P1, @MOD_STORE_TP,   4);

-----------------------------------
-- Genbu (Escha - Ru'Aun)
-----------------------------------
SET @CRACKED_KABUTO = 3007;
DELETE FROM `item_basic` WHERE itemId = @CRACKED_KABUTO;
INSERT INTO `item_basic` VALUES (@CRACKED_KABUTO,0,'cracked_kabuto','cracked_kabuto',1,@ITEM_RARE,0,1,0);

SET @GENMEI_KABUTO = 25629;
DELETE FROM `item_equipment` WHERE itemId = @GENMEI_KABUTO;
UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId = @GENMEI_KABUTO;

DELETE FROM `item_mods` WHERE itemId = @GENMEI_KABUTO;
INSERT INTO `item_mods` VALUES
    (@GENMEI_KABUTO, @MOD_DEF,               38),
    (@GENMEI_KABUTO, @MOD_HP,                75),
    (@GENMEI_KABUTO, @MOD_WATER_RES,         50),
    (@GENMEI_KABUTO, @MOD_ATT,                5),
    (@GENMEI_KABUTO, @MOD_HASTE,            400),
    (@GENMEI_KABUTO, @MOD_PHYS_DMG_TAKEN,  -500);

SET @GENMEI_EARRING = 27539;
DELETE FROM `item_equipment` WHERE itemId = @GENMEI_EARRING;
UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId = @GENMEI_EARRING;

DELETE FROM `item_mods` WHERE itemId = @GENMEI_EARRING;
INSERT INTO `item_mods` VALUES
    (@GENMEI_EARRING, @MOD_DEF,                3),
    (@GENMEI_EARRING, @MOD_COUNTER,            2),
    (@GENMEI_EARRING, @MOD_PHYS_DMG_TAKEN,  -200);

-----------------------------------
-- Kouryu (Escha - Ru'Aun)
-----------------------------------
SET @TATTERED_OSODE = 3008;
DELETE FROM `item_basic` WHERE itemId = @TATTERED_OSODE;
INSERT INTO `item_basic` VALUES (@TATTERED_OSODE,0,'tattered_osode','tattered_osode',1,@ITEM_RARE,0,1,0);

SET @REIKI_OSODE = 25702;
DELETE FROM `item_equipment` WHERE itemId = @REIKI_OSODE;
UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId = @REIKI_OSODE;

DELETE FROM `item_mods` WHERE itemId = @REIKI_OSODE;
INSERT INTO `item_mods` VALUES
    (@REIKI_OSODE, @MOD_DEF,          54),
    (@REIKI_OSODE, @MOD_MP,           50),
    (@REIKI_OSODE, @MOD_STR,          12),
    (@REIKI_OSODE, @MOD_DEX,          12),
    (@REIKI_OSODE, @MOD_VIT,          12),
    (@REIKI_OSODE, @MOD_AGI,          12),
    (@REIKI_OSODE, @MOD_INT,          12),
    (@REIKI_OSODE, @MOD_MND,          12),
    (@REIKI_OSODE, @MOD_CHR,          12),
    (@REIKI_OSODE, @MOD_LIGHT_RES,    50),
    (@REIKI_OSODE, @MOD_DOUBLE_ATK,    4),
    (@REIKI_OSODE, @MOD_CRITICAL_DMG,  4);

SET @REIKIONO = 20842;
UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId = @REIKIONO;
UPDATE `item_weapon` SET dmg = 104, ilvl_skill = 0, ilvl_parry = 0, ilvl_macc = 0 WHERE itemId = @REIKIONO;

DELETE FROM `item_mods` WHERE itemId = @REIKIONO;
INSERT INTO `item_mods` VALUES
    (@REIKIONO, @MOD_TRIPLE_ATK,         4),
    (@REIKIONO, @MOD_CURE_POTENCY_RCVD, 15),
    (@REIKIONO, @MOD_BERSERK_DURATION,  15),
    (@REIKIONO, @MOD_DAMAGE_TAKEN,    -800);

-----------------------------------
-- Seiryu (Escha - Ru'Aun)
-----------------------------------
SET @RUINED_KOTE = 3009;
DELETE FROM `item_basic` WHERE itemId = @RUINED_KOTE;
INSERT INTO `item_basic` VALUES (@RUINED_KOTE,0,'ruined_kote','ruined_kote',1,@ITEM_RARE,0,1,0);

SET @KOBO_KOTE = 27133;
DELETE FROM `item_equipment` WHERE itemId = @KOBO_KOTE;
UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId = @KOBO_KOTE;

DELETE FROM `item_mods` WHERE itemId = @KOBO_KOTE;
INSERT INTO `item_mods` VALUES
    (@KOBO_KOTE, @MOD_DEF,           28),
    (@KOBO_KOTE, @MOD_HP,            60),
    (@KOBO_KOTE, @MOD_AGI,           18),
    (@KOBO_KOTE, @MOD_RACC,          15),
    (@KOBO_KOTE, @MOD_EVA,            5),
    (@KOBO_KOTE, @MOD_STORE_TP,       6),
    (@KOBO_KOTE, @MOD_CRIT_HIT_RATE,  4);

SET @KOBO_OBI = 26320;
DELETE FROM `item_equipment` WHERE itemId = @KOBO_OBI;
UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId = @KOBO_OBI;

DELETE FROM `item_mods` WHERE itemId = @KOBO_OBI;
INSERT INTO `item_mods` VALUES
    (@KOBO_OBI, @MOD_DEF,              6),
    (@KOBO_OBI, @MOD_MP,              25),
    (@KOBO_OBI, @MOD_SUMMONING_SKILL,  5),
    (@KOBO_OBI, @MOD_SINGING_SKILL,    5),
    (@KOBO_OBI, @MOD_GEOMANCY_SKILL,   5);

-----------------------------------
-- Byakko (Escha - Ru'Aun)
-----------------------------------
SET @RIPPED_HAIDATE = 3010;
DELETE FROM `item_basic` WHERE itemId = @RIPPED_HAIDATE;
INSERT INTO `item_basic` VALUES (@RIPPED_HAIDATE,0,'ripped_haidate','ripped_haidate',1,@ITEM_RARE,0,1,0);

SET @JOKUSHU_HAIDATE = 27318;
DELETE FROM `item_equipment` WHERE itemId = @JOKUSHU_HAIDATE;
UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId = @JOKUSHU_HAIDATE;

DELETE FROM `item_mods` WHERE itemId = @JOKUSHU_HAIDATE;
INSERT INTO `item_mods` VALUES
    (@JOKUSHU_HAIDATE, @MOD_DEF,            44),
    (@JOKUSHU_HAIDATE, @MOD_DEX,            18),
    (@JOKUSHU_HAIDATE, @MOD_THUNDER_RES,    50),
    (@JOKUSHU_HAIDATE, @MOD_STORE_TP,        5),
    (@JOKUSHU_HAIDATE, @MOD_HASTE,         500),
    (@JOKUSHU_HAIDATE, @MOD_CRITICAL_DMG,    4);

SET @JOKUSHU_CHAIN = 27525;
DELETE FROM `item_equipment` WHERE itemId = @JOKUSHU_CHAIN;
UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId = @JOKUSHU_CHAIN;

DELETE FROM `item_mods` WHERE itemId = @JOKUSHU_CHAIN;
INSERT INTO `item_mods` VALUES
    (@JOKUSHU_CHAIN, @MOD_DIVINE_SKILL,   10);
    -- TODO: Potency of "Banish" vs. undead +5


-----------------------------------
-- Suzaku (Escha - Ru'Aun)
-----------------------------------
SET @SCUFFED_SUNE_ATE = 3011;
DELETE FROM `item_basic` WHERE itemId = @SCUFFED_SUNE_ATE;
INSERT INTO `item_basic` VALUES (@SCUFFED_SUNE_ATE,0,'scuffed_sune-ate','scuffed_sune-ate',1,@ITEM_RARE,0,1,0);

SET @SHUKUYU_SUNE_ATE = 27489;
DELETE FROM `item_equipment` WHERE itemId = @SHUKUYU_SUNE_ATE;
UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId = @SHUKUYU_SUNE_ATE;

DELETE FROM `item_mods` WHERE itemId = @SHUKUYU_SUNE_ATE;
INSERT INTO `item_mods` VALUES
    (@SHUKUYU_SUNE_ATE, @MOD_DEF,       32),
    (@SHUKUYU_SUNE_ATE, @MOD_MND,       18),
    (@SHUKUYU_SUNE_ATE, @MOD_FIRE_RES,  50),
    (@SHUKUYU_SUNE_ATE, @MOD_MDEF,       5),
    (@SHUKUYU_SUNE_ATE, @MOD_HASTE,    300),
    (@SHUKUYU_SUNE_ATE, @MOD_FASTCAST,   5);

SET @SHUKUYU_RING = 26161;
DELETE FROM `item_equipment` WHERE itemId = @SHUKUYU_RING;
UPDATE `item_equipment` SET level = 75, ilevel = 0 WHERE itemId = @SHUKUYU_RING;

DELETE FROM `item_mods` WHERE itemId = @SHUKUYU_RING;
INSERT INTO `item_mods` VALUES
    (@SHUKUYU_RING, @MOD_ATT,        5),
    (@SHUKUYU_RING, @MOD_MEVA,       3),
    (@SHUKUYU_RING, @MOD_DUAL_WIELD, 3);
