-------------------------------
-- Equipment DAT Modifications
-------------------------------

----------------------------------------------------
-- RUN/GEO Setup
----------------------------------------------------
-- Clean up existing mods before adding replacements
----------------------------------------------------

-- Remove existing item_mods on Geomancy Set (GEO Artifact)
DELETE from item_mods WHERE itemId = "27786";
DELETE from item_mods WHERE itemId = "27926";
DELETE from item_mods WHERE itemId = "28066";
DELETE from item_mods WHERE itemId = "28206";
DELETE from item_mods WHERE itemId = "28346";

-- Remove existing item_mods on Bugua Set (GEO Relic)
DELETE from item_mods WHERE itemId = "26664";
DELETE from item_mods WHERE itemId = "26840";
DELETE from item_mods WHERE itemId = "27016";
DELETE from item_mods WHERE itemId = "27192";
DELETE from item_mods WHERE itemId = "27368";

-- Remove existing item_mods on Runeist Set (RUN Artifact)
DELETE from item_mods WHERE itemId = "27787";
DELETE from item_mods WHERE itemId = "27927";
DELETE from item_mods WHERE itemId = "28067";
DELETE from item_mods WHERE itemId = "28207";
DELETE from item_mods WHERE itemId = "28347";

-- Remove existing item_mods on Runeist Set (RUN Relic)
DELETE from item_mods WHERE itemId = "26666";
DELETE from item_mods WHERE itemId = "26842";
DELETE from item_mods WHERE itemId = "27018";
DELETE from item_mods WHERE itemId = "27194";
DELETE from item_mods WHERE itemId = "27370";

-- 'Ultimate Weapons'
SET @RAQIA = 21722;

DELETE FROM `item_mods` WHERE `itemId` IN (
    @RAQIA
);

DELETE FROM `item_weapon` WHERE `itemId` IN (
    @RAQIA
);

DELETE FROM `item_equipment` WHERE `itemId` IN (
    @RAQIA
);

-- Remove existing item_mods from 'Ultimate Weapons'
DELETE FROM `item_mods` WHERE `itemId` = "19174";
DELETE FROM `item_mods` WHERE `itemId` = "17669";
DELETE FROM `item_mods` WHERE `itemId` = "22086";
DELETE FROM `item_mods` WHERE `itemId` = "19298";
DELETE FROM `item_mods` WHERE `itemId` = "18904";
DELETE from `item_mods` WHERE `itemId` = "18525";
DELETE from `item_mods` WHERE `itemId` = "22107";
DELETE from `item_mods` WHERE `itemId` = "21519";
DELETE FROM `item_mods` WHERE `itemId` = "21830";
DELETE FROM `item_mods` WHERE `itemId` = "15771";
DELETE FROM `item_weapon` WHERE `itemId` = "17669";
DELETE FROM `item_weapon` WHERE `itemId` = "22086";
DELETE FROM `item_equipment` WHERE `itemId` = "17669";
DELETE FROM `item_equipment` WHERE `itemId` = "22086";
------------------------------------------------------
-- Add new item mods
------------------------------------------------------

-- Geomancy Galero
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "27786";
INSERT into item_mods VALUES (27786,1,22);     -- DEF: 22
INSERT into item_mods VALUES (27786,5,25);     -- MP+25
INSERT into item_mods VALUES (27786,12,5);     -- INT+5
INSERT into item_mods VALUES (27786,115,15);   -- Elemental Magic Skill +15

-- Geomancy Tunic
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "27926";
INSERT into item_mods VALUES (27926,1,40);     -- DEF: 40
INSERT into item_mods VALUES (27926,5,35);     -- MP+35
INSERT into item_mods VALUES (27926,116,12);   -- Dark magic skill +12
INSERT into item_mods VALUES (27926,1029,10);  -- Enhances "Life Cycle" effect
INSERT into item_mods VALUES (27926,71,5);     -- MP recovered while healing +5

-- Geomancy Mitaines
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "28066";
INSERT into item_mods VALUES (28066,1,15);     -- DEF: 15
INSERT into item_mods VALUES (28066,5,16);     -- MP+16
INSERT into item_mods VALUES (28066,12,3);     -- INT+3
INSERT into item_mods VALUES (28066,13,4);     -- MND+4
INSERT into item_mods VALUES (28066,123,15);   -- Geomancy skill +15
INSERT into item_mods VALUES (28066,990,22);   -- Luopan: (Physical) Damage taken -6% -- No specific mod currently exists for this.

-- Geomancy Pants
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "28206";
INSERT into item_mods VALUES (28206,1,30);     -- DEF: 30
INSERT into item_mods VALUES (28206,5,20);     -- MP+20
INSERT into item_mods VALUES (28206,170,10);   -- Enhances "Fast Cast" effect +10%
INSERT into item_mods VALUES (28206,168,15);   -- Spell interruption rate down 15%

-- Geomancy Sandals
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "28346";
INSERT into item_mods VALUES (28346,1,12);     -- DEF: 12
INSERT into item_mods VALUES (28346,5,15);     -- MP+15
INSERT into item_mods VALUES (28346,11,5);     -- AGI+5
INSERT into item_mods VALUES (28346,14,5);     -- CHR+5
INSERT into item_mods VALUES (28346,76,12);    -- MOVE_SPEED_GEAR_BONUS+12%

-- Bagua Galero
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "26664";
INSERT into item_mods VALUES (26664,1,25);     -- DEF: 25
INSERT into item_mods VALUES (26664,5,25);     -- MP+25
INSERT into item_mods VALUES (26664,12,3);     -- INT+3
INSERT into item_mods VALUES (26664,13,3);     -- MND+3
INSERT into item_mods VALUES (26664,315,10);   -- “Drain” and “Aspir” potency +10

-- Bagua Tunic
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "26840";
INSERT into item_mods VALUES (26840,1,43);     -- DEF: 43
INSERT into item_mods VALUES (26840,2,15);     -- HP+15
INSERT into item_mods VALUES (26840,5,15);     -- MP+15
INSERT into item_mods VALUES (26840,28,5);     -- “Magic Attack Bonus” +5
INSERT into item_mods VALUES (26840,123,10);   -- Geomancy skill +10

-- Bagua Mitaines
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "27016";
INSERT into item_mods VALUES (27016,1,17);     -- DEF: 17
INSERT into item_mods VALUES (27016,5,21);     -- MP+21
INSERT into item_mods VALUES (27016,369,1);    -- “Refresh + 1”
INSERT into item_mods VALUES (27016,901,6);    -- Elemental Magic casting time -6%

-- Bagua Pants
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "27192";
INSERT into item_mods VALUES (27192,1,31);     -- DEF: 31
INSERT into item_mods VALUES (27192,5,20);     -- MP+20
INSERT into item_mods VALUES (27192,12,5);     -- INT+5
INSERT into item_mods VALUES (27192,13,3);     -- MND+3
INSERT into item_mods VALUES (27192,960,12);   -- “Indicolure” spell duration +12

-- Bagua Sandals
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "27368";
INSERT into item_mods VALUES (27368,1,16);     -- DEF: 16
INSERT into item_mods VALUES (27368,5,18);     -- MP+18
INSERT into item_mods VALUES (27368,13,3);     -- MND+3
INSERT into item_mods VALUES (27368,114,12);   -- Enfeebling magic skill +12
DELETE FROM item_mods_pet WHERE itemId = 27368;
INSERT INTO item_mods_pet VALUES
    (27368, 370, 2, 8);                        -- Luopan: “Regen”+2

-- Runeist Bandeau
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "27787";
INSERT into item_mods VALUES (27787,1,27);     -- DEF: 27
INSERT into item_mods VALUES (27787,2,21);     -- HP+21
INSERT into item_mods VALUES (27787,9,5);      -- DEX+5
INSERT into item_mods VALUES (27787,370,3);    -- "Regen" +3
INSERT into item_mods VALUES (27787,161,-300);    -- Physical damage taken -3%

-- Runeist Coat
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "27927";
INSERT into item_mods VALUES (27927,1,50);     -- DEF: 50
INSERT into item_mods VALUES (27927,2,20);     -- HP+20
INSERT into item_mods VALUES (27927,5,20);     -- MP+20
INSERT into item_mods VALUES (27927,8,5);      -- STR+5
INSERT into item_mods VALUES (27927,10,5);     -- VIT+5
INSERT INTO item_mods VALUES (27927,15,10);    -- FIRE_RES: 10
INSERT INTO item_mods VALUES (27927,16,10);    -- ICE_RES: 10
INSERT INTO item_mods VALUES (27927,17,10);    -- WIND_RES: 10
INSERT INTO item_mods VALUES (27927,18,10);    -- EARTH_RES: 10
INSERT INTO item_mods VALUES (27927,19,10);    -- THUNDER_RES: 10
INSERT INTO item_mods VALUES (27927,20,10);    -- WATER_RES: 10
INSERT INTO item_mods VALUES (27927,21,10);    -- LIGHT_RES: 10
INSERT INTO item_mods VALUES (27927,22,10);    -- DARK_RES: 10
INSERT into item_mods VALUES (27927,1010,10);  -- Enhances "Valiance" and "Vallation" effects

-- Runeist Mitons
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "28067";
INSERT into item_mods VALUES (28067,1,21);     -- DEF: 21
INSERT into item_mods VALUES (28067,5,22);     -- MP+22
INSERT into item_mods VALUES (28067,10,3);     -- VIT+3
INSERT into item_mods VALUES (28067,9,3);      -- DEX+3
INSERT into item_mods VALUES (28067,369,1);    -- "Refresh" +1
INSERT into item_mods VALUES (28067,1018,10);  -- Ennhances "Gambit" Effect

-- Runeist Trousers
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "28207";
INSERT into item_mods VALUES (28207,1,40);     -- DEF: 40
INSERT into item_mods VALUES (28207,2,15);     -- HP+15
INSERT into item_mods VALUES (28207,5,15);     -- MP+15
INSERT into item_mods VALUES (28207,8,7);      -- STR+7
INSERT into item_mods VALUES (28207,27,5);     -- Enmity+5
INSERT into item_mods VALUES (28207,160,-300);    -- Damage taken -3%

-- Runeist Bottes
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "28347";
INSERT into item_mods VALUES (28347,1,18);     -- DEF: 18
INSERT into item_mods VALUES (28347,2,18);     -- HP+18
INSERT into item_mods VALUES (28347,10,6);     -- VIT+6
INSERT into item_mods VALUES (28347,29,2);     -- Magic def. bonus +2
INSERT into item_mods VALUES (28347,1011,10);  -- Enhances "Pflug" effect

-- Futhark Bandeau
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "26666";
INSERT into item_mods VALUES (26666,1,28);     -- DEF: 28
INSERT into item_mods VALUES (26666,2,11);     -- HP+11
INSERT into item_mods VALUES (26666,5,11);     -- MP+11
INSERT into item_mods VALUES (26666,8,6);      -- STR+6
INSERT into item_mods VALUES (26666,384,300);    -- Haste +3%
INSERT into item_mods VALUES (26666,1004,10);  -- Enhances "Battuta" effect

-- Futhark Coat
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "26842";
INSERT into item_mods VALUES (26842,1,52);     -- DEF: 52
INSERT into item_mods VALUES (26842,2,15);     -- HP+15
INSERT into item_mods VALUES (26842,5,15);     -- MP+15
INSERT into item_mods VALUES (26842,8,7);      -- STR+7
INSERT into item_mods VALUES (26842,10,7);     -- VIT+7
INSERT into item_mods VALUES (26842,31,9);     -- Magic Evasion +9
INSERT into item_mods VALUES (26842,516,5);    -- Converts 5% of physical damage taken to MP

-- Futhark Mitons
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "27018";
INSERT into item_mods VALUES (27018,1,20);     -- DEF: 20
INSERT into item_mods VALUES (27018,2,17);     -- HP+17
INSERT into item_mods VALUES (27018,9,7);      -- DEX+7
INSERT into item_mods VALUES (27018,1008,3);   -- "Swordplay" +3
INSERT into item_mods VALUES (27018,1006,10);  -- Enhances "Sleight of Sword" effect

-- Futhark Trousers
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "27194";
INSERT into item_mods VALUES (27194,1,41);     -- DEF: 41
INSERT into item_mods VALUES (27194,2,20);     -- HP+20
INSERT into item_mods VALUES (27194,5,20);     -- MP+20
INSERT into item_mods VALUES (27194,10,7);     -- VIT+7
INSERT into item_mods VALUES (27194,9,7);      -- DEX+7
INSERT into item_mods VALUES (27194,890,10);   -- Enhancing magic duration +10
INSERT into item_mods VALUES (27194,170,10);   -- Enhances "Fast Cast" effect +10%

-- Futhark Boots
UPDATE item_equipment SET level = "75", ilevel = "0" WHERE itemId = "27370";
INSERT into item_mods VALUES (27370,1,19);     -- DEF: 19
INSERT into item_mods VALUES (27370,5,21);     -- MP+21
INSERT into item_mods VALUES (27370,8,5);      -- STR+5
INSERT into item_mods VALUES (27370,9,5);      -- DEX+5
INSERT into item_mods VALUES (27370,384,400);    -- Haste +4%
INSERT into item_mods VALUES (27370,110,15);   -- Parrying skill +15

-- Mirage Charuqs +1
INSERT into item_mods VALUES (11383,890,25);   -- Enh Magic Duration (This mimics the Mirage Charuqs +2)

--------------------------------------
-- Ultimate Weapons by Neckbeard
--------------------------------------

-- Bifrost (Borealis)
-- ItemId: 19174
-- "DMG:86 Delay:444 DEX+15 VIT+15 \\nAttack+15 Enmity+15\\n\"Magic Def. Bonus\"+3"
-- change to UPDATE `item_weapon` SET `dmg` = 87 , `delay` = 445 WHERE itemId = "19174
UPDATE `item_equipment` SET `level` = "75", `ilevel` = "0" WHERE `itemId` = "19174";
UPDATE `item_weapon` SET `dmg` = "86" , `delay` = "444" WHERE `itemId` = "19174";
INSERT INTO `item_mods` VALUES (19174,9,8);    -- DEX: 8
INSERT INTO `item_mods` VALUES (19174,10,8);   -- VIT 8
INSERT INTO `item_mods` VALUES (19174,23,15);  -- ATTACK +15
INSERT INTO `item_mods` VALUES (19174,27,10);  -- ENMITY: +10
INSERT INTO `item_mods` VALUES (19174,29,3);   -- MDEF +3
INSERT INTO `item_mods` VALUES (19174,15,10);  -- FIRE_RES: 10
INSERT INTO `item_mods` VALUES (19174,16,10);  -- ICE_RES: 10
INSERT INTO `item_mods` VALUES (19174,17,10);  -- WIND_RES: 10
INSERT INTO `item_mods` VALUES (19174,18,10);  -- EARTH_RES: 10
INSERT INTO `item_mods` VALUES (19174,19,10);  -- THUNDER_RES: 10
INSERT INTO `item_mods` VALUES (19174,20,10);  -- WATER_RES: 10
INSERT INTO `item_mods` VALUES (19174,21,10);  -- LIGHT_RES: 10
INSERT INTO `item_mods` VALUES (19174,22,10);  -- DARK_RES: 10

-- Undulant Black (Sagasinger)
-- ItemId: 17669
-- "DMG:51 Delay:233\\nHP+30 MP+30 STR+12 VIT+12\\n\"Magic Atk. Bonus\"+7\\nAdditional effect:\\nSteals enhancement effect"
INSERT INTO `item_equipment` VALUES (17669,'sagasinger',75,0,2195665,528,0,0,3,0,0,0);
INSERT INTO `item_weapon` VALUES (17669,'sagasinger',3,0,0,0,0,1,1,233,51,0);
INSERT INTO `item_mods` VALUES (17669,2,30);   -- HP +30
INSERT INTO `item_mods` VALUES (17669,5,30);   -- MP +30
INSERT INTO `item_mods` VALUES (17669,8,8);    -- STR: 8
INSERT INTO `item_mods` VALUES (17669,10,8);   -- VIT: 8
INSERT INTO `item_mods` VALUES (17669,28,7);   -- MAB +7
INSERT INTO `item_mods` VALUES (17669,431,11); -- ITEM_ADDEFFECT_TYPE: 11 (Steal Status)
INSERT INTO `item_mods` VALUES (17669,501,2);  -- ITEM_ADDEFFECT_CHANCE: 2%

-- Elegy's Respite (Xoanon)
-- ItemID: 22086
-- NEW item modelID 857
-- "DMG:72 Delay:402\\nINT+8 MND+8 \\nAccuracy+10 Attack+15\\n\"Refresh\"+1\\nDamage taken -8%"
-- change to UPDATE `item_weapon` SET `dmg` = 72 , `delay` = 402 WHERE itemId = "22086";
INSERT INTO `item_equipment` VALUES (22086,'xoanon',75,0,1590047,857,0,0,1,0,0,0);
INSERT INTO `item_weapon` VALUES (22086,'xoanon',12,0,0,0,0,0,1,402,72,0);
INSERT INTO `item_mods` VALUES (22086,12,8);   -- INT: 8
INSERT INTO `item_mods` VALUES (22086,13,8);   -- MND: 8
INSERT INTO `item_mods` VALUES (22086,25,10);  -- ACC +10
INSERT INTO `item_mods` VALUES (22086,23,15);  -- ATT +15
INSERT INTO `item_mods` VALUES (22086,369,1);  -- REFRESH +1
INSERT INTO `item_mods` VALUES (22086,160,-500); -- DAMAGE TAKEN -5%

-- Carver (Ikarigiri)
-- ItemId: 19298
-- "DMG:41 Delay:222 STR+8 DEX+8 \\nEnmity+5 Evasion+5\\nAdds \"Regen\" effect\\n\"Utsusemi\"+1"
UPDATE `item_equipment` SET `level` = "75", `ilevel` = "0" WHERE itemId = "19298";
UPDATE `item_weapon` SET `dmg` = "41" , `delay` = "222" WHERE `itemId` = "19298";
INSERT INTO `item_mods` VALUES (19298,8,8);   -- STR: 8
INSERT INTO `item_mods` VALUES (19298,9,8);   -- DEX: 8
INSERT INTO `item_mods` VALUES (19298,27,5);  -- ENMITY: +5
INSERT INTO `item_mods` VALUES (19298,68,5);  -- EVA: 5
INSERT INTO `item_mods` VALUES (19298,370,1); -- Regen +1
INSERT INTO `item_mods` VALUES (19298,900,1); -- Utsusemi Shadows +1

-- Somnia Melodiam (Ephemeron)
-- ItemId: 18904
-- "DMG:42 Delay:201 \\nAccuracy+10 \\n\"Ensmite\"\\nOccasionally attacks twice"
-- JOBS: RDM BRD GET SQL UPDATE 512 + 16 = 528
UPDATE `item_equipment` SET `level` = "75", `ilevel` = "0", `jobs` = "528" WHERE `itemId` = "18904";
UPDATE `item_weapon` SET `dmg` = "42", `delay` = "201", `hit` = "2" WHERE `itemId` = "18904";
INSERT INTO `item_mods` VALUES (18904,25,15);    -- ACC +15
INSERT INTO `item_mods` VALUES (18904,431,1);    -- ITEM_ADDEFFECT_TYPE: 1
INSERT INTO `item_mods` VALUES (18904,499,5);    -- ITEM_SUBEFFECT: 5
INSERT INTO `item_mods` VALUES (18904,500,5);    -- ITEM_ADDEFFECT_DMG: 5
INSERT INTO `item_mods` VALUES (18904,501,100);  -- ITEM_ADDEFFECT_CHANCE: 100
INSERT INTO `item_mods` VALUES (18904,950,5);    -- ITEM_ADDEFFECT_ELEMENT: 5
-- Hidden Effect's
INSERT INTO `item_mods` VALUES (18904,347,3);  -- FIRE_AFFINITY_DMG: 3
INSERT INTO `item_mods` VALUES (18904,348,3);  -- ICE_AFFINITY_DMG: 3
INSERT INTO `item_mods` VALUES (18904,349,3);  -- WIND_AFFINITY_DMG: 3
INSERT INTO `item_mods` VALUES (18904,350,3);  -- EARTH_AFFINITY_DMG: 3
INSERT INTO `item_mods` VALUES (18904,351,3);  -- THUNDER_AFFINITY_DMG: 3
INSERT INTO `item_mods` VALUES (18904,352,3);  -- WATER_AFFINITY_DMG: 3
INSERT INTO `item_mods` VALUES (18904,353,3);  -- LIGHT_AFFINITY_DMG: 3
INSERT INTO `item_mods` VALUES (18904,354,3);  -- DARK_AFFINITY_DMG: 3
INSERT INTO `item_mods` VALUES (18904,544,3);  -- FIRE_AFFINITY_ACC: 3
INSERT INTO `item_mods` VALUES (18904,545,3);  -- ICE_AFFINITY_ACC: 3
INSERT INTO `item_mods` VALUES (18904,546,3);  -- WIND_AFFINITY_ACC: 3
INSERT INTO `item_mods` VALUES (18904,547,3);  -- EARTH_AFFINITY_ACC: 3
INSERT INTO `item_mods` VALUES (18904,548,3);  -- THUNDER_AFFINITY_ACC: 3
INSERT INTO `item_mods` VALUES (18904,549,3);  -- WATER_AFFINITY_ACC: 3
INSERT INTO `item_mods` VALUES (18904,550,3);  -- LIGHT_AFFINITY_ACC: 3
INSERT INTO `item_mods` VALUES (18904,551,3);  -- DARK_AFFINITY_ACC: 3
INSERT INTO `item_mods` VALUES (18904,566,1);  -- IRIDESCENCE: 1

-- Hax (Himthige)
-- ItemId: 18525
-- "DMG:109 Delay:504 \\nSTR+8 VIT+8\\nAccuracy+5 Attack+12\\nIncreases \"Double Attack\" damage\\nAdditional effect: TP drain"
UPDATE `item_equipment` SET `level` = "75", `ilevel` = "0" WHERE `itemId` = "18525";
UPDATE `item_weapon` SET `dmg` = "109", `delay` = "504" WHERE `itemId` = "18525";
INSERT INTO `item_mods` VALUES (18525,8,8);    -- STR: 8
INSERT INTO `item_mods` VALUES (18525,10,8);   -- VIT: 8
INSERT INTO `item_mods` VALUES (18525,25,5);   -- ACC +5
INSERT INTO `item_mods` VALUES (18525,23,12);  -- ATT +12
INSERT INTO `item_mods` VALUES (18525,1038,3); -- Increases "Double Attack" damage +3%
INSERT INTO `item_mods` VALUES (18525,431,7);  -- ITEM_ADDEFFECT_TYPE: 7
INSERT INTO `item_mods` VALUES (18525,499,21); -- ITEM_SUBEFFECT: 21
INSERT INTO `item_mods` VALUES (18525,500,50); -- ITEM_ADDEFFECT_DMG: 50
INSERT INTO `item_mods` VALUES (18525,501,2);  -- ITEM_ADDEFFECT_CHANCE: 2%
INSERT INTO `item_mods` VALUES (18525,950,8);  -- ITEM_ADDEFFECT_ELEMENT: 8

-- Tonzoffun (Ullr)
-- ItemId: 22107
-- "DMG:83 Delay:540 \\nSTR+8 AGI+8 \\nRanged Accuracy+10 Ranged Attack+10\\n\"Rapid Shot\"+3 \"Store TP\"+5"
UPDATE `item_equipment` SET `level` = "75", `ilevel` = "0", `jobs` = "1024", `MId` = "140" WHERE `itemId` = "22107";
UPDATE `item_weapon` SET `ilvl_skill` = "0", `dmg` = "83", `delay` = "540" WHERE `itemId` = "22107";
INSERT INTO `item_mods` VALUES (22107,8,8);    -- STR: 8
INSERT INTO `item_mods` VALUES (22107,9,8);    -- DEX: 8
INSERT INTO `item_mods` VALUES (22107,24,10);   -- RATT: 10
INSERT INTO `item_mods` VALUES (22107,26,10);   -- RACC: 10
INSERT INTO `item_mods` VALUES (22107,73,5);    -- STORETP: 5
INSERT INTO `item_mods` VALUES (22107,359,3);   -- RAPID_SHOT: 3

-- Face Breakers (Karambit)
-- ItemId: 21519
-- "DMG:28 Delay:+86 \\nSTR+8 DEX+8 \\nAccuracy+10\\nEnhances \"Maneuver\" effects\\nEnhances \"Boost\" effect\\nAdditional effect: TP drain"
UPDATE `item_equipment` SET `level` = "75", `ilevel` = "0", `jobs` = "131074" WHERE `itemId` = "21519";
UPDATE `item_weapon` SET `ilvl_skill` = "0", `ilvl_parry` = "0", `ilvl_macc` = "0", `dmg` = "28", `delay` = "566" WHERE `itemId` = "21519";
INSERT INTO `item_mods` VALUES (21519,8,8);    -- STR: 8
INSERT INTO `item_mods` VALUES (21519,9,8);    -- DEX: 8
INSERT INTO `item_mods` VALUES (21519,25,10);  -- ACC: 10
INSERT INTO `item_mods` VALUES (21519,504,2);  -- MANEUVER_BONUS: 2
INSERT INTO `item_mods` VALUES (21519,97,50);  -- BOOST_EFFECT: 50
INSERT INTO `item_mods` VALUES (21519,431,7);  -- ITEM_ADDEFFECT_TYPE: 7
INSERT INTO `item_mods` VALUES (21519,499,21); -- ITEM_SUBEFFECT: 21
INSERT INTO `item_mods` VALUES (21519,500,25); -- ITEM_ADDEFFECT_DMG: 25
INSERT INTO `item_mods` VALUES (21519,501,2);  -- ITEM_ADDEFFECT_CHANCE: 2%
INSERT INTO `item_mods` VALUES (21519,950,8);  -- ITEM_ADDEFFECT_ELEMENT: 8

-- Broken Promise (Drepanum)
-- ItemId: 21830
-- "DMG:28 Delay:+86 \\nSTR+8 DEX+8 \\nAccuracy+10\\nEnhances \"Maneuver\" effects\\nEnhances \"Boost\" effect\\nAdditional effect: TP drain"
UPDATE `item_equipment` SET `level` = "75", `ilevel` = "0", `jobs` = "128", `MId` = "853" WHERE `itemId` = "21830";
UPDATE `item_weapon` SET `ilvl_skill` = "0", `ilvl_parry` = "0", `ilvl_macc` = "0", `dmg` = 105, `delay` = 513 WHERE itemId = "21830";
INSERT INTO `item_mods` VALUES (21830,8,8);     -- STR: 8
INSERT INTO `item_mods` VALUES (21830,9,8);     -- DEX: 8
INSERT INTO `item_mods` VALUES (21830,23,15);   -- ATT: 15
INSERT INTO `item_mods` VALUES (21830,73,5);    -- STORETP: 5
INSERT INTO `item_mods` VALUES (21830,1070,15); -- Enhances "Blood Weapon" effect (increases Blood Weapon's duration in sec…

-- Raqia (Dolichenus)
-- ItemId: 21722
-- "DMG:57 Delay:288\\nAGI+12 Attack+7 Ranged Attack+7\\nPhysical Damage taken -10%\\nAdditional effect: MP drain"
INSERT INTO `item_equipment` VALUES (@RAQIA,'raqia',75,0,2098561,850,0,0,3,0,0,0);
INSERT INTO `item_weapon` VALUES (@RAQIA,'raqia',5,0,0,0,0,2,1,288,58,0);
INSERT INTO `item_mods` VALUES (@RAQIA,11,12);     -- AGI: 12
INSERT INTO `item_mods` VALUES (@RAQIA,23,7);      -- ATT: 7
INSERT INTO `item_mods` VALUES (@RAQIA,24,7);      -- RATT: 7
INSERT INTO `item_mods` VALUES (@RAQIA,161,-1000); -- Physical damage taken -10%
INSERT INTO `item_mods` VALUES (@RAQIA,431,6);     -- ITEM_ADDEFFECT_TYPE: 6
INSERT INTO `item_mods` VALUES (@RAQIA,499,22);    -- ITEM_SUBEFFECT: 22
INSERT INTO `item_mods` VALUES (@RAQIA,500,24);    -- ITEM_ADDEFFECT_DMG: 24
INSERT INTO `item_mods` VALUES (@RAQIA,501,12);    -- ITEM_ADDEFFECT_CHANCE: 12%
INSERT INTO `item_mods` VALUES (@RAQIA,950,8);     -- ITEM_ADDEFFECT_ELEMENT: 8

-- Domain Ring (Shining Ring)
-- ItemId: 15771
-- "Enchantment: \"Elvorseal\""
UPDATE `item_equipment` SET `name` = "domain_ring", `level` = "1" WHERE `itemId` = "15771";
UPDATE `item_basic` SET `name` = "domain_ring", `sortname` = "domain_ring", `flags` = 60480, `aH` = 0, `NoSale` = 0 WHERE `itemId` = "15771";

DELETE FROM `item_usable` WHERE `itemId` = "15771";
INSERT INTO `item_usable` VALUES (15771,'domain_ring',1,3,76,0,5,30,3600,0);
-- Needs LUA

-----------------------------------
-- Add jobs to existing gear sets
-----------------------------------
-- RUN job code: 2097152
-- DNC job code: 262144
-- SCH job code: 524288
-- BLM job code: 8

-- Add BLM to Bahamuts Zaghnal
UPDATE item_equipment SET jobs = "393" WHERE name = "bahamut_zaghnal";

-- Add RUN to Bahamuts Mask
UPDATE item_equipment SET jobs = "2107584" WHERE name = "bahamuts_mask";

-- Allow DNC to equip Mercurial Kris
UPDATE item_equipment SET jobs = "474849" WHERE name = "mercurial_kris";

-- Allow DNC to equip Skadis gear
UPDATE item_equipment SET jobs = "328992" WHERE name = "skadis_cuirie";
UPDATE item_equipment SET jobs = "328992" WHERE name = "skadis_bazubands";
UPDATE item_equipment SET jobs = "328992" WHERE name = "skadis_chausses";
UPDATE item_equipment SET jobs = "328992" WHERE name = "skadis_jambeaux";
UPDATE item_equipment SET jobs = "328992" WHERE name = "skadis_visor";

-- Allow SCH to equip Marduks gear
UPDATE item_equipment SET jobs = "541188" WHERE name = "marduks_jubbah";
UPDATE item_equipment SET jobs = "541188" WHERE name = "marduks_dastanas";
UPDATE item_equipment SET jobs = "541188" WHERE name = "marduks_shalwar";
UPDATE item_equipment SET jobs = "541188" WHERE name = "marduks_crackows";
UPDATE item_equipment SET jobs = "541188" WHERE name = "marduks_tiara";

-- Allow RUN to equip Homam gear
UPDATE item_equipment SET jobs = "2138336" WHERE name = "homam_corazza";
UPDATE item_equipment SET jobs = "2138336" WHERE name = "homam_manopolas";
UPDATE item_equipment SET jobs = "2138336" WHERE name = "homam_zucchetto";
UPDATE item_equipment SET jobs = "2138336" WHERE name = "homam_cosciales";
UPDATE item_equipment SET jobs = "2138336" WHERE name = "homam_gambieras";

-- Allow RUN to equip Ares gear
UPDATE item_equipment SET jobs = "2105537" WHERE name = "ares_cuirass";
UPDATE item_equipment SET jobs = "2105537" WHERE name = "ares_gauntlets";
UPDATE item_equipment SET jobs = "2105537" WHERE name = "ares_flanchard";
UPDATE item_equipment SET jobs = "2105537" WHERE name = "ares_sollerets";
UPDATE item_equipment SET jobs = "2105537" WHERE name = "ares_mask";

-- Allow GEO to equip Nashira gear
UPDATE item_equipment SET jobs = "1097756" WHERE name = "nashira_manteel";
UPDATE item_equipment SET jobs = "1097756" WHERE name = "nashira_gages";
UPDATE item_equipment SET jobs = "1097756" WHERE name = "nashira_turban";
UPDATE item_equipment SET jobs = "1097756" WHERE name = "nashira_seraweels";
UPDATE item_equipment SET jobs = "1097756" WHERE name = "nashira_crackows";

-- Allow GEO to equip Morrigan gear
UPDATE item_equipment SET jobs = "1081368" WHERE name = "morrigans_robe";
UPDATE item_equipment SET jobs = "1081368" WHERE name = "morrigans_cuffs";
UPDATE item_equipment SET jobs = "1081368" WHERE name = "morrigans_slops";
UPDATE item_equipment SET jobs = "1081368" WHERE name = "morrigans_pgch.";
UPDATE item_equipment SET jobs = "1081368" WHERE name = "morrigans_coron.";

-- Allow RUN to equip Ragnarok
UPDATE item_equipment SET jobs = "2097345" WHERE name = "ragnarok" and itemId = "18282";

-- Allow GEO to equip Mjollnir
UPDATE item_equipment SET jobs = "1048580" WHERE name = "mjollnir" and itemId = "18324";

-- Add BLU to Joyeuse
UPDATE item_equipment SET jobs = "369233" WHERE name = "joyeuse" and itemId = "17652";

-----------------------------------
-- Crystal Warrior Items
-----------------------------------

-- Provenance Ring (formerly Emporox's ring)
-- Cleanup exiting mods
DELETE FROM item_mods WHERE itemId = 28470;

-- Rename ring in database
UPDATE item_equipment SET name = "provenance_ring", level = 1 WHERE itemId = 28470;
UPDATE item_basic SET name = "provenance_ring" WHERE itemId = 28470;

-- Make item usable
INSERT INTO item_usable VALUES (28470,'provenance_ring',1,1,27,8,1,15,3600,0);

-- Add item mods
INSERT INTO item_mods VALUES (28470,1,2);  -- DEF: 2
INSERT INTO item_mods VALUES (28470,10,1); -- VIT+1
-- End Provenance ring

-- Lower Chocobo Whistle from 30 seconds to 15 seconds
UPDATE item_usable SET useDelay = 15 WHERE name = 'chocobo_whistle';

-----------------------------------
-- Bahamut (The Wyrmking Descends)
-----------------------------------

-- Preparation
DELETE FROM item_mods WHERE itemId = 15264;     -- Bahamut's Mask
DELETE FROM item_mods WHERE itemId = 15599;     -- Bahamut's Hose
DELETE FROM item_mods WHERE itemId = 17598;     -- Bahamut's Staff
DELETE FROM item_mods WHERE itemId = 18061;     -- Bahamut's Zaghnal
DELETE FROM item_mods_pet WHERE itemId = 17598; -- Bahamut's Staff
DELETE FROM item_latents WHERE itemId = 18061;  -- Bahamut's Zaghnal

-- Bahamut's Mask
INSERT INTO item_mods VALUES (15264,1,32);   -- DEF: 32
INSERT INTO item_mods VALUES (15264,27,8);   -- ENMITY: 8
INSERT INTO item_mods VALUES (15264,233,1);  -- DRAGON_KILLER: 1
INSERT INTO item_mods VALUES (15264,15,10);  -- FIRE_RES +10
INSERT INTO item_mods VALUES (15264,25,4);   -- ACC +4
INSERT INTO item_mods VALUES (15264,384,400);  -- HASTE_GEAR 4%

-- Bahamut's Hose
INSERT INTO item_mods VALUES (15599,1,31);     -- DEF: 31
INSERT INTO item_mods VALUES (15599,162,-500); -- DMGBREATH: -500
INSERT INTO item_mods VALUES (15599,292,6);    -- KICK_ATTACK_RATE: 6
INSERT INTO item_mods VALUES (15599,9,6);      -- DEX+6
INSERT INTO item_mods VALUES (15599,15,20);    -- FIRE_RES +20
INSERT INTO item_mods VALUES (15599,25,6);     -- ACC +6
INSERT INTO item_mods VALUES (15599,233,1);    -- DRAGON_KILLER: 1

-- Bahamut's Staff
INSERT INTO item_mods VALUES (17598,5,30);     -- MP: 30
INSERT INTO item_mods VALUES (17598,117,10);   -- SUMMONING: 10
INSERT INTO item_mods VALUES (17598,346,3);    -- PERPETUATION_REDUCTION: 3
INSERT INTO item_mods VALUES (17598,15,30);    -- FIRE_RES +30
INSERT INTO item_mods VALUES (17598,913,5);    -- BLOOD_BOON: 5
INSERT INTO item_mods_pet VALUES (17598,370,3,1);  -- Avatar - REGEN: 3

-- Bahamut's Zaghnal
INSERT INTO item_mods VALUES (18061,15,30); -- FIRE_RES +30
INSERT INTO item_mods VALUES (18061,25,5);  -- ACC +5
INSERT INTO item_mods VALUES (18061,23,5);  -- ATT: 5
INSERT INTO item_latents VALUES (18061,165,7,59,6);   -- Vs. beasts: Critical hit rate +7%
INSERT INTO item_latents VALUES (18061,165,7,59,17);  -- Vs. plantoids: +7% crit
