/*
Author: Neckbeard & Hax
Date: 6/3/2023
Rev: 1.0
Description: A module to add custom equipment to the server for CW players.
*/
----------------------------------
-- CW item_mods Modifications
----------------------------------
SET @MOD_STR =  8;
SET @MOD_DEX =  9;
SET @MOD_VIT = 10;
SET @MOD_AGI = 11;
SET @MOD_INT = 12;
SET @MOD_MND = 13;
SET @MOD_CHR = 14;
SET @MOD_STORE_TP = 73;

-- Delete all item_mods and item_mods_pet rows for CW items
DELETE FROM item_mods
WHERE itemId IN (
    23757, 23764, 23771, 23778, 23785, -- WAR
    26793, 26949, 27099, 27284, 27459, -- MNK
    23760, 23767, 23774, 23781, 23788, -- WHM
    26797, 26953, 27103, 27288, 27463, -- BLM
    23732, 23733, 23734, 23735, 23736, -- RDM
    25613, 25686, 27117, 27302, 27473, -- THF
    27764, 27910, 28049, 28191, 28330, -- PLD
    23756, 23763, 23770, 23777, 23784, -- DRK
    25641, 25717, 25841, 27139, 27495, -- BST
    26795, 26951, 27101, 27286, 27461, -- BRD
    25642, 25718, 27140, 25842, 27496, -- RNG
    25644, 25720, 27142, 25844, 27498, -- SAM
    25611, 25684, 27115, 27300, 27471, -- NIN
    23758, 23765, 23772, 23779, 23786, -- DRG
    25640, 25716, 27138, 25840, 27494, -- SMN
    23759, 23766, 23773, 23780, 23787, -- BLU
    23755, 23762, 23769, 23776, 23783, -- COR
    27784, 27924, 28064, 28204, 28344, -- PUP
    26794, 26950, 27100, 27285, 27460, -- DNC
    25643, 25719, 27141, 25843, 27497, -- SCH
    25615, 25688, 27119, 27304, 27475, -- GEO
    26791, 26947, 27097, 27282, 27457  -- RUN
);
DELETE FROM item_mods_pet
WHERE itemId IN (
    23757, 23764, 23771, 23778, 23785, -- WAR
    26793, 26949, 27099, 27284, 27459, -- MNK
    23760, 23767, 23774, 23781, 23788, -- WHM
    26797, 26953, 27103, 27288, 27463, -- BLM
    23732, 23733, 23734, 23735, 23736, -- RDM
    25613, 25686, 27117, 27302, 27473, -- THF
    27764, 27910, 28049, 28191, 28330, -- PLD
    23756, 23763, 23770, 23777, 23784, -- DRK
    25641, 25717, 25841, 27139, 27495, -- BST
    26795, 26951, 27101, 27286, 27461, -- BRD
    25642, 25718, 27140, 25842, 27496, -- RNG
    25644, 25720, 27142, 25844, 27498, -- SAM
    25611, 25684, 27115, 27300, 27471, -- NIN
    23758, 23765, 23772, 23779, 23786, -- DRG
    25640, 25716, 27138, 25840, 27494, -- SMN
    23759, 23766, 23773, 23780, 23787, -- BLU
    23755, 23762, 23769, 23776, 23783, -- COR
    27784, 27924, 28064, 28204, 28344, -- PUP
    26794, 26950, 27100, 27285, 27460, -- DNC
    25643, 25719, 27141, 25843, 27497, -- SCH
    25615, 25688, 27119, 27304, 27475, -- GEO
    26791, 26947, 27097, 27282, 27457  -- RUN
);

----------------------------------
-- Insert into item_mods.sql
----------------------------------

-- Warrior(Sakpata Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Sakpata's Helm
    (23757, 1, 31),     -- DEF+31
    (23757, 2, 25),     -- HP+25
    (23757, 9, 5),      -- DEX+5
    (23757, 10, 5),     -- VIT+5
    (23757, 109, 10),   -- Shield Skill+10
    (23757, 384, 500),  -- Haste+5% (Base 1000)
    (23757, 518, 3),    -- Shield block rate+3%
-- Sakpata's Plate
    (23764, 1, 53),     -- DEF+53
    (23764, 2, 50),     -- HP+50
    (23764, 23, 12),    -- Attack+12
    (23764, 25, 12),    -- Accuracy+12
    (23764, 27, 5),     -- Enmity+5
    (23764, 160, -500), -- Damage Taken-5% (Base 1000)
    (23764, 168, 20),   -- Spell Interruption Rate Down 20%
    (23764, 3, 5),      -- HP +5%
    (23764, 166, -5),   -- Enemy crit rate -5%
-- Sakpata's Gauntlets
    (23771, 1, 25),     -- DEF+25
    (23771, 8, 5),      -- STR+5
    (23771, 27, 3),     -- Enmity+3
    (23771, 82, 8),     -- Sword Skill+8
    (23771, 384, 300),  -- Haste+3% (Base 1000)
    (23771, 414, 5),    -- Retaliation Damage+5 (dmg * 0.05)
-- Sakpata's Cuisses
    (23778, 1, 42),     -- DEF+42
    (23778, 9, 5),      -- DEX+5
    (23778, 10, 5),     -- VIT+5
    (23778, 109, 8),    -- Shield Skill+8
    (23778, 286, 2),    -- Double Attack+2%
    (23778, 384, 500),  -- Haste+5% (Base 1000)
-- Sakpata's Leggings
    (23785, 1, 22),     -- DEF+22
    (23785, 2, 25),     -- HP+25
    (23785, 8, 3),      -- STR+3
    (23785, 27, 5),     -- Enmity+5
    (23785, 84, 8),     -- Axe Skill+8
    (23785, 302, 1),    -- Triple Attack+1%
    (23785, 384, 300);  -- Haste+3% (Base 1000)

-- Monk(Naga Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Naga Somen
    (26793, 1, 26),     -- DEF+26
    (26793, 3, 5),      -- HP+5%
    (26793, 9, 5),      -- DEX+5
    (26793, 11, 5),     -- AGI+5
    (26793, 27, 5),     -- Enmity+5
    (26793, 384, 500),  -- Haste+5% (Base 1000)
    (26793, 976, 5),    -- Guard+5%
-- Naga Samue
    (26949, 1, 47),     -- DEF+47
    (26949, 3, 5),      -- HP+5%
    (26949, 23, 15),    -- Attack+15
    (26949, 25, 15),    -- Accuracy+15
    (26949, 27, 5),     -- Enmity+5
    (26949, 160, -500), -- Damage Taken-5% (Base 1000)
    (26949, 370, 1),    -- Regen+1
-- Naga Tekko
    (27099, 1, 18),     -- DEF+18
    (27099, 3, 3),      -- HP+3%
    (27099, 9, 3),      -- DEX+3
    (27099, 11, 3),     -- AGI+3
    (27099, 25, 5),     -- Accuracy+5
    (27099, 291, 3),    -- Counter+3
    (27099, 427, 6),    -- Reduces Enmity decrease when taking damage +6
-- Naga Hakama
    (27284, 1, 34),     -- DEF+34
    (27284, 3, 5),      -- HP+5%
    (27284, 107, 10),   -- Guarding Skill+10
    (27284, 166, -5),   -- Enemy Critical Hit Rate-5%
    (27284, 384, 500),  -- Haste+5% (Base 1000)
-- Naga Kyahan
    (27459, 1, 18),     -- DEF+18
    (27459, 3, 3),      -- HP+3%
    (27459, 23, 6),     -- Attack+6
    (27459, 25, 6),     -- Accuracy+6
    (27459, 27, 3),     -- Enmity+3
    (27459, 107, 6),    -- Guarding Skill+6
    (27459, 384, 300);  -- Haste+3% (Base 1000)

-- WhiteMage(Bunzi Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Bunzi's Hat
    (23760, 1, 27),     -- DEF+27
    (23760, 5, 25),     -- MP+25
    (23760, 13, 10),    -- MND+10
    (23760, 111, 10),   -- Divine Magic Skill+10
    (23760, 369, 1),    -- Refresh+1
    (23760, 519, 5),    -- Cure Spellcasting Time-5%
-- Bunzi's Robe
    (23767, 1, 45),     -- DEF+45
    (23767, 5, 50),     -- MP+50
    (23767, 8, 10),     -- STR+10
    (23767, 10, 10),    -- VIT+10
    (23767, 160, -500), -- Damge Taken-5%
    (23767, 890, 5),    -- Enhancing Magic Duration+5%
-- Bunzi's Gloves
    (23774, 1, 17),     -- DEF+17
    (23774, 5, 15),     -- MP+15
    (23774, 30, 6),     -- Magic Accuracy+6
    (23774, 112, 6),    -- Healing Magic Skill+6
    (23774, 296, 3),    -- Conserve MP+3
    (23774, 374, 3),    -- Cure Potency+3%
-- Bunzi's Pants
    (23781, 1, 34),     -- DEF+34
    (23781, 5, 25),     -- MP+25
    (23781, 10, 5),     -- VIT+5
    (23781, 12, 5),     -- INT+5
    (23781, 71, 3),     -- MP Recovered while Healing+3
    (23781, 113, 5),    -- Enhancing Magic Skill+5
-- Bunzi's Sabots
    (23788, 1, 18),     -- DEF+18
    (23788, 5, 15),     -- MP+15
    (23788, 12, 5),     -- INT+5
    (23788, 13, 5),     -- MND+5
    (23788, 72, 3),     -- HP Recovered while Healing+3
    (23788, 170, 2),    -- Fast Cast+2%
    (23788, 860, 1);    -- Converts % of Cure ammount to MP+1

-- BlackMage(Vanya Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Vanya Hood
    (26797, 1, 26),     -- DEF+26
    (26797, 5, 15),     -- MP+15
    (26797, 13, 5),     -- MND+5
    (26797, 27, -5),    -- Enmity-5
    (26797, 113, 6),    -- Enhancing Magic Skill+6
    (26797, 539, 5),    -- Enhances Stoneskil Effect+5
-- Vanya Robe           
    (26953, 1, 44),     -- DEF+44
    (26953, 5, 30),     -- MP+30
    (26953, 12, 5),     -- INT+5
    (26953, 13, 5),     -- MND+5
    (26953, 28, 5),     -- Magic Attack Bonus+5
    (26953, 30, 5),     -- Magic Accuracy+5
-- Vanya Cuffs          
    (27103, 1, 18),     -- DEF+18
    (27103, 5, 15),     -- MP+15
    (27103, 8, 6),      -- STR+6
    (27103, 9, 6),      -- DEX+6
    (27103, 23, 12),    -- Attack+12
    (27103, 25, 12),    -- Accuracy+12
    (27103, 27, -3),    -- Enmity-3
    (27103, 384, 300),  -- Haste+3%
-- Vanya Slops          
    (27288, 1, 22),     -- DEF+22
    (27288, 5, 20),     -- MP+20
    (27288, 73, 5),     -- Store TP+5
    (27288, 91, 10),    -- Staff Skill+10
    (27288, 384, 500),  -- Haste+5%
-- Vanya Clogs          
    (27463, 1, 17),     -- DEF+17
    (27463, 5, 15),     -- MP+15
    (27463, 10, 3),     -- VIT+3
    (27463, 13, 3),     -- MND+3
    (27463, 29, 3),     -- Magic Defense Bonus+3
    (27463, 31, 3),     -- Magic Evasion+3
    (27463, 255, 3);    -- Death Resistance+3

-- RedMage(Malignance Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Malignance Chapeau
    (23732, 1, 27),     -- DEF+27
    (23732, 5, 25),     -- MP+25
    (23732, 12, 6),     -- INT+6
    (23732, 13, 6),     -- MND+6
    (23732, 113, 6),    -- Enhancing Magic Skill+6
    (23732, 296, 5),    -- Conserve MP+5
    (23732, 890, 6),    -- Enhancing Magic Duration+6%
-- Malignance Tabard
    (23733, 1, 48),     -- DEF+48
    (23733, 5, 50),     -- MP+50
    (23733, 23, 12),    -- Attack+12
    (23733, 25, 12),    -- Accuracy+12
    (23733, 109, 12),   -- Shield Skill+12
    (23733, 160, -500), -- Damage Taken-5%
-- Malignance Gloves
    (23734, 1, 20),     -- DEF+20
    (23734, 5, 15),     -- MP+15
    (23734, 10, 3),     -- VIT+3
    (23734, 13, 3),     -- MND+3
    (23734, 29, 3),     -- Magic Defense Bonus+3
    (23734, 31, 3),     -- Magic Evasion+3
    (23734, 370, 1),    -- Regen+1
    (23734, 958, 5),    -- Resist all status ailments+5
-- Malignance Tights
    (23735, 1, 36),     -- DEF+36
    (23735, 5, 25),     -- MP+25
    (23735, 9, 5),      -- DEX+5
    (23735, 11, 5),     -- AGI+5
    (23735, 73, 5),     -- Store TP+5
    (23735, 82, 10),    -- Sword Skill+10
    (23735, 384, 500),  -- Haste+5%
-- Malignance Boots
    (23736, 1, 18),     -- DEF+18
    (23736, 5, 15),     -- MP+15
    (23736, 113, 6),    -- Enhancing Magic Skill+6
    (23736, 170, 3),    -- Fast Cast+3%
    (23736, 301, 2),    -- Phalanx+2
    (23736, 384, 300),  -- Haste+3%
    (23736, 539, 5);    -- Enhanses Stoneskin Effect+5

-- Thief(Adhemar Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Adhemar Bonnet
    (25613, 1, 27),     -- DEF+27
    (25613, 2, 20),     -- HP+20
    (25613, 9, 6),      -- DEX+6
    (25613, 11, 6),     -- AGI+6
    (25613, 24, 9),     -- Ranged Attack+9
    (25613, 26, 9),     -- Ranged Accuracy+9
    (25613, 165, 3),    -- Critical Hit Rate+3%
-- Adhemar Jacket       
    (25686, 1, 49),     -- DEF+49
    (25686, 2, 30),     -- HP+30
    (25686, 23, 10),    -- Attack+10
    (25686, 27, 5),     -- Enmity+5
    (25686, 108, 10),   -- Evasion Skill+10
    (25686, 384, 300),  -- Haste+3%
-- Adhemar Wristbands   
    (27117, 1, 19),     -- DEF+19
    (27117, 2, 25),     -- HP+25
    (27117, 23, 10),    -- Attack+10
    (27117, 25, 10),    -- Accuracy+10
    (27117, 303, 1),    -- Treasure Hunter+1
    (27117, 384, 300),  -- Haste+3%
    (27117, 520, 3),    -- Tick Attack Damage+3%
-- Adhemar Kecks        
    (27302, 1, 37),     -- DEF+37
    (27302, 2, 30),     -- HP+30
    (27302, 9, 4),      -- DEX+4
    (27302, 11, 4),     -- AGI+4
    (27302, 27, 5),     -- Enmity+5
    (27302, 81, 10),    -- Dagger Skill+10
    (27302, 384, 400),  -- Haste+4%
    (27302, 259, 3),    -- "Dual Wield"+3
-- Adhemar Gamashes     
    (27473, 1, 18),     -- DEF+18
    (27473, 2, 20),     -- HP+20
    (27473, 8, 5),      -- STR+5
    (27473, 10, 5),     -- VIT+5
    (27473, 27, 3),     -- Enmity+3
    (27473, 259, 1),    -- Dual Wield+1
    (27473, 302, 2);    -- Triple Attack+2%

-- Paladin(Founder Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Founder's Corona
    (27764, 1, 31),     -- DEF+31
    (27764, 2, 25),     -- HP+25
    (27764, 5, 20),     -- MP+20
    (27764, 27, 5),     -- Enmity+5
    (27764, 83, 5),     -- Great Sword skill+5
    (27764, 384, 500),  -- Haste+5%
    (27764, 73, 5),     -- "Store TP"+5
-- Founder's Breastplate
    (27910, 1, 58),     -- DEF+58
    (27910, 2, 30),     -- HP+30
    (27910, 5, 30),     -- MP+30
    (27910, 8, 5),      -- STR+5
    (27910, 9, 5),      -- DEX+5
    (27910, 25, 12),    -- Accuracy+12
    (27910, 23, 12),    -- Attack+12
    (27910, 27, 5),     -- Enmity+5
-- Founder's Gauntlets  
    (28049, 1, 25),     -- DEF+25
    (28049, 2, 20),     -- HP+20
    (28049, 5, 15),     -- MP+15
    (28049, 13, 3),     -- MND+3
    (28049, 10, 3),     -- VIT+3
    (28049, 31, 3),     -- Magic Evasion+3
    (28049, 29, 3),     -- "Magic Def. Bonus"+3
    (28049,516,2),      -- ABSORB_DMG_TO_MP: 2
    (28049,370,1),      -- REGEN: 1
    (28049,21,15),      -- LIGHT_RES: 15
    (28049,22,-20),     -- DARK_RES: -20
-- Founder's Hose       
    (28191, 1, 46),     -- DEF+46
    (28191, 2, 20),     -- HP+20
    (28191, 5, 15),     -- MP+15
    (28191, 8, 5),      -- STR+5
    (28191, 9, 5),      -- DEX+5
    (28191, 83, 5),     -- Great Sword skill+5
    (28191, 288, 3),    -- Double Attack+3%
    (28191, 384, 500),  -- Haste+5%
-- Founder's Greaves    
    (28330, 1, 22),     -- DEF+22
    (28330, 2, 15),     -- HP+15
    (28330, 5, 10),     -- MP+10
    (28330, 83, 3),     -- Great Sword skill+3
    (28330, 73, 3),     -- Store TP+3
    (28330, 384, 300),  -- Haste+3%
    (28330, 165, 3);    -- Critical hit rate+3%

-- DarkKnight(Gleti Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Gleti's Mask
    (23756, 1, 30),     -- DEF+30
    (23756, 2, 30),     -- HP+30
    (23756, 8, 5),      -- STR+5
    (23756, 12, 5),     -- INT+5
    (23756, 86, 7),     -- Scythe Skill +7
    (23756, 27, 5),     -- Enmity+5
    (23756, 384, 500),  -- Haste+5%
-- Gleti's Cuirass
    (23763, 1, 52),     -- DEF+52
    (23763, 2, 50),     -- HP+50
    (23763, 8, 10),     -- STR+10
    (23763, 9, 10),     -- DEX+10
    (23763, 25, 15),    -- Accuracy+15
    (23763, 23, 15),    -- Attack+15
    (23763, 369, 1),    -- Adds "Refresh" effect
-- Gleti's Gauntlets
    (23770, 1, 23),     -- DEF+23
    (23770, 2, 30),     -- MP+30
    (23770, 11, 5),     -- AGI+5
    (23770, 73, 3),     -- Store TP+3
    (23770, 27, 3),     -- Enmity+3
    (23770, 384, 300),  -- Haste+3%
    (23770, 160, -300), -- Damage taken-3%
-- Gleti's Breeches
    (23777, 1, 41),     -- DEF+41
    (23777, 2, 15),     -- HP+15
    (23777, 5, 15),     -- MP+15
    (23777, 9, 5),      -- DEX+5
    (23777, 12, 5),     -- INT+5
    (23777, 110, 10),   -- Parry skill+10
    (23777, 27, 5),     -- Enmity+5
    (23777, 255, 1),    -- Adds "Death" resistance (1)
-- Gleti's Boots
    (23784, 1, 20),     -- DEF+20
    (23784, 2, 5),      -- HP+5
    (23784, 5, 5),      -- MP+5
    (23784, 8, 3),      -- STR+3
    (23784, 12, 3),     -- INT+3
    (23784, 288, 3),    -- Double Attack+3%
    (23784, 27, 300),   -- Enmity+3
    (23784, 170, 3);    -- Fast Cast+3%

-- Beastmaster(Valorous Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Valorous Mask
    (25641, 1, 29),     -- DEF+29
    (25641, 2, 25),     -- HP+25
    (25641, 13, 6),     -- MND+6
    (25641, 10, 6),     -- VIT+6
    (25641, 27, -5),    -- Enmity -5
    (25641, 384, 500),  -- Haste+5%
    (25641, 364, 15),   -- Enhances "Reward" effect (REWARD_HP_BONUS: 15)
-- Valorous Mail
    (25717, 1, 52),     -- DEF+52
    (25717, 2, 40),     -- HP+40
    (25717, 25, 12),    -- Accuracy+12
    (25717, 23, 12),    -- Attack+12
    (25717, 160, -500), -- Damage taken-5%
-- Valorous Mitts
    (27139, 1, 18),     -- DEF+18
    (27139, 2, 25),     -- HP+25
    (27139, 13, 3),     -- MND+3
    (27139, 10, 3),     -- VIT+3
    (27139, 370, 1),    -- Adds "Regen" effect (+1)
    (27139, 27, -3),    -- Enmity-3
    (27139, 564, 1),    -- Augments "Call Beast" +1 (CAP 2)
-- Valorous Hose
    (25841, 1, 37),     -- DEF+37
    (25841, 2, 25),     -- HP+25
    (25841, 9, 6),      -- DEX+6
    (25841, 11, 6),     -- AGI+6
    (25841, 84, 10),    -- Axe skill+10
    (25841, 384, 500),  -- Haste+5%
-- Valorous Greaves
    (27495, 1, 17),     -- DEF+17
    (27495, 2, 20),     -- HP+20
    (27495, 9, 3),      -- DEX+3
    (27495, 11, 3),     -- AGI+3
    (27495, 86, 10),    -- Scythe skill+10
    (27495, 384, 300),  -- Haste+3%
    (27495, 73, 3);     -- Store TP+3

-- Bard(Pursuer Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Pursuer's Beret
    (26795, 1, 22),       -- DEF+22
    (26795, 5, 25),       -- MP+25
    (26795, @MOD_CHR, 3), -- CHR+3
    (26795, 27, -5),      -- Enmity-5
    (26795, 81, 5),       -- Dagger Skill+5
    (26795, 384, 500),    -- Haste+5%
    (26795, 288, 3),      -- Double Attack+3%
-- Pursuer's Doublet
    (26951, 1, 48),     -- DEF+48
    (26951, 2, 30),     -- HP+30
    (26951, 5, 30),     -- MP+30
    (26951, 9, 5),      -- DEX+5
    (26951, 11, 5),     -- AGI+5
    (26951, 25, 12),    -- Accuracy+12
    (26951, 23, 12),    -- Attack+12
    (26951, 160, -500), -- Damage taken-5%
-- Pursuer's Cuffs
    (27101, 1, 21),     -- DEF+21
    (27101, 2, 15),     -- HP+15
    (27101, 5, 15),     -- MP+15
    (27101, 13, 3),     -- MND+3
    (27101, 10, 3),     -- VIT+3
    (27101, 31, 3),     -- Magic Evasion+3
    (27101, 29, 3),     -- Magic Def. Bonus+3
    (27101, 370, 1),    -- Adds "Regen" effect (+1)
    (27101, 73, 5),     -- Store TP+5
-- Pursuer's Pants
    (27286, 1, 34),     -- DEF+34
    (27286, 2, 15),     -- HP+15
    (27286, 5, 15),     -- MP+15
    (27286, 81, 8),     -- Dagger skill+8
    (27286, 384, 500),  -- Haste+5%
    (27286, @MOD_STORE_TP, 500),  -- Store TP+5
-- Pursuer's Gaiters
    (27461, 1, 17),       -- DEF+17
    (27461, 2, 10),       -- HP+10
    (27461, 5, 10),       -- MP+10
    (27461, @MOD_MND, 3), -- MND+3
    (27461, @MOD_CHR, 3), -- CHR+3
    (27461, 255, 3),      -- Song spellcasting time -3% (SONG_SPELLCASTING_TIME: 3)
    (27461, 384, 300),    -- Haste+3%
    (27461, 454, 10);      -- Increases song effect duration (SONG_DURATION_BONUS +10)

-- Ranger(Herculean Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Herculean Helm
    (25642, 1, 27),     -- DEF+27
    (25642, 2, 25),     -- HP+25
    (25642, 9, 5),      -- DEX+5
    (25642, 8, 5),      -- STR+5
    (25642, 84, 5),     -- Axe skill +5
    (25642, 288, 3),    -- Double Attack+3%
    (25642, 384, 500),  -- Haste+5%
-- Herculean Vest       
    (25718, 1, 48),     -- DEF+48
    (25718, 2, 45),     -- HP+45
    (25718, 11, 6),     -- AGI+6
    (25718, 9, 6),      -- DEX+6
    (25718, 26, 12),    -- Ranged Accuracy+12
    (25718, 24, 12),    -- Ranged Attack+12
-- Herculean Gloves     
    (27140, 1, 17),     -- DEF+17
    (27140, 2, 20),     -- HP+20
    (27140, 13, 3),     -- MND+3
    (27140, 10, 3),     -- VIT+3
    (27140, 29, 3),     -- Magic Def. Bonus+3
    (27140, 370, 1),    -- Adds "Regen" effect (+1)
    (27140, 384, 300),  -- Haste+3%
-- Herculean Trousers   
    (25842, 1, 35),     -- DEF+35
    (25842, 2, 25),     -- HP+25
    (25842, 105, 6),    -- Marksmanship skill +6
    (25842, 26, 6),     -- Ranged Accuracy+6
    (25842, 73, 6),     -- "Store TP"+6
-- Herculean Boots      
    (27496, 1, 19),     -- DEF+19
    (27496, 2, 15),     -- HP+15
    (27496, 11, 3),     -- AGI+3
    (27496, 9, 3),      -- DEX+3
    (27496, 359, 3),    -- Rapid Shot+3
    (27496, 27, -3),    -- Enmity-3
    (27496, 365, 3);    -- Enhances "Snapshot" effect (+3)

-- Summoner(Chironic Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Chironic Hat
    (25644, 1, 21),     -- DEF+21
    (25644, 5, 20),     -- MP+20
    (25644, 27, -5),    -- Enmity-5
    (25644, 91, 10),    -- Staff skill +10
    (25644, 126, 3),    -- Blood Pact damage +3%
-- Chironic Doublet
    (25720, 1, 41),     -- DEF+41
    (25720, 5, 50),     -- MP+50
    (25720, 10, 5),     -- VIT+5
    (25720, 13, 5),     -- MND+5
    (25720, 369, 1),    -- Adds "Refresh" effect
    (25720, 160, -500), -- Damage taken-5%
-- Chironic Gloves
    (27142, 1,  18),     -- DEF+18
    (27142, 5,  25),     -- MP+25
    (27142, 10,  3),     -- VIT+3
    (27142, 13,  3),     -- MND+3
    (27142, 29,  3),     -- MDEF+3
    (27142, 31,  3),     -- MEVA+3
    (27142, 370, 1),     -- REGEN: 1
-- Chironic Hose
    (25844, 1, 32),     -- DEF+32
    (25844, 5, 20),     -- MP+20
    (25844, 27, -3),    -- Enmity-3
    (25844, 357, -2),   -- "Blood Pact" ability delay -2
    (25844, 71, 3),     -- MP recovered while healing +3
-- Chironic Slippers
    (27498, 1, 17),     -- DEF+17
    (27498, 5, 15),     -- MP+15
    (27498, 27, -2);    -- Enmity-2

-- Samurai(Ryuo Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Ryuo Somen
    (25611,1,28),       -- DEF: 28
    (25611,2,25),       -- HP: 25
    (25611,9,5),        -- DEX: 5
    (25611,11,5),       -- AGI: 5
    (25611,384,500),    -- HASTE_GEAR: 500
    (25611,508,5),      -- THIRD_EYE_COUNTER_RATE: 5
    (25611,306,1),      -- ZANSHIN: 1
-- Ryuo Domaru
    (25684,1,53),       -- DEF: 53
    (25684,2,50),       -- HP: 50
    (25684,8,5),        -- STR: 5
    (25684,10,5),       -- VIT: 5
    (25684,25,12),      -- ACC: 12
    (25684,23,12),      -- ATT: 12
    (25684,160,-500),   -- DMG: -500
    (25684,110,10),     -- PARRY: 10
-- Ryuo Tekko
    (27115,1,24),       -- DEF: 24
    (27115,2,20),       -- HP: 20
    (27115,13,3),       -- MND: 3
    (27115,10,3),       -- VIT: 3
    (27115,31,3),       -- MEVA: 3
    (27115,29,3),       -- MDEF: 3
    (27115,370,1),      -- REGEN: 1
-- Ryuo Hakama
    (27300,1,43),       -- DEF: 43
    (27300,2,25),       -- HP: 25
    (27300,8,5),        -- STR: 5
    (27300,9,5),        -- DEX: 5
    (27300,48,10),      -- WSACC: 10
    (27300,73,5),       -- STORETP: 5
-- Ryuo Sune-Ate
    (27471,1,21),       -- DEF: 21
    (27471,2,15),       -- HP: 15
    (27471,9,3),        -- DEX: 3
    (27471,11,3),       -- AGI: 3
    (27471,384,300),    -- HASTE_GEAR: 300
    (27471,508,3),      -- THIRD_EYE_COUNTER_RATE: 3
    (27471,306,1);      -- ZANSHIN: 1

-- Ninja(Mpaca Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Mpaca's Cap
    (23758,1,25),       -- DEF: 25
    (23758,2,25),       -- HP: 25
    (23758,11,6),       -- AGI: 6
    (23758,9,6),        -- DEX: 6
    (23758,108,5),      -- EVASION: 5
    (23758,31,10),      -- MEVA: 10
    (23758,384,500),    -- HASTE_GEAR: 500
-- Mpaca's Doublet
    (23765,1,49),       -- DEF: 49
    (23765,2,50),       -- HP: 50
    (23765,25,10),      -- ACC: 10
    (23765,160,-500),   -- DMG: -500
    (23765,427,10),     -- ENMITY_LOSS_REDUCTION: 10
    (23765,27,5),       -- ENMITY: 5
-- Mpaca's Gloves	
    (23772,1,21),       -- DEF: 21
    (23772,2,25),       -- HP: 25
    (23772,11,6),       -- AGI: 6
    (23772,8,6),        -- STR: 6
    (23772,110,6),      -- PARRY: 6
    (23772,384,300),    -- HASTE_GEAR: 300
    (23772,106,10),     -- THROW: 10
-- Mpaca's Hose
    (23779,1,34),       -- DEF: 34
    (23779,2,25),       -- HP: 25
    (23779,384,500),    -- HASTE_GEAR: 500
    (23779,522,5),      -- NIN_NUKE_BONUS: 5
    (23779,30,6),       -- MACC: 6
-- Mpaca's Boots
    (23786,1,18),       -- DEF: 18
    (23786,2,20),       -- HP: 20
    (23786,8,6),        -- STR: 6
    (23786,10,6),       -- VIT: 6
    (23786,25,6),       -- ACC: 6
    (23786,23,6),       -- ATT: 6
    (23786,384,300),    -- HASTE_GEAR: 300
    (23786,308,10);     -- NINJA_TOOL: 10

-- Dragoon(Odyssean Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Odyssean Helm
    (25640,1,25),       -- DEF: 25
    (25640,2,15),       -- HP: 15
    (25640,5,20),       -- MP: 20
    (25640,9,6),        -- DEX: 6
    (25640,8,6),        -- STR: 6
    (25640,23,5),       -- ATT: 5
    (25640,288,3),      -- DOUBLE_ATTACK: 3
    (25640,1043,1),     -- WYVERN_LVL_BONUS: 1
-- Odyssean Chestplate
    (25716,1,51),       -- DEF: 51
    (25716,2,30),       -- HP: 30
    (25716,5,30),       -- MP: 30
    (25716,23,12),      -- ATT: 12
    (25716,160,-500),   -- DMG: -500
    (25716,168,10),     -- SPELLINTERRUPT: 10
    (25716,384,200),    -- HASTE_GEAR: 200
-- Odyssean Gauntlets
    (27138,1,20),       -- DEF: 20
    (27138,2,15),       -- HP: 15
    (27138,5,20),       -- MP: 20
    (27138,13,6),       -- MND: 6
    (27138,10,6),       -- VIT: 6
    (27138,370,1),      -- REGEN: 1
    (27138,384,500),    -- HASTE_GEAR: 500
-- Odyssean Cuisses
    (25840,1,32),       -- DEF: 32
    (25840,2,15),       -- HP: 15
    (25840,5,25),       -- MP: 25
    (25840,23,10),      -- ATT: 10
    (25840,384,500),    -- HASTE_GEAR: 500
-- Odyssean Greaves
    (27494,1,20),       -- DEF: 20
    (27494,2,10),       -- HP: 10
    (27494,5,10),       -- MP: 10
    (27494,13,3),       -- MND: 3
    (27494,10,3),       -- VIT: 3
    (27494,29,3),       -- MDEF: 3
    (27494,384,300),    -- HASTE_GEAR: 300
    (27494,31,3);       -- MEVA: 3

-- BlueMage(Agwu Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Agwu's Cap
    (23759,1,26),       -- DEF: 26
    (23759,5,20),       -- MP: 20
    (23759,13,6),       -- MND: 6
    (23759,12,6),       -- INT: 6
    (23759,122,10),     -- BLUE: 10
    (23759,28,6),       -- MATT: 6
    (23759,1075,5),     -- BREATH_DAMAGE_DEALT: 5
-- Agwu's Robe
    (23766,1,47),       -- DEF: 47
    (23766,5,50),       -- MP: 50
    (23766,8,10),       -- STR: 10
    (23766,9,10),       -- DEX: 10
    (23766,82,10),      -- SWORD: 10
    (23766,369,1),      -- REFRESH: 1
-- Agwu's Gages
    (23773,1,19),       -- DEF: 19
    (23773,5,25),       -- MP: 25
    (23773,8,5),        -- STR: 5
    (23773,25,10),      -- ACC: 10
    (23773,384,500),    -- HASTE_GEAR: 500
    (23773,288,2),      -- DOUBLE_ATTACK: 2
    (23773,168,15),     -- SPELLINTERRUPT: 15
-- Agwu's Slops
    (23780,1,33),       -- DEF: 33
    (23780,5,15),       -- MP: 15
    (23780,9,5),        -- DEX: 5
    (23780,23,15),      -- ATT: 15
    (23780,384,300),    -- HASTE_GEAR: 300
    (23780,259,3),      -- "Dual Wield"+5
    (23780,370,3),      -- REGEN: 3
-- Agwu's Pigaches
    (23787,1,18),       -- DEF: 18
    (23787,5,20),       -- MP: 20
    (23787,13,4),       -- MND: 4
    (23787,12,4),       -- INT: 4
    (23787,30,6),       -- MACC: 6
    (23787,71,3),       -- MPHEAL: 3
    (23787,562,2);      -- MAGIC_CRITHITRATE: 2

-- Corsair(Ikenga Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Ikenga's Hat
    (23755,1,27),       -- DEF: 27
    (23755,2,20),       -- HP: 20
    (23755,9,5),        -- DEX: 5
    (23755,11,5),       -- AGI: 5
    (23755,73,5),       -- STORETP: 5
    (23755,28,5),       -- MATT: 5
    (23755,105,5),      -- MARKSMAN: 5
-- Ikenga's Vest
    (23762,1,48),       -- DEF: 48
    (23762,2,35),       -- HP: 35
    (23762,9,5),        -- DEX: 5
    (23762,11,5),       -- AGI: 5
    (23762,26,12),      -- RACC: 12
    (23762,24,12),      -- RATT: 12
    (23762,30,5),       -- MACC: 5
-- Ikenga's Gloves
    (23769,1,17),       -- DEF: 17
    (23769,2,20),       -- HP: 20
    (23769,31,3),       -- MEVA: 3
    (23769,881,1),      -- PHANTOM_ROLL: 1
    (23769,29,3),       -- MDEF: 3
    (23769,882,15),     -- PHANTOM_DURATION: 15
-- Ikenga's Trousers
    (23776,1,33),       -- DEF: 33
    (23776,2,30),       -- HP: 30
    (23776,27,-5),      -- ENMITY: -5
    (23776,365,5),      -- SNAP_SHOT: 5
    (23776,370,1),      -- REGEN: 1
    (23776,15,-20),     -- FIRE_RES: -20
    (23776,16,15),      -- ICE_RES: 15
    (23776,21,-20),     -- LIGHT_RES: -20
    (23776,22,15),      -- DARK_RES: 15
-- Ikenga's Clogs
    (23783,1,19),       -- DEF: 19
    (23783,2,20),       -- HP: 20
    (23783,8,3),        -- STR: 3
    (23783,12,3),       -- INT: 3
    (23783,73,3),       -- STORETP: 3
    (23783,28,3),       -- MATT: 3
    (23783,105,3);      -- MARKSMAN: 3

-- Puppetmaster(Thurandaut Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Thurandaut Chapeau
    (27784,1,22),       -- DEF: 22
    (27784,2,15),       -- HP: 15
    (27784,9,5),        -- DEX: 5
    (27784,80,8),       -- HTH: 8
    (27784,384,500),    -- HASTE_GEAR: 500
-- Thurandaut Tabard
    (27924,1,48),       -- DEF: 48
    (27924,2,50),       -- HP: 50
    (27924,8,10),       -- STR: 10
    (27924,9,10),       -- DEX: 10
    (27924,288,3),      -- DOUBLE_ATTACK: 3
-- Thurandaut Gloves
    (28064,1,20),       -- DEF: 20
    (28064,2,20),       -- HP: 20
    (28064,8,5),        -- STR: 5
    (28064,10,5),       -- VIT: 5
    (28064,25,6),       -- ACC: 6
    (28064,23,6),       -- ATT: 6
    (28064,384,300),    -- HASTE_GEAR: 300
-- Thurandaut Tights
    (28204,1,35),       -- DEF: 35
    (28204,2,15),       -- HP: 15
    (28204,10,5),       -- VIT: 5
    (28204,11,5),       -- AGI: 5
    (28204,25,6),       -- ACC: 6
    (28204,23,6),       -- ATT: 6
-- Thurandaut Boots
    (28344,1,20),       -- DEF: 20
    (28344,2,15),       -- HP: 15
    (28344,8,3),        -- STR: 3
    (28344,108,10),     -- EVASION: 10
    (28344,370,1);      -- REGEN: 1

-- Dancer(Rawhide Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Rawhide Mask
    (26794,1,21),       -- DEF: 21
    (26794,2,25),       -- HP: 25
    (26794,9,5),        -- DEX: 5
    (26794,25,10),      -- ACC: 10
    (26794,23,10),      -- ATT: 10
    (26794,491,7),      -- WALTZ_POTENCY: 7
    (26794,288,3),      -- DOUBLE_ATTACK: 3
-- Rawhide Vest
    (26950,1,42),       -- DEF: 42
    (26950,2,30),       -- HP: 30
    (26950,9,10),       -- DEX: 10
    (26950,11,10),      -- AGI: 10
    (26950,81,10),      -- DAGGER: 10
    (26950,384,500),    -- HASTE_GEAR: 500
    (26950,497,-3),     -- WALTZ_DELAY: -3
-- Rawhide Gloves
    (27100,1,20),       -- DEF: 20
    (27100,2,20),       -- HP: 20
    (27100,10,10),      -- VIT: 10
    (27100,23,5),       -- ATT: 5
    (27100,25,5),       -- ACC: 5
    (27100,384,300),    -- HASTE_GEAR: 300
    (27100,160,-300),   -- DMG: -300
-- Rawhide Trousers
    (27285,1,31),       -- DEF: 31
    (27285,2,15),       -- HP: 15
    (27285,8,5),        -- STR: 5
    (27285,11,5),       -- AGI: 5
    (27285,25,5),       -- ACC: 5
    (27285,27,-5),      -- ENMITY: -5
    (27285,384,300),    -- HASTE_GEAR: 300
-- Rawhide Boots
    (27460,1,20),       -- DEF: 20
    (27460,2,25),       -- HP: 25
    (27460,8,5),        -- STR: 5
    (27460,10,5),       -- VIT: 5
    (27460,108,8),      -- EVASION: 8
    (27460,259,1),      -- DUAL_WIELD: 1
    (27460,988,1);      -- MAX_FINISHING_MOVE_BONUS: 1

-- Scholar(Merlinic Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Merlinic Hood
    (25643,1,19),       -- DEF: 19
    (25643,5,25),       -- MP: 25
    (25643,30,5),       -- MACC: 5
    (25643,374,10),     -- CURE_POTENCY: 10
    (25643,838,1),      -- REGEN_MULTIPLIER: 1
    (25643,489,-5),     -- GRIMOIRE_SPELLCASTING: -5
-- Merlinic Jubbah
    (25719,1,41),       -- DEF: 41
    (25719,2,30),       -- HP: 30
    (25719,5,30),       -- MP: 30
    (25719,12,5),       -- INT: 5
    (25719,13,5),       -- MND: 5
    (25719,30,10),      -- MACC: 10
    (25719,337,17),     -- DARK_ARTS_SKILL: 17
-- Merlinic Dastanas
    (27141,1,17),       -- DEF: 17
    (27141,2,25),       -- HP: 25
    (27141,12,3),       -- INT: 3
    (27141,168,20),     -- SPELLINTERRUPT: 20
    (27141,27,-5),      -- ENMITY: -5
    (27141,401,1),      -- SUBLIMATION_BONUS: 1
-- Merlinic Shalwar
    (25843,1,30),       -- DEF: 30
    (25843,5,25),       -- MP: 25
    (25843,12,3),       -- INT: 3
    (25843,13,3),       -- MND: 3
    (25843,116,9),      -- DARK: 9
    (25843,28,6),       -- MATT: 6
    (25843,902,25),     -- OCCULT_ACUMEN: 25
-- Merlinic Crackows
    (27497,1,16),       -- DEF: 16
    (27497,2,25),       -- HP: 25
    (27497,13,3),       -- MND: 3
    (27497,27,-3),      -- ENMITY: -3
    (27497,336,17),     -- LIGHT_ARTS_SKILL: 17
    (27497,112,10);     -- HEALING: 10

-- Geomancer(Amalric Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Amalric Coif
    (25615,1,19),       -- DEF: 19
    (25615,5,25),       -- MP: 25
    (25615,13,7),       -- MND: 7
    (25615,10,7),       -- VIT: 7
    (25615,123,8),      -- GEOMANCY_SKILL: 8
    (25615,369,1),      -- REFRESH: 1
    (25615,1025,1),     -- FULL_CIRCLE: 1
-- Amalric Doublet
    (25688,1,41),       -- DEF: 41
    (25688,2,50),       -- HP: 50
    (25688,5,50),       -- MP: 50
    (25688,13,10),      -- MND: 10
    (25688,12,10),      -- INT: 10
    (25688,384,500),    -- HASTE_GEAR: 500
    (25688,28,6),       -- MATT: 6
    (25688,562,2),      -- MAGIC_CRITHITRATE: 2
-- Amalric Gages
    (27119,1,17),       -- DEF: 17
    (27119,2,25),       -- HP: 25
    (27119,10,4),       -- VIT: 4
    (27119,14,4),       -- CHR: 4
    (27119,161,-700),   -- DMGPHYS: -700
    (27119,370,1),      -- REGEN: 1
    (27119,1029,3),     -- LIFE_CYCLE_EFFECT: 3
    (27119,168,20),     -- SPELLINTERRUPT: 20
-- Amalric Slops
    (27304,1,30),       -- DEF: 30
    (27304,5,25),       -- MP: 25
    (27304,12,5),       -- INT: 5
    (27304,124,8),      -- HANDBELL_SKILL: 8
-- Amalric Nails
    (27475,1,16),       -- DEF: 16
    (27475,2,25),       -- HP: 25
    (27475,14,5),       -- CHR: 5
    (27475,114,8),      -- ENFEEBLE: 8
    (27475,29,3);       -- MDEF: 3

-- RuneFencer(Eschite Set)
INSERT INTO item_mods (itemId, modId, Value)
VALUES
-- Eschite Helm
    (26791,1,30),       -- DEF: 30
    (26791,2,15),       -- HP: 15
    (26791,5,20),       -- MP: 20
    (26791,9,3),        -- DEX: 3
    (26791,11,3),       -- AGI: 3
    (26791,110,10),     -- PARRY: 10
    (26791,384,500),    -- HASTE_GEAR: 500
    (26791,958,2),      -- STATUSRES: 2
-- Eschite Breastplate
    (26947,1,54),       -- DEF: 54
    (26947,2,30),       -- HP: 30
    (26947,5,30),       -- MP: 30
    (26947,9,5),        -- DEX: 5
    (26947,11,5),       -- AGI: 5
    (26947,25,12),      -- ACC: 12
    (26947,23,12),      -- ATT: 12
    (26947,160,-500),   -- DMG: -500
-- Eschite Gauntlets
    (27097,1,30),       -- DEF: 30
    (27097,2,30),       -- HP: 30
    (27097,5,30),       -- MP: 30
    (27097,13,3),       -- MND: 3
    (27097,10,3),       -- VIT: 3
    (27097,27,5),       -- ENMITY: 5
    (27097,384,300),    -- HASTE_GEAR: 300
    (27097,427,6),      -- ENMITY_LOSS_REDUCTION: 6
-- Eschite Cuisses
    (27282,1,43),       -- DEF: 43
    (27282,2,15),       -- HP: 15
    (27282,5,15),       -- MP: 15
    (27282,27,5),       -- ENMITY: 5
    (27282,384,500),    -- HASTE_GEAR: 500
    (27282,516,2),      -- ABSORB_DMG_TO_MP: 2
-- Eschite Greaves
    (27457,1,21),       -- DEF: 21
    (27457,2,10),       -- HP: 10
    (27457,5,10),       -- MP: 10
    (27457,13,3),       -- MND: 3
    (27457,10,3),       -- VIT: 3
    (27457,29,3),       -- MDEF: 3
    (27457,31,3),       -- MEVA: 3
    (27457,384,300);    -- HASTE_GEAR: 300

----------------------------------
-- Insert into item_mods_pet.sql
----------------------------------

-- Beastmaster(Valorous Set)
INSERT INTO item_mods_pet (itemId, modId, value, petType)
VALUES
-- Valorous Mask
    (25641,25,10,0),    -- All Pets - ACC: 10
-- Valorous Mail
    (25717,27,5,0),     -- ALL PETS - ENMITY: 5
-- Valorous Mitts
    (25841,23,10,0),    -- ALL PETS - ATT: 10
-- Valorous Hose
    (27139,384,300,0),  -- All PETS - HASTE_GEAR: 300
-- Valorous Greaves
    (27495,384,300,0);  -- All PETS - HASTE_GEAR: 300

-- Dragoon(Odyssean Set)
INSERT INTO item_mods_pet (itemId, modId, value, petType)
VALUES
-- Odyssean Chestplate
    (25716,160,-500,2), -- Wyvern - DMG: -500
-- Odyssean Gauntlets
    (27138,370,5,2),    -- Wyvern - REGEN: 5
-- Odyssean Cuisses	
    (25840,23,25,2),    -- Wyvern - ATT: 25
-- Odyssean Greaves	
    (27494,163,-300,2); -- Wyvern - DMGMAGIC: -300

-- Summoner(Chironic Set)
INSERT INTO item_mods_pet (itemId, modId, value, petType)
VALUES
-- Chironic Hat
    (25644,27,5,1),     -- Avatar - ENMITY: 5
-- Chironic Doublet
    (25720,27,5,1),     -- Avatar - ENMITY: 5
-- Chironic Gloves
    (27142,370,5,1),    -- Avatar - REGEN: 5
-- Chironic Slippers
    (27498,28,3,1),     -- Avatar - Magic Attack Bonus+5
    (27498,27,3,1);     -- Avatar - ENMITY: 3

-- Puppetmaster(Thurandaut Set)
INSERT INTO item_mods_pet (itemId, modId, value, petType)
VALUES
-- Thurandaut Chapeau
    (27784,369,1,3),    -- Automaton - REFRESH: 1
-- Thurandaut Tabard
    (27924,2,50,3),     -- Automaton - HP: 50
    (27924,27,5,3),     -- Automaton - ENMITY: 5
-- Thurandaut Gloves
    (28064,384,500,3),  -- Automaton - HASTE_GEAR: 500
-- Thurandaut Tights
    (28204,30,5,3),     -- Automaton - MACC: 5
-- Thurandaut Boots
    (28344,28,5,3);     -- Automaton - MATT: 5

-- Geomancer(Amalric Set)
INSERT INTO item_mods_pet (itemId, modId, value, petType)
VALUES
-- Amalric Slops
    (27304,160,-700, 8),-- Luopan - DMG: -700
-- Amalric Nails
    (27475,370,2,8);    -- Luopan - REGEN: 2

-------------------------------
-- UPDATE item_equipment errors
-------------------------------

-- Remove Rows if they exist
DELETE from item_equipment WHERE itemid = 23774; -- Missing SQL Row
DELETE from item_equipment WHERE itemid = 23777; -- Missing SQL Row
-- Insert updates
INSERT INTO item_equipment VALUES (23774,'bunzis_gloves',75,0,4,469,0,0,64,0,0,0);
INSERT INTO item_equipment VALUES (23777,'gletis_breeches',75,0,128,465,0,0,128,0,0,0);

-- Update item_equipment errors
UPDATE item_equipment SET MId = 464 WHERE itemid = 23783; -- Incorrect MId
UPDATE item_equipment SET name = 'bunzis_robe' WHERE itemid = 23767; -- Incorrect Name
UPDATE item_equipment SET name = 'founders_breastplate' WHERE itemid = 27910; -- Incorrect Name
UPDATE item_equipment SET name = 'odyssean_breastplate' WHERE itemid = 25716; -- Incorrect Name
UPDATE item_equipment SET name = 'eschite_breastplate' WHERE itemid = 26947; -- Incorrect Name

-------------------------------------
-- UPDATE item_equipment for CW Items
-------------------------------------

-- Create temporary table for item_equipment
CREATE TEMPORARY TABLE job_item_equipment (
    job_name VARCHAR(255),
    itemid INT,
    level INT,
    ilevel INT,
    jobs INT
);

-- Insert data into the temporary table for item_equipment
INSERT INTO job_item_equipment (job_name, itemid, level, ilevel, jobs)
VALUES
    ('Warrior(Sakpata Set)', 23757, 75, 0, 1),
    ('Warrior(Sakpata Set)', 23764, 75, 0, 1),
    ('Warrior(Sakpata Set)', 23771, 75, 0, 1),
    ('Warrior(Sakpata Set)', 23778, 75, 0, 1),
    ('Warrior(Sakpata Set)', 23785, 75, 0, 1),
    ('Monk(Naga Set)', 26793, 75, 0, 2),
    ('Monk(Naga Set)', 26949, 75, 0, 2),
    ('Monk(Naga Set)', 27099, 75, 0, 2),
    ('Monk(Naga Set)', 27284, 75, 0, 2),
    ('Monk(Naga Set)', 27459, 75, 0, 2),
    ('WhiteMage(Bunzi Set)', 23760, 75, 0, 4),
    ('WhiteMage(Bunzi Set)', 23767, 75, 0, 4), -- Mispelled bunzis_rob
--  ('WhiteMage(Bunzi Set)', 23774, 75, 0, 4), -- Missing SQL Row (MId = 469, slot = 64)
    ('WhiteMage(Bunzi Set)', 23781, 75, 0, 4),
    ('WhiteMage(Bunzi Set)', 23788, 75, 0, 4),
    ('BlackMage(Vanya Set)', 26797, 75, 0, 8),
    ('BlackMage(Vanya Set)', 26953, 75, 0, 8),
    ('BlackMage(Vanya Set)', 27103, 75, 0, 8),
    ('BlackMage(Vanya Set)', 27288, 75, 0, 8),
    ('BlackMage(Vanya Set)', 27463, 75, 0, 8),
    ('RedMage(Malignance Set)', 23732, 75, 0, 16),
    ('RedMage(Malignance Set)', 23733, 75, 0, 16),
    ('RedMage(Malignance Set)', 23734, 75, 0, 16),
    ('RedMage(Malignance Set)', 23735, 75, 0, 16),
    ('RedMage(Malignance Set)', 23736, 75, 0, 16),
    ('Thief(Adhemar Set)', 25613, 75, 0, 32),
    ('Thief(Adhemar Set)', 25686, 75, 0, 32),
    ('Thief(Adhemar Set)', 27117, 75, 0, 32),
    ('Thief(Adhemar Set)', 27302, 75, 0, 32),
    ('Thief(Adhemar Set)', 27473, 75, 0, 32),
    ('Paladin(Founder Set)', 27764, 75, 0, 64),
    ('Paladin(Founder Set)', 27910, 75, 0, 64), -- Name = found._breastplate
    ('Paladin(Founder Set)', 28049, 75, 0, 64),
    ('Paladin(Founder Set)', 28191, 75, 0, 64),
    ('Paladin(Founder Set)', 28330, 75, 0, 64),
    ('DarkKnight(Gleti Set)', 23756, 75, 0, 128),
    ('DarkKnight(Gleti Set)', 23763, 75, 0, 128),
    ('DarkKnight(Gleti Set)', 23770, 75, 0, 128),
--  ('DarkKnight(Gleti Set)', 23777, 75, 0, 128), -- Missing SQL Row (MId = 465, slot = 128)
    ('DarkKnight(Gleti Set)', 23784, 75, 0, 128),
    ('Beastmaster(Valorous Set)', 25641, 75, 0, 256),
    ('Beastmaster(Valorous Set)', 25717, 75, 0, 256),
    ('Beastmaster(Valorous Set)', 25841, 75, 0, 256),
    ('Beastmaster(Valorous Set)', 27139, 75, 0, 256),
    ('Beastmaster(Valorous Set)', 27495, 75, 0, 256),
    ('Bard(Pursuer Set)', 26795, 75, 0, 512),
    ('Bard(Pursuer Set)', 26951, 75, 0, 512),
    ('Bard(Pursuer Set)', 27101, 75, 0, 512),
    ('Bard(Pursuer Set)', 27286, 75, 0, 512),
    ('Bard(Pursuer Set)', 27461, 75, 0, 512),
    ('Ranger(Herculean Set)', 25642, 75, 0, 1024),
    ('Ranger(Herculean Set)', 25718, 75, 0, 1024),
    ('Ranger(Herculean Set)', 27140, 75, 0, 1024),
    ('Ranger(Herculean Set)', 25842, 75, 0, 1024),
    ('Ranger(Herculean Set)', 27496, 75, 0, 1024),
    ('Samurai(Ryuo Set)', 25611, 75, 0, 2048),
    ('Samurai(Ryuo Set)', 25684, 75, 0, 2048),
    ('Samurai(Ryuo Set)', 27115, 75, 0, 2048),
    ('Samurai(Ryuo Set)', 27300, 75, 0, 2048),
    ('Samurai(Ryuo Set)', 27471, 75, 0, 2048),
    ('Ninja(Mpaca Set)', 23758, 75, 0, 4096),
    ('Ninja(Mpaca Set)', 23765, 75, 0, 4096),
    ('Ninja(Mpaca Set)', 23772, 75, 0, 4096),
    ('Ninja(Mpaca Set)', 23779, 75, 0, 4096),
    ('Ninja(Mpaca Set)', 23786, 75, 0, 4096),
    ('Dragoon(Odyssean Set)', 25640, 75, 0, 8192),
    ('Dragoon(Odyssean Set)', 25716, 75, 0, 8192), -- Name = odyss._chestplate
    ('Dragoon(Odyssean Set)', 27138, 75, 0, 8192),
    ('Dragoon(Odyssean Set)', 25840, 75, 0, 8192),
    ('Dragoon(Odyssean Set)', 27494, 75, 0, 8192),
    ('Summoner(Chironic Set)', 25644, 75, 0, 16384),
    ('Summoner(Chironic Set)', 25720, 75, 0, 16384),
    ('Summoner(Chironic Set)', 27142, 75, 0, 16384),
    ('Summoner(Chironic Set)', 25844, 75, 0, 16384),
    ('Summoner(Chironic Set)', 27498, 75, 0, 16384),
    ('BlueMage(Agwu Set)', 23759, 75, 0, 32768),
    ('BlueMage(Agwu Set)', 23766, 75, 0, 32768),
    ('BlueMage(Agwu Set)', 23773, 75, 0, 32768),
    ('BlueMage(Agwu Set)', 23780, 75, 0, 32768),
    ('BlueMage(Agwu Set)', 23787, 75, 0, 32768),
    ('Corsair(Ikenga Set)', 23755, 75, 0, 65536),
    ('Corsair(Ikenga Set)', 23762, 75, 0, 65536),
    ('Corsair(Ikenga Set)', 23769, 75, 0, 65536),
    ('Corsair(Ikenga Set)', 23776, 75, 0, 65536),
    ('Corsair(Ikenga Set)', 23783, 75, 0, 65536), -- Incorrect, MId = 464
    ('Puppetmaster(Thurandaut Set)', 27784, 75, 0, 131072),
    ('Puppetmaster(Thurandaut Set)', 27924, 75, 0, 131072),
    ('Puppetmaster(Thurandaut Set)', 28064, 75, 0, 131072),
    ('Puppetmaster(Thurandaut Set)', 28204, 75, 0, 131072),
    ('Puppetmaster(Thurandaut Set)', 28344, 75, 0, 131072),
    ('Dancer(Rawhide Set)', 26794, 75, 0, 262144),
    ('Dancer(Rawhide Set)', 26950, 75, 0, 262144),
    ('Dancer(Rawhide Set)', 27100, 75, 0, 262144),
    ('Dancer(Rawhide Set)', 27285, 75, 0, 262144),
    ('Dancer(Rawhide Set)', 27460, 75, 0, 262144),
    ('Scholar(Merlinic Set)', 25643, 75, 0, 524288),
    ('Scholar(Merlinic Set)', 25719, 75, 0, 524288),
    ('Scholar(Merlinic Set)', 27141, 75, 0, 524288),
    ('Scholar(Merlinic Set)', 25843, 75, 0, 524288),
    ('Scholar(Merlinic Set)', 27497, 75, 0, 524288),
    ('Geomancer(Amalric Set)', 25615, 75, 0, 1048576),
    ('Geomancer(Amalric Set)', 25688, 75, 0, 1048576),
    ('Geomancer(Amalric Set)', 27119, 75, 0, 1048576),
    ('Geomancer(Amalric Set)', 27304, 75, 0, 1048576),
    ('Geomancer(Amalric Set)', 27475, 75, 0, 1048576),
    ('RuneFencer(Eschite Set)', 26791, 75, 0, 2097152),
    ('RuneFencer(Eschite Set)', 26947, 75, 0, 2097152), -- Name = eschite_breast.
    ('RuneFencer(Eschite Set)', 27097, 75, 0, 2097152),
    ('RuneFencer(Eschite Set)', 27282, 75, 0, 2097152),
    ('RuneFencer(Eschite Set)', 27457, 75, 0, 2097152);

-- Perform the update on item_equipment
UPDATE item_equipment
SET
    level = (SELECT level FROM job_item_equipment WHERE item_equipment.itemid = job_item_equipment.itemid),
    ilevel = (SELECT ilevel FROM job_item_equipment WHERE item_equipment.itemid = job_item_equipment.itemid),
    jobs = (SELECT jobs FROM job_item_equipment WHERE item_equipment.itemid = job_item_equipment.itemid)
WHERE itemid IN (
    SELECT itemid FROM job_item_equipment
);

-- Delete the temporary table for item_equipment
DROP TABLE job_item_equipment;

---------------------------------
-- UPDATE item_basic for CW Items
---------------------------------

-- Create a temporary table
CREATE TEMPORARY TABLE job_itemids (
    job_name VARCHAR(255),
    itemid INT
);

-- Insert data into the temporary table
INSERT INTO job_itemids (job_name, itemid)
VALUES
    ('Warrior(Sakpata Set)', 23757),
    ('Warrior(Sakpata Set)', 23764),
    ('Warrior(Sakpata Set)', 23771),
    ('Warrior(Sakpata Set)', 23778),
    ('Warrior(Sakpata Set)', 23785),
    ('Monk(Naga Set)', 26793),
    ('Monk(Naga Set)', 26949),
    ('Monk(Naga Set)', 27099),
    ('Monk(Naga Set)', 27284),
    ('Monk(Naga Set)', 27459),
    ('WhiteMage(Bunzi Set)', 23760),
    ('WhiteMage(Bunzi Set)', 23767),
    ('WhiteMage(Bunzi Set)', 23774),
    ('WhiteMage(Bunzi Set)', 23781),
    ('WhiteMage(Bunzi Set)', 23788),
    ('BlackMage(Vanya Set)', 26797),
    ('BlackMage(Vanya Set)', 26953),
    ('BlackMage(Vanya Set)', 27103),
    ('BlackMage(Vanya Set)', 27288),
    ('BlackMage(Vanya Set)', 27463),
    ('RedMage(Malignance Set)', 23732),
    ('RedMage(Malignance Set)', 23733),
    ('RedMage(Malignance Set)', 23734),
    ('RedMage(Malignance Set)', 23735),
    ('RedMage(Malignance Set)', 23736),
    ('Thief(Adhemar Set)', 25613),
    ('Thief(Adhemar Set)', 25686),
    ('Thief(Adhemar Set)', 27117),
    ('Thief(Adhemar Set)', 27302),
    ('Thief(Adhemar Set)', 27473),
    ('Paladin(Founder Set)', 27764),
    ('Paladin(Founder Set)', 27910),
    ('Paladin(Founder Set)', 28049),
    ('Paladin(Founder Set)', 28191),
    ('Paladin(Founder Set)', 28330),
    ('DarkKnight(Gleti Set)', 23756),
    ('DarkKnight(Gleti Set)', 23763),
    ('DarkKnight(Gleti Set)', 23770),
    ('DarkKnight(Gleti Set)', 23777),
    ('DarkKnight(Gleti Set)', 23784),
    ('Beastmaster(Valorous Set)', 25641),
    ('Beastmaster(Valorous Set)', 25717),
    ('Beastmaster(Valorous Set)', 25841),
    ('Beastmaster(Valorous Set)', 27139),
    ('Beastmaster(Valorous Set)', 27495),
    ('Bard(Pursuer Set)', 26795),
    ('Bard(Pursuer Set)', 26951),
    ('Bard(Pursuer Set)', 27101),
    ('Bard(Pursuer Set)', 27286),
    ('Bard(Pursuer Set)', 27461),
    ('Ranger(Herculean Set)', 25642),
    ('Ranger(Herculean Set)', 25718),
    ('Ranger(Herculean Set)', 27140),
    ('Ranger(Herculean Set)', 25842),
    ('Ranger(Herculean Set)', 27496),
    ('Summoner(Chironic Set)', 25644),
    ('Summoner(Chironic Set)', 25720),
    ('Summoner(Chironic Set)', 27142),
    ('Summoner(Chironic Set)', 25844),
    ('Summoner(Chironic Set)', 27498),
    ('Samurai(Ryuo Set)', 25611),
    ('Samurai(Ryuo Set)', 25684),
    ('Samurai(Ryuo Set)', 27115),
    ('Samurai(Ryuo Set)', 27300),
    ('Samurai(Ryuo Set)', 27471),
    ('Ninja(Mpaca Set)', 23758),
    ('Ninja(Mpaca Set)', 23765),
    ('Ninja(Mpaca Set)', 23772),
    ('Ninja(Mpaca Set)', 23779),
    ('Ninja(Mpaca Set)', 23786),
    ('Dragoon(Odyssean Set)', 25640),
    ('Dragoon(Odyssean Set)', 25716),
    ('Dragoon(Odyssean Set)', 27138),
    ('Dragoon(Odyssean Set)', 25840),
    ('Dragoon(Odyssean Set)', 27494),
    ('BlueMage(Agwu Set)', 23759),
    ('BlueMage(Agwu Set)', 23766),
    ('BlueMage(Agwu Set)', 23773),
    ('BlueMage(Agwu Set)', 23780),
    ('BlueMage(Agwu Set)', 23787),
    ('Corsair(Ikenga Set)', 23755),
    ('Corsair(Ikenga Set)', 23762),
    ('Corsair(Ikenga Set)', 23769),
    ('Corsair(Ikenga Set)', 23776),
    ('Corsair(Ikenga Set)', 23783),
    ('Puppetmaster(Thurandaut Set)', 27784),
    ('Puppetmaster(Thurandaut Set)', 27924),
    ('Puppetmaster(Thurandaut Set)', 28064),
    ('Puppetmaster(Thurandaut Set)', 28204),
    ('Puppetmaster(Thurandaut Set)', 28344),
    ('Dancer(Rawhide Set)', 26794),
    ('Dancer(Rawhide Set)', 26950),
    ('Dancer(Rawhide Set)', 27100),
    ('Dancer(Rawhide Set)', 27285),
    ('Dancer(Rawhide Set)', 27460),
    ('Scholar(Merlinic Set)', 25643),
    ('Scholar(Merlinic Set)', 25719),
    ('Scholar(Merlinic Set)', 27141),
    ('Scholar(Merlinic Set)', 25843),
    ('Scholar(Merlinic Set)', 27497),
    ('Geomancer(Amalric Set)', 25615),
    ('Geomancer(Amalric Set)', 25688),
    ('Geomancer(Amalric Set)', 27119),
    ('Geomancer(Amalric Set)', 27304),
    ('Geomancer(Amalric Set)', 27475),
    ('RuneFencer(Eschite Set)', 26791),
    ('RuneFencer(Eschite Set)', 26947),
    ('RuneFencer(Eschite Set)', 27097),
    ('RuneFencer(Eschite Set)', 27282),
    ('RuneFencer(Eschite Set)', 27457);

-- Perform item_basic updates
UPDATE item_basic
SET
    flags = 63552, -- (NoAuction, CanEquip, NoSale, NoDelivery, EX, Rare)
    aH = 0,
    NoSale = 1,
    BaseSell = 0
WHERE itemid IN (
    SELECT itemid FROM job_itemids
);

-- Drop Temp Table
DROP TABLE job_itemids;
