-------------------------
-- Jug Pet Custom Changes 
-------------------------
-- Procedure:
--- Update the jug pet level (item_equipment.sql) for out of era jugs.

--- Update the jug pet minimum level, as it takes precedent over the natural 1-2 levels below the master for Call Beast.
---- Leaving time and max level fields here just in case. Why not? Max level doesn't need to be touched as a jug pet cant go past the BST level.

--- Check if the jug synth recipe works. If not add to recipes_added.sql and PR to LSB.

--- Update the .dat.

--- Test it.

-- note that mob_skill_list for the pet pool is _NOT_ a real list of mappings, but a bit shift of the ready id for the bst player
SET @BRINY_BROTH = 17904;
SET @DAPPER_MAC  = 66;
UPDATE `item_equipment` SET level = 75 WHERE itemId = @BRINY_BROTH;
UPDATE `pet_list`       SET minLevel = 69, maxLevel = 99, time = 7200 WHERE petid = @DAPPER_MAC;


SET @LUCKY_CARROT_BROTH = 17878;
SET @LUCKY_LULUSH       = 51;
UPDATE `item_equipment` SET level = 75 WHERE itemId = @LUCKY_CARROT_BROTH;
UPDATE `pet_list`       SET minLevel = 69, maxLevel = 99, time = 7200 WHERE petid = @LUCKY_LULUSH;



-- Fix sandpit and sandblast to use mobskills
update abilities set name = 'sand_blast' where abilityId = 714;
update abilities set name = 'sand_pit' where abilityId = 715;

-------------------------
-- Raise certain HQ pets to 75
-------------------------
UPDATE pet_list SET maxLevel = 75 WHERE name IN (
  'LullabyMelodia',  -- Sheep
  'KeenearedSteffi', -- Rabbit
  'FlowerpotBen',    -- Mandragora
  'SaberSiravarde',  -- Tiger
  'ColdbloodComo',   -- Lizard
  'ShellbusterOrob', -- Fly
  'FunguarFamiliar'  -- Funguar (NQ since no HQ)
);

-- Add Dirty Sanchez grasshopper as a Beastmaster pet
INSERT INTO `pet_list` (`petid`, `name`, `poolid`, `minLevel`, `maxLevel`, `time`, `damageType`) VALUES ('100', 'Dirty Sanchez', '10000', '75', '85', '3600', '2');
INSERT INTO `mob_pools` (`poolid`, `name`, `packet_name`, `familyid`, `modelid`, `mJob`, `sJob`, `cmbSkill`, `cmbDelay`, `cmbDmgMult`, `behavior`, `aggro`, `true_detection`, `links`, `mobType`, `immunity`, `name_prefix`, `flag`, `entityFlags`, `animationsub`, `hasSpellScript`, `spellList`, `namevis`, `roamflag`, `skill_list_id`, `resist_id`) VALUES (10000, 'Pet_Dirty_Sanchez', 'Pet_Dirty_Sanchez', 339, 0x0000f10900000000000000000000000000000000, 1, 1, 7, 240, 100, 0, 0, 0, 0, 8, 0, 0, 449, 129, 0, 0, 0, 0, 0, 10000, 339);
UPDATE `item_basic` SET `name`='jug_of_fun_dip', `sortname`='fun_dip' WHERE `itemid`=17917;
UPDATE `item_equipment` SET `name`='fun_dip', `level`='75' WHERE `itemId`=17917;
UPDATE `item_weapon` SET `name`='fun_dip', `subskill`='100' WHERE `itemId`=17917;
DELETE FROM `synth_recipes` WHERE `ID`=74534;
INSERT INTO `synth_recipes` VALUES (74534, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 4101, 4243, 4017, 4017, 4372, 5965, 0, 0, 0, 0, 17917, 17917, 17917, 17917, 1, 1, 1, 1, 'Fun Dip');
INSERT INTO `mob_skill_lists` (`skill_list_name`, `skill_list_id`, `mob_skill_id`) VALUES ('Jug_DSanchez', '10000', '761');
INSERT INTO `mob_skill_lists` (`skill_list_name`, `skill_list_id`, `mob_skill_id`) VALUES ('Jug_DSanchez', '10000', '762');
UPDATE `abilities` SET `recastTime`='1', `message2`='0' WHERE `abilityId`=761;
UPDATE `abilities` SET `animation`='0' WHERE `abilityId`=762;
UPDATE `mob_skills` SET `mob_anim_id`='2168', `primary_sc`='4' WHERE `mob_skill_id`=2946;
UPDATE `mob_skills` SET `mob_anim_id`='2169', `primary_sc`='10', `secondary_sc`='6' WHERE `mob_skill_id`=2947;