-- Adjusts the range of all blue magic spells until something is done in core to lengthen ranges based on model size
-- TODO remove this when the above is done

-- shorter range spells go from 34 to 60, etc
update spell_list set spell_range = spell_range + 26 where skill = 43 and spell_range > 0 and spell_range < 200;
-- longer range spells go from 204 to 220
update spell_list set spell_range = spell_range + 16 where skill = 43 and spell_range > 200;

-- adjust levels of spells to allow at 75 blue mage
-- this makes them learnable (some spells just past 75 are learnable as well) AND usable at 75
-- some may not be usable, but they will still provide stats/traits if set
update spell_list set jobs = 0x0000000000000000000000000000004b000000000000 where name in (
    'acrid_stream',         -- Double Attack / Triple Attack - https://www.bg-wiki.com/ffxi/Acrid_Stream
    'demoralizing_roar',    -- Double Attack / Triple Attack - https://www.bg-wiki.com/ffxi/Demoralizing_Roar
    'empty_thrash',         -- Double Attack / Triple Attack - https://www.bg-wiki.com/ffxi/Empty_Thrash
    'heavy_strike',         -- Double Attack / Triple Attack - https://www.bg-wiki.com/ffxi/Heavy_Strike
    'animating_wail',       -- Dual Wield - https://www.bg-wiki.com/ffxi/Animating_Wail
    'blazing_bound',        -- Dual Wield - https://www.bg-wiki.com/ffxi/Blazing_Bound
    'quad_continuum',       -- Dual Wield - https://www.bg-wiki.com/ffxi/Quad._Continuum
    'barbed_crescent',      -- Dual Wield - https://www.bg-wiki.com/ffxi/Barbed_Crescent
    'battery_charge',       -- no traits, just a great spell - https://www.bg-wiki.com/ffxi/Battery_Charge
    'plenilune_embrace',    -- no traits, just a great spell - https://www.bg-wiki.com/ffxi/Plenilune_Embrace
    'osmosis',              -- Magic Defense Bonus - https://www.bg-wiki.com/ffxi/Osmosis
    'occultation',          -- Evasion Bonus - https://www.bg-wiki.com/ffxi/Occultation
    'barrier_tusk',         -- Max HP Boost - https://www.bg-wiki.com/ffxi/Barrier_Tusk
    'magic_barrier',        -- Max MP Boost - https://www.bg-wiki.com/ffxi/Magic_Barrier
    'orcish_counterstance', -- Counter - https://www.bg-wiki.com/ffxi/O._Counterstance
    'harden_shell',         -- None - https://www.bg-wiki.com/ffxi/Harden_Shell
    'pyric_bulwark'         -- None - https://www.bg-wiki.com/ffxi/Pyric_Bulwark
);

-- these spells can only be learned in lvl capped zones, so to facilitate cw/wew learning them, we will lower the required lvl but not change the DATs
-- take care as addons like "blusets" can set the spells even if the DAT doesn't allow it. Take care not to allow traits below lvl 75
update spell_list set jobs = 0x00000000000000000000000000000032000000000000 where name in (
    'empty_thrash',         -- Double Attack / Triple Attack
    'quad_continuum',       -- Dual Wield
    'occultation'           -- Evasion Bonus - https://www.bg-wiki.com/ffxi/Occultation
);

-- Give blue mage "Unbridled Learning" ability at level 75
UPDATE `abilities` SET level = "75" WHERE abilityId = "298"; -- Unbridled Learning

-- Give blue mage "Assimilation" merit +2 points per tier
update merits set value = 2 where name = "assimilation";

-- Allow Blue Magic Spells to be allowed to use with Diffusion (https://www.bg-wiki.com/ffxi/Diffusion)
UPDATE `spell_list` SET AOE = "6" WHERE spellid = "685"; -- Barrier Tusk
UPDATE `spell_list` SET AOE = "6" WHERE spellid = "696"; -- Orcish Counterstance
UPDATE `spell_list` SET AOE = "6" WHERE spellid = "737"; -- Harden Shell
UPDATE `spell_list` SET AOE = "6" WHERE spellid = "741"; -- Pyric Bulwark

-- Correct Mob Skill Animations for Adoulin Mobs (specifically higher level BLU Spell Mobs)
-- Velkk
UPDATE `mob_skills` SET mob_anim_id = "2155", mob_skill_aoe = "0" WHERE mob_skill_id = "2988"; -- Glutinous Dart
UPDATE `mob_skills` SET mob_anim_id = "2156", knockback = "1" WHERE mob_skill_id = "2989"; -- Death Spin
UPDATE `mob_skills` SET mob_anim_id = "2157", mob_skill_aoe = "0" WHERE mob_skill_id = "2990"; -- Velkkan Pygmachia
UPDATE `mob_skills` SET mob_anim_id = "2158", mob_skill_aoe = "0" WHERE mob_skill_id = "2991"; -- Saurian Slide

-- Adds missing mob_skills for Blue Magic spells
INSERT INTO `mob_skill_lists` VALUES ('Hippogryph', 140, 580);
INSERT INTO `mob_skill_lists` VALUES ('Hippogryph', 141, 580);

-- Add Out of Era BLU Spells
-- Glutinous Dart
INSERT INTO `spell_list` VALUES (706, 'glutinous_dart', 0x0000000000000000000000000000004b0000000000, 3, 0, 0, 0, 4, 43, 16, 1000, 6000, 2, 0, 913, 2000, 0, 0, 1, 0, 0, 0, 215, 'ABYSSEA'); -- Spell: Glutinous Dart
INSERT INTO `blue_spell_list` VALUES (706, 2988, 2, 15, 1, 12, 0, 0); -- Glutinous Dart

-- Searing Tempest
INSERT INTO `mob_skills` VALUES (2735, 1885, 'searing_tempest', 1, 0.0, 7.0, 2000, 1500, 4, 0, 0, 0, 0, 0, 0); -- Mobskill: Searing Tempest
INSERT INTO `spell_list` VALUES (719, 'searing_tempest', 0x0000000000000000000000000000004b0000000000, 3, 0, 1, 0, 4, 43, 116, 5000, 60000, 2, 0, 996, 6000, 1, 0, 1, 0, 0, 0, 126, 'ABYSSEA'); -- Spell: Searing Tempest
INSERT INTO `blue_traits` VALUES (50, 1, 3, 23, 20); -- Physical Attack Bonus (8)
INSERT INTO `blue_spell_list` VALUES (719, 2735, 8, 50, 1, 0, 0, 0); -- Searing Tempest
INSERT INTO `blue_spell_mods` VALUES (719, 8, 8); -- STR +8
INSERT INTO `blue_spell_mods` VALUES (719, 5, 30); -- MP +30

-- Spectral Floe
INSERT INTO `mob_skills` VALUES (2737, 1887, 'spectral_floe', 1, 0.0, 7.0, 2000, 1500, 4, 0, 0, 0, 0, 0, 0); -- Mobskill: Spectral Floe
INSERT INTO `spell_list` VALUES (720, 'spectral_floe', 0x0000000000000000000000000000004b0000000000, 3, 0, 2, 0, 4, 43, 116, 5000, 60000, 2, 0, 997, 6000, 1, 0, 1, 0, 0, 0, 126, 'ABYSSEA'); -- Spell: Spectral Floe
INSERT INTO `blue_traits` VALUES (51, 1, 5, 28, 20); -- Magic Attack Bonus (8)
INSERT INTO `blue_spell_list` VALUES (720, 2737, 8, 51, 1, 0, 0, 0); -- Spectral Floe
INSERT INTO `blue_spell_mods` VALUES (720, 12, 8); -- INT +8
INSERT INTO `blue_spell_mods` VALUES (720, 5, 30); -- MP +30

-- Anvil Lightning
UPDATE `mob_skills` SET mob_skill_aoe = "1" WHERE mob_skill_id = "2739"; -- Anvil Lightning
INSERT INTO `spell_list` VALUES (721, 'anvil_lightning', 0x0000000000000000000000000000004b0000000000, 3, 0, 5, 0, 4, 43, 116, 5000, 60000, 2, 0, 998, 6000, 1, 0, 1, 0, 0, 0, 126, 'ABYSSEA'); -- Spell: Anvil Lightning
INSERT INTO `blue_traits` VALUES (52, 1, 1, 25, 20); -- Physical Accuracy Bonus (8)
INSERT INTO `blue_spell_list` VALUES (721, 2739, 8, 52, 1, 0, 0, 0); -- Anvil Lightning
INSERT INTO `blue_spell_mods` VALUES (721, 9, 8); -- DEX +8
INSERT INTO `blue_spell_mods` VALUES (721, 5, 30); -- MP +30

-- Entomb
INSERT INTO `mob_skills` VALUES (2741, 1891, 'entomb', 1, 0.0, 7.0, 2000, 1500, 4, 0, 0, 0, 0, 0, 0); -- Mobskill: Entomb
INSERT INTO `spell_list` VALUES (722, 'entomb', 0x0000000000000000000000000000004b0000000000, 3, 0, 4, 0, 4, 43, 116, 5000, 60000, 2, 0, 999, 6000, 1, 0, 1, 0, 0, 0, 126, 'ABYSSEA'); -- Spell: Entomb
INSERT INTO `blue_traits` VALUES (53, 1, 4, 1, 20); -- Defense Bonus (8)
INSERT INTO `blue_spell_list` VALUES (722, 2741, 8, 53, 1, 0, 0, 0); -- Entomb
INSERT INTO `blue_spell_mods` VALUES (722, 10, 8); -- VIT +8
INSERT INTO `blue_spell_mods` VALUES (722, 5, 30); -- MP +30

-- Blinding Fulgor
INSERT INTO `mob_skills` VALUES (2736, 1886, 'blinding_fulgor', 1, 0.0, 7.0, 2000, 1500, 4, 0, 0, 0, 0, 0, 0); -- Mobskill: Blinding Fulgor
INSERT INTO `spell_list` VALUES (725, 'blinding_fulgor', 0x0000000000000000000000000000004b0000000000, 3, 0, 7, 0, 4, 43, 116, 5000, 60000, 2, 0, 1006, 6000, 1, 0, 1, 0, 0, 0, 126, 'ABYSSEA'); -- Spell: Blinding Fulgor
INSERT INTO `blue_traits` VALUES (54, 1, 126, 31, 20); -- Magic Evasion Bonus (8)
INSERT INTO `blue_spell_list` VALUES (725, 2736, 8, 54, 1, 0, 0, 0); -- Blinding Fulgor
INSERT INTO `blue_spell_mods` VALUES (725, 8, 4); -- STR +4
INSERT INTO `blue_spell_mods` VALUES (725, 9, 4); -- DEX +4
INSERT INTO `blue_spell_mods` VALUES (725, 11, 4); -- AGI +4
INSERT INTO `blue_spell_mods` VALUES (725, 2, 40); -- HP +40

-- Scouring Spate
INSERT INTO `mob_skills` VALUES (2738, 1888, 'scouring_spate', 1, 0.0, 7.0, 2000, 1500, 4, 0, 0, 0, 0, 0, 0); -- Mobskill: Scouring Spate
INSERT INTO `spell_list` VALUES (726, 'scouring_spate', 0x0000000000000000000000000000004b0000000000, 3, 0, 6, 0, 4, 43, 116, 5000, 60000, 2, 0, 1007, 6000, 1, 0, 1, 0, 0, 0, 126, 'ABYSSEA'); -- Spell: Scouring Spate
INSERT INTO `blue_traits` VALUES (55, 1, 6, 29, 20); -- Magic Defense Bonus (8)
INSERT INTO `blue_spell_list` VALUES (726, 2738, 8, 55, 1, 0, 0, 0); -- Scouring Spate
INSERT INTO `blue_spell_mods` VALUES (726, 13, 8); -- MND +8
INSERT INTO `blue_spell_mods` VALUES (726, 5, 30); -- MP +30

-- Silent Storm
UPDATE `mob_skills` SET mob_skill_aoe = "1" WHERE mob_skill_id = "2740"; -- Silent Storm
INSERT INTO `spell_list` VALUES (727, 'silent_storm', 0x0000000000000000000000000000004b0000000000, 3, 0, 3, 0, 4, 43, 116, 5000, 60000, 2, 0, 1008, 6000, 1, 0, 1, 0, 0, 0, 126, 'ABYSSEA'); -- Spell: Silent Storm
INSERT INTO `blue_traits` VALUES (56, 1, 2, 68, 20); -- Evasion Bonus (8)
INSERT INTO `blue_spell_list` VALUES (727, 2740, 8, 56, 1, 0, 0, 0); -- Silent Storm
INSERT INTO `blue_spell_mods` VALUES (727, 11, 8); -- AGI +8
INSERT INTO `blue_spell_mods` VALUES (727, 5, 30); -- MP +30

-- Tenebral Crush
INSERT INTO `mob_skills` VALUES (2742, 1892, 'tenebral_crush', 1, 0.0, 7.0, 2000, 1500, 4, 0, 0, 0, 0, 0, 0); -- Mobskill: Tenebral Crush
INSERT INTO `spell_list` VALUES (728, 'tenebral_crush', 0x0000000000000000000000000000004b0000000000, 3, 0, 8, 0, 4, 43, 116, 5000, 60000, 2, 0, 1009, 6000, 1, 0, 1, 0, 0, 0, 126, 'ABYSSEA'); -- Spell: Tenebral Crush
INSERT INTO `blue_traits` VALUES (57, 1, 125, 30, 20); -- Magic Accuracy Bonus (8)
INSERT INTO `blue_spell_list` VALUES (728, 2742, 8, 57, 1, 0, 0, 0); -- Tenebral Crush
INSERT INTO `blue_spell_mods` VALUES (728, 10, 4); -- VIT +4
INSERT INTO `blue_spell_mods` VALUES (728, 12, 4); -- INT +4
INSERT INTO `blue_spell_mods` VALUES (728, 13, 4); -- MND +4
INSERT INTO `blue_spell_mods` VALUES (728, 5, 30); -- MP +30

-- Carcharian Verve
INSERT INTO `spell_list` VALUES (745, 'carcharian_verve', 0x0000000000000000000000000000004b0000000000, 3, 0, 6, 0, 1, 43, 52, 3000, 30000, 230, 0, 916, 4000, 6, 0, 1, 0, 0, 16, 0, 'ABYSSEA'); -- Spell: Carcharian Verve