CREATE DEFINER=`root`@`localhost` PROCEDURE `migrate_wings_char`(
	IN `new_accid` INT,
	IN `old_charid` INT,
	IN `new_charid` INT,
	IN `new_name` CHAR(50)
)
LANGUAGE SQL
NOT DETERMINISTIC
CONTAINS SQL
SQL SECURITY DEFINER
COMMENT ''
BEGIN
    SET @ACCID     = new_accid;
    SET @OLDCHARID = old_charid;
    SET @NEWCHARID = new_charid;
    SET @CHARNAME  = new_name;

    REPLACE INTO tpzdb.CHARS (`CHARID`,`EMINENCE`,`PLAYTIME`,`ZONES`,`TITLES`,`WEAPONSKILLS`,`ABILITIES`,`SET_BLUE_SPELLS`,`KEYITEMS`,`QUESTS`,`UNLOCKED_WEAPONS`,`GMLEVEL`,`MENTOR`,`LASTUPDATE`,`TIMECREATED`,`MOGHANCEMENT`,`LANGUAGES`,`ISSTYLELOCKED`,`CAMPAIGN_ALLEGIANCE`,`CAMPAIGN`,`ASSAULT`,`POS_ROT`,`POS_PREVZONE`,`POS_ZONE`,`NATION`,`CHARNAME`,`ACCID`,`POS_X`,`POS_Y`,`MISSIONS`,`HOME_Z`,`HOME_Y`,`HOME_X`,`HOME_ROT`,`HOME_ZONE`,`BOUNDARY`,`MOGHOUSE`,`POS_Z`)
     SELECT @NEWCHARID as `CHARID`,`EMINENCE`,`PLAYTIME`,`ZONES`,`TITLES`,`WEAPONSKILLS`,`ABILITIES`,`SET_BLUE_SPELLS`,`KEYITEMS`,`QUESTS`,`UNLOCKED_WEAPONS`,`GMLEVEL`,`MENTOR`,`LASTUPDATE`,`TIMECREATED`,`MOGHANCEMENT`,`LANGUAGES`,`ISSTYLELOCKED`,`CAMPAIGN_ALLEGIANCE`,`CAMPAIGN`,`ASSAULT`,`POS_ROT`,`POS_PREVZONE`,`POS_ZONE`,`NATION`,@CHARNAME as `CHARNAME`,@ACCID as `ACCID`,`POS_X`,`POS_Y`,`MISSIONS`,`HOME_Z`,`HOME_Y`,`HOME_X`,`HOME_ROT`,`HOME_ZONE`,`BOUNDARY`,`MOGHOUSE`,`POS_Z`
      FROM ffxiwings.CHARS WHERE charid = @OLDCHARID;
    -- CHAR_BLACKLIST is not a valid table, as it has no charid column
        REPLACE INTO tpzdb.CHAR_EFFECTS (`CHARID`,`TIMESTAMP`,`FLAGS`,`TIER`,`SUBPOWER`,`SUBID`,`DURATION`,`TICK`,`POWER`,`ICON`,`EFFECTID`)
     SELECT @NEWCHARID as `CHARID`,`TIMESTAMP`,`FLAGS`,`TIER`,`SUBPOWER`,`SUBID`,`DURATION`,`TICK`,`POWER`,`ICON`,`EFFECTID`
      FROM ffxiwings.CHAR_EFFECTS WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_EQUIP (`CHARID`,`CONTAINERID`,`EQUIPSLOTID`,`SLOTID`)
     SELECT @NEWCHARID as `CHARID`,`CONTAINERID`,`EQUIPSLOTID`,`SLOTID`
      FROM ffxiwings.CHAR_EQUIP WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_EXP (`CHARID`,`NIN`,`DRG`,`SMN`,`BLU`,`COR`,`PUP`,`DNC`,`SCH`,`GEO`,`RUN`,`MERITS`,`LIMITS`,`SAM`,`RNG`,`MODE`,`WAR`,`MNK`,`WHM`,`BLM`,`RDM`,`BRD`,`BST`,`DRK`,`PLD`,`THF`)
     SELECT @NEWCHARID as `CHARID`,`NIN`,`DRG`,`SMN`,`BLU`,`COR`,`PUP`,`DNC`,`SCH`,`GEO`,`RUN`,`MERITS`,`LIMITS`,`SAM`,`RNG`,`MODE`,`WAR`,`MNK`,`WHM`,`BLM`,`RDM`,`BRD`,`BST`,`DRK`,`PLD`,`THF`
      FROM ffxiwings.CHAR_EXP WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_INVENTORY (`CHARID`,`EXTRA`,`SIGNATURE`,`BAZAAR`,`QUANTITY`,`ITEMID`,`SLOT`,`LOCATION`)
     SELECT @NEWCHARID as `CHARID`,`EXTRA`,`SIGNATURE`,`BAZAAR`,`QUANTITY`,`ITEMID`,`SLOT`,`LOCATION`
      FROM ffxiwings.CHAR_INVENTORY WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_JOBS (`CHARID`,`SAM`,`NIN`,`DRG`,`SMN`,`BLU`,`COR`,`PUP`,`DNC`,`SCH`,`GEO`,`RUN`,`RNG`,`BRD`,`BST`,`UNLOCKED`,`GENKAI`,`WAR`,`MNK`,`WHM`,`BLM`,`RDM`,`THF`,`PLD`,`DRK`)
     SELECT @NEWCHARID as `CHARID`,`SAM`,`NIN`,`DRG`,`SMN`,`BLU`,`COR`,`PUP`,`DNC`,`SCH`,`GEO`,`RUN`,`RNG`,`BRD`,`BST`,`UNLOCKED`,`GENKAI`,`WAR`,`MNK`,`WHM`,`BLM`,`RDM`,`THF`,`PLD`,`DRK`  
      FROM ffxiwings.CHAR_JOBS WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_LOOK (`CHARID`,`LEGS`,`FEET`,`MAIN`,`SUB`,`RANGED`,`HANDS`,`BODY`,`HEAD`,`SIZE`,`RACE`,`FACE`)
     SELECT @NEWCHARID as `CHARID`,`LEGS`,`FEET`,`MAIN`,`SUB`,`RANGED`,`HANDS`,`BODY`,`HEAD`,`SIZE`,`RACE`,`FACE`
      FROM ffxiwings.CHAR_LOOK WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_MERIT (`CHARID`,`UPGRADES`,`MERITID`)
     SELECT @NEWCHARID as `CHARID`,`UPGRADES`,`MERITID`
      FROM ffxiwings.CHAR_MERIT WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_PET (`CHARID`,`CHOCOBOID`,`ADVENTURINGFELLOWID`,`EQUIPPED_ATTACHMENTS`,`UNLOCKED_ATTACHMENTS`,`AUTOMATONID`,`WYVERNID`)
     SELECT @NEWCHARID as `CHARID`,`CHOCOBOID`,`ADVENTURINGFELLOWID`,`EQUIPPED_ATTACHMENTS`,`UNLOCKED_ATTACHMENTS`,`AUTOMATONID`,`WYVERNID`
      FROM ffxiwings.CHAR_PET WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_POINTS (`CHARID`,`MWEYA_PLASM`,`CRUOR`,`RESISTANCE_CREDIT`,`DOMINION_NOTE`,`FIFTH_ECHELON_TROPHY`,`FOURTH_ECHELON_TROPHY`,`THIRD_ECHELON_TROPHY`,`SECOND_ECHELON_TROPHY`,`FIRST_ECHELON_TROPHY`,`CAVE_POINTS`,`ID_TAGS`,`PULCHRIDOPT_WING`,`LEBONDOPT_WING`,`ILRUSI_ASSAULT_POINT`,`NYZUL_ISLE_ASSAULT_POINT`,`ZENI_POINT`,`JETTON`,`THERION_ICHOR`,`ALLIED_NOTES`,`AMAN_VOUCHERS`,`LOGIN_POINTS`,`BAYLD`,`KINETIC_UNIT`,`OBSIDIAN_FRAGMENT`,`OP_CREDITS`,`TRAVERSER_STONES`,`VOIDSTONES`,`RECLAMATION_MARKS`,`UNITY_ACCOLADES`,`FIRE_CRYSTALS`,`ICE_CRYSTALS`,`WIND_CRYSTALS`,`EARTH_CRYSTALS`,`LIGHTNING_CRYSTALS`,`WATER_CRYSTALS`,`LIGHT_CRYSTALS`,`DARK_CRYSTALS`,`REMS_CH10`,`REMS_CH9`,`REMS_CH8`,`KUPOFRIED_CORUNDUMS`,`IMPRIMATURS`,`PHEROMONE_SACKS`,`REMS_CH1`,`REMS_CH2`,`REMS_CH3`,`REMS_CH4`,`REMS_CH5`,`REMS_CH6`,`REMS_CH7`,`DEEDS`,`GUILD_SMITHING`,`GUILD_GOLDSMITHING`,`GUILD_WEAVING`,`GUILD_LEATHERCRAFT`,`GUILD_BONECRAFT`,`GUILD_ALCHEMY`,`GUILD_COOKING`,`CINDER`,`FIRE_FEWELL`,`ICE_FEWELL`,`GUILD_WOODWORKING`,`GUILD_FISHING`,`SCYLD`,`SANDORIA_CP`,`BASTOK_CP`,`WINDURST_CP`,`BEASTMAN_SEAL`,`KINDRED_SEAL`,`KINDRED_CREST`,`HIGH_KINDRED_CREST`,`SACRED_KINDRED_CREST`,`ANCIENT_BEASTCOIN`,`VALOR_POINT`,`WIND_FEWELL`,`EARTH_FEWELL`,`LIGHTNING_FEWELL`,`MOBLIN_MARBLE`,`INFAMY`,`PRESTIGE`,`LEGION_POINT`,`SPARK_OF_EMINENCE`,`SHINING_STAR`,`IMPERIAL_STANDING`,`LEUJAOAM_ASSAULT_POINT`,`MAMOOL_ASSAULT_POINT`,`LEBROS_ASSAULT_POINT`,`PERIQIA_ASSAULT_POINT`,`PHANTOM_WORM`,`MORION_WORM`,`WATER_FEWELL`,`LIGHT_FEWELL`,`DARK_FEWELL`,`BALLISTA_POINT`,`FELLOW_POINT`,`DAILY_TALLY`,`CHOCOBUCK_SANDORIA`,`CHOCOBUCK_BASTOK`,`CHOCOBUCK_WINDURST`,`RESEARCH_MARK`,`TUNNEL_WORM`)
     SELECT @NEWCHARID as `CHARID`,`MWEYA_PLASM`,`CRUOR`,`RESISTANCE_CREDIT`,`DOMINION_NOTE`,`FIFTH_ECHELON_TROPHY`,`FOURTH_ECHELON_TROPHY`,`THIRD_ECHELON_TROPHY`,`SECOND_ECHELON_TROPHY`,`FIRST_ECHELON_TROPHY`,`CAVE_POINTS`,`ID_TAGS`,`PULCHRIDOPT_WING`,`LEBONDOPT_WING`,`ILRUSI_ASSAULT_POINT`,`NYZUL_ISLE_ASSAULT_POINT`,`ZENI_POINT`,`JETTON`,`THERION_ICHOR`,`ALLIED_NOTES`,`AMAN_VOUCHERS`,`LOGIN_POINTS`,`BAYLD`,`KINETIC_UNIT`,`OBSIDIAN_FRAGMENT`,`OP_CREDITS`,`TRAVERSER_STONES`,`VOIDSTONES`,`RECLAMATION_MARKS`,`UNITY_ACCOLADES`,`FIRE_CRYSTALS`,`ICE_CRYSTALS`,`WIND_CRYSTALS`,`EARTH_CRYSTALS`,`LIGHTNING_CRYSTALS`,`WATER_CRYSTALS`,`LIGHT_CRYSTALS`,`DARK_CRYSTALS`,`REMS_CH10`,`REMS_CH9`,`REMS_CH8`,`KUPOFRIED_CORUNDUMS`,`IMPRIMATURS`,`PHEROMONE_SACKS`,`REMS_CH1`,`REMS_CH2`,`REMS_CH3`,`REMS_CH4`,`REMS_CH5`,`REMS_CH6`,`REMS_CH7`,`DEEDS`,`GUILD_SMITHING`,`GUILD_GOLDSMITHING`,`GUILD_WEAVING`,`GUILD_LEATHERCRAFT`,`GUILD_BONECRAFT`,`GUILD_ALCHEMY`,`GUILD_COOKING`,`CINDER`,`FIRE_FEWELL`,`ICE_FEWELL`,`GUILD_WOODWORKING`,`GUILD_FISHING`,`SCYLD`,`SANDORIA_CP`,`BASTOK_CP`,`WINDURST_CP`,`BEASTMAN_SEAL`,`KINDRED_SEAL`,`KINDRED_CREST`,`HIGH_KINDRED_CREST`,`SACRED_KINDRED_CREST`,`ANCIENT_BEASTCOIN`,`VALOR_POINT`,`WIND_FEWELL`,`EARTH_FEWELL`,`LIGHTNING_FEWELL`,`MOBLIN_MARBLE`,`INFAMY`,`PRESTIGE`,`LEGION_POINT`,`SPARK_OF_EMINENCE`,`SHINING_STAR`,`IMPERIAL_STANDING`,`LEUJAOAM_ASSAULT_POINT`,`MAMOOL_ASSAULT_POINT`,`LEBROS_ASSAULT_POINT`,`PERIQIA_ASSAULT_POINT`,`PHANTOM_WORM`,`MORION_WORM`,`WATER_FEWELL`,`LIGHT_FEWELL`,`DARK_FEWELL`,`BALLISTA_POINT`,`FELLOW_POINT`,`DAILY_TALLY`,`CHOCOBUCK_SANDORIA`,`CHOCOBUCK_BASTOK`,`CHOCOBUCK_WINDURST`,`RESEARCH_MARK`,`TUNNEL_WORM`
      FROM ffxiwings.CHAR_POINTS WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_PROFILE (`CHARID`,`FAME_ABY_TAHRONGI`,`FAME_ABY_LATHEINE`,`FAME_ABY_MISAREAUX`,`FAME_ABY_VUNKERL`,`FAME_ABY_ATTOHWA`,`FAME_ABY_ALTEPA`,`FAME_ABY_GRAUBERG`,`FAME_ABY_ULEGUERAND`,`FAME_ADOULIN`,`FAME_ABY_KONSCHTAT`,`FAME_JEUNO`,`RANK_POINTS`,`RANK_SANDORIA`,`RANK_BASTOK`,`RANK_WINDURST`,`FAME_SANDORIA`,`FAME_BASTOK`,`FAME_WINDURST`,`FAME_NORG`)
     SELECT @NEWCHARID as `CHARID`,`FAME_ABY_TAHRONGI`,`FAME_ABY_LATHEINE`,`FAME_ABY_MISAREAUX`,`FAME_ABY_VUNKERL`,`FAME_ABY_ATTOHWA`,`FAME_ABY_ALTEPA`,`FAME_ABY_GRAUBERG`,`FAME_ABY_ULEGUERAND`,`FAME_ADOULIN`,`FAME_ABY_KONSCHTAT`,`FAME_JEUNO`,`RANK_POINTS`,`RANK_SANDORIA`,`RANK_BASTOK`,`RANK_WINDURST`,`FAME_SANDORIA`,`FAME_BASTOK`,`FAME_WINDURST`,`FAME_NORG`
      FROM ffxiwings.CHAR_PROFILE WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_RECAST (`CHARID`,`RECAST`,`TIME`,`ID`)
     SELECT @NEWCHARID as `CHARID`,`RECAST`,`TIME`,`ID`
      FROM ffxiwings.CHAR_RECAST WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_SKILLS (`CHARID`,`RANK`,`VALUE`,`SKILLID`)
     SELECT @NEWCHARID as `CHARID`,`RANK`,`VALUE`,`SKILLID`
      FROM ffxiwings.CHAR_SKILLS WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_SPELLS (`CHARID`,`SPELLID`)
     SELECT @NEWCHARID as `CHARID`,`SPELLID`
      FROM ffxiwings.CHAR_SPELLS WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_STATS (`CHARID`,`BAZAAR_MESSAGE`,`ZONING`,`MLVL`,`SLVL`,`PET_ID`,`PET_TYPE`,`PET_HP`,`PET_MP`,`TITLE`,`HP`,`MP`,`MHFLAG`,`MJOB`,`SJOB`,`DEATH`,`2H`)
     SELECT @NEWCHARID as `CHARID`,`BAZAAR_MESSAGE`,`ZONING`,`MLVL`,`SLVL`,`PET_ID`,`PET_TYPE`,`PET_HP`,`PET_MP`,`TITLE`,`HP`,`MP`,`MHFLAG`,`MJOB`,`SJOB`,`DEATH`,`2H`
      FROM ffxiwings.CHAR_STATS WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_STORAGE (`CHARID`,`WARDROBE4`,`WARDROBE3`,`WARDROBE2`,`WARDROBE`,`CASE`,`SACK`,`SATCHEL`,`LOCKER`,`SAFE`,`INVENTORY`,`wardrobe5`,`wardrobe6`,`wardrobe7`,`wardrobe8`)
     SELECT @NEWCHARID as `CHARID`,`WARDROBE4`,`WARDROBE3`,`WARDROBE2`,`WARDROBE`,`CASE`,`SACK`,`SATCHEL`,`LOCKER`,`SAFE`,`INVENTORY`,0,0,0,0
      FROM ffxiwings.CHAR_STORAGE WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_STYLE (`CHARID`,`RANGED`,`SUB`,`MAIN`,`FEET`,`LEGS`,`HANDS`,`BODY`,`HEAD`)
     SELECT @NEWCHARID as `CHARID`,`RANGED`,`SUB`,`MAIN`,`FEET`,`LEGS`,`HANDS`,`BODY`,`HEAD`
      FROM ffxiwings.CHAR_STYLE WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_UNLOCKS (`CHARID`,`CAMPAIGN_SANDY`,`CAMPAIGN_BASTOK`,`CAMPAIGN_WINDY`,`HOMEPOINTS`,`SURVIVALS`,`MAW`,`RUNIC_PORTAL`,`MOG_LOCKER`,`OUTPOST_WINDY`,`OUTPOST_BASTOK`,`OUTPOST_SANDY`)
     SELECT @NEWCHARID as `CHARID`,`CAMPAIGN_SANDY`,`CAMPAIGN_BASTOK`,`CAMPAIGN_WINDY`,`HOMEPOINTS`,`SURVIVALS`,`MAW`,`RUNIC_PORTAL`,`MOG_LOCKER`,`OUTPOST_WINDY`,`OUTPOST_BASTOK`,`OUTPOST_SANDY`
      FROM ffxiwings.CHAR_UNLOCKS WHERE charid = @OLDCHARID;
    REPLACE INTO tpzdb.CHAR_VARS (`CHARID`,`VALUE`,`VARNAME`)
     SELECT @NEWCHARID as `CHARID`,`VALUE`,`VARNAME`
      FROM ffxiwings.CHAR_VARS WHERE charid = @OLDCHARID;
    -- give received items to new char and set as the sender as well so if they reject it still goes back to them
    -- give items from auction house or gm distribution (senderid = 0)
    REPLACE INTO tpzdb.DELIVERY_BOX (`CHARID`,`SENT`,`RECEIVED`,`SENDER`,`SENDERID`,`EXTRA`,`QUANTITY`,`ITEMSUBID`,`CHARNAME`,`BOX`,`SLOT`,`ITEMID`)
     SELECT @NEWCHARID as `CHARID`,1 as `SENT`,`RECEIVED`,`SENDER`,0 as `SENDERID`,`EXTRA`,`QUANTITY`,`ITEMSUBID`,`CHARNAME`,`BOX`,`SLOT`,`ITEMID`
      FROM ffxiwings.DELIVERY_BOX WHERE charid = @OLDCHARID and (sent = 1 or (sent = 0 and senderid = 0));
    UPDATE ffxiwings.ww_chars SET catseye_charid = @NEWCHARID WHERE character_id = @OLDCHARID;
    -- return items sent to someone else
    REPLACE INTO tpzdb.DELIVERY_BOX (`CHARID`,`SENT`,`RECEIVED`,`SENDER`,`SENDERID`,`EXTRA`,`QUANTITY`,`ITEMSUBID`,`CHARNAME`,`BOX`,`SLOT`,`ITEMID`)
     SELECT @NEWCHARID as `CHARID`,1 as `SENT`,`RECEIVED`,`SENDER`,0 as `SENDERID`,`EXTRA`,`QUANTITY`,`ITEMSUBID`,`CHARNAME`,`BOX`,`SLOT`,`ITEMID`
      FROM ffxiwings.DELIVERY_BOX WHERE senderid = @OLDCHARID and sent = 0 and received = 0;
    UPDATE ffxiwings.ww_chars SET catseye_charid = @NEWCHARID WHERE character_id = @OLDCHARID;
    INSERT INTO tpzdb.char_vars (`charid`, `varname`, `value`) VALUES (@NEWCHARID, 'CHAR_TYPE', 3);
    -- set their variables to not immediately cap login points
    INSERT INTO tpzdb.char_vars (`charid`, `varname`, `value`) VALUES (@NEWCHARID, 'LoginCampaignMonth', MONTH(NOW()));
    INSERT INTO tpzdb.char_vars (`charid`, `varname`, `value`) VALUES (@NEWCHARID, 'LoginCampaignYear', YEAR(NOW()));
    INSERT INTO tpzdb.char_vars (`charid`, `varname`, `value`) VALUES (@NEWCHARID, 'WINGS_CHARID', @OLDCHARID);
END