-------------------------------------------
-- Pirates event zones
-------------------------------------------
require('modules/module_utils')
-------------------------------------------
local m = Module:new('enum_pirates_zones')

-- Ideally, we'd insert these into the zones global table, but it doesn't appear to preserve changes. I'm assuming it gets reloaded after modules are run

xi.pirates = xi.pirates or {}
xi.pirates.zones = xi.pirates.zones or {}

xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA] = {}
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA].mob = {}
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA].mob.SEA_CREATURES = 17682438
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA].mob.SEA_HORROR    = 17682446
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA].mob.PHANTOM       = 17682443

xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA] = {}
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA].mob = {}
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA].mob.SEA_CREATURES = 17678342
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA].mob.PHANTOM       = 17678347
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA].mob.SEA_HORROR    = 17678350
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA].mob.ENAGAKURE     = 17678351

xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES] = {}
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].mob = {}
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].mob.WIGHT         = 17711120
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].mob.SILVERHOOK    = 17711121
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].mob.SEA_MONK      = 17682442
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].mob.SEA_HORROR    = 17682446
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].mob.SEA_CREATURES = 17711110
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].mob.PHANTOM       = 17711115
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].mob.CROSSBONES    = 17711116

-- use this when merged into zone IDs.lua
-- local pirate1 = GetFirstID('Map') + 1
local pirate1 = 17711136 + 1
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].npc = {}
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].npc.PIRATES =
{
    [pirate1] =
    {
        start_pos = { x = 33.601, y = -7.163, z = 13.377, rotation = 128 },
        enter_path =
        {
            { x = 28.75, y = -7.163, z = 10.60 },
            { x = 22.00, y = -7.163, z = 10.46 },
            { x = 21.90, y = -7.163, z = 10.46 },
        },
        look_at = { x = 20, y = -7.163, z = 10.46 },
        exit_path =
        {
            { x = 29.79,  y = -7.163, z = 10.63  },
            { x = 33.57,  y = -7.163, z = 13.14  },
            { x = 33.601, y = -7.163, z = 13.377 },
        },
        position = 1,
    },

    [pirate1 + 1] =
    {
        start_pos = { x = 29.728, y = -7.163, z = 1.303, rotation = 128 },
        enter_path =
        {
            { x = 24.87, y = -7.163, z = 2.77 },
            { x = 22.00, y = -7.163, z = 6.59 },
            { x = 21.90, y = -7.163, z = 6.59 },
        },
        look_at = { x = 20, y = -7.163, z = 6.59 },
        exit_path =
        {
            { x = 21.90,  y = -7.163,  z = 6.59  },
            { x = 22.00,  y = -7.163,  z = 6.59  },
            { x = 24.87,  y = -7.163,  z = 2.77  },
            { x = 25.91,  y = -7.163,  z = 2.77  },
            { x = 29.71,  y = -7.163,  z = 1.54  },
            { x = 29.728, y = -7.163,  z = 1.303 },
        },
        position = 2,
    },

    [pirate1 + 2] =
    {
        start_pos = { x = 29.602, y = -7.163, z = -2.475, rotation = 128 },
        enter_path =
        {
            { x = 29.602, y = -7.163, z = -2.475 },
            { x = 29.61,  y = -7.163, z = -2.71  },
            { x = 25.97,  y = -7.163, z = -4.02  },
            { x = 24.93,  y = -7.163, z = -4.02  },
            { x = 22.00,  y = -7.163, z = 2.10   },
            { x = 21.90,  y = -7.163, z = 2.10   },
        },
        look_at = { x = 20, y = -7.163, z = 2.10 },
        exit_path =
        {
            { x = 21.90,  y = -7.163, z = 2.10   },
            { x = 22.00,  y = -7.163, z = 2.10   },
            { x = 24.93,  y = -7.163, z = -4.02  },
            { x = 25.97,  y = -7.163, z = -4.02  },
            { x = 29.61,  y = -7.163, z = -2.71  },
            { x = 29.602, y = -7.163, z = -2.475 },
        },
        position = 3,
    },
}

-- local pirateShip = GetFirstID('0x0E')
local pirateShip = 17711140
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].npc.PIRATE_SHIP =
{
    id = pirateShip,
    start_pos = { x = 150, y = 0, z = -1000, rotation = 192 },
    event_pos = { x = 30, y = 0, z = 0, rotation = 192 },
    anim_path = 14,
}

        -- Starting Sea Creature Offset
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES] = {}
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].mob = {}
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].mob.SEA_CREATURES = 17707014
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].mob.PHANTOM       = 17707019
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].mob.CROSSBONES    = 17707020
        -- Starting Pirate Offset
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].mob.ENAGAKURE     = 17707026

-- use this when merged into zone IDs.lua
-- local pirate1 = GetFirstID('Map') + 1
pirate1 = 17707041 + 1
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].npc = {}
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].npc.PIRATES =
{
    [pirate1] =
    {
        start_pos =  { x = -33.601, y = -7.163, z = 13.377, rotation = 128 },
        enter_path =
        {
            { x = -28.75, y = -7.163, z = 10.60 },
            { x = -22.00, y = -7.163, z = 10.46 },
            { x = -21.90, y = -7.163, z = 10.46 },
        },
        look_at = { x = -20, y = -7.163, z = 10.46 },
        exit_path =
        {
            { x = -29.79,  y = -7.163, z = 10.63  },
            { x = -33.57,  y = -7.163, z = 13.14  },
            { x = -33.601, y = -7.163, z = 13.377 },
        },
        position = 1,
    },

    [pirate1 + 1] =
    {
        start_pos = { x = -29.728, y = -7.163, z = 1.303, rotation = 128 },
        enter_path =
        {
            { x = -24.87, y = -7.163, z = 2.77 },
            { x = -22.00, y = -7.163, z = 6.59 },
            { x = -21.90, y = -7.163, z = 6.59 },
        },
        look_at = { x = -20, y = -7.163, z = 6.59 },
        exit_path =
        {
            { x = -25.91,  y = -7.163, z = 2.77  },
            { x = -29.71,  y = -7.163, z = 1.54  },
            { x = -29.728, y = -7.163, z = 1.303 },
        },
        position = 2,
    },

    [pirate1 + 2] =
    {
        start_pos = { x = -29.602, y = -7.163, z = -2.475, rotation = 128 },
        enter_path =
        {
            { x = -24.93, y = -7.163, z = -4.02 },
            { x = -22.00, y = -7.163, z =  2.10 },
            { x = -21.90, y = -7.163, z =  2.10 },
        },
        look_at = { x = -20, y = -7.163, z = 2.10 },
        exit_path =
        {
            { x = -25.97,  y = -7.163, z = -4.02  },
            { x = -29.61,  y = -7.163, z = -2.71  },
            { x = -29.602, y = -7.163, z = -2.475 },
        },
        position = 3,
    },
}

pirateShip = 17707040
xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].npc.PIRATE_SHIP =
{
    id = pirateShip,
    start_pos = { x = -150, y = 0, z = -1000, rotation = 192 },
    event_pos = { x = -30, y = 0, z = 0, rotation = 192 },
    anim_path = 13,
}

return m
