-----------------------------------
-- Area: Waughroon Shrine
--  NPC: Armoury Crate
-----------------------------------
local m = Module:new("bf_waughroon_loot")

local function setBattlefieldLoot(id, loot)
    if xi.battlefield.contents[id] == nil then
        print(fmt("[BCNM] Failed loot override for Waughroon Shrine ({}) - BCNM does not exist!", id))
        return
    end

    xi.battlefield.contents[id].loot = loot
end

m:addOverride('xi.server.onServerStart', function()
    super()

    -- BCNM The Worm's Turn
    setBattlefieldLoot(xi.battlefield.id.WORMS_TURN, {
        {
            { item = xi.item.NONE,                  weight = 125 }, -- nothing
            { item = xi.item.FIRE_SPIRIT_PACT,      weight = 125 }, -- fire_spirit_pact
            { item = xi.item.SCROLL_OF_PHALANX,     weight = 125 }, -- scroll_of_phalanx
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI, weight = 125 }, -- scroll_of_utsusemi_ni
            { item = xi.item.SCROLL_OF_ERASE,       weight = 125 }, -- scroll_of_erase
            { item = xi.item.SCROLL_OF_ICE_SPIKES,  weight = 125 }, -- scroll_of_ice_spikes
            { item = xi.item.SCROLL_OF_ABSORB_STR,  weight = 125 }, -- scroll_of_absorb-str
            { item = xi.item.SCROLL_OF_REFRESH,     weight = 125 }, -- scroll_of_refresh
        },

        {
            { item = xi.item.NONE,              weight = 125 }, -- nothing
            { item = xi.item.ENHANCING_EARRING, weight = 125 }, -- enhancing_earring
            { item = xi.item.SPIRIT_TORQUE,     weight = 125 }, -- spirit_torque
            { item = xi.item.GUARDING_GORGET,   weight = 125 }, -- guarding_gorget
            { item = xi.item.NEMESIS_EARRING,   weight = 125 }, -- nemesis_earring
            { item = xi.item.EARTH_MANTLE,      weight = 125 }, -- earth_mantle
            { item = xi.item.STRIKE_SHIELD,     weight = 125 }, -- strike_shield
            { item = xi.item.SHIKAR_BOW,        weight = 125 }, -- shikar_bow
        },

        {
            { item = xi.item.OAK_LOG,      weight = 500 }, -- oak_log
            { item = xi.item.ROSEWOOD_LOG, weight = 500 }, -- rosewood_log
        },

        {
            { item = xi.item.GOLD_BEASTCOIN,    weight = 500 }, -- gold_beastcoin
            { item = xi.item.MYTHRIL_BEASTCOIN, weight = 500 }, -- mythril_beastcoin
        },

        {
            { item = xi.item.BLACK_PEARL, weight = 200 }, -- black_pearl
            { item = xi.item.AMETRINE,    weight = 200 }, -- ametrine
            { item = xi.item.YELLOW_ROCK, weight = 200 }, -- yellow_rock
            { item = xi.item.PERIDOT,     weight = 200 }, -- peridot
            { item = xi.item.TURQUOISE,   weight = 200 }, -- turquoise
        },

        {
            { item = xi.item.NONE,     weight = 800 }, -- nothing
            { item = xi.item.RERAISER, weight = 200 }, -- reraiser
        },
    })

    -- BCNM Grimshell Shocktroopers
    setBattlefieldLoot(xi.battlefield.id.GRIMSHELL_SHOCKTROOPERS, {
        {
            { item = xi.item.NONE,             weight = 250 }, -- nothing
            { item = xi.item.ASSAULT_EARRING,  weight = 125 }, -- assault_earring
            { item = xi.item.VASSAGOS_SCYTHE,  weight = 125 }, -- vassagos_scythe
            { item = xi.item.CHICKEN_KNIFE,    weight = 125 }, -- chicken_knife
            { item = xi.item.FEY_WAND,         weight = 125 }, -- fey_wand
            { item = xi.item.ASTRAL_SHIELD,    weight = 125 }, -- astral_shield
            { item = xi.item.ENHANCING_MANTLE, weight = 125 }, -- enhancing_mantle
        },

        {
            { item = xi.item.MYTHRIL_INGOT,   weight = 250 }, -- mythril_ingot
            { item = xi.item.STEEL_INGOT,     weight = 250 }, -- steel_ingot
            { item = xi.item.GOLD_INGOT,      weight = 250 }, -- gold_ingot
            { item = xi.item.DARKSTEEL_INGOT, weight = 250 }, -- darksteel_ingot
        },

        {
            { item = xi.item.EBONY_LOG,     weight = 250 }, -- ebony_log
            { item = xi.item.CHRYSOBERYL,   weight = 250 }, -- chrysoberyl
            { item = xi.item.FLUORITE,      weight = 250 }, -- fluorite
            { item = xi.item.DREAM_PLATTER, weight = 250 }, -- jadeite
        },

        {
            { item = xi.item.NONE,               weight = 875 }, -- nothing
            { item = xi.item.SCROLL_OF_RAISE_II, weight = 125 }, -- scroll_of_raise_ii
        },

        {
            { item = xi.item.NONE,               weight = 800 }, -- nothing
            { item = xi.item.SCROLL_OF_RAISE_II, weight = 200 }, -- hi-reraiser
        },
    })

    -- BCNM 3, 2, 1...
    setBattlefieldLoot(xi.battlefield.id.THREE_TWO_ONE, {
        {
            { item = xi.item.KAGEBOSHI, weight = 500 }, -- kageboshi
            { item = xi.item.ODENTA,    weight = 500 }, -- odenta
        },

        {
            { item = xi.item.OCEAN_BELT,  weight = 200 }, -- ocean_belt
            { item = xi.item.FOREST_BELT, weight = 200 }, -- forest_belt
            { item = xi.item.STEPPE_BELT, weight = 200 }, -- steppe_belt
            { item = xi.item.JUNGLE_BELT, weight = 200 }, -- jungle_belt
            { item = xi.item.DESERT_BELT, weight = 200 }, -- desert_belt
        },

        {
            { item = xi.item.NONE,                weight = 250 }, -- nothing
            { item = xi.item.SCROLL_OF_FREEZE,    weight = 125 }, -- scroll_of_freeze
            { item = xi.item.SCROLL_OF_QUAKE,     weight = 125 }, -- scroll_of_quake
            { item = xi.item.SCROLL_OF_RAISE_II,  weight = 125 }, -- scroll_of_raise_ii
            { item = xi.item.SCROLL_OF_REGEN_III, weight = 125 }, -- scroll_of_regen_iii
            { item = xi.item.FIRE_SPIRIT_PACT,    weight = 125 }, -- fire_spirit_pact
            { item = xi.item.LIGHT_SPIRIT_PACT,   weight = 125 }, -- light_spirit_pact
        },

        {
            { item = xi.item.NONE,          weight = 800 }, -- nothing
            { item = xi.item.PETRIFIED_LOG, weight = 200 }, -- petrified_log
        },
    })

    -- BCNM Birds of a Feather
    setBattlefieldLoot(xi.battlefield.id.BIRDS_OF_A_FEATHER, {
        {
            { item = xi.item.BIRD_FEATHER, weight = 1000 }, -- Bird Feather
        },

        {
            { item = xi.item.ASHIGARU_EARRING,   weight = 125 }, -- Ashigaru Earring
            { item = xi.item.TRIMMERS_EARRING,   weight = 125 }, -- Trimmers Earring
            { item = xi.item.BEATERS_EARRING,    weight = 125 }, -- Beaters Earring
            { item = xi.item.HEALERS_EARRING,    weight = 125 }, -- Healers Earring
            { item = xi.item.MERCENARYS_EARRING, weight = 125 }, -- Mercenarys Earring
            { item = xi.item.SINGERS_EARRING,    weight = 125 }, -- Singers Earring
            { item = xi.item.WIZARDS_EARRING,    weight = 125 }, -- Wizards Earring
            { item = xi.item.WRESTLERS_EARRING,  weight = 125 }, -- Wrestlers Earring
        },

        {
            { item = xi.item.NONE,        weight = 125 }, -- nothing
            { item = xi.item.AVATAR_BELT, weight = 125 }, -- Avatar Belt
            { item = xi.item.DAGGER_BELT, weight = 125 }, -- Dagger Belt
            { item = xi.item.LANCE_BELT,  weight = 125 }, -- Lance Belt
            { item = xi.item.RAPIER_BELT, weight = 125 }, -- Rapier Belt
            { item = xi.item.SARASHI,     weight = 125 }, -- Sarashi
            { item = xi.item.SCYTHE_BELT, weight = 125 }, -- Scythe Belt
            { item = xi.item.SHIELD_BELT, weight = 125 }, -- Shield Belt
        },

        {
            { item = xi.item.NONE,                   weight = 500 }, -- nothing
            { item = xi.item.SCROLL_OF_DISPEL,       weight = 125 }, -- Scroll Of Dispel
            { item = xi.item.SCROLL_OF_ERASE,        weight = 125 }, -- Scroll Of Erase
            { item = xi.item.SCROLL_OF_MAGIC_FINALE, weight = 125 }, -- Scroll Of Magic Finale
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI,  weight = 125 }, -- Scroll Of Utsusemi Ni
        },

        {
            { item = xi.item.NONE,         weight = 136 }, -- nothing
            { item = xi.item.BIRD_EGG,     weight = 125 }, -- Bird Egg
            { item = xi.item.BIRD_FEATHER, weight =  50 }, -- Bird Feather
            { item = xi.item.CHESTNUT_LOG, weight = 125 }, -- Chestnut Log
            { item = xi.item.ELM_LOG,      weight = 188 }, -- Elm Log
            { item = xi.item.HI_ETHER,     weight =  63 }, -- Hi-ether
            { item = xi.item.HORN_QUIVER,  weight = 313 }, -- Horn Quiver
        },

        {
            { item = xi.item.NONE,                 weight = 123 }, -- nothing
            { item = xi.item.IRON_INGOT,           weight =  63 }, -- Iron Ingot
            { item = xi.item.LAPIS_LAZULI,         weight = 125 }, -- Lapis Lazuli
            { item = xi.item.LIGHT_OPAL,           weight = 125 }, -- Light Opal
            { item = xi.item.MYTHRIL_INGOT,        weight =  63 }, -- Mythril Ingot
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE, weight =  63 }, -- Chunk Of Mythril Ore
            { item = xi.item.ONYX,                 weight = 250 }, -- Onyx
            { item = xi.item.CHUNK_OF_SILVER_ORE,  weight =  63 }, -- Chunk Of Silver Ore
            { item = xi.item.SILVER_INGOT,         weight = 125 }, -- Silver Ingot
        },
    })

    -- BCNM Crustacean Conundrum
    setBattlefieldLoot(xi.battlefield.id.CRUSTACEAN_CONUNDRUM, {
        {
            { item = xi.item.SLICE_OF_LAND_CRAB_MEAT, weight = 1000 }, -- slice_of_land_crab_meat
        },

        {
            { item = xi.item.MANNEQUIN_BODY, weight = 1000 }, -- mannequin_body
        },

        {
            { item = xi.item.NONE,       weight = 334 }, -- nothing
            { item = xi.item.CRAB_SHELL, weight = 666 }, -- crab_shell
        },

        {
            { item = xi.item.BEETLE_QUIVER,         weight = 444 }, -- beetle_quiver
            { item = xi.item.JUG_OF_FISH_OIL_BROTH, weight = 556 }, -- jug_of_fish_oil_broth
        },

        {
            { item = xi.item.NONE,         weight = 450 }, -- nothing
            { item = xi.item.BRASS_INGOT,  weight = 100 }, -- brass_ingot
            { item = xi.item.BRONZE_SHEET, weight = 150 }, -- bronze_sheet
            { item = xi.item.BRONZE_INGOT, weight = 300 }, -- bronze_ingot
        },

        {
            { item = xi.item.NONE,              weight = 300 }, -- nothing
            { item = xi.item.MYTHRIL_BEASTCOIN, weight = 500 }, -- mythril_beastcoin
            { item = xi.item.MANNEQUIN_HANDS,   weight = 100 }, -- mannequin_hands
            { item = xi.item.MANNEQUIN_HEAD,    weight = 100 }, -- mannequin_head
        },

        {
            { item = xi.item.NONE,            weight = 200 }, -- nothing
            { item = xi.item.PLATOON_CESTI,   weight = 100 }, -- platoon_cesti
            { item = xi.item.PLATOON_DAGGER,  weight = 100 }, -- platoon_dagger
            { item = xi.item.PLATOON_AXE,     weight = 100 }, -- platoon_axe
            { item = xi.item.PLATOON_BOW,     weight = 100 }, -- platoon_bow
            { item = xi.item.PLATOON_LANCE,   weight = 100 }, -- platoon_lance
            { item = xi.item.PLATOON_SWORD,   weight = 100 }, -- platoon_sword
            { item = xi.item.PLATOON_MACE,    weight = 100 }, -- platoon_mace
            { item = xi.item.PLATOON_ZAGHNAL, weight = 100 }, -- platoon_zaghnal
        },
    })

    -- BCNM Grove Guardians
    setBattlefieldLoot(xi.battlefield.id.GROVE_GUARDIANS, {
        {
            { item = xi.item.MANNEQUIN_BODY, weight = 1000 }, -- mannequin_body
        },

        {
            { item = xi.item.NONE,            weight = 800 }, -- nothing
            { item = xi.item.MANNEQUIN_HANDS, weight = 200 }, -- mannequin_hands
        },

        {
            { item = xi.item.NONE,             weight = 250 }, -- nothing
            { item = xi.item.WRESTLERS_MANTLE, weight = 250 }, -- wrestlers_mantle
            { item = xi.item.MAGICIANS_MANTLE, weight = 250 }, -- magicians_mantle
            { item = xi.item.PILFERERS_MANTLE, weight = 250 }, -- pilferers_mantle
        },

        {
            { item = xi.item.NONE,           weight = 200 }, -- nothing
            { item = xi.item.HEALERS_SHIELD, weight = 200 }, -- healers_shield
            { item = xi.item.GENIN_ASPIS,    weight = 200 }, -- genin_aspis
            { item = xi.item.KILLER_TARGE,   weight = 200 }, -- killer_targe
            { item = xi.item.STAFF_BELT,     weight = 200 }, -- staff_belt
        },

        {
            { item = xi.item.NONE,                   weight = 250 }, -- nothing
            { item = xi.item.BAG_OF_HERB_SEEDS,      weight = 250 }, -- bag_of_herb_seeds
            { item = xi.item.BAG_OF_VEGETABLE_SEEDS, weight = 250 }, -- bag_of_vegetable_seeds
            { item = xi.item.BAG_OF_GRAIN_SEEDS,     weight = 250 }, -- bag_of_grain_seeds
        },

        {
            { item = xi.item.NONE,                   weight = 500 }, -- nothing
            { item = xi.item.SCROLL_OF_DISPEL,       weight = 125 }, -- scroll_of_dispel
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI,  weight = 125 }, -- scroll_of_utsusemi_ni
            { item = xi.item.SCROLL_OF_MAGIC_FINALE, weight = 125 }, -- scroll_of_magic_finale
            { item = xi.item.SCROLL_OF_ERASE,        weight = 125 }, -- scroll_of_erase
        },

        {
            { item = xi.item.NONE,            weight = 800 }, -- nothing
            { item = xi.item.SCORPION_QUIVER, weight = 200 }, -- scorpion_quiver
        },
    })

    -- KSNM The Hills are Alive
    setBattlefieldLoot(xi.battlefield.id.HILLS_ARE_ALIVE, {
        {
            { item = 3344, weight = 1000 }, -- Red Pondweed
        },

        {
            { item = 17738, weight =  50 }, -- Hauteclaire (custom drop)
            { item = 18047, weight = 188 }, -- Havoc Scythe
            { item = 17939, weight =  27 }, -- Kriegsbeil
            { item = 17937, weight = 170 }, -- Leopard Axe
            { item =  1441, weight = 295 }, -- Libation Abjuration
            { item = 18351, weight =  27 }, -- Meteor Cesti
            { item = 17464, weight =  71 }, -- Purgatory Mace
            { item = 17575, weight = 196 }, -- Somnus Signa
        },

        {
            { item = xi.item.GAWAINS_AXE,         weight =  45 }, -- Gawains Axe
            { item = xi.item.GRIM_STAFF,          weight = 259 }, -- Grim Staff
            { item = xi.item.GROSVENEURS_BOW,     weight = 241 }, -- Grosveneurs Bow
            { item = xi.item.HARLEQUINS_HORN,     weight = 143 }, -- Harlequins Horn
            { item = xi.item.OBLATION_ABJURATION, weight = 161 }, -- Oblation Abjuration
            { item = xi.item.STYLET,              weight = 143 }, -- Stylet
            { item = xi.item.ZEN_POLE,            weight =  36 }, -- Zen Pole
        },

        {
            { item = xi.item.ADAMAN_CHAIN,        weight = 446 }, -- Adaman Chain
            { item = xi.item.ADAMANTOISE_SHELL,   weight = 420 }, -- Adamantoise Shell
            { item = xi.item.PIECE_OF_ANGEL_SKIN, weight =  71 }, -- Piece Of Angel Skin
            { item = xi.item.STRIDER_BOOTS,       weight =  26 }, -- Strider Boots
        },

        {
            { item = xi.item.CORAL_FRAGMENT,           weight = 116 }, -- Coral Fragment
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,   weight =  89 }, -- Chunk Of Darksteel Ore
            { item = xi.item.DEMON_HORN,               weight =  71 }, -- Demon Horn
            { item = xi.item.EBONY_LOG,                weight = 152 }, -- Ebony Log
            { item = xi.item.CHUNK_OF_GOLD_ORE,        weight = 107 }, -- Chunk Of Gold Ore
            { item = xi.item.SPOOL_OF_GOLD_THREAD,     weight =  89 }, -- Spool Of Gold Thread
            { item = xi.item.SLAB_OF_GRANITE,          weight =  45 }, -- Slab Of Granite
            { item = xi.item.HI_RERAISER,              weight =  71 }, -- Hi-reraiser
            { item = xi.item.MAHOGANY_LOG,             weight = 107 }, -- Mahogany Log
            { item = xi.item.PETRIFIED_LOG,            weight = 223 }, -- Petrified Log
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,    weight = 116 }, -- Chunk Of Platinum Ore
            { item = xi.item.SQUARE_OF_RAINBOW_CLOTH,  weight =  54 }, -- Square Of Rainbow Cloth
            { item = xi.item.RAM_HORN,                 weight =  54 }, -- Ram Horn
            { item = xi.item.SQUARE_OF_RAXA,           weight =  71 }, -- Square Of Raxa
            { item = xi.item.RERAISER,                 weight =  45 }, -- Reraiser
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  54 }, -- Handful Of Wyvern Scales
            { item = xi.item.VILE_ELIXIR,              weight =  63 }, -- Vile Elixir
            { item = xi.item.VILE_ELIXIR_P1,           weight =  45 }, -- Vile Elixir +1
        },

        {
            { item = xi.item.ADAMAN_CHAIN,     weight = 268 }, -- Adaman Chain
            { item = xi.item.ADAMANTOISE_EGG,  weight = 121 }, -- Adamantoise Egg
            { item = xi.item.AGILITY_POTION,   weight =  80 }, -- Agility Potion
            { item = xi.item.DEXTERITY_POTION, weight = 143 }, -- Dexterity Potion
            { item = xi.item.STRENGTH_POTION,  weight = 214 }, -- Strength Potion
            { item = xi.item.VITALITY_POTION,  weight = 196 }, -- Vitality Potion
        },

        {
            { item = xi.item.CHUNK_OF_ADAMAN_ORE,     weight = 107 }, -- Chunk Of Adaman Ore
            { item = xi.item.CHARISMA_POTION,         weight =  89 }, -- Charisma Potion
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,  weight = 179 }, -- Chunk Of Darksteel Ore
            { item = xi.item.ICARUS_WING,             weight = 134 }, -- Icarus Wing
            { item = xi.item.INTELLIGENCE_POTION,     weight = 152 }, -- Intelligence Potion
            { item = xi.item.MIND_POTION,             weight =  80 }, -- Mind Potion
            { item = xi.item.CHUNK_OF_ORICHALCUM_ORE, weight =  80 }, -- Chunk Of Orichalcum Ore
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,   weight = 107 }, -- Chunk Of Platinum Ore
            { item = xi.item.PRINCELY_SWORD,          weight = 152 }, -- Princely Sword
        },

        {
            { item = xi.item.CORAL_FRAGMENT,           weight = 139 }, -- Coral Fragment
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,   weight =  59 }, -- Chunk Of Darksteel Ore
            { item = xi.item.DEMON_HORN,               weight =  50 }, -- Demon Horn
            { item = xi.item.EBONY_LOG,                weight = 109 }, -- Ebony Log
            { item = xi.item.CHUNK_OF_GOLD_ORE,        weight =  69 }, -- Chunk Of Gold Ore
            { item = xi.item.SLAB_OF_GRANITE,          weight =  99 }, -- Slab Of Granite
            { item = xi.item.HI_RERAISER,              weight =  79 }, -- Hi-reraiser
            { item = xi.item.MAHOGANY_LOG,             weight = 129 }, -- Mahogany Log
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,     weight = 119 }, -- Chunk Of Mythril Ore
            { item = xi.item.PHOENIX_FEATHER,          weight =  69 }, -- Phoenix Feather
            { item = xi.item.PETRIFIED_LOG,            weight = 168 }, -- Petrified Log
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,    weight = 129 }, -- Chunk Of Platinum Ore
            { item = xi.item.RAM_HORN,                 weight = 109 }, -- Ram Horn
            { item = xi.item.SQUARE_OF_RAXA,           weight =  79 }, -- Square Of Raxa
            { item = xi.item.VILE_ELIXIR,              weight =  69 }, -- Vile Elixir
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  79 }, -- Handful Of Wyvern Scales
            { item = xi.item.RERAISER,                 weight =  50 }, -- Reraiser
            { item = xi.item.SPOOL_OF_GOLD_THREAD,     weight =  89 }, -- Spool Of Gold Thread
        },

        {
            { item = xi.item.VIAL_OF_BLACK_BEETLE_BLOOD, weight = 109 }, -- Vial Of Black Beetle Blood
            { item = xi.item.SQUARE_OF_DAMASCENE_CLOTH,  weight =  89 }, -- Square Of Damascene Cloth
            { item = xi.item.DAMASCUS_INGOT,             weight =  79 }, -- Damascus Ingot
            { item = xi.item.SPOOL_OF_MALBORO_FIBER,     weight =  99 }, -- Spool Of Malboro Fiber
            { item = xi.item.PHILOSOPHERS_STONE,         weight = 188 }, -- Philosophers Stone
            { item = xi.item.PHOENIX_FEATHER,            weight = 238 }, -- Phoenix Feather
            { item = xi.item.SQUARE_OF_RAXA,             weight = 109 }, -- Square Of Raxa
        },

        {
            { item = xi.item.DIVINE_LOG,              weight =  79 }, -- Divine Log
            { item = xi.item.LACQUER_TREE_LOG,        weight = 257 }, -- Lacquer Tree Log
            { item = xi.item.PETRIFIED_LOG,           weight = 337 }, -- Petrified Log
            { item = xi.item.SQUARE_OF_SHINING_CLOTH, weight = 149 }, -- Square Of Shining Cloth
        },
    })

    -- BCNM Royal Jelly
    setBattlefieldLoot(xi.battlefield.id.ROYAL_JELLY, {
        {
            { item = xi.item.VIAL_OF_SLIME_OIL, weight = 1000 },
        },
        {
            { item = xi.item.VIAL_OF_SLIME_OIL, weight = 1000 },
        },
        {
            { item = xi.item.ARCHERS_RING, weight =  91 },
        },
        {
            { item = xi.item.MANA_RING,             weight = 469 },
            { item = xi.item.GRUDGE_SWORD,          weight = 152 },
            { item = xi.item.DE_SAINTRES_AXE,       weight = 120 },
            { item = xi.item.BUZZARD_TUCK,          weight = 118 },
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI, weight = 106 },
        },
        {
            { item = xi.item.MARKSMANS_RING, weight = 258 },
            { item = xi.item.DUSKY_STAFF,    weight = 152 },
            { item = xi.item.HIMMEL_STOCK,   weight = 101 },
            { item = xi.item.SEALED_MACE,    weight  = 98 },
            { item = xi.item.SHIKAR_BOW,     weight  = 98 },
        },
        {
            { item = xi.item.SCROLL_OF_ABSORB_STR, weight = 123 },
            { item = xi.item.SCROLL_OF_ERASE,      weight = 165 },
            { item = xi.item.SCROLL_OF_PHALANX,    weight = 140 },
            { item = xi.item.FIRE_SPIRIT_PACT,     weight = 145 },
            { item = xi.item.STEEL_SHEET,          weight = 229 },
            { item = xi.item.STEEL_INGOT,          weight = 238 },
        },
        {

            { item = xi.item.SCROLL_OF_REFRESH,     weight = 333 },
            { item = xi.item.SCROLL_OF_ICE_SPIKES,  weight = 246 },
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI, weight = 333 },
            { item = xi.item.GOLD_BEASTCOIN,        weight = 182 },
            { item = xi.item.MYTHRIL_BEASTCOIN,     weight = 133 },
            { item = xi.item.PERIDOT,               weight =  27 },
            { item = xi.item.TURQUOISE,             weight =  20 },
            { item = xi.item.BLACK_PEARL,           weight =  15 },
            { item = xi.item.GOSHENITE,             weight =  15 },
            { item = xi.item.SPHENE,                weight =  15 },
            { item = xi.item.AMETRINE,              weight =  10 },
            { item = xi.item.GARNET,                weight =   7 },
            { item = xi.item.BLACK_ROCK,            weight =  12 },
            { item = xi.item.GREEN_ROCK,            weight =   7 },
            { item = xi.item.WHITE_ROCK,            weight =   7 },
            { item = xi.item.BLUE_ROCK,             weight =   2 },
            { item = xi.item.TRANSLUCENT_ROCK,      weight =   2 },
            { item = xi.item.OAK_LOG,               weight =   5 },
            { item = xi.item.ROSEWOOD_LOG,          weight =   5 },
            { item = xi.item.VILE_ELIXIR,           weight =  10 },
            { item = xi.item.RERAISER,              weight =   2 },
        },
    })

    -- BCNM The Final Bout
    setBattlefieldLoot(xi.battlefield.id.FINAL_BOUT, {
        {
            { item = xi.item.BAG_OF_TREE_CUTTINGS, weight = 1000 }, -- bag_of_tree_cuttings
        },

        {
            { item = xi.item.BAG_OF_TREE_CUTTINGS, weight = 1000 }, -- bag_of_tree_cuttings
        },

        {
            { item = xi.item.CLUMP_OF_BOYAHDA_MOSS, weight = 1000 }, -- clump_of_boyahda_moss
        },

        {
            { item = xi.item.SCROLL_OF_QUAKE,          weight = 100 }, -- scroll_of_quake
            { item = xi.item.PIECE_OF_WISTERIA_LUMBER, weight = 100 }, -- piece_of_wisteria_lumber
            { item = xi.item.MAHOGANY_LOG,             weight = 100 }, -- mahogany_log
            { item = xi.item.EBONY_LOG,                weight = 100 }, -- ebony_log
            { item = xi.item.SCROLL_OF_FREEZE,         weight = 100 }, -- scroll_of_freeze
            { item = xi.item.DARKSTEEL_INGOT,          weight = 100 }, -- darksteel_ingot
            { item = xi.item.SCROLL_OF_RAISE_II,       weight = 100 }, -- scroll_of_raise_ii
            { item = xi.item.PETRIFIED_LOG,            weight = 100 }, -- petrified_log
            { item = xi.item.GOLD_INGOT,               weight = 100 }, -- gold_ingot
            { item = xi.item.CORAL_FRAGMENT,           weight = 100 }, -- coral_fragment
        },

        {
            { item = xi.item.SHOCK_MASK,              weight = 62 }, -- shock_mask
            { item = xi.item.SUPER_RIBBON,            weight = 62 }, -- super_ribbon
            { item = xi.item.RIVAL_RIBBON,            weight = 62 }, -- rival_ribbon
            { item = xi.item.IVORY_MITTS,             weight = 62 }, -- ivory_mitts
            { item = xi.item.SPIKED_FINGER_GAUNTLETS, weight = 70 }, -- spiked_finger_gauntlets
            { item = xi.item.SLY_GAUNTLETS,           weight = 62 }, -- sly_gauntlets
            { item = xi.item.RUSH_GLOVES,             weight = 62 }, -- rush_gloves
            { item = xi.item.MANA_CIRCLET,            weight = 62 }, -- mana_circlet
            { item = xi.item.HATEFUL_COLLAR,          weight = 62 }, -- hateful_collar
            { item = xi.item.ESOTERIC_MANTLE,         weight = 62 }, -- esoteric_mantle
            { item = xi.item.TEMPLARS_MANTLE,         weight = 62 }, -- templars_mantle
            { item = xi.item.HEAVY_MANTLE,            weight = 62 }, -- heavy_mantle
            { item = xi.item.INTELLECT_TORQUE,        weight = 62 }, -- intellect_torque
            { item = xi.item.STORM_GORGET,            weight = 62 }, -- storm_gorget
            { item = xi.item.BENIGN_NECKLACE,         weight = 62 }, -- benign_necklace
            { item = xi.item.SNIPERS_MANTLE,          weight = 62 }, -- snipers_mantle
        },
    })

    -- BCNM Up In Arms
    setBattlefieldLoot(xi.battlefield.id.UP_IN_ARMS, {
        {
            { item = xi.item.GIL, weight = 1000, amount = 15000 }, -- Gil
        },

        {
            { item = xi.item.BLACK_PEARL, weight = 1000 }, -- Black Pearl
        },

        {
            { item = xi.item.PEARL, weight = 1000 }, -- Pearl
        },

        {
            { item = xi.item.PEARL, weight = 1000 }, -- Pearl
        },

        {
            { item = xi.item.PIECE_OF_OXBLOOD, weight = 1000 }, -- Piece Of Oxblood
        },

        {
            { item = xi.item.PIECE_OF_OXBLOOD, weight = 1000 }, -- Piece Of Oxblood
        },

        {
            { item = xi.item.PIECE_OF_OXBLOOD, weight = 1000 }, -- Piece Of Oxblood
        },

        {
            { item = xi.item.TELEPORT_RING_ALTEP, weight = 447 }, -- Teleport Ring Altep
            { item = xi.item.TELEPORT_RING_DEM,   weight = 487 }, -- Teleport Ring Dem
        },

        {
            { item = xi.item.AJARI_BEAD_NECKLACE, weight = 494 }, -- Ajari Bead Necklace
            { item = xi.item.PHILOMATH_STOLE,     weight = 449 }, -- Philomath Stole
        },

        {
            { item = xi.item.AQUAMARINE,       weight =  51 }, -- Aquamarine
            { item = xi.item.CHRYSOBERYL,      weight =  32 }, -- Chrysoberyl
            { item = xi.item.DARKSTEEL_INGOT,  weight =  39 }, -- Darksteel Ingot
            { item = xi.item.EBONY_LOG,        weight =  21 }, -- Ebony Log
            { item = xi.item.HI_RERAISER,      weight =  32 }, -- Hi-reraiser
            { item = xi.item.GOLD_INGOT,       weight =  55 }, -- Gold Ingot
            { item = xi.item.JADEITE,          weight =  62 }, -- Jadeite
            { item = xi.item.MYTHRIL_INGOT,    weight =  81 }, -- Mythril Ingot
            { item = xi.item.MOONSTONE,        weight =  56 }, -- Moonstone
            { item = xi.item.PAINITE,          weight = 195 }, -- Painite
            { item = xi.item.STEEL_INGOT,      weight =  58 }, -- Steel Ingot
            { item = xi.item.SUNSTONE,         weight =  38 }, -- Sunstone
            { item = xi.item.TRANSLUCENT_ROCK, weight =  11 }, -- Translucent Rock
            { item = xi.item.VILE_ELIXIR_P1,   weight =  21 }, -- Vile Elixir +1
            { item = xi.item.YELLOW_ROCK,      weight =  15 }, -- Yellow Rock
            { item = xi.item.ZIRCON,           weight =  26 }, -- Zircon
            { item = xi.item.RED_ROCK,         weight =  21 }, -- Red Rock
            { item = xi.item.MAHOGANY_LOG,     weight =  17 }, -- Mahogany Log
            { item = xi.item.BLUE_ROCK,        weight =   9 }, -- Blue Rock
            { item = xi.item.FLUORITE,         weight =  62 }, -- Fluorite
            { item = xi.item.PURPLE_ROCK,      weight =  11 }, -- Purple Rock
            { item = xi.item.BLACK_ROCK,       weight =  11 }, -- Black Rock
            { item = xi.item.GREEN_ROCK,       weight =  11 }, -- Green Rock
            { item = xi.item.WHITE_ROCK,       weight =   9 }, -- White Rock
        },

        {
            { item = xi.item.NONE,         weight =  932 }, -- Nothing
            { item = xi.item.KRAKEN_CLUB,  weight =   13 }, -- Kraken Club
            { item = xi.item.WALKURE_MASK, weight =   55 }, -- Walkure Mask
        },
    })

        -- KSNM Copycat
    setBattlefieldLoot(xi.battlefield.id.COPYCAT, {
        {
            { item =   655, weight = 1000 }, -- Adaman Ingot
        },
        {
            { item =  1474, weight = 1000 }, -- Infinity Core (custom drop)
        },
        {
            { item =   557, weight =  250 }, -- Ahriman Lens
            { item =   935, weight =  250 }, -- Ahriman Wing
            { item = 19025, weight =   50 }, -- Pole Grip
            { item = 19024, weight =   15 }, -- Sword Strap
            { item = 19026, weight =  250 }, -- Spear Strap
        },
        {
            { item = 17275, weight =  250 }, -- Coffinmaker
            { item = 17509, weight =  250 }, -- Destroyers
            { item = 17207, weight =  250 }, -- Expunger
            { item = 17944, weight =  250 }, -- Retributor
        },
        {
            { item = 14762, weight =  250 }, -- Atillas Earring
            { item = 17700, weight =  250 }, -- Durandal
            { item = 18006, weight =  250 }, -- Hoplites Harpe
            { item = 17842, weight =  250 }, -- Sorrowful Harpe
        },
        {
            { item = 15327, weight =  550 }, -- Fuma Sune-ate
            { item =   646, weight =  200 }, -- Chunk of Adaman Ore
            { item =   747, weight =  250 }, -- Orichalcum Ingot
        },
        {
            { item =   887, weight =   50 }, -- Coral Fragment
            { item =   645, weight =   50 }, -- Chunk of Darksteel Ore
            { item =   902, weight =   50 }, -- Demon Horn
            { item =   702, weight =   50 }, -- Ebony Log
            { item =   737, weight =   50 }, -- Chunk of Gold Ore
            { item =   823, weight =   50 }, -- Spool of Gold Thread
            { item =  4173, weight =   50 }, -- Hi-Reraiser
            { item =   738, weight =   50 }, -- Chunk of Platinum Ore
            { item =   700, weight =   50 }, -- Mahogany Log
            { item =   837, weight =   50 }, -- Spool of Malboro Fiber
            { item =   644, weight =   50 }, -- Chunk of Mythril Ore
            { item =   703, weight =   50 }, -- Petrified Log
            { item =   830, weight =   50 }, -- Square of Rainbow Cloth
            { item =   895, weight =   50 }, -- Ram Horn
            { item =  1132, weight =   50 }, -- Square of Raxa
            { item =  4172, weight =   50 }, -- Reraiser
            { item =  4174, weight =   50 }, -- Vile Elixier
            { item =  4175, weight =   50 }, -- Vile Elixir +1
            { item =  2142, weight =   50 }, -- Wailing Ram Horn
            { item =  866,  weight =   50 }, -- Handful of Wyvern Scales
            { item =  942,  weight =   50 }, -- Philosophers Stone
        },
        {
            { item = 1110,  weight =   50 }, -- Vial of Black Beetle Blood
            { item =  836,  weight =   50 }, -- Square of Damascene Cloth
            { item =  658,  weight =   50 }, -- Damascus Ingot
            { item =  837,  weight =   50 }, -- Spool of Malboro Fiber
            { item =  942,  weight =  300 }, -- Philosophers Stone
            { item =  844,  weight =  300 }, -- Phoenix Feather
            { item =  1132, weight =  200 }, -- Square of Raxa
        },
    })

    -- KSNM Operation Desert Swarm
    setBattlefieldLoot(xi.battlefield.id.OPERATION_DESERT_SWARM, {
        {
            { item =  1474, weight = 1000 }, -- Infinity Core (custom drop)
        },

        {
            { item =  1473, weight =  813 }, -- High-quality Scorpion Shell
            { item = 13552, weight =   55 }, -- Serket Ring
            { item =   901, weight =  123 }, -- Venomous Claw
        },

        {
            { item = 17207, weight = 216 }, -- Expunger
            { item = 18005, weight = 295 }, -- Heart Snatcher
            { item = 18217, weight = 239 }, -- Rampager
            { item = 17793, weight = 231 }, -- Senjuinrikio
        },

        {
            { item = xi.item.ANUBISS_KNIFE,    weight = 504 }, -- Anubiss Knife
            { item = xi.item.ADAMAN_INGOT,     weight =   4 }, -- Adaman Ingot
            { item = xi.item.CLAYMORE_GRIP,    weight =  86 }, -- Claymore Grip
            { item = xi.item.ORICHALCUM_INGOT, weight =  22 }, -- Orichalcum Ingot
            { item = xi.item.POLE_GRIP,        weight = 146 }, -- Pole Grip
            { item = xi.item.SWORD_STRAP,      weight =  22 }, -- Sword Strap
        },

        {
            { item = 11287, weight =  50 }, -- Antares Harness (custom drop)
            { item = 15295, weight = 287 }, -- Hierarch Belt
            { item = 12407, weight = 216 }, -- Palmerins Shield
            { item = 14871, weight = 198 }, -- Trainers Gloves
            { item = 15294, weight = 287 }, -- Warwolf Belt
        },

        {
            { item = xi.item.CORAL_FRAGMENT,           weight =  52 }, -- Coral Fragment
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,   weight =  56 }, -- Chunk Of Darksteel Ore
            { item = xi.item.DEMON_HORN,               weight =  41 }, -- Demon Horn
            { item = xi.item.EBONY_LOG,                weight =  63 }, -- Ebony Log
            { item = xi.item.CHUNK_OF_GOLD_ORE,        weight =  52 }, -- Chunk Of Gold Ore
            { item = xi.item.SPOOL_OF_GOLD_THREAD,     weight =  26 }, -- Spool Of Gold Thread
            { item = xi.item.SLAB_OF_GRANITE,          weight =  11 }, -- Slab Of Granite
            { item = xi.item.HI_RERAISER,              weight =  37 }, -- Hi-reraiser
            { item = xi.item.MAHOGANY_LOG,             weight = 101 }, -- Mahogany Log
            { item = xi.item.MYTHRIL_INGOT,            weight =   0 }, -- Mythril Ingot
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,     weight =  52 }, -- Chunk Of Mythril Ore
            { item = xi.item.PETRIFIED_LOG,            weight = 116 }, -- Petrified Log
            { item = xi.item.PHOENIX_FEATHER,          weight =  15 }, -- Phoenix Feather
            { item = xi.item.PHILOSOPHERS_STONE,       weight =  56 }, -- Philosophers Stone
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,    weight =  45 }, -- Chunk Of Platinum Ore
            { item = xi.item.SQUARE_OF_RAINBOW_CLOTH,  weight =  22 }, -- Square Of Rainbow Cloth
            { item = xi.item.RAM_HORN,                 weight =  67 }, -- Ram Horn
            { item = xi.item.SQUARE_OF_RAXA,           weight = 119 }, -- Square Of Raxa
            { item = xi.item.RERAISER,                 weight =  45 }, -- Reraiser
            { item = xi.item.VILE_ELIXIR,              weight =  19 }, -- Vile Elixir
            { item = xi.item.VILE_ELIXIR_P1,           weight =  41 }, -- Vile Elixir +1
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  34 }, -- Handful Of Wyvern Scales
        },

        {
            { item = xi.item.VIAL_OF_BLACK_BEETLE_BLOOD, weight =  78 }, -- Vial Of Black Beetle Blood
            { item = xi.item.SQUARE_OF_DAMASCENE_CLOTH,  weight =  56 }, -- Square Of Damascene Cloth
            { item = xi.item.DAMASCUS_INGOT,             weight =  93 }, -- Damascus Ingot
            { item = xi.item.SPOOL_OF_MALBORO_FIBER,     weight =  56 }, -- Spool Of Malboro Fiber
            { item = xi.item.PHILOSOPHERS_STONE,         weight = 157 }, -- Philosophers Stone
            { item = xi.item.PHOENIX_FEATHER,            weight = 276 }, -- Phoenix Feather
            { item = xi.item.SQUARE_OF_RAXA,             weight = 209 }, -- Square Of Raxa
        },
    })

    -- KSNM Prehistoric Pigeons
    setBattlefieldLoot(xi.battlefield.id.PREHISTORIC_PIGEONS, {
        {
            { item = xi.item.MICHISHIBA_NO_TSUYU, weight = 217 }, -- Michishiba-no-tsuyu
            { item = xi.item.DISSECTOR,           weight = 174 }, -- Dissector
            { item = xi.item.COFFINMAKER,         weight = 333 }, -- Coffinmaker
            { item = xi.item.GRAVEDIGGER,         weight = 174 }, -- Gravedigger
        },

        {
            { item = xi.item.CLAYMORE_GRIP,    weight = 144 }, -- Claymore Grip
            { item = xi.item.DAMASCUS_INGOT,   weight = 275 }, -- Damascus Ingot
            { item = xi.item.GIANT_BIRD_PLUME, weight = 275 }, -- Giant Bird Plume
            { item = xi.item.POLE_GRIP,        weight = 203 }, -- Pole Grip
            { item = xi.item.SPEAR_STRAP,      weight = 116 }, -- Spear Strap
        },

        {
            { item = xi.item.ADAMAN_INGOT,     weight = 159 }, -- Adaman Ingot
            { item = xi.item.ORICHALCUM_INGOT, weight = 290 }, -- Orichalcum Ingot
            { item = xi.item.TITANIS_EARRING,  weight = 406 }, -- Titanis Earring
        },

        {
            { item = xi.item.EVOKERS_BOOTS,  weight = 159 }, -- Evokers Boots
            { item = xi.item.OSTREGER_MITTS, weight = 217 }, -- Ostreger Mitts
            { item = xi.item.PINEAL_HAT,     weight = 145 }, -- Pineal Hat
            { item = xi.item.TRACKERS_KECKS, weight = 159 }, -- Trackers Kecks
        },

        {
            { item = xi.item.CORAL_FRAGMENT,          weight = 101 }, -- Coral Fragment
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,  weight =  29 }, -- Chunk Of Darksteel Ore
            { item = xi.item.DEMON_HORN,              weight =  29 }, -- Demon Horn
            { item = xi.item.EBONY_LOG,               weight =  29 }, -- Ebony Log
            { item = xi.item.GOLD_INGOT,              weight = 101 }, -- Gold Ingot
            { item = xi.item.SPOOL_OF_GOLD_THREAD,    weight =  29 }, -- Spool Of Gold Thread
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,    weight =  29 }, -- Chunk Of Mythril Ore
            { item = xi.item.PETRIFIED_LOG,           weight =  58 }, -- Petrified Log
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,   weight =  14 }, -- Chunk Of Platinum Ore
            { item = xi.item.SQUARE_OF_RAINBOW_CLOTH, weight =  58 }, -- Square Of Rainbow Cloth
            { item = xi.item.RAM_HORN,                weight =  14 }, -- Ram Horn
            { item = xi.item.SQUARE_OF_RAXA,          weight = 159 }, -- Square Of Raxa
            { item = xi.item.SPOOL_OF_MALBORO_FIBER,  weight =  72 }, -- Spool Of Malboro Fiber
        },

        {
            { item = xi.item.VIAL_OF_BLACK_BEETLE_BLOOD, weight =  87 }, -- Vial Of Black Beetle Blood
            { item = xi.item.DAMASCUS_INGOT,             weight =  14 }, -- Damascus Ingot
            { item = xi.item.SQUARE_OF_DAMASCENE_CLOTH,  weight =  29 }, -- Square Of Damascene Cloth
            { item = xi.item.PHILOSOPHERS_STONE,         weight = 174 }, -- Philosophers Stone
            { item = xi.item.PHOENIX_FEATHER,            weight = 246 }, -- Phoenix Feather
            { item = xi.item.SQUARE_OF_RAXA,             weight = 159 }, -- Square Of Raxa
        },
    })
end)

return m
