-----------------------------------
-- Area: Horlais Peak
--  NPC: Armoury Crate
-----------------------------------
local m = Module:new("bf_horlais_loot")

local function setBattlefieldLoot(id, loot)
    if xi.battlefield.contents[id] == nil then
        print(fmt("[BCNM] Failed loot override for Horlais Peak ({}) - BCNM does not exist!", id))
        return
    end

    xi.battlefield.contents[id].loot = loot
end

m:addOverride('xi.server.onServerStart', function()
    super()

    -- BCNM Tails of Woe
    setBattlefieldLoot(xi.battlefield.id.TAILS_OF_WOE, {
        {
            { item = xi.item.BLITZ_RING, weight = 150 }, -- blitz Ring
            { item = xi.item.NONE,       weight = 850 }, -- Nothing
        },

        {
            { item = xi.item.AEGIS_RING,    weight = 300 }, -- aegis Ring
            { item = xi.item.TUNDRA_MANTLE, weight = 200 }, -- tundra mantle
            { item = xi.item.DRUIDS_ROPE,   weight = 200 }, -- druids rope
            { item = xi.item.NONE,          weight = 300 }, -- Nothing
        },

        {
            { item = xi.item.FIRE_SPIRIT_PACT,     weight = 145 }, -- firespirit
            { item = xi.item.SCROLL_OF_ERASE,      weight = 165 }, -- erase
            { item = xi.item.SCROLL_OF_PHALANX,    weight = 140 }, -- phalanx
            { item = xi.item.SCROLL_OF_ABSORB_STR, weight = 123 }, -- absorb-str
            { item = xi.item.PERIDOT,              weight =  94 }, -- peridot
            { item = xi.item.PEARL,                weight =  94 }, -- pearl
            { item = xi.item.GREEN_ROCK,           weight =  13 }, -- green rock
            { item = xi.item.AMETRINE,             weight =  53 }, -- ametrine
            { item = xi.item.GOLD_BEASTCOIN,       weight =  70 }, -- gold beastcoin
            { item = xi.item.MYTHRIL_BEASTCOIN,    weight =  50 }, -- mythril beastcoin
            { item = xi.item.YELLOW_ROCK,          weight =  53 }, -- yellow rock
            { item = xi.item.NONE,                 weight =   0 }, -- nothing
        },

        {
            { item = xi.item.SCROLL_OF_ERASE,      weight = 125 }, -- erase
            { item = xi.item.SCROLL_OF_PHALANX,    weight = 110 }, -- phalanx
            { item = xi.item.SCROLL_OF_ABSORB_STR, weight = 104 }, -- absorb-str
            { item = xi.item.PERIDOT,              weight =  94 }, -- peridot
            { item = xi.item.PEARL,                weight =  94 }, -- pearl
            { item = xi.item.GREEN_ROCK,           weight =  53 }, -- green rock
            { item = xi.item.AMETRINE,             weight =  73 }, -- ametrine
            { item = xi.item.GOLD_BEASTCOIN,       weight =  70 }, -- gold beastcoin
            { item = xi.item.MYTHRIL_BEASTCOIN,    weight =  70 }, -- mythril beastcoin
            { item = xi.item.YELLOW_ROCK,          weight =  73 }, -- yellow rock
            { item = xi.item.NONE,                 weight =  94 }, -- nothing
        },

        {
            { item = xi.item.FIRE_SPIRIT_PACT,      weight = 174 }, -- firespirit
            { item = xi.item.SCROLL_OF_ERASE,       weight =  16 }, -- vile elixir
            { item = xi.item.SCROLL_OF_PHALANX,     weight = 114 }, -- icespikes
            { item = xi.item.SCROLL_OF_ABSORB_STR,  weight = 174 }, -- refresh
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI, weight = 138 }, -- utsusemi ni
            { item = xi.item.GREEN_ROCK,            weight =  18 }, -- green rock
            { item = xi.item.BLACK_ROCK,            weight =  18 }, -- black rock
            { item = xi.item.BLUE_ROCK,             weight =  17 }, -- blue rock
            { item = xi.item.RED_ROCK,              weight =  16 }, -- red rock
            { item = xi.item.PURPLE_ROCK,           weight =  16 }, -- purple rock
            { item = xi.item.WHITE_ROCK,            weight =  16 }, -- white rock
            { item = xi.item.YELLOW_ROCK,           weight =  17 }, -- yellow rock
            { item = xi.item.TRANSLUCENT_ROCK,      weight =  17 }, -- translucent rock
            { item = xi.item.RERAISER,              weight =  21 }, -- reraiser
            { item = xi.item.OAK_LOG,               weight =  22 }, -- oak log
            { item = xi.item.ROSEWOOD_LOG,          weight =  18 }, -- rosewood log
            { item = xi.item.GOLD_BEASTCOIN,        weight = 120 }, -- gold beastcoin
            { item = xi.item.MYTHRIL_BEASTCOIN,     weight = 102 }, -- mythril beastcoin
            { item = xi.item.PEARL,                 weight =  21 }, -- pearl
            { item = xi.item.TURQUOISE,             weight =  23 }, -- Turquoise
            { item = xi.item.GOSHENITE,             weight =  19 }, -- Goshenite
            { item = xi.item.BLACK_PEARL,           weight =  18 }, -- Black pearl
            { item = xi.item.SPHENE,                weight =  17 }, -- sphene
            { item = xi.item.GARNET,                weight =  20 }, -- garnet
            { item = xi.item.AMETRINE,              weight =  18 }, -- ametrine
            { item = xi.item.NONE,                  weight =   0 }, -- nothing
        },

        {
            { item = xi.item.SCROLL_OF_PHALANX,     weight = 87 }, -- icespikes
            { item = xi.item.SCROLL_OF_ABSORB_STR,  weight = 75 }, -- refresh
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI, weight = 75 }, -- utsusemi ni
            { item = xi.item.OAK_LOG,               weight = 80 }, -- oak log
            { item = xi.item.ROSEWOOD_LOG,          weight = 97 }, -- rosewood log
            { item = xi.item.PEARL,                 weight = 86 }, -- pearl
            { item = xi.item.TURQUOISE,             weight = 88 }, -- Turquoise
            { item = xi.item.GOSHENITE,             weight = 79 }, -- Goshenite
            { item = xi.item.BLACK_PEARL,           weight = 93 }, -- Black pearl
            { item = xi.item.SPHENE,                weight = 79 }, -- sphene
            { item = xi.item.GARNET,                weight = 71 }, -- garnet
            { item = xi.item.AMETRINE,              weight = 90 }, -- ametrine
            { item = xi.item.NONE,                  weight =  0 }, -- nothing
        },
    })

    -- BCNM Dismemberment Brigade
    setBattlefieldLoot(xi.battlefield.id.DISMEMBERMENT_BRIGADE, {
        {
            { item = xi.item.KABRAKANS_AXE, weight = 250 }, -- kabrakans_axe
            { item = xi.item.SARNGA,        weight = 250 }, -- sarnga
            { item = xi.item.DRAGVANDIL,    weight = 250 }, -- dragvandil
            { item = xi.item.HAMELIN_FLUTE, weight = 250 }, -- hamelin_flute
        },

        {
            { item = xi.item.NONE,            weight = 400 }, -- nothing
            { item = xi.item.SPECTACLES,      weight = 200 }, -- spectacles
            { item = xi.item.ASSAULT_EARRING, weight = 200 }, -- assault_earring
            { item = xi.item.PEACE_RING,      weight = 200 }, -- peace_ring
        },

        {
            { item = xi.item.NONE,             weight = 200 }, -- nothing
            { item = xi.item.TRANSLUCENT_ROCK, weight = 200 }, -- translucent_rock
            { item = xi.item.GREEN_ROCK,       weight = 200 }, -- green_rock
            { item = xi.item.YELLOW_ROCK,      weight = 200 }, -- yellow_rock
            { item = xi.item.PURPLE_ROCK,      weight = 200 }, -- purple_rock
        },

        {
            { item = xi.item.PAINITE,         weight = 100 }, -- painite
            { item = xi.item.JADEITE,         weight = 100 }, -- jadeite
            { item = xi.item.MYTHRIL_INGOT,   weight = 100 }, -- mythril_ingot
            { item = xi.item.STEEL_INGOT,     weight = 100 }, -- steel_ingot
            { item = xi.item.FLUORITE,        weight = 100 }, -- fluorite
            { item = xi.item.GOLD_INGOT,      weight = 100 }, -- gold_ingot
            { item = xi.item.ZIRCON,          weight = 100 }, -- zircon
            { item = xi.item.CHRYSOBERYL,     weight = 100 }, -- chrysoberyl
            { item = xi.item.DARKSTEEL_INGOT, weight = 100 }, -- darksteel_ingot
            { item = xi.item.MOONSTONE,       weight = 100 }, -- moonstone
        },

        {
            { item = xi.item.NONE,           weight =  900 }, -- nothing
            { item = xi.item.VILE_ELIXIR_P1, weight =  100 }, -- vile_elixir_+1
        },
    })

    -- BCNM Hostile Herbivores
    setBattlefieldLoot(xi.battlefield.id.HOSTILE_HERBIVORES, {
        {
            { item = xi.item.NONE,         weight = 50 }, -- Nothing
            { item = xi.item.OCEAN_BELT,   weight = 95 }, -- Ocean Belt
            { item = xi.item.JUNGLE_BELT,  weight = 95 }, -- Jungle Belt
            { item = xi.item.STEPPE_BELT,  weight = 95 }, -- Steppe Belt
            { item = xi.item.DESERT_BELT,  weight = 95 }, -- Desert Belt
            { item = xi.item.FOREST_BELT,  weight = 95 }, -- Forest Belt
            { item = xi.item.OCEAN_STONE,  weight = 95 }, -- Ocean Stone
            { item = xi.item.JUNGLE_STONE, weight = 95 }, -- Jungle Stone
            { item = xi.item.STEPPE_STONE, weight = 95 }, -- Steppe Stone
            { item = xi.item.DESERT_STONE, weight = 95 }, -- Desert Stone
            { item = xi.item.FOREST_STONE, weight = 95 }, -- Forest Stone
        },

        {
            { item = xi.item.GUARDIANS_RING, weight = 64 }, -- Guardians Ring
            { item = xi.item.KAMPFER_RING,   weight = 65 }, -- Kampfer Ring
            { item = xi.item.CONJURERS_RING, weight = 65 }, -- Conjurers Ring
            { item = xi.item.SHINOBI_RING,   weight = 65 }, -- Shinobi Ring
            { item = xi.item.SLAYERS_RING,   weight = 65 }, -- Slayers Ring
            { item = xi.item.SORCERERS_RING, weight = 65 }, -- Sorcerers Ring
            { item = xi.item.SOLDIERS_RING,  weight = 64 }, -- Soldiers Ring
            { item = xi.item.TAMERS_RING,    weight = 65 }, -- Tamers Ring
            { item = xi.item.TRACKERS_RING,  weight = 64 }, -- Trackers Ring
            { item = xi.item.DRAKE_RING,     weight = 65 }, -- Drake Ring
            { item = xi.item.FENCERS_RING,   weight = 65 }, -- Fencers Ring
            { item = xi.item.MINSTRELS_RING, weight = 65 }, -- Minstrels Ring
            { item = xi.item.MEDICINE_RING,  weight = 64 }, -- Medicine Ring
            { item = xi.item.ROGUES_RING,    weight = 65 }, -- Rogues Ring
            { item = xi.item.RONIN_RING,     weight = 64 }, -- Ronin Ring
            { item = xi.item.PLATINUM_RING,  weight = 30 }, -- Platinum Ring
        },

        {
            { item = xi.item.NONE,                weight = 100 }, -- Nothing
            { item = xi.item.SCROLL_OF_QUAKE,     weight = 176 }, -- Scroll Of Quake
            { item = xi.item.LIGHT_SPIRIT_PACT,   weight =  10 }, -- Light Spirit Pact
            { item = xi.item.SCROLL_OF_FREEZE,    weight = 176 }, -- Scroll Of Freeze
            { item = xi.item.SCROLL_OF_REGEN_III, weight = 176 }, -- Scroll Of Regen Iii
            { item = xi.item.RERAISER,            weight =  60 }, -- Reraiser
            { item = xi.item.VILE_ELIXIR,         weight =  60 }, -- Vile Elixir
            { item = xi.item.SCROLL_OF_RAISE_II,  weight = 176 }, -- Scroll Of Raise Ii
        },

        {
            { item = xi.item.NONE,                weight = 100 }, -- Nothing
            { item = xi.item.SCROLL_OF_QUAKE,     weight = 176 }, -- Scroll Of Quake
            { item = xi.item.LIGHT_SPIRIT_PACT,   weight =  10 }, -- Light Spirit Pact
            { item = xi.item.SCROLL_OF_FREEZE,    weight = 176 }, -- Scroll Of Freeze
            { item = xi.item.SCROLL_OF_REGEN_III, weight = 176 }, -- Scroll Of Regen Iii
            { item = xi.item.RERAISER,            weight =  60 }, -- Reraiser
            { item = xi.item.VILE_ELIXIR,         weight =  60 }, -- Vile Elixir
            { item = xi.item.SCROLL_OF_RAISE_II,  weight = 176 }, -- Scroll Of Raise Ii
        },

        {
            { item = xi.item.RAM_HORN,                 weight =  59 }, -- Ram Horn
            { item = xi.item.MAHOGANY_LOG,             weight =  59 }, -- Mahogany Log
            { item = xi.item.MYTHRIL_INGOT,            weight = 200 }, -- Mythril Ingot
            { item = xi.item.MANTICORE_HIDE,           weight =  59 }, -- Manticore Hide
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  90 }, -- Handful Of Wyvern Scales
            { item = xi.item.WYVERN_SKIN,              weight =  90 }, -- Wyvern Skin
            { item = xi.item.PETRIFIED_LOG,            weight = 176 }, -- Petrified Log
            { item = xi.item.DARKSTEEL_INGOT,          weight =  59 }, -- Darksteel Ingot
            { item = xi.item.RAM_SKIN,                 weight =  59 }, -- Ram Skin
            { item = xi.item.PLATINUM_INGOT,           weight =  90 }, -- Platinum Ingot
        },

        {
            { item = xi.item.NONE,                     weight = 100 }, -- Nothing
            { item = xi.item.RAM_HORN,                 weight =  59 }, -- Ram Horn
            { item = xi.item.MAHOGANY_LOG,             weight =  59 }, -- Mahogany Log
            { item = xi.item.MYTHRIL_INGOT,            weight = 200 }, -- Mythril Ingot
            { item = xi.item.MANTICORE_HIDE,           weight =  59 }, -- Manticore Hide
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  90 }, -- Handful Of Wyvern Scales
            { item = xi.item.WYVERN_SKIN,              weight =  90 }, -- Wyvern Skin
            { item = xi.item.PETRIFIED_LOG,            weight = 176 }, -- Petrified Log
            { item = xi.item.DARKSTEEL_INGOT,          weight =  59 }, -- Darksteel Ingot
            { item = xi.item.RAM_SKIN,                 weight =  59 }, -- Ram Skin
            { item = xi.item.PLATINUM_INGOT,           weight =  90 }, -- Platinum Ingot
        },
    })

    -- BCNM Carapace Combatants
    setBattlefieldLoot(xi.battlefield.id.CARAPACE_COMBATANTS, {
        {
            { item = xi.item.BEETLE_JAW, weight = 1000 }, -- beetle_jaw
        },

        {
            { item = xi.item.BEETLE_SHELL, weight = 1000 }, -- beetle_shell
        },

        {
            { item = xi.item.NONE,        weight = 250 }, -- nothing
            { item = xi.item.KATANA_OBI,  weight = 150 }, -- katana_obi
            { item = xi.item.STAFF_BELT,  weight = 150 }, -- staff_belt
            { item = xi.item.SONG_BELT,   weight = 150 }, -- song_belt
            { item = xi.item.CESTUS_BELT, weight = 150 }, -- cestus_belt
            { item = xi.item.PICK_BELT,   weight = 150 }, -- pick_belt
        },

        {
            { item = xi.item.NONE,              weight = 125 }, -- nothing
            { item = xi.item.GENIN_EARRING,     weight = 125 }, -- genin_earring
            { item = xi.item.MAGICIANS_EARRING, weight = 125 }, -- magicians_earring
            { item = xi.item.PILFERERS_EARRING, weight = 125 }, -- pilferers_earring
            { item = xi.item.WARLOCKS_EARRING,  weight = 125 }, -- warlocks_earring
            { item = xi.item.WRESTLERS_EARRING, weight = 125 }, -- wrestlers_earring
            { item = xi.item.WYVERN_EARRING,    weight = 125 }, -- wyvern_earring
            { item = xi.item.KILLER_EARRING,    weight = 125 }, -- killer_earring
        },

        {
            { item = xi.item.NONE,                   weight = 160 }, -- nothing
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE, weight = 140 }, -- chunk_of_darksteel_ore
            { item = xi.item.MYTHRIL_INGOT,          weight = 140 }, -- mythril_ingot
            { item = xi.item.SILVER_INGOT,           weight = 140 }, -- silver_ingot
            { item = xi.item.STEEL_INGOT,            weight = 140 }, -- steel_ingot
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,   weight = 140 }, -- chunk_of_mythril_ore
            { item = xi.item.SARDONYX,               weight = 140 }, -- sardonyx
        },

        {
            { item = xi.item.NONE,                   weight = 250 }, -- nothing
            { item = xi.item.SCROLL_OF_DISPEL,       weight = 125 }, -- scroll_of_dispel
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI,  weight = 125 }, -- scroll_of_utsusemi_ni
            { item = xi.item.SCROLL_OF_FIRE_II,      weight = 125 }, -- scroll_of_fire_ii
            { item = xi.item.SCROLL_OF_MAGIC_FINALE, weight = 125 }, -- scroll_of_magic_finale
            { item = xi.item.SCROLL_OF_ABSORB_AGI,   weight = 125 }, -- scroll_of_absorb-agi
            { item = xi.item.SCROLL_OF_ABSORB_INT,   weight = 125 }, -- scroll_of_absorb-int
        },

        {
            { item = xi.item.NONE,               weight = 500 }, -- nothing
            { item = xi.item.JUG_OF_SCARLET_SAP, weight = 500 }, -- jug_of_scarlet_sap
        },

        {
            { item = xi.item.NONE,               weight = 750 }, -- nothing
            { item = xi.item.JUG_OF_SCARLET_SAP, weight = 250 }, -- jug_of_scarlet_sap
        },

        {
            { item = xi.item.NONE,     weight = 900 }, -- nothing
            { item = xi.item.HI_ETHER, weight = 100 }, -- hi-ether
        },
    })

    -- BCNM Shooting Fish
    setBattlefieldLoot(xi.battlefield.id.SHOOTING_FISH, {
        {
            { item = xi.item.MANNEQUIN_HEAD, weight = 1000 }, -- mannequin_head
        },

        {
            { item = xi.item.SHALL_SHELL, weight = 1000 }, -- shall_shell
        },

        {
            { item = xi.item.BLACK_ROCK,        weight = 125 }, -- black_rock
            { item = xi.item.PURPLE_ROCK,       weight = 125 }, -- purple_rock
            { item = xi.item.WHITE_ROCK,        weight = 125 }, -- white_rock
            { item = xi.item.GREEN_ROCK,        weight = 125 }, -- green_rock
            { item = xi.item.YELLOW_ROCK,       weight = 125 }, -- yellow_rock
            { item = xi.item.BLUE_ROCK,         weight = 125 }, -- blue_rock
            { item = xi.item.RED_ROCK,          weight = 125 }, -- red_rock
            { item = xi.item.TRANSLUCENT_ROCK,  weight = 125 }, -- translucent_rock
        },

        {
            quantity = 2,
            { item = xi.item.NONE,              weight = 200 }, -- nothing

            { item = xi.item.PLATOON_CESTI,     weight = 100 }, -- platoon_cesti
            { item = xi.item.PLATOON_CUTTER,    weight = 100 }, -- platoon_cutter
            { item = xi.item.PLATOON_SPATHA,    weight = 100 }, -- platoon_spatha
            { item = xi.item.PLATOON_ZAGHNAL,   weight = 100 }, -- platoon_zaghnal

            { item = xi.item.PLATOON_BOW,       weight = 100 }, -- platoon_bow
            { item = xi.item.PLATOON_MACE,      weight = 100 }, -- platoon_mace
            { item = xi.item.PLATOON_DISC,      weight = 100 }, -- platoon_disc
            { item = xi.item.PLATOON_GUN,       weight = 100 }, -- platoon_gun
        },

        {
            { item = xi.item.NONE,                    weight = 200 }, -- nothing
            { item = xi.item.MYTHRIL_BEASTCOIN,       weight = 200 }, -- mythril_beastcoin
            { item = xi.item.HANDFUL_OF_PUGIL_SCALES, weight = 200 }, -- handful_of_pugil_scales
            { item = xi.item.SHALL_SHELL,             weight = 200 }, -- shall_shell
            { item = xi.item.MANNEQUIN_BODY,          weight = 200 }, -- mannequin_body
        },

        {
            { item = xi.item.SCROLL_OF_BLAZE_SPIKES,  weight = 250 }, -- scroll_of_blaze_spikes
            { item = xi.item.SCROLL_OF_HORDE_LULLABY, weight = 250 }, -- scroll_of_horde_lullaby
            { item = xi.item.THUNDER_SPIRIT_PACT,     weight = 250 }, -- thunder_spirit_pact
            { item = xi.item.SCROLL_OF_WARP,          weight = 250 }, -- scroll_of_warp
        },
    })

    -- BCNM Dropping Like Flies
    setBattlefieldLoot(xi.battlefield.id.DROPPING_LIKE_FLIES, {
        {
            { item = xi.item.GIL, weight = 1000, amount = 4000 }, -- Gil
        },

        {
            { item = xi.item.INSECT_WING, weight = 1000 }, -- Insect Wing
        },

        {
            { item = xi.item.MANNEQUIN_HEAD, weight = 1000 }, -- Mannequin Head
        },

        {
            { item = xi.item.NONE,            weight = 636 }, -- Nothing
            { item = xi.item.EMPEROR_HAIRPIN, weight = 364 }, -- Emperor Hairpin
        },

        {
            { item = xi.item.ASHIGARU_TARGE,  weight = 175 }, -- Ashigaru Targe
            { item = xi.item.BEATERS_ASPIS,   weight = 175 }, -- Beaters Aspis
            { item = xi.item.VARLETS_TARGE,   weight = 175 }, -- Varlets Targe
            { item = xi.item.WRESTLERS_ASPIS, weight = 175 }, -- Wrestlers Aspis
            { item = xi.item.CLEAR_TOPAZ,     weight = 100 }, -- Clear Topaz
            { item = xi.item.LAPIS_LAZULI,    weight = 100 }, -- Lapis Lazuli
            { item = xi.item.LIGHT_OPAL,      weight = 100 }, -- Light Opal
        },

        {
            { item = xi.item.MERCENARY_MANTLE, weight = 250 }, -- Mercenary Mantle
            { item = xi.item.SINGERS_MANTLE,   weight = 250 }, -- Singers Mantle
            { item = xi.item.WIZARDS_MANTLE,   weight = 250 }, -- Wizards Mantle
            { item = xi.item.WYVERN_MANTLE,    weight = 250 }, -- Wyvern Mantle
        },

        {
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI,   weight =  70 }, -- Scroll Of Utsusemi Ni
            { item = xi.item.SCROLL_OF_MAGIC_FINALE,  weight =  70 }, -- Scroll Of Magic Finale
            { item = xi.item.JUG_OF_QUADAV_BUG_BROTH, weight = 150 }, -- Jug Of Quadav Bug Broth
            { item = xi.item.ONYX,                    weight = 100 }, -- Onyx
            { item = xi.item.LAPIS_LAZULI,            weight = 100 }, -- Lapis Lazuli
            { item = xi.item.LIGHT_OPAL,              weight = 100 }, -- Light Opal
            { item = xi.item.SCROLL_OF_DISPEL,        weight = 150 }, -- Scroll Of Dispel
            { item = xi.item.SCROLL_OF_ERASE,         weight = 100 }, -- Scroll Of Erase
            { item = xi.item.ELM_LOG,                 weight =  90 }, -- Elm Log
            { item = xi.item.MANNEQUIN_BODY,          weight =  70 }, -- Mannequin Body
        },
    })

    -- KSNM Horns of War
    setBattlefieldLoot(xi.battlefield.id.HORNS_OF_WAR, {
        {
            { item = 13566, weight =  50 }, -- Defending Ring (custom drop)
            { item =  1441, weight = 169 }, -- Libation Abjuration
            { item = 17939, weight = 268 }, -- Kriegsbeil
            { item = 17823, weight =  99 }, -- Shinsoku
            { item = 18173, weight =  85 }, -- Nokizaru Shuriken
            { item = 17694, weight =  70 }, -- Guespiere
            { item = 17464, weight =  85 }, -- Purgatory Mace
            { item = 18351, weight = 225 }, -- Meteor Cesti
        },

        {
            { item = xi.item.OBLATION_ABJURATION, weight = 169 }, -- Oblation Abjuration
            { item = xi.item.UNSHO,               weight =  14 }, -- Unsho
            { item = xi.item.HARLEQUINS_HORN,     weight = 239 }, -- Harlequins Horn
            { item = xi.item.DREIZACK,            weight =  85 }, -- Dreizack
            { item = xi.item.GAWAINS_AXE,         weight = 254 }, -- Gawains Axe
            { item = xi.item.ZEN_POLE,            weight = 183 }, -- Zen Pole
            { item = xi.item.BAYARDS_SWORD,       weight  = 70 }, -- Bayards Sword
        },

        {
            { item = xi.item.PETRIFIED_LOG,           weight = 563 }, -- Petrified Log
            { item = xi.item.LACQUER_TREE_LOG,        weight = 296 }, -- Lacquer Tree Log
            { item = xi.item.SQUARE_OF_SHINING_CLOTH, weight =  14 }, -- Square Of Shining Cloth
            { item = xi.item.DIVINE_LOG,              weight = 141 }, -- Divine Log
        },

        {
            { item = xi.item.BEHEMOTH_HIDE, weight = 535 }, -- Behemoth Hide
            { item = xi.item.BEHEMOTH_HORN, weight = 366 }, -- Behemoth Horn
            { item = xi.item.HEALING_STAFF, weight =  48 }, -- Healing Staff
        },

        {
            { item = xi.item.DEMON_HORN,               weight =  99 }, -- Demon Horn
            { item = xi.item.PETRIFIED_LOG,            weight =  70 }, -- Petrified Log
            { item = xi.item.SQUARE_OF_RAXA,           weight =  70 }, -- Square Of Raxa
            { item = xi.item.SQUARE_OF_RAINBOW_CLOTH,  weight =  28 }, -- Square Of Rainbow Cloth
            { item = xi.item.HI_RERAISER,              weight = 113 }, -- Hi-reraiser
            { item = xi.item.PETRIFIED_LOG,            weight = 211 }, -- Petrified Log
            { item = xi.item.PHILOSOPHERS_STONE,       weight = 141 }, -- Philosophers Stone
            { item = xi.item.CHUNK_OF_GOLD_ORE,        weight =  56 }, -- Chunk Of Gold Ore
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,     weight =  85 }, -- Chunk Of Mythril Ore
            { item = xi.item.CORAL_FRAGMENT,           weight =  70 }, -- Coral Fragment
            { item = xi.item.MAHOGANY_LOG,             weight =  85 }, -- Mahogany Log
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  42 }, -- Handful Of Wyvern Scales
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,   weight =  42 }, -- Chunk Of Darksteel Ore
            { item = xi.item.RAM_HORN,                 weight =  70 }, -- Ram Horn
            { item = xi.item.EBONY_LOG,                weight =  85 }, -- Ebony Log
            { item = xi.item.RERAISER,                 weight =  28 }, -- Reraiser
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,    weight =  42 }, -- Chunk Of Platinum Ore
            { item = xi.item.VILE_ELIXIR,              weight =  42 }, -- Vile Elixir
            { item = xi.item.VILE_ELIXIR_P1,           weight =   7 }, -- Vile Elixir +1
        },

        {
            { item = xi.item.BEHEMOTH_TONGUE,  weight = 208 }, -- Behemoth Tongue
            { item = xi.item.BEHEMOTH_HORN,    weight = 296 }, -- Behemoth Horn
            { item = xi.item.STRENGTH_POTION,  weight = 155 }, -- Strength Potion
            { item = xi.item.DEXTERITY_POTION, weight =  70 }, -- Dexterity Potion
            { item = xi.item.AGILITY_POTION,   weight = 141 }, -- Agility Potion
            { item = xi.item.VITALITY_POTION,  weight = 113 }, -- Vitality Potion
        },

        {
            { item = 3342, weight = 1000 }, -- Savory Shank
        },

        {
            { item = xi.item.MIND_POTION,         weight = 169 }, -- Mind Potion
            { item = xi.item.INTELLIGENCE_POTION, weight =  70 }, -- Intelligence Potion
            { item = xi.item.CHARISMA_POTION,     weight = 113 }, -- Charisma Potion
            { item = xi.item.ICARUS_WING,         weight = 155 }, -- Icarus Wing
            { item = xi.item.ANGEL_LYRE,          weight = 254 }, -- Angel Lyre
            { item = xi.item.EMERALD,             weight =  99 }, -- Emerald
            { item = xi.item.SPINEL,              weight =  42 }, -- Spinel
            { item = xi.item.RUBY,                weight =  56 }, -- Ruby
            { item = xi.item.DIAMOND,             weight =  28 }, -- Diamond
        },

        {
            { item = xi.item.CORAL_FRAGMENT,           weight = 141 }, -- Coral Fragment
            { item = xi.item.SQUARE_OF_RAXA,           weight =  14 }, -- Square Of Raxa
            { item = xi.item.DEMON_HORN,               weight = 113 }, -- Demon Horn
            { item = xi.item.CHUNK_OF_GOLD_ORE,        weight =  28 }, -- Chunk Of Gold Ore
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,     weight =  85 }, -- Chunk Of Mythril Ore
            { item = xi.item.VILE_ELIXIR,              weight =  56 }, -- Vile Elixir
            { item = xi.item.RAM_HORN,                 weight =  28 }, -- Ram Horn
            { item = xi.item.PETRIFIED_LOG,            weight = 296 }, -- Petrified Log
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,    weight =  14 }, -- Chunk Of Platinum Ore
            { item = xi.item.MAHOGANY_LOG,             weight =  56 }, -- Mahogany Log
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  70 }, -- Handful Of Wyvern Scales
            { item = xi.item.SLAB_OF_GRANITE,          weight =  42 }, -- Slab Of Granite
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,   weight =  42 }, -- Chunk Of Darksteel Ore
            { item = xi.item.EBONY_LOG,                weight =  42 }, -- Ebony Log
            { item = xi.item.HI_RERAISER,              weight =  42 }, -- Hi-reraiser
            { item = xi.item.SPOOL_OF_GOLD_THREAD,     weight = 113 }, -- Spool Of Gold Thread
            { item = xi.item.SQUARE_OF_RAINBOW_CLOTH,  weight =  28 }, -- Square Of Rainbow Cloth
        },

        {
            { item = xi.item.SQUARE_OF_RAXA,             weight = 127 }, -- Square Of Raxa
            { item = xi.item.SPOOL_OF_MALBORO_FIBER,     weight =  56 }, -- Spool Of Malboro Fiber
            { item = xi.item.PHILOSOPHERS_STONE,         weight = 225 }, -- Philosophers Stone
            { item = xi.item.PHOENIX_FEATHER,            weight = 423 }, -- Phoenix Feather
            { item = xi.item.SQUARE_OF_DAMASCENE_CLOTH,  weight =  70 }, -- Square Of Damascene Cloth
            { item = xi.item.DAMASCUS_INGOT,             weight =  42 }, -- Damascus Ingot
            { item = xi.item.VIAL_OF_BLACK_BEETLE_BLOOD, weight =  85 }, -- Vial Of Black Beetle Blood
        },
    })

    -- BCNM Under Observation
    setBattlefieldLoot(xi.battlefield.id.UNDER_OBSERVATION, {
        {
            { item = xi.item.NONE,          weight = 910 }, -- Nothing
            { item = xi.item.PEACOCK_CHARM, weight =  90 }, -- Peacock Charm
        },

        {
            { item = xi.item.NONE,          weight = 467 }, -- Nothing
            { item = xi.item.BEHOURD_LANCE, weight =  48 }, -- Behourd Lance
            { item = xi.item.MUTILATOR,     weight =  61 }, -- Mutilator
            { item = xi.item.RAIFU,         weight =  46 }, -- Raifu
            { item = xi.item.TILT_BELT,     weight = 302 }, -- Tilt Belt
            { item = xi.item.TOURNEY_PATAS, weight =  76 }, -- Tourney Patas
        },

        {
            { item = xi.item.NONE,                  weight = 413 }, -- Nothing
            { item = xi.item.BUZZARD_TUCK,          weight =  42 }, -- Buzzard Tuck
            { item = xi.item.DE_SAINTRES_AXE,       weight =  77 }, -- De Saintres Axe
            { item = xi.item.GRUDGE_SWORD,          weight =  73 }, -- Grudge Sword
            { item = xi.item.MANTRA_BELT,           weight = 258 }, -- Mantra Belt
            { item = xi.item.SCROLL_OF_REFRESH,     weight =  68 }, -- Scroll Of Refresh
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI, weight =  55 }, -- Scroll Of Utsusemi Ni
            { item = xi.item.SCROLL_OF_ICE_SPIKES,  weight =  14 }, -- Scroll Of Ice Spikes
        },

        {
            { item = xi.item.SCROLL_OF_ICE_SPIKES,  weight = 114 }, -- Scroll Of Ice Spikes
            { item = xi.item.SCROLL_OF_REFRESH,     weight = 174 }, -- Scroll Of Refresh
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI, weight = 138 }, -- Scroll Of Utsusemi Ni
            { item = xi.item.RED_ROCK,              weight =  16 }, -- Red Rock
            { item = xi.item.BLUE_ROCK,             weight =  17 }, -- Blue Rock
            { item = xi.item.YELLOW_ROCK,           weight =  17 }, -- Yellow Rock
            { item = xi.item.GREEN_ROCK,            weight =  18 }, -- Green Rock
            { item = xi.item.TRANSLUCENT_ROCK,      weight =  17 }, -- Translucent Rock
            { item = xi.item.PURPLE_ROCK,           weight =  16 }, -- Purple Rock
            { item = xi.item.BLACK_ROCK,            weight =  18 }, -- Black Rock
            { item = xi.item.WHITE_ROCK,            weight =  16 }, -- White Rock
            { item = xi.item.MYTHRIL_BEASTCOIN,     weight = 102 }, -- Mythril Beastcoin
            { item = xi.item.GOLD_BEASTCOIN,        weight = 120 }, -- Gold Beastcoin
            { item = xi.item.OAK_LOG,               weight =  22 }, -- Oak Log
            { item = xi.item.AMETRINE,              weight =  18 }, -- Ametrine
            { item = xi.item.BLACK_PEARL,           weight =  18 }, -- Black Pearl
            { item = xi.item.GARNET,                weight =  20 }, -- Garnet
            { item = xi.item.GOSHENITE,             weight =  19 }, -- Goshenite
            { item = xi.item.PEARL,                 weight =  21 }, -- Pearl
            { item = xi.item.PERIDOT,               weight =  35 }, -- Peridot
            { item = xi.item.SPHENE,                weight =  17 }, -- Sphene
            { item = xi.item.TURQUOISE,             weight =  23 }, -- Turquoise
            { item = xi.item.RERAISER,              weight =  21 }, -- Reraiser
            { item = xi.item.VILE_ELIXIR,           weight =  16 }, -- Vile Elixir
        },

        {
            { item = xi.item.FIRE_SPIRIT_PACT,     weight = 116 }, -- Fire Spirit Pact
            { item = xi.item.SCROLL_OF_ABSORB_STR, weight = 113 }, -- Scroll Of Absorb-str
            { item = xi.item.SCROLL_OF_ERASE,      weight = 137 }, -- Scroll Of Erase
            { item = xi.item.SCROLL_OF_ICE_SPIKES, weight =  67 }, -- Scroll Of Ice Spikes
            { item = xi.item.SCROLL_OF_PHALANX,    weight =  99 }, -- Scroll Of Phalanx
            { item = xi.item.AMETRINE,             weight =  58 }, -- Ametrine
            { item = xi.item.BLACK_PEARL,          weight =  52 }, -- Black Pearl
            { item = xi.item.GARNET,               weight =  51 }, -- Garnet
            { item = xi.item.GOSHENITE,            weight =  65 }, -- Goshenite
            { item = xi.item.PEARL,                weight =  61 }, -- Pearl
            { item = xi.item.PERIDOT,              weight =  63 }, -- Peridot
            { item = xi.item.SPHENE,               weight =  55 }, -- Sphene
            { item = xi.item.TURQUOISE,            weight =  62 }, -- Turquoise
        },

        {
            { item = xi.item.HECTEYES_EYE, weight = 1000 }, -- Hecteyes Eye
        },

        {
            { item = xi.item.VIAL_OF_MERCURY, weight = 1000 }, -- Vial Of Mercury
        },
    })

    -- BCNM Eye of the Tiger
    setBattlefieldLoot(xi.battlefield.id.EYE_OF_THE_TIGER, {
        {
            { item = xi.item.BLACK_TIGER_FANG, weight = 1000 }, -- black_tiger_fang
        },

        {
            { item = xi.item.BLACK_TIGER_FANG, weight = 1000 }, -- black_tiger_fang
        },

        {
            { item = xi.item.NONE,     weight = 700 }, -- nothing
            { item = xi.item.NUE_FANG, weight = 300 }, -- nue_fang
        },

        {
            { item = xi.item.NONE,                    weight = 125 }, -- nothing
            { item = xi.item.IVORY_MITTS,             weight = 125 }, -- ivory_mitts
            { item = xi.item.SUPER_RIBBON,            weight = 125 }, -- super_ribbon
            { item = xi.item.MANA_CIRCLET,            weight = 125 }, -- mana_circlet
            { item = xi.item.RIVAL_RIBBON,            weight = 125 }, -- rival_ribbon
            { item = xi.item.SLY_GAUNTLETS,           weight = 125 }, -- sly_gauntlets
            { item = xi.item.SHOCK_MASK,              weight = 125 }, -- shock_mask
            { item = xi.item.SPIKED_FINGER_GAUNTLETS, weight = 125 }, -- spiked_finger_gauntlets
        },

        {
            { item = xi.item.INTELLECT_TORQUE, weight = 125 }, -- intellect_torque
            { item = xi.item.ESOTERIC_MANTLE,  weight = 125 }, -- esoteric_mantle
            { item = xi.item.TEMPLARS_MANTLE,  weight = 125 }, -- templars_mantle
            { item = xi.item.SNIPERS_MANTLE,   weight = 125 }, -- snipers_mantle
            { item = xi.item.HATEFUL_COLLAR,   weight = 125 }, -- hateful_collar
            { item = xi.item.STORM_GORGET,     weight = 125 }, -- storm_gorget
            { item = xi.item.HEAVY_MANTLE,     weight = 125 }, -- heavy_mantle
            { item = xi.item.BENIGN_NECKLACE,  weight = 125 }, -- benign_necklace
        },

        {
            { item = xi.item.NONE,           weight = 125 }, -- nothing
            { item = xi.item.GOLD_INGOT,     weight = 125 }, -- gold_ingot
            { item = xi.item.RAM_HORN,       weight = 125 }, -- ram_horn
            { item = xi.item.WYVERN_SKIN,    weight = 125 }, -- wyvern_skin
            { item = xi.item.EBONY_LOG,      weight = 125 }, -- ebony_log
            { item = xi.item.MYTHRIL_INGOT,  weight = 125 }, -- mythril_ingot
            { item = xi.item.RAM_SKIN,       weight = 125 }, -- ram_skin
            { item = xi.item.CORAL_FRAGMENT, weight = 125 }, -- coral_fragment
        },

        {
            { item = xi.item.NONE,                  weight = 400 }, -- nothing
            { item = xi.item.SLICE_OF_BUFFALO_MEAT, weight = 200 }, -- slice_of_buffalo_meat
            { item = xi.item.SLICE_OF_DRAGON_MEAT,  weight = 200 }, -- slice_of_dragon_meat
            { item = xi.item.SLICE_OF_COEURL_MEAT,  weight = 200 }, -- slice_of_coeurl_meat
        },

        {
            { item = xi.item.NONE,               weight = 625 }, -- nothing
            { item = xi.item.SCROLL_OF_FREEZE,   weight = 125 }, -- scroll_of_freeze
            { item = xi.item.SCROLL_OF_RAISE_II, weight = 125 }, -- scroll_of_raise_ii
            { item = xi.item.SCROLL_OF_QUAKE,    weight = 125 }, -- scroll_of_quake
        },
    })

    -- BCNM Shots in the Dark
    setBattlefieldLoot(xi.battlefield.id.SHOTS_IN_THE_DARK, {
        {
            { item = xi.item.GOLD_BEASTCOIN,    weight = 500 }, -- gold_beastcoin
            { item = xi.item.MYTHRIL_BEASTCOIN, weight = 500 }, -- mythril_beastcoin
        },

        {
            { item = xi.item.STEEL_INGOT, weight = 500 }, -- steel_ingot
            { item = xi.item.AQUAMARINE,  weight = 500 }, -- aquamarine
        },

        {
            { item = xi.item.NONE,         weight = 500 }, -- nothing
            { item = xi.item.DEMON_QUIVER, weight = 500 }, -- demon_quiver
        },

        {
            { item = xi.item.NONE,                weight = 600 }, -- nothing
            { item = xi.item.TELEPORT_RING_HOLLA, weight = 200 }, -- teleport_ring_holla
            { item = xi.item.TELEPORT_RING_VAHZL, weight = 200 }, -- teleport_ring_vahzl
        },

        {
            { item = xi.item.NONE,                weight = 600 }, -- nothing
            { item = xi.item.SAPIENT_CAPE,        weight = 200 }, -- sapient_cape
            { item = xi.item.TRAINERS_WRISTBANDS, weight = 200 }, -- trainers_wristbands
        },
    })

    -- KSNM Double Dragonian
    setBattlefieldLoot(xi.battlefield.id.DOUBLE_DRAGONIAN, {
        {
            { item = xi.item.SUBDUER,        weight = 222 }, -- Subduer
            { item = xi.item.DISSECTOR,      weight = 302 }, -- Dissector
            { item = xi.item.DESTROYERS,     weight = 245 }, -- Destroyers
            { item = xi.item.HEART_SNATCHER, weight = 208 }, -- Heart Snatcher
        },

        {
            { item = xi.item.NONE,                 weight = 638 }, -- Nothing
            { item = xi.item.VIAL_OF_DRAGON_BLOOD, weight =  10 }, -- Vial Of Dragon Blood
            { item = xi.item.DRAGON_HEART,         weight = 176 }, -- Dragon Heart
            { item = xi.item.SLICE_OF_DRAGON_MEAT, weight = 176 }, -- Slice Of Dragon Meat
        },

        {
            { item = xi.item.NONE,                 weight = 638 }, -- Nothing
            { item = xi.item.VIAL_OF_DRAGON_BLOOD, weight =  10 }, -- Vial Of Dragon Blood
            { item = xi.item.DRAGON_HEART,         weight = 176 }, -- Dragon Heart
            { item = xi.item.SLICE_OF_DRAGON_MEAT, weight = 176 }, -- Slice Of Dragon Meat
        },

        {
            { item = xi.item.NONE,        weight = 392 }, -- Nothing
            { item = xi.item.SPEAR_STRAP, weight = 354 }, -- Spear Strap
            { item = xi.item.SWORD_STRAP, weight = 165 }, -- Sword Strap
            { item = xi.item.POLE_GRIP,   weight =  89 }, -- Pole Grip
        },

        {
            { item = xi.item.MINUET_EARRING,   weight = 586 }, -- Minuet Earring
            { item = xi.item.ADAMAN_INGOT,     weight = 184 }, -- Adaman Ingot
            { item = xi.item.ORICHALCUM_INGOT, weight = 207 }, -- Orichalcum Ingot
        },

        {
            { item = xi.item.SORROWFUL_HARP,  weight = 238 }, -- Sorrowful Harp
            { item = xi.item.ATTILAS_EARRING, weight = 250 }, -- Attilas Earring
            { item = xi.item.DURANDAL,        weight = 225 }, -- Durandal
            { item = xi.item.HOPLITES_HARPE,  weight = 275 }, -- Hoplites Harpe
        },

        {
            { item = xi.item.CHUNK_OF_GOLD_ORE,        weight = 122 }, -- Chunk Of Gold Ore
            { item = xi.item.RERAISER,                 weight =  54 }, -- Reraiser
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,     weight =  41 }, -- Chunk Of Mythril Ore
            { item = xi.item.DEMON_HORN,               weight =  81 }, -- Demon Horn
            { item = xi.item.EBONY_LOG,                weight = 149 }, -- Ebony Log
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  54 }, -- Handful Of Wyvern Scales
            { item = xi.item.VILE_ELIXIR_P1,           weight =  27 }, -- Vile Elixir +1
            { item = xi.item.MAHOGANY_LOG,             weight =  41 }, -- Mahogany Log
            { item = xi.item.CORAL_FRAGMENT,           weight =  95 }, -- Coral Fragment
            { item = xi.item.PETRIFIED_LOG,            weight = 108 }, -- Petrified Log
            { item = xi.item.PHOENIX_FEATHER,          weight = 135 }, -- Phoenix Feather
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,    weight =  54 }, -- Chunk Of Platinum Ore
            { item = xi.item.RAM_HORN,                 weight =  14 }, -- Ram Horn
            { item = xi.item.SQUARE_OF_RAINBOW_CLOTH,  weight =  14 }, -- Square Of Rainbow Cloth
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,   weight =  68 }, -- Chunk Of Darksteel Ore
            { item = xi.item.HI_RERAISER,              weight =  14 }, -- Hi-reraiser
            { item = xi.item.SQUARE_OF_RAXA,           weight = 135 }, -- Square Of Raxa
        },

        {
            { item = xi.item.SQUARE_OF_DAMASCENE_CLOTH,  weight =  96 }, -- Square Of Damascene Cloth
            { item = xi.item.DAMASCUS_INGOT,             weight =  27 }, -- Damascus Ingot
            { item = xi.item.PHILOSOPHERS_STONE,         weight = 164 }, -- Philosophers Stone
            { item = xi.item.PHOENIX_FEATHER,            weight = 260 }, -- Phoenix Feather
            { item = xi.item.SPOOL_OF_MALBORO_FIBER,     weight =  96 }, -- Spool Of Malboro Fiber
            { item = xi.item.SQUARE_OF_RAXA,             weight = 288 }, -- Square Of Raxa
            { item = xi.item.VIAL_OF_BLACK_BEETLE_BLOOD, weight =  41 }, -- Vial Of Black Beetle Blood
        },
    })

    -- KSNM Today's Horoscope
    setBattlefieldLoot(xi.battlefield.id.TODAYS_HOROSCOPE, {
        {
            { item = 65535, weight = 1000, amount = 24000 }, -- Gil
        },
        {
            { item =  1474, weight = 1000 }, -- Infinity Core (custom drop)
        },
        {
            { item = 18053, weight =  222 }, -- Gravedigger
            { item = 18097, weight =  302 }, -- Gondo-Shizunori
            { item = 18217, weight =  245 }, -- Rampager
            { item = 17944, weight =  231 }, -- Retributor
        },
        {
            { item = 15295, weight = 250 }, -- Hierarch Belt
            { item = 15294, weight = 338 }, -- Warwolf Belt
            { item = 12407, weight = 206 }, -- Palmerin's Shield
            { item = 14871, weight = 206 }, -- Trainer's Gloves
        },
        {
            { item =     0, weight = 342 },   -- Nothing
            { item = 13693, weight = 250 },   -- Aries Mantle
            { item =   655, weight = 230 },   -- Adaman Ingot
            { item =   747, weight = 178 },   -- Orichalcum Ingot
        },
        {
            { item =   911, weight = 292 },   -- Rampaging Horn
            { item =   910, weight = 265 },   -- Lumbering Horn
            { item = 19024, weight = 354 }, -- Sword Strap
            { item = 19027, weight =  89 },  -- Claymore Grip
        },
        {
            { item =  737, weight = 109 },   -- Chunk Of Gold Ore
            { item = 4172, weight =  34 },   -- Reraiser
            { item =  644, weight =  41 },    -- Chunk Of Mythril Ore
            { item =  902, weight =  61 },    -- Demon Horn
            { item =  702, weight = 121 },   -- Ebony Log
            { item =  866, weight =  44 },    -- Handful Of Wyvern Scales
            { item = 4175, weight =  27 },   -- Vile Elixir +1
            { item =  700, weight =  41 },    -- Mahogany Log
            { item =  887, weight =  80 },    -- Coral Fragment
            { item =  703, weight =  72 },    -- Petrified Log
            { item =  844, weight = 111 },   -- Phoenix Feather
            { item =  738, weight =  44 },    -- Chunk Of Platinum Ore
            { item =  895, weight =  14 },    -- Ram Horn
            { item =  830, weight =  14 },    -- Square Of Rainbow Cloth
            { item =  645, weight =  68 },    -- Chunk Of Darksteel Ore
            { item = 4173, weight =  14 },   -- Hi-reraiser
            { item = 1132, weight = 105 },  -- Square Of Raxa
        },
        {
            { item =   0, weight =  150 },     -- Nothing
            { item =  836, weight =  90 },    -- Square Of Damascene Cloth
            { item =  658, weight =  29 },    -- Damascus Ingot
            { item =  942, weight = 148 },   -- Philosophers Stone
            { item =  844, weight = 234 },   -- Phoenix Feather
            { item =  837, weight =  76 },    -- Spool Of Malboro Fiber
            { item = 1132, weight = 232 },  -- Square Of Raxa
            { item = 1110, weight =  41 },   -- Vial Of Black Beetle Blood
        },
    })

    -- KSNM Contaminated Colosseum
    setBattlefieldLoot(xi.battlefield.id.CONTAMINATED_COLOSSEUM, {
        {
            { item = xi.item.SPOOL_OF_MALBORO_FIBER, weight = 1000 }, -- Spool Of Malboro Fiber
        },

        {
            { item = xi.item.MICHISHIBA_NO_TSUYU, weight = 217 }, -- Michishiba-no-tsuyu
            { item = xi.item.MORGENSTERN,         weight = 174 }, -- Morgenstern
            { item = xi.item.SENJUINRIKIO,        weight = 333 }, -- Senjuinrikio
            { item = xi.item.THYRSUSSTAB,         weight = 174 }, -- Thyrsusstab
        },

        {
            { item = xi.item.CASSIE_EARRING, weight = 101 }, -- Cassie Earring
            { item = xi.item.CLAYMORE_GRIP,  weight =  43 }, -- Claymore Grip
            { item = xi.item.MALBORO_VINE,   weight = 275 }, -- Malboro Vine
            { item = xi.item.MORBOLGER_VINE, weight = 275 }, -- Morbolger Vine
            { item = xi.item.POLE_GRIP,      weight = 203 }, -- Pole Grip
            { item = xi.item.SPEAR_STRAP,    weight = 116 }, -- Spear Strap
        },

        {
            { item = xi.item.ADAMAN_INGOT,     weight = 159 }, -- Adaman Ingot
            { item = xi.item.ORICHALCUM_INGOT, weight = 290 }, -- Orichalcum Ingot
            { item = xi.item.OSCAR_SCARF,      weight = 406 }, -- Oscar Scarf
        },

        {
            { item = xi.item.EVOKERS_BOOTS,  weight = 159 }, -- Evokers Boots
            { item = xi.item.OSTREGER_MITTS, weight = 217 }, -- Ostreger Mitts
            { item = xi.item.PINEAL_HAT,     weight = 145 }, -- Pineal Hat
            { item = xi.item.TRACKERS_KECKS, weight = 159 }, -- Trackers Kecks
        },

        {
            { item = xi.item.CORAL_FRAGMENT,           weight = 101 }, -- Coral Fragment
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,   weight =  29 }, -- Chunk Of Darksteel Ore
            { item = xi.item.DEMON_HORN,               weight =  29 }, -- Demon Horn
            { item = xi.item.EBONY_LOG,                weight =  29 }, -- Ebony Log
            { item = xi.item.CHUNK_OF_GOLD_ORE,        weight = 101 }, -- Chunk Of Gold Ore
            { item = xi.item.SPOOL_OF_GOLD_THREAD,     weight =  29 }, -- Spool Of Gold Thread
            { item = xi.item.SLAB_OF_GRANITE,          weight =  29 }, -- Slab Of Granite
            { item = xi.item.MAHOGANY_LOG,             weight =  43 }, -- Mahogany Log
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,     weight =  29 }, -- Chunk Of Mythril Ore
            { item = xi.item.PETRIFIED_LOG,            weight =  58 }, -- Petrified Log
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,    weight =  14 }, -- Chunk Of Platinum Ore
            { item = xi.item.SQUARE_OF_RAINBOW_CLOTH,  weight =  58 }, -- Square Of Rainbow Cloth
            { item = xi.item.RAM_HORN,                 weight =  14 }, -- Ram Horn
            { item = xi.item.VILE_ELIXIR,              weight =  58 }, -- Vile Elixir
            { item = xi.item.VILE_ELIXIR_P1,           weight =  29 }, -- Vile Elixir +1
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  72 }, -- Handful Of Wyvern Scales
        },

        {
            { item = xi.item.VIAL_OF_BLACK_BEETLE_BLOOD, weight =  87 }, -- Vial Of Black Beetle Blood
            { item = xi.item.DAMASCUS_INGOT,             weight =  14 }, -- Damascus Ingot
            { item = xi.item.SQUARE_OF_DAMASCENE_CLOTH,  weight =  29 }, -- Square Of Damascene Cloth
            { item = xi.item.SPOOL_OF_MALBORO_FIBER,     weight =  43 }, -- Spool Of Malboro Fiber
            { item = xi.item.PHILOSOPHERS_STONE,         weight = 174 }, -- Philosophers Stone
            { item = xi.item.PHOENIX_FEATHER,            weight = 246 }, -- Phoenix Feather
            { item = xi.item.SQUARE_OF_RAXA,             weight = 159 }, -- Square Of Raxa
        },
    })
end)

return m
