-----------------------------------
-- Area: Ghelsba Outpost
--  NPC: Armoury Crate
-----------------------------------
local m = Module:new("bf_ghelsba_outpost_loot")

local function setBattlefieldLoot(id, loot)
    if xi.battlefield.contents[id] == nil then
        print(fmt("[BCNM] Failed loot override for Ghelsba Outpost ({}) - BCNM does not exist!", id))
        return
    end

    xi.battlefield.contents[id].loot = loot
end

m:addOverride('xi.server.onServerStart', function()
    super()

    -- BCNM Steamed Sprouts
    setBattlefieldLoot(xi.battlefield.id.WINGS_OF_FURY, {
        {
            { item = xi.item.BAT_FANG, weight = 1000 }, -- Bat Fang
        },

        {
            { item = xi.item.THUNDER_SPIRIT_PACT, weight = 250 }, -- Thunder Spirit Pact
            { item = xi.item.SCROLL_OF_INVISIBLE, weight = 250 }, -- Scroll Of Invisible
            { item = xi.item.SCROLL_OF_SNEAK,     weight = 250 }, -- Scroll Of Sneak
            { item = xi.item.SCROLL_OF_DEODORIZE, weight = 250 }, -- Scroll Of Deodorize
        },

        {
            { item = xi.item.NONE,              weight = 250 }, -- nothing
            { item = xi.item.GANKO,             weight = 150 }, -- Ganko
            { item = xi.item.PLATOON_EDGE,      weight = 150 }, -- Platoon Edge
            { item = xi.item.PLATOON_AXE,       weight = 150 }, -- Platoon Axe
            { item = xi.item.PLATOON_POLE,      weight = 150 }, -- Platoon Pole
            { item = xi.item.PLATOON_DAGGER,    weight = 150 }, -- Platoon Dagger
        },
        {
            { item = xi.item.NONE,              weight = 250 }, -- nothing
            { item = xi.item.GUNROMARU,         weight = 150 }, -- Gunromaru
            { item = xi.item.PLATOON_DAGGER,    weight = 150 }, -- Platoon Dagger
            { item = xi.item.PLATOON_EDGE,      weight = 150 }, -- Platoon Edge
            { item = xi.item.PLATOON_LANCE,     weight = 150 }, -- Platoon Lance
            { item = xi.item.PLATOON_SWORD,     weight = 150 }, -- Platoon Sword
        },

        {
            { item = xi.item.TRANSLUCENT_ROCK,  weight = 125 }, -- Translucent Rock
            { item = xi.item.PURPLE_ROCK,       weight = 125 }, -- Purple Rock
            { item = xi.item.RED_ROCK,          weight = 125 }, -- Red Rock
            { item = xi.item.WHITE_ROCK,        weight = 125 }, -- White Rock
            { item = xi.item.BLACK_ROCK,        weight = 125 }, -- Black Rock
            { item = xi.item.GREEN_ROCK,        weight = 125 }, -- Green Rock
            { item = xi.item.YELLOW_ROCK,       weight = 125 }, -- Yellow Rock
            { item = xi.item.BLUE_ROCK,         weight = 125 }, -- Blue Rock
        },

        {
            { item = xi.item.NONE,              weight = 300 }, -- nothing
            { item = xi.item.ASTRAL_RING,       weight = 200 }, -- astral_ring
            { item = xi.item.MYTHRIL_BEASTCOIN, weight = 150 }, -- Mythril Beastcoin
            { item = xi.item.BAT_WING,          weight = 350 }, -- bat_wing
        },
    })
end)

return m
