-----------------------------------
-- Area: Boneyard Gully
--  NPC: Armoury Crate
-----------------------------------
local m = Module:new("bf_boneyard_gully")

local function setBattlefieldLoot(id, loot)
    if xi.battlefield.contents[id] == nil then
        print(fmt("[BCNM] Failed loot override for Boneyard Gully ({}) - BCNM does not exist!", id))
        return
    end

    xi.battlefield.contents[id].loot = loot
end

m:addOverride('xi.server.onServerStart', function()
    super()

    -----------------------------------
    -- ENM Like the Wind
    -----------------------------------
    setBattlefieldLoot(xi.battlefield.id.LIKE_THE_WIND, {
        {
            { item = xi.item.CLOUD_EVOKER,           weight = 160 }, -- Cloud Evoker
            { item = xi.item.POT_OF_VIRIDIAN_URUSHI, weight = 280 }, -- Viridian Urushi
            { item = xi.item.SQUARE_OF_GALATEIA,     weight = 280 }, -- Square of Galateia
            { item = xi.item.SQUARE_OF_KEJUSU_SATIN, weight = 280 }, -- Kejusu Satin
        },

        {
            quantity = 2,
            { item = xi.item.NONE,                    weight = 200 }, -- Nothing
            { item = xi.item.MANEATER,                weight = 200 }, -- Maneater
            { item = xi.item.WAGH_BAGHNAKHS,          weight = 200 }, -- Wagh Baghnakhs
            { item = xi.item.ONIMARU,                 weight = 200 }, -- Onimaru
            { item = xi.item.SCROLL_OF_ARMYS_PAEON_V, weight = 200 }, -- Army's Paeon V
        },
    })

    -----------------------------------
    -- ENM Sheep in Antlion's Clothing
    -----------------------------------
    setBattlefieldLoot(xi.battlefield.id.SHEEP_IN_ANTLIONS_CLOTHING, {
        {
            { item = xi.item.CLOUD_EVOKER,           weight = 160 }, -- Cloud Evoker
            { item = xi.item.POT_OF_VIRIDIAN_URUSHI, weight = 280 }, -- Viridian Urushi
            { item = xi.item.SQUARE_OF_GALATEIA,     weight = 280 }, -- Square of Galateia
            { item = xi.item.SQUARE_OF_KEJUSU_SATIN, weight = 280 }, -- Kejusu Satin
        },

        {
            { item = xi.item.HAGUN,            weight = 200 }, -- Hagun
            { item = xi.item.MARTIAL_AXE,      weight = 200 }, -- Martial Axe
            { item = xi.item.MARTIAL_WAND,     weight = 200 }, -- Martial Wand
            { item = xi.item.FORAGERS_MANTLE,  weight = 200 }, -- Forager's Mantle
            { item = xi.item.HARMONIAS_TORQUE, weight = 200 }, -- Harmonia's Torque
        },
    })

    -----------------------------------
    -- ENM Shell we Dance?
    -----------------------------------
    setBattlefieldLoot(xi.battlefield.id.SHELL_WE_DANCE, {
        {
            { item = xi.item.CLOUD_EVOKER,             weight = 160 }, -- Cloud Evoker
            { item = xi.item.PIECE_OF_CASSIA_LUMBER,   weight = 280 }, -- Cassia Lumber
            { item = xi.item.SQUARE_OF_ELTORO_LEATHER, weight = 280 }, -- Eltoro Leather
            { item = xi.item.DRAGON_BONE,              weight = 280 }, -- Dragon Bone
        },

        {
            quantity = 2,
            { item = xi.item.NONE,                    weight = 200 }, -- Nothing
            { item = xi.item.STONE_SPLITTER,          weight = 200 }, -- Stone Splitter
            { item = xi.item.FRENZY_FIFE,             weight = 200 }, -- Frenzy Fife
            { item = xi.item.BLAU_DOLCH,              weight = 200 }, -- Blau Dolch
            { item = xi.item.SCROLL_OF_ARMYS_PAEON_V, weight = 200 }, -- Army's Paeon V
        },
    })
end)

return m
