-----------------------------------
-- Area: Balgas Dais
--  NPC: Armoury Crate
-- Balgas Dais Burning Circle Armoury Crate
-----------------------------------
local m = Module:new("bf_balgas_loot")

local function setBattlefieldLoot(id, loot)
    if xi.battlefield.contents[id] == nil then
        print(fmt("[BCNM] Failed loot override for Balgais Dais ({}) - BCNM does not exist!", id))
        return
    end

    xi.battlefield.contents[id].loot = loot
end

m:addOverride('xi.server.onServerStart', function()
    super()

    -- BCNM Steamed Sprouts
    setBattlefieldLoot(xi.battlefield.id.STEAMED_SPROUTS, {
        {
            { item = xi.item.GOLD_BEASTCOIN,    weight = 500 }, -- gold_beastcoin
            { item = xi.item.MYTHRIL_BEASTCOIN, weight = 500 }, -- mythril_beastcoin
        },

        {
            { item = xi.item.NONE,        weight = 750 }, -- nothing
            { item = xi.item.VILE_ELIXIR, weight = 250 }, -- vile_elixir
        },

        {
            { item = xi.item.NONE,              weight = 600 }, -- nothing
            { item = xi.item.SURVIVAL_BELT,     weight = 100 }, -- survival_belt
            { item = xi.item.GUARDING_GORGET,   weight = 100 }, -- guarding_gorget
            { item = xi.item.ENHANCING_EARRING, weight = 100 }, -- enhancing_earring
            { item = xi.item.BALANCE_BUCKLER,   weight = 100 }, -- balance_buckler
        },

        {
            { item = xi.item.WHITE_ROCK,       weight = 125 }, -- white_rock
            { item = xi.item.TRANSLUCENT_ROCK, weight = 125 }, -- translucent_rock
            { item = xi.item.PURPLE_ROCK,      weight = 125 }, -- purple_rock
            { item = xi.item.RED_ROCK,         weight = 125 }, -- red_rock
            { item = xi.item.BLUE_ROCK,        weight = 125 }, -- blue_rock
            { item = xi.item.YELLOW_ROCK,      weight = 125 }, -- yellow_rock
            { item = xi.item.GREEN_ROCK,       weight = 125 }, -- green_rock
            { item = xi.item.BLACK_ROCK,       weight = 125 }, -- black_rock
        },

        {
            { item = xi.item.GARNET,       weight =  50 }, -- garnet
            { item = xi.item.BLACK_PEARL,  weight =  50 }, -- black_pearl
            { item = xi.item.AMETRINE,     weight =  50 }, -- ametrine
            { item = xi.item.PAINITE,      weight =  50 }, -- painite
            { item = xi.item.PEARL,        weight =  50 }, -- pearl
            { item = xi.item.OAK_LOG,      weight = 100 }, -- oak_log
            { item = xi.item.GOSHENITE,    weight = 100 }, -- goshenite
            { item = xi.item.SPHENE,       weight = 100 }, -- sphene
            { item = xi.item.ROSEWOOD_LOG, weight = 100 }, -- rosewood_log
            { item = xi.item.TURQUOISE,    weight = 100 }, -- turquoise
            { item = xi.item.SAPPHIRE,     weight = 100 }, -- sapphire
            { item = xi.item.PERIDOT,      weight = 150 }, -- peridot
        },

        {
            { item = xi.item.NONE,                  weight = 125 }, -- nothing
            { item = xi.item.SCROLL_OF_REFRESH,     weight = 125 }, -- scroll_of_refresh
            { item = xi.item.FIRE_SPIRIT_PACT,      weight = 125 }, -- fire_spirit_pact
            { item = xi.item.SCROLL_OF_ERASE,       weight = 125 }, -- scroll_of_erase
            { item = xi.item.SCROLL_OF_ABSORB_STR,  weight = 125 }, -- scroll_of_absorb-str
            { item = xi.item.SCROLL_OF_PHALANX,     weight = 125 }, -- scroll_of_phalanx
            { item = xi.item.SCROLL_OF_ICE_SPIKES,  weight = 125 }, -- scroll_of_ice_spikes
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI, weight = 125 }, -- scroll_of_utsusemi_ni
        },
    })

    -- BCNM Divine Punishers
    setBattlefieldLoot(xi.battlefield.id.DIVINE_PUNISHERS, {
        {
            { item = xi.item.FORSETIS_AXE, weight = 250 }, -- forsetis_axe
            { item = xi.item.ARAMISS_RAPIER, weight = 250 }, -- aramiss_rapier
            { item = xi.item.SPARTAN_CESTI, weight = 250 }, -- spartan_cesti
            { item = xi.item.DOMINION_MACE, weight = 250 }, -- dominion_mace
        },

        {
            { item = xi.item.NONE,             weight = 250 }, -- nothing
            { item = xi.item.FUMA_KYAHAN,      weight = 100 }, -- fuma_kyahan
            { item = xi.item.PEACE_RING,       weight = 200 }, -- peace_ring
            { item = xi.item.ENHANCING_MANTLE, weight = 200 }, -- enhancing_mantle
            { item = xi.item.MASTER_BELT,      weight = 150 }, -- master_belt
            { item = xi.item.OCHIUDOS_KOTE,    weight = 100 }, -- ochiudos_kote
        },

        {
            { item = xi.item.NONE,           weight = 850 }, -- nothing
            { item = xi.item.HI_RERAISER,    weight = 100 }, -- hi-reraiser
            { item = xi.item.VILE_ELIXIR_P1, weight =  50 }, -- vile_elixir_+1
        },

        {
            { item = xi.item.PURPLE_ROCK,      weight = 166 }, -- purple_rock
            { item = xi.item.TRANSLUCENT_ROCK, weight = 166 }, -- translucent_rock
            { item = xi.item.RED_ROCK,         weight = 167 }, -- red_rock
            { item = xi.item.BLACK_ROCK,       weight = 167 }, -- black_rock
            { item = xi.item.YELLOW_ROCK,      weight = 167 }, -- yellow_rock
            { item = xi.item.WHITE_ROCK,       weight = 167 }, -- white_rock
        },

        {
            { item = xi.item.PAINITE,     weight = 125 }, -- painite
            { item = xi.item.AQUAMARINE,  weight = 125 }, -- aquamarine
            { item = xi.item.FLUORITE,    weight = 125 }, -- fluorite
            { item = xi.item.ZIRCON,      weight = 125 }, -- zircon
            { item = xi.item.SUNSTONE,    weight = 125 }, -- sunstone
            { item = xi.item.CHRYSOBERYL, weight = 125 }, -- chrysoberyl
            { item = xi.item.MOONSTONE,   weight = 125 }, -- moonstone
            { item = xi.item.JADEITE,     weight = 125 }, -- jadeite
        },

        {
            { item = xi.item.NONE,         weight = 517 }, -- nothing
            { item = xi.item.MAHOGANY_LOG, weight = 333 }, -- mahogany_log
            { item = xi.item.EBONY_LOG,    weight = 150 }, -- ebony_log
        },

        {
            { item = xi.item.STEEL_INGOT,     weight = 350 }, -- steel_ingot
            { item = xi.item.MYTHRIL_INGOT,   weight = 150 }, -- mythril_ingot
            { item = xi.item.DARKSTEEL_INGOT, weight = 150 }, -- darksteel_ingot
            { item = xi.item.GOLD_INGOT,      weight = 350 }, -- gold_ingot
        },
    })

    -- BCNM Treasure and Tribulations
    setBattlefieldLoot(xi.battlefield.id.TREASURE_AND_TRIBULATIONS, {
        {
            { item = xi.item.GUARDIANS_RING, weight =  75 }, -- Guardians Ring
            { item = xi.item.KAMPFER_RING,   weight =  32 }, -- Kampfer Ring
            { item = xi.item.CONJURERS_RING, weight =  54 }, -- Conjurers Ring
            { item = xi.item.SHINOBI_RING,   weight =  32 }, -- Shinobi Ring
            { item = xi.item.SLAYERS_RING,   weight =  97 }, -- Slayers Ring
            { item = xi.item.SORCERERS_RING, weight =  75 }, -- Sorcerers Ring
            { item = xi.item.SOLDIERS_RING,  weight = 108 }, -- Soldiers Ring
            { item = xi.item.TAMERS_RING,    weight =  22 }, -- Tamers Ring
            { item = xi.item.TRACKERS_RING,  weight =  65 }, -- Trackers Ring
            { item = xi.item.DRAKE_RING,     weight =  32 }, -- Drake Ring
            { item = xi.item.FENCERS_RING,   weight =  32 }, -- Fencers Ring
            { item = xi.item.MINSTRELS_RING, weight =  86 }, -- Minstrels Ring
            { item = xi.item.MEDICINE_RING,  weight =  86 }, -- Medicine Ring
            { item = xi.item.ROGUES_RING,    weight =  75 }, -- Rogues Ring
            { item = xi.item.RONIN_RING,     weight =  11 }, -- Ronin Ring
            { item = xi.item.PLATINUM_RING,  weight =  32 }, -- Platinum Ring
        },

        {
            { item = xi.item.ASTRAL_RING,              weight = 376 }, -- Astral Ring
            { item = xi.item.PLATINUM_RING,            weight =  22 }, -- Platinum Ring
            { item = xi.item.SCROLL_OF_QUAKE,          weight =  65 }, -- Scroll Of Quake
            { item = xi.item.RAM_SKIN,                 weight =  10 }, -- Ram Skin
            { item = xi.item.RERAISER,                 weight =  11 }, -- Reraiser
            { item = xi.item.MYTHRIL_INGOT,            weight =  22 }, -- Mythril Ingot
            { item = xi.item.LIGHT_SPIRIT_PACT,        weight =  10 }, -- Light Spirit Pact
            { item = xi.item.SCROLL_OF_FREEZE,         weight =  32 }, -- Scroll Of Freeze
            { item = xi.item.SCROLL_OF_REGEN_III,      weight =  43 }, -- Scroll Of Regen Iii
            { item = xi.item.SCROLL_OF_RAISE_II,       weight =  32 }, -- Scroll Of Raise Ii
            { item = xi.item.PETRIFIED_LOG,            weight =  11 }, -- Petrified Log
            { item = xi.item.CORAL_FRAGMENT,           weight =  11 }, -- Coral Fragment
            { item = xi.item.MAHOGANY_LOG,             weight =  11 }, -- Mahogany Log
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,    weight =  43 }, -- Chunk Of Platinum Ore
            { item = xi.item.CHUNK_OF_GOLD_ORE,        weight = 108 }, -- Chunk Of Gold Ore
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,   weight =  32 }, -- Chunk Of Darksteel Ore
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,     weight =  65 }, -- Chunk Of Mythril Ore
            { item = xi.item.GOLD_INGOT,               weight =  10 }, -- Gold Ingot
            { item = xi.item.DARKSTEEL_INGOT,          weight =  11 }, -- Darksteel Ingot
            { item = xi.item.PLATINUM_INGOT,           weight =  11 }, -- Platinum Ingot
            { item = xi.item.EBONY_LOG,                weight =  11 }, -- Ebony Log
            { item = xi.item.RAM_HORN,                 weight =  11 }, -- Ram Horn
            { item = xi.item.DEMON_HORN,               weight =  11 }, -- Demon Horn
            { item = xi.item.MANTICORE_HIDE,           weight =   9 }, -- Manticore Hide
            { item = xi.item.WYVERN_SKIN,              weight =  11 }, -- Wyvern Skin
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  11 }, -- Handful Of Wyvern Scales
        },
    })

    -- BCNM Creeping Doom
    setBattlefieldLoot(xi.battlefield.id.CREEPING_DOOM, {
        {
            { item = xi.item.SPOOL_OF_SILK_THREAD, weight = 1000 }, -- spool_of_silk_thread
        },

        {
            { item = xi.item.GIL, weight = 1000, amount = 3000 }, -- gil
        },

        {
            { item = xi.item.NONE,                 weight = 700 }, -- nothing
            { item = xi.item.SPOOL_OF_SILK_THREAD, weight = 300 }, -- spool_of_silk_thread
        },

        {
            { item = xi.item.NONE,                 weight = 900 }, -- nothing
            { item = xi.item.SPOOL_OF_SILK_THREAD, weight = 100 }, -- spool_of_silk_thread
        },

        {
            { item = xi.item.NONE,               weight = 300 }, -- nothing
            { item = xi.item.SINGERS_EARRING,    weight =  40 }, -- singers_earring
            { item = xi.item.ASHIGARU_EARRING,   weight =  50 }, -- ashigaru_earring
            { item = xi.item.MAGICIANS_EARRING,  weight =  50 }, -- magicians_earring
            { item = xi.item.WARLOCKS_EARRING,   weight =  50 }, -- warlocks_earring
            { item = xi.item.HEALERS_EARRING,    weight =  40 }, -- healers_earring
            { item = xi.item.ESQUIRES_EARRING,   weight =  45 }, -- esquires_earring
            { item = xi.item.WIZARDS_EARRING,    weight =  50 }, -- wizards_earring
            { item = xi.item.WYVERN_EARRING,     weight =  40 }, -- wyvern_earring
            { item = xi.item.MERCENARYS_EARRING, weight =  50 }, -- mercenarys_earring
            { item = xi.item.KILLER_EARRING,     weight =  45 }, -- killer_earring
            { item = xi.item.WRESTLERS_EARRING,  weight =  45 }, -- wrestlers_earring
            { item = xi.item.GENIN_EARRING,      weight =  50 }, -- genin_earring
            { item = xi.item.BEATERS_EARRING,    weight =  50 }, -- beaters_earring
            { item = xi.item.PILFERERS_EARRING,  weight =  45 }, -- pilferers_earring
            { item = xi.item.TRIMMERS_EARRING,   weight =  50 }, -- trimmers_earring
        },

        {
            { item = xi.item.NONE,               weight = 700 }, -- nothing
            { item = xi.item.SINGERS_EARRING,    weight =  20 }, -- singers_earring
            { item = xi.item.ASHIGARU_EARRING,   weight =  20 }, -- ashigaru_earring
            { item = xi.item.MAGICIANS_EARRING,  weight =  20 }, -- magicians_earring
            { item = xi.item.WARLOCKS_EARRING,   weight =  20 }, -- warlocks_earring
            { item = xi.item.HEALERS_EARRING,    weight =  20 }, -- healers_earring
            { item = xi.item.ESQUIRES_EARRING,   weight =  20 }, -- esquires_earring
            { item = xi.item.WIZARDS_EARRING,    weight =  20 }, -- wizards_earring
            { item = xi.item.WYVERN_EARRING,     weight =  20 }, -- wyvern_earring
            { item = xi.item.MERCENARYS_EARRING, weight =  20 }, -- mercenarys_earring
            { item = xi.item.KILLER_EARRING,     weight =  20 }, -- killer_earring
            { item = xi.item.WRESTLERS_EARRING,  weight =  20 }, -- wrestlers_earring
            { item = xi.item.GENIN_EARRING,      weight =  20 }, -- genin_earring
            { item = xi.item.BEATERS_EARRING,    weight =  20 }, -- beaters_earring
            { item = xi.item.PILFERERS_EARRING,  weight =  20 }, -- pilferers_earring
            { item = xi.item.TRIMMERS_EARRING,   weight =  20 }, -- trimmers_earring
        },

        {
            { item = xi.item.NONE,                    weight = 500 }, -- nothing
            { item = xi.item.SHEET_OF_BAST_PARCHMENT, weight = 400 }, -- sheet_of_bast_parchment
            { item = xi.item.HI_POTION,               weight = 100 }, -- hi-potion
        },

        {
            { item = xi.item.NONE,         weight = 500 }, -- nothing
            { item = xi.item.CHESTNUT_LOG, weight = 250 }, -- chestnut_log
            { item = xi.item.HI_ETHER,     weight = 250 }, -- hi-ether
        },

        {
            { item = xi.item.NONE,                   weight = 250 }, -- nothing
            { item = xi.item.SCROLL_OF_ERASE,        weight = 150 }, -- scroll_of_erase
            { item = xi.item.SCROLL_OF_DISPEL,       weight = 200 }, -- scroll_of_dispel
            { item = xi.item.SCROLL_OF_MAGIC_FINALE, weight = 250 }, -- scroll_of_magic_finale
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI,  weight = 150 }, -- scroll_of_utsusemi_ni
        },

        {
            { item = xi.item.NONE,                   weight = 300 }, -- nothing
            { item = xi.item.AMBER_STONE,            weight =  50 }, -- amber_stone
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE, weight =  50 }, -- chunk_of_darksteel_ore
            { item = xi.item.ELM_LOG,                weight =  50 }, -- elm_log
            { item = xi.item.IRON_INGOT,             weight =  50 }, -- iron_ingot
            { item = xi.item.CHUNK_OF_IRON_ORE,      weight =  50 }, -- chunk_of_iron_ore
            { item = xi.item.LAPIS_LAZULI,           weight =  50 }, -- lapis_lazuli
            { item = xi.item.MYTHRIL_INGOT,          weight =  50 }, -- mythril_ingot
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,   weight =  50 }, -- chunk_of_mythril_ore
            { item = xi.item.ONYX,                   weight =  50 }, -- onyx
            { item = xi.item.SARDONYX,               weight =  50 }, -- sardonyx
            { item = xi.item.SILVER_INGOT,           weight =  50 }, -- silver_ingot
            { item = xi.item.CHUNK_OF_SILVER_ORE,    weight =  50 }, -- chunk_of_silver_ore
            { item = xi.item.STEEL_INGOT,            weight =  50 }, -- steel_ingot
            { item = xi.item.TOURMALINE,             weight =  50 }, -- tourmaline
            { item = xi.item.LIGHT_OPAL,             weight =  50 }, -- light opal
        },

        {
            { item = xi.item.NONE,                   weight = 500 }, -- nothing
            { item = xi.item.AMBER_STONE,            weight =  30 }, -- amber_stone
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE, weight =  40 }, -- chunk_of_darksteel_ore
            { item = xi.item.ELM_LOG,                weight =  30 }, -- elm_log
            { item = xi.item.IRON_INGOT,             weight =  30 }, -- iron_ingot
            { item = xi.item.CHUNK_OF_IRON_ORE,      weight =  40 }, -- chunk_of_iron_ore
            { item = xi.item.LAPIS_LAZULI,           weight =  30 }, -- lapis_lazuli
            { item = xi.item.MYTHRIL_INGOT,          weight =  40 }, -- mythril_ingot
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,   weight =  40 }, -- chunk_of_mythril_ore
            { item = xi.item.ONYX,                   weight =  30 }, -- onyx
            { item = xi.item.SARDONYX,               weight =  30 }, -- sardonyx
            { item = xi.item.SILVER_INGOT,           weight =  40 }, -- silver_ingot
            { item = xi.item.CHUNK_OF_SILVER_ORE,    weight =  30 }, -- chunk_of_silver_ore
            { item = xi.item.STEEL_INGOT,            weight =  30 }, -- steel_ingot
            { item = xi.item.TOURMALINE,             weight =  30 }, -- tourmaline
            { item = xi.item.LIGHT_OPAL,             weight =  30 }, -- light opal
        },
    })

    -- BCNM Charming Trio
    setBattlefieldLoot(xi.battlefield.id.CHARMING_TRIO, {
        {
            { item = xi.item.MANNEQUIN_HANDS, weight = 1000 }, -- Mannequin Hands
        },

        {
            { item = xi.item.JAR_OF_TOAD_OIL,        weight = 125 }, -- Jar Of Toad Oil
            { item = xi.item.POTION,                 weight = 125 }, -- Potion
            { item = xi.item.POTION_P1,              weight = 125 }, -- Potion +1
            { item = xi.item.AIR_SPIRIT_PACT,        weight = 125 }, -- Air Spirit Pact
            { item = xi.item.MANNEQUIN_HEAD,         weight = 125 }, -- Mannequin Head
            { item = xi.item.SCROLL_OF_DRAIN,        weight = 125 }, -- Scroll Of Drain
            { item = xi.item.VIAL_OF_FIEND_BLOOD,    weight = 125 }, -- Vial Of Fiend Blood
            { item = xi.item.MYTHRIL_BEASTCOIN,      weight = 125 }, -- Mythril Beastcoin
        },

        {
            { item = xi.item.MYTHRIL_BEASTCOIN,      weight = 200 }, -- Mythril Beastcoin
            { item = xi.item.SQUARE_OF_GRASS_CLOTH,  weight = 200 }, -- Square Of Grass Cloth
            { item = xi.item.SQUARE_OF_COTTON_CLOTH, weight = 200 }, -- Square Of Cotton Cloth
            { item = xi.item.SQUARE_OF_LINEN_CLOTH,  weight = 200 }, -- Square Of Linen Cloth
            { item = xi.item.SQUARE_OF_WOOL_CLOTH,   weight = 200 }, -- Square Of Wool Cloth
        },

        {
            quantity = 2,
            { item = xi.item.NONE,                weight = 500 },  -- Nothing
            { item = xi.item.VIAL_OF_FIEND_BLOOD, weight = 500 },  -- Vial Of Fiend Blood
        },

        {
            quantity = 2,
            { item = xi.item.NONE,                   weight = 200 }, -- Nothing

            { item = xi.item.PLATOON_EDGE,           weight = 100 }, -- Platoon Edge
            { item = xi.item.PLATOON_GUN,            weight = 100 }, -- Platoon Gun
            { item = xi.item.PLATOON_SPATHA,         weight = 100 }, -- Platoon Spatha
            { item = xi.item.PLATOON_POLE,           weight = 100 }, -- Platoon Pole

            { item = xi.item.GUNROMARU,              weight = 100 }, -- Gunromaru
            { item = xi.item.GANKO,                  weight = 100 }, -- Ganko
            { item = xi.item.PLATOON_DISC,           weight = 100 }, -- Platoon Disc
            { item = xi.item.PLATOON_CUTTER,         weight = 100 }, -- Platoon Cutter
        },
    })

    -- BCNM Harem Scarem
    setBattlefieldLoot(xi.battlefield.id.HAREM_SCAREM, {
        {
            { item = xi.item.DHALMEL_HIDE, weight = 1000 }, -- dhalmel_hide
        },

        {
            { item = xi.item.NONE,        weight =  500 }, -- nothing
            { item = xi.item.GIANT_FEMUR, weight =  500 }, -- giant_femur
        },

        {
            { item = xi.item.NONE,                  weight = 500 }, -- nothing
            { item = xi.item.SLICE_OF_DHALMEL_MEAT, weight = 500 }, -- slice_of_dhalmel_meat
        },

        {
            { item = xi.item.NONE,             weight = 400 }, -- nothing
            { item = xi.item.MERCENARY_MANTLE, weight = 150 }, -- mercenary_mantle
            { item = xi.item.BEATERS_MANTLE,   weight = 150 }, -- beaters_mantle
            { item = xi.item.ESQUIRES_MANTLE,  weight = 150 }, -- esquires_mantle
            { item = xi.item.HEALERS_MANTLE,   weight = 150 }, -- healers_mantle
        },

        {
            { item = xi.item.NONE,           weight = 400 }, -- nothing
            { item = xi.item.WIZARDS_SHIELD, weight = 200 }, -- wizards_shield
            { item = xi.item.TRIMMERS_ASPIS, weight = 200 }, -- trimmers_aspis
            { item = xi.item.WYVERN_TARGE,   weight = 200 }, -- wyvern_targe
        },

        {
            { item = xi.item.NONE,                   weight = 200 }, -- nothing
            { item = xi.item.SCROLL_OF_ERASE,        weight = 200 }, -- scroll_of_erase
            { item = xi.item.SCROLL_OF_DISPEL,       weight = 200 }, -- scroll_of_dispel
            { item = xi.item.SCROLL_OF_MAGIC_FINALE, weight = 200 }, -- scroll_of_magic_finale
            { item = xi.item.SCROLL_OF_UTSUSEMI_NI,  weight = 200 }, -- scroll_of_utsusemi_ni
        },

        {
            { item = xi.item.NONE,                   weight = 250 }, -- nothing
            { item = xi.item.SQUARE_OF_VELVET_CLOTH, weight = 250 }, -- square_of_velvet_cloth
            { item = xi.item.SQUARE_OF_LINEN_CLOTH,  weight = 250 }, -- square_of_linen_cloth
            { item = xi.item.SQUARE_OF_WOOL_CLOTH,   weight = 250 }, -- square_of_wool_cloth
        },

        {
            { item = xi.item.NONE,            weight = 600 }, -- nothing
            { item = xi.item.MANNEQUIN_HEAD,  weight = 200 }, -- mannequin_head
            { item = xi.item.MANNEQUIN_HANDS, weight = 200 }, -- mannequin_hands
        },
    })

    -- KSNM Early Bird Catches the Wyrm
    setBattlefieldLoot(xi.battlefield.id.EARLY_BIRD_CATCHES_THE_WYRM, {
        {
            { item = 3340, weight = 1000 }, -- Cup of Sweet Tea
        },

        {
            { item = 16555, weight =  50 }, -- Ridill (custom drop)
            { item =  1441, weight = 312 }, -- Libation Abjuration
            { item = 17694, weight = 182 }, -- Guespiere
            { item = 18047, weight =  65 }, -- Havoc Scythe
            { item = 17937, weight =  43 }, -- Leopard Axe
            { item = 18173, weight = 181 }, -- Nokizaru Shuriken
            { item = 17823, weight = 217 }, -- Shinsoku
            { item = 17575, weight =  43 }, -- Somnus Signa
        },

        {
            { item = xi.item.DIVINE_LOG,              weight =  94 }, -- Divine Log
            { item = xi.item.LACQUER_TREE_LOG,        weight = 196 }, -- Lacquer Tree Log
            { item = xi.item.PETRIFIED_LOG,           weight = 572 }, -- Petrified Log
            { item = xi.item.SQUARE_OF_SHINING_CLOTH, weight =  43 }, -- Square Of Shining Cloth
        },

        {
            { item = xi.item.OBLATION_ABJURATION,  weight = 159 }, -- Oblation Abjuration
            { item = xi.item.BAYARDS_SWORD,        weight = 151 }, -- Bayards Sword
            { item = xi.item.DREIZACK,             weight = 167 }, -- Dreizack
            { item = xi.item.GRIM_STAFF,           weight =  95 }, -- Grim Staff
            { item = xi.item.GROSVENEURS_BOW,      weight =  95 }, -- Grosveneurs Bow
            { item = xi.item.STYLET,               weight =  56 }, -- Stylet
            { item = xi.item.UNSHO,                weight = 341 }, -- Unsho
        },

        {
            { item = xi.item.DRAGON_HEART,         weight = 522 }, -- Dragon Heart
            { item = xi.item.SLICE_OF_DRAGON_MEAT, weight = 346 }, -- Slice Of Dragon Meat
            { item = xi.item.JUGGERNAUT,           weight =  82 }, -- Juggernaut
            { item = xi.item.SPEED_BELT,           weight =  59 }, -- Speed Belt
        },

        {
            { item = xi.item.CORAL_FRAGMENT,           weight =  32 }, -- Coral Fragment
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,   weight =  71 }, -- Chunk Of Darksteel Ore
            { item = xi.item.DEMON_HORN,               weight =  79 }, -- Demon Horn
            { item = xi.item.EBONY_LOG,                weight =  56 }, -- Ebony Log
            { item = xi.item.CHUNK_OF_GOLD_ORE,        weight =  71 }, -- Chunk Of Gold Ore
            { item = xi.item.SPOOL_OF_GOLD_THREAD,     weight =  32 }, -- Spool Of Gold Thread
            { item = xi.item.HI_RERAISER,              weight =  48 }, -- Hi-reraiser
            { item = xi.item.MAHOGANY_LOG,             weight = 127 }, -- Mahogany Log
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,     weight = 111 }, -- Chunk Of Mythril Ore
            { item = xi.item.PETRIFIED_LOG,            weight = 183 }, -- Petrified Log
            { item = xi.item.PHILOSOPHERS_STONE,       weight =  40 }, -- Philosophers Stone
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,    weight =  56 }, -- Chunk Of Platinum Ore
            { item = xi.item.RAM_HORN,                 weight =  24 }, -- Ram Horn
            { item = xi.item.SQUARE_OF_RAXA,           weight = 119 }, -- Square Of Raxa
            { item = xi.item.RERAISER,                 weight =  56 }, -- Reraiser
            { item = xi.item.VILE_ELIXIR_P1,           weight =  40 }, -- Vile Elixir +1
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  24 }, -- Handful Of Wyvern Scales
        },

        {
            { item = xi.item.WYRM_BEARD,          weight = 210 }, -- Wyrm Beard
            { item = xi.item.LOCK_OF_SIRENS_HAIR, weight = 775 }, -- Lock Of Sirens Hair
        },

        {
            { item = xi.item.MIND_POTION,         weight =  94 }, -- Mind Potion
            { item = xi.item.INTELLIGENCE_POTION, weight = 130 }, -- Intelligence Potion
            { item = xi.item.CHARISMA_POTION,     weight = 116 }, -- Charisma Potion
            { item = xi.item.ICARUS_WING,         weight =  51 }, -- Icarus Wing
            { item = xi.item.SQUARE_OF_RAXA,      weight = 246 }, -- Square Of Raxa
            { item = xi.item.PRELATIC_POLE,       weight = 246 }, -- Prelatic Pole
        },

        {
            { item = xi.item.CORAL_FRAGMENT,           weight =  87 }, -- Coral Fragment
            { item = xi.item.CHUNK_OF_DARKSTEEL_ORE,   weight =  80 }, -- Chunk Of Darksteel Ore
            { item = xi.item.DEMON_HORN,               weight =  58 }, -- Demon Horn
            { item = xi.item.EBONY_LOG,                weight =  72 }, -- Ebony Log
            { item = xi.item.CHUNK_OF_GOLD_ORE,        weight =  87 }, -- Chunk Of Gold Ore
            { item = xi.item.SPOOL_OF_GOLD_THREAD,     weight =  14 }, -- Spool Of Gold Thread
            { item = xi.item.HI_RERAISER,              weight =  22 }, -- Hi-reraiser
            { item = xi.item.MAHOGANY_LOG,             weight =  80 }, -- Mahogany Log
            { item = xi.item.CHUNK_OF_MYTHRIL_ORE,     weight =  36 }, -- Chunk Of Mythril Ore
            { item = xi.item.PETRIFIED_LOG,            weight = 145 }, -- Petrified Log
            { item = xi.item.PHOENIX_FEATHER,          weight =   7 }, -- Phoenix Feather
            { item = xi.item.CHUNK_OF_PLATINUM_ORE,    weight =  51 }, -- Chunk Of Platinum Ore
            { item = xi.item.SQUARE_OF_RAINBOW_CLOTH,  weight =  29 }, -- Square Of Rainbow Cloth
            { item = xi.item.RAM_HORN,                 weight =  36 }, -- Ram Horn
            { item = xi.item.SQUARE_OF_RAXA,           weight =  72 }, -- Square Of Raxa
            { item = xi.item.RERAISER,                 weight =  29 }, -- Reraiser
            { item = xi.item.VILE_ELIXIR,              weight =  29 }, -- Vile Elixir
            { item = xi.item.VILE_ELIXIR_P1,           weight =   7 }, -- Vile Elixir +1
            { item = xi.item.HANDFUL_OF_WYVERN_SCALES, weight =  22 }, -- Handful Of Wyvern Scales
        },

        {
            { item = xi.item.VIAL_OF_BLACK_BEETLE_BLOOD, weight =  58 }, -- Vial Of Black Beetle Blood
            { item = xi.item.SQUARE_OF_DAMASCENE_CLOTH,  weight =  36 }, -- Square Of Damascene Cloth
            { item = xi.item.DAMASCUS_INGOT,             weight =  72 }, -- Damascus Ingot
            { item = xi.item.SPOOL_OF_MALBORO_FIBER,     weight =  22 }, -- Spool Of Malboro Fiber
            { item = xi.item.PHILOSOPHERS_STONE,         weight = 275 }, -- Philosophers Stone
            { item = xi.item.PHOENIX_FEATHER,            weight = 196 }, -- Phoenix Feather
            { item = xi.item.SQUARE_OF_RAXA,             weight = 225 }, -- Square Of Raxa
        },
    })

    -- BCNM Royal Succession
    setBattlefieldLoot(xi.battlefield.id.ROYAL_SUCCESSION, {
        {
            { item = xi.item.BUNCH_OF_WILD_PAMAMAS, weight = 1000 }, -- bunch_of_wild_pamamas
        },

        {
            { item = xi.item.NONE,             weight = 300 }, -- nothing
            { item = xi.item.DUSKY_STAFF,      weight = 100 }, -- dusky_staff
            { item = xi.item.JONGLEURS_DAGGER, weight = 100 }, -- jongleurs_dagger
            { item = xi.item.CALVELEYS_DAGGER, weight = 100 }, -- calveleys_dagger
            { item = xi.item.SEALED_MACE,      weight = 100 }, -- sealed_mace
            { item = xi.item.HIMMEL_STOCK,     weight = 100 }, -- himmel_stock
            { item = xi.item.KAGEHIDE,         weight = 100 }, -- kagehide
            { item = xi.item.OHAGURO,          weight = 100 }, -- ohaguro
        },

        {
            { item =     xi.item.NONE, weight = 100 }, -- nothing
            { item = xi.item.GENIN_EARRING, weight = 300 }, -- genin_earring
            { item = xi.item.AGILE_GORGET, weight = 300 }, -- agile_gorget
            { item = xi.item.JAGD_GORGET, weight = 300 }, -- jagd_gorget
        },

        {
            { item =    xi.item.NONE, weight = 370 }, -- nothing
            { item =  xi.item.TURQUOISE, weight = 100 }, -- turquoise
            { item = xi.item.BUNCH_OF_PAMAMAS, weight = 100 }, -- bunch_of_pamamas
            { item =  xi.item.SQUARE_OF_SILK_CLOTH, weight = 110 }, -- square_of_silk_cloth
            { item =  xi.item.ROSEWOOD_LOG, weight = 140 }, -- rosewood_log
            { item =  xi.item.PEARL, weight = 180 }, -- pearl
        },

        {
            { item = xi.item.SCROLL_OF_PHALANX, weight = 250 }, -- scroll_of_phalanx
            { item = xi.item.SCROLL_OF_ABSORB_STR, weight = 250 }, -- scroll_of_absorb
            { item = xi.item.SCROLL_OF_REFRESH, weight = 250 }, -- scroll_of_refresh
            { item = xi.item.SCROLL_OF_ERASE, weight = 250 }, -- scroll_of_erase
        },

        {
            { item =   xi.item.NONE, weight = 600 }, -- nothing
            { item = xi.item.GOLD_BEASTCOIN, weight = 400 }, -- gold_beastcoin
        },
    })

    -- BCNM Rapid Raptors
    setBattlefieldLoot(xi.battlefield.id.RAPID_RAPTORS, {
        {
            { item = xi.item.RAPTOR_SKIN, weight = 1000 }, -- raptor_skin
        },

        {
            { item = xi.item.ADAMAN_INGOT, weight = 1000 }, -- adaman_ingot
        },

        {
            { item = xi.item.NONE,                    weight = 190 }, -- nothing
            { item = xi.item.SLY_GAUNTLETS,           weight = 110 }, -- sly_gauntlets
            { item = xi.item.SPIKED_FINGER_GAUNTLETS, weight = 120 }, -- spiked_finger_gauntlets
            { item = xi.item.RUSH_GLOVES,             weight = 140 }, -- rush_gloves
            { item = xi.item.RIVAL_RIBBON,            weight = 140 }, -- rival_ribbon
            { item = xi.item.MANA_CIRCLET,            weight = 150 }, -- mana_circlet
            { item = xi.item.IVORY_MITTS,             weight = 150 }, -- ivory_mitts
        },

        {
            { item = xi.item.NONE,             weight =  30 }, -- nothing
            { item = xi.item.STORM_GORGET,     weight = 100 }, -- storm_gorget
            { item = xi.item.INTELLECT_TORQUE, weight = 100 }, -- intellect_torque
            { item = xi.item.BENIGN_NECKLACE,  weight = 120 }, -- benign_necklace
            { item = xi.item.HEAVY_MANTLE,     weight = 130 }, -- heavy_mantle
            { item = xi.item.HATEFUL_COLLAR,   weight = 170 }, -- hateful_collar
            { item = xi.item.ESOTERIC_MANTLE,  weight = 170 }, -- esoteric_mantle
            { item = xi.item.TEMPLARS_MANTLE,  weight = 180 }, -- templars_mantle
        },

        {
            { item = xi.item.NONE,              weight = 230 }, -- nothing
            { item = xi.item.MYTHRIL_INGOT,     weight = 200 }, -- mythril_ingot
            { item = xi.item.CHUNK_OF_IRON_ORE, weight = 200 }, -- chunk_of_iron_ore
            { item = xi.item.PETRIFIED_LOG,     weight = 370 }, -- petrified_log
        },

        {
            { item = xi.item.NONE,     weight = 560 }, -- nothing
            { item = xi.item.RERAISER, weight = 440 }, -- reraiser
        },
    })

    -- BCNM Wild Wild Whiskers
    setBattlefieldLoot(xi.battlefield.id.WILD_WILD_WHISKERS, {
        {
            { item = xi.item.HIGH_QUALITY_COEURL_HIDE, weight = 1000 }, -- high-quality_coeurl_hide
        },

        {
            { item = xi.item.HIGH_QUALITY_COEURL_HIDE, weight = 1000 }, -- high-quality_coeurl_hide
        },

        {
            { item = xi.item.HIGH_QUALITY_COEURL_HIDE, weight = 1000 }, -- high-quality_coeurl_hide
        },

        {
            { item = xi.item.CHUNK_OF_ADAMAN_ORE, weight = 1000 }, -- chunk_of_adaman_ore
        },

        {
            { item = xi.item.HERMES_QUENCHER, weight = 1000 }, -- hermes_quencher
        },

        {
            { item = xi.item.ICARUS_WING, weight = 1000 }, -- icarus_wing
        },

        {
            { item = xi.item.GLEEMANS_BELT,  weight = 365 }, -- gleemans_belt
            { item = xi.item.PENITENTS_ROPE, weight = 635 }, -- penitents_rope
        },

        {
            { item = xi.item.TELEPORT_RING_MEA,   weight = 426 }, -- teleport_ring_mea
            { item = xi.item.TELEPORT_RING_YHOAT, weight = 574 }, -- teleport_ring_yhoat
        },

        {
            { item = xi.item.NONE,         weight = 848 }, -- nothing
            { item = xi.item.WALKURE_MASK, weight =  58 }, -- walkure_mask
            { item = xi.item.HI_RERAISER,  weight =  78 }, -- hi-reraiser
            { item = xi.item.EBONY_LOG,    weight =  16 }, -- ebony_log
        },

        {
            { item = xi.item.YELLOW_ROCK,      weight =  9 }, -- yellow_rock
            { item = xi.item.BLACK_ROCK,       weight =  9 }, -- black_rock
            { item = xi.item.AQUAMARINE,       weight = 16 }, -- aquamarine
            { item = xi.item.RED_ROCK,         weight = 16 }, -- red_rock
            { item = xi.item.BLUE_ROCK,        weight = 16 }, -- blue_rock
            { item = xi.item.PURPLE_ROCK,      weight = 16 }, -- purple_rock
            { item = xi.item.MAHOGANY_LOG,     weight = 33 }, -- mahogany_log
            { item = xi.item.CHRYSOBERYL,      weight = 33 }, -- chrysoberyl
            { item = xi.item.ZIRCON,           weight = 33 }, -- zircon
            { item = xi.item.STEEL_INGOT,      weight = 49 }, -- steel_ingot
            { item = xi.item.DARKSTEEL_INGOT,  weight = 49 }, -- darksteel_ingot
            { item = xi.item.TRANSLUCENT_ROCK, weight = 49 }, -- translucent_rock
            { item = xi.item.SUNSTONE,         weight = 49 }, -- sunstone
            { item = xi.item.MOONSTONE,        weight = 66 }, -- moonstone
            { item = xi.item.MYTHRIL_INGOT,    weight = 82 }, -- mythril_ingot
            { item = xi.item.FLUORITE,         weight = 82 }, -- fluorite
            { item = xi.item.GOLD_INGOT,       weight = 98 }, -- gold_ingot
            { item = xi.item.JADEITE,          weight = 98 }, -- jadeite
            { item = xi.item.PAINITE,          weight = 98 }, -- painite
            { item = xi.item.VILE_ELIXIR_P1,   weight = 99 }, -- vile_elixir_+1
        },
    })
end)

return m
