-----------------------------------
-- Converts zone names to IDs
-----------------------------------
local m = Module:new("enum_zone")

cexi = cexi or {}
cexi.zone =
{
    ['Phanauet_Channel']               =   1,
    ['Carpenters_Landing']             =   2,
    ['Manaclipper']                    =   3,
    ['Bibiki_Bay']                     =   4,
    ['Uleguerand_Range']               =   5,
    ['Bearclaw_Pinnacle']              =   6,
    ['Attohwa_Chasm']                  =   7,
    ['Boneyard_Gully']                 =   8,
    ['PsoXja']                         =   9,
    ['The_Shrouded_Maw']               =  10,
    ['Oldton_Movalpolos']              =  11,
    ['Newton_Movalpolos']              =  12,
    ['Mine_Shaft_2716']                =  13,
    ['Hall_of_Transference']           =  14,
    ['Abyssea-Konschtat']              =  15,
    ['Promyvion-Holla']                =  16,
    ['Spire_of_Holla']                 =  17,
    ['Promyvion-Dem']                  =  18,
    ['Spire_of_Dem']                   =  19,
    ['Promyvion-Mea']                  =  20,
    ['Spire_of_Mea']                   =  21,
    ['Promyvion-Vahzl']                =  22,
    ['Spire_of_Vahzl']                 =  23,
    ['Lufaise_Meadows']                =  24,
    ['Misareaux_Coast']                =  25,
    ['Tavnazian_Safehold']             =  26,
    ['Phomiuna_Aqueducts']             =  27,
    ['Sacrarium']                      =  28,
    ['Riverne-Site_B01']               =  29,
    ['Riverne-Site_A01']               =  30,
    ['Monarch_Linn']                   =  31,
    ['Sealions_Den']                   =  32,
    ['AlTaieu']                        =  33,
    ['Grand_Palace_of_HuXzoi']         =  34,
    ['The_Garden_of_RuHmet']           =  35,
    ['Empyreal_Paradox']               =  36,
    ['Temenos']                        =  37,
    ['Apollyon']                       =  38,
    ['Dynamis-Valkurm']                =  39,
    ['Dynamis-Buburimu']               =  40,
    ['Dynamis-Qufim']                  =  41,
    ['Dynamis-Tavnazia']               =  42,
    ['Diorama_Abdhaljs-Ghelsba']       =  43,
    ['Abdhaljs_Isle-Purgonorgo']       =  44,
    ['Abyssea-Tahrongi']               =  45,
    ['Open_sea_route_to_Al_Zahbi']     =  46,
    ['Open_sea_route_to_Mhaura']       =  47,
    ['Al_Zahbi']                       =  48,
    ['49']                             =  49,
    ['Aht_Urhgan_Whitegate']           =  50,
    ['Wajaom_Woodlands']               =  51,
    ['Bhaflau_Thickets']               =  52,
    ['Nashmau']                        =  53,
    ['Arrapago_Reef']                  =  54,
    ['Ilrusi_Atoll']                   =  55,
    ['Periqia']                        =  56,
    ['Talacca_Cove']                   =  57,
    ['Silver_Sea_route_to_Nashmau']    =  58,
    ['Silver_Sea_route_to_Al_Zahbi']   =  59,
    ['The_Ashu_Talif']                 =  60,
    ['Mount_Zhayolm']                  =  61,
    ['Halvung']                        =  62,
    ['Lebros_Cavern']                  =  63,
    ['Navukgo_Execution_Chamber']      =  64,
    ['Mamook']                         =  65,
    ['Mamool_Ja_Training_Grounds']     =  66,
    ['Jade_Sepulcher']                 =  67,
    ['Aydeewa_Subterrane']             =  68,
    ['Leujaoam_Sanctum']               =  69,
    ['Chocobo_Circuit']                =  70,
    ['The_Colosseum']                  =  71,
    ['Alzadaal_Undersea_Ruins']        =  72,
    ['Zhayolm_Remnants']               =  73,
    ['Arrapago_Remnants']              =  74,
    ['Bhaflau_Remnants']               =  75,
    ['Silver_Sea_Remnants']            =  76,
    ['Nyzul_Isle']                     =  77,
    ['Hazhalm_Testing_Grounds']        =  78,
    ['Caedarva_Mire']                  =  79,
    ['Southern_San_dOria_[S]']         =  80,
    ['East_Ronfaure_[S]']              =  81,
    ['Jugner_Forest_[S]']              =  82,
    ['Vunkerl_Inlet_[S]']              =  83,
    ['Batallia_Downs_[S]']             =  84,
    ['La_Vaule_[S]']                   =  85,
    ['Everbloom_Hollow']               =  86,
    ['Bastok_Markets_[S]']             =  87,
    ['North_Gustaberg_[S]']            =  88,
    ['Grauberg_[S]']                   =  89,
    ['Pashhow_Marshlands_[S]']         =  90,
    ['Rolanberry_Fields_[S]']          =  91,
    ['Beadeaux_[S]']                   =  92,
    ['Ruhotz_Silvermines']             =  93,
    ['Windurst_Waters_[S]']            =  94,
    ['West_Sarutabaruta_[S]']          =  95,
    ['Fort_Karugo-Narugo_[S]']         =  96,
    ['Meriphataud_Mountains_[S]']      =  97,
    ['Sauromugue_Champaign_[S]']       =  98,
    ['Castle_Oztroja_[S]']             =  99,
    ['West_Ronfaure']                  = 100,
    ['East_Ronfaure']                  = 101,
    ['La_Theine_Plateau']              = 102,
    ['Valkurm_Dunes']                  = 103,
    ['Jugner_Forest']                  = 104,
    ['Batallia_Downs']                 = 105,
    ['North_Gustaberg']                = 106,
    ['South_Gustaberg']                = 107,
    ['Konschtat_Highlands']            = 108,
    ['Pashhow_Marshlands']             = 109,
    ['Rolanberry_Fields']              = 110,
    ['Beaucedine_Glacier']             = 111,
    ['Xarcabard']                      = 112,
    ['Cape_Teriggan']                  = 113,
    ['Eastern_Altepa_Desert']          = 114,
    ['West_Sarutabaruta']              = 115,
    ['East_Sarutabaruta']              = 116,
    ['Tahrongi_Canyon']                = 117,
    ['Buburimu_Peninsula']             = 118,
    ['Meriphataud_Mountains']          = 119,
    ['Sauromugue_Champaign']           = 120,
    ['The_Sanctuary_of_ZiTah']         = 121,
    ['RoMaeve']                        = 122,
    ['Yuhtunga_Jungle']                = 123,
    ['Yhoator_Jungle']                 = 124,
    ['Western_Altepa_Desert']          = 125,
    ['Qufim_Island']                   = 126,
    ['Behemoths_Dominion']             = 127,
    ['Valley_of_Sorrows']              = 128,
    ['Ghoyus_Reverie']                 = 129,
    ['RuAun_Gardens']                  = 130,
    ['Mordion_Gaol']                   = 131,
    ['Abyssea-La_Theine']              = 132,
    ['Outer_RaKaznar_[U2]']            = 133,
    ['Dynamis-Beaucedine']             = 134,
    ['Dynamis-Xarcabard']              = 135,
    ['Beaucedine_Glacier_[S]']         = 136,
    ['Xarcabard_[S]']                  = 137,
    ['Castle_Zvahl_Baileys_[S]']       = 138,
    ['Horlais_Peak']                   = 139,
    ['Ghelsba_Outpost']                = 140,
    ['Fort_Ghelsba']                   = 141,
    ['Yughott_Grotto']                 = 142,
    ['Palborough_Mines']               = 143,
    ['Waughroon_Shrine']               = 144,
    ['Giddeus']                        = 145,
    ['Balgas_Dais']                    = 146,
    ['Beadeaux']                       = 147,
    ['Qulun_Dome']                     = 148,
    ['Davoi']                          = 149,
    ['Monastic_Cavern']                = 150,
    ['Castle_Oztroja']                 = 151,
    ['Altar_Room']                     = 152,
    ['The_Boyahda_Tree']               = 153,
    ['Dragons_Aery']                   = 154,
    ['Castle_Zvahl_Keep_[S]']          = 155,
    ['Throne_Room_[S]']                = 156,
    ['Middle_Delkfutts_Tower']         = 157,
    ['Upper_Delkfutts_Tower']          = 158,
    ['Temple_of_Uggalepih']            = 159,
    ['Den_of_Rancor']                  = 160,
    ['Castle_Zvahl_Baileys']           = 161,
    ['Castle_Zvahl_Keep']              = 162,
    ['Sacrificial_Chamber']            = 163,
    ['Garlaige_Citadel_[S]']           = 164,
    ['Throne_Room']                    = 165,
    ['Ranguemont_Pass']                = 166,
    ['Bostaunieux_Oubliette']          = 167,
    ['Chamber_of_Oracles']             = 168,
    ['Toraimarai_Canal']               = 169,
    ['Full_Moon_Fountain']             = 170,
    ['Crawlers_Nest_[S]']              = 171,
    ['Zeruhn_Mines']                   = 172,
    ['Korroloka_Tunnel']               = 173,
    ['Kuftal_Tunnel']                  = 174,
    ['The_Eldieme_Necropolis_[S]']     = 175,
    ['Sea_Serpent_Grotto']             = 176,
    ['VeLugannon_Palace']              = 177,
    ['The_Shrine_of_RuAvitau']         = 178,
    ['Stellar_Fulcrum']                = 179,
    ['LaLoff_Amphitheater']            = 180,
    ['The_Celestial_Nexus']            = 181,
    ['Walk_of_Echoes']                 = 182,
    ['Maquette_Abdhaljs-Legion_A']     = 183,
    ['Lower_Delkfutts_Tower']          = 184,
    ['Dynamis-San_dOria']              = 185,
    ['Dynamis-Bastok']                 = 186,
    ['Dynamis-Windurst']               = 187,
    ['Dynamis-Jeuno']                  = 188,
    ['Outer_RaKaznar_[U3]']            = 189,
    ['King_Ranperres_Tomb']            = 190,
    ['Dangruf_Wadi']                   = 191,
    ['Inner_Horutoto_Ruins']           = 192,
    ['Ordelles_Caves']                 = 193,
    ['Outer_Horutoto_Ruins']           = 194,
    ['The_Eldieme_Necropolis']         = 195,
    ['Gusgen_Mines']                   = 196,
    ['Crawlers_Nest']                  = 197,
    ['Maze_of_Shakhrami']              = 198,
    ['Residential_Area']               = 199,
    ['Garlaige_Citadel']               = 200,
    ['Cloister_of_Gales']              = 201,
    ['Cloister_of_Storms']             = 202,
    ['Cloister_of_Frost']              = 203,
    ['FeiYin']                         = 204,
    ['Ifrits_Cauldron']                = 205,
    ['QuBia_Arena']                    = 206,
    ['Cloister_of_Flames']             = 207,
    ['Quicksand_Caves']                = 208,
    ['Cloister_of_Tremors']            = 209,
    ['GM_Home']                        = 210,
    ['Cloister_of_Tides']              = 211,
    ['Gustav_Tunnel']                  = 212,
    ['Labyrinth_of_Onzozo']            = 213,
    ['Residential_Area']               = 214,
    ['Abyssea-Attohwa']                = 215,
    ['Abyssea-Misareaux']              = 216,
    ['Abyssea-Vunkerl']                = 217,
    ['Abyssea-Altepa']                 = 218,
    ['Residential_Area']               = 219,
    ['Ship_bound_for_Selbina']         = 220,
    ['Ship_bound_for_Mhaura']          = 221,
    ['Provenance']                     = 222,
    ['San_dOria-Jeuno_Airship']        = 223,
    ['Bastok-Jeuno_Airship']           = 224,
    ['Windurst-Jeuno_Airship']         = 225,
    ['Kazham-Jeuno_Airship']           = 226,
    ['Ship_bound_for_Selbina_Pirates'] = 227,
    ['Ship_bound_for_Mhaura_Pirates']  = 228,
    ['Throne_Room_[V]']                = 229,
    ['Southern_San_dOria']             = 230,
    ['Northern_San_dOria']             = 231,
    ['Port_San_dOria']                 = 232,
    ['Chateau_dOraguille']             = 233,
    ['Bastok_Mines']                   = 234,
    ['Bastok_Markets']                 = 235,
    ['Port_Bastok']                    = 236,
    ['Metalworks']                     = 237,
    ['Windurst_Waters']                = 238,
    ['Windurst_Walls']                 = 239,
    ['Port_Windurst']                  = 240,
    ['Windurst_Woods']                 = 241,
    ['Heavens_Tower']                  = 242,
    ['RuLude_Gardens']                 = 243,
    ['Upper_Jeuno']                    = 244,
    ['Lower_Jeuno']                    = 245,
    ['Port_Jeuno']                     = 246,
    ['Rabao']                          = 247,
    ['Selbina']                        = 248,
    ['Mhaura']                         = 249,
    ['Kazham']                         = 250,
    ['Hall_of_the_Gods']               = 251,
    ['Norg']                           = 252,
    ['Abyssea-Uleguerand']             = 253,
    ['Abyssea-Grauberg']               = 254,
    ['Abyssea-Empyreal_Paradox']       = 255,
    ['Western_Adoulin']                = 256,
    ['Eastern_Adoulin']                = 257,
    ['Rala_Waterways']                 = 258,
    ['Rala_Waterways_U']               = 259,
    ['Yahse_Hunting_Grounds']          = 260,
    ['Ceizak_Battlegrounds']           = 261,
    ['Foret_de_Hennetiel']             = 262,
    ['Yorcia_Weald']                   = 263,
    ['Yorcia_Weald_U']                 = 264,
    ['Morimar_Basalt_Fields']          = 265,
    ['Marjami_Ravine']                 = 266,
    ['Kamihr_Drifts']                  = 267,
    ['Sih_Gates']                      = 268,
    ['Moh_Gates']                      = 269,
    ['Cirdas_Caverns']                 = 270,
    ['Cirdas_Caverns_U']               = 271,
    ['Dho_Gates']                      = 272,
    ['Woh_Gates']                      = 273,
    ['Outer_RaKaznar']                 = 274,
    ['Outer_RaKaznar_[U1]']            = 275,
    ['RaKaznar_Inner_Court']           = 276,
    ['RaKaznar_Turris']                = 277,
    ['Gwora-Corridor']                 = 278,
    ['Walk_of_Echoes_[P2]']            = 279,
    ['Mog_Garden']                     = 280,
    ['Leafallia']                      = 281,
    ['Mount_Kamihr']                   = 282,
    ['Silver_Knife']                   = 283,
    ['Celennia_Memorial_Library']      = 284,
    ['Feretory']                       = 285,
    ['286']                            = 286,
    ['Maquette_Abdhaljs-Legion_B']     = 287,
    ['Escha_ZiTah']                    = 288,
    ['Escha_RuAun']                    = 289,
    ['Desuetia_Empyreal_Paradox']      = 290,
    ['Reisenjima']                     = 291,
    ['Reisenjima_Henge']               = 292,
    ['Reisenjima_Sanctorium']          = 293,
    ['Dynamis-San_dOria_[D]']          = 294,
    ['Dynamis-Bastok_[D]']             = 295,
    ['Dynamis-Windurst_[D]']           = 296,
    ['Dynamis-Jeuno_[D]']              = 297,
    ['Walk_of_Echoes_[P1]']            = 298,
    ['Gwora-Throne_Room']              = 299,
}

cexi.zoneName = {}

for zoneName, zoneID in pairs(cexi.zone) do
    cexi.zoneName[zoneID] = zoneName
end

return m
