-----------------------------------
-- Look and model IDs
-----------------------------------
local m = Module:new("enum_look")

cexi      = cexi or {}
cexi.face =
{
    A1 = 0,
    B1 = 1,
    A2 = 2,
    B2 = 3,
    A3 = 4,
    B3 = 5,
    A4 = 6,
    B4 = 7,
    A5 = 8,
    B5 = 9,
    A6 = 10,
    B6 = 11,
    A7 = 12,
    B7 = 13,
    A8 = 14,
    B8 = 15,
}

cexi.model =
{
    -- FULL SETS
    NOTHING               = 0,
    LEATHER_VEST          = 1,
    PLATE_ARMOR           = 2,
    TUNIC                 = 3,
    SHINOBI               = 4,
    CHAINMAIL             = 5,
    LIZARD_JERKIN         = 6,
    RAPTOR_JERKIN         = 7,
    STARTER_RSE           = 8,
    HARA_ATE              = 9,
    CLOAK                 = 10,
    WHITE_CLOAK           = 11,
    ROYAL_SQUIRE          = 12,
    ROYAL_KNIGHT          = 13,
    PADDED_HARNESS        = 14,
    BRONZE_HARNESS        = 15,
    BONE_HARNESS          = 16,
    KENPOGI               = 17,
    VELVET_ROBE           = 18,
    TACTICIAN_MAGICIAN    = 19,
    ROBE                  = 20,
    DOUBLET               = 21,
    DARKSTEEL_CUIRASS     = 22,
    GAMBISON              = 23,
    BATTLE_JUPON          = 24,
    IRON_MUSKETEERS       = 25,
    CENTURIONS_SCALE_MAIL = 26,
    GAVIAL_MAIL           = 27,
    SCALE_MAIL            = 28,
    MYTHRIL_BREASTPLATE   = 29,
    -- EMPTY              = 30, -- Judge's?
    RSE                   = 31,
    -- BODY ONLY
    ASSAULT_BREASTPLATE   = 32,
    CARDINAL_VEST         = 33,
    SCORPION_HARNESS      = 34,
    DEMONS_HARNESS        = 35, -- Ranperre's Harness
    PARADE_CUIRASS        = 36,
    JUJITSU_GI            = 37,
    ROYAL_KNIGHTS_AKETON  = 38,
    AKETON                = 39,
    HAUBERGEON            = 40,
    BYRNIE                = 41,
    SHINOBI_GI            = 42,
    EARTH_DOUBLET         = 43,
    BRIGANDINE            = 44,
    JUSTAUCORPS           = 45,
    BLACK_CLOAK           = 46,
    VERMILLION_CLOAK      = 47,
    BLUE_COTEHARDIE       = 48,
    BLACK_COTEHARDIE      = 49,
    TIGER_JERKIN          = 50,
    TOCIS_HARNESS         = 51,
    -- FULL SETS
    IRON_SCALE_MAIL       = 52,
    STEEL_SCALE_MAIL      = 53,
    COEURL_JERKIN         = 54,
    ADAMAN_CUIRASS        = 55,
    CORAL_HARNESS         = 56,
    NOBLES_TUNIC          = 57,
    HAUBERK               = 58,
    ARHATS_GI             = 59,
    DRAGON_MAIL           = 60,
    RASETSU_SAMUE         = 61,
    CRIMSON_SCALE_MAIL    = 62,
    ADAMAN_HAUBERK        = 63,
    WARRIOR_ARTIFACT      = 64,
    WARRIOR_RELIC         = 65,
    MONK_ARTIFACT         = 66,
    MONK_RELIC            = 67,
    WHITE_MAGE_ARTIFACT   = 68,
    WHITE_MAGE_RELIC      = 69,
    BLACK_MAGE_ARTIFACT   = 70,
    BLACK_MAGE_RELIC      = 71,
    RED_MAGE_ARTIFACT     = 72,
    RED_MAGE_RELIC        = 73,
    THIEF_ARTIFACT        = 74,
    THIEF_RELIC           = 75,
    PALADIN_ARTIFACT      = 76,
    PALADIN_RELIC         = 77,
    DARK_KNIGHT_ARTIFACT  = 78,
    DARK_KNIGHT_RELIC     = 79,
    BEASTMASTER_ARTIFACT  = 80,
    BEASTMASTER_RELIC     = 81,
    BARD_ARTIFACT         = 82,
    BARD_RELIC            = 83,
    RANGER_ARTIFACT       = 84,
    RANGER_RELIC          = 85,
    SAMURAI_ARTIFACT      = 86,
    SAMURAI_RELIC         = 87,
    NINJA_ARTIFACT        = 88,
    NINJA_RELIC           = 89,
    DRAGOON_ARTIFACT      = 90,
    DRAGOON_RELIC         = 91,
    SUMMONER_ARTIFACT     = 92,
    SUMMONER_RELIC        = 93,
    OGRE_JERKIN           = 94,
    KOENIG_CUIRASS        = 95,
    SOMETHING_JUPON       = 96,
    HOLY_BREASTPLATE      = 97,
    YASHA_SAMUE           = 98,
    KIRINS_OSODE          = 99,
    HECATOMB_HARNESS      = 100,
    ERRANT_HOUPPELANDE    = 101,
    FISHING_TUNICA        = 102,
    CHOCOBO_JACK_COAT     = 103,
    VAGABONDS_TUNICA      = 104,
    FIELD_TUNICA          = 105,
    SHURA_TOGI            = 106,
    DALMATICA             = 107,
    CARAPACE_HARNESS      = 108,
    DUSK_JERKIN           = 109,
    DRAGON_HARNESS        = 110,
    -- BODY ONLY
    KINGDOM_AKETON        = 111,
    FEDERATION_AKETON     = 112,
    REPUBLIC_AKETON       = 113,
    -- FULL SETS
    SCORPION_BREASTPLATE  = 114,
    AUSTERE_ROBE          = 115,
    OPALINE_DRESS         = 116,
    CARPENTERS_APRON      = 117,
    BLACKSMITHS_APRON     = 118,
    WEAVERS_APRON         = 119,
    ALCHEMISTS_APRON      = 120,
    BONEWORKERS_APRON     = 121,
    FISHERMANS_APRON      = 122,
    TANNERS_APRON         = 123,
    CULINARIANS_APRON     = 124,
    GOLDSMITHS_APRON      = 125,
    -- EMPTY              = 126, DRACHEN_HORN (HEAD)
    YUKATA                = 127,
    HYDRA_HARNESS         = 128,
    SHADE_HARNESS         = 129,
    GARISH_TUNIC          = 130,
    SEERS_TUNIC           = 131,
    HYDRA_DOUBLET         = 132,
    NOCT_DOUBLET          = 133,
    BISON_JACKET          = 134,
    SHAIR_MANTEEL         = 135,
    BARONE_CORAZZA        = 136,
    IGQIRA_WESKIT         = 137,
    EISENBRUST            = 138,
    LORDS_CUIRASS         = 139,
    DREAM_ROBE            = 140,
    HACHIMAN_DOMARU       = 141,
    BLESSED_BLIAUT        = 142,
    CHASUBLE              = 143,
    -- BODY ONLY
    CARPENTERS_SMOCK      = 144, -- Orc Hat
    BLACKSMITHS_SMOCK     = 145, -- Yagudo Hat
    WEAVERS_SMOCK         = 146, -- Goblin Hat
    ALCHEMISTS_SMOCK      = 147, -- Quadav Hat
    UNICORN_HARNESS       = 148,
    -- FULL SETS
    TRADERS_SAIO          = 149,
    ALUMINE_HAUBERT       = 150,
    PLASTRON              = 151,
    BONEWORKERS_SMOCK     = 152,
    FISHERMANS_SMOCK      = 153,
    TANNERS_SMOCK         = 154,
    CULINARIANS_SMOCK     = 155,
    GOLDSMITHS_SMOCK      = 156,
    SWIMSUIT              = 157,
    NO_LIMBS              = 158,
    HOMAM_CORAZZA         = 159,
    NASHIRA_MANTEEL       = 160,
    TRADERS_SAIO_BLACK    = 161, -- Is this unused?
    CROW_JUPON            = 162,
    HYDRA_JUPON           = 163,
    HYDRA_HAUBERT         = 164,
    BLUE_MAGE_ARTIFACT    = 165,
    BLUE_MAGE_RELIC       = 166,
    CORSAIR_ARTIFACT      = 167,
    CORSAIR_RELIC         = 168,
    PUPPETMASTER_ARTIFACT = 169,
    PUPPETMASTER_RELIC    = 170,
    SIPAHI_JAWSHAN        = 171,
    JARIDAH_PETI          = 172,
    -- EMPTY              = 173,
    AMIR_KORAZIN          = 174,
    PAHLUWAN_KHAZAGAND    = 175,
    YIGIT_GOMLEK          = 176,
    -- EMPTY              = 177,
    -- EMPTY              = 178,
    -- BODY ONLY
    CORSELET              = 179,
    KYUDOGI               = 180,
    TWILIGHT_MAIL         = 181,
    -- FULL SETS
    ARES_CUIRASS          = 182,
    SKADIS_CUIRIE         = 183,
    USUKANE_HARAMAKI      = 184,
    MARDUKS_JUBBAH        = 185,
    MORRIGANS_ROBE        = 186,
    -- BODY ONLY
    ORANGE_RACING_SILKS   = 187,
    BLACK_RACING_SILKS    = 188,
    PURPLE_RACING_SILKS   = 189,
    SKY_BLUE_RACING_SILKS = 190,
    BLUE_RACING_SILKS     = 191,
    RED_RACING_SILKS      = 192,
    WHITE_RACING_SILKS    = 193,
    GREEN_RACING_SILKS    = 194,
    -- FULL SETS
    ASKAR_KORAZIN         = 195,
    DENALI_JACKET         = 196,
    GOLIARD_SAIO          = 197,
    MEXTLI_HARNESS        = 198,
    VALHALLA_BREASTPLATE  = 199,
    SHADOW_BREASTPLATE    = 200,
    SHADOW_COAT           = 201,
    SCHOLARS              = 214,
    ARGUTE                = 215,
    ETOILE                = 304,
    ACRO                  = 325,
    TAEON                 = 326,
    HELIOS                = 327,
    ORVAIL                = 344,
    STARLET               = 408,
}

return m
