-----------------------------------
-- BST Beasts
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("enum_job_bst_beasts")

cexi                = cexi or {}
cexi.job            = cexi.job or {}
cexi.job.bst        = cexi.job.bst or {}

-- Local incase cexi.rate isn't defined yet
local rate =
{
    GUARANTEED  = 1000, -- 100%
    VERY_COMMON =  240, --  24%
    COMMON      =  150, --  15%
    UNCOMMON    =  100, --  10%
    RARE        =   50, --   5%
    VERY_RARE   =   10, --   1%
    SUPER_RARE  =    5, -- 0.5%
    ULTRA_RARE  =    1, -- 0.1%
}

cexi.job.bst.beasts =
{
    -----------------------------------
    -- LullabyMelodia
    -----------------------------------
    {
        name = "LullabyMelodia",
        id   = xi.petId.LULLABY_MELODIA,
        look = 340,
        desc = "Attack+/Defense+",
        from =
        {
            { "La_Theine_Plateau",   "Mad_Sheep",  rate.VERY_RARE   },
            { "Konschtat_Highlands", "Stray_Mary", rate.VERY_COMMON },
        },
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        mobs =
        {
            { "Konschtat_Highlands", "Huge_Wasp", 15 },
            { "La_Theine_Plateau",   "Huge_Wasp", 15 },
        },
        gift =
        {
            832, -- Sheep Wool
            505, -- Sheepskin
            859, -- Ram Skin
        },
        mods =
        {
            [xi.mod.ATT] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 15,
        },
    },

    -----------------------------------
    -- KeenearedSteffi
    -----------------------------------
    {
        name = "KeenearedSteffi",
        id   = xi.petId.KEENEARED_STEFFI,
        look = 268,
        desc = "Accuracy+/Evasion+",
        from =
        {
            { "Cape_Teriggan",          "Beach_Bunny", rate.VERY_RARE   },
            { "Fort_Karugo-Narugo_[S]", "Ratatoskr",   rate.VERY_COMMON },
        },
        feed =
        {
            name = "San d'Orian carrots",
            item = xi.item.SAN_DORIAN_CARROT,
        },
        mobs =
        {
            { "Tahrongi_Canyon",   "Akbaba", 15 },
            { "La_Theine_Plateau", "Akbaba", 15 },
        },
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.EVA] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Evasion+",
            effect = xi.effect.EVASION_BOOST,
            amount = 15,
        },
    },

    -----------------------------------
    -- Tom-Tit-Tat
    -----------------------------------
    {
        name = "FlowerpotBen",
        id   = xi.petId.FLOWERPOT_BEN,
        look = 300,
        desc = "VIT+/Attack+",
        from =
        {

            { "The_Boyahda_Tree",   "Mourioche", rate.VERY_RARE   },
            { "Buburimu_Peninsula", "Backoo",    rate.VERY_COMMON },
        },
        feed =
        {
            name = "pinches of Yuhtunga sulfur",
            item = xi.item.PINCH_OF_YUHTUNGA_SULFUR,
        },
        mobs =
        {
            { "Tahrongi_Canyon",    "Canyon_Crawler",      15 },
            { "Buburimu_Peninsula", "Carnivorous_Crawler", 15 },
        },
        mods =
        {
            [xi.mod.ATT] = { 5, 8, 10, 12, 15 },
            [xi.mod.VIT] = { 5, 8, 10, 12, 15 },
        },
        buff =
        {
            name   = "Counter+",
            effect = xi.effect.COUNTER_BOOST,
            amount = 15,
        },
    },

    -----------------------------------
    -- SaberSiravarde
    -----------------------------------
    {
        name = "SaberSiravarde",
        id   = xi.petId.SABER_SIRAVARDE,
        look = 308,
        desc = "DEX+/Accuracy+",
        from =
        {
            { "Wajaom_Woodlands",   "Wajaom_Tiger",  rate.VERY_RARE   },
            { "Carpenters_Landing", "Tempest_Tigon", rate.VERY_COMMON },
        },
        feed =
        {
            name = "slices of giant sheep meat",
            item = xi.item.SLICE_OF_GIANT_SHEEP_MEAT,
        },
        mobs =
        {
            { "Jugner_Forest",  "Goblin_Butcher", 10 },
            { "Batallia_Downs", "Orcish_Impaler", 10 },
        },
        mods =
        {
            [xi.mod.DEX] = { 5, 8, 10, 12, 15 },
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Critical hit rate+",
            effect = xi.effect.POTENCY,
            amount = 10,
        },
    },

    -----------------------------------
    -- ColdbloodComo
    -----------------------------------
    {
        name = "ColdbloodComo",
        id   = xi.petId.COLDBLOOD_COMO,
        look = 328,
        desc = "INT+/Accuracy+",
        from =
        {
            { "Crawlers_Nest", "Maze_Lizard",   rate.VERY_RARE   },
            { "Dangruf_Wadi",  "Geyser_Lizard", rate.VERY_COMMON },
        },
        feed =
        {
            name = "crawler eggs",
            item = 4357,
        },
        mobs =
        {
            { "Konschtat_Highlands",   "Goblin_Ambusher", 10 },
            { "Meriphataud_Mountains", "Raptor",          15 },
        },
        mods =
        {
            [xi.mod.INT] = {  5,  8, 10, 12, 15 },
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Accuracy+",
            effect = xi.effect.ACCURACY_BOOST,
            amount = 30, -- Flat (Not %)
        },
    },

    -----------------------------------
    -- ShellbusterOrob
    -----------------------------------
    {
        name = "ShellbusterOrob",
        id   = xi.petId.SHELLBUSTER_OROB,
        look = 448,
        desc = "DEX+/MND+",
        from =
        {
            { "Attohwa_Chasm",          "Monarch_Ogrefly", rate.VERY_RARE   },
            { "The_Sanctuary_of_ZiTah", "Elusive_Edwin",   rate.VERY_COMMON },
        },
        feed =
        {
            name = "pots of honey",
            item = xi.item.POT_OF_HONEY,
        },
        mobs =
        {
            { "Meriphataud_Mountains", "Coeurl",        15 },
            { "Meriphataud_Mountains", "Yagudo_Votary", 10 },
        },
        mods =
        {
            [xi.mod.DEX] = { 5, 8, 10, 12, 15 },
            [xi.mod.MND] = { 5, 8, 10, 12, 15 },
        },
        buff =
        {
            name   = "MND+",
            effect = xi.effect.MND_BOOST,
            amount = 15,
        },
    },

    -----------------------------------
    -- VoraciousAudrey
    -----------------------------------
    {
        name = "VoraciousAudrey",
        id   = xi.petId.VORACIOUS_AUDREY,
        look = 1345,
        desc = "AGI+/INT+",
        from =
        {
            { "Riverne-Site_A01",   "Hawkertrap", rate.RARE        },
            { "Aydeewa_Subterrane", "Lizardtrap", rate.VERY_COMMON },
        },
        feed =
        {
            name = "skull locusts",
            item = xi.item.SKULL_LOCUST,
        },
        mobs =
        {
            { "Carpenters_Landing", "Forest_Tiger", 15 },
            { "Carpenters_Landing", "Land_Pugil",   10 },
        },
        mods =
        {
            [xi.mod.AGI] = { 5, 8, 10, 12, 15 },
            [xi.mod.INT] = { 5, 8, 10, 12, 15 },
        },
        buff =
        {
            name   = "Magic Attack+",
            effect = xi.effect.MAGIC_ATK_BOOST,
            amount = 15,
        },
    },
    --[[
    {
        name = "AmbusherAllie",
        id   = xi.petId.AMBUSHER_ALLIE,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "LifedrinkerLars",
        id   = xi.petId.LIFEDRINKER_LARS,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "PanzerGalahad",
        id   = xi.petId.PANZER_GALAHAD,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "ChopsueyChucky",
        id   = xi.petId.CHOPSUEY_CHUCKY,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "AmigoSabotender",
        id   = xi.petId.AMIGO_SABOTENDER,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "CraftyClyvonne",
        id   = xi.petId.CRAFTY_CLYVONNE,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "BloodclawShasra",
        id   = xi.petId.BLOODCLAW_SHASRA,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "LuckyLulush",
        id   = xi.petId.LUCKY_LULUSH,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "FatsoFargann",
        id   = xi.petId.FATSO_FARGANN,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "DiscreetLouise",
        id   = xi.petId.DISCREET_LOUISE,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "SwiftSieghard",
        id   = xi.petId.SWIFT_SIEGHARD,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "DipperYuly",
        id   = xi.petId.DIPPER_YULY,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "FlowerpotMerle",
        id   = xi.petId.FLOWERPOT_MERLE,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "NurseryNazuna",
        id   = xi.petId.NURSERY_NAZUNA,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "MailbusterCetas",
        id   = xi.petId.MAILBUSTER_CETAS,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "AudaciousAnna",
        id   = xi.petId.AUDACIOUS_ANNA,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "PrestoJulio",
        id   = xi.petId.PRESTO_JULIO,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "BugeyedBroncha",
        id   = xi.petId.BUGEYED_BRONCHA,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "GooeyGerard",
        id   = xi.petId.GOOEY_GERARD,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "GorefangHobs",
        id   = xi.petId.GOREFANG_HOBS,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "FaithfulFalcor",
        id   = xi.petId.FAITHFUL_FALCOR,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "CrudeRaphie",
        id   = xi.petId.CRUDE_RAPHIE,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "DapperMac",
        id   = xi.petId.DAPPER_MAC,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "SlipperySilas",
        id   = xi.petId.SLIPPERY_SILAS,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    {
        name = "TurbidToloi",
        id   = xi.petId.TURBID_TOLOI,
        feed =
        {
            name = "clumps of Boyahda moss",
            item = xi.item.CLUMP_OF_BOYAHDA_MOSS,
        },
        look = 340,
        desc = "Accuracy+/Defense+",
        mods =
        {
            [xi.mod.ACC] = { 10, 15, 20, 25, 30 },
            [xi.mod.DEF] = { 10, 15, 20, 25, 30 },
        },
        buff =
        {
            name   = "Attack+",
            effect = xi.effect.ATTACK_BOOST,
            amount = 20,
        },
    },
    ]]
}

cexi.job.bst.beastLookup = {}

for index, pet in pairs(cexi.job.bst.beasts) do
    cexi.job.bst.beastLookup[pet.name] = index
end

return m
