-----------------------------------
-- Augment names
-----------------------------------
-- Comments are taken directly from augments.sql
-- I've done some work to clean them up but there may still be inaccuracies
-----------------------------------
local m = Module:new("enum_augment_name")

cexi      = cexi or {}
cexi.util = cexi.util or {} -- Used for: cexi.util.getAugmentDescription

cexi.augment_name =
{
    [1] = "HP+1",
    [2] = "HP+33",
    [3] = "HP+65",
    [4] = "HP+97",
    [5] = "HP-1",
    [6] = "HP-33",
    [7] = "HP-65",
    [8] = "HP-97",
    [9] = "MP+1",
    [10] = "MP+33",
    [11] = "MP+65",
    [12] = "MP+97",
    [13] = "MP-1",
    [14] = "MP-33",
    [15] = "MP-65",
    [16] = "MP-97",
    [17] = "HP+1 MP+1",
    [17] = "Cont.",
    [18] = "HP+33 MP+33",
    [18] = "Cont.",
    [19] = "HP+1 MP-1",
    [19] = "Cont.",
    [20] = "HP+33 MP-33",
    [20] = "Cont.",
    [21] = "HP-1 MP+1",
    [21] = "Cont.",
    [22] = "HP-33 MP+33",
    [22] = "Cont.",
    [23] = "Accuracy+1",
    [24] = "Accuracy-1",
    [25] = "Attack+1",
    [26] = "Attack-1",
    [27] = "Rng.Acc.+1",
    [28] = "Rng.Acc.-1",
    [29] = "Rng.Atk.+1",
    [30] = "Rng.Atk.-1",
    [31] = "Evasion+1",
    [32] = "Evasion-1",
    [33] = "DEF+1",
    [34] = "DEF-1",
    [35] = "Mag.Acc.+1",
    [36] = "Mag.Acc.-1",
    [37] = "Mag.Evasion+1",
    [38] = "Mag.Evasion-1",
    [39] = "Enmity+1",
    [40] = "Enmity-1",
    [41] = "Crit. hit rate +1%",
    [42] = "Enemy crit. hit rate -1%",
    [43] = "Charm+1", -- Could not determine retail AUGMENT effect. Duration? Chance to land charm? Just set as chance for now.
    [44] = "Store TP+1 Subtle Blow+1",
    [44] = "Cont.",
    [45] = "DMG:+(X+1)", -- Increases damage rating of this weapon (Maximum X=31 for DMG+32) (Retail: melee,not ranged...Mainhand only?) Item displays a value 1 larger than stored in item
    [46] = "DMG:-(X+1)", -- Decreases damage rating of this weapon (Maximum X=31 for DMG-32) (Retail: melee,not ranged...Mainhand only?) Item displays a (negative) value 1 larger than stored in item
    [47] = "Delay:+1%",  -- (melee,not ranged)
    [48] = "Delay:-1%",  -- (melee,not ranged)
    [49] = "Haste+1%",
    [50] = "Slow+1%",
    [51] = "HP recovered while healing+1",
    [52] = "MP recovered while healing+1",
    [53] = "Spell interruption rate down 1%",
    [54] = "Phys. dmg. taken -1%",
    [55] = "Magic dmg. taken -1%",
    [56] = "Breath dmg. taken -1%",
    [57] = "Magic crit. hit rate+1%",
    [58] = "Mag.Def.Bns.-1",
    [59] = "Latent effect: Regain+10", -- (Do via Latent: triggered with your current weapon drawn for 10 TP/tick.)
    [60] = "Latent effect: Refresh+1", -- (Do via Latent: triggered with your current weapon not drawn for 1 MP/tick. Refresh is not present while resting(/heal),chocobo or /sit.)
    [61] = "Occ. inc. resist to stat ailments+1",
    [62] = "Accuracy +33",
    [63] = "Rng.Accuracy +33",
    [64] = "Mag. Acc. +33",
    [65] = "Attack +33",
    [66] = "Rng.Attack +33",
    [67] = "All songs +1",
    [68] = "Accuracy +1 Attack +1",
    [68] = "Cont.",
    [69] = "Rng.Acc. +1 Rng.Atk. +1",
    [69] = "Cont.",
    [70] = "Mag. Acc. +33 Mag.Atk.Bns +33",
    [70] = "Cont.",
    [71] = "Damage Taken -1%",
    [72] = "Exp. Point +1%",
    [73] = "Exp. Point +33%",
    [74] = "Cap. Point +1%",
    [75] = "Cap. Point +33%",
    [76] = "DMG +33", -- Unsure if main hand or off hand so leaving values blank for now,goes up in increments of 1 after the initial 33.
    [77] = "Delay -33%", -- Unsure if main hand or off hand so leaving values blank for now,goes up in increments of 1 after the initial 33.
    [78] = "HP +2 (count by 2)",
    [79] = "HP +3 (count by 3)",
    [80] = "Mag. Acc. +1/Mag. Dmg. +1",
    [80] = "Cont.",
    [81] = "Eva +1/Mag. Eva + d", -- Corrupted
    [82] = "MP +2", --  (count by 2)
    [83] = "MP +3", --  (count by 3)
    -- 84 to 95
    [96] = "Pet: Accuracy+1 Rng.Acc+1",
    [96] = "Cont.",
    [97] = "Pet: Attack+1 Rng.Atk.+1",
    [97] = "Cont.",
    [98] = "Pet: Evasion+1",
    [99] = "Pet: DEF+1",
    [100] = "Pet: Mag.Acc.+1",
    [101] = "Pet: Mag.Atk.Bns.+1",
    [102] = "Pet: Crit.hit rate+1%",
    [103] = "Pet: Enemy crit. hit rate -1%",
    [104] = "Pet: Enmity+1",
    [105] = "Pet: Enmity-1",
    [106] = "Pet: Accuracy+1 Rng.Acc.+1",
    [106] = "Cont.",
    [107] = "Pet: Attack+1 Rng.Atk.+1",
    [107] = "Cont.",
    [108] = "Pet: Mag.Acc.+1 Mag.Atk.Bns.+1",
    [108] = "Cont.",
    [109] = "Pet: Dbl.Atk.+1% Crit.hit rate+1",
    [109] = "Cont.",
    [110] = "Pet: Regen+1",
    [111] = "Pet: Haste+1",
    [112] = "Pet: Damage taken -1%",
    [113] = "Pet: Rng.Acc.+1",
    [114] = "Pet: Rng.Atk.+1",
    [115] = "Pet: Store TP+1",
    [116] = "Pet: Subtle Blow+1",
    [117] = "Pet: Mag. Evasion+1",
    [118] = "Pet: Phys. dmg. taken -1%",
    [119] = "Pet: Mag.Def.Bns.+1",
    [120] = "Avatar: Mag.Atk.Bns.+1",
    [121] = "Pet: Breath +1",
    [122] = "Pet: TP Bonus +20",
    [123] = "Pet: Dbl.Att.+1%",
    [124] = "Pet: Acc+1 R.Acc+1 Atk.+1 R.Atk.+1",
    [124] = "Cont.",
    [124] = "Cont.",
    [124] = "Cont.",
    [125] = "Pet: Mag.Acc.+1 Mag.Dmg.+1",
    [125] = "Cont.",
    [126] = "Pet: Magic Damage +1",
    [127] = "Pet: Magic Damage Taken -1%",
    -- [128] = "128 doesnt seem to be a valid Augment,incomplete or garbled text displays",
    [129] = "Accuracy+1 Rng.Acc.+1",
    [129] = "Cont.",
    [130] = "Attack+1 Rng.Atk.+1",
    [130] = "Cont.",
    [131] = "Mag. Acc.+1 Mag.Atk.Bns+1",
    [131] = "Cont.",
    [132] = "Dbl.Atk.+1% Crit.hit rate+1%",
    [132] = "Cont.",
    [133] = "Mag.Atk.Bns.+1",
    [134] = "Mag.Def.Bns.+1",
    -- [135] = "135 doesnt seem to be a valid Augment,incomplete or garbled text displays",
    -- [136] = "136 doesnt seem to be a valid Augment,incomplete or garbled text displays",
    [137] = "Regen+1",
    [138] = "Refresh+1",
    [139] = "Rapid Shot+1",
    [140] = "Fast Cast+1%",
    [141] = "Conserve MP+1",
    [142] = "Store TP+1",
    [143] = "Dbl.Atk.+1%",
    [144] = "Triple Atk.+1%",
    [145] = "Counter+1",
    [146] = "Dual Wield+1",
    [147] = "Treasure Hunter+1",
    [148] = "Gilfinder+1",
    -- -- 149
    -- -- 150
    [151] = "Martial Arts+1",
    -- -- 152
    [153] = "Shield Mastery+1",
    -- 154 to 175
    [176] = "Resist Sleep+1",
    [177] = "Resist Poison+1",
    [178] = "Resist Paralyze+1",
    [179] = "Resist Blind+1",
    [180] = "Resist Silence+1",
    [181] = "Resist Virus+1",
    [182] = "Resist Petrify+1",
    [183] = "Resist Bind+1",
    [184] = "Resist Curse+1",
    [185] = "Resist Gravity+1",
    [186] = "Resist Slow+1",
    [187] = "Resist Stun+1",
    [188] = "Resist Charm+1",
    -- 189
    -- 190
    -- 191
    -- 192
    -- 193
    [194] = "Kick Attacks+1", -- Rate or Damage? Assuming Rate for now.
    [195] = "Subtle Blow+1",
    -- 196
    -- 197
    [198] = "Zanshin+1",
    -- 199 to 210
    [211] = "Snapshot+1",
    [212] = "Recycle+1",
    -- 213
    -- 214
    [215] = "Ninja tool expertise+1",
    -- 216 to 231
    [232] = "True Shot +1",
    [233] = "Blood Boon+1",
    -- 234 to 236
    [237] = "Occult Acumen+1",
    -- 238 to 250 
    [251] = "Daken +1",
    -- 252 to 256
    [257] = "Hand-to-Hand skill+1",
    [258] = "Dagger skill+1",
    [259] = "Sword skill+1",
    [260] = "Great Sword skill+1",
    [261] = "Axe skill+1",
    [262] = "Great Axe skill+1",
    [263] = "Scythe skill+1",
    [264] = "Polearm skill+1",
    [265] = "Katana skill+1",
    [266] = "Great Katana skill+1",
    [267] = "Club skill+1",
    [268] = "Staff skill+1",
    -- 269 to 277
    [278] = "Automaton Melee skill+1",
    [279] = "Automaton Ranged skill+1",
    [280] = "Automaton Magic skill+1",
    [281] = "Archery skill+1",
    [282] = "Marksmanship skill+1",
    [283] = "Throwing skill+1",
    -- 284
    -- 285
    [286] = "Shield skill+1",
    [287] = "Parrying Skill +1",
    [288] = "Divine magic skill+1",
    [289] = "Healing magic skill+1",
    [290] = "Enha.mag. skill+1",
    [291] = "Enfb.mag. skill+1",
    [292] = "Elem. magic skill+1",
    [293] = "Dark magic skill+1",
    [294] = "Summoning magic skill+1",
    [295] = "Ninjutsu skill+1",
    [296] = "Singing skill+1",
    [297] = "String instrument skill+1",
    [298] = "Wind instrument skill+1",
    [299] = "Blue Magic skill+1",
    [300] = "Geomancy Skill+1",
    [301] = "Handbell Skill+1",
    -- 302 to 319
    [320] = "Blood Pact ability delay -1",
    [321] = "Avatar perpetuation cost -1",
    [322] = "Song spellcasting time -1%",
    [323] = "Cure spellcasting time -1%",
    [324] = "Call Beast ability delay -1",
    [325] = "Quick Draw ability delay -1",
    [326] = "Weapon Skill Acc.+1",
    [327] = "Weapon skill damage+1%", -- However, some sources apply to all swings of the weapon skill (like Magian Trials Weapon Skill Damage +n% weapons) (i.e. this indicates the augment is for all hits)
    [328] = "Crit. hit damage+1%",
    [329] = "Cure potency+1%",
    [330] = "Waltz potency+1%",
    [331] = "Waltz ability delay -1",
    [332] = "Sklchn.dmg.+1%",
    [333] = "Conserve TP+1",
    [334] = "Magic burst dmg.+1%",
    [335] = "Mag. crit. hit dmg.+1%",
    [336] = "Sic and Ready ability delay -1",
    [337] = "Song recast delay -1",
    [338] = "Barrage+1", -- (additional shots,NOT acc)
    [339] = "Elemental Siphon+5", -- (value",*5) Use Multiplier field.
    [340] = "Phantom Roll ability delay -1",
    [341] = "Repair potency+1%",
    [342] = "Waltz TP cost -1",
    [343] = "\"Drain\" and \"Aspir\" Potency +1",
    -- 344 to 346
    [347] = "Healing Magic Recast Delay -1",
    [348] = "Elemental Magic Recast Delay -1",
    [349] = "Enfeebling Magic Recast Delay -1",
    [350] = "Occ. maximizes magic accuracy+1%",
    [351] = "Occ. quickens spellcasting+1%",
    [352] = "Occ. grants dmg. bonus based on TP+1%",
    [353] = "TP Bonus +50",
    [354] = "Quadruple Attack+1%",
    [355] = "Enhancing Magic Recast Delay -1",
    [356] = "Potency of Cure received+1%",
    -- 354 to 359
    [360] = "Save TP+10", -- Mod undefined as of yet
    [362] = "Magic Damage+1",
    [363] = "Chance of successful block+1",
    -- -- 364
    -- -- 365
    [366] = "Blood Pact Ability Delay II", -- (modId is 541 but no idea what the value of the augment is so leaving zero until the value is determined)",
    -- -- 367
    [368] = "Phalanx+1",
    [369] = "Avatar: Blood Pact Dmg+1",
    [370] = "Reverse Flourish+1",
    [371] = "Regen Potency+1",
    [372] = "Embolden+1", -- Mod undefined as of yet so leaving blank.",
    -- 373
    [374] = "Enhancing Magic Duration +1",
    -- 375 to 378
    [379] = "Enmity +1 for each Utsusemi",
    [380] = "Physical Damage Limit +1%",
    -- 381 to 511
    [512] = "STR+1",
    [513] = "DEX+1",
    [514] = "VIT+1",
    [515] = "AGI+1",
    [516] = "INT+1",
    [517] = "MND+1",
    [518] = "CHR+1",
    [519] = "STR-1",
    [520] = "DEX-1",
    [521] = "VIT-1",
    [522] = "AGI-1",
    [523] = "INT-1",
    [524] = "MND-1",
    [525] = "CHR-1",
    [526] = "STR+1 DEX-1 VIT-1",
    [526] = "Cont.",
    [526] = "Cont.",
    [527] = "STR+1 DEX-1 AGI-1",
    [527] = "Cont.",
    [527] = "Cont.",
    [528] = "STR+1 VIT-1 AGI-1",
    [528] = "Cont.",
    [528] = "Cont.",
    [529] = "STR-1 DEX+1 VIT-1",
    [529] = "Cont.",
    [529] = "Cont.",
    [530] = "STR-1 DEX+1 AGI-1",
    [530] = "Cont.",
    [530] = "Cont.",
    [531] = "DEX+1 VIT-1 AGI-1",
    [531] = "Cont.",
    [531] = "Cont.",
    [532] = "STR-1 DEX-1 VIT+1",
    [532] = "Cont.",
    [532] = "Cont.",
    [533] = "STR-1 VIT+1 AGI-1",
    [533] = "Cont.",
    [533] = "Cont.",
    [534] = "DEX-1 VIT+1 AGI-1",
    [534] = "Cont.",
    [534] = "Cont.",
    [535] = "STR-1 DEX-1 AGI+1",
    [535] = "Cont.",
    [535] = "Cont.",
    [536] = "STR-1 VIT-1 AGI+1",
    [536] = "Cont.",
    [536] = "Cont.",
    [537] = "DEX-1 VIT-1 AGI+1",
    [537] = "Cont.",
    [537] = "Cont.",
    [538] = "AGI+1 INT-1 MND-1",
    [538] = "Cont.",
    [538] = "Cont.",
    [539] = "AGI+1 INT-1 CHR-1",
    [539] = "Cont.",
    [539] = "Cont.",
    [540] = "AGI+1 MND-1 CHR-1",
    [540] = "Cont.",
    [540] = "Cont.",
    [541] = "AGI-1 INT+1 MND-1",
    [541] = "Cont.",
    [541] = "Cont.",
    [542] = "AGI-1 INT+1 CHR-1",
    [542] = "Cont.",
    [542] = "Cont.",
    [543] = "INT+1 MND-1 CHR-1",
    [543] = "Cont.",
    [543] = "Cont.",
    [544] = "AGI-1 INT-1 MND+1",
    [544] = "Cont.",
    [544] = "Cont.",
    [545] = "AGI-1 MND+1 CHR-1",
    [545] = "Cont.",
    [545] = "Cont.",
    [546] = "INT-1 MND+1 CHR-1",
    [546] = "Cont.",
    [546] = "Cont.",
    [547] = "AGI-1 INT-1 CHR+1",
    [547] = "Cont.",
    [547] = "Cont.",
    [548] = "AGI-1 MND-1 CHR+1",
    [548] = "Cont.",
    [548] = "Cont.",
    [549] = "INT-1 MND-1 CHR+1",
    [549] = "Cont.",
    [549] = "Cont.",
    [550] = "STR+1 DEX+1",
    [550] = "Cont.",
    [551] = "STR+1 VIT+1",
    [551] = "Cont.",
    [552] = "STR+1 AGI+1",
    [552] = "Cont.",
    [553] = "DEX+1 AGI+1",
    [553] = "Cont.",
    [554] = "INT+1 MND+1",
    [554] = "Cont.",
    [555] = "MND+1 CHR+1",
    [555] = "Cont.",
    [556] = "INT+1 MND+1 CHR+1",
    [556] = "Cont.",
    [556] = "Cont.",
    [557] = "STR+1 CHR+1",
    [557] = "Cont.",
    [558] = "STR+1 INT+1",
    [558] = "Cont.",
    [559] = "STR+1 MND+1",
    [559] = "Cont.",
    -- 560 to 639
    [640] = "Counter +2", -- (increases by 2)
    -- 641 to 739
    [740] = "DMG:+1",
    [741] = "Dmg:+33",   -- Needs to work in either hand,whichever one the weapon is equipped in.
    [742] = "Dmg:+65",   -- Ranged weapons use diff AugID (starts at 746) and diff ModID.
    [743] = "Dmg:+97",   -- (melee,not ranged)
    [744] = "Dmg:-1",    -- (melee,not ranged)
    [745] = "Dmg:-33",   -- (melee,not ranged)
    [746] = "Dmg:+1",    -- (ranged,not melee)
    [747] = "Dmg:+33",   -- (ranged,not melee)
    [748] = "Dmg:+65",   -- (ranged,not melee)
    [749] = "Dmg:+97",   -- (ranged,not melee)
    [750] = "Dmg:-1",    -- (ranged,not melee)
    [751] = "Dmg:-33",   -- (ranged,not melee)
    [752] = "Delay:+1",  -- (melee,not ranged)
    [753] = "Delay:+33", -- (melee,not ranged)
    [754] = "Delay:+65", -- (melee,not ranged)
    [755] = "Delay:+97", -- (melee,not ranged)
    [756] = "Delay:-1",  -- (melee,not ranged)
    [757] = "Delay:-33", -- (melee,not ranged)
    [758] = "Delay:-65", -- (melee,not ranged)
    [759] = "Delay:-97", -- (melee,not ranged)
    [760] = "Delay:+1",  -- (ranged,not melee)
    [761] = "Delay:+33", -- (ranged,not melee)
    [762] = "Delay:+65", -- (ranged,not melee)
    [763] = "Delay:+97", -- (ranged,not melee)
    [764] = "Delay:-1",  -- (ranged,not melee)
    [765] = "Delay:-33", -- (ranged,not melee)
    [766] = "Delay:-65", -- (ranged,not melee)
    [767] = "Delay:-97", -- (ranged,not melee)
    [768] = "Fire resist+1",
    [769] = "Ice resist+1",
    [770] = "Wind resist+1",
    [771] = "Earth resist+1",
    [772] = "Lightning resist+1",
    [773] = "Water resist+1",
    [774] = "Light resist+1",
    [775] = "Dark resist+1",
    [776] = "Fire resist-1",
    [777] = "Ice resist-1",
    [778] = "Wind resist-1",
    [779] = "Earth resist-1",
    [780] = "Lightning resist-1",
    [781] = "Water resist-1",
    [782] = "Light resist-1",
    [783] = "Dark resist-1",
    [784] = "Fire resist+1 Water resist-1",
    [784] = "Cont.",
    [785] = "Fire resist-1 Water resist+1",
    [785] = "Cont.",
    [786] = "Ice resist-1 Wind resist+1",
    [786] = "Cont.",
    [787] = "Wind resist-1 Earth resist+1",
    [787] = "Cont.",
    [788] = "Earth resist-1 Lightning resist+1",
    [788] = "Cont.",
    [789] = "Lightning resist-1 Water resist+1",
    [789] = "Cont.",
    [790] = "Light resist+1 Dark resist-1",
    [790] = "Cont.",
    [791] = "Light resist-1 Dark resist+1",
    [791] = "Cont.",
    [792] = "Fire/Wind/Lightning/Light resist+1",
    [792] = "Cont.",
    [792] = "Cont.",
    [792] = "Cont.",
    [793] = "Ice/Earth/Water/Dark resist+1",
    [793] = "Cont.",
    [793] = "Cont.",
    [793] = "Cont.",
    [794] = "Fire/Wind/Lightning/Light resist+1, Ice/Earth/Water/Dark resist-1",
    [794] = "Cont.",
    [794] = "Cont.",
    [794] = "Cont.",
    [794] = "Cont.",
    [794] = "Cont.",
    [794] = "Cont.",
    [794] = "Cont.",
    [795] = "Fire/Wind/Lightning/Light resist-1, Ice/Earth/Water/Dark resist+1",
    [795] = "Cont.",
    [795] = "Cont.",
    [795] = "Cont.",
    [795] = "Cont.",
    [795] = "Cont.",
    [795] = "Cont.",
    [795] = "Cont.",
    [796] = "All elemental resists+1",
    [796] = "Cont.",
    [796] = "Cont.",
    [796] = "Cont.",
    [796] = "Cont.",
    [796] = "Cont.",
    [796] = "Cont.",
    [796] = "Cont.",
    [797] = "All elemental resists -1",
    [797] = "Cont.",
    [797] = "Cont.",
    [797] = "Cont.",
    [797] = "Cont.",
    [797] = "Cont.",
    [797] = "Cont.",
    [797] = "Cont.",
    -- 798 to 831
    [832] = "Additional Effect: Fire Dmg", --      (Base of 5,each additional point +1 for range of 5 to 36)
    [833] = "Additional Effect: Ice Dmg", --       (Base of 5,each additional point +1 for range of 5 to 36)
    [834] = "Additional Effect: Wind Dmg", --      (Base of 5,each additional point +1 for range of 5 to 36)
    [835] = "Additional Effect: Earth Dmg", --     (Base of 5,each additional point +1 for range of 5 to 36)
    [836] = "Additional Effect: Lightning Dmg", -- (Base of 5,each additional point +1 for range of 5 to 36)
    [837] = "Additional Effect: Water Dmg", --     (Base of 5,each additional point +1 for range of 5 to 36)
    [838] = "Additional Effect: Light Dmg", --     (Base of 5,each additional point +1 for range of 5 to 36)
    [839] = "Additional Effect: Darkness Dmg", --  (Base of 5,each additional point +1 for range of 5 to 36)
    [840] = "Additional Effect: Disease +1",
    [841] = "Additional Effect: Paralysis +1",
    [842] = "Additional Effect: Silence +1",
    [843] = "Additional Effect: Slow +1",
    [844] = "Additional Effect: Stun +1",
    [845] = "Additional Effect: Poison +1",
    [846] = "Additional Effect: Flash +1",
    [847] = "Additional Effect: Blindness +1",
    [848] = "Additional Effect: Weakens Defense +1",
    [849] = "Additional Effect: Sleep +1",
    [850] = "Additional Effect: Weakens Attack +1",
    [851] = "Additional Effect: Impairs Evasion +1",
    [852] = "Additional Effect: Lowers Accuracy +1",
    [853] = "Additional Effect: Lowers Magic Evasion +1",
    [854] = "Additional Effect: Lowers Magic Attack +1",
    [855] = "Additional Effect: Lowers Magic Defense +1",
    [856] = "Additional Effect: Lowers Magic Accuracy +1",
    -- 857 to 895
    [896] = "Sword Enhancement Spell Damage +1",
    [897] = "Enhances Souleater Effect +1%",
    -- 898
    [899] = "Sword Enhancement spell damage +1%", -- (Percent Damage)
    -- 900 to 912
    [913] = "Movement Speed+1%",
    -- 914 to 927
    [928] = "Fire Affinity+1",
    [928] = "Cont.",
    [928] = "Cont.",
    [929] = "Ice Affinity+1",
    [929] = "Cont.",
    [929] = "Cont.",
    [930] = "Wind Affinity+1",
    [930] = "Cont.",
    [930] = "Cont.",
    [931] = "Earth Affinity+1",
    [931] = "Cont.",
    [931] = "Cont.",
    [932] = "Lightning Affinity+1",
    [932] = "Cont.",
    [932] = "Cont.",
    [933] = "Water Affinity+1",
    [933] = "Cont.",
    [933] = "Cont.",
    [934] = "Light Affinity+1",
    [934] = "Cont.",
    [934] = "Cont.",
    [935] = "Dark Affinity+1",
    [935] = "Cont.",
    [935] = "Cont.",
    [936] = "Fire Affinity Magic Accuracy+1",
    [937] = "Ice Affinity Magic Accuracy+1",
    [938] = "Wind Affinity Magic Accuracy+1",
    [939] = "Earth Affinity Magic Accuracy+1",
    [940] = "Lightning Affinity Magic Accuracy+1",
    [941] = "Water Affinity Magic Accuracy+1",
    [942] = "Light Affinity Magic Accuracy+1",
    [943] = "Dark Affinity Magic Accuracy+1",
    [944] = "Fire Affinity Magic Damage+1",
    [945] = "Ice Affinity Magic Damage+1",
    [946] = "Wind Affinity Magic Damage+1",
    [947] = "Earth Affinity Magic Damage+1",
    [948] = "Lightning Affinity Magic Damage+1",
    [949] = "Water Affinity Magic Damage+1",
    [950] = "Light Affinity Magic Damage+1",
    [951] = "Dark Affinity Magic Damage+1",
    [952] = "Fire Affinity: Avatar perp. cost -1",
    [953] = "Ice Affinity: Avatar perp. cost -1",
    [954] = "Wind Affinity: Avatar perp. cost -1",
    [955] = "Earth Affinity: Avatar perp. cost -1",
    [956] = "Thunder Affinity: Avatar perp. cost -1",
    [957] = "Water Affinity: Avatar perp. cost -1",
    [958] = "Light Affinity: Avatar perp. cost -1",
    [959] = "Dark Affinity: Avatar perp. cost -1",

    -- For 960 to 975 and 984 to 1015 the values behave differently.
    -- The Magic Accuracy increase matches value,not displayed if value is zero.
    [960] = "Fire Affinity: Recast time -2",      -- (Increases by 2)
    [960] = "Cont.",
    [961] = "Ice Affinity: Recast time -2",       -- (Increases by 2)
    [961] = "Cont.",
    [962] = "Wind Affinity: Recast time -2",      -- (Increases by 2)
    [962] = "Cont.",
    [963] = "Earth Affinity: Recast time -2",     -- (Increases by 2)
    [963] = "Cont.",
    [964] = "Lightning Affinity: Recast time -2", -- (Increases by 2)
    [964] = "Cont.",
    [965] = "Water Affinity: Recast time -2",     -- (Increases by 2)
    [965] = "Cont.",
    [966] = "Light Affinity: Recast time -2",     -- (Increases by 2)
    [966] = "Cont.",
    [967] = "Dark Affinity: Recast time -2",      -- (Increases by 2)
    [967] = "Cont.",

    -- The Magic Damage increase matches value,not displayed if value is zero.
    [968] = "Fire Affinity: Casting time -2%",       -- (Increases by 2)
    [968] = "Cont.",
    [969] = "Ice Affinity: Casting time -2%",        -- (Increases by 2)
    [969] = "Cont.",
    [970] = "Wind Affinity: Casting time -2%",       -- (Increases by 2)
    [970] = "Cont.",
    [971] = "Earth Affinity: Casting time -2%",      -- (Increases by 2)
    [971] = "Cont.",
    [972] = "Lightning Affinity: Casting time -2%",  -- (Increases by 2)
    [972] = "Cont.",
    [973] = "Water Affinity: Casting time -2%",      -- (Increases by 2)
    [973] = "Cont.",
    [974] = "Light Affinity: Casting time -2%",      -- (Increases by 2)
    [974] = "Cont.",
    [975] = "Dark Affinity: Casting time -2%",       -- (Increases by 2)
    [975] = "Cont.",
    [976] = "Fire Affin.: Blood Pact delay -1",
    [977] = "Ice Affin.: Blood Pact delay -1",
    [978] = "Wind Affin.: Blood Pact delay -1",
    [979] = "Earth Affin.: Blood Pact delay -1",
    [980] = "Lightning Affin.: Blood Pact delay -1",
    [981] = "Water Affin.: Blood Pact delay -1",
    [982] = "Light Affin.: Blood Pact delay -1",
    [983] = "Dark Affin.: Blood Pact delay -1",
    [984] = "Fire Affin.: Recast time -2%",      -- (increases by 2)
    [985] = "Ice Affin.: Recast time -2%",       -- (increases by 2)
    [986] = "Wind Affin.: Recast time -2%",      -- (increases by 2)
    [987] = "Earth Affin.: Recast time -2%",     -- (increases by 2)
    [988] = "Lightning Affin.: Recast time -2%", -- (increases by 2)
    [989] = "Water Affin.: Recast time -2%",     -- (increases by 2)
    [990] = "Light Affin.: Recast time -2%",     -- (increases by 2)
    [991] = "Dark Affin.: Recast time -2%",      -- (increases by 2)
    [992] = "Fire Affinity: Casting time -2%",      -- (increases by 2)
    [993] = "Ice Affinity: Casting time -2%",       -- (increases by 2)
    [994] = "Wind Affinity: Casting time -2%",      -- (increases by 2)
    [995] = "Earth Affinity: Casting time -2%",     -- (increases by 2)
    [996] = "Lightning Affinity: Casting time -2%", -- (increases by 2)
    [997] = "Water Affinity: Casting time -2%",     -- (increases by 2)
    [998] = "Light Affinity: Casting time -2%",     -- (increases by 2)
    [999] = "Dark Affinity: Casting time -2%",      -- (increases by 2)

    -- The Magic Accuracy increase matches value,not displayed if value is zero.
    [1000] = "Fire Affinity: Casting time -6%",      -- (increases by 6)
    [1000] = "Cont.",
    [1001] = "Ice Affinity: Casting time -6%",       -- (increases by 6)
    [1001] = "Cont.",
    [1002] = "Wind Affinity: Casting time -6%",      -- (increases by 6)
    [1002] = "Cont.",
    [1003] = "Earth Affinity: Casting time -6%",     -- (increases by 6)
    [1003] = "Cont.",
    [1004] = "Lightning Affinity: Casting time -6%", -- (increases by 6)
    [1004] = "Cont.",
    [1005] = "Water Affintiy: Casting time -6%",     -- (increases by 6)
    [1005] = "Cont.",
    [1006] = "Light Affinity: Casting time -6%",     -- (increases by 6)
    [1006] = "Cont.",
    [1007] = "Dark Affinity: Casting time -6%",      -- (increases by 6)
    [1007] = "Cont.",

    -- The Magic Damage increase matches value,not displayed if value is zero.
    [1008] = "Fire Affinity: Recast time -6%",           -- (increases by 6)
    [1008] = "Cont.",
    [1009] = "Ice Affinity: Recast time -6%",            -- (increases by 6)
    [1009] = "Cont.",
    [1010] = "Wind Affinity: Recast time -6%",           -- (increases by 6)
    [1010] = "Cont.",
    [1011] = "Earth Affinity: Recast time -6%",          -- (increases by 6)
    [1011] = "Cont.",
    [1012] = "Lightning Affinity: Recast time -6%",      -- (increases by 6)
    [1012] = "Cont.",
    [1013] = "Water Affinity: Recast time -6%",          -- (increases by 6)
    [1013] = "Cont.",
    [1014] = "Light Affinity: Recast time -6%",          -- (increases by 6)
    [1014] = "Cont.",
    [1015] = "Dark Affinity: Recast time -6%",           -- (increases by 6)
    [1015] = "Cont.",
    -- 1016 to 1023

    -- For 1024 to 1080 values,count by 5 each increase
    -- ModId = WEAPONSKILL_DAMAGE_BASE(570)+WsId
    [1024] = "Backhand Blow:DMG+5%", -- (increases by 5)
    [1025] = "Spinning Attack:DMG+5%", -- (increases by 5)
    [1026] = "Howling Fist:DMG+5%", -- (increases by 5)
    [1027] = "Dragon Kick:DMG+5%", -- (increases by 5)
    [1028] = "Viper Bite:DMG+5%", -- (increases by 5)
    [1029] = "Shadowstitch:DMG+5%", -- (increases by 5)
    [1030] = "Cyclone:DMG+5%", -- (increases by 5)
    [1031] = "Evisceration:DMG+5%", -- (increases by 5)
    [1032] = "Burning Blade:DMG+5%", -- (increases by 5)
    [1033] = "Shining Blade:DMG+5%", -- (increases by 5)
    [1034] = "Circle Blade:DMG+5%", -- (increases by 5)
    [1035] = "Savage Blade:DMG+5%", -- (increases by 5)
    [1036] = "Freezebite:DMG+5%", -- (increases by 5)
    [1037] = "Shockwave:DMG+5%", -- (increases by 5)
    [1038] = "Ground Strike:DMG+5%", -- (increases by 5)
    [1039] = "Sickle Moon:DMG+5%", -- (increases by 5)
    [1040] = "Gale Axe:DMG+5%", -- (increases by 5)
    [1041] = "Spinning Axe:DMG+5%", -- (increases by 5)
    [1042] = "Calamity:DMG+5%", -- (increases by 5)
    [1043] = "Decimation:DMG+5%", -- (increases by 5)
    [1044] = "Iron Tempest:DMG+5%", -- (increases by 5)
    [1045] = "Sturmwind:DMG+5%", -- (increases by 5)
    [1046] = "Keen Edge:DMG+5%", -- (increases by 5)
    [1047] = "Steel Cyclone:DMG+5%", -- (increase by 5)
    [1048] = "Nightmare Scythe:DMG+5%", -- (increases by 5)
    [1049] = "Spinning Scythe:DMG+5%", -- (increases by 5)
    [1050] = "Vorpal Scythe:DMG+5%", -- (increases by 5)
    [1051] = "Spiral Hell:DMG+5%", -- (increases by 5)
    [1052] = "Leg Sweep:DMG+5%", -- (increases by 5)
    [1053] = "Vorpal Thrust:DMG+5%", -- (increases by 5)
    [1054] = "Skewer:DMG+5%", -- (increases by 5)
    [1055] = "Impulse Drive:DMG+5%", -- (increases by 5)
    [1056] = "Blade: To:DMG+5%", -- (increases by 5)
    [1057] = "Blade: Chi:DMG+5%", -- (increases by 5)
    [1058] = "Blade: Ten:DMG+5%", -- (increases by 5)
    [1059] = "Blade: Ku:DMG+5%", -- (increases by 5)
    [1060] = "Tachi: Goten:DMG+5%", -- (increases by 5)
    [1061] = "Tachi: Jinpu:DMG+5%", -- (increases by 5)
    [1062] = "Tachi: Koki:DMG+5%", -- (increases by 5)
    [1063] = "Tachi: Kasha:DMG+5%", -- (increases by 5)
    [1064] = "Brainshaker:DMG+5%", -- (increases by 5)
    [1065] = "Skullbreaker:DMG+5%", -- (increases by 5)
    [1066] = "Judgment:DMG+5%", -- (increases by 5)
    [1067] = "Black Halo:DMG+5%", -- (increases by 5)
    [1068] = "Rock Crusher:DMG+5%", -- (increases by 5)
    [1069] = "Shell Crusher:DMG+5%", -- (increases by 5)
    [1070] = "Full Swing:DMG+5%", -- (increases by 5)
    [1071] = "Retribution:DMG+5%", -- (increases by 5)
    [1072] = "Dulling Arrow:DMG+5%", -- (increases by 5)
    [1073] = "Blast Arrow:DMG+5%", -- (increases by 5)
    [1074] = "Arching Arrow:DMG+5%", -- (increases by 5)
    [1075] = "Empyreal Arrow:DMG+5%", -- (increases by 5)
    [1076] = "Hot Shot:DMG+5%", -- (increases by 5)
    [1077] = "Split Shot:DMG+5%", -- (increases by 5)
    [1078] = "Sniper Shot:DMG+5%", -- (increases by 5)
    [1079] = "Detonator:DMG+5%", -- (increases by 5)
    [1080] = "Weapon Skill:DMG+5%", -- (increases by 5)
    [1081] = "Final Heaven:DMG+5%", -- (increases by 5)
    [1082] = "Ascetics Fury:DMG+5%", -- (increases by 5)
    [1083] = "Stringing Pummel:DMG+5%", -- (increases by 5)
    [1084] = "Victory Smite:DMG+5%", -- (increases by 5)
    [1085] = "Mercy Stroke:DMG+5%", -- (increases by 5)
    [1086] = "Pyric Kleos:DMG+5%", -- (increases by 5)
    [1087] = "Mandalic Stab:DMG+5%", -- (increases by 5)
    [1088] = "Mordant Rime:DMG+5%", -- (increases by 5)
    [1089] = "Rudra's Storm:DMG+5%", -- (increases by 5)
    [1090] = "Knights of Round:DMG+5%", -- (increases by 5)
    [1091] = "Death Blossom:DMG+5%", -- (increases by 5)
    [1092] = "Expiacion:DMG+5%", -- (increases by 5)
    [1093] = "Chant du Cygne:DMG+5%", -- (increases by 5)
    [1094] = "Randgrith:DMG+5%", -- (increases by 5)
    [1095] = "Mystic Boon:DMG+5%", -- (increases by 5)
    [1096] = "Scourge:DMG+5%", -- (increases by 5)
    [1097] = "Torcleaver:DMG+5%", -- (increases by 5)
    [1098] = "Onslaught:DMG+5%", -- (increases by 5)
    [1099] = "Primal Rend:DMG+5%", -- (increases by 5)
    [1100] = "Cloudsplitter:DMG+5%", -- (increases by 5)
    [1101] = "Metatron Torment:DMG+5%", -- (increases by 5)
    [1102] = "King's Justice:DMG+5%", -- (increases by 5)
    [1103] = "Ukko's Fury:DMG+5%", -- (increases by 5)
    [1104] = "Catastrophe:DMG+5%", -- (increases by 5)
    [1105] = "Insurgency:DMG+5%", -- (increases by 5)
    [1106] = "Quietus:DMG+5%", -- (increases by 5)
    [1107] = "Geirskogul:DMG+5%", -- (increases by 5)
    [1108] = "Drakesbane:DMG+5%", -- (increases by 5)
    [1109] = "Camlann's Torment:DMG+5%", -- (increases by 5)
    [1110] = "Blade: Metsu:DMG+5%", -- (increases by 5)
    [1111] = "Blade: Kamu:DMG+5%", -- (increases by 5)
    [1112] = "Blade: Hi:DMG+5%", -- (increases by 5)
    [1113] = "Tachi: Kaiten:DMG+5%", -- (increases by 5)
    [1114] = "Tachi: Rana:DMG+5%", -- (increases by 5)
    [1115] = "Tachi: Fudo:DMG+5%", -- (increases by 5)
    [1116] = "Gate of Tartarus:DMG+5%", -- (increases by 5)
    [1117] = "Omniscience:DMG+5%", -- (increases by 5)
    [1118] = "Vidohunir:DMG+5%", -- (increases by 5)
    [1119] = "Garland of Bliss:DMG+5%", -- (increases by 5)
    [1120] = "Namas Arrow:DMG+5%", -- (increases by 5)
    [1121] = "Jishnu's Radiance:DMG+5%", -- (increases by 5)
    [1122] = "Trueflight:DMG+5%", -- (increases by 5)
    [1123] = "Coronach:DMG+5%", -- (increases by 5)
    [1124] = "Leaden Salute:DMG+5%", -- (increases by 5)
    [1125] = "Wildfire:DMG+5%", -- (increases by 5)
    [1126] = "Dimidiation:DMG+5%", -- (increases by 5)
    [1127] = "Exudation:DMG+5%", -- (increases by 5)
    [1128] = "Shijin Spiral:DMG+5%", -- (increases by 5)
    [1129] = "Exenterator:DMG+5%", -- (increases by 5)
    [1130] = "Requiescat:DMG+5%", -- (increases by 5)
    [1131] = "Upheaval:DMG+5%", -- (increases by 5)
    [1132] = "Entropy:DMG+5%", -- (increases by 5)
    [1133] = "Stardiver:DMG+5%", -- (increases by 5)
    [1134] = "Blade: Shun:DMG+5%", -- (increases by 5)
    [1135] = "Tachi: Shoha:DMG+5%", -- (increases by 5)
    [1136] = "Realmrazer:DMG+5%", -- (increases by 5)
    [1137] = "Shattersoul:DMG+5%", -- (increases by 5)
    [1138] = "Resolution:DMG+5%", -- (increases by 5)
    [1139] = "Ruinator:DMG+5%", -- (increases by 5)
    [1140] = "Last Stand:DMG+5%", -- (increases by 5)
    -- 1141 to 1151
    [1152] = "DEF +10",
    [1153] = "Evasion +3",
    [1154] = "Mag. Evasion +3",
    [1155] = "Physical Damage Taken -2%",
    [1156] = "Magic Damage Taken -2%",
    [1157] = "Spell Interruption Rate Down 2%",
    [1158] = "Occ. Resistance to Status Ailments +2",
    -- 1159 to 1245
    [1246] = "Pet: Phy. Dmg. Taken -2%",
    [1247] = "Pet: Magic Dmg. Taken -2%",
    [1248] = "Enhancing Magic Effect Duration +1",
    [1249] = "Helix Effect Duration+1",
    [1250] = "Indi Effect Duration+1",
    [1251] = "Enfeebling Magic Duration +1",
    -- 1252 to 1263
    [1264] = "Meditate Effect Duration +1",
    -- 1265 to 1279
    [1280] = "Enhances Mighty Strikes effect",
    [1281] = "Enhances Hundred Fists effect",
    [1282] = "Enhances Benediction effect",
    [1283] = "Enhances Manafont effect",
    [1284] = "Enhances Chainspell effect",
    [1285] = "Enhances Perfect Dodge effect",
    [1286] = "Enhances Invincible effect",
    [1287] = "Enhances Blood Weapon effect",
    [1288] = "Enhances Familiar effect",
    [1289] = "Enhances Soul Voice effect",
    [1290] = "Enhances Eagle Eye Shot effect",
    [1291] = "Enhances Meikyo Shisui effect",
    [1292] = "Enhances Mijin Gakure effect",
    [1293] = "Enhances Spirit Surge effect",
    [1294] = "Enhances Astral Flow effect",
    [1295] = "Enhances Azure Lore effect",
    [1296] = "Enhances Wild Card effect",
    [1297] = "Enhances Overdrive effect",
    [1298] = "Enhances Trance effect",
    [1299] = "Enhances Tablua Rasa effect",
    [1300] = "Enhances Bolster effect",
    [1301] = "Enhances Elemental Sforzo effect",
     -- 1302 to 1327
    [1328] = "Enhances \"Savagery\" effect",
    [1329] = "Enhances \"Aggressive Aim\" effect",
    [1330] = "Enhances \"Warriors Charge\" effect",
    [1331] = "Enhances \"Tomahawk\" effect",
    -- 1332
    -- 1333
    [1334] = "Enhances \"Penance\" effect",
    [1335] = "Enhances \"Formless Strikes\" effect",
    [1336] = "Enhances \"Invigorate\" effect",
    [1337] = "Enhances \"Mantra\" effect",
    -- 1338
    -- 1339
    [1340] = "Enhances \"Protectra V\" effect",
    [1341] = "Enhances \"Martyr\" effect",
    [1342] = "Enhances \"Shellra V\" effect",
    [1343] = "Enhances \"Devotion\" effect",
    -- 1344
    -- 1345
    [1346] = "Increases Ancient Magic II damage",
    [1347] = "Reduces Ancient Magic II casting time",
    [1348] = "Increases Ancient Magic II accuracy",
    [1349] = "Reduces Ancient Magic II MP cost",
    -- 1350
    -- 1351
    [1352] = "Enhances \"Dia III\" effect",
    [1353] = "Enhances \"Slow II\" effect",
    [1354] = "Enhances \"Phalanx II\" effect",
    [1355] = "Enhances \"Bio III\" effect",
    [1356] = "Enhances \"Blind II\" effect",
    [1357] = "Enhances \"Paralyze II\" effect",
    [1358] = "Enhances \"Aura Steal\" effect",
    [1359] = "Enhances \"Ambush\" effect",
    [1360] = "Enhances \"Feint\" effect",
    [1361] = "Enh. \"Assassins Charge\" effect",
    -- 1362
    -- 1363
    [1364] = "Enhances \"Iron Will\" effect",
    [1365] = "Enhances \"Fealty\" effect",
    [1366] = "Enhances \"Chivalry\" effect",
    [1367] = "Enhances \"Guardian\" effect",
    -- 1368
    -- 1369
    [1370] = "Enhances \"Dark Seal\" effect",
    [1371] = "Enhances \"Diabolic Eye\" effect",
    [1372] = "Enhances \"Muted Soul\" effect",
    [1373] = "Enhances \"Desperate Blows\" effect",
    -- 1374
    -- 1375
    [1376] = "Enhances \"Killer Instinct\" effect",
    [1377] = "Enhances \"Feral Howl effect\"",
    [1378] = "Enhances Beast Affinity effect",
    [1379] = "Enhances Beast Healer effect",
    -- 1380
    -- 1381
    [1382] = "Enhances \"Foe Sirvente\" effect",
    [1383] = "Enhances \"Troubadour\" effect",
    [1384] = "Enh. \"Adventurers Dirge\" effect",
    [1385] = "Enhances \"Nightingale\" effect",
    -- 1386
    -- 1387
    [1388] = "Enhances \"Recycle\" effect",
    [1389] = "Enhances \"Snapshot\" effect",
    [1390] = "Enhances \"Flashy Shot\" effect",
    [1391] = "Enhances \"Stealth Shot\" effect",
    -- 1392
    -- 1393
    [1394] = "Enhances \"Shikikoyo\" effect",
    [1395] = "Enhances \"Overwhelm\" effect",
    [1396] = "Enhances \"Blade Bash\" effect",
    [1397] = "Enhances \"Ikishoten\" effect",
    -- 1398
    -- 1399
    [1400] = "Increases elem. ninjutsu III damage",
    [1401] = "Enhances \"Sange\" effect",
    [1402] = "Enh. Ninja Tool Expertise effect",
    [1403] = "Reduces elem. ninjutsu III cast time",
    -- 1404
    -- 1405
    [1406] = "Enhances Deep Breathing effect",
    [1407] = "Enhances Angon effect",
    [1408] = "Enhances Strafe effect",
    [1409] = "Enhances Empathy effect",
    -- 1410
    -- 1411
    [1412] = "Reduces Sp Blood Pact MP cost",
    [1413] = "Inc Sp Blood Pact magic burst dmg",
    [1414] = "Increases Sp Blood Pact accuracy",
    [1415] = "Inc. Sp. Blood Pact magic crit. dmg.",
    -- 1416
    -- 1417
    [1418] = "Enhances \"Convergence\" effect",
    [1419] = "Enhances \"Enchainment\" effect",
    [1420] = "Enhances \"Assimilation\" effect",
    [1421] = "Enhances \"Diffusion\" effect",
    -- 1422
    -- 1423
    [1424] = "Enhances \"Winning Streak\" effect",
    [1425] = "Enhances \"Loaded Deck\" effect",
    [1426] = "Enhances \"Fold\" effect",
    [1427] = "Enhances \"Snake Eye\" effect",
    -- 1428
    -- 1429
    [1430] = "Enhances \"Optimization\" effect",
    [1431] = "Enhances \"Fine-Tuning\" effect",
    [1432] = "Enhances \"Ventriloquy\" effect",
    [1433] = "Enhances \"Role Reversal\" effect",
    -- 1434
    -- 1435
    [1436] = "Enhances \"No Foot\" Rise effect",
    [1437] = "Enhances \"Fan Dance\" effect",
    [1438] = "Enhances \"Saber Dance\" effect",
    [1439] = "Enhances \"Closed Position\" effect",
    -- 1440
    -- 1441
    [1442] = "Enh. \"Altruism\" and \"Focalization\"",
    [1443] = "Enhances \"Enlightenment\" effect",
    [1444] = "Enh. \"Tranquility\" and \"Equanimity\"",
    [1445] = "Enhances Stormsurge effect",
    -- 1446
    -- 1447
    [1448] = "Enhances \"Mending Halation\" effect",
    [1449] = "Enhances \"Radial Arcana\" effect",
    [1450] = "Enhances \"Curative Recantation\" effect",
    [1451] = "Enhances \"Primeval Zeal\" effect",
    -- 1452
    -- 1453
    [1454] = "Enhances \"Battuta\" effect",
    [1455] = "Enhances \"Rayke\" effect",
    [1456] = "Enhances \"Inspire\" effect",
    [1457] = "Enhances \"Sleight of Sword\" effect",
    -- 1458 to 1471
    [1472] = "Parrying rate +1% (not +skill)",
    -- 1473 to 1535
    [1536] = "Backhand Blow:DMG+5%", -- (increases by 5)
    [1537] = "Spinning Attack:DMG+5%", -- (increases by 5)
    [1538] = "Howling Fist:DMG+5%", -- (increases by 5)
    [1539] = "Dragon Kick:DMG+5%", -- (increases by 5)
    [1540] = "Viper Bite:DMG+5%", -- (increases by 5)
    [1541] = "Shadowstitch:DMG+5%", -- (increases by 5)
    [1542] = "Cyclone:DMG+5%", -- (increases by 5)
    [1543] = "Evisceration:DMG+5%", -- (increases by 5)
    [1544] = "Burning Blade:DMG+5%", -- (increases by 5)
    [1545] = "Shining Blade:DMG+5%", -- (increases by 5)
    [1546] = "Circle Blade:DMG+5%", -- (increases by 5)
    [1547] = "Savage Blade:DMG+5%", -- (increases by 5)
    [1548] = "Freezebite:DMG+5%", -- (increases by 5)
    [1549] = "Shockwave:DMG+5%", -- (increases by 5)
    [1550] = "Ground Strike:DMG+5%", -- (increases by 5)
    [1551] = "Sickle Moon:DMG+5%", -- (increases by 5)
    [1552] = "Gale Axe:DMG+5%", -- (increases by 5)
    [1553] = "Spinning Axe:DMG+5%", -- (increases by 5)
    [1554] = "Calamity:DMG+5%", -- (increases by 5)
    [1555] = "Decimation:DMG+5%", -- (increases by 5)
    [1556] = "Iron Tempest:DMG+5%", -- (increases by 5)
    [1557] = "Sturmwind:DMG+5%", -- (increases by 5)
    [1558] = "Keen Edge:DMG+5%", -- (increases by 5)
    [1559] = "Steel Cyclone:DMG+5%", -- (increase by 5)
    [1560] = "Nightmare Scythe:DMG+5%", -- (increases by 5)
    [1561] = "Spinning Scythe:DMG+5%", -- (increases by 5)
    [1562] = "Vorpal Scythe:DMG+5%", -- (increases by 5)
    [1563] = "Spiral Hell:DMG+5%", -- (increases by 5)
    [1564] = "Leg Sweep:DMG+5%", -- (increases by 5)
    [1565] = "Vorpal Thrust:DMG+5%", -- (increases by 5)
    [1566] = "Skewer:DMG+5%", -- (increases by 5)
    [1567] = "Impulse Drive:DMG+5%", -- (increases by 5)
    [1568] = "Blade: To:DMG+5%", -- (increases by 5)
    [1569] = "Blade: Chi:DMG+5%", -- (increases by 5)
    [1570] = "Blade: Ten:DMG+5%", -- (increases by 5)
    [1571] = "Blade: Ku:DMG+5%", -- (increases by 5)
    [1572] = "Tachi: Goten:DMG+5%", -- (increases by 5)
    [1573] = "Tachi: Jinpu:DMG+5%", -- (increases by 5)
    [1574] = "Tachi: Koki:DMG+5%", -- (increases by 5)
    [1575] = "Tachi: Kasha:DMG+5%", -- (increases by 5)
    [1576] = "Brainshaker:DMG+5%", -- (increases by 5)
    [1577] = "Skullbreaker:DMG+5%", -- (increases by 5)
    [1578] = "Judgment:DMG+5%", -- (increases by 5)
    [1579] = "Black Halo:DMG+5%", -- (increases by 5)
    [1580] = "Rock Crusher:DMG+5%", -- (increases by 5)
    [1581] = "Shell Crusher:DMG+5%", -- (increases by 5)
    [1582] = "Full Swing:DMG+5%", -- (increases by 5)
    [1583] = "Retribution:DMG+5%", -- (increases by 5)
    [1584] = "Dulling Arrow:DMG+5%", -- (increases by 5)
    [1585] = "Blast Arrow:DMG+5%", -- (increases by 5)
    [1586] = "Arching Arrow:DMG+5%", -- (increases by 5)
    [1587] = "Empyreal Arrow:DMG+5%", -- (increases by 5)
    [1588] = "Split Shot:DMG+5%", -- (increases by 5)
    [1589] = "Hot Shot:DMG+5%", -- (increases by 5)
    [1590] = "Sniper Shot:DMG+5%", -- (increases by 5)
    [1591] = "Detonator:DMG+5%", -- (increases by 5)
    [1592] = "Weapon Skill:DMG+5%", -- (increases by 5)
    [1593] = "Final Heaven:DMG+5%", -- (increases by 5)
    [1594] = "Ascetics Fury:DMG+5%", -- (increases by 5)
    [1595] = "Stringing Pummel:DMG+5%", -- (increases by 5)
    [1596] = "Victory Smite:DMG+5%", -- (increases by 5)
    [1597] = "Mercy Stroke:DMG+5%", -- (increases by 5)
    [1598] = "Pyric Kleos:DMG+5%", -- (increases by 5)
    [1599] = "Mandalic Stab:DMG+5%", -- (increases by 5)
    [1600] = "Mordant Rime:DMG+5%", -- (increases by 5)
    [1601] = "Rudra's Storm:DMG+5%", -- (increases by 5)
    [1602] = "Knights of Round:DMG+5%", -- (increases by 5)
    [1603] = "Death Blossom:DMG+5%", -- (increases by 5)
    [1604] = "Expiacion:DMG+5%", -- (increases by 5)
    [1605] = "Chant du Cygne:DMG+5%", -- (increases by 5)
    [1606] = "Randgrith:DMG+5%", -- (increases by 5)
    [1607] = "Mystic Boon:DMG+5%", -- (increases by 5)
    [1608] = "Scourge:DMG+5%", -- (increases by 5)
    [1609] = "Torcleaver:DMG+5%", -- (increases by 5)
    [1610] = "Onslaught:DMG+5%", -- (increases by 5)
    [1611] = "Primal Rend:DMG+5%", -- (increases by 5)
    [1612] = "Cloudsplitter:DMG+5%", -- (increases by 5)
    [1613] = "Metatron Torment:DMG+5%", -- (increases by 5)
    [1614] = "King's Justice:DMG+5%", -- (increases by 5)
    [1615] = "Ukko's Fury:DMG+5%", -- (increases by 5)
    [1616] = "Catastrophe:DMG+5%", -- (increases by 5)
    [1617] = "Insurgency:DMG+5%", -- (increases by 5)
    [1618] = "Quietus:DMG+5%", -- (increases by 5)
    [1619] = "Geirskogul:DMG+5%", -- (increases by 5)
    [1620] = "Drakesbane:DMG+5%", -- (increases by 5)
    [1621] = "Camlann's Torment:DMG+5%", -- (increases by 5)
    [1622] = "Blade: Metsu:DMG+5%", -- (increases by 5)
    [1623] = "Blade: Kamu:DMG+5%", -- (increases by 5)
    [1624] = "Blade: Hi:DMG+5%", -- (increases by 5)
    [1625] = "Tachi: Kaiten:DMG+5%", -- (increases by 5)
    [1626] = "Tachi: Rana:DMG+5%", -- (increases by 5)
    [1627] = "Tachi: Fudo:DMG+5%", -- (increases by 5)
    [1628] = "Gate of Tartarus:DMG+5%", -- (increases by 5)
    [1629] = "Omniscience:DMG+5%", -- (increases by 5)
    [1630] = "Vidohunir:DMG+5%", -- (increases by 5)
    [1631] = "Garland of Bliss:DMG+5%", -- (increases by 5)
    [1632] = "Namas Arrow:DMG+5%", -- (increases by 5)
    [1633] = "Jishnu's Radiance:DMG+5%", -- (increases by 5)
    [1634] = "Trueflight:DMG+5%", -- (increases by 5)
    [1635] = "Coronach:DMG+5%", -- (increases by 5)
    [1636] = "Leaden Salute:DMG+5%", -- (increases by 5)
    [1637] = "Wildfire:DMG+5%", -- (increases by 5)
    [1638] = "Dimidiation:DMG+5%", -- (increases by 5)
    [1639] = "Exudation:DMG+5%", -- (increases by 5)
    [1640] = "Shijin Spiral:DMG+5%", -- (increases by 5)
    [1641] = "Exenterator:DMG+5%", -- (increases by 5)
    [1642] = "Requiescat:DMG+5%", -- (increases by 5)
    [1643] = "Upheaval:DMG+5%", -- (increases by 5)
    [1644] = "Entropy:DMG+5%", -- (increases by 5)
    [1645] = "Stardiver:DMG+5%", -- (increases by 5)
    [1646] = "Blade: Shun:DMG+5%", -- (increases by 5)
    [1647] = "Tachi: Shoha:DMG+5%", -- (increases by 5)
    [1648] = "Realmrazer:DMG+5%", -- (increases by 5)
    [1649] = "Shattersoul:DMG+5%", -- (increases by 5)
    [1650] = "Resolution:DMG+5%", -- (increases by 5)
    [1651] = "Ruinator:DMG+5%", -- (increases by 5)
    [1652] = "Last Stand:DMG+5%", -- (increases by 5)
    -- 1653 to 1791
    [1792] = "Pet: STR+1",
    [1793] = "Pet: DEX+1",
    [1794] = "Pet: VIT+1",
    [1795] = "Pet: AGI+1",
    [1796] = "Pet: INT+1",
    [1797] = "Pet: MND+1",
    [1798] = "Pet: CHR+1",
    [1799] = "Pet: STR-1",
    [1800] = "Pet: DEX-1",
    [1801] = "Pet: VIT-1",
    [1802] = "Pet: AGI-1",
    [1803] = "Pet: INT-1",
    [1804] = "Pet: MND-1",
    [1805] = "Pet: CHR-1",
    [1806] = "Pet: STR+1 DEX+1 VIT+1",
    [1806] = "Cont.",
}

cexi.util.getAugmentDescription = function(augs)
    local result = ""

    for val = 1, #augs, 2 do
        result = result .. string.gsub(cexi.augment_name[augs[val]], "%d+", augs[val + 1] + 1)

        if val < #augs - 2 then
            result = result .. " / "
        end
    end

    return result
end

cexi.augment_id =
{
    HP = 1,
    HP_33 = 2,
    HP_65 = 3,
    HP_97 = 4,
    HP_MINUS = 5,
    HP_MINUS_33 = 6,
    HP_MINUS_65 = 7,
    HP_MINUS_97 = 8,
    MP = 9,
    MP_33 = 10,
    MP_65 = 11,
    MP_97 = 12,
    MP_MINUS = 13,
    MP_MINUS_33 = 14,
    MP_MINUS_65 = 15,
    MP_MINUS_97 = 16,
    HP_PLUS_1_MP = 17,
    --_[17]_=_"Cont_",
    HP_PLUS_33_MP_PLUS_33 = 18,
    --_[18]_=_"Cont_",
    HP_PLUS_1_MP_MINUS = 19,
    --_[19]_=_"Cont_",
    HP_PLUS_33_MP_MINUS_33 = 20,
    --_[20]_=_"Cont_",
    HP_MINUS_1_MP = 21,
    --_[21]_=_"Cont_",
    HP_MINUS_33_MP_PLUS_33 = 22,
    --_[22]_=_"Cont_",
    ACCURACY = 23,
    ACCURACY_MINUS = 24,
    ATTACK = 25,
    ATTACK_MINUS = 26,
    RANGED_ACCURACY = 27,
    RANGED_ACCURACY_MINUS = 28,
    RANGED_ATTACK = 29,
    RANGED_ATTACK_MINUS = 30,
    EVASION = 31,
    EVASION_MINUS = 32,
    DEF = 33,
    DEF_MINUS = 34,
    MAGIC_ACCURACY = 35,
    MAGIC_ACCURACY_MINUS = 36,
    MAG_EVASION = 37,
    MAG_EVASION_MINUS = 38,
    ENMITY = 39,
    ENMITY_MINUS = 40,
    CRIT_HIT_RATE = 41,
    ENEMY_CRIT_RATE = 42,
    CHARM = 43,
    STORE_TP_PLUS_1_SUBTLE_BLOW = 44,
    --_[44]_=_"Cont_",
    DMG_PLUS_X = 45,
    DMG_MINUS_X = 46,
    DELAY = 47,
    DELAY_MINUS = 48,
    HASTE = 49,
    SLOW = 50,
    HHP = 51,
    HMP = 52,
    SPELL_INTERRUPTION_RATE_DOWN_1_PERCENT = 53,
    PHYS_DMG_TAKEN = 54,
    MAGIC_DMG_TAKEN = 55,
    BREATH_DMG_TAKEN = 56,
    MAGIC_CRIT_HIT_RATE = 57,
    MAG_DEF_BNS_MINUS = 58,
    LATENT_EFFECT_REGAIN_PLUS_10 = 59,
    LATENT_EFFECT_REFRESH = 60,
    OCC_INC_RESIST_TO_STAT_AILMENTS = 61,
    ACCURACY_PLUS_33 = 62,
    RNG_ACCURACY_PLUS_33 = 63,
    MAG_ACC_PLUS_33 = 64,
    ATTACK_PLUS_33 = 65,
    RNG_ATTACK_PLUS_33 = 66,
    ALL_SONGS = 67,
    ACCURACY_PLUS_1_ATTACK = 68,
    --_[68]_=_"Cont_",
    RNG_ACC_PLUS_1_RNG_ATK = 69,
    --_[69]_=_"Cont_",
    MAG_ACC_PLUS_33_MAG_ATK_BNS_PLUS_33 = 70,
    --_[70]_=_"Cont_",
    DAMAGE_TAKEN = 71,
    EXP_POINT = 72,
    EXP_POINT_PLUS_33_PERCENT = 73,
    CAP_POINT = 74,
    CAP_POINT_PLUS_33_PERCENT = 75,
    DMG_PLUS_33 = 76,
    DELAY_MINUS_33_PERCENT = 77,
    HP_PLUS_2_COUNT_BY_2 = 78,
    HP_PLUS_3_COUNT_BY_3 = 79,
    MAG_ACC_PLUS_1_MAG_DMG = 80,
    --_[80]_=_"Cont_",
    EVASION_PLUS_1_MAG_EVASION = 81,
    MP_PLUS_2 = 82,
    MP_PLUS_3 = 83,

    PET_ACC_RNG_ACC = 96,
    --_[96]_=_"Cont_",
    PET_ATK_RNG_ATK = 97,
    --_[97]_=_"Cont_",
    PET_EVASION = 98,
    PET_DEF = 99,
    PET_MAG_ACC = 100,
    PET_MAG_ATK_BNS = 101,
    PET_CRIT_HIT_RATE = 102,
    PET_ENEMY_CRIT_HIT_RATE_MINUS = 103,
    PET_ENMITY = 104,
    PET_ENMITY_MINUS = 105,
    PET_ACCURACY_PLUS_1_RNG_ACC = 106,
    --_[106]_=_"Cont_",
    PET_ATTACK_PLUS_1_RNG_ATK = 107,
    --_[107]_=_"Cont_",
    PET_MAG_ACC_PLUS_1_MAG_ATK_BNS = 108,
    --_[108]_=_"Cont_",
    PET_DA_CRIT_RATE = 109,
    --_[109]_=_"Cont_",
    PET_REGEN = 110,
    PET_HASTE = 111,
    PET_DAMAGE_TAKEN = 112,
    PET_RNG_ACC = 113,
    PET_RNG_ATK = 114,
    PET_STORE_TP = 115,
    PET_SUBTLE_BLOW = 116,
    PET_MAG_EVASION = 117,
    PET_PHYS_DMG_TAKEN_MINUS = 118,
    PET_MAG_DEF_BNS = 119,
    AVATAR_MAG_ATK_BNS = 120,
    PET_BREATH = 121,
    PET_TP_BONUS_PLUS_20 = 122,
    PET_DOUBLE_ATTACK = 123,
    PET_ACC_PLUS_1_R_ACC_PLUS_1_ATK_PLUS_1_R_ATK = 124,
    --_[124]_=_"Cont_",
    --_[124]_=_"Cont_",
    --_[124]_=_"Cont_",
    PET_MAG_ACC_PLUS_1_MAG_DMG = 125,
    --_[125]_=_"Cont_",
    PET_MAGIC_DAMAGE = 126,
    PET_MAGIC_DAMAGE_TAKEN_MINUS = 127,

    ACCURACY_PLUS_1_RNG_ACC = 129,
    --_[129]_=_"Cont_",
    ATTACK_PLUS_1_RNG_ATK = 130,
    --_[130]_=_"Cont_",
    MAG_ACC_PLUS_1_MAG_ATK_BNS = 131,
    --_[131]_=_"Cont_",
    DBL_ATK_PLUS_1_PERCENT_CRIT_HIT_RATE = 132,
    --_[132]_=_"Cont_",
    MAGIC_ATK_BONUS = 133,
    MAGIC_DEF_BONUS = 134,

    REGEN = 137,
    REFRESH = 138,
    RAPID_SHOT = 139,
    FAST_CAST = 140,
    CONSERVE_MP = 141,
    STORE_TP = 142,
    DOUBLE_ATTACK = 143,
    TRIPLE_ATTACK = 144,
    COUNTER = 145,
    DUAL_WIELD = 146,
    TREASURE_HUNTER = 147,
    GILFINDER = 148,

    MARTIAL_ARTS = 151,

    SHIELD_MASTERY = 153,

    RESIST_SLEEP = 176,
    RESIST_POISON = 177,
    RESIST_PARALYZE = 178,
    RESIST_BLIND = 179,
    RESIST_SILENCE = 180,
    RESIST_VIRUS = 181,
    RESIST_PETRIFY = 182,
    RESIST_BIND = 183,
    RESIST_CURSE = 184,
    RESIST_GRAVITY = 185,
    RESIST_SLOW = 186,
    RESIST_STUN = 187,
    RESIST_CHARM = 188,

    KICK_ATTACK_RATE = 194,
    SUBTLE_BLOW = 195,

    ZANSHIN = 198,

    SNAPSHOT = 211,
    RECYCLE = 212,

    NIN_TOOL_EXPERTISE = 215,

    TRUE_SHOT = 232,
    BLOOD_BOON = 233,

    OCCULT_ACUMEN = 237,

    DAKEN = 251,

    HAND_MINUS_TO_MINUS_HAND_SKILL = 257,
    DAGGER_SKILL = 258,
    SWORD_SKILL = 259,
    GREAT_SWORD_SKILL = 260,
    AXE_SKILL = 261,
    GREAT_AXE_SKILL = 262,
    SCYTHE_SKILL = 263,
    POLEARM_SKILL = 264,
    KATANA_SKILL = 265,
    GREAT_KATANA_SKILL = 266,
    CLUB_SKILL = 267,
    STAFF_SKILL = 268,

    AUTOMATON_MELEE_SKILL = 278,
    AUTOMATON_RANGED_SKILL = 279,
    AUTOMATON_MAGIC_SKILL = 280,
    ARCHERY_SKILL = 281,
    MARKSMANSHIP_SKILL = 282,
    THROWING_SKILL = 283,

    SHIELD_SKILL = 286,
    PARRYING_SKILL = 287,
    DIVINE_MAGIC_SKILL = 288,
    HEALING_MAGIC_SKILL = 289,
    ENHA_MAG_SKILL = 290,
    ENFB_MAG_SKILL = 291,
    ELEM_MAGIC_SKILL = 292,
    DARK_MAGIC_SKILL = 293,
    SUMMONING_SKILL = 294,
    NINJUTSU_SKILL = 295,
    SINGING_SKILL = 296,
    STRING_SKILL = 297,
    WIND_SKILL = 298,
    BLUE_MAGIC_SKILL = 299,
    GEOMANCY_SKILL = 300,
    HANDBELL_SKILL = 301,

    BP_ABILITY_DELAY = 320,
    AVATAR_PERP_COST = 321,
    SONG_CAST_TIME = 322,
    CURE_CAST_TIME = 323,
    CALL_BEAST_DELAY = 324,
    QUICK_DRAW_DELAY = 325,
    WEAPON_SKILL_ACC = 326,
    WEAPON_SKILL_DAMAGE = 327,
    CRIT_HIT_DAMAGE = 328,
    CURE_POTENCY = 329,
    WALTZ_POTENCY = 330,
    WALTZ_DELAY = 331,
    SKLCHN_DMG = 332,
    CONSERVE_TP = 333,
    MAGIC_BURST_DMG = 334,
    MAG_CRIT_HIT_DMG = 335,
    SIC_AND_READY_ABILITY_DELAY_MINUS = 336,
    SONG_RECAST = 337,
    BARRAGE = 338,
    ELEMENTAL_SIPHON = 339,
    PHANTOM_ROLL_ABILITY_DELAY_MINUS = 340,
    REPAIR_POTENCY = 341,
    WALTZ_TP_COST_MINUS = 342,
    DRAIN_ASPIR_POTENCY = 343,

    HEALING_MAGIC_RECAST_DELAY_MINUS = 347,
    ELEMENTAL_MAGIC_RECAST_DELAY_MINUS = 348,
    ENFEEBLING_MAGIC_RECAST_DELAY_MINUS = 349,
    OCC_MAXIMIZES_MAGIC_ACCURACY = 350,
    OCC_QUICKENS_SPELLCASTING = 351,
    OCC_GRANTS_DMG_BONUS_BASED_ON_TP = 352,
    TP_BONUS_PLUS_50 = 353,
    QUADRUPLE_ATTACK = 354,
    ENHANCING_MAGIC_RECAST_DELAY_MINUS = 355,
    CURE_POTENCY_RCVD = 356,

    SAVE_TP_PLUS_10 = 360,
    MAGIC_DAMAGE = 362,
    BLOCK_CHANCE = 363,


    BP_ABILITY_DELAY_II = 366,

    PHALANX = 368,
    AVATAR_BLOOD_PACT_DMG = 369,
    REVERSE_FLOURISH = 370,
    REGEN_POTENCY = 371,
    EMBOLDEN = 372,

    ENHANCING_MAGIC_DURATION = 374,

    ENMITY_PER_UTSUSEMI = 379,
    PHYSICAL_DAMAGE_LIMIT = 380,

    STR = 512,
    DEX = 513,
    VIT = 514,
    AGI = 515,
    INT = 516,
    MND = 517,
    CHR = 518,
    STR_MINUS = 519,
    DEX_MINUS = 520,
    VIT_MINUS = 521,
    AGI_MINUS = 522,
    INT_MINUS = 523,
    MND_MINUS = 524,
    CHR_MINUS = 525,
    STR_PLUS_1_DEX_MINUS_1_VIT_MINUS = 526,
    --_[526]_=_"Cont_",
    --_[526]_=_"Cont_",
    STR_PLUS_1_DEX_MINUS_1_AGI_MINUS = 527,
    --_[527]_=_"Cont_",
    --_[527]_=_"Cont_",
    STR_PLUS_1_VIT_MINUS_1_AGI_MINUS = 528,
    --_[528]_=_"Cont_",
    --_[528]_=_"Cont_",
    STR_MINUS_1_DEX_PLUS_1_VIT_MINUS = 529,
    --_[529]_=_"Cont_",
    --_[529]_=_"Cont_",
    STR_MINUS_1_DEX_PLUS_1_AGI_MINUS = 530,
    --_[530]_=_"Cont_",
    --_[530]_=_"Cont_",
    DEX_PLUS_1_VIT_MINUS_1_AGI_MINUS = 531,
    --_[531]_=_"Cont_",
    --_[531]_=_"Cont_",
    STR_MINUS_1_DEX_MINUS_1_VIT = 532,
    --_[532]_=_"Cont_",
    --_[532]_=_"Cont_",
    STR_MINUS_1_VIT_PLUS_1_AGI_MINUS = 533,
    --_[533]_=_"Cont_",
    --_[533]_=_"Cont_",
    DEX_MINUS_1_VIT_PLUS_1_AGI_MINUS = 534,
    --_[534]_=_"Cont_",
    --_[534]_=_"Cont_",
    STR_MINUS_1_DEX_MINUS_1_AGI = 535,
    --_[535]_=_"Cont_",
    --_[535]_=_"Cont_",
    STR_MINUS_1_VIT_MINUS_1_AGI = 536,
    --_[536]_=_"Cont_",
    --_[536]_=_"Cont_",
    DEX_MINUS_1_VIT_MINUS_1_AGI = 537,
    --_[537]_=_"Cont_",
    --_[537]_=_"Cont_",
    AGI_PLUS_1_INT_MINUS_1_MND_MINUS = 538,
    --_[538]_=_"Cont_",
    --_[538]_=_"Cont_",
    AGI_PLUS_1_INT_MINUS_1_CHR_MINUS = 539,
    --_[539]_=_"Cont_",
    --_[539]_=_"Cont_",
    AGI_PLUS_1_MND_MINUS_1_CHR_MINUS = 540,
    --_[540]_=_"Cont_",
    --_[540]_=_"Cont_",
    AGI_MINUS_1_INT_PLUS_1_MND_MINUS = 541,
    --_[541]_=_"Cont_",
    --_[541]_=_"Cont_",
    AGI_MINUS_1_INT_PLUS_1_CHR_MINUS = 542,
    --_[542]_=_"Cont_",
    --_[542]_=_"Cont_",
    INT_PLUS_1_MND_MINUS_1_CHR_MINUS = 543,
    --_[543]_=_"Cont_",
    --_[543]_=_"Cont_",
    AGI_MINUS_1_INT_MINUS_1_MND = 544,
    --_[544]_=_"Cont_",
    --_[544]_=_"Cont_",
    AGI_MINUS_1_MND_PLUS_1_CHR_MINUS = 545,
    --_[545]_=_"Cont_",
    --_[545]_=_"Cont_",
    INT_MINUS_1_MND_PLUS_1_CHR_MINUS = 546,
    --_[546]_=_"Cont_",
    --_[546]_=_"Cont_",
    AGI_MINUS_1_INT_MINUS_1_CHR = 547,
    --_[547]_=_"Cont_",
    --_[547]_=_"Cont_",
    AGI_MINUS_1_MND_MINUS_1_CHR = 548,
    --_[548]_=_"Cont_",
    --_[548]_=_"Cont_",
    INT_MINUS_1_MND_MINUS_1_CHR = 549,
    --_[549]_=_"Cont_",
    --_[549]_=_"Cont_",
    STR_PLUS_1_DEX = 550,
    --_[550]_=_"Cont_",
    STR_PLUS_1_VIT = 551,
    --_[551]_=_"Cont_",
    STR_PLUS_1_AGI = 552,
    --_[552]_=_"Cont_",
    DEX_PLUS_1_AGI = 553,
    --_[553]_=_"Cont_",
    INT_PLUS_1_MND = 554,
    --_[554]_=_"Cont_",
    MND_PLUS_1_CHR = 555,
    --_[555]_=_"Cont_",
    INT_PLUS_1_MND_PLUS_1_CHR = 556,
    --_[556]_=_"Cont_",
    --_[556]_=_"Cont_",
    STR_PLUS_1_CHR = 557,
    --_[557]_=_"Cont_",
    STR_PLUS_1_INT = 558,
    --_[558]_=_"Cont_",
    STR_PLUS_1_MND = 559,
    --_[559]_=_"Cont_",

    COUNTER_PLUS_2 = 640,

    DMG = 740,
    DMG_PLUS_33 = 741,
    DMG_PLUS_65 = 742,
    DMG_PLUS_97 = 743,
    DMG_MINUS = 744,
    DMG_MINUS_33 = 745,
    DMG = 746,
    DMG_PLUS_33 = 747,
    DMG_PLUS_65 = 748,
    DMG_PLUS_97 = 749,
    DMG_MINUS = 750,
    DMG_MINUS_33 = 751,
    DELAY = 752,
    DELAY_PLUS_33 = 753,
    DELAY_PLUS_65 = 754,
    DELAY_PLUS_97 = 755,
    DELAY_MINUS = 756,
    DELAY_MINUS_33 = 757,
    DELAY_MINUS_65 = 758,
    DELAY_MINUS_97 = 759,
    DELAY = 760,
    DELAY_PLUS_33 = 761,
    DELAY_PLUS_65 = 762,
    DELAY_PLUS_97 = 763,
    DELAY_MINUS = 764,
    DELAY_MINUS_33 = 765,
    DELAY_MINUS_65 = 766,
    DELAY_MINUS_97 = 767,
    FIRE_RESIST = 768,
    ICE_RESIST = 769,
    WIND_RESIST = 770,
    EARTH_RESIST = 771,
    LIGHTNING_RESIST = 772,
    WATER_RESIST = 773,
    LIGHT_RESIST = 774,
    DARK_RESIST = 775,
    FIRE_RESIST_MINUS = 776,
    ICE_RESIST_MINUS = 777,
    WIND_RESIST_MINUS = 778,
    EARTH_RESIST_MINUS = 779,
    LIGHTNING_RESIST_MINUS = 780,
    WATER_RESIST_MINUS = 781,
    LIGHT_RESIST_MINUS = 782,
    DARK_RESIST_MINUS = 783,
    FIRE_RESIST_PLUS_WATER_RESIST_MINUS = 784,
    --_[784]_=_"Cont_",
    FIRE_RESIST_MINUS_WATER_RESIST = 785,
    --_[785]_=_"Cont_",
    ICE_RESIST_MINUS_WIND_RESIST = 786,
    --_[786]_=_"Cont_",
    WIND_RESIST_MINUS_EARTH_RESIST = 787,
    --_[787]_=_"Cont_",
    EARTH_RESIST_MINUS_LIGHTNING_RESIST = 788,
    --_[788]_=_"Cont_",
    LIGHTNING_RESIST_MINUS_WATER_RESIST = 789,
    --_[789]_=_"Cont_",
    LIGHT_RESIST_PLUS_DARK_RESIST_MINUS = 790,
    --_[790]_=_"Cont_",
    LIGHT_RESIST_MINUS_DARK_RESIST = 791,
    --_[791]_=_"Cont_",
    LIGHT_ELEMENTS_RESIST = 792,
    --_[792]_=_"Cont_",
    --_[792]_=_"Cont_",
    --_[792]_=_"Cont_",
    DARK_ELEMENTS_RESIST = 793,
    --_[793]_=_"Cont_",
    --_[793]_=_"Cont_",
    --_[793]_=_"Cont_",
    LIGHT_ELEMENTS_RESIST_PLUS_DARK_ELEMENTS_RESIST_MINUS = 794,
    --_[794]_=_"Cont_",
    --_[794]_=_"Cont_",
    --_[794]_=_"Cont_",
    --_[794]_=_"Cont_",
    --_[794]_=_"Cont_",
    --_[794]_=_"Cont_",
    --_[794]_=_"Cont_",
    LIGHT_ELEMENTS_RESIST_MINUS_DARK_ELEMENTS_RESIST = 795,
    --_[795]_=_"Cont_",
    --_[795]_=_"Cont_",
    --_[795]_=_"Cont_",
    --_[795]_=_"Cont_",
    --_[795]_=_"Cont_",
    --_[795]_=_"Cont_",
    --_[795]_=_"Cont_",
    ALL_ELEMENTAL_RESISTS = 796,
    --_[796]_=_"Cont_",
    --_[796]_=_"Cont_",
    --_[796]_=_"Cont_",
    --_[796]_=_"Cont_",
    --_[796]_=_"Cont_",
    --_[796]_=_"Cont_",
    --_[796]_=_"Cont_",
    ALL_ELEMENTAL_RESISTS_MINUS = 797,
    --_[797]_=_"Cont_",
    --_[797]_=_"Cont_",
    --_[797]_=_"Cont_",
    --_[797]_=_"Cont_",
    --_[797]_=_"Cont_",
    --_[797]_=_"Cont_",
    --_[797]_=_"Cont_",

    ADDITIONAL_EFFECT_FIRE_DMG = 832,
    ADDITIONAL_EFFECT_ICE_DMG = 833,
    ADDITIONAL_EFFECT_WIND_DMG = 834,
    ADDITIONAL_EFFECT_EARTH_DMG = 835,
    ADDITIONAL_EFFECT_LIGHTNING_DMG = 836,
    ADDITIONAL_EFFECT_WATER_DMG = 837,
    ADDITIONAL_EFFECT_LIGHT_DMG = 838,
    ADDITIONAL_EFFECT_DARKNESS_DMG = 839,
    ADDITIONAL_EFFECT_DISEASE = 840,
    ADDITIONAL_EFFECT_PARALYSIS = 841,
    ADDITIONAL_EFFECT_SILENCE = 842,
    ADDITIONAL_EFFECT_SLOW = 843,
    ADDITIONAL_EFFECT_STUN = 844,
    ADDITIONAL_EFFECT_POISON = 845,
    ADDITIONAL_EFFECT_FLASH = 846,
    ADDITIONAL_EFFECT_BLINDNESS = 847,
    ADDITIONAL_EFFECT_WEAKENS_DEFENSE = 848,
    ADDITIONAL_EFFECT_SLEEP = 849,
    ADDITIONAL_EFFECT_WEAKENS_ATTACK = 850,
    ADDITIONAL_EFFECT_IMPAIRS_EVASION = 851,
    ADDITIONAL_EFFECT_LOWERS_ACCURACY = 852,
    ADDITIONAL_EFFECT_LOWERS_MAGIC_EVASION = 853,
    ADDITIONAL_EFFECT_LOWERS_MAGIC_ATTACK = 854,
    ADDITIONAL_EFFECT_LOWERS_MAGIC_DEFENSE = 855,
    ADDITIONAL_EFFECT_LOWERS_MAGIC_ACCURACY = 856,

    SWORD_ENHANCEMENT_SPELL_DAMAGE = 896,
    SOULEATER = 897,

    SWORD_ENHANCEMENT_SPELL_DAMAGE = 899,

    MOVEMENT_SPEED = 913,

    FIRE_AFFINITY = 928,
    --_[928]_=_"Cont_",
    --_[928]_=_"Cont_",
    ICE_AFFINITY = 929,
    --_[929]_=_"Cont_",
    --_[929]_=_"Cont_",
    WIND_AFFINITY = 930,
    --_[930]_=_"Cont_",
    --_[930]_=_"Cont_",
    EARTH_AFFINITY = 931,
    --_[931]_=_"Cont_",
    --_[931]_=_"Cont_",
    LIGHTNING_AFFINITY = 932,
    --_[932]_=_"Cont_",
    --_[932]_=_"Cont_",
    WATER_AFFINITY = 933,
    --_[933]_=_"Cont_",
    --_[933]_=_"Cont_",
    LIGHT_AFFINITY = 934,
    --_[934]_=_"Cont_",
    --_[934]_=_"Cont_",
    DARK_AFFINITY = 935,
    --_[935]_=_"Cont_",
    --_[935]_=_"Cont_",
    FIRE_MAG_ACCURACY = 936,
    ICE_MAG_ACCURACY = 937,
    WIND_MAG_ACCURACY = 938,
    EARTH_MAG_ACCURACY = 939,
    LIGHTNING_MAG_ACCURACY = 940,
    WATER_MAG_ACCURACY = 941,
    LIGHT_MAG_ACCURACY = 942,
    DARK_MAG_ACCURACY = 943,
    FIRE_AFFINITY_MAGIC_DAMAGE = 944,
    ICE_AFFINITY_MAGIC_DAMAGE = 945,
    WIND_AFFINITY_MAGIC_DAMAGE = 946,
    EARTH_AFFINITY_MAGIC_DAMAGE = 947,
    LIGHTNING_AFFINITY_MAGIC_DAMAGE = 948,
    WATER_AFFINITY_MAGIC_DAMAGE = 949,
    LIGHT_AFFINITY_MAGIC_DAMAGE = 950,
    DARK_AFFINITY_MAGIC_DAMAGE = 951,
    FIRE_AFFINITY_AVATAR_PERP_COST_MINUS = 952,
    ICE_AFFINITY_AVATAR_PERP_COST_MINUS = 953,
    WIND_AFFINITY_AVATAR_PERP_COST_MINUS = 954,
    EARTH_AFFINITY_AVATAR_PERP_COST_MINUS = 955,
    THUNDER_AFFINITY_AVATAR_PERP_COST_MINUS = 956,
    WATER_AFFINITY_AVATAR_PERP_COST_MINUS = 957,
    LIGHT_AFFINITY_AVATAR_PERP_COST_MINUS = 958,
    DARK_AFFINITY_AVATAR_PERP_COST_MINUS = 959,



    FIRE_AFFINITY_RECAST_TIME_MINUS_2 = 960,
    --_[960]_=_"Cont_",
    ICE_AFFINITY_RECAST_TIME_MINUS_2 = 961,
    --_[961]_=_"Cont_",
    WIND_AFFINITY_RECAST_TIME_MINUS_2 = 962,
    --_[962]_=_"Cont_",
    EARTH_AFFINITY_RECAST_TIME_MINUS_2 = 963,
    --_[963]_=_"Cont_",
    LIGHTNING_AFFINITY_RECAST_TIME_MINUS_2 = 964,
    --_[964]_=_"Cont_",
    WATER_AFFINITY_RECAST_TIME_MINUS_2 = 965,
    --_[965]_=_"Cont_",
    LIGHT_AFFINITY_RECAST_TIME_MINUS_2 = 966,
    --_[966]_=_"Cont_",
    DARK_AFFINITY_RECAST_TIME_MINUS_2 = 967,
    --_[967]_=_"Cont_",


    FIRE_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 968,
    --_[968]_=_"Cont_",
    ICE_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 969,
    --_[969]_=_"Cont_",
    WIND_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 970,
    --_[970]_=_"Cont_",
    EARTH_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 971,
    --_[971]_=_"Cont_",
    LIGHTNING_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 972,
    --_[972]_=_"Cont_",
    WATER_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 973,
    --_[973]_=_"Cont_",
    LIGHT_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 974,
    --_[974]_=_"Cont_",
    DARK_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 975,
    --_[975]_=_"Cont_",
    FIRE_AFFIN_BLOOD_PACT_DELAY_MINUS = 976,
    ICE_AFFIN_BLOOD_PACT_DELAY_MINUS = 977,
    WIND_AFFIN_BLOOD_PACT_DELAY_MINUS = 978,
    EARTH_AFFIN_BLOOD_PACT_DELAY_MINUS = 979,
    LIGHTNING_AFFIN_BLOOD_PACT_DELAY_MINUS = 980,
    WATER_AFFIN_BLOOD_PACT_DELAY_MINUS = 981,
    LIGHT_AFFIN_BLOOD_PACT_DELAY_MINUS = 982,
    DARK_AFFIN_BLOOD_PACT_DELAY_MINUS = 983,
    FIRE_AFFIN_RECAST_TIME_MINUS_2_PERCENT = 984,
    ICE_AFFIN_RECAST_TIME_MINUS_2_PERCENT = 985,
    WIND_AFFIN_RECAST_TIME_MINUS_2_PERCENT = 986,
    EARTH_AFFIN_RECAST_TIME_MINUS_2_PERCENT = 987,
    LIGHTNING_AFFIN_RECAST_TIME_MINUS_2_PERCENT = 988,
    WATER_AFFIN_RECAST_TIME_MINUS_2_PERCENT = 989,
    LIGHT_AFFIN_RECAST_TIME_MINUS_2_PERCENT = 990,
    DARK_AFFIN_RECAST_TIME_MINUS_2_PERCENT = 991,
    FIRE_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 992,
    ICE_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 993,
    WIND_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 994,
    EARTH_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 995,
    LIGHTNING_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 996,
    WATER_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 997,
    LIGHT_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 998,
    DARK_AFFINITY_CASTING_TIME_MINUS_2_PERCENT = 999,


    FIRE_AFFINITY_CASTING_TIME_MINUS_6_PERCENT = 1000,
    --_[1000]_=_"Cont_",
    ICE_AFFINITY_CASTING_TIME_MINUS_6_PERCENT = 1001,
    --_[1001]_=_"Cont_",
    WIND_AFFINITY_CASTING_TIME_MINUS_6_PERCENT = 1002,
    --_[1002]_=_"Cont_",
    EARTH_AFFINITY_CASTING_TIME_MINUS_6_PERCENT = 1003,
    --_[1003]_=_"Cont_",
    LIGHTNING_AFFINITY_CASTING_TIME_MINUS_6_PERCENT = 1004,
    --_[1004]_=_"Cont_",
    WATER_AFFINTIY_CASTING_TIME_MINUS_6_PERCENT = 1005,
    --_[1005]_=_"Cont_",
    LIGHT_AFFINITY_CASTING_TIME_MINUS_6_PERCENT = 1006,
    --_[1006]_=_"Cont_",
    DARK_AFFINITY_CASTING_TIME_MINUS_6_PERCENT = 1007,
    --_[1007]_=_"Cont_",


    FIRE_AFFINITY_RECAST_TIME_MINUS_6_PERCENT = 1008,
    --_[1008]_=_"Cont_",
    ICE_AFFINITY_RECAST_TIME_MINUS_6_PERCENT = 1009,
    --_[1009]_=_"Cont_",
    WIND_AFFINITY_RECAST_TIME_MINUS_6_PERCENT = 1010,
    --_[1010]_=_"Cont_",
    EARTH_AFFINITY_RECAST_TIME_MINUS_6_PERCENT = 1011,
    --_[1011]_=_"Cont_",
    LIGHTNING_AFFINITY_RECAST_TIME_MINUS_6_PERCENT = 1012,
    --_[1012]_=_"Cont_",
    WATER_AFFINITY_RECAST_TIME_MINUS_6_PERCENT = 1013,
    --_[1013]_=_"Cont_",
    LIGHT_AFFINITY_RECAST_TIME_MINUS_6_PERCENT = 1014,
    --_[1014]_=_"Cont_",
    DARK_AFFINITY_RECAST_TIME_MINUS_6_PERCENT = 1015,
    --_[1015]_=_"Cont_",

    BACKHAND_BLOW_DMG = 1024,
    SPINNING_ATTACK_DMG = 1025,
    HOWLING_FIST_DMG = 1026,
    DRAGON_KICK_DMG = 1027,
    VIPER_BITE_DMG = 1028,
    SHADOWSTITCH_DMG = 1029,
    CYCLONE_DMG = 1030,
    EVISCERATION_DMG = 1031,
    BURNING_BLADE_DMG = 1032,
    SHINING_BLADE_DMG = 1033,
    CIRCLE_BLADE_DMG = 1034,
    SAVAGE_BLADE_DMG = 1035,
    FREEZEBITE_DMG = 1036,
    SHOCKWAVE_DMG = 1037,
    GROUND_STRIKE_DMG = 1038,
    SICKLE_MOON_DMG = 1039,
    GALE_AXE_DMG = 1040,
    SPINNING_AXE_DMG = 1041,
    CALAMITY_DMG = 1042,
    DECIMATION_DMG = 1043,
    IRON_TEMPEST_DMG = 1044,
    STURMWIND_DMG = 1045,
    KEEN_EDGE_DMG = 1046,
    STEEL_CYCLONE_DMG = 1047,
    NIGHTMARE_SCYTHE_DMG = 1048,
    SPINNING_SCYTHE_DMG = 1049,
    VORPAL_SCYTHE_DMG = 1050,
    SPIRAL_HELL_DMG = 1051,
    LEG_SWEEP_DMG = 1052,
    VORPAL_THRUST_DMG = 1053,
    SKEWER_DMG = 1054,
    IMPULSE_DRIVE_DMG = 1055,
    BLADE_TO_DMG = 1056,
    BLADE_CHI_DMG = 1057,
    BLADE_TEN_DMG = 1058,
    BLADE_KU_DMG = 1059,
    TACHI_GOTEN_DMG = 1060,
    TACHI_JINPU_DMG = 1061,
    TACHI_KOKI_DMG = 1062,
    TACHI_KASHA_DMG = 1063,
    BRAINSHAKER_DMG = 1064,
    SKULLBREAKER_DMG = 1065,
    JUDGMENT_DMG = 1066,
    BLACK_HALO_DMG = 1067,
    ROCK_CRUSHER_DMG = 1068,
    SHELL_CRUSHER_DMG = 1069,
    FULL_SWING_DMG = 1070,
    RETRIBUTION_DMG = 1071,
    DULLING_ARROW_DMG = 1072,
    BLAST_ARROW_DMG = 1073,
    ARCHING_ARROW_DMG = 1074,
    EMPYREAL_ARROW_DMG = 1075,
    HOT_SHOT_DMG = 1076,
    SPLIT_SHOT_DMG = 1077,
    SNIPER_SHOT_DMG = 1078,
    DETONATOR_DMG = 1079,
    WEAPON_SKILL_DMG = 1080,
    FINAL_HEAVEN_DMG = 1081,
    ASCETICS_FURY_DMG = 1082,
    STRINGING_PUMMEL_DMG = 1083,
    VICTORY_SMITE_DMG = 1084,
    MERCY_STROKE_DMG = 1085,
    PYRIC_KLEOS_DMG = 1086,
    MANDALIC_STAB_DMG = 1087,
    MORDANT_RIME_DMG = 1088,
    RUDRAS_STORM_DMG = 1089,
    KNIGHTS_OF_ROUND_DMG = 1090,
    DEATH_BLOSSOM_DMG = 1091,
    EXPIACION_DMG = 1092,
    CHANT_DU_CYGNE_DMG = 1093,
    RANDGRITH_DMG = 1094,
    MYSTIC_BOON_DMG = 1095,
    SCOURGE_DMG = 1096,
    TORCLEAVER_DMG = 1097,
    ONSLAUGHT_DMG = 1098,
    PRIMAL_REND_DMG = 1099,
    CLOUDSPLITTER_DMG = 1100,
    METATRON_TORMENT_DMG = 1101,
    KINGS_JUSTICE_DMG = 1102,
    UKKOS_FURY_DMG = 1103,
    CATASTROPHE_DMG = 1104,
    INSURGENCY_DMG = 1105,
    QUIETUS_DMG = 1106,
    GEIRSKOGUL_DMG = 1107,
    DRAKESBANE_DMG = 1108,
    CAMLANNS_TORMENT_DMG = 1109,
    BLADE_METSU_DMG = 1110,
    BLADE_KAMU_DMG = 1111,
    BLADE_HI_DMG = 1112,
    TACHI_KAITEN_DMG = 1113,
    TACHI_RANA_DMG = 1114,
    TACHI_FUDO_DMG = 1115,
    GATE_OF_TARTARUS_DMG = 1116,
    OMNISCIENCE_DMG = 1117,
    VIDOHUNIR_DMG = 1118,
    GARLAND_OF_BLISS_DMG = 1119,
    NAMAS_ARROW_DMG = 1120,
    JISHNUS_RADIANCE_DMG = 1121,
    TRUEFLIGHT_DMG = 1122,
    CORONACH_DMG = 1123,
    LEADEN_SALUTE_DMG = 1124,
    WILDFIRE_DMG = 1125,
    DIMIDIATION_DMG = 1126,
    EXUDATION_DMG = 1127,
    SHIJIN_SPIRAL_DMG = 1128,
    EXENTERATOR_DMG = 1129,
    REQUIESCAT_DMG = 1130,
    UPHEAVAL_DMG = 1131,
    ENTROPY_DMG = 1132,
    STARDIVER_DMG = 1133,
    BLADE_SHUN_DMG = 1134,
    TACHI_SHOHA_DMG = 1135,
    REALMRAZER_DMG = 1136,
    SHATTERSOUL_DMG = 1137,
    RESOLUTION_DMG = 1138,
    RUINATOR_DMG = 1139,
    LAST_STAND_DMG = 1140,

    DEF_PLUS_10 = 1152,
    EVASION_PLUS_3 = 1153,
    MAG_EVASION_PLUS_3 = 1154,
    PHYSICAL_DAMAGE_TAKEN_MINUS_2_PERCENT = 1155,
    MAGIC_DAMAGE_TAKEN_MINUS_2_PERCENT = 1156,
    SPELL_INTERRUPTION_RATE_DOWN_2_PERCENT = 1157,
    OCC_RESISTANCE_TO_STATUS_AILMENTS_PLUS_2 = 1158,

    PET_PHY_DMG_TAKEN_MINUS_2_PERCENT = 1246,
    PET_MAGIC_DMG_TAKEN_MINUS_2_PERCENT = 1247,
    ENHANCING_MAGIC_EFFECT_DURATION = 1248,
    HELIX_EFFECT_DURATION = 1249,
    INDI_EFFECT_DURATION = 1250,
    ENFEEBLING_MAGIC_DURATION = 1251,

    MEDITATE_DURATION = 1264,

    MIGHTY_STRIKES = 1280,
    HUNDRED_FISTS = 1281,
    BENEDICTION = 1282,
    MANAFONT = 1283,
    CHAINSPELL = 1284,
    PERFECT_DODGE = 1285,
    INVINCIBLE = 1286,
    BLOOD_WEAPON = 1287,
    FAMILIAR = 1288,
    SOUL_VOICE = 1289,
    EAGLE_EYE_SHOT = 1290,
    MEIKYO_SHISUI = 1291,
    MIJIN_GAKURE = 1292,
    SPIRIT_SURGE = 1293,
    ASTRAL_FLOW = 1294,
    AZURE_LORE = 1295,
    WILD_CARD = 1296,
    OVERDRIVE = 1297,
    TRANCE = 1298,
    TABLUA_RASA = 1299,
    BOLSTER = 1300,
    ELEMENTAL_SFORZO = 1301,

    SAVAGERY = 1328,
    AGGRESSIVE_AIM = 1329,
    WARRIORS_CHARGE = 1330,
    TOMAHAWK = 1331,

    PENANCE = 1334,
    FORMLESS_STRIKES = 1335,
    INVIGORATE = 1336,
    MANTRA = 1337,

    PROTECTRA_V = 1340,
    MARTYR = 1341,
    SHELLRA_V = 1342,
    DEVOTION = 1343,

    INCREASES_ANCIENT_MAGIC_II_DAMAGE = 1346,
    REDUCES_ANCIENT_MAGIC_II_CASTING_TIME = 1347,
    INCREASES_ANCIENT_MAGIC_II_ACCURACY = 1348,
    REDUCES_ANCIENT_MAGIC_II_MP_COST = 1349,

    DIA_III = 1352,
    SLOW_II = 1353,
    PHALANX_II = 1354,
    BIO_III = 1355,
    BLIND_II = 1356,
    PARALYZE_II = 1357,
    AURA_STEAL = 1358,
    AMBUSH = 1359,
    FEINT = 1360,
    ENH_ASSASSINS_CHARGE_EFFECT = 1361,

    IRON_WILL = 1364,
    FEALTY = 1365,
    CHIVALRY = 1366,
    GUARDIAN = 1367,

    DARK_SEAL = 1370,
    DIABOLIC_EYE = 1371,
    MUTED_SOUL = 1372,
    DESPERATE_BLOWS = 1373,

    KILLER_INSTINCT = 1376,
    FERAL_HOWL = 1377,
    BEAST_AFFINITY = 1378,
    BEAST_HEALER = 1379,

    FOE_SIRVENTE = 1382,
    TROUBADOUR = 1383,
    ENH_ADVENTURERS_DIRGE_EFFECT = 1384,
    NIGHTINGALE = 1385,

    RECYCLE      = 1388,
    SNAPSHOT     = 1389,
    FLASHY_SHOT  = 1390,
    STEALTH_SHOT = 1391,

    SHIKIKOYO = 1394,
    OVERWHELM = 1395,
    BLADE_BASH = 1396,
    IKISHOTEN = 1397,

    INCREASES_ELEM_NINJUTSU_III_DAMAGE = 1400,
    SANGE = 1401,
    ENH_NINJA_TOOL_EXPERTISE_EFFECT = 1402,
    REDUCES_ELEM_NINJUTSU_III_CAST_TIME = 1403,

    DEEP_BREATHING = 1406,
    ANGON = 1407,
    STRAFE = 1408,
    EMPATHY = 1409,

    REDUCES_SP_BLOOD_PACT_MP_COST = 1412,
    INC_SP_BLOOD_PACT_MAGIC_BURST_DMG = 1413,
    INCREASES_SP_BLOOD_PACT_ACCURACY = 1414,
    INC_SP_BLOOD_PACT_MAGIC_CRIT_DMG_ = 1415,

    CONVERGENCE = 1418,
    ENCHAINMENT = 1419,
    ASSIMILATION = 1420,
    DIFFUSION = 1421,

    WINNING_STREAK = 1424,
    LOADED_DECK = 1425,
    FOLD = 1426,
    SNAKE_EYE = 1427,

    OPTIMIZATION = 1430,
    FINE_MINUS_TUNING = 1431,
    VENTRILOQUY = 1432,
    ROLE_REVERSAL = 1433,

    NO_FOOT_RISE = 1436,
    FAN_DANCE = 1437,
    SABER_DANCE = 1438,
    CLOSED_POSITION = 1439,

    ENH_ALTRUISM_AND_FOCALIZATION = 1442,
    ENLIGHTENMENT = 1443,
    ENH_TRANQUILITY_AND_EQUANIMITY = 1444,
    STORMSURGE = 1445,

    MENDING_HALATION = 1448,
    RADIAL_ARCANA = 1449,
    CURATIVE_RECANTATION = 1450,
    PRIMEVAL_ZEAL = 1451,

    BATTUTA = 1454,
    RAYKE = 1455,
    INSPIRE = 1456,
    SLEIGHT_OF_SWORD = 1457,

    PARRYING_RATE = 1472,

    BACKHAND_BLOW_DMG = 1536,
    SPINNING_ATTACK_DMG = 1537,
    HOWLING_FIST_DMG = 1538,
    DRAGON_KICK_DMG = 1539,
    VIPER_BITE_DMG = 1540,
    SHADOWSTITCH_DMG = 1541,
    CYCLONE_DMG = 1542,
    EVISCERATION_DMG = 1543,
    BURNING_BLADE_DMG = 1544,
    SHINING_BLADE_DMG = 1545,
    CIRCLE_BLADE_DMG = 1546,
    SAVAGE_BLADE_DMG = 1547,
    FREEZEBITE_DMG = 1548,
    SHOCKWAVE_DMG = 1549,
    GROUND_STRIKE_DMG = 1550,
    SICKLE_MOON_DMG = 1551,
    GALE_AXE_DMG = 1552,
    SPINNING_AXE_DMG = 1553,
    CALAMITY_DMG = 1554,
    DECIMATION_DMG = 1555,
    IRON_TEMPEST_DMG = 1556,
    STURMWIND_DMG = 1557,
    KEEN_EDGE_DMG = 1558,
    STEEL_CYCLONE_DMG = 1559,
    NIGHTMARE_SCYTHE_DMG = 1560,
    SPINNING_SCYTHE_DMG = 1561,
    VORPAL_SCYTHE_DMG = 1562,
    SPIRAL_HELL_DMG = 1563,
    LEG_SWEEP_DMG = 1564,
    VORPAL_THRUST_DMG = 1565,
    SKEWER_DMG = 1566,
    IMPULSE_DRIVE_DMG = 1567,
    BLADE_TO_DMG = 1568,
    BLADE_CHI_DMG = 1569,
    BLADE_TEN_DMG = 1570,
    BLADE_KU_DMG = 1571,
    TACHI_GOTEN_DMG = 1572,
    TACHI_JINPU_DMG = 1573,
    TACHI_KOKI_DMG = 1574,
    TACHI_KASHA_DMG = 1575,
    BRAINSHAKER_DMG = 1576,
    SKULLBREAKER_DMG = 1577,
    JUDGMENT_DMG = 1578,
    BLACK_HALO_DMG = 1579,
    ROCK_CRUSHER_DMG = 1580,
    SHELL_CRUSHER_DMG = 1581,
    FULL_SWING_DMG = 1582,
    RETRIBUTION_DMG = 1583,
    DULLING_ARROW_DMG = 1584,
    BLAST_ARROW_DMG = 1585,
    ARCHING_ARROW_DMG = 1586,
    EMPYREAL_ARROW_DMG = 1587,
    SPLIT_SHOT_DMG = 1588,
    HOT_SHOT_DMG = 1589,
    SNIPER_SHOT_DMG = 1590,
    DETONATOR_DMG = 1591,
    WEAPON_SKILL_DMG = 1592,
    FINAL_HEAVEN_DMG = 1593,
    ASCETICS_FURY_DMG = 1594,
    STRINGING_PUMMEL_DMG = 1595,
    VICTORY_SMITE_DMG = 1596,
    MERCY_STROKE_DMG = 1597,
    PYRIC_KLEOS_DMG = 1598,
    MANDALIC_STAB_DMG = 1599,
    MORDANT_RIME_DMG = 1600,
    RUDRAS_STORM_DMG = 1601,
    KNIGHTS_OF_ROUND_DMG = 1602,
    DEATH_BLOSSOM_DMG = 1603,
    EXPIACION_DMG = 1604,
    CHANT_DU_CYGNE_DMG = 1605,
    RANDGRITH_DMG = 1606,
    MYSTIC_BOON_DMG = 1607,
    SCOURGE_DMG = 1608,
    TORCLEAVER_DMG = 1609,
    ONSLAUGHT_DMG = 1610,
    PRIMAL_REND_DMG = 1611,
    CLOUDSPLITTER_DMG = 1612,
    METATRON_TORMENT_DMG = 1613,
    KINGS_JUSTICE_DMG = 1614,
    UKKOS_FURY_DMG = 1615,
    CATASTROPHE_DMG = 1616,
    INSURGENCY_DMG = 1617,
    QUIETUS_DMG = 1618,
    GEIRSKOGUL_DMG = 1619,
    DRAKESBANE_DMG = 1620,
    CAMLANNS_TORMENT_DMG = 1621,
    BLADE_METSU_DMG = 1622,
    BLADE_KAMU_DMG = 1623,
    BLADE_HI_DMG = 1624,
    TACHI_KAITEN_DMG = 1625,
    TACHI_RANA_DMG = 1626,
    TACHI_FUDO_DMG = 1627,
    GATE_OF_TARTARUS_DMG = 1628,
    OMNISCIENCE_DMG = 1629,
    VIDOHUNIR_DMG = 1630,
    GARLAND_OF_BLISS_DMG = 1631,
    NAMAS_ARROW_DMG = 1632,
    JISHNUS_RADIANCE_DMG = 1633,
    TRUEFLIGHT_DMG = 1634,
    CORONACH_DMG = 1635,
    LEADEN_SALUTE_DMG = 1636,
    WILDFIRE_DMG = 1637,
    DIMIDIATION_DMG = 1638,
    EXUDATION_DMG = 1639,
    SHIJIN_SPIRAL_DMG = 1640,
    EXENTERATOR_DMG = 1641,
    REQUIESCAT_DMG = 1642,
    UPHEAVAL_DMG = 1643,
    ENTROPY_DMG = 1644,
    STARDIVER_DMG = 1645,
    BLADE_SHUN_DMG = 1646,
    TACHI_SHOHA_DMG = 1647,
    REALMRAZER_DMG = 1648,
    SHATTERSOUL_DMG = 1649,
    RESOLUTION_DMG = 1650,
    RUINATOR_DMG = 1651,
    LAST_STAND_DMG = 1652,

    PET_STR = 1792,
    PET_DEX = 1793,
    PET_VIT = 1794,
    PET_AGI = 1795,
    PET_INT = 1796,
    PET_MND = 1797,
    PET_CHR = 1798,
    PET_STR_MINUS = 1799,
    PET_DEX_MINUS = 1800,
    PET_VIT_MINUS = 1801,
    PET_AGI_MINUS = 1802,
    PET_INT_MINUS = 1803,
    PET_MND_MINUS = 1804,
    PET_CHR_MINUS = 1805,
    PET_STR_PLUS_1_DEX_PLUS_1_VIT = 1806,
    --_[1806]_=_"Cont_",
}

return m
