require("scripts/globals/npc_util")
require("modules/module_utils")
-----------------------------------

local m = Module:new("pop_hnm_from_kindreds_seal")

m:addOverride("xi.zones.Dragons_Aery.npcs.qm0.onTrade", function(player, npc, trade)
    local ID = require("scripts/zones/Dragons_Aery/IDs")
    if
        not GetMobByID(ID.mob.FAFNIR):isSpawned() and
        not GetMobByID(ID.mob.NIDHOGG):isSpawned()
    then
        if npcUtil.tradeHasExactly(trade, { { xi.item.KINDREDS_SEAL, 99 } }) then
            npcUtil.popFromQM(player, npc, ID.mob.NIDHOGG)
            player:confirmTrade()
        elseif
            npcUtil.tradeHasExactly(trade, 3339) and
            npcUtil.popFromQM(player, npc, ID.mob.FAFNIR)
        then
            player:confirmTrade()

            -- Stop force spawn affecting the actual ToD
            npc:timer(5000, function()
                local fafnir = GetMobByID(ID.mob.FAFNIR)

                if fafnir ~= nil then
                    fafnir:setLocalVar("ignoreTOD", 1)
                end
            end)
        elseif
            npcUtil.tradeHasExactly(trade, 3340) and
            npcUtil.popFromQM(player, npc, ID.mob.NIDHOGG)
        then
            player:confirmTrade()
        end
    end
end)

m:addOverride("xi.zones.Behemoths_Dominion.npcs.qm2.onTrade", function(player, npc, trade)
    local ID = require("scripts/zones/Behemoths_Dominion/IDs")
    if
        not GetMobByID(ID.mob.BEHEMOTH):isSpawned() and
        not GetMobByID(ID.mob.KING_BEHEMOTH):isSpawned()
    then
        if npcUtil.tradeHasExactly(trade, { { xi.item.KINDREDS_SEAL, 99 } }) then
            npcUtil.popFromQM(player, npc, ID.mob.KING_BEHEMOTH)
            player:confirmTrade()
        elseif
            npcUtil.tradeHasExactly(trade, 3341) and
            npcUtil.popFromQM(player, npc, ID.mob.BEHEMOTH)
        then
            player:confirmTrade()

            -- Stop force spawn affecting the actual ToD
            npc:timer(5000, function()
                local behemoth = GetMobByID(ID.mob.BEHEMOTH)

                if behemoth ~= nil then
                    behemoth:setLocalVar("ignoreTOD", 1)
                end
            end)
        elseif
            npcUtil.tradeHasExactly(trade, 3342) and
            npcUtil.popFromQM(player, npc, ID.mob.KING_BEHEMOTH)
        then
            player:confirmTrade()
        end
    end
end)

m:addOverride("xi.zones.Valley_of_Sorrows.npcs.qm1.onTrade", function(player, npc, trade)
    local ID = require("scripts/zones/Valley_of_Sorrows/IDs")
    if
        not GetMobByID(ID.mob.ADAMANTOISE):isSpawned() and
        not GetMobByID(ID.mob.ASPIDOCHELONE):isSpawned()
    then
        if npcUtil.tradeHasExactly(trade, { { xi.item.KINDREDS_SEAL, 99 } }) then
            npcUtil.popFromQM(player, npc, ID.mob.ASPIDOCHELONE)
            player:confirmTrade()
        elseif
            npcUtil.tradeHasExactly(trade, 3343) and
            npcUtil.popFromQM(player, npc, ID.mob.ADAMANTOISE)
        then
            player:confirmTrade()

            -- Stop force spawn affecting the actual ToD
            npc:timer(5000, function()
                local adamantoise = GetMobByID(ID.mob.ADAMANTOISE)

                if adamantoise ~= nil then
                    adamantoise:setLocalVar("ignoreTOD", 1)
                end
            end)
        elseif
            npcUtil.tradeHasExactly(trade, 3344) and
            npcUtil.popFromQM(player, npc, ID.mob.ASPIDOCHELONE)
        then
            player:confirmTrade()
        end
    end
end)

return m
