-------------------------------------------
-- Pirates event zones
-------------------------------------------
require('modules/module_utils')
-------------------------------------------
local m = Module:new('pirates_zones')

local refreshEnum = function()
    zones[xi.zone.SHIP_BOUND_FOR_MHAURA].mob = xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA].mob
    zones[xi.zone.SHIP_BOUND_FOR_SELBINA].mob = xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA].mob
    zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].mob = xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].mob
    zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].npc = xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_MHAURA_PIRATES].npc
    zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].mob = xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].mob
    zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].npc = xi.pirates.zones[xi.zone.SHIP_BOUND_FOR_SELBINA_PIRATES].npc
end

local function eventStartConditions(player, zone)
    if
        zone:getLocalVar('stateSet') == 0 and
        ((player and player:getGMLevel() == 0) or
        #(zone:getPlayers()) == 0) -- start event if the gm enters an empty zone
    then
        return true
    else
        return false
    end
end

m:addOverride('xi.zones.Mhaura.Zone.onZoneIn', function(player, prevZone)
    local cs     = super(player, prevZone)

    local shipId = 17797182

    if cs == 202 then
        local ship = GetNPCByID(shipId)
        ship:setAnimBegin(VanadielTime())
    end

    return cs
end)

m:addOverride('xi.zones.Selbina.Zone.onZoneIn', function(player, prevZone)
    local cs = super(player, prevZone)

    local shipId = 17793088

    if cs == 202 then
        local ship = GetNPCByID(shipId)
        ship:setAnimBegin(VanadielTime())
    end

    return cs
end)

m:addOverride('xi.zones.Ship_bound_for_Mhaura.Zone.onZoneIn', function(player, prevZone)
    local zoneID = player:getZoneID()
    local zone = GetZone(zoneID)

    if
        player:getXPos() == 0 and
        player:getYPos() == 0 and
        player:getZPos() == 0
    then
        if
            eventStartConditions(player, zone)
        then
            zone:setLocalVar('stateSet', 1)
            zone:setLocalVar('state', 2)
            zone:setLocalVar('transportTime', os.time())
        end
    end

    return super(player, prevZone)
end)

m:addOverride('xi.zones.Ship_bound_for_Mhaura.Zone.onTransportEvent', function(player, transport)
    player:getZone():setLocalVar('stateSet', 0)
    player:getZone():setLocalVar('state', 1)

    super(player, transport)
end)

m:addOverride('xi.zones.Ship_bound_for_Mhaura.Zone.onGameHour', function(zone)
    local zoneID = zone:getID()
    local ID = zones[zoneID]
    local hour = VanadielHour()
    if
        hour >= 20 or
        hour < 4
    then
        if
            math.random() < 0.20 and
            not GetMobByID(ID.mob.PHANTOM):isSpawned()
        then
            GetMobByID(ID.mob.PHANTOM):spawn()
        end
    elseif GetMobByID(ID.mob.PHANTOM):isSpawned() then
        DespawnMob(ID.mob.PHANTOM)
    end

    local mob = GetMobByID(ID.mob.SEA_HORROR)
    -- 3% chance per game hour (if not spawned, and min repop time)
    if
        math.random(0, 100) < 3 and
        not mob:isSpawned() and
        os.time() > mob:getLocalVar("respawnTime")
    then
        mob:spawn()
    end
end)

m:addOverride('xi.zones.Ship_bound_for_Mhaura.Zone.onZoneTick', function(zone)
    local zoneID = zone:getID()
    local ID = zones[zoneID]
    if zone:getLocalVar('state') == 1 then
        if GetMobByID(ID.mob.PHANTOM):isSpawned() then
            DespawnMob(ID.mob.PHANTOM)
        end

        if GetMobByID(ID.mob.SEA_HORROR):isSpawned() then
            DespawnMob(ID.mob.SEA_HORROR)
        end

        zone:setLocalVar('state', 0)
        xi.sea_creatures.despawn(zoneID)
    elseif zone:getLocalVar('state') == 2 then
        if GetMobByID(ID.mob.SEA_HORROR):isSpawned() then -- make sure we dont have horror from previous or docked zone
            DespawnMob(ID.mob.SEA_HORROR)
        end

        xi.sea_creatures.checkSpawns(zoneID, 5, 1) -- 5 percent on init
        zone:setLocalVar('state', 0)
    end

    if os.time() - zone:getLocalVar('transportTime') % 60 then
        xi.sea_creatures.checkSpawns(zoneID, 1, 2) -- 1 percent per vana minute, 2 total mobs
    end
end)

m:addOverride('xi.zones.Ship_bound_for_Selbina.Zone.onZoneIn', function(player, prevZone)
    local zoneID = player:getZoneID()
    local zone = GetZone(zoneID)

    if
        player:getXPos() == 0 and
        player:getYPos() == 0 and
        player:getZPos() == 0
    then
        if
            eventStartConditions(player, zone)
        then
            zone:setLocalVar('stateSet', 1)
            zone:setLocalVar('state', 2)
            zone:setLocalVar('transportTime', os.time())
        end
    end

    return super(player, prevZone)
end)

m:addOverride('xi.zones.Ship_bound_for_Selbina.Zone.onTransportEvent', function(player, transport)
    player:getZone():setLocalVar('stateSet', 0)
    player:getZone():setLocalVar('state', 1)

    super(player, transport)
end)

m:addOverride('xi.zones.Ship_bound_for_Selbina.Zone.onGameHour', function(zone)
    local zoneID = zone:getID()
    local ID = zones[zoneID]
    local hour = VanadielHour()

    if hour >= 20 or hour < 4 then
        if
            math.random() < 0.20 and
            not GetMobByID(ID.mob.PHANTOM):isSpawned()
        then
            GetMobByID(ID.mob.PHANTOM):spawn()
        end
    else
        if GetMobByID(ID.mob.PHANTOM):isSpawned() then
            DespawnMob(ID.mob.PHANTOM)
        end

        if GetMobByID(ID.mob.ENAGAKURE):isSpawned() then
            DespawnMob(ID.mob.ENAGAKURE)
        end
    end

    local mob = GetMobByID(ID.mob.SEA_HORROR)
    -- 3% chance per game hour (if not spawned, and min repop time)
    if
        math.random(0, 100) < 3 and
        not mob:isSpawned() and
        os.time() > mob:getLocalVar("respawnTime")
    then
        mob:spawn()
    end
end)

m:addOverride('xi.zones.Ship_bound_for_Selbina.Zone.onZoneTick', function(zone)
    local zoneID = zone:getID()
    local ID = zones[zoneID]
    if zone:getLocalVar('state') == 1 then
        if GetMobByID(ID.mob.PHANTOM):isSpawned() then
            DespawnMob(ID.mob.PHANTOM)
        end

        if GetMobByID(ID.mob.SEA_HORROR):isSpawned() then
            DespawnMob(ID.mob.SEA_HORROR)
        end

        zone:setLocalVar('state', 0)
        xi.sea_creatures.despawn(zoneID)
    elseif zone:getLocalVar('state') == 2 then
        if GetMobByID(ID.mob.SEA_HORROR):isSpawned() then -- make sure we dont have horror from previous or docked zone
            DespawnMob(ID.mob.SEA_HORROR)
        end

        xi.sea_creatures.checkSpawns(zoneID, 5, 1) -- 5 percent on init
        zone:setLocalVar('state', 0)
    end

    if os.time() - zone:getLocalVar('transportTime') % 60 then
        xi.sea_creatures.checkSpawns(zoneID, 1, 2) -- 1 percent per vana minute, 2 total mobs
    end
end)

m:addOverride('xi.zones.Ship_bound_for_Mhaura.Zone.onInitialize', function(zone)
    refreshEnum()

    super(zone)
end)

m:addOverride('xi.zones.Ship_bound_for_Mhaura_Pirates.Zone.onInitialize', function(zone)
    refreshEnum()

    local zoneID = zone:getID()
    local ID = zones[zoneID]
    xi.pirates.init(zoneID)
end)

m:addOverride('xi.zones.Ship_bound_for_Mhaura_Pirates.Zone.onZoneIn', function(player, prevZone)
    local cs = -1
    local zoneID = player:getZoneID()
    local zone = GetZone(zoneID)

    if
        player:getXPos() == 0 and
        player:getYPos() == 0 and
        player:getZPos() == 0
    then
        local position      = math.random(-2, 2) + 0.150
        local stateSet      = zone:getLocalVar('stateSet')
        local state         = zone:getLocalVar('state')
        local transportTime = zone:getLocalVar('transportTime', os.time())

        player:setPos(position, -2.100, 3.250, 64)

        if
            eventStartConditions(player, zone)
        then
            zone:setLocalVar('stateSet', 1)
            zone:setLocalVar('state', 2)
            zone:setLocalVar('transportTime', os.time())

            print('zone:' .. zone:getName() .. ' stateSet: ' .. stateSet .. ' state: ' .. state .. ' transportTime:' .. transportTime)
        end
    end

    return cs
end)

m:addOverride('xi.zones.Ship_bound_for_Mhaura_Pirates.Zone.onGameHour', function(zone)
    local zoneID = zone:getID()
    local ID = zones[zoneID]
    local hour = VanadielHour()
    if
        hour >= 20 or
        hour < 4
    then
        if
            math.random() < 0.20 and
            not GetMobByID(ID.mob.PHANTOM):isSpawned()
        then
            GetMobByID(ID.mob.PHANTOM):spawn()
        end
    elseif GetMobByID(ID.mob.PHANTOM):isSpawned() then
        DespawnMob(ID.mob.PHANTOM)
    end
end)

m:addOverride('xi.zones.Ship_bound_for_Mhaura_Pirates.Zone.onZoneTick', function(zone)
    local zoneID = zone:getID()
    local ID = zones[zoneID]

    if zone:getLocalVar('state') == 1 then
        zone:setLocalVar('state', 0)

        if GetMobByID(ID.mob.PHANTOM):isSpawned() then
            DespawnMob(ID.mob.PHANTOM)
        end

        xi.sea_creatures.despawn(zoneID)
    elseif zone:getLocalVar('state') == 2 then
        zone:setLocalVar('state', 0)
        xi.pirates.start(zoneID)
        xi.sea_creatures.checkSpawns(zoneID, 5, 1) -- 5 percent on init
    end

    if os.time() - zone:getLocalVar('transportTime') % 60 then
        xi.sea_creatures.checkSpawns(zoneID, 1, 2) -- 1 percent per vana minute, 2 total mobs
    end

    -- print('[PIRATES] CurrentTime: ' .. os.time() .. ' transportTime: ' .. zone:getLocalVar('transportTime') .. ' tripTime: ' .. os.time()-zone:getLocalVar('transportTime'))
    xi.pirates.update(zoneID, zone, os.time()-zone:getLocalVar('transportTime'))
end)

m:addOverride('xi.zones.Ship_bound_for_Mhaura_Pirates.Zone.onTransportEvent', function(player, transport)
    player:getZone():setLocalVar('stateSet', 0)
    player:getZone():setLocalVar('state', 1)

    super(player, transport)
end)


m:addOverride('xi.zones.Ship_bound_for_Selbina.Zone.onInitialize', function(zone)
    refreshEnum()

    super(zone)
end)

m:addOverride('xi.zones.Ship_bound_for_Selbina_Pirates.Zone.onInitialize', function(zone)
    refreshEnum()

    local zoneID = zone:getID()
    local ID = zones[zoneID]
    xi.pirates.init(zoneID)
end)

m:addOverride('xi.zones.Ship_bound_for_Selbina_Pirates.Zone.onZoneIn', function(player, prevZone)
    local cs = -1
    local zoneID = player:getZoneID()
    local zone = GetZone(zoneID)

    if
        player:getXPos() == 0 and
        player:getYPos() == 0 and
        player:getZPos() == 0
    then
        local position      = math.random(-2, 2) + 0.150
        local stateSet      = zone:getLocalVar('stateSet')
        local state         = zone:getLocalVar('state')
        local transportTime = zone:getLocalVar('transportTime', os.time())

        player:setPos(position, -2.100, 3.250, 64)

        if
            eventStartConditions(player, zone)
        then
            zone:setLocalVar('stateSet', 1)
            zone:setLocalVar('state', 2)
            zone:setLocalVar('transportTime', os.time())

            print('zone:' .. zone:getName() .. ' stateSet: ' .. stateSet .. ' state: ' .. state .. ' transportTime:' .. transportTime)
        end
    end

    return cs
end)

m:addOverride('xi.zones.Ship_bound_for_Selbina_Pirates.Zone.onGameHour', function(zone)
    local zoneID = zone:getID()
    local ID = zones[zoneID]
    local hour = VanadielHour()
    if
        hour >= 20 or
        hour < 4
    then
        if
            math.random() < 0.20 and
            not GetMobByID(ID.mob.PHANTOM):isSpawned()
        then
            GetMobByID(ID.mob.PHANTOM):spawn()
        end
    elseif GetMobByID(ID.mob.PHANTOM):isSpawned() then
        DespawnMob(ID.mob.PHANTOM)
    end
end)

m:addOverride('xi.zones.Ship_bound_for_Selbina_Pirates.Zone.onZoneTick', function(zone)
    local zoneID = zone:getID()
    local ID = zones[zoneID]

    if zone:getLocalVar('state') == 1 then
        zone:setLocalVar('state', 0)

        if GetMobByID(ID.mob.PHANTOM):isSpawned() then
            DespawnMob(ID.mob.PHANTOM)
        end

        xi.sea_creatures.despawn(zoneID)
    elseif zone:getLocalVar('state') == 2 then
        zone:setLocalVar('state', 0)
        xi.pirates.start(zoneID)
        xi.sea_creatures.checkSpawns(zoneID, 5, 1) -- 5 percent on init
    end

    if os.time() - zone:getLocalVar('transportTime') % 60 then
        xi.sea_creatures.checkSpawns(zoneID, 1, 2) -- 1 percent per vana minute, 2 total mobs
    end

    -- print('[PIRATES] CurrentTime: ' .. os.time() .. ' transportTime: ' .. zone:getLocalVar('transportTime') .. ' tripTime: ' .. os.time()-zone:getLocalVar('transportTime'))
    xi.pirates.update(zoneID, zone, os.time()-zone:getLocalVar('transportTime'))
end)

m:addOverride('xi.zones.Ship_bound_for_Selbina_Pirates.Zone.onTransportEvent', function(player, transport)
    player:getZone():setLocalVar('stateSet', 0)
    player:getZone():setLocalVar('state', 1)

    super(player, transport)
end)

return m
