-------------------------------------------
-- Pirates event mobs
-------------------------------------------
require('modules/module_utils')
-------------------------------------------
local m = Module:new('pirates_mobs')

local pirateMobList =
{
    ['Ship_bound_for_Mhaura'] =
    {
        ['Sea_Horror'] =
        {
            [xi.mod.SLEEPRES] = 100,
        },

        ['Silverhook'] =
        { 
            [xi.mod.SILENCERES] = 100,
            [xi.mod.BINDRES]    = 100,
            [xi.mod.MDEF]       =  50,
        },
    },

    ['Ship_bound_for_Selbina'] =
    {
        ['Sea_Horror'] =
        {
            [xi.mod.SLEEPRES] = 100,
        },
        
        ['Blackbeard'] =
        {
            [xi.mod.SILENCERES] = 100,
            [xi.mod.BINDRES]    = 100,
            [xi.mod.MDEF]       =  50,
        },
    },
}

for ship, mobs in pairs(pirateMobList) do
    for mobName, mods in pairs(mobs) do
        -- Ensure tables are created for overriding
        xi.module.ensureTable(string.format('xi.zones.%s.mobs.%s', ship, mobName))

        -- Apply mods and mobMods
        m:addOverride(
            string.format('xi.zones.%s.mobs.%s.onMobSpawn', ship, mobName),
            function(mob)
                mob:setMobMod(xi.mobMod.ROAM_COOL, 8)

                for modName, modValue in pairs(mods) do
                    mob:setMod(modName, modValue)
                end
            end
        )
    end
end

return m
