-----------------------------------
-- Mobskill Magic Burst 
-----------------------------------
require("modules/module_utils")
require("scripts/globals/mobskills")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("mobskill_magic_burst")

local elements =
{
    [xi.damageType.FIRE]    = xi.element.FIRE,
    [xi.damageType.ICE]     = xi.element.ICE,
    [xi.damageType.WIND]    = xi.element.WIND,
    [xi.damageType.EARTH]   = xi.element.EARTH,
    [xi.damageType.THUNDER] = xi.element.THUNDER,
    [xi.damageType.WATER]   = xi.element.WATER,
    [xi.damageType.LIGHT]   = xi.element.LIGHT,
    [xi.damageType.DARK]    = xi.element.DARK,
}

m:addOverride("xi.mobskills.mobFinalAdjustments", function(dmg, mob, skill, target, attackType, damageType, shadowbehav)
    local damage = super(dmg, mob, skill, target, attackType, damageType, shadowbehav)

    if
        attackType == xi.attackType.MAGICAL and
        mob:isPet()
    then
        local mbDamage = xi.mobskills.mobAddBonuses(mob, target, damage, elements[damageType], skill)

        if mbDamage > damage then
            damage = mbDamage
            skill:setMsg(xi.msg.basic.MOBSKILL_MAGIC_BURST)
        end
    end

    return damage
end)

return m
