-------------------------------------------
-- Login Campaign
-------------------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
require("scripts/events/login_campaign")
-------------------------------------------
local m = Module:new("system_login_campaign")

-- ONLY 19 ITEMS PER PRICE BRACKET POSSIBLE!! (20 will overwrite the ingame back button.)
local loginCampaignData =
{
    -- STATIC, DOESNT ROTATE
    [1] =
    {
        ["price"] = 50,
        ["items"] =
        {
            5113, -- Cracked Nut
            xi.item.CAVORTING_WORM,
            xi.item.PIECE_OF_COPSE_CANDY,
            5204, -- Elvaan Mochi
            5295, -- Elvaan Rice Cake
            5206, -- Galka Mochi
            xi.item.LITTLE_LUGWORM,
            5203, -- Hume Mochi
            5294, -- Hume rice cake
            5733, -- Miracle Milk
            6537, -- Pinch of Pungent Powder III
            6193, -- Purple Spriggan Lolli
        },
    },

    -- STATIC, DOESNT ROTATE
    [5] =
    {
        ["price"] = 200,
        ["items"] =
        {
            xi.item.CURTANA,
            xi.item.CHUNK_OF_DIORITE,
            xi.item.FLASK_OF_ROMAEVE_SPRING_WATER,
        },
    },

    -- COSTUMES/ETC
    [9] =
    {
        ["price"] = 300,
        ["cycle"] = true,
        ["items"] =
        {
            -- Cycle #1 January/May/September
            {
                xi.item.TRAINEE_AXE,
                xi.item.TRAINEE_BURIN,
                xi.item.TRAINEE_GLOVES,
                xi.item.TRAINEE_HAMMER,
                xi.item.TRAINEE_KNIFE,
                xi.item.TRAINEES_NEEDLE,
                xi.item.TRAINEE_SCISSORS,
                xi.item.TRAINEES_SPECTACLES,
                xi.item.TRAINEE_SWORD,
            },


            -- Cycle #2 February/June/October
            {
                xi.item.CHOCOBO_MASQUE,
                xi.item.CHOCOBO_SUIT,
                xi.item.MANDRAGORA_MASQUE,
                xi.item.MANDRAGORA_SUIT,
                xi.item.MOOGLE_MASQUE,
                xi.item.MOOGLE_SUIT,
                19221, -- Firefly
                xi.item.GOTHIC_GAUNTLETS,
                15551, -- Shikaree Ring
            },

            -- Cycle #3 March/July/November
            {
                xi.item.PUPILS_SHIRT,
                xi.item.PUPILS_CAMISA,
                xi.item.PUPILS_TROUSERS,
                xi.item.PUPILS_SHOES,
                xi.item.TRACK_PANTS,
                xi.item.TRACK_SHIRT,
                xi.item.GOTHIC_SABATONS,
                11401, -- Rambler's Gaiters
                16279, -- Pile Chain
            },


            -- Cycle #4 -- April/August/December
            {
                xi.item.ARTHROS_CAP,
                xi.item.BUFFALO_CAP,
                xi.item.MORBOL_CAP,
                xi.item.RARAB_CAP,
                xi.item.SHEEP_CAP,
                18953, -- Beluga
                18867, -- Daedalus Hammer
                19157, -- Surviver
                19222, -- Wurger
            },
        },
    },

    [13] =
    {
        ["price"] = 500,
        ["cycle"] = true,
        ["items"] =
        {
            -- Cycle #1 January/May/September
            {
                xi.item.ANCIENT_BEASTCOIN,
                xi.item.CHOCOBO_SHIELD,
                xi.item.GLINTING_SHIELD,
                xi.item.HATCHLING_SHIELD,
                xi.item.JANUS_GUARD,
                xi.item.KAMLANAUTS_SHIELD,
                xi.item.MALICE_MASHER,
                xi.item.MOOGLE_GUARD,
                xi.item.MORBOL_SHIELD,
                xi.item.SLIME_SHIELD,
            },

            -- Cycle #2 February/June/October

            {
                xi.item.ANCIENT_BEASTCOIN,
                18399, -- Charm Wand
                xi.item.CHOCOBO_PULLUS_TORQUE,
                xi.item.DETONATOR_BELT,
                xi.item.DROVERS_BELT,
                xi.item.HEARTBEATER_P1,
                xi.item.SHELL_SCEPTER,
                10851, -- Slime Belt
                xi.item.WORM_MASQUE_P1,
                10849, -- Yagudo Belt
            },

            -- Cycle #3 March/July/November
            {
                xi.item.ANCIENT_BEASTCOIN,
                xi.item.BLIZZARD_BRAND,
                xi.item.ESIKUVA,
                xi.item.EXCALIPOOR,
                xi.item.FIRETONGUE,
                xi.item.INFILTRATOR,
                xi.item.KAMLANAUTS_SWORD,
                xi.item.ONION_SWORD_II,
                xi.item.SAVE_THE_QUEEN_II,
                xi.item.WIND_KNIFE,
            },

            -- Cycle #4 -- April/August/December
            {
                xi.item.ANCIENT_BEASTCOIN,
                xi.item.HEARTSTOPPER,
                xi.item.MARVELOUS_CHEER,
                xi.item.MELON_SLICER,
                xi.item.MUTSUNOKAMI,
                -- 21786, -- Poison Axe (ITEM NOT ADDED TO LSB YET?)
                xi.item.SEIKA_UCHIWA,
                xi.item.SHA_WUJINGS_LANCE,
                xi.item.SILVER_GUN,
                xi.item.ZANMATO,
            },
        },
    },

    -- MOUNTS
    [17] =
    {
        ["price"] = 750,
        ["items"] =
        {
            -- TODO: Add mounts which only have a KeyItem.
            -- https://www.bg-wiki.com/ffxi/Levitus_key
            -- https://www.bg-wiki.com/ffxi/Omega_whistle
            -- https://www.bg-wiki.com/ffxi/Morbol_companion
            -- https://www.bg-wiki.com/ffxi/Sheep_companion

            10072, -- ♪Adamantoise
            10058, -- ♪Beetle
            10053, -- ♪Bomb
            10077, -- ♪Buffalo
            10050, -- ♪Tiger
            10068, -- ♪Coeurl
            10051, -- ♪Crab
            10056, -- ♪Crawler
            10073, -- ♪Dhalmel
            10074, -- ♪Doll
            10069, -- ♪Goobbue
            10064, -- ♪Hippogryph
            10060, -- ♪Magic Pot
            10070, -- ♪Raaz
            10066, -- ♪Spheroid
            10061, -- ♪Tulfaire
            10062, -- ♪Warmachine
            10078, -- ♪Wivre
            10063, -- ♪Xzomit
        },
    },

    -- STATIC, DOESNT ROTATE
    [21] =
    {
        ["price"] = 1000,
        ["items"] =
        {
            xi.item.SUMMERSTONE,
            xi.item.SPRINGSTONE,
            xi.item.GEM_OF_THE_NORTH,
            xi.item.GEM_OF_THE_EAST,
            xi.item.GEM_OF_THE_WEST,
            415,  -- Aldebaran Horn
            xi.item.AUTUMN_TREE,
            xi.item.BIRCH_TREE,
            xi.item.CHERRY_TREE,
            192,  -- Hoary Spire
            3641, -- Kabuto-kazari
            3642, -- Katana-kazari
        },
    },

    -- STATIC, DOESNT ROTATE
    [25] =
    {
        ["price"] = 1500,
        ["items"] =
        {
            xi.item.CHOCOBO_COMMODE,
            9277, -- Silver Voucher
            3585, -- Galley Kitchen
            xi.item.HARPSICHORD,
            3744, -- Mandragora Pot
            154,  -- Miniature Airship
            xi.item.MEMORIAL_CAKE,
            xi.item.MOOGLE_BED,
            xi.item.ORCHESTRION,
            xi.item.SHOBUHOUOU_KABUTO,
            xi.item.STUFFED_CHOCOBO,
            88,   -- Timepiece
            25726, -- Kupo Suit
        },
    },

    -- NICE STUFF TO HAVE (Rotates)
    [29] =
    {
        ["price"] = 1500,
        ["cycle"] = true,
        ["items"] =
        {
            -- Cycle #1 January/May/September
            {
                16057, -- Aesir Ear Pendant
                11546, -- Aesir Mantle
                11589, -- Aesir Torque
                xi.item.AMIR_PUGGAREE,
                xi.item.AMIR_KORAZIN,
                xi.item.AMIR_KOLLUKS,
                xi.item.AMIR_DIRS,
                xi.item.AMIR_BOOTS,
                xi.item.DIA_WAND,
                17192, -- Ifrit's Bow
                18019, -- X's Knife
            },

            -- Cycle #2 February/June/October
            {
                16058, -- Colossus's Earring
                11547, -- Colossus's Mantle
                11590, -- Colossus's Torque
                xi.item.HAMAYUMI,
                18109, -- Leviathan's Couse
                xi.item.PAHLUWAN_QALANSUWA,
                xi.item.PAHLUWAN_KHAZAGAND,
                xi.item.PAHLUWAN_DASTANAS,
                xi.item.PAHLUWAN_SERAWEELS,
                xi.item.PAHLUWAN_CRACKOWS,
                18057, -- Y's Scythe
            },


            -- Cycle #3 March/July/November
            {
                14931, -- Carbuncle's Cuffs
                18063, -- Garuda's Sickle
                18404, -- Ramuh's Mace
                17711, -- Shiva's Shotel
                xi.item.STONE_GORGET,
                18021, -- Titan's Baselarde
                xi.item.YIGIT_TURBAN,
                xi.item.YIGIT_GOMLEK,
                xi.item.YIGIT_GAGES,
                xi.item.YIGIT_SERAWEELS,
                xi.item.YIGIT_CRACKOWS,
                18101, -- Z's Trident
            },

            -- Cycle #4 -- April/August/December
            {
                15351, -- Bounding Boots
                xi.item.EMPRESS_HAIRPIN,
                16368, -- Herder's Subligar
                14986, -- Ochimusha Kote
                15221, -- Patroclus's Helm
                15220, -- Rain hat
                15737, -- Sarutobi Kyahan
                17965, -- Sirocco Axe
                17709, -- Swan Bilbo
                16734, -- Pendragon Axe
                17212, -- Selene's Bow
                17924, -- Tungi
            },
        },
    },
}

local prizes = {}

for month = 1, 12 do
    prizes[month] = {}

    for categoryID, categoryInfo in pairs(loginCampaignData) do
        local items = categoryInfo.items

        if categoryInfo.cycle then
            items = categoryInfo.items[(month - 1) % 4 + 1] -- jan(1) => 1, feb(2) => 2..., may(5) => 1
        end

        prizes[month][categoryID] =
        {
            price = categoryInfo.price,
            items = items,
        }
    end
end

m:addOverride("xi.events.loginCampaign.isCampaignActive", function()
    if xi.settings.main.ENABLE_LOGIN_CAMPAIGN == 1 then
        return true
    end

    return false
end)

local function getMonth()
    return tonumber(os.date("%m", os.time()))
end

local function getYear()
    return tonumber(os.date("%Y", os.time()))
end

m:addOverride("xi.events.loginCampaign.onGameIn", function(player)
    if player:isCrystalWarrior() then
        return
    end

    if not xi.events.loginCampaign.isCampaignActive()  then
        return
    end

    local zoneId      = player:getZoneID()
    local ID          = zones[zoneId]
    local loginPoints = player:getCurrency('login_points')

    local playercMonth = player:getCharVar('LoginCampaignMonth')
    local playercYear  = player:getCharVar('LoginCampaignYear')
    local nextMidnight = player:getCharVar('LoginCampaignNextMidnight')
    local loginCount   = player:getCharVar('LoginCampaignLoginNumber')

    local loginCampaignMonth = getMonth()
    local loginCampaignYear  = getYear()

    -- Carry last months points if there's any
    if playercMonth ~= loginCampaignMonth or playercYear ~= loginCampaignYear then
        if loginPoints > 1500 then
            player:setCurrency('login_points', 1500)
            player:messageSpecial(ID.text.CARRIED_OVER_POINTS, 0, 1500)
        elseif loginPoints ~= 0 then
            player:messageSpecial(ID.text.CARRIED_OVER_POINTS, 0, loginPoints)
        end

        player:setCharVar('LoginCampaignMonth', loginCampaignMonth)
        player:setCharVar('LoginCampaignYear', loginCampaignYear)
        loginCount = 1  -- Reset to 1 for the first login of the new month/year

        -- Show info about new campaign month/year
        player:messageSpecial(ID.text.LOGIN_CAMPAIGN_UNDERWAY, loginCampaignYear, loginCampaignMonth)
    elseif nextMidnight ~= getMidnight() then
        loginCount = loginCount + 1  -- Increment for daily logins within the same month/year
    else
        return -- If it's not a new day or month, do nothing
    end

    player:setCharVar('LoginCampaignNextMidnight', getMidnight())

    -- Award login points based on the login count
    if loginCount == 1 then
        player:addCurrency('login_points', 500)
        player:messageSpecial(ID.text.LOGIN_NUMBER, 0, loginCount, 500, player:getCurrency('login_points'))
    else
        player:addCurrency('login_points', 200)
        player:messageSpecial(ID.text.LOGIN_NUMBER, 0, loginCount, 200, player:getCurrency('login_points'))
    end

    player:setCharVar('LoginCampaignLoginNumber', loginCount)
end)

m:addOverride("xi.events.loginCampaign.onTrigger", function(player, csid)
    if player:isCrystalWarrior() then
        player:printToPlayer('You cannot claim login rewards as a Crystal Warrior.', xi.msg.channel.SYSTEM_3)
        return
    end

    if not xi.events.loginCampaign.isCampaignActive() then
        -- TODO: What do the moogles do when the campaign isn't active?
        return
    end

    local loginPoints = player:getCurrency('login_points')
    local cDate = bit.bor(getYear(), bit.lshift(getMonth(), 28))
    local currentLoginCampaign = prizes[getMonth()]
    local price = {}
    local priceShift = {}
    local hideOptions = 0

    -- Makes a table of prices
    for k, v in pairs(currentLoginCampaign) do
        price[k] = currentLoginCampaign[k]['price']
    end

    -- Bit shifts values of prices (Defaults to 0 if price not in table)
    priceShift[1] = price[1] or 0
    priceShift[2] = bit.lshift(price[5] or 0, 16)
    priceShift[3] = price[9] or 0
    priceShift[4] = bit.lshift(price[13] or 0, 16)
    priceShift[5] = price[17] or 0
    priceShift[6] = bit.lshift(price[21] or 0, 16)
    priceShift[7] = price[25] or 0
    priceShift[8] = bit.lshift(price[29] or 0, 16)

    -- Combines two 16bit values to a single 32bit that will be passed as a CS param
    local priceBit1 = bit.bor(priceShift[1], priceShift[2])
    local priceBit2 = bit.bor(priceShift[3], priceShift[4])
    local priceBit3 = bit.bor(priceShift[5], priceShift[6])
    local priceBit4 = bit.bor(priceShift[7], priceShift[8])

    -- Turning on bits in hideOptions will make choices disappear
    for i = 1, #priceShift do
        if priceShift[i] == 0 then
            hideOptions = bit.bor(hideOptions, bit.lshift(1, i - 1))
        end
    end

    -- Eight param is not used/unknown
    player:startEvent(csid, cDate, loginPoints, priceBit1, priceBit2, priceBit3, priceBit4, hideOptions)
end)

m:addOverride("xi.events.loginCampaign.onEventUpdate", function(player, csid, option)
    if not xi.events.loginCampaign.isCampaignActive() then
        return
    end

    local showItems = bit.band(option, 31) -- first 32 bits are for showing correct item list
    local itemSelected = bit.band(bit.rshift(option, 5), 31)
    local itemQuantity = bit.band(bit.rshift(option, 11), 511)
    local currentLoginCampaign = prizes[getMonth()]
    local loginPoints = player:getCurrency('login_points')

    if
        showItems == 1 or
        showItems == 5 or
        showItems == 9 or
        showItems == 13 or
        showItems == 17 or
        showItems == 21 or
        showItems == 25 or
        showItems == 29
    then
        local items = {}
        for i = 1, 20 do
            if currentLoginCampaign[showItems]["items"][i] ~= nil then
                table.insert(items, currentLoginCampaign[showItems]["items"][i])
            else
                table.insert(items, 0)
            end
        end

        player:updateEvent(
            bit.bor(items[1], bit.lshift(items[2], 16)),
            bit.bor(items[3], bit.lshift(items[4], 16)),
            bit.bor(items[5], bit.lshift(items[6], 16)),
            bit.bor(items[7], bit.lshift(items[8], 16)),
            bit.bor(items[9], bit.lshift(items[10], 16)),
            bit.bor(items[11], bit.lshift(items[12], 16)),
            bit.bor(items[13], bit.lshift(items[14], 16)),
            bit.bor(items[15], bit.lshift(items[16], 16)))
    elseif
        showItems == 2 or
        showItems == 6 or
        showItems == 10 or
        showItems == 14 or
        showItems == 18 or
        showItems == 22 or
        showItems == 26 or
        showItems == 30
    then
        local price = currentLoginCampaign[showItems - 1]["price"]
        local totalItemsMask = (2 ^ 20 - 1) - (2 ^ #currentLoginCampaign[showItems - 1]["items"] - 1)  -- Uses 20 bits and sets to 1 for items not used.
        local items = {}

        for i = 1, 20 do
            if currentLoginCampaign[showItems - 1]["items"][i] ~= nil then
                table.insert(items, currentLoginCampaign[showItems - 1]["items"][i])
            else
                table.insert(items, 0)
            end
        end

        player:updateEvent(
            bit.bor(items[17], bit.lshift(items[18], 16)),
            bit.bor(items[19], bit.lshift(items[20], 16)),
            totalItemsMask,
            price,
            loginPoints)
    else
        if itemQuantity == 1 then
            if npcUtil.giveItem(player, { { currentLoginCampaign[showItems - 2]["items"][itemSelected + 1], itemQuantity } }) then
                player:delCurrency("login_points", currentLoginCampaign[showItems - 2]["price"] * itemQuantity)
                player:updateEvent(
                    currentLoginCampaign[showItems - 2]["items"][itemSelected + 1],
                    player:getCurrency("login_points"), -- Login Points after purchase
                    0, -- Unknown (most likely totalItemMask)
                    currentLoginCampaign[showItems - 2]["price"],
                    loginPoints) -- Login points before purchase
            end
        else
            print(string.format("%s has attempted to purchase %s of item: %s from login campaign.", player, itemQuantity, currentLoginCampaign[showItems - 2]["items"][itemSelected + 1], itemQuantity))
        end
    end
end)

return m
