------------------------------
-- Dynamis QM Control
-- Controls which Dynamis Bosses can be spawned
-- Also sets progress variables to unlock each boss
-----------------------------
require("scripts/globals/npc_util")
require("modules/module_utils")
require("scripts/globals/utils")
local req = require("modules/catseyexi/lua/additive_overrides/systems/dynamis_2_0/neo_dyna_requirements")
-----------------------------
local m = Module:new("dynamis_qm_control")

local nqDiabolosNames = { "Diabolos_Spade", "Diabolos_Heart", "Diabolos_Diamond", "Diabolos_Club" }
local hqDiabolosNames = { "Diabolos_Somnus", "Diabolos_Nox", "Diabolos_Umbra", "Diabolos_Letum" }

local QM =
{
    ["Dynamis-Bastok"] =
    {
        qm0 =
        {
            ["GuDha_Effigy"] = { xi.item.STEELWALL_BIJOU },
            ["Arch_GuDha_Effigy"] = {
                xi.item.FIENDISH_TOME_CHAPTER_6,
                xi.item.FIENDISH_TOME_CHAPTER_7,
                xi.item.FIENDISH_TOME_CHAPTER_8,
                xi.item.FIENDISH_TOME_CHAPTER_9,
                xi.item.FIENDISH_TOME_CHAPTER_10,
            },
        },
    },
    ["Dynamis-San_dOria"] =
    {
        qm0 =
        {
            ["Overlords_Tombstone"] = { xi.item.BARBARIC_BIJOU },
            ["Arch_Overlord_Tombstone"] = {
                xi.item.FIENDISH_TOME_CHAPTER_1,
                xi.item.FIENDISH_TOME_CHAPTER_2,
                xi.item.FIENDISH_TOME_CHAPTER_3,
                xi.item.FIENDISH_TOME_CHAPTER_4,
                xi.item.FIENDISH_TOME_CHAPTER_5,
            },
        },
    },
    ["Dynamis-Windurst"] =
    {
        qm0 =
        {
            ["Tzee_Xicu_Idol"] = { xi.item.DIVINE_BIJOU },
            ["Arch_Tzee_Xicu_Idol"] = {
                xi.item.FIENDISH_TOME_CHAPTER_11,
                xi.item.FIENDISH_TOME_CHAPTER_12,
                xi.item.FIENDISH_TOME_CHAPTER_13,
                xi.item.FIENDISH_TOME_CHAPTER_14,
                xi.item.FIENDISH_TOME_CHAPTER_15,
            },
        },
    },
    ["Dynamis-Jeuno"] =
    {
        qm0 =
        {
            ["Goblin_Golem"] = { xi.item.ROVING_BIJOU },
            ["Arch_Goblin_Golem"] = {
                xi.item.FIENDISH_TOME_CHAPTER_16,
                xi.item.FIENDISH_TOME_CHAPTER_17,
                xi.item.FIENDISH_TOME_CHAPTER_18,
                xi.item.FIENDISH_TOME_CHAPTER_19,
                xi.item.FIENDISH_TOME_CHAPTER_20,
            },
        },
    },
    ["Dynamis-Beaucedine"] =
    {
        qm0 =
        {
            ["Angra_Mainyu"] = { xi.item.LEERING_BIJOU },
            ["Arch_Angra_Mainyu"] = {
                xi.item.FIENDISH_TOME_CHAPTER_21,
                xi.item.FIENDISH_TOME_CHAPTER_22,
                xi.item.FIENDISH_TOME_CHAPTER_23,
                xi.item.FIENDISH_TOME_CHAPTER_24,
                xi.item.FIENDISH_TOME_CHAPTER_25,
            },
        },
    },
    ["Dynamis-Xarcabard"] =
    {
        qm0 =
        {
            ["Dynamis_Lord"] = { xi.item.SHROUDED_BIJOU },
            -- ["Arch_Dynamis_Lord"] = {
            --     xi.item.FIENDISH_TOME_CHAPTER_26,
            --     xi.item.FIENDISH_TOME_CHAPTER_27,
            --     xi.item.FIENDISH_TOME_CHAPTER_28,
            --     xi.item.FIENDISH_TOME_CHAPTER_29,
            --     xi.item.FIENDISH_TOME_CHAPTER_30,
            -- },
        },
    },
    ["Dynamis-Valkurm"] =
    {
        qm0 =
        {
            ["Cirrate_Christelle"] = { xi.item.CREEPERS_JUJU },
            ["Arch_Christelle"] = {
                xi.item.FIENDISH_TOME_II_CHAPTER_1,
                xi.item.FIENDISH_TOME_II_CHAPTER_2,
                xi.item.FIENDISH_TOME_II_CHAPTER_3,
                xi.item.FIENDISH_TOME_II_CHAPTER_4,
            },
        },
    },
    ["Dynamis-Buburimu"] =
    {
        qm0 =
        {
            ["Apocalyptic_Beast"] = { xi.item.REVELATORY_JUJU },
            ["Arch_Apocalyptic_Beast"] = {
                xi.item.FIENDISH_TOME_II_CHAPTER_5,
                xi.item.FIENDISH_TOME_II_CHAPTER_6,
                xi.item.FIENDISH_TOME_II_CHAPTER_7,
                xi.item.FIENDISH_TOME_II_CHAPTER_8,
                xi.item.FIENDISH_TOME_II_CHAPTER_9,
            },
        },
    },
    ["Dynamis-Qufim"] =
    {
        qm0 =
        {
            ["Antaeus"] = { xi.item.UNDYING_JUJU },
            ["Arch_Antaeus"] = {
                xi.item.FIENDISH_TOME_II_CHAPTER_10,
                xi.item.FIENDISH_TOME_II_CHAPTER_11,
                xi.item.FIENDISH_TOME_II_CHAPTER_12,
                xi.item.FIENDISH_TOME_II_CHAPTER_13,
            },
        },
    },
    ["Dynamis-Tavnazia"] = {
        qm0 = {
            ["Diabolos_Spade"] = { xi.item.HERALDS_JUJU },
            ["Diabolos_Somnus"] = {
                xi.item.FIENDISH_TOME_II_CHAPTER_14,
                xi.item.FIENDISH_TOME_II_CHAPTER_15,
                xi.item.FIENDISH_TOME_II_CHAPTER_16,
                xi.item.FIENDISH_TOME_II_CHAPTER_17,
            },
        },
    },
}

local function getMobIDs(zone, mobNames)
    local mobIDs = {}

    for _, mobName in ipairs(mobNames) do
        local results = zone:queryEntitiesByName(mobName)
        if results then
            for _, mob in ipairs(results) do
                table.insert(mobIDs, mob:getID())
            end
        end
    end

    return mobIDs
end

local function getRandomMobID(zone, mobNames)
    local mobIDs = getMobIDs(zone, mobNames)
    if #mobIDs > 0 then
        return mobIDs[math.random(#mobIDs)]
    end
    return nil
end


for zoneName, npcs in pairs(QM) do
    for npcName, npcInfo in pairs(npcs) do
        local npcPath = string.format("xi.zones.%s.npcs.%s", zoneName, npcName)

        m:addOverride(npcPath .. ".onTrade", function(player, npc, trade)
            local zone = player:getZone()

            for mobName, tradeList in pairs(npcInfo) do
                local mobID

                if zoneName == "Dynamis-Tavnazia" then
                    if mobName == "Diabolos_Spade" then
                        mobID = getRandomMobID(zone, nqDiabolosNames)
                    elseif mobName == "Diabolos_Somnus" then
                        mobID = getRandomMobID(zone, hqDiabolosNames)
                    end
                else
                    local mobIDs = getMobIDs(zone, { mobName })
                    mobID = mobIDs[1]
                end

                if mobID and GetMobByID(mobID):isSpawned() then
                    player:printToPlayer("You sense a hostile presence.", xi.msg.channel.NS_SAY)
                    return
                end

                if npcUtil.tradeHasExactly(trade, tradeList) then
                    local mobName = req.mobName[mobID]

                    if
                        mobName ~= nil and
                        req.requirements[mobName].needs ~= nil
                    then
                        local progress = player:getCharVar("[NEO]PROGRESS")

                        for k, v in pairs(req.requirements[mobName].needs) do
                            if not utils.mask.getBit(progress, v) then
                                player:printToPlayer("The adversary eludes you. It seems you will need to absorb the correct essences to be worthy of their animus.", xi.msg.channel.NS_SAY)
                                return
                            end
                        end
                    end

                    player:tradeComplete()

                    npc:setStatus(xi.status.DISAPPEAR)
                    npc:timer(180000, function() -- 3 minutes
                        npc:setStatus(xi.status.NORMAL)
                    end)

                    local mob = GetMobByID(mobID)

                    mob:spawn()
                    mob:updateClaim(player)
                    mob:updateEnmity(player)

                    return
                end
            end
        end)
    end
end

return m

