----------------------------------------------------------
-- Crystal Restrict Era Automaton Shops
-- Populates Puppetmaster shop tables for Crystal Warriors
----------------------------------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
require("scripts/globals/npc_util")
-----------------------------------
local ID = require("scripts/zones/Nashmau/IDs")
local m  = Module:new("cw_era_pup_shops")

-- Lua for this NPC doesn't currently exist, futureproof it.
xi.module.ensureTable("xi.zones.Nashmau.npcs.Rararoon")

m:addOverride("xi.zones.Nashmau.npcs.Yoyoroon.onTrigger", function(player, npc)
    if player:isCrystalWarrior() then
        local stock =
        {
            2239,  4940,    -- Tension Spring
            2243,  4940,    -- Loudspeaker
            2246,  4940,    -- Accelerator
            2251,  4940,    -- Armor Plate
            2254,  4940,    -- Stabilizer
            2258,  4940,    -- Mana Jammer
            2262,  4940,    -- Auto-Repair Kit
            2266,  4940,    -- Mana Tank
            2240,  9925,    -- Inhibitor
            2242,  9925,    -- Mana Booster
            2247,  9925,    -- Scope
            2250,  9925,    -- Shock Absorber
            2255,  9925,    -- Volt Gun
            2260,  9925,    -- Stealth Screen
            2264,  9925,    -- Damage Gauge
            2268,  9925,    -- Mana Conserver
            2238, 19890,    -- Strobe
        }

        player:showText(npc, ID.text.YOYOROON_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        super(player, npc)
    end
end)

m:addOverride("xi.zones.Nashmau.npcs.Rararoon.onTrigger", function(player, npc)
    if player:isCrystalWarrior() then
        local stock =
        {
            18731,   200,    -- Lv 15 Oil
            18732,   500,    -- Lv 30 Oil
            18733,  1000,    -- Lv 50 Oil
        }

        player:showText(npc, ID.text.YOYOROON_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        super(player, npc)
    end
end)

return m
