-------------------------------------------------------
-- Crystal Restrict Era Magic Shops
-- Populates new magic shop tables for Crystal Warriors
-------------------------------------------------------
require('modules/module_utils')
require('scripts/globals/utils')
require('scripts/globals/npc_util')
-----------------------------------
local m = Module:new('cw_era_magic_shops')

m:addOverride('xi.zones.Windurst_Waters.npcs.Shohrun-Tuhrun.onTrigger', function(player, npc)
    local ID = require('scripts/zones/Windurst_Waters/IDs')

    if player:isCrystalWarrior() then
        local stock =
        {
            4665, 18000, 1, -- Haste
            4620,  5178, 2, -- Scroll of Raise
            4632, 10080, 2, -- Scroll of Dia II
            4637,  8100, 2, -- Scroll of Banish II
            4652,  6366, 2, -- Scroll of Protect II
            4657, 15840, 2, -- Scroll of Shell II
            4708,  4644, 2, -- Scroll of Enfire
            4709,  3688, 2, -- Scroll of Enblizzard
            4710,  2250, 2, -- Scroll of Enaero
            4711,  1827, 2, -- Scroll of Enstone
            4712,  1363, 2, -- Scroll of Enthunder
            4713,  6366, 2, -- Scroll of Enwater
            4611,  3261, 3, -- Scroll of Cure III
            4654, 78200, 3, -- Scroll of Protect IV
            4736, 74520, 3, -- Scroll of Protectra IV
        }

        player:showText(npc, ID.text.SHOHRUNTUHRUN_SHOP_DIALOG)
        xi.shop.nation(player, stock, xi.nation.WINDURST)
    else
        super(player, npc)
    end
end)

m:addOverride('xi.zones.Rabao.npcs.Brave_Ox.onTrigger', function(player, npc)
    local ID = require('scripts/zones/Rabao/IDs')

    if player:isCrystalWarrior() then
        local stock =
        {
            4654,  77350,    -- Protect IV
            4736,  73710,    -- Protectra IV
            4860,  31850,    -- Stun
            4720,  31850,    -- Flash
            4750, 546000,    -- Reraise III
            4638,  78260,    -- Banish III
        }

        player:showText(npc, ID.text.BRAVEOX_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        super(player, npc)
    end
end)

m:addOverride('xi.zones.Selbina.npcs.Quelpia.onTrigger', function(player, npc)
    local ID = require('scripts/zones/Selbina/IDs')

    if player:isCrystalWarrior() then
        local stock =
        {
            4610,   585,    -- Scroll of Cure II
            4611,  3261,    -- Scroll of Cure III
            4616, 10080,    -- Scroll of Curaga II
            4620,  5178,    -- Scroll of Raise
            4629, 31500,    -- Scroll of Holy
            4632, 10080,    -- Scroll of Dia II
            4637,  8100,    -- Scroll of Banish II
            4652,  6366,    -- Scroll of Protect II
            4657, 15840,    -- Scroll of Shell II
            4665, 20800,    -- Scroll of Haste
            4708,  4644,    -- Scroll of Enfire
            4709,  3688,    -- Scroll of Enblizzard
            4710,  2250,    -- Scroll of Enaero
            4711,  1827,    -- Scroll of Enstone
            4712,  1363,    -- Scroll of Enthunder
            4713,  6366,    -- Scroll of Enwater
        }

        player:showText(npc, ID.text.QUELPIA_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        super(player, npc)
    end
end)

m:addOverride('xi.zones.Selbina.npcs.Falgima.onTrigger', function(player, npc)
    local ID = require('scripts/zones/Selbina/IDs')

    if player:isCrystalWarrior() then
        local stock =
        {
            4744,  5351,    -- Scroll of Invisible
            4745,  2325,    -- Scroll of Sneak
            4746,  1204,    -- Scroll of Deodorize
        }

        player:showText(npc, ID.text.FALGIMA_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        super(player, npc)
    end
end)

m:addOverride('xi.zones.Mhaura.npcs.Tya_Padolih.onTrigger', function(player, npc)
    local ID = require('scripts/zones/Mhaura/IDs')

    if player:isCrystalWarrior() then
        local stock =
        {
            4716,  4147,    -- Scroll of Regen
            4718,  7516,    -- Scroll of Regen II
            4881, 10752,    -- Scroll of Sleepga
            4690, 29030,    -- Scroll of Baramnesia
            4691, 29030,    -- Scroll of Baramnesra
            4744,  5523,    -- Scroll of Invisible
            4745,  2400,    -- Scroll of Sneak
            4746,  1243,    -- Scroll of Deodorize
        }

        player:showText(npc, ID.text.TYAPADOLIH_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        super(player, npc)
    end
end)

m:addOverride('xi.zones.Norg.npcs.Solby-Maholby.onTrigger', function(player, npc)
    local ID = require('scripts/zones/Norg/IDs')

    if player:isCrystalWarrior() then
        local stock =
        {
            17395,     9,    -- Lugworm
            4899,    450,    -- Earth Spirit Pact
            2870,   9000,    -- Norg Waystone
        }

        player:showText(npc, ID.text.SOLBYMAHOLBY_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        super(player, npc)
    end
end)

m:addOverride('xi.zones.Al_Zahbi.npcs.Zafif.onTrigger', function(player, npc)
    local ID = require('scripts/zones/Al_Zahbi/IDs')

    if player:isCrystalWarrior() then
        local stock =
        {
            4612, 23400,    -- Scroll of Cure IV
            4616, 11200,    -- Scroll of Curaga II
            4617, 19932,    -- Scroll of Curaga III
            4653, 32000,    -- Scroll of Protect III
            4654, 91116,    -- Scroll of Protect IV
            4736, 85500,    -- Scroll of Protectra IV
            4629, 35000,    -- Scroll of Holy
            4647, 20000,    -- Scroll of Banishga II
            4625,  2330,    -- Scroll of Silena
            4626, 19200,    -- Scroll of Stona
            4627, 13300,    -- Scroll of Viruna
            4628,  8586,    -- Scroll of Cursna
            4720, 27000,    -- Scroll of Flash
            4750, 99375,    -- Scroll of Reraise III
            4715, 28500     -- Scroll of Reprisal
        }

        player:showText(npc, ID.text.ZAFIF_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        super(player, npc)
    end
end)

m:addOverride('xi.zones.Nashmau.npcs.Mamaroon.onTrigger', function(player, npc)
    local ID = require('scripts/zones/Nashmau/IDs')

    if player:isCrystalWarrior() then
        local stock =
        {
            4860,  27000,    -- Scroll of Stun
            4708,   5160,    -- Scroll of Enfire
            4709,   4098,    -- Scroll of Enblizzard
            4710,   2500,    -- Scroll of Enaero
            4711,   2030,    -- Scroll of Entone
            4712,   1515,    -- Scroll of Enthunder
            4713,   7074,    -- Scroll of Enwater
            4859,   9000,    -- Scroll of Shock Spikes
            2502,  29950,    -- White Puppet Turban
            2501,  29950,    -- Black Puppet Turban
        }

        player:showText(npc, ID.text.MAMAROON_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        local stock =
        {
            4860,  27000,    -- Scroll of Stun
            4708,   5160,    -- Scroll of Enfire
            4709,   4098,    -- Scroll of Enblizzard
            4710,   2500,    -- Scroll of Enaero
            4711,   2030,    -- Scroll of Entone
            4712,   1515,    -- Scroll of Enthunder
            4713,   7074,    -- Scroll of Enwater
            4859,   9000,    -- Scroll of Shock Spikes
            2502,  29950,    -- White Puppet Turban
            2501,  29950,    -- Black Puppet Turban
        }
        
        player:showText(npc, ID.text.MAMAROON_SHOP_DIALOG)
        xi.shop.general(player, stock)
    end
end)

m:addOverride('xi.zones.Lower_Jeuno.npcs.Hasim.onTrigger', function(player, npc)
    local ID = require('scripts/zones/Lower_Jeuno/IDs')

    if player:isCrystalWarrior() then
    local stock =
        {
            4612,  23400, -- Scroll of Cure IV
            4616,  11200, -- Scroll of Curaga II
            4617,  19932, -- Scroll of Curaga III
            4653,  32000, -- Scroll of Protect III
            4734,   7074, -- Scroll of Protectra II
            4735,  19200, -- Scroll of Protectra III
            4658,  26244, -- Scroll of Shell III
            4738,   1760, -- Scroll of Shellra
            4739,  14080, -- Scroll of Shellra II
            4740,  26244, -- Scroll of Shellra III
            4668,   1760, -- Scroll of Barfire
            4669,   3624, -- Scroll of Barblizzard
            4670,    930, -- Scroll of Baraero
            4671,    156, -- Scroll of Barstone
            4672,   5754, -- Scroll of Barthunder
            4673,    360, -- Scroll of Barwater
            4674,   1760, -- Scroll of Barfira
            4675,   3624, -- Scroll of Barblizzara
            4676,    930, -- Scroll of Baraera
            4677,    156, -- Scroll of Barstonra
            4678,   5754, -- Scroll of Barthundra
            4679,    360, -- Scroll of Barwatera
            4680,    244, -- Scroll of Barsleep
        }

        player:showText(npc, ID.text.WAAG_DEEG_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        local stock =
        {
            4612,  23400, -- Scroll of Cure IV
            4616,  11200, -- Scroll of Curaga II
            4617,  19932, -- Scroll of Curaga III
            4625,   2330, -- Scroll of Silena
            4626,  19200, -- Scroll of Stona
            4627,  13300, -- Scroll of Viruna
            4628,   8586, -- Scroll of Cursna
            4653,  32000, -- Scroll of Protect III
            4734,   7074, -- Scroll of Protectra II
            4735,  19200, -- Scroll of Protectra III
            4658,  26244, -- Scroll of Shell III
            4738,   1760, -- Scroll of Shellra
            4739,  14080, -- Scroll of Shellra II
            4740,  26244, -- Scroll of Shellra III
            4668,   1760, -- Scroll of Barfire
            4669,   3624, -- Scroll of Barblizzard
            4670,    930, -- Scroll of Baraero
            4671,    156, -- Scroll of Barstone
            4672,   5754, -- Scroll of Barthunder
            4673,    360, -- Scroll of Barwater
            4674,   1760, -- Scroll of Barfira
            4675,   3624, -- Scroll of Barblizzara
            4676,    930, -- Scroll of Baraera
            4677,    156, -- Scroll of Barstonra
            4678,   5754, -- Scroll of Barthundra
            4679,    360, -- Scroll of Barwatera
            4680,    244, -- Scroll of Barsleep
            4681,    400, -- Scroll of Barpoison
            4682,    780, -- Scroll of Barparalyze
            4683,   2030, -- Scroll of Barblind
            4684,   4608, -- Scroll of Barsilence
            4694,    244, -- Scroll of Barsleepra
            4695,    400, -- Scroll of Barpoisonra
            4696,    780, -- Scroll of Barparalyzra
            4697,   2030, -- Scroll of Barblindra
            4698,   4608, -- Scroll of Barsilencera
            4685,  15120, -- Scroll of Barpetrify
            4686,   9600, -- Scroll of Barvirus
            4699,  15120, -- Scroll of Barpetra
            4700,   9600, -- Scroll of Barvira
            4629,  35000, -- Scroll of Holy
            4647,  20000, -- Scroll of Banishga II
            4737, 119240, -- Scroll of Protectra V
            4742, 124540, -- Scroll of Shellra V
            4633, 139135, -- Scroll of Dia III
            6569, 139135, -- Scroll of Slow II
            6570, 139135, -- Scroll of Paralyze II
            6571, 139135, -- Scroll of Phalanx II
        }
    
        player:showText(npc, ID.text.WAAG_DEEG_SHOP_DIALOG)
        xi.shop.general(player, stock)
    end
end)

m:addOverride('xi.zones.Lower_Jeuno.npcs.Susu.onTrigger', function(player, npc)
    local ID = require('scripts/zones/Lower_Jeuno/IDs')

    if player:isCrystalWarrior() then
        local stock =
        {
            4646,  2240,  -- Banishga I
            4647, 20000,  -- Banishga II
            4683,  2030,  -- Barblind
            4697,  2030,  -- Barblindra
            4682,  2034,  -- Barparalyze
            4696,  2034,  -- Barparalyzra
            4681,  2056,  -- Barpoison
            4695,  2056,  -- Barpoisonra
            4684,  3152,  -- Barsilence
            4698,  3152,  -- Barsilencera
            4680,  3225,  -- Barsleep
            4694,  3225,  -- Barsleepra
            4628,  4125,  -- Cursna
            4629, 75146,  -- Holy
            4625,   725,  -- Silena
            4626,  1124,  -- Stona
            4627,  7744,  -- Viruna
        }

        player:showText(npc, ID.text.WAAG_DEEG_SHOP_DIALOG)
        xi.shop.general(player, stock)
    else
        super(player, npc)
    end
end)

m:addOverride("xi.zones.Lower_Jeuno.npcs.Amalasanda.onTrigger", function(player, npc)
    if not player:hasKeyItem(xi.ki.TENSHODO_MEMBERS_CARD) then
        return
    end

    local ID    = require("scripts/zones/Lower_Jeuno/IDs")
    local stock =
    {
        704,    144,    -- Bamboo Stick
        829,  21000,    -- Silk Cloth
        1240,   220,    -- Koma
        657,   7000,    -- Tama-Hagane
        1415, 73530,    -- Urushi
        1161,    40,    -- Uchitake
        1164,    40,    -- Tsurara
        1167,    40,    -- Kawahori-Ogi
        1170,    40,    -- Makibishi
        1173,    40,    -- Hiraishin
        1176,    40,    -- Mizu-Deppo
        1179,   125,    -- Shihei
        1182,   125,    -- Jusatsu
        1185,   125,    -- Kaginawa
        1188,   125,    -- Sairui-Ran
        1191,   125,    -- Kodoku
        1194,   125,    -- Shinobi-Tabi
        1471,   316,    -- Sticky Rice
        1554,   645,    -- Turmeric
        1555,  1585,    -- Coriander
        1590,   800,    -- Holy Basil
        1475,   990,    -- Curry Powder
        5164,  2595,    -- Ground Wasabi
        1652,   200,    -- Rice Vinegar
        5237,   492,    -- Shirataki
        2702,  5000,    -- Buckwheat Flour
    }

    player:showText(npc, ID.text.AMALASANDA_SHOP_DIALOG)
    xi.shop.general(player, stock)
end)

return m
