-----------------------------------
-- Unlock Mog Wardrobe slots as you complete missions
-----------------------------------
require("modules/module_utils")
require("scripts/globals/missions")
require("scripts/globals/utils")
local cw_unlocks  = require("modules/catseyexi/lua/additive_overrides/utils/custom_unlocks")
local wew_unlocks = require("modules/catseyexi/lua/additive_overrides/utils/wew_unlocks")
-----------------------------------
local m = Module:new("wardrobe_unlocks")

local function applyIncrease(player, bag, bagName, bagIncrease)
    local oldSize = player:getContainerSize(bag)
    player:changeContainerSize(bag, bagIncrease)
    local newSize = player:getContainerSize(bag)

    local str = string.format(
        "\129\154 Your %s capacity has been increased by %i from %i to %i! \129\154",
        bagName, bagIncrease, oldSize, newSize)

    if newSize > oldSize then
        player:printToPlayer(str, xi.msg.channel.SYSTEM_3)
    end
end

local function awardIncrease(player, unlock, log, id, unlocks)
    local bag = unlock[1]
    local bagName = unlocks.bagNames[bag]
    local bagIncrease = unlock[2]

    -- Repeatable mission
    if unlock[3] ~= nil then
        local missionVar = string.format("[CW]MISSION_%u_%u", log, id)

        if player:getCharVar(missionVar) == 1 then
            return
        end

        player:setCharVar(missionVar, 1)
    end

    applyIncrease(player, bag, bagName, bagIncrease)
end

local function unlockCW(player, logId, missionId)
    if
        cw_unlocks.wardrobeMissions[logId] ~= nil and
        cw_unlocks.wardrobeMissions[logId][missionId] ~= nil
    then
        awardIncrease(player, cw_unlocks.wardrobeMissions[logId][missionId], logId, missionId, cw_unlocks)
    end
end

local function unlockWEW(player, logId, missionId)
    -- wardrobe unlocks based on specific missions completed
    if
        wew_unlocks.wardrobeMissions[logId] ~= nil and
        wew_unlocks.wardrobeMissions[logId][missionId] ~= nil
    then
        awardIncrease(player, wew_unlocks.wardrobeMissions[logId][missionId], logId, missionId, wew_unlocks)
    end

    -- wardrobe size based on player's rank
    if
        xi.mission.log_id.SANDORIA or
        xi.mission.log_id.BASTOK or
        xi.mission.log_id.WINDURST
    then
        local bag     = xi.inv.WARDROBE
        local bagName = wew_unlocks.bagNames[bag]
        local rank    = player:getRank(player:getNation())
        local oldSize = player:getContainerSize(bag)
        local total   = 0

        for rankNum, rankInfo in ipairs(wew_unlocks.wardrobeRanks) do
            total = total + rankInfo[2]

            if rank == rankNum then
                if oldSize < total then
                    applyIncrease(player, bag, bagName, total - oldSize)
                end

                break
            end
        end
    end

    -- Mog case based on wotg progress
    -- 1 slot per completion offset to adjust for 53 total WOTG missions
    if logId == xi.mission.log_id.WOTG then
        local bag     = xi.inv.MOGCASE
        local bagName = wew_unlocks.bagNames[bag]
        local oldSize = player:getContainerSize(bag)
        local total   = 27 + missionId

        if oldSize < total then
            applyIncrease(player, bag, bagName, total - oldSize)
        end
    end
end

m:addOverride("npcUtil.completeMission", function(player, logId, missionId, params)
    local result = super(player, logId, missionId, params)

    if result then
        if player:isCrystalWarrior() then
            unlockCW(player, logId, missionId)
        elseif player:isClassicMode() then
            unlockWEW(player, logId, missionId)
        end
    end

    return result
end)

m:addOverride("npcUtil.completeQuest", function(player, logId, questId, params)
    local result = super(player, logId, questId, params)

    if
        result and
        player:isCrystalWarrior() and
        cw_unlocks.wardrobeQuests[logId] ~= nil and
        cw_unlocks.wardrobeQuests[logId][questId] ~= nil
    then
        awardIncrease(player, cw_unlocks.wardrobeQuests[logId][questId], logId, questId, cw_unlocks)
    end

    return result
end)

return m
