-------------------------------------------
-- Fixes null error coming from onAttachmentUnequip for Regen/Refresh attachments
-------------------------------------------
require("modules/module_utils")
require("scripts/globals/utils")
require("scripts/globals/automaton")
-------------------------------------------

local m = Module:new("automaton_fix")

local modTable =
{
    xi.mod.ACC,
    xi.mod.ATTP,
    xi.mod.AUTO_ANALYZER,
    xi.mod.AUTO_DECISION_DELAY,
    xi.mod.AUTO_EQUALIZER,
    xi.mod.AUTO_HEALING_DELAY,
    xi.mod.AUTO_HEALING_THRESHOLD,
    xi.mod.AUTO_MAGIC_DELAY,
    xi.mod.AUTO_PERFORMANCE_BOOST,
    xi.mod.AUTO_RANGED_DAMAGEP,
    xi.mod.AUTO_RANGED_DELAY,
    xi.mod.AUTO_SCAN_RESISTS,
    xi.mod.AUTO_SCHURZEN,
    xi.mod.AUTO_SHIELD_BASH_SLOW,
    xi.mod.AUTO_STEAM_JACKET_REDUCTION,
    xi.mod.AUTO_STEAM_JACKET,
    xi.mod.AUTO_TP_EFFICIENCY,
    xi.mod.BURDEN_DECAY,
    xi.mod.COMBAT_SKILLUP_RATE,
    xi.mod.CONSERVE_MP,
    xi.mod.COUNTER,
    xi.mod.CRITHITRATE,
    xi.mod.CURE_POTENCY,
    xi.mod.DMGPHYS,
    xi.mod.DOUBLE_ATTACK,
    xi.mod.DOUBLE_SHOT_RATE,
    xi.mod.ENMITY,
    xi.mod.EVA,
    xi.mod.HASTE_MAGIC,
    xi.mod.HPP,
    xi.mod.MACC,
    xi.mod.MAGIC_DAMAGE,
    xi.mod.MAIN_DMG_RATING,
    xi.mod.MATT,
    xi.mod.MDEF,
    xi.mod.MPP,
    xi.mod.OCCULT_ACUMEN,
    xi.mod.RACC,
    xi.mod.RANGED_DMG_RATING,
    xi.mod.RATTP,
    xi.mod.REFRESH,
    xi.mod.REGEN,
    xi.mod.SHIELDBLOCKRATE,
    xi.mod.SHIELD_MASTERY_TP,
    xi.mod.AUTO_SHIELD_BASH_DELAY,
    xi.mod.SHIELD_BASH,
    xi.mod.SKILLCHAINBONUS,
    xi.mod.STORETP,
    xi.mod.STATUSRES
}

m:addOverride("xi.automaton.onAttachmentUnequip", function(pet, attachment)
    for _, entry in pairs(modTable) do
        pet:delMod(entry, pet:getMod(entry))
    end
end)

return m
