-----------------------------------
-- Spell: Death
-- Consumes all MP. Has a chance to knock out the target. If Death fails to knock out the target, it
-- will instead deal darkness damage. Ineffective against undead.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("spell_death")

m:addOverride("xi.actions.spells.black.death.onMagicCastingCheck", function(mob, target, spell)
    spell:setFlag(xi.magic.spellFlag.IGNORE_SHADOWS)
    return 0
end)

m:addOverride("xi.actions.spells.black.death.onSpellCast", function(caster, target, spell)
    if
        target:isUndead() or
        target:hasStatusEffect(xi.effect.MAGIC_SHIELD) or
        -- Todo: DeathRes has no place in the resistance functions so far..
        math.random(1, 100) <= target:getMod(xi.mod.DEATHRES)
    then
        spell:setMsg(xi.msg.basic.MAGIC_NO_EFFECT)
        return 0
    end

    spell:setMsg(xi.msg.basic.FALL_TO_GROUND)
    target:setHP(0)

    if target:isPC() then
        target:setLocalVar('MijinGakure', 1) -- will ignore res sickness after raise
    end

    return 0
end)

return m
