-----------------------------------
-- Spell: Silent Storm
-- Deals wind damage to enemies within range.
-- Additional effect: Silence
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("silent_storm")
local path = "xi.actions.spells.blue.silent_storm"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local params = {}
    params.ecosystem = xi.ecosystem.ELEMENTAL
    params.attackType = xi.attackType.MAGICAL
    params.damageType = xi.damageType.WIND
    params.attribute = xi.mod.INT
    params.multiplier = 8
    params.azureBonus = 0.5
    params.tMultiplier = 4.0
    params.tp150 = 4.5
    params.tp300 = 5.0
    params.azuretp = 5.5
    params.duppercap = 80
    params.str_wsc = 0.0
    params.dex_wsc = 0.0
    params.vit_wsc = 0.0
    params.agi_wsc = 0.8
    params.int_wsc = 0.0
    params.mnd_wsc = 0.0
    params.chr_wsc = 0.0
    local resistThreshold = 0.25
    local duration = 300

    local damage = xi.spells.blue.useMagicalSpell(caster, target, spell, params)

    params.attribute = xi.mod.INT
    params.skillType = xi.skill.BLUE_MAGIC
    local resist = applyResistanceEffect(caster, target, spell, params)

    if resist >= resistThreshold then
        target:addStatusEffect(xi.effect.SILENCE, 20, 0, duration * resist)
    end

    return damage
end)

return m
