-----------------------------------
-- Spell: Quad. Continuum
-- Delivers a fourfold attack. Damage varies with TP.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("quad_continuum")
local path = "xi.actions.spells.blue.quad_continuum"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local params = {}
    params.ecosystem = xi.ecosystem.EMPTY
    params.tpmod = xi.spells.blue.tpMod.DAMAGE
    params.attackType = xi.attackType.PHYSICAL
    params.damageType = xi.damageType.PIERCING
    params.scattr = xi.skillchainType.DISTORTION
    params.scattr2 = xi.skillchainType.SCISSION
    params.numhits = 4
    params.multiplier = 4.7
    params.tp150 = 5.1
    params.tp300 = 5.5
    params.azuretp = 5.63
    params.duppercap = 80
    params.str_wsc = 0.32
    params.dex_wsc = 0.0
    params.vit_wsc = 0.32
    params.agi_wsc = 0.0
    params.int_wsc = 0.0
    params.mnd_wsc = 0.0
    params.chr_wsc = 0.0

    local damage = xi.spells.blue.usePhysicalSpell(caster, target, spell, params)

    return damage
end)

return m
