-----------------------------------
-- Spell: Pyric Bulwark
-- Description: Resists Physical Damage (15 secs)
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("pyric_bulwark")
local path = "xi.actions.spells.blue.pyric_bulwark"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local duration = xi.spells.blue.calculateDurationWithDiffusion(caster, 15)

    if not target:addStatusEffectEx(xi.effect.PHYSICAL_SHIELD, 0, 1, 0, duration) then
        spell:setMsg(xi.msg.basic.PHYSICAL_SHIELD)
    end

    return xi.effect.PHYSICAL_SHIELD
end)

return m
