-----------------------------------
-- Spell: Osmosis
-- Steals an enemy's HP and one beneficial status effect.
-- Ineffective against undead.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("osmosis")
local path = "xi.actions.spells.blue.osmosis"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local params = {}
    params.ecosystem = xi.ecosystem.VORAGEAN
    params.attribute = xi.mod.INT
    params.attackType = xi.attackType.MAGICAL
    params.damageType = xi.damageType.DARK
    params.diff = 0
    params.skillType = xi.skill.BLUE_MAGIC
    params.dmgMultiplier = 3
    local stolen = 0
    local damage = 0

    damage = xi.spells.blue.useDrainSpell(caster, target, spell, params, 0, false)

    local resist = applyResistanceEffect(caster, target, spell, params)
    if resist >= 0.5 then
        stolen = caster:stealStatusEffect(target)
        if stolen ~= 0 then
            spell:setMsg(xi.msg.basic.MAGIC_STEAL)
            return stolen
        end
    end

    return damage
end)

return m
